 /*
 * file      : split.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "configuser.h"
#include "fileselect.h"
#include "win_info.h"
#include "cursor.h"
#include "dragNdrop.h"
#include "get_info.h"
#include "tags.h"
#include "win_scan.h"
#include "popup.h"
#include "mplayer.h"
#include "alsa_play.h"
#include "prg_init.h"
#include "split.h"




extern gint		 n_drag_types;			/* Drag And Drop	*/
VAR_SPLIT VarSplit;



// 
// PERCENT = ( VALUE_X / LONGUEUR_TOTALE ) * 100.0
// VALUE_X = ( LONGUEUR_TOTALE * PERCENT ) / 100.0
// 
void split_set_time (void)
{
	gint		sec;
	gdouble		dsec;
	gdouble		TimeSongSec;
	gdouble		Percent;
	gint		H, M, S, C;
	gchar		*Str = NULL;
	gint		hundr;

	if (NULL == VarSplit.Tags || VarSplit.NbrSelecteurs <= 0) {
		gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_begin_time_split")), TRUE);
		gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_begin_time_split")),
					// "00<b>:</b>00<b>:</b>00<b>.</b>00");
					"00<b>:</b>00<b>:</b>00");
		
		gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_end_time_split")), TRUE);
		gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_end_time_split")),
					// "00<b>:</b>00<b>:</b>00<b>.</b>00");
					"00<b>:</b>00<b>:</b>00");
		
		gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_time_split")), TRUE);
		gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_time_split")),
					// "00<b>:</b>00<b>:</b>00<b>.</b>00");
					"00<b>:</b>00<b>:</b>00");
		
		gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_nmr_plage_split")), TRUE);
		gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_nmr_plage_split")), "Plage -- / --");
	
		// 
		gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), TRUE);
		gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), "00:00:00");
		return;
	}
	
	// ACQUISITION DUREE TOTALE DU FICHIER EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	// POSITION INDEX DEBUT
	Percent = SplitSelector_get_percent_begin (VarSplit.SelecteurActif);
	sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
	dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
	hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
	H = (sec / 60) / 60;
	M = (sec / 60) % 60;
	S = sec % 60;
	C = hundr;
	// Str = g_strdup_printf ("%02d:%02d:%02d.%02d", H, M, S, C);
	Str = g_strdup_printf ("%02d:%02d:%02d", H, M, S);
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_begin_time_split")), TRUE);
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_begin_time_split")), Str);
	g_free (Str);  Str = NULL;

	// POSITION INDEX FIN
	Percent = SplitSelector_get_percent_end (VarSplit.SelecteurActif);
	sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
	dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
	hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
	H = (sec / 60) / 60;
	M = (sec / 60) % 60;
	S = sec % 60;
	C = hundr;
	// Str = g_strdup_printf ("%02d:%02d:%02d.%02d", H, M, S, C);
	Str = g_strdup_printf ("%02d:%02d:%02d", H, M, S);
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_end_time_split")), TRUE);
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_end_time_split")), Str);
	g_free (Str);  Str = NULL;

	// NUMERO DE PLAGE EN COURS
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_nmr_plage_split")), TRUE);
	Str = g_strdup_printf ("Plage %02d / %02d", VarSplit.SelecteurActif +1, VarSplit.NbrSelecteurs);
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_nmr_plage_split")), Str);
	g_free (Str);  Str = NULL;
	
	// DUREE DE LA PLAGE
	Percent  = SplitSelector_get_percent_end (VarSplit.SelecteurActif) - SplitSelector_get_percent_begin (VarSplit.SelecteurActif);
	sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
	dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
	hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
	H = (sec / 60) / 60;
	M = (sec / 60) % 60;
	S = sec % 60;
	C = hundr;
	// Str = g_strdup_printf ("%02d:%02d:%02d.%02d", H, M, S, C);
	Str = g_strdup_printf ("%02d:%02d:%02d", H, M, S);
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_time_split")), TRUE);
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_time_split")), Str);
	g_free (Str);  Str = NULL;
	
	// TEMPS DU PLAY
	// gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), TRUE);
	// gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), "00:00:00");
	Percent = VarSplit.PercentActivePlay;
	sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
	dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
	hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
	H = (sec / 60) / 60;
	M = (sec / 60) % 60;
	S = sec % 60;
	C = hundr;
	Str = g_strdup_printf ("%02d:%02d:%02d", H, M, S);
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), TRUE);
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_curseur_lecture_split")), Str);
	g_free (Str);  Str = NULL;
}
// 
// 
void split_set_flag_buttons (void)
{
	gboolean	Bool [ 3 ];
	
	Bool [ 0 ] = VarSplit.BoolReadFileSpectre;
	Bool [ 1 ] = VarSplit.NbrSelecteurs > 1 && !VarSplit.BoolPlay ? TRUE : FALSE;
	Bool [ 2 ] = VarSplit.NbrSelecteurs > 0 && !VarSplit.BoolPlay? TRUE : FALSE;

	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_cut_split")),	Bool [ 1 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_begin_split")),	Bool [ 2 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")),		Bool [ 2 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_end_split")),	Bool [ 2 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_gen_cue_split")),	Bool [ 2 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_action_split")),		Bool [ 2 ]);

	gtk_widget_grab_focus (VarSplit.AdrWidgetSpectre);
	
	split_set_time ();
}
// 
// 
void SplitSpectre_adjustment (gint NewWith)
{
	GtkScrolledWindow	*scrolled_window;
	GtkAdjustment		*Adj;
	gdouble			Value;
	gint			Begin;
	gint			End;
	gint			LenScroll;
	
	
	if (VarSplit.NbrSelecteurs == 0) return;
	

	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();
	
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	Value = Adj->value;
	
	LenScroll = SplitSpectre_get_with_scrollwindow () -1;
	Begin     = SplitSelector_get_pos_begin (VarSplit.SelecteurActif)  - (gint)Value;
	End       = SplitSelector_get_pos_end (VarSplit.SelecteurActif)  - (gint)Value;
		
	while (Begin < 100 || Value > 0.) {
		Begin ++;
		End  ++;
		Value --;
	}

	while (Begin > 100 && Value + LenScroll < VarSplit.SpectreW) {
		Begin --;
		End  --;
		Value ++;
	}

	// g_print ("   value                         = %f\n", Value);
		
	if (Value < 0.0) {
		Value = 0.0;
	}
		
	gtk_adjustment_set_value (Adj, Value);
	
	// RAFFRACHISSEMENT DU SYSTEME
	while (gtk_events_pending()) gtk_main_iteration(); 
}
// 
// 
void SplitSpectre_scroll_droite_play (void)
{
	GtkScrolledWindow	*scrolled_window;
	GtkAdjustment		*Adj;
	gdouble			Value;
	gint			Begin;
	gint			LenScroll;
	
	if (VarSplit.NbrSelecteurs == 0) return;
	
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();
	
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	Value = Adj->value;
	
	LenScroll = SplitSpectre_get_with_scrollwindow () -1;
	Begin     = SplitSelector_get_pos_play ()  - (gint)Value;
		
	while (Begin > 100 && Value + LenScroll < VarSplit.SpectreW) {
		Begin --;
		Value ++;
	}

	if (Value < 0.0) {
		Value = 0.0;
	}
		
	gtk_adjustment_set_value (Adj, Value);
	
	// RAFFRACHISSEMENT DU SYSTEME
	while (gtk_events_pending()) gtk_main_iteration(); 
}
// 
// 
void SplitSpectre_scroll_droite (void)
{
	GtkScrolledWindow	*scrolled_window;
	GtkAdjustment		*Adj;
	gdouble			Value;
	
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	Value = Adj->value;
	Value ++;
	Value += 4.0;
	gtk_adjustment_set_value (Adj, Value);
}
// 
// 
void SplitSpectre_scroll_gauche (void)
{
	GtkScrolledWindow	*scrolled_window;
	GtkAdjustment		*Adj;
	gdouble			Value;
	
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	Value = Adj->value;
	Value --;
	Value -= 4.0;
	if (Value < 0.0) Value = 0.0;
	gtk_adjustment_set_value (Adj, Value);
}

// DEMANDE DE REDRAW
// 
void split_redraw_image (void)
{
	if (NULL == VarSplit.AdrWidgetSpectre) return;
	PRINT_FUNC_LF();
	gtk_widget_queue_draw_area (
				VarSplit.AdrWidgetSpectre,
				VarSplit.AdrWidgetSpectre->allocation.x,
				VarSplit.AdrWidgetSpectre->allocation.y,
				VarSplit.AdrWidgetSpectre->allocation.width,
				VarSplit.AdrWidgetSpectre->allocation.height
				);
}
void on_image_splitspectre_chrono_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrWidgetSpectreChrono = widget;
}
// 
// 
gboolean on_eventbox_splitspectre_chrono_expose_event (GtkWidget *drawing, GdkEventExpose *e, gpointer data)
{
	SplitSpectre_draw_chrono ();
	VarSplit.BoolQueueDrawChrono = FALSE;
	return TRUE;
}
// 
// 
gboolean on_eventbox_splitspectre_chrono_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gint			CursorX, CursorY;
	GdkModifierType		state;
		
	// GET EMPLACEMENT CURSOR MOUSE
 	gdk_window_get_pointer (((GdkEventButton*)event)->window, &CursorX, &CursorY, &state);	
	
	// SI LE CURSEUR N EST PAS DANS LA ZONE ALORS SORTIE
	if (CursorX < VarSplit.ChronoX) return FALSE;
	if (CursorX > VarSplit.ChronoX + VarSplit.ChronoW) return FALSE;
	if (CursorY < VarSplit.ChronoY) return FALSE;
	if (CursorY > VarSplit.ChronoY + VarSplit.ChronoH) return FALSE;
	
	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectreChrono);
	return FALSE;
}
// 
// 
gboolean on_scrolledwindow_splitspectre_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if (GDK_EXPOSE == event->type) {
		VarSplit.BoolQueueDrawSpectre = TRUE;
		VarSplit.BoolQueueDrawChrono = TRUE;
	}
	return FALSE;
}
// EVENT splitspectre
// 
gboolean on_eventbox_splitspectre_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gint			CursorX, CursorY;
	GdkModifierType		state;
	gboolean		BoolEventTypeScroll = (GDK_SCROLL == event->type) ? TRUE : FALSE;
	gint			EventTypeScrollDirection = ((GdkEventScroll*)event)->direction;
	gint			NewWidth;
	GtkScrolledWindow	*scrolled_window = NULL;
	GtkAdjustment		*Adj = NULL;
	gboolean		bool_click_droit = (((GdkEventButton*)event)->button == 3);
	gboolean		bool_click_centre = (((GdkEventButton*)event)->button == 2);
	gboolean		bool_click_gauche = (((GdkEventButton*)event)->button == 1);
	
// #define MAX_POINTS 1000
#define MAX_POINTS VarSplit.InitwidthZoom
	
	// PRINT_FUNC_LF();
	// g_print ("event->type == %d\n", event->type);
	
	SplitSpectre_get_pos_widget ();
 	if (VarSplit.NbrSelecteurs > 1 && GDK_BUTTON_PRESS == event->type && TRUE == bool_click_droit && VarSplit.NbrSelecteurs > 0) {
		popup_file_Split ();
		return FALSE;
	}
	
	
	// PERCENT = ( VALUE_X / LONGUEUR_TOTALE ) * 100.0
	// VALUE_X = ( LONGUEUR_TOTALE * PERCENT ) / 100.0
		
 	// GET EMPLACEMENT CURSOR MOUSE
 	gdk_window_get_pointer (((GdkEventButton*)event)->window, &CursorX, &CursorY, &state);	
		
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	
	// SI LE CURSEUR N EST PAS DANS LA ZONE ALORS SORTIE
	// if (CursorX < VarSplit.SpectreX) return FALSE;
	// if (CursorX > VarSplit.SpectreX + VarSplit.SpectreW) return FALSE;
	// if (CursorY < VarSplit.SpectreY) return FALSE;
	// if (CursorY > VarSplit.SpectreY + VarSplit.SpectreH) return FALSE;
	
	if (FALSE == VarSplit.BoolEventButtonPressSpectre) {
		if (VarSplit.NbrSelecteurs > 0) {
			
			if (TRUE == SplitSelector_cursor_in_box_play (CursorX, CursorY)) {
				cursor_set_hand ();
				VarSplit.TypeCursorSpectre = _CURSOR_IS_HAND_;
			}
			else if (TRUE == SplitSelector_cursor_in_line_play (CursorX, CursorY)) {
				cursor_set_hand ();
				VarSplit.TypeCursorSpectre = _CURSOR_IS_HAND_;
			}
			else if (CursorX == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin ||
			    CursorX+1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin ||
			    CursorX-1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin) {
				
				if (CursorY > VarSplit.ImgY) {
					cursor_set_gauche ();
					VarSplit.TypeCursorSpectre = _CURSOR_IS_LEFT_;
				}
			}
			else if (CursorX == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End ||
				 CursorX+1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End ||
				 CursorX-1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End) {
				if (CursorY > VarSplit.ImgY) {
					cursor_set_droit ();
					VarSplit.TypeCursorSpectre = _CURSOR_IS_RIGHT_;
				}
			}
			else {
				cursor_set_old ();
				VarSplit.TypeCursorSpectre = _CURSOR_IS_NONE_;
			}
		}
		else {
			cursor_set_old ();
			VarSplit.TypeCursorSpectre = _CURSOR_IS_NONE_;
		}
	}
	
	// SCROLL
	if (TRUE == BoolEventTypeScroll && VarSplit.NbrSelecteurs > 0 && CursorY < VarSplit.SpectreY) {
		// PLAGE SUIVANTE
		// GDK_SCROLL_UP ++
		if (GDK_SCROLL_UP == EventTypeScrollDirection) {
			// if (VarSplit.NbrSelecteurs -1 == VarSplit.SelecteurActif)
			// 	VarSplit.SelecteurActif = 0;
			// else	VarSplit.SelecteurActif ++;
			if (VarSplit.SelecteurActif  < VarSplit.NbrSelecteurs -1) {
				VarSplit.SelecteurActif ++;
				VarSplit.BoolQueueDrawSpectre = TRUE;
				SplitSpectre_adjustment (VarSplit.SpectreW);
			}
		}
		// PLAGE PRECEDANTE
		// GDK_SCROLL_DOWN --
		else if (GDK_SCROLL_DOWN == EventTypeScrollDirection) {
			//if (VarSplit.SelecteurActif == 0)
			//	VarSplit.SelecteurActif = VarSplit.NbrSelecteurs -1;
			//else	VarSplit.SelecteurActif --;
			if (VarSplit.SelecteurActif > 0) {
				VarSplit.SelecteurActif --;
				VarSplit.BoolQueueDrawSpectre = TRUE;
				SplitSpectre_adjustment (VarSplit.SpectreW);
			}
		}
		split_set_time ();
	}
	
	// DOUBLE CLICK : GENERE UN NOUVEL INDEX
	// else if (TRUE == bool_click_centre && GDK_2BUTTON_PRESS == event->type && VarSplit.NbrSelecteurs > 0) {
	else if (TRUE == bool_click_centre && GDK_BUTTON_PRESS == event->type && VarSplit.NbrSelecteurs > 0) {
		
		// g_print ("event->type = GDK_2BUTTON_PRESS\n\tDOUBLE CLICK : GENERE UN NOUVEL INDEX\n");
		// g_print ("\t@Dzef:\n\tPour ajouter manuellement un marqueur de début, j'ajoute, par défaut, au même endroit celui de sortie de la plage précédente.\n");
		// g_print ("\tEn mode lecture un double clic sur le bandeau des index place un sélecteur à la position de la tête de lecture ? \n");
		// g_print ("\tEn mode pause un double clic sur le bandeau des index place un sélecteur à l'endroit où on a cliqué ? \n");
		// 4 CAS D INSERTION SONT POSSISBLES. VOIR LA FONCTION : void SplitSelector_add (gint p_CursorX);
		// SplitSelector_add (CursorX + (gint)Adj->value);
		
		if (TRUE == VarSplit.BoolPlay) {
			SplitSelector_add (SplitSelector_get_pos_play ());
		}
		else {
			SplitSelector_add (CursorX);
		}
	}
	
	// UN CLICK BOUTON SOURIS : PRESSED
	else if (TRUE == bool_click_gauche && event->type == GDK_BUTTON_PRESS) {
			// if (CursorX == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin ||
			//     CursorX+1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin ||
			//     CursorX-1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin ||
			//     CursorX == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End ||
			//     CursorX+1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End ||
			//     CursorX-1 == VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End) {
		
		if (VarSplit.TypeCursorSpectre == _CURSOR_IS_LEFT_ ||
		    VarSplit.TypeCursorSpectre == _CURSOR_IS_RIGHT_ ||
		    VarSplit.TypeCursorSpectre == _CURSOR_IS_HAND_) {
			    
			if (VarSplit.TypeCursorSpectre == _CURSOR_IS_HAND_) {
				AlsaPlay_Pause ();
			}
			VarSplit.BoolEventButtonPressSpectre = TRUE;
		}
		
		// SIMPLE CLICK
		else {
			// CHANGEMENT DE PLAGE PAR CLICK SUR LE BANDEAU
			if (CursorY < VarSplit.SpectreY) {
				
				gint Pos;
				
				for (Pos = 0; Pos < VarSplit.NbrSelecteurs ; Pos ++) {
					if (CursorX > SplitSelector_get_pos_begin (Pos) && CursorX < SplitSelector_get_pos_end (Pos)) {
						VarSplit.SelecteurActif = Pos;
						VarSplit.BoolQueueDrawSpectre = TRUE;
						SplitSpectre_adjustment (VarSplit.SpectreW);
						split_set_time ();
						break;
					}
				}
			}
			// REPOSITIONNEMENT DU CURSEUR DE LECTURE PAR CLICK SUR LE SPECTRE
			else {
				SplitSelector_set_pos_play (CursorX);
				
				AlsaPlay_fseek (VarSplit.PercentActivePlay);
				
				VarSplit.BoolQueueDrawChrono = TRUE;
				VarSplit.BoolQueueDrawSpectre = TRUE;
			}
		}
	}
	
	// GESTION CLICK BOUTON SOURIS : RELEASE
	else if (event->type == GDK_BUTTON_RELEASE) {
		if (TRUE == VarSplit.BoolEventButtonPressSpectre) {
			VarSplit.BoolEventButtonPressSpectre = FALSE;
			
			if (VarSplit.TypeCursorSpectre == _CURSOR_IS_HAND_) {

				AlsaPlay_fseek (VarSplit.PercentActivePlay);

				VarSplit.BoolQueueDrawChrono = TRUE;
				VarSplit.BoolQueueDrawSpectre = TRUE;
			}
			else if (VarSplit.TypeCursorSpectre == _CURSOR_IS_LEFT_) {
				SplitSelector_set_pos_begin (CursorX);
 				VarSplit.BoolQueueDrawSpectre = TRUE;
			}
			else if (VarSplit.TypeCursorSpectre == _CURSOR_IS_RIGHT_) {
				SplitSelector_set_pos_end (CursorX);
				VarSplit.BoolQueueDrawSpectre = TRUE;
			}		
			cursor_set_old ();
			VarSplit.TypeCursorSpectre = _CURSOR_IS_NONE_;
		}
		split_set_name_file ();
	}
	
	// ENTREE DANS LE WIDGET
	else if (event->type == GDK_ENTER_NOTIFY) {
		VarSplit.BoolQueueDrawSpectre = TRUE;
	}
	
	// SRTIE DU WIDGET
	else if (event->type == GDK_LEAVE_NOTIFY) {
		VarSplit.BoolQueueDrawSpectre = TRUE;
	}
	
	// MANIP ROULETTE MOUSE : ZOOM + | -
	else if (TRUE == BoolEventTypeScroll) {
		if (TRUE == keys.BoolGDK_Control_L || TRUE == keys.BoolGDK_Control_R) {
		
			// g_print("keys.BoolGDK_Control_L = %s\n", keys.BoolGDK_Control_L ? "TRUE" : "FALSE");
			// g_print("keys.BoolGDK_Control_R = %s\n", keys.BoolGDK_Control_R ? "TRUE" : "FALSE");
			
			while (gtk_events_pending()) gtk_main_iteration(); 
			// ZOOM ++
			if (GDK_SCROLL_UP == EventTypeScrollDirection) {
				if (VarSplit.NbrZoom < 200) {
					
					SplitSpectre_get_pos_widget ();
					
					NewWidth = VarSplit.SpectreW + MAX_POINTS;
					// NewWidth = VarSplit.MaxPointsInTab * (VarSplit.NbrZoom +1);
		
					gtk_widget_set_size_request (
							VarSplit.AdrWidgetSpectre,
							NewWidth,
							-1
							);
					
					while (gtk_events_pending()) gtk_main_iteration(); 
					SplitSpectre_get_pos_widget ();
					SplitSpectre_adjustment (NewWidth);
					VarSplit.NbrZoom ++;
					while (gtk_events_pending()) gtk_main_iteration();
					VarSplit.BoolQueueDrawSpectre = TRUE;
					
					// g_print ("NewWidth                              = %d\n", NewWidth);
					// g_print ("VarSplit.NbrZoom(%d) * MAX_POINTS(%d) = %d\n", VarSplit.NbrZoom +1, MAX_POINTS, (VarSplit.NbrZoom +1) * MAX_POINTS);
					// g_print ("VarSplit.TotalAllocation              = %lu\n", VarSplit.TotalAllocation);
					// g_print ("VarSplit.MaxPointsInTab               = %d\n", VarSplit.MaxPointsInTab);
					
				}
			}
			// ZOOM --
			else if (GDK_SCROLL_DOWN == EventTypeScrollDirection) {
				
				if (VarSplit.SpectreW > SplitSpectre_get_with_scrollwindow ()) {
					
					SplitSpectre_get_pos_widget ();
					
					NewWidth = VarSplit.SpectreW - MAX_POINTS;
					if (NewWidth < SplitSpectre_get_with_scrollwindow ()) {
						NewWidth = SplitSpectre_get_with_scrollwindow () -1;
						VarSplit.NbrZoom = 0;
					}
					VarSplit.NbrZoom --;
					if (VarSplit.NbrZoom < 0) VarSplit.NbrZoom = 0;
					
					gtk_widget_set_size_request (
							VarSplit.AdrWidgetSpectre,
							NewWidth,
							-1
							);
					
					while (gtk_events_pending()) gtk_main_iteration(); 
					SplitSpectre_get_pos_widget ();
					SplitSpectre_adjustment (NewWidth);
					while (gtk_events_pending()) gtk_main_iteration(); 
					VarSplit.BoolQueueDrawSpectre = TRUE;
				}
			}
			split_set_time ();	
			
			// while (gdk_event_get () != NULL);
		}
		else {
			gint	begin, end;
		
			begin = (gint)Adj->value;
			end   = SplitSpectre_get_with_scrollwindow () + begin;
			
			if (GDK_SCROLL_UP == EventTypeScrollDirection) {
				if (end <= VarSplit.SpectreW) {
					// g_print ("end   = %d / %d\n", end, VarSplit.SpectreW);
					SplitSpectre_scroll_droite ();
				}
			}
			else if (GDK_SCROLL_DOWN == EventTypeScrollDirection) {
				if (begin > 0) {
					// g_print ("value = %d\n", begin);
					SplitSpectre_scroll_gauche ();
				}
			}
			split_set_time ();
		}
		/*else if (GDK_SCROLL_LEFT == EventTypeScrollDirection) {
			g_print("GDK_SCROLL_LEFT = %d\n", EventTypeScrollDirection);
		}
		else if (GDK_SCROLL_RIGHT == EventTypeScrollDirection) {
			g_print("GDK_SCROLL_RIGHT = %d\n", EventTypeScrollDirection);
		}*/
		VarSplit.BoolQueueDrawSpectre = TRUE;
		
	}
	
	// MOVE CURSEUR
	if (TRUE == VarSplit.BoolEventButtonPressSpectre && TRUE == bool_click_gauche) {
		
		gint	end = SplitSpectre_get_with_scrollwindow () + (gint)Adj->value;
		
		if (VarSplit.TypeCursorSpectre == _CURSOR_IS_HAND_) {
			SplitSelector_set_pos_play (CursorX);
			VarSplit.BoolQueueDrawChrono = TRUE;
			VarSplit.BoolQueueDrawSpectre = TRUE;
		}
		else if (VarSplit.TypeCursorSpectre == _CURSOR_IS_LEFT_) {
			SplitSelector_set_pos_begin (CursorX);
			VarSplit.BoolQueueDrawChrono = TRUE;
			VarSplit.BoolQueueDrawSpectre = TRUE;
		}
		else if (VarSplit.TypeCursorSpectre == _CURSOR_IS_RIGHT_) {
			SplitSelector_set_pos_end (CursorX);
			VarSplit.BoolQueueDrawChrono = TRUE;
			VarSplit.BoolQueueDrawSpectre = TRUE;
		}
		
		// g_print ("CursorX           = %d\n", CursorX);
		// g_print ("(gint)Adj->value  = %d\n", (gint)Adj->value);
		// g_print ("End               = %d\n", end);
		// g_print ("VarSplit.SpectreW = %d\n", VarSplit.SpectreW);
		// g_print ("\n");
		
		if ((gint)Adj->value >= 0 && CursorX >= end && CursorX < VarSplit.SpectreW) {
			// PRINT("SCROLL_VERS_DROITE");
			SplitSpectre_scroll_droite ();
		}
		else if ((gint)Adj->value > 0 && CursorX < (gint)Adj->value) {
			// PRINT("SCROLL_VERS_GAUCHE");
			SplitSpectre_scroll_gauche ();
		}
		
		split_set_time ();
	}
	// 
 	else if (CursorX >= VarSplit.ImgX && CursorX <= VarSplit.ImgX + VarSplit.ImgW && CursorY >= VarSplit.ImgY && CursorY <= VarSplit.ImgY + VarSplit.ImgH) {
		VarSplit.BoolQueueDrawChrono = TRUE;
 	}
	if (TRUE == VarSplit.BoolQueueDrawChrono) {
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectreChrono);
	}
	if (TRUE == VarSplit.BoolQueueDrawSpectre) {
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
	}
	split_set_flag_buttons ();

	return FALSE;
}
// EVENT-AFTER
// 
void on_eventbox_splitspectre_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
}
// 
// 
static void split_drag_data_received_file (GtkWidget	   *widget,
					GdkDragContext     *drag_context,
					gint                x,
					gint                y,
					GtkSelectionData   *data,
					guint               info,
					guint               time)
{
	if (gtk_drag_get_source_widget(drag_context) != widget) {
		PRINT_FUNC_LF();
		dragndrop_list_drag_data (widget, (gchar *)data->data);
	}
}
// INIT WIDGET IMAGE
// 
void on_image_split_spectre_realize (GtkWidget *widget, gpointer user_data)
{
	// gint	Cpt;
	// gint	Begin, End;
	
	// INIT COORDONNEES WIDGET
	VarSplit.AdrWidgetSpectre = widget;
	
	// 
	gtk_widget_grab_focus (VarSplit.AdrWidgetSpectre);
	
	/* Drag and drop support
	*  SIGNAL : 'drag-data-received'
	*/
	gtk_drag_dest_set (GTK_WIDGET (widget),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY| GDK_ACTION_MOVE );
	g_signal_connect(G_OBJECT(widget),
			 "drag-data-received",
			 G_CALLBACK(split_drag_data_received_file),
			 NULL);

	gtk_drag_source_set(
			GTK_WIDGET(widget),
			GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			drag_types, n_drag_types,
			GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_DEFAULT
			);

	VarSplit.BoolEventButtonPressSpectre = FALSE;
	VarSplit.NbrZoom = 0;
	VarSplit.InitwidthZoom = 0;
	VarSplit.BoolReadFileSpectre = FALSE;
	VarSplit.PathNameFile = NULL;
	VarSplit.NbrSelecteurs = 0;
	VarSplit.TypeCursorSpectre = _CURSOR_IS_NONE_;
	VarSplit.BoolPlay = FALSE;
	VarSplit.PercentActivePlay = 0.0;
	VarSplit.BoolQueueDrawSpectre = FALSE;
	VarSplit.BoolQueueDrawChrono = FALSE;
	VarSplit.BoolBlankWithCue = FALSE;
	
	gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")));
	gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_split")));
	
	SplitSpectre_get_pos_widget ();
	
	split_set_flag_buttons ();
	split_set_time ();
}
// REDRAW SPECTRE
// 
gboolean on_eventbox_splitspectre_expose_event (GtkWidget *drawing, GdkEventExpose *e, gpointer data)
{
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();
	SplitSpectre_draw_lines ();
	VarSplit.BoolQueueDrawSpectre = FALSE;
	return TRUE;
}
// 
// 
void split_set_name_file (void)
{
	gchar	*Ptr = NULL;
	
	if (NULL != VarSplit.PathNameFileReal && NULL != (Ptr = strrchr (VarSplit.PathNameFileReal, '/'))) {
		gchar	*Str = NULL;
		
		Ptr ++;		
		if (NULL != VarSplit.Tags) {
			Str = g_strdup_printf ("%s     %s     %s Hertz  %s voies  %s bits ",
						Ptr, VarSplit.Tags->time, VarSplit.Tags->hertz, VarSplit.Tags->voie, VarSplit.Tags->bits);
		}
		else {
			Str = g_strdup_printf ("<b>%s</b>", Ptr);

		}
		// gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_filename_split")), TRUE);
		// gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_filename_split")), Str);
		main_puts_statusbar_global (Str);
		g_free (Str);
		Str = NULL;
	}
	else {
		main_puts_statusbar_global (_("<i>Pret pour l'import d'un fichier CUE, WAV, FLAC, OGG, MP3, APE</i>"));
	}
}
//
// 
static void VarSplit_thread (void *arg)
{
	VarSplit.BoolInThread = TRUE;
	
	SplitSpectre_read_file_spectre (VarSplit.PathNameFile);
	
	VarSplit.BoolInThread = FALSE;
	PRINT("FIN THREAD SPLIT");
	pthread_exit(0);
}
// 
// 
static gint VarSplit_timeout (gpointer data)
{
	/*if (TRUE == VarSplit.BoolInThread) {
		// WindScan_set_pulse ();
	} 
	else */
	if (FALSE == VarSplit.BoolInThread) {
		gint	IndicePoints = 0;
				
		gtk_timeout_remove (VarSplit.HandlerTimeoutDo);
		
		VarSplit.Tags = tagswav_remove_info (VarSplit.Tags);
		VarSplit.Tags = (INFO_WAV *)tagswav_get_info (VarSplit.PathNameFile);
		
		// 
		split_set_name_file ();

		// g_print("\n");
		// g_print("%s\n", VarSplit.PathNameFile);
		g_print("\ttime     : Temps d'ecoute             = %s\n", VarSplit.Tags->time);
		g_print("\tSecTime  : Temps d'ecoute en secondes = %d\n", VarSplit.Tags->SecTime);
		g_print("\thertz    : Taux d'échantillonnage     = %s\n", VarSplit.Tags->hertz);
		g_print("\tvoie     : 1, 2, 4, 6                 = %s\n", VarSplit.Tags->voie);
		g_print("\tbits     : 8, 16, 24, 32 ou 64        = %s\n", VarSplit.Tags->bits);
		g_print("\n");
		
		/*for (IndicePoints = 0; IndicePoints < MAX_SELECTEURS_SPLIT; IndicePoints ++) {
			if (VarSplit.Points50DB [ IndicePoints ] . PointBegin > -1 && VarSplit.Points50DB [ IndicePoints ] . PointEnd > -1) {
				VarSplit.Selecteur [ IndicePoints ] . Nmr          = IndicePoints;
				VarSplit.Selecteur [ IndicePoints ] . Begin        = VarSplit.Points50DB [ IndicePoints ] . Begin;
				VarSplit.Selecteur [ IndicePoints ] . End          = VarSplit.Points50DB [ IndicePoints ] . End;
				VarSplit.Selecteur [ IndicePoints ] . PercentBegin = ((gdouble)VarSplit.Selecteur [ IndicePoints ] . Begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				VarSplit.Selecteur [ IndicePoints ] . PercentEnd   = ((gdouble)VarSplit.Selecteur [ IndicePoints ] . End / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				SplitSelector_get_pos ();
				
				VarSplit.NbrSelecteurs ++;
			}
		}*/
		for (IndicePoints = 0; IndicePoints < MAX_SELECTEURS_SPLIT; IndicePoints ++) {
			if (-1 != VarSplit.Selecteur [ IndicePoints ] . Nmr) {
				VarSplit.NbrSelecteurs ++;
			}
		}
		
		SplitSelector_get_pos ();
		
		split_set_flag_buttons ();
		split_set_time ();
		VarSplit.PercentActivePlay = 0.0;
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		WindScan_close ();
		PRINT("FIN TIMEOUT SPLIT");
	}
	return (TRUE);
}
// 
// IMPORT D'UN FICHIER
// 
void split_file_load (gchar *p_PathNameFile)
{
	gchar		*PathNameFile = NULL;
	TYPE_FILE_IS	TypeFileIs = GetInfo_file_is (p_PathNameFile);

	if (0 == strcmp (p_PathNameFile, SPLIT_FILE_TMP_WAV)) {
		wininfo_create (
			_("Ce fichier appartient a XCFA"),
			_("Selectionnez un autre fichier."),
			  "");
		return;
	}
	
	if (libutils_get_size_file (p_PathNameFile) <= 0) {
		wininfo_create (
			_("Fichier vide"),
			_("Le fichier ne contient aucune donnee !!!"),
			  "");
		return;
	}
	
	// INIT STRUCTURES: Selecteur
	SplitSelector_init ();
	
	if (TRUE == FileIs_g_str_has_suffix (p_PathNameFile, ".CUE")) {
		
		PRINT("FILE IS CUE  ;-)");
		
		if (NULL == (PathNameFile = SplitCue_read_cue_file (p_PathNameFile))) {
			g_print ("\tBAD FORMAT OF CUE FILE :/\n");
			return;
		}
		if (0 == strcmp (PathNameFile, SPLIT_FILE_TMP_WAV)) {
			wininfo_create (
				_("Ce fichier appartient a XCFA"),
				_("Selectionnez un autre fichier."),
				  "");
			g_free (PathNameFile);
			PathNameFile = NULL;
			return;
		}
		
		VarSplit.BoolBlankWithCue = TRUE;
	}
	else {
		PathNameFile = g_strdup (p_PathNameFile);
	}
	
	if (FILE_IS_WAV == TypeFileIs || FILE_IS_FLAC == TypeFileIs || FILE_IS_MP3 == TypeFileIs || FILE_IS_OGG == TypeFileIs || FILE_IS_APE == TypeFileIs) {
		
		if (FALSE == PrgInit.bool_sox || FALSE == PrgInit.bool_mplayer) {
		
			wininfo_create (
				_("Sox et Mplayer absents"),
				_("Sox et Mplayer sont absents de votre"),
			  	"\n",
				_("configuration."),
			  	"\n\n",
				_("Veuillez les installer pour pouvoir continuer."),

				"");
			return;
		}
	}
	
	if (NULL != VarSplit.PathNameFileReal) {
		g_free (VarSplit.PathNameFileReal);
		VarSplit.PathNameFileReal = NULL;
	}
	VarSplit.PathNameFileReal = g_strdup (p_PathNameFile);
	
	SplitConv_to (PathNameFile);
}
void split_file_load_continue (gchar *p_PathNameFile)
{
	pthread_t	nmr_tid;
	gint		NewWidth;
	gchar		*PathNameFile = p_PathNameFile;
	TYPE_FILE_IS	TypeFileIs = libutils_test_file_exist (p_PathNameFile);
	
	if (TRUE == libutils_test_file_exist (PathNameFile) &&
	    (FILE_IS_WAV == TypeFileIs || FILE_IS_FLAC == TypeFileIs || FILE_IS_MP3 == TypeFileIs || FILE_IS_OGG == TypeFileIs || FILE_IS_APE == TypeFileIs)) {
		
		AlsaPlay_stop ();
		
		// REAJUSTEMENT DU ZOOM A 100%
		if (VarSplit.SpectreW != SplitSpectre_get_with_scrollwindow () -1) {
			SplitSpectre_get_pos_widget ();
			NewWidth = SplitSpectre_get_with_scrollwindow () -1;
			VarSplit.NbrZoom = 0;
			gtk_widget_set_size_request (
					VarSplit.AdrWidgetSpectre,
					NewWidth,
					-1
					);
			SplitSpectre_get_pos_widget ();
			SplitSpectre_adjustment (NewWidth);
			gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		}
		WindScan_set_pulse ();
		// WindScan_open ("Analyse du fichier", WINDSCAN_PULSE);
		WindScan_set_label ("<b><i>Analyse du fichier ...</i></b>");
		// g_usleep (1);
		while (gtk_events_pending()) gtk_main_iteration(); 
		
		if (NULL != VarSplit.PathNameFile) {
			g_free (VarSplit.PathNameFile);
			VarSplit.PathNameFile = NULL;
		}
		VarSplit.PathNameFile = g_strdup (PathNameFile);

		VarSplit.BoolInThread = TRUE;
		PRINT("DEBUT TIMEOUT SPLIT");
		PRINT("DEBUT THREAD SPLIT");
		VarSplit.HandlerTimeoutDo = gtk_timeout_add (5, VarSplit_timeout, 0);
		pthread_create (&nmr_tid, NULL ,(void *)VarSplit_thread, (void *)NULL);
	}
	else {
		wininfo_create (
			_("Erreur de choix de fichier"),
			_("Veuillez selectionner un fichier de type WAV FLAC MP3 OGG APE"),
			  "");
	}
	split_set_flag_buttons ();
}

	
// IMPORT D'UN FICHIER
// 
void split_maj_file_load (gchar *path)
{
	gchar		*Ptr = NULL;
	TYPE_FILE_IS	TypeFileIs = FILE_IS_NONE;
	gboolean	BoolTypeFileIsOk = FALSE;
	
	g_free (Config.PathLoadSplit);
	Config.PathLoadSplit = NULL;
	Config.PathLoadSplit = g_strdup (path);
	if (NULL != (Ptr = strrchr (Config.PathLoadSplit, '/'))) {
		*Ptr = '\0';
	}

	TypeFileIs = GetInfo_file_is (path);
	if (FILE_IS_WAV == TypeFileIs ||
	    FILE_IS_FLAC == TypeFileIs ||
	    FILE_IS_MP3 == TypeFileIs ||
	    FILE_IS_OGG == TypeFileIs ||
	    FILE_IS_APE == TypeFileIs ||
	    TRUE == FileIs_g_str_has_suffix (path, ".CUE")) {
		split_file_load (path);
		BoolTypeFileIsOk = TRUE;
	}
	
	if (FALSE == BoolTypeFileIsOk) {
		wininfo_create (
			_("Mauvais type de fichier"),
			_("Les types de fichiers acceptes\nsont: WAV FLAC MP3 OGG APE CUE"),
			  "");
	}
}
// 
// 
void on_button_importer_split_clicked (GtkButton *button, gpointer user_data)
{
	// g_print ("IMPORTATION : keys.BoolGDK_space = %s\n", keys.BoolGDK_space ? "TRUE" : "FALSE");
	if (FALSE == keys.BoolGDK_space)
		fileselect_create (_PATH_LOAD_SPLIT_FILE_, Config.PathLoadSplit, split_maj_file_load);
}
// INIT WIDGET DE LA DESTINAION DES DECOUPES
// 
void on_button_destination_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.Adr_button_destination = GTK_BUTTON (widget);
	gtk_button_set_use_underline (GTK_BUTTON (VarSplit.Adr_button_destination), FALSE);
	gtk_button_set_label (GTK_BUTTON (VarSplit.Adr_button_destination), Config.PathDestinationSplit);
}
// CHOIX D'UNE DESTINATION POUR LES DECOUPES
// 
void split_maj_destination (gchar *path)
{
	if (libutils_test_write (path) == TRUE) {
		g_free (Config.PathDestinationSplit);
		Config.PathDestinationSplit = NULL;
		Config.PathDestinationSplit = g_strdup (path);
		gtk_button_set_label (GTK_BUTTON (VarSplit.Adr_button_destination), Config.PathDestinationSplit);
	}

}
// 
// 
void on_button_destination_split_clicked (GtkButton *button, gpointer user_data)
{
	// g_print ("DESTINATION : keys.BoolGDK_space = %s\n", keys.BoolGDK_space ? "TRUE" : "FALSE");
	if (FALSE == keys.BoolGDK_space) {
		fileselect_create (_PATH_CHOICE_DESTINATION_, Config.PathDestinationSplit, split_maj_destination);
		split_set_flag_buttons ();
	}
}
// LOAD DEPUIS UN DRAG AND DROP
// 
void split_load_from_dnd (GSList *p_list)
{
	GSList		*gs_List = p_list;
	gchar		*Ptr = NULL;
	TYPE_FILE_IS	TypeFileIs = FILE_IS_NONE;
	gboolean	BoolTypeFileIsOk = FALSE;
	
	// PRINT_FUNC_LF();
	
	while (NULL != gs_List) {
		if (NULL != (Ptr = (gchar *)gs_List->data)) {
			g_print("\t%s\n", Ptr);
			TypeFileIs = GetInfo_file_is (Ptr);
			if (FILE_IS_WAV == TypeFileIs ||
			    FILE_IS_FLAC == TypeFileIs ||
			    FILE_IS_MP3 == TypeFileIs ||
			    FILE_IS_OGG == TypeFileIs ||
			    FILE_IS_APE == TypeFileIs ||
			    TRUE == FileIs_g_str_has_suffix (Ptr, ".CUE")) {
				split_file_load (Ptr);
				BoolTypeFileIsOk = TRUE;
				break;
			}
		}
		gs_List = g_slist_next (gs_List);
	}
	
	if (FALSE == BoolTypeFileIsOk) {
		wininfo_create (
			_("Mauvais type de fichier"),
			_("Les types de fichiers acceptes\nsont: WAV FLAC MP3 OGG APE CUE"),
			  "");
	}
	
	split_set_flag_buttons ();
	split_set_time ();
}
// 
// 
void split_set_value (gdouble p_value)
{
	GtkScrolledWindow	*scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	GtkAdjustment		*Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));

	VarSplit.PercentActivePlay = p_value;
	if (VarSplit.PercentActivePlay >= 100.0) VarSplit.PercentActivePlay = 99.99;

	if (SplitSelector_get_pos_play () > SplitSpectre_get_with_scrollwindow () + (gint)Adj->value && (gint)Adj->value < VarSplit.SpectreW) {
		SplitSpectre_scroll_droite_play ();
	}
	
	split_set_time ();
	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectreChrono);
	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
}
// 
// 
void split_end_play (void)
{
	// PRINT_FUNC_LF();
	
	split_set_stop ();
	
	gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")));
	gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_split")));
	// gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame_choice_reader")),		TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_begin_split")),	TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")),		TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_end_split")),	TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_cut_split")),	TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_gen_cue_split")), 	TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_action_split")), 	TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_importer_split")), 	TRUE);
}
// 
// 
void split_set_stop (void)
{
	VarSplit.BoolPlay = FALSE;
}
// 
// 
gboolean split_is_stop (void)
{
	return (VarSplit.BoolPlay ? FALSE : TRUE);
}
// DEBUT DE LECTURE
// 
void on_button_play_split_clicked (GtkButton *button, gpointer user_data)
{
	// PRINT_FUNC_LF();
	
	VarSplit.BoolPlay = TRUE;
	
	gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_split")));
	gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")));
	// gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame_choice_reader")),		FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_begin_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_end_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_cut_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_importer_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_gen_cue_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_action_split")), 	FALSE);
	
	AlsaPlay_song (
		VarSplit.PathNameFile,
		VarSplit.PercentActivePlay,
		100.0,
		split_set_value,
		split_end_play
		);
}
// FIN DE LECTURE
// 
void on_button_pause_split_clicked (GtkButton *button, gpointer user_data)
{
	// PRINT_FUNC_LF();
	
	VarSplit.BoolPlay = FALSE;
	
	AlsaPlay_stop ();
	gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")));
	gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_split")));
}
// FROM BARRE ESPACE
// 
void split_play (void)
{
	if (VarSplit.NbrSelecteurs > 0) {
		if (FALSE == VarSplit.BoolPlay) {
			on_button_play_split_clicked (NULL, NULL);
		}
		else {
			on_button_pause_split_clicked (NULL, NULL);
		}
	}
}

#define TIME_READ_BEGIN_END_5S_SPLIT 6

// LECTURE 5 SECONDES DEBUT
// 
void on_button_play_begin_split_clicked (GtkButton *button, gpointer user_data)
{
	gdouble		Percent;
	
	// PRINT_FUNC_LF();
	
	gdouble	PercentBegin = SplitSelector_get_percent_begin (VarSplit.SelecteurActif);
	gdouble	PercentEnd   = SplitSelector_get_percent_begin (VarSplit.SelecteurActif) + SplitSelector_get_percent_for_x_secondes (5);
	
	Percent = SplitSelector_get_percent_begin (VarSplit.SelecteurActif);
	AlsaPlay_song (
		VarSplit.PathNameFile,
		PercentBegin,
		PercentEnd,
		split_set_value,
		split_end_play
		);
	
	// gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame_choice_reader")),		FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_begin_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")),		FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_end_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_cut_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_gen_cue_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_action_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_importer_split")), 	FALSE);
}
// LECTURE 5 SECONDES FIN
// 
void on_button_play_end_split_clicked (GtkButton *button, gpointer user_data)
{
	gdouble		Percent;
	
	// PRINT_FUNC_LF();
	
	gdouble	PercentBegin = SplitSelector_get_percent_end (VarSplit.SelecteurActif) - SplitSelector_get_percent_for_x_secondes (5);
	gdouble	PercentEnd   = SplitSelector_get_percent_end (VarSplit.SelecteurActif);
	
	Percent = SplitSelector_get_percent_begin (VarSplit.SelecteurActif);
	AlsaPlay_song (
		VarSplit.PathNameFile,
		PercentBegin,
		PercentEnd,
		split_set_value,
		split_end_play
		);
	
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_begin_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_split")),		FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_play_end_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_cut_split")),	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_gen_cue_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_action_split")), 	FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_importer_split")), 	FALSE);
}
// 
// 
void split_from_popup (gint p_choice)
{
	// PRINT_FUNC_LF();
	
	switch (p_choice) {
	// Selecteur suivant
	case 0 :
		if (VarSplit.NbrSelecteurs -1 == VarSplit.SelecteurActif)
			VarSplit.SelecteurActif = 0;
		else	VarSplit.SelecteurActif ++;
		SplitSpectre_adjustment (VarSplit.SpectreW);
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		break;
	// Selecteur precedant
	case 1 :
		if (VarSplit.SelecteurActif == 0)
			VarSplit.SelecteurActif = VarSplit.NbrSelecteurs -1;
		else	VarSplit.SelecteurActif --;
		SplitSpectre_adjustment (VarSplit.SpectreW);
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		break;
	// Supprimer le selecteur actif
	case 2 :
		SplitSelector_cut ();
		break;
	}
}









