 /*
 * file      : poche_dir.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <pthread.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "configuser.h"
#include "win_scan.h"
#include "get_info.h"
#include "poche.h"




extern int lstat(const char *file_name, struct stat *buf);


typedef struct {
	
	GList			*ListReceive;		// COPIE DU GSLIST POUR RECHERCHE DES FICHIERS IMAGES UNIQUEMENT QUI SERONT INSCRIT DANS:
	GList			*ListFiles;		// LE NOM DU FICHIER
	
	// RECHERCHE RECURSIVE DES FICHIERS
	// INDIQUE LE NOMBRE TOTAL DANS: VarAnalyze.RecTotalFile
	// 
	gchar			*RecPtrDir;		// POUR WINDSCAN
	gchar			*RecName;		// 
	gint			RecTotalFile;		// 
	gint			RecActivate;		// 
	double			percent;		// 
	
	gboolean		BoolInThread;
	gboolean		BoolSetPercent;
	guint			HandlerTimeout;
	
	gboolean  CancelClicked;
	gboolean  EndThread;
	gboolean  EndTimeout;
	gboolean  Action;
	gchar    *name;
	guint     timeout;
	pthread_t nmr_tid;
	
} VAR_POCHEDIR;

VAR_POCHEDIR	VarPocheDir;



// 
// 
void pochedir_make_glist (gchar *filename)
{
	GLIST_POCHETTE	*new = NULL;
	guint		num = 0;
	
	/* Allocation memoire */
	if ((new = (GLIST_POCHETTE *)g_malloc0 (sizeof (GLIST_POCHETTE))) == NULL) {
		PRINT_FUNC_LF();
		g_print ("\tERREUR D'ALLOCATION\n");
		return;
	}

	new->name_img = g_strdup (filename);
	/* Numero de l'image.png */
	num = 1;
	/* Trouver un nom de fichier libre */
	while (TRUE) {
		new->name_png = g_strdup_printf ("%s/%03d.png", poche.Path_pochette_png, num);
		if (FALSE == libutils_test_file_exist (new->name_png)) break;
		num ++;
		g_free (new->name_png);
		new->name_png = NULL;
	}

	/* Construction du fichier PNG */
	pocheexec_convert_to_png (filename, new->name_png, "80x80");

	if (poche.glist == NULL) {
		/*
		poche.num_recto_actif = -1;
		poche.num_verso_actif = -1;
		*/
	}

	/* Stocke */
	poche.glist = g_list_append (poche.glist, new);
}
// 
// 
void pochedir_set_in_list (void)
{
	GList		*list = NULL;
	gchar		*PtrName = NULL;
	
	list = g_list_first (VarPocheDir.ListFiles);
	while (list) {
		if (NULL != (PtrName = (gchar *)list->data)) {
			pochedir_make_glist (PtrName);
			VarPocheDir.RecActivate ++;
			VarPocheDir.BoolSetPercent = TRUE;
		}
		list = g_list_next (list);
	}
}
// 
// 
gboolean pochedir_is_dupply (gchar *filename)
{
	GList		*list = NULL;
	GLIST_POCHETTE	*gl = NULL;
	
	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {
			if (strcmp (gl->name_img, filename) == 0) {
				return (TRUE);
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
// VERIFIE LA VALIDITE DU FICHIER
// 
void pochedir_verif_validity_files (void)
{
	GList		*List = NULL;
	gchar		*Ptr = NULL;	
	
	List = g_list_first (VarPocheDir.ListFiles);
	while (List) {
		
		if (WindScan_close_request () == TRUE) break;
		
		if (NULL != (Ptr = (gchar *)List->data)) {
			if (TRUE == pochedir_is_dupply (Ptr)) {
				g_free (Ptr);
				Ptr = List->data = NULL;
				List = g_list_next (List);
				continue;
			}
			
			if (FILE_IS_IMG != GetInfo_file_is (Ptr)) {
				g_free (Ptr);
				Ptr = List->data = NULL;
				List = g_list_next (List);
				continue;
			}
			VarPocheDir.RecTotalFile ++;
		}
		List = g_list_next (List);
	}
	VarPocheDir.BoolSetPercent = TRUE;
}
// RECHERCHE RECURSIVE DES FICHIERS
// INDIQUE LE NOMBRE TOTAL DANS: VarPocheDir.RecTotalFile
void pochedir_recherche_recursive_ (gchar *Directory)
{
	DIR    *dp;
	struct  dirent *entry;
	struct  stat statbuf;
	gint	Dummy;
	
	if (NULL == (dp = opendir (Directory))) {
		if (TRUE == libutils_test_file_exist (Directory) && libutils_get_size_file (Directory) > 100) {

			VarPocheDir.ListFiles = g_list_append (VarPocheDir.ListFiles, g_strdup (Directory));
			VarPocheDir.RecTotalFile ++;
		}
		return;
	}
		
	Dummy = chdir (Directory);
	while ((entry = readdir (dp)) != NULL) {
		
		if (WindScan_close_request () == TRUE) break;

		lstat (entry->d_name, &statbuf);
		
		if (S_ISDIR (statbuf.st_mode)) {
			if (strcmp (".", entry->d_name) == 0 || strcmp ("..", entry->d_name) == 0) continue;
			pochedir_recherche_recursive_ (entry->d_name);
		}
		else {
			// VarPocheDir.RecPtrDir = g_get_current_dir ();
			// VarPocheDir.RecPtrDir = get_current_dir_name();
			
			// Comme  une  extension  du  standard POSIX.1-2001, la version  Linux (libc4, libc5, glibc) de getcwd() alloue le
			// tampon dynamiquement avec malloc(3), si buf est NULL. Dans ce cas, le tampon alloué a la longueur size à moins
			// que size soit égal à zéro, auquel cas buf est alloué avec la taille nécessaire.
			// L'appelant doit libérer avec free(3) le tampon renvoyé.
			if ((VarPocheDir.RecPtrDir = getcwd(VarPocheDir.RecPtrDir, 0)) != NULL) {
							
				VarPocheDir.RecName = g_strdup_printf ("%s/%s", VarPocheDir.RecPtrDir, entry->d_name);
				free (VarPocheDir.RecPtrDir);
				VarPocheDir.RecPtrDir = NULL;
				
				// LA TAILLE DU FICHIER DOIT ETRE POSITIVE
				if (libutils_get_size_file (VarPocheDir.RecName) > 100) {
					
					// ALIMENTE LA LISTE AVEC LE NOM COMPLET DE FICHIER: PATH + NAMEFILE					
					VarPocheDir.ListFiles = g_list_append (VarPocheDir.ListFiles, VarPocheDir.RecName);
					VarPocheDir.RecTotalFile ++;
				}
				else {
					g_free (VarPocheDir.RecName);
					VarPocheDir.RecName = NULL;
				}
			}
		}
	}
	Dummy = chdir ("..");
	closedir (dp);
}
// 
// 
static void pochedir_thread_ (void *arg)
{
	gchar		*Ptr = NULL;
	GList		*List = NULL;
	
	VarPocheDir.BoolInThread = TRUE;
	
	// CONSTRUIT UNE LISTE DE TOUS LES FICHIERS SANS LES DOSSIERS
	List = g_list_first (VarPocheDir.ListReceive);
	while (List) {
		if ((Ptr = (gchar *)List->data) != NULL) {
			// RECHERCHE RECURSIVE DES FICHIERS
			pochedir_recherche_recursive_ (Ptr);
		}
		List = g_list_next (List);
	}

	// SUPPRESISON DE LA COPIE DU GSLIST
	VarPocheDir.ListReceive = libutils_remove_glist (VarPocheDir.ListReceive);

	// VERIFIE LA VALIDITE DU FICHIER
	VarPocheDir.RecActivate = 0;
	VarPocheDir.RecTotalFile = 0;
	pochedir_verif_validity_files ();
	
	// ALIMENTATION DE LA LISTE
	pochedir_set_in_list ();
	
	// REMOVE COPIE DU GLIST
	VarPocheDir.ListFiles = libutils_remove_glist (VarPocheDir.ListFiles);

	VarPocheDir.BoolInThread = FALSE;
	VarPocheDir.BoolSetPercent = FALSE;
	g_print("END THREAD\n");

	pthread_exit(0);
}
// 
// 
static gint pochedir_timeout_ (gpointer data)
{
	VarPocheDir.CancelClicked = WindScan_close_request ();
	
	if (TRUE == VarPocheDir.BoolSetPercent) {
		gchar	*Str = NULL;
		
		VarPocheDir.BoolSetPercent = FALSE;
		VarPocheDir.percent = (double)VarPocheDir.RecActivate  / (double)VarPocheDir.RecTotalFile;
		Str = g_strdup_printf ("%d%%", (int)(VarPocheDir.percent*100));
		WindScan_set_progress (Str, VarPocheDir.percent);
		g_free (Str);
		Str = NULL;
	}
	else if (FALSE == VarPocheDir.BoolInThread) {
		gtk_timeout_remove (VarPocheDir.HandlerTimeout);
		pocheevnt_table_add_images ();
		pocheevnt_set_flag_buttons_recto ();
		pocheevnt_set_flag_buttons_verso ();
		WindScan_close ();
		g_print("END TIMEOUT\n");
	}
	return (TRUE);
}
// 
// 
void pochedir_add_img_file (GSList *p_list)
{
	gchar		*Ptr = NULL;
	GSList		*gs_List = p_list;
	pthread_t	nmr_tid_1;
	
	WindScan_open ("Files scan", WINDSCAN_PULSE);
	WindScan_set_label ("<b><i>Scan directory, verify and load ...</i></b>");
	
	// COPIE DE LA GSlist TRANSMISE PAR LE FILESELECT ET QUI DEVRA ETRE SUPRIMEE
	while (gs_List) {
		if ((Ptr = (gchar *)gs_List->data) != NULL) {
			VarPocheDir.ListReceive = g_list_append (VarPocheDir.ListReceive, g_strdup (Ptr));
		}
		gs_List = g_slist_next (gs_List);
	}
	
	VarPocheDir.RecActivate = 0;
	VarPocheDir.RecTotalFile = 0;
	
	// CALL THREAD
	VarPocheDir.BoolInThread = TRUE;
	VarPocheDir.BoolSetPercent = FALSE;
	
	g_print("DEBUT TIMEOUT\n");
	VarPocheDir.HandlerTimeout = gtk_timeout_add (100, pochedir_timeout_, 0);
	g_print("DEBUT THREAD\n");
	pthread_create (&nmr_tid_1, NULL ,(void *)pochedir_thread_, (void *)NULL);

}





