 /*
 * file      : options_cd.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "configuser.h"
#include "cd_audio.h"
#include "options.h"


void on_radiobutton_cdparanoia_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_cdparanoia = widget;
}
void on_radiobutton_ioctl_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_ioctl = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON(var_options.Adr_radiobutton_ioctl), Config.ReadCdByIoctl);
}
void on_radiobutton_ioctl_clicked (GtkButton *button, gpointer user_data)
{
	Config.ReadCdByIoctl = TRUE;
}
void on_radiobutton_cdparanoia_clicked (GtkButton *button, gpointer user_data)
{
	Config.ReadCdByIoctl = FALSE;
}


void on_radiobutton_choice_extract_with_clicked (GtkButton *button, gpointer user_data)
{
	if (GTK_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert) == button)		Config.ExtractCdWith = EXTRACT_WITH_CDPARANOIA_EXPERT;
	else if (GTK_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav) == button)	Config.ExtractCdWith = EXTRACT_WITH_CDDA2WAV;
	else if (GTK_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia) == button)	Config.ExtractCdWith = EXTRACT_WITH_CDPARANOIA;
}
void on_radiobutton_extract_with_cdparanoia_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_extract_with_cdparanoia = widget;
	if (Config.ExtractCdWith == EXTRACT_WITH_CDPARANOIA)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia), TRUE);
}
void on_radiobutton_extract_with_cdda2wav_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_extract_with_cdda2wav = widget;
	if (Config.ExtractCdWith == EXTRACT_WITH_CDDA2WAV)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav), TRUE);
}
void on_radiobutton_cdparanoia_mode_expert_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_cdparanoia_mode_expert = widget;
	if (Config.ExtractCdWith == EXTRACT_WITH_CDPARANOIA_EXPERT)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert), TRUE);
}


void on_entry_stockage_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_stockage_cdaudio = widget;
	gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio), Config.Templates_rep_cdaudio);
	cdaudio_entry_stockage_cdaudio_changed ();
}
void on_entry_stockage_cdaudio_changed (GtkEditable *editable, gpointer user_data)
{
	cdaudio_entry_stockage_cdaudio_changed ();
}
void on_label_stockage_cdaudio_exemple_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_label_stockage_cdaudio = widget;
	if (var_cd.Adr_entry_stockage_cdaudio) {
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio), Config.Templates_rep_cdaudio);
		cdaudio_entry_stockage_cdaudio_changed ();
	}
}
















