 /*
 * file      : global.h
 * project   : BaseBuild
 * with      : Gtk-2
 *
 * copyright : (C) 2010 by Claude Bulin
 *
 * BaseBuild - Creation d'une base de programmation en langage C de type GNU avec les autotools
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __global_h__
#define __global_h__ 1

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n.h>


extern	GtkBuilder	*GtkXcfaProjet;
extern	GtkWidget	*WindMain;

void main_puts_statusbar_global (gchar *mess_label_status);

/* This is used to create the pixmaps used in the interface. */
GtkWidget *create_pixmap (GtkWidget *widget, const gchar *filename);



#define GLADE_GET_OBJECT(OBJ) gtk_builder_get_object (GtkXcfaProjet, OBJ)

/*
*---------------------------------------------------------------------------
* NOTEBOOK
*---------------------------------------------------------------------------
*/
// notebook_general
#define NOTEBOOK_DVD_AUDIO	0
#define NOTEBOOK_CD_AUDIO	1
	// notebook_expander_cd
	#define NOTEBOOK_CD_AUDIO_TAGS		0
	#define NOTEBOOK_CD_AUDIO_TITRE_CD	1
	#define NOTEBOOK_CD_AUDIO_CUE		2
#define NOTEBOOK_FICHIERS	2
	// notebook_in_file
	#define NOTEBOOK_FICHIERS_CONVERSION	0
	#define NOTEBOOK_FICHIERS_WAV		1
	#define NOTEBOOK_FICHIERS_MP3OGG	2	
	#define NOTEBOOK_FICHIERS_TAGS		3
#define NOTEBOOK_SPLIT		3
#define NOTEBOOK_POCHETTE	4
	// 
	#define NOTEBOOK_POCHETTE_IMAGE		0
	#define NOTEBOOK_POCHETTE_TITRE		1
	#define NOTEBOOK_POCHETTE_TEXTE		2
#define NOTEBOOK_OPTIONS	5
	// notebook_options
	#define NOTEBOOK_OPTIONS_GENERAL	0
	#define NOTEBOOK_OPTIONS_CD_AUDIO	1
	#define NOTEBOOK_OPTIONS_LAME		2
	#define NOTEBOOK_OPTIONS_OGGENC		3
	#define NOTEBOOK_OPTIONS_FLAC		4
	#define NOTEBOOK_OPTIONS_MAC		5
	#define NOTEBOOK_OPTIONS_WAVPACK	6
	#define NOTEBOOK_OPTIONS_MUSEPACK	7
	#define NOTEBOOK_OPTIONS_FAAC		8
	#define NOTEBOOK_OPTIONS_AACPLUSENC	9
	#define NOTEBOOK_OPTIONS_EXPORT_TAGS	10
#define NOTEBOOK_PRGEXTERNES	6
	// notebook_app_externes
	#define NOTEBOOK_OPTIONS_PRGEXTERNES	0
	#define NOTEBOOK_OPTIONS_EXTRA		1

/*
*---------------------------------------------------------------------------
* DEBUG
*---------------------------------------------------------------------------
*/
#define PRINT_FUNC_LF() g_print ("%s :: %s (line = %d)\n", __FILE__, __FUNCTION__, __LINE__)
#define PRINTINT(str,num) g_print ("%s = %d\n", str, num)
#define PRINTBOOL(str,bool) g_print ("%s = %s\n", str, bool == TRUE ? "TRUE" : "FALSE")
#define PRINT(str) g_print ("%s :: %s(line = %d)\n\t%s\n", __FILE__, __FUNCTION__, __LINE__, str)

/*
*---------------------------------------------------------------------------
* SUPPORT
*---------------------------------------------------------------------------
*/
#ifndef GLADE_HOOKUP_OBJECT
#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)
#endif

#ifndef GLADE_HOOKUP_OBJECT_NO_REF
#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)
#endif


/*
*---------------------------------------------------------------------------
* ALSA_PLAY.C
* SPLIT_SPECTRE.C
*---------------------------------------------------------------------------
*/
#define BLOCK_SIZE	2352

// gdkkeysyms.h
/*
GDK_NOTHING		a special code to indicate a null event.
GDK_KEY_PRESS		a key has been pressed.
GDK_KEY_RELEASE		a key has been released.
*/
typedef struct {
	gint		eventkey;		/* GDK_NOTHING | GDK_KEY_PRESS | GDK_KEY_RELEASE	*/
	gint		type;			/* GdkEventType						*/
	guint		state;			/*							*/
	guint		keyval;			/*							*/
	guint16		hardware_keycode;	/*							*/
	gchar		str [ 2 ];		/*							*/
/*
#define GDK_KP_Add 0xffab
#define GDK_KP_Subtract 0xffad
#define GDK_plus 0x02b
#define GDK_minus 0x02d
*/
	gboolean	BoolGDK_KP_Add;		/*							*/
	gboolean	BoolGDK_KP_Subtract;	/*							*/
	gboolean	BoolGDK_plus;		/*							*/
	gboolean	BoolGDK_minus;		/*							*/
/*
#define GDK_Control_L 0xffe3
#define GDK_Control_R 0xffe4
*/
	gboolean	BoolGDK_Control_L;	/* TRUE is PRESS else is RELEASE			*/
	gboolean	BoolGDK_Control_R;	/* TRUE is PRESS else is RELEASE			*/
/*
#define GDK_Shift_L 0xffe1
#define GDK_Shift_R 0xffe2
*/
	gboolean	BoolGDK_Shift_L;	/* TRUE is PRESS else is RELEASE			*/
	gboolean	BoolGDK_Shift_R;	/* TRUE is PRESS else is RELEASE			*/
/*
#define GDK_Left 0xff51
#define GDK_Right 0xff53
*/
	gboolean	BoolGDK_Left;		/* TRUE is PRESS else is RELEASE			*/
	gboolean	BoolGDK_Right;		/* TRUE is PRESS else is RELEASE			*/
	
	gboolean	BoolGDK_Control_A;	/* TRUE is PRESS else is RELEASE			*/
/*
#define GDK_space 0x020
*/
	gboolean	BoolGDK_space;
} KEYS;

extern KEYS keys;

typedef struct {
	gchar      Machine [ 100 ];
	gint       NbCpu;
	gint       TypeCpu;
	gboolean   BoolCpuIs64Bits;
	
} HOST_CONF;

extern HOST_CONF HostConf;


/*
*---------------------------------------------------------------------------
* Dossier temporaire
*---------------------------------------------------------------------------
*/

#define PATH_TMP_XCFA_CD_NORMALISE_PEAK_ALBUM "xcfa_peak_album"

#define PATH_TMP_XCFA_WAVSPLIT "xcfa_wavsplit"

#define PATH_TMP_XCFA_AUDIOCD "xcfa_cdaudio"

#define PATH_TMP_XCFA_AUDIOFILE "xcfa_audiofile"

#define PATH_TMP_XCFA_AUDIOFILEWAVCONV "xcfa_audiofilewavconv"

#define PATH_TMP_XCFA_AUDIOFILEMP3OGG "xcfa_audiofilemp3ogg"

#define PATH_TMP_XCFA_AUDIOFILENORMALYSE "xcfa_audiofilenormalyse"

#define PATH_TMP_XCFA_CDDBTEST "xcfa_cddbtest"

#define TMP_FILE_XCFA_INSTALL	"/tmp/tmp_file_xcfa_install.txt"
#define FILE_XCFA_INSTALL	"/tmp/xcfa_install.sh"
#define PATH_DOWNLOAD_TO_XCFA	"/tmp/download_to_xcfa"

#define PATH_SAVE_POCHETTE_IMG "XcfaPochette"
#define PATH_SAVE_POCHETTE_PS  "XcfaPochette/PostScript"
#define PATH_SAVE_POCHETTE_PNG "XcfaPochette/png"

#define PATH_MANPAGE "XcfaManpage"

#define PATH_TMP_XCFA_ICEDAX "XcfaIcedax"

#endif

