 /*
 * file      : file_conv.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib/gprintf.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
 

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "options.h"
#include "conv.h"
#include "tags.h"
#include "configuser.h"
#include "prg_init.h"
#include "notify_send.h"
#include "tags.h"
#include "win_scan.h"
#include "file.h"



typedef struct {
	gboolean	Bool;
	
} VAR_FILE_CONV;

VAR_FILE_CONV VarFileConv = {
			FALSE
			};



// 
// 
void fileconv_infos (DETAIL *detail)
{
	g_print ("\nCONVERSION(S) DEPUIS L'ONGLET 'FICHIERS'\n");
	if (detail->type_infosong_file_is == FILE_IS_WMA) {
		g_print ("\tFrom FILE_IS_WMA\n");
		// logs_write_datas ("From FILE_IS_WMA: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_RM) {
		g_print ("\tFrom FILE_IS_RM\n");
		// logs_write_datas ("From FILE_IS_RM: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_DTS) {
		g_print ("\tFrom FILE_IS_DTS\n");
		// logs_write_datas ("From FILE_IS_DTS: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_AIFF) {
		g_print ("\tFrom FILE_IS_AIFF\n");
		// logs_write_datas ("From FILE_IS_AIFF: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_M4A) {
		g_print ("\tFrom FILE_IS_M4A\n");
		// logs_write_datas ("From FILE_IS_M4A: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_SHN) {
		g_print ("\tFrom FILE_IS_SHN\n");
		// logs_write_datas ("From FILE_IS_SHN: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_WAV) {
		g_print ("\tFrom FILE_IS_WAV\n");
		// logs_write_datas ("From FILE_IS_WAV: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_FLAC) {
		g_print ("\tFrom FILE_IS_FLAC\n");
		// logs_write_datas ("From FILE_IS_FLAC: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_MP3) {
		g_print ("\tFrom FILE_IS_MP3\n");
		// logs_write_datas ("From FILE_IS_MP3: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_OGG) {
		g_print ("\tFrom FILE_IS_OGG\n");
		// logs_write_datas ("From FILE_IS_OGG: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_MPC) {
		g_print ("\tFrom FILE_IS_MPC\n");
		// logs_write_datas ("From FILE_IS_MPC: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_APE) {
		g_print ("\tFrom FILE_IS_APE\n");
		// logs_write_datas ("From FILE_IS_APE: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
		g_print ("\tFrom FILE_IS_WAVPACK\n");
		// logs_write_datas ("From FILE_IS_WAVPACK: ");
		// logs_writeln_datas (detail->namefile);
	}
	if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Wav\n");
	if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Mp3%s\n", detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Ogg%s\n", detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Flac%s\n", detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT ? "...........WithLineExpert" :"");
	if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo M4a%s\n", detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Aac%s\n", detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Mpc%s\n", detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Ape%s\n", detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo WavPack%s\n", detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT ? "........WithLineExpert" :"");	
	g_print ("\n");
}
void fileconv_copy_src_to_dest (DETAIL *detail, CONV_FIC *PConv)
{
	if (TRUE == conv.bool_stop) return;

	if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_flac)) {
		conv_copy_src_to_dest (PConv->tmp_flac, PConv->dest_flac);
		detail->EtatSelection_Flac = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_ape)) {
		conv_copy_src_to_dest (PConv->tmp_ape, PConv->dest_ape);
		detail->EtatSelection_Ape = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_mp3)) {
		conv_copy_src_to_dest (PConv->tmp_mp3, PConv->dest_mp3);
		detail->EtatSelection_Mp3 = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_ogg)) {
		conv_copy_src_to_dest (PConv->tmp_ogg, PConv->dest_ogg);
		detail->EtatSelection_Ogg = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_wav)) {
		conv_copy_src_to_dest (PConv->tmp_wav, PConv->dest_wav);
		detail->EtatSelection_Wav = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_m4a)) {
		conv_copy_src_to_dest (PConv->tmp_m4a, PConv->dest_m4a);
		detail->EtatSelection_M4a = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_mpc)) {
		conv_copy_src_to_dest (PConv->tmp_mpc, PConv->dest_mpc);
		detail->EtatSelection_Mpc = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_aac)) {
		conv_copy_src_to_dest (PConv->tmp_aac, PConv->dest_aac);
		detail->EtatSelection_Aac = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST && libutils_test_file_exist (PConv->tmp_wavpack)) {
		conv_copy_src_to_dest (PConv->tmp_wavpack, PConv->dest_wavpack);
		
		if (*optionsWavpack_get_wavpack_correction_file () != '\0') {
			conv_copy_src_to_dest (PConv->tmp_wavpack_md5, PConv->dest_wavpack_md5);
		}
		detail->EtatSelection_WavPack = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (detail->EtatTrash == FILE_TRASH_OK) detail->EtatTrash = FILE_TRASH_VERIF_OK;
}
// 
// 
void fileconv_change_quantification_with_sox (DETAIL *detail, CONV_FIC *PConv, gchar *Quantification)
{
	INFO_WAV	*info = (INFO_WAV *)detail->info;

	conv_with_sox_get_param (PConv->tmp_wav, PConv->tmp_sox, info->hertz, info->voie, Quantification);
	conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
	filelc_get_command_line_remove ();
}
// 
// 
static void fileconv_thread (void *arg)
{
	GList		*ListGlobal = NULL;
	DETAIL		*detail = NULL;
	CONV_FIC	*PConv = NULL;
	PARAM_FILELC	param_filelc;
	gint		pos;
	gboolean	BoolResultMplayerIsOk = FALSE;
	
	conv.bool_thread_conv = TRUE;
	PRINT("DEBUT THREAD FILECONV");
	ListGlobal = g_list_first (entetefile);
	while (FALSE == conv.bool_stop && ListGlobal) {
		if (NULL != (detail = (DETAIL *)ListGlobal->data) && NULL != (PConv = (CONV_FIC *)detail->PConv)) {
		
			/*
			SOURCE WAV
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_WAV == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_WAV	*info = (INFO_WAV *)detail->info;
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;
				gchar		 StrBits [ 10 ];

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				// SI <> NULL ALORS 'detail->NameFileCopyFromNormalizate' SE TROUVE DEJA DANS LE DOSSIER TEMPORAIRE
				if (NULL == detail->NameFileCopyFromNormalizate) {
					conv_copy_src_to_dest (detail->namefile, PConv->tmp_wav);
				}
						
				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (PConv->dest_flac);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 24 && Bits != 16 && Bits != 8)
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 24)				strcpy (StrBits, "24");
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "24" : "16");
						else if (Bits >  8 && Bits < 16)	strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits <  8)			strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
					} else {
						conv_inc_encode_completed ();
					}
					
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ]) ? PConv->tmp_sox : PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (detail->dest_ape);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 16 && Bits != 8)
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 16)			strcpy (StrBits, "16");
						else if (Bits > 8 && Bits < 16)	strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits < 8)		strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
					} else {
						conv_inc_encode_completed ();
					}

					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ]) ? PConv->tmp_sox : PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (detail->dest_wavpack);

					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_wavpack;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.PtrStrBitrate         = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();
										
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}
				
				// CONVERSION OGG
				//     BUG TROUVE PAR XAVIER
				//     =====================
				//     Si je veux normaliser et convertir un wav 48 kHz en ogg, xcfa me crée un ogg en 44.1 kHz... Pas normal, hein ?
				// 
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (PConv->dest_ogg);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 24 && Bits != 16 && Bits != 8);
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 24)				{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
					} else {
						conv_inc_encode_completed ();
					}
					
					// SET WITH FLOAT FORMAT IF == 24
					if (Bits == 24) {
						// SOX
						conv_with_sox_float_get_param (
									(TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ]) ?  PConv->tmp_sox : PConv->tmp_wav,
									PConv->tmp_sox_24);
						
						conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}

					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ] || Bits == 24) {
						param_filelc.filesrc               = PConv->tmp_sox;
					}
					else {
						param_filelc.filesrc               = PConv->tmp_wav;
					}
					
					param_filelc.filedest              = PConv->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}				
				
				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (detail->dest_m4a);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_M4A ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	{ strcpy (StrBits, "32"); Bits = 32; }
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_copy_src_to_dest (PConv->tmp_wav, PConv->tmp_sox);
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24 || 32
					if (Bits == 32 || Bits == 24) {

						conv_with_sox_float_get_param (
									PConv->tmp_sox, 
									PConv->tmp_sox_24);
						conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}

					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_sox;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (PConv->dest_aac);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);

					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_AAC ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	strcpy (StrBits, "32");
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_copy_src_to_dest (PConv->tmp_wav, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24
					if (Bits == 24) {
						// SOX FLOAT
						conv_with_sox_float_get_param (PConv->tmp_sox, PConv->tmp_sox_24);
						conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					if (Hertz < 44100) {
						pos = filelc_get_command_line_nice ();
						conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
						conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
						conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_sox);
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup ("pcm");
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s",PConv->tmp_sox_24);
						conv.ArgConv [ pos++ ] = g_strdup ("-srate");
						conv.ArgConv [ pos++ ] = g_strdup ("44100");
						conv.ArgConv [ pos++ ] = NULL;
						
						conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, "MPLAYER_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_sox;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (PConv->dest_mpc);

					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MPC ]) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						// logs_write_datas ("\tChange bit ");
						// logs_write_datas (StrBits);
						// logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	{ strcpy (StrBits, "32"); Bits = 32; }
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) < 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						// logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_copy_src_to_dest (PConv->tmp_wav, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24 || 32
					if (Bits == 32 || Bits == 24) {
						// SOX
						conv_with_sox_float_get_param (PConv->tmp_sox, PConv->tmp_sox_24);
						conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					if (Hertz < 44100) {
						pos = filelc_get_command_line_nice ();
						conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
						conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
						conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_sox);
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup ("pcm");
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s",PConv->tmp_sox_24);
						conv.ArgConv [ pos++ ] = g_strdup ("-srate");
						conv.ArgConv [ pos++ ] = g_strdup ("44100");
						conv.ArgConv [ pos++ ] = NULL;
						
						conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, "MPLAYER_WAV_TO_WAV");
						filelc_get_command_line_remove ();

						conv_copy_src_to_dest (PConv->tmp_sox_24, PConv->tmp_sox);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_sox;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					
					// logs_write_datas ("\t");
					// logs_writeln_datas (PConv->dest_mp3);
					
					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// detail->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] = 
					// (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) &&
					//  ((Hertz == 48000 && Bits == 32) || (Bits != 8 || Bits != 16 || Bits != 24 || Bits != 32));
					if (Hertz == 48000 && Bits == 32) {
						conv_with_sox_float_get_param (PConv->tmp_wav, PConv->tmp_sox);
						conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
						filelc_get_command_line_remove ();
						
						PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] = TRUE;
						
					} else if (Bits != 8 || Bits != 16 || Bits != 24 || Bits != 32) {
						
						// CORRECTION
						// http://forum.ubuntu-fr.org/viewtopic.php?pid=3271586#p3271586
						// joelab07
						
						if (Bits < 8)			strcpy (StrBits, "8");
						if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) < 3 ? "16" : "24");
						if (Bits > 24 && Bits < 32)	strcpy (StrBits, (Bits - 24) < 3 ? "24" : "32");
						else 				strcpy (StrBits, "32");
						
						fileconv_change_quantification_with_sox (detail, PConv, StrBits);
						// SORTIE FICHIER EN tmp_sox
						
						PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] = TRUE;
						
					} else {
						conv_inc_encode_completed ();
					}

					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (TRUE == PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ]) ? PConv->tmp_sox : PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}				

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			
			/*
			SOURCE FLAC
			DEST   OGG      :  FLAC -> OGG    oggenc
			DEST   WAV      :  FLAC -> WAV    flac
			DEST   MP3      :  WAV  -> MP3    lame
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_FLAC == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_FLAC *info = (INFO_FLAC *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_flac);
				
				if (FALSE == conv.bool_stop) {
					param_filelc.type_conv            = FLAC_FLAC_TO_WAV;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_flac;
					param_filelc.filedest             = PConv->tmp_wav;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_FLAC_TO_WAV, "FLAC_FLAC_TO_WAV");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
				
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE APE
			DEST   WAV      :  APE -> WAV     mac
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_APE == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_APE *info = (INFO_APE *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_ape);

				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					param_filelc.type_conv            = MAC_APE_TO_WAV;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_ape;
					param_filelc.filedest             = PConv->tmp_wav;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_APE_TO_WAV, "MAC_APE_TO_WAV");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}
				
				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE WAVPACK
			DEST   WAV      :  WAVPACK -> WAV wvunpack
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			*/
			if (FALSE == conv.bool_stop && FILE_IS_WAVPACK == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST
				)) {

				INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_wavpack);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (PConv->dest_wavpack_md5, PConv->tmp_wavpack_md5);
				
				//  UNPACK : WAVPACK -> WAV
				if (FALSE == conv.bool_stop) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
					
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("wvunpack");
					conv.ArgConv [ pos++ ] = g_strdup ("-y");
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.ArgConv [ pos++ ] = g_strdup (optionsWavpack_get_wavpack_signature_md5 ());
					}
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wavpack);
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = NULL;
					
					conv_to_convert (FALSE, WVUNPACK_WAVPACK_TO_WAV, "WVUNPACK_WAVPACK_TO_WAV");
					filelc_get_command_line_remove ();
					
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wvunpack = TRUE;
					}
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, NULL);						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv             = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_flac;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}
				
				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE OGG
			DEST   WAV      :  OGG -> WAV     ogg123
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_OGG == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_OGG *info = (INFO_OGG *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				// SI <> NULL ALORS 'detail->NameFileCopyFromNormalizate' se trouve deja dans le dossier temporaire
				if (FALSE == conv.bool_stop && NULL == detail->NameFileCopyFromNormalizate) {
					
					conv_copy_src_to_dest (detail->namefile, PConv->tmp_ogg);
				}

					// CONVERSION WAV

					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_ogg);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = NULL;
				
					conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_OGG_TO_WAV, "MPLAYER_OGG_TO_WAV");
					filelc_get_command_line_remove ();

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_wavpack;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE M4A
			DEST   WAV      :  M4A -> WAV     faad
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   MP3      :  WAV -> MP3     lame
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_M4A == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_M4A *info = (INFO_M4A *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_m4a);
				
				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_m4a);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = NULL;

					BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_M4A_TO_WAV, "MPLAYER_M4A_TO_WAV");
					filelc_get_command_line_remove ();
					
					if (FALSE == BoolResultMplayerIsOk) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
					
					/*
					conv_inc_encode_completed ();
					conv.type_conv = SOX_WAV_TO_WAV;
					listmplayer = conv_with_sox_get_param (PConv->tmp_sox, PConv->tmp_wav, "44100", "2", "16");
					conv.ArgConv = conv_alloc_arg (listmplayer);
					conv_exec (FALSE, SOX_WAV_TO_WAV, listmplayer, "SOX_WAV_TO_WAV");
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					*/
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE MPC
			DEST   WAV      :  MPC -> WAV     mppdec
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_MPC == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_MPC *info = (INFO_MPC *)detail->info;
				gint	  BoolApplyConvMPC = 0;
				
				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_mpc);
				
				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					gchar *ptr = NULL;
					
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup (prginit_get_name (NMR_musepack_tools_mppdec));
					// MPC123 et MPPDEC et MPPDEC: MPC -> WAV
					BoolApplyConvMPC = 0;
					ptr = prginit_get_name (NMR_musepack_tools_mppdec);
					if (strstr (ptr, "mpc123") != NULL) BoolApplyConvMPC = 1;
					if (strstr (ptr, "mppdec") != NULL) BoolApplyConvMPC = 1;
					if (strstr (ptr, "mpcdec") != NULL) BoolApplyConvMPC = 2;
					
					// mpc123 | mppdec
					if (1 == BoolApplyConvMPC) {
						conv.ArgConv [ pos++ ] = g_strdup ("--wav");
					}
					
					if (HostConf.BoolCpuIs64Bits == TRUE) {
						if (1 == BoolApplyConvMPC) {
							conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
							conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_mpc);
						}
						else if (2 == BoolApplyConvMPC) {
							conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_mpc);
							conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
						}
					}
					else {
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_mpc);
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
					}
					param_filelc.PtrStrBitrate        = NULL;	
					conv_to_convert (param_filelc.With_CommandLineUser, MPPDEC_MPC_TO_WAV, "MPPDEC_MPC_TO_WAV");
					filelc_get_command_line_remove ();
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE MP3
			DEST   WAV      :  MP3 -> WAV     mpg321
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_MP3 == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Wav  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape  > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_MP3 *info = (INFO_MP3 *)detail->info;
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;

				fileconv_infos (detail);
				
				// COPIE SOURCE WAV DANS LE DOSSIER TEMPORAIRE
				// SI <> NULL ALORS 'detail->NameFileCopyFromNormalizate' se trouve deja dans le dossier temporaire
				if (NULL == detail->NameFileCopyFromNormalizate) {
					conv_copy_src_to_dest (detail->namefile, PConv->tmp_mp3);
				}

				if (FALSE == conv.bool_stop) {
					
					// Changement du bitrate
					if (NULL == detail->NameFileCopyFromNormalizate) {
						
						// PRINT("CHANGEMENT: voie + hertz + bits");
						
						pos = filelc_get_command_line_nice ();
						conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
						conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
						conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_mp3);
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup ("pcm");
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s",PConv->tmp_wav);
						conv.ArgConv [ pos++ ] = NULL;
						
						BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_MP3_TO_WAV, "MPLAYER_MP3_TO_WAV");
						filelc_get_command_line_remove ();
										
						if (FALSE == BoolResultMplayerIsOk) {
							PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
							break;
						}
						
						// 8000
						// 22000
						// 32000
						// 44056
						// 44100
						// 48000
						// 88200
						// 96000
					}
					
					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					g_print("Channels = %d   Hertz = %d   Bits = %d\n", Channels, Hertz, Bits);
						
					if (Hertz < 44100 && (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST || detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)) {
						pos = filelc_get_command_line_nice ();
						conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
						conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
						conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
						conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup ("pcm");
						conv.ArgConv [ pos++ ] = g_strdup ("-ao");
						conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s",PConv->tmp_sox);
						conv.ArgConv [ pos++ ] = g_strdup ("-srate");
						conv.ArgConv [ pos++ ] = g_strdup ("44100");
						conv.ArgConv [ pos++ ] = NULL;
						
						BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, "MPLAYER_WAV_TO_WAV");
						filelc_get_command_line_remove ();
					}

				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (Hertz < 44100) ? PConv->tmp_sox : PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}
				
				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (Hertz < 44100) ? PConv->tmp_sox : PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE RM
			DEST   WAV      :  RM  -> WAV     mplayer ./01.rm -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_RM == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_RM *info = (INFO_RM *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_rm);
				
				// CONVERSION WAV */
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_rm);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = g_strdup ("-af");
					conv.ArgConv [ pos++ ] = g_strdup ("channels=2");
					conv.ArgConv [ pos++ ] = g_strdup ("-srate");
					conv.ArgConv [ pos++ ] = g_strdup ("44100");
					conv.ArgConv [ pos++ ] = NULL;
							
					BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_RM_TO_WAV, "MPLAYER_RM_TO_WAV");
					filelc_get_command_line_remove ();

					if (FALSE == BoolResultMplayerIsOk) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE DTS
			DEST   WAV      :  DTS -> WAV     mplayer ./01.dts -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_DTS == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_DTS *info = (INFO_DTS *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_dts);
				
				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_dts);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = g_strdup ("-af");
					conv.ArgConv [ pos++ ] = g_strdup ("channels=2");
					conv.ArgConv [ pos++ ] = g_strdup ("-srate");
					conv.ArgConv [ pos++ ] = g_strdup ("44100");
					conv.ArgConv [ pos++ ] = NULL;
		
					BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_DTS_TO_WAV, "MPLAYER_DTS_TO_WAV");
					filelc_get_command_line_remove ();

					if (FALSE == BoolResultMplayerIsOk) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE AIFF
			DEST   WAV      :  AIF -> WAV     mplayer ./01.aif -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_AIFF == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_AIFF *info = (INFO_AIFF *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_aiff);

				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_aiff);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = g_strdup ("-af");
					conv.ArgConv [ pos++ ] = g_strdup ("channels=2");
					conv.ArgConv [ pos++ ] = g_strdup ("-srate");
					conv.ArgConv [ pos++ ] = g_strdup ("44100");
					conv.ArgConv [ pos++ ] = NULL;
		
					BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_AIFF_TO_WAV, "MPLAYER_AIFF_TO_WAV");
					filelc_get_command_line_remove ();

					if (FALSE == BoolResultMplayerIsOk) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE WMA
			DEST   WAV      :  WMA -> WAV     mplayer ./01.wma -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_WMA == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_WMA *info = (INFO_WMA *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_wma);

				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("mplayer");
					conv.ArgConv [ pos++ ] = g_strdup ("-nojoystick");
					conv.ArgConv [ pos++ ] = g_strdup ("-nolirc");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wma);
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup ("pcm");
					conv.ArgConv [ pos++ ] = g_strdup ("-ao");
					conv.ArgConv [ pos++ ] = g_strdup_printf ("pcm:file=%s", PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = g_strdup ("-af");
					conv.ArgConv [ pos++ ] = g_strdup ("channels=2");
					conv.ArgConv [ pos++ ] = g_strdup ("-srate");
					conv.ArgConv [ pos++ ] = g_strdup ("44100");
					conv.ArgConv [ pos++ ] = NULL;
		
					BoolResultMplayerIsOk = conv_to_convert (param_filelc.With_CommandLineUser, MPLAYER_WMA_TO_WAV, "MPLAYER_WMA_TO_WAV");
					filelc_get_command_line_remove ();

					if (FALSE == BoolResultMplayerIsOk) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
						param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, "AACPLUSENC_WAV_TO_AAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE SHORTEN
			DEST   WAV      :  SHN -> WAV     shorten -x -b 256 -c 2 01.shn 01.wav
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_SHN == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_SHN *info = (INFO_SHN *)detail->info;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_shn);

				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("shorten");
					conv.ArgConv [ pos++ ] = g_strdup ("-x");
					conv.ArgConv [ pos++ ] = g_strdup ("-b");
					conv.ArgConv [ pos++ ] = g_strdup ("256");
					conv.ArgConv [ pos++ ] = g_strdup ("-c");
					conv.ArgConv [ pos++ ] = g_strdup ("2");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_shn);
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = NULL;
		
					conv_to_convert (param_filelc.With_CommandLineUser, SHORTEN_SHN_TO_WAV, "SHORTEN_SHN_TO_WAV");
					filelc_get_command_line_remove ();
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}

				// CONVERSION OGG
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = detail->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = detail->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					
					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = detail->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			/*
			SOURCE AC3
			DEST   WAV      :  AC3 -> WAV     a52dec
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (FALSE == conv.bool_stop && FILE_IS_AC3 == detail->type_infosong_file_is &&
				(
				detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST ||
				detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST
				)) {

				// INFO_AC3 *info = (INFO_AC3 *)detail->info;
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;
				gchar		*StrChannels = NULL;
				gchar		*StrHertz = NULL;
				gchar		*StrBits = NULL;

				fileconv_infos (detail);
				
				// COPIE DANS LE DOSSIER TEMPORAIRE
				conv_copy_src_to_dest (detail->namefile, PConv->tmp_ac3);

				// CONVERSION WAV
				if (FALSE == conv.bool_stop) {
					// 
					// TODO DEBIAN/ liba52-0.7.4-dev
					// 
					// a52dec ./audio.ac3 -o wav > audio.wav
					// 
					pos = filelc_get_command_line_nice ();
					conv.ArgConv [ pos++ ] = g_strdup ("a52dec");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_ac3);
					conv.ArgConv [ pos++ ] = g_strdup ("-o");
					conv.ArgConv [ pos++ ] = g_strdup ("wav");
					conv.ArgConv [ pos++ ] = g_strdup (">");
					conv.ArgConv [ pos++ ] = g_strdup (PConv->tmp_wav);
					conv.ArgConv [ pos++ ] = NULL;
					conv_to_convert (FALSE, A52DEC_AC3_TO_WAV, "A52DEC_AC3_TO_WAV");
					filelc_get_command_line_remove ();
					
					tagswav_file_GetBitrate (PConv->tmp_wav, &Channels, &Hertz, &Bits);
					StrChannels = g_strdup_printf ("%d", Channels);
					StrHertz    = g_strdup_printf ("%d", Hertz);
					StrBits     = g_strdup_printf ("%d", Bits);
					conv_with_sox_get_param (PConv->tmp_wav, PConv->tmp_sox, StrHertz, StrChannels, StrBits);
					conv_to_convert (FALSE, SOX_WAV_TO_WAV, "SOX_WAV_TO_WAV");
					filelc_get_command_line_remove ();
					
					g_free (StrChannels);	StrChannels = NULL;
					g_free (StrHertz);	StrHertz = NULL;
					g_free (StrBits);	StrBits = NULL;
					
					conv_copy_src_to_dest (PConv->tmp_sox, PConv->tmp_wav);
				}

				// CONVERSION FLAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
										
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, "FLAC_WAV_TO_FLAC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION APE
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, "MAC_WAV_TO_APE");
					filelc_get_command_line_remove ();
				}

				// CONVERSION WAVPACK
				if (FALSE == conv.bool_stop && detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					PConv->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_wavpack;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.PtrStrBitrate         = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, "WAVPACK_WAV_TO_WAVPACK");
					filelc_get_command_line_remove ();
										
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
				}

				// CONVERSION OGG
				//     BUG TROUVE PAR XAVIER
				//     =====================
				//     Si je veux normaliser et convertir un wav 48 kHz en ogg, xcfa me crée un ogg en 44.1 kHz... Pas normal, hein ?
				// 
				if (FALSE == conv.bool_stop && detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_ogg;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, NULL);
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, "OGGENC_WAV_TO_OGG");
					filelc_get_command_line_remove ();
				}				

				// CONVERSION M4A
				if (FALSE == conv.bool_stop && detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					param_filelc.type_conv             = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = PConv->tmp_wav;
					param_filelc.filedest              = PConv->tmp_m4a;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION AAC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					
					g_print ("PConv->tmp_wav = %s\n", PConv->tmp_wav);
					g_print ("PConv->tmp_aac = %s\n", PConv->tmp_aac);
					
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_aac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = NULL;						
					
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, "FAAC_WAV_TO_M4A");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MPC
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mpc;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.PtrStrBitrate        = NULL;
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, "MPPENC_WAV_TO_MPC");
					filelc_get_command_line_remove ();
				}

				// CONVERSION MP3
				if (FALSE == conv.bool_stop && detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = PConv->tmp_wav;
					param_filelc.filedest             = PConv->tmp_mp3;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, NULL);
						
					filelc_get_command_line (&param_filelc);
					conv_to_convert (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, "LAME_WAV_TO_MP3");
					filelc_get_command_line_remove ();
				}				
				
				// COPIE DOSSIER TEMPORAIRE VERS DESTINATION
				fileconv_copy_src_to_dest (detail, PConv);
			}
			
			g_unlink (PConv->tmp_flac);
			g_unlink (PConv->tmp_wav);
			g_unlink (PConv->tmp_sox);
			g_unlink (PConv->tmp_sox_24);
			g_unlink (PConv->tmp_mp3);
			g_unlink (PConv->tmp_ogg);
			g_unlink (PConv->tmp_m4a);
			g_unlink (PConv->tmp_aac);
			g_unlink (PConv->tmp_shn);
			g_unlink (PConv->tmp_wma);
			g_unlink (PConv->tmp_rm);
			g_unlink (PConv->tmp_dts);
			g_unlink (PConv->tmp_mpc);
			g_unlink (PConv->tmp_ape);
			g_unlink (PConv->tmp_wavpack);
			g_unlink (PConv->tmp_wavpack_md5);
			g_unlink (PConv->tmp_ac3);
		}
		
		if (TRUE == conv.bool_stop)
			break;
		else	ListGlobal = g_list_next(ListGlobal);
	}
	
	// close(conv.tube_conv [ 0 ]);
	conv.bool_thread_conv = FALSE;
	PRINT("FIN THREAD FILECONV");
	pthread_exit(0);
}
// 
// 
static gint fileconv_timeout (gpointer data)
{
	if (TRUE == conv.BoolIsa52dec) {
		WindScan_set_pulse ();
	}
	if (TRUE == conv.BoolIsa52dec || TRUE == conv.BoolIsExtract || TRUE == conv.BoolIsConvert || TRUE == conv.BoolIsCopy || TRUE == conv.BoolIsNormalise || TRUE == conv.BoolIsReplaygain) {
		gchar	Str [ 200 ];
		
		Str [ 0 ] = '\0';
		
		if (TRUE == conv.BoolIsExtract) {
			strcat (Str, "<b><i>Extraction</i></b> ");
		}
		if (TRUE == conv.BoolIsConvert) {
			strcat (Str, "<b><i>Conversion</i></b> ");
		}
		if (TRUE == conv.BoolIsCopy) {
			strcat (Str, "<b><i>Copie</i></b> ");
		}
		if (TRUE == conv.BoolIsNormalise) {
			strcat (Str, "<b><i>Normalise</i></b> ");
		}
		if (TRUE == conv.BoolIsReplaygain) {
			strcat (Str, "<b><i>Replaygain</i></b>");
		}
		if (TRUE == conv.BoolIsa52dec) {
			strcat (Str, "<b><i>Conversion AC3</i></b>");
		}
		
		WindScan_set_label (Str);
	}
	if (TRUE == conv.bool_percent_conv) {
		
		gchar	*Str = NULL;
		
		Str = g_strdup_printf ("%d%%", (int)(conv.total_percent * 100));
		WindScan_set_progress (Str, conv.total_percent);
		g_free (Str);
		Str = NULL;
		conv.bool_percent_conv = FALSE;
	}
	if (TRUE == conv.Bool_MAJ_select) {
		conv.Bool_MAJ_select = FALSE;
		file_pixbuf_update_glist ();
	}
	else if (FALSE == conv.bool_thread_conv) {
		
		DETAIL		*detail = NULL;
		CONV_FIC	*PConv = NULL;
		GList		*list = NULL;
		
		// SUPPRESSION DE LA STRUCTURE DE CONVERSIONS
		list = g_list_first (entetefile);
		while (list) {
			if (NULL != (detail = (DETAIL *)list->data)) {
				if (NULL != (PConv = (CONV_FIC *)detail->PConv)) {
					
					g_free (detail->NameFileCopyFromNormalizate);		detail->NameFileCopyFromNormalizate = NULL;
					
					g_free (PConv->dest_flac);		PConv->dest_flac = NULL;
					g_free (PConv->dest_wav);		PConv->dest_wav = NULL;
					g_free (PConv->dest_mp3);		PConv->dest_mp3 = NULL;
					g_free (PConv->dest_ogg);		PConv->dest_ogg = NULL;
					g_free (PConv->dest_m4a);		PConv->dest_m4a = NULL;
					g_free (PConv->dest_aac);		PConv->dest_aac = NULL;
					g_free (PConv->dest_mpc);		PConv->dest_mpc = NULL;
					g_free (PConv->dest_ape);		PConv->dest_ape = NULL;
					g_free (PConv->dest_wavpack);		PConv->dest_wavpack = NULL;
					g_free (PConv->dest_wavpack_md5);	PConv->dest_wavpack_md5 = NULL;
					g_free (PConv->tmp_flac);		PConv->tmp_flac = NULL;
					g_free (PConv->tmp_wav);		PConv->tmp_wav = NULL;
					g_free (PConv->tmp_mp3);		PConv->tmp_mp3 = NULL;
					g_free (PConv->tmp_ogg);		PConv->tmp_ogg = NULL;
					g_free (PConv->tmp_m4a);		PConv->tmp_m4a = NULL;
					g_free (PConv->tmp_aac);		PConv->tmp_aac = NULL;
					g_free (PConv->tmp_shn);		PConv->tmp_shn = NULL;
					g_free (PConv->tmp_wma);		PConv->tmp_wma = NULL;
					g_free (PConv->tmp_rm);			PConv->tmp_rm = NULL;
					g_free (PConv->tmp_dts);		PConv->tmp_dts = NULL;
					g_free (PConv->tmp_mpc);		PConv->tmp_mpc = NULL;
					g_free (PConv->tmp_ape);		PConv->tmp_ape = NULL;
					g_free (PConv->tmp_wavpack);		PConv->tmp_wavpack = NULL;
					g_free (PConv->tmp_wavpack_md5);	PConv->tmp_wavpack_md5 = NULL;
					g_free (PConv->tmp_sox);		PConv->tmp_sox = NULL;
					g_free (PConv->tmp_sox_24);		PConv->tmp_sox_24 = NULL;
					g_free (PConv->tmp_ac3);		PConv->tmp_ac3 = NULL;
					
					g_free (PConv);
					PConv = detail->PConv = NULL;
				}
			}
			list = g_list_next(list);
		}
		
		// DELETTE TEMPORAY REP
		if (NULL != conv.TmpRep)  {
			conv.TmpRep  = libutils_remove_temporary_rep (conv.TmpRep);
		}
		
		// EST FERMEE DEPUIS: fileaction_ ...
		// WindScan_close ();
		
		PRINT("FIN TIMEOUT FILECONV");
		gtk_timeout_remove (conv.handler_timeout_conv);
		file_pixbuf_update_glist ();
		fileaction_set_end (TYPE_CONVERSION);
		if (FALSE == conv.bool_stop) {
			NotifySend_msg (_("XCFA: Conversions fichiers"), _("Ok"));
		} else {
			NotifySend_msg (_("XCFA: Conversions fichiers"), _("Arret par l'utilisateur"));
		}
	}
	return (TRUE);
}
// PREPARE LA LISTE POUR LES CONVERSIONS
// 
void fileconv_set_flags_before_conversion_file (void)
{
	GList		*list = NULL;
	DETAIL		*detail = NULL;
	CONV_FIC	*PConv = NULL;
	gint		CptEtat;
	
	list = g_list_first (entetefile);
	while (list) {
		if (NULL != (detail = (DETAIL *)list->data)) {
		
			// SI AUCUNE CONVERSION DANS CETTE LIGNE, CONTINUE
			if (detail->EtatSelection_Wav <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Flac <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Ape <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_WavPack <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Ogg <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_M4a <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Aac <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Mpc <= ETAT_ATTENTE_EXIST &&
				detail->EtatSelection_Mp3 <= ETAT_ATTENTE_EXIST) {
				
				list = g_list_next(list);
				continue;
			}
			// CREATION STRUCTURE
			detail->PConv = (CONV_FIC *)g_malloc0 (sizeof (CONV_FIC));
			PConv = detail->PConv;
			
			// INIT DOSSIER TEMPORAIRE
			if (NULL == conv.TmpRep)  {
				conv.TmpRep  = libutils_create_temporary_rep (Config.PathnameTMP, PATH_TMP_XCFA_AUDIOFILE);
			}
						
			// INIT ETAT
			for (CptEtat = 0; CptEtat < ETAT_BOOL_TOTAL; CptEtat ++) {
				PConv->BoolEtatConv [ CptEtat ] = FALSE;
			}
			
			// PREPARATION DES PATHNAMES DE DESTINATION
			PConv->dest_flac        = file_get_pathname_dest (detail, "flac");
			PConv->dest_wav         = file_get_pathname_dest (detail, "wav");
			PConv->dest_mp3         = file_get_pathname_dest (detail, "mp3");
			PConv->dest_ogg         = file_get_pathname_dest (detail, "ogg");
			PConv->dest_m4a         = file_get_pathname_dest (detail, "m4a");
			PConv->dest_aac         = file_get_pathname_dest (detail, "aac");
			PConv->dest_mpc         = file_get_pathname_dest (detail, "mpc");
			PConv->dest_ape         = file_get_pathname_dest (detail, "ape");
			PConv->dest_wavpack     = file_get_pathname_dest (detail, "wv");
			PConv->dest_wavpack_md5 = file_get_pathname_dest (detail, "wvc");
			
			// PREPARATION DES PATHNAMES TEMPORAIRES
			PConv->tmp_flac         = g_strdup_printf ("%s/tmp.flac",    conv.TmpRep);
			if (NULL != detail->NameFileCopyFromNormalizate)
				PConv->tmp_wav = g_strdup (detail->NameFileCopyFromNormalizate);
			else	PConv->tmp_wav = g_strdup_printf ("%s/tmp.wav", conv.TmpRep);
			PConv->tmp_sox         = g_strdup_printf ("%s/tmp_sox.wav", conv.TmpRep);
			PConv->tmp_sox_24      = g_strdup_printf ("%s/tmp_sox_24.wav", conv.TmpRep);
			PConv->tmp_mp3         = g_strdup_printf ("%s/tmp.mp3",     conv.TmpRep);
			PConv->tmp_ogg         = g_strdup_printf ("%s/tmp.ogg",     conv.TmpRep);
			PConv->tmp_m4a         = g_strdup_printf ("%s/tmp.m4a",     conv.TmpRep);
			PConv->tmp_aac         = g_strdup_printf ("%s/tmp.aac",     conv.TmpRep);
			PConv->tmp_shn         = g_strdup_printf ("%s/tmp.shn",     conv.TmpRep);
			PConv->tmp_wma         = g_strdup_printf ("%s/tmp.wma",     conv.TmpRep);
			PConv->tmp_rm          = g_strdup_printf ("%s/tmp.rm",      conv.TmpRep);
			PConv->tmp_dts         = g_strdup_printf ("%s/tmp.dts",     conv.TmpRep);
			PConv->tmp_aiff        = g_strdup_printf ("%s/tmp.aiff",    conv.TmpRep);
			PConv->tmp_mpc         = g_strdup_printf ("%s/tmp.mpc",     conv.TmpRep);
			PConv->tmp_ape         = g_strdup_printf ("%s/tmp.ape",     conv.TmpRep);
			PConv->tmp_wavpack     = g_strdup_printf ("%s/tmp.wv",      conv.TmpRep);
			PConv->tmp_wavpack_md5 = g_strdup_printf ("%s/tmp.wvc",     conv.TmpRep);
			PConv->tmp_ac3         = g_strdup_printf ("%s/tmp.ac3",     conv.TmpRep);
			
			/*
			SOURCE WAVPACK
			DEST   WAV      :  WAVPACK -> WAV wvunpack
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			*/
			if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}
			
			/*
			SOURCE APE
			DEST   WAV      :  APE -> WAV     mac
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_APE) {

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}
			
			/*
			SOURCE MPC
			DEST   WAV      :  MPC -> WAV     mppdec
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_MPC) {

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}
			
			/*
			SOURCE M4A
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAV      :  M4A -> WAV     faad
			DEST   MP3      :  WAV -> MP3     lame
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_M4A) {

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 4;
				
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE SHORTEN
			DEST   WAV      :  SHN -> WAV     shorten -x -b 256 -c 2 01.shn 01.wav
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_SHN) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}
			
			/*
			SOURCE FLAC
			DEST   OGG      :  FLAC -> OGG    oggenc
			DEST   WAV      :  FLAC -> WAV    flac
			DEST   MP3      :  WAV  -> MP3    lame
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_FLAC) {

				if (detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}
			
			/*
			SOURCE WAV
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_WAV) {
				
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;

				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert += 2;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert += 2;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert += 4;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert += 4;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert += 6;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert += 6;
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert += 3;
				
				// COPY TO TMP
				conv.total_convert += 2;
				
				tagswav_file_GetBitrate (detail->namefile, &Channels, &Hertz, &Bits);
								
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ] = 
					detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST &&
					(Bits != 24 && Bits != 16 && Bits != 8);
				
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ] = 
					detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST &&
					(Bits != 16 && Bits != 8);
				
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ] = 
					detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST &&
					(Bits != 24 && Bits != 16 && Bits != 8);				
												
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_M4A ] = 
					detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);
				
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_AAC ] = 
					detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);

				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MPC ] = 
					detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);
								
				PConv->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] = 
					(detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) &&
					 ((Hertz == 48000 && Bits == 32) || (Bits != 8 || Bits != 16 || Bits != 24 || Bits != 32));
			}

			/*
			SOURCE MP3
			DEST   WAV      :  MP3 -> WAV     mpg321
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_MP3) {
				
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 5;
				
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE OGG
			DEST   WAV      :  OGG -> WAV     ogg123
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_OGG) {

				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 4;
				
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE WMA
			DEST   WAV      :  WMA -> WAV     mplayer ./01.wma -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_WMA) {

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE RM
			DEST   WAV      :  WMA -> WAV     mplayer ./01.rm -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_RM) {

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE DTS
			DEST   WAV      :  DTS -> WAV     mplayer ./01.dts -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_DTS) {

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE AIFF
			DEST   WAV      :  AIF -> WAV     mplayer ./01.aif -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_AIFF) {

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE AC3
			DEST   WAV      :  AC3 -> WAV     a52dec
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_AC3) {

				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 5;
				
				if (detail->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (detail->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (detail->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				
				PRINT("PASS");
			}
		}
		list = g_list_next(list);
	}
	/*
	g_print("\n");
	g_print("conv.total_convert      = %d\n", conv.total_convert);
	g_print("conv.total_percent      = %f\n", conv.total_percent);
	g_print("conv.rip_completed      = %d\n", conv.rip_completed);
	g_print("conv.encode_completed   = %d\n", conv.encode_completed);
	g_print("conv.extract_percent    = %f\n", conv.extract_percent);
	g_print("conv.conversion_percent = %f\n", conv.conversion_percent);
	g_print("conv.total_rip          = %d\n", conv.total_rip);
	g_print("\n");
	*/
}
// 
// 
void fileconv_action (void)
{
	pthread_t  nmr_tid;
 	
	WindScan_open ("Conversions files", WINDSCAN_PULSE);
	WindScan_set_label ("<b><i>Conversions files ...</i></b>");
	
	conv_reset_struct (WindScan_close_request);
	// PREPARE LA LISTE POUR LES CONVERSIONS
	fileconv_set_flags_before_conversion_file ();
	conv.bool_thread_conv = TRUE;
 	pthread_create (&nmr_tid, NULL ,(void *)fileconv_thread, (void *)NULL);
	
	// Le premier paramètre est le nombre de millisecondes entre les appels à notre fonction.
	// Le deuxième est la fonction à appeler.
	// Le troisième est la donnée passée à cette fonction de rappel.
	PRINT("DEBUT TIMEOUT FILECONV");
	conv.handler_timeout_conv = gtk_timeout_add (300, fileconv_timeout, 0);
}















