 /*
 * file      : dvd_read.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "scan.h"
#include "conv.h"
#include "configuser.h"
#include "dvd.h"

/*
NAME_DVD
	TITLE 01
		AUDIO_TITLE 1
		CHAPTER 01
			AUDIO 1
				Stream id: 0x80, 0x81, 0x82, ...
				Length: hh:mm:ss.ccc
				Format: ac3, dts
				Frequency: 48000 (ac3 par defaut) pas dts
				Quantization: drc
				Channels:

			AUDIO 2
		CHAPTER 02
			AUDIO 1
			AUDIO 2
	TITLE 02
		CHAPTER 01
			AUDIO 1
			AUDIO 2



*/

typedef struct {
	gint             tst;
	gchar		*Language;
	gchar           *Lang;
	gchar		*Format;
	gint		 Frequency;
	gchar		*Quantization;
	gint		 Channels;
	gchar		*StreamId;
	gint             ValStreamId;
} DVD_AUDIO;

typedef struct {
	gchar		*Length;
} DVD_CHAPTERS;

typedef struct {
	gint             NumTitle;
	gint		 max_chapter;
	DVD_CHAPTERS    *chapters;
	gint		 max_audio;
	DVD_AUDIO       *audio;
	gchar		*length;
} DVD_TITLE;


typedef struct {
	gchar		*DiscTitle;
	gint		 LongestTrack;

	gint		 max_cells;
	gint		 max_subpictures;

	gint		 max_titles;
	DVD_TITLE       *titles;

} DVD_LIST;

DVD_LIST dvd_data = {NULL, 0,0,0,0, NULL};



void dvdread_remove_list (void)
{
	// PRINT_FUNC_LF();
	if (NULL != GlistDvd) {
		GList *list = NULL;
		VAR   *var = NULL;

		list = g_list_first (GlistDvd);
		while (list) {
			if (NULL != (var = (VAR *)list->data)) { 
				if (var->def)			{ g_free (var->def);			var->def = NULL;			}
				if (var->time)			{ g_free (var->time);			var->time = NULL;			}
				var->GUINT_TempsTotal = 0;
				if (var->name_file)		{ g_free (var->name_file);		var->name_file = NULL;			}
				if (var->StaticNameFile)	{ g_free (var->StaticNameFile);		var->StaticNameFile = NULL;		}
				if (var->StrNumerateTitle)	{ g_free (var->StrNumerateTitle);	var->StrNumerateTitle = NULL;		}
				if (var->StrNumerateChapter)	{ g_free (var->StrNumerateChapter);	var->StrNumerateChapter = NULL;		}
				if (var->StrNumberChannel)	{ g_free (var->StrNumberChannel);	var->StrNumberChannel = NULL;		}
				if (var->StrNumerateStreamId)	{ g_free (var->StrNumerateStreamId);	var->StrNumerateStreamId = NULL;	}
				g_free (var);
				var = list->data = NULL;
			}
			list = g_list_next (list);
		}
		g_list_free (GlistDvd);
		GlistDvd = NULL;
	}
}

void dvdread_create_list (TYPE_LIST_DVD type_list_dvd,
			  gchar *def,
			  gchar *time,
			  gchar *name_file,
			  gint   format_id,
			  gint   NumerateTitle,
			  gint   NumerateChapter,
			  gint   NumberChannel,
			  gchar *StrNumerateStreamId)
{
	VAR *var = g_malloc0( sizeof (VAR));

	var->type_list_dvd       = type_list_dvd;
	var->def                 = g_strdup (def ? def : "");
	
	var->time                = g_strdup (time ? time : "");
	var->GUINT_TempsTotal    = 0;
	
	if (NULL != time) {
		guint H = 0;
		guint M = 0;
		guint S = 0;
		gchar *Ptr = time;
		/*
		TIME=00:08:36
		*/
		H = atoi (Ptr);
		Ptr += 3;
		M = atoi (Ptr);
		Ptr += 3;
		S = atoi (Ptr);
		
		var->GUINT_TempsTotal = (H * 60) * 60;
		var->GUINT_TempsTotal += M * 60;
		var->GUINT_TempsTotal += S;
	}


	var->name_file           = g_strdup (name_file ? name_file : "");
	var->StaticNameFile      = g_strdup (var->name_file);
	var->format_id           = format_id;
	var->StrNumerateTitle    = g_strdup_printf ("%d", NumerateTitle);
	var->NumerateTitle       = NumerateTitle;
	var->StrNumerateChapter  = g_strdup_printf ("%d", NumerateChapter);
	var->NumerateChapter     = NumerateChapter;
	var->StrNumberChannel    = g_strdup_printf ("%d", NumberChannel);
	var->StrNumerateStreamId = g_strdup (StrNumerateStreamId ? StrNumerateStreamId : "");
	var->EtatChoix           = _COCHE_;

	var->DebutLecture        = 0;
	var->EtatNormalise       = FALSE;
	
	GlistDvd = g_list_append (GlistDvd, var);
}

void dvdread_compteur (void)
{
	GList          *list = NULL;
	gint           title_actif;
	VAR           *var = NULL;
	gint           Ch = 0;
	gint           OldChapter = 0;
	
	for (title_actif = 0; title_actif < dvd_data.max_titles; title_actif ++) {

		list = g_list_first (GlistDvd);
		while (list) {
			if (NULL != (var = (VAR *)list->data)) {
				if (var->NumerateTitle == title_actif +1) {
					if (var->NumerateChapter == 1) {
						/* Init */
						Ch = var->GUINT_TempsTotal;
					}
					else if (var->NumerateChapter > 1) {
						/* Ajout */
						
						var->DebutLecture += Ch;
						if (OldChapter == var->NumerateChapter) {
							Ch += var->GUINT_TempsTotal;
						} 
						if (OldChapter != var->NumerateChapter) OldChapter = var->NumerateChapter;
					}
				}
			}
			list = g_list_next (list);
		}
	}
}

void dvdread_create_list_with_data (void)
{
	gint           title_actif = -1;
	gint           audio_actif = -1;
	gint           chapter_actif = -1;
	gchar         *str = NULL;
	gchar         *ptr_length = NULL;
	gchar         *name_file = NULL;
	gchar         *format = NULL;
	gint           format_id = 0;

	guint          H = 0;
	guint          M = 0;
	guint          S = 0;
	gchar          *Ptr = NULL;

	dvdread_remove_list ();

	dvdread_create_list (_DVD_NAME, dvd_data.DiscTitle, NULL, NULL, 0, 0, 0, 0, NULL);

	for (title_actif = 0; title_actif < dvd_data.max_titles; title_actif ++) {

		if (title_actif +1 == dvd_data.LongestTrack) {
			str = g_strdup_printf (_("Titre [%02d <span color=\"red\"><b>**</b></span> ]"), title_actif +1);
		}
		else {
			str = g_strdup_printf (_("Titre [%02d]"), title_actif +1);
		}
		dvdread_create_list (_DVD_TITLE, str, NULL, NULL, 0, 0, 0, 0, NULL);
		g_free (str);
		str = NULL;

		if (title_actif +1 == dvd_data.LongestTrack) {

			/* PRECAUTION
			*/
			if (dvd_data.titles[ title_actif ].length == NULL) {
				g_print ("******* SORTIE UN\n");
				continue;
			}

			for (audio_actif = 0; audio_actif < dvd_data.titles[ title_actif ].max_audio; audio_actif ++) {
				if (dvd_data.titles [ title_actif ].audio [ audio_actif ].tst == 0) {

					/* PRECAUTION
					*/
					if (dvd_data.titles[ title_actif ].audio[ audio_actif ].Frequency == 0) continue;

					if (strstr (dvd_data.titles[ title_actif ].audio[ audio_actif ].Format, "dts")) {
						format = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _DTS_;
					}
					else if (strstr (dvd_data.titles[ title_actif ].audio[ audio_actif ].Format, "ac3")) {
						format = g_strdup_printf ("<span color=\"blue\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _AC3_;
					}
					else {
						format = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _INCONNU_;
					}

					str = g_strdup_printf ("Audio: [%02d] %s, <b>%s</b>, %d KHz, %s",
								audio_actif +1,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Language,
								format,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Frequency / 1000,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Quantization
								);

					name_file = g_strdup_printf (_("Fichier_complet_%02d_%s"),
							audio_actif +1, dvd_data.titles[ title_actif ].audio[ audio_actif ].Lang);
					
					Ptr = dvd_data.titles[ title_actif ].length;
					/*
					TIME=00:08:36
					*/
					H = atoi (Ptr);
					Ptr += 3;
					M = atoi (Ptr);
					Ptr += 3;
					S = atoi (Ptr);
					
					var_dvd.GUINT_TempsTotal = (H * 60) * 60;
					var_dvd.GUINT_TempsTotal += M * 60;
					var_dvd.GUINT_TempsTotal += S;


					dvdread_create_list (_DVD_DATA_ALL,
								str,
								dvd_data.titles[ title_actif ].length,
								name_file,
								format_id,
								title_actif +1,
								0,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Channels,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].StreamId);

					g_free (name_file); name_file = NULL;
					g_free (format);    format = NULL;
					g_free (str);       str = NULL;
				}
			}
		}

		/* PRECAUTION
		*/
		if (NULL == (dvd_data.titles[ title_actif ].length)) {
			g_print ("******* SORTIE DEUX\n");
			continue;
		}

		for (chapter_actif = 0; chapter_actif < dvd_data.titles[ title_actif ].max_chapter; chapter_actif ++) {

			str = g_strdup_printf (_("Chapitre: [%02d]"), chapter_actif +1);
			dvdread_create_list (_DVD_CHAPTER, str, NULL, NULL, 0, 0, 0, 0, NULL);
			g_free (str);
			str = NULL;
			
			for (audio_actif = 0; audio_actif < dvd_data.titles[ title_actif ].max_audio; audio_actif ++) {

				if (dvd_data.titles [ title_actif ].audio [ audio_actif ].tst == 0) {

					/* PRECAUTION
					*/
					if (dvd_data.titles[ title_actif ].audio[ audio_actif ].Frequency == 0) {
						g_print ("******* SORTIE TROIS\n");
						continue;
					}

					if (dvd_data.titles[ title_actif ].chapters[ chapter_actif ].Length != NULL) {
						ptr_length = dvd_data.titles[ title_actif ].chapters[ chapter_actif ].Length;
					}
					else {
						ptr_length = dvd_data.titles[ title_actif ].length;
					}


					if (strstr (dvd_data.titles[ title_actif ].audio[ audio_actif ].Format, "dts")) {
						format = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _DTS_;
					}
					else if (strstr (dvd_data.titles[ title_actif ].audio[ audio_actif ].Format, "ac3")) {
						format = g_strdup_printf ("<span color=\"blue\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _AC3_;
					}
					else {
						format = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
						format_id = _INCONNU_;
					}

					str = g_strdup_printf ("Audio: [%02d] %s, <b>%s</b>, %d KHz, %s",
								audio_actif +1,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Language,
								format,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Frequency / 1000,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Quantization
								);

					name_file = g_strdup_printf (_("Titre_%02d_Chapitre_%02d_audio_%02d_%s"),
							title_actif+1, chapter_actif+1, audio_actif+1, dvd_data.titles[ title_actif ].audio[ audio_actif ].Lang);

					dvdread_create_list (_DVD_DATA,
								str,
								ptr_length,
								name_file,
								format_id,
								title_actif +1,
								chapter_actif +1,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].Channels,
								dvd_data.titles[ title_actif ].audio[ audio_actif ].StreamId);
					g_free (name_file); name_file = NULL;
					g_free (format);    format = NULL;
					g_free (str);       str = NULL;
					ptr_length = NULL;
				}
			}
		}
	}
}

void dvdread_print_data_struct (void)
{
	gint          title_actif = -1;
	gint          chapter_actif = -1;
	gint          audio_actif = -1;

	/*PRINT_FUNC_LF();*/

	g_print ("DiscTitle:       %s\n", dvd_data.DiscTitle);
	g_print ("LongestTrack:    %d\n", dvd_data.LongestTrack);

	g_print ("max_cells:       %d\n", dvd_data.max_cells);
	g_print ("max_subpictures: %d\n", dvd_data.max_subpictures);
	g_print ("max_titles:      %d\n", dvd_data.max_titles);
	for (title_actif = 0; title_actif < dvd_data.max_titles; title_actif ++) {
		g_print ("Title: %02d\n", title_actif +1);

		g_print ("dvd_data.titles[ %02d ].length: %s\n", title_actif +1, dvd_data.titles[ title_actif ].length);

		g_print ("dvd_data.titles[ %02d ].max_chapter: %d\n", title_actif +1, dvd_data.titles[ title_actif ].max_chapter);
		for (chapter_actif = 0; chapter_actif < dvd_data.titles[ title_actif ].max_chapter; chapter_actif ++) {
			g_print ("dvd_data.titles[ %02d ].chapters[ %02d ].Length: %s\n",
					title_actif +1,
					chapter_actif +1,
					dvd_data.titles[ title_actif ].chapters[ chapter_actif ].Length);
		}

		g_print ("dvd_data.titles[ %02d ].max_audio: %d\n", title_actif +1, dvd_data.titles[ title_actif ].max_audio);
		for (audio_actif = 0; audio_actif < dvd_data.titles[ title_actif ].max_audio; audio_actif ++) {
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Language: %s\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Language);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Lang: %s\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Lang);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Format: %s\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Format);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Frequency: %d\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Frequency);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Quantization: %s\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Quantization);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].Channels: %d\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].Channels);
			g_print ("dvd_data.titles[ %02d ].audio[ %02d ].StreamId: %s\n",
				title_actif +1,
				audio_actif +1,
				dvd_data.titles[ title_actif ].audio[ audio_actif ].StreamId);
		}
	}

}

void dvdread_remove (void)
{
	gint title;
	gint audio;
	gint chapter;

	/*PRINT_FUNC_LF();*/

	for (title=0; title < dvd_data.max_titles; title ++) {

		for (audio=0; audio < dvd_data.titles[ title ].max_audio; audio ++) {
			g_free (dvd_data.titles[ title ].audio[ audio ].Language);	dvd_data.titles[ title ].audio[ audio ].Language= NULL;
			g_free (dvd_data.titles[ title ].audio[ audio ].Lang);		dvd_data.titles[ title ].audio[ audio ].Lang= NULL;
			g_free (dvd_data.titles[ title ].audio[ audio ].Format);	dvd_data.titles[ title ].audio[ audio ].Format= NULL;
			g_free (dvd_data.titles[ title ].audio[ audio ].Quantization);	dvd_data.titles[ title ].audio[ audio ].Quantization= NULL;
			g_free (dvd_data.titles[ title ].audio[ audio ].StreamId);	dvd_data.titles[ title ].audio[ audio ].StreamId= NULL;
		}
		g_free (dvd_data.titles[ title ].audio);
		dvd_data.titles[ title ].audio = NULL;

		for (chapter=0; chapter < dvd_data.titles[ title ].max_chapter; chapter ++) {
			g_free (dvd_data.titles[ title ].chapters[ chapter ].Length);
			dvd_data.titles[ title ].chapters[ chapter ].Length= NULL;
		}

		g_free (dvd_data.titles[ title ].chapters);
		dvd_data.titles[ title ].chapters = NULL;
		g_free (dvd_data.titles[ title ].length);
		dvd_data.titles[ title ].length = NULL;
	}

	g_free (dvd_data.titles);
	dvd_data.titles          = NULL;

	g_free (dvd_data.DiscTitle);
	dvd_data.DiscTitle       = NULL;
	dvd_data.LongestTrack    = 0;
	dvd_data.max_cells       = 0;
	dvd_data.max_subpictures = 0;
	dvd_data.max_titles      = 0;
}

void dvdread_create_recap_audio (void)
{
	gint          cpt;
	gchar        *LineCommand = NULL;
	FILE         *fp = NULL;
	gint          Dummy;

	// Suppression du fichier precedant si il existe
	g_unlink ("/tmp/get_infos_dvd.sh");
	g_unlink ("/tmp/infos_dvd.txt");

	fp = fopen ("/tmp/get_infos_dvd.sh", "w");

	fprintf (fp, "#!/bin/sh\n");
	fprintf (fp, "\n");
	fprintf (fp, "set -e\n");
	fprintf (fp, "\n");

	for (cpt = 0; cpt < dvd_data.max_titles; cpt ++) {

		LineCommand = g_strdup_printf ("mplayer -dvd-device %s dvd://%d -vo null -frames 0 -v 2>&1 | grep aid >> /tmp/infos_dvd.txt",
					scan_get_text_combo_cd (_DVD_), cpt +1);
		fprintf (fp, "echo \"Title:%d\" >> /tmp/infos_dvd.txt\n", cpt+1);
		fprintf (fp, "%s\n", LineCommand);
		fprintf (fp, "echo \"\" >> /tmp/infos_dvd.txt\n");
		g_free (LineCommand);
		LineCommand = NULL;
	}

	fprintf (fp, "\n");

	fclose (fp);

	Dummy = system ("chmod +x /tmp/get_infos_dvd.sh");

	Dummy = system ("/tmp/get_infos_dvd.sh");
	g_unlink ("/tmp/get_infos_dvd.sh");
}


typedef struct {
	gint   NumTitle;
	gint   NumLang;
	gchar  StrLang [ 30 ];
} LIST_AUDIO;
GList *GListAudio = NULL;

GList *dvdread_remove_ListAudio (GList *p_list)
{
	GList *list = NULL;
	LIST_AUDIO *var = NULL;
	
	list = g_list_first (GListAudio);
	while (list) {
		if (NULL != (var = (LIST_AUDIO *)list->data)) {
			g_free (var);
			var = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (GListAudio);
	GListAudio = NULL;
	return ((GList *)NULL);
}

gboolean dvdread_syncro (gint NumTitle, gint NumLang, gchar *StrLang)
{
	gint t, a;
	
	for (t=0; t < dvd_data.max_titles; t++) {
		
		if (NumTitle == dvd_data.titles [ t ].NumTitle) {
		
			for (a=0; a < dvd_data.titles [ t ].max_audio; a++) {
				if (NumLang == dvd_data.titles [ t ].audio [ a ].ValStreamId) {
					dvd_data.titles [ t ].audio [ a ].tst = 0;
					return (TRUE);
				}
			}
			return (FALSE);
		}
	}
	
	return (FALSE);
}

void dvdread_read_info_audio (void)
{
	FILE         *fp = NULL;
	size_t        size;
	gchar        *buf = NULL;
	gchar       **Larrbuf = NULL;
	gint          line;
	gchar        *ptr = NULL;
	gint          nmr_title = -1;
	gint          max_audio = 0;
	gint          t, a;

	LIST_AUDIO   *list_audio = NULL;
	GList        *list = NULL;
	
	size = libutils_get_size_file ("/tmp/infos_dvd.txt");
	buf = (gchar *)g_malloc0 (sizeof (gchar) * (size +10));
	fp = fopen ("/tmp/infos_dvd.txt", "r");
	size = fread (buf, size, 1, fp);
	fclose (fp);

	Larrbuf = g_strsplit (buf, "\n", 0);
	g_free (buf);
	buf = NULL;

	for (t=0; t <dvd_data.max_titles; t++) {
		for (a=0; a<dvd_data.titles [ t ].max_audio; a++) {
			dvd_data.titles [ t ].audio [ a ].tst = -1;
		}
	}
	
	/* TEST GLIST
	*/
	list_audio = (LIST_AUDIO *)g_malloc0 (sizeof(LIST_AUDIO));
	nmr_title = -1;
	for (line=0; Larrbuf[line]; line++) {
		if ((ptr = strstr (Larrbuf[line], "Title:"))) {
			ptr += 6;
			nmr_title = atoi (ptr);
		}
		else if ((ptr = strstr (Larrbuf[line], " aid: "))) {
			/*
			Title:3
			audio stream: 0 format: ac3 (5.1) language: en aid: 128.
			audio stream: 1 format: ac3 (5.1) language: fr aid: 129.
			audio stream: 2 format: dts (5.1) language: fr aid: 138.
			*/
			if (NULL == list_audio) list_audio = (LIST_AUDIO *)g_malloc0 (sizeof(LIST_AUDIO));
			list_audio->NumTitle = nmr_title;
			list_audio->NumLang  = (gint)atoi(ptr + 6);
			/*
			unknown
			*/
			while (*ptr != ':') ptr --;
			ptr ++;
			ptr ++;
			t = 0;
			while (*ptr != ' ') {
				list_audio->StrLang[ t ++ ] = *ptr ++;
			}
			list_audio->StrLang[ t ] = '\0';
			GListAudio = g_list_append (GListAudio, list_audio);
			list_audio = NULL;
		}
	
		if (*Larrbuf[line] == '\0') {
			nmr_title = -1;
		}
	}
	max_audio = 0;
	list = g_list_first (GListAudio);
	while (list) {
		if ((list_audio = (LIST_AUDIO *)list->data)) {
			dvdread_syncro (list_audio->NumTitle -1, list_audio->NumLang, list_audio->StrLang);
		}
		list = g_list_next (list);
	}

	if (NULL == GListAudio) {
		for (t=0; t <dvd_data.max_titles; t++) {
			for (a=0; a<dvd_data.titles [ t ].max_audio; a++) {
				dvd_data.titles [ t ].audio [ a ].tst = 0;
			}
		}
	}
	
	GListAudio = dvdread_remove_ListAudio (GListAudio);
	
	g_unlink ("/tmp/infos_dvd.txt");
	
	g_strfreev (Larrbuf);
}

gboolean dvdread_dvd_read (void)
{
	gchar       **Larrbuf = NULL;
	gchar        *ptr = NULL;
	gint          line;
	gint          cpt;
	gchar         str [ 512 ];
	gint          title_actif = -1;
	gint          audio_actif = -1;
	gint          max_audio = 1;
	gint          chapter_actif = -1;
	gint          max_chapters;
	gint          chapters_per_title;
	gchar        *buf = NULL;
	gint		pos;
	
	dvdread_remove ();

	// PRINT_FUNC_LF();

	pos = 0;
	conv.ArgConv [ pos++ ] = "nice";
	conv.ArgConv [ pos++ ] = "-n";
	conv.ArgConv [ pos++ ] = "0";
	conv.ArgConv [ pos++ ] = "lsdvd";
	conv.ArgConv [ pos++ ] = var_dvd.PathDvd;
	conv.ArgConv [ pos++ ] = "-x";
	conv.ArgConv[  pos++ ] = "2>&1";
	conv.ArgConv [ pos++ ] = NULL;
	// lsdvd_exec ();
	conv_to_convert (FALSE, LSDVD, "NEW2:-> LSDVD");
	
	if (NULL != (buf = libutils_get_datas_on_disk ())) {
		Larrbuf = g_strsplit (buf, "\n", 0);
		g_free (buf);
		buf = NULL;
	}
	else {
		PRINT("PROBLEME ALLOC BUF");
	}

	for (line = 0; Larrbuf[line]; line++) {
		if ((ptr = strstr (Larrbuf[line], "Disc Title: "))) {
			if (var_dvd.from.path != NULL && (ptr = strrchr (var_dvd.from.path, '/'))) {
					ptr ++;
			}
			else {
				ptr += 12;
			}
			dvd_data.DiscTitle = g_strdup (ptr);
		}

		if ((ptr = strstr (Larrbuf[line], "Longest track: "))) {
			ptr += 15;

			/* ALLOC */
			dvd_data.LongestTrack = atoi (ptr);
		}

		if (line > 0 && (ptr = strstr (Larrbuf[line], "Title: "))) {
				/* ALLOC */
				dvd_data.max_titles ++;
		}
	}

	dvd_data.titles = (DVD_TITLE *)g_malloc0 (sizeof (DVD_TITLE) * dvd_data.max_titles);

	// CHERCHER: le nombre coherent de chapitres
	chapters_per_title = -1;
	max_chapters = -1;
	title_actif = -1;
	for (line = 1; Larrbuf[line]; line++) {
		if ((ptr = strstr (Larrbuf[line], "Title: ")) && strstr (Larrbuf[line], "Chapters: ")) {

			title_actif ++;

			if ((ptr = strstr (Larrbuf[line], "Chapters: "))) {
				for (ptr+=10, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';

				max_chapters = atoi (str);
			}
		}
		if ((ptr=strstr (Larrbuf[line], "Chapter: ")) && strstr (Larrbuf[line], ", Length: ")) {

			for (ptr+=9, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
			str[cpt]='\0';
			chapters_per_title = atoi (str);
		}

		if (*Larrbuf[line] == '\0') {
			if (chapters_per_title > -1 && max_chapters > -1) {
				/* ALLOC */
				dvd_data.titles [ title_actif ].NumTitle = title_actif;
				dvd_data.titles [ title_actif ].chapters = (DVD_CHAPTERS *)g_malloc0 (sizeof (DVD_CHAPTERS) * (chapters_per_title));
				dvd_data.titles [ title_actif ].max_chapter = chapters_per_title;
				chapters_per_title = -1;
				max_chapters = -1;
			}
		}
	}

	// RECUPERE: tous les parametres pour chaque 'Title: xx'
	title_actif = -1;
	for (line = 1; Larrbuf[line]; line++) {

		if ((ptr = strstr (Larrbuf[line], "Title: ")) && strstr (Larrbuf[line], "Length: ")) {
			ptr += 7;
			memset (str, '\0', 500);

			title_actif ++;
			audio_actif  = -1;
			chapter_actif = -1;

			if ((ptr = strstr (Larrbuf[line], "Length: "))) {
				for (ptr+=8, cpt=0; *ptr!='.'; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles[ title_actif ].length = g_strdup (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Cells: "))) {
				for (ptr+=7, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.max_cells = atoi (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Audio streams: "))) {
				for (ptr+=15, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				max_audio = atoi (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Subpictures: "))) {
				for (ptr+=13, cpt=0; *ptr; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.max_subpictures = atoi (str);
			}

			dvd_data.titles [ title_actif ].audio = (DVD_AUDIO *)g_malloc0 (sizeof (DVD_AUDIO) * (max_audio));
			dvd_data.titles [ title_actif ].max_audio = max_audio;
		}

		if ((ptr = strstr (Larrbuf[line], "Audio: "))) {

			audio_actif ++;

			for (ptr+=7, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
			str[cpt]='\0';

			if ((ptr = strstr (Larrbuf[line], "Language: "))) {
				for (ptr+=10, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Language = g_strdup (str);
				str [ 2 ] = '\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Lang = g_strdup (str);

			}
			if ((ptr = strstr (Larrbuf[line], "Format: "))) {
				for (ptr+=8, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Format = g_strdup (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Frequency: "))) {
				for (ptr+=11, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Frequency = atoi (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Quantization: "))) {
				for (ptr+=14, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Quantization = g_strdup (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Channels: "))) {
				for (ptr+=10, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].Channels = atoi (str);
			}
			if ((ptr = strstr (Larrbuf[line], "Stream id: "))) {
				for (ptr+=11, cpt=0; *ptr; cpt++,ptr++) str[cpt]=*ptr;
				str[cpt]='\0';
				dvd_data.titles [ title_actif ].audio [ audio_actif ].StreamId    = g_strdup (str);
				dvd_data.titles [ title_actif ].audio [ audio_actif ].ValStreamId = (gint)libutils_hexa_to_int (str);
				dvd_data.titles [ title_actif ].audio [ audio_actif ].tst = 0;
			}
		}

		if ((ptr=strstr (Larrbuf[line], "Chapter: ")) && strstr (Larrbuf[line], ", Length: ")) {

			chapter_actif ++;

			for (ptr+=9, cpt=0; *ptr!=','; cpt++,ptr++) str[cpt]=*ptr;
			str[cpt]='\0';

			ptr=strstr (Larrbuf[line], ", Length: ");
			for (ptr+=10, cpt=0; *ptr!='.'; cpt++,ptr++) str[cpt]=*ptr;
			str[cpt]='\0';
			dvd_data.titles [ title_actif ].chapters [ chapter_actif ].Length = g_strdup (str);
		}
	}

	g_strfreev(Larrbuf);

	dvdread_create_recap_audio ();
	dvdread_read_info_audio ();
	dvdread_create_list_with_data ();
	dvdread_compteur ();

	return (TRUE);
}
/*
lsdvd /dev/hdd -a
Can't open disc
*/
gboolean dvdread_dvd_found (void)
{
	gchar		*buf = NULL;
	gboolean	 BoolRet = TRUE;
	gint		pos;
	
	// PRINT_FUNC_LF();
	
	pos = 0;
	conv.ArgConv [ pos++ ] = "nice";
	conv.ArgConv [ pos++ ] = "-n";
	conv.ArgConv [ pos++ ] = "0";
	conv.ArgConv [ pos++ ] = "lsdvd";
	conv.ArgConv [ pos++ ] = var_dvd.PathDvd;
	conv.ArgConv [ pos++ ] = "-x";
	conv.ArgConv[  pos++ ] = "2>&1";
	conv.ArgConv [ pos++ ] = NULL;

	conv_to_convert (FALSE, LSDVD, "NEW1:-> LSDVD");
	
	if (NULL == (buf = libutils_get_datas_on_disk ())) {
		return (FALSE);
	}
	if (NULL != buf && (*buf == '\b' || *buf == '\r' || *buf == '\n')) {
		BoolRet = FALSE;
	}
	if (NULL != buf) {
		g_free (buf);
		buf = NULL;
	}

	return (BoolRet);
}














