 /*
 * file      : cursor.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "cursor.h"

/*
*---------------------------------------------------------------------------
* TYPE DE CURSEUR SOURIS
*---------------------------------------------------------------------------
*/
static GdkCursor *_cursor = NULL;
GdkCursorType     cursor_type = GDK_LEFT_PTR;




// 
// 
void cursor_set_hand (void)
{
	if (cursor_type != GDK_HAND2) {
		cursor_type = GDK_HAND2;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_saisie (void)
{
	if (cursor_type != GDK_XTERM) {
		cursor_type = GDK_XTERM;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_gauche_droite (void)
{
	if (cursor_type != GDK_SB_H_DOUBLE_ARROW) {
		cursor_type = GDK_SB_H_DOUBLE_ARROW;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_haut (void)
{
	if (cursor_type != GDK_TOP_SIDE) {
		cursor_type = GDK_TOP_SIDE;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_bas (void)
{
	if (cursor_type != GDK_BOTTOM_SIDE) {
		cursor_type = GDK_BOTTOM_SIDE;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_gauche (void)
{
	if (cursor_type != GDK_LEFT_SIDE) {
		cursor_type = GDK_LEFT_SIDE;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_droit (void)
{
	if (cursor_type != GDK_RIGHT_SIDE) {
		cursor_type = GDK_RIGHT_SIDE;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_haut_gauche (void)
{
	if (cursor_type != GDK_TOP_LEFT_CORNER) {
		cursor_type = GDK_TOP_LEFT_CORNER;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_haut_droit (void)
{
	if (cursor_type != GDK_TOP_RIGHT_CORNER) {
		cursor_type = GDK_TOP_RIGHT_CORNER;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_bas_gauche (void)
{
	if (cursor_type != GDK_BOTTOM_LEFT_CORNER) {
		cursor_type = GDK_BOTTOM_LEFT_CORNER;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_bas_droit (void)
{
	if (cursor_type != GDK_BOTTOM_RIGHT_CORNER) {
		cursor_type = GDK_BOTTOM_RIGHT_CORNER;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_move (void)
{
	if (cursor_type != GDK_FLEUR) {
		cursor_type = GDK_FLEUR;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_old (void)
{
	if (cursor_type != GDK_LEFT_PTR) {
		cursor_type = GDK_LEFT_PTR;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
void cursor_set_watch (void)
{
	if (cursor_type != GDK_WATCH) {
		cursor_type = GDK_WATCH;
		_cursor = gdk_cursor_new (cursor_type);
		gdk_window_set_cursor (GDK_WINDOW(WindMain->window), _cursor);
		gdk_flush ();
	}
}
// 
// 
gboolean cursor_get_watch (void)
{
	return (cursor_type == GDK_WATCH ? TRUE : FALSE);
}

