 /*
 * file      : configuser.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef configuser_h
#define configuser_h 1


typedef struct {
	gint        Bitrate_type_Lame;			// Bitrate Lame
	gint        If_abr;				// SI ABR est defini
	gint        If_cbr;				// SI CBR est defini
	gint        If_vbr;				// SI VBR est defini
	gint        If_vbr_new;				// SI VBR_NEW est defini
	gint        Mode_Lame;				// Mode Lame
	gint        Bitrate_Oggenc;			// Bitrate Oggenc
	gint        Managed_Oggenc;			// Managed Oggenc
	gint        Downmix_Oggenc;			// Downmix Oggenc
} RATE_MP3OGG;

typedef struct {
	gboolean	BoolConfigOk;			// Attendre la fin de la config.: Voir main.c
	gint		WinPos_X;			// 
	gint		WinPos_Y;			// 
	gint		WinWidth;			// 
	gint		WinHeight;			// 
	gint		Nice;				// 
	gchar		*PathLoadFileAll;		// 
	gchar		*PathLoadFileWav;		// 
	gchar		*PathLoadFileMp3Ogg;		// 
	gchar		*PathLoadFileTags;		// 
	gint		TabIndiceComboDestFile[4];	// 
	gchar		*PathDestinationFileAll;	// 
	gchar		*PathDestinationFileWav;	// 
	gchar		*PathDestinationFileMp3Ogg;	// 
	gchar		*PathDestinationFileTags;	// 
	gchar		*PathDestinationDVD;		// 
	gchar		*PathChoiceFileDVD;		// 
	gchar		*PathDestinationCD;		// 
	gchar		*PathChoiceFileCD;		// 
	gchar		*PathDestinationSplit;		// 
	gchar		*PathLoadSplit;			// 
	gchar		*PathnameTMP;			// 
	gchar		*PathStockeImagesPochette;	// 
	gchar		*PathDestFilePostScript;	// 
	gchar		*PathLoadImages;		// 
	gint		NotebookGeneral;		// 
	gint		NotebookExpanderCd;		// 
	gint		NotebookFile;			// 
	gint		NotebookPochette;		// 
	gint		NotebookOptions;		// 
	gint		NotebookAppExterns;		// 
	gboolean	ReadCdByIoctl;			// TRUE = ioctl, FALSE = cdparanoia
	gint		ExtractCdWith;			// EXTRACT_WITH_CDPARANOIA = 0, EXTRACT_WITH_CDPARANOIA_EXPERT, EXTRACT_WITH_CDDA2WAV	
	
	gint		BitrateLameIndice;		// abr .. vbr_new
	gint		TabBitrateLame[4];		// [ abr | cbr | vbr | vbr_new ]
	gint		TabModeLame[4];			// [ ModeAbr | ModeCbr | ModeVbr | ModeVbrNew ]
	
	gint		BitrateOggenc;			// 
	gint		ManagedOggenc;			// 
	gint		DownmixOggenc;			// 
	
	gint		CompressionLevelFlac;		// 
	
	gint		CompressionLevelApeMac;		// 
	
	gint		CompressionWavpack;		// 
	gint		SoundWavpack;			// 
	gint		ModeHybrideWavpack;		// 
	gint		CorrectionFileWavpack;		// 
	gint		CompressionMaximumWavpack;	// 
	gint		SignatureMd5Wavpack;		// 
	gint		ExtraEncodingWavpack;		// 
	
	gint		QualityMppenc;			// 
	
	gint		ConteneurFacc;			// 
	gint		AbrVbrFacc;			// 
	gint		AbrFaccIndice;			// 
	gint		VbrFaccIndice;			// 
	
	gint		ChoiceMonoAacplusenc;		// 
	gint		ChoiceStereoAacplusenc;		// 
	
	gboolean	BoolArtistTag;			// 
	gboolean	BoolTitleTag;			// 
	gboolean	BoolAlbumTag;			// 
	gboolean	BoolNumerateTag;		// 
	gboolean	BoolGenreTag;			// 
	gboolean	BoolYearTag;			// 
	gboolean	BoolCommentTag;			// 
	gboolean	BoolEtatExpanderCd;		// 
	
	gchar		*StringExpanderLame;		// Lignes de saisie: options pour les geeks
	gchar		*StringExpanderOggenc;		// 
	gchar		*StringExpanderFlac;		// 
	gchar		*StringExpanderFaac;		// 
	gchar		*StringExpanderMppenc;		// 
	gchar		*StringExpanderMac;		// 
	gchar		*StringExpanderWavpack;		// 
	
	gint		 ServeurCddb;			// 
	gchar		*StringNameFile_m3u_xspf;	// 
	gchar		*Templates_title_cdaudio;	// Format titres cdaudio
	gchar		*Templates_rep_cdaudio;		// Dossier de sauvegarde des fichiers cdaudio
	
	gchar		*StringNameNavigateur;		// 
	gchar		*StringParamNameNavigateur;	// 
	gchar		*StringNameLecteurPostScript;	// 
	gchar		*StringNameLecteurAudio;	// 
	gchar		*StringParamNameLecteurAudio;	// 
	
	gchar		*StringBoolFieldsIsVisible;	// FIELDS DVD,CD,FILES: FALSE or HIDE = 0, TRUE or SHOW = 1
	gchar		*StringPosFieldsName;		// POS NAME OF DVD,CD,FILES: 0 = LEFT, 1 = CENTER, 2 = RIGHT
	
	gint		 NumSelectComboBoxCd;		// 
	
} VAR_CONFIG;

extern VAR_CONFIG Config;
extern VAR_CONFIG ConfigSaveToRest;

void config_read(void);
void config_save (void);
void config_remove (void);


#endif

