 /*
 * file      : configuser.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
 

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "options.h"
#include "cd_audio.h"
#include "configuser.h"


VAR_CONFIG ConfigSaveToRest;	// Pour les restitutions par defaut
VAR_CONFIG Config = {
	FALSE,		// BoolConfigOk
	0,		// WinPos_X
	0,		// WinPos_Y
	800,		// WinWidth
	520,		// WinHeight
	0,		// Nice
	NULL,		// PathLoadFileAll
	NULL,		// PathLoadFileWav
	NULL,		// PathLoadFileMp3Ogg
	NULL,		// PathLoadFileTags
	{0,0,0,0},	// TabIndiceComboDestFile
	NULL,		// PathDestinationFileAll
	NULL,		// PathDestinationFileWav
	NULL,		// PathDestinationFileMp3Ogg
	NULL,		// PathDestinationFileTags
	NULL,		// PathDestinationDVD
	NULL,		// PathChoiceFileDVD
	NULL,		// PathDestinationCD
	NULL,		// PathChoiceFileCD
	NULL,		// PathDestinationSplit
	NULL,		// PathLoadSplit
	NULL,		// PathnameTMP
	NULL,		// PathStockeImagesPochette
	NULL,		// PathDestFilePostScript
	NULL,		// PathLoadImages
	0,		// NotebookGeneral
	0,		// NotebookExpanderCd
	0,		// NotebookFile
	0,		// NotebookPochette
	0,		// NotebookOptions
	0,		// NotebookAppExterns;
	TRUE,		// ReadCdByIoctl
	0,		// ExtractCdWith = EXTRACT_WITH_CDPARANOIA = 0
	1,		// BitrateLameIndice
	{0,8,0,0},	// TabBitrateLame
	{0,0,0,0},	// TabModeLame
	15,		// BitrateOggenc
	1,		// ManagedOggenc
	1,		// DownmixOggenc
	5,		// CompressionLevelFlac
	1,		// CompressionLevelApeMac

	0,		// CompressionWavpack
	1,		// SoundWavpack
	0,		// ModeHybrideWavpack
	0,		// CorrectionFileWavpack
	0,		// CompressionMaximumWavpack
	0,		// SignatureMd5Wavpack
	0,		// ExtraEncodingWavpack
	
	5,		// QualityMppenc
	
	0,		// ConteneurFacc
	0,		// AbrVbrFacc
	0,		// AbrFaccIndice
	6,		// VbrFaccIndice
	
	7,		// ChoiceMonoAacplusenc
	4,		// ChoiceStereoAacplusenc 
	
	TRUE,		// BoolArtistTag
	TRUE,		// BoolTitleTag
	TRUE,		// BoolAlbumTag
	TRUE,		// BoolNumerateTag
	TRUE,		// BoolGenreTag
	TRUE,		// BoolYearTag
	TRUE,		// BoolCommentTag
	TRUE,		// BoolEtatExpanderCd
	
	NULL,		// StringExpanderLame		Lignes de saisie: options pour les geeks
	NULL,		// StringExpanderOggenc
	NULL,		// StringExpanderFlac
	NULL,		// StringExpanderFaac
	NULL,		// StringExpanderMppenc
	NULL,		// StringExpanderMac
	NULL,		// StringExpanderWavpack
	0,		// ServeurCddb
	NULL,		// StringNameFile_m3u_xspf
	NULL,		// Templates_title_cdaudio
	NULL,		// Templates_rep_cdaudio
	
	NULL,		// StringNameNavigateur
	NULL,		// StringParamNameNavigateur
	NULL,		// StringNameLecteurPostScript
	NULL,		// StringNameLecteurAudio
	NULL,		// StringParamNameLecteurAudio
	NULL,		// StringBoolFieldsIsVisible	FIELDS DVD,CD,FILES : FALSE or HIDE = 0, TRUE or SHOW = 1
	NULL,		// StringPosFieldsName		POS NAME OF DVD,CD,FILES: 0 = LEFT, 1 = CENTER, 2 = RIGHT
	0		// NumSelectComboBoxCd
};



// 
// 
void config_print_data (gchar *p_str)
{
	gint	len = strlen (p_str);
	g_print("%s", p_str);
	while (len < 33) {
		g_print(" ");
		len ++;
	}
	g_print("= ");
}
// RETOURNE LE NOM COMPLET DU FICHIER DE CONFIGURATION
// 
gchar *config_get_pathname (void)
{
	return ((gchar *)g_strdup_printf ("%s/%s", getenv ("HOME"), ".config/xcfa_new/xcfa.conf"));
}
// RETOURNE UNE DEFINITION DU FICHIER DE CONFIGURATION
// 
gchar *config_get_target (gchar *p_buf)
{
	gchar	*Str = NULL;
	gchar	*Ptr = NULL;
	
	if ((Ptr = strchr (p_buf, '=')) != NULL) {
		Ptr ++;
		while (*Ptr && (*Ptr != ' ' && *Ptr != '\t')) Ptr ++;
		Ptr ++;
		Str = g_strdup (Ptr);
		if ((Ptr = strchr (Str, '\r')) != NULL) *Ptr = '\0';
		if ((Ptr = strchr (Str, '\n')) != NULL) *Ptr = '\0';
	}
	return ((gchar *)Str);
}
// 
// 
gboolean config_get_bool (gchar *value)
{
	gchar *ptr = value;

	while (*ptr) {
		*ptr = toupper (*ptr);
		ptr++;
	}
	return (!strncmp (value, "TRUE", strlen ("TRUE")) ? TRUE : FALSE);
}
// LECTURE ET AFFECTATION
// 
gboolean config_read_value_str (gchar *p_Buf, gchar *p_Search, gchar **p_ValueStr)
{
	gchar	*Ptr = NULL;
	if (libutils_new_strcmp (p_Buf, p_Search) == TRUE) {
		if ((Ptr = config_get_target (p_Buf)) != NULL) {
			*p_ValueStr = g_strdup (Ptr);
			g_free (Ptr);
			Ptr = NULL;
			config_print_data (p_Search);
			g_print("%s\n",*p_ValueStr ? *p_ValueStr : "");
			return (TRUE);	
		}
	}
	return (FALSE);	
}
// 
// 
gboolean config_read_value_bool (gchar *p_Buf, gchar *p_Search, gboolean *p_ValueBool)
{	
	gchar	*Ptr = NULL;
	if (libutils_new_strcmp (p_Buf, p_Search) == TRUE) {
		if ((Ptr = config_get_target (p_Buf)) != NULL) {
			*p_ValueBool = config_get_bool (Ptr);
			g_free (Ptr);
			Ptr = NULL;
			config_print_data (p_Search);
			g_print("%s\n",*p_ValueBool ? "TRUE" : "FALSE");
			return (TRUE);	
		}
	}
	return (FALSE);	
}
// 
// 
gboolean config_read_value_atoi (gchar *p_Buf, gchar *p_Search, gint *p_ValueAtoi, gint p_Min, gint p_Max)
{
	gchar	*Ptr = NULL;
	if (libutils_new_strcmp (p_Buf, p_Search) == TRUE) {
		if ((Ptr = config_get_target (p_Buf)) != NULL) {
			*p_ValueAtoi = atoi (Ptr);
			g_free (Ptr);
			Ptr = NULL;
			if (p_Min > -1 && *p_ValueAtoi < p_Min) *p_ValueAtoi = p_Min;
			if (p_Max > -1 && *p_ValueAtoi > p_Max) *p_ValueAtoi = p_Max;
			config_print_data (p_Search);
			g_print("%d\n",*p_ValueAtoi);
			return (TRUE);
		}
	}
	return (FALSE);	
}
// 
// 
gboolean config_read_value_path (gchar *p_Buf, gchar *p_Search, gchar **p_ValuePath, gchar *p_default)
{
	gchar	*Ptr = NULL;
	if (libutils_new_strcmp (p_Buf, p_Search) == TRUE) {
		if ((Ptr = config_get_target (p_Buf)) != NULL) {
			if (libutils_test_dir_exist (Ptr) == TRUE) {
				*p_ValuePath = Ptr;
			} else {
				if (NULL == p_default)	*p_ValuePath = g_strdup (getenv ("HOME"));
				else			*p_ValuePath = g_strdup (p_default);
				g_free (Ptr);
				Ptr = NULL;
			}
		}
		else {
			if (NULL == p_default)	*p_ValuePath = g_strdup (getenv ("HOME"));
			else			*p_ValuePath = g_strdup (p_default);
		}
		config_print_data (p_Search);
		g_print("%s\n",*p_ValuePath);
		return (TRUE);
	}
	return (FALSE);	
}
// 
// 
void config_verif_path (gchar **p_ValuePath, gchar *p_default)
{
	if (NULL == *p_ValuePath) {
		if (NULL == p_default)	*p_ValuePath = g_strdup (getenv ("HOME"));
		else			*p_ValuePath = g_strdup (p_default);
	}
}
// LECTURE DU FICHIER DE CONFIGURATION
// 
void config_read (void)
{
	gchar	*PathNameConfig = config_get_pathname ();
	FILE	*fp;
#define MAX_CARS 255
	gchar	 buf   [ MAX_CARS +1 ];
	
	// Pour les restitutions par defaut
	g_memmove (&ConfigSaveToRest, &Config, sizeof (VAR_CONFIG));
	
	g_print ("\n------------------------------------------------------------------------\n");
	g_print ("%s\n", PathNameConfig);
	g_print ("------------------------------------------------------------------------\n");
	if (libutils_test_file_exist (PathNameConfig) == FALSE) {
		
		gchar	*StrDir = g_strdup (PathNameConfig);
		gchar	*Ptr = strrchr (StrDir, '/');
		
		Ptr ++;
		*Ptr = '\0';
		g_mkdir_with_parents (StrDir, 0700);
		g_free (StrDir);
		StrDir = Ptr = NULL;
		
		config_save ();
	}
	
	fp = fopen (PathNameConfig, "r");
	while (fgets (buf, MAX_CARS, fp) != NULL) {
		
		// Si commentaire ou ligne vide alors ligne suivante
		if (buf[0] == '#' || buf[0] == '\n') continue;
		
		// READ ATOI
		// 
		if (FALSE == config_read_value_atoi (buf, "WIN_POS_X",				&Config.WinPos_X,       		 0,	-1))
		if (FALSE == config_read_value_atoi (buf, "WIN_POS_Y",				&Config.WinPos_Y,       		 0,	-1))
		if (FALSE == config_read_value_atoi (buf, "WIN_WIDTH",				&Config.WinWidth,        		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "WIN_HEIGHT",				&Config.WinHeight,       		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NICE",				&Config.Nice,            		 0,	19))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_GENERAL",			&Config.NotebookGeneral, 		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_EXPANDER_CD",		&Config.NotebookExpanderCd,		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_FILE",			&Config.NotebookFile,			-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_POCHETTE",			&Config.NotebookPochette,		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_OPTIONS",			&Config.NotebookOptions,  		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "NOTEBOOK_APP_EXTERNS",		&Config.NotebookAppExterns,  		-1,	-1))
		if (FALSE == config_read_value_atoi (buf, "EXTRACT_CD_WITH",			&Config.ExtractCdWith,    		EXTRACT_WITH_CDPARANOIA,  EXTRACT_WITH_CDDA2WAV))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_BITRATE_LAME",		&Config.BitrateLameIndice,		0,	3))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_VALUE_ABR_LAME",   		&Config.TabBitrateLame[0],		0,	13))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_VALUE_CBR_LAME",   		&Config.TabBitrateLame[1],		0,	14))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_VALUE_VBR_LAME",   		&Config.TabBitrateLame[2],		0,	14))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_VALUE_VBR_NEW_LAME",		&Config.TabBitrateLame[3],		0,	15))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MODE_ABR_LAME",   		&Config.TabModeLame[0],			0,	13))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MODE_CBR_LAME",   		&Config.TabModeLame[1],			0,	14))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MODE_VBR_LAME",   		&Config.TabModeLame[2],			0,	14))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MODE_VBR_NEW_LAME",		&Config.TabModeLame[3],			0,	15))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_BITRATE_OGGENC",		&Config.BitrateOggenc,			0,	22))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MANAGED_OGGENC",		&Config.ManagedOggenc,			0,	1))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_DOWNMIX_OGGENC",		&Config.DownmixOggenc,			0,	1))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_LEVEL_FLAC",			&Config.CompressionLevelFlac,		0,	8))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_LEVEL_APE_MAC",		&Config.CompressionLevelApeMac,		0,	4))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_COMPRESSION_WAVPACK",	&Config.CompressionWavpack,		0,	3))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_SOUND_WAVPACK",		&Config.SoundWavpack,			0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_MODE_HYBRIDE_WAVPACK",	&Config.ModeHybrideWavpack,		0,	4))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_CORRECTION_WAVPACK",		&Config.CorrectionFileWavpack,		0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_COMPRESSION_MAXI_WAVPACK",	&Config.CompressionMaximumWavpack,	0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_SIGNATURE_WAVPACK",		&Config.SignatureMd5Wavpack,		0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_EXTRA_ENCODING_WAVPACK",	&Config.ExtraEncodingWavpack,		0,	6))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_QUALITY_MPPENC",		&Config.QualityMppenc,			0,	6))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_CONTENEUR_FAAC",		&Config.ConteneurFacc,			0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_ABRVBR_FAAC",		&Config.AbrVbrFacc,			0,	2))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_ABR_INDICE_FAAC",		&Config.AbrFaccIndice,			0,	5))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_VBR_INDICE_FAAC",		&Config.VbrFaccIndice,			0,	13))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_CHOICE_MONO_AACPLUSENC",	&Config.ChoiceMonoAacplusenc,		0,	7))
		if (FALSE == config_read_value_atoi (buf, "OPTIONS_CHOICE_STEREO_AACPLUSENC",	&Config.ChoiceStereoAacplusenc,		0,	4))
		if (FALSE == config_read_value_atoi (buf, "IND_COMBO_DEST_FILE_ALL",		&Config.TabIndiceComboDestFile[0],	0,	2))
		if (FALSE == config_read_value_atoi (buf, "IND_COMBO_DEST_FILE_WAV",		&Config.TabIndiceComboDestFile[1],	0,	2))
		if (FALSE == config_read_value_atoi (buf, "IND_COMBO_DEST_FILE_MP3OGG",		&Config.TabIndiceComboDestFile[2],	0,	2))
		if (FALSE == config_read_value_atoi (buf, "IND_COMBO_DEST_FILE_TAGS",		&Config.TabIndiceComboDestFile[3],	0,	2))
		if (FALSE == config_read_value_atoi (buf, "SERVER_FREE_CDDB",			&Config.ServeurCddb,			0,	1))
		if (FALSE == config_read_value_atoi (buf, "NUM_SELECT_COMBOBOX_CD",		&Config.NumSelectComboBoxCd,		0,	10))
		
		// READ BOOL
		// 
		if (FALSE == config_read_value_bool (buf, "READ_CD_BY_IOCTL",			&Config.ReadCdByIoctl))
		if (FALSE == config_read_value_bool (buf, "TAGS_ARTISTE",			&Config.BoolArtistTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_TITLE",				&Config.BoolTitleTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_ALBUM",				&Config.BoolAlbumTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_NUMERATE",			&Config.BoolNumerateTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_GENRE",				&Config.BoolGenreTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_YEAR",				&Config.BoolYearTag))
		if (FALSE == config_read_value_bool (buf, "TAGS_COMMENT",			&Config.BoolCommentTag))
		if (FALSE == config_read_value_bool (buf, "BOOL_ETAT_EXPANDER_CD",		&Config.BoolEtatExpanderCd))
		
		// READ PATH
		// 
		if (FALSE == config_read_value_path (buf, "PATH_DEST_FILE_ALL",			&Config.PathDestinationFileAll,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_FILE_WAV",			&Config.PathDestinationFileWav,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_FILE_MP3OGG",		&Config.PathDestinationFileMp3Ogg,	NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_FILE_TAGS",		&Config.PathDestinationFileTags,	NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_DVD",			&Config.PathDestinationDVD,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_CHOICE_FILE_DVD",		&Config.PathChoiceFileDVD,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_CD",			&Config.PathDestinationCD,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_CHOICE_FILE_CD",		&Config.PathChoiceFileCD,		NULL))
		if (FALSE == config_read_value_path (buf, "PATHNAME_TMP",			&Config.PathnameTMP,			"/tmp"))
		if (FALSE == config_read_value_path (buf, "PATHNAME_STOCKE_IMAGES_POCHETTE",	&Config.PathStockeImagesPochette,	NULL))
		if (FALSE == config_read_value_path (buf, "PATHNAME_DEST_FILE_POSTSCRIPT",	&Config.PathDestFilePostScript,		NULL))
		if (FALSE == config_read_value_path (buf, "PATHNAME_LOAD_IMAGES",		&Config.PathLoadImages,			NULL))
		if (FALSE == config_read_value_path (buf, "PATH_LOAD_FILE_ALL",			&Config.PathLoadFileAll,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_LOAD_FILE_WAV",			&Config.PathLoadFileWav,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_LOAD_FILE_MP3OGG",		&Config.PathLoadFileMp3Ogg,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_LOAD_FILE_TAGS",		&Config.PathLoadFileTags,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_DEST_SPLIT",			&Config.PathDestinationSplit,		NULL))
		if (FALSE == config_read_value_path (buf, "PATH_LOAD_SPLIT",			&Config.PathLoadSplit,			NULL))

		// READ STRING
		// 
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_LAME",		&Config.StringExpanderLame))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_OGGENC",		&Config.StringExpanderOggenc))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_FLAC",		&Config.StringExpanderFlac))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_FAAC",		&Config.StringExpanderFaac))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_MPPENC",		&Config.StringExpanderMppenc))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_MAC",			&Config.StringExpanderMac))
		if (FALSE == config_read_value_str (buf, "STRING_EXPANDER_WAVPACK",		&Config.StringExpanderWavpack))
		if (FALSE == config_read_value_str (buf, "STRING_NAME_FILE_M3U_XSPF",		&Config.StringNameFile_m3u_xspf))
		if (FALSE == config_read_value_str (buf, "TEMPLATE_TITLE_CDAUDIO",		&Config.Templates_title_cdaudio))
		if (FALSE == config_read_value_str (buf, "TEMPLATE_REP_CDAUDIO",		&Config.Templates_rep_cdaudio))
		if (FALSE == config_read_value_str (buf, "STRING_NAME_NAVIGATEUR",		&Config.StringNameNavigateur))
		if (FALSE == config_read_value_str (buf, "STRING_PARAM_NAME_NAVIGATEUR",	&Config.StringParamNameNavigateur))
		if (FALSE == config_read_value_str (buf, "STRING_NAME_LECTEUR_POSTSCRIPT",	&Config.StringNameLecteurPostScript))
		if (FALSE == config_read_value_str (buf, "STRING_NAME_LECTEUR_AUDIO",		&Config.StringNameLecteurAudio))
		if (FALSE == config_read_value_str (buf, "STRING_PARAM_NAME_LECTEUR_AUDIO",	&Config.StringParamNameLecteurAudio))
		if (FALSE == config_read_value_str (buf, "STRING_BOOL_FIELD_IS_VISIBLE",	&Config.StringBoolFieldsIsVisible))
		if (FALSE == config_read_value_str (buf, "STRING_POS_FIELD_IS_NAME",		&Config.StringPosFieldsName));
		buf [ 0 ] = '\0';
	}
	fclose (fp);
	
	config_verif_path (&Config.PathDestinationFileAll,	NULL);
	config_verif_path (&Config.PathDestinationFileWav,	NULL);
	config_verif_path (&Config.PathDestinationFileMp3Ogg,	NULL);
	config_verif_path (&Config.PathDestinationFileTags,	NULL);
	config_verif_path (&Config.PathDestinationDVD,		NULL);
	config_verif_path (&Config.PathChoiceFileDVD,		NULL);
	config_verif_path (&Config.PathDestinationCD,		NULL);
	config_verif_path (&Config.PathChoiceFileCD,		NULL);
	config_verif_path (&Config.PathnameTMP,			"/tmp");
	config_verif_path (&Config.PathStockeImagesPochette,	NULL);
	config_verif_path (&Config.PathDestFilePostScript,	NULL);
	config_verif_path (&Config.PathLoadImages,		NULL);
	config_verif_path (&Config.PathLoadFileAll,		NULL);
	config_verif_path (&Config.PathLoadFileWav,		NULL);
	config_verif_path (&Config.PathLoadFileMp3Ogg,		NULL);
	config_verif_path (&Config.PathLoadFileTags,		NULL);
	config_verif_path (&Config.PathDestinationSplit,	NULL);
	config_verif_path (&Config.PathLoadSplit,		NULL);

}
//  SAUVEGARDE DU FICHIER DE CONFIGURATION
// 
void config_save (void)
{
	gchar	*PathNameConfig = config_get_pathname ();
	FILE	*fp;
	gchar	*Ptr = NULL;
	
	if (NULL != (fp = fopen (PathNameConfig, "w"))) {
		fprintf (fp,   "############################################################################\n");
		fprintf (fp,   "## Fichier de configuration pour : %s\n", PACKAGE_STRING);
		fprintf (fp,   "##--------------------------------------------------------------------------\n");
		fprintf (fp,   "## File of configuration to : %s\n", PACKAGE_STRING);
		fprintf (fp,   "############################################################################\n");
		
		fprintf (fp, "\n");
		fprintf (fp, "WIN_POS_X                           = %d\n", Config.WinPos_X);
		fprintf (fp, "WIN_POS_Y                           = %d\n", Config.WinPos_Y);
		fprintf (fp, "WIN_WIDTH                           = %d\n", Config.WinWidth);
		fprintf (fp, "WIN_HEIGHT                          = %d\n", Config.WinHeight);
		fprintf (fp, "NICE                                = %d\n", Config.Nice);
		
		fprintf (fp, "IND_COMBO_DEST_FILE_ALL             = %d\n", Config.TabIndiceComboDestFile[0]);
		fprintf (fp, "IND_COMBO_DEST_FILE_WAV             = %d\n", Config.TabIndiceComboDestFile[1]);
		fprintf (fp, "IND_COMBO_DEST_FILE_MP3OGG          = %d\n", Config.TabIndiceComboDestFile[2]);
		fprintf (fp, "IND_COMBO_DEST_FILE_TAGS            = %d\n", Config.TabIndiceComboDestFile[3]);
		
		fprintf (fp, "PATH_LOAD_FILE_ALL                  = %s\n", Config.PathLoadFileAll != NULL ? Config.PathLoadFileAll : "");
		fprintf (fp, "PATH_LOAD_FILE_WAV                  = %s\n", Config.PathLoadFileWav != NULL ? Config.PathLoadFileWav : "");
		fprintf (fp, "PATH_LOAD_FILE_MP3OGG               = %s\n", Config.PathLoadFileMp3Ogg != NULL ? Config.PathLoadFileMp3Ogg : "");
		fprintf (fp, "PATH_LOAD_FILE_TAGS                 = %s\n", Config.PathLoadFileTags != NULL ? Config.PathLoadFileTags : "");
		
		fprintf (fp, "PATH_DEST_FILE_ALL                  = %s\n", Config.PathDestinationFileAll != NULL ? Config.PathDestinationFileAll : "");
		fprintf (fp, "PATH_DEST_FILE_WAV                  = %s\n", Config.PathDestinationFileWav != NULL ? Config.PathDestinationFileWav : "");
		fprintf (fp, "PATH_DEST_FILE_MP3OGG               = %s\n", Config.PathDestinationFileMp3Ogg != NULL ? Config.PathDestinationFileMp3Ogg : "");
		fprintf (fp, "PATH_DEST_FILE_TAGS                 = %s\n", Config.PathDestinationFileTags != NULL ? Config.PathDestinationFileTags : "");
		fprintf (fp, "PATH_DEST_DVD                       = %s\n", Config.PathDestinationDVD != NULL ? Config.PathDestinationDVD : "");
		fprintf (fp, "PATH_CHOICE_FILE_DVD                = %s\n", Config.PathChoiceFileDVD != NULL ? Config.PathChoiceFileDVD : "");
		fprintf (fp, "PATH_DEST_CD                        = %s\n", Config.PathDestinationCD != NULL ? Config.PathDestinationCD : "");
		fprintf (fp, "PATH_CHOICE_FILE_CD                 = %s\n", Config.PathChoiceFileCD != NULL ? Config.PathChoiceFileCD : "");
		fprintf (fp, "PATH_DEST_SPLIT                     = %s\n", Config.PathDestinationSplit != NULL ? Config.PathDestinationSplit : "");
		fprintf (fp, "PATH_LOAD_SPLIT                     = %s\n", Config.PathLoadSplit != NULL ? Config.PathLoadSplit : "");
		
		fprintf (fp, "PATHNAME_TMP                        = %s\n", Config.PathnameTMP != NULL ? Config.PathnameTMP : "");
		fprintf (fp, "PATHNAME_STOCKE_IMAGES_POCHETTE     = %s\n", Config.PathStockeImagesPochette != NULL ? Config.PathStockeImagesPochette : "");
		fprintf (fp, "PATHNAME_DEST_FILE_POSTSCRIPT       = %s\n", Config.PathDestFilePostScript != NULL ? Config.PathDestFilePostScript : "");
		fprintf (fp, "PATHNAME_LOAD_IMAGES                = %s\n", Config.PathLoadImages != NULL ? Config.PathLoadImages : "");
		fprintf (fp, "NOTEBOOK_GENERAL                    = %d\n", Config.NotebookGeneral);
		fprintf (fp, "NOTEBOOK_EXPANDER_CD                = %d\n", Config.NotebookExpanderCd);
		fprintf (fp, "NOTEBOOK_FILE                       = %d\n", Config.NotebookFile);
		fprintf (fp, "NOTEBOOK_POCHETTE                   = %d\n", Config.NotebookPochette);
		fprintf (fp, "NOTEBOOK_OPTIONS                    = %d\n", Config.NotebookOptions);
		fprintf (fp, "NOTEBOOK_APP_EXTERNS                = %d\n", Config.NotebookAppExterns);
		fprintf (fp, "READ_CD_BY_IOCTL                    = %s\n", Config.ReadCdByIoctl == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "EXTRACT_CD_WITH                     = %d\n", Config.ExtractCdWith);
		
		fprintf (fp, "OPTIONS_BITRATE_LAME                = %d\n", Config.BitrateLameIndice);
		fprintf (fp, "OPTIONS_VALUE_ABR_LAME              = %d\n", Config.TabBitrateLame[0]);
		fprintf (fp, "OPTIONS_VALUE_CBR_LAME              = %d\n", Config.TabBitrateLame[1]);
		fprintf (fp, "OPTIONS_VALUE_VBR_LAME              = %d\n", Config.TabBitrateLame[2]);
		fprintf (fp, "OPTIONS_VALUE_VBR_NEW_LAME          = %d\n", Config.TabBitrateLame[3]);
		fprintf (fp, "OPTIONS_MODE_ABR_LAME               = %d\n", Config.TabModeLame[0]);
		fprintf (fp, "OPTIONS_MODE_CBR_LAME               = %d\n", Config.TabModeLame[1]);
		fprintf (fp, "OPTIONS_MODE_VBR_LAME               = %d\n", Config.TabModeLame[2]);
		fprintf (fp, "OPTIONS_MODE_VBR_NEW_LAME           = %d\n", Config.TabModeLame[3]);
		
		fprintf (fp, "OPTIONS_BITRATE_OGGENC              = %d\n", Config.BitrateOggenc);
		fprintf (fp, "OPTIONS_MANAGED_OGGENC              = %d\n", Config.ManagedOggenc);
		fprintf (fp, "OPTIONS_DOWNMIX_OGGENC              = %d\n", Config.DownmixOggenc);
		
		fprintf (fp, "OPTIONS_LEVEL_FLAC                  = %d\n", Config.CompressionLevelFlac);
		
		fprintf (fp, "OPTIONS_LEVEL_APE_MAC               = %d\n", Config.CompressionLevelApeMac);
		
		fprintf (fp, "OPTIONS_COMPRESSION_WAVPACK         = %d\n", Config.CompressionWavpack);
		fprintf (fp, "OPTIONS_SOUND_WAVPACK               = %d\n", Config.SoundWavpack);
		fprintf (fp, "OPTIONS_MODE_HYBRIDE_WAVPACK        = %d\n", Config.ModeHybrideWavpack);
		fprintf (fp, "OPTIONS_CORRECTION_WAVPACK          = %d\n", Config.CorrectionFileWavpack);
		fprintf (fp, "OPTIONS_COMPRESSION_MAXI_WAVPACK    = %d\n", Config.CompressionMaximumWavpack);
		fprintf (fp, "OPTIONS_SIGNATURE_WAVPACK           = %d\n", Config.SignatureMd5Wavpack);
		fprintf (fp, "OPTIONS_EXTRA_ENCODING_WAVPACK      = %d\n", Config.ExtraEncodingWavpack);
		
		fprintf (fp, "OPTIONS_QUALITY_MPPENC              = %d\n", Config.QualityMppenc);
		
		fprintf (fp, "OPTIONS_CONTENEUR_FAAC              = %d\n", Config.ConteneurFacc);
		fprintf (fp, "OPTIONS_ABRVBR_FAAC                 = %d\n", Config.AbrVbrFacc);
		fprintf (fp, "OPTIONS_ABR_INDICE_FAAC             = %d\n", Config.AbrFaccIndice);
		fprintf (fp, "OPTIONS_VBR_INDICE_FAAC             = %d\n", Config.VbrFaccIndice);
		
		fprintf (fp, "OPTIONS_CHOICE_MONO_AACPLUSENC      = %d\n", Config.ChoiceMonoAacplusenc);
		fprintf (fp, "OPTIONS_CHOICE_STEREO_AACPLUSENC    = %d\n", Config.ChoiceStereoAacplusenc);
		
		fprintf (fp, "TAGS_ARTISTE                        = %s\n", Config.BoolArtistTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_TITLE                          = %s\n", Config.BoolTitleTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_ALBUM                          = %s\n", Config.BoolAlbumTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_NUMERATE                       = %s\n", Config.BoolNumerateTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_GENRE                          = %s\n", Config.BoolGenreTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_YEAR                           = %s\n", Config.BoolYearTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "TAGS_COMMENT                        = %s\n", Config.BoolCommentTag == TRUE ? "TRUE" : "FALSE");
		fprintf (fp, "BOOL_ETAT_EXPANDER_CD               = %s\n", Config.BoolEtatExpanderCd == TRUE ? "TRUE" : "FALSE");
		
		fprintf (fp, "STRING_EXPANDER_LAME                = %s\n", Config.StringExpanderLame ? Config.StringExpanderLame : "");
		fprintf (fp, "STRING_EXPANDER_OGGENC              = %s\n", Config.StringExpanderOggenc ? Config.StringExpanderOggenc : "");
		fprintf (fp, "STRING_EXPANDER_FLAC                = %s\n", Config.StringExpanderFlac ? Config.StringExpanderFlac : "");
		fprintf (fp, "STRING_EXPANDER_FAAC                = %s\n", Config.StringExpanderFaac ? Config.StringExpanderFaac : "");
		fprintf (fp, "STRING_EXPANDER_MPPENC              = %s\n", Config.StringExpanderMppenc ? Config.StringExpanderMppenc : "");
		fprintf (fp, "STRING_EXPANDER_MAC                 = %s\n", Config.StringExpanderMac ? Config.StringExpanderMac : "");
		fprintf (fp, "STRING_EXPANDER_WAVPACK             = %s\n", Config.StringExpanderWavpack ? Config.StringExpanderWavpack : "");
		
		fprintf (fp, "SERVER_FREE_CDDB                    = %d\n", Config.ServeurCddb);
		
		fprintf (fp, "STRING_NAME_FILE_M3U_XSPF           = %s\n", Config.StringNameFile_m3u_xspf ? Config.StringNameFile_m3u_xspf : "");
		fprintf (fp, "TEMPLATE_TITLE_CDAUDIO              = ");
		Ptr = Config.Templates_title_cdaudio;
		if (Ptr == NULL) {
			fprintf (fp, "%%c %%d");
		}
		else {
			while (Ptr && *Ptr) {
				if (*Ptr == '%')	fprintf (fp, "%%");
				else			fprintf (fp, "%c", *Ptr);
				Ptr++;
			}
		}
		fprintf (fp,   "\n");
		fprintf (fp, "TEMPLATE_REP_CDAUDIO                = ");
		Ptr = Config.Templates_rep_cdaudio;
		if (Ptr == NULL) {
			fprintf (fp, "%%b");
		}
		else {
			while (Ptr && *Ptr) {
				if (*Ptr == '%')	fprintf (fp, "%%");
				else			fprintf (fp, "%c", *Ptr);
				Ptr++;
			}
		}
		fprintf (fp, "\n");

		fprintf (fp, "STRING_NAME_NAVIGATEUR              = %s\n", Config.StringNameNavigateur ? Config.StringNameNavigateur : "");
		fprintf (fp, "STRING_PARAM_NAME_NAVIGATEUR        = %s\n", Config.StringParamNameNavigateur ? Config.StringParamNameNavigateur : "");
		fprintf (fp, "STRING_NAME_LECTEUR_POSTSCRIPT      = %s\n", Config.StringNameLecteurPostScript ? Config.StringNameLecteurPostScript : "");
		fprintf (fp, "STRING_NAME_LECTEUR_AUDIO           = %s\n", Config.StringNameLecteurAudio ? Config.StringNameLecteurAudio : "");
		fprintf (fp, "STRING_PARAM_NAME_LECTEUR_AUDIO     = %s\n", Config.StringParamNameLecteurAudio ? Config.StringParamNameLecteurAudio : "");
		fprintf (fp, "STRING_BOOL_FIELD_IS_VISIBLE        = %s\n", Config.StringBoolFieldsIsVisible ? Config.StringBoolFieldsIsVisible : "");
		fprintf (fp, "STRING_POS_FIELD_IS_NAME            = %s\n", Config.StringPosFieldsName ? Config.StringPosFieldsName : "");
		
		fprintf (fp, "NUM_SELECT_COMBOBOX_CD              = %d\n", Config.NumSelectComboBoxCd);
		
		fprintf (fp, "\n");
		fclose (fp);
	}
}
// LIBERATION MEMOIRE
// 
void config_remove (void)
{	
	g_free (Config.PathLoadFileAll);		Config.PathLoadFileAll = NULL;
	g_free (Config.PathLoadFileWav);		Config.PathLoadFileWav = NULL;
	g_free (Config.PathLoadFileMp3Ogg);		Config.PathLoadFileMp3Ogg = NULL;
	g_free (Config.PathLoadFileTags);		Config.PathLoadFileTags = NULL;
	g_free (Config.PathDestinationFileAll);		Config.PathDestinationFileAll = NULL;
	g_free (Config.PathDestinationFileWav);		Config.PathDestinationFileWav = NULL;
	g_free (Config.PathDestinationFileMp3Ogg);	Config.PathDestinationFileMp3Ogg = NULL;
	g_free (Config.PathDestinationFileTags);	Config.PathDestinationFileTags = NULL;
	g_free (Config.PathDestinationDVD);		Config.PathDestinationDVD = NULL;
	g_free (Config.PathChoiceFileDVD);		Config.PathChoiceFileDVD = NULL;
	g_free (Config.PathDestinationCD);		Config.PathDestinationCD = NULL;
	g_free (Config.PathChoiceFileCD);		Config.PathChoiceFileCD = NULL;
	g_free (Config.PathDestinationSplit);		Config.PathDestinationSplit = NULL;
	g_free (Config.PathLoadSplit);			Config.PathLoadSplit = NULL;
	g_free (Config.PathnameTMP);			Config.PathnameTMP = NULL;
	g_free (Config.PathStockeImagesPochette);	Config.PathStockeImagesPochette = NULL;
	g_free (Config.PathDestFilePostScript);		Config.PathDestFilePostScript = NULL;
	g_free (Config.PathLoadImages);			Config.PathLoadImages = NULL;
	g_free (Config.StringExpanderLame);		Config.StringExpanderLame = NULL;
	g_free (Config.StringExpanderOggenc);		Config.StringExpanderOggenc = NULL;
	g_free (Config.StringExpanderFlac);		Config.StringExpanderFlac = NULL;
	g_free (Config.StringExpanderFaac);		Config.StringExpanderFaac = NULL;
	g_free (Config.StringExpanderMppenc);		Config.StringExpanderMppenc = NULL;
	g_free (Config.StringExpanderMac);		Config.StringExpanderMac = NULL;
	g_free (Config.StringExpanderWavpack);		Config.StringExpanderWavpack = NULL;
	g_free (Config.StringNameFile_m3u_xspf);	Config.StringNameFile_m3u_xspf = NULL;
	g_free (Config.Templates_title_cdaudio);	Config.Templates_title_cdaudio = NULL;
	g_free (Config.Templates_rep_cdaudio);		Config.Templates_rep_cdaudio = NULL;
	g_free (Config.StringNameNavigateur);		Config.StringNameNavigateur = NULL;
	g_free (Config.StringParamNameNavigateur);	Config.StringParamNameNavigateur = NULL;
	g_free (Config.StringNameLecteurPostScript);	Config.StringNameLecteurPostScript = NULL;
	g_free (Config.StringNameLecteurAudio);		Config.StringNameLecteurAudio = NULL;
	g_free (Config.StringParamNameLecteurAudio);	Config.StringParamNameLecteurAudio = NULL;
	g_free (Config.StringBoolFieldsIsVisible);	Config.StringBoolFieldsIsVisible = NULL;
	g_free (Config.StringPosFieldsName);		Config.StringPosFieldsName = NULL;
}

