 /*
 * file      : cd_audio_toc.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "file.h"
#include "cd_audio_extract.h"
#include "configuser.h"
#include "scan.h"
#include "cdtoc.h"
#include "cd_cue.h"
#include "win_info.h"
#include "win_scan.h"
#include "cd_audio.h"




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/



/* Activation du thread de lecture du catalogue du cd-audio et
*  des datas WEB si l'utilisateur est connecte
*  --
*  entree : -
*  retour : -
*/
void *cdaudiotoc_thread_do_read_toc_cd (void *data)
{
	var_cd.bool_thread_read_toc_cd = TRUE;
	EnteteCD.GList_Audio_cd = (GList *)cdtoc_read ();
	var_cd.bool_thread_read_toc_cd = FALSE;
	pthread_exit (0);
}
/* Mise a jour des informations du cd-audio
*  --
*  entree :
*      gpointer data :
*  retour :
*      TRUE
*/
static gint cdaudiotoc_timeout_do_read_toc_cd (gpointer data)
{
	if (var_cd.bool_thread_read_toc_cd == FALSE) {

		// FIN du timeout Update_cdaudio_do_read_toc_cd
		gtk_timeout_remove (var_cd.handler_timeout_read_toc_cd);

		cdaudio_put_label_duree ("");
		cdaudio_put_label_titre ("");
		if (EnteteCD.Bool_Read_Infos_cd == TRUE) {
			if (EnteteCD.GList_Audio_cd != NULL) {
				cdaudio_affiche_glist_audio ();
				cdaudio_set_flag_buttons ();
				cdaudio_put_label_duree (EnteteCD.Duree_cd);
				cdaudio_put_label_titre (EnteteCD.TitleCD);

				cdaudio_entry_stockage_cdaudio_changed ();

				/* TO DEBUG : A VERIFIER DES QUE CONNECTION WEB EST OK

				g_print ("\n");
				g_print ("EnteteCD.TitleCD            : %s\n", EnteteCD.TitleCD);
				g_print ("EnteteCD.Title              : %s\n", EnteteCD.Title);
				g_print ("EnteteCD.Artiste            : %s\n", EnteteCD.Artiste);
				g_print ("EnteteCD.Duree_cd           : %s\n", EnteteCD.Duree_cd);
				g_print ("EnteteCD.Num_ID_CD          : %lu\n",EnteteCD.Num_ID_CD);
				g_print ("EnteteCD.Str_ID_CD          : %s\n", EnteteCD.Str_ID_CD);
				g_print ("EnteteCD.TotalTracks        : %d\n", EnteteCD.TotalTracks);
				g_print ("EnteteCD.NumGenre           : %d\n", EnteteCD.NumGenre);
				g_print ("EnteteCD.StrGenre           : %s\n", EnteteCD.StrGenre);

				g_print ("GENRE                       : %s\n", cddb_disc_db_genre(EnteteCD.NumGenre));

				g_print ("EnteteCD.NumYear            : %d\n", EnteteCD.NumYear);
				g_print ("EnteteCD.StrYear            : %s\n", EnteteCD.StrYear);

				g_print ("EnteteCD.Bool_Connected     : ");
				if (EnteteCD.Bool_Connected == CONNECT_IS_FALSE)
					g_print ("CONNECT_IS_FALSE\n");
				else if (EnteteCD.Bool_Connected == CONNECT_IS_TRUE)
					g_print ("CONNECT_IS_TRUE\n");
				else if (EnteteCD.Bool_Connected == CONNECT_IS_NO_MATCH_FOUND)
					g_print ("NO MATCH FOUND THIS CD\n");
				else	g_print ("ERREUR: CODE A VERIFIER :(\n");

				g_print ("EnteteCD.Bool_Read_Infos_cd : %s\n", EnteteCD.Bool_Read_Infos_cd ? "TRUE" : "FALSE");
				g_print ("EnteteCD.Message            : %s\n", EnteteCD.Message);
				*/
			}
		}
		var_cd.bool_timeout_read_toc_cd = FALSE;
	
		WindScan_close ();
	}
	return (TRUE);
}
/* Lecture du catalogue du cd-audio
*  --
*  entree : -
*  retour : -
*/
void cdaudiotoc_reffresh_list_cd (void)
{
	pthread_t nmr_tid;
	
	if (var_cd.Adr_Combo_Box == NULL) return;
	
	if (FALSE == libutils_find_file ("icedax")) {
		PRINT_FUNC_LF();
		wininfo_create (
			_("icedax NOT FOUND"),
			_("Please, install package [ icedax ]"),
		  	"");
		return;
	}
	
	WindScan_open ("Scan CD", WINDSCAN_PULSE);
	WindScan_set_label ("<b><i>Scanning CD ...</i></b>");
	WindScan_set_pulse ();

	EnteteCD.NameCD_Device = scan_get_text_combo_cd (_CD_);

	cdaudio_deallocate_glist_context ();
	cdaudio_deallocate_glist ();
	cdcue_remove_base_ioctl ();
	gtk_list_store_clear (var_cd.Adr_List_Store);

	cdaudio_set_flag_buttons ();

	// recherche CDDB is TRUE
	cddb_set_bool_cancel_cddb (FALSE);

	// ACTIVATION de l'update qui attends la fin du thread cd audio
	var_cd.bool_thread_read_toc_cd = TRUE;
	var_cd.bool_timeout_read_toc_cd = TRUE;
	var_cd.handler_timeout_read_toc_cd = gtk_timeout_add (50, cdaudiotoc_timeout_do_read_toc_cd, 0);
	pthread_create (&nmr_tid, NULL ,(void *)cdaudiotoc_thread_do_read_toc_cd, (void *)NULL);
}
// 
// 
void cdaudiotoc_button_eject_cd_clicked (void)
{
	if (FALSE == libutils_find_file ("eject")) {
		PRINT_FUNC_LF();
		wininfo_create (
			"eject NOT FOUND !",
			"Please, install package [ eject ]",
		  	"");
		return;
	}	
	cdaudio_deallocate_glist_context ();
	cdaudio_deallocate_glist ();
	cdcue_remove_base_ioctl ();
	gtk_list_store_clear (var_cd.Adr_List_Store);
	cdaudio_set_flag_buttons ();
	scan_eject_media (_CD_);
}



