 /*
 * file      : web.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

#include "win_info.h"
#include "global.h"
#include "utils.h"
#include "cdtoc.h"
#include "prg_navigator.h"
#include "web.h"


typedef struct {
	gchar *Navigateur;
	gchar *NameNavi;
	gchar *TemporaryRep;
} VAR_WEB ;

VAR_WEB VarWeb = { NULL, NULL, NULL };



void web_remove (void)
{
	if (VarWeb.Navigateur != NULL) {
		g_free (VarWeb.Navigateur);
		VarWeb.Navigateur = NULL;
	}
	
	if (VarWeb.NameNavi != NULL) {
		g_free (VarWeb.NameNavi);
		VarWeb.NameNavi = NULL;
	}
}

/* Appelle un navigateur pour aller sur le site d'XCFA et cela en thread
*  --
*  entree :
*      gchar *Navigateur :
*      gchar *PathHelp   :
*  retour : -
*/
void web_call_navigator (void)
{
	pid_t  pid;

	pid = fork ();
	if (pid == 0) {
		/*
		kfmclient newTab http://www.xcfa.tuxfamily.org &
		*/
		if (strcmp (VarWeb.Navigateur, "konqueror") == 0) {
			execlp ("kfmclient",
				"kfmclient",
				"newTab",
				VarWeb.NameNavi,
				NULL);
		}
		if (strcmp (VarWeb.Navigateur, "opera") == 0) {
			execlp (VarWeb.Navigateur,
				VarWeb.Navigateur,
				VarWeb.NameNavi,
				NULL);
		}
		else {
			/*
			-new-window URL
				Open URL in a new window in an already running Firefox  process.
				-new-tab URL Open URL in a new tab in an already running Firefox process.
			EXEMPLE:
				firefox -new-window -new-tab http:/www.google.fr
			*/
			// g_print("%s -new-window -new-tab %s\n", VarWeb.Navigateur,VarWeb.NameNavi);
			execlp (VarWeb.Navigateur,
				VarWeb.Navigateur,
				"-new-window",
				"-new-tab",
				VarWeb.NameNavi,
				NULL);
		}
		_exit (0);
	}
}
/*
void web_call_navigator (void)
{
	gchar	*LineCommand = NULL;
	
	LineCommand = g_strdup_printf ("%s -new-tab %s\n", VarWeb.Navigateur,VarWeb.NameNavi);
	g_print("LineCommand = %s\n", LineCommand);
	system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
}
*/

static void web_thread (void *arg)
{
	web_call_navigator ();
	pthread_exit(0);
}


/* Fonction commune d'appel a un navigateur pour aller sur le site d'XCFA
*  --
*  entree : -
*  retour : -
*/

void web_goto_xcfa_page (gchar *str_web)
{
	gchar      *name_navi = NULL;
	pthread_t   nmr_tid;
 	
	/*PRINT_FUNC_LF();*/

	if ((name_navi = prgnavigator_get_name_is_actived ()) == NULL) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_PRGNAVIGATOR);
		
		wininfo_create (
			_("PAS de navigateur present"),
			  "\n",
			_("   L'acces au web est impossible car aucun navigateur"),
			  "        \n",
			_("   n'est present dans votre configuration."),
			  "\n\n",
			_("   Veuillez installez un navigateur."),
			  "\n",
			  "");
		return;
	}

	if (cddb_test_access_web () == FALSE) {
		
		wininfo_create (
			_("La liaison internet est absente            "),
			  "\n",
			_("   Vous devez ouvrir l'acces internet"),
			  "\n\n",
			  "");
		return;
	}
	
	web_remove ();
	VarWeb.Navigateur = g_strdup (name_navi);
	VarWeb.NameNavi   = g_strdup (str_web);
	
	pthread_create (&nmr_tid, NULL ,(void *)web_thread, (void *)NULL);
	/*web_call_navigator ();*/
}

void web_make_file (gchar *StrMakeManFile)
{
	pid_t  pid;

	// PRINT_FUNC_LF();
	
	pid = fork ();
	if (pid == 0) {
		system (StrMakeManFile);
		_exit (0);
	}
}

void web_goto_manpage (gchar *NameManPage)
{
	gchar		*name_navi = NULL;
	pthread_t	 nmr_tid;
	gchar		*LineCommand = NULL;
 	
	/*PRINT_FUNC_LF();*/

	if ((name_navi = prgnavigator_get_name_is_actived ()) == NULL) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_PRGNAVIGATOR);
		
		wininfo_create (
			_("PAS de navigateur present"),
			  "\n",
			_("   L'acces au web est impossible car aucun navigateur"),
			  "        \n",
			_("   n'est present dans votre configuration."),
			  "\n\n",
			_("   Veuillez installez un navigateur."),
			  "\n",
			  "");
		return;
	}

	if (utils_scan_by_which (NameManPage, NULL) == FALSE) {
		g_print("The application is missing, you must install [ %s ]\n", NameManPage);
		return;
	}
	
	if (utils_scan_by_which ("txt2html", NULL) == FALSE) {
		// g_print("The application is missing, you must install [ txt2html ]\n");
		wininfo_create (
			_("txt2html absent"),
			  "\n",
			_("   txt2html est absent de votre configuration."),
			  "\n\n",
			_("   Veuillez l'installer."),
			  "\n",
			  "");
		return;
	}
	
	// Create rep	
	// gchar *utils_create_temporary_rep (gchar *path_tmprep)
	// gchar *utils_remove_temporary_rep (gchar *path_tmprep)
	if (VarWeb.TemporaryRep == NULL) {
		VarWeb.TemporaryRep = utils_create_temporary_rep (PATH_MANPAGE);
	}
	
	// INIT var
	web_remove ();
	VarWeb.Navigateur = g_strdup (name_navi);
	VarWeb.NameNavi   = g_strdup_printf ("%s/%s.html", VarWeb.TemporaryRep, NameManPage);
	
	// IF VarWeb.NameNavi NOT EXIST
	if (infosong_file_is_reg (VarWeb.NameNavi) == FALSE) {	
		LineCommand = g_strdup_printf ("man %s | txt2html > %s/%s.html", NameManPage, VarWeb.TemporaryRep, NameManPage);
		web_make_file (LineCommand);
		g_free (LineCommand);
		LineCommand = NULL;
		sleep(20);
	}
		
	pthread_create (&nmr_tid, NULL ,(void *)web_thread, (void *)NULL);
}


void web_remove_temporary_rep (void)
{
	web_remove ();
	if (VarWeb.TemporaryRep != NULL) {
		VarWeb.TemporaryRep = utils_remove_temporary_rep (VarWeb.TemporaryRep);
		VarWeb.TemporaryRep = NULL;
	}
}
