 /*
 * file      : scan_cd.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __scan_cd_h__
#define __scan_cd_h__ 1


typedef struct {

	gchar *Full_Name;
	gchar *Device;
	gint   Num;
	
	gint   line;
	gint   type;		/* 0 = IDE, 1 = SCSI */

} MEDIA;

extern GList *Media_List;

typedef enum { _CD_, _DVD_ } TYPE_READER;

void   scancd_remove_glist_media (void);
void   scancd_open_peri_cd (void);
void   scancd_close_peri_cd (void);
gint   scancd_get_nbr_readers_detected (void);
void   scancd_combobox_peripherique_cd_realize (GtkWidget *widget);
gchar *scancd_get_text_combo_cd (TYPE_READER type_reader);
GList *scancd_get_glist (void);
void   scancd_set_bool_scan (gboolean p_flag);
void   scancd_eject_media (TYPE_READER TypeReadder);


#endif
