 /*
 * file    : prg_postcript.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>

#include <string.h>

#include "global.h"
#include "utils.h"
#include "poche.h"
#include "prg_postscript.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	NUM_TREE_Nom = 0,
	NUM_TREE_Description,
	NUM_TREE_ALL_COLUMN
};

enum
{
	NAME_PRG_PS,
	COMMENT_PRG_PS,
	NUM_COLUMNS_PRG_PS
};

typedef struct {
	GtkListStore      *Adr_List_Store;
	GtkTreeModel      *Adr_Tree_Model;
	GtkWidget         *Adr_scroll;
	GtkTreeSelection  *Adr_Line_Selected;
	GtkWidget         *Adr_button_add_ps;
	GtkWidget         *Adr_entry_name_ps;
	GtkWidget         *Adr_button_del_ps;
	
	GList             *List_prg;

} VAR_PRG_PS;


VAR_PRG_PS var_prg_ps;



void prgpostscript_affiche_glist (gchar *p_name)
{
	GtkTreeIter     iter;
	gdouble         AdjValue;
	GtkAdjustment  *Adj = NULL;
	GList          *list = NULL;
	gchar          *ptr = NULL;

	/* PRINT_FUNC_LF(); */

	/* Reajustement de la liste */
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_prg_ps.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_prg_ps.Adr_scroll), Adj);

	if (p_name == NULL) {
	
		gtk_list_store_clear (var_prg_ps.Adr_List_Store);
		
		if (var_prg_ps.List_prg == NULL) {
			prgpostscript_add_glist ("evince");
			prgpostscript_add_glist ("kghostview");
			prgpostscript_add_glist ("gv");
			prgpostscript_add_glist ("ggv");
		}
		
		list = g_list_first (var_prg_ps.List_prg);
		while (list) {
			if ((ptr = (gchar *)list->data)) {
				gtk_list_store_append (var_prg_ps.Adr_List_Store, &iter);
				gtk_list_store_set (var_prg_ps.Adr_List_Store, &iter,

							NAME_PRG_PS,		ptr,
							COMMENT_PRG_PS,		_("Visual File PostScript"),
							-1);
			}
			list = g_list_next (list);
		}
	}
	else {
		gtk_list_store_append (var_prg_ps.Adr_List_Store, &iter);
		gtk_list_store_set (var_prg_ps.Adr_List_Store, &iter,

					NAME_PRG_PS,		p_name,
					COMMENT_PRG_PS,		_("Visual File PostScript"),
					-1);
	}
	
	pocheevnt_add_elements_combobox_preview ();
	if (var_prg_ps.Adr_entry_name_ps) gtk_entry_set_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps), "");
}

void prgpostscript_remove_prog_ps (void)
{
	GList          *list = NULL;
	gchar          *ptr = NULL;

	/* Remove GList */
	list = g_list_first (var_prg_ps.List_prg);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			g_free (ptr);
			ptr = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (var_prg_ps.List_prg);
	var_prg_ps.List_prg = NULL;
	list = NULL;
	
	/* Remove TreeWiev */
	gtk_list_store_clear (var_prg_ps.Adr_List_Store);
}
GList *prgpostscript_get_glist_prog_ps (void)
{
	return ((GList *)var_prg_ps.List_prg);
}

gboolean prgpostscript_test_is_find_ps (gchar *p_name)
{
	GList          *list = NULL;
	gchar          *ptr = NULL;

	list = g_list_first (var_prg_ps.List_prg);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			if (strcmp (ptr, p_name) == 0) return (TRUE);
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

gboolean prgpostscript_add_glist (gchar *p_name)
{
	GtkTreeIter        iter;
	gboolean           valid;
	gchar             *name = NULL;
	
	if (var_prg_ps.Adr_Tree_Model) {
		/* Test presence dans le TreeWiev */
		valid = gtk_tree_model_get_iter_first (var_prg_ps.Adr_Tree_Model, &iter);
		while (valid) {
			gtk_tree_model_get (var_prg_ps.Adr_Tree_Model, &iter, NAME_PRG_PS, &name, -1);
			if (name) {
				if (strcmp (p_name, name) == 0) return (FALSE);
			}
			valid = gtk_tree_model_iter_next (var_prg_ps.Adr_Tree_Model, &iter);
		}
	}
	
	/* Test presence dans le GList */
	if (prgpostscript_test_is_find_ps (p_name) == TRUE) {
		return (FALSE);
	}
	
	/* Test presence dans le systeme*/
	if (utils_scan_by_which (p_name, NULL) == FALSE) {
		return (FALSE);
	}
	
	var_prg_ps.List_prg = g_list_append (var_prg_ps.List_prg, g_strdup (p_name));
	
	return (TRUE);
}

gboolean prgpostscript_traite_button_press_event (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	gchar              *Name = NULL;
	GtkTreeViewColumn  *column;
	GtkTreePath        *path;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	GtkTreeIter         iter;
	
	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/* Recuperation de la structure */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, NULL, NULL)) {
		
		/* Vider la saisie */
		gtk_entry_set_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps), "");
		return (FALSE);
	}
					   
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_prg_ps.Adr_Tree_Model, &iter, NAME_PRG_PS, &Name, -1);
	
	/* Vider la saisie */
	gtk_entry_set_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps), Name);
	
	return (FALSE);
}

static void prgpostscript_add_columns (GtkTreeView *treeview)
{
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) prgpostscript_traite_button_press_event,
			 model);
			 
	/* SIGNAL 'changed'
	*/
	var_prg_ps.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	gtk_tree_selection_set_mode (var_prg_ps.Adr_Line_Selected, GTK_SELECTION_BROWSE);

	/* NAME_PRG_PS */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Nom"),
							renderer,
							"text", NAME_PRG_PS,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
						GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 110);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* COMMENT_PRG_PS */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Description"),
							renderer,
							"text", COMMENT_PRG_PS,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 160);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
}

void prgpostscript_make_scrolledwindow (GtkWidget *widget)
{
	GtkTreeModel *model;
	GtkWidget    *treeview;
	GtkListStore *store;

	/* PRINT_FUNC_LF(); */
	/*
	FALSE = 0
	TRUE = 1
	*/
	var_prg_ps.Adr_scroll = widget;
	var_prg_ps.Adr_List_Store =
	store = gtk_list_store_new (NUM_COLUMNS_PRG_PS,		/* Nombre total de colonnes */
				    G_TYPE_STRING,		/* Name */
				    G_TYPE_STRING		/* Commentaire */
				    );
	var_prg_ps.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);

	/* add columns to the tree view */
	prgpostscript_add_columns (GTK_TREE_VIEW (treeview));
			
	/**/
	prgpostscript_affiche_glist (NULL);
	
	gtk_widget_show_all (widget);
}




void prgpostscript_button_add_postscript_clicked (void)
{
	gchar *Name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps));
	
	if (prgpostscript_add_glist (Name) == TRUE) {
		
		prgpostscript_affiche_glist (Name);
	}
	else {
	
	}

}
void prgpostscript_button_del_postscript_clicked (void)
{
	GList          *list = NULL;
	gchar          *ptr = NULL;
	gchar          *Name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps));

	/* Set NULL if namein GList */
	list = g_list_first (var_prg_ps.List_prg);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			if (strcmp (ptr, Name) == 0) {
				g_free (ptr);
				ptr = NULL;
				list->data = NULL;
				break;
			}
		}
		list = g_list_next (list);
	}
	
	prgpostscript_affiche_glist (NULL);
}

void prgpostscript_entry_name_postscript_changed (void)
{
	gchar *Name = NULL;

	/*PRINT_FUNC_LF();*/
	
	if (!var_prg_ps.Adr_button_add_ps || !var_prg_ps.Adr_button_del_ps || !var_prg_ps.Adr_entry_name_ps) return;
	
	Name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prg_ps.Adr_entry_name_ps));

	if (*Name == '\0') {
		gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_add_ps), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_del_ps), FALSE);
		return;
	}
	
	if (prgpostscript_test_is_find_ps (Name)) {
		/* Remove TRUE
		*/
		gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_del_ps), TRUE);

		/* Add FALSE
		*/
		gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_add_ps), FALSE);
	}
	else {
		/* Remove FALSE
		*/
		gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_del_ps), FALSE);

		/* Add TRUE if (Name && *Name)
		*/
		if (Name && *Name)
			gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_add_ps), TRUE);
		else    gtk_widget_set_sensitive (GTK_WIDGET (var_prg_ps.Adr_button_add_ps), FALSE);
	}
}


void prgpostscript_button_add_postscript_realize (GtkWidget *widget)
{
	var_prg_ps.Adr_button_add_ps = widget;
	prgpostscript_entry_name_postscript_changed ();
}
void prgpostscript_button_del_postscript_realize (GtkWidget *widget)
{
	var_prg_ps.Adr_button_del_ps = widget;
	prgpostscript_entry_name_postscript_changed ();
}
void prgpostscript_entry_name_postscript_realize (GtkWidget *widget)
{
	var_prg_ps.Adr_entry_name_ps = widget;
	prgpostscript_entry_name_postscript_changed ();
}












