 /*
 * file      : prg_init.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __prg_init_h__
#define __prg_init_h__ 1

typedef struct {
	GtkListStore      *Adr_List_Store;
	GtkTreeModel      *Adr_Tree_Model;
	GtkWidget         *Adr_scroll;
	GtkTreeSelection  *Adr_Line_Selected;
	gboolean           Bool_Goto_Page_Options;
	// GdkPixbuf         *Pixbuf_Coche;
	// GdkPixbuf         *Pixbuf_Selected;
	GdkPixbuf         *Pixbuf_Ok;
	GdkPixbuf         *Pixbuf_Not_Ok;

} VAR_PRGEXTERN;

extern VAR_PRGEXTERN var_prgextern;



typedef enum {
	NMR_aacplusenc = 0,
	NMR_cdparanoia,
	NMR_checkmp3,
	NMR_imagemagick_convert,
	NMR_cuetools,
	NMR_faac,
	NMR_faad,
	NMR_flac,
	NMR_icedax,
	NMR_lame,
	NMR_lsdvd,
	
	NMR_mac,
	
	// NMR_mpc123_mppdec,
	// NMR_mppenc,
	NMR_musepack_tools_mppdec,
	NMR_musepack_tools_mppenc,
	
	NMR_mplayer,
	NMR_mp3gain,
	NMR_mpg321,
	NMR_mp3splt,
	NMR_normalize,
	NMR_libnotify_bin,
	NMR_ps2pdf,
	NMR_shorten,
	NMR_shntool,
	NMR_sox,
	NMR_txt2html,
	NMR_vorbis_tools_oggenc,
	NMR_vorbisgain,
	NMR_wavsplit,
	NMR_wavpack,
	NMR_wXXcodecs,
	
	NMR_MAX_TABLEAU
} TYPE_PROGINIT;



typedef struct {
	gchar		*PackageDebian64;			// PACKAGEDEBIAN_64
	gchar		*PackageDebian32;			// PACKAGEDEBIAN_32
	gchar		*Name1;					// NAME1
	gchar		*Name2;					// NAME2
	gchar		*Name3;					// NAME3
	gboolean	*BoolFound;				// FOUND
	gchar		*DepotDebian64;				// DEPOTDEBIAN_64
	gchar		*DepotDebian32;				// DEPOTDEBIAN_32
	gchar		*PtrName;				// NAME TREE-VIEW : pointeur sur Name1 | Name2 | Name3
	GdkPixbuf	*Pixbuf;				// PIXBUF TREE-VIEW
	gchar		*Description;				// DESCRIPTION TREE-VIEW
} TABLEAU_PRG_EXTERN;

extern TABLEAU_PRG_EXTERN TableauPrgExtern [  ];



typedef struct {
	gboolean	bool_notify_send;
	gboolean	bool_ape;
	gboolean	bool_mpc123_mppdec;
	gboolean	bool_mppenc;
	gboolean	bool_cdparanoia;
	gboolean	bool_cdda2wav;
	gboolean	bool_lame;
	gboolean	bool_oggenc;
	gboolean	bool_mpg321;
	gboolean	bool_ps2pdf;
	gboolean	bool_sox;
	gboolean	bool_normalize;
	gboolean	bool_checkmp3;
	gboolean	bool_faad;
	gboolean	bool_faac;
	gboolean	bool_mplayer;
	gboolean	bool_w32codecs;
	gboolean	bool_shorten;
	gboolean	bool_convert;
	gboolean	bool_lsdvd;
	gboolean	bool_vorbisgain;
	gboolean	bool_flac;
	gboolean	bool_mp3gain;
	gboolean	bool_mp3splt;
	gboolean	bool_wavsplit;
	gboolean	bool_wavpack;
	gboolean	bool_shntool;
	gboolean	bool_cuetools;
	gboolean	bool_aacplusenc;
	gboolean	bool_txt2html;

} PRGINIT;

extern PRGINIT PrgInit;



void       prginit_remove_comment (void);
void       prginit_make_scrolledwindow (GtkWidget *widget);
gboolean   prginit_get_etat (void);
void       prginit_update_glist (void);
gchar     *prginit_get_name (TYPE_PROGINIT TypeEnum);

#endif

