 /*
 * file      : options_wavpack.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
void optionsWavpack_combobox_wavpack_realize (GtkWidget *widget)
{
	var_options.Adr_Widget_wavpack = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	/*
	-f   Mode rapide de compression
	-h   Ume bonne qualite de compression dans tous les modes mais plus lent
	-hh  La meilleure qualite de compression dans tous les modes mais la plus lente
	*/
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mode normal"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mode rapide de compression"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Bonne qualite de compression"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Meilleure qualite de compression"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.compression_wavpack);
}
gchar *optionsWavpack_get_wavpack_compression (void)
{
	gchar *str_val_preset[] = { "", "-f", "-h", "-hh" };
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack) ]);
}
void optionsWavpack_combobox_wavpack_sound_realize (GtkWidget *widget)
{
	var_options.Adr_Widget_wavpack_sound = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	/*
	-jn  Joint-stereo override (0 = left/right, 1 = mid/side)
	----------------------
	-j0  Joint-stereo override (0 = left/right)
	-j1  Joint-stereo override (1 = mid/side)
	*/
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("stereo left/right"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("stereo mid/side"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.sound_wavpack);
}
gchar *optionsWavpack_get_wavpack_sound (void)
{
	gchar *str_val_preset[] = { "-j0", "-j1" };
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_sound) ]);
}


void optionsWavpack_combobox_wavpack_mode_hybride_changed (void)
{
	gboolean bool = *optionsWavpac_get_wavpack_hybride () == '\0' ? FALSE : TRUE;
	
	if (var_options.Adr_Widget_wavpack_correction_file)
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("combobox_wavpack_fichier_de_correction")), bool);
	
	if (var_options.Adr_Widget_wavpack_maximum_compression)
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("combobox_wavpack_compression_maximum")), bool);
	

	options_set_datas_interne (COLOR_WAVPACK_MODE_HYBRIDE, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}

void optionsWavpack_combobox_wavpack_mode_hybride_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/

	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "320 kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "384 kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "448 kbit/s");
	
	var_options.Adr_Widget_wavpack_mode_hybride = GTK_COMBO_BOX (widget);
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.wavpack_mode_hybride);
}
gchar *optionsWavpac_get_wavpack_hybride (void)
{
	gchar *str_val_preset[] = {"", "-b320", "-b384", "-b448"};
	if (var_options.Adr_Widget_wavpack_mode_hybride)
		return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_mode_hybride) ]);
	return ("");
}
void optionsWavpack_combobox_wavpack_fichier_de_correction_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/

	var_options.Adr_Widget_wavpack_correction_file = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.wavpack_correction_file);
	
	optionsWavpack_combobox_wavpack_mode_hybride_changed ();
}
gchar *optionsWavpack_get_wavpack_correction_file (void)
{
	gchar *str_val_preset[] = {"",  "-c"};
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_correction_file) ]);
}
void optionsWavpack_combobox_wavpack_compression_maximum_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/

	var_options.Adr_Widget_wavpack_maximum_compression = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.wavpack_maximum_compression);
	
	optionsWavpack_combobox_wavpack_mode_hybride_changed ();
}
gchar *optionsWavpack_get_wavpack_maximum_compression (void)
{
	gchar *str_val_preset[] = {"", "-cc"};
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_maximum_compression) ]);
}
void optionsWavpack_combobox_wavpack_signature_md5_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/

	var_options.Adr_Widget_wavpack_signature_md5 = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.wavpack_signature_md5);
}
gchar *optionsWavpack_get_wavpack_signature_md5 (void)
{
	gchar *str_val_preset[] = {"", "-m"};
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_signature_md5) ]);
}
void optionsWavpack_combobox_wavpack_extra_encoding_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/

	var_options.Adr_Widget_wavpack_extra_encoding = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),  _("Non"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("1 (fast / rapide)"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "2");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "3");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "4");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "5");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("6 (very slow / tres lent)"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.wavpack_extra_encoding);
}
gchar *optionsWavpack_get_wavpack_extra_encoding (void)
{
	gchar *str_val_preset[] = {"", "-x1", "-x2", "-x3", "-x4", "-x5", "-x6"};
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_extra_encoding) ]);
}

void optionsWavpack_combobox_wavpack_changed (void)
{
	/* compression */
	options_set_datas_interne (COLOR_WAVPACK_COMPRESSION, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}
void optionsWavpack_combobox_wavpack_sound_changed ()
{
	options_set_datas_interne (COLOR_WAVPACK_SOUND, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}
void optionsWavpack_combobox_wavpack_fichier_de_correction_changed (void)
{
	options_set_datas_interne (COLOR_WAVPACK_FICHIER_CORRECTION, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}
void optionsWavpack_combobox_wavpack_compression_maximum_changed (void)
{
	options_set_datas_interne (COLOR_WAVPACK_COMPRESSION_MAXIMUM, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}
void optionsWavpack_combobox_wavpack_signature_md5_changed (void)
{
	options_set_datas_interne (COLOR_WAVPACK_SIGNATURE_MD5, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}
void optionsWavpack_combobox_wavpack_extra_encoding_changed (void)
{
	options_set_datas_interne (COLOR_WAVPACK_EXTRA_ENCODING, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
}


