 /*
 * file      : file_action.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


/*
    Salut Claude

    Le ReplayGain s'applique toujours en dernier, une fois toutes les
    conversions effectuées.
    Sauf bien sûr pour nettoyer mais en principe quand on nettoie les « tags
    » ReplayGain c'est la seule opération que l'on fait sur le/les fichier(s).

    Maxime

    xcfaudio a écrit :
    > Bonjour à tous,
    >
    > L'intégration du ReplayGain est en bonne voie ;)
    >
    > ? Juste une question d'ordre technique ?
    >
    > L'ordre de prise en compte par rapport à une sélection (globale) doit
    > bien être:
    > 1 - Clear ReplayGain
    > 2 - Normalisation Individuelle
    > 3 - Normalisation Collective
    > 4 - Conversions
    > 5 - ReplayGain
    >
    > Xavier, Maxime, Patrick ... ???
    >
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#include "global.h"
#include "file.h"
#include "replaygain.h"
#include "normalise.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {

	gboolean   dedans;
	guint      handler_timeout;
	gboolean   bool_ReplaygainClear;
	gboolean   bool_normalize;
	gboolean   bool_conversion;
	gboolean   bool_ReplaygainApply;
	gboolean   bool_trash;

	gint       NbrFileRemove;
	
} FILE_ACTION;

FILE_ACTION FileAction;


/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
void fileaction_set_end (void)
{
	FileAction.dedans = FALSE;
}

/*
*---------------------------------------------------------------------------
* TIMEOUT
*---------------------------------------------------------------------------
*/
static gint fileaction_timeout (gpointer data)
{
	if (FileAction.dedans == TRUE) return (TRUE);
	
	if (FileAction.bool_ReplaygainClear == TRUE) {
		FileAction.dedans = TRUE;
		FileAction.bool_ReplaygainClear = FALSE;
		replaygain_action (_CLEAR_REPLAYGAIN_);
		return (TRUE);
	}
	if (FileAction.bool_normalize == TRUE) {
		FileAction.dedans = TRUE;
		FileAction.bool_normalize = FALSE;
		normalise_file ();
		return (TRUE);
	}
	if (FileAction.bool_conversion == TRUE) {
		FileAction.dedans = TRUE;
		FileAction.bool_conversion = FALSE;
		fileconv_conversion_file_to_file_action ();
		return (TRUE);
	}
	if (FileAction.bool_ReplaygainApply == TRUE) {
		FileAction.dedans = TRUE;
		FileAction.bool_ReplaygainApply = FALSE;
		replaygain_action (_APPLY_REPLAYGAIN_);
		return (TRUE);
	}
	
	if (FileAction.bool_trash == TRUE) {
	    FileAction.dedans = TRUE;
	    FileAction.bool_trash = FALSE;
		filetrash_action ();
		return (TRUE);
	}
	
	if (!FileAction.bool_ReplaygainClear &&
	    !FileAction.bool_normalize &&
	    !FileAction.bool_conversion &&
	    !FileAction.bool_ReplaygainApply) {
		
		gtk_timeout_remove (FileAction.handler_timeout);
	}
	
	return (TRUE);
}



void fileaction_choice (void)
{
	/*PRINT_FUNC_LF();*/

	FileAction.dedans = FALSE;
	FileAction.NbrFileRemove = 0;
	
	if ((FileAction.NbrFileRemove = file_verif_existing_file ()) > 0) {
		file_verif_existing_file_alert (FileAction.NbrFileRemove);
		return;
	}
	
	FileAction.bool_ReplaygainClear    = file_get_bool_ReplaygainClear_file ();
	FileAction.bool_normalize          = normalise_individuel ();
	FileAction.bool_conversion         = file_get_bool_conversion_FILE ();
	FileAction.bool_ReplaygainApply    = file_get_bool_ReplaygainApply_file ();
	FileAction.bool_trash              = filetrash_ok ();
	
	FileAction.handler_timeout = gtk_timeout_add (100, fileaction_timeout, 0);
}









