 /*
 * file      : file.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#include "global.h"
#include "utils.h"
#include "config_user.h"
#include "dragNdrop.h"
#include "prg_init.h"
#include "info_song.h"
#include "file.h"
#include "options.h"
#include "fileselect.h"
#include "popup.h"
#include "level.h"
#include "win_info.h"
#include "showhide_treeview.h"
#include "win_play.h"
#include "prg_audio.h"
#include "play_file.h"
#include "mplayer.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
extern gint n_drag_types;

	/*
	Wav
	Flac
	Ape
	WPack
	Ogg
	Aac
	Mpc
	Mp3
	*/
enum
{
	COLUMN_FILE_PLAY = 0,
	COLUMN_FILE_TRASH,
	COLUMN_FILE_TYPE,
	COLUMN_FILE_WAV,
	COLUMN_FILE_FLAC,
	COLUMN_FILE_APE,
	COLUMN_FILE_WAVPACK,
	COLUMN_FILE_OGG,
	COLUMN_FILE_M4A,
	COLUMN_FILE_AAC,
	COLUMN_FILE_MPC,
	COLUMN_FILE_MP3,
	COLUMN_FILE_TIME,
	COLUMN_FILE_NORMALIZE,
	COLUMN_FILE_REPLAYGAIN,
	COLUMN_FILE_NAME,
	COLUMN_FILE_EDITABLE,

	COLUMN_FILEWAV_HERTZ,
	COLUMN_FILEWAV_NEW_HERTZ,
	COLUMN_FILEWAV_VOIE,
	COLUMN_FILEWAV_NEW_VOIE,
	COLUMN_FILEWAV_BITS,
	COLUMN_FILEWAV_NEW_BITS,
	COLUMN_FILEWAV_NAME,

	COLUMN_FILEMP3OGG_TYPE,
	COLUMN_FILEMP3OGG_BITRATE,
	COLUMN_FILEMP3OGG_NEWBITRATE,
	COLUMN_FILEMP3OGG_SIZE,
	COLUMN_FILEMP3OGG_TIME,
	COLUMN_FILEMP3OGG_NAME,

	COLUMN_FILE_POINTER_STRUCT,

	COLUMN_FILE_NUM
};


/*
enum
{
	NUM_TREE_Play = 0,
	NUM_TREE_Trash,
	NUM_TREE_Type,
	NUM_TREE_Wav,
	NUM_TREE_Flac,
	NUM_TREE_Ape,
	NUM_TREE_WavP,
	NUM_TREE_Ogg,
	NUM_TREE_M4a,
	NUM_TREE_Aac,
	NUM_TREE_Mpc,
	NUM_TREE_Mp3,
	NUM_TREE_Time,
	NUM_TREE_Normalise,
	NUM_TREE_ReplayGain,
	NUM_TREE_Nom,
	
	NUM_TREE_FREQUENCE,
	NUM_TREE_PISTE,
	NUM_TREE_QUANTIFICATION,
	
	NUM_TREE_NOUVEAUBITRATE,
	NUM_TREE_ALL_COLUMN
};
*/
enum
{
	NUM_TREE_Play = 0,			/* -- FILE	*/
	NUM_TREE_Trash,
	NUM_TREE_Type,
	NUM_TREE_Wav,
	NUM_TREE_Flac,
	NUM_TREE_Ape,
	NUM_TREE_WavP,
	NUM_TREE_Ogg,
	NUM_TREE_M4a,
	NUM_TREE_Aac,
	NUM_TREE_Mpc,
	NUM_TREE_Mp3,
	NUM_TREE_Time,
	NUM_TREE_Normalise,
	NUM_TREE_ReplayGain,

	NUM_TREE_Nom,				/* -- WAV	*/
	NUM_TREE_Frequence,
	NUM_TREE_FREQUENCE,
	NUM_TREE_Piste,
	NUM_TREE_PISTE,
	NUM_TREE_Quantification,
	NUM_TREE_QUANTIFICATION,
	NUM_TREE_Nom1,

	NUM_TREE_Type1,				/* -- MP3-OGG	*/
	NUM_TREE_Bitrate,
	NUM_TREE_NOUVEAUBITRATE,
	NUM_TREE_Size,
	NUM_TREE_Time1,
	NUM_TREE_Nom2,

	NUM_TREE_ALL_COLUMN			/* -- TOTAL	*/
};


typedef struct
{
	GdkPixbuf    *ColumnFilePlay;
	GdkPixbuf    *ColumnFileTrash;
	gchar        *ColumnFileType;
	GdkPixbuf    *ColumnFileFlac;
	GdkPixbuf    *ColumnFileWav;
	GdkPixbuf    *ColumnFileMp3;
	GdkPixbuf    *ColumnFileOgg;
	GdkPixbuf    *ColumnFileM4a;
	GdkPixbuf    *ColumnFileAac;
	GdkPixbuf    *ColumnFileWma;
	GdkPixbuf    *ColumnFileMpc;
	GdkPixbuf    *ColumnFileApe;
	GdkPixbuf    *ColumnFileWavPack;
	gchar        *ColumnFileTime;
	gchar        *ColumnFileNormalize;
	GdkPixbuf    *ColumnFileReplayGain;
	gchar        *ColumnFileName;
	gboolean      ColumnFileEditable;

	gchar        *ColumnFileWavHertz;				/* Taux d'échantillonnage en hertz (qualité du son) */
	gchar        *ColumnFileWavVoie;				/* 1, 2 ou 4 */
	gchar        *ColumnFileWavBits;				/* 8, 16, 32 ou 64 */
	gchar        *ColumnFileWavNewHertz;				/* Hertz */
	gchar        *ColumnFileWavNewVoie;				/* Voie */
	gchar        *ColumnFileWavNewBits;				/* Bits */
	gchar        *ColumnFileWavName;				/* Nom du fichier sans l'extension */

	gchar        *ColumnFileMp3OggType;
	gchar        *ColumnFileMp3OggBitrate;
	gchar        *ColumnFileMp3OggNewBitrate;
	gchar        *ColumnFileMp3OggSize;
	gchar        *ColumnFileMp3OggTime;
	gchar        *ColumnFileMp3OggName;

	gpointer      ColumnFileAdrStruct;

} ARTICLES_FILE;

GArray           *Articles_file = NULL;			/* Adresse tab */

VAR_FILE var_file;



GList *file_get_GLIST_line_selected (void);
void   file_set_GLIST_line_selected (GList *p_list);
GList *file_clear_GLIST_line_selected (GList *p_list);

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/


gint file_verif_existing_file (void)
{
	GList     *list = NULL;
	DETAIL    *detail = NULL;
	FIC       *fic = NULL;
	gint       NbrFileRemove = 0;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
				/* Suppression d'un fichier qui n'existe plus !
				*  @Shankarius
				*/
				if (infosong_file_is_reg (detail->namefile) == FALSE) {
					g_print ("@Shankarius: NOT EXIST: DEL IN LISTE -> %s\n", detail->namefile);
					detail->remove = STRUCT_FIC_REMOVE;
					NbrFileRemove ++;
				}
			}
		}
		list = g_list_next(list);
	}
	if (NbrFileRemove > 0) {
		fileanalyze_modify_glist_entetefile ();
	}
	return (NbrFileRemove);
}
void file_verif_existing_file_alert (gint NbrFileRemove)
{
	if (NbrFileRemove > 0) {
		gchar *Str = NULL;

		Str = g_strdup_printf (_("   %d fichiers ''absents'' du systeme   \n   nettoye(s) de la liste !"), NbrFileRemove);
		wininfo_create (
			_("Fichier(s) absent(s)  !"),
			Str,
			  "\n\n",
			_("   Veuillez recommencer."),
			  "           \n\n",
			  "");
		g_free (Str);
		Str = NULL;
	}
}

gint file_get_COLUMN_FILE_NORMALIZE (void)
{
	return (COLUMN_FILE_NORMALIZE);
}

gint file_get_pointer_struct (void)
{
	return (COLUMN_FILE_POINTER_STRUCT);
}

gchar *file_get_str_level_normalise (DETAIL *detail)
{
	gint		 level = 0;
	gint		 NewLevel = 0;
	gchar		*Str = NULL;
	FIC		*fic = NULL;
	gboolean	 BoolOk = FALSE;
	
	// PRINT_FUNC_LF();

	if ((fic = (FIC *)detail->fic) == NULL) return (g_strdup (""));
	if (detail->type_infosong_file_is == FILE_IS_WAV) {
		INFO_WAV *info = (INFO_WAV *)detail->info;

		level          = info->LevelDbfs.level;
		NewLevel       = info->LevelDbfs.NewLevel;
		BoolOk         = TRUE;
	}
	else if (detail->type_infosong_file_is == FILE_IS_MP3) {
		INFO_MP3 *info = (INFO_MP3 *)detail->info;

		level          = info->LevelDbfs.level;
		NewLevel       = info->LevelDbfs.NewLevel;
		BoolOk         = TRUE;
	}
	else if (detail->type_infosong_file_is == FILE_IS_OGG) {
		INFO_OGG *info = (INFO_OGG *)detail->info;

		level          = info->LevelDbfs.level;
		NewLevel       = info->LevelDbfs.NewLevel;
		BoolOk         = TRUE;
	}
	else {
		fic->Etat_Normalise = NORM_NONE;
	}

	switch (fic->Etat_Normalise) {

	case NORM_NONE :
		Str = g_strdup ("");
		break;

	case NORM_READY_FOR_SELECT :
		Str = g_strdup ("<span font_desc=\"Courier bold 9\"><span color=\"black\"><b>[ ]</b></span></span>");
		break;

	case NORM_PEAK_ALBUM :
		Str = g_strdup ("<span font_desc=\"Courier bold 9\"><span color=\"black\"><b>PEAK/ALBUM</b></span></span>");
		break;

	case NORM_PEAK :
		Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"black\"><b>PEAK</b></span></span>");
		break;

	case NORM_RMS_MIX_ALBUM :
		if (fic->Etat_Scan == ETAT_SCAN_NONE) {
			fic->Etat_Scan = ETAT_SCAN_DEMANDE;
			FileScanDB_action (TRUE);
		}
		if (fic->LevelMix < level) {
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"black\"><b>RMS/ALBUM:%02d:%02d dBFS</b></span></span>", level, fic->LevelMix);
		}
		else if (fic->LevelMix == level) {
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"forestgreen\"><b>RMS/ALBUM:%02d:%02d dBFS</b></span></span>", level, fic->LevelMix);
		}
		else if (fic->LevelMix > level) {
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"gold\"><b>RMS/ALBUM:%02d:%02d dBFS</b></span></span>", level, fic->LevelMix);
		}
		else {
			Str = g_strdup ("");
		}
		break;

	case NORM_RMS_FIX :
		if (fic->Etat_Scan == ETAT_SCAN_NONE) {
			fic->Etat_Scan = ETAT_SCAN_DEMANDE;
			FileScanDB_action (TRUE);
		}

		if (NewLevel < level) {
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"red\"><b>RMS:%02d:%02d dBFS</b></span></span>", level, NewLevel);
		}
		else if (NewLevel == level) {
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"forestgreen\"><b>RMS:%02d:%02d dBFS</b></span></span>", level, NewLevel);
		}
		else if (NewLevel > level){
			Str = g_strdup_printf ("<span font_desc=\"Courier bold 9\"><span color=\"orange\"><b>RMS:%02d:%02d dBFS</b></span></span>", level, NewLevel);
		}
		else {
			Str = g_strdup ("");
		}
		break;
	}

	return (Str);
}

void file_button_del_file_clicked (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *BeginList = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	/* PRINT_FUNC_LF(); */
	/* marque les structures a detruires dans le glist 'entefile' */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	if ((BeginList = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model))) {
		list = g_list_first (BeginList);
		while (list) {
			if ((path = list->data)) {
				gtk_tree_model_get_iter (model, &iter, path);
				gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
				/*
				g_print ("DEL: %s\n", detail->namefile);
				*/
				if (detail) {
					detail->remove = STRUCT_FIC_REMOVE;
				}
			}
			list = g_list_next (list);
		}

		/* detruit les structures 'marquees' dans le glist 'entefile' */
		fileanalyze_modify_glist_entetefile ();

		if (gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter))
			gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
	}

}

void file_make_combobox_select_type (void)
{
	GList         *list = NULL;
	DETAIL        *detail = NULL;
	gboolean       bool_flac = FALSE;
	gboolean       bool_mp3 = FALSE;
	gboolean       bool_ogg = FALSE;
	gboolean       bool_wav = FALSE;
	gboolean       bool_m4a = FALSE;
	gboolean       bool_aac = FALSE;
	gboolean       bool_shn = FALSE;
	gboolean       bool_wma = FALSE;
	gboolean       bool_rm = FALSE;
	gboolean       bool_dts = FALSE;
	gboolean       bool_aiff = FALSE;
	gboolean       bool_mpc = FALSE;
	gboolean       bool_ape = FALSE;
	gboolean       bool_wavpack = FALSE;
	gboolean       bool_val;

	/*PRINT_FUNC_LF();*/
	if (GTK_COMBO_BOX (var_file.Adr_combobox_select_type) == NULL) return;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->choice_treeview != _TREEVIEW_SPLIT_) {
				if ((FIC *)detail->fic) {
					if (detail->type_infosong_file_is == FILE_IS_FLAC) {
						bool_flac = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_WAV) {
						bool_wav = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_MP3) {
						bool_mp3 = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_OGG) {
						bool_ogg = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_M4A) {
						bool_m4a = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_AAC) {
						bool_aac = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_SHN) {
						bool_shn = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_WMA) {
						bool_wma = TRUE;
					
					} else if (detail->type_infosong_file_is == FILE_IS_RM) {
						bool_rm = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_DTS) {
						bool_dts = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_AIFF) {
						bool_aiff = TRUE;
					
					} else if (detail->type_infosong_file_is == FILE_IS_MPC) {
						bool_mpc = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_APE) {
						bool_ape = TRUE;
					} else if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
						bool_wavpack = TRUE;
					}
				}
			}
		}
		list = g_list_next (list);
	}

	// utils_clear_elements_combobox (GTK_COMBO_BOX (var_file.Adr_combobox_select_type));
	utils_alloc_combo (GTK_COMBO_BOX (var_file.Adr_combobox_select_type));
	
			  gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), _("Select type: --"));
	if (bool_flac)    gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "FLAC");
	if (bool_wav)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "WAV");
	if (bool_mp3)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "MP3");
	if (bool_ogg)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "OGG");
	if (bool_m4a)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "M4A");
	if (bool_aac)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "AAC");
	if (bool_shn)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "SHN");
	if (bool_wma)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "WMA");
	if (bool_rm)      gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "RM");
	if (bool_dts)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "DTS");
	if (bool_aiff)    gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "AIFF");
	if (bool_mpc)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "MPC");
	if (bool_ape)     gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "APE");
	if (bool_wavpack) gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), "WAVPACK");
	gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), 0);

	bool_val = bool_flac | bool_wav | bool_mp3 | bool_ogg | bool_m4a | bool_aac | bool_shn | bool_wma | bool_rm | bool_dts | bool_aiff | bool_mpc | bool_ape | bool_wavpack;
	gtk_widget_set_sensitive (GTK_WIDGET (var_file.Adr_combobox_select_type), bool_val);
}

void file_combobox_select_type_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Select type: --"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_file.Adr_combobox_select_type = GTK_COMBO_BOX (widget);
	file_make_combobox_select_type ();
}
void file_combobox_select_type_changed (void)
{
	gchar         *ptr = NULL;
	gint           nmr = -1;
	TYPE_FILE_IS   type_file_is = FILE_IS_NONE;
	gboolean       valid;
	GtkTreeIter    iter;
	DETAIL        *detail = NULL;

	if (var_file.Adr_combobox_select_type != NULL) {
		if ((nmr = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.Adr_combobox_select_type)) > 0)) {

			ptr = gtk_combo_box_get_active_text (GTK_COMBO_BOX (var_file.Adr_combobox_select_type));
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_select_type), 0);
			if (!strcmp (ptr, "FLAC"))     type_file_is = FILE_IS_FLAC;
			if (!strcmp (ptr, "WAV"))      type_file_is = FILE_IS_WAV;
			if (!strcmp (ptr, "MP3"))      type_file_is = FILE_IS_MP3;
			if (!strcmp (ptr, "OGG"))      type_file_is = FILE_IS_OGG;
			if (!strcmp (ptr, "M4A"))      type_file_is = FILE_IS_M4A;
			if (!strcmp (ptr, "AAC"))      type_file_is = FILE_IS_AAC;
			if (!strcmp (ptr, "SHN"))      type_file_is = FILE_IS_SHN;
			if (!strcmp (ptr, "WMA"))      type_file_is = FILE_IS_WMA;
			if (!strcmp (ptr, "RM"))       type_file_is = FILE_IS_RM;
			if (!strcmp (ptr, "DTS"))      type_file_is = FILE_IS_DTS;
			if (!strcmp (ptr, "AIFF"))     type_file_is = FILE_IS_AIFF;
			if (!strcmp (ptr, "MPC"))      type_file_is = FILE_IS_MPC;
			if (!strcmp (ptr, "APE"))      type_file_is = FILE_IS_APE;
			if (!strcmp (ptr, "WAVPACK"))  type_file_is = FILE_IS_WAVPACK;

			if (type_file_is == FILE_IS_NONE) return;

			gtk_tree_selection_unselect_all (var_file.Adr_Line_Selected);

			valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
			while (valid) {
				gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
				if (detail->type_infosong_file_is == type_file_is) {
					gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
				}
				valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
			}
		}
	}
}

gboolean file_get_bool_normalize_FILE (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is == FILE_IS_WAV ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG) {
				if ((fic = (FIC *)detail->fic)) {
					if (fic->Etat_Normalise == NORM_RMS_FIX) {

						gint Level = 0, NewLevel = 0;

						if (detail->type_infosong_file_is == FILE_IS_WAV) {
							INFO_WAV *info = (INFO_WAV *)detail->info;
							Level    = info->LevelDbfs.level;
							NewLevel = info->LevelDbfs.NewLevel;
						}
						else if (detail->type_infosong_file_is == FILE_IS_OGG) {
							INFO_OGG *info = (INFO_OGG *)detail->info;
							Level    = info->LevelDbfs.level;
							NewLevel = info->LevelDbfs.NewLevel;
						}
						else if (detail->type_infosong_file_is == FILE_IS_MP3) {
							INFO_MP3 *info = (INFO_MP3 *)detail->info;
							Level    = info->LevelDbfs.level;
							NewLevel = info->LevelDbfs.NewLevel;
						}
						if (Level != NewLevel) return (TRUE);
					}
					else if (fic->Etat_Normalise > NORM_RMS_FIX) {
						return (TRUE);
					}
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

gboolean file_get_bool_ReplaygainApply_file (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is == FILE_IS_OGG ||
				detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_FLAC ||
				detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				if ((fic = (FIC *)detail->fic)) {
					if (fic->Etat_ReplayGain != RPG_EFFACER && fic->Etat_ReplayGain != RPG_ATTENTE) {
						return (TRUE);
					}
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
gboolean file_get_bool_ReplaygainClear_file (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is == FILE_IS_OGG ||
				detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_FLAC ||
				detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				if ((fic = (FIC *)detail->fic)) {
					if (fic->Etat_ReplayGain == RPG_EFFACER) {
						return (TRUE);
					}
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

gboolean file_get_bool_replaygain_FILE (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is == FILE_IS_OGG ||
				detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_FLAC ||
				detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				if ((fic = (FIC *)detail->fic)) {
					if (fic->Etat_ReplayGain != RPG_ATTENTE) return (TRUE);
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

gboolean file_get_bool_supprime_selected_FILE  (void)
{
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;

	if (var_file.Adr_TreeView == NULL) return (FALSE);
	if (var_file.Adr_Line_Selected == NULL) return (FALSE);
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	return (list ? TRUE : FALSE);
}
gboolean file_get_bool_conversion_FILE (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) return (TRUE);
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
void file_get_nbr_conversion_file (guint *p_conv, guint *p_nbr_data, guint *p_normalyze)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	/* PRINT_FUNC_LF(); */

	(*p_normalyze) = 0;
	(*p_conv) = 0;
	(*p_nbr_data) = g_list_length (entetefile);
	(*p_nbr_data) = 0;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {

				(*p_nbr_data) ++;

				if (fic->EtatSelection_Flac != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Wav != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Mp3 != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Ogg != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_M4a != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Aac != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Mpc != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_Ape != ETAT_ATTENTE)	(*p_conv) ++;
				if (fic->EtatSelection_WavPack != ETAT_ATTENTE)	(*p_conv) ++;

				if ((detail->type_infosong_file_is == FILE_IS_MP3 ||
					detail->type_infosong_file_is == FILE_IS_OGG ||
					detail->type_infosong_file_is == FILE_IS_WAV) &&
					(fic->Etat_Normalise >= NORM_RMS_FIX)) (*p_normalyze) ++;
			}
		}
		list = g_list_next (list);
	}
}

void file_get_etat_FILE (guint *total, guint *nbr_file, guint *nbr_norm, guint *nbr_rpg)
{
	gboolean     valid;
	GtkTreeIter  iter;
	DETAIL      *detail = NULL;
	FIC         *fic = NULL;

	*total    = 0;
	*nbr_file = 0;
	*nbr_norm = 0;
	*nbr_rpg  = 0;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		(*total) ++;

		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {
			if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) (*nbr_file) ++;
			if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) (*nbr_file) ++;

			if (fic->Etat_Normalise == NORM_RMS_FIX) {

				gint Level = 0;
				gint NewLevel = 0;

				if (detail->type_infosong_file_is == FILE_IS_WAV) {
					INFO_WAV *info = (INFO_WAV *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				else if (detail->type_infosong_file_is == FILE_IS_OGG) {
					INFO_OGG *info = (INFO_OGG *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				else if (detail->type_infosong_file_is == FILE_IS_MP3) {
					INFO_MP3 *info = (INFO_MP3 *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				if (Level != NewLevel) (*nbr_norm) ++;
			}
			else if (fic->Etat_Normalise > NORM_RMS_FIX) {
				(*nbr_norm) ++;
			}

			if (fic->Etat_ReplayGain > RPG_ATTENTE) (*nbr_rpg) ++;
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

/*
*---------------------------------------------------------------------------
* INFOS SUR LE NOMBRE ET LE TYPE DE FICHIERS
*---------------------------------------------------------------------------
*/

void file_set_tooltips_FILE (void)
{
	guint    nbr_wav = 0;
	guint    nbr_mp3 = 0;
	guint    nbr_ogg = 0;
	guint    nbr_flac = 0;
	guint    nbr_m4a = 0;
	guint    nbr_aac = 0;
	guint    nbr_shn = 0;
	guint    nbr_wma = 0;
	guint    nbr_rm = 0;
	guint    nbr_dts = 0;
	guint    nbr_aiff = 0;
	guint    nbr_mpc = 0;
	guint    nbr_ape = 0;
	guint    nbr_wavpack = 0;
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;
	GString *gstr = g_string_new (NULL);

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->choice_treeview != _TREEVIEW_SPLIT_) {
			if ((fic = (FIC *)detail->fic)) {

				if (detail->type_infosong_file_is == FILE_IS_FLAC)	nbr_flac ++;
				if (detail->type_infosong_file_is == FILE_IS_WAV)	nbr_wav ++;
				if (detail->type_infosong_file_is == FILE_IS_MP3)	nbr_mp3 ++;
				if (detail->type_infosong_file_is == FILE_IS_OGG)	nbr_ogg ++;
				if (detail->type_infosong_file_is == FILE_IS_M4A)	nbr_m4a ++;
				if (detail->type_infosong_file_is == FILE_IS_AAC)	nbr_aac ++;
				if (detail->type_infosong_file_is == FILE_IS_SHN)	nbr_shn ++;
				if (detail->type_infosong_file_is == FILE_IS_WMA)	nbr_wma ++;
				if (detail->type_infosong_file_is == FILE_IS_RM)	nbr_rm ++;
				if (detail->type_infosong_file_is == FILE_IS_DTS)	nbr_dts ++;
				if (detail->type_infosong_file_is == FILE_IS_AIFF)	nbr_aiff ++;
				if (detail->type_infosong_file_is == FILE_IS_MPC)	nbr_mpc ++;
				if (detail->type_infosong_file_is == FILE_IS_APE)	nbr_ape ++;
				if (detail->type_infosong_file_is == FILE_IS_WAVPACK)	nbr_wavpack ++;
			}
			}
		}
		list = g_list_next (list);
	}

	if (nbr_flac > 0) {
		g_string_append_printf (gstr, "flac:%d  ", nbr_flac);
	}
	if (nbr_wav > 0) {
		g_string_append_printf (gstr, "wav:%d  ", nbr_wav);
	}
	if (nbr_mp3 > 0) {
		g_string_append_printf (gstr, "mp3:%d  ", nbr_mp3);
	}
	if (nbr_ogg > 0) {
		g_string_append_printf (gstr, "ogg:%d  ", nbr_ogg);
	}
	if (nbr_m4a > 0) {
		g_string_append_printf (gstr, "m4a:%d  ", nbr_m4a);
	}
	if (nbr_aac > 0) {
		g_string_append_printf (gstr, "aac:%d  ", nbr_aac);
	}
	if (nbr_shn > 0) {
		g_string_append_printf (gstr, "shn:%d  ", nbr_shn);
	}
	if (nbr_wma > 0) {
		g_string_append_printf (gstr, "wma:%d  ", nbr_wma);
	}
	
	if (nbr_rm > 0) {
		g_string_append_printf (gstr, "rm:%d  ", nbr_rm);
	}
	if (nbr_dts > 0) {
		g_string_append_printf (gstr, "dts:%d  ", nbr_dts);
	}
	if (nbr_aiff > 0) {
		g_string_append_printf (gstr, "aiff:%d  ", nbr_aiff);
	}
	
	if (nbr_mpc > 0) {
		g_string_append_printf (gstr, "mpc:%d  ", nbr_mpc);
	}
	if (nbr_ape > 0) {
		g_string_append_printf (gstr, "ape:%d  ", nbr_ape);
	}
	if (nbr_wavpack > 0) {
		g_string_append_printf (gstr, "wavpack:%d", nbr_wavpack);
	}

	g_free (var_file.AdrInfosAllFiles);
	var_file.AdrInfosAllFiles = NULL;
	var_file.AdrInfosAllFiles = g_strdup (gstr->str);

	g_string_free (gstr, TRUE);
}

void file_set_tooltips_FILEWAV (void)
{
	guint     nbr_wav = 0;
	GList    *list = NULL;
	DETAIL   *detail = NULL;
	FIC_WAV  *fic = NULL;
	GString  *gstr = g_string_new (NULL);

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->choice_treeview != _TREEVIEW_SPLIT_) {
				if ((fic = (FIC_WAV *)detail->fic_wav)) {
					if (detail->type_infosong_file_is == FILE_IS_WAV)	nbr_wav ++;
				}
			}
		}
		list = g_list_next (list);
	}

	if (nbr_wav > 0) {
		g_string_append_printf (gstr, "wav:%d", nbr_wav);
	}

	g_free (var_file.AdrInfosWav);
	var_file.AdrInfosWav = NULL;
	var_file.AdrInfosWav = g_strdup (gstr->str);

	g_string_free (gstr, TRUE);
}

void file_set_tooltips_FILEMP3OGG (void)
{
	guint        nbr_mp3 = 0;
	guint        nbr_ogg = 0;
	GList       *list = NULL;
	DETAIL      *detail = NULL;
	FIC_MP3OGG  *fic = NULL;
	GString     *gstr = g_string_new (NULL);

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->choice_treeview != _TREEVIEW_SPLIT_) {
			if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {

				if (detail->type_infosong_file_is == FILE_IS_MP3)	nbr_mp3 ++;
				if (detail->type_infosong_file_is == FILE_IS_OGG)	nbr_ogg ++;
			}
			}
		}
		list = g_list_next (list);
	}

	if (nbr_mp3 > 0) {
		g_string_append_printf (gstr, "mp3:%d  ", nbr_mp3);
	}
	if (nbr_ogg > 0) {
		g_string_append_printf (gstr, "ogg:%d", nbr_ogg);
	}

	g_free (var_file.AdrInfosMp3Ogg);
	var_file.AdrInfosMp3Ogg = NULL;
	var_file.AdrInfosMp3Ogg = g_strdup (gstr->str);

	g_string_free (gstr, TRUE);
}

void file_set_tooltips (void)
{
	file_set_tooltips_FILE ();
	file_set_tooltips_FILEWAV ();
	file_set_tooltips_FILEMP3OGG ();
}

/*
*---------------------------------------------------------------------------
* SET ETATS WIDGETS FILE
*---------------------------------------------------------------------------
*/

void file_puts_label_number_FILE (char *mess_label_status)
{
	gchar *New_Str = NULL;

	/* PRINT_FUNC_LF(); */
	if (var_file.Adr_Label_Number) {
		/*New_Str = g_strdup_printf ("<b>%s</b>", g_markup_escape_text (mess_label_status, -1));*/
		New_Str = g_strdup_printf ("<b>%s</b>",mess_label_status);
		gtk_label_set_use_markup (GTK_LABEL (var_file.Adr_Label_Number), TRUE);
		gtk_label_set_markup (GTK_LABEL (var_file.Adr_Label_Number), New_Str);
		g_free (New_Str);
		New_Str = NULL;
	}
}

gboolean file_get_etat_normalise (void)
{
	GList		*list = NULL;
	DETAIL		*detail = NULL;
	FIC		*fic = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {

			if (detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_WAV) {

				if ((fic = (FIC *)detail->fic)) {
					if (fic->Etat_Normalise > NORM_READY_FOR_SELECT) return (TRUE);
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

void file_set_flag_buttons_FILE (void)
{
	gboolean      BoolButtonsAudio [ 7 ];
	gchar        *Ptr = NULL;
	guint         total, nbr_file, nbr_norm, nbr_rpg;
	DETAIL       *detail = NULL;

	/* FILE IMPORT */
	BoolButtonsAudio [ 0 ] = TRUE;

	/* DEL SELECTION */
	BoolButtonsAudio [ 1 ] = file_get_bool_supprime_selected_FILE ();

	/* LECTURE */
	BoolButtonsAudio [ 2 ] = BoolButtonsAudio [ 1 ];

	/* CONVERTION */
	BoolButtonsAudio [ 3 ] = file_get_bool_conversion_FILE () ||
				 file_get_bool_normalize_FILE () ||
				 file_get_bool_replaygain_FILE () ||
				 file_get_etat_normalise ();
				 /*
				  ||
				 filetrash_ok ();
				 */

	BoolButtonsAudio [ 4 ] = BoolButtonsAudio [ 1 ];

	BoolButtonsAudio [ 6 ] = file_get_etat_normalise ();

	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_file.AdrComboboxNormalise)), BoolButtonsAudio [ 6 ]);
	switch (gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise))) {
	case 0:
	case 1:
		gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
		break;
	case 2:
	case 3:
		if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (var_file.AdrComboboxNormalise)) == TRUE) {
			gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), TRUE);
		}
		else {
			gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
		}
		break;
	}

	/* ACTION */
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_import_file")), BoolButtonsAudio [ 0 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_file")),    BoolButtonsAudio [ 1 ]);

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_conv_file")),   BoolButtonsAudio [ 3 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_select_type")),   BoolButtonsAudio [ 1 ]);

	/*
	*---------------------------------------------------------------------------
	* FILE TAGS
	*---------------------------------------------------------------------------
	*
	* FILE_IS_FLAC
	* FILE_IS_MP3
	* FILE_IS_OGG
	* FILE_IS_MPC
	*/
	BoolButtonsAudio [ 5 ] = FALSE;
	// BoolButtonsAudio [ 5 ] = TRUE;
	if (var_file.Adr_table_tag != NULL) {
		if ((detail = file_get_line_selected ()) != NULL) {
			if (detail->type_infosong_file_is == FILE_IS_FLAC ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_MPC) {
				BoolButtonsAudio [ 5 ] = TRUE;
			}
		}
		gtk_widget_set_sensitive (GTK_WIDGET (var_file.Adr_table_tag), BoolButtonsAudio [ 5 ]);
	}

	file_get_etat_FILE (&total, &nbr_file, &nbr_norm, &nbr_rpg);

	Ptr = g_strdup_printf (_("<b>Total fichiers: %d,  Selection(s): %d</b>"), total, nbr_file + nbr_norm + nbr_rpg);
	file_puts_label_number_FILE (Ptr);
	g_free (Ptr);
	Ptr = NULL;

	file_make_combobox_select_type ();
}

/*
*---------------------------------------------------------------------------
* SET ETATS WIDGETS FILE WAV
*---------------------------------------------------------------------------
*/

gboolean file_get_bool_apply_file_WAV (void)
{
	GList       *list = NULL;
	DETAIL      *detail = NULL;
	FIC_WAV     *fic = NULL;

	/*PRINT_FUNC_LF();*/
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC_WAV *)detail->fic_wav)) {
				if (fic->Bool_Conv) return (TRUE);
			}
		}
		list = g_list_next(list);
	}
	return (FALSE);
}
gboolean file_get_bool_supprime_selected_file_WAV (void)
{
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;

	/* Marque les elements a detruire */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	return (list ? TRUE : FALSE);
}
gboolean file_get_bool_efface_bitrate_file_WAV (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_WAV          *fic = NULL;

	/* Prendre la liste des elements a verifier */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			/* prend le numero de la structure */
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if ((fic = (FIC_WAV *)detail->fic_wav)) {
				if (fic->NewHertz && *fic->NewHertz) return (TRUE);
				if (fic->NewVoie && *fic->NewVoie) return (TRUE);
				if (fic->NewBits && *fic->NewBits) return (TRUE);
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

void file_set_flag_buttons_file_WAV (void)
{
	gboolean      BoolButtonsAudio [ 3 ];

	/* LECTURE */
	BoolButtonsAudio [ 0 ] = file_get_bool_supprime_selected_file_WAV ();
	BoolButtonsAudio [ 1 ] = file_get_bool_supprime_selected_file_WAV ();
	BoolButtonsAudio [ 2 ] = file_get_bool_apply_file_WAV ();

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_file")),          BoolButtonsAudio [ 0 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("spinbutton_frequence_wav")), BoolButtonsAudio [ 1 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_apply_wav")),         BoolButtonsAudio [ 2 ]);
}

/*
*---------------------------------------------------------------------------
* SET ETATS WIDGETS FILE MP3OGG
*---------------------------------------------------------------------------
*/

gboolean file_get_bool_applique_bitrate_file_MP3OGG (void)
{
	GList            *list = NULL;
	DETAIL           *detail = NULL;
	FIC_MP3OGG       *fic = NULL;
	gboolean          Ret = FALSE;

	/* PRINT_FUNC_LF(); */

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
				if (detail->type_infosong_file_is == FILE_IS_MP3) {
					if (fic->Lame.type != -1 && fic->Lame.debit != -1 && fic->Lame.mode != -1) {
						return (TRUE);
					}
				}
				else if (detail->type_infosong_file_is == FILE_IS_OGG) {
					if (fic->Oggenc.type != -1 && fic->Oggenc.debit != -1 && fic->Oggenc.mode != -1) {
						return (TRUE);
					}
				}
			}
		}
		list = g_list_next (list);
	}
	return (Ret);
}
gboolean file_get_bool_efface_bitrate_file_MP3OGG (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_MP3OGG       *fic = NULL;

	/*PRINT_FUNC_LF();*/

	/* Marque les elements a detruire */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			/* prend le numero de la structure */
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if (detail) {
				if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
					if (detail->type_infosong_file_is == FILE_IS_MP3) {
						if (fic->Lame.type != -1 && fic->Lame.debit != -1 && fic->Lame.mode != -1) {
							return (TRUE);
						}
					}
					else if (detail->type_infosong_file_is == FILE_IS_OGG) {
						if (fic->Oggenc.type != -1 && fic->Oggenc.debit != -1 && fic->Oggenc.mode != -1) {
							return (TRUE);
						}
					}
				}
			}
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

gboolean file_get_bool_supprime_selected_FILE_MP3 (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	/* Prendre la liste des elements a verifier */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			/* prend le numero de la structure */
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			if (detail->type_infosong_file_is == FILE_IS_MP3) return (TRUE);
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
gboolean file_get_bool_supprime_selected_FILE_OGG (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	/* Prendre la liste des elements a verifier */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			/* prend le numero de la structure */
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			if (detail->type_infosong_file_is == FILE_IS_OGG) return (TRUE);
		}
		list = g_list_next (list);
	}
	return (FALSE);
}

void file_set_flag_buttons_file_MP3OGG (void)
{
	gboolean      BoolButtonsAudio [ 5 ] = { FALSE, FALSE, FALSE, FALSE, FALSE };

	/*PRINT_FUNC_LF();*/

	/* APPLIQUE */
	BoolButtonsAudio [ 0 ] = file_get_bool_applique_bitrate_file_MP3OGG ();

	/* EFFACE */
	BoolButtonsAudio [ 1 ] = file_get_bool_efface_bitrate_file_MP3OGG ();

	/* EFFACE */
	BoolButtonsAudio [ 2 ] = file_get_bool_supprime_selected_FILE ();

	/* ComboBox Lame */
	BoolButtonsAudio [ 3 ] = file_get_bool_supprime_selected_FILE_MP3 ();

	/* ComboBox Oggenc */
	BoolButtonsAudio [ 4 ] = file_get_bool_supprime_selected_FILE_OGG ();

	/* ACTION */
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_applique_file_mp3ogg")),		BoolButtonsAudio [ 0 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_efface_bitrate_mp3ogg")),		BoolButtonsAudio [ 1 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_file")),				BoolButtonsAudio [ 2 ]);

	/* ComboBox Lame */
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_lame_abr_cbr_vbr_mp3ogg")),	BoolButtonsAudio [ 3 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_lame_type_bitrate_mp3ogg")),	BoolButtonsAudio [ 3 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_lame_mode_mp3ogg")),		BoolButtonsAudio [ 3 ]);

	/* ComboBox Oggenc */
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_bitrate_mp3ogg")),	BoolButtonsAudio [ 4 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_managed_mp3ogg")),	BoolButtonsAudio [ 4 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_downmix_m3ogg")),	BoolButtonsAudio [ 4 ]);
}

void file_set_flag_buttons_audio_file (void)
{
	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		file_set_flag_buttons_FILE ();
		break;
	case NOTEBOOK_FICHIERS_WAV :
		file_set_flag_buttons_file_WAV ();
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		file_set_flag_buttons_file_MP3OGG ();
		break;
	}
	file_set_tooltips ();
}

typedef struct {
	TYPE_FILE_IS	From;
	TYPE_FILE_IS	To;
	gchar		*Conv1;
	gboolean	*Bool1;
	gchar		*Conv2;
	gboolean	*Bool2;
} TST_FROM;

TST_FROM TstFrom[] = {

{FILE_IS_WMA,		FILE_IS_WMA,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_WMA,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_WMA,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_WMA,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer, 		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_WMA,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_WMA,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_WMA,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_WMA,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_WMA,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MAC",		&PrgInit.bool_ape },
{FILE_IS_WMA,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_RM,		FILE_IS_RM,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_RM,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_RM,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_RM,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer, 		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_RM,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_RM,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_RM,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_RM,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_RM,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MAC",		&PrgInit.bool_ape },
{FILE_IS_RM,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_DTS,		FILE_IS_DTS,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_DTS,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_DTS,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_DTS,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer, 		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_DTS,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_DTS,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_DTS,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_DTS,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_DTS,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MAC",		&PrgInit.bool_ape },
{FILE_IS_DTS,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_AIFF,		FILE_IS_AIFF,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_AIFF,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_AIFF,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_AIFF,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer, 		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_AIFF,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_AIFF,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer, 		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_AIFF,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_AIFF,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_AIFF,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer, 		"MAC",		&PrgInit.bool_ape },
{FILE_IS_AIFF,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_WAV,		FILE_TO_NORMALISE,		"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_WAV,		FILE_TO_NORMALISE_COLLECTIF,	"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_WAV,		FILE_IS_MP3,			"MPLAYER", 				&PrgInit.bool_mplayer,		"LAME", 	&PrgInit.bool_lame },
{FILE_IS_WAV,		FILE_IS_OGG,			"MPLAYER", 				&PrgInit.bool_mplayer,		"OGGENC", 	&PrgInit.bool_oggenc },
{FILE_IS_WAV,		FILE_IS_FLAC,			"MPLAYER", 				&PrgInit.bool_mplayer,		"FLAC", 	&PrgInit.bool_flac },
{FILE_IS_WAV,		FILE_IS_M4A,			"FAAC", 				&PrgInit.bool_faac,		NULL,		NULL },
{FILE_IS_WAV,		FILE_IS_AAC,			"AACPLUSENC", 				&PrgInit.bool_aacplusenc,	NULL,		NULL },
{FILE_IS_WAV,		FILE_IS_MPC,			"MPLAYER", 				&PrgInit.bool_mplayer,		"MPPENC", 	&PrgInit.bool_mppenc },
{FILE_IS_WAV,		FILE_IS_APE,			"MPLAYER", 				&PrgInit.bool_mplayer,		"MAC", 		&PrgInit.bool_ape },
{FILE_IS_WAV,		FILE_IS_WAVPACK,		"MPLAYER", 				&PrgInit.bool_mplayer,		"WAVPACK", 	&PrgInit.bool_wavpack },

{FILE_IS_FLAC,		FILE_TO_REPLAYGAIN,		"METAFLAC", 				&PrgInit.bool_flac,		NULL,		NULL },
{FILE_IS_FLAC,		FILE_IS_WAV,			"FLAC",					&PrgInit.bool_flac,		NULL,		NULL },
{FILE_IS_FLAC,		FILE_IS_MP3,			"FLAC", 				&PrgInit.bool_flac,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_FLAC,		FILE_IS_OGG,			"OGGENC", 				&PrgInit.bool_oggenc,		NULL,		NULL },
{FILE_IS_FLAC,		FILE_IS_M4A,			"FLAC", 				&PrgInit.bool_flac,		"FAAC", 	&PrgInit.bool_faac },
{FILE_IS_FLAC,		FILE_IS_AAC,			"FLAC",					&PrgInit.bool_flac,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_FLAC,		FILE_IS_MPC,			"FLAC",					&PrgInit.bool_flac,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_FLAC,		FILE_IS_APE,			"FLAC",					&PrgInit.bool_flac,		"MAC",		&PrgInit.bool_ape },
{FILE_IS_FLAC,		FILE_IS_WAVPACK,		"FLAC",					&PrgInit.bool_flac,		"WAVPACK",	&PrgInit.bool_wavpack },
{FILE_IS_MP3,		FILE_TO_REPLAYGAIN,		"MP3GAIN", 				&PrgInit.bool_mp3gain,		NULL,		NULL },

{FILE_IS_MP3,		FILE_TO_NORMALISE,		"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_MP3,		FILE_TO_NORMALISE_COLLECTIF,	"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_MP3,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_MP3,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_MP3,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer,		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_MP3,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_MP3,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer,		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_MP3,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_MP3,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_MP3,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer,		"MAC",		&PrgInit.bool_ape },
{FILE_IS_MP3,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_OGG,		FILE_TO_REPLAYGAIN,		"VORBISGAIN",				&PrgInit.bool_vorbisgain,	NULL,		NULL },
{FILE_IS_OGG,		FILE_TO_NORMALISE,		"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_OGG,		FILE_TO_NORMALISE_COLLECTIF,	"NORMALISE",				&PrgInit.bool_normalize,	NULL,		NULL },
{FILE_IS_OGG,		FILE_IS_OGG,			"OGGENC",				&PrgInit.bool_oggenc,		NULL,		NULL },
{FILE_IS_OGG,		FILE_IS_WAV,			"OGGENC",				&PrgInit.bool_oggenc,		NULL,		NULL },
{FILE_IS_OGG,		FILE_IS_MP3,			"OGGENC",				&PrgInit.bool_oggenc,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_OGG,		FILE_IS_FLAC,			"OGGENC",				&PrgInit.bool_oggenc,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_OGG,		FILE_IS_M4A,			"OGGENC",				&PrgInit.bool_oggenc,		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_OGG,		FILE_IS_AAC,			"OGGENC",				&PrgInit.bool_oggenc,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_OGG,		FILE_IS_MPC,			"OGGENC",				&PrgInit.bool_oggenc,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_OGG,		FILE_IS_APE,			"OGGENC",				&PrgInit.bool_oggenc,		"MAC",		&PrgInit.bool_ape },
{FILE_IS_OGG,		FILE_IS_WAVPACK,		"OGGENC",				&PrgInit.bool_oggenc,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_SHN,		FILE_IS_WAV,			"SHORTEN",				&PrgInit.bool_shorten,		NULL,		NULL },
{FILE_IS_SHN,		FILE_IS_MP3,			"SHORTEN",				&PrgInit.bool_shorten,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_SHN,		FILE_IS_OGG,			"SHORTEN",				&PrgInit.bool_shorten,		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_SHN,		FILE_IS_FLAC,			"SHORTEN",				&PrgInit.bool_shorten,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_SHN,		FILE_IS_M4A,			"SHORTEN",				&PrgInit.bool_shorten,		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_SHN,		FILE_IS_AAC,			"SHORTEN",				&PrgInit.bool_shorten,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_SHN,		FILE_IS_MPC,			"SHORTEN",				&PrgInit.bool_shorten,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_SHN,		FILE_IS_APE,			"SHORTEN",				&PrgInit.bool_shorten,		"MAC",		&PrgInit.bool_ape },
{FILE_IS_SHN,		FILE_IS_WAVPACK,		"SHORTEN",				&PrgInit.bool_shorten,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_M4A,		FILE_IS_M4A,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_M4A,		FILE_IS_AAC,			"MPLAYER",				&PrgInit.bool_mplayer,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_M4A,		FILE_IS_WAV,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_M4A,		FILE_IS_MP3,			"MPLAYER",				&PrgInit.bool_mplayer,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_M4A,		FILE_IS_OGG,			"MPLAYER",				&PrgInit.bool_mplayer,		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_M4A,		FILE_IS_FLAC,			"MPLAYER",				&PrgInit.bool_mplayer,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_M4A,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_M4A,		FILE_IS_APE,			"MPLAYER",				&PrgInit.bool_mplayer,		"MAC",		&PrgInit.bool_ape },
{FILE_IS_M4A,		FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_MPC,		FILE_IS_MPC,			"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_MPC,		FILE_IS_WAV,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	NULL,		NULL },
{FILE_IS_MPC,		FILE_IS_MP3,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"LAME",		&PrgInit.bool_lame },
{FILE_IS_MPC,		FILE_IS_OGG,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_MPC,		FILE_IS_FLAC,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"FLAC",		&PrgInit.bool_flac },
{FILE_IS_MPC,		FILE_IS_M4A,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"FAAC",		&PrgInit.bool_faac },
{FILE_IS_MPC,		FILE_IS_AAC,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_MPC,		FILE_IS_APE,			"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"MAC",		&PrgInit.bool_ape },
{FILE_IS_MPC,		FILE_IS_WAVPACK,		"MPPDEC",				&PrgInit.bool_mpc123_mppdec,	"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_APE,		FILE_IS_WAV,			"MAC",					&PrgInit.bool_ape,		NULL,		NULL },
{FILE_IS_APE,		FILE_IS_MP3,			"MAC",					&PrgInit.bool_ape,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_APE,		FILE_IS_OGG,			"MAC",					&PrgInit.bool_ape,		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_APE,		FILE_IS_FLAC,			"MAC",					&PrgInit.bool_ape,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_APE,		FILE_IS_M4A,			"MAC",					&PrgInit.bool_ape,		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_APE,		FILE_IS_AAC,			"MAC",					&PrgInit.bool_ape,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_APE,		FILE_IS_MPC,			"MAC",					&PrgInit.bool_ape,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_APE,		FILE_IS_WAVPACK,		"MAC",					&PrgInit.bool_ape,		"WAVPACK",	&PrgInit.bool_wavpack },

{FILE_IS_WAVPACK,	FILE_TO_REPLAYGAIN,		"WVGAIN",				&PrgInit.bool_wavpack,		NULL,		NULL },
{FILE_IS_WAVPACK,	FILE_IS_WAVPACK,		"MPLAYER",				&PrgInit.bool_mplayer,		NULL,		NULL },
{FILE_IS_WAVPACK,	FILE_IS_WAV,			"WVUNPACK",				&PrgInit.bool_wavpack,		NULL,		NULL },
{FILE_IS_WAVPACK,	FILE_IS_MP3,			"WVUNPACK",				&PrgInit.bool_wavpack,		"LAME",		&PrgInit.bool_lame },
{FILE_IS_WAVPACK,	FILE_IS_OGG,			"WVUNPACK",				&PrgInit.bool_wavpack,		"OGGENC",	&PrgInit.bool_oggenc },
{FILE_IS_WAVPACK,	FILE_IS_FLAC,			"WVUNPACK",				&PrgInit.bool_wavpack,		"FLAC",		&PrgInit.bool_flac },
{FILE_IS_WAVPACK,	FILE_IS_M4A,			"WVUNPACK",				&PrgInit.bool_wavpack,		"FAAC",		&PrgInit.bool_faac },
{FILE_IS_WAVPACK,	FILE_IS_AAC,			"WVUNPACK",				&PrgInit.bool_wavpack,		"AACPLUSENC",	&PrgInit.bool_aacplusenc },
{FILE_IS_WAVPACK,	FILE_IS_MPC,			"WVUNPACK",				&PrgInit.bool_wavpack,		"MPPENC",	&PrgInit.bool_mppenc },
{FILE_IS_WAVPACK,	FILE_IS_APE,			"WVUNPACK",				&PrgInit.bool_wavpack,		"MAC",		&PrgInit.bool_ape },

{-1}
};

gboolean file_bool_from_to (DETAIL *detail, TYPE_FILE_IS to, gboolean is_mess)
{
	gint	     Cpt;
	TYPE_FILE_IS from = detail->type_infosong_file_is;

	/*PRINT_FUNC_LF();*/
	for (Cpt = 0; TstFrom [ Cpt ].From != -1; Cpt ++) {
		if (from == TstFrom [ Cpt ].From && to == TstFrom [ Cpt ].To) {
			if (is_mess) {
				utils_set_prg_not_found (TstFrom [ Cpt ].Conv1, *TstFrom [ Cpt ].Bool1);
				if (TstFrom [ Cpt ].Conv2 != NULL) {
					utils_set_prg_not_found (TstFrom [ Cpt ].Conv2, *TstFrom [ Cpt ].Bool2);
				}
			}
			if (TstFrom [ Cpt ].Conv2 != NULL) {
				return (*TstFrom [ Cpt ].Bool1 & *TstFrom [ Cpt ].Bool2);
			}
			else {
				return (*TstFrom [ Cpt ].Bool1);
			}
		}
	}
	
	return FALSE;
}

GdkPixbuf *file_get_pixbuf_trash (DETAIL *detail, gboolean p_bool_next)
{
	FIC       *fic = (FIC *)detail->fic;

	/*PRINT_FUNC_LF();*/
	if (fic->EtatTrash == FILE_TRASH_NONE) {

		if (p_bool_next == TRUE){
			fic->EtatTrash = FILE_TRASH_OK;
			return (var_file.Pixbuf_Trash);
		}
		return (var_file.Pixbuf_NoTrash);
	}
	else if (fic->EtatTrash == FILE_TRASH_OK) {

		if (p_bool_next == TRUE){
			fic->EtatTrash = FILE_TRASH_NONE;
			return (var_file.Pixbuf_NoTrash);
		}

		return (var_file.Pixbuf_Trash);
	}

	return ((GdkPixbuf *)NULL);
}

GdkPixbuf *file_get_pixbuf_play (DETAIL *detail, ETAT_PLAY_FILE etat)
{
	GdkPixbuf *PixBuf = NULL;

	/*PRINT_FUNC_LF();*/
	if (detail->type_infosong_file_is == FILE_IS_FLAC ||
		detail->type_infosong_file_is == FILE_IS_WAV ||
		detail->type_infosong_file_is == FILE_IS_MP3 ||
		detail->type_infosong_file_is == FILE_IS_OGG ||
		detail->type_infosong_file_is == FILE_IS_M4A ||
		detail->type_infosong_file_is == FILE_IS_WMA ||
		detail->type_infosong_file_is == FILE_IS_RM  ||
		detail->type_infosong_file_is == FILE_IS_DTS ||
		detail->type_infosong_file_is == FILE_IS_AIFF ||
		detail->type_infosong_file_is == FILE_IS_MPC ||
		detail->type_infosong_file_is == FILE_IS_WAVPACK ||
		detail->type_infosong_file_is == FILE_IS_APE ||
		detail->type_infosong_file_is == FILE_IS_SHN) {
		if (PrgInit.bool_mplayer == FALSE) {
			utils_set_prg_not_found ("MPLAYER", PrgInit.bool_mplayer);
			PixBuf = var_file.Pixbuf_NotInstall;
		}
	}
	if (PixBuf == NULL) {
		if (etat == FILE_ETAT_PLAY)			PixBuf = var_file.Pixbuf_FilePlay;
		else if (etat == FILE_ETAT_PLAY_ATTENTE)	PixBuf = var_file.Pixbuf_FileStop;
		else if (etat == FILE_ETAT_PLAY_PRG_ABSENT)	PixBuf = NULL;
		else if (etat == FILE_ETAT_PLAY_NONE)		PixBuf = NULL;
	}
	return ((GdkPixbuf *)PixBuf);
}

void file_button_conv_file_clicked (void)
{
	/*PRINT_FUNC_LF();*/

	if (entetefile) {

		GtkTreeIter     iter;
		gboolean        valid;
		DETAIL         *detail = NULL;
		FIC            *fic = NULL;
		GList          *list = NULL;
		GdkPixbuf      *PixBuf = NULL;

		/* Arret du fichier en ecoute */
		list = g_list_first (entetefile);
		while (list) {
			if ((detail = (DETAIL *)list->data)) {
				if ((fic = (FIC *)detail->fic)) {
					if (fic->EtatPlay == FILE_ETAT_PLAY) {
						fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
						mplayer_fifo_quit ();
					}
				}
			}
			list = g_list_next (list);
		}

		/* Si icone PLAY alors icone READY */
		valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
		while (valid) {
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			fic = (FIC *)detail->fic;
			PixBuf = file_get_pixbuf_play (detail, fic->EtatPlay);

			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, PixBuf, -1);
			valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
		}

		/* La normalisation des fichiers se fait a la fin de la conversion des fichiers */
		fileaction_choice ();
	}
}

gboolean file_get_next_flag_test_expert (DETAIL *detail, TYPE_FILE_IS type)
{

	if (detail->type_infosong_file_is == FILE_IS_FLAC ||
		detail->type_infosong_file_is == FILE_IS_WAV ||
		detail->type_infosong_file_is == FILE_IS_MP3 ||
		detail->type_infosong_file_is == FILE_IS_OGG ||
		detail->type_infosong_file_is == FILE_IS_M4A ||
		detail->type_infosong_file_is == FILE_IS_AAC ||
		detail->type_infosong_file_is == FILE_IS_MPC ||
		detail->type_infosong_file_is == FILE_IS_APE ||
		detail->type_infosong_file_is == FILE_IS_WAVPACK) {

		if (type == FILE_IS_FLAC)	return (options_get_entry_is_valid (FLAC_WAV_TO_FLAC));
		if (type == FILE_IS_WAV)	return (FALSE);
		if (type == FILE_IS_MP3)	return (options_get_entry_is_valid (LAME_WAV_TO_MP3));
		if (type == FILE_IS_OGG)	return (options_get_entry_is_valid (OGGENC_WAV_TO_OGG));
		if (type == FILE_IS_M4A)	return (options_get_entry_is_valid (FAAC_WAV_TO_M4A));
		if (type == FILE_IS_AAC)	return (options_get_entry_is_valid (AACPLUSENC_WAV_TO_AAC));
		if (type == FILE_IS_MPC)	return (options_get_entry_is_valid (MPPENC_WAV_TO_MPC));
		if (type == FILE_IS_APE)	return (options_get_entry_is_valid (MAC_WAV_TO_APE));
		if (type == FILE_IS_WAVPACK)	return (options_get_entry_is_valid (WAVPACK_WAV_TO_WAVPACK));

	}
	return (FALSE);
}

ETAT_SELECTION file_get_next_flag (DETAIL *detail, TYPE_FILE_IS type, gboolean p_next)
{
	FIC             *fic = (FIC *)detail->fic;
	ETAT_SELECTION   etat = ETAT_ATTENTE;
	gboolean         op_expert = FALSE;
	gboolean         file_exist = FALSE;

	if (!fic) return (etat);
	if (detail->type_infosong_file_is == type) return (ETAT_PRG_NONE);
	if (!file_bool_from_to (detail, type, FALSE)) return (ETAT_PRG_ABSENT);

	/* PRINT_FUNC_LF(); */

	file_exist = fileanalyze_exist (detail, type);

	if (type == FILE_IS_FLAC)	etat = fic->EtatSelection_Flac;
	if (type == FILE_IS_WAV)	etat = fic->EtatSelection_Wav;
	if (type == FILE_IS_MP3)	etat = fic->EtatSelection_Mp3;
	if (type == FILE_IS_OGG)	etat = fic->EtatSelection_Ogg;
	if (type == FILE_IS_M4A)	etat = fic->EtatSelection_M4a;
	if (type == FILE_IS_AAC)	etat = fic->EtatSelection_Aac;
	if (type == FILE_IS_MPC)	etat = fic->EtatSelection_Mpc;
	if (type == FILE_IS_APE)	etat = fic->EtatSelection_Ape;
	if (type == FILE_IS_WAVPACK)	etat = fic->EtatSelection_WavPack;

	op_expert = file_get_next_flag_test_expert (detail, type);

	switch (etat) {
	case ETAT_PRG_NONE :
		if (type == FILE_IS_FLAC) {
			return (fileanalyze_exist (detail, FILE_IS_FLAC) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_WAV) {
			return (fileanalyze_exist (detail, FILE_IS_WAV) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_MP3) {
			return (fileanalyze_exist (detail, FILE_IS_MP3) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_OGG) {
			return (fileanalyze_exist (detail, FILE_IS_OGG) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_M4A) {
			return (fileanalyze_exist (detail, FILE_IS_M4A) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_AAC) {
			return (fileanalyze_exist (detail, FILE_IS_AAC) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_MPC) {
			return (fileanalyze_exist (detail, FILE_IS_MPC) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_APE) {
			return (fileanalyze_exist (detail, FILE_IS_APE) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		else if (type == FILE_IS_WAVPACK) {
			return (fileanalyze_exist (detail, FILE_IS_WAVPACK) ? ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
		}
		return (ETAT_PRG_NONE);

	case ETAT_PRG_ABSENT :
		return (ETAT_PRG_ABSENT);

	case ETAT_ATTENTE :
		if (p_next == TRUE) {
			if (file_exist) {
				return (ETAT_SELECT_EXIST);
			}
			return (ETAT_SELECT);
		}
		if (file_exist) return (ETAT_ATTENTE_EXIST);
		return (ETAT_ATTENTE);

	case ETAT_ATTENTE_EXIST :
		if (p_next == TRUE) {
			if (file_exist) {
				return (ETAT_SELECT_EXIST);
			}
			return (ETAT_SELECT);
		}
		if (file_exist) return (ETAT_ATTENTE_EXIST);
		return (ETAT_ATTENTE);

	case ETAT_SELECT :
		if (p_next == TRUE) {
			if (file_exist) {
				if (op_expert == TRUE) return (ETAT_SELECT_EXPERT_EXIST);
				return (ETAT_ATTENTE_EXIST);
			}
			if (op_expert == TRUE) return (ETAT_SELECT_EXPERT);
			return (ETAT_ATTENTE);
		}
		if (file_exist) return (ETAT_SELECT_EXIST);
		return (ETAT_SELECT);

	case ETAT_SELECT_EXIST :
		if (p_next == TRUE) {
			if (file_exist) {
				if (op_expert == TRUE) return (ETAT_SELECT_EXPERT_EXIST);
				return (ETAT_ATTENTE_EXIST);
			}
			if (op_expert == TRUE) return (ETAT_SELECT_EXPERT);
			return (ETAT_ATTENTE);
		}
		if (!file_exist) return (ETAT_SELECT);
		return (ETAT_SELECT_EXIST);

	case ETAT_SELECT_EXPERT :
		if (p_next == TRUE) {
			if (file_exist) {
				return (ETAT_ATTENTE_EXIST);
			}
			return (ETAT_ATTENTE);
		}
		if (file_exist) return (ETAT_SELECT_EXPERT_EXIST);
		return (ETAT_SELECT_EXPERT);

	case ETAT_SELECT_EXPERT_EXIST :
		if (p_next == TRUE) {
			if (file_exist) {
				return (ETAT_ATTENTE_EXIST);
			}
			return (ETAT_ATTENTE);
		}
		if (!file_exist) return (ETAT_SELECT_EXPERT);
		return (ETAT_SELECT_EXPERT_EXIST);
	}

	return (ETAT_ATTENTE);
}
/* Cette fonction retourne le type de PixBuf
*/
GdkPixbuf *file_get_pixbuf_file (DETAIL *detail, TYPE_FILE_IS type)
{
	FIC             *fic = (FIC *)detail->fic;
	ETAT_SELECTION   etat = ETAT_ATTENTE;

	/* PRINT_FUNC_LF(); */

	if (detail->type_infosong_file_is == type) return (NULL);

	if (!file_bool_from_to (detail, type, FALSE)) return (var_file.Pixbuf_NotInstall);

	if (type == FILE_IS_FLAC)         etat = fic->EtatSelection_Flac    = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_WAV)     etat = fic->EtatSelection_Wav     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_OGG)     etat = fic->EtatSelection_Ogg     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_MP3)     etat = fic->EtatSelection_Mp3     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_M4A)     etat = fic->EtatSelection_M4a     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_AAC)     etat = fic->EtatSelection_Aac     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_MPC)     etat = fic->EtatSelection_Mpc     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_APE)     etat = fic->EtatSelection_Ape     = file_get_next_flag (detail, type, FALSE);
	else if (type == FILE_IS_WAVPACK) etat = fic->EtatSelection_WavPack = file_get_next_flag (detail, type, FALSE);

	switch (etat) {
	case ETAT_PRG_NONE :
		return (NULL);
	case ETAT_PRG_ABSENT :
		return (var_file.Pixbuf_NotInstall);
	case ETAT_ATTENTE :
		return (var_file.Pixbuf_Coche);
	case ETAT_ATTENTE_EXIST :
		return (var_file.Pixbuf_Coche_exist);
	case ETAT_SELECT :
		return (var_file.Pixbuf_Selected);
	case ETAT_SELECT_EXIST :
		return (var_file.Pixbuf_Selected_exist);
	case ETAT_SELECT_EXPERT :
		return (var_file.Pixbuf_Selected_expert);
	case ETAT_SELECT_EXPERT_EXIST :
		return (var_file.Pixbuf_Selected_expert_exist);
	}

	return (NULL);
}


/* Cette fonction retourne un type de PixBuf refletant l'etat du ReplayGain
*/
GdkPixbuf *file_get_pixbuf_replaygain (DETAIL *detail, gboolean p_bool_next)
{
	GdkPixbuf *PixBuf = NULL;
	FIC       *fic = (FIC *)detail->fic;

	if (!fic) return (NULL);

	switch (detail->type_infosong_file_is) {
	case FILE_IS_NONE :
	case FILE_IS_WAV :
	case FILE_IS_M4A :
	case FILE_IS_AAC :
	case FILE_IS_SHN :
	case FILE_IS_WMA :
	case FILE_IS_RM :
	case FILE_IS_DTS :
	case FILE_IS_AIFF :
	case FILE_IS_APE :
	case FILE_IS_WAVPACK_MD5 :
	case FILE_TO_NORMALISE :
	case FILE_TO_NORMALISE_COLLECTIF :
	case FILE_TO_REPLAYGAIN :
	case FILE_IS_IMG :
	case FILE_IS_HTML :
	case FILE_IS_TXT :
	case FILE_IS_XCFA_GEN_CONF :
	case FILE_IS_CUE :
	/*
	Remarque de @Shankarius:
	je me demande si le support du ReplayGain pour MusePack est vraiment souhaitable du
	fait qu'il ne se trouve pas dans les depots, de l'impossibilite de supprimer les tags
	et de la doc plus que limitee le concernant...
	*/
	case FILE_IS_MPC :
		break;
	case FILE_IS_MP3 :
	case FILE_IS_OGG :
	case FILE_IS_WAVPACK :
		if (detail->type_infosong_file_is == FILE_IS_MP3 && ! PrgInit.bool_mp3gain) return (var_file.Pixbuf_NotInstall);
		if (detail->type_infosong_file_is == FILE_IS_OGG && ! PrgInit.bool_vorbisgain) return (var_file.Pixbuf_NotInstall);
		if (detail->type_infosong_file_is == FILE_IS_WAVPACK && ! PrgInit.bool_wavpack) return (var_file.Pixbuf_NotInstall);

		switch (fic->Etat_ReplayGain) {
		case RPG_NONE :
			return (NULL);
		case RPG_ATTENTE :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_PISTE;
				return (var_file.Pixbuf_rpg_piste);
			}
			return (var_file.Pixbuf_rpg_wait);
		case RPG_PISTE :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_ALBUM;
				return (var_file.Pixbuf_rpg_album);
			}
			return (var_file.Pixbuf_rpg_piste);
		case RPG_ALBUM :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_EFFACER;
				return (var_file.Pixbuf_rpg_effacer);
			}
			return (var_file.Pixbuf_rpg_album);
		case RPG_EFFACER :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_ATTENTE;
				return (var_file.Pixbuf_rpg_wait);
			}
			return (var_file.Pixbuf_rpg_effacer);
		}
		break;
	case FILE_IS_FLAC :
		if (! PrgInit.bool_flac) return (var_file.Pixbuf_NotInstall);

		switch (fic->Etat_ReplayGain) {
		case RPG_NONE :
			return (NULL);
		case RPG_ATTENTE :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_ALBUM;
				return (var_file.Pixbuf_rpg_album);
			}
			return (var_file.Pixbuf_rpg_wait);
		case RPG_PISTE :
			fic->Etat_ReplayGain = RPG_ATTENTE;
			return (var_file.Pixbuf_rpg_wait);
		case RPG_ALBUM :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_EFFACER;
				return (var_file.Pixbuf_rpg_effacer);
			}
			return (var_file.Pixbuf_rpg_album);
		case RPG_EFFACER :
			if (p_bool_next) {
				fic->Etat_ReplayGain = RPG_ATTENTE;
				return (var_file.Pixbuf_rpg_wait);
			}
			return (var_file.Pixbuf_rpg_effacer);
		}
	}

	return ((GdkPixbuf *)PixBuf);
}


gchar *file_get_value_pixbuf_normalize (DETAIL *detail)
{
	FIC       *fic = (FIC *)detail->fic;

	/* PRINT_FUNC_LF(); */
	if (!fic) return (NULL);

	if (detail->type_infosong_file_is == FILE_IS_WAV || detail->type_infosong_file_is == FILE_IS_MP3 || detail->type_infosong_file_is == FILE_IS_OGG) {
		if (detail->type_infosong_file_is == FILE_IS_WAV) {
			return (g_strdup ("dB"));
		}
		else if (detail->type_infosong_file_is == FILE_IS_MP3) {
			return (g_strdup ("dB"));
		}
		else if (detail->type_infosong_file_is == FILE_IS_OGG) {
			return (g_strdup ("dB"));
		}
	}
	return (g_strdup (""));
}

gchar *file_get_time_file (DETAIL *detail)
{
	gchar *ptr = NULL;

	if (detail->type_infosong_file_is == FILE_IS_FLAC) {
		INFO_FLAC *info = (INFO_FLAC *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_WAV) {
		INFO_WAV *info = (INFO_WAV *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_MP3) {
		INFO_MP3 *info = (INFO_MP3 *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_OGG) {
		INFO_OGG *info = (INFO_OGG *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_M4A) {
		INFO_M4A *info = (INFO_M4A *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_AAC) {
		INFO_AAC *info = (INFO_AAC *)detail->info;
		if ((INFO_AAC *)info)
			ptr = info->time;
	}

	/* Infos obtenues via SHNTOOL
	*/
	else if (detail->type_infosong_file_is == FILE_IS_APE) {
		INFO_APE *info = (INFO_APE *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_SHN) {
		INFO_SHN *info = (INFO_SHN *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
		INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;
		ptr = info->time;
	}

	return (ptr);
}
guint file_get_time_in_secondes (DETAIL *detail)
{
	guint Sectime = 0;
	if (detail->type_infosong_file_is == FILE_IS_MP3) {

		INFO_MP3 *info = (INFO_MP3 *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	else if (detail->type_infosong_file_is == FILE_IS_OGG) {

		INFO_OGG *info = (INFO_OGG *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	else if (detail->type_infosong_file_is == FILE_IS_WAV) {

		INFO_WAV *info = (INFO_WAV *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	else if (detail->type_infosong_file_is == FILE_IS_FLAC) {
		INFO_FLAC *info = (INFO_FLAC *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	else if (detail->type_infosong_file_is == FILE_IS_SHN) {
		INFO_SHN *info = (INFO_SHN *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	else if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
		INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;
		Sectime   = info->ValueMark.SecTime;
	}
	return (Sectime);
}

void file_clear_all_pixbuf_file_play (void)
{
	DETAIL         *detail = NULL;
	FIC            *fic = NULL;
	GList          *list = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
				fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
			}
		}
		list = g_list_next (list);
	}
}
/* FILE_ETAT_PLAY_ATTENTE
   FILE_ETAT_PLAY
   */
void file_set_etat_music_pixbuf_with_detail (DETAIL *p_detail, ETAT_PLAY_FILE EtatPlay)
{
	DETAIL         *detail = NULL;
	FIC            *fic = NULL;
	GdkPixbuf      *Pixbuf = NULL;
	GtkTreeIter     iter;
	gboolean        valid;

	/* Tous les flags et widget sur FILE_ETAT_PLAY_ATTENTE */
	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail) {
			if ((fic = (FIC *)detail->fic)) {
				fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
				Pixbuf  = file_get_pixbuf_play (detail, fic->EtatPlay);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, Pixbuf, -1);
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}

	if (EtatPlay == FILE_ETAT_PLAY) {
		valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
		while (valid) {
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if (detail && detail == p_detail) {
				if ((fic = (FIC *)detail->fic)) {
					fic->EtatPlay = FILE_ETAT_PLAY;
					Pixbuf  = file_get_pixbuf_play (detail, fic->EtatPlay);
					gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, Pixbuf, -1);
				}
			}
			valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
		}
	}
}

void file_del_all_pixbuf_file_play (void)
{
	DETAIL         *detail = NULL;
	FIC            *fic = NULL;
	GdkPixbuf      *Pixbuf = NULL;
	GtkTreeIter     iter;
	gboolean        valid;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {
			if (fic->EtatPlay == FILE_ETAT_PLAY) fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
			Pixbuf  = file_get_pixbuf_play (detail, fic->EtatPlay);
		}
		gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, Pixbuf, -1);
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

void file_affiche_all_pixbuf_file_play (void)
{
	DETAIL         *detail = NULL;
	FIC            *fic = NULL;
	GdkPixbuf      *Pixbuf = NULL;
	GtkTreeIter     iter;
	gboolean        valid;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {
			Pixbuf  = file_get_pixbuf_play (detail, fic->EtatPlay);
		}
		gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, Pixbuf, -1);
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

/* Mise a jour du champs 'time' de 'EnteteWav.glist' apres une operation de 'SOX'
*  --
*  entree : -
*  retour : -
*/
void file_UpdateTime_glist (void)
{
	DETAIL        *detail = NULL;
	GtkTreeIter    iter;
	gboolean       valid;

	/*PRINT_FUNC_LF();*/
	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

		if (detail->type_infosong_file_is == FILE_IS_FLAC) {
			INFO_FLAC *info = (INFO_FLAC *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}
		else if (detail->type_infosong_file_is == FILE_IS_WAV) {
			INFO_WAV *info = (INFO_WAV *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}
		else if (detail->type_infosong_file_is == FILE_IS_MP3) {
			INFO_MP3 *info = (INFO_MP3 *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}
		else if (detail->type_infosong_file_is == FILE_IS_OGG) {
			INFO_OGG *info = (INFO_OGG *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}
		else if (detail->type_infosong_file_is == FILE_IS_M4A) {
			INFO_M4A *info = (INFO_M4A *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}
		else if (detail->type_infosong_file_is == FILE_IS_AAC) {
			INFO_AAC *info = (INFO_AAC *)detail->info;
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_TIME, info->time, -1);
		}

		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

/* Mise a jour (par defaut) de frequence, piste(voie) et Bits
*/
void file_update_glist_wav (void)
{
	DETAIL        *detail = NULL;
	FIC_WAV       *FicWav = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	gchar          *Str = NULL;
	INFO_WAV       *info = NULL;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((FicWav = (FIC_WAV *)detail->fic_wav)) {

			info = (INFO_WAV *)detail->info;
			detail->info = (INFO_WAV *)tagswav_remove_info (info);
			info = NULL;
			detail->info = (INFO_WAV *)tagswav_get_info (detail, detail->namefile);
			info = (INFO_WAV *)detail->info;

			g_free (FicWav->Hertz);
			FicWav->Hertz = NULL;
			FicWav->Hertz = g_strdup (info->hertz);

			g_free (FicWav->NewHertz);
			FicWav->NewHertz = NULL;
			FicWav->NewHertz = g_strdup (info->hertz);

			g_free (FicWav->Voie);
			FicWav->Voie = NULL;
			FicWav->Voie = g_strdup (info->voie);

			g_free (FicWav->NewVoie);
			FicWav->NewVoie = NULL;
			FicWav->NewVoie = g_strdup (info->voie);

			g_free (FicWav->Bits);
			FicWav->Bits = NULL;
			FicWav->Bits = g_strdup (info->bits);

			g_free (FicWav->NewBits);
			FicWav->NewBits = NULL;
			FicWav->NewBits = g_strdup (info->bits);

			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_HERTZ, FicWav->Hertz, -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_VOIE, FicWav->Voie, -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_BITS, FicWav->Bits, -1);

			Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Hertz);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, Str, -1);
			g_free (Str);
			Str = NULL;

			Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Voie);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, Str, -1);
			g_free (Str);
			Str = NULL;

			Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Bits);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, Str, -1);
			g_free (Str);
			Str = NULL;
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

gchar *file_get_size (DETAIL *detail);
gchar *file_get_time (DETAIL *detail);


void file_update_glist_file_MP3OGG (void)
{
	DETAIL        *detail = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	FIC_MP3OGG    *fic = NULL;
	gchar         *Str = NULL;

	PRINT_FUNC_LF();

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

		if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {

			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_BITRATE, fic->Bitrate, -1);

			/*g_free (fic->NewBitrate);*/
			/*fic->NewBitrate = NULL;*/
			/*fic->NewBitrate = g_strdup (fic->Bitrate);*/

			/*Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", fic->NewBitrate);*/
			Str = g_strdup ("");
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, Str, -1);
			g_free (Str);
			Str = NULL;

			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_SIZE, file_get_size (detail), -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_TIME, file_get_time (detail), -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NAME, file_make_pathname_file (detail, FALSE), -1);
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}


/* Mise a jour des champs 'pixbuf' de 'EnteteWav.glist' apres une operation de conversion
*  --
*  entree : -
*  retour : -
*/
void file_pixbuf_update_glist_file (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GdkPixbuf     *pixbuf = NULL;

	if (var_file.PageNum != NOTEBOOK_FICHIERS_CONVERSION && var_file.PageNum != NOTEBOOK_FICHIERS_TAGS) return;
	if (var_file.Adr_Tree_Model == NULL) return;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail) {
			if ((fic = (FIC *)detail->fic)) {
				pixbuf  = file_get_pixbuf_play (detail, fic->EtatPlay);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_PLAY, pixbuf, -1);
			}
			pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_FLAC, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAV, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MP3, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_OGG, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_M4A, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_AAC, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MPC, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_APE, pixbuf, -1);

			pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAVPACK, pixbuf, -1);

			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_NORMALIZE, file_get_str_level_normalise (detail), -1);

			pixbuf = file_get_pixbuf_replaygain (detail, FALSE);
			gtk_list_store_set (
					var_file.Adr_List_Store,
					&iter,
					COLUMN_FILE_REPLAYGAIN,
					pixbuf,
					-1);
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}

	file_set_flag_buttons_audio_file ();
}

/* Cette fonction indique qu'une modif de tag a eu lieu.
*  Flag modifie         : colonne TYPE en rouge gras
*  Apres une sauvegarde : colonne TYPE normale
*/
void file_affiche_type (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	TAGS          *tags = NULL;

	/*PRINT_FUNC_LF();*/

	if (var_file.Adr_Tree_Model == NULL) return;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail && (detail->type_infosong_file_is == FILE_IS_FLAC || detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_OGG || detail->type_infosong_file_is == FILE_IS_MPC)) {
			if ((tags = (TAGS *)filexpander_get_tag (detail))) {

				gchar        *old_text = NULL;
				GtkTreeModel *model = var_file.Adr_Tree_Model;

				gtk_tree_model_get (model, &iter, COLUMN_FILE_TYPE, &old_text, -1);
				g_free (old_text);
				old_text = NULL;

				if (tags->bool_save == TRUE) {

					gtk_list_store_set (var_file.Adr_List_Store,
						&iter,
						COLUMN_FILE_TYPE,
						g_strdup_printf ("<span color=\"red\"><b>%s</b></span>",
								infosong_get_str_type_file_is (detail->type_infosong_file_is)),
						-1);
				}
				else {
					gtk_list_store_set (var_file.Adr_List_Store,
						&iter,
						COLUMN_FILE_TYPE,
						g_strdup (infosong_get_str_type_file_is (detail->type_infosong_file_is)),
						-1);
				}

			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

gboolean file_is_dupply (gchar *namefile)
{
	GtkTreeIter    iter;
	DETAIL        *detail = NULL;
	gboolean       valid;

	if (var_file.Adr_Tree_Model == NULL) return (FALSE);

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail) {
			if (strcmp (namefile, detail->namefile) == 0) return (TRUE);
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	return (FALSE);
}

gchar *file_get_size (DETAIL *detail)
{
	gchar *ptr = NULL;

	if (detail->type_infosong_file_is == FILE_IS_MP3) {
		INFO_MP3 *info = (INFO_MP3 *)detail->info;
		ptr = info->size;
	}
	else if (detail->type_infosong_file_is == FILE_IS_OGG) {
		INFO_OGG *info = (INFO_OGG *)detail->info;
		ptr = info->size;
	}

	return (ptr);
}
gchar *file_get_time (DETAIL *detail)
{
	gchar *ptr = NULL;

	if (detail->type_infosong_file_is == FILE_IS_FLAC) {
		INFO_FLAC *info = (INFO_FLAC *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_WAV) {
		INFO_WAV *info = (INFO_WAV *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_MP3) {
		INFO_MP3 *info = (INFO_MP3 *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_OGG) {
		INFO_OGG *info = (INFO_OGG *)detail->info;
		ptr = info->time;
	}
	else if (detail->type_infosong_file_is == FILE_IS_M4A) {
		INFO_M4A *info = (INFO_M4A *)detail->info;
		ptr = info->time;
	}
	return (ptr);
}

DETAIL *file_is_selected_file (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *BeginList = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	if (var_file.Adr_TreeView == NULL) return (NULL);
	if (var_file.Adr_Line_Selected == NULL) return (NULL);

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	BeginList = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (BeginList);
	if (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		}
	}
	return (detail);
}

void file_affiche_glist_file (void)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	FIC_WAV       *FicWav = NULL;
	FIC_MP3OGG    *FicMp3Ogg = NULL;
	GList         *list = NULL;
	GtkTreeIter    iter;
	ARTICLES_FILE  Foo;
	gboolean       BoolPrint = FALSE;
	GtkAdjustment *Adj = NULL;
	gdouble        AdjValue;

	// PRINT_FUNC_LF();

	var_file.BOOL_ENTER = FALSE;
	gtk_list_store_clear (GTK_LIST_STORE (var_file.Adr_List_Store));

	/* Reajustement de la liste */
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_file.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_file.Adr_scroll), Adj);

	list = g_list_first (entetefile);
	while (list) {
		if (!(detail = (DETAIL *)list->data)) {
			list = g_list_next(list);
			continue;
		}

		switch (detail->choice_treeview) {
		case _TREEVIEW_ALL_ :
		case _TREEVIEW_SPLIT_ALL_ :
			break;
		case _TREEVIEW_SPLIT_ :
			list = g_list_next(list);
			continue;
			break;
		}

		fic = (FIC *)detail->fic;
		FicWav = (FIC_WAV *)detail->fic_wav;
		FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg;

		switch (var_file.PageNum) {
		case NOTEBOOK_FICHIERS_CONVERSION :
		case NOTEBOOK_FICHIERS_TAGS :
			if ((fic = (FIC *)detail->fic) == NULL) {
				list = g_list_next(list);
				continue;
			}
			break;
		case NOTEBOOK_FICHIERS_WAV :
			if ((FicWav = (FIC_WAV *)detail->fic_wav) == NULL) {
				list = g_list_next(list);
				continue;
			}
			break;
		case NOTEBOOK_FICHIERS_MP3OGG :
			if ((FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg) == NULL) {
				list = g_list_next(list);
				continue;
			}
			break;
		}

		if (file_is_dupply (detail->namefile) == TRUE) {
			list = g_list_next(list);
			continue;
		}

		Foo.ColumnFilePlay		= NULL;
		Foo.ColumnFileTrash		= NULL;
		Foo.ColumnFileType		= NULL;
		Foo.ColumnFileFlac		= NULL;
		Foo.ColumnFileWav		= NULL;
		Foo.ColumnFileMp3		= NULL;
		Foo.ColumnFileOgg		= NULL;
		Foo.ColumnFileM4a		= NULL;
		Foo.ColumnFileAac		= NULL;
		Foo.ColumnFileMpc		= NULL;
		Foo.ColumnFileApe		= NULL;
		Foo.ColumnFileWavPack		= NULL;
		Foo.ColumnFileTime		= NULL;
		Foo.ColumnFileNormalize		= NULL;
		Foo.ColumnFileReplayGain	= NULL;
		Foo.ColumnFileName		= NULL;
		Foo.ColumnFileEditable		= TRUE;

		Foo.ColumnFileWavHertz		= NULL;
		Foo.ColumnFileWavVoie		= NULL;
		Foo.ColumnFileWavBits		= NULL;
		Foo.ColumnFileWavNewHertz	= NULL;
		Foo.ColumnFileWavNewVoie	= NULL;
		Foo.ColumnFileWavNewBits	= NULL;
		Foo.ColumnFileWavName		= NULL;

		Foo.ColumnFileMp3OggType	= NULL;
		Foo.ColumnFileMp3OggBitrate	= NULL;
		Foo.ColumnFileMp3OggNewBitrate	= NULL;
		Foo.ColumnFileMp3OggSize	= NULL;
		Foo.ColumnFileMp3OggTime	= NULL;
		Foo.ColumnFileMp3OggName	= NULL;

		switch (var_file.PageNum) {
		case NOTEBOOK_FICHIERS_CONVERSION :
		case NOTEBOOK_FICHIERS_TAGS :
			Foo.ColumnFilePlay		= file_get_pixbuf_play (detail, fic->EtatPlay);
			Foo.ColumnFileTrash		= file_get_pixbuf_trash (detail, FALSE);
			Foo.ColumnFileType		= g_strdup (infosong_get_str_type_file_is (detail->type_infosong_file_is));
			Foo.ColumnFileFlac		= file_get_pixbuf_file (detail, FILE_IS_FLAC);
			Foo.ColumnFileWav		= file_get_pixbuf_file (detail, FILE_IS_WAV);
			Foo.ColumnFileMp3		= file_get_pixbuf_file (detail, FILE_IS_MP3);
			Foo.ColumnFileOgg		= file_get_pixbuf_file (detail, FILE_IS_OGG);
			Foo.ColumnFileM4a		= file_get_pixbuf_file (detail, FILE_IS_M4A);
			Foo.ColumnFileAac		= file_get_pixbuf_file (detail, FILE_IS_AAC);
			Foo.ColumnFileMpc		= file_get_pixbuf_file (detail, FILE_IS_MPC);
			Foo.ColumnFileApe		= file_get_pixbuf_file (detail, FILE_IS_APE);
			Foo.ColumnFileWavPack		= file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
			Foo.ColumnFileTime		= g_strdup (file_get_time_file (detail));
			Foo.ColumnFileNormalize		= file_get_str_level_normalise (detail);
			Foo.ColumnFileReplayGain	= file_get_pixbuf_replaygain (detail, FALSE);
			Foo.ColumnFileName		= fileanalyze_get_name_without_path_ext (detail->namefile, FALSE);
			Foo.ColumnFileEditable		= TRUE;
			break;

		case NOTEBOOK_FICHIERS_WAV :
			if (detail->type_infosong_file_is == FILE_IS_WAV &&
			    (FicWav = (FIC_WAV *)detail->fic_wav) != NULL) {
			    	Foo.ColumnFilePlay		= file_get_pixbuf_play (detail, fic->EtatPlay);
				Foo.ColumnFileWavHertz		= g_strdup (FicWav->Hertz);
				Foo.ColumnFileWavVoie		= g_strdup (FicWav->Voie);
				Foo.ColumnFileWavBits		= g_strdup (FicWav->Bits );
				Foo.ColumnFileWavNewHertz	= g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Hertz);
				Foo.ColumnFileWavNewVoie	= g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Voie);
				Foo.ColumnFileWavNewBits	= g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->Bits);
				Foo.ColumnFileWavName		= fileanalyze_get_name_without_path_ext (detail->namefile, FALSE);
			}
			else {
				Foo.ColumnFileWavHertz		= g_strdup ("");
				Foo.ColumnFileWavVoie		= g_strdup ("");
				Foo.ColumnFileWavBits		= g_strdup ("");
				Foo.ColumnFileWavNewHertz	= g_strdup ("");
				Foo.ColumnFileWavNewVoie	= g_strdup ("");
				Foo.ColumnFileWavNewBits	= g_strdup ("");
				Foo.ColumnFileWavName		= g_strdup ("");
			}
			break;

		case NOTEBOOK_FICHIERS_MP3OGG :
			if ((detail->type_infosong_file_is == FILE_IS_MP3 ||
			     detail->type_infosong_file_is == FILE_IS_OGG) &&
			     (FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg) != NULL) {
			   	Foo.ColumnFilePlay		= file_get_pixbuf_play (detail, fic->EtatPlay);
				Foo.ColumnFileMp3OggType	= g_strdup (infosong_get_str_type_file_is (detail->type_infosong_file_is));
				Foo.ColumnFileMp3OggBitrate	= g_strdup (FicMp3Ogg->Bitrate);

				if (detail->type_infosong_file_is == FILE_IS_MP3) {
					// g_print("detail->type_infosong_file_is == FILE_IS_MP3\n");
					Foo.ColumnFileMp3OggNewBitrate	=
						file_get_param_lame_affiche (FicMp3Ogg->Lame.type, FicMp3Ogg->Lame.debit, FicMp3Ogg->Lame.mode);
				} else {
					// g_print("detail->type_infosong_file_is == FILE_IS_OGG\n");
					Foo.ColumnFileMp3OggNewBitrate	=
						file_get_param_oggenc_affiche (FicMp3Ogg->Oggenc.type, FicMp3Ogg->Oggenc.debit, FicMp3Ogg->Oggenc.mode);
				}

				Foo.ColumnFileMp3OggSize	= g_strdup (file_get_size (detail));
				Foo.ColumnFileMp3OggTime	= g_strdup (file_get_time (detail));
				Foo.ColumnFileMp3OggName	= g_strdup (fileanalyze_get_name_without_path_ext (detail->namefile, FALSE));
			}
			else {
				Foo.ColumnFileMp3OggType	= g_strdup ("");
				Foo.ColumnFileMp3OggBitrate	= g_strdup ("");
				Foo.ColumnFileMp3OggNewBitrate	= g_strdup ("");
				Foo.ColumnFileMp3OggSize	= g_strdup ("");
				Foo.ColumnFileMp3OggTime	= g_strdup ("");
				Foo.ColumnFileMp3OggName	= g_strdup ("");
			}
			break;
		}

		Foo.ColumnFileAdrStruct  = detail;

		g_array_append_vals (Articles_file, &Foo, 1);
		gtk_list_store_append (var_file.Adr_List_Store, &iter);
		gtk_list_store_set (var_file.Adr_List_Store, &iter,
				COLUMN_FILE_PLAY,		Foo.ColumnFilePlay,
				COLUMN_FILE_TRASH,		Foo.ColumnFileTrash,
				COLUMN_FILE_TYPE,		Foo.ColumnFileType,
				COLUMN_FILE_FLAC,		Foo.ColumnFileFlac,
				COLUMN_FILE_WAV,		Foo.ColumnFileWav,
				COLUMN_FILE_MP3,		Foo.ColumnFileMp3,
				COLUMN_FILE_OGG,		Foo.ColumnFileOgg,
				COLUMN_FILE_M4A,		Foo.ColumnFileM4a,
				COLUMN_FILE_AAC,		Foo.ColumnFileAac,
				COLUMN_FILE_MPC,		Foo.ColumnFileMpc,
				COLUMN_FILE_APE,		Foo.ColumnFileApe,
				COLUMN_FILE_WAVPACK,		Foo.ColumnFileWavPack,
				COLUMN_FILE_TIME,		Foo.ColumnFileTime,
				COLUMN_FILE_NORMALIZE,		Foo.ColumnFileNormalize,
				COLUMN_FILE_REPLAYGAIN,		Foo.ColumnFileReplayGain,
				COLUMN_FILE_NAME,		Foo.ColumnFileName,
				COLUMN_FILE_EDITABLE,		Foo.ColumnFileEditable,

				COLUMN_FILEWAV_HERTZ,		Foo.ColumnFileWavHertz,
				COLUMN_FILEWAV_NEW_HERTZ,	Foo.ColumnFileWavNewHertz,
				COLUMN_FILEWAV_VOIE,		Foo.ColumnFileWavVoie,
				COLUMN_FILEWAV_NEW_VOIE,	Foo.ColumnFileWavNewVoie,
				COLUMN_FILEWAV_BITS,		Foo.ColumnFileWavBits,
				COLUMN_FILEWAV_NEW_BITS,	Foo.ColumnFileWavNewBits,
				COLUMN_FILEWAV_NAME,		Foo.ColumnFileWavName,

				COLUMN_FILEMP3OGG_TYPE,		Foo.ColumnFileMp3OggType,
				COLUMN_FILEMP3OGG_BITRATE,	Foo.ColumnFileMp3OggBitrate,
				COLUMN_FILEMP3OGG_NEWBITRATE,	Foo.ColumnFileMp3OggNewBitrate,
				COLUMN_FILEMP3OGG_SIZE,		Foo.ColumnFileMp3OggSize,
				COLUMN_FILEMP3OGG_TIME,		Foo.ColumnFileMp3OggTime,
				COLUMN_FILEMP3OGG_NAME,		Foo.ColumnFileMp3OggName,

				COLUMN_FILE_POINTER_STRUCT,	Foo.ColumnFileAdrStruct,
				-1);

		BoolPrint = TRUE;
		list = g_list_next (list);
	}

	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		if (var_file.AdrGlistFile == NULL && BoolPrint == TRUE && file_is_selected_file () == NULL) {
			if (gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter))
				gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
		}
		break;
	case NOTEBOOK_FICHIERS_WAV :
		if (var_file.AdrGlistFileWav == NULL && BoolPrint == TRUE && file_is_selected_file () == NULL) {
			if (gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter))
				gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
		}
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		if (var_file.AdrGlistFileMp3Ogg == NULL && BoolPrint == TRUE && file_is_selected_file () == NULL) {
			if (gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter))
				gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
		}
		break;
	}

	file_set_flag_buttons_audio_file ();
	var_file.BOOL_ENTER = TRUE;
}

gchar *file_make_pathname_file (DETAIL *detail, TYPE_FILE_IS Type_File)
{
	FIC   *fic = (FIC *)detail->fic;
	gchar *PathName = NULL;
	gchar  Ext [ 8 ];

	/*PRINT_FUNC_LF();*/

	switch (Type_File) {
	case FILE_IS_FLAC :		strcpy (Ext, "flac");	break;
	case FILE_IS_WAV :		strcpy (Ext, "wav");	break;
	case FILE_IS_MP3 :		strcpy (Ext, "mp3");	break;
	case FILE_IS_OGG :		strcpy (Ext, "ogg");	break;
	case FILE_IS_M4A :		strcpy (Ext, "m4a");	break;
	case FILE_IS_AAC :		strcpy (Ext, "aac");	break;
	case FILE_IS_SHN :		strcpy (Ext, "shn");	break;
	case FILE_IS_WMA :		strcpy (Ext, "wma");	break;
	case FILE_IS_MPC :		strcpy (Ext, "mpc");	break;
	case FILE_IS_APE :		strcpy (Ext, "ape");	break;
	case FILE_IS_WAVPACK :		strcpy (Ext, "wv");	break;
	case FILE_IS_WAVPACK_MD5 :	strcpy (Ext, "wvc");	break;

	case FILE_IS_NONE :
		break;
	case FILE_IS_IMG :
	case FILE_IS_TXT :
	case FILE_IS_XCFA_GEN_CONF :
	default :
		return (PathName);
	}

	switch (gtk_combo_box_get_active (var_file.Adr_combobox_DestFile)) {
	/* Conversion vers la source
	*/
	case 0 : {
			gchar *ptr = NULL;
			gchar *Rep = NULL;

			if (Type_File == FILE_IS_NONE) {
				Rep = g_strdup (detail->namefile);
				ptr = strrchr (Rep, '/');
				*ptr = '\0';
				PathName = g_strdup (Rep);
				g_free (Rep);
				Rep = NULL;
			} else {
				Rep = g_strdup (detail->namefile);
				ptr = strrchr (Rep, '/');
				*ptr = '\0';
				PathName = g_strdup_printf ("%s/%s.%s", Rep, fic->name_dest, Ext);
				g_free (Rep);
				Rep = NULL;
			}
		}
		break;
	/* Choix d'une nouvelle destination
	*/
	case 1 :
		break;
	/* Pathname de la nouvelle destination
	*/
	case 2 :
		{
			gchar *PtrPathName = NULL;

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				PtrPathName = Config_User.Path_Destination_file;
				break;
			case NOTEBOOK_FICHIERS_WAV :
				PtrPathName = Config_User.Path_Destination_file_wav;
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				PtrPathName = Config_User.Path_Destination_file_mp3ogg;
				break;
			}

			if (Type_File == FILE_IS_NONE) {
				PathName = g_strdup (PtrPathName);
			} else {
				PathName = g_strdup_printf ("%s/%s.%s", PtrPathName, fic->name_dest, Ext);
			}
		}
		break;
	}

	return (PathName);
}

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

gboolean file_peak_get_size_is_ok (ETAT_NORMALISE p_EtatNormalise, SIZE_TMP *SizeTmp)
{
	GtkTreeIter	 iter;
	gboolean	 valid;
	DETAIL		*detail = NULL;
	FIC		*fic = NULL;
	glong		 AllSize = 0;
	glong		 SizeRepTmp;

	if (SizeTmp != NULL) {
		SizeTmp->SizeTmpKo   = 0;
		SizeTmp->NbrFile     = 0;
		SizeTmp->SizeFileKo  = 0;
	}
	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail->type_infosong_file_is == FILE_IS_MP3 ||
		    detail->type_infosong_file_is == FILE_IS_OGG) {
			if ((fic = (FIC *)detail->fic)) {

				if (fic->Etat_Normalise == p_EtatNormalise) {

					AllSize += (glong)atol (file_get_size (detail));

					if (SizeTmp != NULL) {
						SizeTmp->NbrFile ++;
						SizeTmp->SizeFileKo = AllSize;
					}
				}
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}

	if (AllSize > 0) {
		/* 12 est l'indice de multiplication permettant de determiner la taille vers le format WAV
		*/
		AllSize = AllSize * 12;
		if (SizeTmp != NULL) {
			SizeTmp->SizeFileKo *= 12;
			SizeTmp->SizeFileKo /= 1024;
		}

		/*
		g_print ("\tOCTET  %lu\n", AllSize);
		g_print ("\tKO     %lu\n", AllSize / 1024);
		g_print ("\tMEGA   %lu\n", (AllSize / 1024) / 1024);
		g_print ("\tGIGA   %lu\n", ((AllSize / 1024) / 1024) / 1024);
		g_print ("\n");

		df --block-size=K /tmp

		Sys. de fich.  1K-blocs   Occupé    Disponible  Capacité Monté sur
		/dev/sda5      19686772K  4080984K  14605748K   22%      /

		AllSize        = taille en octets
		AllSize / 1024 = taille en KiloOctet
		*/

		SizeRepTmp = level_df ();
		if (SizeTmp != NULL) {
			SizeTmp->SizeTmpKo   = SizeRepTmp;
		}
		/*g_print("\tSizeRepTmp = %lu\n", SizeRepTmp);*/
		/*g_print("\tAllSize / 1024 = %lu\n", AllSize / 1024);*/
		if (AllSize / 1024 >= SizeRepTmp) {
			return (FALSE);
		}

	}
	return (TRUE);
}

gboolean file_get_all_is_normalised (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;

	/* PRINT_FUNC_LF(); */

	if (var_file.Adr_Tree_Model == NULL) return (FALSE);

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail && (fic = (FIC *)detail->fic)) {

			if (detail->type_infosong_file_is == FILE_IS_WAV ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG) {
				if (fic->Etat_Scan == ETAT_SCAN_NONE) return (FALSE);
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	return (TRUE);
}
gboolean file_get_normalise_is_selected (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;

	/* PRINT_FUNC_LF(); */

	if (var_file.Adr_Tree_Model == NULL) return (FALSE);

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail && (fic = (FIC *)detail->fic)) {

			if (detail->type_infosong_file_is == FILE_IS_WAV ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG) {
				if (fic->Etat_Normalise != NORM_NONE) return (TRUE);
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	return (FALSE);
}


gboolean file_event_click_mouse_file_after (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	gint                Pos_X = 0, Pos_Y = 0;
	gboolean            BoolSelectColNewBitrate = FALSE;
	DETAIL             *detail = NULL;
	FIC                *fic = NULL;

	// PRINT_FUNC_LF();

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);

	BoolSelectColNewBitrate    = strcmp(column->title, _("Nouveau bitrate")) == 0 ? TRUE : FALSE;

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
	if (!detail) return (FALSE);
	if (!(fic = (FIC *)detail->fic)) return (FALSE);

	if (BoolSelectColNewBitrate) {

		if (detail->type_infosong_file_is == FILE_IS_MP3) {
			FIC_MP3OGG *FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg;
			if (FicMp3Ogg != NULL) {

				if (FicMp3Ogg->Lame.type != -1 && FicMp3Ogg->Lame.debit != -1 && FicMp3Ogg->Lame.mode != -1) {

					var_file.BOOL_ENTER = FALSE;

					Config_User.RateMp3OggFile.Bitrate_type_Lame = FicMp3Ogg->Lame.type;
					switch (FicMp3Ogg->Lame.type) {
					case 0 : Config_User.RateMp3OggFile.If_abr     = FicMp3Ogg->Lame.debit;		break;
					case 1 : Config_User.RateMp3OggFile.If_cbr     = FicMp3Ogg->Lame.debit;		break;
					case 2 : Config_User.RateMp3OggFile.If_vbr     = FicMp3Ogg->Lame.debit;		break;
					case 3 : Config_User.RateMp3OggFile.If_vbr_new = FicMp3Ogg->Lame.debit;		break;
					}
					Config_User.RateMp3OggFile.Mode_Lame = FicMp3Ogg->Lame.mode;

					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_abr_cbr_vbr), FicMp3Ogg->Lame.type);
					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), FicMp3Ogg->Lame.debit);
					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_Mode), FicMp3Ogg->Lame.mode);

					var_file.BOOL_ENTER = TRUE;
				}
			}
		}
	}

	return (FALSE);
}

gboolean file_event_click_mouse_file (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	gboolean            BoolFlac = FALSE;
	gboolean            BoolWav = FALSE;
	gboolean            BoolMp3 = FALSE;
	gboolean            BoolOgg = FALSE;
	gboolean            BoolM4a = FALSE;
	gboolean            BoolAac = FALSE;
	gboolean            BoolShn = FALSE;
	gboolean            BoolWma = FALSE;
	gboolean            BoolMpc = FALSE;
	gboolean            BoolApe = FALSE;
	gboolean            BoolWavPack = FALSE;

	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColTrash = FALSE;
	gboolean            BoolSelectColType = FALSE;
	gboolean            BoolSelectColFlac = FALSE;
	gboolean            BoolSelectColWav = FALSE;
	gboolean            BoolSelectColMp3 = FALSE;
	gboolean            BoolSelectColOgg = FALSE;
	gboolean            BoolSelectColM4a = FALSE;
	gboolean            BoolSelectColAac = FALSE;
	gboolean            BoolSelectColMpc = FALSE;
	gboolean            BoolSelectColApe = FALSE;
	gboolean            BoolSelectColWavP = FALSE;
	gboolean            BoolSelectColTime = FALSE;
	gboolean            BoolSelectColNorm = FALSE;
	gboolean            BoolSelectColReplayGain = FALSE;
	gboolean            BoolSelectColNom = FALSE;

	gboolean            BoolSelectColNewBitrate = FALSE;

	gboolean            BoolSelectColFREQUENCE = FALSE;
	gboolean            BoolSelectColPISTE = FALSE;
	gboolean            BoolSelectColQUANTIFICATION = FALSE;

	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	gint                i;
	
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	GdkPixbuf          *Pixbuf = NULL;
	DETAIL             *detail = NULL;
	FIC                *fic = NULL;
	gint                Pos_X = 0, Pos_Y = 0;
	gboolean            bool_key_Control = (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R);
	gboolean            bool_key_Shift   = (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R);
	gboolean            bool_key_Release = (bool_key_Control == FALSE &&  bool_key_Shift == FALSE);
	gboolean            bool_click_gauche = (event->button == 1);
	gboolean            bool_click_droit = (event->button == 3);	
	
	// PRINT_FUNC_LF();

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/*
	if (event->type == GDK_2BUTTON_PRESS) {
		g_print ("event->type == GDK_2BUTTON_PRESS\n");
	}
	g_print ("event->button = %d\n", event->button);
	event->button = 1 = GAUCHE
	event->button = 2 = CENTRE
	event->button = 3 = DROITE
	*/

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);

	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Trash :		BoolSelectColTrash		= TRUE;	break;
			case NUM_TREE_Type :		BoolSelectColType		= TRUE;	break;
			case NUM_TREE_Wav :		BoolSelectColWav		= TRUE;	break;
			case NUM_TREE_Flac :		BoolSelectColFlac		= TRUE;	break;
			case NUM_TREE_Ape :		BoolSelectColApe		= TRUE;	break;
			case NUM_TREE_WavP :		BoolSelectColWavP		= TRUE;	break;
			case NUM_TREE_Ogg :		BoolSelectColOgg		= TRUE;	break;
			case NUM_TREE_M4a :		BoolSelectColM4a		= TRUE;	break;
			case NUM_TREE_Aac :		BoolSelectColAac		= TRUE;	break;
			case NUM_TREE_Mpc :		BoolSelectColMpc		= TRUE;	break;
			case NUM_TREE_Mp3 :		BoolSelectColMp3		= TRUE;	break;
			case NUM_TREE_Time :		BoolSelectColTime		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNorm		= TRUE;	break;
			case NUM_TREE_ReplayGain :	BoolSelectColReplayGain		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			case NUM_TREE_FREQUENCE :	BoolSelectColFREQUENCE		= TRUE;	break;
			case NUM_TREE_PISTE :		BoolSelectColPISTE		= TRUE;	break;
			case NUM_TREE_QUANTIFICATION :	BoolSelectColQUANTIFICATION	= TRUE;	break;
			case NUM_TREE_NOUVEAUBITRATE :	BoolSelectColNewBitrate		= TRUE;	break;
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}
	/*
	BoolSelectColPlay          = strcmp(column->title, "Play") == 0 ? TRUE : FALSE;
	BoolSelectColTrash         = strcmp(column->title, "Trash") == 0 ? TRUE : FALSE;
	BoolSelectColType          = strcmp(column->title, "Type") == 0 ? TRUE : FALSE;
	BoolSelectColFlac          = strcmp(column->title, "Flac") == 0 ? TRUE : FALSE;
	BoolSelectColWav           = strcmp(column->title, "Wav") == 0 ? TRUE : FALSE;
	BoolSelectColMp3           = strcmp(column->title, "Mp3") == 0 ? TRUE : FALSE;
	BoolSelectColOgg           = strcmp(column->title, "Ogg") == 0 ? TRUE : FALSE;
	BoolSelectColM4a           = strcmp(column->title, "M4a") == 0 ? TRUE : FALSE;
	BoolSelectColAac           = strcmp(column->title, "Aac") == 0 ? TRUE : FALSE;

	BoolSelectColMpc           = strcmp(column->title, "Mpc") == 0 ? TRUE : FALSE;
	BoolSelectColApe           = strcmp(column->title, "Ape") == 0 ? TRUE : FALSE;
	BoolSelectColWavP          = strcmp(column->title, "WavP") == 0 ? TRUE : FALSE;
	BoolSelectColTime          = strcmp(column->title, "Time") == 0 ? TRUE : FALSE;
	BoolSelectColNorm          = strcmp(column->title, "Normalise") == 0 ? TRUE : FALSE;
	BoolSelectColReplayGain    = strcmp(column->title, "ReplayGain") == 0 ? TRUE : FALSE;
	BoolSelectColNom           = strcmp(column->title, "Nom") == 0 ? TRUE : FALSE;

	BoolSelectColNewBitrate    = strcmp(column->title, _("Nouveau bitrate")) == 0 ? TRUE : FALSE;

	BoolSelectColFREQUENCE     = strcmp(column->title, "FREQUENCE") == 0 ? TRUE : FALSE;
	BoolSelectColPISTE         = strcmp(column->title, "PISTE") == 0 ? TRUE : FALSE;
	BoolSelectColQUANTIFICATION= strcmp(column->title, "QUANTIFICATION") == 0 ? TRUE : FALSE;
	*/
	
	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
	if (!detail) return (FALSE);
	if (!(fic = (FIC *)detail->fic)) return (FALSE);

	BoolSelectColNorm &= (detail->type_infosong_file_is == FILE_IS_WAV ||
			      detail->type_infosong_file_is == FILE_IS_OGG ||
			      detail->type_infosong_file_is == FILE_IS_MP3);


	/* Si <> de Normalise ET <> ReplayGain */
	if (!BoolSelectColNewBitrate &&
	    !BoolSelectColNorm &&
	    !BoolSelectColReplayGain &&
	    !BoolSelectColFREQUENCE &&
	    !BoolSelectColPISTE &&
	    !BoolSelectColQUANTIFICATION) {
		/* position du curseur a l'instant du click */
		if (Pos_X < 18 || Pos_X > 30) return (FALSE);
		if (Pos_Y < 6 || Pos_Y > 18) return (FALSE);
	}

	if (BoolSelectColNewBitrate && (bool_click_gauche && bool_key_Release)) {

		if (detail->type_infosong_file_is == FILE_IS_OGG) {

			FIC_MP3OGG *FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg;
			if (FicMp3Ogg != NULL) {

				if (FicMp3Ogg->Oggenc.type != -1 && FicMp3Ogg->Oggenc.debit != -1 && FicMp3Ogg->Oggenc.mode != -1) {

					var_file.BOOL_ENTER = FALSE;

					Config_User.RateMp3OggFile.Bitrate_type_Lame = FicMp3Ogg->Lame.type;
					Config_User.RateMp3OggFile.If_vbr_new        = FicMp3Ogg->Lame.debit;
					Config_User.RateMp3OggFile.Mode_Lame         = FicMp3Ogg->Lame.mode;

					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Oggenc_bitrate), FicMp3Ogg->Oggenc.type);
					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Oggenc_managed), FicMp3Ogg->Oggenc.debit);
					gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Oggenc_downmix), FicMp3Ogg->Oggenc.mode);

					gtk_widget_set_sensitive (
						GTK_WIDGET (XCFA_GET_OBJECT("combobox_oggenc_managed_mp3ogg")),
						gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate) < 11 ? TRUE : FALSE);
					gtk_widget_set_sensitive (
						GTK_WIDGET (XCFA_GET_OBJECT("combobox_oggenc_downmix_m3ogg")),
						gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate) < 9 ? TRUE : FALSE);

					var_file.BOOL_ENTER = TRUE;
				}
			}

		}
		return (FALSE);
	}
	/*
	g_print ("bool_key_Control = %s\n", bool_key_Control ? "TRUE" : "FALSE");
	g_print ("bool_key_Shift   = %s\n", bool_key_Shift   ? "TRUE" : "FALSE");
	g_print ("bool_key_Release = %s\n", bool_key_Release ? "TRUE" : "FALSE");
	g_print ("keys.keyval      = %d\n", keys.keyval);
	*/

	if (bool_click_droit && BoolSelectColFREQUENCE == TRUE) {
		popup_frequence ();
		return (FALSE);
	}
	if (bool_click_droit && BoolSelectColPISTE) {
		popup_piste ();
		return (FALSE);
	}
	if (bool_click_droit && BoolSelectColQUANTIFICATION) {
		popup_quantification ();
		return (FALSE);
	}

	if (bool_click_droit &&
	   (BoolSelectColFlac ||
	    BoolSelectColWav ||
	    BoolSelectColMp3 ||
	    BoolSelectColOgg ||
	    BoolSelectColM4a ||
	    BoolSelectColAac ||
	    BoolSelectColMpc ||
	    BoolSelectColApe ||
	    BoolSelectColWavP)) {

	    	GdkPixbuf    *Pixbuf = NULL;
	    	TYPE_FILE_IS  TypeFileIs;

		if (BoolSelectColFlac)      {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);	TypeFileIs = FILE_IS_FLAC;	}
		else if (BoolSelectColWav)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);	TypeFileIs = FILE_IS_WAV;	}
		else if (BoolSelectColMp3)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);	TypeFileIs = FILE_IS_MP3;	}
		else if (BoolSelectColOgg)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);	TypeFileIs = FILE_IS_OGG;	}
		else if (BoolSelectColM4a)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);	TypeFileIs = FILE_IS_M4A;	}
		else if (BoolSelectColAac)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);	TypeFileIs = FILE_IS_AAC;	}
		else if (BoolSelectColMpc)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);	TypeFileIs = FILE_IS_MPC;	}
		else if (BoolSelectColApe)  {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);	TypeFileIs = FILE_IS_APE;	}
		else if (BoolSelectColWavP) {Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);	TypeFileIs = FILE_IS_WAVPACK;	}

		if (Pixbuf != NULL && Pixbuf != var_file.Pixbuf_NotInstall) popup_file (detail, TypeFileIs);
		return (FALSE);
	}

	if (bool_click_droit && BoolSelectColTrash) {
		popup_trash ();
	}

	/*
	if (bool_click_droit && BoolSelectColNorm) {
		if (detail->type_infosong_file_is == FILE_IS_WAV ||
		    detail->type_infosong_file_is == FILE_IS_MP3 ||
		    detail->type_infosong_file_is == FILE_IS_OGG) {

			popup_file_Normalisation (detail, file_get_all_is_normalised (), file_get_normalise_is_selected ());
		}
		return (FALSE);
	}
	*/

	if (bool_click_droit && BoolSelectColReplayGain) {
		if (detail->type_infosong_file_is == FILE_IS_FLAC ||
		    detail->type_infosong_file_is == FILE_IS_MP3 ||
		    detail->type_infosong_file_is == FILE_IS_WAVPACK ||
		    detail->type_infosong_file_is == FILE_IS_OGG) {

	    		GdkPixbuf *Pixbuf = file_get_pixbuf_replaygain (detail, FALSE);

			if (Pixbuf != NULL && Pixbuf != var_file.Pixbuf_NotInstall) popup_file_ReplayGain (detail);

		}
		return (FALSE);
	}
	
	if (BoolSelectColPlay && bool_click_droit) {
		popup_for_player ();
	}
	else

	/* test des possibilites */
	if (BoolSelectColPlay && (BoolSelectColPlay = (bool_click_gauche && bool_key_Release))) {
		if (detail->type_infosong_file_is == FILE_IS_FLAC ||
		    detail->type_infosong_file_is == FILE_IS_WAV ||
		    detail->type_infosong_file_is == FILE_IS_MP3 ||
		    detail->type_infosong_file_is == FILE_IS_OGG ||
		    detail->type_infosong_file_is == FILE_IS_M4A ||
		    detail->type_infosong_file_is == FILE_IS_WMA ||
		    detail->type_infosong_file_is == FILE_IS_RM ||
		    detail->type_infosong_file_is == FILE_IS_DTS ||
		    detail->type_infosong_file_is == FILE_IS_AIFF ||
		    detail->type_infosong_file_is == FILE_IS_MPC ||
		    detail->type_infosong_file_is == FILE_IS_WAVPACK ||
		    detail->type_infosong_file_is == FILE_IS_SHN ||
		    detail->type_infosong_file_is == FILE_IS_APE) {

			BoolSelectColPlay = PrgInit.bool_mplayer;
		}
		else {
			BoolSelectColPlay = FALSE;
		}
	}

	else if (BoolSelectColTrash && (BoolSelectColTrash = bool_click_gauche)) {
		BoolSelectColTrash &= bool_click_gauche;
	}

	else if (BoolSelectColNorm && (BoolSelectColNorm = bool_click_gauche)) {
		if (detail->type_infosong_file_is == FILE_IS_WAV ||
			detail->type_infosong_file_is == FILE_IS_MP3 ||
			detail->type_infosong_file_is == FILE_IS_OGG) {

			if ((BoolSelectColNorm = PrgInit.bool_normalize) == TRUE && bool_key_Shift && bool_click_gauche) {
				BoolFlac    = file_bool_from_to (detail, FILE_IS_FLAC, FALSE);
				BoolWav     = file_bool_from_to (detail, FILE_IS_WAV, FALSE);
				BoolMp3     = file_bool_from_to (detail, FILE_IS_MP3, FALSE);
				BoolOgg     = file_bool_from_to (detail, FILE_IS_OGG, FALSE);
				BoolM4a     = file_bool_from_to (detail, FILE_IS_M4A, FALSE);
				BoolAac     = file_bool_from_to (detail, FILE_IS_AAC, FALSE);
				BoolShn     = file_bool_from_to (detail, FILE_IS_SHN, FALSE);
				BoolWma     = file_bool_from_to (detail, FILE_IS_WMA, FALSE);
				BoolMpc     = file_bool_from_to (detail, FILE_IS_MPC, FALSE);
				BoolApe     = file_bool_from_to (detail, FILE_IS_APE, FALSE);
				BoolWavPack = file_bool_from_to (detail, FILE_IS_WAVPACK, FALSE);
			}
		}
	}
	else if (BoolSelectColReplayGain) {
		BoolSelectColReplayGain = bool_click_gauche;
	}
	else if (detail->type_infosong_file_is != FILE_IS_FLAC && BoolSelectColFlac) {
		BoolFlac = file_bool_from_to (detail, FILE_IS_FLAC, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_WAV && BoolSelectColWav) {
		BoolWav  = file_bool_from_to (detail, FILE_IS_WAV, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_MP3 && BoolSelectColMp3) {
		BoolMp3  = file_bool_from_to (detail, FILE_IS_MP3, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_OGG && BoolSelectColOgg) {
		BoolOgg  = file_bool_from_to (detail, FILE_IS_OGG, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_M4A && BoolSelectColM4a) {
		BoolM4a  = file_bool_from_to (detail, FILE_IS_M4A, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_AAC && BoolSelectColAac) {
		BoolAac  = file_bool_from_to (detail, FILE_IS_AAC, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_MPC && BoolSelectColMpc) {
		BoolMpc  = file_bool_from_to (detail, FILE_IS_MPC, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_APE && BoolSelectColApe) {
		BoolApe  = file_bool_from_to (detail, FILE_IS_APE, FALSE);
	}
	else if (detail->type_infosong_file_is != FILE_IS_WAVPACK && BoolSelectColWavP) {
		BoolWavPack  = file_bool_from_to (detail, FILE_IS_WAVPACK, FALSE);
	}

	if (bool_key_Shift && bool_click_gauche) {
		if (BoolWav || BoolFlac || BoolMp3 || BoolOgg || BoolM4a || BoolAac || BoolMpc || BoolApe || BoolWavPack) {
			BoolFlac    = file_bool_from_to (detail, FILE_IS_FLAC, FALSE);
			BoolWav     = file_bool_from_to (detail, FILE_IS_WAV, FALSE);
			BoolMp3     = file_bool_from_to (detail, FILE_IS_MP3, FALSE);
			BoolOgg     = file_bool_from_to (detail, FILE_IS_OGG, FALSE);
			BoolM4a     = file_bool_from_to (detail, FILE_IS_M4A, FALSE);
			BoolAac     = file_bool_from_to (detail, FILE_IS_AAC, FALSE);
			BoolShn     = file_bool_from_to (detail, FILE_IS_SHN, FALSE);
			BoolWma     = file_bool_from_to (detail, FILE_IS_WMA, FALSE);
			BoolMpc     = file_bool_from_to (detail, FILE_IS_MPC, FALSE);
			BoolApe     = file_bool_from_to (detail, FILE_IS_APE, FALSE);
			BoolWavPack = file_bool_from_to (detail, FILE_IS_WAVPACK, FALSE);
		}
	}

	/* traitements */
	if (BoolSelectColPlay) {
		if (bool_key_Release  && bool_click_gauche) {
			
			if (prgaudio_name_is_internal () == FALSE) {
								
				PlayFile_play (prgaudio_get_name_is_actived (), prgaudio_get_param_is_actived (), detail->namefile);
			}
			else {
			
				if (fic->EtatPlay == FILE_ETAT_PLAY_ATTENTE) {

					if (WinPlay_Is_Ok () == TRUE) {
						gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_PLAY, &Pixbuf, -1);

						if (detail != NULL) {

							GList *list = NULL;
							gint sec = 0;
							
							file_set_etat_music_pixbuf_with_detail (detail, FILE_ETAT_PLAY_ATTENTE);
							file_set_etat_music_pixbuf_with_detail (detail, FILE_ETAT_PLAY);

							if (WinPlay_IsOpen () == FALSE) {

								switch (var_file.PageNum) {
								case NOTEBOOK_FICHIERS_CONVERSION :
								case NOTEBOOK_FICHIERS_TAGS :
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Conversions"), detail->namefile);
									break;
								case NOTEBOOK_FICHIERS_WAV :
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Wav"), detail->namefile);
									break;
								case NOTEBOOK_FICHIERS_MP3OGG :
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->mp3-Ogg"), detail->namefile);
									break;
								}
							}
							else {
								switch (var_file.PageNum) {
								case NOTEBOOK_FICHIERS_CONVERSION :
								case NOTEBOOK_FICHIERS_TAGS :
									// WinPlay_set_label_namefile (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Conversions"), detail->namefile);
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Conversions"), detail->namefile);
									break;
								case NOTEBOOK_FICHIERS_WAV :
									// WinPlay_set_label_namefile (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Wav"), detail->namefile);
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->Wav"), detail->namefile);
									break;
								case NOTEBOOK_FICHIERS_MP3OGG :
									// WinPlay_set_label_namefile (LIST_MPLAYER_FROM_FILE, _("From Fichiers->mp3-Ogg"), detail->namefile);
									WinPlay_Open (LIST_MPLAYER_FROM_FILE, _("From Fichiers->mp3-Ogg"), detail->namefile);
									break;
								}
							}
							
							mplayer_fifo_quit ();
							
							
							sec = (gint) ((VarMplayer.DOUBLE_TempsTotal * VarMplayer.PercentTempsActuel) / 100.0);
							sec = 0;
							list = g_list_append (list, g_strdup (detail->namefile));
							list = g_list_append (list, g_strdup ("-ss"));
							list = g_list_append (list, g_strdup_printf ("%d", sec));
							mplayer_set_list (LIST_MPLAYER_FROM_FILE, 0.0, 0, list);
							list = utils_clear_list (list);
						}
					}
				}
				else {
					file_set_etat_music_pixbuf_with_detail (detail, FILE_ETAT_PLAY_ATTENTE);
					mplayer_fifo_quit ();
				}
			}
		}
	}

	else if (BoolSelectColTrash) {

		/* Une seule selection par l'utilisateur */
		if ((bool_key_Release && bool_click_gauche)) {
			gtk_list_store_set (
					var_file.Adr_List_Store,
					&iter,
					COLUMN_FILE_TRASH,
					file_get_pixbuf_trash (detail, TRUE),
					-1);
		}

		/* Selection verticale par l'utilisateur */
		else if (bool_key_Control && bool_click_gauche) {

			file_select_or_deselect_vertical_trash (fic->EtatTrash == FILE_TRASH_NONE ? TRUE : FALSE);
		}

		file_set_flag_buttons_audio_file ();
	}

	else if (BoolSelectColNorm) {

		/* Une seule selection par l'utilisateur */
		if ((bool_key_Release && bool_click_gauche)) {

			gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_file.AdrComboboxNormalise)), TRUE);

			if (fic->Etat_Normalise == NORM_READY_FOR_SELECT) {
				switch (gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise))) {
				case 0 :
					fic->Etat_Normalise = NORM_PEAK_ALBUM;
					break;
				case 1 :
					fic->Etat_Normalise = NORM_PEAK;
					break;
				case 2 :
					fic->Etat_Normalise = NORM_RMS_MIX_ALBUM;
					break;
				case 3 :
					fic->Etat_Normalise = NORM_RMS_FIX;
					break;
				}
			}
			else if (fic->Etat_Normalise > NORM_READY_FOR_SELECT) {
				fic->Etat_Normalise = NORM_READY_FOR_SELECT;
				fic->Etat_Scan = ETAT_SCAN_NONE;
			}

			gtk_list_store_set (
					var_file.Adr_List_Store,
					&iter,
					COLUMN_FILE_NORMALIZE,
					file_get_str_level_normalise (detail),
					-1);
		}

		/* Selection verticale par l'utilisateur */
		/*
		else if (bool_key_Control && bool_click_gauche) {
		}
		*/

		/* Remise en position ATTENTE */
		else if (bool_key_Shift && bool_click_gauche) {

			/* Vertical
			ETAT_NORMALISE
				NORM_NONE
				NORM_RMS_FIX
				NORM_PEAK
				NORM_RMS_MIX_ALBUM
				NORM_PEAK_ALBUM
			*/
			file_select_or_deselect_vertical_normalise (NORM_RMS_FIX);
		}
		file_set_flag_buttons_audio_file ();
	}

	else if (BoolSelectColReplayGain) {

		gboolean valid;

		/* Une seule selection par l'utilisateur */
		if ((bool_key_Release && bool_click_gauche)) {
			gtk_list_store_set (
					var_file.Adr_List_Store,
					&iter,
					COLUMN_FILE_REPLAYGAIN,
					file_get_pixbuf_replaygain (detail, TRUE),
					-1);
		}

		/* Selection verticale par l'utilisateur */
		else if (bool_key_Control && bool_click_gauche) {
			valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
			while (valid) {
				gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
				if (detail->type_infosong_file_is == FILE_IS_FLAC ||
					detail->type_infosong_file_is == FILE_IS_MP3 ||
					detail->type_infosong_file_is == FILE_IS_OGG ||
					detail->type_infosong_file_is == FILE_IS_WAVPACK) {
					if ((fic = (FIC *)detail->fic)) {
						gtk_list_store_set (
								var_file.Adr_List_Store,
								&iter,
								COLUMN_FILE_REPLAYGAIN,
								file_get_pixbuf_replaygain (detail, TRUE),
								-1);
					}
				}
				valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
			}
		}

		/* Remise en position ATTENTE */
		else if (bool_key_Shift && bool_click_gauche) {
			valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
			while (valid) {
				gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
				if (detail->type_infosong_file_is == FILE_IS_FLAC ||
					detail->type_infosong_file_is == FILE_IS_MP3 ||
					detail->type_infosong_file_is == FILE_IS_OGG ||
					detail->type_infosong_file_is == FILE_IS_WAVPACK) {
					if ((fic = (FIC *)detail->fic)) {

						fic->Etat_ReplayGain = RPG_ATTENTE;

						gtk_list_store_set (
								var_file.Adr_List_Store,
								&iter,
								COLUMN_FILE_REPLAYGAIN,
								file_get_pixbuf_replaygain (detail, FALSE),
								-1);
					}
				}
				valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
			}
		}

		file_set_flag_buttons_audio_file ();
	}

	else if (BoolFlac || BoolWav || BoolMp3 || BoolOgg || BoolShn || BoolM4a || BoolAac || BoolWma || BoolMpc || BoolApe || BoolWavPack) {
		if (bool_key_Release && bool_click_gauche) {
			if (BoolFlac) {
				fic->EtatSelection_Flac = file_get_next_flag (detail, FILE_IS_FLAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_FLAC,
							Pixbuf,
							-1);
			}
			else if (BoolWav) {
				fic->EtatSelection_Wav = file_get_next_flag (detail, FILE_IS_WAV, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_WAV,
							Pixbuf,
							-1);
			}
			else if (BoolMp3) {
				fic->EtatSelection_Mp3 = file_get_next_flag (detail, FILE_IS_MP3, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_MP3,
							Pixbuf,
							-1);
			}
			else if (BoolOgg) {
				fic->EtatSelection_Ogg = file_get_next_flag (detail, FILE_IS_OGG, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_OGG,
							Pixbuf,
							-1);
			}
			else if (BoolM4a) {
				fic->EtatSelection_M4a = file_get_next_flag (detail, FILE_IS_M4A, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_M4A,
							Pixbuf,
							-1);
			}
			else if (BoolAac) {
				fic->EtatSelection_Aac = file_get_next_flag (detail, FILE_IS_AAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_AAC,
							Pixbuf,
							-1);
			}
			else if (BoolMpc) {
				fic->EtatSelection_Mpc = file_get_next_flag (detail, FILE_IS_MPC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_MPC,
							Pixbuf,
							-1);
			}
			else if (BoolApe) {
				fic->EtatSelection_Ape = file_get_next_flag (detail, FILE_IS_APE, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_APE,
							Pixbuf,
							-1);
			}
			else if (BoolWavPack) {
				fic->EtatSelection_WavPack = file_get_next_flag (detail, FILE_IS_WAVPACK, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
				gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_WAVPACK,
							Pixbuf,
							-1);
			}
		}
		else if (bool_key_Control && bool_click_gauche) {

			TYPE_FILE_IS TypeFileIs = FILE_IS_NONE;

			if (BoolFlac)		TypeFileIs = FILE_IS_FLAC;
			else if (BoolWav)	TypeFileIs = FILE_IS_WAV;
			else if (BoolMp3)	TypeFileIs = FILE_IS_MP3;
			else if (BoolOgg)	TypeFileIs = FILE_IS_OGG;
			else if (BoolM4a)	TypeFileIs = FILE_IS_M4A;
			else if (BoolAac)	TypeFileIs = FILE_IS_AAC;
			else if (BoolMpc)	TypeFileIs = FILE_IS_MPC;
			else if (BoolApe)	TypeFileIs = FILE_IS_APE;
			else if (BoolWavPack)	TypeFileIs = FILE_IS_WAVPACK;

			/* Verticalement
				ETAT_SELECTION
					ETAT_ATTENTE
					ETAT_PRG_NONE
					ETAT_SELECT
					ETAT_SELECT_EXPERT
			*/
			file_select_or_deselect_verticaly (TypeFileIs, ETAT_ATTENTE);
		}
		else if (bool_key_Shift && bool_click_gauche) {

			/* Horizontal
				ETAT_SELECTION
					ETAT_ATTENTE
					ETAT_PRG_NONE
					ETAT_SELECT
					ETAT_SELECT_EXPERT
			*/
			file_select_or_deselect_horizontal (detail, ETAT_ATTENTE);
		}

		file_set_flag_buttons_audio_file ();
	}

	return (FALSE);
}

DETAIL *file_get_line_selected (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	// gint              num_list = 0;

	if (!var_file.Adr_TreeView) return ((DETAIL *)detail);
	if (!var_file.Adr_Tree_Model) return ((DETAIL *)detail);
	if (!var_file.Adr_Line_Selected) return ((DETAIL *)detail);

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	begin_list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			// num_list ++;
			if ((DETAIL *)detail != NULL) return ((DETAIL *)detail);
		}
		list = g_list_next (list);
	}
	// if (num_list == 0) detail = NULL;

	return ((DETAIL *)detail);
}

GtkTreeIter file_get_iter_line_selected (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	gint              num_list = 0;

	/* PRINT_FUNC_LF(); */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	begin_list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			num_list ++;
		}
		list = g_list_next (list);
	}
	return ((GtkTreeIter)iter);
}

glong file_get_frequence (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	FIC_WAV          *FicWav = NULL;
	DETAIL           *detail = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);

	if (list == NULL) return (-1);

	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			FicWav = (FIC_WAV *)detail->fic_wav;
			return ((glong)atol (FicWav->Hertz));
		}
		list = g_list_next (list);
	}
	return ((glong)atol (FicWav->Hertz));
}

glong file_get_new_frequence (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GList            *BeginList = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_WAV          *FicWav = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	if ((BeginList = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model)) == NULL) return (-1);

	list = g_list_first (BeginList);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if ((FicWav = (FIC_WAV *)detail->fic_wav))
				return ((glong)atol (FicWav->NewHertz));
			else	return (-1);
		}
		list = g_list_next (list);
	}
	if ((FicWav = (FIC_WAV *)detail->fic_wav))
		return ((glong)atol (FicWav->NewHertz));
	else	return (-1);
}
/* Actualisation du spinbutton
*  --
*  entree :
*      gdouble frequence :
*  retour : -
*/
void file_set_frequence (gdouble frequence)
{
	/*PRINT_FUNC_LF();*/
	if (var_file.Adr_spinbutton_frequence) {
		/* Le signal 'Changed' ne sera produit que si 'frequence' est different du nombre existant
		*/
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_file.Adr_spinbutton_frequence), 1.0);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_file.Adr_spinbutton_frequence), frequence);
	}
}

void file_spinbutton_change_frequence_value (void)
{
	if  (var_file.PageNum == NOTEBOOK_FICHIERS_WAV) {
		var_file.BOOL_ENTER_SPIN = FALSE;
		file_set_frequence ((gdouble) file_get_new_frequence() );
		var_file.BOOL_ENTER_SPIN = TRUE;
	}
}

void file_changed_selection_row_file (GtkTreeSelection *selection, gpointer data)
{
	var_file.Adr_Line_Selected = selection;

	file_spinbutton_change_frequence_value ();

	if (var_file.BOOL_ENTER == FALSE) return;

	if  (var_file.PageNum == NOTEBOOK_FICHIERS_TAGS) {

		if (file_get_line_selected () != NULL) {

			filexpander_set_entry_tag_album ();
			filexpander_set_entry_tag_title ();
			filexpander_set_entry_tag_artist ();
			filexpander_set_entry_tag_comment ();
			filexpander_set_spinbutton_tag_year ();
			filexpander_set_spinbutton_tag_track ();
			filexpander_set_combobox_tag_genre ();
			filexpander_set_label_tag_change ();
		}
	}
	
	file_set_flag_buttons_audio_file ();
}

static void file_drag_data_received_file (GtkWidget	   *widget,
					GdkDragContext     *drag_context,
					gint                x,
					gint                y,
					GtkSelectionData   *data,
					guint               info,
					guint               time)
{
	/* PRINT_FUNC_LF(); */
        /* Une copie ne peut aller vers elle meme !!! */
	if (gtk_drag_get_source_widget(drag_context) != widget) {
		dragndrop_list_drag_data (widget, (gchar *)data->data);
	}
}

static void file_drag_data_drop_file (GtkWidget *widget,
					GdkDragContext *dc,
					GtkSelectionData *selection_data,
					guint info,
					guint t,
					gpointer data)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	gchar            *text = NULL;

	/* PRINT_FUNC_LF(); */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(widget));
	begin_list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			/*g_print ("detail->namefile = %s\n", detail->namefile);*/
			text = g_strdup (detail->namefile);
			gtk_selection_data_set (selection_data,
						GDK_SELECTION_TYPE_STRING,
						8,	/* 8 bits per character. */
						(const guchar *)text,
						strlen(text)
						);
			g_free (text);
			text = NULL;
		}
		list = g_list_next (list);
	}
}

gboolean file_key_press_event_file (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	/* PRINT_FUNC_LF(); */
	
	g_print ("keys.BoolGDK_Control_A = %s\n", keys.BoolGDK_Control_A ? "TRUE" : "FALSE");
	
	if (keys.BoolGDK_Control_A == TRUE) {
		gtk_tree_selection_unselect_all (var_file.Adr_Line_Selected);
		gtk_tree_selection_select_all (var_file.Adr_Line_Selected);
	}
	/*
	else if ((keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R) && (event->keyval == 'A' || event->keyval == 'a')) {
		gtk_tree_selection_unselect_all (var_file.Adr_Line_Selected);
		gtk_tree_selection_select_all (var_file.Adr_Line_Selected);
	}
	*/
	else if (event->keyval == GDK_Delete) {
		GtkTreeIter   iter;

		if (gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter)) {
			file_button_del_file_clicked ();
			return (FALSE);
		}
	}

	return (TRUE);
}
static void file_cell_edited_file (GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath  *path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter   iter;
	gint          column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "column"));

	/* PRINT_FUNC_LF(); */

	gtk_tree_model_get_iter (model, &iter, path);

	if (column == COLUMN_FILE_NAME) {
		gint     Num_cell;
		gchar   *old_text;
		DETAIL  *detail = NULL;
		FIC     *Fic = NULL;
		gchar	*StrVerif = NULL;
		gchar	*ptr = NULL;
		
		StrVerif = g_strdup (new_text);
		if (strchr (StrVerif, '/')) {
			while ((ptr = strchr (StrVerif, '/'))) {
				strcpy (ptr, ptr+1);
			}
		}
		
		gtk_tree_model_get (model, &iter, COLUMN_FILE_NAME, &old_text, -1);
		g_free (old_text);
		old_text = NULL;

		Num_cell = gtk_tree_path_get_indices (path)[0];

		g_free (g_array_index (Articles_file, ARTICLES_FILE, Num_cell).ColumnFileName);
		g_array_index (Articles_file, ARTICLES_FILE, Num_cell).ColumnFileName = NULL;
		g_array_index (Articles_file, ARTICLES_FILE, Num_cell).ColumnFileName = g_strdup (StrVerif);

		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if((Fic = (FIC *)detail->fic)) {

			if (Fic->name_dest) {
				g_free (Fic->name_dest);
				Fic->name_dest = NULL;
			}
			Fic->name_dest = g_strdup (StrVerif);
			if (detail->nametreeview) {
				g_free (detail->nametreeview);
				detail->nametreeview = NULL;
			}
			detail->nametreeview = g_strdup (StrVerif);
		}

		/* actualise le nom */
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_NAME,
					g_array_index (Articles_file, ARTICLES_FILE, Num_cell).ColumnFileName,
					-1);

		/* actualise FLAC WAV MP3 OGG, ...  */
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_FLAC,
					file_get_pixbuf_file (detail, FILE_IS_FLAC),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_WAV,
					file_get_pixbuf_file (detail, FILE_IS_WAV),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_MP3,
					file_get_pixbuf_file (detail, FILE_IS_MP3),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_OGG,
					file_get_pixbuf_file (detail, FILE_IS_OGG),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_M4A,
					file_get_pixbuf_file (detail, FILE_IS_M4A),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_MPC,
					file_get_pixbuf_file (detail, FILE_IS_MPC),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_APE,
					file_get_pixbuf_file (detail, FILE_IS_APE),
					-1);
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					COLUMN_FILE_WAVPACK,
					file_get_pixbuf_file (detail, FILE_IS_WAVPACK),
					-1);
		
		g_free (StrVerif);
		StrVerif = NULL;
	}
	gtk_tree_path_free (path);
}

gboolean file_get_for (DETAIL *detail)
{
	gchar    *Path = NULL;
	gchar    *Name = NULL;
	gchar    *Ptr = NULL;
	gboolean  Bool = FALSE;

	if (detail == NULL) return (FALSE);

	Path = file_make_pathname_file (detail, FILE_IS_NONE);
	Name = g_strdup (detail->namefile);
	Ptr = strrchr (Name, '/');
	*Ptr = '\0';
	Bool = (strcmp (Path, Name) == 0) ? TRUE : FALSE;
	g_free (Path);
	Path = NULL;
	g_free (Name);
	Name = NULL;
	return (Bool);
}

void file_update_name (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

		/* Et mettre le contenu a jour
		*/
		switch (Config_User.notebook_file) {
		case 0 :
		case 3 :
		gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_NAME, fileanalyze_get_name_without_path_ext (detail->namefile, FALSE), -1);
		break;
		case 1 :
		gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NAME, fileanalyze_get_name_without_path_ext (detail->namefile, FALSE), -1);
		break;
		case 2 :
		gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NAME, fileanalyze_get_name_without_path_ext (detail->namefile, FALSE), -1);
		break;
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

gboolean file_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	gint                x, y;
	GdkModifierType     state;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)user_data;
	DETAIL             *detail = NULL;
	FIC                *fic = NULL;
	gint                Pos_X = 0, Pos_Y = 0;
	gint                i;
	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColTrash = FALSE;
	gboolean            BoolSelectColType = FALSE;
	gboolean            BoolSelectColFlac = FALSE;
	gboolean            BoolSelectColWav = FALSE;
	gboolean            BoolSelectColMp3 = FALSE;
	gboolean            BoolSelectColOgg = FALSE;
	gboolean            BoolSelectColM4a = FALSE;
	gboolean            BoolSelectColAac = FALSE;
	gboolean            BoolSelectColMpc = FALSE;
	gboolean            BoolSelectColApe = FALSE;
	gboolean            BoolSelectColWavP = FALSE;
	gboolean            BoolSelectColTime = FALSE;
	gboolean            BoolSelectColNorm = FALSE;
	gboolean            BoolSelectColReplayGain = FALSE;
	gboolean            BoolSelectColNom = FALSE;

	gboolean            BoolSelectColFREQUENCE = FALSE;
	gboolean            BoolSelectColPISTE = FALSE;
	gboolean            BoolSelectColQUANTIFICATION = FALSE;

	gboolean            BoolSelectColBITRATE = FALSE;

	static gint type_GDK_EXPOSE = -1;
	static gint type_GDK_VISIBILITY_NOTIFY = -1;

	// PRINT_FUNC_LF();

	if (keys.eventkey == GDK_KEY_PRESS) {
		return (FALSE);
	}

	/* Le redraw des champs Nom pose problème !!!
	*/
	if (event->type == GDK_EXPOSE) type_GDK_EXPOSE = GDK_EXPOSE;
	if (event->type == GDK_VISIBILITY_NOTIFY) type_GDK_VISIBILITY_NOTIFY = GDK_VISIBILITY_NOTIFY;
	if (type_GDK_EXPOSE == GDK_EXPOSE && type_GDK_VISIBILITY_NOTIFY == GDK_VISIBILITY_NOTIFY) {
		/*
		 * if (event->type == GDK_BUTTON_RELEASE) {
		 *
		 * DES LE RELACHEMENT DU CLICK SOURIS
		 */
		file_update_name ();
		type_GDK_EXPOSE = -1;
		type_GDK_VISIBILITY_NOTIFY = -1;
	}

	if (event->type == GDK_ENTER_NOTIFY) {
		var_file.cursor_on_num_file = 0;
		var_file.bool_dedans = TRUE;
	}
	else if (event->type == GDK_LEAVE_NOTIFY) {
		var_file.cursor_on_num_file = 0;
		var_file.bool_dedans = FALSE;
		utils_puts_statusbar_global ("");
		return (FALSE);
	}
	else if (event->type == GDK_MOTION_NOTIFY)  {
		var_file.bool_dedans = TRUE;
	}

	if (var_file.bool_dedans == FALSE) {
		var_file.cursor_on_num_file = 0;
		utils_puts_statusbar_global ("");
		return (FALSE);
	}

	/* Si pas de selection a cet endroit retour */
	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					   x, y,
					   &path, &column, &Pos_X, &Pos_Y)) {
		var_file.cursor_on_num_file = 0;
		utils_puts_statusbar_global ("");
		return (FALSE);
	}

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
	if (!detail) return (FALSE);
	if (!(fic = (FIC *)detail->fic)) {
		var_file.cursor_on_num_file = 0;
		utils_puts_statusbar_global ("");
		return (FALSE);
	}

	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Trash :		BoolSelectColTrash		= TRUE;	break;
			case NUM_TREE_Type :		BoolSelectColType		= TRUE;	break;
			case NUM_TREE_Wav :		BoolSelectColWav		= TRUE;	break;
			case NUM_TREE_Flac :		BoolSelectColFlac		= TRUE;	break;
			case NUM_TREE_Ape :		BoolSelectColApe		= TRUE;	break;
			case NUM_TREE_WavP :		BoolSelectColWavP		= TRUE;	break;
			case NUM_TREE_Ogg :		BoolSelectColOgg		= TRUE;	break;
			case NUM_TREE_M4a :		BoolSelectColM4a		= TRUE;	break;
			case NUM_TREE_Aac :		BoolSelectColAac		= TRUE;	break;
			case NUM_TREE_Mpc :		BoolSelectColMpc		= TRUE;	break;
			case NUM_TREE_Mp3 :		BoolSelectColMp3		= TRUE;	break;
			case NUM_TREE_Time :		BoolSelectColTime		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNorm		= TRUE;	break;
			case NUM_TREE_ReplayGain :	BoolSelectColReplayGain		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			case NUM_TREE_FREQUENCE :	BoolSelectColFREQUENCE		= TRUE;	break;
			case NUM_TREE_PISTE :		BoolSelectColPISTE		= TRUE;	break;
			case NUM_TREE_QUANTIFICATION :	BoolSelectColQUANTIFICATION	= TRUE;	break;
			case NUM_TREE_NOUVEAUBITRATE :	BoolSelectColBITRATE		= TRUE;	break;
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}
	/*
	BoolSelectColPlay           = strcmp(column->title, "Play") == 0 ? TRUE : FALSE;
	BoolSelectColTrash          = strcmp(column->title, "Trash") == 0 ? TRUE : FALSE;
	BoolSelectColType           = strcmp(column->title, "Type") == 0 ? TRUE : FALSE;
	BoolSelectColFlac           = strcmp(column->title, "Flac") == 0 ? TRUE : FALSE;
	BoolSelectColWav            = strcmp(column->title, "Wav") == 0 ? TRUE : FALSE;
	BoolSelectColMp3            = strcmp(column->title, "Mp3") == 0 ? TRUE : FALSE;
	BoolSelectColOgg            = strcmp(column->title, "Ogg") == 0 ? TRUE : FALSE;
	BoolSelectColM4a            = strcmp(column->title, "M4a") == 0 ? TRUE : FALSE;
	BoolSelectColAac            = strcmp(column->title, "Aac") == 0 ? TRUE : FALSE;
	BoolSelectColMpc            = strcmp(column->title, "Mpc") == 0 ? TRUE : FALSE;
	BoolSelectColApe            = strcmp(column->title, "Ape") == 0 ? TRUE : FALSE;
	BoolSelectColWavP           = strcmp(column->title, "WavP") == 0 ? TRUE : FALSE;
	BoolSelectColTime           = strcmp(column->title, "Time") == 0 ? TRUE : FALSE;
	BoolSelectColNorm           = strcmp(column->title, "Normalise") == 0 ? TRUE : FALSE;
	BoolSelectColReplayGain     = strcmp(column->title, "ReplayGain") == 0 ? TRUE : FALSE;
	BoolSelectColNom            = strcmp(column->title, "Nom") == 0 ? TRUE : FALSE;

	BoolSelectColFREQUENCE      = strcmp(column->title, "FREQUENCE") == 0 ? TRUE : FALSE;
	BoolSelectColPISTE          = strcmp(column->title, "PISTE") == 0 ? TRUE : FALSE;
	BoolSelectColQUANTIFICATION = strcmp(column->title, "QUANTIFICATION") == 0 ? TRUE : FALSE;

	BoolSelectColBITRATE        = strcmp(column->title, _("Nouveau bitrate")) == 0 ? TRUE : FALSE;
	*/
	
	if (BoolSelectColNom) {
		if (var_file.cursor_on_num_file == detail->num_struct) return (FALSE);
		var_file.cursor_on_num_file = detail->num_struct;
		utils_puts_statusbar_global (detail->namefile);
	}

	else if (BoolSelectColPlay ||
		 BoolSelectColTrash ||
		 BoolSelectColFlac ||
		 BoolSelectColWav ||
		 BoolSelectColMp3 ||
		 BoolSelectColOgg ||
		 BoolSelectColM4a ||
		 BoolSelectColAac ||
		 BoolSelectColMpc ||
		 BoolSelectColApe ||
		 BoolSelectColWavP ||
		 BoolSelectColNorm ||
		 BoolSelectColReplayGain ||
		 BoolSelectColFREQUENCE ||
		 BoolSelectColPISTE ||
		 BoolSelectColQUANTIFICATION ||
		 BoolSelectColBITRATE ) {

		/* position du curseur a l'instant du click */
		if (! BoolSelectColNorm &&
		    ! BoolSelectColReplayGain &&
		    ! BoolSelectColFREQUENCE &&
		    ! BoolSelectColPISTE &&
		    ! BoolSelectColQUANTIFICATION &&
		    ! BoolSelectColBITRATE) {
			if (Pos_X < 18 || Pos_X > 30 || Pos_Y < 8 || Pos_Y > 20) {
				var_file.cursor_on_num_file = 0;
				utils_puts_statusbar_global ("");
				return (FALSE);
			}
		}

		if (BoolSelectColPlay) {
			if (PrgInit.bool_mplayer == FALSE) {
				utils_set_prg_not_found ("MPLAYER", PrgInit.bool_mplayer);
				utils_set_mess_from_file_ETAT_PLAY (FILE_ETAT_PLAY_PRG_ABSENT);
			}
			else if (detail->type_infosong_file_is == FILE_IS_FLAC ||
			    detail->type_infosong_file_is == FILE_IS_WAV ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_M4A ||
			    detail->type_infosong_file_is == FILE_IS_WMA ||
			    detail->type_infosong_file_is == FILE_IS_RM  ||
			    detail->type_infosong_file_is == FILE_IS_DTS ||
			    detail->type_infosong_file_is == FILE_IS_AIFF ||
			    detail->type_infosong_file_is == FILE_IS_APE ||
			    detail->type_infosong_file_is == FILE_IS_MPC ||
			    detail->type_infosong_file_is == FILE_IS_SHN ||
			    detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				file_bool_from_to (detail, detail->type_infosong_file_is, TRUE);
				utils_set_mess_from_file_ETAT_PLAY (fic->EtatPlay);
			}
			else {
				utils_puts_statusbar_global ("");
				BoolSelectColPlay = FALSE;
			}
		}

		else if (BoolSelectColFREQUENCE) {
			utils_puts_statusbar_global (_("(Click Droit = Menu) / Choix de la frequence"));
		}
		else if (BoolSelectColPISTE) {
			utils_puts_statusbar_global (_("(Click Droit = Menu) / Choix du nombre de pistes (voies)"));
		}
		else if (BoolSelectColQUANTIFICATION) {
			utils_puts_statusbar_global (_("(Click Droit = Menu) / Choix du codage en nombre de bits"));
		}

		else if (BoolSelectColBITRATE) {
			utils_puts_statusbar_global (_("Modification du bitrate"));
		}

		else if (BoolSelectColTrash) {
			utils_set_mess_from_file_ETAT_TRASH (fic->EtatTrash);
		}

		else if (BoolSelectColFlac) {
			file_bool_from_to (detail, FILE_IS_FLAC, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Flac, file_get_for (detail));
		}
		else if (BoolSelectColWav) {
			file_bool_from_to (detail, FILE_IS_WAV, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Wav, file_get_for (detail));
		}
		else if (BoolSelectColMp3) {
			file_bool_from_to (detail, FILE_IS_MP3, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Mp3, file_get_for (detail));
		}
		else if (BoolSelectColOgg) {
			file_bool_from_to (detail, FILE_IS_OGG, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Ogg, file_get_for (detail));
		}
		else if (BoolSelectColM4a) {
			file_bool_from_to (detail, FILE_IS_M4A, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_M4a, file_get_for (detail));
		}
		else if (BoolSelectColAac) {
			file_bool_from_to (detail, FILE_IS_AAC, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Aac, file_get_for (detail));
		}
		else if (BoolSelectColMpc) {
			file_bool_from_to (detail, FILE_IS_MPC, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Mpc, file_get_for (detail));
		}
		else if (BoolSelectColApe) {
			file_bool_from_to (detail, FILE_IS_APE, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_Ape, file_get_for (detail));
		}
		else if (BoolSelectColWavP) {
			file_bool_from_to (detail, FILE_IS_WAVPACK, TRUE);
			utils_set_mess_from_file_ETAT_SELECTION (fic->EtatSelection_WavPack, file_get_for (detail));
		}
		else if (BoolSelectColNorm) {
			var_file.cursor_on_num_file = 0;
			utils_puts_statusbar_global ("");
			file_bool_from_to (detail, FILE_TO_NORMALISE, TRUE);
			utils_set_mess_from_file_ETAT_NORMALISE (detail, fic, fic->Etat_Normalise, file_get_for (detail));
		}
		else if (BoolSelectColReplayGain) {
			var_file.cursor_on_num_file = 0;
			utils_puts_statusbar_global ("");
			file_bool_from_to (detail, FILE_TO_REPLAYGAIN, TRUE);
			utils_set_mess_from_file_ETAT_REPLAYGAIN (fic->Etat_ReplayGain, file_get_for (detail));
		}
	}
	else {
		var_file.cursor_on_num_file = 0;
		utils_puts_statusbar_global ("");
	}

	return (FALSE);
}

void file_set_etat_column_normalise (void)
{
	GList		*list = NULL;
	DETAIL		*detail = NULL;
	FIC		*fic = NULL;
	gboolean	 BoolNorm = file_get_etat_normalise ();
	gboolean	 BoolScanACtion = FALSE;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {

			if (detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_WAV) {

				if ((fic = (FIC *)detail->fic)) {
					if (BoolNorm == TRUE) {
						fic->Etat_Normalise = NORM_READY_FOR_SELECT;
						fic->Etat_Scan = ETAT_SCAN_NONE;
					}
					else {
						switch (gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise))) {
						case 0 :
							fic->Etat_Normalise = NORM_PEAK_ALBUM;
							break;
						case 1 :
							fic->Etat_Normalise = NORM_PEAK;
							break;
						case 2 :
							fic->Etat_Normalise = NORM_RMS_MIX_ALBUM;
							if (fic->Etat_Scan == ETAT_SCAN_NONE) {
								fic->Etat_Scan = ETAT_SCAN_DEMANDE;
								BoolScanACtion = TRUE;
							}
							gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), TRUE);
							break;
						case 3 :
							fic->Etat_Normalise = NORM_RMS_FIX;
							if (fic->Etat_Scan == ETAT_SCAN_NONE) {
								fic->Etat_Scan = ETAT_SCAN_DEMANDE;
								BoolScanACtion = TRUE;
							}
							gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), TRUE);
							break;
						}
					}
				}
			}
		}
		list = g_list_next (list);
	}
	if (BoolScanACtion == TRUE) FileScanDB_action (TRUE);
	file_pixbuf_update_glist_file ();
}

void file_set_etat_column_replaygain (void)
{
	GList		*list = NULL;
	DETAIL		*detail = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			file_get_pixbuf_replaygain (detail, TRUE);
		}
		list = g_list_next (list);
	}
	file_pixbuf_update_glist_file ();
}

void file_selected_column (GtkTreeViewColumn *treeviewcolumn, gpointer user_data)
{
	gint		NumColonne = GPOINTER_TO_INT(user_data);
	TYPE_FILE_IS	TypeFileIs = FILE_IS_NONE;

	/*PRINT_FUNC_LF();*/

	switch (NumColonne) {
	case  0 : TypeFileIs = FILE_IS_WAV;		break;
	case  1 : TypeFileIs = FILE_IS_FLAC;		break;
	case  2 : TypeFileIs = FILE_IS_APE;		break;
	case  3 : TypeFileIs = FILE_IS_WAVPACK;		break;
	case  4 : TypeFileIs = FILE_IS_OGG;		break;
	case  5 : TypeFileIs = FILE_IS_M4A;		break;
	case  6 : TypeFileIs = FILE_IS_AAC;		break;
	case  7 : TypeFileIs = FILE_IS_MPC;		break;
	case  8 : TypeFileIs = FILE_IS_MP3;		break;
	case  9 : file_set_etat_column_normalise ();	return;
	case 10 : file_set_etat_column_replaygain ();	return;
	}

	file_select_set_etat_next (TypeFileIs);
}



/* Create Columns of TreeView
*  --
*  entree :
*      GtkTreeView *treeview :
*  retour : -
*/
static void file_add_columns_scrolledwindow_file (GtkTreeView *treeview)
{
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;

	/* PRINT_FUNC_LF(); */
	var_file.cursor_on_num_file = 0;
	var_file.bool_dedans = FALSE;

	/* SIGNAL : 'event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "event",
                    	 (GCallback) file_event,
			 model);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect_after(G_OBJECT(treeview),
			 "button-release-event",
                    	 (GCallback) file_event_click_mouse_file_after,
			 model);
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) file_event_click_mouse_file,
			 model);

	/* SIGNAL : Ligne actuellement selectionnee 'changed'
	*/
	var_file.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	g_signal_connect(G_OBJECT(var_file.Adr_Line_Selected),
			 "changed",
                   	 G_CALLBACK(file_changed_selection_row_file),
                   	 "1");

	/* Drag and drop support
	*  SIGNAL : 'drag-data-received'
	*/
	gtk_drag_dest_set (GTK_WIDGET (treeview),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY| GDK_ACTION_MOVE );
	g_signal_connect(G_OBJECT(treeview),
			 "drag-data-received",
			 G_CALLBACK(file_drag_data_received_file),
			 NULL);

	gtk_drag_source_set(
			GTK_WIDGET(treeview),
			GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			drag_types, n_drag_types,
			GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_DEFAULT
			);

	g_signal_connect(G_OBJECT(treeview),
      			"drag-data-get",
			 G_CALLBACK(file_drag_data_drop_file),
			 treeview);

	/* SIGNAL 'key-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "key-press-event",
                    	 (GCallback) file_key_press_event_file,
			 model);

	/* COLUMN_FILE_PLAY
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFilePlay =
	column = gtk_tree_view_column_new_with_attributes (_("Play"),
						     renderer,
						     "pixbuf", COLUMN_FILE_PLAY,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column), GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILE_TRASH
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileTrash =
	column = gtk_tree_view_column_new_with_attributes (_("Trash"),
						     renderer,
						     "pixbuf", COLUMN_FILE_TRASH,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILE_TYPE
	*/
	renderer = gtk_cell_renderer_text_new ();
	/* renderer = gtk_cell_renderer_pixbuf_new (); */
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileType =
	column = gtk_tree_view_column_new_with_attributes (_("Type"),
						     renderer,
						     /*"pixbuf", COLUMN_FILE_TYPE,*/
						     "markup", COLUMN_FILE_TYPE,
						     /*"text", COLUMN_FILE_TYPE,*/
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 55);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILE_TYPE);
	gtk_tree_view_append_column (treeview, column);

	/*
	@Patachon, @Shankarius, @Dzef

	Je plaide aussi pour la réunion logique des formats lossless puis des
	autres. Je propose :

	    lossless     |       perte      | destruction forte
	<================>
	                 <============================>
					    <=========>
	Wav | Flac | Ape | WPack | Ogg | Aac | Mpc | Mp3

	Je conviens qu'il n'est pas facile de classer, car certains formats sont
	capables d'être utilisés en lossless ou en moindre qualité. Ce n'est
	donc pas vraiment linéaire. Mais c'est une piste...
	*/

	/* COLUMN_FILE_WAV
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWav =
	column = gtk_tree_view_column_new_with_attributes (_("Wav"),
						     renderer,
						     "pixbuf", COLUMN_FILE_WAV,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(0));

	/* COLUMN_FILE_FLAC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileFlac =
	column = gtk_tree_view_column_new_with_attributes (_("Flac"),
						     renderer,
						     "pixbuf", COLUMN_FILE_FLAC,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(1));

	/* COLUMN_FILE_APE
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileApe =
	column = gtk_tree_view_column_new_with_attributes (_("Ape"),
						     renderer,
						     "pixbuf", COLUMN_FILE_APE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(2));

	/* COLUMN_FILE_WAVPACK
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavPack =
	column = gtk_tree_view_column_new_with_attributes (_("WavP"),
						     renderer,
						     "pixbuf", COLUMN_FILE_WAVPACK,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(3));

	/* COLUMN_FILE_OGG
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileOgg =
	column = gtk_tree_view_column_new_with_attributes (_("Ogg"),
						     renderer,
						     "pixbuf", COLUMN_FILE_OGG,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(4));

	/* COLUMN_FILE_M4A
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileM4a =
	column = gtk_tree_view_column_new_with_attributes (_("M4a"),
						     renderer,
						     "pixbuf", COLUMN_FILE_M4A,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(5));

	/* COLUMN_FILE_AAC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileAac =
	column = gtk_tree_view_column_new_with_attributes (_("Aac"),
						     renderer,
						     "pixbuf", COLUMN_FILE_AAC,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(6));

	/* COLUMN_FILE_MPC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMpc =
	column = gtk_tree_view_column_new_with_attributes (_("Mpc"),
						     renderer,
						     "pixbuf", COLUMN_FILE_MPC,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(7));

	/* COLUMN_FILE_MP3
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3 =
	column = gtk_tree_view_column_new_with_attributes (_("Mp3"),
						     renderer,
						     "pixbuf", COLUMN_FILE_MP3,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(8));

	/* COLUMN_FILE_TIME
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileTime =
	column = gtk_tree_view_column_new_with_attributes (_("Time"),
						     renderer,
						     /*"pixbuf", COLUMN_FILE_TYPE,*/
						     "text", COLUMN_FILE_TIME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 70);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILE_NORMALIZE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer,
			"xalign", 0.5,
			NULL);
	var_file.Adr_ColumnFileNormalize =
	column = gtk_tree_view_column_new_with_attributes (_("Normalise"),
						     renderer,
						     "markup", COLUMN_FILE_NORMALIZE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 170);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(9));

	/* COLUMN_FILE_REPLAYGAIN
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileReplayGain =
	column = gtk_tree_view_column_new_with_attributes (_("ReplayGain"),
						     renderer,
						     "pixbuf", COLUMN_FILE_REPLAYGAIN,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 80);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_selected_column),
			GINT_TO_POINTER(10));

	/* COLUMN_FILE_NAME
	*  COLUMN_FILE_EDITABLE
	*/
	var_file.Adr_ColumnFileAligmentRenderer =
	renderer = gtk_cell_renderer_text_new ();
	g_signal_connect (renderer, "edited", G_CALLBACK (file_cell_edited_file), model);
	g_object_set (renderer, "xalign", 0.5, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_FILE_NAME);
	var_file.Adr_ColumnFileName =
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
							renderer,
							"markup", COLUMN_FILE_NAME,
							"editable", COLUMN_FILE_EDITABLE,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 200);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILE_NAME);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_HERTZ
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavHertz =
	column = gtk_tree_view_column_new_with_attributes (_("Frequence"),
						     renderer,
						     "text", COLUMN_FILEWAV_HERTZ,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEWAV_HERTZ);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_NEW_HERTZ
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavNewHertz =
/*
	column = gtk_tree_view_column_new_with_attributes ("Nom",
						     renderer,
						     "markup", COLUMN_FILEMP3OGG_NAME,
						     NULL);
*/
	column = gtk_tree_view_column_new_with_attributes (_("FREQUENCE"),
						     renderer,
						     "markup", COLUMN_FILEWAV_NEW_HERTZ,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	/*
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (file_call_un),
			GINT_TO_POINTER(7));
	*/

	/* COLUMN_FILEWAV_VOIE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavVoie =
	column = gtk_tree_view_column_new_with_attributes (_("Piste"),
						     renderer,
						     "text", COLUMN_FILEWAV_VOIE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEWAV_VOIE);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_NEW_VOIE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavNewVoie =
	column = gtk_tree_view_column_new_with_attributes (_("PISTE"),
						     renderer,
						     "markup", COLUMN_FILEWAV_NEW_VOIE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_BITS
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavBits =
	column = gtk_tree_view_column_new_with_attributes (_("Quantification"),
						     renderer,
						     "text", COLUMN_FILEWAV_BITS,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 120);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEWAV_BITS);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_NEW_BITS
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavNewBits =
	column = gtk_tree_view_column_new_with_attributes (_("QUANTIFICATION"),
						     renderer,
						     "markup", COLUMN_FILEWAV_NEW_BITS,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 115);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEWAV_NAME
	*/
	var_file.Adr_ColumnFileWavAligmentRenderer =
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileWavName =
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
						     renderer,
						     /*"text", COLUMN_FILEWAV_NAME,*/
						     "markup", COLUMN_FILEWAV_NAME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);


	/* COLUMN_FILEMP3OGG_TYPE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggType =
	column = gtk_tree_view_column_new_with_attributes (_("Type"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_TYPE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEMP3OGG_TYPE);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEMP3OGG_BITRATE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggBitrate =
	column = gtk_tree_view_column_new_with_attributes (_("Bitrate"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_BITRATE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEMP3OGG_BITRATE);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEMP3OGG_NEWBITRATE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggNewBitrate =
	column = gtk_tree_view_column_new_with_attributes (_("Nouveau bitrate"),
						     renderer,
						     "markup", COLUMN_FILEMP3OGG_NEWBITRATE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 350);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEMP3OGG_SIZE
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggSize =
	column = gtk_tree_view_column_new_with_attributes (_("Size"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_SIZE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEMP3OGG_TIME
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggTime =
	column = gtk_tree_view_column_new_with_attributes (_("Time"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_TIME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* COLUMN_FILEMP3OGG_NAME
	*/
	var_file.Adr_ColumnFileMp3OggAligmentRenderer =
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file.Adr_ColumnFileMp3OggName =
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
						     renderer,
						     "markup", COLUMN_FILEMP3OGG_NAME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);




	/* COLUMN_FILE_POINTER_STRUCT
	*/
}

/* Initialisate adress pixbuf
*  --
*  entree :
*      char *NameFilePixbuf :
*  retour :
*      <> NULL :
*      == NULL :
*/
GdkPixbuf *file_init_pixbufs_file (char *NameFilePixbuf)
{
	GdkPixbuf *NewPixbuf = NULL;
	GError    *error = NULL;
	gchar     *Pathname_Pixbuf = NULL;

	/* PRINT_FUNC_LF(); */

	Pathname_Pixbuf = utils_get_pathname (NameFilePixbuf);

	/* g_print ("file_init_pixbufs_file (%s)\n", Pathname_Pixbuf); */

	/* load pixbuf
	*/
	NewPixbuf = gdk_pixbuf_new_from_file(Pathname_Pixbuf, &error);
 	if (error) {
 		GDK_PIXBUF_ERROR;
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
		g_free (Pathname_Pixbuf);
		Pathname_Pixbuf = NULL;
		return (NULL);
	}

	g_free (Pathname_Pixbuf);
	Pathname_Pixbuf = NULL;

	return (NewPixbuf);
}

/* Mise en place du 'Scrolledwindow_File'
*  --
*  entree :
*      GtkWidget *widget :
*  retour : -
*/
void file_scrolledwindow_file_realize (GtkWidget *widget)
{
	GtkListStore *store;
	GtkTreeModel *model;
	GtkWidget    *treeview;

	/* PRINT_FUNC_LF(); */

	var_file.BOOL_ENTER = TRUE;
	var_file.Adr_scroll = widget;

	var_file.Pixbuf_Coche                  = file_init_pixbufs_file ("coche.png");
	var_file.Pixbuf_Selected               = file_init_pixbufs_file ("selected.png");
	var_file.Pixbuf_Coche_exist            = file_init_pixbufs_file ("coche_exist.png");
	var_file.Pixbuf_Selected_exist         = file_init_pixbufs_file ("selected_exist.png");

	var_file.Pixbuf_Selected_expert        = file_init_pixbufs_file ("selected_expert.png");
	var_file.Pixbuf_Selected_expert_exist  = file_init_pixbufs_file ("selected_expert_exist.png");
	var_file.Pixbuf_FilePlay               = file_init_pixbufs_file ("sol.png");
	var_file.Pixbuf_FileStop               = file_init_pixbufs_file ("no_play.png");

	var_file.Pixbuf_NotInstall             = file_init_pixbufs_file ("not_install.png");
	var_file.Pixbuf_rpg_piste              = file_init_pixbufs_file ("rpg_piste.png");
	var_file.Pixbuf_rpg_album              = file_init_pixbufs_file ("rpg_album.png");
	var_file.Pixbuf_rpg_effacer            = file_init_pixbufs_file ("rpg_effacer.png");
	var_file.Pixbuf_rpg_wait               = file_init_pixbufs_file ("norm_rpg_wait.png");

	var_file.Pixbuf_norm_fix               = file_init_pixbufs_file ("norm_fix.png");
	var_file.Pixbuf_norm_mix               = file_init_pixbufs_file ("norm_mix.png");
	var_file.Pixbuf_norm_peak              = file_init_pixbufs_file ("norm_peak.png");
	var_file.Pixbuf_norm_wait              = file_init_pixbufs_file ("norm_rpg_wait.png");

	var_file.Pixbuf_Normalize_Coche        = file_init_pixbufs_file ("normalize2.png");

	var_file.Pixbuf_NoTrash			= file_init_pixbufs_file ("coche.png");
	var_file.Pixbuf_Trash			= file_init_pixbufs_file ("trash.png");

	Articles_file = g_array_sized_new (FALSE, FALSE, sizeof (ARTICLES_FILE), 1);

	var_file.Adr_List_Store = store =
	gtk_list_store_new (	COLUMN_FILE_NUM,	/* TOTAL NUMBER			*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_PLAY		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_TRASH		*/
				G_TYPE_STRING,	        /* COLUMN_FILE_TYPE		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_FLAC		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_WAV		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_MP3		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_OGG		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_M4A		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_AAC		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_MPC		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_APE		*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_WAVPACK		*/
				G_TYPE_STRING,		/* COLUMN_FILE_TIME		*/
				G_TYPE_STRING,		/* COLUMN_FILE_NORMALIZE	*/
				GDK_TYPE_PIXBUF,	/* COLUMN_FILE_REPLAYGAIN	*/
				G_TYPE_STRING,		/* COLUMN_FILE_NAME		*/
				G_TYPE_BOOLEAN,         /* COLUMN_FILE_EDITABLE		*/

				G_TYPE_STRING,		/* COLUMN_FILEWAV_HERTZ		*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_NEW_HERTZ	*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_VOIE		*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_NEW_VOIE	*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_BITS		*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_NEW_BITS	*/
				G_TYPE_STRING,		/* COLUMN_FILEWAV_NAME		*/

				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_TYPE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_BITRATE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_NEWBITRATE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_SIZE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_TIME	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_NAME	*/

				G_TYPE_POINTER          /* COLUMN_FILE_POINTER_STRUCT	*/
			   );

	var_file.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	/* creation de tree view
	 */
	var_file.Adr_TreeView =
	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
	gtk_tree_selection_set_mode (
		gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)), GTK_SELECTION_MULTIPLE);
	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);
	file_add_columns_scrolledwindow_file (GTK_TREE_VIEW (treeview));

	gtk_widget_show_all (widget);

	/* DRAG & DROP onglet 'Fichiers'
	*/
	/*xcfa_drag_dest_set (GTK_WIDGET (Adr_TreeView));*/
}


/* Deselection totale
*/
void file_all_deselect (void)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	GdkPixbuf     *Pixbuf = NULL;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {

			fic->EtatSelection_Wav = ETAT_PRG_NONE;
			fic->EtatSelection_Wav = file_get_next_flag (detail, FILE_IS_WAV, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAV, Pixbuf, -1);

			fic->EtatSelection_Flac = ETAT_PRG_NONE;
			fic->EtatSelection_Flac = file_get_next_flag (detail, FILE_IS_FLAC, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_FLAC, Pixbuf, -1);

			fic->EtatSelection_Ape = ETAT_PRG_NONE;
			fic->EtatSelection_Ape = file_get_next_flag (detail, FILE_IS_APE, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_APE, Pixbuf, -1);

			fic->EtatSelection_WavPack = ETAT_PRG_NONE;
			fic->EtatSelection_WavPack = file_get_next_flag (detail, FILE_IS_WAVPACK, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAVPACK, Pixbuf, -1);

			fic->EtatSelection_Ogg = ETAT_PRG_NONE;
			fic->EtatSelection_Ogg = file_get_next_flag (detail, FILE_IS_OGG, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_OGG, Pixbuf, -1);

			fic->EtatSelection_M4a = ETAT_PRG_NONE;
			fic->EtatSelection_M4a = file_get_next_flag (detail, FILE_IS_M4A, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_M4A, Pixbuf, -1);

			fic->EtatSelection_Aac = ETAT_PRG_NONE;
			fic->EtatSelection_Aac = file_get_next_flag (detail, FILE_IS_AAC, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_AAC, Pixbuf, -1);

			fic->EtatSelection_Mpc = ETAT_PRG_NONE;
			fic->EtatSelection_Mpc = file_get_next_flag (detail, FILE_IS_MPC, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MPC, Pixbuf, -1);

			fic->EtatSelection_Mp3 = ETAT_PRG_NONE;
			fic->EtatSelection_Mp3 = file_get_next_flag (detail, FILE_IS_MP3, FALSE);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MP3, Pixbuf, -1);
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

/* Verticalement
ETAT_SELECTION
	ETAT_PRG_NONE
	ETAT_SELECT
	ETAT_SELECT_EXPERT
*/
void file_select_or_deselect_verticaly (TYPE_FILE_IS type_file_is, ETAT_SELECTION EtatSelection)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	GdkPixbuf     *Pixbuf = NULL;

	/* PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {

			if (type_file_is == FILE_IS_FLAC) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Flac = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Flac = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Flac = ETAT_SELECT_EXIST;
				fic->EtatSelection_Flac = file_get_next_flag (detail, FILE_IS_FLAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_FLAC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_WAV) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Wav = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Wav = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Wav = ETAT_SELECT_EXIST;
				fic->EtatSelection_Wav = file_get_next_flag (detail, FILE_IS_WAV, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAV, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_MP3) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Mp3 = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Mp3 = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Mp3 = ETAT_SELECT_EXIST;
				fic->EtatSelection_Mp3 = file_get_next_flag (detail, FILE_IS_MP3, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MP3, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_OGG) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Ogg = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Ogg = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Ogg = ETAT_SELECT_EXIST;
				fic->EtatSelection_Ogg = file_get_next_flag (detail, FILE_IS_OGG, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_OGG, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_M4A) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_M4a = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_M4a = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_M4a = ETAT_SELECT_EXIST;
				fic->EtatSelection_M4a = file_get_next_flag (detail, FILE_IS_M4A, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_M4A, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_AAC) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Aac = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Aac = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Aac = ETAT_SELECT_EXIST;
				fic->EtatSelection_Aac = file_get_next_flag (detail, FILE_IS_AAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_AAC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_MPC) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Mpc = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Mpc = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Mpc = ETAT_SELECT_EXIST;
				fic->EtatSelection_Mpc = file_get_next_flag (detail, FILE_IS_MPC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MPC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_APE) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Ape = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Ape = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Ape = ETAT_SELECT_EXIST;
				fic->EtatSelection_Ape = file_get_next_flag (detail, FILE_IS_APE, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_APE, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_WAVPACK) {
				if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_WavPack = ETAT_PRG_NONE;
				else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_WavPack = ETAT_ATTENTE_EXIST;
				else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_WavPack = ETAT_SELECT_EXIST;
				fic->EtatSelection_WavPack = file_get_next_flag (detail, FILE_IS_WAVPACK, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAVPACK, Pixbuf, -1);
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

void file_select_set_etat_next (TYPE_FILE_IS TypeFileIs)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	GdkPixbuf     *Pixbuf = NULL;

	/* PRINT_FUNC_LF(); */

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {

			if (TypeFileIs == FILE_IS_FLAC) {
				fic->EtatSelection_Flac = file_get_next_flag (detail, FILE_IS_FLAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_FLAC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_WAV) {
				fic->EtatSelection_Wav = file_get_next_flag (detail, FILE_IS_WAV, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAV, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_MP3) {
				fic->EtatSelection_Mp3 = file_get_next_flag (detail, FILE_IS_MP3, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MP3, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_OGG) {
				fic->EtatSelection_Ogg = file_get_next_flag (detail, FILE_IS_OGG, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_OGG, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_M4A) {
				fic->EtatSelection_M4a = file_get_next_flag (detail, FILE_IS_M4A, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_M4A, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_AAC) {
				fic->EtatSelection_Aac = file_get_next_flag (detail, FILE_IS_AAC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_AAC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_MPC) {
				fic->EtatSelection_Mpc = file_get_next_flag (detail, FILE_IS_MPC, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_MPC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_APE) {
				fic->EtatSelection_Ape = file_get_next_flag (detail, FILE_IS_APE, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_APE, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_WAVPACK) {
				fic->EtatSelection_WavPack = file_get_next_flag (detail, FILE_IS_WAVPACK, TRUE);
				Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILE_WAVPACK, Pixbuf, -1);
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

/* Horizontal
ETAT_SELECTION
	ETAT_PRG_NONE
	ETAT_SELECT
	ETAT_SELECT_EXPERT
*/
void file_select_or_deselect_horizontal (DETAIL *p_detail, ETAT_SELECTION EtatSelection)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GtkTreeIter    iter;
	gboolean       valid;
	GdkPixbuf     *Pixbuf = NULL;

	/* PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic) && p_detail == detail) {

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Wav = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Wav = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Wav = ETAT_SELECT_EXIST;

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Flac = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Flac = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Flac = ETAT_SELECT_EXIST;

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Ape = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Ape = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Ape = ETAT_SELECT_EXIST;

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_WavPack = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_WavPack = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_WavPack = ETAT_SELECT_EXIST;

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Ogg = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Ogg = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Ogg = ETAT_SELECT_EXIST;
			
			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_M4a = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_M4a = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_M4a = ETAT_SELECT_EXIST;
			
			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Aac = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Aac = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Aac = ETAT_SELECT_EXIST;
			
			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Mpc = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Mpc = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Mpc = ETAT_SELECT_EXIST;

			if (EtatSelection == ETAT_PRG_NONE)		fic->EtatSelection_Mp3 = ETAT_PRG_NONE;
			else if (EtatSelection == ETAT_SELECT)		fic->EtatSelection_Mp3 = ETAT_ATTENTE_EXIST;
			else if (EtatSelection == ETAT_SELECT_EXPERT)	fic->EtatSelection_Mp3 = ETAT_SELECT_EXIST;
			
			fic->EtatSelection_Flac    = file_get_next_flag (detail, FILE_IS_FLAC, TRUE);
			fic->EtatSelection_Wav     = file_get_next_flag (detail, FILE_IS_WAV, TRUE);
			fic->EtatSelection_Mp3     = file_get_next_flag (detail, FILE_IS_MP3, TRUE);
			fic->EtatSelection_Ogg     = file_get_next_flag (detail, FILE_IS_OGG, TRUE);
			fic->EtatSelection_M4a     = file_get_next_flag (detail, FILE_IS_M4A, TRUE);
			fic->EtatSelection_Aac     = file_get_next_flag (detail, FILE_IS_AAC, TRUE);
			fic->EtatSelection_Mpc     = file_get_next_flag (detail, FILE_IS_MPC, TRUE);
			fic->EtatSelection_Ape     = file_get_next_flag (detail, FILE_IS_APE, TRUE);
			fic->EtatSelection_WavPack = file_get_next_flag (detail, FILE_IS_WAVPACK, TRUE);

			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_FLAC);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_FLAC,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAV);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_WAV,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MP3);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_MP3,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_OGG);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_OGG,
							Pixbuf,
							-1);

			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_M4A);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_M4A,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_AAC);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_AAC,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_MPC);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_MPC,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_APE);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_APE,
							Pixbuf,
							-1);
			Pixbuf = file_get_pixbuf_file (detail, FILE_IS_WAVPACK);
			gtk_list_store_set (var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_WAVPACK,
							Pixbuf,
							-1);

			file_set_flag_buttons_audio_file ();
			return;
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}

/* Vertical
ETAT_REPLAYGAIN
	RPG_NONE
	RPG_ATTENTE
	RPG_PISTE
	RPG_ALBUM
	RPG_EFFACER
*/
void file_select_or_deselect_vertical_replaygain (ETAT_REPLAYGAIN EtatReplayGain)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if (detail->type_infosong_file_is == FILE_IS_FLAC ||
				detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_OGG ||
				detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				if ((fic = (FIC *)detail->fic)) {

					fic->Etat_ReplayGain = EtatReplayGain;

					gtk_list_store_set (
							var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_REPLAYGAIN,
							file_get_pixbuf_replaygain (detail, FALSE),
							-1);
				}
			}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

/* Vertical
ETAT_NORMALISE
	NORM_NONE
	NORM_RMS_FIX
	NORM_PEAK
	NORM_RMS_MIX_ALBUM
	NORM_PEAK_ALBUM
*/
void file_select_or_deselect_vertical_normalise (ETAT_NORMALISE EtatNormalise)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail->type_infosong_file_is == FILE_IS_WAV ||
			detail->type_infosong_file_is == FILE_IS_MP3 ||
			detail->type_infosong_file_is == FILE_IS_OGG) {
			if ((fic = (FIC *)detail->fic)) {

				if (fic->Etat_Normalise >= NORM_RMS_FIX ||
				    EtatNormalise == NORM_PEAK ||
				    EtatNormalise == NORM_PEAK_ALBUM
				    ) {
					fic->Etat_Normalise = EtatNormalise;
					gtk_list_store_set (
							var_file.Adr_List_Store,
							&iter,
							COLUMN_FILE_NORMALIZE,
							file_get_str_level_normalise (detail),
							-1);
				}

			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

void file_select_or_deselect_vertical_trash (gboolean BoolSelect)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if ((fic = (FIC *)detail->fic)) {

			if (BoolSelect == TRUE)
				fic->EtatTrash = FILE_TRASH_OK;
			else	fic->EtatTrash = FILE_TRASH_NONE;

			gtk_list_store_set (
					var_file.Adr_List_Store,
					&iter,
					COLUMN_FILE_TRASH,
					file_get_pixbuf_trash (detail, FALSE),
					-1);

		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

/*
*---------------------------------------------------------------------------
* FILE WAV
*---------------------------------------------------------------------------
*/

/* Changement des parametres: freq, voie, ou bits si differents de NULL
*  --
*  entree :
*      gchar *freq :
*      gchar *voie :
*      gchar *bits :
*  retour : -
*/
void file_set_change_parameters_is_selected (gchar *freq, gchar *voie, gchar *bits)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_WAV          *FicWav = NULL;
	GList            *list = NULL;
	gchar            *Str = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		path = list->data;
		if (path) {
			/* prend le numero de la structure
			*/
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			FicWav = (FIC_WAV *)detail->fic_wav;

			/* Et mettre le contenu a jour
			*/
			if (freq) {
				if (FicWav->NewHertz) {
					g_free (FicWav->NewHertz);
					FicWav->NewHertz = NULL;
				}
				FicWav->NewHertz = g_strdup (freq);

				if (strcmp (FicWav->Hertz, FicWav->NewHertz) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewHertz);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewHertz);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, Str, -1);
				g_free (Str);
				Str = NULL;
			}
			if (voie) {
				if (FicWav->NewVoie) {
					g_free (FicWav->NewVoie);
					FicWav->NewVoie = NULL;
				}
				FicWav->NewVoie = g_strdup (voie);

				if (strcmp (FicWav->Voie, FicWav->NewVoie) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewVoie);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewVoie);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, Str, -1);
				g_free (Str);
				Str = NULL;
			}
			if (bits) {
				if (FicWav->NewBits) {
					g_free (FicWav->NewBits);
					FicWav->NewBits = NULL;
				}
				FicWav->NewBits = g_strdup (bits);

				if (strcmp (FicWav->Bits, FicWav->NewBits) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewBits);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewBits);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, Str, -1);
				g_free (Str);
				Str = NULL;
			}

			FicWav->Bool_Conv = FALSE;
			if (atoi(FicWav->NewHertz) != atoi(FicWav->Hertz)) FicWav->Bool_Conv = TRUE;
			if (atoi(FicWav->NewVoie) != atoi(FicWav->Voie)) FicWav->Bool_Conv = TRUE;
			if (atoi(FicWav->NewBits) != atoi(FicWav->Bits)) FicWav->Bool_Conv = TRUE;

		}
		list = g_list_next (list);
	}
	file_set_flag_buttons_audio_file ();
}

void file_set_change_parameters_to_column (gchar *freq, gchar *voie, gchar *bits)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC_WAV       *FicWav = NULL;
	gchar         *Str = NULL;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		FicWav = (FIC_WAV *)detail->fic_wav;

		/* Et mettre le contenu a jour
		*/
		if (freq) {
			if (FicWav->NewHertz) {
				g_free (FicWav->NewHertz);
				FicWav->NewHertz = NULL;
			}
			FicWav->NewHertz = g_strdup (freq);

			if (strcmp (FicWav->Hertz, FicWav->NewHertz) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewHertz);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewHertz);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, Str, -1);
			g_free (Str);
			Str = NULL;
		}
		if (voie) {
			if (FicWav->NewVoie) {
				g_free (FicWav->NewVoie);
				FicWav->NewVoie = NULL;
			}
			FicWav->NewVoie = g_strdup (voie);

			if (strcmp (FicWav->Voie, FicWav->NewVoie) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewVoie);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewVoie);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, Str, -1);
			g_free (Str);
			Str = NULL;
		}
		if (bits) {
			if (FicWav->NewBits) {
				g_free (FicWav->NewBits);
				FicWav->NewBits = NULL;
			}
			FicWav->NewBits = g_strdup (bits);

			if (strcmp (FicWav->Bits, FicWav->NewBits) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewBits);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewBits);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, Str, -1);
			g_free (Str);
			Str = NULL;
		}

		FicWav->Bool_Conv = FALSE;
		if (atoi(FicWav->NewHertz) != atoi(FicWav->Hertz)) FicWav->Bool_Conv = TRUE;
		if (atoi(FicWav->NewVoie) != atoi(FicWav->Voie)) FicWav->Bool_Conv = TRUE;
		if (atoi(FicWav->NewBits) != atoi(FicWav->Bits)) FicWav->Bool_Conv = TRUE;

		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

void file_set_default_parameters_to_column (gboolean Boolfreq, gboolean Boolvoie, gboolean Boolbits)
{
	GtkTreeIter    iter;
	gboolean       valid;
	DETAIL        *detail = NULL;
	FIC_WAV       *FicWav = NULL;
	gchar         *Str = NULL;

	/*PRINT_FUNC_LF();*/

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		FicWav = (FIC_WAV *)detail->fic_wav;

		/* Et mettre le contenu a jour
		*/
		if (Boolfreq) {
			if (FicWav->NewHertz) {
				g_free (FicWav->NewHertz);
				FicWav->NewHertz = NULL;
			}
			FicWav->NewHertz = g_strdup (FicWav->Hertz);

			if (strcmp (FicWav->Hertz, FicWav->NewHertz) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewHertz);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewHertz);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, Str, -1);
			g_free (Str);
			Str = NULL;
		}
		if (Boolvoie) {
			if (FicWav->NewVoie) {
				g_free (FicWav->NewVoie);
				FicWav->NewVoie = NULL;
			}
			FicWav->NewVoie = g_strdup (FicWav->Voie);

			if (strcmp (FicWav->Voie, FicWav->NewVoie) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewVoie);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewVoie);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, Str, -1);
			g_free (Str);
			Str = NULL;
		}
		if (Boolbits) {
			if (FicWav->NewBits) {
				g_free (FicWav->NewBits);
				FicWav->NewBits = NULL;
			}
			FicWav->NewBits = g_strdup (FicWav->Bits);

			if (strcmp (FicWav->Bits, FicWav->NewBits) == 0)
				Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewBits);
			else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewBits);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, Str, -1);
			g_free (Str);
			Str = NULL;
		}

		FicWav->Bool_Conv = FALSE;
		if (atoi(FicWav->NewHertz) != atoi(FicWav->Hertz)) FicWav->Bool_Conv = TRUE;
		if (atoi(FicWav->NewVoie) != atoi(FicWav->Voie)) FicWav->Bool_Conv = TRUE;
		if (atoi(FicWav->NewBits) != atoi(FicWav->Bits)) FicWav->Bool_Conv = TRUE;

		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	file_set_flag_buttons_audio_file ();
}

void file_set_default_parameters_is_selected (gboolean Boolfreq, gboolean Boolvoie, gboolean Boolbits)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_WAV          *FicWav = NULL;
	GList            *list = NULL;
	gchar            *Str = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		path = list->data;
		if (path) {
			/* prend le numero de la structure
			*/
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			FicWav = (FIC_WAV *)detail->fic_wav;

			/* Et mettre le contenu a jour
			*/
			if (Boolfreq) {
				if (FicWav->NewHertz) {
					g_free (FicWav->NewHertz);
					FicWav->NewHertz = NULL;
				}
				FicWav->NewHertz = g_strdup (FicWav->Hertz);

				if (strcmp (FicWav->Hertz, FicWav->NewHertz) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewHertz);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewHertz);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, Str, -1);
				g_free (Str);
				Str = NULL;
			}
			if (Boolvoie) {
				if (FicWav->NewVoie) {
					g_free (FicWav->NewVoie);
					FicWav->NewVoie = NULL;
				}
				FicWav->NewVoie = g_strdup (FicWav->Voie);

				if (strcmp (FicWav->Voie, FicWav->NewVoie) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewVoie);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewVoie);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, Str, -1);
				g_free (Str);
				Str = NULL;
			}
			if (Boolbits) {
				if (FicWav->NewBits) {
					g_free (FicWav->NewBits);
					FicWav->NewBits = NULL;
				}
				FicWav->NewBits = g_strdup (FicWav->Bits);

				if (strcmp (FicWav->Bits, FicWav->NewBits) == 0)
					Str = g_strdup_printf ("<span color=\"forestgreen\"><b>%s</b></span>", FicWav->NewBits);
				else	Str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", FicWav->NewBits);
				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, Str, -1);
				g_free (Str);
				Str = NULL;
			}

			FicWav->Bool_Conv = FALSE;
			if (atoi(FicWav->NewHertz) != atoi(FicWav->Hertz)) FicWav->Bool_Conv = TRUE;
			if (atoi(FicWav->NewVoie) != atoi(FicWav->Voie)) FicWav->Bool_Conv = TRUE;
			if (atoi(FicWav->NewBits) != atoi(FicWav->Bits)) FicWav->Bool_Conv = TRUE;

		}
		list = g_list_next (list);
	}
	file_set_flag_buttons_audio_file ();
}

void file_convert_set_change_parameters_is_selected (TYPE_CEIL_WAV TypeCeilWav, gint freq, gint voie, gint bits)
{
	gchar *StrFreq = NULL;
	gchar *StrVoie = NULL;
	gchar *StrBits = NULL;

	if (freq != -1) StrFreq = g_strdup_printf ("%d", freq);
	if (voie != -1) StrVoie = g_strdup_printf ("%d", voie);
	if (bits != -1) StrBits = g_strdup_printf ("%d", bits);

	switch (TypeCeilWav) {
	case _CEIL_ :
		file_set_change_parameters_is_selected (StrFreq, StrVoie, StrBits);
		break;
	case _COLUMN_ :
		file_set_change_parameters_to_column (StrFreq, StrVoie, StrBits);
		break;
	case _DEFAULT_CEIL_ :
		file_set_default_parameters_is_selected (StrFreq ? TRUE : FALSE, StrVoie ? TRUE : FALSE, StrBits ? TRUE : FALSE);
		break;
	case _DEFAULT_COLUMN_ :
		file_set_default_parameters_to_column (StrFreq ? TRUE : FALSE, StrVoie ? TRUE : FALSE, StrBits ? TRUE : FALSE);
		break;
	}

	g_free (StrFreq);
	g_free (StrVoie);
	g_free (StrBits);
	StrFreq = NULL;
	StrVoie = NULL;
	StrBits = NULL;

	file_spinbutton_change_frequence_value ();
	file_set_flag_buttons_audio_file ();
}

/*
ACTION CHANGE VALUE IN SAISIE
	affiche "value" in treeview
*/
void file_spinbutton_frequence_value_changed (void)
{
	gchar  *ptr = NULL;
	glong   value;

	if (!var_file.Adr_spinbutton_frequence) return;
	if (var_file.BOOL_ENTER_SPIN == FALSE) return;

	value = (glong)gtk_spin_button_get_value (var_file.Adr_spinbutton_frequence);

	if (value == 0) {
		file_set_change_parameters_is_selected ("", NULL, NULL);
	}
	else {
		ptr = g_strdup_printf ("%lu", value);
		file_set_change_parameters_is_selected (ptr, NULL, NULL);
		g_free (ptr);
		ptr = NULL;
	}
}

/*
*---------------------------------------------------------------------------
* COMBOBOX: FILE, FILE_WAV, FILE_MP3_OGG
*---------------------------------------------------------------------------
*/

// void		 utils_remove_combo (void);
// GtkListStore	*utils_alloc_combo (GtkComboBox *p_combo);

void file_set_combobox_dest_file (gint p_PageNum)
{
	GtkComboBox *WidgetCombobox = var_file.Adr_combobox_DestFile;
	// GtkListStore		*store = NULL;
	// GtkCellRenderer 	*renderer = NULL;
	// GtkTreeIter		iter;
	// static gboolean pass = FALSE;

	// PRINT_FUNC_LF();
		
		// if (pass == FALSE) {
		// store = gtk_list_store_new (1, G_TYPE_STRING);
		// gtk_combo_box_set_model (GTK_COMBO_BOX(WidgetCombobox), GTK_TREE_MODEL(store));
		// renderer = gtk_cell_renderer_text_new ();
		// gtk_cell_layout_pack_start (GTK_CELL_LAYOUT(WidgetCombobox), renderer, TRUE);
		// gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT(WidgetCombobox), renderer, "text", 0, NULL);
		// pass = TRUE;
		// }
		// else {
		// store = GTK_LIST_STORE (gtk_combo_box_get_model(WidgetCombobox));
		// }

	// utils_clear_elements_combobox (GTK_COMBO_BOX (WidgetCombobox));
		
		// gtk_list_store_append (store, &iter);
		// gtk_list_store_set (store, &iter, 0, _("Conversion(s) vers la source"), -1);
		// gtk_list_store_append (store, &iter);
		// gtk_list_store_set (store, &iter, 0, _("Choix d'une nouvelle destination"), -1);
		// gtk_combo_box_set_active (GTK_COMBO_BOX (WidgetCombobox), 0);
		// return;

	var_file.Adr_combobox_DestFile = NULL;
	var_file.BOOL_ENTER = FALSE;

	/* Vider le combobox */
	// utils_clear_elements_combobox (GTK_COMBO_BOX (WidgetCombobox));
	// store = utils_alloc_combo (WidgetCombobox);
	utils_alloc_combo (WidgetCombobox);

	/* Les deux premieres entrees par defaut */
	gtk_combo_box_append_text (GTK_COMBO_BOX (WidgetCombobox), _("Conversion(s) vers la source"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (WidgetCombobox), _("Choix d'une nouvelle destination"));
	
	/* et le path choisis par l'utilisateur */
	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		gtk_combo_box_append_text (GTK_COMBO_BOX (WidgetCombobox), Config_User.Path_Destination_file);
		gtk_combo_box_set_active (GTK_COMBO_BOX (WidgetCombobox), Config_User.Value_choice_file_dest);

		gtk_label_set_markup (GTK_LABEL (XCFA_GET_OBJECT("label_combobox_dest_file")),
					_("<b> Destination des conversions </b>"));
		break;
	case NOTEBOOK_FICHIERS_WAV :
		gtk_combo_box_append_text (GTK_COMBO_BOX (WidgetCombobox), Config_User.Path_Destination_file_wav);
		gtk_combo_box_set_active (GTK_COMBO_BOX (WidgetCombobox), Config_User.Value_choice_file_dest_wav);

		gtk_label_set_markup (GTK_LABEL (XCFA_GET_OBJECT("label_combobox_dest_file")),
					_("<b> Destination Wav </b>"));
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		gtk_combo_box_append_text (GTK_COMBO_BOX (WidgetCombobox), Config_User.Path_Destination_file_mp3ogg);
		gtk_combo_box_set_active (GTK_COMBO_BOX (WidgetCombobox), Config_User.Value_choice_file_mp3ogg_dest);

		gtk_label_set_markup (GTK_LABEL (XCFA_GET_OBJECT("label_combobox_dest_file")),
					_("<b> Destination Ogg et Mp3 </b>"));
		break;
	}
	var_file.Adr_combobox_DestFile = WidgetCombobox;
	var_file.BOOL_ENTER = TRUE;
	var_file.BOOL_ENTER_SPIN = TRUE;
}
void file_select_new_path_destination (gchar *path)
{
	/*PRINT_FUNC_LF();*/
	if (options_verif_dossier_is_ok (path) == TRUE) {
		if (utils_test_write (path) == TRUE) {

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				g_free (Config_User.Path_Destination_file);
				Config_User.Path_Destination_file = NULL;
				Config_User.Path_Destination_file = g_strdup (path);
				break;
			case NOTEBOOK_FICHIERS_WAV :
				g_free (Config_User.Path_Destination_file_wav);
				Config_User.Path_Destination_file_wav = NULL;
				Config_User.Path_Destination_file_wav = g_strdup (path);
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				g_free (Config_User.Path_Destination_file_mp3ogg);
				Config_User.Path_Destination_file_mp3ogg = NULL;
				Config_User.Path_Destination_file_mp3ogg = g_strdup (path);
				break;
			}

			file_set_combobox_dest_file (var_file.PageNum);

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				Config_User.Value_choice_file_dest = 2;
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_dest);
				break;
			case NOTEBOOK_FICHIERS_WAV :
				Config_User.Value_choice_file_dest_wav = 2;
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_dest_wav);
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				Config_User.Value_choice_file_mp3ogg_dest = 2;
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_mp3ogg_dest);
				break;
			}

		}
	}
}
void file_combobox_dest_file_changed ()
{
	if (var_file.BOOL_ENTER == FALSE) return;
	if (var_file.Adr_combobox_DestFile != NULL) {

		/*PRINT_FUNC_LF();*/
		switch (gtk_combo_box_get_active (var_file.Adr_combobox_DestFile)) {
		case 0 :
			file_pixbuf_update_glist_file ();

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				Config_User.Value_choice_file_dest = 0;
				break;
			case NOTEBOOK_FICHIERS_WAV :
				Config_User.Value_choice_file_dest_wav = 0;
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				Config_User.Value_choice_file_mp3ogg_dest = 0;
				break;
			}
			break;

		case 1 :
			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_dest);
				fileselect_create (_PATH_DESTINATION_FILE_, file_select_new_path_destination);
				break;
			case NOTEBOOK_FICHIERS_WAV :
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_dest_wav);
				fileselect_create (_PATH_DESTINATION_FILE_WAV_, file_select_new_path_destination);
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config_User.Value_choice_file_mp3ogg_dest);
				fileselect_create (_PATH_DESTINATION_FILE_MP3OGG_, file_select_new_path_destination);
				break;
			}
			break;

		case 2 :
			file_pixbuf_update_glist_file ();

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				Config_User.Value_choice_file_dest = 2;
				break;
			case NOTEBOOK_FICHIERS_WAV :
				Config_User.Value_choice_file_dest_wav = 2;
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				Config_User.Value_choice_file_mp3ogg_dest = 2;
				break;
			}
			break;
		}
	}
}

void file_combobox_dest_file_realize (GtkWidget *widget)
{
	var_file.Adr_combobox_DestFile = GTK_COMBO_BOX (widget);
}

/*
*---------------------------------------------------------------------------
* IMPORT FICHIERS
*---------------------------------------------------------------------------
*/

void file_button_import_file_clicked (void)
{
	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		fileselect_create (_PATH_LOAD_FILE_, NULL);
		break;
	case NOTEBOOK_FICHIERS_WAV :
		fileselect_create (_PATH_IMPORT_FILE_WAV_, NULL);
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		fileselect_create (_PATH_IMPORT_FILE_MP3OGG_, NULL);
		break;
	}
}

GList *file_clear_GLIST_line_selected (GList *p_list)
{
	GList *list = NULL;

	list = g_list_first (p_list);
	while (list) {
		list->data = NULL;
		list = g_list_next (list);
	}

	g_list_free (p_list);
	p_list = NULL;
	return ((GList *)NULL);
}

GList *file_get_GLIST_line_selected (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;


	/* marque les structures a detruires dans le glist 'entefile' */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			switch (var_file.PageNum) {
			case NOTEBOOK_FICHIERS_CONVERSION :
			case NOTEBOOK_FICHIERS_TAGS :
				var_file.AdrGlistFile = g_list_append (var_file.AdrGlistFile, detail);
				break;
			case NOTEBOOK_FICHIERS_WAV :
				var_file.AdrGlistFileWav = g_list_append (var_file.AdrGlistFileWav, detail);
				break;
			case NOTEBOOK_FICHIERS_MP3OGG :
				var_file.AdrGlistFileMp3Ogg = g_list_append (var_file.AdrGlistFileMp3Ogg, detail);
				break;
			}
		}
		list = g_list_next (list);
	}

	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		return (var_file.AdrGlistFile);
	case NOTEBOOK_FICHIERS_WAV :
		return (var_file.AdrGlistFileWav);
	case NOTEBOOK_FICHIERS_MP3OGG :
		return (var_file.AdrGlistFileMp3Ogg);
	}
	return (NULL);
}

void file_set_GLIST_line_selected (GList *p_list)
{
	gboolean      valid;
	GtkTreeIter   iter;
	DETAIL       *detail = NULL;
	GList        *list = NULL;
	GtkTreePath  *path;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		list = g_list_first (p_list);
		while (list) {
			if (list->data == detail) {
				gtk_tree_selection_select_iter (var_file.Adr_Line_Selected, &iter);
				path = gtk_tree_model_get_path (var_file.Adr_Tree_Model, &iter);
				gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (var_file.Adr_TreeView), path, NULL, TRUE, 0.5, 0.5);
				break;
			}
			list = g_list_next (list);
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
}


void file_notebook_in_file_switch_page (guint page_num)
{
	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		var_file.AdrGlistFile = file_get_GLIST_line_selected ();
		break;
	case NOTEBOOK_FICHIERS_WAV :
		var_file.AdrGlistFileWav = file_get_GLIST_line_selected ();
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		var_file.AdrGlistFileMp3Ogg = file_get_GLIST_line_selected ();
		break;
	}

	/* Affecter la nouvelle page */
	var_file.PageNum = page_num;

	showhidetreeview_get_etat_fields ();
	showhidetreeview_set_etat_treeview (Config_User.notebook_general, var_file.PageNum);
	/* Mise a jour de la destination des fichiers */
	file_set_combobox_dest_file (var_file.PageNum);
	/* Affichage du contenu des colonnes */
	file_affiche_glist_file ();
	file_set_flag_buttons_audio_file ();

	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
	case NOTEBOOK_FICHIERS_TAGS :
		file_set_GLIST_line_selected (var_file.AdrGlistFile);
		var_file.AdrGlistFile = file_clear_GLIST_line_selected (var_file.AdrGlistFile);
		break;
	case NOTEBOOK_FICHIERS_WAV :
		file_set_GLIST_line_selected (var_file.AdrGlistFileWav);
		var_file.AdrGlistFileWav = file_clear_GLIST_line_selected (var_file.AdrGlistFileWav);
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		file_set_GLIST_line_selected (var_file.AdrGlistFileMp3Ogg);
		var_file.AdrGlistFileMp3Ogg = file_clear_GLIST_line_selected (var_file.AdrGlistFileMp3Ogg);
		break;
	}
}

void file_button_efface_bitrate_clicked_file_MP3OGG (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	FIC_MP3OGG       *fic = NULL;

	/*PRINT_FUNC_LF();*/

	/* Marque les elements a detruire */
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if ((path = list->data)) {
			/* prend le numero de la structure */
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {

				if (detail->type_infosong_file_is == FILE_IS_MP3) {
					fic->Lame.type  = -1;
					fic->Lame.debit = -1;
					fic->Lame.mode  = -1;
				}
				else if (detail->type_infosong_file_is == FILE_IS_OGG) {
					fic->Oggenc.type  = -1;
					fic->Oggenc.debit = -1;
					fic->Oggenc.mode  = -1;
				}

				gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, "", -1);
			}
		}
		list = g_list_next (list);
	}
	file_set_flag_buttons_audio_file ();
}

void file_button_apply_file_clicked (GtkButton *button)
{
	SIZE_TMP SizeTmp;

	switch (var_file.PageNum) {
	case NOTEBOOK_FICHIERS_CONVERSION :
		if (GTK_BUTTON (GTK_WIDGET (XCFA_GET_OBJECT("button_conv_file"))) == button) {

			if (file_peak_get_size_is_ok (NORM_PEAK_ALBUM, &SizeTmp) == FALSE) {

				gchar *Str1 = NULL;
				gchar *Str2 = NULL;

				Str1 = g_strdup_printf ("<b>   %s/  = %lu Ko</b>", Config_User.Path_TMP, SizeTmp.SizeTmpKo);
				Str2 = g_strdup_printf ("<b>   %lu Ko en selection</b>", SizeTmp.SizeFileKo);

				wininfo_create (
					_("CAPACITE DOSSIER TEMPORAIRE TROP FAIBLE"),
					_("   Pas assez de place dans le dossier temporaire              "),
					  "\n",
					  Str1,
					  "\n",
					  Str2,
					  "\n\n",
					_("   Veuillez deselectionner des PeakGroup."),
					  "\n",
					"");

				g_free (Str1);
				Str1 = NULL;
				g_free (Str2);
				Str2 = NULL;
				return;
			}
			else {
				file_button_conv_file_clicked ();
			}
		}
		break;
	case NOTEBOOK_FICHIERS_WAV :
		if (GTK_BUTTON (GTK_WIDGET (XCFA_GET_OBJECT("button_apply_wav"))) == button) {
			filewavconv_apply ();
		}
		break;
	case NOTEBOOK_FICHIERS_MP3OGG :
		if (GTK_BUTTON (GTK_WIDGET (XCFA_GET_OBJECT("button_applique_file_mp3ogg"))) == button) {
			filemp3oggconv_apply_regul_mp3ogg_by_conv ();
		}
		break;
	}
}

/* Changement des parametres: freq, voie, ou bits si differents de NULL
*  --
*  entree :
*      gchar *freq :
*      gchar *voie :
*      gchar *bits :
*  retour : -
*/
void file_change_parameters_MP3OGG (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	DETAIL           *detail = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	FIC_WAV          *fic = NULL;

	PRINT_FUNC_LF();
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		path = list->data;
		if (path) {
			/* prend le numero de la structure
			*/
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
			fic = (FIC_WAV *)detail->fic_wav;
			/* Et mettre le contenu a jour
			*/
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_HERTZ, fic->NewHertz, -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_VOIE, fic->NewVoie, -1);
			gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEWAV_NEW_BITS, fic->NewBits, -1);
		}
		list = g_list_next (list);
	}
}

GList *file_get_glist_play (void)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	GList            *list = NULL;
	GList            *p_list = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	if ((list = g_list_first (list))) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			if (detail && detail->namefile) {

				file_set_etat_music_pixbuf_with_detail (detail, FILE_ETAT_PLAY);

				p_list = g_list_append (p_list, g_strdup (detail->namefile));
				p_list = g_list_append (p_list, g_strdup ("-ss"));
				p_list = g_list_append (p_list, g_strdup ("0"));
			}
		}
	}

	return ((GList *)p_list);
}

gint file_set_scan (void)
{
	DETAIL         *detail = NULL;
	FIC            *fic = NULL;
	GtkTreeIter     iter;
	gboolean        valid;
	gint		compteur = 0;

	valid = gtk_tree_model_get_iter_first (var_file.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);
		if (detail && (fic = (FIC *)detail->fic)) {
			if(detail->choice_treeview != _TREEVIEW_SPLIT_ &&
			   (detail->type_infosong_file_is == FILE_IS_WAV ||
			    detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG)) {

				if (fic->Etat_Scan == ETAT_SCAN_DEMANDE) compteur ++;
			}
		}
		valid = gtk_tree_model_iter_next (var_file.Adr_Tree_Model, &iter);
	}
	return (compteur);
}

void file_combobox_normalise_file_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Peak/album"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Peak"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mix (scan)Rms/album"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Fix (scan)Rms"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_file.AdrComboboxNormalise = GTK_COMBO_BOX (widget);

	/*g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(file_choix_compression), NULL);*/
}

void file_combobox_normalise_file_changed (void)
{
	GList		*list = NULL;
	DETAIL		*detail = NULL;
	FIC		*fic = NULL;
	gboolean	 BoolScanACtion = FALSE;
	gint		 FicLevelMix;

	if (var_file.AdrComboboxNormalise == NULL) return;

	FicLevelMix = (gint)gtk_spin_button_get_value (var_file.AdrSpinbuttonNormalise);

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {

			if (detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_WAV) {

				if ((fic = (FIC *)detail->fic) && fic->Etat_Normalise > NORM_READY_FOR_SELECT) {
					switch (gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise))) {
					case 0 :
						fic->Etat_Normalise = NORM_PEAK_ALBUM;
						gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
						break;
					case 1 :
						fic->Etat_Normalise = NORM_PEAK;
						gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
						break;
					case 2 :
						fic->LevelMix = FicLevelMix;
						fic->Etat_Normalise = NORM_RMS_MIX_ALBUM;
						if (fic->Etat_Scan == ETAT_SCAN_NONE) {
							fic->Etat_Scan = ETAT_SCAN_DEMANDE;
							BoolScanACtion = TRUE;
						}
						gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), TRUE);
						break;
					case 3 :
						if (detail->type_infosong_file_is == FILE_IS_WAV) {
							INFO_WAV *info           = (INFO_WAV *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						else if (detail->type_infosong_file_is == FILE_IS_MP3) {
							INFO_MP3 *info           = (INFO_MP3 *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						else if (detail->type_infosong_file_is == FILE_IS_OGG) {
							INFO_OGG *info           = (INFO_OGG *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						fic->Etat_Normalise = NORM_RMS_FIX;
						if (fic->Etat_Scan == ETAT_SCAN_NONE) {
							fic->Etat_Scan = ETAT_SCAN_DEMANDE;
							BoolScanACtion = TRUE;
						}
						gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), TRUE);
						break;
					}
				}
			}
		}
		list = g_list_next (list);
	}

	if (BoolScanACtion == TRUE) FileScanDB_action (TRUE);

	file_pixbuf_update_glist_file ();

}
void file_spinbutton_choix_niveau_file_value_changed (void)
{
	gint		 FicLevelMix = (gint)gtk_spin_button_get_value (var_file.AdrSpinbuttonNormalise);
	GList		*list = NULL;
	DETAIL		*detail = NULL;
	FIC		*fic = NULL;

	if (var_file.AdrSpinbuttonNormalise == NULL) return;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {

			if (detail->type_infosong_file_is == FILE_IS_MP3 ||
			    detail->type_infosong_file_is == FILE_IS_OGG ||
			    detail->type_infosong_file_is == FILE_IS_WAV) {

				if ((fic = (FIC *)detail->fic) && fic->Etat_Normalise > NORM_READY_FOR_SELECT) {
					switch (gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise))) {
					case 0 :
					case 1 :
						break;
					case 2 :
						fic->LevelMix = FicLevelMix;
						break;
					case 3 :
						if (detail->type_infosong_file_is == FILE_IS_WAV) {
							INFO_WAV *info           = (INFO_WAV *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						else if (detail->type_infosong_file_is == FILE_IS_MP3) {
							INFO_MP3 *info           = (INFO_MP3 *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						else if (detail->type_infosong_file_is == FILE_IS_OGG) {
							INFO_OGG *info           = (INFO_OGG *)detail->info;
							info->LevelDbfs.NewLevel = FicLevelMix;
						}
						break;
					}
				}
			}
		}
		list = g_list_next (list);
	}
	file_pixbuf_update_glist_file ();
}

/* Update pour FILE_IS_MP3 et FILE_IS_OGG
*/
void file_update_LameOggenc_mp3ogg (TYPE_FILE_IS TypeFileIs)
{
	GtkTreeModel		*model = NULL;
	GList			*list = NULL;
	GtkTreePath		*path;
	DETAIL			*detail = NULL;
	GtkTreeIter		 iter;
	FIC_MP3OGG		*fic = NULL;
	gchar			*Str = NULL;

	/*PRINT_FUNC_LF();*/
	if (var_file.BOOL_ENTER == FALSE) return;
	var_file.BOOL_ENTER = FALSE;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	list = g_list_first (gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model));
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, COLUMN_FILE_POINTER_STRUCT, &detail, -1);

			/* FILE_IS_MP3
			*/
			if (TypeFileIs == FILE_IS_MP3 && detail->type_infosong_file_is == FILE_IS_MP3) {

				if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
					fic->Lame.type = Config_User.RateMp3OggFile.Bitrate_type_Lame;
					switch (fic->Lame.type) {
					case 0 : fic->Lame.debit = Config_User.RateMp3OggFile.If_abr;		break;
					case 1 : fic->Lame.debit = Config_User.RateMp3OggFile.If_cbr;		break;
					case 2 : fic->Lame.debit = Config_User.RateMp3OggFile.If_vbr;		break;
					case 3 : fic->Lame.debit = Config_User.RateMp3OggFile.If_vbr_new;	break;
					}
					if (fic->Lame.debit < 0) fic->Lame.debit = 0;
					fic->Lame.mode = Config_User.RateMp3OggFile.Mode_Lame;
					Str = file_get_param_lame_affiche (fic->Lame.type, fic->Lame.debit, fic->Lame.mode);
					gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, Str, -1);
					g_free (Str);
					Str = NULL;
				}
			}
			/* FILE_IS_OGG
			*/
			else if (TypeFileIs == FILE_IS_OGG && detail->type_infosong_file_is == FILE_IS_OGG) {

				if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
					fic->Oggenc.type  = Config_User.RateMp3OggFile.Bitrate_Oggenc;
					fic->Oggenc.debit = Config_User.RateMp3OggFile.Managed_Oggenc;
					fic->Oggenc.mode  = Config_User.RateMp3OggFile.Downmix_Oggenc;
					Str = file_get_param_oggenc_affiche (fic->Oggenc.type, fic->Oggenc.debit, fic->Oggenc.mode);
					gtk_list_store_set (var_file.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, Str, -1);
					g_free (Str);
					Str = NULL;
				}
			}
		}

		list = g_list_next(list);
	}
	file_set_flag_buttons_audio_file ();
	var_file.BOOL_ENTER = TRUE;
}

void file_combobox_lame_abr_cbr_vbr_mp3ogg_realize (GtkWidget *widget)
{
	var_file.Adr_Widget_Lame_abr_cbr_vbr = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "ABR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "CBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR-NEW");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggFile.Bitrate_type_Lame);
}
void file_combobox_lame_abr_cbr_vbr_mp3ogg_changed (void)
{
	if (var_file.Adr_Widget_Lame_abr_cbr_vbr == NULL || var_file.Adr_Widget_Lame_bitrate == NULL) return;

	var_file.BOOL_ENTER = FALSE;
	// utils_clear_elements_combobox (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate));
	utils_alloc_combo (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate));

	/* LA MEME CHOSE POUR LE MODULE OPTION
	*/
	Config_User.RateMp3OggFile.Bitrate_type_Lame  = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_abr_cbr_vbr);

	switch (gtk_combo_box_get_active (var_file.Adr_Widget_Lame_abr_cbr_vbr)) {
	/* ABR 0 .. 13 */
	case 0 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "128");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "320");
		var_file.BOOL_ENTER = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggFile.If_abr);
		break;
	/* CBR 0 .. 14 */
	case 1 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), _("128 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "320");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset insane");
		var_file.BOOL_ENTER = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggFile.If_cbr);
		break;
	/* VBR 0 .. 14 */
	case 2 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), _("V0 -meilleure qualite"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), _("V4 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), _("V9 -moins bonne qualite"));
		var_file.BOOL_ENTER = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggFile.If_vbr);
		break;
	/* VBR_NEW 0 .. 14 */
	case 3 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), " ");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V0");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), _("V4 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), "V9");
		var_file.BOOL_ENTER = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggFile.If_vbr_new);
		break;
	}
}

void file_combobox_lame_type_bitrate_mp3ogg_realize (GtkWidget *widget)
{
	var_file.Adr_Widget_Lame_bitrate = GTK_COMBO_BOX (widget);
	file_combobox_lame_abr_cbr_vbr_mp3ogg_changed ();
}
void file_combobox_lame_type_bitrate_mp3ogg_changed (void)
{
	if (var_file.BOOL_ENTER == FALSE) return;

	if (var_file.Adr_Widget_Lame_bitrate == NULL || var_file.Adr_Widget_Lame_abr_cbr_vbr == NULL) return;

	switch (gtk_combo_box_get_active (var_file.Adr_Widget_Lame_abr_cbr_vbr)) {
	/* ABR 0 .. 13 */
	case 0 :
		Config_User.RateMp3OggFile.If_abr = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_bitrate);
		break;
	/* CBR 0 .. 14 */
	case 1 :
		Config_User.RateMp3OggFile.If_cbr = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_bitrate);
		break;
	/* VBR 0 .. 14 */
	case 2 :
		Config_User.RateMp3OggFile.If_vbr = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_bitrate);
		break;
	/* VBR_NEW 0 .. 14 */
	case 3 :
		Config_User.RateMp3OggFile.If_vbr_new = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_bitrate);
		break;
	}
	file_update_LameOggenc_mp3ogg (FILE_IS_MP3);
}

void file_combobox_lame_mode_mp3ogg_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Defaut"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Forced Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Duo Channels");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Mono");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggFile.Mode_Lame);
	var_file.Adr_Widget_Lame_Mode = GTK_COMBO_BOX (widget);
}
void file_combobox_lame_mode_mp3ogg_changed (void)
{
	if (var_file.BOOL_ENTER == FALSE) return;

	if (var_file.Adr_Widget_Lame_Mode == NULL || var_options.Adr_Widget_Lame_Mode == NULL) return;

	Config_User.RateMp3OggFile.Mode_Lame = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_Mode);

	file_update_LameOggenc_mp3ogg (FILE_IS_MP3);

	/* LA MEME CHOSE POUR LE MODULE OPTION
	*/
	Config_User.RateMp3OggFile.Mode_Lame = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_Mode);
}

void file_combobox_oggenc_bitrate_mp3ogg_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 45  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 64  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 80  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 96  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "112  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "128  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "160  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "192  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "224  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "256  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "320  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite -1 -Moins bonne qualite"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  0"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  1"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  2"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  3 -Defaut"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  4"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  5"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  6"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  7"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  8"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  9"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  10 -Meilleure qualite"));
	var_file.Adr_Widget_Oggenc_bitrate = GTK_COMBO_BOX (widget);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggFile.Bitrate_Oggenc);
}
void file_combobox_oggenc_bitrate_mp3ogg_changed (void)
{
	if (var_file.BOOL_ENTER == FALSE) return;
	if (var_file.Adr_Widget_Oggenc_bitrate == NULL) return;

	gtk_widget_set_sensitive (
		GTK_WIDGET (XCFA_GET_OBJECT("combobox_oggenc_managed_mp3ogg")),
		gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate) < 11 ? TRUE : FALSE);
	gtk_widget_set_sensitive (
		GTK_WIDGET (XCFA_GET_OBJECT("combobox_oggenc_downmix_m3ogg")),
		gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate) < 9 ? TRUE : FALSE);
	
	if (var_file.Adr_Widget_Oggenc_bitrate)
		Config_User.RateMp3OggFile.Bitrate_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate);
	if (var_file.Adr_Widget_Oggenc_managed)
		Config_User.RateMp3OggFile.Managed_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_managed);
	if (var_file.Adr_Widget_Oggenc_downmix)
		Config_User.RateMp3OggFile.Downmix_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_downmix);

	file_update_LameOggenc_mp3ogg (FILE_IS_OGG);
}

void file_combobox_oggenc_managed_mp3ogg_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggFile.Managed_Oggenc);
	var_file.Adr_Widget_Oggenc_managed = GTK_COMBO_BOX (widget);
	file_combobox_oggenc_managed_mp3ogg_changed ();
}
void file_combobox_oggenc_managed_mp3ogg_changed (void)
{
	if (var_file.BOOL_ENTER == FALSE) return;
	if (var_file.Adr_Widget_Oggenc_managed == NULL) return;

	if (var_file.Adr_Widget_Oggenc_bitrate)
		Config_User.RateMp3OggFile.Bitrate_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate);
	if (var_file.Adr_Widget_Oggenc_managed)
		Config_User.RateMp3OggFile.Managed_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_managed);
	if (var_file.Adr_Widget_Oggenc_downmix)
		Config_User.RateMp3OggFile.Downmix_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_downmix);
	file_update_LameOggenc_mp3ogg (FILE_IS_OGG);
}
void file_combobox_oggenc_downmix_m3ogg_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mono force"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Stereo"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggFile.Downmix_Oggenc);
	var_file.Adr_Widget_Oggenc_downmix = GTK_COMBO_BOX (widget);
	file_combobox_oggenc_downmix_m3ogg_changed ();
}
void file_combobox_oggenc_downmix_m3ogg_changed (void)
{
	if (var_file.BOOL_ENTER == FALSE) return;
	if (var_file.Adr_Widget_Oggenc_downmix == NULL) return;

	if (var_file.Adr_Widget_Oggenc_bitrate)
		Config_User.RateMp3OggFile.Bitrate_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate);
	if (var_file.Adr_Widget_Oggenc_managed)
		Config_User.RateMp3OggFile.Managed_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_managed);
	if (var_file.Adr_Widget_Oggenc_downmix)
		Config_User.RateMp3OggFile.Downmix_Oggenc = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_downmix);
	file_update_LameOggenc_mp3ogg (FILE_IS_OGG);
}


gchar *file_get_param_lame_print (void)
{
	gchar	*Str = NULL;
	static gchar StrLame[ 100 ];

	Str = g_strdup_printf ("%d %d %d",
			gtk_combo_box_get_active (var_file.Adr_Widget_Lame_abr_cbr_vbr),
			gtk_combo_box_get_active (var_file.Adr_Widget_Lame_bitrate),
			gtk_combo_box_get_active (var_file.Adr_Widget_Lame_Mode)
			);
	strcpy (StrLame, Str);
	g_free (Str);
	Str = NULL;
	return ((gchar *)StrLame);
}

gchar *file_get_param_lame_affiche (gint abr_cbr_vbr, gint bitrate, gint mode)
{
	gchar *PtrStrLame = NULL;

	gchar *str_abr [] = {
	"ABR: -b 32",
	"ABR: -b 40",
	"ABR: -b 48",
	"ABR: -b 56",
	"ABR: -b 64",
	"ABR: -b 80",
	"ABR: -b 96",
	"ABR: -b 112",
	"ABR: -b 128",
	"ABR: -b 160",
	"ABR: -b 192",
	"ABR: -b 224",
	"ABR: -b 256",
	"ABR: -b 320"
	};
	gchar *str_cbr [] = {
	"CBR: -b 32",
	"CBR: -b 40",
	"CBR: -b 48",
	"CBR: -b 56",
	"CBR: -b 64",
	"CBR: -b 80",
	"CBR: -b 96",
	"CBR: -b 112",
	"CBR: -b 128",
	"CBR: -b 160",
	"CBR: -b 192",
	"CBR: -b 224",
	"CBR: -b 256",
	"CBR: -b 320",
	"CBR: --preset insane"
	};
	gchar *str_vbr [] = {
	"VBR: --preset medium",
	"VBR: --preset standard",
	"VBR: --preset extreme",
	"VBR: --preset fast standard",
	"VBR: --preset fast extreme",
	"VBR: -V0",
	"VBR: -V1",
	"VBR: -V2",
	"VBR: -V3",
	"VBR: -V4",
	"VBR: -V5",
	"VBR: -V6",
	"VBR: -V7",
	"VBR: -V8",
	"VBR: -V9"
	};
	gchar *str_vbr_new [] = {
	"VBR NEW",
	"VBR NEW: --preset medium",
	"VBR NEW: --preset standard",
	"VBR NEW: --preset extreme",
	"VBR NEW: --preset fast standard",
	"VBR NEW: --preset fast extreme",
	"VBR NEW: -V0",
	"VBR NEW: -V1",
	"VBR NEW: -V2",
	"VBR NEW: -V3",
	"VBR NEW: -V4",
	"VBR NEW: -V5",
	"VBR NEW: -V6",
	"VBR NEW: -V7",
	"VBR NEW: -V8",
	"VBR NEW: -V9"
	};

	gchar *str_val_mode[] = {
	"Defaut",		/* 	*/
	"Stereo",		/* -m s	*/
	"Join Stereo",		/* -m j	*/
	"Forced Join Stereo",	/* -m f	*/
	"Duo Channels",		/* -m d	*/
	"Mono"			/* -m m	*/
	};

	gchar *PtrOne = NULL;
	
	if (abr_cbr_vbr < 0) return ((gchar *)g_strdup (""));
	if (bitrate < 0) return ((gchar *)g_strdup (""));

	switch (abr_cbr_vbr) {

	/* ABR */
	case 0 :
		if (bitrate > 13) bitrate = 0;
		PtrOne = g_strdup (str_abr [ bitrate ]);
		break;

	/* CBR */
	case 1 :
		if (bitrate > 14) bitrate = 0;
		PtrOne = g_strdup (str_cbr [ bitrate ]);
		break;

	/* VBR */
	case 2 :
		if (bitrate > 14) bitrate = 0;
		PtrOne = g_strdup (str_vbr [ bitrate ]);
		break;

	/* VBR_NEW */
	case 3 :
		if (bitrate > 15) bitrate = 0;
		PtrOne = g_strdup (str_vbr_new [ bitrate ]);
		break;
	default:
		return ((gchar *)g_strdup (""));
	}
	
	if (mode < 0) mode = 0;
	PtrStrLame = g_strdup_printf ("%s %s", PtrOne, str_val_mode[ mode ]);
	g_free (PtrOne);
	PtrOne = NULL;
		
	return ((gchar *)PtrStrLame);
}


gchar *file_get_param_oggenc_print (void)
{
	gchar	*Str = NULL;
	static	gchar StrOggenc[ 100 ];

	Str = g_strdup_printf ("%d %d %d",
			gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate),
			gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_managed),
			gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_downmix)
			);

	strcpy (StrOggenc, Str);
	g_free (Str);
	Str = NULL;
	return ((gchar *)StrOggenc);
}


gchar *file_get_param_oggenc_affiche (gint bitrate, gint managed, gint downmix)
{
	gchar StrOggenc[ 1000 ];

	gchar *val[] = {
	"--bitrate=45",
	"--bitrate=64",
	"--bitrate=80",
	"--bitrate=96",
	"--bitrate=112",
	"--bitrate=128",
	"--bitrate=160",
	"--bitrate=192",
	"--bitrate=224",
	"--bitrate=256",
	"--bitrate=320",
	"--quality=-1",
	"--quality=0",
	"--quality=1",
	"--quality=2",
	"--quality=3",
	"--quality=4",
	"--quality=5",
	"--quality=6",
	"--quality=7",
	"--quality=8",
	"--quality=9",
	"--quality=10"
	};
	
	
	if (bitrate < 0 || bitrate > 22) return ((gchar *)g_strdup (""));
	
	strcpy (StrOggenc, (gchar *)val[ bitrate ]);

	if (bitrate < 11) {
		if (managed == 0) {
			strcat (StrOggenc, " ");
			strcat (StrOggenc, "--managed");
		}
	}
	if (bitrate < 9) {
		if (downmix == 0) {
			strcat (StrOggenc, " ");
			strcat (StrOggenc, "--downmix");
		}
	}

	return ((gchar *)g_strdup (StrOggenc));
}


