 /*
 * file      : cd_audio_toc.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

#include "global.h"
#include "file.h"
#include "options.h"
#include "cd_audio_extract.h"
#include "fileselect.h"
#include "config_user.h"
#include "scan_cd.h"
#include "cdtoc.h"
#include "secu.h"
#include "info_song.h"
#include "file.h"
#include "utils.h"
#include "popup.h"
#include "cd_cue.h"
#include "cd_audio.h"
#include "mplayer.h"
#include "win_info.h"
#include "win_play.h"




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/



/* Activation du thread de lecture du catalogue du cd-audio et
*  des datas WEB si l'utilisateur est connecte
*  --
*  entree : -
*  retour : -
*/
void *cdaudiotoc_thread_do_read_toc_cd (void *data)
{
	/* PRINT_FUNC_LF(); */

	var_cd.bool_thread_read_toc_cd = TRUE;
	EnteteCD.GList_Audio_cd = (GList *)cdtoc_read ();
	var_cd.bool_thread_read_toc_cd = FALSE;
	secu_thread_sub ();
	pthread_exit (0);
}

/* Mise a jour des informations du cd-audio
*  --
*  entree :
*      gpointer data :
*  retour :
*      TRUE
*/
static gint cdaudiotoc_timeout_do_read_toc_cd (gpointer data)
{
	if (var_cd.bool_thread_read_toc_cd == FALSE) {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_rafraichir_cd")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame185")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (var_cd.Adr_Combo_Box), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (var_cd.Adr_Button_Destination), TRUE);

		/* FIN du timeout Update_cdaudio_do_read_toc_cd */
		gtk_timeout_remove (var_cd.handler_timeout_read_toc_cd);

		gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Progressbar));
		gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Button_Cancel_cddb));
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame185")));
		
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("hbox_cache_cd")));

		/* SI lecture OK, affichage du resultat */
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, EnteteCD.Message);

		if (EnteteCD.Bool_Read_Infos_cd == TRUE) {
			if (EnteteCD.GList_Audio_cd != NULL) {
				cdaudio_affiche_glist_audio_cd ();
				cdaudio_set_flag_buttons_audio_cd ();
				cdaudio_put_label_status_bar_cd (_DUREE_, _SHOW_, EnteteCD.Duree_cd);
				cdaudio_put_label_status_bar_cd (_TITRE_, _SHOW_, EnteteCD.TitleCD);

				cdaudio_entry_stockage_cdaudio_changed ();

				/*
				cdaudio_set_entry_tag_nom_artiste (EnteteCD.Artiste);
				cdaudio_set_entry_tag_titre_disque (EnteteCD.Title);
				*/

				/* TO DEBUG : A VERIFIER DES QUE CONNECTION WEB EST OK
				*/
				/*
				g_print ("\n");
				g_print ("EnteteCD.TitleCD            : %s\n", EnteteCD.TitleCD);
				g_print ("EnteteCD.Title              : %s\n", EnteteCD.Title);
				g_print ("EnteteCD.Artiste            : %s\n", EnteteCD.Artiste);
				g_print ("EnteteCD.Duree_cd           : %s\n", EnteteCD.Duree_cd);
				g_print ("EnteteCD.Num_ID_CD          : %lu\n",EnteteCD.Num_ID_CD);
				g_print ("EnteteCD.Str_ID_CD          : %s\n", EnteteCD.Str_ID_CD);
				g_print ("EnteteCD.TotalTracks        : %d\n", EnteteCD.TotalTracks);
				g_print ("EnteteCD.NumGenre           : %d\n", EnteteCD.NumGenre);
				g_print ("EnteteCD.StrGenre           : %s\n", EnteteCD.StrGenre);

				g_print ("GENRE                       : %s\n", cddb_disc_db_genre(EnteteCD.NumGenre));

				g_print ("EnteteCD.NumYear            : %d\n", EnteteCD.NumYear);
				g_print ("EnteteCD.StrYear            : %s\n", EnteteCD.StrYear);

				g_print ("EnteteCD.Bool_Connected     : ");
				if (EnteteCD.Bool_Connected == CONNECT_IS_FALSE)
					g_print ("CONNECT_IS_FALSE\n");
				else if (EnteteCD.Bool_Connected == CONNECT_IS_TRUE)
					g_print ("CONNECT_IS_TRUE\n");
				else if (EnteteCD.Bool_Connected == CONNECT_IS_NO_MATCH_FOUND)
					g_print ("NO MATCH FOUND THIS CD\n");
				else	g_print ("ERREUR: CODE A VERIFIER :(\n");

				g_print ("EnteteCD.Bool_Read_Infos_cd : %s\n", EnteteCD.Bool_Read_Infos_cd ? "TRUE" : "FALSE");
				g_print ("EnteteCD.Message            : %s\n", EnteteCD.Message);
				*/
			}
		}
		var_cd.bool_timeout_read_toc_cd = FALSE;
	} else {
		float val;

		val = gtk_progress_get_value(GTK_PROGRESS(var_cd.Adr_Progressbar));
		val = val >= 100.0 ? 0.0 : val;
		gtk_progress_set_value(GTK_PROGRESS(var_cd.Adr_Progressbar), val + 0.01);
		
		if (cddb_get_bool_cancel_cddb () == TRUE) {
			// PRINT("ARRET");
			conv_stop_conversion ();
		}
	}
	return (TRUE);
}


void cdaudiotoc_button_eject_cd_clicked (void)
{
	if (utils_scan_by_which ("eject", NULL) == FALSE) {
		PRINT_FUNC_LF();
		utils_puts_statusbar_global ("eject NOT FOUND: Please, install package [ eject ]");
		wininfo_create (
			"eject NOT FOUND !",
			"    Please, install package [ eject ]  ",
	 	  	"     \n\n",
		  	"");
		return;
	}	
	cdaudio_clear_all_pixbuf_cd_play ();
	cdaudio_affiche_all_pixbuf_cd_play ();
	mplayer_fifo_quit ();
	cdaudio_deallocate_glist_context ();
	cdaudio_deallocate_glist_cd ();
	cdcue_remove_base_ioctl ();
	gtk_list_store_clear (var_cd.Adr_List_Store);
	cdaudio_set_flag_buttons_audio_cd ();
	
	scancd_eject_media (_CD_);
}

/* Lecture du catalogue du cd-audio
*  --
*  entree : -
*  retour : -
*/
void cdaudiotoc_reffresh_list_cd (void)
{
	pthread_t nmr_tid;
	
	/*PRINT_FUNC_LF();*/

	if (var_cd.Adr_Combo_Box == NULL) return;
	
	if (utils_scan_by_which ("icedax", NULL) == FALSE) {
		PRINT_FUNC_LF();
		utils_puts_statusbar_global (_("icedax NOT FOUND: Please, install package [ icedax ]"));
		wininfo_create (
			_("icedax NOT FOUND !"),
			_("    Please, install package [ icedax ]  "),
	 	  	"     \n\n",
		  	"");
		return;
	}

	Config_User.IntSelectCd = gtk_combo_box_get_active (GTK_COMBO_BOX (var_cd.Adr_Combo_Box));
	
	cdaudio_clear_all_pixbuf_cd_play ();
	cdaudio_affiche_all_pixbuf_cd_play ();
	mplayer_fifo_quit ();

	EnteteCD.NameCD_Device = scancd_get_text_combo_cd (_CD_);

	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Recuperation de la liste des pistes. Veuillez patienter ..."));

	cdaudio_deallocate_glist_context ();
	cdaudio_deallocate_glist_cd ();
	cdcue_remove_base_ioctl ();
	gtk_list_store_clear (var_cd.Adr_List_Store);

	cdaudio_set_flag_buttons_audio_cd ();

	/* recherche CDDB is TRUE */
	cddb_set_bool_cancel_cddb (FALSE);

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_rafraichir_cd")), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (var_cd.Adr_Combo_Box), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (var_cd.Adr_Button_Destination), FALSE);
	
	cdaudio_put_label_status_bar_cd (_DUREE_, _HIDE_, "");
	cdaudio_put_label_status_bar_cd (_TITRE_, _HIDE_, "");

	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("hbox_cache_cd")));

	/* Montre button: CANCEL_CDDB */
	gtk_widget_show (var_cd.Adr_Progressbar);
	gtk_widget_show (GTK_WIDGET (var_cd.Adr_Button_Cancel_cddb));
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame185")), TRUE);
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame185")));
	gtk_widget_set_sensitive (var_cd.Adr_Button_Cancel_cddb, TRUE);
	
	gtk_progress_bar_pulse (GTK_PROGRESS_BAR (var_cd.Adr_Progressbar));
	gtk_progress_set_value(GTK_PROGRESS((GtkWidget*)var_cd.Adr_Progressbar), 0.0);
	gtk_progress_set_activity_mode (GTK_PROGRESS((GtkWidget*)var_cd.Adr_Progressbar), TRUE);

	/* ACTIVATION de l'update qui attends la fin du thread cd audio */
	var_cd.bool_thread_read_toc_cd = TRUE;
	var_cd.bool_timeout_read_toc_cd = TRUE;
	var_cd.handler_timeout_read_toc_cd = gtk_timeout_add (50, cdaudiotoc_timeout_do_read_toc_cd, 0);

	/* ACTIVATION du thread cd audio */
	secu_thread_add ();
	pthread_create (&nmr_tid, NULL ,(void *)cdaudiotoc_thread_do_read_toc_cd, (void *)NULL);
}



