 /*
 * file    : tags_shn.c
 * project : xcfa
 * with    : Gtk-2
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 * 2003,2004,2005,2006,2007,2008,2009 Claude Bulin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include "support.h"

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/



/*
*---------------------------------------------------------------------------
* FILE IS SHN ?
*---------------------------------------------------------------------------
*/

gboolean tagsshn_file_is_shn (gchar *namefile)
{
	FILE      *fp = NULL;
	gchar      str [ 8 ] = {'\0','\0','\0','\0','\0','\0','\0','\0'};
	size_t     lenread = 0;

	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (&str[0], 1, 4, fp);
		fclose (fp);
	}

	if (str [0] == 'a' && str [1] == 'j' && str [2] == 'k' && str [3] == 'g') return (TRUE);

	return (FALSE);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/

INFO_SHN *tagsshn_remove_info (INFO_SHN *info)
{
	if (info) {
		g_free (info->namefile);
		g_free (info->time);
		g_free (info->size);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_SHN *)NULL);
}

INFO_SHN *tagsshn_get_info (gchar *namefile)
{
	INFO_SHN	*ptrinfo = NULL;
	SHNTAG		*ShnTag = get_with_shntool (namefile);

	ptrinfo = (INFO_SHN *)g_malloc0 (sizeof (INFO_SHN));
	if (ptrinfo == NULL) return (NULL);
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);

	ptrinfo->namefile = g_strdup (namefile);
	
	ptrinfo->SecTime  = ShnTag->SecTime;
	ptrinfo->time     = g_strdup (ShnTag->time);
	ptrinfo->size     = g_strdup (ShnTag->size);
	
	ShnTag = get_free_shntool (ShnTag);
	
	return (ptrinfo);
}
