 /*
 * file    : tags_ape.c
 * project : xcfa
 * with    : Gtk-2
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 * 2003,2004,2005,2006,2007,2008,2009 Claude Bulin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include "support.h"

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*****************************************************************************************
APE header that all APE files have in common (old and new)
*****************************************************************************************
struct APE_COMMON_HEADER
{
    char cID[4];                            should equal 'MAC '
    uint16 nVersion;                        version number * 1000 (3.81 = 3810)
};

*****************************************************************************************
APE header structure for old APE files (3.97 and earlier)
*****************************************************************************************
struct APE_HEADER_OLD
{
    char cID[4];                            should equal 'MAC '
    uint16 nVersion;                        version number * 1000 (3.81 = 3810)
    uint16 nCompressionLevel;               the compression level
    uint16 nFormatFlags;                    any format flags (for future use)
    uint16 nChannels;                       the number of channels (1 or 2)
    uint32 nSampleRate;                     the sample rate (typically 44100)
    uint32 nHeaderBytes;                    the bytes after the MAC header that compose the WAV header
    uint32 nTerminatingBytes;               the bytes after that raw data (for extended info)
    uint32 nTotalFrames;                    the number of frames in the file
    uint32 nFinalFrameBlocks;               the number of samples in the final frame
};
*****************************************************************************************/

/*
*---------------------------------------------------------------------------
* FILE IS APE ?
*---------------------------------------------------------------------------
*/

gboolean tagsape_file_is_ape (gchar *namefile)
{
	FILE        *fp = NULL;
	size_t       lenread = 0;
	gchar       *buf = NULL;
	gint         cpt;
	gboolean     bool_signature = FALSE;
	
	/*PRINT_FUNC_LF();*/

	buf = (gchar *)g_malloc0 (sizeof(gchar) * 2048);
	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (buf, 1, 2000, fp);
		fclose (fp);
	}
	
	for (cpt = 0; cpt < 2000; cpt ++) {
		if (buf [ cpt + 0 ] == 0x4d &&	/* 'M' */
		    buf [ cpt + 1 ] == 0x41 &&	/* 'A' */
		    buf [ cpt + 2 ] == 0x43 &&	/* 'C' */
		    buf [ cpt + 3 ] == 0x20) {	/* ' ' */
		    bool_signature = TRUE;
		    break;
		}
	}
	g_free (buf);
	buf = NULL;
	
	return (bool_signature);
}


/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/

INFO_APE *tagsape_remove_info (INFO_APE *info)
{
	if (info) {
		g_free (info->namefile);
		g_free (info->time);
		g_free (info->size);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_APE *)NULL);
}

INFO_APE *tagsape_get_info (gchar *namefile)
{
	INFO_APE	*ptrinfo = NULL;
	SHNTAG		*ShnTag = get_with_shntool (namefile);

	ptrinfo = (INFO_APE *)g_malloc0 (sizeof (INFO_APE));
	if (ptrinfo == NULL) return (NULL);
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);

	ptrinfo->namefile = g_strdup (namefile);
	
	ptrinfo->SecTime  = ShnTag->SecTime;
	ptrinfo->time     = g_strdup (ShnTag->time);
	ptrinfo->size     = g_strdup (ShnTag->size);

	/*
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	tags_set (namefile, ptrinfo->tags);
	*/
	
	ShnTag = get_free_shntool (ShnTag);
	
	return (ptrinfo);
}
