 /*
 * file      : poche_draw.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <string.h>
#include <stdlib.h>

#include "support.h"
#include "global.h"
#include "config_user.h"
#include "poche.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/


#define FOND_BLANC \
	gdk_color.red = 65535; \
	gdk_color.green = 65535; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (poche.Adr_image_preview->window, &gdk_color);

#define FOND_NOIR \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (adr_draw_sosa->window, &gdk_color);

#define FOND_BLEU \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (poche.Adr_image_preview->window, &gdk_color);

#define CRAYON_BLANC \
	gdk_color.red = 65535; \
	gdk_color.green = 65535; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_NOIR \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_BLEU \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_ROUGE \
	gdk_color.red = 65535; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);


/*
typedef enum
{
  GDK_COPY,
  GDK_INVERT,
  GDK_XOR,
  GDK_CLEAR,
  GDK_AND,
  GDK_AND_REVERSE,
  GDK_AND_INVERT,
  GDK_NOOP,
  GDK_OR,
  GDK_EQUIV,
  GDK_OR_REVERSE,
  GDK_COPY_INVERT,
  GDK_OR_INVERT,
  GDK_NAND,
  GDK_NOR,
  GDK_SET
} GdkFunction;

void gdk_gc_set_function (GdkGC *gc, GdkFunction function);
*/


void pochedraw_draw_grille_img (void)
{
	GdkColor      gdk_color;
	GdkColormap  *colormap;
	GdkGC        *gc;
	gint          cptab = 0;

	if (!poche.Adr_image_preview) return;

	colormap = gdk_window_get_colormap (poche.Adr_image_preview->window);
	FOND_BLANC
	gc = gdk_gc_new (poche.Adr_image_preview->window);
	CRAYON_BLEU

	if (poche.bool_file_recto_ps == TRUE) {
		for (cptab = 0; cptab < 4; cptab ++) {
			gdk_draw_line (poche.Adr_image_preview->window,
					gc,
					poche.tab [ cptab ].x1,
					poche.tab [ cptab ].y1,
					poche.tab [ cptab ].x2,
					poche.tab [ cptab ].y2
					);
		}
	}

	if (poche.bool_file_verso_ps == TRUE) {
		for (cptab = 4; cptab < 8; cptab ++) {
			gdk_draw_line (poche.Adr_image_preview->window,
					gc,
					poche.tab [ cptab ].x1,
					poche.tab [ cptab ].y1,
					poche.tab [ cptab ].x2,
					poche.tab [ cptab ].y2
					);
		}
	}
	gdk_gc_destroy (gc);
}

gboolean pochedraw_get_grille_img (void)
{
#define W 612.0
#define H 792.0
	gint          x, y, w, h, x1, x2, y1, y2;
	gdouble       percent = pocheevnt_get_percent_zoom ();
	gint          hauteur;
	gint          largeur;
	gint          diff_hauteur = 0;
	gint          diff_largeur;
	gint          point = 0;
	gint          cptab = 0;

	if (!poche.Adr_image_preview) return (FALSE);

	/*gdk_window_clear (poche.Adr_image_preview->window);*/

	largeur = (percent * 612.0) / 100.0;
	hauteur = (percent * 792.0) / 100.0;
	gtk_widget_set_size_request (poche.Adr_image_preview, largeur +2, hauteur +2);
	w = poche.Adr_image_preview->allocation.width;
	h = poche.Adr_image_preview->allocation.height;

	diff_largeur = x = (w/2)-(largeur/2);
	diff_hauteur = y = (h/2)-(hauteur/2);

	/* recto haut */
	point = (percent * (gdouble)PTR0) / 100.0;
	x1 = x + point;
	x1 --;
	y1 = (percent * (gdouble)(PTR0+PTR2)) / 100.0;
	y1 += diff_largeur;
	x2 = (percent * (gdouble)(792.0-(PTR1+PTR3))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;
	/*gdk_draw_line (poche.Adr_image_preview->window, poche.Adr_image_preview->style->black_gc, x1-7, x2, y1+7, y2);*/

	/* recto bas */
	x2 = (percent * (gdouble)(792.0-(PTR1))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* recto gauche */
	point = (percent * (gdouble)PTR0) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(PTR1+PTR3))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(PTR1))) / 100.0;
	y2 += diff_hauteur;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* largeur minimale */
	point = (percent * (gdouble)(56)) / 100.0;
	poche.largeur_mini = point;

	/* recto droite */
	point = (percent * (gdouble)(PTR0+PTR2)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(PTR1+PTR3))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(PTR1))) / 100.0;
	y2 += diff_hauteur;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* verso haut */
	point = (percent * (gdouble)PTV0) / 100.0;
	x1 = x + point;
	x1 --;
	y1 = (percent * (gdouble)(PTV0+PTV2)) / 100.0;
	y1 += diff_largeur;
	x2 = (percent * (gdouble)(792.0-(PTV1+PTV3))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* verso bas */
	x2 = (percent * (gdouble)(792.0-(PTV1))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* verso gauche */
	point = (percent * (gdouble)PTV0) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(PTV1+PTV3))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(PTV1))) / 100.0;
	y2 += diff_hauteur;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;

	/* verso droite */
	point = (percent * (gdouble)(PTV0+PTV2)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(PTV1+PTV3))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(PTV1))) / 100.0;
	y2 += diff_hauteur;
	poche.tab [ cptab ].x1 = x1;
	poche.tab [ cptab ].y1 = x2;
	poche.tab [ cptab ].x2 = y1;
	poche.tab [ cptab ].y2 = y2;
	cptab ++;
	
	return (TRUE);
}

void pochedraw_draw_grille_base (void)
{
#define W 612.0
#define H 792.0
	GdkColor      gdk_color;
	GdkColormap  *colormap;
	GdkGC        *gc;
	gint          x, y, w, h, x1, x2, y1, y2;
	gdouble       percent = pocheevnt_get_percent_zoom ();
	gint          hauteur;
	gint          largeur;
	gint          diff_hauteur = 0;
	gint          diff_largeur;
	gint          point = 0;
	gint          cptab = 0;

	if (!poche.Adr_image_preview) return;

	if (Config_User.Bool_Config_Ok == FALSE) return;
	if (Config_User.notebook_general != NOTEBOOK_POCHETTE) return;
	
	/*PRINT_FUNC_LF();*/

	/*gdk_window_clear (poche.Adr_image_preview->window);*/
	/*gdk_window_clear_area (poche.Adr_image_preview->window,
				poche.Adr_image_preview->allocation.x,
				poche.Adr_image_preview->allocation.y,
				poche.Adr_image_preview->allocation.width,
				poche.Adr_image_preview->allocation.height
				);*/

	largeur = (percent * 612.0) / 100.0;
	hauteur = (percent * 792.0) / 100.0;
	gtk_widget_set_size_request (poche.Adr_image_preview, largeur +2, hauteur +2);
	w = poche.Adr_image_preview->allocation.width;
	h = poche.Adr_image_preview->allocation.height;

	diff_largeur = x = (w/2)-(largeur/2);
	diff_hauteur = y = (h/2)-(hauteur/2);

	colormap = gdk_window_get_colormap (poche.Adr_image_preview->window);
	FOND_BLANC
	gc = gdk_gc_new (poche.Adr_image_preview->window);
	CRAYON_NOIR

	poche.grille [ cptab ].x1 = x;
	poche.grille [ cptab ].y1 = y;
	poche.grille [ cptab ].x2 = largeur;
	poche.grille [ cptab ].y2 = hauteur;
	cptab ++;
gdk_draw_rectangle (poche.Adr_image_preview->window, gc, FALSE, x, y, largeur, hauteur);

	/* recto haut */
	point = (percent * (gdouble)RECTO_GAUCHE) / 100.0;
	x1 = x + point;
	x1 --;
	y1 = (percent * (gdouble)(RECTO_MAX_LARGEUR)) / 100.0;
	y1 += diff_largeur;
	x2 = (percent * (gdouble)(792.0-(RECTO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1-7, x2, y1+7, y2);

	/* recto bas */
	x2 = (percent * (gdouble)(792.0-(RECTO_BAS))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1-7, x2, y1+7, y2);

	/* recto gauche */
	point = (percent * (gdouble)RECTO_GAUCHE) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(RECTO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(RECTO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-4, y1, y2+7);

	/* recto droite */
	point = (percent * (gdouble)(RECTO_MAX_LARGEUR)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(RECTO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(RECTO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-4, y1, y2+7);

	/* verso haut */
	point = (percent * (gdouble)VERSO_GAUCHE) / 100.0;
	x1 = x + point;
	x1 --;
	y1 = (percent * (gdouble)(VERSO_MAX_LARGEUR)) / 100.0;
	y1 += diff_largeur;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1-7, x2, y1+7, y2);

	/* verso bas */
	x2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	x2 += diff_hauteur;
	y2 = x2;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1-7, x2, y1+7, y2);

	/* verso gauche */
	point = (percent * (gdouble)VERSO_GAUCHE) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-7, y1, y2+7);

	/* verso gauche + 1 */
	point = (percent * (gdouble)RECTO_GAUCHE) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-7, y1, y2+7);

	/* verso gauche + 2 */
	point = (percent * (88.0 + 391.0)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-7, y1, y2+7);

	/* verso gauche + 3 */
	point = (percent * (88.0 + 408.0)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-7, y1, y2+7);

	/* verso droite */
	point = (percent * (gdouble)(VERSO_MAX_LARGEUR)) / 100.0;
	x1 = x + point;
	x1 --;
	x2 = (percent * (gdouble)(792.0-(VERSO_MAX_HAUTEUR))) / 100.0;
	x2 += diff_hauteur;
	y1 = x1;
	y2 = (percent * (gdouble)(792.0-(VERSO_BAS))) / 100.0;
	y2 += diff_hauteur;
	poche.grille [ cptab ].x1 = x1;
	poche.grille [ cptab ].y1 = x2;
	poche.grille [ cptab ].x2 = y1;
	poche.grille [ cptab ].y2 = y2;
	cptab ++;
gdk_draw_line (poche.Adr_image_preview->window, gc, x1, x2-7, y1, y2+7);

	gdk_gc_destroy (gc);
}


void pochedraw_redraw_image (void)
{
	/*GdkRectangle update_rect;*/
	
	if (poche.Adr_image_preview == NULL) return;
	/*
	g_print ("poche.Adr_image_preview->allocation.x      = %d\n", poche.Adr_image_preview->allocation.x);
	g_print ("poche.Adr_image_preview->allocation.y      = %d\n", poche.Adr_image_preview->allocation.y);
	g_print ("poche.Adr_image_preview->allocation.width  = %d\n", poche.Adr_image_preview->allocation.width);
	g_print ("poche.Adr_image_preview->allocation.height = %d\n", poche.Adr_image_preview->allocation.height);

	update_rect.x      = poche.Adr_image_preview->allocation.x;
	update_rect.y      = poche.Adr_image_preview->allocation.y;
	update_rect.width  = poche.Adr_image_preview->allocation.width;
	update_rect.height = poche.Adr_image_preview->allocation.height;

	gdk_draw_rectangle (
			poche.Adr_image_preview->window,
  			poche.Adr_image_preview->style->white_gc,
   			FALSE,
			update_rect.x,
			update_rect.y,
			update_rect.width,
			update_rect.height
			);
	gtk_widget_draw (poche.Adr_image_preview, &update_rect);
	*/
	gtk_widget_queue_draw_area (
				poche.Adr_image_preview,
				poche.Adr_image_preview->allocation.x,
				poche.Adr_image_preview->allocation.y,
				poche.Adr_image_preview->allocation.width,
				poche.Adr_image_preview->allocation.height
				);
	
}






