 /*
 * file      : player.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"
#include "support.h"
#include "global.h"
#include "file.h"
#include "cd_audio.h"
#include "dvd_audio.h"
#include "secu.h"
#include "get.h"
#include "win_control.h"
#include "options.h"
#include "utils.h"
#include "win_play.h"
#include "player.h"




/*
*---------------------------------------------------------------------------
* EXTERNAL REF
*---------------------------------------------------------------------------
*/
extern int kill(pid_t pid, int sig);


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
VAR_PLAYER VarPlayer;



/*
*---------------------------------------------------------------------------
* GESTION FENETRE MUSIQUE
*---------------------------------------------------------------------------
*/

/* PLAYER ONGLET FICHIER
*/
void Player_set_value_time (gdouble value)
{
	// gchar   *Mess = NULL;
	gint     sec   = 0;

	if (value < 0.0)   value = 0.0;
	if (value > 100.0) value = 100.0;
	
	sec = (gint) ((VarPlayer.DOUBLE_TempsTotal * value) / 100.0);
	
	if (sec < 0) sec = 0;
	
	// Mess = g_strdup_printf ("<b> %02d:%02d:%02d </b>", (sec/60)/60, (sec/60)%60, sec%60);
/*g_print("%s\n", Mess);*/
	
	
	if (VarLecture.AdrAdjustAllFile) {
		gtk_adjustment_set_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile), value);
	}
	
	// g_free (Mess);
	// Mess = NULL;

}
gboolean Player_change_value_time (GtkRange *range, GtkScrollType scroll, gdouble value, gpointer user_data)
{
	if (VarPlayer.Button == GDK_BUTTON_RELEASE) {
		PlayerExec_fifo_seek_with_hundr (value);
		VarPlayer.PercentTempsActuel = value;
		VarPlayer.Button = -1;
	}
	Player_set_value_time (value);
	return FALSE;
}
gboolean Player_event_music (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	if (event->type == GDK_BUTTON_PRESS) {
		VarPlayer.Button = GDK_BUTTON_PRESS;
	}
	if (event->type == GDK_BUTTON_RELEASE) {
		VarPlayer.Button = GDK_BUTTON_RELEASE;
	}
	
	return (FALSE);
}

/* PLAYER ONGLET DVD
*/
void Player_button_stop_music_clicked (GtkButton *button)
{
	PlayerExec_user_to_quit ();
}



















