 /*
 * file      : options.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"
#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "conv.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"
#include "file.h"
#include "fileselect.h"
#include "win_info.h"
#include "prg_init.h"


/*
*---------------------------------------------------------------------------
* VARIABLE
*---------------------------------------------------------------------------
*/

VAR_OPTIONS var_options;


/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/

/* retour
 *	EXTRACT_WITH_CDPARANOIA
 *	EXTRACT_WITH_CDPARANOIA_EXPERT
 *	EXTRACT_WITH_CDDA2WAV
 */
EXTRACT_WITH options_extract_by (void)
{
	EXTRACT_WITH	ExtractWith = EXTRACT_WITH_CDPARANOIA;
	
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia)) == TRUE)
		ExtractWith = EXTRACT_WITH_CDPARANOIA;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert)) == TRUE)
		ExtractWith = EXTRACT_WITH_CDPARANOIA_EXPERT;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav)) == TRUE)
		ExtractWith = EXTRACT_WITH_CDDA2WAV;
	
	return ((EXTRACT_WITH)ExtractWith);
}
gchar *options_extract_by_name (void)
{
	static gchar OptionName [ 50 ];
	
	OptionName [ 0 ] = '\0';
	
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia)) == TRUE) {
		strcpy (OptionName, _("[Extraction cdparanoia]"));
	}
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav)) == TRUE) {
		strcpy (OptionName, _("[Extraction "));
		// strcat (OptionName, PrgInit.name_cdda2wav_icedax);
		strcat (OptionName, prginit_get_name (NMR_icedax));
		strcat (OptionName, " ]");
	}
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert)) == TRUE) {
		strcpy (OptionName, _("[Extraction cdparanoia expert]"));
	}
	
	return (&OptionName[0]);
}


/* Construction des options internes
*/
void options_set_datas_interne (COLOR_LINE_COMMAND ColorLineCommand, GtkWidget *widget, TYPE_CONV type_conv)
{
	GString     *gstr = NULL;

	if (!widget) return;
	if (!var_options.Adr_Widget_Oggenc_bitrate) return;
	if (!var_options.Adr_Widget_Lame_Mode) return;
	if (!var_options.Adr_Widget_Lame_abr_cbr_vbr) return;
	if (!var_options.Adr_Widget_Lame_bitrate) return;
	
	gtk_label_set_markup (GTK_LABEL (widget), "");

	if (var_options.ColorLineCommand != COLOR_INIT) {
		var_options.ColorLineCommand = ColorLineCommand;
	}

	if ((gstr = filelc_get_options_for_visual (type_conv))) {

		gchar *str = g_strdup_printf ("<b>%s</b>", gstr->str);
		gtk_label_set_use_markup (GTK_LABEL (widget), TRUE);
		gtk_label_set_justify (GTK_LABEL (widget), GTK_JUSTIFY_LEFT);
		gtk_label_set_markup (GTK_LABEL (widget), str);
		gtk_widget_show (widget);

		g_string_free (gstr, TRUE);
		g_free (str);
		str = NULL;
	}
	
	var_options.ColorLineCommand = COLOR_NONE;
}

/* Construction du combobox 'Nice'
*  --
*  entree :
*      GtkWidget *widget : Adresse du combobox
*  retour : -
*/
void options_make_combobox_nice (GtkWidget *widget)
{
	gint   i;
	gchar *Ptr = NULL;

	/* PRINT_FUNC_LF(); */
	utils_clear_elements_combobox (widget);
	for (i = 0; i < 20; i++) {
		Ptr = g_strdup_printf ("%d", i);
		gtk_combo_box_append_text (GTK_COMBO_BOX (widget), Ptr);
		g_free (Ptr);
		Ptr = NULL;

	}
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.Nice);
	var_options.Adr_Widget_Nice = GTK_COMBO_BOX (widget);
}

/*
*---------------------------------------------------------------------------
* ONGLET OPTIONS -> ACTION
*---------------------------------------------------------------------------
*/

/* Recupere et renvoie le numero actif dans le combobox 'Nice'
*  --
*  entree : -
*  retour :
*      gint : Numero du combobox actif
*/
gint options_get_val_nice (void)
{
	/* PRINT_FUNC_LF(); */
	if (var_options.Adr_Widget_Nice != NULL) {
		return (gtk_combo_box_get_active (var_options.Adr_Widget_Nice));
	}
	return 0;
}

gboolean options_get_readdir_cdaudio_by_ioctl (void)
{
	Config_User.Bool_directory_by_ioctl =
		gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_ioctl));

	return (Config_User.Bool_directory_by_ioctl ? TRUE : FALSE);
}

void options_set_all_interne (void)
{
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_lame_mp3, LAME_WAV_TO_MP3);
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_oggenc_ogg, OGGENC_WAV_TO_OGG);	
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_flac_flac, FLAC_WAV_TO_FLAC);
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_mac_ape, MAC_WAV_TO_APE);
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_musepack_mpc, MPPENC_WAV_TO_MPC);
	options_set_datas_interne (COLOR_NONE, var_options.Adr_label_faac_m4a, FAAC_WAV_TO_M4A);
}

gboolean options_bool_add_line_command (TYPE_CONV p_type_conv, gchar **entry)
{
	GtkWidget *wd = NULL;
	
	switch (p_type_conv) {
	
	case FLAC_WAV_TO_FLAC :		wd = var_options.Adr_entry_flac_flac;		break;
	case LAME_WAV_TO_MP3 :		wd = var_options.Adr_entry_lame_mp3;		break;
	case OGGENC_WAV_TO_OGG :	wd = var_options.Adr_entry_oggenc_ogg;		break;
	case FAAC_WAV_TO_M4A :		wd = var_options.Adr_entry_faac_m4a;		break;
	case MPPENC_WAV_TO_MPC :	wd = var_options.Adr_entry_musepack_mpc;	break;
	case MAC_WAV_TO_APE :		wd = var_options.Adr_entry_mac_ape;		break;
	case WAVPACK_WAV_TO_WAVPACK :	wd = var_options.Adr_entry_wavpack_wv;		break;
	
	case CDPARANOIA_CD_TO_WAV_EXPERT :
	case CDPARANOIA_CD_TO_WAV :
	case CDDA2WAV_CD_TO_WAV :	return (FALSE);
	
	default :			return (FALSE);
	}
	if (wd == NULL) return (FALSE);
	
	*entry = (gchar *)gtk_entry_get_text (GTK_ENTRY(wd));

	return ((entry != NULL && **entry != '\0' && **entry != ' ') ? TRUE : FALSE);
}

gboolean options_get_entry_is_valid (TYPE_CONV p_verif_conv)
{
	gchar     *ptr = NULL;
	GtkWidget *wd = NULL;
	
	switch (p_verif_conv) {
	
	case FLAC_WAV_TO_FLAC :		wd = var_options.Adr_entry_flac_flac;		break;
	case LAME_WAV_TO_MP3 :		wd = var_options.Adr_entry_lame_mp3;		break;
	case OGGENC_WAV_TO_OGG :	wd = var_options.Adr_entry_oggenc_ogg;		break;
	case FAAC_WAV_TO_M4A :		wd = var_options.Adr_entry_faac_m4a;		break;
	case MPPENC_WAV_TO_MPC :	wd = var_options.Adr_entry_musepack_mpc;	break;
	case MAC_WAV_TO_APE :		wd = var_options.Adr_entry_mac_ape;		break;
	case WAVPACK_WAV_TO_WAVPACK :	wd = var_options.Adr_entry_wavpack_wv;		break;
	case CDPARANOIA_CD_TO_WAV_EXPERT :
	case CDPARANOIA_CD_TO_WAV :
	case CDDA2WAV_CD_TO_WAV :
		return(gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert)));
	default :
		return (FALSE);
	}
	if (wd == NULL) return (FALSE);
	ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY(wd));
	return ((ptr && *ptr != '\0' && *ptr != ' ') ? TRUE : FALSE);
}

void options_entry_op_internal_changed (GtkEditable *editable)
{
	if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_flac_flac)) {
		g_free (Config_User.String_expander_Flac);
		Config_User.String_expander_Flac = NULL;
		Config_User.String_expander_Flac = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_lame_mp3)) {
		g_free (Config_User.String_expander_Lame);
		Config_User.String_expander_Lame = NULL;
		Config_User.String_expander_Lame = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_oggenc_ogg)) {
		g_free (Config_User.String_expander_Oggenc);
		Config_User.String_expander_Oggenc = NULL;
		Config_User.String_expander_Oggenc = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_faac_m4a)) {
		g_free (Config_User.String_expander_Faac);
		Config_User.String_expander_Faac = NULL;
		Config_User.String_expander_Faac = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_musepack_mpc)) {
		g_free (Config_User.String_expander_Mppenc);
		Config_User.String_expander_Mppenc = NULL;
		Config_User.String_expander_Mppenc = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_mac_ape)) {
		g_free (Config_User.String_expander_Mac);
		Config_User.String_expander_Mac = NULL;
		Config_User.String_expander_Mac = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	} else if (GTK_EDITABLE (editable) == GTK_EDITABLE (var_options.Adr_entry_wavpack_wv)) {
		g_free (Config_User.String_expander_Wavpack);
		Config_User.String_expander_Wavpack = NULL;
		Config_User.String_expander_Wavpack = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY(editable)));
	}
}

void options_init (void)
{
	if (Config_User.String_expander_Lame)       gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_lame_mp3), Config_User.String_expander_Lame);
	if (Config_User.String_expander_Oggenc)     gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_oggenc_ogg), Config_User.String_expander_Oggenc);
	if (Config_User.String_expander_Flac)       gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_flac_flac), Config_User.String_expander_Flac);
	if (Config_User.String_expander_Faac)       gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_faac_m4a), Config_User.String_expander_Faac);
	if (Config_User.String_expander_Mppenc)     gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_musepack_mpc), Config_User.String_expander_Mppenc);
	if (Config_User.String_expander_Mac)        gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_mac_ape), Config_User.String_expander_Mac);
	if (Config_User.String_expander_Wavpack)    gtk_entry_set_text (GTK_ENTRY(var_options.Adr_entry_wavpack_wv), Config_User.String_expander_Wavpack);
}


/* La gestion de l'installation des paquets sera faite sur systeme DEBIAN par:
*     0 = apt-get
*     1 = aptitude
*/
void options_set_administrator_of_packets (void)
{
	/*
	frame_choix_install_debian
	radiobutton_install_aptget
	radiobutton_install_aptitude
	*/
	if (Config_User.AdministratorOfPackets == 0)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "radiobutton_install_aptget"))), TRUE);
	else
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "radiobutton_install_aptitude"))), TRUE);
	
	if (var_options.Type_Package != _DEBIAN_)
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "frame_choix_install_debian")), FALSE);
}
gint options_get_administrator_of_packets (void)
{
	Config_User.AdministratorOfPackets = 0;
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "radiobutton_install_aptitude")))))
		Config_User.AdministratorOfPackets = 1;
	return (Config_User.AdministratorOfPackets);
}

/*
*---------------------------------------------------------------------------
* Dossier temporaire
*---------------------------------------------------------------------------
*/
	/*
	#define PATH_TMP_XCFA_AUDIOCD "xcfa_cdaudio"
	#define PATH_TMP_XCFA_AUDIOFILE "xcfa_audiofile"
	#define PATH_TMP_XCFA_AUDIOFILEWAVCONV "xcfa_audiofilewavconv"
	#define PATH_TMP_XCFA_AUDIOFILEMP3OGG "xcfa_audiofilemp3ogg"
	#define PATH_TMP_XCFA_AUDIOFILENORMALYSE "xcfa_audiofilenormalyse"
	#define PATH_TMP_XCFA_CDDBTEST "xcfa_cddbtest"
	#define PATH_DOWNLOAD_TO_XCFA	"/tmp/download_to_xcfa"
	#define PATH_SAVE_POCHETTE_IMG "XcfaPochette"
	#define PATH_SAVE_POCHETTE_PS  "XcfaPochette/PostScript"
	#define PATH_SAVE_POCHETTE_PNG "XcfaPochette/png"
	*/
	
gboolean options_verif_dossier_is_ok (gchar *path)
{
	gint i;
	gchar *tmp [] = {
		PATH_TMP_XCFA_AUDIOCD,
		PATH_TMP_XCFA_AUDIOFILE,
		PATH_TMP_XCFA_AUDIOFILEWAVCONV,
		PATH_TMP_XCFA_AUDIOFILEMP3OGG,
		PATH_TMP_XCFA_AUDIOFILENORMALYSE,
		PATH_TMP_XCFA_CDDBTEST,
		"download_to_xcfa",
		PATH_SAVE_POCHETTE_IMG,
		PATH_SAVE_POCHETTE_PS,
		PATH_SAVE_POCHETTE_PNG
	};
	
	for (i = 0; i < 10; i++) {
		if (strstr (path, tmp [ i ]) != NULL) {
			wininfo_create (
				_("ERREUR: Lieu de stockage non autorise !     "),
				_("   Ce lieu de stockage est utilise par Xcfa   "),
				  "\n\n",
				_("   Veuillez recommencer."),
				  "\n",
				  "");
				  
			return (FALSE);
		}
	}

	return (TRUE);
}

void options_button_dossier_de_conversion_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	/*g_print ("Config_User.Path_TMP = %s\n\n", Config_User.Path_TMP);*/
	var_options.Adr_path_temp = widget;
	gtk_button_set_label (GTK_BUTTON (widget), Config_User.Path_TMP);
}
void options_path_tmp (gchar *path)
{
	if (utils_test_write (path) == TRUE) {
	
	g_print ("MV FROM %s/%s TO %s/%s\n", Config_User.Path_TMP, PATH_SAVE_POCHETTE_IMG, path, PATH_SAVE_POCHETTE_IMG);
	/*
	mv -f Config_User.Path_TMP / PATH_SAVE_POCHETTE_IMG       path / PATH_SAVE_POCHETTE_IMG
	*/
		g_free (Config_User.Path_TMP);
		Config_User.Path_TMP = NULL;
		Config_User.Path_TMP = g_strdup (path);
		gtk_button_set_label (GTK_BUTTON (var_options.Adr_path_temp), Config_User.Path_TMP);
	}
}
void options_button_dossier_de_conversion_clicked (void)
{
	/*PRINT_FUNC_LF();*/
	fileselect_create (_PATH_TEMP_, options_path_tmp);
}

void options_default_values (GtkButton *button)
{
	/*
	PRINT_FUNC_LF();
	*/
	if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_lame"))){
		/* Set ABR/CBR/VBR/VBR-NEW qui passe le debit par defaut */
		Config_User.RateMp3OggOptions.Bitrate_type_Lame = ConfigUserSave.RateMp3OggOptions.Bitrate_type_Lame;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_abr_cbr_vbr), Config_User.RateMp3OggOptions.Bitrate_type_Lame);
		
		switch (Config_User.RateMp3OggOptions.Bitrate_type_Lame) {
		case 0 :
			Config_User.RateMp3OggOptions.If_abr = ConfigUserSave.RateMp3OggOptions.If_abr;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_abr);
			break;
		case 1 :
			Config_User.RateMp3OggOptions.If_cbr = ConfigUserSave.RateMp3OggOptions.If_cbr;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_cbr);
			break;
		case 2 :
			Config_User.RateMp3OggOptions.If_vbr = ConfigUserSave.RateMp3OggOptions.If_vbr;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_vbr);
			break;
		case 3 :
			Config_User.RateMp3OggOptions.If_vbr_new = ConfigUserSave.RateMp3OggOptions.If_vbr_new;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_vbr_new);
			break;
		default :
			break;
		}
		/* Set mode */
		Config_User.RateMp3OggOptions.Mode_Lame = ConfigUserSave.RateMp3OggOptions.Mode_Lame;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_Mode), Config_User.RateMp3OggOptions.Mode_Lame);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_oggenc"))){
		/* Debit */
		Config_User.RateMp3OggOptions.Bitrate_Oggenc = ConfigUserSave.RateMp3OggOptions.Bitrate_Oggenc;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Oggenc_bitrate), Config_User.RateMp3OggOptions.Bitrate_Oggenc);
		/* Mode flux: Streaming */
		Config_User.RateMp3OggOptions.Managed_Oggenc = ConfigUserSave.RateMp3OggOptions.Managed_Oggenc;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Oggenc_managed), Config_User.RateMp3OggOptions.Managed_Oggenc);
		/* Mode */
		Config_User.RateMp3OggOptions.Downmix_Oggenc = ConfigUserSave.RateMp3OggOptions.Downmix_Oggenc;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Oggenc_downmix), Config_User.RateMp3OggOptions.Downmix_Oggenc);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_flac"))){
		/* Taux de compression */
		Config_User.compression_level_flac = ConfigUserSave.compression_level_flac;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_flac_compression), Config_User.compression_level_flac);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_mac"))){
		/* Qualite */
		Config_User.compression_level_ape = ConfigUserSave.compression_level_ape;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_ape_compression), Config_User.compression_level_ape);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_wavpack"))){
		/* Compression */
		Config_User.compression_wavpack = ConfigUserSave.compression_wavpack;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack), Config_User.compression_wavpack);
		/* sound */
		Config_User.sound_wavpack = ConfigUserSave.sound_wavpack;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_sound), Config_User.sound_wavpack);
		/* Hybride */
		Config_User.wavpack_mode_hybride = ConfigUserSave.wavpack_mode_hybride;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_mode_hybride), Config_User.wavpack_mode_hybride);
		/* Fichier de correction */
		Config_User.wavpack_correction_file = ConfigUserSave.wavpack_correction_file;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_correction_file), Config_User.wavpack_correction_file);
		/* Compression maximum */
		Config_User.wavpack_maximum_compression = ConfigUserSave.wavpack_maximum_compression;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_maximum_compression), Config_User.wavpack_maximum_compression);
		/* Signature md5 */
		Config_User.wavpack_signature_md5 = ConfigUserSave.wavpack_signature_md5;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_signature_md5), Config_User.wavpack_signature_md5);
		/* Extra encoding */
		Config_User.wavpack_extra_encoding = ConfigUserSave.wavpack_extra_encoding;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_wavpack_extra_encoding), Config_User.wavpack_extra_encoding);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_musepack"))){
		/* Extra encoding */
		Config_User.quality_mppenc = ConfigUserSave.quality_mppenc;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Mppenc), Config_User.quality_mppenc);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_faac"))){
		Config_User.faac_conteneur      = ConfigUserSave.faac_conteneur;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_faac_conteneur), Config_User.faac_conteneur);
		
		Config_User.faac_choice_vbr_abr = ConfigUserSave.faac_choice_vbr_abr;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_faac_choice_vbr_abr), Config_User.faac_choice_vbr_abr);
		
		Config_User.faac_set_choice_vbr = ConfigUserSave.faac_set_choice_vbr;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), Config_User.faac_set_choice_vbr);
	}
	else if (button == GTK_BUTTON (lookup_widget (wind_main, "button_defaut_aacplusenc"))){
		Config_User.aacplusenc_choice_mono = ConfigUserSave.aacplusenc_choice_mono;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_aacplusenc_mono), Config_User.aacplusenc_choice_mono);
		Config_User.aacplusenc_choice_stereo = ConfigUserSave.aacplusenc_choice_stereo;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_aacplusenc_stereo), Config_User.aacplusenc_choice_stereo);
	}
	
	
}


