 /*
 * file      : file_trash.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include "support.h"

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#include "global.h"
#include "utils.h"
#include "config_user.h"
#include "dragNdrop.h"
#include "info_song.h"
#include "file.h"
#include "options.h"
#include "fileselect.h"
#include "logs.h"
#include "popup.h"
#include "level.h"
#include "win_norm_replay.h"
#include "win_control.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {

	gboolean         BoolTrashIsOk;
	gboolean         Bool_kde_full_session;
	
	pthread_t        nmr_tid;
	guint            handler_timeout;
	gboolean         bool_thread_end;
	double           total_percent;
	
	gint             nbr_trash;
	gint             ElementActif;
	
	gboolean         BoolEtat;
	gboolean         bool_pass_conv;
	gint             pass_conv;
	
	gboolean         bool_set_end_of_user;
	
	gchar            PathNameTrash [ 256 ];
	
} VAR_FILE_TRASH;

VAR_FILE_TRASH var_filetrash = { FALSE, FALSE };



/*
mv ./11\ Track_11.wav /home/cat/.Trash/11\ Track_11.wav

Sous Ubuntu
	$HOME/.Trash
Kubuntu et Xubuntu
	$HOME/.local/share/Trash/files

*/
gboolean filetrash_test_desktop_is_kde (void)
{
	FILE       *fp;
#define MAX_CARS_KDE 255
	gchar       buf   [ MAX_CARS_KDE +1 ];
	gboolean    BoolRet = FALSE;
	
	/*
	KDE_FULL_SESSION
	*/
	system ("env | grep \"KDE_FULL_SESSION\" > /tmp/tst_kde_full_session.txt");
	if ((fp = fopen ("/tmp/tst_kde_full_session.txt", "r")) != NULL) {
		while (fgets (buf, MAX_CARS_KDE, fp) != NULL) {
			if (strcmp (buf, "KDE_FULL_SESSION") == 0) {
				if (strcmp (buf, "true") == 0 || strcmp (buf, "TRUE") == 0) {
					BoolRet = TRUE;
					break;
				}
			}
		}
		fclose (fp);
	}
	infosong_delete_file ("/tmp/tst_kde_full_session.txt");
	return (BoolRet);	
}



/*  #include <gio/gio.h>
 *  
 *  gboolean g_file_trash (GFile *file, GCancellable *cancellable, GError **error);
 *  
 *  
 *  
void filetrash_test (gchar *Name)
{
	GError *error;
	g_file_trash ((GFile *)Name, NULL, &error);
}
 *  
 *  
 */
 


gboolean filetrash_move_to_trash (gchar *Name)
{
	gchar     *NameDest = NULL;
	gchar     *Ptr = NULL;
	gchar     *LineCommand = NULL;
	
	/*PRINT_FUNC_LF();*/
	
	if ((Ptr = strrchr (Name, '/')))
		Ptr ++;
	else	Ptr = Name;
	
	NameDest = g_strdup_printf ("%s/%s", filetrash_get_trash (), Ptr);
	
	LineCommand = g_strdup_printf ("mv -f \"%s\" \"%s\"", Name, NameDest);
	g_print ("To Trash:\n\t%s\n", LineCommand);
	system (LineCommand);
	
	g_free (LineCommand);
	LineCommand = NULL;
	
	g_free (NameDest);
	NameDest = NULL;
	
	return (TRUE);
}

gchar *filetrash_get_trash (void)
{
	if (var_filetrash.Bool_kde_full_session == TRUE)
		g_sprintf (var_filetrash.PathNameTrash, "%s/.local/share/Trash/files", getenv ("HOME"));
	else	g_sprintf (var_filetrash.PathNameTrash, "%s/.Trash", getenv ("HOME"));

	return ((gchar *)var_filetrash.PathNameTrash);
}

void filetrash_test_trash_is_ok (void)
{
	gboolean      BoolExistTrashOLD;
	gboolean      BoolExistTrashNEW;
	gchar        *Path = NULL;
	gchar        *StrTrash = NULL;
	
	g_print ("\n[ Trash ]\n");
	
	if (var_filetrash.BoolTrashIsOk == TRUE) return;
	var_filetrash.BoolTrashIsOk = TRUE;
	var_filetrash.Bool_kde_full_session = filetrash_test_desktop_is_kde ();
	
	g_print ("KDE SESSION : %s\n", var_filetrash.Bool_kde_full_session ? "TRUE" : "FALSE");

	Path = g_strdup_printf ("%s/.Trash", getenv ("HOME"));
	BoolExistTrashOLD = infosong_file_is_dir (Path);
	if (BoolExistTrashOLD == TRUE)
		g_print ("EXIST ......: %s\n", Path);
	else	g_print ("NOT EXIST ..: %s\n", Path);
	g_free (Path);
	Path = NULL;
	
	Path = g_strdup_printf ("%s/.local/share/Trash/files", getenv ("HOME"));
	BoolExistTrashNEW = infosong_file_is_dir (Path);
	if (BoolExistTrashNEW == TRUE)
		g_print ("EXIST ......: %s\n", Path);
	else	g_print ("NOT EXIST ..: %s\n", Path);
	g_free (Path);
	Path = NULL;
	
	// SI SESSION KDE
	if (var_filetrash.Bool_kde_full_session == TRUE) {
		if (BoolExistTrashNEW == FALSE) {
			StrTrash = g_strdup_printf ("mkdir -p %s", filetrash_get_trash ());
			system (StrTrash);
			g_free (StrTrash);
			StrTrash = NULL;
			BoolExistTrashNEW = TRUE;
		}
	}
	// SI PAS SESSION KDE
	else {
		if (BoolExistTrashNEW == TRUE) {
			var_filetrash.Bool_kde_full_session = TRUE;
		}
		else if (BoolExistTrashOLD == FALSE) {
			var_filetrash.Bool_kde_full_session = TRUE;
			StrTrash = g_strdup_printf ("mkdir -p %s", filetrash_get_trash ());
			system (StrTrash);
			g_free (StrTrash);
			StrTrash = NULL;
			BoolExistTrashNEW = TRUE;
		}
		else {
			
		}
	
	}
	
	g_print ("---\nUSE ........: %s\n---\n\n", filetrash_get_trash ());
}

static void filetrash_thread (void *arg)
{
	GList     *list = NULL;
	DETAIL    *detail = NULL;
	FIC       *fic = NULL;

	var_filetrash.bool_thread_end = FALSE;
	var_filetrash.bool_pass_conv = TRUE;
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
				if (fic->EtatTrash == FILE_TRASH_VERIF_OK) {

					var_filetrash.ElementActif ++;
					var_filetrash.BoolEtat = TRUE;

					if (filetrash_move_to_trash (detail->namefile) == TRUE) {
						detail->remove = STRUCT_FIC_REMOVE;
					}
				}
				
			}
		}
		list = g_list_next (list);
	}
	var_filetrash.bool_pass_conv = FALSE;
	var_filetrash.bool_thread_end = TRUE;
	
	pthread_exit(0);
}

static gint filetrash_timeout (gpointer data)
{
	if (WinNormReplay_is_get_close () == TRUE) {
		var_filetrash.bool_thread_end = TRUE;
	}
	
	if (var_filetrash.bool_pass_conv == TRUE) {

		gchar *str = NULL;
    		gchar *spinner="|/-\\";
		
		str = g_strdup_printf ("<b>En cours: %d / %d   %c</b>",
					var_filetrash.ElementActif,
					var_filetrash.nbr_trash,
					spinner[var_filetrash.pass_conv++%4]
					);
		WinNormReplay_set_compteur (str);
		g_free (str);
		str = NULL;
	}
	
	if (var_filetrash.BoolEtat == TRUE) {
		
		var_filetrash.total_percent = (double)((double)var_filetrash.ElementActif / (double)var_filetrash.nbr_trash);
		WinNormReplay_set_data_progressBar (var_filetrash.total_percent);
		
		var_filetrash.BoolEtat = FALSE;
		return (TRUE);
	}
	
	if (var_filetrash.bool_thread_end == TRUE) {
		WinNormReplay_close ();
		fileaction_set_end ();
		gtk_timeout_remove (var_filetrash.handler_timeout);
		fileanalyze_modify_glist_entetefile ();
	}
	return (TRUE);
}

void filetrash_action (void)
{
	/*PRINT_FUNC_LF();*/
	
	var_filetrash.bool_thread_end = FALSE;
	var_filetrash.ElementActif     = 0;
	var_filetrash.BoolEtat        = FALSE;
	var_filetrash.bool_pass_conv   = FALSE;
	
	WinNormReplay_Create (_("Trash"));
	WinNormReplay_reset_progressBar ();
		
	pthread_create (&var_filetrash.nmr_tid, NULL ,(void *)filetrash_thread, (void *)NULL);
	var_filetrash.handler_timeout = gtk_timeout_add (100, filetrash_timeout, 0);
}

gboolean filetrash_ok (void)
{
	GList     *list = NULL;
	DETAIL    *detail = NULL;
	FIC       *fic = NULL;
	gboolean   BoolTrash = FALSE;
		
	var_filetrash.nbr_trash = 0;
	
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
			
				if (fic->EtatTrash != FILE_TRASH_NONE) {
					BoolTrash = TRUE;
					var_filetrash.nbr_trash ++;
				}
			}
		}
		list = g_list_next (list);
	}
	return (BoolTrash);
}







