 /*
 * file      : callbacks.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "config_user.h"
#include "fileselect.h"
#include "global.h"
#include "file.h"
#include "options.h"
#include "dragNdrop.h"
#include "cd_audio.h"
#include "scan_cd.h"
#include "about_xcfa.h"
#include "web.h"
#include "logs.h"
#include "win_control.h"
#include "poche.h"
#include "utils.h"
#include "dvd_audio.h"
#include "split.h"
#include "help.h"
#include "showhide_treeview.h"
#include "player.h"
#include "win_play.h"
#include "cd_cue.h"
#include "win_choice.h"
#include "prg_navigator.h"
#include "prg_postscript.h"
#include "prg_init.h"
#include "prg_install.h"
#include "prg_audio.h"
#include "split_shuttle.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

KEYS keys = {
	GDK_NOTHING,	/* eventkey		*/
	0,		/* type			*/
	0,		/* state		*/
	0,		/* keyval		*/
	0,		/* hardware_keycode	*/
	"",		/* str			*/
	FALSE,		/* BoolGDK_KP_Add	*/
	FALSE,		/* BoolGDK_KP_Subtract	*/
	FALSE,		/* BoolGDK_plus		*/
	FALSE,		/* BoolGDK_minus	*/
	FALSE,		/* BoolGDK_Control_L	*/
	FALSE,		/* BoolGDK_Control_R	*/
	FALSE,		/* BoolGDK_Shift_L	*/
	FALSE,		/* BoolGDK_Shift_R	*/
	FALSE,		/* BoolGDK_Left		*/
	FALSE,		/* BoolGDK_Right	*/
	FALSE		/* BoolGDK_Control_A	*/
};


/*
*---------------------------------------------------------------------------
* WIND MAIN QUIT
*---------------------------------------------------------------------------
*/

/* Cette fonction est appellee avant la fin du processus et effectue une
*  sauvegarde des principaux parametres qui seront recupperes lors de la
*  prochaine session.
*/
void Before_End_Prg (void)
{
	g_print ("--------------------------------------------------\n");
	PRINT_FUNC_LF();
	g_print ("--------------------------------------------------\n");

	g_print ("player_remove_fifo ()\n");
	PlayerExec_user_to_quit ();
	PlayerExec_remove_fifo ();

	g_print ("Recuperation position et taille de la fenetre\n");
	gdk_window_get_root_origin (wind_main->window, &Config_User.WinPos_X, &Config_User.WinPos_Y);
	gdk_window_get_size (wind_main->window, &Config_User.Win_Width, &Config_User.Win_Height);

	g_print ("Recuperation value NICE\n");
	Config_User.Nice = options_get_val_nice ();

	g_print ("Recuperation values LAME et OGGENC\n");
	Config_User.RateMp3OggOptions.Bitrate_type_Lame  = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_abr_cbr_vbr);
	Config_User.RateMp3OggOptions.Mode_Lame          = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_Mode);
	Config_User.RateMp3OggOptions.Bitrate_Oggenc     = gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_bitrate);
	Config_User.RateMp3OggOptions.Managed_Oggenc     = gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_managed);
	Config_User.RateMp3OggOptions.Downmix_Oggenc     = gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_downmix);

	Config_User.RateMp3OggFile.Bitrate_type_Lame  = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_abr_cbr_vbr);
	Config_User.RateMp3OggFile.Mode_Lame          = gtk_combo_box_get_active (var_file.Adr_Widget_Lame_Mode);
	Config_User.RateMp3OggFile.Bitrate_Oggenc     = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_bitrate);
	Config_User.RateMp3OggFile.Managed_Oggenc     = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_managed);
	Config_User.RateMp3OggFile.Downmix_Oggenc     = gtk_combo_box_get_active (var_file.Adr_Widget_Oggenc_downmix);

	g_print ("Recuperation values FLAC\n");
	Config_User.compression_level_flac = gtk_combo_box_get_active ( var_options.Adr_Widget_flac_compression);

	g_print ("Recuperation values APE\n");
	Config_User.compression_level_ape = gtk_combo_box_get_active ( var_options.Adr_Widget_ape_compression);

	g_print ("Recuperation values CDPARANOIA or IOCTL\n");
	options_get_readdir_cdaudio_by_ioctl ();

	g_print ("Recuperation values CDPARANOIA or CDPARANOIA EXPERT or CDDA2WAV\n");
	/*
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDDA2WAV;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA_EXPERT;
	*/
	
	g_print ("Recuperation values TAGS\n");
	Config_User.Bool_artist_tag   = optionstags_get_checkbutton_artist_tag ();
	Config_User.Bool_title_tag    = optionstags_get_checkbutton_title_tag ();
	Config_User.Bool_album_tag    = optionstags_get_checkbutton_album_tag ();
	Config_User.Bool_numerate_tag = optionstags_get_checkbutton_numerate_tag ();
	Config_User.Bool_genre_tag    = optionstags_get_checkbutton_genre_tag ();
	Config_User.Bool_year_tag     = optionstags_get_checkbutton_year_tag ();
	Config_User.Bool_comment_tag  = optionstags_get_checkbutton_comment_tag ();

	g_print ("Recuperation values mppenc\n");
	Config_User.quality_mppenc              = gtk_combo_box_get_active (var_options.Adr_Widget_Mppenc);

	g_print ("Recuperation values wavpack\n");
	Config_User.compression_wavpack         = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack);
	Config_User.sound_wavpack               = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_sound);
	Config_User.wavpack_mode_hybride        = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_mode_hybride);
	Config_User.wavpack_correction_file     = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_correction_file);
	Config_User.wavpack_maximum_compression = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_maximum_compression);
	Config_User.wavpack_signature_md5       = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_signature_md5);
	Config_User.wavpack_extra_encoding      = gtk_combo_box_get_active (var_options.Adr_Widget_wavpack_extra_encoding);

	g_print ("Recuperation values faac\n");
	Config_User.faac_conteneur              = gtk_combo_box_get_active (var_options.Adr_Widget_faac_conteneur);
	Config_User.faac_choice_vbr_abr         = gtk_combo_box_get_active (var_options.Adr_Widget_faac_choice_vbr_abr);

	g_print ("Recuperation values aacplusenc\n");
	Config_User.aacplusenc_choice_mono      = gtk_combo_box_get_active (var_options.Adr_Widget_aacplusenc_mono);
	Config_User.aacplusenc_choice_stereo    = gtk_combo_box_get_active (var_options.Adr_Widget_aacplusenc_stereo);

	g_print ("Recuperation des templates\n");
	g_free (Config_User.Templates_title_cdaudio);
	Config_User.Templates_title_cdaudio = NULL;
	Config_User.Templates_title_cdaudio = g_strdup (
			gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)));

	g_free (Config_User.Templates_rep_cdaudio);
	Config_User.Templates_rep_cdaudio = NULL;
	Config_User.Templates_rep_cdaudio = g_strdup (
			gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio)));

	g_print ("Recuperation du gestionnaire de paquets\n");
	Config_User.AdministratorOfPackets = options_get_administrator_of_packets ();

	g_print ("Sauvegarde position des onglets\n");
	Config_User.Bool_save_pos_notebook = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_pos_onglets")));

	g_print ("Sauvegarde l'etat de l'expander CD\n");
	Config_User.BoolEtatExpanderCd = gtk_expander_get_expanded (GTK_EXPANDER (var_cd.Adr_Expander));

	g_print ("configuser_save_file_config ()\n");
	configuser_save_file_config ();

	g_print ("fileanalyze_remove_entetefile ()\n");
	fileanalyze_remove_entetefile ();

	g_print ("dvdaudio_remove_GtkTree ()\n");
	dvdaudio_remove_GtkTree ();
	g_print ("dvdaudio_clear_list ()\n");
	dvdexec_remove_list ();

	g_print ("cdaudio_deallocate_glist_cd ();\n");
	cdaudio_deallocate_glist_cd ();

	g_print ("split_deallocate_GList ();\n");
	/**split_deallocate_GList ();*/

	g_print ("scancd_remove_glist_media ();\n");
	scancd_remove_glist_media ();

	g_print ("prgpostscript_remove_prog_ps ();\n");
	prgpostscript_remove_prog_ps ();

	g_print ("configuser_remove_struct ()\n");
	configuser_remove_struct ();

	g_print ("pocheevnt_remove ()\n");
	pocheevnt_remove ();

	g_print ("fileselect_clear_glist ()\n");
	fileselect_clear_glist ();
	
	g_print ("wincontrol_remove ()\n");
	wincontrol_remove ();

	g_print ("splitshuttle_remove_data ()\n");
	splitshuttle_remove_data ();

	g_print ("prginit_remove_comment ()\n");
	prginit_remove_comment ();
	
	g_print ("fileselect_remove_comment ()\n");
	fileselect_remove_comment ();
	
	g_print ("\n");

	gtk_main_quit ();
}

/*
*---------------------------------------------------------------------------
* WIND MAIN EVENT
*---------------------------------------------------------------------------
*/
gboolean on_wind_main_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	Before_End_Prg ();
	return FALSE;
}
gboolean on_wind_main_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	Before_End_Prg ();
	return FALSE;
}


/* Recuperation d'evenements clavier pour la structure KEYS
*/
gboolean on_wind_main_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	/*
	if (event->type == GDK_KEY_PRESS) {
		g_print("event->type                 = %d\n", event->type);
		g_print("event->key.state            = %d = %c\n", event->key.state,event->key.state );
		g_print("event->key.keyval           = %d = %c\n", event->key.keyval,  event->key.keyval);
		g_print("event->key.hardware_keycode = %d\n", event->key.hardware_keycode);
		g_print("\n");
	}
	*/
	
	if (event->type == GDK_LEAVE_NOTIFY) {
		splitshuttle_set_out ();
		utils_puts_statusbar_global ("");
	}
	else if (event->type == GDK_CONFIGURE) {
		/*
		Apply_New_Size_Tree_View_Audio (wind_main->allocation.width);
		Apply_New_Size_Tree_View_File (wind_main->allocation.width);
		*/
	}
	else if (event->type == GDK_KEY_PRESS /*&& keys.eventkey != GDK_KEY_PRESS*/) {
		keys.eventkey           = GDK_KEY_PRESS;
		keys.type               = event->type;
		keys.state              = event->key.state;
		keys.keyval             = event->key.keyval;
		keys.hardware_keycode   = event->key.hardware_keycode;

		if (event->key.keyval == GDK_Control_L) {
			keys.BoolGDK_Control_L = TRUE;
		}
		else if (event->key.keyval == GDK_Control_R) {
			keys.BoolGDK_Control_R = TRUE;
		}
		else if (event->key.keyval == GDK_Shift_L) {
			keys.BoolGDK_Shift_L = TRUE;
		}
		else if (event->key.keyval == GDK_Shift_R) {
			keys.BoolGDK_Shift_R = TRUE;
		}
		else if (event->key.keyval == GDK_Left) {
			keys.BoolGDK_Left = TRUE;
		}
		else if (event->key.keyval == GDK_Right) {
			keys.BoolGDK_Right = TRUE;
		}
		else if (event->key.keyval == GDK_KP_Add) {
			keys.BoolGDK_KP_Add = TRUE;
		}
		else if (event->key.keyval == GDK_KP_Subtract) {
			keys.BoolGDK_KP_Subtract = TRUE;
		}
		else if (event->key.keyval == GDK_plus) {
			keys.BoolGDK_plus = TRUE;
		}
		else if (event->key.keyval == GDK_minus) {
			keys.BoolGDK_minus = TRUE;
		}
		// CTRL_A  ?
		else if (event->key.state == 20 || event->key.state == 21) {
			if (event->key.keyval == 65 || event->key.keyval == 97) {
				keys.BoolGDK_Control_A = TRUE;
			}
		}
		/*
		if (Config_User.notebook_general == NOTEBOOK_SPLIT && VarSplit.SplitSelect == SPLIT_SELECT_IS_TACHE_MODIFIER) {
			if (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R) {
				VarSplit.SplitSelect = SPLIT_SELECT_IS_TACHE_AJOUTER;
				if (keys.keyval == GDK_Control_L) {
					utils_puts_statusbar_global (_("Ajouter une tache / [ Ctrl Gauche ] et [ + ou - ] : modif marqueur virtuel de la tache"));
				}
				else if (keys.keyval == GDK_Control_R) {
					utils_puts_statusbar_global (_("Ajouter une tache / [ Ctrl Droite ] et [ + ou - ] : modif marqueur virtuel de la tache"));
				}
			}
		}
		else if (Config_User.notebook_general == NOTEBOOK_SPLIT && VarSplit.SplitSelect == SPLIT_SELECT_IS_FILE) {
			if (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R) {
				if (keys.keyval == GDK_Control_L) {
					utils_puts_statusbar_global (_("[ Ctrl Gauche ] et [ + ou - ] : modif marqueur virtuel du fichier"));
				}
				else if (keys.keyval == GDK_Control_R) {
					utils_puts_statusbar_global (_("[ Ctrl Droite ] et [ + ou - ] : modif marqueur virtuel du fichier"));
				}
			}
		}
		*/
		if (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R) {

			utils_puts_statusbar_global (_("Touche CTRL + Click gauche = selection verticale"));
			cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Touche CTRL + Click gauche = selection verticale"));
			dvdaudio_puts_label_statusbar (_STATUSBAR_SAVE_, _("Touche CTRL inadaptee !"));
		}
		else if (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R) {

			utils_puts_statusbar_global (_("Touche SHIFT + Click gauche = selection horizontale"));
			cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Touche SHIFT + Click gauche = selection horizontale"));
			dvdaudio_puts_label_statusbar (_STATUSBAR_SAVE_, _("Touche SHIFT inadaptee !"));
		}
		else {
			utils_puts_statusbar_global ("");
			cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
			dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");
		}
	}
	else if (event->type == GDK_KEY_RELEASE) {
		keys.eventkey           = GDK_KEY_RELEASE;
		keys.type               = event->type;
		keys.state              = 0;
		keys.keyval             = 0;
		keys.hardware_keycode   = 0;

		if (event->key.keyval == GDK_Control_L) {
			keys.BoolGDK_Control_L = FALSE;
		}
		else if (event->key.keyval == GDK_Control_R) {
			keys.BoolGDK_Control_R = FALSE;
		}
		else if (event->key.keyval == GDK_Shift_L) {
			keys.BoolGDK_Shift_L = FALSE;
		}
		else if (event->key.keyval == GDK_Shift_R) {
			keys.BoolGDK_Shift_R = FALSE;
		}
		else if (event->key.keyval == GDK_Left) {
			keys.BoolGDK_Left = FALSE;
		}
		else if (event->key.keyval == GDK_Right) {
			keys.BoolGDK_Right = FALSE;
		}
		else if (event->key.keyval == GDK_KP_Add) {
			keys.BoolGDK_KP_Add = FALSE;
		}
		else if (event->key.keyval == GDK_KP_Subtract) {
			keys.BoolGDK_KP_Subtract = FALSE;
		}
		else if (event->key.keyval == GDK_plus) {
			keys.BoolGDK_plus = FALSE;
		}
		else if (event->key.keyval == GDK_minus) {
			keys.BoolGDK_minus = FALSE;
		}
		keys.BoolGDK_Control_A = FALSE;
		/*
		if (keys.BoolGDK_Control_L == FALSE && keys.BoolGDK_Control_R == FALSE) {

			if (Config_User.notebook_general == NOTEBOOK_SPLIT) {
				if (VarSplit.SplitSelect == SPLIT_SELECT_IS_TACHE_AJOUTER) {
					VarSplit.SplitSelect = SPLIT_SELECT_IS_TACHE_MODIFIER;
				}
			}
		}
		*/

		utils_puts_statusbar_global ("");
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");
	}
	else if (keys.eventkey == GDK_KEY_RELEASE) {
		keys.eventkey           = GDK_NOTHING;
		keys.type               = event->type;
		keys.state              = 0;
		keys.keyval             = 0;
		keys.hardware_keycode   = 0;

		utils_puts_statusbar_global ("");
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");

	}
	return FALSE;
}

/*
*---------------------------------------------------------------------------
* WIND MAIN -> MENU
*---------------------------------------------------------------------------
*/

/* MENU FICHIERS */

void on_quitter1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	Before_End_Prg ();
}

/* MENU ONGLETS */

void on_dvd_audio1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_DVD_AUDIO);
}
void on_cd_audio1_activate (GtkMenuItem *menuitem, gpointer user_data)
{

	Config_User.BoolEtatExpanderCd = TRUE;
	gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderCd);

	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_CD_AUDIO);
}
void on_fichiers1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_FICHIERS);

	Config_User.BoolEtatExpanderFile = TRUE;
	gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderFile);

		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_CONVERSION);
}
void on_wav1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_FICHIERS);

	Config_User.BoolEtatExpanderFile = TRUE;
	gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderFile);

		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_WAV);
}
void on_analyse_mp3_ogg1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_FICHIERS);

	Config_User.BoolEtatExpanderFile = TRUE;
	gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderFile);

		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_MP3OGG);
}
void on_tags1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_FICHIERS);

	Config_User.BoolEtatExpanderFile = TRUE;
	gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderFile);

		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_TAGS);
}

void on_logs1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_POCHETTE);
}
void on_pochette1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_LOGS);
}
void on_options1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_OPTIONS);
}
void on_expert2_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_PRGEXTERNES);
}




void on_select_popup_tongle_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/*
	struct {
		gchar *n;
		gint   i;
	} TT [ 3 ] = {
	{"selection_popup_tongle_dvd",		NOTEBOOK_DVD_AUDIO },
	{"selection_popup_tongle_cd",		NOTEBOOK_CD_AUDIO },
	{"selection_popup_tongle_fichiers",	NOTEBOOK_FICHIERS }
	};
	gint cpt;

	for (cpt = 0; cpt < 3; cpt ++) {
		if (GTK_WIDGET (menuitem) == GTK_WIDGET (lookup_widget (wind_main, TT[ cpt ].n))) {
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), TT[ cpt ].i);
			-- fileshowhide_create_win ();
			break;
		}
	}
	*/
	showhidetreeview_open_window (Config_User.notebook_general, Config_User.notebook_file);
}

/* MENU OUTILS */

void on_applications_externes_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (
			GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGEXTERNES);
}
void on_logs2_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_LOGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")),
				NOTEBOOK_LOGS_COMPUTER);
}
void on_preferences1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_OPTIONS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_GENERAL);
}

/* MENU AIDE */

void on_le_site_d_xcfa1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	web_goto_xcfa_page ("http://www.xcfa.tuxfamily.org");
}
void on_a_propos1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	AboutXcfa_Create_Windows ();
}

/*
*---------------------------------------------------------------------------
* ONGLET CD-AUDIO -> REALIZATE
*---------------------------------------------------------------------------
*/
void on_button_cancel_cddb_clicked (GtkButton *button, gpointer user_data)
{
	cdaudio_set_cancel_cddb ();
}
void on_button_cancel_cddb_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Button_Cancel_cddb = widget;
}
void on_combobox_peripherique_cd_changed (GtkComboBox *combobox, gpointer user_data)
{
	cdaudiotoc_reffresh_list_cd ();
}
void on_combobox_peripherique_cd_realize (GtkWidget *widget, gpointer user_data)
{
	scancd_combobox_peripherique_cd_realize (widget);
	var_cd.Adr_Combo_Box = GTK_COMBO_BOX (widget);
}
void on_button_destination_cd_clicked (GtkButton *button, gpointer user_data)
{
	cdaudio_button_destination_cd_clicked ();
}
void on_scrolledwindow_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdaudio_scrolledwindow_cd_realize (widget);
}
void on_button_rafraichir_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Button_Raffraichir = widget;
}
void on_button_rafraichir_cd_clicked (GtkButton *button, gpointer user_data)
{
	cdaudiotoc_reffresh_list_cd ();
}
void on_label_duree_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Label_Duree = widget;
}
void on_label_titre_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Label_Titre = widget;
}
void on_progressbar_cd_audio_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Progressbar = widget;
}
void on_button_destination_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Button_Destination = GTK_BUTTON (widget);
	gtk_button_set_use_underline (GTK_BUTTON (var_cd.Adr_Button_Destination), FALSE);
	gtk_button_set_label (GTK_BUTTON (var_cd.Adr_Button_Destination), Config_User.Path_Destination_CD);
}
void on_cdaudio_combobox_serveur_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdaudio_combobox_serveur_cd_realize (widget);
}
void on_combobox_serveur_cd_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (var_cd.Adr_combobox_serveur) {
		Config_User.serveur_cddb = gtk_combo_box_get_active (var_cd.Adr_combobox_serveur);
	}
}
void on_frame_action_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_frame_action_cd = widget;
}
void on_button_applique_change_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_button_applique_change = widget;
}
void on_button_applique_change_clicked (GtkButton *button, gpointer user_data)
{
	cdaudio_applique_change ();
}

/*
*---------------------------------------------------------------------------
* ONGLET FICHIER -> REALIZATE
*---------------------------------------------------------------------------
*/
void on_file_scrolledwindow_file_realize (GtkWidget *widget, gpointer user_data)
{
	file_scrolledwindow_file_realize (widget);
}
void on_button_import_file_clicked (GtkButton *button, gpointer user_data)
{
	file_button_import_file_clicked ();
}
void on_label_number_files_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_Label_Number = widget;
}
void on_file_button_del_file_clicked (GtkButton *button, gpointer user_data)
{
	file_button_del_file_clicked ();
}
void on_combobox_dest_file_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_dest_file_realize (widget);
}
void on_combobox_dest_file_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_dest_file_changed ();
}
void on_combobox_select_type_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_select_type_realize (widget);
}
void on_combobox_select_type_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_select_type_changed ();
}
void on_button_apply_file_clicked (GtkButton *button, gpointer user_data)
{
	file_button_apply_file_clicked (button);
}

/*
*---------------------------------------------------------------------------
* ONGLET ANALYZE WAV -> REALIZE
*---------------------------------------------------------------------------
*/
void on_spinbutton_frequence_wav_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_spinbutton_frequence = GTK_SPIN_BUTTON (widget);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.Adr_spinbutton_frequence)), FALSE);
}
void on_filewav_spinbutton_frequence_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	file_spinbutton_frequence_value_changed ();
}


/*
*---------------------------------------------------------------------------
* ONGLET ANALYZE MP3 OGG -> REALIZE
*---------------------------------------------------------------------------
*/
void on_filemp3ogg_button_efface_bitrate_clicked (GtkButton *button, gpointer user_data)
{
	file_button_efface_bitrate_clicked_file_MP3OGG ();
}

/*
*---------------------------------------------------------------------------
* REALIZE RESTITUTION ONGLETS
*---------------------------------------------------------------------------
*/
void on_checkbutton_pos_onglets_realize (GtkWidget *widget, gpointer user_data)
{
}

/*
*---------------------------------------------------------------------------
* ONGLET OPTIONS
*---------------------------------------------------------------------------
*/
void on_scrolledwindow_applications_externes_realize (GtkWidget *widget, gpointer user_data)
{
	prginit_make_scrolledwindow (widget);
}
void on_combobox_nice_realize (GtkWidget *widget, gpointer user_data)
{
	options_make_combobox_nice (widget);
}
void on_combobox_nice_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (var_options.Adr_Widget_Nice != NULL) {
		Config_User.Nice = options_get_val_nice ();
	}
}
void on_button_scan_clicked (GtkButton *button, gpointer user_data)
{
	prginit_update_glist ();
}
void on_button_scan_without_deb_clicked (GtkButton *button, gpointer user_data)
{
	prginit_update_glist ();
}

void on_combobox_lame_abr_cbr_vbr_realize (GtkWidget *widget, gpointer user_data)
{
	optionsLame_combobox_lame_abr_cbr_vbr_realize (widget);
}
void on_combobox_lame_abr_cbr_vbr_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsLame_combobox_lame_abr_cbr_vbr_changed ();
}

void on_combobox_lame_type_bitrate_realize (GtkWidget *widget, gpointer user_data)
{
	optionsLame_combobox_lame_type_bitrate_realize (widget);
}
void on_combobox_lame_type_bitrate_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsLame_combobox_lame_type_bitrate_changed ();
}

void on_combobox_lame_mode_realize (GtkWidget *widget, gpointer user_data)
{
	optionsLame_make_combobox_lame_mode_realize (widget);
}
void on_combobox_lame_mode_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsLame_combobox_lame_mode_changed ();
}
void on_combobox_mppenc_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsMusepack_combobox_mppenc_changed ();
}
void on_combobox_mppenc_realize (GtkWidget *widget, gpointer user_data)
{
	optionsMusepack_combobox_mppenc_realize (widget);
}

void on_combobox_wavpack_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_changed ();
}
void on_combobox_wavpack_sound_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_sound_changed ();
}
void on_combobox_wavpack_fichier_de_correction_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_fichier_de_correction_changed ();
}
void on_combobox_wavpack_compression_maximum_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_compression_maximum_changed ();
}
void on_combobox_wavpack_signature_md5_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_signature_md5_changed ();
}
void on_combobox_wavpack_extra_encoding_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_extra_encoding_changed ();
}

void on_combobox_wavpack_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_realize (widget);
}
void on_combobox_wavpack_sound_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_sound_realize (widget);
}
void on_combobox_wavpack_mode_hybride_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_mode_hybride_changed ();
}


void on_combobox_wavpack_mode_hybride_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_mode_hybride_realize (widget);
}
void on_combobox_wavpack_fichier_de_correction_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_fichier_de_correction_realize (widget);
}
void on_combobox_wavpack_compression_maximum_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_compression_maximum_realize (widget);
}
void on_combobox_wavpack_signature_md5_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_signature_md5_realize (widget);
}
void on_combobox_wavpack_extra_encoding_realize (GtkWidget *widget, gpointer user_data)
{
	optionsWavpack_combobox_wavpack_extra_encoding_realize (widget);
}

void on_combobox_oggenc_bitrate_realize (GtkWidget *widget, gpointer user_data)
{
	optionsOggenc_make_combobox_oggenc (widget);
}
void on_combobox_oggenc_bitrate_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsOggenc_combobox_oggenc_bitrate_changed ();
}
void on_eventbox_combobox_oggenc_managed_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_combobox_oggenc_managed_realize (GtkWidget *widget, gpointer user_data)
{
	optionsOggenc_combobox_oggenc_managed_realize (widget);
}
void on_combobox_oggenc_managed_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsOggenc_combobox_oggenc_managed_changed ();
}
void on_eventbox_combobox_oggenc_downmix_realize (GtkWidget *widget, gpointer user_data)
{

}
void on_combobox_oggenc_downmix_realize (GtkWidget *widget, gpointer user_data)
{
	optionsOggenc_combobox_oggenc_downmix_realize (widget);
}
void on_combobox_oggenc_downmix_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsOggenc_combobox_oggenc_downmix_changed ();
}

void on_radiobutton_cdparanoia_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_cdparanoia = widget;
}
void on_radiobutton_ioctl_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_ioctl = widget;
}

void on_combobox_flac_compression_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsFlac_combobox_flac_compression_changed ();
}
void on_eventbox_flac_compression_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_options_combobox_flac_compression_realize (GtkWidget *widget, gpointer user_data)
{
	optionsFlac_combobox_flac_compression_realize (widget);
}
void on_combobox_ape_compression_changed (GtkComboBox *combobox, gpointer user_data)
{
	optionsApe_combobox_ape_compression_changed ();
}
void on_eventbox_combobox_ape_compression_realize (GtkWidget *widget,  gpointer user_data)
{
}
void on_combobox_ape_compression_realize (GtkWidget *widget, gpointer user_data)
{
	optionsApe_combobox_ape_compression_realize (widget);
}

void  on_button_defaut_convertisseur_clicked (GtkButton *button, gpointer user_data)
{
	options_default_values (button);
}

/*
*---------------------------------------------------------------------------
* ONGLET LOGS
*---------------------------------------------------------------------------
*/
void on_label_computer_realize (GtkWidget *widget, gpointer user_data)
{
	var_logs.Adr_label_computer = widget;
}
void on_label_import_file_realize (GtkWidget *widget,gpointer user_data)
{
	var_logs.Adr_label_import_file = widget;
}
void on_checkbutton_goto_files_import_realize (GtkWidget *widget, gpointer user_data)
{
	var_logs.Adr_checkbutton_goto_files_import = widget;
}
void on_logs_checkbutton_goto_files_import_clicked (GtkButton *button, gpointer user_data)
{
	logs_checkbutton_goto_files_import_clicked ();
}

/*
*---------------------------------------------------------------------------
* ONGLET POCHETTE -> REALIZATE
*---------------------------------------------------------------------------
*/

/* Callbacks Preview Image */

void on_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_image_preview_realize (widget);
}
void on_button_path_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_button_path_image_preview_realize (widget);
}
void on_button_path_image_preview_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_path_image_preview_clicked ();
}
void on_togglebutton_recto_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_togglebutton_recto_realize (widget);
}
void on_togglebutton_recto_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_togglebutton_recto_clicked ();
}
void on_togglebutton_verso_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_togglebutton_verso_realize (widget);
}
void on_togglebutton_verso_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_togglebutton_verso_clicked ();
}
void on_combobox_zoom_choiximage_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_zoom_choiximage_realize (widget);
}
void on_combobox_zoom_choiximage_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_zoom_choiximage_changed ();
}
void on_button_load_choiximage_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_load_choiximage_clicked ();
}
void on_togglebutton_remove_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_togglebutton_remove_realize (widget);
}
void on_togglebutton_remove_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_togglebutton_remove_clicked ();
}
void on_viewport_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_viewport_image_preview_realize (widget);
}

/* Titre volume cd-audio */

void on_comboboxentry_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_comboboxentry_cdaudio_realize (widget);
}
void on_comboboxentry_cdaudio_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_comboboxentry_cdaudio_changed ();
}
void on_button_get_from_web_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_get_from_web_clicked ();
}
void on_button_get_title_cdaudio_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_get_title_cdaudio_clicked ();
}

/* recto */

gboolean on_spinbutton_zoom_recto_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	pocheevnt_spinbutton_zoom_recto_button_press_event ();
	return FALSE;
}
gboolean on_spinbutton_zoom_recto_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	pocheevnt_spinbutton_zoom_recto_button_release_event ();
	return FALSE;
}
void on_spinbutton_zoom_recto_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gint value;

	value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));
	pocheevnt_spinbutton_zoom_recto_value_changed (value);
}

/* verso */

gboolean on_spinbutton_zoom_verso_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	pocheevnt_spinbutton_zoom_verso_button_press_event ();
	return (FALSE);
}
gboolean on_spinbutton_zoom_verso_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	pocheevnt_spinbutton_zoom_verso_button_release_event ();
	return (FALSE);
}
void on_spinbutton_zoom_verso_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gint value;

	value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));
	pocheevnt_spinbutton_zoom_verso_value_changed (value);
}

/* Titre */

void on_entry_titre_ps_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_entry_titre_ps_realize (widget);
}
void on_entry_titre_ps_changed (GtkEditable *editable, gpointer user_data)
{
	pocheevnt_entry_titre_ps_changed ();
}
void on_combobox_entry_title_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_entry_title_realize (widget);
}
void on_combobox_entry_title_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_entry_title_changed ();
}

/* Pied de page */

void on_entry_foottext_ps_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_entry_foottext_ps_realize (widget);
}
void on_entry_foottext_ps_changed (GtkEditable *editable, gpointer user_data)
{
	pocheevnt_entry_foottext_ps_changed ();
}
void on_combobox_foottext_ps_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_foottext_ps_realize (widget);
}
void on_combobox_foottext_ps_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_foottext_ps_changed ();
}

/* Texte */

void on_combobox_text_recto_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_text_recto_realize (widget);
}
void on_combobox_text_recto_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_text_recto_changed ();
}
void on_combobox_text_verso_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_text_verso_realize (widget);
}
void on_combobox_text_verso_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_text_verso_changed ();
}
void on_combobox_link_fields_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_link_fields_realize (widget);
}
void on_combobox_link_fields_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_link_fields_changed ();
}
void on_button_liste_numerate_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_button_liste_numerate_realize (widget);
}
void on_button_liste_numerate_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_liste_numerate_clicked ();
}

void on_button_importation_titre_cd_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_button_importation_titre_cd_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_importation_titre_cd_clicked ();
}

void on_textview_text_poche_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_textview_text_poche_realize (widget);
}
void on_textview_text_poche_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
	/* le DRAG n'est plus utile */
	data->length = 0;
	pocheevnt_textview_text_poche_drag_data_received ((gchar *)data->data);
}

/* Options */

void on_checkbutton_load_images_init_xcfa_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_checkbutton_load_images_init_xcfa_realize (widget);
}
void on_checkbutton_load_images_init_xcfa_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_checkbutton_load_images_init_xcfa_clicked ();
}

/* Choix, preview, make fichier PostScript */

void on_button_preview_postscript_clicked (GtkButton *button, gpointer user_data)
{
	pocheevnt_button_preview_postscript_clicked ();
}
void on_combobox_choice_preview_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_choice_preview_postscript_realize (widget);
}
void on_combobox_choice_preview_postscript_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_choice_preview_postscript_changed ();
}
void on_eventbox_combobox_generate_ps_pdf_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_combobox_generate_ps_pdf_realize (GtkWidget *widget, gpointer user_data)
{
	pocheevnt_combobox_generate_ps_pdf_realize (widget);
}
void on_combobox_generate_ps_pdf_changed (GtkComboBox *combobox, gpointer user_data)
{
	pocheevnt_combobox_generate_ps_pdf_changed ();
}

/* Evenements dessin pochette */

gboolean on_eventbox_image_preview_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	pocheevnt_event (widget, event, user_data);
	return FALSE;
}
void on_eventbox_image_preview_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	pocheevnt_after_event (widget, event, user_data);
}

/* TAGS */

void on_checkbutton_artist_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_artist_tag_realize (widget);
}
void on_checkbutton_title_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_title_tag_realize (widget);
}
void on_checkbutton_album_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_album_tag_realize (widget);
}
void on_checkbutton_numerate_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_numerate_tag_realize (widget);
}
void on_checkbutton_genre_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_genre_tag_realize (widget);
}
void on_checkbutton_year_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_year_tag_realize (widget);
}
void on_checkbutton_comment_tag_realize (GtkWidget *widget, gpointer user_data)
{
	optionstags_checkbutton_comment_tag_realize (widget);
}
void on_checkbutton_tag_clicked (GtkButton *button, gpointer user_data)
{
	/*PRINT_FUNC_LF();*/
	optionstags_checkbutton_tag_clicked (button);
}

void on_scrolledwindow_applications_navigator_realize (GtkWidget *widget, gpointer user_data)
{
	prgnavigator_make_scrolledwindow (widget);
}
void on_button_add_navigator_realize (GtkWidget *widget, gpointer user_data)
{
	var_prgnavi.Adr_button_add_navigator = widget;
}
void on_entry_name_navigator_realize (GtkWidget *widget, gpointer user_data)
{
	var_prgnavi.Adr_entry_name_navigator = widget;
}
void on_button_del_navigator_realize (GtkWidget *widget, gpointer user_data)
{
	var_prgnavi.Adr_button_del_navigator = widget;
}
void on_button_add_navigator_clicked (GtkButton *button, gpointer user_data)
{
	prgnavigator_button_add_navigator_clicked ();
}
void on_entry_name_navigator_changed (GtkEditable *editable, gpointer user_data)
{
	prgnavigator_entry_name_navigator_changed ();
}
void on_button_del_navigator_clicked (GtkButton *button, gpointer user_data)
{
	prgnavigator_button_del_navigator_clicked ();
}

void on_label_type_paquege_realize (GtkWidget *widget, gpointer user_data)
{
	/* PRINT_FUNC_LF(); */

	/* Init: var_options.Adr_label_type_paquege */
	prginstall_set_label_type_package (widget);
}

void on_scrolledwindow_applications_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	prgpostscript_make_scrolledwindow (widget);
}
void on_button_add_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	prgpostscript_button_add_postscript_realize (widget);
}
void on_button_add_postscript_clicked (GtkButton *button, gpointer user_data)
{
	prgpostscript_button_add_postscript_clicked ();
}
void on_entry_name_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	prgpostscript_entry_name_postscript_realize (widget);
}
void on_entry_name_postscript_changed (GtkEditable *editable, gpointer user_data)
{
	prgpostscript_entry_name_postscript_changed ();
}
void on_button_del_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	prgpostscript_button_del_postscript_realize (widget);
}
void on_button_del_postscript_clicked (GtkButton *button, gpointer user_data)
{
	prgpostscript_button_del_postscript_clicked ();
}

/* WAV */

void on_progressbar_wav_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_progressbar_wav = widget;
}

/* DVD AUDIO */

void on_scrolledwindow_dvd_audio_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_make_scrolledwindow_realize (widget);
}
void on_combobox_peripherique_dvd_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_combobox_peripherique_dvd_realize (widget);
}
void on_combobox_peripherique_dvd_changed (GtkComboBox *combobox, gpointer user_data)
{
	dvdaudio_reffresh_list_dvd ();
}
void on_button_rafraichir_dvd_clicked (GtkButton *button, gpointer user_data)
{
	dvdaudio_reffresh_list_dvd ();
}
void on_button_destination_dvd_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_button_destination_dvd_realize (widget);
}
void on_button_destination_dvd_clicked (GtkButton *button, gpointer user_data)
{
	dvdaudio_button_destination_dvd_clicked ();
}
void on_button_extraction_dvd_clicked (GtkButton *button, gpointer user_data)
{
	dvdaudio_button_extraction_dvd_clicked ();
}
void on_button_deplier_dvd_clicked (GtkButton *button, gpointer user_data)
{
	gtk_tree_view_expand_all ( (GtkTreeView *)var_dvdaudio.Adr_TreeView);
}
void on_button_replier_dvd_clicked (GtkButton *button, gpointer user_data)
{
	gtk_tree_view_collapse_all ( (GtkTreeView *)var_dvdaudio.Adr_TreeView);
}
void on_button_annuler_lecture_dvd_clicked (GtkButton *button, gpointer user_data)
{
	dvdaudio_button_annuler_lecture_dvd_clicked ();
}
void on_progressbar_dvd_audio_realize (GtkWidget *widget, gpointer user_data)
{
	var_dvdaudio.Adr_progressbar_dvd = widget;
}

/* SUB & AMBIANCE DVD */

void on_eventbox_combobox_sub_dvd_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_eventbox_combobox_ambiance_dvd_realize (GtkWidget *widget, gpointer user_data)
{
}
void on_combobox_sub_dvd_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_combobox_sub_dvd_realize (widget);
}
void on_combobox_ambiance_dvd_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_combobox_ambiance_dvd_realize (widget);
}

void on_notebook_general_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok) {
		Config_User.notebook_general = page_num;
	}
	/* Update Glist CD-Audio
	*/
	if (page_num == NOTEBOOK_CD_AUDIO) {
		cdaudio_update_glist_audio_cd ();
	}

	/* Update Glist Files
	*/
	if (page_num == NOTEBOOK_FICHIERS) {
		file_pixbuf_update_glist_file ();
	}

	if (page_num == NOTEBOOK_SPLIT) {
		split_set_flag_buttons_audio ();
	}

	if (page_num == NOTEBOOK_PRGEXTERNES) {
		prginit_update_glist ();
	}

	showhidetreeview_get_etat_fields ();
	showhidetreeview_set_etat_treeview (Config_User.notebook_general, Config_User.notebook_file);
}
void on_notebook_options_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_options = page_num;
}
void on_notebook_pochette_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_pochette = page_num;
}
void on_notebook_logs_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_logs = page_num;
}
void on_notebook_app_externes_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_app = page_num;
}

void on_button_WebInformations_clicked (GtkButton *button, gpointer user_data)
{
	if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebCdparanoia_homepage")))) {
		web_goto_xcfa_page (_("http://www.xiph.org/paranoia/"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebCdparanoia_manpage")))) {
		web_goto_xcfa_page (_("http://www.delafond.org/traducmanfr/man/man1/cdparanoia.1.html"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebLame_homepage")))) {
		web_goto_xcfa_page (_("http://lame.sourceforge.net/index.php"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebLame_wikimp3")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/Mp3"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebLame_wikilame")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/LAME"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebOggenc_wiki")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/Ogg_Vorbis"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebOggenc_manpage")))) {
		web_goto_xcfa_page (_("http://www.delafond.org/traducmanfr/man/man1/oggenc.1.html"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebFlac_homepage")))) {
		web_goto_xcfa_page (_("http://flac-tools.sourceforge.net/"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebFlac_framasoft")))) {
		web_goto_xcfa_page (_("http://www.framasoft.net/article1510.html"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebMac_wiki")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/Advanced_Audio_Coding"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebFlac_wiki")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/WavPack"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebMusepack_homepage")))) {
		web_goto_xcfa_page (_("http://www.musepack.net/"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_WebMusepack_framasoft")))) {
		web_goto_xcfa_page (_("http://www.framasoft.net/article2094.html"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_faac_homepage")))) {
		web_goto_xcfa_page (_("http://www.audiocoding.com/faac.html"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_faac_web_info")))) {
		web_goto_xcfa_page (_("http://freshmeat.net/projects/faac/"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_aacplusenc_homepage")))) {
		web_goto_xcfa_page (_("http://teknoraver.campuslife.it/software/mp4tools/"));
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (wind_main, "button_aacplusenc_web_info")))) {
		web_goto_xcfa_page (_("http://fr.wikipedia.org/wiki/Advanced_Audio_Coding"));
	}
}

void on_entry_lame_mp3_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_lame_mp3 = widget;
}
void on_label_lame_mp3_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_lame_mp3 = widget;
}
void on_entry_oggenc_ogg_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_oggenc_ogg = widget;
}
void on_label_oggenc_ogg_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_oggenc_ogg = widget;
}
void on_entry_flac_flac_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_flac_flac = widget;
}
void on_label_flac_flac_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_flac_flac = widget;
}
void on_entry_mac_ape_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_mac_ape = widget;
}
void on_label_mac_ape_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_mac_ape = widget;
}
void on_entry_wavpack_wv_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_wavpack_wv = widget;
}
void on_label_wavpack_wv_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_wavpack_wv = widget;
}
void on_entry_musepack_mpc_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_musepack_mpc = widget;
}
void on_label_musepack_mpc_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_musepack_mpc = widget;
}
void on_entry_faac_m4a_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_entry_faac_m4a = widget;
}
void on_label_faac_m4a_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_label_faac_m4a = widget;
}
void on_entry_op_internal_changed (GtkEditable *editable, gpointer user_data)
{
	options_entry_op_internal_changed (editable);
}
void on_button_dossier_de_conversion_realize (GtkWidget *widget, gpointer user_data)
{
	options_button_dossier_de_conversion_realize (widget);
}
void on_button_dossier_de_conversion_clicked (GtkButton *button, gpointer user_data)
{
	options_button_dossier_de_conversion_clicked ();
}
void on_hbox_expander_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	/*cdexpander_hbox_expander_cdaudio_realize (widget);*/
}
void on_entry_stockage_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_stockage_cdaudio = widget;
	gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio), Config_User.Templates_rep_cdaudio);
	cdaudio_entry_stockage_cdaudio_changed ();
}
void on_label_stockage_cdaudio_exemple_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_label_stockage_cdaudio = widget;
	if (var_cd.Adr_entry_stockage_cdaudio) {
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio), Config_User.Templates_rep_cdaudio);
		cdaudio_entry_stockage_cdaudio_changed ();
	}
}
void on_entry_stockage_cdaudio_changed (GtkEditable *editable, gpointer user_data)
{
	cdaudio_entry_stockage_cdaudio_changed ();
}


void on_radiobutton_extract_with_cdparanoia_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_extract_with_cdparanoia = widget;
	if (Config_User.Extract_cd_with == EXTRACT_WITH_CDPARANOIA)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia), TRUE);
}
void on_radiobutton_extract_with_cdda2wav_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_extract_with_cdda2wav = widget;
	if (Config_User.Extract_cd_with == EXTRACT_WITH_CDDA2WAV)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav), TRUE);
}
void on_radiobutton_cdparanoia_mode_expert_realize (GtkWidget *widget, gpointer user_data)
{
	var_options.Adr_radiobutton_cdparanoia_mode_expert = widget;
	if (Config_User.Extract_cd_with == EXTRACT_WITH_CDPARANOIA_EXPERT)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert), TRUE);
}
void on_radiobutton_choice_extract_with_clicked (GtkButton *button, gpointer user_data)
{
	if (GTK_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert) == button)		Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA_EXPERT;
	else if (GTK_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav) == button)	Config_User.Extract_cd_with = EXTRACT_WITH_CDDA2WAV;
	else if (GTK_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia) == button)	Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA;
}

/*
*---------------------------------------------------------------------------
* ONGLET APPLICATIONS EXTERNES -> InstallationSimplifiee
*---------------------------------------------------------------------------
*/
void on_button_selection_globale_InstallSimple_clicked (GtkButton *button, gpointer user_data)
{
	prginit_set_selected ();
	gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_goto_install), prginit_get_bool_install ());
}
void on_button_goto_install_InstallSimple_realize (GtkWidget *widget, gpointer user_data)
{
	var_prgextern.button_goto_install = widget;
	gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_goto_install), FALSE);
}
void on_button_goto_install_InstallSimple_clicked (GtkButton *button, gpointer user_data)
{
	prginstall_systeme_debian ();
}
void on_button_selection_globale_InstallSimple_realize (GtkWidget *widget, gpointer user_data)
{
	var_prgextern.button_selection_globale = widget;
	if (var_prgextern.button_selection_globale)
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_selection_globale), prginit_is_not_installed ());
}

/* SWITCH PAGE IN FILE
*/

void on_notebook_in_file_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_file = page_num;

	file_notebook_in_file_switch_page (Config_User.notebook_file);
}

void on_entry_tag_title_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_entry_tag_title = widget;
}
void on_entry_tag_album_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_entry_tag_album = widget;
}
void on_entry_tag_artist_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_entry_tag_artist = widget;
}
void on_entry_tag_comment_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_entry_tag_comment = widget;
}
void on_spinbutton_tag_track_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_spinbutton_tag_track = widget;
}
void on_spinbutton_tag_year_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_spinbutton_tag_year = widget;
}
void on_label_tag_change_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_label_tag_change = widget;
}
void on_button_tag_appliquer_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_button_tag_appliquer = widget;
}
void on_table_tag_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.Adr_table_tag = widget;
}

void on_expander_in_file_realize (GtkWidget *widget,  gpointer user_data)
{
	var_file.Adr_Expander = widget;
}


/* LABEL STATUSBAR GLOBAL
*/
void on_label_statusbar_global_realize (GtkWidget *widget, gpointer user_data)
{
	var_utils.AdrLabelStatusbarGlobal = widget;
}

gboolean on_wind_wav_to_wav_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (filewavconv_delete_event ());
}
gboolean on_wind_wav_to_wav_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (filewavconv_destroy_event ());
}
void on_button_stop_wav_to_wav_clicked (GtkButton *button, gpointer user_data)
{
	filewavconv_stop_wav_to_wav_clicked ();
}

/*
*---------------------------------------------------------------------------
* AIDE : FILE, DVD, CD, POCHETTE, APP-EXT, OPTIONS
*---------------------------------------------------------------------------
*/
gboolean on_button_lecture_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_lecture_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_lecture_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_lecture_leave_notify_event ();
	return FALSE;
}

gboolean on_button_file_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_file_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_file_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_dvd_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_dvdaudio_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_dvd_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_cd_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_cdaudio_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_cd_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_pochette_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_pocheevnt_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_pochette_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_AppExt_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_prgextern_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_AppExt_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_options_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_options_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_options_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}
gboolean on_button_split_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_split_enter_notify_event (widget);
	return FALSE;
}
gboolean on_button_split_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data)
{
	help_leave_notify_event ();
	return FALSE;
}

/*  AFFICHER / CACHER LES CHAMPS DES TREEVIEWS
 *  DVD, CD, ALLFILE, WAV, MP3OGG, SPLIT
 */
gboolean on_wind_treeview_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (showhidetreeview_delete_event ());
}
gboolean on_wind_treeview_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (showhidetreeview_destroy_event ());
}
void on_notebook_windtreeview_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	showhidetreeview_notebook_windtreeview_switch_page (page_num);
}
void on_button_select_global_windtreeview_clicked (GtkButton *button, gpointer user_data)
{
	showhidetreeview_button_select_global_windtreeview_clicked ();
}
void on_button_deselect_global_windtreeview_clicked (GtkButton *button, gpointer user_data)
{
	showhidetreeview_button_deselect_global_windtreeview_clicked ();
}
void on_button_quit_windtreeview_clicked (GtkButton *button, gpointer user_data)
{
	showhidetreeview_button_quit_windtreeview_clicked ();
}
void on_checkbutton_modif_treeview_clicked (GtkButton *button, gpointer user_data)
{
	showhidetreeview_checkbutton_modif_treeview_clicked (button);
}
void on_radiobutton_modif_treeview_clicked (GtkButton *button, gpointer user_data)
{
	showhidetreeview_radiobutton_modif_treeview_clicked (button);
}



/*  WIND ABOUT
*
*   GtkWidget* create_wind_about (void);
*/

gboolean on_wind_about_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (AboutXcfa_delete_event ());
}
gboolean on_wind_about_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (AboutXcfa_destroy_event ());
}
void on_image_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_image_about_realize (widget);
}
void on_label_xcfa_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_label_xcfa_about_realize (widget);
}
void on_label_author_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_label_author_about_realize (widget);
}
void on_label_contrib_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_label_contrib_about_realize (widget);
}
void on_button_ok_about_clicked (GtkButton *button, gpointer user_data)
{
	AboutXcfa_button_ok_about_clicked ();
}
void on_label_button_pagexcfa_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_label_button_pagexcfa_about_realize (widget);
}
void on_textview_label_license_about_realize (GtkWidget *widget, gpointer user_data)
{
	AboutXcfa_textview_label_license_about_realize (widget);
}
void on_button_contrib_about_clicked (GtkButton *button, gpointer user_data)
{
	AboutXcfa_button_contrib_about_clicked (button);
}



/* ONGLET CD ACTION ET TAGS
*/
void on_entry_tag_titre_chanson_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_tag_titre_chanson_changed ();
}
void on_entry_tag_titre_album_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_tag_titre_album_changed ();
}
void on_entry_tag_nom_artiste_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_tag_nom_artiste_changed ();
}
void on_entry_tag_commentaire_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_tag_commentaire_changed ();
}
void on_spinbutton_tag_annee_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	cdexpander_spinbutton_tag_annee_value_changed ();
}
void on_spinbutton_tag_piste_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	cdexpander_spinbutton_tag_piste_value_changed ();
}
void on_entry_tag_titre_fichier_m3u_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_tag_titre_fichier_m3u_changed ();
}
void on_combobox_tag_genre_cd_changed (GtkComboBox *combobox, gpointer user_data)
{
	cdexpander_combobox_tag_genre_cd_changed ();
}
void on_entry_new_titre_cdaudio_changed (GtkEditable *editable, gpointer user_data)
{
	cdexpander_entry_new_titre_cdaudio_changed ();
}





void on_entry_tag_titre_chanson_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_tag_titre_chanson_realize (widget);
}
void on_entry_tag_titre_album_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_tag_titre_album_realize (widget);
}
void on_entry_tag_nom_artiste_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_tag_nom_artiste_realize (widget);
}
void on_entry_tag_commentaire_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_tag_commentaire_realize (widget);
}
void on_spinbutton_tag_annee_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_spinbutton_tag_annee_realize (widget);
}
void on_spinbutton_tag_piste_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_spinbutton_tag_piste_realize (widget);
}
void on_entry_tag_titre_fichier_m3u_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_tag_titre_fichier_m3u_realize (widget);
}
void on_combobox_tag_genre_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_combobox_tag_genre_cd_realize (widget);
}
void on_entry_new_titre_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_entry_new_titre_cdaudio_realize (widget);
}
void on_expander_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_expander_cd_realize (widget);
}
void on_notebook_expander_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdexpander_notebook_expander_cd_realize (widget);
}

/* PLAYER ONGLET FICHIER
*/
void on_button_stop_music_clicked (GtkButton *button, gpointer user_data)
{
	Player_button_stop_music_clicked (button);
}


/* FAAC
*/
void on_combobox_faac_conteneur_realize (GtkWidget *widget, gpointer user_data)
{
	OptionsFaac_combobox_faac_conteneur_realize (widget);
}
void on_combobox_faac_conteneur_changed (GtkComboBox *combobox, gpointer user_data)
{
	OptionsFaac_combobox_faac_conteneur_changed ();
}
void on_combobox_faac_choice_vbr_abr_realize (GtkWidget *widget, gpointer user_data)
{
	OptionsFaac_combobox_faac_choice_vbr_abr_realize (widget);
}
void on_combobox_faac_choice_vbr_abr_changed (GtkComboBox *combobox, gpointer user_data)
{
	OptionsFaac_combobox_faac_choice_vbr_abr_changed ();
}
void on_combobox_faac_set_choice_vbr_abr_realize (GtkWidget *widget, gpointer user_data)
{
	OptionsFaac_combobox_faac_set_choice_vbr_abr_realize (widget);
}
void on_combobox_faac_set_choice_vbr_abr_changed (GtkComboBox *combobox, gpointer user_data)
{
	OptionsFaac_combobox_faac_set_choice_vbr_abr_changed ();
}

/*
*---------------------------------------------------------------------------
* FENETRE DE LECTURE
*---------------------------------------------------------------------------
*/

gboolean on_wind_lecture_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (WinPlay_wind_lecture_delete_event ());
}
gboolean on_wind_lecture_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (WinPlay_wind_lecture_destroy_event ());
}
void on_button_lecture_clicked (GtkButton *button, gpointer user_data)
{
	WinPlay_button_lecture_clicked (button);
}
void on_label_lecture_namefile_realize (GtkWidget *widget, gpointer user_data)
{
	VarLecture.AdrLabelNameFile = widget;
}
void on_hbox_lecture_realize (GtkWidget *widget, gpointer user_data)
{
	WinPlay_hbox_lecture_realize (widget);
}
void on_label_statusbar_lecture_realize (GtkWidget *widget, gpointer user_data)
{
	VarLecture.AdrStatusBar = widget;
}

void on_combobox_normalise_cd_realize (GtkWidget *widget, gpointer user_data)
{
	cdaudio_combobox_normalise_cd_realize (widget);
}
void on_combobox_normalise_cd_changed (GtkComboBox *combobox, gpointer user_data)
{
	cdaudio_combobox_normalise_cd_changed ();
}
void on_combobox_normalise_dvd_realize (GtkWidget *widget, gpointer user_data)
{
	dvdaudio_combobox_normalise_dvd_realize (widget);
}

void on_radiobutton_ioctl_clicked (GtkButton *button, gpointer user_data)
{
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_ioctl)) == TRUE) {
		/*gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_cue_creation_from_cd")), FALSE);*/
	}
}

/* SIMPLIFICATION DE LA NORMALISATION SELON @Dzef
*/
void on_combobox_normalise_file_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_normalise_file_realize (widget);
}
void on_combobox_normalise_file_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_normalise_file_changed ();
}
void on_spinbutton_choix_niveau_file_realize (GtkWidget *widget, gpointer user_data)
{
	var_file.AdrSpinbuttonNormalise = GTK_SPIN_BUTTON (widget);
	gtk_spin_button_set_value (var_file.AdrSpinbuttonNormalise, -10);
}
void on_spinbutton_choix_niveau_file_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	file_spinbutton_choix_niveau_file_value_changed ();
}

/* SPLIT REALIZE
*/

void on_scrolledwindow_file_split_realize (GtkWidget *widget, gpointer user_data)
{
	split_scrolledwindow_file_split_realize (widget);
}

void on_combobox_dest_split_realize (GtkWidget *widget, gpointer user_data)
{
	split_combobox_dest_split_realize (widget);
}

/* SPLIT CHANGED
*/

void on_combobox_dest_split_changed (GtkComboBox *combobox, gpointer user_data)
{
	split_combobox_dest_split_changed ();
}


/* SPLIT REALIZE
*/

void on_button_lecture_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrButtonPlay = widget;
	if (VarSplit.AdrButtonStop != NULL) {
		gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
		gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
	}
}
void on_button_stop_lecture_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrButtonStop = widget;
	/*gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), FALSE);*/
}

/* SPLIT CLICKED
*/

void on_button_lecture_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_lecture_split_clicked ();
}
void on_button_stop_lecture_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_stop_lecture_split_clicked ();
}



void on_button_ajouter_tache_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_ajouter_tache_clicked ();
}
void on_button_importer_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_importer_split_clicked ();
}
void on_button_action_split_clicked (GtkButton *button, gpointer user_data)
{
	splitaction_button_clicked ();
}
void on_checkbutton_creation_fichier_cue_clicked (GtkButton *button, gpointer user_data)
{
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (button)) == TRUE)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_creation_fichier_unique_cue")), TRUE);
}
void on_checkbutton_creation_fichier_unique_cue_clicked (GtkButton *button, gpointer user_data)
{
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (button)) == FALSE)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_creation_fichier_cue")), FALSE);
}

/* Nettoyer FICHIERS ****************/
void on_button_remove_file_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_remove_file_split_clicked ();
}
void on_button_nettoyer_tout_split_clicked (GtkButton *button, gpointer user_data)
{
	split_button_remove_all_file_split_clicked ();
}
/*****************/


/* SPLIT EVENT*/

void on_spinbutton_secondes_mark_A_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrSpinbuttonSecondesDebut = GTK_SPIN_BUTTON(widget);
}
void on_spinbutton_secondes_mark_B_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrSpinbuttonSecondesFin = GTK_SPIN_BUTTON(widget);
}
void on_spinbutton_centiemes_mark_A_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrSpinbuttonCentiemeDebut = GTK_SPIN_BUTTON(widget);
}
void on_spinbutton_centiemes_mark_B_split_realize (GtkWidget *widget, gpointer user_data)
{
	VarSplit.AdrSpinbuttonCentiemeFin = GTK_SPIN_BUTTON(widget);
}


void on_spinbutton_secondes_mark_A_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	split_spinbutton_set_mark_A_split_value_changed ();
}
void on_spinbutton_centiemes_mark_A_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	split_spinbutton_set_mark_A_split_value_changed ();
}
void on_spinbutton_secondes_mark_B_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	split_spinbutton_set_mark_B_split_value_changed ();
}
void on_spinbutton_centiemes_mark_B_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	split_spinbutton_set_mark_B_split_value_changed ();
}

void on_image_button_coller_mark_A_split_realize (GtkWidget *widget, gpointer user_data)
{
	gchar *LineCommand = NULL;

	LineCommand = g_strdup_printf ("%s", utils_get_pathname ("markA.png"));
	gtk_image_set_from_file (GTK_IMAGE(widget), LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
}
void on_image_button_coller_mark_B_split_realize (GtkWidget *widget, gpointer user_data)
{
	gchar *LineCommand = NULL;

	LineCommand = g_strdup_printf ("%s", utils_get_pathname ("markB.png"));
	gtk_image_set_from_file (GTK_IMAGE(widget), LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
}



/* PRODUCTION DE FICHIER UNIQUE ET DE FICHIER CUE
*/

void on_combobox_choice_file_cue_realize (GtkWidget *widget, gpointer user_data)
{
	utils_clear_elements_combobox (widget);
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "WAV");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "FLAC");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "OGG");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "MPC");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}

void on_button_cue_creation_from_cd_clicked (GtkButton *button, gpointer user_data)
{
	cdcue_button_cue_creation_from_cd_clicked ();
}
void on_entry_name_fichier_unique_cue_changed (GtkEditable *editable, gpointer user_data)
{
	cdcue_entry_name_fichier_unique_cue_changed ();
}
void on_entry_name_fichier_unique_cue_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_name_file_cue = widget;
}




/* WININFO
*/
gboolean on_wind_choice_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (windchoice_delete_event ());
}
gboolean on_wind_choice_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return (windchoice_destroy_event ());
}
void on_button_cancel_wind_choice_clicked (GtkButton *button, gpointer user_data)
{
	windchoice_button_cancel_wind_choice_clicked ();
}
void on_button_ok_wind_choice_clicked (GtkButton *button, gpointer user_data)
{
	windchoice_button_ok_wind_choice_clicked ();
}





void on_notebook_expander_cd_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (Config_User.Bool_Config_Ok)
		Config_User.notebook_expander_cd = page_num;
}


void on_button_eject_cd_clicked (GtkButton *button, gpointer user_data)
{
	cdaudiotoc_button_eject_cd_clicked ();
}


void on_button_eject_dvd_clicked (GtkButton *button, gpointer user_data)
{
	dvdaudio_button_eject_dvd_clicked ();
}





void on_combobox_accplusenc_stereo_realize (GtkWidget *widget, gpointer user_data)
{
	optionsaacplusenc_combobox_accplusenc_stereo_realize (widget);
}
void on_combobox_accplusenc_mono_realize (GtkWidget *widget, gpointer user_data)
{
	optionsaacplusenc_combobox_accplusenc_mono_realize (widget);
}




void on_combobox_lame_type_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_lame_type_bitrate_mp3ogg_realize (widget);
}
void on_combobox_lame_mode_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_lame_mode_mp3ogg_realize (widget);
}
void on_combobox_lame_abr_cbr_vbr_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_lame_abr_cbr_vbr_mp3ogg_realize (widget);
}
void on_combobox_oggenc_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_oggenc_bitrate_mp3ogg_realize (widget);
}
void on_combobox_oggenc_managed_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_oggenc_managed_mp3ogg_realize (widget);
}
void on_combobox_oggenc_downmix_m3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	file_combobox_oggenc_downmix_m3ogg_realize (widget);
}




void on_combobox_lame_abr_cbr_vbr_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_lame_abr_cbr_vbr_mp3ogg_changed ();
}
void on_combobox_lame_type_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_lame_type_bitrate_mp3ogg_changed ();
}
void on_combobox_lame_mode_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_lame_mode_mp3ogg_changed ();
}


void on_combobox_oggenc_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_oggenc_bitrate_mp3ogg_changed ();
}
void on_combobox_oggenc_managed_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_oggenc_managed_mp3ogg_changed ();
}
void on_combobox_oggenc_downmix_m3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	file_combobox_oggenc_downmix_m3ogg_changed ();
}



void on_scrolledwindow_applications_audio_realize (GtkWidget *widget, gpointer user_data)
{
	prgaudio_make_scrolledwindow (widget);
}
void on_button_add_audio_realize (GtkWidget *widget, gpointer user_data)
{
	VarPrgAudio.Adr_button_add_audio = widget;
}
void on_entry_name_audio_realize (GtkWidget *widget, gpointer user_data)
{
	VarPrgAudio.Adr_entry_name_audio = widget;
}
void on_button_del_audio_realize (GtkWidget *widget, gpointer user_data)
{
	VarPrgAudio.Adr_button_del_audio = widget;
}
void on_entry_name_audio_changed (GtkEditable *editable, gpointer user_data)
{
	prgaudio_entry_name_audio_changed ();
}
void on_button_add_audio_clicked (GtkButton *button, gpointer user_data)
{
	prgaudio_button_add_audio_clicked ();
}
void on_button_del_audio_clicked (GtkButton *button, gpointer user_data)
{
	prgaudio_button_del_audio_clicked ();
}


void on_button_copy_commentaire_clicked (GtkButton *button, gpointer user_data)
{
	cdexpander_entry_copy_tag_commentaire ();
}
void on_button_paste_comment_clicked (GtkButton *button, gpointer user_data)
{
	cdexpander_entry_paste_tag_commentaire ();
}


/* NOUVEAU WIDGET SPLIT
*/

GtkWidget *splitshuttle_create (gchar *widget_name, gchar *string1, gchar *string2, gint int1, gint int2)
{
	return (splitshuttle_new ());
}

void on_checkbutton_contour_split_clicked (GtkButton *button, gpointer user_data)
{
	splitshuttle_force_redraw ();
}

