<?php

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.13
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

// Try to load our extension if it's not already loaded.
if (!extension_loaded('xapian')) {
  if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
    if (!dl('php_xapian.dll')) return;
  } else {
    // PHP_SHLIB_SUFFIX gives 'dylib' on MacOS X but modules are 'so'.
    if (PHP_SHLIB_SUFFIX === 'dylib') {
      if (!dl('xapian.so')) return;
    } else {
      if (!dl('xapian.'.PHP_SHLIB_SUFFIX)) return;
    }
  }
}



abstract class Xapian {
	static function version_string() {
		return version_string();
	}

	static function major_version() {
		return major_version();
	}

	static function minor_version() {
		return minor_version();
	}

	static function revision() {
		return revision();
	}

	const BAD_VALUENO = BAD_VALUENO;

	const DB_CREATE = DB_CREATE;

	const DB_CREATE_OR_OPEN = DB_CREATE_OR_OPEN;

	const DB_CREATE_OR_OVERWRITE = DB_CREATE_OR_OVERWRITE;

	const DB_OPEN = DB_OPEN;

	const DB_NO_SYNC = DB_NO_SYNC;

	const DB_FULL_SYNC = DB_FULL_SYNC;

	const DB_DANGEROUS = DB_DANGEROUS;

	const DB_NO_TERMLIST = DB_NO_TERMLIST;

	const DB_BACKEND_CHERT = DB_BACKEND_CHERT;

	const DB_BACKEND_GLASS = DB_BACKEND_GLASS;

	const DB_BACKEND_INMEMORY = DB_BACKEND_INMEMORY;

	const DB_BACKEND_STUB = DB_BACKEND_STUB;

	const DB_RETRY_LOCK = DB_RETRY_LOCK;

	const DBCHECK_SHORT_TREE = DBCHECK_SHORT_TREE;

	const DBCHECK_FULL_TREE = DBCHECK_FULL_TREE;

	const DBCHECK_SHOW_FREELIST = DBCHECK_SHOW_FREELIST;

	const DBCHECK_SHOW_STATS = DBCHECK_SHOW_STATS;

	const DBCHECK_FIX = DBCHECK_FIX;

	const DBCOMPACT_MULTIPASS = DBCOMPACT_MULTIPASS;

	const DBCOMPACT_NO_RENUMBER = DBCOMPACT_NO_RENUMBER;

	const DBCOMPACT_SINGLE_FILE = DBCOMPACT_SINGLE_FILE;

	const DOC_ASSUME_VALID = DOC_ASSUME_VALID;

	const RP_SUFFIX = RP_SUFFIX;

	const RP_REPEATED = RP_REPEATED;

	const RP_DATE_PREFER_MDY = RP_DATE_PREFER_MDY;

	static function sortable_serialise($value) {
		return sortable_serialise($value);
	}

	static function sortable_unserialise($serialised) {
		return sortable_unserialise($serialised);
	}

	static function miles_to_metres($miles) {
		return miles_to_metres($miles);
	}

	static function metres_to_miles($metres) {
		return metres_to_miles($metres);
	}

	static function auto_open_stub($file,$action=null) {
		switch (func_num_args()) {
		case 1: $r=auto_open_stub($file); break;
		default: $r=auto_open_stub($file,$action);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_Xapian__WritableDatabase': return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function inmemory_open() {
		$r=inmemory_open();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianWritableDatabase($r);
		}
		return $r;
	}

	static function chert_open($dir,$action=null,$block_size=0) {
		switch (func_num_args()) {
		case 1: $r=chert_open($dir); break;
		default: $r=chert_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_Xapian__WritableDatabase': return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function remote_open($host_or_program,$port_or_args,$timeout=null,$connect_timeout=null) {
		switch (func_num_args()) {
		case 2: $r=remote_open($host_or_program,$port_or_args); break;
		case 3: $r=remote_open($host_or_program,$port_or_args,$timeout); break;
		default: $r=remote_open($host_or_program,$port_or_args,$timeout,$connect_timeout);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDatabase($r);
		}
		return $r;
	}

	static function remote_open_writable($host_or_program,$port_or_args,$timeout=null,$connect_timeout_or_flags=null,$flags=null) {
		switch (func_num_args()) {
		case 2: $r=remote_open_writable($host_or_program,$port_or_args); break;
		case 3: $r=remote_open_writable($host_or_program,$port_or_args,$timeout); break;
		case 4: $r=remote_open_writable($host_or_program,$port_or_args,$timeout,$connect_timeout_or_flags); break;
		default: $r=remote_open_writable($host_or_program,$port_or_args,$timeout,$connect_timeout_or_flags,$flags);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianWritableDatabase($r);
		}
		return $r;
	}

	static function BAD_VALUENO_get() {
		return BAD_VALUENO_get();
	}
}

/* PHP Proxy Classes */
class XapianPositionIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__PositionIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_PositionIterator();
	}

	function skip_to($termpos) {
		PositionIterator_skip_to($this->_cPtr,$termpos);
	}

	function get_description() {
		return PositionIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=PositionIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function current() {
		return PositionIterator_current($this->_cPtr);
	}

	function valid() {
		return PositionIterator_valid($this->_cPtr);
	}

	function rewind() {
		PositionIterator_rewind($this->_cPtr);
	}

	function equals(XapianPositionIterator $o) {
		return PositionIterator_equals($this->_cPtr,$o);
	}

	function get_termpos() {
		return PositionIterator_get_termpos($this->_cPtr);
	}

	function next() {
		PositionIterator_next($this->_cPtr);
	}
}

class XapianPostingIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__PostingIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_PostingIterator();
	}

	function get_wdf() {
		return PostingIterator_get_wdf($this->_cPtr);
	}

	function get_doclength() {
		return PostingIterator_get_doclength($this->_cPtr);
	}

	function get_unique_terms() {
		return PostingIterator_get_unique_terms($this->_cPtr);
	}

	function positionlist_begin() {
		$r=PostingIterator_positionlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end() {
		$r=PostingIterator_positionlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function skip_to($did) {
		PostingIterator_skip_to($this->_cPtr,$did);
	}

	function get_description() {
		return PostingIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=PostingIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPostingIterator($r);
		}
		return $r;
	}

	function current() {
		return PostingIterator_current($this->_cPtr);
	}

	function valid() {
		return PostingIterator_valid($this->_cPtr);
	}

	function rewind() {
		PostingIterator_rewind($this->_cPtr);
	}

	function equals(XapianPostingIterator $o) {
		return PostingIterator_equals($this->_cPtr,$o);
	}

	function get_docid() {
		return PostingIterator_get_docid($this->_cPtr);
	}

	function next() {
		PostingIterator_next($this->_cPtr);
	}
}

class XapianTermIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__TermIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_TermIterator();
	}

	function get_wdf() {
		return TermIterator_get_wdf($this->_cPtr);
	}

	function get_termfreq() {
		return TermIterator_get_termfreq($this->_cPtr);
	}

	function positionlist_count() {
		return TermIterator_positionlist_count($this->_cPtr);
	}

	function positionlist_begin() {
		$r=TermIterator_positionlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end() {
		$r=TermIterator_positionlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function skip_to($term) {
		TermIterator_skip_to($this->_cPtr,$term);
	}

	function get_description() {
		return TermIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=TermIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function current() {
		return TermIterator_current($this->_cPtr);
	}

	function valid() {
		return TermIterator_valid($this->_cPtr);
	}

	function rewind() {
		TermIterator_rewind($this->_cPtr);
	}

	function equals(XapianTermIterator $o) {
		return TermIterator_equals($this->_cPtr,$o);
	}

	function get_term() {
		return TermIterator_get_term($this->_cPtr);
	}

	function next() {
		TermIterator_next($this->_cPtr);
	}
}

class XapianValueIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ValueIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_ValueIterator();
	}

	function get_docid() {
		return ValueIterator_get_docid($this->_cPtr);
	}

	function get_valueno() {
		return ValueIterator_get_valueno($this->_cPtr);
	}

	function skip_to($docid_or_slot) {
		ValueIterator_skip_to($this->_cPtr,$docid_or_slot);
	}

	function check($docid) {
		return ValueIterator_check($this->_cPtr,$docid);
	}

	function get_description() {
		return ValueIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=ValueIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function current() {
		return ValueIterator_current($this->_cPtr);
	}

	function valid() {
		return ValueIterator_valid($this->_cPtr);
	}

	function rewind() {
		ValueIterator_rewind($this->_cPtr);
	}

	function equals(XapianValueIterator $o) {
		return ValueIterator_equals($this->_cPtr,$o);
	}

	function get_value() {
		return ValueIterator_get_value($this->_cPtr);
	}

	function next() {
		ValueIterator_next($this->_cPtr);
	}
}

class XapianDocument {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Document') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_Document();
	}

	function get_value($slot) {
		return Document_get_value($this->_cPtr,$slot);
	}

	function add_value($slot,$value) {
		Document_add_value($this->_cPtr,$slot,$value);
	}

	function remove_value($slot) {
		Document_remove_value($this->_cPtr,$slot);
	}

	function clear_values() {
		Document_clear_values($this->_cPtr);
	}

	function get_data() {
		return Document_get_data($this->_cPtr);
	}

	function set_data($data) {
		Document_set_data($this->_cPtr,$data);
	}

	function add_posting($tname,$tpos,$wdfinc=1) {
		Document_add_posting($this->_cPtr,$tname,$tpos,$wdfinc);
	}

	function add_term($tname,$wdfinc=1) {
		Document_add_term($this->_cPtr,$tname,$wdfinc);
	}

	function add_boolean_term($term) {
		Document_add_boolean_term($this->_cPtr,$term);
	}

	function remove_posting($tname,$tpos,$wdfdec=1) {
		Document_remove_posting($this->_cPtr,$tname,$tpos,$wdfdec);
	}

	function remove_postings($term,$term_pos_first,$term_pos_last,$wdf_dec=1) {
		return Document_remove_postings($this->_cPtr,$term,$term_pos_first,$term_pos_last,$wdf_dec);
	}

	function remove_term($tname) {
		Document_remove_term($this->_cPtr,$tname);
	}

	function clear_terms() {
		Document_clear_terms($this->_cPtr);
	}

	function termlist_count() {
		return Document_termlist_count($this->_cPtr);
	}

	function termlist_begin() {
		$r=Document_termlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function termlist_end() {
		$r=Document_termlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function values_count() {
		return Document_values_count($this->_cPtr);
	}

	function values_begin() {
		$r=Document_values_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function values_end() {
		$r=Document_values_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function get_docid() {
		return Document_get_docid($this->_cPtr);
	}

	function serialise() {
		return Document_serialise($this->_cPtr);
	}

	static function unserialise($serialised) {
		$r=Document_unserialise($serialised);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_description() {
		return Document_get_description($this->_cPtr);
	}
}

class XapianRegistry {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Registry') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_Registry();
	}

	function register_weighting_scheme(XapianWeight $wt) {
		Registry_register_weighting_scheme($this->_cPtr,$wt);
	}

	function get_weighting_scheme($name) {
		$r=Registry_get_weighting_scheme($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}

	function register_posting_source(XapianPostingSource $source) {
		Registry_register_posting_source($this->_cPtr,$source);
	}

	function get_posting_source($name) {
		$r=Registry_get_posting_source($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}

	function register_match_spy(XapianMatchSpy $spy) {
		Registry_register_match_spy($this->_cPtr,$spy);
	}

	function get_match_spy($name) {
		$r=Registry_get_match_spy($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}

	function register_lat_long_metric($metric) {
		Registry_register_lat_long_metric($this->_cPtr,$metric);
	}

	function get_lat_long_metric($name) {
		$r=Registry_get_lat_long_metric($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianQuery {
	public $_ps=null;
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	static function MatchNothing() {
		$r=Query_MatchNothing_get();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	static function MatchAll() {
		$r=Query_MatchAll_get();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	const OP_AND = 0;

	const OP_OR = 1;

	const OP_AND_NOT = 2;

	const OP_XOR = 3;

	const OP_AND_MAYBE = 4;

	const OP_FILTER = 5;

	const OP_NEAR = 6;

	const OP_PHRASE = 7;

	const OP_VALUE_RANGE = 8;

	const OP_SCALE_WEIGHT = 9;

	const OP_ELITE_SET = 10;

	const OP_VALUE_GE = 11;

	const OP_VALUE_LE = 12;

	const OP_SYNONYM = 13;

	const OP_MAX = 14;

	const OP_WILDCARD = 15;

	const OP_INVALID = 99;

	const WILDCARD_LIMIT_ERROR = 0;

	const WILDCARD_LIMIT_FIRST = Query_WILDCARD_LIMIT_FIRST;

	const WILDCARD_LIMIT_MOST_FREQUENT = Query_WILDCARD_LIMIT_MOST_FREQUENT;

	function get_terms_begin() {
		$r=Query_get_terms_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_terms_end() {
		$r=Query_get_terms_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_unique_terms_begin() {
		$r=Query_get_unique_terms_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_length() {
		return Query_get_length($this->_cPtr);
	}

	function is_empty() {
		return Query_is_empty($this->_cPtr);
	}

	function serialise() {
		return Query_serialise($this->_cPtr);
	}

	static function unserialise($serialised,$reg=null) {
		switch (func_num_args()) {
		case 1: $r=Query_unserialise($serialised); break;
		default: $r=Query_unserialise($serialised,$reg);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function get_type() {
		return Query_get_type($this->_cPtr);
	}

	function get_num_subqueries() {
		return Query_get_num_subqueries($this->_cPtr);
	}

	function get_subquery($n) {
		$r=Query_get_subquery($this->_cPtr,$n);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function get_description() {
		return Query_get_description($this->_cPtr);
	}

	function __construct($term_or_source_or_factor_or_op_=null,$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin=null,$pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter=null,$range_upper_or_max_type=null,$combiner=null) {
		if ($term_or_source_or_factor_or_op_ instanceof XapianPostingSource) {
			$this->_ps[]=$term_or_source_or_factor_or_op_;
		} else if (is_array($wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin)) {
			foreach ($wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin as $xxx) {
				if ($xxx instanceof XapianQuery) $this->_ps[]=$xxx->_ps;
			}
		} else {
			if ($term_or_source_or_factor_or_op_ instanceof XapianQuery) $this->_ps[]=$term_or_source_or_factor_or_op_->_ps;
			if ($wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin instanceof XapianQuery) $this->_ps[]=$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin->_ps;
			if ($pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter instanceof XapianQuery) $this->_ps[]=$pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter->_ps;
		}
		if (is_resource($term_or_source_or_factor_or_op_) && get_resource_type($term_or_source_or_factor_or_op_) === '_p_Xapian__Query') {
			$this->_cPtr=$term_or_source_or_factor_or_op_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Query(); break;
		case 1: $this->_cPtr=new_Query($term_or_source_or_factor_or_op_); break;
		case 2: $this->_cPtr=new_Query($term_or_source_or_factor_or_op_,$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin); break;
		case 3: $this->_cPtr=new_Query($term_or_source_or_factor_or_op_,$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin,$pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter); break;
		case 4: $this->_cPtr=new_Query($term_or_source_or_factor_or_op_,$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin,$pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter,$range_upper_or_max_type); break;
		default: $this->_cPtr=new_Query($term_or_source_or_factor_or_op_,$wqf_or_subquery_or_a_or_slot_or_pattern_or_qbegin,$pos_or_factor_or_b_or_range_limit_or_range_lower_or_max_expansion_or_parameter,$range_upper_or_max_type,$combiner);
		}
	}
}

abstract class XapianStemImplementation {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__StemImplementation') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianStemImplementation') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_StemImplementation($_this);
	}

	function apply($word) {
		return StemImplementation_apply($this->_cPtr,$word);
	}

	function get_description() {
		return StemImplementation_get_description($this->_cPtr);
	}
}

class XapianStem {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($language_or_p) {
		if (is_resource($language_or_p) && get_resource_type($language_or_p) === '_p_Xapian__Stem') {
			$this->_cPtr=$language_or_p;
			return;
		}
		$this->_cPtr=new_Stem($language_or_p);
	}

	function apply($word) {
		return Stem_apply($this->_cPtr,$word);
	}

	function get_description() {
		return Stem_get_description($this->_cPtr);
	}

	static function get_available_languages() {
		return Stem_get_available_languages();
	}
}

class XapianTermGenerator {
	protected $_stopper=null;
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__TermGenerator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_TermGenerator();
	}

	function set_stemmer(XapianStem $stemmer) {
		TermGenerator_set_stemmer($this->_cPtr,$stemmer);
	}

	function set_stopper(XapianStopper $stop=null) {
		$this->_stopper=$stop;
		TermGenerator_set_stopper($this->_cPtr,$stop);
	}

	function set_document(XapianDocument $doc) {
		TermGenerator_set_document($this->_cPtr,$doc);
	}

	function get_document() {
		$r=TermGenerator_get_document($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function set_database(XapianDatabase $db) {
		TermGenerator_set_database($this->_cPtr,$db);
	}

	const FLAG_SPELLING = 128;

	const FLAG_CJK_NGRAM = 2048;

	const STEM_NONE = 0;

	const STEM_SOME = TermGenerator_STEM_SOME;

	const STEM_ALL = TermGenerator_STEM_ALL;

	const STEM_ALL_Z = TermGenerator_STEM_ALL_Z;

	const STEM_SOME_FULL_POS = TermGenerator_STEM_SOME_FULL_POS;

	const STOP_NONE = 0;

	const STOP_ALL = TermGenerator_STOP_ALL;

	const STOP_STEMMED = TermGenerator_STOP_STEMMED;

	function set_flags($toggle,$mask=null) {
		switch (func_num_args()) {
		case 1: $r=TermGenerator_set_flags($this->_cPtr,$toggle); break;
		default: $r=TermGenerator_set_flags($this->_cPtr,$toggle,$mask);
		}
		return $r;
	}

	function set_stemming_strategy($strategy) {
		TermGenerator_set_stemming_strategy($this->_cPtr,$strategy);
	}

	function set_stopper_strategy($strategy) {
		TermGenerator_set_stopper_strategy($this->_cPtr,$strategy);
	}

	function set_max_word_length($max_word_length) {
		TermGenerator_set_max_word_length($this->_cPtr,$max_word_length);
	}

	function index_text($text,$wdf_inc=1,$prefix=null) {
		switch (func_num_args()) {
		case 1: case 2: TermGenerator_index_text($this->_cPtr,$text,$wdf_inc); break;
		default: TermGenerator_index_text($this->_cPtr,$text,$wdf_inc,$prefix);
		}
	}

	function index_text_without_positions($text,$wdf_inc=1,$prefix=null) {
		switch (func_num_args()) {
		case 1: case 2: TermGenerator_index_text_without_positions($this->_cPtr,$text,$wdf_inc); break;
		default: TermGenerator_index_text_without_positions($this->_cPtr,$text,$wdf_inc,$prefix);
		}
	}

	function increase_termpos($delta=100) {
		TermGenerator_increase_termpos($this->_cPtr,$delta);
	}

	function get_termpos() {
		return TermGenerator_get_termpos($this->_cPtr);
	}

	function set_termpos($termpos) {
		TermGenerator_set_termpos($this->_cPtr,$termpos);
	}

	function get_description() {
		return TermGenerator_get_description($this->_cPtr);
	}
}

class XapianMSet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MSet') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_MSet();
	}

	function convert_to_percent($weight_or_it) {
		return MSet_convert_to_percent($this->_cPtr,$weight_or_it);
	}

	function get_termfreq($term) {
		return MSet_get_termfreq($this->_cPtr,$term);
	}

	function get_termweight($term) {
		return MSet_get_termweight($this->_cPtr,$term);
	}

	function get_firstitem() {
		return MSet_get_firstitem($this->_cPtr);
	}

	function get_matches_lower_bound() {
		return MSet_get_matches_lower_bound($this->_cPtr);
	}

	function get_matches_estimated() {
		return MSet_get_matches_estimated($this->_cPtr);
	}

	function get_matches_upper_bound() {
		return MSet_get_matches_upper_bound($this->_cPtr);
	}

	function get_uncollapsed_matches_lower_bound() {
		return MSet_get_uncollapsed_matches_lower_bound($this->_cPtr);
	}

	function get_uncollapsed_matches_estimated() {
		return MSet_get_uncollapsed_matches_estimated($this->_cPtr);
	}

	function get_uncollapsed_matches_upper_bound() {
		return MSet_get_uncollapsed_matches_upper_bound($this->_cPtr);
	}

	function get_max_attained() {
		return MSet_get_max_attained($this->_cPtr);
	}

	function get_max_possible() {
		return MSet_get_max_possible($this->_cPtr);
	}

	const SNIPPET_BACKGROUND_MODEL = 1;

	const SNIPPET_EXHAUSTIVE = 2;

	const SNIPPET_EMPTY_WITHOUT_MATCH = 4;

	function snippet($text,$length=null,$stemmer=null,$flags=null,$hi_start=null,$hi_end=null,$omit=null) {
		switch (func_num_args()) {
		case 1: $r=MSet_snippet($this->_cPtr,$text); break;
		case 2: $r=MSet_snippet($this->_cPtr,$text,$length); break;
		case 3: $r=MSet_snippet($this->_cPtr,$text,$length,$stemmer); break;
		case 4: $r=MSet_snippet($this->_cPtr,$text,$length,$stemmer,$flags); break;
		case 5: $r=MSet_snippet($this->_cPtr,$text,$length,$stemmer,$flags,$hi_start); break;
		case 6: $r=MSet_snippet($this->_cPtr,$text,$length,$stemmer,$flags,$hi_start,$hi_end); break;
		default: $r=MSet_snippet($this->_cPtr,$text,$length,$stemmer,$flags,$hi_start,$hi_end,$omit);
		}
		return $r;
	}

	function fetch($begin_or_item=null,$end=null) {
		switch (func_num_args()) {
		case 0: MSet_fetch($this->_cPtr); break;
		case 1: MSet_fetch($this->_cPtr,$begin_or_item); break;
		default: MSet_fetch($this->_cPtr,$begin_or_item,$end);
		}
	}

	function size() {
		return MSet_size($this->_cPtr);
	}

	function is_empty() {
		return MSet_is_empty($this->_cPtr);
	}

	function begin() {
		$r=MSet_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function end() {
		$r=MSet_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function back() {
		$r=MSet_back($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function get_description() {
		return MSet_get_description($this->_cPtr);
	}

	function get_docid($i) {
		return MSet_get_docid($this->_cPtr,$i);
	}

	function get_document($i) {
		$r=MSet_get_document($this->_cPtr,$i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_hit($i) {
		$r=MSet_get_hit($this->_cPtr,$i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function get_document_percentage($i) {
		return MSet_get_document_percentage($this->_cPtr,$i);
	}
}

class XapianMSetIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'off_from_end') return MSetIterator_off_from_end_set($this->_cPtr,$value);
		if ($var === 'mset') return MSetIterator_mset_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'mset') return new XapianMSet(MSetIterator_mset_get($this->_cPtr));
		if ($var === 'off_from_end') return MSetIterator_off_from_end_get($this->_cPtr);
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('MSetIterator_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MSetIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_MSetIterator();
	}

	function get_rank() {
		return MSetIterator_get_rank($this->_cPtr);
	}

	function get_document() {
		$r=MSetIterator_get_document($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_weight() {
		return MSetIterator_get_weight($this->_cPtr);
	}

	function get_collapse_key() {
		return MSetIterator_get_collapse_key($this->_cPtr);
	}

	function get_collapse_count() {
		return MSetIterator_get_collapse_count($this->_cPtr);
	}

	function get_sort_key() {
		return MSetIterator_get_sort_key($this->_cPtr);
	}

	function get_percent() {
		return MSetIterator_get_percent($this->_cPtr);
	}

	function get_description() {
		return MSetIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=MSetIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function current() {
		return MSetIterator_current($this->_cPtr);
	}

	function valid() {
		return MSetIterator_valid($this->_cPtr);
	}

	function rewind() {
		MSetIterator_rewind($this->_cPtr);
	}

	function equals(XapianMSetIterator $o) {
		return MSetIterator_equals($this->_cPtr,$o);
	}

	function get_docid() {
		return MSetIterator_get_docid($this->_cPtr);
	}

	function next() {
		MSetIterator_next($this->_cPtr);
	}

	function prev() {
		MSetIterator_prev($this->_cPtr);
	}
}

class XapianESet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ESet') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_ESet();
	}

	function size() {
		return ESet_size($this->_cPtr);
	}

	function is_empty() {
		return ESet_is_empty($this->_cPtr);
	}

	function get_ebound() {
		return ESet_get_ebound($this->_cPtr);
	}

	function begin() {
		$r=ESet_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function end() {
		$r=ESet_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function back() {
		$r=ESet_back($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function get_description() {
		return ESet_get_description($this->_cPtr);
	}
}

class XapianESetIterator implements Iterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'off_from_end') return ESetIterator_off_from_end_set($this->_cPtr,$value);
		if ($var === 'eset') return ESetIterator_eset_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'eset') return new XapianESet(ESetIterator_eset_get($this->_cPtr));
		if ($var === 'off_from_end') return ESetIterator_off_from_end_get($this->_cPtr);
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('ESetIterator_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ESetIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_ESetIterator();
	}

	function get_weight() {
		return ESetIterator_get_weight($this->_cPtr);
	}

	function get_description() {
		return ESetIterator_get_description($this->_cPtr);
	}

	function key() {
		$r=ESetIterator_key($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function current() {
		return ESetIterator_current($this->_cPtr);
	}

	function valid() {
		return ESetIterator_valid($this->_cPtr);
	}

	function rewind() {
		ESetIterator_rewind($this->_cPtr);
	}

	function equals(XapianESetIterator $o) {
		return ESetIterator_equals($this->_cPtr,$o);
	}

	function get_term() {
		return ESetIterator_get_term($this->_cPtr);
	}

	function next() {
		ESetIterator_next($this->_cPtr);
	}

	function prev() {
		ESetIterator_prev($this->_cPtr);
	}
}

class XapianRSet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__RSet') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_RSet();
	}

	function size() {
		return RSet_size($this->_cPtr);
	}

	function is_empty() {
		return RSet_is_empty($this->_cPtr);
	}

	function add_document($did_or_i) {
		RSet_add_document($this->_cPtr,$did_or_i);
	}

	function remove_document($did_or_i) {
		RSet_remove_document($this->_cPtr,$did_or_i);
	}

	function contains($did_or_i) {
		return RSet_contains($this->_cPtr,$did_or_i);
	}

	function get_description() {
		return RSet_get_description($this->_cPtr);
	}
}

abstract class XapianMatchDecider {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MatchDecider') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianMatchDecider') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_MatchDecider($_this);
	}

	function apply($doc) {
		return MatchDecider_apply($this->_cPtr,$doc);
	}
}

class XapianEnquire {
	protected $_ps=null;
	protected $_sorter=null;
	protected $_spies=null;
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($database) {
		if (is_resource($database) && get_resource_type($database) === '_p_Xapian__Enquire') {
			$this->_cPtr=$database;
			return;
		}
		$this->_cPtr=new_Enquire($database);
	}

	function set_query(XapianQuery $query,$qlen=0) {
		$this->_ps=$query->_ps;
		Enquire_set_query($this->_cPtr,$query,$qlen);
	}

	function get_query() {
		$r=Enquire_get_query($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function add_matchspy(XapianMatchSpy $spy) {
		$this->_spies[]=$spy;
		Enquire_add_matchspy($this->_cPtr,$spy);
	}

	function clear_matchspies() {
		$this->_spies=null;
		Enquire_clear_matchspies($this->_cPtr);
	}

	function set_weighting_scheme(XapianWeight $weight_) {
		Enquire_set_weighting_scheme($this->_cPtr,$weight_);
	}

	function set_expansion_scheme($eweightname_,$expand_k_=1.0) {
		Enquire_set_expansion_scheme($this->_cPtr,$eweightname_,$expand_k_);
	}

	function set_collapse_key($collapse_key,$collapse_max=1) {
		Enquire_set_collapse_key($this->_cPtr,$collapse_key,$collapse_max);
	}

	const ASCENDING = 1;

	const DESCENDING = 0;

	const DONT_CARE = 2;

	function set_docid_order($order) {
		Enquire_set_docid_order($this->_cPtr,$order);
	}

	function set_cutoff($percent_cutoff,$weight_cutoff=0.0) {
		Enquire_set_cutoff($this->_cPtr,$percent_cutoff,$weight_cutoff);
	}

	function set_sort_by_relevance() {
		Enquire_set_sort_by_relevance($this->_cPtr);
	}

	function set_sort_by_value($sort_key,$reverse) {
		Enquire_set_sort_by_value($this->_cPtr,$sort_key,$reverse);
	}

	function set_sort_by_key(XapianKeyMaker $sorter,$reverse) {
		$this->_sorter=$sorter;
		Enquire_set_sort_by_key($this->_cPtr,$sorter,$reverse);
	}

	function set_sort_by_value_then_relevance($sort_key,$reverse) {
		Enquire_set_sort_by_value_then_relevance($this->_cPtr,$sort_key,$reverse);
	}

	function set_sort_by_key_then_relevance(XapianKeyMaker $sorter,$reverse) {
		$this->_sorter=$sorter;
		Enquire_set_sort_by_key_then_relevance($this->_cPtr,$sorter,$reverse);
	}

	function set_sort_by_relevance_then_value($sort_key,$reverse) {
		Enquire_set_sort_by_relevance_then_value($this->_cPtr,$sort_key,$reverse);
	}

	function set_sort_by_relevance_then_key(XapianKeyMaker $sorter,$reverse) {
		$this->_sorter=$sorter;
		Enquire_set_sort_by_relevance_then_key($this->_cPtr,$sorter,$reverse);
	}

	function set_time_limit($time_limit) {
		Enquire_set_time_limit($this->_cPtr,$time_limit);
	}

	function get_mset($first,$maxitems,$checkatleast_or_omrset=null,$omrset_or_mdecider=null,XapianMatchDecider $mdecider=null) {
		switch (func_num_args()) {
		case 2: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems); break;
		case 3: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset); break;
		case 4: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider); break;
		default: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider,$mdecider);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSet($r);
		}
		return $r;
	}

	const INCLUDE_QUERY_TERMS = Enquire_INCLUDE_QUERY_TERMS;

	const USE_EXACT_TERMFREQ = Enquire_USE_EXACT_TERMFREQ;

	function get_eset($maxitems,$omrset_or_rset,$flags_or_edecider=null,$edecider_or_k=null,$min_wt_or_edecider=null,$min_wt=null) {
		switch (func_num_args()) {
		case 2: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset_or_rset); break;
		case 3: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset_or_rset,$flags_or_edecider); break;
		case 4: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset_or_rset,$flags_or_edecider,$edecider_or_k); break;
		case 5: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset_or_rset,$flags_or_edecider,$edecider_or_k,$min_wt_or_edecider); break;
		default: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset_or_rset,$flags_or_edecider,$edecider_or_k,$min_wt_or_edecider,$min_wt);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESet($r);
		}
		return $r;
	}

	function get_matching_terms_begin($did_or_it) {
		$r=Enquire_get_matching_terms_begin($this->_cPtr,$did_or_it);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_matching_terms_end($arg1) {
		$r=Enquire_get_matching_terms_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_description() {
		return Enquire_get_description($this->_cPtr);
	}

	function get_matching_terms($item) {
		return Enquire_get_matching_terms($this->_cPtr,$item);
	}
}

abstract class XapianExpandDecider {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ExpandDecider') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianExpandDecider') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ExpandDecider($_this);
	}

	function apply($term) {
		return ExpandDecider_apply($this->_cPtr,$term);
	}

	function release() {
		$r=ExpandDecider_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianExpandDeciderAnd extends XapianExpandDecider {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianExpandDecider::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianExpandDecider::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianExpandDecider::__isset($var);
	}

	function __construct($first_,$second_) {
		if (is_resource($first_) && get_resource_type($first_) === '_p_Xapian__ExpandDeciderAnd') {
			$this->_cPtr=$first_;
			return;
		}
		$this->_cPtr=new_ExpandDeciderAnd($first_,$second_);
	}

	function apply($term) {
		return ExpandDeciderAnd_apply($this->_cPtr,$term);
	}
}

class XapianExpandDeciderFilterPrefix extends XapianExpandDecider {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianExpandDecider::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianExpandDecider::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianExpandDecider::__isset($var);
	}

	function __construct($prefix_) {
		if (is_resource($prefix_) && get_resource_type($prefix_) === '_p_Xapian__ExpandDeciderFilterPrefix') {
			$this->_cPtr=$prefix_;
			return;
		}
		$this->_cPtr=new_ExpandDeciderFilterPrefix($prefix_);
	}

	function apply($term) {
		return ExpandDeciderFilterPrefix_apply($this->_cPtr,$term);
	}
}

abstract class XapianKeyMaker {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__KeyMaker') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianKeyMaker') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_KeyMaker($_this);
	}

	function apply($doc) {
		return KeyMaker_apply($this->_cPtr,$doc);
	}

	function release() {
		$r=KeyMaker_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianMultiValueKeyMaker extends XapianKeyMaker {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianKeyMaker::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianKeyMaker::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianKeyMaker::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MultiValueKeyMaker') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_MultiValueKeyMaker();
	}

	function apply($doc) {
		return MultiValueKeyMaker_apply($this->_cPtr,$doc);
	}

	function add_value($slot,$reverse=false,$defvalue=null) {
		switch (func_num_args()) {
		case 1: case 2: MultiValueKeyMaker_add_value($this->_cPtr,$slot,$reverse); break;
		default: MultiValueKeyMaker_add_value($this->_cPtr,$slot,$reverse,$defvalue);
		}
	}
}

abstract class XapianStopper {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Stopper') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianStopper') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_Stopper($_this);
	}

	function apply($term) {
		return Stopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return Stopper_get_description($this->_cPtr);
	}

	function release() {
		$r=Stopper_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianSimpleStopper extends XapianStopper {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStopper::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStopper::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStopper::__isset($var);
	}

	function add($word) {
		SimpleStopper_add($this->_cPtr,$word);
	}

	function apply($term) {
		return SimpleStopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return SimpleStopper_get_description($this->_cPtr);
	}

	function __construct($file=null) {
		if (is_resource($file) && get_resource_type($file) === '_p_Xapian__SimpleStopper') {
			$this->_cPtr=$file;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_SimpleStopper(); break;
		default: $this->_cPtr=new_SimpleStopper($file);
		}
	}
}

class XapianRangeProcessor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($slot_=null,$str_=null,$flags_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__RangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		if (get_class($this) === 'XapianRangeProcessor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_RangeProcessor($_this); break;
		case 1: $this->_cPtr=new_RangeProcessor($_this, $slot_); break;
		case 2: $this->_cPtr=new_RangeProcessor($_this, $slot_,$str_); break;
		default: $this->_cPtr=new_RangeProcessor($_this, $slot_,$str_,$flags_);
		}
	}

	function check_range($b,$e) {
		$r=RangeProcessor_check_range($this->_cPtr,$b,$e);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function apply($begin,$end) {
		$r=RangeProcessor_apply($this->_cPtr,$begin,$end);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function release() {
		$r=RangeProcessor_release($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianRangeProcessor($r);
		}
		return $r;
	}
}

class XapianDateRangeProcessor extends XapianRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianRangeProcessor::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianRangeProcessor::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianRangeProcessor::__isset($var);
	}

	function __construct($slot_,$flags__or_str_=null,$epoch_year__or_flags_=null,$epoch_year_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__DateRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_DateRangeProcessor($slot_); break;
		case 2: $this->_cPtr=new_DateRangeProcessor($slot_,$flags__or_str_); break;
		case 3: $this->_cPtr=new_DateRangeProcessor($slot_,$flags__or_str_,$epoch_year__or_flags_); break;
		default: $this->_cPtr=new_DateRangeProcessor($slot_,$flags__or_str_,$epoch_year__or_flags_,$epoch_year_);
		}
	}

	function apply($begin,$end) {
		$r=DateRangeProcessor_apply($this->_cPtr,$begin,$end);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}
}

class XapianNumberRangeProcessor extends XapianRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianRangeProcessor::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianRangeProcessor::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianRangeProcessor::__isset($var);
	}

	function __construct($slot_,$str_=null,$flags_=0) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__NumberRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_NumberRangeProcessor($slot_); break;
		default: $this->_cPtr=new_NumberRangeProcessor($slot_,$str_,$flags_);
		}
	}

	function apply($begin,$end) {
		$r=NumberRangeProcessor_apply($this->_cPtr,$begin,$end);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}
}

abstract class XapianValueRangeProcessor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ValueRangeProcessor') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianValueRangeProcessor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ValueRangeProcessor($_this);
	}

	function apply($begin,$end) {
		return ValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}

	function release() {
		$r=ValueRangeProcessor_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianStringValueRangeProcessor extends XapianValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValueRangeProcessor::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValueRangeProcessor::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValueRangeProcessor::__isset($var);
	}

	function __construct($slot_,$str_=null,$prefix_=true) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__StringValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_StringValueRangeProcessor($slot_); break;
		default: $this->_cPtr=new_StringValueRangeProcessor($slot_,$str_,$prefix_);
		}
	}

	function apply($begin,$end) {
		return StringValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

class XapianDateValueRangeProcessor extends XapianStringValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStringValueRangeProcessor::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStringValueRangeProcessor::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStringValueRangeProcessor::__isset($var);
	}

	function __construct($slot_,$prefer_mdy__or_str_=null,$epoch_year__or_prefix_=null,$prefer_mdy_=null,$epoch_year_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__DateValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_DateValueRangeProcessor($slot_); break;
		case 2: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_); break;
		case 3: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_); break;
		case 4: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_,$prefer_mdy_); break;
		default: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_,$prefer_mdy_,$epoch_year_);
		}
	}

	function apply($begin,$end) {
		return DateValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

class XapianNumberValueRangeProcessor extends XapianStringValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStringValueRangeProcessor::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStringValueRangeProcessor::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStringValueRangeProcessor::__isset($var);
	}

	function __construct($slot_,$str_=null,$prefix_=true) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__NumberValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_NumberValueRangeProcessor($slot_); break;
		default: $this->_cPtr=new_NumberValueRangeProcessor($slot_,$str_,$prefix_);
		}
	}

	function apply($begin,$end) {
		return NumberValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

abstract class XapianFieldProcessor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__FieldProcessor') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianFieldProcessor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_FieldProcessor($_this);
	}

	function apply($str) {
		$r=FieldProcessor_apply($this->_cPtr,$str);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function release() {
		$r=FieldProcessor_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianQueryParser {
	protected $_rps=null;
	protected $_vrps=null;
	protected $_stopper=null;
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	const FLAG_BOOLEAN = 1;

	const FLAG_PHRASE = 2;

	const FLAG_LOVEHATE = 4;

	const FLAG_BOOLEAN_ANY_CASE = 8;

	const FLAG_WILDCARD = 16;

	const FLAG_PURE_NOT = 32;

	const FLAG_PARTIAL = 64;

	const FLAG_SPELLING_CORRECTION = 128;

	const FLAG_SYNONYM = 256;

	const FLAG_AUTO_SYNONYMS = 512;

	const FLAG_AUTO_MULTIWORD_SYNONYMS = 1024;

	const FLAG_CJK_NGRAM = 2048;

	const FLAG_DEFAULT = QueryParser_FLAG_DEFAULT;

	const STEM_NONE = 0;

	const STEM_SOME = QueryParser_STEM_SOME;

	const STEM_ALL = QueryParser_STEM_ALL;

	const STEM_ALL_Z = QueryParser_STEM_ALL_Z;

	const STEM_SOME_FULL_POS = QueryParser_STEM_SOME_FULL_POS;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__QueryParser') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_QueryParser();
	}

	function set_stemmer(XapianStem $stemmer) {
		QueryParser_set_stemmer($this->_cPtr,$stemmer);
	}

	function set_stemming_strategy($strategy) {
		QueryParser_set_stemming_strategy($this->_cPtr,$strategy);
	}

	function set_stopper(XapianStopper $stop=null) {
		$this->_stopper=$stop;
		QueryParser_set_stopper($this->_cPtr,$stop);
	}

	function set_default_op($default_op) {
		QueryParser_set_default_op($this->_cPtr,$default_op);
	}

	function get_default_op() {
		return QueryParser_get_default_op($this->_cPtr);
	}

	function set_database(XapianDatabase $db) {
		QueryParser_set_database($this->_cPtr,$db);
	}

	function set_max_expansion($max_expansion,$max_type=null,$flags=null) {
		switch (func_num_args()) {
		case 1: QueryParser_set_max_expansion($this->_cPtr,$max_expansion); break;
		case 2: QueryParser_set_max_expansion($this->_cPtr,$max_expansion,$max_type); break;
		default: QueryParser_set_max_expansion($this->_cPtr,$max_expansion,$max_type,$flags);
		}
	}

	function set_max_wildcard_expansion($arg1) {
		QueryParser_set_max_wildcard_expansion($this->_cPtr,$arg1);
	}

	function parse_query($query_string,$flags=null,$default_prefix=null) {
		switch (func_num_args()) {
		case 1: $r=QueryParser_parse_query($this->_cPtr,$query_string); break;
		case 2: $r=QueryParser_parse_query($this->_cPtr,$query_string,$flags); break;
		default: $r=QueryParser_parse_query($this->_cPtr,$query_string,$flags,$default_prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function add_prefix($field,$prefix_or_proc) {
		QueryParser_add_prefix($this->_cPtr,$field,$prefix_or_proc);
	}

	function add_boolean_prefix($field,$prefix_or_proc,$grouping_or_exclusive=null) {
		switch (func_num_args()) {
		case 2: QueryParser_add_boolean_prefix($this->_cPtr,$field,$prefix_or_proc); break;
		default: QueryParser_add_boolean_prefix($this->_cPtr,$field,$prefix_or_proc,$grouping_or_exclusive);
		}
	}

	function stoplist_begin() {
		$r=QueryParser_stoplist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function stoplist_end() {
		$r=QueryParser_stoplist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function unstem_begin($term) {
		$r=QueryParser_unstem_begin($this->_cPtr,$term);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function unstem_end($arg1) {
		$r=QueryParser_unstem_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function add_rangeprocessor(XapianRangeProcessor $range_proc,$grouping=null) {
		$this->_rps[]=$range_proc;
		QueryParser_add_rangeprocessor($this->_cPtr,$range_proc,$grouping);
	}

	function add_valuerangeprocessor(XapianValueRangeProcessor $vrproc) {
		$this->_vrps[]=$vrproc;
		QueryParser_add_valuerangeprocessor($this->_cPtr,$vrproc);
	}

	function get_corrected_query_string() {
		return QueryParser_get_corrected_query_string($this->_cPtr);
	}

	function get_description() {
		return QueryParser_get_description($this->_cPtr);
	}
}

class XapianValueSetMatchDecider extends XapianMatchDecider {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianMatchDecider::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianMatchDecider::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianMatchDecider::__isset($var);
	}

	function __construct($slot,$inclusive_) {
		if (is_resource($slot) && get_resource_type($slot) === '_p_Xapian__ValueSetMatchDecider') {
			$this->_cPtr=$slot;
			return;
		}
		$this->_cPtr=new_ValueSetMatchDecider($slot,$inclusive_);
	}

	function add_value($value) {
		ValueSetMatchDecider_add_value($this->_cPtr,$value);
	}

	function remove_value($value) {
		ValueSetMatchDecider_remove_value($this->_cPtr,$value);
	}

	function apply($doc) {
		return ValueSetMatchDecider_apply($this->_cPtr,$doc);
	}
}

abstract class XapianWeight {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	const TWO_STAGE_SMOOTHING = 1;

	const DIRICHLET_SMOOTHING = 2;

	const ABSOLUTE_DISCOUNT_SMOOTHING = 3;

	const JELINEK_MERCER_SMOOTHING = 4;

	const DIRICHLET_PLUS_SMOOTHING = 5;

	function name() {
		return Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return Weight_get_maxextra($this->_cPtr);
	}
}

class XapianBoolWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__BoolWeight') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_BoolWeight();
	}

	function name() {
		return BoolWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return BoolWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return BoolWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return BoolWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return BoolWeight_get_maxextra($this->_cPtr);
	}
}

class XapianTfIdfWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($normalizations=null) {
		if (is_resource($normalizations) && get_resource_type($normalizations) === '_p_Xapian__TfIdfWeight') {
			$this->_cPtr=$normalizations;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_TfIdfWeight(); break;
		default: $this->_cPtr=new_TfIdfWeight($normalizations);
		}
	}

	function name() {
		return TfIdfWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return TfIdfWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return TfIdfWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return TfIdfWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return TfIdfWeight_get_maxextra($this->_cPtr);
	}
}

class XapianBM25Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($k1=null,$k2=null,$k3=null,$b=null,$min_normlen=null) {
		if (is_resource($k1) && get_resource_type($k1) === '_p_Xapian__BM25Weight') {
			$this->_cPtr=$k1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_BM25Weight(); break;
		case 1: $this->_cPtr=new_BM25Weight($k1); break;
		case 2: $this->_cPtr=new_BM25Weight($k1,$k2); break;
		case 3: $this->_cPtr=new_BM25Weight($k1,$k2,$k3); break;
		case 4: $this->_cPtr=new_BM25Weight($k1,$k2,$k3,$b); break;
		default: $this->_cPtr=new_BM25Weight($k1,$k2,$k3,$b,$min_normlen);
		}
	}

	function name() {
		return BM25Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return BM25Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return BM25Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return BM25Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return BM25Weight_get_maxextra($this->_cPtr);
	}
}

class XapianBM25PlusWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($k1=null,$k2=null,$k3=null,$b=null,$min_normlen=null,$delta=null) {
		if (is_resource($k1) && get_resource_type($k1) === '_p_Xapian__BM25PlusWeight') {
			$this->_cPtr=$k1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_BM25PlusWeight(); break;
		case 1: $this->_cPtr=new_BM25PlusWeight($k1); break;
		case 2: $this->_cPtr=new_BM25PlusWeight($k1,$k2); break;
		case 3: $this->_cPtr=new_BM25PlusWeight($k1,$k2,$k3); break;
		case 4: $this->_cPtr=new_BM25PlusWeight($k1,$k2,$k3,$b); break;
		case 5: $this->_cPtr=new_BM25PlusWeight($k1,$k2,$k3,$b,$min_normlen); break;
		default: $this->_cPtr=new_BM25PlusWeight($k1,$k2,$k3,$b,$min_normlen,$delta);
		}
	}

	function name() {
		return BM25PlusWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return BM25PlusWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return BM25PlusWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return BM25PlusWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return BM25PlusWeight_get_maxextra($this->_cPtr);
	}
}

class XapianTradWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($k=1.0) {
		if (is_resource($k) && get_resource_type($k) === '_p_Xapian__TradWeight') {
			$this->_cPtr=$k;
			return;
		}
		$this->_cPtr=new_TradWeight($k);
	}

	function name() {
		return TradWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqueterms) {
		return TradWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqueterms);
	}

	function get_maxpart() {
		return TradWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return TradWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return TradWeight_get_maxextra($this->_cPtr);
	}
}

class XapianInL2Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__InL2Weight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_InL2Weight(); break;
		default: $this->_cPtr=new_InL2Weight($c_);
		}
	}

	function name() {
		return InL2Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return InL2Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return InL2Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return InL2Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return InL2Weight_get_maxextra($this->_cPtr);
	}
}

class XapianIfB2Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__IfB2Weight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_IfB2Weight(); break;
		default: $this->_cPtr=new_IfB2Weight($c_);
		}
	}

	function name() {
		return IfB2Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return IfB2Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return IfB2Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return IfB2Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return IfB2Weight_get_maxextra($this->_cPtr);
	}
}

class XapianIneB2Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__IneB2Weight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_IneB2Weight(); break;
		default: $this->_cPtr=new_IneB2Weight($c_);
		}
	}

	function name() {
		return IneB2Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return IneB2Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return IneB2Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return IneB2Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return IneB2Weight_get_maxextra($this->_cPtr);
	}
}

class XapianBB2Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__BB2Weight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_BB2Weight(); break;
		default: $this->_cPtr=new_BB2Weight($c_);
		}
	}

	function name() {
		return BB2Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return BB2Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return BB2Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return BB2Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return BB2Weight_get_maxextra($this->_cPtr);
	}
}

class XapianDLHWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__DLHWeight') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_DLHWeight();
	}

	function name() {
		return DLHWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return DLHWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return DLHWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return DLHWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return DLHWeight_get_maxextra($this->_cPtr);
	}
}

class XapianPL2Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__PL2Weight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_PL2Weight(); break;
		default: $this->_cPtr=new_PL2Weight($c_);
		}
	}

	function name() {
		return PL2Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return PL2Weight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return PL2Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return PL2Weight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return PL2Weight_get_maxextra($this->_cPtr);
	}
}

class XapianPL2PlusWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($c_=null,$delta=null) {
		if (is_resource($c_) && get_resource_type($c_) === '_p_Xapian__PL2PlusWeight') {
			$this->_cPtr=$c_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_PL2PlusWeight(); break;
		case 1: $this->_cPtr=new_PL2PlusWeight($c_); break;
		default: $this->_cPtr=new_PL2PlusWeight($c_,$delta);
		}
	}

	function name() {
		return PL2PlusWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return PL2PlusWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return PL2PlusWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return PL2PlusWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return PL2PlusWeight_get_maxextra($this->_cPtr);
	}
}

class XapianDPHWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__DPHWeight') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_DPHWeight();
	}

	function name() {
		return DPHWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterms) {
		return DPHWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterms);
	}

	function get_maxpart() {
		return DPHWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$uniqterms) {
		return DPHWeight_get_sumextra($this->_cPtr,$doclen,$uniqterms);
	}

	function get_maxextra() {
		return DPHWeight_get_maxextra($this->_cPtr);
	}
}

class XapianLMWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __construct($param_log_=0.0,$select_smoothing_=null,$param_smoothing1_=-1.0,$param_smoothing2_=-1.0) {
		if (is_resource($param_log_) && get_resource_type($param_log_) === '_p_Xapian__LMWeight') {
			$this->_cPtr=$param_log_;
			return;
		}
		switch (func_num_args()) {
		case 0: case 1: $this->_cPtr=new_LMWeight($param_log_); break;
		default: $this->_cPtr=new_LMWeight($param_log_,$select_smoothing_,$param_smoothing1_,$param_smoothing2_);
		}
	}

	function name() {
		return LMWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return LMWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return LMWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen,$arg2) {
		return LMWeight_get_sumextra($this->_cPtr,$doclen,$arg2);
	}

	function get_maxextra() {
		return LMWeight_get_maxextra($this->_cPtr);
	}
}

class XapianCoordWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function init($factor_) {
		CoordWeight_init($this->_cPtr,$factor_);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__CoordWeight') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_CoordWeight();
	}

	function name() {
		return CoordWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen,$uniqterm) {
		return CoordWeight_get_sumpart($this->_cPtr,$wdf,$doclen,$uniqterm);
	}

	function get_maxpart() {
		return CoordWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($arg1,$arg2) {
		return CoordWeight_get_sumextra($this->_cPtr,$arg1,$arg2);
	}

	function get_maxextra() {
		return CoordWeight_get_maxextra($this->_cPtr);
	}
}

class XapianCompactor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	const STANDARD = 0;

	const FULL = 1;

	const FULLER = 2;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Compactor') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianCompactor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_Compactor($_this);
	}

	function set_block_size($block_size) {
		Compactor_set_block_size($this->_cPtr,$block_size);
	}

	function set_renumber($renumber) {
		Compactor_set_renumber($this->_cPtr,$renumber);
	}

	function set_multipass($multipass) {
		Compactor_set_multipass($this->_cPtr,$multipass);
	}

	function set_compaction_level($compaction) {
		Compactor_set_compaction_level($this->_cPtr,$compaction);
	}

	function set_destdir($destdir) {
		Compactor_set_destdir($this->_cPtr,$destdir);
	}

	function add_source($srcdir) {
		Compactor_add_source($this->_cPtr,$srcdir);
	}

	function compact() {
		Compactor_compact($this->_cPtr);
	}

	function set_status($table,$status) {
		Compactor_set_status($this->_cPtr,$table,$status);
	}

	function resolve_duplicate_metadata($key,$num_tags,$tags) {
		return Compactor_resolve_duplicate_metadata($this->_cPtr,$key,$num_tags,$tags);
	}
}

abstract class XapianPostingSource {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__PostingSource') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianPostingSource') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_PostingSource($_this);
	}

	function get_termfreq_min() {
		return PostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return PostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return PostingSource_get_termfreq_max($this->_cPtr);
	}

	function set_maxweight($max_weight) {
		PostingSource_set_maxweight($this->_cPtr,$max_weight);
	}

	function get_maxweight() {
		return PostingSource_get_maxweight($this->_cPtr);
	}

	function get_weight() {
		return PostingSource_get_weight($this->_cPtr);
	}

	function get_docid() {
		return PostingSource_get_docid($this->_cPtr);
	}

	function next($min_wt) {
		PostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($did,$min_wt) {
		PostingSource_skip_to($this->_cPtr,$did,$min_wt);
	}

	function check($did,$min_wt) {
		return PostingSource_check($this->_cPtr,$did,$min_wt);
	}

	function at_end() {
		return PostingSource_at_end($this->_cPtr);
	}

	function name() {
		return PostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db) {
		PostingSource_init($this->_cPtr,$db);
	}

	function get_description() {
		return PostingSource_get_description($this->_cPtr);
	}

	function release() {
		$r=PostingSource_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianValuePostingSource extends XapianPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianPostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianPostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianPostingSource::__isset($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValuePostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		if (get_class($this) === 'XapianValuePostingSource') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ValuePostingSource($_this, $slot_);
	}

	function get_termfreq_min() {
		return ValuePostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return ValuePostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return ValuePostingSource_get_termfreq_max($this->_cPtr);
	}

	function next($min_wt) {
		ValuePostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		ValuePostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return ValuePostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function at_end() {
		return ValuePostingSource_at_end($this->_cPtr);
	}

	function get_docid() {
		return ValuePostingSource_get_docid($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		ValuePostingSource_init($this->_cPtr,$db_);
	}

	function get_database() {
		$r=ValuePostingSource_get_database($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDatabase($r);
		}
		return $r;
	}

	function get_slot() {
		return ValuePostingSource_get_slot($this->_cPtr);
	}

	function get_value() {
		return ValuePostingSource_get_value($this->_cPtr);
	}

	function done() {
		ValuePostingSource_done($this->_cPtr);
	}

	function get_started() {
		return ValuePostingSource_get_started($this->_cPtr);
	}

	function set_termfreq_min($termfreq_min_) {
		ValuePostingSource_set_termfreq_min($this->_cPtr,$termfreq_min_);
	}

	function set_termfreq_est($termfreq_est_) {
		ValuePostingSource_set_termfreq_est($this->_cPtr,$termfreq_est_);
	}

	function set_termfreq_max($termfreq_max_) {
		ValuePostingSource_set_termfreq_max($this->_cPtr,$termfreq_max_);
	}
}

class XapianValueWeightPostingSource extends XapianValuePostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValuePostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValuePostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValuePostingSource::__isset($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueWeightPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		if (get_class($this) === 'XapianValueWeightPostingSource') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ValueWeightPostingSource($_this, $slot_);
	}

	function get_weight() {
		return ValueWeightPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return ValueWeightPostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		ValueWeightPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return ValueWeightPostingSource_get_description($this->_cPtr);
	}
}

class XapianDecreasingValueWeightPostingSource extends XapianValueWeightPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValueWeightPostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValueWeightPostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValueWeightPostingSource::__isset($var);
	}

	function __construct($slot_,$range_start_=0,$range_end_=0) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__DecreasingValueWeightPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_DecreasingValueWeightPostingSource($slot_,$range_start_,$range_end_);
	}

	function get_weight() {
		return DecreasingValueWeightPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return DecreasingValueWeightPostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		DecreasingValueWeightPostingSource_init($this->_cPtr,$db_);
	}

	function next($min_wt) {
		DecreasingValueWeightPostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		DecreasingValueWeightPostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return DecreasingValueWeightPostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function get_description() {
		return DecreasingValueWeightPostingSource_get_description($this->_cPtr);
	}
}

class XapianValueMapPostingSource extends XapianValuePostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValuePostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValuePostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValuePostingSource::__isset($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueMapPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_ValueMapPostingSource($slot_);
	}

	function add_mapping($key,$wt) {
		ValueMapPostingSource_add_mapping($this->_cPtr,$key,$wt);
	}

	function clear_mappings() {
		ValueMapPostingSource_clear_mappings($this->_cPtr);
	}

	function set_default_weight($wt) {
		ValueMapPostingSource_set_default_weight($this->_cPtr,$wt);
	}

	function get_weight() {
		return ValueMapPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return ValueMapPostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		ValueMapPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return ValueMapPostingSource_get_description($this->_cPtr);
	}
}

class XapianFixedWeightPostingSource extends XapianPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianPostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianPostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianPostingSource::__isset($var);
	}

	function __construct($wt) {
		if (is_resource($wt) && get_resource_type($wt) === '_p_Xapian__FixedWeightPostingSource') {
			$this->_cPtr=$wt;
			return;
		}
		$this->_cPtr=new_FixedWeightPostingSource($wt);
	}

	function get_termfreq_min() {
		return FixedWeightPostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return FixedWeightPostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return FixedWeightPostingSource_get_termfreq_max($this->_cPtr);
	}

	function get_weight() {
		return FixedWeightPostingSource_get_weight($this->_cPtr);
	}

	function next($min_wt) {
		FixedWeightPostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		FixedWeightPostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return FixedWeightPostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function at_end() {
		return FixedWeightPostingSource_at_end($this->_cPtr);
	}

	function get_docid() {
		return FixedWeightPostingSource_get_docid($this->_cPtr);
	}

	function name() {
		return FixedWeightPostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		FixedWeightPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return FixedWeightPostingSource_get_description($this->_cPtr);
	}
}

abstract class XapianMatchSpy {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MatchSpy') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianMatchSpy') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_MatchSpy($_this);
	}

	function apply($doc,$wt) {
		MatchSpy_apply($this->_cPtr,$doc,$wt);
	}

	function name() {
		return MatchSpy_name($this->_cPtr);
	}

	function merge_results($serialised) {
		MatchSpy_merge_results($this->_cPtr,$serialised);
	}

	function get_description() {
		return MatchSpy_get_description($this->_cPtr);
	}

	function release() {
		$r=MatchSpy_release($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}
}

class XapianValueCountMatchSpy extends XapianMatchSpy {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianMatchSpy::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianMatchSpy::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianMatchSpy::__isset($var);
	}

	function __construct($slot_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueCountMatchSpy') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ValueCountMatchSpy(); break;
		default: $this->_cPtr=new_ValueCountMatchSpy($slot_);
		}
	}

	function get_total() {
		return ValueCountMatchSpy_get_total($this->_cPtr);
	}

	function values_begin() {
		$r=ValueCountMatchSpy_values_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function values_end() {
		$r=ValueCountMatchSpy_values_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function top_values_begin($maxvalues) {
		$r=ValueCountMatchSpy_top_values_begin($this->_cPtr,$maxvalues);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function top_values_end($arg1) {
		$r=ValueCountMatchSpy_top_values_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function apply($doc,$wt) {
		ValueCountMatchSpy_apply($this->_cPtr,$doc,$wt);
	}

	function name() {
		return ValueCountMatchSpy_name($this->_cPtr);
	}

	function merge_results($serialised) {
		ValueCountMatchSpy_merge_results($this->_cPtr,$serialised);
	}

	function get_description() {
		return ValueCountMatchSpy_get_description($this->_cPtr);
	}
}

class XapianLatLongCoord {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'latitude') return LatLongCoord_latitude_set($this->_cPtr,$value);
		if ($var === 'longitude') return LatLongCoord_longitude_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'latitude') return LatLongCoord_latitude_get($this->_cPtr);
		if ($var === 'longitude') return LatLongCoord_longitude_get($this->_cPtr);
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('LatLongCoord_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($latitude_=null,$longitude_=null) {
		if (is_resource($latitude_) && get_resource_type($latitude_) === '_p_Xapian__LatLongCoord') {
			$this->_cPtr=$latitude_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_LatLongCoord(); break;
		case 1: $this->_cPtr=new_LatLongCoord($latitude_); break;
		default: $this->_cPtr=new_LatLongCoord($latitude_,$longitude_);
		}
	}

	function unserialise($serialised) {
		LatLongCoord_unserialise($this->_cPtr,$serialised);
	}

	function serialise() {
		return LatLongCoord_serialise($this->_cPtr);
	}

	function get_description() {
		return LatLongCoord_get_description($this->_cPtr);
	}
}

class XapianLatLongCoordsIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__LatLongCoordsIterator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_LatLongCoordsIterator();
	}

	function equals(XapianLatLongCoordsIterator $o) {
		return LatLongCoordsIterator_equals($this->_cPtr,$o);
	}

	function get_coord() {
		$r=LatLongCoordsIterator_get_coord($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianLatLongCoord($r);
		}
		return $r;
	}

	function next() {
		LatLongCoordsIterator_next($this->_cPtr);
	}
}

class XapianLatLongCoords {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function begin() {
		$r=LatLongCoords_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianLatLongCoordsIterator($r);
		}
		return $r;
	}

	function end() {
		$r=LatLongCoords_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianLatLongCoordsIterator($r);
		}
		return $r;
	}

	function size() {
		return LatLongCoords_size($this->_cPtr);
	}

	function is_empty() {
		return LatLongCoords_is_empty($this->_cPtr);
	}

	function append($coord) {
		LatLongCoords_append($this->_cPtr,$coord);
	}

	function __construct($coord=null) {
		if (is_resource($coord) && get_resource_type($coord) === '_p_Xapian__LatLongCoords') {
			$this->_cPtr=$coord;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_LatLongCoords(); break;
		default: $this->_cPtr=new_LatLongCoords($coord);
		}
	}

	function unserialise($serialised) {
		LatLongCoords_unserialise($this->_cPtr,$serialised);
	}

	function serialise() {
		return LatLongCoords_serialise($this->_cPtr);
	}

	function get_description() {
		return LatLongCoords_get_description($this->_cPtr);
	}
}

abstract class XapianLatLongMetric {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function pointwise_distance($a,$b) {
		return LatLongMetric_pointwise_distance($this->_cPtr,$a,$b);
	}

	function apply($a,$b_or_b_ptr,$b_len=null) {
		switch (func_num_args()) {
		case 2: $this->_cPtr=LatLongMetric_apply($this->_cPtr,$a,$b_or_b_ptr); break;
		default: $this->_cPtr=LatLongMetric_apply($this->_cPtr,$a,$b_or_b_ptr,$b_len);
		}
		return $r;
	}

	function name() {
		return LatLongMetric_name($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__LatLongMetric') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianLatLongMetric') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_LatLongMetric($_this);
	}
}

class XapianGreatCircleMetric extends XapianLatLongMetric {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianLatLongMetric::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianLatLongMetric::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianLatLongMetric::__isset($var);
	}

	function __construct($radius_=null) {
		if (is_resource($radius_) && get_resource_type($radius_) === '_p_Xapian__GreatCircleMetric') {
			$this->_cPtr=$radius_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_GreatCircleMetric(); break;
		default: $this->_cPtr=new_GreatCircleMetric($radius_);
		}
	}

	function pointwise_distance($a,$b) {
		return GreatCircleMetric_pointwise_distance($this->_cPtr,$a,$b);
	}

	function name() {
		return GreatCircleMetric_name($this->_cPtr);
	}
}

class XapianLatLongDistancePostingSource extends XapianValuePostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValuePostingSource::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValuePostingSource::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValuePostingSource::__isset($var);
	}

	function __construct($slot_,$centre_,$metric__or_max_range_=null,$max_range__or_k1_=null,$k1__or_k2_=null,$k2_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__LatLongDistancePostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 2: $this->_cPtr=new_LatLongDistancePostingSource($slot_,$centre_); break;
		case 3: $this->_cPtr=new_LatLongDistancePostingSource($slot_,$centre_,$metric__or_max_range_); break;
		case 4: $this->_cPtr=new_LatLongDistancePostingSource($slot_,$centre_,$metric__or_max_range_,$max_range__or_k1_); break;
		case 5: $this->_cPtr=new_LatLongDistancePostingSource($slot_,$centre_,$metric__or_max_range_,$max_range__or_k1_,$k1__or_k2_); break;
		default: $this->_cPtr=new_LatLongDistancePostingSource($slot_,$centre_,$metric__or_max_range_,$max_range__or_k1_,$k1__or_k2_,$k2_);
		}
	}

	function next($min_wt) {
		LatLongDistancePostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		LatLongDistancePostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return LatLongDistancePostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function get_weight() {
		return LatLongDistancePostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return LatLongDistancePostingSource_name($this->_cPtr);
	}

	function init(XapianDatabase $db_) {
		LatLongDistancePostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return LatLongDistancePostingSource_get_description($this->_cPtr);
	}
}

class XapianLatLongDistanceKeyMaker extends XapianKeyMaker {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianKeyMaker::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianKeyMaker::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianKeyMaker::__isset($var);
	}

	function __construct($slot_,$centre_,$metric_=null,$defdistance=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__LatLongDistanceKeyMaker') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 2: $this->_cPtr=new_LatLongDistanceKeyMaker($slot_,$centre_); break;
		case 3: $this->_cPtr=new_LatLongDistanceKeyMaker($slot_,$centre_,$metric_); break;
		default: $this->_cPtr=new_LatLongDistanceKeyMaker($slot_,$centre_,$metric_,$defdistance);
		}
	}

	function apply($doc) {
		return LatLongDistanceKeyMaker_apply($this->_cPtr,$doc);
	}
}

class XapianDatabase {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function add_database(XapianDatabase $database) {
		Database_add_database($this->_cPtr,$database);
	}

	function __construct($path_or_fd=null,$flags=0) {
		if (is_resource($path_or_fd) && get_resource_type($path_or_fd) === '_p_Xapian__Database') {
			$this->_cPtr=$path_or_fd;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Database(); break;
		default: $this->_cPtr=new_Database($path_or_fd,$flags);
		}
	}

	function reopen() {
		return Database_reopen($this->_cPtr);
	}

	function close() {
		Database_close($this->_cPtr);
	}

	function get_description() {
		return Database_get_description($this->_cPtr);
	}

	function postlist_begin($tname) {
		$r=Database_postlist_begin($this->_cPtr,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPostingIterator($r);
		}
		return $r;
	}

	function postlist_end($arg1) {
		$r=Database_postlist_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPostingIterator($r);
		}
		return $r;
	}

	function termlist_begin($did) {
		$r=Database_termlist_begin($this->_cPtr,$did);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function termlist_end($arg1) {
		$r=Database_termlist_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function has_positions() {
		return Database_has_positions($this->_cPtr);
	}

	function positionlist_begin($did,$tname) {
		$r=Database_positionlist_begin($this->_cPtr,$did,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end($arg1,$arg2) {
		$r=Database_positionlist_end($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function allterms_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_allterms_begin($this->_cPtr); break;
		default: $r=Database_allterms_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function allterms_end($arg1=null) {
		switch (func_num_args()) {
		case 0: $r=Database_allterms_end($this->_cPtr); break;
		default: $r=Database_allterms_end($this->_cPtr,$arg1);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_doccount() {
		return Database_get_doccount($this->_cPtr);
	}

	function get_lastdocid() {
		return Database_get_lastdocid($this->_cPtr);
	}

	function get_avlength() {
		return Database_get_avlength($this->_cPtr);
	}

	function get_total_length() {
		return Database_get_total_length($this->_cPtr);
	}

	function get_termfreq($tname) {
		return Database_get_termfreq($this->_cPtr,$tname);
	}

	function term_exists($tname) {
		return Database_term_exists($this->_cPtr,$tname);
	}

	function get_collection_freq($tname) {
		return Database_get_collection_freq($this->_cPtr,$tname);
	}

	function get_value_freq($slot) {
		return Database_get_value_freq($this->_cPtr,$slot);
	}

	function get_value_lower_bound($slot) {
		return Database_get_value_lower_bound($this->_cPtr,$slot);
	}

	function get_value_upper_bound($slot) {
		return Database_get_value_upper_bound($this->_cPtr,$slot);
	}

	function get_doclength_lower_bound() {
		return Database_get_doclength_lower_bound($this->_cPtr);
	}

	function get_doclength_upper_bound() {
		return Database_get_doclength_upper_bound($this->_cPtr);
	}

	function get_wdf_upper_bound($term) {
		return Database_get_wdf_upper_bound($this->_cPtr,$term);
	}

	function valuestream_begin($slot) {
		$r=Database_valuestream_begin($this->_cPtr,$slot);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function valuestream_end($arg1) {
		$r=Database_valuestream_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function get_doclength($did) {
		return Database_get_doclength($this->_cPtr,$did);
	}

	function get_unique_terms($did) {
		return Database_get_unique_terms($this->_cPtr,$did);
	}

	function keep_alive() {
		Database_keep_alive($this->_cPtr);
	}

	function get_document($did,$flags=null) {
		switch (func_num_args()) {
		case 1: $r=Database_get_document($this->_cPtr,$did); break;
		default: $r=Database_get_document($this->_cPtr,$did,$flags);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_spelling_suggestion($word,$max_edit_distance=2) {
		return Database_get_spelling_suggestion($this->_cPtr,$word,$max_edit_distance);
	}

	function spellings_begin() {
		$r=Database_spellings_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function spellings_end() {
		$r=Database_spellings_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonyms_begin($term) {
		$r=Database_synonyms_begin($this->_cPtr,$term);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonyms_end($arg1) {
		$r=Database_synonyms_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonym_keys_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_synonym_keys_begin($this->_cPtr); break;
		default: $r=Database_synonym_keys_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonym_keys_end($arg1=null) {
		switch (func_num_args()) {
		case 0: $r=Database_synonym_keys_end($this->_cPtr); break;
		default: $r=Database_synonym_keys_end($this->_cPtr,$arg1);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_metadata($key) {
		return Database_get_metadata($this->_cPtr,$key);
	}

	function metadata_keys_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_metadata_keys_begin($this->_cPtr); break;
		default: $r=Database_metadata_keys_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function metadata_keys_end($arg1=null) {
		switch (func_num_args()) {
		case 0: $r=Database_metadata_keys_end($this->_cPtr); break;
		default: $r=Database_metadata_keys_end($this->_cPtr,$arg1);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_uuid() {
		return Database_get_uuid($this->_cPtr);
	}

	function locked() {
		return Database_locked($this->_cPtr);
	}

	function get_revision() {
		return Database_get_revision($this->_cPtr);
	}

	static function check($path_or_fd,$opts=0) {
		$r=Database_check($path_or_fd,$opts);
		return $r;
	}

	function compact($output_or_fd,$flags=null,$block_size=null,$compactor=null) {
		switch (func_num_args()) {
		case 1: Database_compact($this->_cPtr,$output_or_fd); break;
		case 2: Database_compact($this->_cPtr,$output_or_fd,$flags); break;
		case 3: Database_compact($this->_cPtr,$output_or_fd,$flags,$block_size); break;
		default: Database_compact($this->_cPtr,$output_or_fd,$flags,$block_size,$compactor);
		}
	}
}

class XapianWritableDatabase extends XapianDatabase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianDatabase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianDatabase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianDatabase::__isset($var);
	}

	function __construct($path=null,$flags=0,$block_size=0) {
		if (is_resource($path) && get_resource_type($path) === '_p_Xapian__WritableDatabase') {
			$this->_cPtr=$path;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_WritableDatabase(); break;
		default: $this->_cPtr=new_WritableDatabase($path,$flags,$block_size);
		}
	}

	function commit() {
		WritableDatabase_commit($this->_cPtr);
	}

	function flush() {
		WritableDatabase_flush($this->_cPtr);
	}

	function begin_transaction($flushed=true) {
		WritableDatabase_begin_transaction($this->_cPtr,$flushed);
	}

	function commit_transaction() {
		WritableDatabase_commit_transaction($this->_cPtr);
	}

	function cancel_transaction() {
		WritableDatabase_cancel_transaction($this->_cPtr);
	}

	function add_document(XapianDocument $document) {
		return WritableDatabase_add_document($this->_cPtr,$document);
	}

	function delete_document($did_or_unique_term) {
		WritableDatabase_delete_document($this->_cPtr,$did_or_unique_term);
	}

	function replace_document($did_or_unique_term,XapianDocument $document) {
		return WritableDatabase_replace_document($this->_cPtr,$did_or_unique_term,$document);
	}

	function add_spelling($word,$freqinc=1) {
		WritableDatabase_add_spelling($this->_cPtr,$word,$freqinc);
	}

	function remove_spelling($word,$freqdec=1) {
		WritableDatabase_remove_spelling($this->_cPtr,$word,$freqdec);
	}

	function add_synonym($term,$synonym) {
		WritableDatabase_add_synonym($this->_cPtr,$term,$synonym);
	}

	function remove_synonym($term,$synonym) {
		WritableDatabase_remove_synonym($this->_cPtr,$term,$synonym);
	}

	function clear_synonyms($term) {
		WritableDatabase_clear_synonyms($this->_cPtr,$term);
	}

	function set_metadata($key,$metadata) {
		WritableDatabase_set_metadata($this->_cPtr,$key,$metadata);
	}

	function get_description() {
		return WritableDatabase_get_description($this->_cPtr);
	}
}


?>
