# X2Go Client / X2Go Broker Setup

The easy setup for getting a first impression is this:


## Installing X2Go Client, X2Go Server and X2Go Broker

Install x2goclient, x2gobroker and x2goserver(-xsession) locally. For
testing purposes, you can run all three components on one host. For
production environments, you distribute the services over different
machines and probably run many X2Go Server instances and man X2Go Client
instances.

 $ sudo apt install x2gobroker-daemon x2gobroker-authservice
 $ sudo apt install x2goclient
 $ sudo apt install x2goserver-xsession

## Test Configuration

Edit the file /etc/default/x2gobroker-daemon. Enable the daemon and,
if needed, adapt the bind address:port (DAEMON_BIND_ADDRESS) parameter.

After editing, save the file and return to your terminal command line.
From here, start the daemon:

 $ invoke-rc.d x2gobroker-daemon restart

## Approach 1: Launch X2Go Client

Launch x2goclient in HTTP broker mode:

  $ x2goclient --broker-url=http://127.0.0.1:8080/plain/

(if you have changed the bind address, use your changed value here).

## Approach 2: Launch PyHoca-GUI

Alternatively, launch pyhoca-gui in HTTP broker mode:

  $ pyhoca-gui --broker-url=https://127.0.0.1:8080/json/

(if you have changed the bind address, use your changed value here).


## The Broker Authentication

The first authentication that the x2goclient asks for is an authentication
against the X2Go Broker (a HTTP server using the Tornado web framework on
default port 8080).

As authentication backend the PAM setup of your system is used, investigate this
further by looking at this file:

 $ sudo editor /etc/pam.d/x2gobroker

## The X2Go Client WebUI in Broker Mode

If you have successfully authenticated against the broker, then you get offered
two session profiles named ,,KDE - localhost'' and ,,MATE - localhost''. These
session profiles can be modified and customized in

  /etc/x2go/broker/x2gobroker-sessionprofiles.conf

## Launch an X2Go Session via Broker Backend

If you select either of the session profiles (KDE or MATE on localhost), you
will start an X2Go session on your local machine. (Of course, either KDE or the
MATE desktop needs to be installed locally).
