.\" @(#)xgterm.1 1.1 16-Dec-96 MJF
.TH XGTERM 1 "16 Dec 1996" "X11IRAF Project"
.SH NAME
xgterm \- terminal emulator for X with graphics and imaging capability
.SH SYNOPSIS
\fBxgterm\fP [\-\fItoolkitoption\fP ...] [\-\fIoption\fP ...]
.SH DESCRIPTION
The \fIxgterm\fP program is a terminal emulator for the X Window System
based largely on \fIxterm\fP but with a completely new graphics and imaging
widget. It provides DEC VT102 and Tektronix 4014 compatible terminals for
programs that can't use the window system directly.  \fIXGterm\fP also
serves as a prototype for the \fIWidget Server\fP being developed by the
IRAF Project at NOAO.  The \fIObject Manager Library\fP it uses implements a
window system toolkit as an interpreted window-object language, allowing 
application GUIs to be defined and executed at runtime without compiling 
any code, and with minimal dependence upon the underlying window system 
toolkit library.  We will concentrate here, however, on it's use as a terminal
emulator and a description of the new \fIGterm\fP widget.
.PP
The Gterm graphics window operates almost identically to the \fIxterm\fP Tek
window, however there are extensions for implementing full-screen cursors,
imaging, area fills, colors, graphics erasure, a "status line" and so on.
Any graphics application capable of running under an \fIxterm\fP Tek window
should also be able to use \fIxgterm\fP as well.  Client programs wishing to
make use of the extended features, or those wishing to implement a GUI, are
advised to use the OBM (\fIObject Manager\fP) library supplied with the XGterm
source as part of the X11IRAF package.  This provides a much better 
programmatic interface to all of the features available; however, as of 
this writing it is not yet fully documented.  Users are referred to the
\fIXImtool\fP task as an example of a more complex application using the
\fIOBM Library\fP and \fIGterm\fP widget, as well as demo tasks in the
\fIguidemo\fP directory of the X11IRAF sources.  Questions or comments may
also be sent to \fIiraf@noao.edu\fP. 
.PP
The VT102 text window is unchanged from the original \fIxterm\fR application.
All of it's resources, command-line options and operation are identical to 
that used by \fIxterm\fP.  The \fItermcap(5)\fP entry for \fIxterm\fP may
be used for \fIxgterm\fP as well.  See the \fIxterm(1)\fP man page for details.
.SH OPTIONS
All \fIxterm(1)\fP and X Toolkit command line options are supported, there 
are no additional options.
.SH RESOURCES
The program understands all of the core X Toolkit resource names and 
classes, all text window resources known to \fIxterm(1)\fP, as well as
the \fIGterm\fP (graphics and imaging widget) resources.  The proper Class
name for all resources described here is \fIGterm\fP.  A table of
available \fIGterm\fP resources and their defaults may be found below,
some of the more interesting resources are described here in detail:
.TP 5
\fIbasePixel\fP
Base cell of the custom colormap.  This essentially allows you
to reserve \fIbasePixel\fP colors in the global colormap for other
applications.  The default is 38, if changed you'll need to also enable
the \fIcmapInitialize\fP resource to force the Gterm widget to 
update it's global colormap resource in the X server.   
.TP 5
\fIcmapInitialize\fP
Initialize the ximtool colormap at startup.  When resetting the \fIbasePixel\fP
resource or colormap this is required in order to force the Gterm widget to 
update it's global colormap resource in the X server.  The default is False.
.TP 5
\fIcmapInterpolate\fP
Interpolate the colormap to the number of display colors.  The default is
True.
.TP 5
\fIcmapName\fP
Name used for private colormap.  The default for all IRAF imaging
applications is \fIimage\fP.  Gterm widget based imaging applications
which have the same value of cmapName will share the same colormap,
minimizing colormap flashing and allowing multiple applications to be
run at the same time.
.TP 5
\fIcolor0\fP
The widget background color.  The default is black.
.TP 5
\fIcolor1\fP
The widget foreground color.  The default is white.
.TP 5
\fIcolor2\fP  thru  \fIcolor9\fP
Optional drawing colors.  The line color used for graphics is set using 
an escape sequence to select the current color index.  See \fIGterm I/O
Escape Sequences\fP below for more details.
.TP 5
\fIcrosshairCursorColor\fP
Color of the full screen crosshair cursor.
.TP 5
\fIdefaultMarker\fP
Default marker type.  Options include \fItext\fP, \fIline\fP, \fIpolyline\fP,
\fIrectangle\fP, \fIbox\fP, \fIcircle\fP, \fIellipse\fP, and \fIpolygon\fP.
The default is \fIrectangle\fP.
.TP 5
\fIdeiconifyWindow\fP
De-iconify the Gterm graphics window when activated.  The default is False.
.TP 5
\fIdialogBgColor\fP
Dialog box (i.e. the status line) background color.  Dialog text is text which
is drawn into the dialog area at the bottom of the gterm window, it is 
transient and is not a permanent part of the graphics being drawn.  Dialog
text is normally used to interact with the user or to display messages
during program operation, without affecting the graphics being drawn.
.TP 5
\fIdialogFgColor\fP
Dialog box (i.e. status line) foreground color.
.TP 5
\fIginmodeBlinkInterval\fP
Graphics cursor blink interval, time is specified in milliseconds.  The
default is 0.
.TP 5
\fIginmodeCursor\fP
Graphics mode cursor type.  The default is a full screen cursor custom to
the widget.
.TP 5
\fIheight\fP
Height of the Gterm window.  The default is 480.
.TP 5
\fIidleCursor\fP
Cursor to use when not in graphics mode.  The default is a plus sign.
.TP 5
\fImarkerHighlightColor\fP
Highlight color for the active marker.  When the pointer moves into a marker
is it marked "active", the highlight color and width change to which marker
is active.  The default is green.
.TP 5
\fImarkerHighlightWidth\fP
Highlight width for the active marker. The default is 2.
.TP 5
\fImaxColors\fP
The maximum number of colors to use in the private global colormap, the
default is 216.  Out of this number 10 colors (the \fIcolor0\fP thru 
\fIcolor9\fP values) are reserved by the widget as static colors, the 
remainder may be allocated for images.
.TP 5
\fIraiseWindow\fP
Raise the window when active.  The default is False.
.TP 5
\fIwarpCursor\fP
Warp the cursor to the window when active.  The default is False.
.TP 5
\fIwidth\fP
Width of the Gterm window.  The default is 640.

.SH "GTERM WIDGET RESOURCES"

.SS "Class Hierarchy"
.PP
\fBCore -> Gterm\fP
.SS "Resources"
.PP
When creating a Gterm widget instance, the following resources are retrieved
from the arguments list or from the resource database:

.TS
center;
lB lB lB lB
l l l l.
Name	Class Type	Default	Description
=
alphaFont1	XFontStruct	nil2	Graphics fonts
alphaFont2	XFontStruct	5x8	      "
alphaFont3	XFontStruct	6x10	      "
alphaFont4	XFontStruct	7x13	      "
alphaFont5	XFontStruct	8x13	      "
alphaFont6	XFontStruct	9x15	      "
alphaFont7	XFontStruct	9x15	      "
alphaFont8	XFontStruct	9x15	      "
basePixel	Int	38	Base of private global colormap
busyCursor	String	watch	Cursor to use when application is busy
busyCursorBgColor	Foreground	white	Busy cursor background color
busyCursorFgColor	Foreground	black	Busy cursor foreground color
cacheRasters	String	whenNeeded	Save rasters as server pixmaps for faster access
cmapInitialize	Boolean	False	Initialize colormap at startup
cmapInterpolate	Boolean	True	Interpolate colormap
cmapName	String	default	Custom colormap name
cmapShadow	Int	10	Colormap shadow interval
cmapUpdate	Int	60	Colormap update interval
color0	Background	black	Default graphics background color
color1	Foreground	white	Default graphics foreground color
color2	Foreground	red	Optional drawing color
color3	Foreground	green	      "
color4	Foreground	blue	      "
color5	Foreground	cyan	      "
color6	Foreground	yellow	      "
color7	Foreground	magenta	      "
color8	Foreground	purple	      "
color9	Foreground	darkslategray	      "
copyOnResize	Boolean	True	Copy raster when resized
crosshairCursorColor	Foreground	red	Full-screen cursor color
defaultMarker	String	rectangle	Default marker type
deiconifyWindow	Boolean	False	Deiconify window when active
dialogBgColor	Foreground	yellow	Status line background color
dialogFgColor	Foreground	black	Status line foreground color
dialogFont1	XFontStruct	nil2	Status line fonts
dialogFont2	XFontStruct	5x8	      "
dialogFont3	XFontStruct	6x10	      "
dialogFont4	XFontStruct	7x13	      "
dialogFont5	XFontStruct	8x13	      "
dialogFont6	XFontStruct	9x15	      "
dialogFont7	XFontStruct	9x15	      "
dialogFont8	XFontStruct	9x15	      "
ginmodeBlinkInterval	Int	0	Graphics cursor blink interval
ginmodeCursor	String	full_crosshair	Graphics cursor type
ginmodeCursorBgColor	Foreground	black	Graphics cursor background color
ginmodeCursorFgColor	Foreground	white	Graphics cursor foreground color
height	Dimension	480	Height of graphics window
idleCursor	String	Plus	Idle cursor type
idleCursorBgColor	Foreground	white	Idle cursor background color
idleCursorFgColor	Foreground	black	Idle cursor foreground color
markerBoxKnotColor	Foreground	blue	Vertex knot color
markerBoxKnotSize	Int	0	Vertex knot size
markerBoxLineColor	Foreground	green	Marker border color
markerCircleKnotColor	Foreground	blue	Vertex knot color
markerCircleKnotSize	Int	0	Vertex knot size
markerCircleLineColor	Foreground	green	Marker border color
markerCursorBgColor	Foreground	black	Cursor background when in marker
markerCursorFgColor	Foreground	yellow	Cursor foreground when in marker
markerEllipseKnotColor	Foreground	blue	Vertex knot color
markerEllipseKnotSize	Int	0	Vertex knot size
markerEllipseLineColor	Foreground	green	Marker border color
markerFill	Boolean	False	Flood fill marker area with \fImarkerFillColor\fP
markerFillBgColor	Foreground	black	Fill area background color
markerFillColor	Foreground	slategray	Flood fill color
markerFillStyle	Int	FillSolid	Fill area style
markerHighlightColor	Foreground	green	Marker highlight color
markerHighlightWidth	Int	2	Marker highlight line width
markerLineKnotColor	Foreground	blue	Vertex knot color
markerLineKnotSize	Int	5	Vertex knot size
markerLineLineColor	Foreground	green	Line marker color
markerLineStyle	Int	LineSolid	Line marker line style
markerLineWidth	Int	1	Line marker width
markerPgonKnotColor	Foreground	blue	Vertex knot color
markerPgonKnotSize	Int	5	Vertex knot size
markerPgonLineColor	Foreground	green	Marker border color
markerRectKnotColor	Foreground	blue	Vertex knot color
markerRectKnotSize	Int	0	Vertex knot size
markerRectLineColor	Foreground	green	Marker border color
markerTextBgColor	Foreground	slategray	Text marker background color
markerTextBorder	Int	2	Text marker border width
markerTextColor	Foreground	yellow	Text marker text color
markerTextFont	XFontStruct	6x13	Text marker font
markerTextLineColor	Foreground	green	Text marker line color
markerTextString	String	NULL	Text string
markerTranslations	String	default	Marker event-to-actions translations
maxColors	Int	216	Max colors in custom colormap
maxMappings	Int	32	Max image mappings
maxRasters	Int	512	Max image rasters
nearEdge	Int	1	T{
Distance, in pixels, between pointer and marker edge required 
for translation actions for be in effect. 
T}
nearVertex	Int	4	T{
Distance, in pixels between pointer and marker vertex (i.e. \fIknot\fP)
required for translation actions for be in effect. 
T}
raiseWindow	Boolean	False	Raise window when active
translations	String	default	Event-to-actions translations
useTimers	Boolean	True	Ok to use timers
warpCursor	Boolean	False	Enable warp cursor when active
width	Dimension	640	Height of graphics window
xorFill	Boolean	False	Fill with GXxor
xorFillBgColor	Int	255	Xor-fill background color
xorFillColor	Int	2	Xor-fill color
.TE

.SH "GTERM WIDGET TRANSLATIONS AND ACTIONS"

.LP 
The default translations for a Gterm window are:
.TS
center;
r l. 
<Btn1Down>:	m_create()
<Btn2Down>:	crosshair(on)
<Btn2Motion>:	crosshair(on)
<Btn2Up>:	crosshair(off)
<EnterWindow>:	enter-window()
<LeaveWindow>:	leave-window()
<KeyPress>:	graphics-input()
<Motion>:	track-cursor()
.TE
.LP
The available action procedures for a Gterm window are:
.RS
.TP 20
\fIignore()\fP
Ignore an event.
.TP 20
\fIgraphics-input()\fP
Handle a graphics input request.
.TP 20
\fIcrosshair(on|off)\fP
Display a crosshair cursor.
.TP 20
\fItrack-cursor()\fP
Track crosshair cursor position.
.TP 20
\fIenter-window()\fP
Handle an EnterWindow event.
.TP 20
\fIleave-window()\fP
Handle an LeaveWindow event.
.TP 20
\fIreset()\fP
Do a soft reset of the Gterm widget.
.TP 20
\fIm_create()\fP
Create a new marker.  Valid types include 
.TS
center;
l l l l.
\fItext	line	polyline	rectangle
box	circle	ellipse	polygon\fP
.TE
The default is \fIrectangle\fP, if no type is given the default type 
specified by the \fImarkerType\fP resource will be used.
.RE

.SH "GTERM MARKER TRANSLATIONS AND ACTIONS"

.LP
The default translations for a marker are:

.TS
center;
r l. 
!Shift <Btn1Motion>:	m_rotateResize()
<Btn1Motion>:	m_moveResize()
!Shift <Btn1Down>:	m_raise()  m_markpos()
<Btn1Down>:	m_raise()  m_markposAdd()
<Btn1Up>:	m_redraw() m_destroyNull()
<Btn2Down>:	m_lower()
<Key>BackSpace:	m_deleteDestroy()
<Key>Delete:	m_deleteDestroy()
<KeyPress>:	m_input()
<Motion>:	track-cursor()
.TE

Translations affect only the currently active marker, the cursor must be
within \fInearEdge\fP pixels of a marker edge, or \fInearVertex\fP pixels
of a marker vertex to take effect.

The available action procedures for a marker are
.RS
.TP 18
\fIm_create(type)\fP
Create a new marker.  Valid types include 
.TS
center;
l l l l.
\fItext	line	polyline	rectangle
box	circle	ellipse	polygon\fP
.TE
The default is \fIrectangle\fP, if no type is given the default type 
specified by the \fImarkerType\fP resource will be used.
.TP 18
\fIm_destroy()\fP
Destroy the active marker.
.TP 18
\fIm_destroyNull()\fP
Destroy the active marker if it is null sized.
.TP 18
\fIm_set(attribute, value, ....)\fP
Set a marker attribute.  Valid attributes include 

.TS
center;
l l l l.
\fIactivated	autoRedraw	fill	fillBgColor
fillColor	fillPattern	fillStyle	font
height	highlightColor	imageText	knotColor
knotSize	lineColor	lineStyle	lineWidth
rotangle	sensitive	textBgColor	textBorder
textColor	translations	type	visible
width	x	y	\fP
.TE
.TP 18
\fIm_raise()\fP
Raise the active marker to the top of the display list.
.TP 18
\fIm_lower()\fP
Lower the active marker to the bottom of the display list.
.TP 18
\fIm_notify(event, event, ....)\fP
Notify any clients that have registered callbacks for the specified type 
of events.  Recognized events include 
.TS
center;
l l l.
\fInotify	\fImoveResize	\fImodify
\fIredraw	\fIdestroy	\fIinput
\fIfocusIn	\fIfocusOut	\fIconstraint\fP
.TE
.TP 18
\fIm_input()\fP
Notify any clients that have registered a input callback that a input event
has occurred. 
.TP 18
\fIm_markpos()\fP
Mark the current position of the marker, e.g., so that it can later be erased.
.TP 18
\fIm_markposAdd()\fP
Execute either the markpos or add action, depending upon
the pointer location.  If the pointer is over an active marker at a
location where the add action can be executed this is done, otherwise the
markpos action is executed.  
.TP 18
\fIm_redraw()\fP
Redraw the active marker.
.TP 18
\fIm_addPt()\fP
Add a point (i.e. vertex knot). \fIPolyline\fP and \fIpolygon\fP markers only.
.TP 18
\fIm_deletePt()\fP
Delete a point (i.e. vertex knot).
.TP 18
\fIm_movePt()\fP
Move a point (i.e. vertex knot). \fIPolyline\fP and \fIpolygon\fP markers only.
.TP 18
\fIm_deleteDestroy()\fP
Delete a point or destroy a marker, depending upon the pointer position. 
.TP 18
\fIm_move()\fP
Move a marker.
.TP 18
\fIm_resize()\fP
Resize a marker.
.TP 18
\fIm_moveResize()\fP
Move a point or marker, or resize a marker, depending upon the pointer
position.
.TP 18
\fIm_rotate()\fP
Rotate a marker.
.TP 18
\fIm_rotateResize()\fP
Rotate or resize a marker.  A marker is rotated if near a vertex know, or
resized if near an edge.
.RE

.SH "GTERM I/O ESCAPE SEQUENCES"
XGterm uses escape sequences to provide graphics emulation.
This protocol is an extension of the Tektronix 4012 graphics protocol.
The basic extensions are patterned after the Retrographics VT640 graphics
terminal, using GS (octal \\035, aka Ctrl-]) and CAN (octal \\030, aka
Ctrl-x) to switch between vt100 and graphics modes.
Additional extensions are defined to support advanced features such as
color, area fills, graphics erasure, setting the cursor location under
program control, interactive dialog via the "status line", and so on. 

While these escape sequences can be used directly, the best programmatic 
interface is to use the OBM (\fIObject Manager\fP) library supplied with 
the XGterm source as part of the X11IRAF package.  Any Tektronix-compatible
graphics library will suffice for producing vector graphics, the added
escape sequences used by the Gterm widget are required to make use of
imaging, area fills, the status line, etc.
 
All escape sequences begin with an \fBESC\fP character (octal \\033), followed
by up to three characters defining the action to be taken.  All strings in
capital letters refer to the ASCII code (e.g. \fILF\fP is the ASCII linefeed
code), a three digit number preceeded by a '\' refers to an octal code (e.g.
"\012" is octal 12) , all others are characters in the escape code (e.g.
"/bc" are the three characters '/', 'b', and 'c').

.SS "ESCAPE SEQUENCES"

.RS
.TP 15
\fBUS\fP
.sp -0.5
.TP 15
\fBCR\fP
Switch to alpha mode.  Characters are drawn in the graphics window at the
"current" position (normally set beforehand with a GS/US vector move),
using the alpha mode font. Receipt of any control code causes alpha mode to be
exited.

.TP 15
\fBGS\fP
Switch to vector polyline mode.
.sp -0.5
.TP 15
\fBFS\fP
Switch to vector polypoint mode.  
.sp -0.5
.TP 15
\fBRS\fP
Switch to vector mode, vertices are joined as a polygon.

With all three codes, vertices and points are accumulated in a buffer and
displayed when the buffer fills or when vector mode is terminated by receipt
of any control code.  A workstation open will be done if it hasn't already
been opened, no-op sequences GS-CAN are filtered out, since they would only
cause a pointless switch to the graphics frame and back without drawing.
The open workstation sequence is GS,US, or by the \fIxterm\fP graphics start
escape sequence "[?38h".

.TP 15
\fBEM\fP
Enter message mode.  In message mode input text is accumulated in a buffer
and eventually passed to the object manager, which delivers the message to
the referenced object.  Messages are used to download the user interface to
be executed by the object manager.  During execution, messages are used
to set the values of user interface parameters to allow the UI to track
the state of the client application.

.TP 15
\fBCAN\fP
Close workstation and enter command mode.
.TP 15
\fBBEL\fP
Ring the screen bell.

.TP 15
\fBENQ\fP
Return terminal status.  Returned values include the terminal mode, and alpha
cursor x and y position.
.TP 15
\fBSUB\fP
Initiate a cursor read, values are returned in window coordinates.
.TP 15
\fB/SUB\fP
Return window cursor position in raster coordinates.
.TP 15
\fBFF\fP
Clear the screen.
.TP 15
\fB/f\fP
Set current cursor position.
.TP 15
\fB0\fP
Set character size 0. (Currently ignored).
.sp -0.5
.TP 15
\fB1\fP
Set character size 1. (Currently ignored).
.sp -0.5
.TP 15
\fB2\fP
Set character size 2. (Currently ignored).
.sp -0.5
.TP 15
\fB3\fP
Set character size 3. (Currently ignored).
.TP 15
\fB/0d\fP
Set color index.
.sp -0.5
.TP 15
\fB/1d\fP
Clear graphics screen.
.sp -0.5
.TP 15
\fB/2d\fP
Invert graphics screen
.TP 15
\fB`\fP
Select line style 0. (Solid)
.sp -0.5
.TP 15
\fBa\fP
Select line style 1. (Dashed)
.sp -0.5
.TP 15
\fBb\fP
Select line style 2. (Dotted)
.sp -0.5
.TP 15
\fBc\fP
Select line style 3. (DashDot)
.sp -0.5
.TP 15
\fBd\fP
Select line style 4. (Dash3Dot)
.TP 15
\fB/0w\fP
Select line width 0.
.sp -0.5
.TP 15
\fB/1w\fP
Select line width 1.
.sp -0.5
.TP 15
\fB/2w\fP
Select line width 2.
.sp -0.5
.TP 15
\fB/nw\fP
Select line width 3.
.TP 15
\fB/0c\fP
Select line color 0.
.sp -0.5
.TP 15
\fB/1c\fP
Select line color 1.
.sp -0.5
.TP 15
\fB/2c\fP
Select line color 2.
.sp -0.5
.TP 15
\fB/3c\fP
Select line color 3.
.sp -0.5
.TP 15
\fB/4c\fP
Select line color 4.
.sp -0.5
.TP 15
\fB/5c\fP
Select line color 5.
.sp -0.5
.TP 15
\fB/6c\fP
Select line color 6.
.sp -0.5
.TP 15
\fB/7c\fP
Select line color 7.
.sp -0.5
.TP 15
\fB/8c\fP
Select line color 8.
.sp -0.5
.TP 15
\fB/9c\fP
Select line color 9.
.RE

.SS "IMAGING ESCAPE SEQUENCES"  

These are encoded as follows:

		\fBESC\fP <code> [ \fIP ; P\fP ; ... ] <\fIdata\fP>

where \fIcode\fR is a character sequence and \fIP\fP is an ASCII encoded
parameter described below.
.RS 
.TP 15
\fB/nc\fP
Select line color.  Parameter is the color number in the range 0-9.
.TP 15
\fBsre\fP
\fIReset\fP.  Parameters are "reset-str".
.TP 15
\fBssz\fP
\fIResize\fP. Parameters are "resize-str".
.TP 15
\fBrir\fP
\fIInitialize raster\fP.
.TP 15
\fBrcr\fP
\fICreate a raster\fP.  Parameters are raster number, type, width, height, and
depth.  Type is 1 for a normal (client) raster, 2 for cached in server memory,
or 0 if you don't care.  Depth may be 1, 8, 16, or 32.
.TP 15
\fBrde\fP
\fIDestroy a raster\fP.  Parameter is raster number.
.TP 15
\fBrqr\fP
\fIQuery a raster\fP.  Parameter is raster number.
Output parameters are status, type, width, height, and depth encoded in the
string ""\\033[5;%d;%d;%d;%d;%d]".
.TP 15
\fBrsr\fP
\fISelect a raster\fP.  Parameter is raster number.
.TP 15
\fBrwr\fP
\fIWrite pixels to a rectangular region of a raster\fP.  Parameters are raster 
number, encoding type (not used), x1, y1, nx, ny, and depth followed by 
(nx*ny) data pixels.
.TP 15
\fBrrd\fP
\fIRead from a rectangular region of a raster\fP.  Parameters are raster 
number, encoding type (not used), x1, y1, nx, ny, and depth followed by (nx*ny) 
data pixels.
.TP 15
\fBrrp\fP
\fIRefresh raster pixels\fP.  Parameters are raster number, coordinate type (0 
for pixel, 1 for NDC), x1, y1, nx, ny.
.TP 15
\fBrsp\fP
\fISet all the raster pixels in a region to a single color\fP.  Parameters are
raster number, coordinate type (0 for pixel, 1 for NDC), x1, y1, nx, ny,
color, and raster operand.  If nx=ny=0 the entire raster will be written. 
Raster operands include transient (octal 020), refresh_all (octal 040),
or refresh_none (octal 100).
.TP 15
\fBrco\fP
\fICopy a region of the source raster to a region of the
destination raster\fP.   Parameters are raster operand, source raster number,
source type, source x coord, source y coord, source width, source height,
destination raster number, destination type, destination x coord, destination
y coord, destination width, destination height, If the input and output 
regions are not the same size the subimage is automatically scaled to fit 
the destination region.  If the destination extent DNX or DNY is negative, 
the image is flipped in that axis.  The type of spatial scaling performed is 
determined by the scale factors (zoom, dezoom, or no scaling).  The rasterop 
argument is used to exercise fine control over how the mapping is performed,
e.g. to force a refresh, implement a transient mapping, or in the case of a
dezoom (many-to-one) mapping, select the antialiasing technique to be used. 
.TP 15
\fBrwc\fP
\fIWrite a colormap\fP.  Parameters are colormap number, first color and the
number of colors followed by NC colors triples in the data.
.TP 15
\fBrrc\fP
\fIReturn the color assignments for a region of the named colormap\fP.
Parameters are colormap number, first color and the number of colors followed
by NC colors triples in the data.
.TP 15
\fBrlc\fP
\fILoad a colormap into the display\fP, optionally scaling the colormap via a
linear transformation in the process.  Parameters are the colormap number, the
offset value, and the cursor x and Y coordinates in NDC units.  The colormap is
unaffected if offset=0.5, scale=1.0.  A negative scale inverts the image.
If map=0 the linear transformation is applied directly to the display colormap.
.TP 15
\fBrfc\fP
\fIFree a colormap\fP.  Parameter is the colormap number.
.TP 15
\fBrwo\fP
\fIWrite the IOmap\fP. Parameters are the first color and the number of colors,
followed by NC color triples in the data.  An iomap is an optional lookup 
table used to isolate the client application from the color model used within
the Gterm widget.  To simplify color allocation the Gterm widget defines a 
logical color space where color 0 is the background, 1 the foreground, 2-N are
statically allocated standard colors, and colors N+1 and above are dynamically
allocated by the graphics application.  Less-demanding applications use
only the statically allocated, shared colors.  The widget internally maps
these logical colors to whatever the window system requires, but providing
a well-defined logical color space isolates the client from the details of
color allocation in the underlying window system.

An iomap can be used to define a mapping between the color model of the
client application and the Gterm color model (when we say color model here
we mean color allocation schemes for 8 bit pseudocolor).  By default the
iomap is one-to-one.  The use of an iomap frees the client from having to
worry about color index translations, and allows color tables to be
combined in the widget for greater efficiency when color tables are serially
applied.  The iomap applies to all color indices or pixel values passed
in i/o operations between the client and the Gterm widget.
.TP 15
\fBrro\fP
\fIRead the IOmap\fP.  Return values are the first color and the number of
colors, followed by NC color triples in the data.
.TP 15
\fBrim\fP
\fIDelete all mappings\fP and initialize the mapping subsystem.
.TP 15
\fBrsm\fP
\fIDefine a new mapping function\fP, or modify an old one.
If a new mapping is defined it is merely enabled, and no refreshing
of the screen takes place until either some mapped data is written
to or the mapping is explicitly refreshed.  If an existing mapping is
modified the old and new mappings are examined and only those portions
of the destination rect for which the mapping changed are updated.
This permits minor changes to a mapping (e.g. moving an edge) without
having to redraw the entire region.  Regions of the destination drawable
which were previously covered by the mapping but which were exposed by
modifying the mapping are redrawn.
.TP 15
\fBrgm\fP
\fIReturn the external parameters of a mapping\fP.  Parameter is the mapping
number, values returned (in the string 
"\\033[6;%d;%d %d;%d;%d;%d;%d;%d %d;%d;%d;%d;%d;%d]") are the mapping 
number, rasterop, source mapping, type, x, y, width, height, and destination
mapping, type, x, y, width and height.
.TP 15
\fBrem\fP
\fIEnable a mapping\fP. Parameters are the mapping number and an integer
flag indicating whether to refresh the mapping.
.TP 15
\fBrdm\fP
\fIDisable a mapping\fP. Disabling a mapping does not
affect the mapping definition, hence a disabled mapping may later be
reenabled. Parameters are the mapping number and an integer flag indicating
whether to erase the mapping.
.TP 15
\fBrrm\fP
\fIRefresh a mapping\fP. Parameter is the mapping number.
.TP 15
\fBrfm\fP
\fIFree a mapping\fP. Parameter is the mapping number.
.RE

.SH "MORE ON IMAGING"
The imaging model of the Gterm widget defines the following key object or
data types: \fIrasters\fP, \fImappings\fP, and \fIcolors\fP.
.TP 10
.B "raster"
A raster is a MxN array of pixels.  At present pixels are 8 bits deep but 
hooks are built into the widget to expand this in the future.  Pixel 
values are indices into the Gterm virtual colormap, with values starting at 
zero.  A raster may be any size.  A raster is merely a two-dimensional array
in the graphics server; it is not displayed unless mapped.  An exception is
raster zero, which is the graphics window.  Rasters are referred to by number,
starting with zero.  Initially only raster zero exists; new rasters are created
with the create raster escape code \fBrcr\fP.  Space for rasters may be
allocated either in the graphics server, or in the X server.  This has 
implications on performance but is otherwise transparent to the client.
By default rasters are allocated in the graphics server, i.e., in the X client.
.TP 10
.B "mapping"
A mapping defines a projection of a rectangle of the source raster onto a
rectangle of the destination raster.  Mappings may be either enabled (active)
or disabled.  When a mapping is enabled, any change to a pixel in the source
rect will cause the corresponding pixels in the destination rect to be
updated.  Mappings are referred to by number starting with one.  Initially 
no mappings are defined.  If the size of the input and output rect is not 
the same the input rect will be scaled by pixel replication or subsampling 
to fill the output rect.  If the argument DW (destination width) or DH 
(destination height) of the destination rect is negative, the image will be
flipped around the corresponding axis when copied to the destination; the
region of the destination drawn into is the same in either case.  Multiple
mappings may reference the same source or destination raster.  Mappings are
refreshed in order by the mapping number.  Modifying a mapping causes the 
changed regions of the destination rect to be refreshed.
.TP 10
.B "color"
The \fIGterm\fP widget provides a fixed number of preassigned colors 
corresponding to pixel values 0 through 9. Zero is the background color,
one is the foreground color, and 2-9 (8 colors) are arbitrary colors defined
by Gterm widget resources.  These static colors are normally used to draw 
the background, frame, axes, titles, etc. of a plot, or to draw color 
graphics within the drawing area.  The advantage of static colors is that
they are shared with other X clients, and the values of these colors may be
assigned by the user to personalize the way plots look.

The \fIGterm\fP widget also allows any number (up to about 200 or so) additional
colors to be defined at runtime by the client application.  These color 
values start at pixel value 10 and go up to the maximum pixel value assigned
by the client.  The client application allocates colors with the
write colormap escape code \fBrwc\fP.  Attempts to overwrite the values of
the static colors are ignored.  The values of already allocated colors may
be changed dynamically at runtime using write colormap code to write the 
desired range of color values.

Applications should not assume that there are 10 static colors and 200 or 
so allocatable colors.  The IRAF graphcap entry for the logical device in use,
and resources set for the widget,
defines these parameters for the device.  Alternatively, the read colormap 
code may be used to dynamically determine how many colors the server has
preallocated when the application starts up.

An image may use either static and dynamic pixel values or both types of 
values, but in most cases imaging applications involve smoothly shaded 
surfaces hence will require dynamically assigned private colors.

If for some reason the client application cannot use the \fIGterm\fP widget
color model, the IOMAP feature can be used to make the widget appear to have
some externally defined (i.e., client defined) color model.
.LP
The maximum number of rasters and maximum number of mappings is defined by
the Gterm widget resources \fImaxRaster\fP and \fImaxMappings\fP (or in the
GUI file) when the graphics application starts up.  The maximum values should
be much larger than most applications require.  Applications should allocate
raster or mapping numbers sequentially starting at 1 (more or less) to avoid
running out of raster or mapping descriptors.

The {read|write}pixels escape codes operate directly on
raster pixels.  The mapping escape codes support two alternative coordinate
systems, raster pixels and NDC (normalized device coordinates), as indicated
by the ST or DT argument (source or destination coordinate type).  Note
that the origin of the pixel coordinate system is the upper left corner of
the display window (consistent with most graphics systems), whereas the origin
of the NDC coordinate system is the lower left corner (consistent with IRAF).

Pixel coordinates allow precise control of imaging but require the
application to know the window size, and may result in complications e.g. if
the window is resized.  NDC coordinates pretty much guarantee that a mapping
will involve sampling, hence are not the most efficient, but the graphics
will be drawn correctly no matter how the window is resized and for most
applications the performance difference is negligible.  Most applications
should use NDC coordinates for raster 0 (the display window), and pixel
coordinates for rasters 1-N.

Although the size of rasters 1 and higher are defined by the client
application, the size of raster zero, the actual gterm display window, is
subject to the constraints of the window system.  The client can attempt to
reset the size of the gterm window using create raster escape with raster=0,
however the Gterm widget, UI containing the \fIGterm\fP widget, and the window
manager are all free to deny such a request.  The query raster escape should be
called to determine the actual size of the window one will be drawing into.

.SS AN EXAMPLE IMAGING APPLICATION

.LP
An example of a simple imaging application might be one that downloads an
image and displays it in the gterm window, filling the window.  This could
be done as follows (following a graphics open and other escape codes to
prepare the drawing surface).

.TP 15
\fIcreate raster\fP
Create raster 1 the size of the pixel array to be displayed. This need not 
be the same as the size of the gterm display window.
.TP 15
\fIset mapping\fP
Define a mapping between raster 1 and raster 0, the display window, using 
NDC coordinates to define the region of the display window to be
filled.  The mapping number is arbitrary but mappings should normally be 
allocated starting with 1. The mapping is automatically enabled
when first defined.
.TP 15
\fIwrite colormap\fP
(Optional).  Define the pixel value to RGB color assignments for the image 
pixels.
.TP 15
\fIwrite pixels\fP
This escape is called one or more times to write pixels into raster 1.  
At most 32K pixels can be written in each call.  As each write is
made the affected region of the display window will be updated.
.LP
Alternatively, one could write the pixels and then define the mapping to
cause the entire image to be displayed at once.

Note that the imaging escape can be combined with normal graphics to draw text
and graphics around or on top of an image region.  The order in which drawing
operations occur is important, e.g., to draw graphics or text on top of an
image the image should be drawn first.

.SH "MARKERS"
Markers are a general feature of the \fIGterm\fP widget and are used more
extensively in other programs (e.g. the prototype IRAF science GUI 
applications), but they have no real use in \fIxgterm\fP when used as 
simply a graphics terminal. All markers share some of the same characteristics,
so it is worthwhile learning basic marker manipulation keystrokes (as defined
using the default marker translations), especially how to delete an 
accidentally created marker:
.RS
.TP 3
\fBo\fP
\fIDelete\fP or \fIBackspace\fP in a marker deletes it.
.TP 3
\fBo\fP
MB1 anywhere inside a marker may be used to drag the marker.
.TP 3
\fBo\fP
MB1 near a marker corner or edge, depending on the type of marker, 
resizes the marker.
.TP 3
\fBo\fP
Shift-MB1 on the corner of most markers will rotate the marker.
.TP 3
\fBo\fP
Markers stack, if you have several markers and you put one on top of
the other. The active marker is highlighted to tell you which of the
stacked markers is active. If the markers overlap, this will be marker
"on top" in the stacking order.
.TP 3
\fBo\fP
MB2 in the body of a marker "lowers" the marker, i.e. moves it to the
bottom of the stacking order.
.RE

.SH ENVIRONMENT
.I XGterm
sets the environment variables ``TERM'' and ``TERMCAP'' properly for the
size window you have created.
It also uses and sets the environment
variable ``DISPLAY'' to specify which bit map display terminal to use.
The environment variable ``WINDOWID'' is set to the X window id number
of the \fIxgterm\fP window.

.SH "SEE ALSO"
xterm(1), resize(1), X(1), pty(4), tty(4)
.br
\fIXterm Control Sequences\fP (in the \fIxterm\fP source directory)

.SH BUGS
Many of the same bugs affecting \fIxterm\fP also apply here.

\fIXgterm\fP is not normally installed with setuid permissions.  On some
Linux systems, for example, where the /dev/tty and /dev/pty devices have
root ownership and permission 600 this can cause problems.  Workarounds
are to either install \fIXGterm\fP with setuid permissions or modify the
/dev/tty and /dev/pty devices to have permission 666.

.SH COPYRIGHT
Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.

