#include "wxMathml.h"

wxMathML::wxMathML()
    { 
      m_wxMathML =
	wxString(
	"(format t \"<suppressOutput>\")\n"
	";; wxMaxima xml format (based on David Drysdale MathML printing)\n"
	";; Andrej Vodopivec,  2004-2014\n"
	";; Gunter Königsmann, 2014-2018\n"
	";;  SPDX-License-Identifier: GPL-2.0+\n"
	"\n"
	";; MathML-printing\n"
	";; Created by David Drysdale (DMD), December 2002/January 2003\n"
	";;\n"
	";; closely based on the original TeX conversion code in mactex.lisp,\n"
	";; for which the following credits apply:\n"
	";;   (c) copyright 1987, Richard J. Fateman\n"
	";;   small corrections and additions: Andrey Grozin, 2001\n"
	";;   additional additions: Judah Milgram (JM), September 2001\n"
	";;   additional corrections: Barton Willis (BLW), October 2001\n"
	";; Method:\n"
	"\n"
	";; Producing wxml from a Maxima internal expression is done by\n"
	";; a reversal of the parsing process.  Fundamentally, a\n"
	";; traversal of the expression tree is produced by the program,\n"
	";; with appropriate substitutions and recognition of the\n"
	";; infix / prefix / postfix / matchfix relations on symbols. Various\n"
	";; changes are made to this so that MathML will like the results.\n"
	"\n"
	";(format t \"<wxxml-start/>\")\n"
	"\n"
	";; This is necessary to make file and directory names that contain special characters\n"
	";; work under windows.\n"
	"(progn\n"
	"  #+sbcl (setf sb-impl::*default-external-format* :UTF-8)\n"
	"\n"
	"  (in-package :maxima)\n"
	"\n"
	"  (declare-top\n"
	"   (special lop rop $inchar)\n"
	"   (*expr wxxml-lbp wxxml-rbp))\n"
	"\n"
	"  ;; Use rounded parenthesis for matrices by default\n"
	"  (setq $lmxchar #\\()\n"
	"  (setq $rmxchar #\\()\n"
	"\n"
	"  ;; A few variables whose value can be configured from wxMaxima\n"
	"  (defvar *wx-plot-num* 0 \"The serial number of the current plot\")\n"
	"  (defvar $wxfilename \"\" \"The filename of the current wxMaxima worksheet\")\n"
	"  (defvar $wxdirname \"\" \"The directory the current wxMaxima worksheet lies in\")\n"
	"  (defvar $wxanimate_autoplay nil \"Automatically playback new animations?\")\n"
	"  (defvar wxUserConfDir \"\" \"The location wxMaxima looks for maxima\'s config files in\")\n"
	"  (defvar wxHelpDir \"\" \"The location wxMaxima searches for help files in\")\n"
	"  (defvar wxMaximaLispLocation \"\" \"The location wxMaxima searches for lisp files in\")\n"
	"  (defvar $wxplot_size \'((mlist simp) 800 600) \"The size of new plots\")\n"
	"  (defvar $wxmaximaversion t \"The wxMaxima version\")\n"
	"  (defprop $wxmaximaversion read-only-assign assign)\n"
	"  (defvar $wxwidgetsversion t \"The wxWidgets version wxMaxima is using.\")\n"
	"  (defvar $wxsubscripts t\n"
	"    \"Recognize TeX-style subscripts\")\n"
	"  (defvar $wxplot_pngcairo nil \"Use gnuplot\'s pngcairo terminal for new plots?\")\n"
	"  (defmvar $wxplot_old_gnuplot nil)\n"
	"\n"
	"\n"
	"  ;; Escape all chars that need escaping in XML\n"
  "  (defun wxxml-fix-string (x)\n"
  "    (if (stringp x)\n"
  "	(let* ((tmp-x (string-substitute \"&amp;\" #\\& x))\n"
  "	       (tmp-x (string-substitute \"&lt;\" #\\< tmp-x))\n"
  "	       (tmp-x (string-substitute \"&gt;\" #\\> tmp-x))\n"
  "	       (tmp-x (string-substitute \"&#13;\" #\\Return tmp-x))\n"
  "	       (tmp-x (string-substitute \"&#13;\" #\\Linefeed tmp-x))\n"
  "	       (tmp-x (string-substitute \"&#13;\" #\\Newline tmp-x)))\n"
  "	  tmp-x)\n"
  "      x))\n"
	"\n") +
	wxString(
  "  ;; Allow the user to communicate what to display in the statusbar whilst\n"
  "  ;; the current program is running\n"
  "  (defun $wxstatusbar (&rest status)\n"
  "    (format t \"<statusbar>~a</statusbar>~%\" (wxxml-fix-string\n"
  "					     (apply \'$sconcat status))))\n"
  "\n"
  "\n"
  ";;; Without this command encountering unicode characters might cause\n"
  ";;; Maxima to stop responding on windows.\n"
  "  #+(and clisp win32) (setf (stream-external-format *socket-connection*) charset:utf-8)\n"
  "  #+(and clisp win32) (setf custom:*default-file-encoding* charset:utf-8)\n"
  "\n"
  ";;; Muffle compiler-notes globally\n"
  "  #+sbcl (declaim (sb-ext:muffle-conditions sb-ext:compiler-note))\n"
  "  (defmacro no-warning (form)\n"
  "    #+sbcl `(handler-bind\n"
  "		((style-warning #\'muffle-warning)\n"
  "		 (sb-ext:compiler-note #\'muffle-warning))\n"
  "	      ,form)\n"
  "    #+clisp `(let ((custom:*suppress-check-redefinition* t)) ,form)\n"
  "    #-(or sbcl clisp) `(progn ,form))\n"
  "\n"
  "  (defun read-wxmaxima-version (v)\n"
  "    (let* ((d1 (position #\\. v))\n"
  "	   (year (subseq v 0 d1))\n"
  "	   (d2 (position #\\. v :start (1+ d1)))\n"
  "	   (month (subseq v (1+ d1) d2))\n"
  "	   (rest (subseq v (1+ d2))))\n"
  "      (list \'(mlist simp) (parse-integer year) (parse-integer month) rest)))\n"
  "\n"
  "  (defun $wxbuild_info ()\n"
  "    (let ((year (sixth cl-user:*maxima-build-time*))\n"
  "	  (month (fifth cl-user:*maxima-build-time*))\n"
  "	  (day (fourth cl-user:*maxima-build-time*))\n"
  "	  (hour (third cl-user:*maxima-build-time*))\n"
  "	  (minute (second cl-user:*maxima-build-time*))\n"
  "	  (seconds (first cl-user:*maxima-build-time*)))\n"
  "      (format t \"wxMaxima version: ~a~%\" $wxmaximaversion)\n"
  "      (format t \"using wxWidgets version: ~a~%\" $wxwidgetsversion)\n"
  "      (format t \"Maxima version: ~a~%\" *autoconf-version*)\n"
  "      (format t \"Maxima build date: ~4,\'0d-~2,\'0d-~2,\'0d ~2,\'0d:~2,\'0d:~2,\'0d~%\"\n"
  "	      year month day hour minute seconds)\n"
  "      (format t \"Host type: ~a~%\" *autoconf-host*)\n"
  "      (format t \"System type: ~a ~a ~a~%\" (software-type) (software-version) (machine-type))\n"
  "      (format t \"Lisp implementation type: ~a~%\" (lisp-implementation-type))\n"
  "      (format t \"Lisp implementation version: ~a~%\" (lisp-implementation-version))\n"
  "      (format t \"~%~%wxMaxima\'s idea of the directory layout is:~%User configuration dir: ~a~%\" wxUserConfDir)\n"
  "      (format t \"Help dir: ~a~%\" wxHelpDir)\n"
  "      (format t \"Maxima lisp dir: ~a~%\" wxMaximaLispLocation))\n"
  "    \"\")\n"
  "\n"
  "  (defmfun $wxbug_report ()\n"
  "    (format t \"wxMaxima is a graphical front end for Maxima, which does the mathematics in the background.~%\")\n"
  "    (format t \"If you encounter a mathematical problem, it is probably a Maxima bug und should be submitted there.~%\")\n"
  "    (format t \"~%The Maxima bug database is available at~%\")\n"
  "    (format t \"    https://sourceforge.net/p/maxima/bugs~%\")\n"
	"    (format t \"Submit bug reports by following the \'Create Ticket\' link on that page.~%\")\n"
	"    (format t \"To report a Maxima bug, you must have a Sourceforge account.~%~%\")\n"
	"    (format t \"A problem in the graphical user interface is probably a wxMaxima bug.~%\")\n"
	"    (format t \"The wxMaxima bug database is available at~%\")\n"
	"    (format t \"    https://github.com/wxMaxima-developers/wxmaxima/issues?direction=desc&sort=created&state=open~%\")\n"
	"    (format t \"Submit bug reports by following the \'New issue\' link on that page.~%~%\")\n"
	"    (format t \"Please check before submitting, if your bug was already reported.~%~%\")\n"
	"    (format t \"Please include the following information with your bug report:~%\")\n"
	"    (format t \"-------------------------------------------------------------~%\")\n"
	"    ($wxbuild_info)\n"
	"    (format t \"-------------------------------------------------------------~%\"))\n"
	"\n"
	"  (defvar *var-tag* \'(\"<v>\" \"</v>\"))\n"
	"\n"
	"  (defun wxxml-get (x p)\n"
	"    (if (symbolp x) (get x p)))\n"
	"\n"
	"  (defun wxxml-array (x l r &aux f)\n"
	"    (if (eq \'mqapply (caar x))\n"
	"	(setq f (cadr x)\n"
	"	      x (cdr x)\n"
	"	      l (wxxml f (append l (list \"<i><p>\")) (list \"</p>\")\n"
	"		       \'mparen \'mparen))\n"
	"      (setq f (caar x)\n"
	"	    l (wxxml f (append l \'(\"<i><r>\"))\n"
	"		     (list \"</r>\") lop \'mfunction)))\n"
	"    (setq r (nconc (wxxml-list (cdr x) (list \"<r>\")\n"
	"			       (list \"</r></i>\") \"<v>,</v>\") r))\n"
	"    (nconc l r))\n"
	"\n"
	"  (defmacro make-tag (val tag)\n"
	"    ``((wxxmltag simp) ,,val ,,tag))\n"
	"\n"
	"  (defun $wxxmltag (val tag)\n"
	"    (make-tag ($sconcat val) ($sconcat tag)))\n"
	"\n"
	"  (defun string-substitute (newstring oldchar x &aux matchpos)\n"
	"    (setq matchpos (position oldchar x))\n"
	"    (if (null matchpos) x\n"
	"      (concatenate \'string\n"
	"		   (subseq x 0 matchpos)\n"
	"		   newstring\n"
	"		   (string-substitute newstring oldchar\n"
	"				      (subseq x (1+ matchpos))))))\n"
	"\n"
	";;; First we have the functions which are called directly by wxxml and its\n"
	";;; descendants\n"
	"  (defun $wxdeclare_subscript (x &optional (opt t))\n"
	"    (unless (listp x)\n"
	"      (setq x (list \'(mlist simp) x)))\n"
	"    (dolist (s (cdr x))\n"
	"      ($put s opt \'$wxxml_subscript))\n"
	"    opt)\n"
	"\n"
	"  (defun $wxdeclare_subscripted (x &optional (opt t))\n"
	"    (unless (listp x)\n"
	"      (setq x (list \'(mlist simp) x)))\n"
  "    (dolist (s (cdr x))\n"
  "      ($put s opt \'$wxxml_subscripted))\n"
  "    opt)\n"
  "\n"
  "  (defun subscriptp (x)\n"
  "    (unless (symbolp x)\n"
  "      (return-from subscriptp x))\n"
  "    (let* ((name (subseq (maybe-invert-string-case (symbol-name x)) 1))\n"
  "	   (pos (search \"_\" name :from-end t))\n"
  "	   #-gcl (*readtable* (copy-readtable nil)))\n"
  "      #-gcl (setf (readtable-case *readtable*) :invert)\n"
  "      (when pos\n"
  "	(let* ((sub (subseq name (+ pos 1)))\n"
  "	       (sub-var (subseq name 0 pos))\n"
  "	       (sub-var-symb (read-from-string (concatenate \'string \"$\" sub-var)))\n"
  "	       (sub-symb (read-from-string (concatenate \'string \"$\" sub)))\n"
  "	       (sub-int (ignore-errors\n"
  "			  (parse-integer sub))))\n"
  "	  (when (and (> (length sub-var) 0)\n"
  "		     (or sub-int\n"
  "			 (eq $wxsubscripts \'$all)\n"
  "			 (= (length sub) 1)\n"
  "			 (= (length sub-var) 1)\n"
  "			 ($get x \'$wxxml_subscripted)\n"
  "			 ($get sub-symb \'$wxxml_subscript)))\n"
  "	    (format nil  \"<i altCopy=\\\"~{~a~}\\\"><r>~a</r><r>~a</r></i>\"\n"
  "		    (mstring x)\n"
  "		    (or (get sub-var-symb \'wxxmlword)\n"
  "			(format nil \"<v>~a</v>\" sub-var))\n"
  "		    (if sub-int\n"
  "			(format nil \"<n>~a</n>\" sub-int)\n"
  "                      (format nil \"<v>~a</v>\" sub))))))))\n"
  "\n"
  "  (defun wxxmlnumformat (atom)\n"
  "    (let (r firstpart exponent)\n"
  "      (cond ((integerp atom)\n"
  "	     (format nil \"<n>~{~c~}</n>\" (exploden atom)))\n"
  "	    (t\n"
  "	     (setq r (exploden atom))\n"
  "	     (setq exponent (member \'e r :test #\'string-equal))\n"
  "	     (cond ((null exponent)\n"
  "		    (format nil \"<n>~{~c~}</n>\" r))\n"
  "		   (t\n"
  "		    (setq firstpart\n"
  "			  (nreverse (cdr (member \'e (reverse r)\n"
  "						 :test #\'string-equal))))\n"
  "		    (if (char= (cadr exponent) #\\+)\n"
  "			(setq exponent (cddr exponent))\n"
  "		      (setq exponent (cdr exponent)))\n"
  "		    (format nil\n"
  "			    \"<r><n>~{~c~}</n><h>*</h><e><n>10</n><n>~{~c~}</n></e></r>\"\n"
  "			    firstpart exponent)))))))\n"
  "\n"
  "  (defun wxxml-stripdollar (sym &aux pname)\n"
  "    (or (symbolp sym)\n"
  "	(return-from wxxml-stripdollar\n"
  "		     (wxxml-fix-string (format nil \"~a\" sym))))\n"
  "    (setq pname (maybe-invert-string-case (symbol-name sym)))\n"
  "    (setq pname (cond ((and (> (length pname) 0)\n"
  "			    (member (elt pname 0) \'(#\\$ #\\&) :test #\'eq))\n"
  "		       (subseq pname 1))\n"
  "		      ((and (> (length pname) 0)\n"
  "			    (equal (elt pname 0) #\\%))\n"
  "		       (if $noundisp\n"
  "			   (concatenate \'string \"\'\"\n"
  "					(subseq pname 1))\n"
  "			 (subseq pname 1)))\n"
  "		      ($lispdisp\n"
  "		       (concatenate \'string \"?\" pname))\n"
  "		      (t pname)))\n"
  "    (setq pname (wxxml-fix-string pname))\n"
  "    (concatenate \'string (car *var-tag*) pname (cadr *var-tag*)))\n"
  "\n"
  "  (defun wxxml-atom (x l r &aux tmp-x)\n"
  "    (append l\n"
  "	    (list (cond ((numberp x) (wxxmlnumformat x))\n"
  "			((and (symbolp x) (get x \'wxxmlword)))\n"
  "			((and (symbolp x) (get x \'reversealias))\n"
  "			 (wxxml-stripdollar (get x \'reversealias)))\n"
  "			((stringp x)\n"
  "			 (setq tmp-x (wxxml-fix-string x))\n"
  "			 (if (and (boundp \'$stringdisp) $stringdisp)\n"
  "			     (setq tmp-x (format nil \"\\\"~a\\\"\" tmp-x)))\n"
  "			 (concatenate \'string \"<st>\" tmp-x \"</st>\"))\n"
  "			((arrayp x)\n"
  "			 (format nil \"<v>#{Lisp array [~{~a~^,~}]}</v>\"\n"
  "				 (array-dimensions x)))\n"
  "			((functionp x)\n"
  "			 (format nil \"<v>~a</v>\"\n"
  "				 (wxxml-fix-string\n"
  "				  (stripdollar\n"
  "				   (maybe-invert-string-case (format nil \"~A\" x))))))\n"
  "			((streamp x)\n"
  "			 (format nil \"<v>#{Stream [~A]</v>}\"\n"
  "				 (stream-element-type x)))\n"
  "			((member (type-of x) \'(GRAPH DIGRAPH))\n"
  "			 (format nil \"<v>~a</v>\" x))\n"
  "			((typep x \'structure-object)\n"
  "			 (let ((tmp-string (format nil \"~s\" x)))\n"
  "			   (format nil \"<st>~a</st>\" (wxxml-fix-string tmp-string))))\n"
  "			((hash-table-p x)\n"
  "			 (format nil \"<v>#{HashTable}</v>\"))\n"
  "			((and $wxsubscripts (subscriptp x)))\n"
  "			(t (wxxml-stripdollar x))))\n"
  "	    r))\n"
  "\n"
  "  ;; we could patch this so sin x rather than sin(x), but instead we made\n"
  "  ;; sin a prefix operator\n"
  "  (defun wxxml-function (x l r)\n"
  "    (setq l\n"
  "	  (let ((*var-tag* \'(\"<fnm>\" \"</fnm>\")))\n"
  "	    (wxxml (caar x) (append l \'(\"<fn>\"))\n"
  "		   nil \'mparen \'mparen))\n"
  "	  r (wxxml (cons \'(mprogn) (cdr x)) nil (append \'(\"</fn>\") r)\n"
  "		   \'mparen \'mparen))\n"
  "    (append l r))\n"
  "\n"
  "  (defun wxxml-defstruct (x l r)\n"
  "    (let ((L1 (cdr (get (caar x) \'defstruct-template)))\n"
  "	  (L2 (cdr x)))\n"
  "      (wxxml-function\n"
  "       (cons (car x)\n"
  "	     (mapcar #\'(lambda (e1 e2) (if (eq e1 e2) e1 `((mequal) ,e1 ,e2))) L1 L2))\n"
  "       l r)))\n"
  "\n"
  "  (defun wxxml-matchfix-dim (x l r)\n"
  "    (setq l (append l\n"
  "		    (list (wxxml-dissym-to-string (car (get (caar x) \'dissym)))))\n"
  "	  r (append (list (wxxml-dissym-to-string (cdr (get (caar x) \'dissym))))\n"
  "		    r)\n"
  "	  x (wxxml-list (cdr x) nil r \"<t>,</t>\"))\n"
  "    (append l x))\n"
  "\n"
  "  (defun wxxml-nary (x l r)\n"
  "    (let* ((op (caar x))\n"
  "	   (sym (cond ((member op \'(mtimes wxtimes) :test #\'eq)\n"
  "		       (if $stardisp\n"
  "			   \"<t>*</t>\"\n"
  "			 \"<h>*</h>\"))\n"
  "					;((wxxmlsym op))\n"
  "		      ((eq (get op \'dimension) \'dimension-nary)\n"
  "		       (wxxml-dissym-to-string (get op \'dissym)))))\n"
  "	   (y (cdr x))\n"
  "	   (ext-lop lop)\n"
  "	   (ext-rop rop))\n"
  "      (cond ((null y)\n"
  "	     (wxxml-function x l r)) ; this should not happen\n"
  "	    ((null (cdr y))\n"
  "	     (wxxml-function x l r)) ; this should not happen, too\n"
  "	    (t (do ((nl) (lop ext-lop op)\n"
  "		    (rop op (if (null (cdr y)) ext-rop op)))\n"
  "		   ((null (cdr y))\n"
  "		    (setq nl (nconc nl (wxxml (car y) l r lop rop))) nl)\n"
  "		   (setq nl (nconc nl (wxxml (car y) l (list sym) lop rop))\n"
  "			 y (cdr y)\n"
  "			 l nil))))))\n"
  "\n") + wxString(
  "  (defun wxxml (x l r lop rop)\n"
  "    ;; x is the expression of interest; l is the list of strings to its\n"
  "    ;; left, r to its right. lop and rop are the operators on the left\n"
  "    ;; and right of x in the tree, and will determine if parens must\n"
  "    ;; be inserted\n"
  "    (setq x (nformat x))\n"
  "    (cond ((atom x) (wxxml-atom x l r))\n"
  "	  ((not (listp (car x)))\n"
  "	   (wxxml (cons \'(mlist simp) x) l r lop rop))\n"
  "	  ((or (<= (wxxml-lbp (caar x)) (wxxml-rbp lop))\n"
  "	       (> (wxxml-lbp rop) (wxxml-rbp (caar x))))\n"
  "	   (wxxml-paren x l r))\n"
  "	  ;; special check needed because macsyma notates arrays peculiarly\n"
  "	  ((member \'array (cdar x) :test #\'eq) (wxxml-array x l r))\n"
  "	  ;; dispatch for object-oriented wxxml-ifiying\n"
  "	  ((wxxml-get (caar x) \'wxxml) (funcall (get (caar x) \'wxxml) x l r))\n"
  "	  ((equal (wxxml-get (caar x) \'dimension) \'dimension-infix)\n"
  "	   (wxxml-infix x l r))\n"
  "	  ((equal (wxxml-get (caar x) \'dimension) \'dimension-match)\n"
  "	   (wxxml-matchfix-dim x l r))\n"
  "	  ((equal (wxxml-get (caar x) \'dimension) \'dimension-nary)\n"
  "	   (wxxml-nary x l r))\n"
  "	  ((equal (wxxml-get (caar x) \'dimension) \'dimension-postfix)\n"
  "	   (wxxml-postfix x l r))\n"
  "	  ((wxxml-get (caar x) \'defstruct-template)\n"
  "	   (wxxml-defstruct x l r))\n"
  "	  (t (wxxml-function x l r))))\n"
  "\n"
  "  (defun wxxml-paren (x l r)\n"
  "    (wxxml x (append l \'(\"<r><p>\")) (cons \"</p></r>\" r) \'mparen \'mparen))\n"
  "\n"
  "  ;; set up a list , separated by symbols (, * ...)  and then tack on the\n"
  "  ;; ending item (e.g. \"]\" or perhaps \")\"\n"
  "  (defun wxxml-list (x l r sym)\n"
  "    (if (null x) r\n"
  "      (do ((nl))\n"
  "	  ((null (cdr x))\n"
  "	   (setq nl (nconc nl (wxxml (car x)  l r \'mparen \'mparen)))\n"
  "	   nl)\n"
  "	  (setq nl (nconc nl (wxxml (car x)  l (list sym) \'mparen \'mparen))\n"
  "		x (cdr x)\n"
  "		l nil))))\n"
  "\n"
  ";;; Now we have functions which are called via property lists\n"
  "\n"
  "  (defun wxxml-prefix (x l r)\n"
  "    (wxxml (cadr x) (append l (wxxmlsym (caar x))) r (caar x) rop))\n"
  "\n"
  "  (defun wxxml-infix (x l r)\n"
  "    ;; check for 2 args\n"
  "    (if (or (null (cddr x)) (cdddr x)) (wna-err (caar x)))\n"
  "    (setq l (wxxml (cadr x) l nil lop (caar x)))\n"
  "    (wxxml (caddr x) (append l (wxxmlsym (caar x))) r (caar x) rop))\n"
  "\n"
  "  (defun wxxml-postfix (x l r)\n"
  "    (wxxml (cadr x) l (append (wxxmlsym (caar x)) r) lop (caar x)))\n"
  "\n"
  "  (defun wxxml-nofix (x l r) (wxxml (caar x) l r (caar x) rop))\n"
  "\n"
  "  (defun wxxml-matchfix (x l r)\n"
  "    (setq l (append l (car (wxxmlsym (caar x))))\n"
  "	  ;; car of wxxmlsym of a matchfix operator is the lead op\n"
  "	  r (append (cdr (wxxmlsym (caar x))) r)\n"
  "	  ;; cdr is the trailing op\n"
  "	  x (wxxml-list (cdr x) nil r \"<t>,</t>\"))\n"
  "    (append l x))\n"
  "\n"
  "\n"
  "  (defun wxxml-dissym-to-string (lst &aux pname)\n"
  "    (setq pname\n"
  "	  (wxxml-fix-string (format nil \"~{~a~}\" lst)))\n"
  "    (concatenate \'string \"<v>\" pname \"</v>\"))\n"
  "\n"
  "  (defun wxxmlsym (x)\n"
  "    (or (get x \'wxxmlsym)\n"
  "	(get x \'strsym)\n"
  "	(and (get x \'dissym)\n"
  "	     (list (wxxml-dissym-to-string (get x \'dissym))))\n"
  "	(list (stripdollar x))))\n"
  "\n"
  "  (defun wxxmlword (x)\n"
  "    (or (get x \'wxxmlword)\n"
  "	(stripdollar x)))\n"
  "\n"
  "  (defprop bigfloat wxxml-bigfloat wxxml)\n"
  "\n"
  "  ;;(defun mathml-bigfloat (x l r) (declare (ignore l r)) (fpformat x))\n"
  "  (defun wxxml-bigfloat (x l r)\n"
  "    (append l \'(\"<n>\") (fpformat x) \'(\"</n>\") r))\n"
  "\n"
  "  (defprop mprog  \"<fnm>block</fnm>\" wxxmlword)\n"
  "  (defprop $true  \"<t>true</t>\"  wxxmlword)\n"
  "  (defprop $false \"<t>false</t>\" wxxmlword)\n"
  "\n"
  "  (defprop mprogn wxxml-matchfix wxxml)\n"
  "  (defprop mprogn ((\"<r><p>\") \"</p></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop mlist wxxml-matchfix wxxml)\n"
  "  (defprop mlist ((\"<r><t>[</t>\")\"<t>]</t></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop $set wxxml-matchfix wxxml)\n"
  "  (defprop $set ((\"<r><t>{</t>\")\"<t>}</t></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop mabs wxxml-matchfix wxxml)\n"
  "  (defprop mabs ((\"<r><a>\")\"</a></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop $conjugate wxxml-matchfix wxxml)\n"
  "  (defprop $conjugate ((\"<r><cj>\")\"</cj></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop %conjugate wxxml-matchfix wxxml)\n"
  "  (defprop %conjugate ((\"<r><cj>\")\"</cj></r>\") wxxmlsym)\n"
  "\n"
  "  (defprop mbox wxxml-mbox wxxml)\n"
  "  (defprop mlabox wxxml-mbox wxxml)\n"
  "\n"
  "  (defprop mbox 10. wxxml-rbp)\n"
  "  (defprop mbox 10. wxxml-lbp)\n"
  "\n"
  "  (defprop mlabbox 10. wxxml-rbp)\n"
  "  (defprop mlabbox 10. wxxml-lbp)\n"
  "\n"
  "  (defun wxxml-mbox (x l r)\n"
  "    (setq l (wxxml (cadr x) (append l \'(\"<r><hl>\")) nil \'mparen \'mparen)\n"
  "	  r (append \'(\"</hl></r>\") r))\n"
  "    (append l r))\n"
  "\n"
  "  (defprop mqapply wxxml-mqapply wxxml)\n"
  "\n"
  "  (defun wxxml-mqapply (x l r)\n"
  "    (setq l (wxxml (cadr x) (append l \'(\"<fn>\"))\n"
  "		   (list \"<p>\" ) lop \'mfunction)\n"
  "	  r (wxxml-list (cddr x) nil (cons \"</p></fn>\" r) \"<t>,</t>\"))\n"
  "    (append l r))\n"
  "\n"
  "\n"
  "  (defprop $zeta \"<g>zeta</g>\" wxxmlword)\n"
  "  (defprop %zeta \"<g>zeta</g>\" wxxmlword)\n"
  "\n"
  "  ;;\n"
  "  ;; Greek characters\n"
  "  ;;\n"
  "  (defprop $%alpha \"<g>%alpha</g>\" wxxmlword)\n"
  "  (defprop $alpha \"<g>alpha</g>\" wxxmlword)\n"
  "  (defprop $%beta \"<g>%beta</g>\" wxxmlword)\n"
  "  (defprop $beta \"<g>beta</g>\" wxxmlword)\n"
  "  (defprop $%gamma \"<g>%gamma</g>\" wxxmlword)\n"
  "  (defprop %gamma \"<g>gamma</g>\" wxxmlword)\n"
  "  (defprop $%delta \"<g>%delta</g>\" wxxmlword)\n"
  "  (defprop $delta \"<g>delta</g>\" wxxmlword)\n"
  "  (defprop $%epsilon \"<g>%epsilon</g>\" wxxmlword)\n"
  "  (defprop $epsilon \"<g>epsilon</g>\" wxxmlword)\n"
  "  (defprop $%zeta \"<g>%zeta</g>\" wxxmlword)\n"
  "  (defprop $%eta \"<g>%eta</g>\" wxxmlword)\n"
  "  (defprop $eta \"<g>eta</g>\" wxxmlword)\n"
  "  (defprop $%theta \"<g>%theta</g>\" wxxmlword)\n"
  "  (defprop $theta \"<g>theta</g>\" wxxmlword)\n"
  "  (defprop $%iota \"<g>%iota</g>\" wxxmlword)\n"
  "  (defprop $iota \"<g>iota</g>\" wxxmlword)\n"
  "  (defprop $%kappa \"<g>%kappa</g>\" wxxmlword)\n"
  "  (defprop $kappa \"<g>kappa</g>\" wxxmlword)\n"
  "  (defprop $%lambda \"<g>%lambda</g>\" wxxmlword)\n"
  "  (defprop $lambda \"<g>lambda</g>\" wxxmlword)\n"
  "  (defprop $%mu \"<g>%mu</g>\" wxxmlword)\n"
  "  (defprop $mu \"<g>mu</g>\" wxxmlword)\n"
  "  (defprop $%nu \"<g>%nu</g>\" wxxmlword)\n"
  "  (defprop $nu \"<g>nu</g>\" wxxmlword)\n"
  "  (defprop $%xi \"<g>%xi</g>\" wxxmlword)\n"
  "  (defprop $xi \"<g>xi</g>\" wxxmlword)\n"
  "  (defprop $%omicron \"<g>%omicron</g>\" wxxmlword)\n"
  "  (defprop $omicron \"<g>omicron</g>\" wxxmlword)\n"
  "  (defprop $%pi \"<s>%pi</s>\" wxxmlword)\n"
  "  (defprop $pi \"<g>pi</g>\" wxxmlword)\n"
  "  (defprop $%rho \"<g>%rho</g>\" wxxmlword)\n"
  "  (defprop $rho \"<g>rho</g>\" wxxmlword)\n"
  "  (defprop $%sigma \"<g>%sigma</g>\" wxxmlword)\n"
  "  (defprop $sigma \"<g>sigma</g>\" wxxmlword)\n"
  "  (defprop $%tau \"<g>%tau</g>\" wxxmlword)\n"
  "  (defprop $tau \"<g>tau</g>\" wxxmlword)\n"
  "  (defprop $%upsilon \"<g>%upsilon</g>\" wxxmlword)\n"
  "  (defprop $upsilon \"<g>upsilon</g>\" wxxmlword)\n"
  "  (defprop $%phi \"<g>%phi</g>\" wxxmlword)\n"
  "  (defprop $phi \"<g>phi</g>\" wxxmlword)\n"
  "  (defprop $%chi \"<g>%chi</g>\" wxxmlword)\n"
  "  (defprop $chi \"<g>chi</g>\" wxxmlword)\n"
  "  (defprop $%psi \"<g>%psi</g>\" wxxmlword)\n"
  "  (defprop $psi \"<g>psi</g>\" wxxmlword)\n"
  "  (defprop $%omega \"<g>%omega</g>\" wxxmlword)\n"
  "  (defprop $omega \"<g>omega</g>\" wxxmlword)\n"
  "  (defprop |$%Alpha| \"<g>%Alpha</g>\" wxxmlword)\n"
  "  (defprop |$Alpha| \"<g>Alpha</g>\" wxxmlword)\n"
  "  (defprop |$%Beta| \"<g>%Beta</g>\" wxxmlword)\n"
  "  (defprop |$Beta| \"<g>Beta</g>\" wxxmlword)\n"
  "  (defprop |$%Gamma| \"<g>%Gamma</g>\" wxxmlword)\n"
  "  (defprop |$Gamma| \"<g>Gamma</g>\" wxxmlword)\n"
  "  (defprop |$%Delta| \"<g>%Delta</g>\" wxxmlword)\n"
  "  (defprop |$Delta| \"<g>Delta</g>\" wxxmlword)\n"
  "  (defprop |$%Epsilon| \"<g>%Epsilon</g>\" wxxmlword)\n"
  "  (defprop |$Epsilon| \"<g>Epsilon</g>\" wxxmlword)\n"
  "  (defprop |$%Zeta| \"<g>%Zeta</g>\" wxxmlword)\n"
  "  (defprop |$Zeta| \"<g>Zeta</g>\" wxxmlword)\n"
  "  (defprop |$%Eta| \"<g>%Eta</g>\" wxxmlword)\n"
  "  (defprop |$Eta| \"<g>Eta</g>\" wxxmlword)\n"
  "  (defprop |$%Theta| \"<g>%Theta</g>\" wxxmlword)\n"
  "  (defprop |$Theta| \"<g>Theta</g>\" wxxmlword)\n"
  "  (defprop |$%Iota| \"<g>%Iota</g>\" wxxmlword)\n"
  "  (defprop |$Iota| \"<g>Iota</g>\" wxxmlword)\n"
  "  (defprop |$%Kappa| \"<g>%Kappa</g>\" wxxmlword)\n"
  "  (defprop |$Kappa| \"<g>Kappa</g>\" wxxmlword)\n"
  "  (defprop |$%Lambda| \"<g>%Lambda</g>\" wxxmlword)\n"
  "  (defprop |$Lambda| \"<g>Lambda</g>\" wxxmlword)\n"
  "  (defprop |$%Mu| \"<g>%Mu</g>\" wxxmlword)\n"
  "  (defprop |$Mu| \"<g>Mu</g>\" wxxmlword)\n"
  "  (defprop |$%Nu| \"<g>%Nu</g>\" wxxmlword)\n"
  "  (defprop |$Nu| \"<g>Nu</g>\" wxxmlword)\n"
  "  (defprop |$%Xi| \"<g>%Xi</g>\" wxxmlword)\n"
  "  (defprop |$Xi| \"<g>Xi</g>\" wxxmlword)\n"
  "  (defprop |$%Omicron| \"<g>%Omicron</g>\" wxxmlword)\n"
  "  (defprop |$Omicron| \"<g>Omicron</g>\" wxxmlword)\n"
  "  (defprop |$%Rho| \"<g>%Rho</g>\" wxxmlword)\n"
  "  (defprop |$Rho| \"<g>Rho</g>\" wxxmlword)\n"
  "  (defprop |$%Sigma| \"<g>%Sigma</g>\" wxxmlword)\n"
  "  (defprop |$Sigma| \"<g>Sigma</g>\" wxxmlword)\n"
  "  (defprop |$%Tau| \"<g>%Tau</g>\" wxxmlword)\n"
  "  (defprop |$Tau| \"<g>Tau</g>\" wxxmlword)\n"
  "  (defprop |$%Upsilon| \"<g>%Upsilon</g>\" wxxmlword)\n"
  "  (defprop |$Upsilon| \"<g>Upsilon</g>\" wxxmlword)\n"
  "  (defprop |$%Phi| \"<g>%Phi</g>\" wxxmlword)\n"
  "  (defprop |$Phi| \"<g>Phi</g>\" wxxmlword)\n"
  "  (defprop |$%Chi| \"<g>%Chi</g>\" wxxmlword)\n"
  "  (defprop |$Chi| \"<g>Chi</g>\" wxxmlword)\n"
  "  (defprop |$%Psi| \"<g>%Psi</g>\" wxxmlword)\n"
  "  (defprop |$Psi| \"<g>Psi</g>\" wxxmlword)\n"
  "  (defprop |$%Omega| \"<g>%Omega</g>\" wxxmlword)\n"
  "  (defprop |$Omega| \"<g>Omega</g>\" wxxmlword)\n"
  "  (defprop |$%Pi| \"<g>%Pi</g>\" wxxmlword)\n"
  "  (defprop |$Pi| \"<g>Pi</g>\" wxxmlword)\n"
  "\n"
  "  (defprop $%i \"<s>%i</s>\" wxxmlword)\n"
  "  (defprop $%e \"<s>%e</s>\" wxxmlword)\n"
  "  (defprop $inf \"<s>inf</s>\" wxxmlword)\n"
  "  (defprop $minf \"<t>-</t><s>inf</s>\" wxxmlword)\n"
  "\n"
  "  (defprop mreturn \"return\" wxxmlword)\n"
  "\n"
  "  (defprop mquote wxxml-prefix wxxml)\n"
  "  (defprop mquote (\"<t>\'</t>\") wxxmlsym)\n"
  "  (defprop mquote \"<t>\'</t>\" wxxmlword)\n"
  "  (defprop mquote 201. wxxml-rbp)\n"
  "\n"
  "  (defprop msetq wxxml-infix wxxml)\n"
  "  (defprop msetq (\"<t>:</t>\") wxxmlsym)\n"
  "  (defprop msetq \"<t>:</t>\" wxxmlword)\n"
  "  (defprop msetq 180. wxxml-rbp)\n"
  "  (defprop msetq 20. wxxml-rbp)\n"
  "\n"
  "  (defprop mset wxxml-infix wxxml)\n"
  "  (defprop mset (\"<t>::</t>\") wxxmlsym)\n"
  "  (defprop mset \"<t>::</t>\" wxxmlword)\n"
  "  (defprop mset 180. wxxml-lbp)\n"
  "  (defprop mset 20. wxxml-rbp)\n"
  "\n"
  "  (defprop mdefine wxxml-infix wxxml)\n"
  "  (defprop mdefine (\"<t>:=</t>\") wxxmlsym)\n"
  "  (defprop mdefine \"<t>:=</t>\" wxxmlword)\n"
  "  (defprop mdefine 180. wxxml-lbp)\n"
  "  (defprop mdefine 20. wxxml-rbp)\n"
  "\n"
	"  (defprop mdefmacro wxxml-infix wxxml)\n"
	"  (defprop mdefmacro (\"<t>::=</t>\") wxxmlsym)\n"
	"  (defprop mdefmacro \"<t>::=</t>\" wxxmlword)\n"
	"  (defprop mdefmacro 180. wxxml-lbp)\n"
	"  (defprop mdefmacro 20. wxxml-rbp)\n"
	"\n"
	"  (defprop marrow wxxml-infix wxxml)\n"
	"  (defprop marrow (\"<t>-></t>\") wxxmlsym)\n"
	"  (defprop marrow \"<t>-></t>\" wxxmlword)\n"
	"  (defprop marrow 25 wxxml-lbp)\n"
	"  (defprop marrow 25 wxxml-rbp)\n"
	"\n"
	"  (defprop mfactorial wxxml-postfix wxxml)\n"
	"  (defprop mfactorial (\"<t>!</t>\") wxxmlsym)\n"
	"  (defprop mfactorial \"<t>!</t>\" wxxmlword)\n"
	"  (defprop mfactorial 160. wxxml-lbp)\n"
	"\n"
	"  (defprop mexpt wxxml-mexpt wxxml)\n"
	"  (defprop mexpt 140. wxxml-lbp)\n"
	"  (defprop mexpt 139. wxxml-rbp)\n"
	"\n"
	"  (defprop %sum 90. wxxml-rbp)\n"
	"  (defprop %product 95. wxxml-rbp)\n"
	"\n"
	"  ;; insert left-angle-brackets for mncexpt. a^<t> is how a^^n looks.\n"
	"\n"
	"  (defun wxxml-mexpt (x l r)\n"
	"    (cond ((atom (cadr x))\n"
	"	   (wxxml-mexpt-simple x l r))\n"
	"	  ((member \'array (caadr x))\n"
	"	   (wxxml-mexpt-array x l r))\n"
	"	  (t\n"
	"	   (wxxml-mexpt-simple x l r))))\n"
	"\n"
	"  (defun wxxml-mexpt-array (x l r)\n"
	"    (let* ((nc (eq (caar x) \'mncexpt))\n"
	"	   f (xarr (cadr x))\n"
	"	   (xexp (nformat (caddr x))))\n"
	"      ;; the index part\n"
	"      (if (eq \'mqapply (caar xarr))\n"
	"	  (setq f (cadr xarr)\n"
	"		xarr (cdr xarr)\n"
	"		l (wxxml f (append l (list \"<ie><p>\")) (list \"</p>\")\n"
	"			 \'mparen \'mparen))\n"
	"	(setq f (caar xarr)\n"
	"	      l (wxxml f (append l (if nc\n"
	"				       (list \"<ie mat=\\\"true\\\"><r>\")\n"
	"				     (list \"<ie><r>\")))\n"
	"		       (list \"</r>\") lop \'mfunction)))\n"
	"      (setq  l (append l (wxxml-list (cdr xarr) (list \"<r>\")\n"
	"				     (list \"</r>\") \"<v>,</v>\")))\n"
	"      ;; The exponent part\n"
	"      (setq r (if (mmminusp xexp)\n"
	"		  ;; the change in base-line makes parens unnecessary\n"
	"		  (wxxml (cadr xexp) \'(\"<r><v>-</v>\")\n"
	"			 (cons \"</r></ie>\" r) \'mparen \'mparen)\n"
	"		(if (and (integerp xexp) (< xexp 10))\n"
	"		    (wxxml xexp nil\n"
	"			   (cons \"</ie>\" r) \'mparen \'mparen)\n"
	"		  (wxxml xexp (list \"<r>\")\n"
	"			 (cons \"</r></ie>\" r) \'mparen \'mparen)\n"
	"		  )))\n"
	"      (append l r)))\n"
	"\n"
	"  (defun wxxml-mexpt-simple (x l r)\n"
	"    (let((nc (eq (caar x) \'mncexpt)))\n"
	"      (setq l (wxxml (cadr x) (append l (if nc\n"
	"					    \'(\"<e mat=\\\"true\\\"><r>\")\n"
	"					  \'(\"<e><r>\")))\n"
	"		     nil lop (caar x))\n"
	"	    r (if (mmminusp (setq x (nformat (caddr x))))\n"
	"		  ;; the change in base-line makes parens unnecessary\n"
	"		  (wxxml (cadr x) \'(\"</r><r><v>-</v>\")\n"
	"			 (cons \"</r></e>\" r) \'mminus \'mminus)\n"
	"		(if (and (integerp x) (< x 10))\n"
	"		    (wxxml x (list \"</r>\")\n"
	"			   (cons \"</e>\" r) \'mparen \'mparen)\n"
	"		  (wxxml x (list \"</r><r>\")\n"
	"			 (cons \"</r></e>\" r) \'mparen \'mparen)\n"
	"		  )))\n"
	"      (append l r)))\n"
	"\n"
	"  (defprop mncexpt wxxml-mexpt wxxml)\n"
	"\n"
	"  (defprop mncexpt 135. wxxml-lbp)\n"
	"  (defprop mncexpt 134. wxxml-rbp)\n"
	"\n"
	"  (defprop mnctimes wxxml-nary wxxml)\n"
	"  (defprop mnctimes \"<t>.</t>\" wxxmlsym)\n"
	"  (defprop mnctimes \"<t>.</t>\" wxxmlword)\n"
	"  (defprop mnctimes 110. wxxml-lbp)\n"
	"  (defprop mnctimes 109. wxxml-rbp)\n"
	"\n"
	"  (defprop mtimes wxxml-nary wxxml)\n"
	"  (defprop mtimes \"<h>*</h>\" wxxmlsym)\n"
	"  (defprop mtimes \"<t>*</t>\" wxxmlword)\n"
	"  (defprop mtimes 120. wxxml-lbp)\n"
	"  (defprop mtimes 120. wxxml-rbp)\n"
	"\n"
	"  (defprop wxtimes wxxml-nary wxxml)\n"
	"  (defprop wxtimes \"<h>*</h>\" wxxmlsym)\n"
	"  (defprop wxtimes \"<t>*</t>\" wxxmlword)\n"
	"  (defprop wxtimes 120. wxxml-lbp)\n"
	"  (defprop wxtimes 120. wxxml-rbp)\n"
	"\n"
	"  (defprop %sqrt wxxml-sqrt wxxml)\n"
	"\n"
	"  (defun wxxml-sqrt (x l r)\n"
	"    (wxxml (cadr x) (append l  \'(\"<q>\"))\n"
	"	   (append \'(\"</q>\") r) \'mparen \'mparen))\n"
	"\n"
	"  (defprop mquotient wxxml-mquotient wxxml)\n"
	"  (defprop mquotient (\"<t>/</t>\") wxxmlsym)\n"
	"  (defprop mquotient \"<t>/</t>\" wxxmlword)\n"
	"  (defprop mquotient 122. wxxml-lbp) ;;dunno about this\n"
	"  (defprop mquotient 123. wxxml-rbp)\n"
	"\n"
	"  (defun wxxml-mquotient (x l r)\n"
	"    (if (or (null (cddr x)) (cdddr x)) (wna-err (caar x)))\n"
	"    (setq l (wxxml (cadr x) (append l \'(\"<f><r>\")) nil \'mparen \'mparen)\n"
	"	  r (wxxml (caddr x) (list \"</r><r>\")\n"
	"		   (append \'(\"</r></f>\")r) \'mparen \'mparen))\n"
	"    (append l r))\n"
	"\n"
	"  (defprop $matrix wxxml-matrix-test wxxml)\n"
	"\n"
	"  (defun wxxml-matrix-test (x l r)\n"
	"    (if (every #\'$listp (cdr x))\n"
	"	(wxxml-matrix x l r)\n"
	"      (wxxml-function x l r)))\n"
  "\n") + wxString(
	"  (defun wxxml-matrix(x l r) ;;matrix looks like ((mmatrix)((mlist) a b) ...)\n"
	"    (cond ((null (cdr x))\n"
	"	   (append l `(\"<fn><fnm>matrix</fnm><p/></fn>\") r))\n"
	"	  ((and (null (cddr x))\n"
	"		(null (cdadr x)))\n"
	"	   (append l `(\"<fn><fnm>matrix</fnm><p><t>[</t><t>]</t></p></fn>\") r))\n"
	"	  (t\n"
	"	   (append l (cond\n"
	"		      ((find \'inference (car x))\n"
	"		       (list \"<tb inference=\\\"true\\\">\"))\n"
	"		      ((find \'special (car x))\n"
	"		       (list (format nil \"<tb special=\\\"true\\\" rownames=~s colnames=~s>\"\n"
	"				     (if (find \'rownames (car x)) \"true\" \"false\")\n"
	"				     (if (find \'colnames (car x)) \"true\" \"false\"))))\n"
	"		      ((string= $lmxchar #\\()\n"
	"		       (list \"<tb roundedParens=\\\"true\\\">\"))\n"
	"		      (t\n"
	"		       (list \"<tb>\")))\n"
	"		   (mapcan #\'(lambda (y)\n"
	"			       (cond ((null (cdr y))\n"
	"				      (list \"<mtr><mtd><mspace/></mtd></mtr>\"))\n"
	"				     (t\n"
	"				      (wxxml-list (cdr y)\n"
	"						  (list \"<mtr><mtd>\")\n"
	"						  (list \"</mtd></mtr>\")\n"
	"						  \"</mtd><mtd>\"))))\n"
	"			   (cdr x))\n"
	"		   `(\"</tb>\") r))))\n"
	"\n"
	"  ;; macsyma sum or prod is over integer range, not  low <= index <= high\n"
	"  ;; wxxml is lots more flexible .. but\n"
	"\n"
	"  (defprop %sum wxxml-sum wxxml)\n"
	"  (defprop %lsum wxxml-lsum wxxml)\n"
	"  (defprop %product wxxml-sum wxxml)\n"
	"  (defprop $sum wxxml-sum wxxml)\n"
	"  (defprop $lsum wxxml-lsum wxxml)\n"
	"  (defprop $product wxxml-sum wxxml)\n"
	"\n"
	"  ;; easily extended to union, intersect, otherops\n"
	"\n"
	"  (defun wxxml-lsum(x l r)\n"
	"    (let ((op \"<sm type=\\\"lsum\\\"><r>\")\n"
	"	  ;; gotta be one of those above\n"
	"	  (s1 (wxxml (cadr x) nil nil \'mparen rop));; summand\n"
	"	  (index ;; \"index = lowerlimit\"\n"
	"	   (wxxml `((min simp) , (caddr x), (cadddr x))\n"
	"		  nil nil \'mparen \'mparen)))\n"
	"      (append l `(,op ,@index\n"
	"		      \"</r><r><mn/></r><r>\"\n"
	"		      ,@s1 \"</r></sm>\") r)))\n"
	"\n"
	"  (defun wxxml-sum(x l r)\n"
	"    (let ((op (if (or (eq (caar x) \'%sum)\n"
	"		      (eq (caar x) \'$sum))\n"
	"		  \"<sm><r>\"\n"
	"		\"<sm type=\\\"prod\\\"><r>\"))\n"
	"	  (s1 (wxxml (cadr x) nil nil \'mparen rop));; summand\n"
	"	  (index ;; \"index = lowerlimit\"\n"
	"	   (wxxml `((mequal simp) ,(caddr x) ,(cadddr x))\n"
	"		  nil nil \'mparen \'mparen))\n"
	"	  (toplim (wxxml (car (cddddr x)) nil nil \'mparen \'mparen)))\n"
	"      (append l `( ,op ,@index \"</r><r>\" ,@toplim\n"
	"		       \"</r><r>\"\n"
	"		       ,@s1 \"</r></sm>\") r)))\n"
	"\n"
	"  (defprop %integrate wxxml-int wxxml)\n"
	"  (defprop $integrate wxxml-int wxxml)\n"
	"\n"
	"  (defun wxxml-int (x l r)\n"
	"    (let ((s1 (wxxml (cadr x) nil nil \'mparen \'mparen));;integrand delims / & d\n"
	"	  (var (wxxml (caddr x) nil nil \'mparen rop))) ;; variable\n"
	"      (cond ((= (length x) 3)\n"
	"	     (append l `(\"<in def=\\\"false\\\"><r>\"\n"
	"			 ,@s1\n"
	"			 \"</r><r><s>d</s>\"\n"
	"			 ,@var\n"
	"			 \"</r></in>\") r))\n"
	"	    (t ;; presumably length 5\n"
	"	     (let ((low (wxxml (nth 3 x) nil nil \'mparen \'mparen))\n"
	"		   ;; 1st item is 0\n"
	"		   (hi (wxxml (nth 4 x) nil nil \'mparen \'mparen)))\n"
	"	       (append l `(\"<in><r>\"\n"
	"			   ,@low\n"
	"			   \"</r><r>\"\n"
	"			   ,@hi\n"
	"			   \"</r><r>\"\n"
	"			   ,@s1\n"
	"			   \"</r><r><s>d</s>\"\n"
	"			   ,@var \"</r></in>\") r))))))\n"
	"\n"
	"  (defprop %limit wxxml-limit wxxml)\n"
	"\n"
	"  (defprop mrarr wxxml-infix wxxml)\n"
	"  (defprop mrarr (\"<t>-></t>\") wxxmlsym)\n"
	"  (defprop mrarr 80. wxxml-lbp)\n"
	"  (defprop mrarr 80. wxxml-rbp)\n"
	"\n"
	"  (defun wxxml-limit (x l r) ;; ignoring direction, last optional arg to limit\n"
	"    (let ((s1 (wxxml (second x) nil nil \'mparen rop));; limitfunction\n"
	"	  (subfun ;; the thing underneath \"limit\"\n"
	"	   (wxxml `((mrarr simp) ,(third x)\n"
	"		    ,(fourth x)) nil nil \'mparen \'mparen)))\n"
	"      (case (fifth x)\n"
	"	    ($plus\n"
	"	     (append l `(\"<lm><fnm>lim</fnm><r>\"\n"
	"			 ,@subfun \"<v>+</v></r><r>\"\n"
	"			 ,@s1 \"</r></lm>\") r))\n"
	"	    ($minus\n"
	"	     (append l `(\"<lm><fnm>lim</fnm><r>\"\n"
	"			 ,@subfun \"<t>-</t></r><r>\"\n"
	"			 ,@s1 \"</r></lm>\") r))\n"
	"	    (otherwise\n"
	"	     (append l `(\"<lm><fnm>lim</fnm><r>\"\n"
	"			 ,@subfun \"</r><r>\"\n"
	"			 ,@s1 \"</r></lm>\") r)))))\n"
	"\n"
	"  (defprop %at wxxml-at wxxml)\n"
	"  ;; e.g.  at(diff(f(x)),x=a)\n"
	"  (defun wxxml-at (x l r)\n"
	"    (let ((s1 (wxxml (cadr x) nil nil lop rop))\n"
	"	  (sub (wxxml (caddr x) nil nil \'mparen \'mparen)))\n"
	"      (append l \'(\"<at><r>\") s1\n"
	"	      \'(\"</r><r>\") sub \'(\"</r></at>\") r)))\n"
	"\n"
	"  ;;binomial coefficients\n"
	"\n"
	"  (defprop %binomial wxxml-choose wxxml)\n"
	"\n"
	"\n"
	"  (defun wxxml-choose (x l r)\n"
	"    `(,@l\n"
	"      \"<p print=\\\"no\\\"><f line=\\\"no\\\"><r>\"\n"
	"      ,@(wxxml (cadr x) nil nil \'mparen \'mparen)\n"
	"      \"</r><r>\"\n"
	"      ,@(wxxml (caddr x) nil nil \'mparen \'mparen)\n"
	"      \"</r></f></p>\"\n"
	"      ,@r))\n"
	"\n"
	"\n"
	"  (defprop rat wxxml-rat wxxml)\n"
	"  (defprop rat 120. wxxml-lbp)\n"
	"  (defprop rat 121. wxxml-rbp)\n"
	"  (defun wxxml-rat(x l r) (wxxml-mquotient x l r))\n"
	"\n"
	"  (defprop mplus wxxml-mplus wxxml)\n"
	"  (defprop mplus 100. wxxml-lbp)\n"
	"  (defprop mplus 100. wxxml-rbp)\n"
	"\n"
	"  (defun wxxml-mplus (x l r)\n"
	"    (cond ((member \'trunc (car x) :test #\'eq)\n"
	"	   (setq r (cons \"<v>+</v><t>...</t>\" r))))\n"
	"    (cond ((null (cddr x))\n"
	"	   (if (null (cdr x))\n"
	"	       (wxxml-function x l r)\n"
	"	     (wxxml (cadr x) l r \'mplus rop)))\n"
	"	  (t (setq l (wxxml (cadr x) l nil lop \'mplus)\n"
	"		   x (cddr x))\n"
	"	     (do ((nl l)  (dissym))\n"
	"		 ((null (cdr x))\n"
	"		  (if (mmminusp (car x)) (setq l (cadar x) dissym\n"
	"					       (list \"<v>-</v>\"))\n"
	"		    (setq l (car x) dissym (list \"<v>+</v>\")))\n"
	"		  (setq r (wxxml l dissym r \'mplus rop))\n"
	"		  (append nl r))\n"
	"		 (if (mmminusp (car x)) (setq l (cadar x) dissym\n"
	"					      (list \"<v>-</v>\"))\n"
	"		   (setq l (car x) dissym (list \"<v>+</v>\")))\n"
	"		 (setq nl (append nl (wxxml l dissym nil \'mplus \'mplus))\n"
	"		       x (cdr x))))))\n"
	"\n"
	"  (defprop mminus wxxml-prefix wxxml)\n"
	"  (defprop mminus (\"<v>-</v>\") wxxmlsym)\n"
	"  (defprop mminus \"<v>-</v>\" wxxmlword)\n"
	"  (defprop mminus 101. wxxml-rbp)\n"
	"  (defprop mminus 101. wxxml-lbp)\n"
	"\n"
	"  (defprop $~ wxxml-infix wxxml)\n"
	"  (defprop $~ (\"<t>~</t>\") wxxmlsym)\n"
	"  (defprop $~ \"<t>~</t>\" wxxmlword)\n"
	"  (defprop $~ 134. wxxml-lbp)\n"
	"  (defprop $~ 133. wxxml-rbp)\n"
	"\n"
	"  (defprop min wxxml-infix wxxml)\n"
	"  (defprop min (\"<fnm>in</fnm>\") wxxmlsym)\n"
	"  (defprop min \"<fnm>in</fnm>\" wxxmlword)\n"
	"  (defprop min 80. wxxml-lbp)\n"
	"  (defprop min 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mequal wxxml-infix wxxml)\n"
	"  (defprop mequal (\"<v>=</v>\") wxxmlsym)\n"
	"  (defprop mequal \"<v>=</v>\" wxxmlword)\n"
	"  (defprop mequal 80. wxxml-lbp)\n"
	"  (defprop mequal 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mnotequal wxxml-infix wxxml)\n"
	"  (defprop mnotequal (\"<t>#</t>\") wxxmlsym)\n"
	"  (defprop mnotequal 80. wxxml-lbp)\n"
	"  (defprop mnotequal 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mgreaterp wxxml-infix wxxml)\n"
	"  (defprop mgreaterp (\"<t>&gt;</t>\") wxxmlsym)\n"
	"  (defprop mgreaterp \"<t>&gt;</t>\" wxxmlword)\n"
	"  (defprop mgreaterp 80. wxxml-lbp)\n"
	"  (defprop mgreaterp 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mgeqp wxxml-infix wxxml)\n"
	"  (defprop mgeqp (\"<t>&gt;=</t>\") wxxmlsym)\n"
	"  (defprop mgeqp \"<t>&gt;=</t>\" wxxmlword)\n"
	"  (defprop mgeqp 80. wxxml-lbp)\n"
	"  (defprop mgeqp 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mlessp wxxml-infix wxxml)\n"
	"  (defprop mlessp (\"<t>&lt;</t>\") wxxmlsym)\n"
	"  (defprop mlessp \"<t>&lt;</t>\" wxxmlword)\n"
	"  (defprop mlessp 80. wxxml-lbp)\n"
	"  (defprop mlessp 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mleqp wxxml-infix wxxml)\n"
	"  (defprop mleqp (\"<t>&lt;=</t>\") wxxmlsym)\n"
	"  (defprop mleqp \"<t>&lt;=</t>\" wxxmlword)\n"
	"  (defprop mleqp 80. wxxml-lbp)\n"
	"  (defprop mleqp 80. wxxml-rbp)\n"
	"\n"
	"  (defprop mnot wxxml-prefix wxxml)\n"
	"  (defprop mnot (\"<fnm altCopy=\\\"not \\\">not</fnm>\") wxxmlsym)\n"
	"  (defprop mnot \"<fnm>not</fnm>\" wxxmlword)\n"
	"  (defprop mnot 70. wxxml-rbp)\n"
	"\n"
	"  (defprop mand wxxml-nary wxxml)\n"
	"  (defprop mand \"<mspace/><fnm>and</fnm><mspace/>\" wxxmlsym)\n"
	"  (defprop mand \"<fnm>and</fnm>\" wxxmlword)\n"
	"  (defprop mand 60. wxxml-lbp)\n"
	"  (defprop mand 60. wxxml-rbp)\n"
	"\n"
	"  (defprop mor wxxml-nary wxxml)\n"
	"  (defprop mor \"<mspace/><fnm>or</fnm><mspace/>\" wxxmlsym)\n"
	"  (defprop mor \"<fnm>or</fnm>\" wxxmlword)\n"
	"  (defprop mor 50. wxxml-lbp)\n"
	"  (defprop mor 50. wxxml-rbp)\n"
	"\n"
	"\n"
	"  (defprop mcond wxxml-mcond wxxml)\n"
	"  (defprop mcond 25. wxxml-lbp)\n"
	"  (defprop mcond 25. wxxml-rbp)\n"
	"\n"
	"  (defprop %derivative wxxml-derivative wxxml)\n"
	"  (defprop %derivative 120. wxxml-lbp)\n"
	"  (defprop %derivative 119. wxxml-rbp)\n"
	"\n"
	"  (defprop $diff wxxml-derivative wxxml)\n"
	"  (defprop $diff 120. wxxml-lbp)\n"
	"  (defprop $diff 119. wxxml-rbp)\n"
	"\n"
	"  (defun wxxml-derivative (x l r)\n"
	"    (if (and $derivabbrev\n"
	"	     (every #\'integerp (odds (cddr x) 0))\n"
	"	     (every #\'atom (odds (cddr x) 1)))\n"
	"	(append l (wxxml-d-abbrev x) r)\n"
	"      (wxxml (wxxml-d x) (append l \'(\"<d>\"))\n"
	"	     (append \'(\"</d>\") r) \'mparen \'mparen)))\n"
	"\n"
	"  (defun $derivabbrev (a)\n"
	"    (if a\n"
	"	(progn\n"
	"	  (defprop %derivative 130. wxxml-lbp)\n"
	"	  (defprop %derivative 129. wxxml-rbp)\n"
	"	  (setq $derivabbrev t))\n"
	"      (progn\n"
	"	(defprop %derivative 120. wxxml-lbp)\n"
	"	(defprop %derivative 119. wxxml-rbp)\n"
	"	(setq $derivabbrev nil))))\n"
	"\n"
	"  (defun wxxml-d-abbrev-subscript (l_vars l_ords &aux var_xml)\n"
	"    (let ((sub ()))\n"
	"      (loop while l_vars do\n"
	"	    (setq var_xml (car (wxxml (car l_vars) nil nil \'mparen \'mparen)))\n"
	"	    (loop for i from 1 to (car l_ords) do\n"
	"		  (setq sub (cons var_xml sub)))\n"
	"	    (setq l_vars (cdr l_vars)\n"
	"		  l_ords (cdr l_ords)))\n"
	"      (reverse sub)))\n"
	"\n"
	"  (defun wxxml-d-abbrev (x)\n"
	"    (let*\n"
	"	((difflist (cddr x))\n"
	"	 (ords (odds  difflist 0))\n"
	"	 (ords (cond ((null ords) \'(1))\n"
	"		     (t ords)))\n"
	"	 (vars (odds difflist 1))\n"
	"	 (fun (wxxml (cadr x) nil nil \'mparen \'mparen)))\n"
	"      (append \'(\"<i d=\\\"1\\\"><r>\") fun \'(\"</r>\")\n"
	"	      \'(\"<r>\") (wxxml-d-abbrev-subscript vars ords) \'(\"</r></i>\"))))\n"
	"\n"
	"  (defun wxxml-d (x)\n"
	"    ;; format the macsyma derivative form so it looks\n"
	"    ;; sort of like a quotient times the deriva-dand.\n"
	"    (let*\n"
	"	(($simp t)\n"
	"	 (arg (cadr x)) ;; the function being differentiated\n"
	"	 (difflist (cddr x)) ;; list of derivs e.g. (x 1 y 2)\n"
	"	 (ords (odds difflist 0)) ;; e.g. (1 2)\n"
	"	 (ords (cond ((null ords) \'(1))\n"
	"		     (t ords)))\n"
	"	 (vars (odds difflist 1)) ;; e.g. (x y)\n"
	"	 (dsym \'((wxxmltag simp) \"d\" \"s\"))\n"
	"	 (numer `((mexpt) ,dsym ((mplus) ,@ords))) ; d^n numerator\n"
	"	 (denom (cons \'(mtimes)\n"
	"		      (mapcan #\'(lambda(b e)\n"
	"				  `(,dsym ,(simplifya `((mexpt) ,b ,e) nil)))\n"
	"			      vars ords))))\n"
	"      `((wxtimes)\n"
	"	((mquotient) ,(simplifya numer nil) ,denom)\n"
	"	,arg)))\n"
	"\n"
	"  (defun wxxml-mcond (x l r)\n"
	"    (let ((res ()))\n"
	"      (setq res (wxxml (cadr x) \'(\"<fnm>if</fnm><mspace/>\")\n"
	"		       \'(\"<mspace/><fnm>then</fnm><mspace/>\") \'mparen \'mparen))\n"
	"      (setq res (append res (wxxml (caddr x) nil\n"
	"				   \'(\"<mspace/>\") \'mparen \'mparen)))\n"
	"      (let ((args (cdddr x)))\n"
	"	(loop while (>= (length args) 2) do\n"
	"	      (cond\n"
	"	       ((and (= (length args) 2) (eql (car args) t))\n"
	"		(unless (or (eql (cadr args) \'$false) (null (cadr args)))\n"
	"		  (setq res (wxxml (cadr args)\n"
	"				   (append res \'(\"<fnm>else</fnm><mspace/>\"))\n"
	"				   nil \'mparen \'mparen))))\n"
	"	       (t\n"
	"		(setq res (wxxml (car args)\n"
	"				 (append res \'(\"<fnm>elseif</fnm><mspace/>\"))\n"
	"				 (wxxml (cadr args)\n"
	"					\'(\"<mspace/><fnm>then</fnm><mspace/>\")\n"
	"					\'(\"<mspace/>\") \'mparen \'mparen)\n"
	"				 \'mparen \'mparen))))\n"
	"	      (setq args (cddr args)))\n"
	"	(append l res r))))\n"
	"\n") + wxString(
	"  (defprop mdo wxxml-mdo wxxml)\n"
	"  (defprop mdo 30. wxxml-lbp)\n"
	"  (defprop mdo 30. wxxml-rbp)\n"
	"  (defprop mdoin wxxml-mdoin wxxml)\n"
	"  (defprop mdoin 30. wxxml-rbp)\n"
	"\n"
	"  (defun wxxml-lbp (x)\n"
	"    (cond ((wxxml-get x \'wxxml-lbp))\n"
	"	  (t(lbp x))))\n"
	"\n"
	"  (defun wxxml-rbp (x)\n"
	"    (cond ((wxxml-get x \'wxxml-rbp))\n"
	"	  (t(lbp x))))\n"
	"\n"
	"  ;; these aren\'t quite right\n"
	"\n"
	"  (defun wxxml-mdo (x l r)\n"
	"    (wxxml-list (wxxmlmdo x) l r \"<mspace/>\"))\n"
	"\n"
	"  (defun wxxml-mdoin (x l r)\n"
	"    (wxxml-list (wxxmlmdoin x) l r \"<mspace/>\"))\n"
	"\n"
	"  (defun wxxmlmdo (x)\n"
	"    (nconc (cond ((second x) (list (make-tag \"for\" \"fnm\") (second x))))\n"
	"	   (cond ((equal 1 (third x)) nil)\n"
	"		 ((third x)  (list (make-tag \"from\" \"fnm\") (third x))))\n"
	"	   (cond ((equal 1 (fourth x)) nil)\n"
	"		 ((fourth x)\n"
	"		  (list (make-tag \"step\" \"fnm\")  (fourth x)))\n"
	"		 ((fifth x)\n"
	"		  (list (make-tag \"next\" \"fnm\") (fifth x))))\n"
	"	   (cond ((sixth x)\n"
	"		  (list (make-tag \"thru\" \"fnm\") (sixth x))))\n"
	"	   (cond ((null (seventh x)) nil)\n"
	"		 ((eq \'mnot (caar (seventh x)))\n"
	"		  (list (make-tag \"while\" \"fnm\") (cadr (seventh x))))\n"
	"		 (t (list (make-tag \"unless\" \"fnm\") (seventh x))))\n"
	"	   (list (make-tag \"do\" \"fnm\") (eighth x))))\n"
	"\n"
	"  (defun wxxmlmdoin (x)\n"
	"    (nconc (list (make-tag \"for\" \"fnm\") (second x)\n"
	"		 (make-tag \"in\" \"fnm\") (third x))\n"
	"	   (cond ((sixth x)\n"
	"		  (list (make-tag \"thru\" \"fnm\") (sixth x))))\n"
	"	   (cond ((null (seventh x)) nil)\n"
	"		 ((eq \'mnot (caar (seventh x)))\n"
	"		  (list (make-tag \"while\" \"fnm\") (cadr (seventh x))))\n"
	"		 (t (list (make-tag \"unless\" \"fnm\") (seventh x))))\n"
	"	   (list (make-tag \"do\" \"fnm\") (eighth x))))\n"
	"\n"
	"\n"
	"  (defun wxxml-matchfix-np (x l r)\n"
	"    (setq l (append l (car (wxxmlsym (caar x))))\n"
	"	  ;; car of wxxmlsym of a matchfix operator is the lead op\n"
	"	  r (append (cdr (wxxmlsym (caar x))) r)\n"
	"	  ;; cdr is the trailing op\n"
	"	  x (wxxml-list (cdr x) nil r \"\"))\n"
	"    (append l x))\n"
	"\n"
	"  (defprop text-string wxxml-matchfix-np wxxml)\n"
	"  (defprop text-string ((\"<t>\")\"</t>\") wxxmlsym)\n"
	"\n"
	"  (defprop mtext wxxml-matchfix-np wxxml)\n"
	"  (defprop mtext ((\"\")\"\") wxxmlsym)\n"
	"\n"
	"  (defvar *wxxml-mratp* nil)\n"
	"\n"
	"  (defun wxxml-mlable (x l r)\n"
	"    (wxxml (caddr x)\n"
	"	   (append l\n"
	"		   (if (cadr x)\n"
	"		       (list\n"
	"			(format nil \"<lbl>(~A)~A </lbl>\"\n"
	"				(stripdollar (maybe-invert-string-case (symbol-name (cadr x))))\n"
	"				*wxxml-mratp*))\n"
	"		     nil))\n"
	"	   r \'mparen \'mparen))\n"
	"\n"
	"  (defprop mlable wxxml-mlable wxxml)\n"
	"  (defprop mlabel wxxml-mlable wxxml)\n"
	"\n"
	"  (defun wxxml-spaceout (x l r)\n"
	"    (append l (list \" \" (make-string (cadr x) :initial-element #\\.) \"\") r))\n"
	"\n"
	"  (defprop spaceout wxxml-spaceout wxxml)\n"
	"\n"
	"  (defun mydispla (x)\n"
	"    (let ((*print-circle* nil)\n"
	"	  (*wxxml-mratp* (format nil \"~{~a~}\" (cdr (checkrat x)))))\n"
	"      (mapc #\'princ\n"
	"	    (wxxml x \'(\"<mth>\") \'(\"</mth>\") \'mparen \'mparen))))\n"
	"\n"
	"  (setf *alt-display2d* \'mydispla)\n"
	"\n"
	"  (defun $set_display (tp)\n"
	"    (cond\n"
	"     ((eq tp \'$none)\n"
	"      (setq $display2d nil))\n"
	"     ((eq tp \'$ascii)\n"
	"      (setq $display2d t)\n"
	"      (setf *alt-display2d* nil))\n"
	"     ((eq tp \'$xml)\n"
	"      (setq $display2d t)\n"
	"      (setf *alt-display2d* \'mydispla))\n"
	"     (t\n"
	"      (format t \"Unknown display type\")\n"
	"      (setq tp \'$unknown)))\n"
	"    tp)\n"
	"\n"
	"  ;;\n"
	"  ;; inference_result from the stats package\n"
	"  ;;\n"
	"\n"
	"  (defun wxxml-inference (x l r)\n"
	"    (let ((name (cadr x))\n"
	"	  (values (caddr x))\n"
	"	  (dis (cadddr x))\n"
	"	  (m ()))\n"
	"      (labels\n"
	"       ((build-eq (e)\n"
	"		  `((mequal simp) ,(cadr e) ,(caddr e))))\n"
	"       (dolist (i (cdr dis))\n"
	"	 (setq m (append m `(((mlist simp) ,(build-eq (nth i values)))))))\n"
	"       (setq m (cons `((mlist simp) ,name) m))\n"
	"       (setq m (cons \'($matrix simp inference) m))\n"
	"       (wxxml m l r \'mparen \'mparen))))\n"
	"\n"
	"  (defprop $inference_result wxxml-inference wxxml)\n"
	"\n"
	"  (defun wxxml-amatrix (x l r)\n"
	"    (let* ((nr ($@-function x \'$nr))\n"
	"	   (nc ($@-function x \'$nc))\n"
	"	   (M (simplifya ($genmatrix\n"
	"			  `((lambda) ((mlist) i j) (mfuncall \'$get_element ,x i j))\n"
	"			  nr nc)\n"
	"			 t)))\n"
	"      (wxxml-matrix M l r)))\n"
	"\n"
	"  (defprop $amatrix wxxml-amatrix wxxml)\n"
	"\n"
	"  ;;\n"
	"  ;; orthopoly functions\n"
	"  ;;\n"
	"\n"
	"  (defun wxxml-pochhammer (x l r)\n"
	"    (let ((n (cadr x))\n"
	"	  (k (caddr x)))\n"
	"      (append l\n"
	"	      (list (format nil \"<i altCopy=\\\"~{~a~}\\\"><p>\" (mstring x)))\n"
	"	      (wxxml n nil nil \'mparen \'mparen)\n"
	"	      (list \"</p><r>\")\n"
	"	      (wxxml k nil nil \'mparen \'mparen)\n"
	"	      (list \"</r></i>\")\n"
	"	      r)))\n"
	"\n"
	"  (defprop $pochhammer wxxml-pochhammer wxxml)\n"
	"\n"
	"  (defun wxxml-orthopoly (x l r)\n"
	"    (let* ((fun-name (caar x))\n"
	"	   (disp-name (get fun-name \'wxxml-orthopoly-disp))\n"
	"	   (args (cdr x)))\n"
	"      (append l\n"
	"	      (list (format nil \"<fn altCopy=\\\"~{~a~}\\\">\" (mstring x)))\n"
	"	      (if (nth 2 disp-name)\n"
	"		  (list (format nil \"<ie><fnm>~a</fnm><r>\" (car disp-name)))\n"
	"		(list (format nil \"<i><fnm>~a</fnm><r>\" (car disp-name))))\n"
	"	      (wxxml (nth (nth 1 disp-name) args) nil nil \'mparen \'mparen)\n"
	"	      (when (nth 2 disp-name)\n"
	"		(append (list \"</r><r>\")\n"
	"			(when (nth 3 disp-name) (list \"<p>\"))\n"
	"			(wxxml-list (or (nth 5 disp-name)\n"
	"					(mapcar (lambda (i) (nth i args)) (nth 2 disp-name)))\n"
	"				    nil nil \",\")\n"
	"			(when (nth 3 disp-name) (list \"</p>\"))\n"
	"			(list \"</r>\")))\n"
	"	      (if (nth 2 disp-name)\n"
	"		  (list \"</ie>\")\n"
	"		(list \"</r></i>\"))\n"
	"	      (list \"<p>\")\n"
	"	      (wxxml-list (mapcar (lambda (i) (nth i args)) (nth 4 disp-name)) nil nil \",\")\n"
	"	      (list \"</p></fn>\")\n"
	"	      r)))\n"
	"\n") + wxString(
	"  (dolist (ortho-pair\n"
	"	   \'(($laguerre \"L\" 0 nil nil (1))\n"
	"	     (%laguerre \"L\" 0 nil nil (1))\n"
	"	     ($legendre_p \"P\" 0 nil nil (1))\n"
	"	     (%legendre_p \"P\" 0 nil nil (1))\n"
	"	     ($legendre_q \"Q\" 0 nil nil (1))\n"
	"	     (%legendre_q \"Q\" 0 nil nil (1))\n"
	"	     ($chebyshev_t \"T\" 0 nil nil (1))\n"
	"	     (%chebyshev_t \"T\" 0 nil nil (1))\n"
	"	     ($chebyshev_u \"U\" 0 nil nil (1))\n"
	"	     (%chebyshev_u \"U\" 0 nil nil (1))\n"
	"	     ($hermite \"H\" 0 nil nil (1))\n"
	"	     (%hermite \"H\" 0 nil nil (1))\n"
	"	     ($spherical_bessel_j \"J\" 0 nil nil (1))\n"
	"	     (%spherical_bessel_j \"J\" 0 nil nil (1))\n"
	"	     ($spherical_bessel_y \"Y\" 0 nil nil (1))\n"
	"	     (%spherical_bessel_y \"Y\" 0 nil nil (1))\n"
	"	     ($assoc_legendre_p \"P\" 0 (1) nil (2))\n"
	"	     (%assoc_legendre_p \"P\" 0 (1) nil (2))\n"
	"	     ($assoc_legendre_q \"Q\" 0 (1) nil (2))\n"
	"	     (%assoc_legendre_q \"Q\" 0 (1) nil (2))\n"
	"	     ($jacobi_p \"P\" 0 (1 2) t (3))\n"
	"	     (%jacobi_p \"P\" 0 (1 2) t (3))\n"
	"	     ($gen_laguerre \"L\" 0 (1) t (2))\n"
	"	     (%gen_laguerre \"L\" 0 (1) t (2))\n"
	"	     ($spherical_harmonic \"Y\" 0 (1) nil (2 3))\n"
	"	     (%spherical_harmonic \"Y\" 0 (1) nil (2 3))\n"
	"	     ($ultraspherical \"C\" 0 (1) t (2))\n"
	"	     (%ultraspherical \"C\" 0 (1) t (2))\n"
	"	     ($spherical_hankel1 \"H\" 0 t t (1) (1))\n"
	"	     (%spherical_hankel1 \"H\" 0 t t (1) (1))\n"
	"	     ($spherical_hankel2 \"H\" 0 t t (1) (2))\n"
	"	     (%spherical_hankel2 \"H\" 0 t t (1) (2))))\n"
	"    (setf (get (car ortho-pair) \'wxxml) \'wxxml-orthopoly)\n"
	"    (setf (get (car ortho-pair) \'wxxml-orthopoly-disp) (cdr ortho-pair)))\n"
	"\n"
	";;;\n"
	";;; This is the display support only - copy/paste will not work\n"
	";;;\n"
	"\n"
	"  (defmvar $pdiff_uses_prime_for_derivatives nil)\n"
	"  (defmvar $pdiff_prime_limit 3)\n"
	"  (defmvar $pdiff_uses_named_subscripts_for_derivatives nil)\n"
	"  (defmvar $pdiff_diff_var_names (list \'(mlist) \'|$x| \'|$y| \'|$z|))\n"
	"\n"
	"  (setf (get \'%pderivop \'wxxml) \'wxxml-pderivop)\n"
	"  (setf (get \'$pderivop \'wxxml) \'wxxml-pderivop)\n"
	"\n"
	"  (defun wxxml-pderivop (x l r)\n"
	"    (cond ((and $pdiff_uses_prime_for_derivatives (eq 3 (length x)))\n"
	"	   (let* ((n (car (last x)))\n"
	"		  (p))\n"
	"\n"
	"	     (cond ((<= n $pdiff_prime_limit)\n"
	"		    (setq p (make-list n :initial-element \"\'\")))\n"
	"		   (t\n"
	"		    (setq p (list \"(\" n \")\"))))\n"
	"	     (append (append l \'(\"<r>\"))\n"
	"		     (let ((*var-tag* (list \"<fnm>\" \"</fnm>\"))) (wxxml (cadr x) nil nil lop rop))\n"
	"		     p\n"
	"		     (list \"</r>\")  r)))\n"
	"\n"
	"	  ((and $pdiff_uses_named_subscripts_for_derivatives\n"
	"		(< (apply #\'+ (cddr x)) $pdiff_prime_limit))\n"
	"	   (let ((n (cddr x))\n"
	"		 (v (mapcar #\'stripdollar (cdr $pdiff_diff_var_names)))\n"
	"		 (p))\n"
	"	     (cond ((> (length n) (length v))\n"
	"		    (merror \"Not enough elements in pdiff_diff_var_names to display the expression\")))\n"
	"	     (dotimes (i (length n))\n"
	"	       (setq p (append p (make-list (nth i n)\n"
	"					    :initial-element (nth i v)))))\n"
	"	     (append (append l \'(\"<i><r>\"))\n"
	"		     (wxxml (cadr x) nil nil lop rop)\n"
	"		     (list \"</r><r>\") p (list \"</r></i>\") r)))\n"
	"	  (t\n"
	"	   (append (append l \'(\"<i><r>\"))\n"
	"		   (wxxml (cadr x) nil nil lop rop)\n"
	"		   (list \"</r><r>(\")\n"
	"		   (wxxml-list (cddr x) nil nil \",\")\n"
	"		   (list \")</r></i>\") r))))\n"
	"\n"
	"  ;;\n"
	"  ;; Plotting support\n"
	"  ;;\n"
	"\n"
	"  (defprop wxxmltag wxxml-tag wxxml)\n"
	"\n"
	"  (defun wxxml-tag (x l r)\n"
	"    (let ((name (cadr x))\n"
	"	  (tag (caddr x))\n"
	"	  (prop (cadddr x)))\n"
	"      (if prop\n"
	"	  (append l (list (format nil \"<~a ~a>~a</~a>\" tag prop name tag)) r)\n"
	"	(append l (list (format nil \"<~a>~a</~a>\" tag name tag)) r))))\n"
	"\n"
	"\n"
	"  (defvar *image-counter* 0)\n"
	"\n"
	"  ;; A suitable name for a .gnuplot file\n"
	"  (defun wxplot-gnuplotfilename ()\n"
	"    (incf *wx-plot-num*)\n"
	"    (format nil \"maxout_~d_~d.gnuplot\" (getpid) *wx-plot-num*))\n"
	"\n"
	"  ;; A suitable name for a .data file\n"
	"  (defun wxplot-datafilename ()\n"
	"    (incf *wx-plot-num*)\n"
	"    (format nil \"maxout_~d_~d.data\" (getpid) *wx-plot-num*))\n"
	"\n"
	"  (defun wxplot-filename (&optional (suff t))\n"
	"    (incf *image-counter*)\n"
	"    (plot-temp-file (if suff\n"
	"			(format nil \"maxout_~d_~d.png\" (getpid) *image-counter*)\n"
	"		      (format nil \"maxout_~d_~d\" (getpid) *image-counter*))))\n"
	"\n"
	"  ;; The \"solid\" has to be changed to \"dashed\" as soon as plot() starts\n"
	"  ;; supporting other line styles than \"solid\" or \"dots\".\n"
	"  (defun $wxplot_preamble ()\n"
	"    (let ((frmt\n"
	"	   (cond\n"
	"	    ($wxplot_old_gnuplot \"set terminal png picsize ~d ~d; set zeroaxis;\")\n"
	"	    ($wxplot_pngcairo \"set terminal pngcairo solid background \\\"white\\\" enhanced font \\\"arial,10\\\" fontscale 1.0 size ~d,~d; set zeroaxis;\")\n"
	"	    (t \"set terminal png size ~d,~d; set zeroaxis;\"))))\n"
	"      (format nil frmt\n"
	"	      ($first $wxplot_size)\n"
	"	      ($second $wxplot_size))))\n"
	"\n"
	"  (defun $int_range (lo &optional hi (st 1))\n"
	"    (unless (integerp lo)\n"
	"      ($error \"int_range: first argument is not an integer.\"))\n"
	"    (unless (or (null hi) (integerp hi))\n"
	"      ($error \"int_range: second argument is not an integer.\"))\n"
	"    (when (null hi)\n"
	"      (setq hi lo)\n"
	"      (setq lo 1))\n"
	"    (cons \'(mlist simp) (loop :for i :from lo :to hi :by st :collect i)))\n"
	"\n"
	"  (defvar *default-framerate* 2)\n"
	"  (defvar $wxanimate_framerate *default-framerate*)\n"
	"  (defun slide-tag (images)\n"
	"    (if (eql *default-framerate* $wxanimate_framerate)\n"
	"	($ldisp (list \'(wxxmltag simp) (format nil \"~{~a;~}\" images) \"slide\" (if (eql $wxanimate_autoplay \'t) \"running=\\\"true\\\" del=\\\"true\\\"\" \"running=\\\"false\\\" del=\\\"true\\\"\")))\n"
	"      ($ldisp (list \'(wxxmltag simp) (format nil \"~{~a;~}\" images) \"slide\" (if (eql $wxanimate_autoplay \'t) (format nil \"fr=\\\"~a\\\" running=\\\"true\\\" del=\\\"true\\\"\" $wxanimate_framerate)  (format nil \"fr=\\\"~a\\\" running=\\\"false\\\" del=\\\"true\\\"\" $wxanimate_framerate))\n"
	"                    ))))\n"
	"\n"
	"  (defun wxanimate (scene)\n"
	"    (let* ((scene (cdr scene))\n"
	"	   (a (car scene))\n"
	"	   (a-range (meval (cadr scene)))\n"
	"	   (expr (caddr scene))\n"
	"	   (args (cdddr scene))\n"
	"	   (frameno 1)\n"
	"	   (images ()))\n"
	"      (when (integerp a-range)\n"
	"	(setq a-range (cons \'(mlist simp) (loop for i from 1 to a-range collect i))))\n"
	"      (dolist (aval (reverse (cdr a-range)))\n"
	"	($wxstatusbar (format nil \"Preparing Frame #~d\" frameno))\n"
	"	(setf frameno (+ 1 frameno))\n"
	"	(let ((preamble ($wxplot_preamble))\n"
	"	      (system-preamble (get-plot-option-string \'$gnuplot_preamble 2))\n"
	"	      (filename (wxplot-filename))\n"
	"	      (expr (maxima-substitute aval a expr)))\n"
	"	  (when (string= system-preamble \"false\")\n"
	"	    (setq system-preamble \"\"))\n"
	"	  (setq preamble (format nil \"~a; ~a\" preamble system-preamble))\n"
	"	  (dolist (arg args)\n"
	"	    (if (and (listp arg) (eql (cadr arg) \'$gnuplot_preamble))\n"
	"		(setq preamble (format nil \"~a; ~a\"\n"
	"				       preamble (meval (maxima-substitute aval a (caddr arg)))))))\n"
	"	  (apply #\'$plot2d `(,(meval expr) ,@(mapcar #\'meval args)\n"
	"			     ((mlist simp) $plot_format $gnuplot)\n"
	"			     ((mlist simp) $gnuplot_term ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"			     ((mlist simp) $gnuplot_preamble ,preamble)\n"
	"			     ((mlist simp) $gnuplot_out_file ,filename)))\n"
	"	  (setq images (cons filename images))))\n"
	"      (when images\n"
	"	(slide-tag images)))\n"
	"    \"\")\n"
	"\n"
	"  (defmspec $with_slider (scene)\n"
	"    (wxanimate scene))\n"
	"\n"
	"  (defmspec $wxanimate (scene)\n"
	"    (wxanimate scene))\n"
	"\n"
	"  (defvar *windows-OS* (string= *autoconf-win32* \"true\"))\n"
	"\n"
	"  (defun get-file-name-opt (scene)\n"
	"    (let (opts filename)\n"
	"      (loop for opt in scene do\n"
	"	    (if (and (not (atom opt))\n"
	"		     (eq (caar opt) \'mequal)\n"
	"		     (eq (cadr opt) \'$file_name))\n"
	"		(setq filename (caddr opt))\n"
	"	      (setq opts (cons opt opts))))\n"
	"      (values (reverse opts) filename)))\n"
	"\n") + wxString(
	"  (defun get-pic-size-opt ()\n"
	"    (cond\n"
	"     ((eq ($get \'$draw \'$version) 1)\n"
	"      `(((mequal simp) $pic_width ,($first $wxplot_size))\n"
	"	((mequal simp) $pic_height ,($second $wxplot_size))))\n"
	"     (t\n"
	"      `(((mequal simp) $dimensions ,$wxplot_size)))))\n"
	"\n"
	"  (defun wxanimate-draw (scenes scene-head)\n"
	"    (unless ($get \'$draw \'$version) ($load \"draw\"))\n"
	"    (multiple-value-bind (scene file-name) (get-file-name-opt (cdr scenes))\n"
	"			 (let* ((a (meval (car scene)))\n"
	"				(a-range (meval (cadr scene)))\n"
	"				(*windows-OS* t)\n"
	"				(args (cddr scene))\n"
	"				(frameno 1)\n"
	"				(images ()))\n"
	"			   (when (integerp a-range)\n"
	"			     (setq a-range (cons \'(mlist simp) (loop for i from 1 to a-range collect i))))\n"
	"			   (if file-name\n"
	"			       ;; If file_name is set, draw the animation into gif using gnuplot\n"
	"			       (let (imgs)\n"
	"				 (dolist (aval (reverse (cdr a-range)))\n"
	"				   (setq imgs (cons\n"
	"					       (cons scene-head\n"
	"						     (mapcar #\'(lambda (arg) (meval (maxima-substitute aval a arg)))\n"
	"							     args))\n"
	"					       imgs)))\n"
	"				 ($apply \'$draw\n"
	"					 (append\n"
	"					  `((mlist simp)\n"
	"					    ((mequal simp) $terminal $animated_gif)\n"
	"					    ((mequal simp) $file_name ,file-name))\n"
	"					  (get-pic-size-opt)\n"
	"					  imgs))\n"
	"				 \"\")\n"
	"			     ;; If file_name is not set, show the animation in wxMaxima\n"
	"			     (progn\n"
	"			       (dolist (aval (reverse (cdr a-range)))\n"
	"				 ($wxstatusbar (format nil \"Preparing Frame #~d\" frameno))\n"
	"				 (setf frameno (+ 1 frameno))\n"
	"				 (let* ((filename (wxplot-filename nil))\n"
	"					(args (cons scene-head\n"
	"						    (mapcar #\'(lambda (arg) (meval (maxima-substitute aval a arg)))\n"
	"							    args))))\n"
	"				   (setq images (cons (format nil \"~a.png\" filename) images))\n"
	"				   ($apply \'$draw\n"
	"					   (append\n"
	"					    `((mlist simp)\n"
	"					      ((mequal simp) $terminal ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"					      ((mequal simp) $file_name ,filename))\n"
	"					    (get-pic-size-opt)\n"
	"					    (list args)))))\n"
	"			       (when images\n"
	"				 (slide-tag images))))\n"
	"			   \"\")))\n"
	"\n"
	"  (defmspec $wxanimate_draw (scene)\n"
	"    (wxanimate-draw scene \'($gr2d)))\n"
	"\n"
	"  (defmspec $with_slider_draw (scene)\n"
	"    (wxanimate-draw scene \'($gr2d)))\n"
	"\n"
	"  (defmspec $with_slider_draw2d (scene)\n"
	"    (wxanimate-draw scene \'($gr2d)))\n"
	"\n"
	"  (defmspec $with_slider_draw3d (scene)\n"
	"    (wxanimate-draw scene \'($gr3d)))\n"
	"\n"
	"  (defmspec $wxanimate_draw3d (scene)\n"
	"    (wxanimate-draw scene \'($gr3d)))\n"
	"\n"
	"  (defun $wxplot2d (&rest args)\n"
	"    (let ((preamble ($wxplot_preamble))\n"
	"	  (system-preamble (get-plot-option-string \'$gnuplot_preamble 2))\n"
	"	  (filename (wxplot-filename)))\n"
	"      (when (string= system-preamble \"false\")\n"
	"	(setq system-preamble \"\"))\n"
	"      (setq preamble (format nil \"~a; ~a\" preamble system-preamble))\n"
	"      (dolist (arg args)\n"
	"	(if (and (listp arg) (eql (cadr arg) \'$gnuplot_preamble))\n"
	"	    (setq preamble (format nil \"~a; ~a\" preamble (caddr arg)))))\n"
	"      (apply #\'$plot2d `(,@args\n"
	"			 ((mlist simp) $plot_format $gnuplot)\n"
	"			 ((mlist simp) $gnuplot_term ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"			 ((mlist simp) $gnuplot_preamble ,preamble)\n"
	"			 ((mlist simp) $gnuplot_out_file ,filename)))\n"
	"      ($ldisp `((wxxmltag simp) ,filename \"img\")))\n"
	"    \"\")\n"
	"\n"
	"  (defun $wxplot3d (&rest args)\n"
	"    (let ((preamble ($wxplot_preamble))\n"
	"	  (system-preamble (get-plot-option-string \'$gnuplot_preamble 2))\n"
	"	  (filename (wxplot-filename)))\n"
	"      (when (string= system-preamble \"false\")\n"
	"	(setq system-preamble \"\"))\n"
	"      (setq preamble (format nil \"~a; ~a\" preamble system-preamble))\n"
	"      (dolist (arg args)\n"
	"	(if (and (listp arg) (eql (cadr arg) \'$gnuplot_preamble))\n"
	"	    (setq preamble (format nil \"~a; ~a\"\n"
	"				   preamble (caddr arg)))))\n"
	"      (apply #\'$plot3d `(,@args\n"
	"			 ((mlist simp) $plot_format $gnuplot)\n"
	"			 ((mlist simp) $gnuplot_term ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"			 ((mlist simp) $gnuplot_preamble ,preamble)\n"
	"			 ((mlist simp) $gnuplot_out_file ,filename)))\n"
	"      ($ldisp `((wxxmltag simp) ,filename \"img\")))\n"
	"    \"\")\n"
	"\n"
	"\n"
	"  (defun $wxdraw2d (&rest args)\n"
	"    (apply #\'$wxdraw\n"
	"	   (list (cons \'($gr2d) args))))\n"
	"\n"
	"  (defun $wxdraw3d (&rest args)\n"
	"    (apply #\'$wxdraw\n"
	"	   (list (cons \'($gr3d) args))))\n"
	"\n"
	"  (defvar $display_graphics t)\n"
	"\n"
	"  (defun option-sublist (lst)\n"
	"    (cons \'(mlist simp)\n"
	"	  (loop for l in lst\n"
	"		when (and (listp l) (= ($length l) 2))\n"
	"		collect l)))\n"
	"\n"
	"  (defun $wxdraw (&rest args)\n"
	"    (unless ($get \'$draw \'$version) ($load \"draw\"))\n"
	"    (let* ((file_name_spec ($assoc \'$file_name\n"
	"				   (option-sublist (append (cdar args)\n"
	"							   (cdr args)))))\n"
	"	   (gnuplotfilename (wxplot-gnuplotfilename))\n"
	"	   (datafilename (wxplot-datafilename))\n"
	"	   (filename (or file_name_spec (wxplot-filename nil)))\n"
	"	   (*windows-OS* t)\n"
	"	   res)\n"
	"      (setq res ($apply \'$draw\n"
	"			(append\n"
	"			 \'((mlist simp))\n"
	"			 args\n"
	"			 `(((mequal simp) $terminal ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"			   ((mequal simp) $gnuplot_file_name ,gnuplotfilename)\n"
	"			   ((mequal simp) $data_file_name ,datafilename)\n"
	"			   ((mequal simp) $file_name ,filename))\n"
	"			 (cond\n"
	"			  ((eq ($get \'$draw \'$version) 1)\n"
	"			   `(((mequal simp) $pic_width ,($first $wxplot_size))\n"
	"			     ((mequal simp) $pic_height ,($second $wxplot_size))))\n"
	"			  (t\n"
	"			   `(((mequal simp) $dimensions ,$wxplot_size)))))))\n"
	"      (if $display_graphics\n"
	"	  (progn\n"
	"	    ($ldisp `((wxxmltag simp) ,(format nil \"~a.png\" filename) \"img\"\n"
	"		      ,(if file_name_spec\n"
	"			   (format nil \"del=\\\"no\\\" gnuplotsource=\\\"~a/~a\\\" gnuplotdata=\\\"~a/~a\\\"\" $maxima_tempdir gnuplotfilename $maxima_tempdir datafilename)\n"
	"			 (format nil \"del=\\\"yes\\\" gnuplotsource=\\\"~a/~a\\\" gnuplotdata=\\\"~a/~a\\\"\" $maxima_tempdir gnuplotfilename $maxima_tempdir datafilename)\n"
	"			 )\n"
	"		      ))\n"
	"	    (setq res \"\"))\n"
	"	(setf res `((wxxmltag simp) ,(format nil \"~a.png\" filename) \"img\")))\n"
	"      res))\n"
	"\n"
	"  (defmspec $wxdraw_list (args)\n"
	"    (unless ($get \'$draw \'$version) ($load \"draw\"))\n"
	"    (let (($display_graphics nil))\n"
	"      ($ldisp (cons \'(mlist simp) (mapcar #\'meval (cdr args)))))\n"
	"    \'$done)\n"
	"\n") + wxString(
	"  (defun $wximplicit_plot (&rest args)\n"
	"    (let ((preamble ($wxplot_preamble))\n"
	"	  (system-preamble (get-plot-option-string \'$gnuplot_preamble 2))\n"
	"	  (filename (wxplot-filename)))\n"
	"      (when (string= system-preamble \"false\")\n"
	"	(setq system-preamble \"\"))\n"
	"      (setq preamble (format nil \"~a; ~a\" preamble system-preamble))\n"
	"      (dolist (arg args)\n"
	"	(if (and (listp arg) (eql (cadr arg) \'$gnuplot_preamble))\n"
	"	    (setq preamble (format nil \"~a; ~a\"\n"
	"				   preamble (caddr arg)))))\n"
	"      ($apply \'$implicit_plot `((mlist simp) ,@args\n"
	"				((mlist simp) $plot_format $gnuplot)\n"
	"				((mlist simp) $gnuplot_term ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"				((mlist simp) $gnuplot_preamble ,preamble)\n"
	"				((mlist simp) $gnuplot_out_file ,filename)))\n"
	"      ($ldisp `((wxxmltag simp) ,filename \"img\")))\n"
	"    \"\")\n"
	"\n"
	"\n"
	"  (defun $wxcontour_plot (&rest args)\n"
	"    (let ((preamble ($wxplot_preamble))\n"
	"	  ($plot_options $plot_options)\n"
	"	  (system-preamble (get-plot-option-string \'$gnuplot_preamble 2))\n"
	"	  (filename (wxplot-filename)))\n"
	"      (when (string= system-preamble \"false\")\n"
	"	(setq system-preamble \"\"))\n"
	"      (setq preamble (format nil \"~a; ~a\" preamble system-preamble))\n"
	"      (dolist (arg args)\n"
	"	(if (and (listp arg) (eql (cadr arg) \'$gnuplot_preamble))\n"
	"	    (setq preamble (format nil \"~a; ~a\" preamble (caddr arg)))))\n"
	"      (apply #\'$contour_plot `(,@args\n"
	"			       ((mlist simp) $gnuplot_term ,(if $wxplot_pngcairo \'$pngcairo \'$png))\n"
	"			       ((mlist simp) $plot_format $gnuplot)\n"
	"			       ((mlist simp) $gnuplot_preamble ,preamble)\n"
	"			       ((mlist simp) $gnuplot_out_file ,filename)))\n"
	"\n"
	"      ($ldisp `((wxxmltag simp) ,filename \"img\")))\n"
	"    \"\")\n"
	"\n"
	"  (defun $show_image (file)\n"
	"    ($ldisp `((wxxmltag simp) ,file \"img\" \"del=\\\"no\\\"\")))\n"
	"\n"
	"  ;;\n"
	"  ;; Port of Barton Willis\'s texput function.\n"
	"  ;;\n"
	"\n"
	"  (defun $wxxmlput (e s &optional tx lbp rbp)\n"
	"\n"
	"    (when (stringp e)\n"
	"      (setf e (define-symbol e)))\n"
	"\n"
	"    (cond (($listp s)\n"
	"	   (setq s (margs s)))\n"
	"	  ((stringp s)\n"
	"	   (setq s (list s)))\n"
	"	  ((atom s)\n"
	"	   (setq s (list (wxxml-stripdollar ($sconcat s))))))\n"
	"\n"
	"    (when (or (null lbp) (not (integerp lbp)))\n"
	"      (setq lbp 180))\n"
	"    (when (or (null rbp) (not (integerp rbp)))\n"
	"      (setq rbp 180))\n"
	"    (cond ((null tx)\n"
	"	   (if (stringp (nth 0 s))\n"
	"	       (putprop e (nth 0 s) \'wxxmlword)\n"
	"             (let ((fun-name (gensym))\n"
	"                   (fun-body\n"
	"                    `(append l\n"
	"                             (list\n"
	"                              (let ((f-x (mfuncall \',s x)))\n"
	"                                (if (stringp f-x)\n"
	"                                    f-x\n"
	"				  (merror \"wxxml: function ~s did not return a string.~%\"\n"
	"					  ($sconcat \',(nth 0 s))))))\n"
	"                             r)))\n"
	"               (setf (symbol-function fun-name) (coerce `(lambda (x l r) ,fun-body) \'function))\n"
	"               (setf (get e \'wxxml) fun-name))))\n"
	"	  ((eq tx \'$matchfix)\n"
	"	   (putprop e \'wxxml-matchfix \'wxxml)\n"
	"	   (cond ((< (length s) 2)\n"
	"		  (merror\n"
	"		   \"Improper 2nd argument to `wxxmlput\' for matchfix operator.\"))\n"
	"		 ((eq (length s) 2)\n"
	"		  (putprop e (list (list (nth 0 s)) (nth 1 s)) \'wxxmlsym))\n"
	"		 (t\n"
	"		  (putprop\n"
	"		   e (list (list (nth 0 s)) (nth 1 s) (nth 2 s)) \'wxxmlsym))))\n"
	"	  ((eq tx \'$prefix)\n"
	"	   (putprop e \'wxxml-prefix \'wxxml)\n"
	"	   (putprop e s \'wxxmlsym)\n"
	"	   (putprop e lbp \'wxxml-lbp)\n"
	"	   (putprop e rbp \'wxxml-rbp))\n"
	"	  ((eq tx \'$infix)\n"
	"	   (putprop e \'wxxml-infix \'wxxml)\n"
	"	   (putprop e  s \'wxxmlsym)\n"
	"	   (putprop e lbp \'wxxml-lbp)\n"
	"	   (putprop e rbp \'wxxml-rbp))\n"
	"	  ((eq tx \'$postfix)\n"
	"	   (putprop e \'wxxml-postfix \'wxxml)\n"
	"	   (putprop e  s \'wxxmlsym)\n"
	"	   (putprop e lbp \'wxxml-lbp))\n"
	"	  (t (merror \"Improper arguments to `wxxmlput\'.\"))))\n"
	"\n"
	";;;;;;;;;;;;;\n"
	"  ;; Auto-loaded functions\n"
	";;;;\n"
	"\n"
	"  (setf (get \'$lbfgs \'autoload) \"lbfgs\")\n"
	"  (setf (get \'$lcm \'autoload) \"functs\")\n"
	"\n"
	";;;;;;;;;;;;;\n"
	"  ;; Statistics functions\n"
	";;;;\n"
	"\n"
	"  (defvar $draw_compound t)\n"
	"\n"
	"  (defmacro create-statistics-wrapper (fun wxfun)\n"
	"    `(defun ,wxfun (&rest args)\n"
	"       (let (($draw_compound nil) res)\n"
	"	 (declare (special $draw_compound))\n"
	"	 (setq res ($apply \',fun (cons \'(mlist simp) args)))\n"
	"	 ($apply \'$wxdraw2d res))))\n"
	"\n"
	"  (create-statistics-wrapper $histogram $wxhistogram)\n"
	"  (create-statistics-wrapper $scatterplot $wxscatterplot)\n"
	"  (create-statistics-wrapper $barsplot $wxbarsplot)\n"
	"  (create-statistics-wrapper $piechart $wxpiechart)\n"
	"  (create-statistics-wrapper $boxplot $wxboxplot)\n"
	"\n"
	"  (dolist (fun \'($histogram\n"
	"		 $scatterplot\n"
	"		 $barsplot\n"
	"		 $piechart\n"
	"		 $boxplot))\n"
	"    (setf (get fun \'autoload) \"descriptive\"))\n"
	"\n"
	"  (dolist (fun \'($mean\n"
	"		 $median\n"
	"		 $var\n"
	"		 $std\n"
	"		 $test_mean\n"
	"		 $test_means_difference\n"
	"		 $test_normality\n"
	"		 $simple_linear_regression\n"
	"		 $subsample))\n"
	"    (setf (get fun \'autoload) \"stats\"))\n"
	"\n"
	"  (setf (get \'$lsquares_estimates \'autoload) \"lsquares\")\n"
	"\n"
	"  (setf (get \'$to_poly_solve \'autoload) \"to_poly_solve\")\n"
	"\n") + wxString(
	";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	"  ;;\n"
	"  ;; Redefine load so that it prints the list of functions\n"
	"  ;; used for autocompletion.\n"
	"  ;;\n"
	";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	"  (defun symbol-to-xml (s)\n"
	"    (wxxml-fix-string (format nil \"~a\" (maybe-invert-string-case (symbol-name (stripdollar s))))))\n"
	"\n"
	"  (defun print_unit (unit)\n"
	"    (format nil \"<unit>~a</unit>\" (symbol-to-xml unit)))\n"
	"\n"
	"  (defun $print_function (fun)\n"
	"    (let ((fun-name (symbol-to-xml (caar fun)))\n"
	"	  (*print-circle* nil)\n"
	"	  (args (mapcar (lambda (u)\n"
	"			  (cond ((atom u) (symbol-to-xml u))\n"
	"				((eq (caar u) \'mlist)\n"
	"				 ($concat \"[\" (symbol-to-xml\n"
	"					       (if (atom (cadr u)) (cadr u) (cadadr u))) \"]\"))\n"
	"				(t (symbol-to-xml (cadr u)))))\n"
	"			(cdr fun))))\n"
	"      (format nil \"<function>~a</function><template>~a(~{&lt;~a&gt;~^, ~})</template>\" fun-name fun-name args)))\n"
	"\n"
	"  (defun print_value (val)\n"
	"    (format nil \"<value>~a</value>\" (symbol-to-xml val)))\n"
	"\n"
	"  (defun $add_function_template (&rest functs)\n"
	"    (let ((*print-circle* nil))\n"
	"      (format t \"<wxxml-symbols>~{~a~^$~}</wxxml-symbols>\" (mapcar #\'$print_function functs))\n"
	"      (cons \'(mlist simp) functs)))\n"
	"\n"
	"\n"
	"  ;; A function that determines all symbols for autocompletion\n"
	"  (defun wxPrint_autoompletesymbols ()\n"
	"    (format t \"<wxxml-symbols>\")\n"
	"    ;; Function names and rules\n"
	"    (format t \"~{~a~^$~}\"\n"
	"	    (append (mapcar #\'$print_function (cdr ($append $functions $macros)))\n"
	"		    (mapcar #\'print_value (cdr ($append $values $rules)))))\n"
	"    ;; Idea from Robert Dodier:\n"
	"    ;; Variables defined with mdef don\'t appear in $values nor do they in $myoptions\n"
	"    ;; but they appear in *variable-initial-values*\n"
	"    (maphash (lambda (key val)\n"
	"	       (declare (ignore val))\n"
	"	       (if (eq (char (format nil \"~a\" key) 0) #\\$ )\n"
	"		   (format t \"~a\" (print_value key))))\n"
	"	     *variable-initial-values*)\n"
	"\n"
	"    ;; ezunits publishes all known units in a function.\n"
	"    ;; Currently the following lines produce a warning, though, that\n"
	"    ;; $known_units is undefined.\n"
	"    ;;	(if (boundp \'$known_units)\n"
	"    ;;	    (no-warning\n"
	"    ;;	     (format t \"~{~a~^$~}\"\n"
	"    ;;		     (mapcar #\'print_unit (cdr ($known_units))))))\n"
	"    (format t \"</wxxml-symbols>\"))\n"
	"\n"
	";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	";;;\n"
	";;; Communication between wxMaxima and wxMaxima about variables and directories\n"
	";;;\n"
	"\n"
	";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	";;;\n"
	";;; Communicate the contents of variables to wxMaxima\n"
	"  (defun wx-print-variable (var)\n"
	"    (format t \"<variable>\")\n"
	"    (format t \"<name>~a</name>\" (symbol-to-xml var))\n"
	"    (if (boundp var)\n"
	"	(format t \"<value>~a</value>\" (wxxml-fix-string(eval var))))\n"
	"    (format t \"</variable>\"))\n"
	"\n"
	"  (defun wx-print-variables ()\n"
	"    ;; Flush stdout as this might hinder clisp on MSW from failing to send\n"
	"    ;; network packets in the wrong order\n"
	"    (finish-output)\n"
	"    (format t \"<variables>\")\n"
	"    (wx-print-variable \'$maxima_userdir)\n"
	"    (wx-print-variable \'$maxima_tempdir)\n"
	"    (wx-print-variable \'*maxima-htmldir*)\n"
	"					;  (wx-print-variable \'*maxima-topdir*)\n"
	"    (wx-print-variable \'$gnuplot_command)\n"
	"    (wx-print-variable \'*maxima-demodir*)\n"
	"    (wx-print-variable \'*maxima-sharedir*)\n"
	"    (wx-print-variable \'*autoconf-version*)\n"
	"    (wx-print-variable \'*autoconf-host*)\n"
	"    (format t \"<variable><name>*lisp-name*</name><value>~a</value></variable>\"\n"
	"	    #+sbcl (ensure-readably-printable-string (lisp-implementation-type))\n"
	"	    #-sbcl (lisp-implementation-type))\n"
	"    (format t \"<variable><name>*lisp-version*</name><value>~a</value></variable>\"\n"
	"	    #+sbcl (ensure-readably-printable-string (lisp-implementation-version))\n"
	"	    #-sbcl (lisp-implementation-version))\n"
	"    (format t \"</variables>\")\n"
	"    ;; Flush stdout as this might hinder clisp on MSW from failing to send\n"
	"    ;; network packets in the wrong order\n"
	"    (finish-output)\n"
	"    )\n"
	"\n"
	";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n"
	"  ;; A function that allows wxMaxima to set maxima\'s current directory to that\n"
	"  ;; of the worksheet.\n"
	"  (defun wx-cd (dir)\n"
	"    (handler-case\n"
	"      (progn\n"
	"        (let ((dir (cond ((pathnamep dir) dir)\n"
	"	  	       ((stringp dir)\n"
	"	  		(make-pathname :directory (pathname-directory dir)\n"
	"	    			       :host (pathname-host dir)\n"
	"	  			       :device (pathname-device dir)))\n"
	"	  	       (t (error \"cd(dir): dir must be a string or pathname.\")))))\n"
	"	  #+  allegro (excl:chdir dir)\n"
	"	  #+clisp (ext:cd dir)\n"
	"	  #+cmu (setf (ext:default-directory) dir)\n"
	"	  #+cormanlisp (ccl:set-current-directory dir)\n"
	"	  #+gcl (si::chdir dir)\n"
	"	  #+lispworks (hcl:change-directory dir)\n"
	"	  #+lucid (lcl:working-directory dir)\n"
	"	  #+sbcl (sb-posix:chdir dir)\n"
	"	  #+sbcl (setf *default-pathname-defaults* (sb-ext:native-pathname (format nil \"~A~A\" (sb-posix:getcwd) \"/\")))\n"
	"	  #+ccl (ccl:cwd dir)\n"
	"	  #+ecl (si::chdir dir)\n"
	"         ;;; Officially gcl supports (si:chdir dir), too. But the version\n"
	"         ;;; shipped with debian and ubuntu (at least in Feb 2017) doesn\'t.\n"
	"	  #+gcl (xchdir dir)\n"
	"	  #+gcl (setf *default-pathname-defaults* dir)\n"
	"\n"
        "	  #-(or allegro clisp cmu cormanlisp gcl lispworks lucid sbcl ccl ecl) (format t\n"
        "           \"Info: wxMathml.cpp: Changing the working dir during a maxima session isn\'t implemented for this lisp.\")\n"
	"  	  (namestring dir)\n"
	"	  (wx-print-variables)))\n"
	"      (error (c)"
	"        (format t \"Warning: Cannot change maxima\'s working directory to the dir of the worksheet:~%~&~%\")\n"
        "          (values 0 c))))\n"
	"\n"
	";;;;;;;;;;;;;;;;;;;;;\n"
	"  ;; table_form implementation\n"
	"\n"
	"  (defun make-zeros (n)\n"
	"    (cons \'(mlist simp) (loop for i from 1 to n collect \"\")))\n"
	"  (defun take-first (l n)\n"
	"    (if (= n 0) nil (cons (first l) (take-first (rest l) (- n 1)))))\n"
	"\n") + wxString(
	"  (defun $table_form (mat &rest opts)\n"
	"    (when (mapatom mat)\n"
	"      ($error \"table_form: the argument should not be an atom.\"))\n"
	"    (setq mat ($args mat))\n"
	"    (unless (every #\'$listp (cdr mat))\n"
	"      (setq mat (cons \'(mlist simp)\n"
	"		      (mapcar (lambda (e) (list \'(mlist simp) e))\n"
	"			      (cdr mat)))))\n"
	"    (setq opts (cons \'(mlist simp) opts))\n"
	"    (let ((row-names ($assoc \'$row_names opts))\n"
	"	  (col-names ($assoc \'$column_names opts))\n"
	"	  (m (apply #\'max (mapcar \'$length (cdr mat))))\n"
	"	  (n (length (cdr mat)))\n"
	"	  (mtrx \'(special)))\n"
	"      (when ($assoc \'$transpose opts)\n"
	"	(rotatef m n))\n"
	"      (when (eq row-names \'$auto)\n"
	"	(setq row-names (cons \'(mlist simp) (loop for i from 1 to n collect i))))\n"
	"      (when (eq col-names \'$auto)\n"
	"	(setq col-names (cons \'(mlist simp) (loop for i from 1 to m collect i))))\n"
	"      (when row-names\n"
	"	(setq row-names ($append row-names (make-zeros (- n ($length row-names)))))\n"
	"	(setq row-names (cons \'(mlist simp) (take-first (cdr row-names) n))))\n"
	"      (when col-names\n"
	"	(setq col-names ($append col-names (make-zeros (- m ($length col-names)))))\n"
	"	(setq col-names (cons \'(mlist simp) (take-first (cdr col-names) m))))\n"
	"      (when (and row-names col-names)\n"
	"	(setq col-names ($cons \"\" col-names)))\n"
	"      (setq mat (cons \'(mlist simp) (mapcar\n"
	"				     (lambda (r) ($append r (make-zeros (- m ($length r)))))\n"
	"				     (cdr mat))))\n"
	"      (setq mat ($apply \'$matrix mat))\n"
	"      (when ($assoc \'$transpose opts)\n"
	"	(setq mat ($transpose mat)))\n"
	"      (when row-names\n"
	"	(setq mat (cons \'($matrix simp)\n"
	"			(mapcar #\'$append (cdr ($transpose row-names)) (cdr mat))))\n"
	"	(setq mtrx (cons \'rownames mtrx)))\n"
	"      (when col-names\n"
	"	(setq mat (cons \'(matrix simp)\n"
	"			(cons col-names (cdr mat))))\n"
	"	(setq mtrx (cons \'colnames mtrx)))\n"
	"      ($ldisp (cons (append \'($matrix simp) mtrx) (cdr mat)))\n"
	"      \'$done))\n"
	"\n"
	"  (putprop \'$table_form t \'evfun)\n"
	"\n"
	"  ;; Load the initial functions (from mac-init.mac)\n"
	"  (let ((*print-circle* nil))\n"
	"    (format t \"<wxxml-symbols>~{~a~^$~}</wxxml-symbols>\"\n"
	"	    (mapcar #\'$print_function (cdr ($append $functions $macros)))))\n"
	"\n"
	"  (no-warning\n"
	"   (defun mredef-check (fnname)\n"
	"     (declare (ignore fnname))\n"
	"     t))\n"
	"\n"
	";;; A function that loads bitmaps from files as a slideshow.\n"
	";;; Todo: Replace this function by at least half-way-optimized LISP code.\n"
	"  (progn\n"
	"    (defprop $wxanimate_from_imgfiles t translated)\n"
	"    (add2lnc \'$wxanimate_from_imgfiles $props)\n"
	"    (defmtrfun ($wxanimate_from_imgfiles $any mdefine t nil)\n"
	"      ($x)\n"
	"      (declare (special $x))\n"
	"      (progn\n"
	"	(simplify (mfunction-call $printf t \'\"<mth><slide\"))\n"
	"	(cond\n"
	"	 ((is-boole-check (trd-msymeval $wxanimate_autoplay \'$wxanimate_autoplay))\n"
	"	  (simplify (mfunction-call $printf t \'\" running=\\\"false\\\"\"))))\n"
	"	(cond\n"
	"	 ((like\n"
	"	   (simplify\n"
	"	    `((mfactorial)\n"
	"	      ,(trd-msymeval $wxanimate_framerate \'$wxanimate_framerate)))\n"
	"	   \'$wxanimate_framerate)\n"
	"	  (simplify\n"
	"	   (mfunction-call $printf t \'\" fr=\\\"~d\\\"\"\n"
	"			   (trd-msymeval $wxanimate_framerate\n"
	"					 \'$wxanimate_framerate)))))\n"
	"	(simplify (mfunction-call $printf t \'\">\"))\n"
	"	(do (($i)\n"
	"	     (mdo (cdr $x) (cdr mdo)))\n"
	"	    ((null mdo) \'$done)\n"
	"	    (declare (special $i))\n"
	"	    (setq $i (car mdo))\n"
	"	    (simplify (mfunction-call $printf t \'\"~a;\" $i)))\n"
	"	(simplify (mfunction-call $printf t \'\"</slide></mth>\")))\n"
	"      ))\n"
	"\n"
	"\n"
	"  (when ($file_search \"wxmaxima-init\")\n"
	"    ($load \"wxmaxima-init\"))\n"
	"\n"
	";;;\n"
	";;; Now that we have loaded the init file we can rewrite of the function load\n"
	";;; (maxima/src/mload.lisp) to displays functions and variable names after\n"
	";;; loading a Maxima package so the autocomplete functionality knows which\n"
	";;; function and variable names exists.\n"
	";;;\n"
	";;; We also inform wxMaxima about the name of the package and about the fact\n"
	";;; if it was loaded by another package.\n"
	";;;\n"
	"  (no-warning\n"
	"   (defun $load (filename)\n"
	"     (let ((searched-for\n"
	"	    ($file_search1 filename\n"
	"			   \'((mlist) $file_search_maxima $file_search_lisp  )))\n"
	"	   type)\n"
	"       (setq type ($file_type searched-for))\n"
	"       (case type\n"
	"	     (($maxima)\n"
	"	      (format t \"<variables>\")\n"
	"	      (format t \"<variable><name>*wx-load-file-name*</name><value>~a</value></variable>\"\n"
	"		      (wxxml-fix-string filename))\n"
	"	      (format t \"<variable><name>*wx-load-file-start*</name><value>1</value></variable>\")\n"
	"	      (format t \"</variables>\")\n"
	"	      ($batchload searched-for)\n"
	"	      (format t \"<variables>\")\n"
	"	      (format t \"<variable><name>*wx-load-file-start*</name><value>0</value></variable>\")\n"
	"	      (format t \"</variables>\")\n"
	"	      (wxPrint_autoompletesymbols))\n"
	"	     (($lisp $object)\n"
	"	      ;; do something about handling errors\n"
	"	      ;; during loading. Foobar fail act errors.\n"
	"	      (format t \"<variables>\")\n"
	"	      (format t \"<variable><name>*wx-load-file-name*</name><value>~a</value></variable>\"\n"
	"		      (wxxml-fix-string filename))\n"
	"	      (format t \"<variable><name>*wx-load-file-start*</name><value>1</value></variable>\")\n"
	"	      (format t \"</variables>\")\n"
	"	      (no-warning\n"
	"	       (load-and-tell searched-for))\n"
	"	      (format t \"<variables>\")\n"
	"	      (format t \"<variable><name>*wx-load-file-start*</name><value>0</value></variable>\")\n"
	"	      (format t \"</variables>\")\n"
	"	      (wxPrint_autoompletesymbols))\n"
	"	     (t\n"
	"	      (merror \"Maxima bug: Unknown file type ~M\" type)))\n"
	"       searched-for)))\n"
	"  (force-output)\n"
	"  (format t \"</suppressOutput>\")\n"
	"  ;; Publish all new global variables maxima might contain to wxMaxima\'s\n"
	"  ;; autocompletion feature.\n"
	"  (wxPrint_autoompletesymbols)\n"
	"  (wx-print-variables)\n"
	"  (force-output)\n"
        ")\n\0");
    }

wxString wxMathML::GetCmd()
{
  wxString cmd;
  
  wxStringTokenizer lines(m_wxMathML,wxT("\n"));
  while(lines.HasMoreTokens())
  {
    wxString line = lines.GetNextToken();
    wxString lineWithoutComments;

    bool stringIs = false;
    wxChar lastChar=wxT(' ');
    wxString::iterator ch = line.begin();
    while (ch < line.end())
    {
      // Remove formatting spaces
      if(((lastChar == ' ') && (*ch == ' ')) && (!stringIs))
	  ch++;
      else
	{
	  // Handle backslashes that might escape double quotes
	  if (*ch == wxT('\\'))
	    {
	      lineWithoutComments += *ch;
	      lastChar = *ch;
	      ch++;
	    }
	  else
	    {
	      // Handle strings
	      if (*ch == wxT('\"'))
		stringIs = !stringIs;

	      // Handle comments
	      if ((*ch == wxT(';')) && (!stringIs))
		break;
	    }
	  lineWithoutComments += *ch;
	  lastChar = *ch;
	  ch++;
	}
    }
    cmd += lineWithoutComments + " ";
  }
  return wxT(":lisp-quiet ") + cmd + "\n";
}
