"""\
Code generator functions for wxStaticLine objects

@copyright: 2002-2007 Alberto Griggio
@copyright: 2014-2015 Carsten Grohmann
@license: MIT (see license.txt) - THIS PROGRAM COMES WITH NO WARRANTY
"""

import common
import wcodegen


class PythonStaticLineGenerator(wcodegen.PythonWidgetCodeWriter):
    tmpl = '%(name)s = %(klass)s(%(parent)s, %(id)s%(style)s)\n'

# end of class PythonStaticLineGenerator


class CppStaticLineGenerator(wcodegen.CppWidgetCodeWriter):
    import_modules = ['<wx/statline.h>']
    tmpl = '%(name)s = new %(klass)s(%(parent)s, %(id)s%(style)s);\n'

# end of class CppStaticLineGenerator


def xrc_code_generator(obj):
    xrcgen = common.code_writers['XRC']

    class XrcCodeGenerator(xrcgen.DefaultXrcObject):
        def write(self, *args, **kwds):
            try:
                del self.properties['attribute']
            except KeyError:
                pass
            xrcgen.DefaultXrcObject.write(self, *args, **kwds)

    return XrcCodeGenerator(obj)


def initialize():
    klass = 'wxStaticLine'
    common.class_names['EditStaticLine'] = klass
    common.register('python', klass, PythonStaticLineGenerator(klass))
    common.register('C++', klass, CppStaticLineGenerator(klass))
    common.register('XRC', klass, xrc_code_generator)
