"""\
Code generator functions for wxCheckListBox objects

@copyright: 2002-2007 Alberto Griggio
@copyright: 2014 Carsten Grohmann
@copyright: 2015 Franco Bugnano
@license: MIT (see license.txt) - THIS PROGRAM COMES WITH NO WARRANTY
"""

import common
import wcodegen
from ChoicesCodeHandler import *


class PythonCheckListBoxGenerator(wcodegen.PythonWidgetCodeWriter):
    tmpl = '%(name)s = %(klass)s(%(parent)s, %(id)s, ' \
           'choices=[%(choices)s]%(style)s)\n'

# end of class PythonCheckListBoxGenerator


class CppCheckListBoxGenerator(wcodegen.CppWidgetCodeWriter):
    tmpl = '%(name)s = new %(klass)s(%(parent)s, %(id)s, ' \
           'wxDefaultPosition, wxDefaultSize, %(choices_len)s, ' \
           '%(name)s_choices%(style)s);\n'

# end of class CppCheckListBoxGenerator


def xrc_code_generator(obj):
    xrcgen = common.code_writers['XRC']

    class CheckListBoxXrcObject(xrcgen.DefaultXrcObject):
        def write_property(self, name, val, outfile, tabs):
            if name == 'choices':
                xrc_write_choices_property(self, outfile, tabs)
            elif name == 'selection':
                choices = self.properties['choices']
                if choices:
                    xrcgen.DefaultXrcObject.write_property(self, name, val,
                                                           outfile, tabs)
            else:
                xrcgen.DefaultXrcObject.write_property(self, name, val,
                                                       outfile, tabs)

    # end of class CheckListBoxXrcObject

    return CheckListBoxXrcObject(obj)


def initialize():
    klass = 'wxCheckListBox'
    common.class_names['EditCheckListBox'] = klass
    common.register('python', klass, PythonCheckListBoxGenerator(klass),
                    'choices', ChoicesCodeHandler)
    common.register('C++', klass, CppCheckListBoxGenerator(klass),
                    'choices', ChoicesCodeHandler)
    common.register('XRC', klass, xrc_code_generator,
                    'choices', ChoicesCodeHandler)
