#! /usr/bin/python
#
#    https://launchpad.net/wxbanker
#    silk.py: Copyright 2007, 2008 Mike Rooney <michael@wxbanker.org>
#
#    This file is part of wxBanker.
#
#    wxBanker is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    wxBanker is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with wxBanker.  If not, see <http://www.gnu.org/licenses/>.
#
#----------------------------------------------------------------------
# This file was generated by compileart.py
#
from embeddedimage import PyEmbeddedImage

catalog = {}
index = []

accept = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsxJ"
    "REFUOI2lk19ok1cYxn/nSxPsTNqaZiVNmrI2iCJzaoci1dh10uFamUJRR9HuUhl4IezWK2+c"
    "IqgFL0QQLQq7GAyVMfTCSdt169R2av3bRk2bNDMOE2tqzvd95xwvNjNQvPK5fHmfh5eH3wvv"
    "KfHmoPdqe9xIu0cp3SvtUlhrF4zOos1pY+yzP3VOTL4z4JvhRLd0ZF8D8fplHyaY760GYNbO"
    "88fUJe4WRme0Nrt//Tr142uPp2webO0uOvJUa6AzuLJ+PXk3T/LFBDn5N/N9flrqE9R4goFr"
    "0ze6Gr8K3Eufm71TvqBnYG2z7ZQG1tZ0RRbWLmModxlXK1ytsf5bqhAe1tS1M54eof/GmYzA"
    "k7j5bSppARintL1BxCOLapczlLtMyXWwlYOrHGzXxnUdOiJdjGQH+Di6ipbapREp9XYAC8BW"
    "cseK8Dqm51K4ykVpF61chNYIbdj00VbaG75k19LvmH7+kLaF65HS7CgHvJQyWuMLki4+RmnF"
    "huhGdi3Zg9AWm5u20Rb9AqVdzk/8QDqfZEFlHealiQJUAJSkRBuD0ZqAJ0Br+DOqfNXsXbWf"
    "4LwQSrscHzvEg6c38Xv9CAw4/5ZvAeCQzs/liH4Q44UscGzse4rOLMF5IbTRHL9+kDtPRhFA"
    "pKqRXH4GoUj/34Fj+oeSl4hUxvBqeFLMcOTPfdz/Z5wTo4e4nRtDaIGlBbGqJi7cuoiB/jIH"
    "dRurp1L5zJa6yppASyRBJj9J0X7OSPoKudksFgKf5aGtuZOrDwf5ZXgwg/LuKfxeeOYByJwr"
    "PAt1VD0efjTeFfH7fasbP6fC8iLtOXyWl3hoMZ+EVzKSvMLJC+eLosLamTo8/dtbKDcdiHbr"
    "kun7tHFx/YYlHSyoDIGBXDHLz2MX+ev2xIwQ1u7U0XQZ5beeKbYvFheO6hEuvUYSRoGArIHT"
    "RnnOTvVNTb7peS+9ApeISjS5aLgjAAAAAElFTkSuQmCC")
index.append('accept')
catalog['accept'] = accept

#----------------------------------------------------------------------
add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo9J"
    "REFUOI2lk0tIlGEUhp/5x1tl0sVSx+ziZBaVId2zkiCCECKwjVJBEERB0ICbaFdE0C6kRbXK"
    "pEWQmyQ0U7qHUJQVlaENWuMMkznOjDP6/993vr9V043adJYH3nMezvse+M/y/N44393kN1o3"
    "Ki0HxehiZQSldUQbaVHavd7c0DL41wHnuwL1IjSXzfeXVBavYVp2Po5xiE6M8HSgh+hoNKwd"
    "dfzKobab3zXen8Vam6vrK2rnVJfVEJkKMzjRT3jyM94sL1ULNpLUYzMjX7/Ura5b2v+q/cO7"
    "DMG5rhPlruZhtX+Lr6KoivvhO6RTaZSrycvLxcXFNjYrClbxpP8u74ODI2LUtrZj3R8tAMTd"
    "P3vWPN/iwuU8inQzqaZIq0kCa09xdGUT43aMsXiEp+F7bFq2AytHfI6S/QAWgNbmwKL5lbyP"
    "v2E0MUoinWA8FcvcJhQcRtkpUsmvfE4EqamsQYk+AJAFoIwqzcuezlAyiGNsTm44+4szF+tb"
    "AQh0NhIa/8iquetQWpX+IBBNSiVJOgmUV/3Td1cMHlyUaDIEjuhQKDa0ND83n/HJMQIPDpOK"
    "Jri870ZmM4DlsfAVLGQ4GkSLDmUIlJFrL4O9LJy+BFfZeEQzZ/aMXzYbcbGMh7KCJdzu60aJ"
    "XPtBoKTViHWkd+Ceb3P5Th4PdaCNJtDZiCsALjmWl9ry3XS8bCeenBixjd2aCdKzttexNXsq"
    "hsZi8bq4Hc3Z7t9FlpWN7aTJsbLxFy6nqng9HX236H37KiVaH+k7/eHJH1FuuLS73tGqWbKk"
    "pHbFVooKSsCFT7FhOl/0kEimwyLq+Isz/Zko//FMey/s8NuiGx2Rg2JU5plETAtq6vrzswOD"
    "v2v+q74Bs3Vib859UBQAAAAASUVORK5CYII=")
index.append('add')
catalog['add'] = add

#----------------------------------------------------------------------
anchor = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAc1J"
    "REFUOI2lkzGLGlEUhc+sgluIM01AYY35CylSpTFdugRst5EgFltFCCxYTGGzIEw1Wm4EwToh"
    "KWKaYBeIsKAWm2oTzUJYFpRgnLnvvDeTxkCW7Fgkpz3fu/e+8+4D/lNWkjEejz2tdVVrDa31"
    "y3K53LiN20sqQLKqlHKVUq6IVJO4dJKhtYYx5gdJkEzCkguICEmekoTW+jqJ+yuD0Wj0ieR9"
    "knAcJ4UYuPhyYUhCKXVWq9Ue7JyA5BuSIiJYrVYPjTYg+VFEQPJ94l1u02AwiHu9XryLScwA"
    "ALZddzZJA8BwODwi2RARr1KpdH6bSikopW4caDabR8aYhlLK8zyvk96C/n5mH4Dl9/t9f7PZ"
    "lOr1+vzPCVzXvWuM+XpwcIB0Ko3JdOID6OwBQBRF+eVqCWMiiMhxFEUZ3/fzIhKHYRi7rps3"
    "xmS01seAhfPP5wjD8A6w3UQR+RkEwfOrq+9z27ZPwjCcBEHQLhQKVrFYtLTWbRGZlEr3Tmaz"
    "6Xy9Xj+7kcFyuZQwDE9TqdTbxWLRzmazT23bPnQcB3Ecw7Ksw8tvl5jNpq/iOH4RBMF1LpcL"
    "gITP1Gq1HpN8opR6tN3EDyRfd7vddzuf5F/0C4pDJZPalDp9AAAAAElFTkSuQmCC")
index.append('anchor')
catalog['anchor'] = anchor

#----------------------------------------------------------------------
application = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWNJ"
    "REFUOI3Fk7FOlkEQRc/sLgVBbbU18Q2gpPAVbLSwtTE2dj6BiVYSEh5CGh+HEixoqRAM+829"
    "Frsf+YnVHwsn2ewUu+feO8nAP1a8+vj9w+HL/a9Xt+zZgIQlUollZOFMZONMUuLJTv91dnb5"
    "6cfRm5N2cLh/vLP7qDzd3Up47/p2OQZO2k2n3Fxdb239d6cANKf5/PbF1oB3X34yABYAd0ti"
    "wDIpEEYyKZGLx7G4S/P82WNSOQDYAEQJwsYlcJhQUEoQUYhIopqqQlvGey0TsJIK4AgIqAYF"
    "SKYaSlRaQIbJMhwrNSNoEIkA+wEoApxGAQ6gBFV1ANYIazMYMZoNkFrQJOThUvOJNB0svd87"
    "CMA2EYE3QJRCBdKmxHC89GVGmFkqjE8zygNHgIAagafyerfVCkDMw8bHtep9M2cwRdrl+cXp"
    "+2/9tTJRisxEEtk7ksYOKMcwPfZkaPr0L5X/Un8Ay9zpBmk1I4QAAAAASUVORK5CYII=")
index.append('application')
catalog['application'] = application

#----------------------------------------------------------------------
application_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAftJ"
    "REFUOI2l0k9IVFEUx/Hvue8NKWpBi5qBWvRHqkVaWBImFITboE0tWgVtcgiCFgltCwyKQtBF"
    "mxatiqCEIBChFiZRRBmJixYWMSYttCF1xPfOOS7eTE07hy5cOIvL5/5+lwv/ueTMlUfF3pNd"
    "txYqtLgDZrgZaoqbY264KuaOq6JmbM4lyzMzpWtP750bjo/0dg3lmlvD9uaGLm5ZqqRDwHC8"
    "khBWFpYajr6aEABiV+fm+b0NAxcHv5EBbgCspYoDbo4aGI6Zo2Zo6tl2Y02dXfk21DQDcAdA"
    "giDueBBcHDEhBEEkIKJI5EQWiNPsvKVVoCYFwEVAIHIwATMncggSEQuoOBqyxKZWrWCZiAi4"
    "/wOJgKtjAi5AECKLMqBWoTZkhmRDHWSxEJsx/n6UV1PPKS8vkqQJFd2XAWmS/EkggLsjIngd"
    "9OLdEz6Wxjhx/Cg7trbzcvoZbz6P010s3A5e7RIBUk0h1TmIEEQYff2QQ/s70aB0FvpQSTh2"
    "sAfwYjCzvxWqjxlEiOr2z18/yEkrpw9cBuDqqfvs2daBIE1xafbr40t3k7OmiqmhqpgZmiSY"
    "GebOQnmR6blJpuYmGOh7wODYBZqiTTi+Khv5dd39hRs7d2+53tPRS3v+MF/mPzD5aYLvs+U7"
    "GwIyJD+ISL9Am8Nv3EfejswPrAPE1ghQyrn13gAAAABJRU5ErkJggg==")
index.append('application_add')
catalog['application_add'] = application_add

#----------------------------------------------------------------------
application_cascade = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcxJ"
    "REFUOI2Nkr9rU1EUxz/v+V5+1ARr1Yigg6D+BerWQWeH4iCKCoIdrAh2sy7iEnRqqJtrHYQO"
    "KqKLgwj9GyyJCH2iwUFJE/Pjxbx3znF4bWybtsl3uNx7uPdz7vfLcabuv7w8eeH83VpHMwYg"
    "RiwRJoYgEAuCkSWkvPJ9/s3CtVdsknd28tyslxlzCxmGqhPKLLAVEPbMDWut4a+BMDJ3e80z"
    "MYo3To8EuP3020DNUzMA3i9/Kfzspo//bptrBqhhqojGqAomSm78AHPPl4NKufrodenqIoAH"
    "CsDXRvpEPj/mFFK7/yDf/Iuf8gk78hhIAM21RuIvNidca+9pod4M2ef7hBH9LLxqEHycmY8u"
    "jh85zIOpk4CRuLL+w41jKuV2c9k005uycDY2c4uV4MnNM7z9VMmvtvyDv1rmJFnoehaCiGAi"
    "qBlZp0N5pXrP+98m6fi55k/kcvs5OrGnGwDanfhZH9Cq15Niz2iPOBfdCLcP+BEE7+6UepcO"
    "FY5RvH5qJMD0DnPBwxcV201qZqpmqmpmZreKHwZHcyOLneRsXdBY8LZfaq5nMRwCzcafQUB1"
    "NViaKUVXVAQVRURQVSSKiEUwFUyMKIoBW/oHIcgOeWSBNF4AAAAASUVORK5CYII=")
index.append('application_cascade')
catalog['application_cascade'] = application_cascade

#----------------------------------------------------------------------
application_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfBJ"
    "REFUOI2lzzFIVXEUx/Hv+d+/6etZUAQqIfbArZawNsGgqaaCUKKxICqCaikIwqWwyRDEaGtM"
    "CCFxCYfApTFaHKLSyKcQOfTsPXv3nnMa7n2mQ5B04MDhz5/POT/4z5Lzt17cGDw18Hi9Qdkd"
    "MMPNUFPcHHPDVTF3XBU1Y39b+nNxceXuzJORyXhicGCirdQZukq7WlzeaGQTwGSsp4T6+sau"
    "T99MCQDR1Xl4qX/XwJWxZXLADYBmpjjg5qiB4Zg5aoZmnrcbTXUq3ftQ0xzAHQAJgrjjQXBx"
    "xIQQBJGAiCKJk1ggZvl/ywqgJQXARUAgcTABMydxCJIQBVQcDfnFplZEsFxEBNx3QCLg6piA"
    "CxCExJIcaEVoDbkh+bANsihEM6qzT1mdnaL+5QNtXYc51j6UA1mabl0ggLsjIvg2aHXuGbW3"
    "0xy/cJn2ylEa719TWpjn5Ol4M3iRJQGkuEKKOYgQRFh+OU7/0Dk6Pr5Bnl9k76cZKn0HUfx2"
    "NLM/EYqmFaWoZnWZju4KnL2z9RZHe0hcjsSVz0vT18bTYVPF1FBVzAxNU8wMc2e44wD1d3OU"
    "X13nV2ONOlD7kaAJ1Z2r/lILIz2jezrL93sPaYzhK7VvGUtriTY37cE/ATnSe6/+vXo1mPRZ"
    "8BXDp87M26Pf2WAIlHqbv3EAAAAASUVORK5CYII=")
index.append('application_delete')
catalog['application_delete'] = application_delete

#----------------------------------------------------------------------
application_double = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcRJ"
    "REFUOI2Vkj1rlFEQhZ973xtZ8mFAC9dKFP0HapdCf4FYiKKdNhHBgIVgH0ilKGJlL6TQ/ACx"
    "t7TQLZMgC4Jo436+984ci3fX7ILF5sBlODBzOHPuhBuP393cuHb14a+BtzDhMiwbhkExDKFi"
    "mJz1E2X07ev3N3sv77xngnR548pWai3HMy0WQas3sC3gSGBYKw5/9xaaBhhmxVmeZGL73qWF"
    "Be7vHM7x5BIA42J8+Ng5+6Msn/v5RxXuyJ1SCi5HZrjE2vo6j15/1sml3O90uk8TOAAhwP5g"
    "+cLq6grt0wuZWekNy6vk3ghEoF+L/jHyGGViKqVMHARkYvvuxYUFHuwckkqdGxYjUuNmXAy5"
    "MIfijrljRc2TU5s4317D3EiWGwcVwCTQGEAxoCASkRAiIRihEpVHUmn6vBipe3DwafN5vl5y"
    "zal2+986BKgEkqgEMVSkABaExcapm8/v9OTtF0lScVdxVzZTbaaRmcY5a1hnDeqs3ihLkm4/"
    "25u/qpLzkYOZGoEQI1UVCTEQq2l/Ic0KTPOIzXSTzaROsTTbbzYv0N0/2N18kW+VOmNmuDt5"
    "PMYl5IZMzVW605yPdv/3vcfCX4l7He7IDgaIAAAAAElFTkSuQmCC")
index.append('application_double')
catalog['application_double'] = application_double

#----------------------------------------------------------------------
application_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlNJ"
    "REFUOI2lkk1IlFEUhp/7zTdj5s8UlkqR/RlRIhEGEbloZVIQBJVE0SY3FkKLKGgbQrYpDCnK"
    "dgXWJkFahEFkZRD9KGZOSprQaGpOpjbOzPfdc1rMFBhtpLO6XHif94Fz4D/HHDxz73TlnorG"
    "2Dw5qoAIKoIVi4oiKqi1iCpqLVaE/KD3s78/ev7B1Zpmd0dlRVMwO9cpyl5Ucc7cvN8ENLtx"
    "Dycem1u0esLDAXDVKg3HShcNqL00QhqgAkDKtyigolgBQRFRrAjWV6yveN+eEH97h0BuOfWF"
    "T6lvLjvhogqAcQxGFXUMahQjBscxGONgjEVi7QTHXlNcfpzw+u1MD2+m/1HLZdeKBcAB1Bgw"
    "EFAQAyJKQMGf7CCU/EDOpt3EPvUTMiny8ovJLSgJuyppA4wB1QUgYyA10YmZfUV4w16SY62E"
    "lhpGuiPMxIHU1DZHMgZpRiaVMUpOduJPdRDeuI/E6C1M8DvB3DxyNMbd6C521rcNOL7n/TEw"
    "mbAxhvFIO/EvjwiXHiARvY4T9EjNrGPyeQ8rqxoYnV+WLlKb3kIAMJnwROQhs9EuCsv2k/ra"
    "QiCkJGfWMvniHcWHbrCkaAsq6ZwrmQcZwGBXK/6PXnyzirHeaywvDJGIrWH6TYSSmpsEw6sB"
    "kMz23Ojw5/t1V7wjYi1ihSrTwuG623xsPcvAsy6ySrbxYzzKw8RRxhteoiKkO/X+79IFc7F2"
    "q3fu5CkXx9L9uI2RocG5/BXhyurGvp5/XWTg74+Cpd6FkaE+/LkpSWbZ5w5Sva/xfeRfYYBf"
    "uUQgv6QY8HoAAAAASUVORK5CYII=")
index.append('application_edit')
catalog['application_edit'] = application_edit

#----------------------------------------------------------------------
application_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiRJ"
    "REFUOI2lk01IVFEUx3/3vjc541eGhYYVCJIIFdlEtXDhrmWYUYTbdm2qTeuIwHYluMhFi6BQ"
    "+gKJ2rS1SNMiCDMQ07RykabNzBvnvXtOi/dGXbiRLhzuvVzO7/z/h3PhP5fpujJ0uaMze3sp"
    "oEoVEEFFcOJQUUQFdQ5RRZ3DiVCbCvOTkwvXn9+50O8f78j2pTLVtiGzrcJVuSDqA/r9Qogt"
    "LOW2Lb0YYgF8dcqtnpZtAy71zhIDVAAoRQ4FVBQnICgiihPBRRqHCiWnNDfW4MQBYFEFwFiD"
    "NWCtwXrgGYNvLb7no38/UJruJWUCKlM+ABIlgA0SGGMw1uBZg/UMxoLVgOLcM6rrjxD+fIm/"
    "w8YAFyu3KrECjFkHWWOw1uB5hsL3V1TWt1O7t5383GvIzcSAcuHygUTBZpDLLfBn+gU1u+tw"
    "q8PsabvIytQgKhEiiYIoDNcVmCS5vP/+8pj6ljNQnGD0wUOq6wJWZ0ZYmX1DFEaJhcSLB5hy"
    "H4D8rwlcfpmaXQVkbQZUcLkxmjuvMf/2HimKZQuyYaHcTHUsvr9P3YGjSOETKgHZ7lak9IN0"
    "+iu1+07RnhmNc7quDg417G86L84hTnDOcahijHMn0jQezOByo6iWGH86Sba7DePthMxpRgZu"
    "rlVI4ZjZasre3T05f7jnUZNnv6HRMqCbXi1eppXFzx+ZGr7xxN8KEK6V0uMDZwMVRZPfqaps"
    "3BVEQLTxH5oYG4bgspQLAAAAAElFTkSuQmCC")
index.append('application_error')
catalog['application_error'] = application_error

#----------------------------------------------------------------------
application_form = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWRJ"
    "REFUOI29k7FOlEEUhb/ZLAXBWEphocFGshVC+Re+ghb6AoaGEOxs7KysdEko1CeAhjfBcunA"
    "gk2UBCh+wGT+ew7FjEQNbLIx8dR3zj3fyR34R6Vnr7fXmqfL708umbMBCUuEAsvIwhHIxhGE"
    "xN2ZfD4aHb3Z/fhyq7/SLG/OzN7pzc9OtXiuvew2ga3+RaZ3cdJOHf1npgfQd5i3z+9PbbA+"
    "/EYxsLCNATAYSImve3u3Pn6ytEQoigE2EcHq8PB64MvGQwCaprnRoG1b1FWDUGn40/oDSAYn"
    "ZE+MLwmFKoKMQqQEVsVIZjAYcHZ2yp9eCTAJ0C8EKZAC/zaCYbQ/ujXB48VFpJqgy5mIYOPz"
    "9+uB4er8xA6Oj3/Q5a4ihJDEh1f3yurKOEkR5VorgpAMqBIWLSw8YjweF6hkEgkb0l9F948O"
    "DnfebecXikAhIgJJRM6lbRsrcNR/IVGWe2dizP+mK7xR6EKdJR4LAAAAAElFTkSuQmCC")
index.append('application_form')
catalog['application_form'] = application_form

#----------------------------------------------------------------------
application_form_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAflJ"
    "REFUOI2lkU1IlGEUhZ93miFFK2jhDxXFiFAMGZMhIkNEYbQqalHrIFwoYtAioXa1MChqBIVs"
    "EbSzFha0CqHNIBKhJNkIBWOEnz8LHWvSwW/uvS2+SRwoaeisz33OPffCf8pdvD7clTjVfG95"
    "nSozQBVTRVQwNdQUE0HNMBFEld0R/2c6PXdz5NGVgfCJRHN/pLI6VFtZVnBVbr3QDwyE13xC"
    "a8u5slfP+4QAwibG7Uv7ygZ0J78SAEwxMwwAAwOcY3Ji4q/Dx+NxRCUAYIaI0JGc3TQ86TkE"
    "QCKR+CMgl8uhhSJANLjw4+6D4AzMoWbbrq+qqGixghoqinNgWqzhjFgsRja7QinLAYYD9HcF"
    "VUFVsC0WDNIz6ZLU9OJ7ZpYmyOW/s+FvsC6HA0DB9xEReoYWN83JjtqSG7weH2bepjh9spX9"
    "ext5O/2S8Y+jtHTV3w+bKKrKw2s1QXSx41aNpJ5x4dxZJCQcq29n9NMLWo+2kfnyqiukqqha"
    "UEMDmKoSjTbgeR6eN89Sdp6Iq+b8kW4AbpwZoqGmCYerCM9lZp/fGfYvqwgqioigqojvBzAz"
    "lldXmPbG+OCl6G1/St+bq1Ts2Ilhebftv4pq6ay/eyC651ZbU4LGujifFyYZm0rxLbP64J8A"
    "AaSuD+c6Hewy+IHZ4LvBhd5fZAcZ0vVRcdoAAAAASUVORK5CYII=")
index.append('application_form_add')
catalog['application_form_add'] = application_form_add

#----------------------------------------------------------------------
application_form_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAe9J"
    "REFUOI2lkb9rk2EUhZ83+aqJKf4AtS1S0lSc4lJbtwyik246tOIsVSqh6qKgSEERnGoKpah/"
    "QUUUAi7SQewiglFc0kUapQkRsS02JrVf7r0OXwwNaDF45vM+557zwn/Knb48eyl1bPDeco2Y"
    "GaCKqSIqmBpqiomgZpgIosrODv9HPl+89uz+yLQ3lBqc6oh2hrqibQXHKrX6FDDtVX1C1eVK"
    "26ev+4QAPBPj5pkDbQPSmU8EAFPMDAPAwADneJfL/fXxkYEBRCUAYIaIMJopNA2PxvsASKVS"
    "fwRUKhW03gCIBgs/SMfBGZhDzbY8X1VR0UYFNVQU58C0UcMZyWSS1dUVWlkOMBygvyuoCqqC"
    "bbJgkF/It8bmssibp9TLnwnv6+Zw9HgAqPs+IsL4wy9Nb2a0q2WDpewMK8XXHDo3xvZEktqH"
    "F8Tm5zh6wkt7JoqqMnl+fxDd6LhZi08mGTp7kcjHl/DqDjt27SYRj/N2wa54qoqqAdpoGKi/"
    "/yClUglwbJQKRLoTcOpqE+pN9BA21+cVFwuPb8/6wyqCiiIiqCri+8HaZgxH9lB9/5xYdoyf"
    "tTJVYO17GAlTclv+V0PzIz0T2zpjN3r3iueFllj7WqdQDsvGut76J0AA6b1e/Va6EFIX15AV"
    "FZs5Oad3fwGo7gpAHG3N2AAAAABJRU5ErkJggg==")
index.append('application_form_delete')
catalog['application_form_delete'] = application_form_delete

#----------------------------------------------------------------------
application_form_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmNJ"
    "REFUOI2lkk1I1GEQxn/v7n+11c2lDA0k7cMIWkSiIKINOlUEQQV9QXRJgorFDlER3aSDXUpD"
    "orJjVBIUQkHUJRILAlupTbMvRdYPctcPdF13/+9MhzUh8yLNaRjmeeaZZwb+M8yBc4/Ohndu"
    "rk9OU6gKiKAiWLGoKKKCWouootZiRSjyZae6uuIXn9w40uRsCW9u9PkDnlL/ogYXTk67jUCT"
    "k8riSSUnFy09ncUD4KhVrhwsWzRBpKGPHIEKqooCoKCAMXzo6PgH5M90EhhqwxuoIlLymkhT"
    "6ISDKtZaTjX0zjXerV0NQDgcnqulBluZ6O7HX3Wc4JpNjP3cQNeL5muOlZzDtyMVYBTUIKp/"
    "TU4NPmdmLMry9dtJfu8iz2RYWrSSQHF50FFRxArGgMrsGkYJhUKMjY3ijr7Fm3pHcO1uZgYf"
    "kldg6It2M5ECMolqj4hFxOJai53NxRVisRhfOx7gnWojuG4v6YG7GN8ovsBS/DbB/fg2tkae"
    "9jhuNou1lto7w3OSG06V4v5qp3JVkmDlftLxW3h8LpmJNSTaO/HvuMRAbGj2ClYQEa7XlOTk"
    "A8nvLyktGKEktI/MUDPePCU9XsFI+wfKjzaTSBlUBnIEIoKIAoIB+qOtBEw/rilj8ONNlpXk"
    "kU6uIvn+M0t2XmVkKnfqP0Y78Z+9LXWPsofFWsQKu8xjDp2+x5eH5+l5005+eTXjw3GepY8x"
    "3PMNlR4kZ3YLgJn/LHU1G7MXTp5x8Fiir57S9+PrZNGKYHhPfaxzoY/0zi8UF2Qv9/2I4U4m"
    "ZCbftnmQPXvrP3UvBAb4DQ1SPETkn2FaAAAAAElFTkSuQmCC")
index.append('application_form_edit')
catalog['application_form_edit'] = application_form_edit

#----------------------------------------------------------------------
application_form_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAf5J"
    "REFUOI2lkrFPFFEQh793u3vHgSgx8Q5CVDjtMFHAylyMrbHCQis7pTEErWyMvTYKCYX6D0Cl"
    "lbVGK0zQ5nKSYAIFEjEeAfZuWXZnxuLWq6S4ONUr5n3v970Z+M9yUw+W7levTT5tRPSZAaqY"
    "KqKCqaGmmAhqhokgqhwPkma9vvnozYvbC/7l6uR8UDyWKxe7ergvjNJ5YMFvJeRajbDr6AcJ"
    "OQDfxHh8c7hrwMzcBm2AKWaGAWBggHN8WVk58vLE+Dii0gZghogwPbfeaXg9OwJAtVr9JyAM"
    "QzTNAKLtH345cxacgTnULGs1PtY22d6LCOMChcDnRFG5MlpARTMFNVQU58A003DG2NgY77+u"
    "09Q+Lo6exA88tncP2dmPWf4eoplCTlVQFVIRJDtrqtRqNX5FPVTKvezEjq09IXUew6V+GpFD"
    "NUuQJgkiwuyrnx3Huely2zU6JJ8PSOMUNYhTo8f3SM0nTdJMQRRV5fndUjs+dOi9hYDDREgE"
    "Us3m5KDVbGJ/E6gqqgYoroOASuUcB1sJ+5HQX8wTi+HnHFuNBPu9ynlvFQA39XBxqXx6+JaK"
    "oKKICKqKJAlB3mewNMDEhTOowW4YI9t1qqd+sLv2Kd2of77jjtyWI+rtk+v3BoeGnpUqlwa+"
    "Lb9red0CFj+srVwdCTeS+OBGzvN6/wBpiSds75Fu/QAAAABJRU5ErkJggg==")
index.append('application_form_magnify')
catalog['application_form_magnify'] = application_form_magnify

#----------------------------------------------------------------------
application_get = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdBJ"
    "REFUOI2lkL9rFFEUhb/7ZqIsUbEI0Tas/0FMI1v4LwhiimAh2IiFioiFaAIiKClcImuntUlj"
    "b2UZBFsjK6IJhKwWC0I2OzNv7r0WM+OPyiweeHCLe757zoP/lFy4uX69c37+yXDMtDtghpuh"
    "prg55oarYu64KmrGiak42travfu6u9hLz3bm16Zax8Kp1kSHp/fH5RrQSw8i4WC4P3H0LBIA"
    "Ulfn0dKZiQFXH29TAdwAKErFATdHDQzHzFEztPTquVGoM3f6OGpaAXAHQIIg7ngQXBwxIQRB"
    "JCCiSOIkFkjLat/KGtCQAuAiIJA4mICZkzgESUgFVBwNVWJTqytYRUQE3P8CiYCrYwLd9w+x"
    "0rmx8KACNIeboWLUrjpREEHSwOrmfcbFiFH+g+U3t2pAlSCUMf5KILW5AamVrLy9TYw57Zk2"
    "c7NtsjjiyoslYswrgNddEkBqs9Tzs3erfBvukWU5WVmQlTlHj7TYGWzzPaw3Fex3hT+iJyLc"
    "OXePlxdf0d/5RB4z8pjR/9yne/k5M3Gx+sTdL183rj2Nl0wVU0NVMTM0RswMc2d8MmNc5kSN"
    "DPYGLHc/Ar7RHP2nOisLnueRmEWKIvKh1z+U71D6CSItEOxrcOwtAAAAAElFTkSuQmCC")
index.append('application_get')
catalog['application_get'] = application_get

#----------------------------------------------------------------------
application_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg5J"
    "REFUOI2lkr9LlWEUxz/nea+DPzIMQSmVNBeNINAwykCKooYGlxoaXFqiRZcaChpKsCEQwf9B"
    "J5eGhoKICoxqaBErEJWMBgX1Xu/1fZ9zTsPrtVXpwIGHw8PnfL5w4D9Lhkdn7w8O9T3fKFPv"
    "DpjhZqgpbo654aqYO66KmtFYk5UWFn49nJu8PV3oH+ybqqltCC21h1pcXyzHKWC6sJMRdjaK"
    "h1avZASAgqszfqf70IC7E8vkADcA0qg44OaogeGYOWqGRs/bjVSdztYjqGkOwB0ACYK440Fw"
    "ccSEEASRgIgiiZNYoBDz/xZzQKiSAiAiSBCSIIREkABJgJokYfzldR7NXcCTLAdobh7cciIi"
    "+6Ag+fYkERKBEGA3prQ19zA6O0AaK1g1QvXBngEA7jyYGcI9klokjZHjTd30tA6wXSlxc7qL"
    "Jp/MATHL9g0EcHdEhGgpV0+PoJ4fleGsba5ypu0ixbTMl/IIfRMcLfhelgTwahR3KjFF3Vhe"
    "/0FmkWgZmWZs7W5ztv0SxWyH+aX36wUz+xdhrxGhEitEjbQ0dhBNUTd+b65wrKGVr6sfmP/5"
    "jZLRL8NjM7Mt7SdumSqmhqpiZmw136OSpqSWUokpp5p7Od91jc8rH3m3+ImT5bFXr188uSEH"
    "vbzep1I613G57u33N78y4craMxar1geqzseU1JO6XbTrzzhL1flfG5ckP7BkOx4AAAAASUVO"
    "RK5CYII=")
index.append('application_go')
catalog['application_go'] = application_go

#----------------------------------------------------------------------
application_home = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkFJ"
    "REFUOI3Nk01IVFEUx3/vzXujznMMjSjTFllQDbVycKP0AUG4DKUW1SZqERFEgQV9gExJ5iIT"
    "DBdZG40yRNq0LIiCvsCCQEJDxdSknJxmnDf43j23xZuZcBltOqvDPef8zv+cy4F/NOPg2Uen"
    "m/bWdyZdHK0BEbQIShRaNKIFrRSiNVoplAgVtrc8NjZ7YaT7cK8Vb6rvscvKzfVlf9XYybh+"
    "D9BrZT3MbDKzKmr5yzTOJ1jxPVxX+LTtGn7IWZWT8zABLK00149sLQY89xcfBhLY1VWkMy4b"
    "66oIT1yh+fwAdmm0mHfixjQAptYCwIqvWM4s8fHBOUxLk0rnKK3bz4+vU6ytrmWk4yhT03NM"
    "fksDoEQFALQOtmkafB6+iBk2SLtC9b42duw5Rs3uM8yMjxOpiPKs+zgR2wJA/ABg/SFBLpfC"
    "kzCbm69Sua4GL/uTTbFGtL7M875L+J6PFTYDgAqUW1p0/kMNGk4O8vTJMBtq6+jq7GBpKYXj"
    "OLS3t/PwcZy2RBcEdUihccEJGAaeGIi3gm2HicViGIYBWhNyqrBCYIYKgLwC3/MAeDP/ircz"
    "75jIjLFzcRdRJ0okEqHELmE0+Z50wxy3X3Sydc12WuMt+J6fHyE/y+Dr+7hZl+R8int9/YTE"
    "YuH7Arlcjrt3+lFbcnxZfMmoO0prvAVdUFCQkjhwE18pMosZtGiUUkWZogXLsiivLCccDuff"
    "gt1Zs5NTQ6dueYdEKURJsVB5HiIS3IAotMrfhQgBVw/xX9hvyZowCXRnS8cAAAAASUVORK5C"
    "YII=")
index.append('application_home')
catalog['application_home'] = application_home

#----------------------------------------------------------------------
application_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi1J"
    "REFUOI2lkstLVVEUh7+1z/GimQoVVCSiFTSoQaKDJAeFBFE0aFJEhRMJpAaN6h+oqFFliBRN"
    "gkCTHqMSpMe0CCIk0yxJKwv1pqXe1zl3r9XgqjWwQNqwZnt9v2+tveE/jxw8fedk4666S1MZ"
    "Ss0AVUwVrx5TQ00x71EzzHu8KuVFcWpgYOzsgyuH28P6xrq2opKVbm3JsoJL5zL5NqA9TMe4"
    "9NTcstWzMQ4gNG+cP7p52YCWi6MUAKYARHmPAaaGV1AMVcOr4vNWKFMib9SsK8OrLwAwA0Cc"
    "IGaYE0wMUcE5QcQh4hHniV7fIMwMMzPdhOZXAOAWSA4QEcQJgRNcIIiDwEFREJAf7Ka0+BPr"
    "dzaTHX9ElfUX+kwLBogsgpwU0oNACAQyQ/cJss+o2FJParSHoHgDx2qe03Nq45FQ5w2YNwDA"
    "DAeYCBoK+eQrVtfux6f7KV5TSdZ/oWr3NkhPdIT5OF40EMDMEBHsD1BQWkk8PYILkohLkShP"
    "QjbN3LdcEJovvEIAhSYRFhYbJd8y03cdScRoPoPTH+DKsDjiTdcwQ0PfT4Sq+nuE+UKE2fcP"
    "mRm4y6raBizqRfwsg70RRbkcgQi3J/dxretcZzj2caS79XJ8SL1HveK9R1Vpre5ie9MeomQH"
    "YVhB35McnYM7GE9sxQyiRKL7nz/t8729L3LjFyz17oC9vNowe7N50/Gl7oV/A3wdmXw88/Np"
    "dWo6nfkwNHGm5dbwkom/AB6tGoaXd8wEAAAAAElFTkSuQmCC")
index.append('application_key')
catalog['application_key'] = application_key

#----------------------------------------------------------------------
application_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAidJ"
    "REFUOI2lk81LlFEUxn/zvu+MjpMzIYUj+EE4KUTQwmjlQlcRFKSUQUKrNhGBu/6ACmoRiuI/"
    "ELjIIHHRppatgogISdPQPtDE749x3nHuvee0eGeKoiDprC538TvPw/Mc+M+J9Qw8vtnZ1fFg"
    "IySlCoigIjhxqCiigjqHqKLO4URIx83e9PTi7YmhK6PB6c6O4XjykFefPNDiVD60w8BoUDB4"
    "hY38gaUXDR5AoE651587MOD6/c9EABUAStahgN19Q3FpBHUWdYJYQZ3gjEGpwbTc5VhzK05c"
    "BEAVgJgXIyYOt/OSqpp6/PhR1FjUWFwpJNycQbN9xFNZAMRGAK9C8gC1q5TWnhNPtiB774l5"
    "KcRZiluz+A1XqW44T5AIIoCLlHsqWnbl2F99RqI2B/hIuIzYfba/vsDP9pJs6sEPYiR8PwJU"
    "LFQetjBL8dsE6aazqA3BbwBjUAmQ/Bf2pocQE6Jemur2y4hECgJrDAD5+UESmeOE6zOIFRI1"
    "OZCATLabcP0dzpTYWXpL3Zk7+FWHscaWUyh7qa7rxhbXwPOI+SU25ydJN3Rhi1uUCmt4mVM0"
    "9z4kqG3C8320oqAiJdXY/yNjsXm2P4xRWJmiuLtC3ckBMm2XfumBlNMLFhc+jd8YNH3iHOIE"
    "5xz9jSO0H6nj1ZzH5PItwtc+6p5GdyFCtFPH/9iwj0/azs2N5RZmHrVe/HsPf07w+0fMsFhy"
    "cuHEtfmpfwF8BzZLJlSQvSTcAAAAAElFTkSuQmCC")
index.append('application_lightning')
catalog['application_lightning'] = application_lightning

#----------------------------------------------------------------------
application_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAltJ"
    "REFUOI2l0k9IVFEUx/Hvee/pJK8/jhgOLpSkTYgr2zkwbQRdFElQg9KqEqTNFETLVkHSogha"
    "K620Ra5sL5mbCIoIRTD/4Pgn/0H6dPS9e06LUcmldOHCWVw+5/eDC/95pKsw/DB7rbV/c4/Q"
    "DFDFVHHqMDXUFHMONcOcw6lyviKOJieLT0de33kbXM22vqmoOuvVVZ1qcbizl7wB3ga7Md7u"
    "5s6po5diPIDAnPG85/Kpgfsv5ikDpgAcJA4DTA2noBiqhlPFJVa+phw441LmHE5dGcAMAPEE"
    "McM8wcQQFTxPEPEQcYhv+OoRJOX3mhwCR5IHmAgI+AYqoGr4Bp74BAJODOeVE6vTwwpaFhEB"
    "sxOQCJgzVMAE8ARf/TJwVOFoKBtCqVRifHycnz9+kE6n2djY4GZXFxfSNbwbHKAmnWZra4vK"
    "PZ/29vYwSOL4OEESxwwPDbGzvU1PTw9RFLG4uMjH0VHOVFVx4/p1fN9neXmZ4OtX1qYqnwV2"
    "2MUHPk1M8Gtmhlv5PAODg0x8/kwmk6GlpYW52VlefvnCysoKbW1tZLNZ5ufnez1VPa7w/ds3"
    "wjAE4FGhQBzH5PN5stksnZ2ddHR0EMcxhUIBgOrq6lRQnJ173/cqvq3OsTz1h/rK3wDc7X3C"
    "/kFMf3//MRpFEXHi6L73mMd93RSLxZL8+7uam5uvNDU1fcjlcpmGhgYNgqBmdXWV6elpUqkU"
    "jY2N1NXVkSTJ5sLCgjc2NrZyAgD8XC7XEobhSH19/cVUKuWbmbe+vv5ARIq1tbUjQMX+/r5b"
    "Wlpai6Ko6y+SXDAZX6KQpwAAAABJRU5ErkJggg==")
index.append('application_link')
catalog['application_link'] = application_link

#----------------------------------------------------------------------
application_osx = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXhJ"
    "REFUOI2lkDFrk1EUhp8v382XCiY6VKikOFVEXfQX1M3JpT9AFHHVUXDUxcVBcNHBpZtQ8Ee4"
    "Ck6K0Cp1cTeRJPe851yHJG1dYqIvHM6Fe5/3vPfAf6p6s/v21WZ/4267adolQOFYFpLIEjmL"
    "bMZkYtOejZyN0Whkh9++vk6b/Y375188q87c/sCd+hIvr+7+fWoFZ3un24+fPu+ndrtTndve"
    "Zu1izY3WdQAub11YaPB5/zt13cIVVTIXP27uADvcAiY58/HTPgCSYybkjsmRHPm0fzkIXEYq"
    "EVy7svVPC9zbe7eepABgNJ6sBJ9a6+AUkrsD0GmaPx6UUqZFIWJ69ghKmd4BhDspm1YC5wXg"
    "ESSTVgaP5DpOECWWB+d8KSSbGbjH0uBcsx3Y0X9OwgBVVS00oBTScDgcjMfj7s/BLyJiZnC8"
    "6ZNp5oEKhSa1UEjVg0dPHnZ7vXuUupvDcHOyHDfDZLiEuRFZWIgwESHMNIjQ+8URl9BvWnRd"
    "oCkYf0QAAAAASUVORK5CYII=")
index.append('application_osx')
catalog['application_osx'] = application_osx

#----------------------------------------------------------------------
application_osx_terminal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAa1J"
    "REFUOI2lUjGLU0EQ/mZ35il6p69JOLnjsBE5tBNSidxPSJfOKGInFiKChW2wPbCx0OaaYJHK"
    "Kv9B8geuPBvJWXjBl7czu7G4e+GdeYcBBz52h52Z75vZAf7T6PPhl48721tPJctkkQBLERoM"
    "ZoZghhAMQRVlqWdnUISgKIpCf578eM0721vPbx28p5uPv+GJv4sP9w7/zUpAfmNDBgef7rDI"
    "Fdp98RKyd4RXtIucN9aSfv3aVZgasUbD/pu3IKJGOOfgnFvxnXO4ff8heJESvPeYTqcXgpoS"
    "6n6r1UKe53BmaSlrNBphMBis/QOqBhdjhIhARNDr9dDpdNDtdiEiyLJs+VYHM0NEUGoJDmpg"
    "ZjAzhsMhJpMJxuMxRGRFdr0t7z20LMFqtmTr9/sgIojIMhDAygwAgJlhpmcKKln1AdYZm3zv"
    "PaIqWM9bqFj/LlIpIKILd+ccVBUcVOG9h4icb1kzY4WqiPce86jg2Wx2ysyb7Xa7MfiyIkSE"
    "MC/mfHz8/d3eg0fPsPCbISmiRgSLiKpQU0QzaFSkYAjJkNSQkkHVTovfv76uvTSX2R8MA7DL"
    "4SxJxgAAAABJRU5ErkJggg==")
index.append('application_osx_terminal')
catalog['application_osx_terminal'] = application_osx_terminal

#----------------------------------------------------------------------
application_put = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdpJ"
    "REFUOI2lkj9rVFEQR8/c9xayRgUJcVewULQSkUi0i2jEL6CFKSwVRLTQKn6BgKKiBNLaWCn+"
    "+Qg2ItiIonELA2oRDRYBIdndd++bGYv3VjeCYHBgYLjce+b84MJ/lpy++vDy1InJm6s9Rt0B"
    "M9wMNcXNMTdcFXPHVVEztjfSeqezPPvs3sxCfmRqcr7R3BpazU0tHl3rlfPAQt5NhO7q2qbV"
    "+4kAkLs6c+f2bxpw4cYXKoAbALFUHHBz1MBwzBw1Q0uv2o2ozt72NtS0AuAOgARB3PEguDhi"
    "QgiCSEBEkczJLJCX1X0ra8CAFAAXAYHMwQTMnMwhSEYuoOJoqIxNrY5gFRERcN8AEgFXxwRc"
    "gCBkllWAQYTBUDGkGoZAlguzz8+TYkmMidRPPJh5glllEMqUfhkMACL1+jpa0U8c3zPN9L6T"
    "9LoFAGUq6wh1lgzwoSjDRkWvoCgLoiZGZITOt0W8NsgHKgBS92D77ZdzfPj6jvHmTvplJGpk"
    "fEeLK/cvkvJWBVj+9PnRpbvprKliaqgqZoamhPlB4u5FtowVFKlP1MjK9xXWfzTYVZ55DE+R"
    "v/+133Xq1rG37bH2oRgTSx+X3ry+8/7wv7zbUEevT7yauHbgxZ/nPwF8oQoFwSjRfwAAAABJ"
    "RU5ErkJggg==")
index.append('application_put')
catalog['application_put'] = application_put

#----------------------------------------------------------------------
application_side_boxes = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXNJ"
    "REFUOI29k71qVkEQhp+dnS8S81MZktYiVxDLFN5CmliktBIbu0CCpYiVEsgdJEjS5Aq8jaSI"
    "oE1AUb5Cv/zgnpmx2HMOyPlShIADyyzD8LzvzjJwz0gbr45erj9deze+Zi4CcCfcMTfCAw8n"
    "zPAIwgxzZ3FULs/OLrZPPjzb1yfra3uj2XlZnr2T8NzkutkD9vWqIFfjyZ2t3xQEgJ2D85gW"
    "ux8/T6138fztpwDQCAdg9/C8p7/ZWu3v48kN1kQ94fyx4PHKAuYGgBDRNy8/WhhY1azoSNAH"
    "wsyM8nCkAHhTAdqRAL7//D0AZAFJGU1gKTCpjt1q1vAY2P4HkMATRAIkkT1XQCus3eW2GSQV"
    "1B0PECqsAqoDaUrpm1eWFgcOBEgi5CwkSUg1QFOa9gntWwC+/fg1BKQq6UBOiWiVu6ydldtn"
    "UAG5L7QzaH9PL758PX7xvmy6GW6OmeHuWClsvT6tO+BGWLsX7lTNOJ6q+N/jL6++8ahOGq9p"
    "AAAAAElFTkSuQmCC")
index.append('application_side_boxes')
catalog['application_side_boxes'] = application_side_boxes

#----------------------------------------------------------------------
application_side_contract = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcBJ"
    "REFUOI29k71rVEEUxX9v9gWyJqyuFomIIItpFYllCv+FICSCIBYBBRsFUUEkigqxUgJRgpZ+"
    "RRLSpUpvFSMIrgoqW1iJcYvs58y912LeRoLPIghOOTOc8zvncuEfTzJ+ceHC2InRexstBswA"
    "VUwVUcHUUFNMBDXDRBBVSn2+Ua1+u7r8YHIuPT42OttXHHRDxR0ZD2y2wiwwlzY9rrmxuWP0"
    "tscBpCbG2dNdkpiIhASH4+bidc4cneLI/mOUd+0ldek2gamZGgDOTLcuRYUXr58C0Gp2kCCY"
    "WS6BqACQkn0wYH71IT/q36kdrlEqlAhB4kOOhoYo4HpKj1cfURDHoX0VnqzM018ogoCqYTkK"
    "KpE8NTVmlu6wu7/MyPAIwYQ9g2WqHz/Q6XYxU5KsoW0CmbFTFa6dvEGj0eTNp3XW3q+xuLJE"
    "u9NGgqCa34FqJHDBewAuT1yh/rPO5y9feXbrOevv3pJYnEpekcGHKGDyewq3z92lMlwBoNP2"
    "dL2PEZI/I1iPoIcCkBZSps9PA+A7fquo3AgZVTJ+6eXC0MEDEyqCiiIiqCriPaoad0AFk2wv"
    "VIme9mr5/qnJvzr8t/MLmGH+S8wz2I0AAAAASUVORK5CYII=")
index.append('application_side_contract')
catalog['application_side_contract'] = application_side_contract

#----------------------------------------------------------------------
application_side_expand = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAd1J"
    "REFUOI3Fk71rVFEQR8/72I0xIrFxI1EEk0LRLhYWi1jkH0hhIliIYKFIQEEULMRKIgpKQrSx"
    "08IVIYhgIzaxsFUUg1XUENwlySpkP97uuzNj8e6qi1oEC281xb1nfnOGC/94grFzpbPFIyPX"
    "q036zABVTBVRwdRQU0wENcNEEFW25tL6wsLypbnbE7PxweLIdK53S1jo3VDjvlrTTQOzcSMl"
    "bFRrG46epIQAsYlx5ngEBJgZ9XaNz98+8nzxGTcO3f0r4NTUJwBCM/3jBZc6AG6+ukb56zrl"
    "1QbLKzUWy+sAiEoGwOzHI8N8Emi3UgA+VN4z9fIicU9IPh+zORcDoM4DRIWfCDBTnHPs3LSb"
    "E4+P0t/TD2ZceTpJLoqI82EGEPUjqBH8mt1AnNBqtSgOH2bP9iGGBodJpMH4zCj5KMoAfoS4"
    "U2TdLdu3Gs0kYf7tPAPbBliprmK1gCcXXqBemfoidGnaJc/MaLdTKmsVLo9e5fW7N9TXEu6d"
    "fkAQBoRRt+TQRH9zIE5Y+rLEvh372Vs4wP3JEgQBURgSBdnA5hPEnSjmMaaGc46k0QJg5uSd"
    "7v12HPjtBWPnH5YKuwbHVQQVRURQVSRNUVXvRDDx/0LVe7BHc7eOTfDfz3fV7hKOGqqMkgAA"
    "AABJRU5ErkJggg==")
index.append('application_side_expand')
catalog['application_side_expand'] = application_side_expand

#----------------------------------------------------------------------
application_side_list = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZZJ"
    "REFUOI3FkzFrVEEURs+dmSAhxlZbe7vYmSLYZEstVgsbRbKwsdHKRbGWVJFAtNRCENPoH1DS"
    "+A/EFBFMk3YJy5qEN+/eazHvrcJuEyxyYZhhGM537gwD/1ly+/HHR8srSxvDExbcATPcDDXF"
    "zTE3XBVzx1VRMy7N5d97e4dPP726u52uLy9tzc1fDJfnzxS8MD6pt4DtdJwJx8PxmdVPMwGA"
    "Z+/3fVY9//Bz5n5bD19+cYDkbgD0d6FrX6mqik6nM0kajk/R2stwo1Ln6pVF1BSAhDsAb1YA"
    "bk6pppgQUSQ60QKpLuetbgAtqb8Lq0efyTnT7XYngBggSCQJqDgairFpmZPbvwa3pgyigAm4"
    "AEGIFgugbaFd3HgLa/KOqqro9XoTgKRAMsMcAgVWAI1BnTMA3x4A3J8yCAAhEAF1J0gxrnPd"
    "tND0cm0T1i+8ZjQaMRgM/gKkRBoQRfAmuZ1Tq/L9CcD6jDsogDjZaO6geb10+Otgp7+Z75gq"
    "poaqYmZoztx78aP8AVNcm39hRsn0nam0c6k/f88L3Qw8LlwAAAAASUVORK5CYII=")
index.append('application_side_list')
catalog['application_side_list'] = application_side_list

#----------------------------------------------------------------------
application_side_tree = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXFJ"
    "REFUOI3Fk7FKXEEUhr9zZq4gu0kbW59Biy0sUuwLpIlFylQhjV1AsRYrg+AbBEJsUm6zeY1Y"
    "GEga2602Kpl7zrGYe8WNayEW/jAMDHP+/5s5HHii5M3Ot49brzcOZ1cMIgB3wh1zIzzwcMIM"
    "jyDMMHdeNuXv2dnFp++ft0/y5tbGcbM61FerjwoezK/aY+AkXxb0cjZ/NPp1QQHY/XIey7T3"
    "9dfS817vD34EQI5wACaTCU3TMB6PF5Jm82usjbrC+WfB+toLzA2ATATA0mKAnDIihqQguZLb"
    "et/bzqB3AphOpwALRklBJZEFTALTSuxWdw2vjqPR6F4xQBJQBU2QsrCSUjXogtXvENyl6CVZ"
    "yVpJcqpG1aAS5LaUhYL/CRRAlQRYBCqVuC1t94TuLQ8RqAgqAiIkVZIIANET9CjD4XBpF/qC"
    "dHvQ/UHXvXzx+8/ph6Py1s1wc8wMd8dK4d3+zzoDboR1c+FOzYzTe2nPohslye8KAn8XMQAA"
    "AABJRU5ErkJggg==")
index.append('application_side_tree')
catalog['application_side_tree'] = application_side_tree

#----------------------------------------------------------------------
application_split = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAaBJ"
    "REFUOI3Fkz9rVFEQxX9z30sRorbaCn6DpEzhV7BRwdZGbAQLwV7QyhBIZ//YXUOUFH4Oq5Qq"
    "ebtbCKk2u+veN3Ms7ttFsFosHBjmFDPnzB8G/tHswYvB88P7+++uFuxJQASKwMNRiFAgd0JC"
    "7ngEt3by9cXF+NXZ0aOT+uBw/3hn90a6vbuV8N5s0R0DJ/U8k+ZXs61bX2YSQC0Xb57c25rg"
    "6dsfFAIFAKvOEaAQHhCICOEReKfiClYu7t65iYcXAiQALBkmoWTIhIWRkmGWMHOsElUk6q7k"
    "R9cTrJkSIDMwqARhECEqQbKK2sBNeCodh5eYFKJpGtq2ZTQYMLm85HQ4ZDJu+Xw6YjpuOT8b"
    "MZm2fDn/yM/plKZpiF6Ylx++SpK6iI1nd2V3rdy1dNevnLVYZc1XWbNlliQ9fv1JAHWXc2Ey"
    "wwBJmBkCkMqtUqICXCJZ2UGXu/4K/SwVlCIzNos125wtgMoMRclfxzp6AGC980fh2qoNKCh6"
    "kXr87fvw2fv8MNwJD9ydiMBzJiLKD4Qj7/8igqKp4V8q/8V+A7qMJ/eyM8CuAAAAAElFTkSu"
    "QmCC")
index.append('application_split')
catalog['application_split'] = application_split

#----------------------------------------------------------------------
application_tile_horizontal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATpJ"
    "REFUOI29kb1KQ0EQhU/WNN4r+AQ+gD6CgjZ2loLYBkvtrexESWMhWNtHLBVE8BUEi4iKCAZB"
    "g+A1cePd3fmxuDdgs9sITjXsGb45Zxb4YzVa+xebywtz7aJEPrQWQoIggummt9fd/tnS/OzK"
    "xzdyFmBQFAjMmDLe3nRftk/aq0eN46seZ1lmVCuiqkIUUAWGXyNk+SREAFGFKiBa9fe3d3Kw"
    "tTjRHAUY+zmqxV9DohBVDJyte4DrNxHAlmIAAIfnzxqrvdOnqNbavVQAMCwSPRAxRzUfAioA"
    "JwAU10JZAzyltlAc7irNJLck4DSOkNoSUg6oduCcjw650sXhrtIM+VTOeATh2oH38aFUhPHv"
    "NXsPj52NdrnGgVC89UFMEGIwC4Slt75TzrAnMDEG769QZogACu1E6f9aP+jyFS2VUeCBAAAA"
    "AElFTkSuQmCC")
index.append('application_tile_horizontal')
catalog['application_tile_horizontal'] = application_tile_horizontal

#----------------------------------------------------------------------
application_tile_vertical = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYJJ"
    "REFUOI2Nkz1PFUEUhp/Zu0iExoRaGzsaiYlSmFhZWViS0JjYmUBs7aUwJlYk+hMo+APEP0Fh"
    "YwEFJiYUGGBzL9dlz5fFriwDudd7kvnYmTPP7LzvTAJ48/Hbxotny5/OaxbdIdxxd8TaVt1x"
    "NdSDu4z5/uN4c+fDqy8AJcDz1eXtwdxCsTQHEUEAEV0BPIII8GjnHwxlG+gBF0IxasZERJcE"
    "QeBONvYPNKq9oIsSwDR49/I+s8bbz0dX/RJAzSYmRwD0RygHiUYkB1TVcCIgJYBESpC6serk"
    "9Gq+AJApf5DBula0zy8Bjg5/7n/du/f47A+YB26GmyNqmDnqholh7szHBSa2nwGePH20Mphf"
    "YOlOb9V15W+6UFXNSgYYXkZR1SPcr3set78D3INxbbmNIs7W+sOZdABYe3+Qi6g6XcT+ZkYr"
    "omgOMPOpgJRX2OWNe3D++/T2qokQGFV9fgnw6+Bw9/VWvWaqmBgq0r6+psGttc9NCXVEGyJi"
    "9787zhp/AdqOGQfsRby7AAAAAElFTkSuQmCC")
index.append('application_tile_vertical')
catalog['application_tile_vertical'] = application_tile_vertical

#----------------------------------------------------------------------
application_view_columns = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZBJ"
    "REFUOI21kz1rU2EYhi9DOpSKq3/APyCnoEgpNRLsECJN/cC4ZhElilBcXAWdlEARHAqCg22F"
    "QluoWDHCATFgNqGjOnTtVHtOct7nfhxOWsiYiPd2L9d98X7AP+bUwsPVezNz0fODhCl3QMIl"
    "TIbLkQs3Q+64GSZxZiL7s7e3/3jj5a3l4vRM1JqYPF04OznS8NRhElrAcvEoo3B0cDiyeppR"
    "ACi6OU/vnBsZ0Hj2mxzgAqDb7SKJEALnpy/yNW6f9LkrV/m4s4W7Y2bUajVMlgNwByCKoqGF"
    "Uqk01KvV6lBXGACOSZ1OB0n0+30uXJol/vLppJfnK2xurCMJSdTrdWS5OUsrP3yc1J9sOkBR"
    "A4M4jpFEr9dj9nKZz7s7SCJNUyrXFll/95YQAmZGo9FAGhg8ePV9LIPrS+99cI05qd1uE0Ig"
    "TVPK8xV2P2wTQiBJEmo3bvNm5TVmRgiBZrOJHxvcb30by2Dh0WpusP/z19rdF9lNmSETZoYk"
    "LMvyU3fHZbgN/oVEPu5rI7++/5K/WxKajuHqbD8AAAAASUVORK5CYII=")
index.append('application_view_columns')
catalog['application_view_columns'] = application_view_columns

#----------------------------------------------------------------------
application_view_detail = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdtJ"
    "REFUOI21k01LlGEUhq93HEMx2vYH+ge2KLTQgoR2ShTUtqIwKAJp0zaoVWFIlKARkvmdH6PZ"
    "OJOEixYtA5fVwmX24Tgzzvucc7d4Rmg7RTeczVlc9/XAc+Afk/Temujv7Gp/sF2hTQLckTvm"
    "hly4HJnhEjLD3DnUnO5ubm7dmXt0YSh7tLN9sLn1YOZwa0PFbaVKGASGsuWUTHm71LB6NSUD"
    "kJWJe5eONAy4fP8rESAH4OrbCs/OtFIsFnF3Qgh0ne6hmF/h2MkeNoo5JGFm9PX1YW4RgATA"
    "4+4Wqqk4fqIbXIT6vqO7Bwk6Tp3FXXhc4yECMvuk/rVdWpoTNtbXeL+eZz2/DMC71UWSBArL"
    "sxSWZyjkpiLAojkDI58kSbXg2ktd1Vqccs1VqblKlaBflaAf5aDvu0HbpSBJunh3QQAZrxtc"
    "e/OTA9mEQn6F/GqO3PwMAEvz0zQlCQvTL5mbeMHM+Gg08LrBzScfJUmpudK6xV4a2/+cUtW0"
    "Uw7aKUeDcwPT0UD1t1xZ/Ea2KWF1ZYnc4mtmp8YBmHo1BsDY82FejD5lZHgIAO0b3Bj8oL9J"
    "7+0JAWS3Pn+ZvP4wPe9muDlmhrtjaYq7xxtwQ1a/C3diuSYb/n3/Jb8B5bKGgth6hvEAAAAA"
    "SUVORK5CYII=")
index.append('application_view_detail')
catalog['application_view_detail'] = application_view_detail

#----------------------------------------------------------------------
application_view_gallery = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcBJ"
    "REFUOI3Nkz9oU1EUxn83fc8kTdRagwVxUFysU2v7BkkRNzehCBXEyc1/oB1ax451agkWHETE"
    "LV0KFd11KJpFBLHoohG6lFJEY5P0vnOOw3tJdYwuftPlnnt+5/suHPhHuck71ZsT58fubzcp"
    "mAGqmCqigqmhppgIaoaJIKocCP3P9fWN2ZXFy0vB+MRYJcwXM0P5ngYXGs24AiwFO57Mznaj"
    "Z+stTwYgMDHuXhjoGXDvUZ0EYApArVbjafYo2TDHUN9JRB2xQmxw9dBDzgzU+b47yNqH05TL"
    "ZUQlAWDWpcb9T/jY/kTen2K4b5qcHcMrvPh2ha+tlxzJbOKcA0DjFNAhARRdkxO5gOK+93i9"
    "gffD2O4o7xojvNo6h7aFmf1vEoBoGkH3HIwPZgnD4xSCg4i1+CGbtOUZxnMUwzdDXP1SAuhE"
    "6ByiKCIiSovahdpvEa1g2GH7400Qe0+pVOp+hXUb95rNkntRcA5yoSP2cRohzXJtdQuAxxdL"
    "NN5OAdA/UmV+bQ6A2bNzhDO3E/riA6zj8lbltf2NJqerBhBsfP6yfH3BT6kIKoqIoKqI96hq"
    "sgMqmKR7oUoy3Jb5L/QLE3soyubcoOMAAAAASUVORK5CYII=")
index.append('application_view_gallery')
catalog['application_view_gallery'] = application_view_gallery

#----------------------------------------------------------------------
application_view_icons = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAY1J"
    "REFUOI29k79LHFEUhb83OxZiSBVYtrGyXgtTCkmTWgKSINosxEJF8wPULl1AqyQmIgRFW0UJ"
    "Fnb6H1jILDPahCSFndhoVHhz77V4s4OCQZZADhy4xePc77zHg3+Ue/5mfaL/ad/86SVdZoAq"
    "poqoYGqoKSaCmmEiiCoPO/yfw8Pj2e+fXi7Gj/v7Fjo6H0TVzrYWd51f5gvAYnzhiS5Oz9tG"
    "v/JEALGJ8WG4p+2AV3O/CQGmACRJAkC9XqexfQLA6sAjvh18BmC0d4pms1meERUAIsza3g6g"
    "eQhgZi21u6SqpUXkls3MRt7vGEBkGgga2yclepIkJa7bnCbamgHg7Gics6PxQNCq0BpashuV"
    "/jaHgHB3vF7aL5FvYuZ5fsve+9JmZoPTm0UFKZLeTuLeTWFmLCdfWGl+BSBNU9I0BSDLMrIs"
    "C0QFQdxCcUMjAFQqFZ50PyvnarWKc444jqnVajjnQoWiUnz889fG2Ef/QkVQUWRvF1VFvEf1"
    "R/gDKpgU/0KVsNM27nnp/6Rr+l4xjFrsqlYAAAAASUVORK5CYII=")
index.append('application_view_icons')
catalog['application_view_icons'] = application_view_icons

#----------------------------------------------------------------------
application_view_list = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWJJ"
    "REFUOI21k7tKQ0EQhj/DsRDF1hfwDbRIIcEinEJMYQQthNhIQGzsfAJBK0UQa0tFtJAgmEZS"
    "5Q0s1cLWyhvszvwW5xyvKAbxh4HZXea/7LLwR/TNrB6sTEyObd49MSgB7sgdc0MuXI7McAmZ"
    "Ye4M94eHy8vbtZPt+d1kfGJsp39gqDQy0JPw4P1T3AF2k8dA6fHuvmfrz4ESQCIT6wujPRMs"
    "bdyQEcgBWL6AvUnodrtIwsxw9y8FkKYp5pYRIAHZMEC5XP6gpPz8c+8xJyiYFs9hP4VOp4OZ"
    "EWN8dfHejSTq9TpunkfwjHU/zZgrlcq3qu/XXkQomtlTOJoW7XabGOOH+uyg0Wi83kcSQwCy"
    "YUlUq9UflQvEEPMIeZap4z5aM6LVahFCIIRAjJEQwpdXaDabqHBQbJ7NApSo1Wr8Bp47Sm6v"
    "rg+Xt8Kcm+H2duNWKEvIDVn+L9zJNHX4K6V/xwsZSiKdXNFgMQAAAABJRU5ErkJggg==")
index.append('application_view_list')
catalog['application_view_list'] = application_view_list

#----------------------------------------------------------------------
application_view_tile = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXVJ"
    "REFUOI3Nk7FLW3EQxz95xMEqzSDaTSk4ZbLomKH/gAUXhXYVpbZDEEqX0kEQ2kkJCGbpHhfB"
    "v8HBQahDUTebgEulgdAYC7933+vwni++djG49OCG43t87nsHBw+MwkK18abyfPZz+4YRd0DC"
    "JUyGy5ELN0PuuBkm8XgoXJ+dXb7f317aKc5VZmtDw6PRk+GBBo90b+IasFPsBaJeuzuw9d+B"
    "CKDo5my+mh4YsPypSQJwAbBx2Bc/VqB6sJrV2y/q1E/6+uoMmAyACPdMmCzlp5QnywB42jP+"
    "qK8pTgG3JIBWJw84bZ3mAFe9OwBLnPPuyzf/OyRlaWa5jOPY3d1ffjhwgKJSB3d33prfpVBf"
    "BKAAaKXBr/O1TC+Vd5ESB1EcQibMPH2Ws8zYVK4uTcxlvXGIE4Df7gKcXHzNA342c3Xnx3HW"
    "66kD3taO/rnBfWJhvZHc4PLi+97rrbAoM2TCzJCEhYCk5AdkuKV/IZEM9z3+i/gDmpEp2naQ"
    "iVsAAAAASUVORK5CYII=")
index.append('application_view_tile')
catalog['application_view_tile'] = application_view_tile

#----------------------------------------------------------------------
application_xp = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAThJ"
    "REFUOI2lkrFKA2EQhL/oLx4RtLISnyAWomUqX0MsLGx9Antra0kpKGgldjZiY6MGrCzSphEi"
    "KIjGuDMWd14SCWh0YNllYXZnloV/orJ70rqcTqw8vjJjAxKWwBAOLCMLRyAbRxASs1O9l9d3"
    "3SZDfW1pfuKu3eX5TSO3rM61uXlaKPIi28cbHG0ezFxd39crO4ctO4xtsLCNpHxroUahfi+E"
    "FEjGCpLDrC93R7kDJovow3ZZ7509kGxRq9X+dMA4PSdRTJRG+7ddhtS3WK1W0UeQQjEW8asH"
    "oBDJ8ljEwRtIQVKhYBxif4BILrxL+jVxSEFEriAifk0sB4RJjlxBlmU/Er7DEkkSzWaTLMtK"
    "G5KGFI2y1+l0kE1Cvcb+RW9L8YxigFjk/IXzt3W4fHEJrG5jbNnf8Qk6zYLxSH+owQAAAABJ"
    "RU5ErkJggg==")
index.append('application_xp')
catalog['application_xp'] = application_xp

#----------------------------------------------------------------------
application_xp_terminal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZVJ"
    "REFUOI2lkz+Lk0EQxn+77+x7xYFWSSOCH8BKIc3ZCH6AVKYRYmFrYat9uvsGVwoGlLRCShsb"
    "NWBlce11QVCQ8/7MMxZJXt8zb+DAgWF3dmdnnpl5Fv5T0uTd8Yc94973U/YjAImQIMDDCQUK"
    "Ee4ognDHJW6Ui1+n5/piAQcP7/by15Mzfv5WZ5b7N0/4/OPWer3N87dPmD59vf/x07eD9OrN"
    "cYQHEQEhIgJJq6xrNHL9PXMhOVIQciw8eH/4mJRSp+acyTlv2Tln7jx6iUWIqqpYLpdXnLoe"
    "tO1er4fLyUQ0tc5mMyaTybUnoEsnu5xSCqUURqMRg8GA4XBIKYW6rpu7tpoZpRTkwkKBmWFm"
    "TKdTFosF8/mcUsoW7HZZVVUhOaY1grquGY/HpJQopTSOwFYPAMwMSVhIDax2A9sZu+wGgbs3"
    "Nf3r3EaQUrqyzznjHlj4aoyllBW3d2Tc6CZIVVVcSpgkzIx+v9/pvCtISglFYOjiqP/gxTO5"
    "IxfujrT+PNpQOJCc8GgoLkH42dG1SbNL/gBTPeR+G4V+UwAAAABJRU5ErkJggg==")
index.append('application_xp_terminal')
catalog['application_xp_terminal'] = application_xp_terminal

#----------------------------------------------------------------------
arrow_branch = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdxJ"
    "REFUOI2Nks9LVHEUxc/TGKecUZLQN75pNkUtJHAVQZQ7/4NpEW6KqJX9hAgKgtBdbqxN23Zl"
    "bYKyRYlgkC3M0gmnst6bin4o2OYNNe97z/22GGRsxqee3fcL58M9516gTmcnT74YnDjxqv4/"
    "Tk115lk3lTnsptyDZ8YH3m4F4ADA9UI+8Xs5Pe+m3X17d+2BWovi9yJKS98WQ8OesWNj0YYT"
    "rCynHyltjrSgKqiEKCGUbILyeNMJVnX6yYA9uv8IFMSz1xO4m3/gxBlXtW3tg0KoJWgVItzM"
    "W4uwFmCUoApoGgH9N/uu5O/nmzcEVCcgRKQBYCjHlz58uRMbQQwhVqBq0bajHf0jfb/QBGNp"
    "PQrR3emB5IFDV6Nwenj2fCNACCrh/wxQDsvIutnOjvYOtG5vRbIlWe2GgqgSneu9ZMI3I4Vr"
    "/5doBKIK3y8hs7sL2VQODpqhtrpWhYJWQRJqJBEbIdfjoSuZwd+VCj76iwhKASiE1+2BVPif"
    "/dtzo8XL6wAEVKLFSaL8p4zJqamvJB++vDFzAQB6L1bmROxMYXRhcN0tiCE0dNAW7cSndwFo"
    "auZqRN4r/Fg4Fb8FEYgS1hJ+EGB6qGYGgPlb74dRp4YOnj4fB4XgFi/xH7gdIjmWX1B+AAAA"
    "AElFTkSuQmCC")
index.append('arrow_branch')
catalog['arrow_branch'] = arrow_branch

#----------------------------------------------------------------------
arrow_divide = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI2tkE1IVHEUxY8zz1EbHb/FN6P5lUnkSkFalAXBEASF0YvIBBeVu0hJENoWkhQtbBGk"
    "EFghQ7tIrNxIyhApWU2RNYqGSswbxlByPv733tdCRjScVZ3tOb9zORf4n+qavNx3bfzSzVT+"
    "xeGWvvOPT+/w7VvwxJX+0kxPZ7aW3bz/XGX+u6EPo9uDF4Zb+j2usk5nhrO55FhR/uzz4CgA"
    "pBk+w16m5w/oWXp7jasWzIxvka9YjCwM/opSBwA4iAb0PE97nV4HsgiBuQCCS8FBl6ekQyt3"
    "5/UQc2M6HBARWLBAxCAlTZlANyllV0SNTAS2GCICTUuHUtQU+r7UnQYAV1+37dXsexab9EMQ"
    "EbyafYlHZ3xp2yeceuC1vI1ekMUY849hNbpRMdkz+cMGADFg8yozyCIIWTB8hiMJGz7DIUpA"
    "QiAhKEVANAYAsAEAogArAlsEYkZpTinwe6M3WbC+Eu7Vi9xQsulTghDb5KEBwGostpxlQ8Rc"
    "NwtcWbmoKK7CRizadfL+8Xohhl7k9laXV4GEEAqbWFtbj1TP1y5PYxpbO1uftpwloidVxTUO"
    "d6EbAgvmqglmQl5uAUgU5hbmEQh8Tiji1pm7n54BwI5HGQ+9++KMG6So7UDlQXtJYTFEGEs/"
    "VzA1M8VMPMRxuvX+3pdgktlRkNSJO0cPO505bxrqG8CWwP/Wj1DYPDJ9++PE31nbbgWj18cn"
    "QmEznmCFBCmETDO+G5yyAABYcYZYAoGAFGekymmpDFKEFyMjYMVg4lSxf9cfCwIziKgUtqMA"
    "AAAASUVORK5CYII=")
index.append('arrow_divide')
catalog['arrow_divide'] = arrow_divide

#----------------------------------------------------------------------
arrow_down = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAQxJ"
    "REFUOI2lkzFLQ0EQhEcNSCCVIpGXRkggCIpiFUkXLAyCv0JQCzv9ISLYCP4OwcJGECvBToIW"
    "YiEYUibvdm73LF6nnvLOaXfvY2ZvF/inpmKF47uDEEKAeoN6xVnv8sfe6RjAzNCZ62JzoQsK"
    "ow4qsYJS4c3DzEDx5QGkLwDBILkkAFwBUDNInhBBHEFVWFC4FAfiBFTCgqZFkFyKCKkO3ISg"
    "EpriYPt8q1OtVEHzMFO4X4b4bZH6p70rHec39fk6qB40j2wxw8pRe9Leb17/CaiN3nfd2L9+"
    "DIfwVnwlSYjj28xodudrf/QWNk5WHxpZY11VMXh6fhxcvKxFc8S0fNi6be0t3Zd+WEafYK+k"
    "p4E/rQYAAAAASUVORK5CYII=")
index.append('arrow_down')
catalog['arrow_down'] = arrow_down

#----------------------------------------------------------------------
arrow_in = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAe9J"
    "REFUOI3lks9L03Ecxl+frxPX/AXa/I7Z2ctsIZ0kCDOoKIK2QzWRDhPyEJ2y/yIiPRoGQUVG"
    "zIYhQgehy5AudRChg1j6nTMJdVNz2/fzfnezYgP/gJ7z84uHxwA8yI3Oqmi/79jYRP/UJscg"
    "nU1lrJXQ8+T0FTOWG513m6KXG00j30orRVvRHgIUJgamzN+iu3PDOnn1hUlnUxk3FEmICN6O"
    "9z4gogeqihuM4FvbtkG+UPbLNalihXQ2pV0hl+6WU+RLeaxIv/P43GTS2/dmVvdWaTHN9LbH"
    "UZEaAytKX9dZWgOteEWPlZ8rRdVqzAEYP/80md/3aAqcwKhBrNZtoArBQAhv1wP1e14PzW4G"
    "AO4vpFVF+PRjERFBpb7B4loOEUWsIGIKgKkh/ocwACOzQ/pnHEFEeXnz7T8DJZ5dUz3iKCLC"
    "3L0PxgFAJNKgDcQ6TxMP9yG29gdilXj0DLFo75EYwBnJ3nZ9X752BsPs/tqh6lfqG4hQthW2"
    "D7Y52RLm0viFDIDjV2Up0tzd1tHUQam8x5eNz0idJ4oVlteXqVR93HaXcGtX4uKjgYxjRXKH"
    "1UPWi+sUShsz08PvjK3bQNkrH0bWtr4Xt3a3UFFUJWQAbr26Ma++Hry5k00et/rgk0EX3y6p"
    "am7h4cfrvwHgVCW0ZtAt3gAAAABJRU5ErkJggg==")
index.append('arrow_in')
catalog['arrow_in'] = arrow_in

#----------------------------------------------------------------------
arrow_inout = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcBJ"
    "REFUOI3lkz1rFGEUhZ93smazcUMgm3XGxI8fkLgSrG0UFLES0SKooAERRCv/h1qKYCOCELEw"
    "ksZCO1utUiZg1gyKxOjqzmbmnmsxRBJ2/QVeeLnNPfceHs4b7r2/5QDuXj45908+Dgyom8tX"
    "XHIkISt7BBBXD3K4dhSXYz0ld98t+CCx5UWCIK4lxKMxMhHtXI6rCdO1I+wbHk6lPj0y4YR0"
    "stZkun6IoVApHbictLvBWmeNetjP7HgLl/oWmJy5AycYq4zR/tFm9dsqZiKSO0VWJJ9/talW"
    "agQPyP7hwGGkMkp7q417nshEALjz9oa7nB1ALufRuad7QF5dvOSSyhkTkli89mog7P+tAsDC"
    "0rzvhiM5zy6/2APowpPzJWjTX9jLt9+EaGFp3pGSIR9ipnGMVnMOWX8OZE5r6jgzU7NIIsst"
    "OfvwtEcyUZinjZEmW93v5MX24AUSPdtm8/cmk/Um1ShKJRHJRDI6xUR1gp+9Dh83PqABSZSJ"
    "lfUVtvOCeDxmot7A5VRMIssz1nvrfO18IUSWWO5pvwOnW2RJ1vuUygyXI3fC/POLZcJ2wXl5"
    "/fXAhJ15cMp3hK7yE/4BrUQ+kumCS1oAAAAASUVORK5CYII=")
index.append('arrow_inout')
catalog['arrow_inout'] = arrow_inout

#----------------------------------------------------------------------
arrow_join = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhdJ"
    "REFUOI21UktrU2EQPWmb3NQ8jCmW9jaKrSlFobgTxNIiProTRSNIWl2J1D8gBUHquq2/wUVd"
    "JF35ABVdFNtaF6JichsE7w02pSGRRF2Ym/vNfJ+L0FpjUnHh2c3MmWHmzAH+Jyaejr++9ii+"
    "uBOnpVnh+pOx91279KPdfv34lfnY22Y8V33idiLmyQe8ad3XHe3vGIBUEqn1FMyC+VFp3sHk"
    "paSz4wZ5v/aYBUWIGKQIJAk+jw9U5f3V0rcHf91gE+OJC+rEwElIJbG8uoxiuXDs4Y3nK/W8"
    "tmYDyOGqw0KTivHla7HaqLnhCQBwee7ckF/za1JJsGT4taB2anpkqBG3dXswlohFD5+NzghH"
    "3D3Q2dfS7m0HS4JSCusbuauRYb1XH+lM5xbypT80iN8/f5GI5nr3HvToHTokFIrlIpgJod1h"
    "kBT4lDWRSqUdQRx/N/NhfmtALBFrddl2YXDfkXDQHwSRgGGtIruWfUaC0NMVOdMfjULBhWKx"
    "gKWXS6WBjUxnMgmuaVCp9LTBHQ74AiAmZKwMrDVr9sXNxdGFWyujpmnOpg0DLAmhcAhuTQun"
    "9/T1/BLRBkgQBNf+buWyyP8oT26e991tT5qmBVYMkgwWDHv7FyqwIZxaMzHBqTowpowtxxlT"
    "huNUBUgypGQwMVCpE/H09LAiQSDBICK8uvPmN5MdmuhXTAxmCckS1r3PTU34T/gJlQcYvvxf"
    "XWoAAAAASUVORK5CYII=")
index.append('arrow_join')
catalog['arrow_join'] = arrow_join

#----------------------------------------------------------------------
arrow_left = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPpJ"
    "REFUOI3tkDFKQ1EQRe+L0UTSiRKFEIK9wS24BrHS2m//F+AWXINdkFQWEaxsjFYSUMHOj5Uo"
    "pBDJezN3nhb5kh+wSPqc5s4M3GHuAAumOH08WEn7yfU8nnKx+f5aezLGxjwL3F+R3iaDzcpW"
    "mySyYQYJCvEK8YLgZayjSS1eMTh7dmUASPsn9/XlertV2wYj0ag1wUioGdQUGhVqzGcEo+Ki"
    "051EiDSlI8QEjASN0MjcnGu+gEbwh1DhdISkd/SwXtnYrS6tInvP8DH8/PdsCQoVgkq8nr85"
    "V3zIYWf/Rbw0fdC9y+Oru1meWCo24ko7YRRuZjUvGPMLQu6swybSdFgAAAAASUVORK5CYII=")
index.append('arrow_left')
catalog['arrow_left'] = arrow_left

#----------------------------------------------------------------------
arrow_merge = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYhJ"
    "REFUOI2Vkr1LglEUxh/DLEwliHgtIqHChiD6oqAil2psCHKJtoymqH+giKYW9/Y2CSJoCJcM"
    "CZqicnAI+pgiLKPUfN97zr0NJpTd1+qBO9xzz/nd59x7AButJSPJlePFM7vzsmp0wdWTyLnh"
    "8o/5643h5aOFi2oAx9fNRmrO9fLku/LXtwQ7fF2QSiKdSeP++f46Z3FPLByzqjrIZrwHTLKd"
    "mcHycxGBhGirJXH4q4Oylg7n1XggBCUl4uk4dsN72jwAcOqCJEq3S8kgi+xqf7ZQlrAIzAxS"
    "BMNrYGZnau2fAAFShJyZQ5OvGWTS7FQ0pIXYOiAmZAoZeN0e9HcPjrc2tUQntkbU6PqQ+rOD"
    "/Hset9kbOOucCHYGMRmahqh4Ez3AJAhmpFPXeH3Io1gwIUiAFYHEd4D2F4QlwJIx0NuH5Okp"
    "LlMXj4CjkZhdTPJvAJIEd4MbplWEp+EtkNi8K+py9QCTQIogpYQQhMS2vriKg9IcsJK/DpLN"
    "JBL29w/AxJAVPVfqA1um3jCc2iwUAAAAAElFTkSuQmCC")
index.append('arrow_merge')
catalog['arrow_merge'] = arrow_merge

#----------------------------------------------------------------------
arrow_out = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfJJ"
    "REFUOI3lU81rE3EQfb9NJB/Y+EGzmyq5aS/xJK2SgxcPVoUqjVhtFCIEpRT15P+hV6leRGwF"
    "2SIRrVj0GL1UUXrxFCIxm0JMs8aYdPf3xkNQaBr9B3wwzGXmzcybGXWrOCsAICI9o+D2sXmF"
    "Abj2/LKQApKg7nkDAMb3pDG2++g/kwFAe34igCAOm2MY33cE1IQhIvDpo+W1YIZGcONN3h6U"
    "nH960RLBZytiwe004fl+rwOh4ENjFU2viWQkCSucmJp7dWUbCYG1/UPJWDxqot5u4F35LbQm"
    "DIqg+7OTKH0vuZV2BdSEaIluI/BZ7HhdlL6V8LVZWVqYsRU18Wfemyt5y6Neo7B4d+LB5KAx"
    "Lj0+t0xKe2HGzvxNp/8RW44mZ0/bWjP68PyTk4OCz947XaBmGsZmqnD1dQ0AVL6QlfuTj1TO"
    "nraHw+YUSVRd59li1t6yiTPzp5bNneZEQAXwpV52Ox5HdyjlBKmJnH1BhsNxWNEE1n+sQ6jT"
    "/dVFs61JxGMmfF/HahuO0/U2YVATqb2HEFIh1FoOyo2yqwym+gkKsy8zTqO6VKlXoAzBgZGD"
    "EAoMTUIEiASjcFwHhqFHF7OF2iANXlxfyTgbDoZCuxBQBiiCILXgfXUV1ETvVcXpF/c3Ttw5"
    "LkLBx9InCHvv/wtoihs4h5ZXbQAAAABJRU5ErkJggg==")
index.append('arrow_out')
catalog['arrow_out'] = arrow_out

#----------------------------------------------------------------------
arrow_redo = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhhJ"
    "REFUOI29Uk9I02EYfn6/TUNXpM5lzY3MgeR5pwjBINgpBg071GVEF6nALukhgwihUxLUoaPH"
    "FA+VhyAMkjoYSDApK7eWmf07aITb3O97n/frYK6tvNShBz4+ngeeh/f53g/4nzg1fnyob7zP"
    "V625fxMgG3JS14u3qzWnmvQ/Tkfdsk2RmqAwTjIkQtAQIkS4qR0qRG4ld2Pq3PRATcDZh6cP"
    "qeVgJBBJNje0IFAXgN/1g5agKlQJsYShYD6bQXYpOzI9+PSSHwD6H6SjqhzsDnYn2wJ7UZIi"
    "XMcHUYI/j1pWuDECI1IPAH4AsGAqsjOaDDXugajAE0H2ywLyn/OoVDCCcGs7SCL3LndzZnj2"
    "YiWAZGL3jiYUTQGk4tGL6WVSJyfSUxeq3+jItcMZGjM3M/zsfM0WaDTeUNcIBy5WVldgjPxh"
    "BgDjyZ22zP4z1ZofAIwYCAWO48BQQMNt1/jk8uwIMFujbU5Q5tza+hpKpoiWXUF4nkklrveO"
    "bpvyGxwAODF2bCDc3D4a2xcDraJQKmBxaRH55TzE/PoHFG5yEi9vvXEqFcosT779kOut99Un"
    "Qy1t8OChq7MLnR0xqCVUFaKEQkFV3Ju4X5nABwCv7+a+dxw9sPTp68fWDa980LEOHNeBAptm"
    "q1BL0FpYJRbmX2H1+bcrlQpb6LnaE4WWUyJM0EhcRIMUuhSCVGzdSkV+7H2N95/xAxFnTbiV"
    "dtfYAAAAAElFTkSuQmCC")
index.append('arrow_redo')
catalog['arrow_redo'] = arrow_redo

#----------------------------------------------------------------------
arrow_refresh = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm1J"
    "REFUOI2Nk01IVHEUxc+bGQw/0CHLxpkUMYiICMRVBIGLkKJyoRa0EC0oSs0oSIOKIAQLgiQh"
    "giwzCLJcuFMrKQyDyI2Ymh/pOJmQQaHz5t2P954tzHDMwAsXLv977o/DgT+wjjr25EhdaVup"
    "d62dZz0AK0bHo7M/7q+1M5aHC2/Ls5gXi5m1UMTOt1k2MymEBKGNIYgoRsZGGvtu9J9fCfAB"
    "QOXLE3tiZNeGkkJFaX4/khKS4TEMqKtQ24a6ClLG/MJCza6qhehg0+iVv4AzneVZqly7I31n"
    "UUZyBqIShbvogm39A1CIqxBHQcQg1oQ4B6paHEwJFqUnpoOUYbKFkakRjE2OQUjBJNgaDEHV"
    "xujwaNP4w/ClOAATFSb7kxEVEybF0P2+e5otftF77cPFZdHCKXPAEe2faJmuXh2izzI5r2+o"
    "j5nU5ZhYytz67vrHqytFyvJsMhZpKGsrqSASKCuUCEQKH5l0WUjBLBBSEBFK20q9wUBqXeO+"
    "5noAmHwcqQcA6xDnsiVnhSWRY+xRkl/GaksAcO7NyUeqmn9vf+vu5bfi5oO3hbSkIK8g2/B6"
    "MPt9Fq97ezp9q4+reyrubtkQKLc9NsqelywyLTkLpGUiZ3sODK8BcQRTX8Mgi7viAJWvym9l"
    "JASqcv3b4DgOsv05UEeX2lXM0zy86sOXqUkMDn7qYNNtjwOwJcKGgITguC7EXToWRxGzTMz9"
    "nMPMzDcMD33uUNGbEy3hyD8ZHG09fCeQmlkjohgPj0NIwKRQ4jlhu19Euxwx2idaJiJr5QcA"
    "ONBY8KCgYe/AfwUras3fmJK56TSZ9HQ9gN81YnzgUNbvigAAAABJRU5ErkJggg==")
index.append('arrow_refresh')
catalog['arrow_refresh'] = arrow_refresh

#----------------------------------------------------------------------
arrow_refresh_small = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAbVJ"
    "REFUOI21Uz1Im1EUPf4UFSEWSuKg0WBD0RgrUYQsavxrQKEUJEPpUqeAqEu6dZHOLoIgSJe6"
    "CNFFdNGoJIqaJZQqiYlRYwqliB26qe/e+32dUr7Sfo1QeqZ337nvcDiHB/xvTO6MhQPhQJkZ"
    "X1pMgBQ3W6oebJvxJcYhdBj06aJPC0svs4BJUFddD2ZG9uvp5tKrVb+pQOgw6BPWZtw17Z22"
    "ylqILtB0gWgC0QWJXAKZz5nztfGI0yhQXjiw0l42W1o6rRU2fLr6iItv5yBFqLfYwcxI50+3"
    "1iciQ6YOJrZeXzJLI5NAKdpbHF3uAYAXC/4jpfh71/W2b8PirYiH4jfFcoMx9eHZ/pW/tWCK"
    "5/NDK/fZKzcOgXCgypV03SWs+9HbW3pYuPe+9eyS4m5SDFacT81nHQXulxoBYGSuP9JodQwS"
    "EVJnaZBiNNkd6PJ4kMpkENs7WDh7nwv+0cHwbN+V/VGDrc3ZCtEE7ieun3VmcxeIxfYTJLRk"
    "fPObg5533g1HXcMzZkEyfQJWDCYBMcdEeDr/4Uu0aDAdb9qiT6dajoouwuQvPM4fDyji9H0E"
    "/hk/ALOAzz2zT/9eAAAAAElFTkSuQmCC")
index.append('arrow_refresh_small')
catalog['arrow_refresh_small'] = arrow_refresh_small

#----------------------------------------------------------------------
arrow_right = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPZJ"
    "REFUOI3tUbFKA1EQnEgIeqWpzh/QJloqEtu0VvkHLQV7aytLrfIjIsFKhRSJIXgcCUQLC4OV"
    "F3xvZ/e0MHdJYZGrdWDZZZaZXXaBfxTC4VXjunnWrCxyK0UMxLH+vvY6WORKAHB6d/QFAKYG"
    "pYKiEE+II8QJvBOIE4TrIUSIKI4fO+e9HQAoZ0771QNYatBU86AZaARTgpZxiiSZbifH04fo"
    "crhbzibTOBebgqnOxLNs856QUK/MN1Aq2s83v67tP3/qYDVAGG5g8jZB/DTqjlrjen6DZVA7"
    "2dpTZ216vgxb483CX+hfRPf0elv5CGrLav4KvgFJZLLiNphTcwAAAABJRU5ErkJggg==")
index.append('arrow_right')
catalog['arrow_right'] = arrow_right

#----------------------------------------------------------------------
arrow_rotate_anticlockwise = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAf5J"
    "REFUOI3Fkj1oU1EYht97Y9QmUoMa09xISoM2ggEFs1QRrIqDIgWdBBclQyEGcRZdirQgLpa6"
    "ObhIwcW4iLYWBLcU/Au0AfMzSEGIQyP56T3vd46LCQ1Ng5vvdDjwPLzfdw7wv2P1usx8SKW1"
    "qzJam7hQIJQCKbPPr72c6ytIf7zleFyTDfsiScfvYMDrg2iNWquGcrWC8s/ysrVhJuZTr9fa"
    "jL1ZYLsmG90zkjwcOALL8oBCiBbYto3R0ChiwViyJRvZzYynU3vpZnpowEmN7I1BjAZJlH6V"
    "UK1V4d/ph2VZGPQPot5qOPvHAtXi20quq4FQMkO+MJqqgaZqYbGwoFfWClOrP1am3n1e0LXW"
    "b1CISPAQ6DLT5na0D6SO7/LshjaCUrUIuvrh/I1XDwDgytOL9fe5xRkqAUmQEt8iEEWIIURr"
    "CAmSnTmpOPPmzlLPF+uMoJQU1hvrqLt1hAJhKFfduzx3/sVfAcanT5m+ArqcrVQr8FgeWBZw"
    "9sS47exzrl94dMaEDzgIH3Qwdv/kFklXravPLuWGg8PJaCiKumrAa3uhtUCMgTaCL/mvKBXL"
    "+PQ43+G6/gEb7kShUljOf8+j2WyBQigtoFagEKSASrZv0M656dNpRU5q6gRJOOEIRATlYhnf"
    "nqz2ZPrm+N1jJpE52nOJ/5TE7fi28B8NSQuVAOr6rgAAAABJRU5ErkJggg==")
index.append('arrow_rotate_anticlockwise')
catalog['arrow_rotate_anticlockwise'] = arrow_rotate_anticlockwise

#----------------------------------------------------------------------
arrow_rotate_clockwise = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgFJ"
    "REFUOI3Fkr9rU3EUxc9L2pAm0gZq7ctrERPaZHWIig7aqWgrdoji4KRkC/kDFOqSqUOlUEQR"
    "/AUiBae4aUUQ1MUMFWzSKL4kIAEhLiEJL+977/26GElIKt080+VyzofD5QL/W8awZeZdKi2u"
    "yojoOBODiUtEvPk0+eLuPwHp9zcsr6tz4cBMwgpaGBsNgEXQcBoo1yso/yznjY5e2Uq9rHUz"
    "nl6Ax9W5o4ciibnQPAzDC2ICC8Pj8SA2HUN0KppwuJPrzXj/1n57PW2OWanIRBSsBUQE+5eN"
    "eqOOoC8IwzAwHhxHy2lbk6dD9e+vKp/6GjBxxgyEwcJodlp4U9qWYq2U3ftRzL7e2ZaW20bT"
    "bWFmahbkUqabG+kORBL/WP0AJgYphhDf2rqWWwOAS/cWUa7Zq8esCPx+PxRRfADwYOlZ30Gv"
    "PLmoAawBgOsSFBGUKIhokEsYAPTq8uNlrf6YLmwsPFeKrlpHwmi6TXTaLsil0r6A5KNlbU6Y"
    "IGKc31jQ5qSFWDQO0YwRGUWhXAQRb3b9fbWTD5f0dCiM+dk5kAhEM0QYLdWGz+tD6dtX7BYK"
    "+Z313RNDGyhFICIQE0gLRBisBU7bQaGyB9u284ZDK72ZgVdeXD+nzcMmiAXVagVEBKXoCxPf"
    "/3ynMPDKQ3U2e0qfuZ3QBzLvp5M3jx8I8Bv5aBASyYcdHAAAAABJRU5ErkJggg==")
index.append('arrow_rotate_clockwise')
catalog['arrow_rotate_clockwise'] = arrow_rotate_clockwise

#----------------------------------------------------------------------
arrow_switch = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjhJ"
    "REFUOI29kUtIlGEYhR+nmTHIFt7y8odamX9m3iAvRVQggZshIaYgXLRq3yqSaNGu1tEqKNpV"
    "a0MoUkEcqhFHM4icMTRLzZGRCXX+/3u/72tRgVKUbXrgXbyHczbnwP/kwsPIQPRxNLxZC2w3"
    "fP5+pNPz5FQuvfpms553uf+i/fkYbTDaoEXHROgL7KBHKd2tlbi7wgU4RQ7p1TTTs6nEi6sj"
    "rQBBgN6mS1gs1lqMtUx/eX/s7fzUoBjBrT7EznA+og3aakoKS9jYyLUcv3F0ZPRm/ETAWovB"
    "Yqz5cZp9Jftpq2kjs5ohFAyhRFBGobRCaUEpQfl+CCBoxPDg1T20aAJmBwdL62hwjlC4u5ig"
    "DZGan2FxZYHPiwtUljloEZIzqcn4rckOgLzNhUTvRAt06Ou1+sqGvna3g0RynOHxYW2sPTt0"
    "PdbffqVF65D5MHZ7svb3K+wBA0xMJ1j31nGr6vHXFF7GB8Bf9/HS3pZIXu+jc1aUIEqwYikv"
    "qiCbyVJX6XKgqpaZjynGpyZIJpM0uIcRMYy9jk+mnsw1AwSVrzhZfxptNdoIYjTp/BUm3k1Q"
    "vbeGynKHinIH02XQRmMweDmvKbemXn56utARUP7WhkUL2fUsi8tLDI0Os5JZQawgRhCrEaMR"
    "0YhoBZAXuXvGihKUL4j/fSJRKiY52+etej1aqW7xjVtaWkpjcyPzs/PEY2OJpefp1l9W+BNO"
    "xOk0ogaN2LmlZ8vudnNbKOsqHiBK+O/Of+AbuTJWoUb0ThIAAAAASUVORK5CYII=")
index.append('arrow_switch')
catalog['arrow_switch'] = arrow_switch

#----------------------------------------------------------------------
arrow_turn_left = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAalJ"
    "REFUOI2tkUFI03EUx7//beo0TCuhv1tKqYOwu4dAwcvwEh1Coq6ZdHOdCjoFgQgdvHYM8qAw"
    "0QmKFEF5KKTBwA5NlNpk1qjGQMz//L3v+3moSdqIMXyn97689+H75QEnXcMzw/7YyujDavd9"
    "x4Ww2/pMhberBTh/D2Nv70yGguExVUWmmAGpoOF3MUySsixW49O35rcqAmJvRp64jaFHXc3d"
    "cByAVqGq8MRD8VcR34p5bGxvzquRibl7y+/+iUCyniQUClGCJMQKfI4PwfoGRNwIrnT0XjfG"
    "PIg+7e8o3/nLzerz1MueG51tnvH68jt5JDMfsP51HXveHpobTwOOg1PBJnil0uUfhZ/Zz6+2"
    "3h8BAEByam3p0rULFws7Bf+Lm7Pux/inx+cH21o3cxvh9nPtLR49AA4yuSyyr3NTFb+wSzti"
    "jEyX57m7S/elJPH0lzQCvjqcaTkL7nOo4hf+V4PjV210IAqqIrGYwOp4ygGAQLUAsy8wFKhV"
    "iOGhXjVAjECUsJYQI7UACOofB1KjA1qCqmBtEfg7gipYiwMKkZhZAKlQ6qF+AJ447IzZe1WN"
    "AAAAAElFTkSuQmCC")
index.append('arrow_turn_left')
catalog['arrow_turn_left'] = arrow_turn_left

#----------------------------------------------------------------------
arrow_turn_right = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYFJ"
    "REFUOI29kT9LWwEUxY/PNKIpRoUopmavc6eOnRSXDOLQTtG6lLZQ/6AOXf0AQpd+hLa6lCoY"
    "FMzbu1RBBJ+NVCn5ALbk3XPu6yAGec0gKfSOh3t+/LgX+F/z/PPTtZmPM93pPLgrwGI+yzrf"
    "p/OudLBYq5SalkzLfELyR5IKMmG0/wGcQtSINrZmd960Bbw8mHuMWKvF+2PlgZ5B5O7lkAky"
    "8MRBF+jEUf0Q0eXZ+var/bcAkLkpv6hVSt7U6sPB8fJwbhi/7ReCIACdkAueJJALRsJiZW96"
    "LUDQTKZH+4rlQl8BdMEkHP88wXmjDppQHCqCFL5fRO+qi+HKX4CYnOjPDuDKrkAJ4XHtB8mt"
    "T5UvCwAwtfHkG6mv1aXwddsvuGky35tHd1cGUeMUt8sAEJs+5Esj8+mjtwxoAkUocdQbdWzO"
    "bi/cXtxbDtfT5RSAYEJIDsZst9t2WgAzwigIglkHAMa6NnB1ZkAjTIQnHRpYTNAJ/xeDarh7"
    "/Q3eHfAHD2/t30Aj8WEAAAAASUVORK5CYII=")
index.append('arrow_turn_right')
catalog['arrow_turn_right'] = arrow_turn_right

#----------------------------------------------------------------------
arrow_undo = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgxJ"
    "REFUOI3Fkk9I03EYxp/9HJEYFWzkNtOGw1tdCoKiYhZFUelB1GtEFEHSn0uHTgURRqBRIISH"
    "IggKdlgENSIoKDvULp1if7AciRLyS0PY9r7P++0gLpdidOo5vZfnA+/zPMD/VmDxuPT2tDMz"
    "GA2kgUqQBlU1is2oMmvCjBOkHp9Ml5YBLrw55ZKx/XAOMEeYc6AjaERZyvDnfUz508h/y6VZ"
    "5eCzgVfvAcBbBJC2YDIFnUFNQSPoCM9rQOPaRnS0dGDrlm3dVdXLh27tbQWAYA2gRKbwHCSh"
    "QlAJVYJCxDa2IN4cB4IBNIciaNvU1p0fz78GMFx7YTV1jRwc0qr27NuebGVA8cOfxbsPYy/G"
    "rn084v3dDjw9+/KiCFOlqRIC8LCuqQmq3FGXAQD0Pult6H/YdWUliIhCSagpxAitCpYBApXK"
    "qFTZ/6c5eX33kFS0JxwKY17mMePPQIRZYEmIfQ+O3Ymuj55QJY7ePeBUCBVdCDESQ7w1juCa"
    "IDzzMDmZgykzNUDf/eM3Ixui5xLRBAwO7S3ttQppBjriZ2UOHj18nSghn8unK2apGkBUq6oK"
    "MYE5gI4wI9QIc0S5XMasP4fcdAGFz4W00QaL94olYMkSD9/uHI6FoueVhi8T41D5vQNR/W5i"
    "WVXNSMCliiPFElZS541do3uu7vy0eqn1qmshnNh8hspH/wL4BVfpShtMzyvVAAAAAElFTkSu"
    "QmCC")
index.append('arrow_undo')
catalog['arrow_undo'] = arrow_undo

#----------------------------------------------------------------------
arrow_up = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAQlJ"
    "REFUOI21kL1KA1EQhU/8C4ogFlksJIjY2gqa59BG22xKER/AB4oQFUVbIYJbiaAoYpN6QwJG"
    "yL3zd61sgruBXTzlzJmPjwH+M6cPcXJ83+zmdWayFifd+Lk2v7YTVaNG6/boKatXmRycvewv"
    "jIarr7VqtLWxvAkzw3v/Db209zEOle32QZtyDb6GKzfCsi6iEBNIECzOLsF7rtvo+2qqwW+a"
    "14dhr96AmiH5TNAfpLud+O5xsjeXBSDPYFVYUKSDFBd/HE8BEFgZFhTkKKuWA3AEMYEGhS8C"
    "8GMGK0PLGLAJzBTecQEDR2CV8j+woGBfwIAcQZRhMDBJAYBndM4vISxQ0UxA6fwAMoqrUD2w"
    "uKAAAAAASUVORK5CYII=")
index.append('arrow_up')
catalog['arrow_up'] = arrow_up

#----------------------------------------------------------------------
asterisk_orange = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqxJ"
    "REFUOI2lkj9sW2UUxX+f33t2nh03eYlS0iaN0CttoHSBN1QMHRCPBQm2ZEKwOVIZkLo0CFVd"
    "WmEYWCpVatlbiUzM9YJQEUPcin9FDLWUFJHGIX1xbcfPz993P4bIxbRsnOle3XOu7j068D+h"
    "Rhv7FZFYqtYSY1h2z7EG0L1KBVHXjVATa1cmz9MYanIj4or4h9fV/FtxLnwPg6o83SyqMrb4"
    "DoUjr8dicuu7XzhLw5E7LLTQyKkxKM6i3DGsdyjufdkKNYSqdCTKuT7O+DQiYMU8f4G3Qs20"
    "NldN8ydAcKZfQSt1QaxaciaOgRXS7QZWWJ35hPp/egCwf1Xddmdfi92Zl+ncvZUUFs4E+ck5"
    "en/+TvfhrzdmPrUro3w3u0YEkD93sDVz7LJ5eO+BO/VSMP7qu4FSoLsJ7c379dSxq0PhxkUv"
    "YgCqf03dxj8cm04Ta0iMpW6FoLQYR47nggg6Tdn95bu6CIloFYoldIuH2N9r11wr4M29Qb48"
    "h3QeBZL1YsTi+D4MuiAa1/eZOv1mJIMUp+Dj5gv0Hu/Q2rmLawzo+99gBcSquhGbWAPlk2dj"
    "zx8DLINuh+0fv6+LJjFWhaJVOBjAIFO4pY/t2yNRYu8zgkxyD9zSFKb/BMdzsZIhGhBZDqsk"
    "oybmeAaZqK+L86cD3e/xaP3bRmfnL/KlccrHTkR97VSf5TujTfOKqhZmFz8oL5yivfEb6ZPH"
    "q93m9pZTKEYTR18gS230/vFOen1d7jx3QfOys5SffvFCeeEUptel/UcjYSBrYlnb29oGK0wv"
    "HCVfnKj+8KEXPc3BsDAG9rc2E8cPAt1P0WI/P/jX1H7+aLc+Od+LWlu7tHbaidEqhIPc/CuJ"
    "G5cI0U5VxAaZ9VYWq/0GwL1KfqmvbcVkqiaS3Th78x8j/wauAUd4RhFPcwAAAABJRU5ErkJg"
    "gg==")
index.append('asterisk_orange')
catalog['asterisk_orange'] = asterisk_orange

#----------------------------------------------------------------------
asterisk_yellow = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo1J"
    "REFUOI2tk89LlGEQxz/v7ru75ma6qIc02HwjpKAw3nOBskYEHToYQdRxAy8ds6BDFLH+CQlC"
    "QYHoKZAo1CTC6uCWFCVELphm/kjf9cf+et/3mafDIm5Kt+Y0M8/Md+b5zgz8T9FvsNVrRvxx"
    "tD9G17Y/95Jk7jl6Y5iR7DBWZU6gIjkpYWvSaL6eCLTcQimS22+iSFa13ibSdDEhLpOrQzvg"
    "5rbi+2SMfVGMfYcxzGp0uDFRGF6xfLAC0WN2wAwTjLYgAlqT2dNBqJ1RyX7uUStjoCFQ34Fv"
    "cFOELrP2BGihuPQeLfQ0XiL9Tx7yLxlxpy5o+dmrN56xVpq6rPXsXZ17d1YvDfBwd7zhvsIG"
    "CHeUUbPDxIIwEz15L4a/iqEN/GKOtU996aLQGb+CAzD7CBsPTC2kqLIS+RcZtOAoIS2KjBTm"
    "7WBAgfggGhEwhcG5R1iisMyqJvKFhVFTKwg1XyZccxzZmomJt5VAK4LhCLiLoH3Mqlrq227Y"
    "4uUJRuowI3XkV7+xPvEYUynwvz5ABKRc3dEKalqvJkIRE7TGy62z+OFJWgmOKCzxsTwX3BKY"
    "0fN0VpKSfUqsZDIT3H8YVVggGNqPpoASCLhcaukuc7BnjNvimgxWHzoXU26Oxcn+zNbvFcLR"
    "Rg7E2+2CT2p3fLDSWB4gFTl45lpNvIONzDhFZ64ntzz9KxBpsOuajuKWsK+0/Sz2jTGxp4Pl"
    "AbpC9fbNmngCVdxg88dbhxJD4jG0Pj8NWmiwThGJHky9uVMe/V8ASkF+Ie1sLXxkcz6NUvTG"
    "u3GOdDO6Nvc9venkWfr2heziL0cVdw7KqPzCbD+WQEorYp7P9dbu8s5P3qfLL5H0PEaBvtOp"
    "HSL/ANikQvL/Oa4mAAAAAElFTkSuQmCC")
index.append('asterisk_yellow')
catalog['asterisk_yellow'] = asterisk_yellow

#----------------------------------------------------------------------
attach = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfZJ"
    "REFUOI3Nkb9rU2EUhk9qwaEERKRFHDRY4yY4qEhRcBNd/Qs6xc0aELOEQHAQmjWxSYaQoYIu"
    "/lgSI00uESopRAUXBwkFoSDSem/uOe93vpt741SxJaWCi+96zvMcOC/RPyb2N0u1Wu3UaDTq"
    "A9hU1fsiwtls9gMR0ZHD4Hq9nrDWbojINoDjIpKMx+PLyWRy3Ov1nKnDLgNYE5H3ImJF5F4u"
    "l7s9GAyuishDIqLpg+CVlZUTALoAPotIpKrZfD7/kojIdd2htdY9UFCpVOZU9Ysx5h2AH6r6"
    "GsDbVCrliEgXwEUANFFQrVZPG2P6ADoAvgPYMMZ0mPkNgC4zH1PV+TAMLxDta6FUKp0LgqAN"
    "oAXAAFi31j73PO+Tqr4QkTkAN6IoutJsNrf2CMrlckJE2gAaAIaq2rHWrrmu+1FEVo0xZwHc"
    "tNZearfbm7vcFBFRsVg87/t+3/f99Uwmc5eZE57nLe/s7Hxl5qcAEsaYW7FYbP5P+LdARM6I"
    "yDAIgiUiGhcKhTvM/IqZHzDzSWPMQhRFyUaj4e3/2TQR0XA43FLVo8wc7g5836+qajYIgsvj"
    "8Xih1WptT2osRkSUTqdnrLXPAIyZeUlVZ0XkyWg0mgmC4LrjON8mwXueuLi4GAdwDcAjY8xs"
    "GIaPrbV1x3F+HgT/H/kFyEt+J0am0ZgAAAAASUVORK5CYII=")
index.append('attach')
catalog['attach'] = attach

#----------------------------------------------------------------------
award_star_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAudJ"
    "REFUOI19k01s03UYxz+/f99oLc5VBWUTE1YzxpDNyMGYRcyUGKNZ5CDECzgMamY8cZDEGOM0"
    "Bk2IF53JLiQzLIaLRHYQ8WW4UScg6upAzAjazLFu3UrXrqz/38vjYaxZduCbPHm+l+f7vCtu"
    "4Zn3z0hnR5Kf/53DGcFah7UOZx3GONoa7qbn2EV+/fxFxQoEl4mzFucEo28FmiVvzZIZI1hj"
    "WQ1vmVSzaYvxLU2hEfbe+SHat2htlwRvJ+CMZaGs2bA2gvYt7bETbE9c5T75iwdqopTKFay9"
    "bQWm+3w6yz2RIM2182wKj+Il2nk6/j3r7gjzy28TWGO6VwsElknmbP9gKNnhLVbMjufrvmPj"
    "hiRebRuxzKccHXuS9N/Z7iv9+99dLaAkVR/1XaBRiQS0hndS+157veXUgY3bDoAXxs98Sd+Q"
    "d3LP1vR76KUgXxdn6nbnMwCqMrh+QmJb6kRARBAneLVPQOxBROcRXUDPjmLL0wgKpzV+8R/8"
    "udzeTV18ETSz2S53PXss0NwVD9a9hPhTOD+P0zmwZVCO0L2thINrcUZTuNDP3Pnc114NXwEo"
    "gBt9JJ1lILx5V2Og/gXEzyJmAXFlxN4EFeCHy1P8dN1S1Jr5hUIxX5r9+NRH6Q+qV5U9TtzT"
    "9MVa39qlIgmcySO2DG6R09c06Qo82rSd+sRD/Dh2gpE/h7g2njtSXeP63ZQC0fhpXRhHFCAO"
    "hQKxDFyeoHVzC9aztNy/E6s0jz38OCBveKyAU+HnQrWtKBVEjMGfm0SFEkzP5wipOB1NbwJw"
    "8KleGtZtQ6HWVH8hc7w+6ly5PXDXFgrnjjB7NjUuHsPxxuTLxVKFsckUf0wOc2jnUQ5/28ma"
    "QARBFqsVRJjfoeIN0ZmBg0wPpnpdiUeaD9OZvzL+bBs3iiOjKcIEOZnuIayCDP9+BlCfVYf4"
    "Xy+v3Jzh7cUcXVs/4ZuVrV14lZpeVzN0KRRt1p7yBIqI9JzrmTr0P5VGgdHTVfjEAAAAAElF"
    "TkSuQmCC")
index.append('award_star_add')
catalog['award_star_add'] = award_star_add

#----------------------------------------------------------------------
award_star_bronze_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnZJ"
    "REFUOI2Fk0tI1FEUh7/7f/if0bHs/fCRhTFJhEUWVousnRg9Fq2CoEVEReuW1kBtaxcFUS0C"
    "cROYpT2oRbVwEUYRiomVpEZTvsZm/D/uPS3MYSSG7uZw4X4fh/O7R1FwogvnJaypJejqQkTA"
    "GMQYRAQxBu/QIXj5isSLp2qBcQoFEkX5xwtgXrIgCsJCBGuRIIzmAa0RrXGrNWXNfv4uxvxH"
    "EIRIEGBt3oxojdcA7vZK7HIfK5mEuTkkCIoLTBCk1OgYdm0tTsMm3LUas34fsYYynA0bMP2f"
    "ED9MFRXE29vbZGw8xZcRvC02pu4YeuUuvDXTyMAgMjicWtbf11bIOADS0RQnsJIoy4Zfnbnn"
    "mXVuqTkdLj2Ozuaw6/fifX37MHZseadwYCcAfpBWZ96MKAC50/iNFfWVggIREINevQffqcLM"
    "/sSOpvCyn1BzE/NN6xBmx7Fmpk7OC65WHyYy903z2YSuO46ZSRPN/MRk0pjsFBL4IAZVUopN"
    "hPOhi9jwUCeePpH/ENJWVUeou0zT0aRfcwQ9+R2dncRkp5HfM4gSvGiCRN9zTSZsU/d+XFk0"
    "RHX52xBu1Gj19zxwpj4iJkDmfiN+FhPlcFyHRP/LCULTsgD/k4K6nJ6lovyZlfmCRCFEIRgN"
    "4d9a4syqm+PPisY4n0u8VVdsAcB2I2L2NFa8Am089PJVNZJKbisqkI6mOIaDOlFLbLib8ie3"
    "h0pfd98tT/fi2RmiJRshVK3FO5jQ+3WiOu4+vkRJb+8tbL1D3Rg95Y6NtJS9ezQquRyEskiw"
    "aBvJTFbaQ+OfSfvn1L10T3421772yMVNW2MD76+j2V2I/AETYVbTF3nsbgAAAABJRU5ErkJg"
    "gg==")
index.append('award_star_bronze_1')
catalog['award_star_bronze_1'] = award_star_bronze_1

#----------------------------------------------------------------------
award_star_bronze_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAolJ"
    "REFUOI19k01IlEEYgJ/vZ/12bQ0pM8mMFMmiOhRlRoXRzYTqEh2KqEOUdevS0TTqFNQtCsIM"
    "IuiQUZZKQgUVWNCvZZGZ/Sqt7K67uvZ989dhzVbCBl5ehpnnYWbedyxyxpHufWbrsjqexR+j"
    "jEZpNRkaqSVrizbScuMyXUcfWH8YN1cghUSb7GalFVLryfw3gkDmItjTBIHEGBBKESjJktEE"
    "uz5/JFACqSbXfDGzQAQSj3w8O4xQkk0jI6yWUUpSo3hOhIiJIoL/CAJfNL8d7KPMq2S+dKgY"
    "T6MXbGDDcILycBXPXr4g8GVzLuPkTnqvv78fXufYc9x5tVuCFAuK16OKqinpbaNLlNLx5E7z"
    "89O9jbmMBWCu1UQI7Cos2wE4kbQPHioMH5i9ogElXLyvbVx9//TWnpKipinSD2LWwUdfsoKW"
    "Nd+Yu6zUYIExYDSqeD2+uxA9NoIjk3iZD1i/4tlbKwFjQ9ip5N6s4FTZNqS+ojc3RFXlTnQq"
    "hkyNoNMxdCaJCXwwGisvHweJ+7qd8ED/TTy1e6ohTOPCSoRq1zU7qvxF21GJYVQmgc6MYsZT"
    "GMvgyTjR592KtGi0Wn+enFYFq+lbPyG5xu7rbHOTbzA6wPwax/gZtJzADblE++7FEbruD/xP"
    "Ga2m2BiFBXft9CBGCpACtAIxmfPcMev80N0Z+wAAN1KvCpdmaxyShJ1R7EghSnuoOfMWmeaq"
    "lTMKzLWaCJotKrqY8EAHBV0X+/MfdlwqiPXgOWnk7HIQVv3MJ4irWhUti4TuHCevp+cCjlpl"
    "nfu+P/TjS92sF7e/m4kJEGaaYNpvJJ0odfqHPhHzD1utsc6ptznzudMcq1gefvfqLIrqXOQ3"
    "lcVVzBd+rh8AAAAASUVORK5CYII=")
index.append('award_star_bronze_2')
catalog['award_star_bronze_2'] = award_star_bronze_2

#----------------------------------------------------------------------
award_star_bronze_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAopJ"
    "REFUOI19k0tI1EEYwH+z+1/Xzd2SMg/5oGzJojr0IIyCokMhgtWhU9CTkLp0q6Np1LVORUFU"
    "hB66BD0NiwqS2KKnhD3EarPMNlZz19XdmW+mw5ashA4MH9/h95tv5vtGUbC2HH/k9jZGefIl"
    "iTUOEYuIxYrFGMv6hXM40/aC52d3qH+MVyiwIljrMPovaPJRTH4b4xAjhQi+wmTiNC2YnLBU"
    "v2Z/7jw6J2gteeF0AmuE0YxmXiSIzgmb3X3qSgaoGO+jalaIdCaLyLQVmNZn3YOUBT2WRUZZ"
    "5D5i562jQT2hvKSI2Mt+xJjWQsZfmMS72h8Goo2+8azZsH3WUyqrFiFlayh/d5Ez8ZV0fxhs"
    "fd++r7mQUQDual2InK8W5fMDHOlpaDpcEztQtmo3oj2CX69x5bnc2BONt0yQ2VxCNXXF84KL"
    "q/uZs6TCocA5cBYpX0vWq8Smf+E3wwQzH1HjyfytRUN6AN/I8K684GRVI8a22Y0HwxLdgR1J"
    "YEZ+YVMJbGYYl8uCs6iiGfgxeN03Ke7rvU5Qdk4MhGuujKLlpq3bVput3ooM/UAyQ9jMb9zo"
    "CE45giZJ+OU9IaWb1eWfJyZ1QbX09xIwq309Hde84bc4m8ONj+KyGawZwwt4hHseJNG2/h/8"
    "XxtVSyJNaaTTl/qMMxqMBiug/8YiL63ODXROOQcAeKEGKV2c73HAUOz/jS9UitggMntutWut"
    "XT6lwF2tC2HZJOH5FPfdIXL3Qu+Mx3cuRRIxgv4UZuYC0Kph6gqSskHCVaHA7WMUxWLn8csK"
    "dfbb3sD3eH3Jq1vf3NgYaDdJMOk3khqq8PcOfCKRPaQuJzom3ubUlw53tGZp8bs3pxHWFCJ/"
    "ADXQXvT5EBZuAAAAAElFTkSuQmCC")
index.append('award_star_bronze_3')
catalog['award_star_bronze_3'] = award_star_bronze_3

#----------------------------------------------------------------------
award_star_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuhJ"
    "REFUOI19kk1slFUUhp/7fdOZzjBYplZBWqHAaJUSrIlLImZioqghsrCGDYoGNbNDFy6MUWtC"
    "2Bg3piRsjDU0hg0GMVFskyLSgtS/NpjWFKNjCx06nWlnytfpd3+Oi9JJ0wVvcnLfxTnPueee"
    "q7ijZz6+IIf3pxn6t4gzgrUOax3OOoxx7NlxL92nfuWXEy8pVimyYpy1OCcYfafQLJ/WLIcx"
    "gjWWtfJWTK2btpjQ8mjdZQ7dcwwdWrS2y8C7AZyx3A40m9fH0KElk/iaJxqvs0nGeLAhzkKw"
    "hLV3vYHpujqapykWoT1VZnt0BK8xw9PJfu5fF+XKb5NYY7rWAvwVk7vUO1CX3u9Vl8zeF5r7"
    "2LI5jZfaQyL3GZ9fe4rRv/Jd472vfbAWoGSwJR46v02J+FrD+4OvvPnWY98f2bL7CHhRwtxX"
    "9Fz0vnl51+hH6OWiUFdmmjtLOQC1NLBxUhI7m0VARBAneKknIbEV0SVEz6NnR7DBLQSF05qw"
    "8g9hsXBoe5YvI2Y2n3U386f89mwy0nwQCadxYQmnC2ADUI66+zqIRtbjjGZ+uJfi1cJZr4Ez"
    "AApgroe0s5yLPnKgzW95EQnziLmNuACxi6B8pvuGmb7wB9W5qjhPJgXpfrbPHa/9qvxpkp6m"
    "J9Hx7gEVa8SZEmIDcFVmhqaojBd4ONNJbFs7iyPn+fPieTs3Nna0tsaNnSz48eQPen4CUYA4"
    "FArE8l//EA9lOqm/PoD64iCJv8/QurXJt8jRyKqN4FT0+ViqA6UiOGPQczeINrWiC2XqN22D"
    "596u5UY+fABfVGsNkDvdEncuyPgbdjL/8yfMXhqcEI+fkm3pV/0NCYLfv2Xd2SxLi9MEQKXs"
    "Y31u1EaIUd6rkjviM+fe4dbA4Em3wOPtxzlcGp/YV98olWuXf+RmNU7Zr6NUVExMKisi3bVH"
    "nDrJ64szvFctkN31Kd+tHm34DRoWyqn+arG82zcq4jyZcsiJfX3u2P8E+4ovXUezIAAAAABJ"
    "RU5ErkJggg==")
index.append('award_star_delete')
catalog['award_star_delete'] = award_star_delete

#----------------------------------------------------------------------
award_star_gold_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnZJ"
    "REFUOI2FkstLlGEUh5/3+0ZlakTHFhZjjlAykXQPgoqKVoUSCVFEEEXUomgR/QHCQNCmNu0i"
    "CIIiigrMCIpMqFxYEJXdJxHJ0TJnGse5+L7f954WNcN0kc7uvTwPh/M7ioryjh8T09yC7ulB"
    "RMBaxFpEBLGWmo4OePiIUO89VWIClQLxvPLnEliWlETaVCI4vwmM9xPwfcT3cWI5qnaNls9i"
    "7X8E2iBa47S2Ir5PYEMGZ10Y5mVxYjEoFhGtZxdYreNqNInb0oK7OopamMNp2IqzQRGIRrFv"
    "PyIzJj6rIHj1apckx+IMj+CuKeBE9uDUr0eiSeTdB+TDUDz89nlXJRMAkP6moLZuTIm4xjzv"
    "lhuRBYQnD6vanYgtUNW6Eb1o4LYcdrsnTPMaAG2yE5Hd6REFMNPX+FnmLI2I8CsFwQlvgjlR"
    "xKQRk8FMvsTPf0VQWGPQ2WF06tt+BZC7wQ6ruey2HQ0FInsRPY7VaaxJgZ8H8UAFUIFarGfI"
    "PLvC5NPBbqeOfeWF+H6Jxdanp3pJZ8xt2onoL4iXQ2we8QugXLxUkrG7132TpWvFOU79NsT6"
    "/STMXNYWhm7dslNvQASRGcTOgGgULl96r6e8IttL8F8pNO5m2g2G7ptMAlGAWBQK5OcS4TC9"
    "/Cz3Z40RwKrq9qrwSpQKIJ6HTiVRVQ041XVUN85vfhFn2V8xlmrkWlPQ2vxWt34pmYEzTD7p"
    "T4jD41Bs8YHaJVuoWdBG6tN4O/Dqnx3UMLVZhRYFJ3pO8rWv/7ydZlXbaQ6m3ye2f7p5YVQX"
    "NMUc7X92Xa7R8xxKnGJo8ATb/nx7doS6B/u4eKeT15X3PwARjVieA+d/JQAAAABJRU5ErkJg"
    "gg==")
index.append('award_star_gold_1')
catalog['award_star_gold_1'] = award_star_gold_1

#----------------------------------------------------------------------
award_star_gold_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApBJ"
    "REFUOI19kutrzXEcx1/f3+84Z2eOdnGZdWaS1bDcQhIhD2RWwgMlpUk84BH+ALVSEp54JqWE"
    "B+TS3HJtipVLc5tJnY1krts5ZtvZzvf28cDGcX3Xp2/f7+f7evep90eRp+036mXl1Fpa0s04"
    "8TjvhspjvWXemEUcPX+Mqztvq2Emkm9gjcXL98/OO6z3Q+fP0trmIwS/GGiLCBjn0M5Spd+z"
    "tv8e2hmsG+rlzL8NjLbEKCQWFGCcZUGunRlhwNjBLmJhnLgkMPo/BjpnGtpev2BCrIpxIlSa"
    "LoLSZczre8ukgmpanjxG52xDPhPmX1rPvmwqmB8GpZGxSxbHOkmOnk9QsohEx3Ga0lO5cv9y"
    "w6P9rbvzmQiANFfEtQ+rlUhozIvGfa8y5ckJ2S2qfDniByiqWMjEluMXri2NNrKwcg6ANr2f"
    "k+sybxRArqnsrRROS4qAiCBeCEoWQ+FExGQQ04PpforLfkJQeGPQva/R6a6NCqD/DKu85kRY"
    "sy0RSa5H9Ae8zuBNGlwWxIKKoCKj8NbQ8/Ak3Q9aG4MiNvxYiC/HqPKOi9Epa6rDitWI/ojY"
    "fsRnETcAKsSm3/H+ymlnetk98xB7fkmheCMpM5K5Ax3nzvmvbSCCSA7xORCNIuTjrdNpO0jt"
    "MPxHjGXr6AvjieumJ4UoQDwKBeIQ7yGgb8ZBrv9zDwC8itaNKJmFUhHEWnT6HWpEKUG0iGjZ"
    "+MonDUz/I8ZhvTlVEfc+uywsnkbP/QN0321OScCdRHVV/agpS4mV15Bu/1AHPPvrBDG+LlGJ"
    "yfHPF3fxqan5sO9jds1eNmVepmrbzx7p1AOawX7qfp/6hzoPszm1h47WHaz4vfdwK0U3N3D0"
    "0hqe579/AwYKV3nB8EbFAAAAAElFTkSuQmCC")
index.append('award_star_gold_2')
catalog['award_star_gold_2'] = award_star_gold_2

#----------------------------------------------------------------------
award_star_gold_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApBJ"
    "REFUOI19k2tozWEcxz/P/3921pkzs5FhM8WpYa7lpdBSaFq8QFJj5JJ38loykTe8IUpKKUvk"
    "kkuSSxPmTgyZzsTJbdiZ3c52/s/l58VYf9dfPT39nuf5fH/f+v0eRSjmbb8utdUJbr9N44xg"
    "rcNah7MOYxwzxw1l/9FHPDywRP1kImEBZy3OCUb/AE3/bk3/MkawxoYRvHAyUE1bTGCZkHOH"
    "msE70YFFa9sv+D8BZyw9Gc2o/Fx0YKnMO8OMohZGyEtGF8TozmSx9r8OTN39plaG5UaoKOxk"
    "bPQpXlElc+NXGT4oyt3H77DG1IUZP5ykbtU35CSqvb6smb2w5AploxJ4hTPJS+3j8PM5NL1q"
    "rWuuX701zCgAaSyNBc4vVyK+1rClceX6DVMvrS2bsha8KEHqGEdueOeWTWrahu4HA931pWRp"
    "e0oBZBuK30nexBIREBHECV7hLMgbg+h2RHeg255iM58RFE5rgq43BOmvNQqg5yTVLuCoX7Ex"
    "HilZjgSfcEE7TqfBZkAMqAgqko8zmo4H9bTdf3bWK2DFwEB8O0LCWc5Hxy8u90sXIUErYnoQ"
    "l0FsLygfk/7Ax4snrO5i69S97PilC0NqSOpBzOh9ffq063wBIohkEZcFCVD4tF47kTZ9LPgJ"
    "/9HG4qV0+7H4Zd2RRBQgDoUCsYhz4NE9ZQ+X/zkHAE5Fq3IKp6FUBDGGIP0BlVOEFy0gWjyi"
    "7Ekdk8Pvf/kLqeOlMecylf6QiXTc203brcakeNyMlydW5Y+fQ+7ICtItn6qApr86yKVztoqP"
    "i305v5nPDY0HXTfTK3ZR296cXNBy6tD7oDegr4eq310PxPuDrEnu4PWzTcz//e7BOgquruDw"
    "hcU8D59/BxVmWbwXErXTAAAAAElFTkSuQmCC")
index.append('award_star_gold_3')
catalog['award_star_gold_3'] = award_star_gold_3

#----------------------------------------------------------------------
award_star_silver_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAotJ"
    "REFUOI2Fkz1IW1EUx//vI+SFWMgTP5CXxICVUEqHklIchGKniM6CS6FDHSwd3FxEiXRT6NSh"
    "Uwdb3IRU8NFAixQCcWinYmw1LUFt60fEKC/vvXM/OmhCQgm927nc34/D+Z+roOmwZ08lxRPw"
    "19chpQSEgBQCUkpIIRAcHwc+fkLHh/dKndGbBZKxxuM62JDURT41I1BbBMSuAM4hOcflrVvY"
    "n5xs1FKI/wh8gvR9qIODkJzjeHgYtaEhOD09UJNJwHUhfb+9QPh+Rjk4hJZIgKdSqMZiME0T"
    "xyMj0Pv7Iba/Q3qUaSsIra7Oy8NfGfwso5JKoaevD5FIBL/jcYjiLuS3Usbc/jLfzOgAkM/n"
    "Q5qmJaWU2meibPztat+fjhtPooaBi4sLRGIxfI1a77bH09mXRCkiQq1WO56dnS0rAFAoFPYD"
    "gYDFOQdjDIwxmKYJVVXheR50XcfR0RFOTk5ARGCMoVqtolKpPNIBgIima7XaG8uyOiKRCM7P"
    "z+E4DhzHgZQSnHP09vZiYGAAwWAQW1tbKJVKWUVR1hoLYdv2TcbYumVZSeO6dc75VfZSwjAM"
    "CCGwsbHBGWPzmUzmecsQ0+n0ruM493Z2dtaICJqmQQgBcb1AgUAAtm1XiGi0Dv+TwsTExKXv"
    "+7nT01NomgZVVaFpGhRFgZQSruteLi4u5trGCACe5411dXXBMAyEw2G4rgvTNBEOh9HZ2Rmf"
    "mZm501awvLwcIqKH0WgU5XIZ2Wx2d3Nz83U+n8fZ2RkSiQSIaKytIBgMPuju7g7Zto1CofCK"
    "iO4uLCw8LhaLoysrKwdCCDDGWgQtv9HzPGtvb+8HEU3Pzc3Z9fulpSV7amrqdi6Xe8E5v9/M"
    "/AXk4nc7HI/26wAAAABJRU5ErkJggg==")
index.append('award_star_silver_1')
catalog['award_star_silver_1'] = award_star_silver_1

#----------------------------------------------------------------------
award_star_silver_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp1J"
    "REFUOI19k0toE1EUhv+ZSZyJKTSTB11M1WqroWrRgo+NUhSE1u67FF1Yoa7qqpvSmuKuBddu"
    "FGkXdmElKh2JC7uJJIuqUDSBJkpQKDVN6YNJZs59uLDVBIkXDpdzzv2+zTlXQd25+/amvN49"
    "gOVKGlwKcMH3QoAJhvPRS3j84ine3FtS9hlfvYARg5C/H3PBwYTYu/+G57F6BGqDwGOQEiDO"
    "4XGGGLfQ612GxwmM7/Vcai4gj0HHQeiqAeIMR71udPq6EaRW6FoAAdkC8v4j8FxKfP72BYf0"
    "LoQQRasXgWmaOELHcdSIY/nTR3guS9QzWn2y8jz/zrioqWFfrO/EgZM4Fu5CJBJBuVjB6noB"
    "i9nXiQ/TKxP1jAIA6XQ6oGlaXEqpERHmc3N3rljXbp+JnwUArK2tYf79s5enW3vuExGICNVq"
    "9efY2FhJAYBMJvPd7/dbnHMwxsAYg2maUFUVruvC5/NhfX0d5XIZRATGGLa3t1GpVG74AICI"
    "RqrV6pxlWS2hUAhbW1twHAeO40BKCc452tra0NnZCV3Xkc1mUSwWk4qiLPxZCNu2uxhjryzL"
    "ihuGgZ2dHXDOIaWElBKGYUAIgcXFRc4Ym0gkEg8aptDf37/qOM65fD6/QETQNA1CCAghIKWE"
    "3++HbdsVIhrYh/8Z49DQ0K7neamNjQ1omgZVVaFpGhRFgZQStVptd2pqKtV0DwDAdd3BaDQK"
    "wzAQDAZRq9VgmiaCwSDC4fDh0dHRnqaCmZmZABFdbW9vR6lUQjKZXF1aWnqSTqexubmJjo4O"
    "ENFgU4Gu632xWCxg2zYymcwjIuqdnJy8lcvlBmZnZ38IIcAYaxA0/EbXda1CofCViEbGx8ft"
    "/fr09LQ9PDx8KpVKPeScX6hnfgEckW7QD0VN5AAAAABJRU5ErkJggg==")
index.append('award_star_silver_2')
catalog['award_star_silver_2'] = award_star_silver_2

#----------------------------------------------------------------------
award_star_silver_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAptJ"
    "REFUOI19k09IFHEUx78zs+uMbH8cR1tyLAQXQqIg+nMqoi4Zgbc8BgZ58ObNiyQr3RQ6FQRB"
    "B+sabIFDe2kPbaxREV201GgzKNMVXZvdmffe79fBlJWwHzx+vB98Pu8H7z0DDefKeEEP9GXw"
    "+msFijVEFEQUlCgwK5zv9nDv8Tu8vX/d2GYSjQIlAqU0mP6CvHULbwWzhrA0IjAbk51qJOBY"
    "4NuCC14MigVEsiX8n0Cx4HdI6Nhvg2JBz74YPV4CBwzCkYPN2AwjiPz3B5x98/En2uwEMq1N"
    "8JIxXNfFSU/hUKoJpfdLEOZsI2M1JuVXT14mM31mPeKLZztMZDpceJ6H5W+LePFhEx8//cjO"
    "Pbl5u5FJAECxWGy2LOuY1toiotzDQuWwFdZuOY6HarUKP+0hbX5+duWS5Oj8vdNEhFqt9mtk"
    "ZKRsAECpVFpKJpO+iICZwcxwXRemaSKKIiQSCSwvL2NlZQVEBGbGxsYGKpXKjQQAENFQrVZ7"
    "7Pv+vpaWFqyvryMMQ4RhCK01RATpdBrd3d2wbRszMzNYXFzMGYbxdGcggiDIMPNz3/ePOY6D"
    "arUKEYHWGlprOI4DpRSmp6eFmW9ns9k7u7rQ29s7H4bhmbm5uadEBMuyoJSCUgpaaySTSQRB"
    "UCGiq9vwP23s7+/fjOM4v7q6CsuyYJomLMuCYRjQWqNer2+Oj4/n95wDAIii6FpbWxscx0Eq"
    "lUK9XofrukilUmhtbT06PDx8Yk/B5ORkMxFd7uzsRLlcRi6Xmy8UCo+KxSLW1tbQ1dUFIrq2"
    "p8C27Yvt7e3NQRCgVCo9IKJTY2NjA7Ozs1enpqa+K6XAzLsEu7YxiiJ/YWHhCxENjY6OBtvv"
    "ExMTweDg4PF8Pn9XRM41Mn8API15DFtZvAAAAAAASUVORK5CYII=")
index.append('award_star_silver_3')
catalog['award_star_silver_3'] = award_star_silver_3

#----------------------------------------------------------------------
basket = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnhJ"
    "REFUOI3Nkj9MU1EUxs996evrKw9ayKupooRCJKCBkIiJgzHGoFQSYcAaB3VwMDEaRgd3FzcT"
    "TYxRU2Fl1MbA4KBp1LQKoTBQrQ8jqAHbpveV++e83rooiQbR0S850/nObzjfB/BfK5fL+dPp"
    "tLmdh/xpcXXizQVLubcP7vZpCzQE31w+fuv8gYe/+7Stjq9MZMcChnpUC/gbCxtWQ03XGnR/"
    "/cG5m0/G/goYT2b7NCWnQi0mrBU+QgxW5spf1yHUYoJGcOrU+J2+bQGjHfx61CfAWXSgtcHL"
    "nh452R/y1l85iw7YZAOOdsClX34wPz9/1/O8I4gInuf5pZQdvb29ZCr1TPR37TEcx4FoNAov"
    "ZpfYyLFD5szMzAYiLnPOARHXNET0IpFIDyGkR0p5zTAMkk6nX3buDBuFQuGsaZqQz+fPtNtB"
    "c3p6+r5lWUHG2I3u7u4eznkHyWQynUqpd+VyuVXX9SKldB/nfNXzvB2U0mVCSKxarTqe5+1y"
    "XfcLAEQRsWQYxmqxWExpAwMD713Xrei6vlKpVIYDgUBWSnk8GAzO1ev1uGVZb6WUQ01NTQsA"
    "EA+HwwtCiMFYLAZCiOcEACCVSj2VUl4slUpFwzC6GGOfhRBtAFCglMaUUh+q1WobY+xzrVaL"
    "AECRc+4g4qgGAMA5v0cIWdE0bVjX9TnG2GAoFMpQSuPNzc1Z13Xjtm3PKqVO2LadY4wNIeIq"
    "ALzebGIymcR6vd5IKW0nhKxRSruEEHkhxF4AWOKcx6SUn6SUUaXUfkS8PDk5edj3EyCl9Akh"
    "GCKCEAKklPAjWkDEzanVakAIAaXU461a/E9KJBL+RCLhBwD4Dp0zYJyL/xlBAAAAAElFTkSu"
    "QmCC")
index.append('basket')
catalog['basket'] = basket

#----------------------------------------------------------------------
basket_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr1J"
    "REFUOI21k01IFGEcxp932nF215FJUVvToFYMN/Aj2iKkIir7ogw0pEMFdejQh4eCiLoWRNAh"
    "KAnp07NElzyshw7J9uVWpiuUNe4muoq6s86Mu++87+xMhwoq+rr0XP/P/3d4Hh7gf2p4eLgg"
    "Go36/uQhvzuc7H51WHbM62urPELcUDBn0o5rh9bc+dkn/Or5RHeszSs59/PegiI1KxfmRaFQ"
    "LHBvH7zyqO2vgI57sXrBYT1KiQ8z6ieswMRgZnoWSokPAuE9eztu1P8RsC9Izwc8FhIjCVQW"
    "2rH9LbsaFXv2eWIkgVKSxeYgjv2QwdDQ0E3btjdxzmHbdgFjLFhXV0d6eh9bjSuXSYlEAoFA"
    "AP1v3udatqz39fX1ZTnnSUopOOczAufcLisrCxFCQoyxs5IkkWg0+qy6YrGkquoBn8+H0dHR"
    "9uWlfl8kErkly7I/l8tdqq2tDVFKg2RgYKDacZwPmUymUhTFtGEYqyilk7ZtlxuGkSSErFhY"
    "WEjYtr3UNM0pAAHOuSZJ0mQ6ne4VwuHwR9M0dVEUJ3Rd3+31emOMsWa/3z/ouu5OWZZfM8Z2"
    "MFmLa6XvJlLKm/iY/6maLZqGZVlPPABAKX3KGDuqaVpakqQGy7JSuq6HAajj4+NrkuLL9iWl"
    "Rdge2uitKqnB4/hD77PhJ0gRKyx8BXQRQiYEQdgtiuJgLpfbpijKgGEYO4uLi2M6nT/dWNuA"
    "vJBHQ0Uz8oRjfV0TKNH3CADQ2tr6QNM023Gc3lQqFXJdN5JMJpuy2WyfqqpNmYVZUSQyWkKn"
    "AABntnahurwehBDJ861PxpjHsqwc5xyWZYExhq/VQjPnEJ+MYnCyH+ea7+Jy5Ai8iyS4cOlv"
    "t/C91h2vuLgsqFxoqt+AmsBqjE69RvRtP8bH5q/+E+ALJHAZhBwnQJELGHDdzhedU+c+AyTt"
    "X40NpbslAAAAAElFTkSuQmCC")
index.append('basket_add')
catalog['basket_add'] = basket_add

#----------------------------------------------------------------------
basket_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr5J"
    "REFUOI21k0tIVGEUx893nTvX61wdHbVGzXylaOGDrKhNhLbIICvsYVAuWiQ9cBllEG5qUW2C"
    "oggLdSVhBJEuVCywpgdjaD4WWcO10WnyMY73G+d+jzt3WmRSkdam//Kc//ktzv8cgP+pkZER"
    "q8vlklfzoJUa59re1Slm6NbWdRZhFNthLkQabp4of/C7T/jT8Nm2gZpYyWyNxFrjPWHFFhEF"
    "m2iN3j9+rbPmr4CGloESwWQddocMM57PkANTQ8Gvs2B3yCAg3rGv4XbJqoD9uaTRaaGgjqmQ"
    "YTMGDlVXldmN2TfqmAopKAy7cuHULzsYHh6+axjGTs45GIZhZYzlFhcXo46uZ7SsIFNSVRWc"
    "Tie8GPygV1dsl3t6esKc8wlCCHDOZwTOuZGamlqEECpijJ2XJAm5XK7XeWmJksfjqZVlGcbH"
    "x49kp8TJ3d3dzYqixOm6fqWwsLCIEJKL3G53nmmaH4PBYIYoigGM8UZCiM8wjDUY4wmEUM7i"
    "4qJqGEZ6KBTyA4CTcz4vSZIvEAh0IQCAvr6+BYRQgqZpNbIsP5qenq5TFKXN7/fXJiQktHu9"
    "3toNC2PtiSNP56IhLZmKQoCUHnD0aEkXLQAAhJBXjLGT8/PzAUmSSimlXzRN2wIAHq/XW75t"
    "sLnakZ7MC+obk6WcTaC/73aM9vfCjsngemEJcA8hNCUIwl5RFId0Xd9tt9vdGOM9SUlJA+GA"
    "93R+xWEx9tNzQK3HIM7zGHKyHLCW+PYuX2JLSwuPRqPxGONshNAMxriAUjpOKc2vfHvjZeX1"
    "hwhtPrgcX7ApDdz9s1HLjwJjzEIp1TnnQCkFxhgsRQvhWBuEBzvB9uQMUN0PYQDAWgxEYsC3"
    "4i/8rP6jaU1WxXYpMyVisQiTgGcMUP0xEUbMy/8E+A7JvBCe89ULJsoyheiUCdE7Vb3m1W8K"
    "n15nYex2mQAAAABJRU5ErkJggg==")
index.append('basket_delete')
catalog['basket_delete'] = basket_delete

#----------------------------------------------------------------------
basket_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvJJ"
    "REFUOI21k11MFGcUht+ZnW9mB1h2XfnZVtAuqxggCBZoQ1yaJpQYrXpDiUZtmxpDYjTYpE3T"
    "3vSmmBpvWlIN1lZKIWm4gBiT1bQXrUHiuCo04mLEpozrzyKw7v/Cznzf7KxXcNEoXvXcnud9"
    "kpNzDvB/1tTUlKgoirwaw72scWzg748KzPTppjKBv5uyI5LWuno+bOj7L8e/KHx0YKLdKpm/"
    "Zq2iTV0qyM8SPp+IufMHT11qf6Wgq39iC2/SYbtTRlh9BDdCk/H5Z7A7ZfAcG97ddWbLqiP8"
    "efXakP8R26tGFuFCYuLE8f2NX/94wR/SxLfflG6h1TYNS0EtFp+NAlroYy4QCJw1DOMdxhgM"
    "wxAppRW1tbXc8OUren1luRQMBuFyuTA7M0LffUMW5aIW2N1bEX9wHXf+6KM8Y8woLi6u4jiu"
    "ilL6hSRJnKIofs9rDklV1X2yLEOY7/mu7a01onPTNmSi95AJ3oCt0IVCZxnhxsfHPaZp/huP"
    "x9cRQqKpVKpa07RZwzBKUqnUw4aiiwfclVt/cHh28PrTIWQiHBbuL2FxKQvfjHWUb2xsnEmn"
    "00lCSCiZTO60Wq0TlNK2vLy8SU/+lS8rKuvOODbu4rXZn8CRGEiBDUJaTaikHnNJ/C4AgKZp"
    "1ymlh2KxWFSSpDpd15/mPen9qqbV+6194x5ooV7wxABNurEwqiwGo/y+v0LTFxljt5cF5ywW"
    "S4jn+XZCyIgl9Nv3m+ubPy2peR907mdYxBy0xAYsjPrppURz/vSTiMsw2CyAmytr7O/vZ7lc"
    "zkYDpz/zvre92+BKsNZ5DWtKRGiJcoTHbkSno/JO3+PXddM0axhjRwYHB73CsoBSKui6nikt"
    "daDa24n7Q5/jnzEF0vo6pOceYCy22Tm/JPizWQMcx8E0TR8ArAg6Ozs5APjmcDWjd32Cu64F"
    "iXAED28F0oVFdm93zy+Ty2xHR4f40kv8wOvINHhKhaaqCuSIrujh8Ce7TgbUF/0MADwH+apT"
    "PJHnRKsAAAAASUVORK5CYII=")
index.append('basket_edit')
catalog['basket_edit'] = basket_edit

#----------------------------------------------------------------------
basket_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAstJ"
    "REFUOI21k0tIVGEUx//3m7neeTr2mNQmM6eysRgttNr1oCINKnoHPSCoIAo3QYs20aJFbSIo"
    "iqAyoSCQFkVD9DAouj5iQlPLiqYpGnGcUXO8zL33++58X4teGGarDpzF4fzPb3HO/wD/M7q7"
    "u/NUVXVOpJH+1jjS+HKvh2vnF8+wk55RHwY1o/7cnuqrf+rIeMOHG6NbHAq/nnPkeWNZjzsn"
    "E7ecJ67sPnNvyz8B9Q3RSsJpk2+yE6nYZ5Qh0fk1mYZvshNEYk3r6y9UTgjYGDSOF9lNxF/H"
    "EXBb0a0b6hb6rHRb/HUcU6UsVgRxcMwOurq6LlmWtYwxBsuy8iilwXA4LDVFnpgLy0uUeDyO"
    "YKEOaK3cWbKPPHj8PMsY+2QYBhhjKcIYs/x+f4UkSRWU0mOKokiqqrbOLi5QYrHYTrfTDq/x"
    "KBGct4oMvrnW5fF4XLqunwqFQhWGYQQJ5/xsX18fhoeHA0KISCqVqtZ1fdPAwEBVJpO5X8Lv"
    "XpxSWhvIL14Ev9I/c7qtZQeltLm3txeMsVekpqbmg6ZpGVmWE5lMZp3D4YhSSte4XK7OaY7E"
    "fhvXD3mnFiCXuYOiygM+F8ndylFjbVlZGUzTfEYAwDCMlpGRkcDQ0FAknU5XmaZ5P5lMLJmj"
    "dCwpWrANMF6ivfEGPAU6CnhC1Jb22FVVpYyxjp+Ay5IkJQgh62RZ7tR1fXWxJ9vu8Ye3eydl"
    "wc2PgODIaS8QXHlUsuWyJyVu9ANo/+XEhoYGJoTwjo6OzlKs/pFF+S+a5y4/GHLIbeD0y4+b"
    "ybC5q5F8TxCJ3P186PTD0l8+oJTaNU3TGWNv3BjqKyyvC7m8aQhrEJBsiN5+B4CDG+/gLy/F"
    "XGeq8OmJ+fPH/YW2c0u/hHfdDNhIHMIaBiDGeM/mnIdkTwfe3jnZZB8PwEzqiF7erAsuIDj/"
    "nkLgdy0AzgEuir4BPw9oQ6kd3mwAAAAASUVORK5CYII=")
index.append('basket_error')
catalog['basket_error'] = basket_error

#----------------------------------------------------------------------
basket_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArdJ"
    "REFUOI21k09IVFEYxc99M2/ePLWmrKkR03CMcCrLyEjoDxIUFWTgRESUQYvZVC5bRLtyU6ui"
    "oILE3AXWRnKRZIE1Zv5B0QycnMZiHEOdsXnz575777uvlUFRtuosv+98v8V3OMD/1Pj4uCsc"
    "DuvLecjfFpfah5uKZObu7g1O5YPhwUKGNt8+t6v1d5/yp+OL7UNBtyYfW27XimiuqNBSlULV"
    "ZT86e/N58J+A5rah7YpkHZ5iHXPRL6hAfHTx2zw8xToUwjuON9/bvizghJ9e9TlNxCZiKC0U"
    "QycbjtZ4xHx/bCKGtSSHej9Cv/xgbGzsvhDiAOccQggXY8xfXV1NOrpemTWby7RYLAafz4c3"
    "I5P5hoN1end3d45zPk0pBed8TuGcC6/XGyCEBBhjVzRNI+Fw+F1lySotGo2e1nUdkUjk1Gxx"
    "m35nsAkFRe6CfD7fUlVVFaCU+sng4GCllPLT4uJiqaqqScMwtlBKZ4QQ6wzDmCaEVGSz2di4"
    "pz1R7g24J+LD8M7t83tlWTSZTHY5a2trp3p6etKqqsbT6XRQ1/Wn6XS6aYA8aJc6s5ltEaZw"
    "u3T1ZhLw7YFBsxjNdU7tXHMDiUSi1wkAlNI+xtiFVCqV1DRth2maCeFiOLTtPLFsCUtaRMLG"
    "zPevqN6wFxmWJ/e/XMYmx7HIEuChw+GIK4oSVFX1aTKZPEMVBsuWmF6IgEsBITm4xZE2DdSU"
    "7UeG59BPnz1RAKCxsfFZKpUSUsquRCIRsG37BRUUwhJYv7IcvpUbUeLxQ3Xo8K4oxfDXt3gX"
    "ec+zHLXOpTwZY07TNPOcc5imiZyToq3vFphkoIKhcu1W1PkPY2D6DXo/9iIwWx/ubH0x8hMQ"
    "CoX+2gsASF3vyxJFL3g9+TLuMAuPuA3PJLBMmX5XxTVkLdtRYMLyf2vB56X5D4rcYx1f/WHO"
    "AAAAAElFTkSuQmCC")
index.append('basket_go')
catalog['basket_go'] = basket_go

#----------------------------------------------------------------------
basket_put = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqVJ"
    "REFUOI2Nkk9IVGEUxc/39PlsGh2NN2EF5RiZGhaRi6CIiEop+kMw0SaiwKBFLiNa1CoIinZB"
    "VAtB2rmswRT6j4QYGRaFlimmRtEbne+9+f7c977XpoKikQ7czeXwg3vPYSih8727YhUp5MUC"
    "fCqa3s6Jsn/5rFIAgML2lk4c3ngWMtIlXSUBzDblYBZiBkSgkr7yvxdXB/bP+7qIuqXNACwY"
    "w5BZ1oLN1xZ4oajUx4uxuyigzNaplpptqEttwVc+jQXhYXv9EYAlkg/eP5ZAsPgJk5NXNr0P"
    "HmHCe4JlS1fCrVqDka9PMV2owrbKu+6BrhsbFwUcapAXyj9fxlBwH+++9+Gd9xhD02OF5f5x"
    "uKyInQ04/cevRkdHb4ZhuIOIEIZhhda6obW1lfXmHqq+9EnH8taja9V1PB8ZEwd3bV0yMDBQ"
    "JKIpKSWI6JtFRGE6nW5mjDVrrc85jsMGBwdfrF1R6xzN3z52InkJ4+PjR+vdxJL+/v47yWQy"
    "IYS43NTU1CylbGDDw8NrjTEf5ufnV9m27XHOW6SUs2EYLuecTzHGMkEQTIZhuNL3/S8A6ogo"
    "7zjOrOd5Oautre2j7/sF27ZnCoXCvsrKypda6z2JROJ1HMcdyWTylda6vbq6+i2AjpqamrdK"
    "qd2ZTAZKqWcMAHK5XJ/W+lQ+n/ccx2kUQswppVYDmOCcZ4wxn4IgWC2EmIuiKA3Ak1JOEtEh"
    "CwCklLcYYzOWZe2zbfu1EGJ3KpUa5px31NbWvvR9v8N13RFjzF7Xdd8IIdqJaBbAEPsVR3d3"
    "N8VxXMU5r2eMfeOcNyqlxpVS6wCMSSkzWuvPWus6Y8wGIjrT09Oz/XcTtdblSilBRFBKQWuN"
    "n9GCiH5PFEVgjMEYc+/vDv23stlsRTabrQCAH5pLe5ziQpK+AAAAAElFTkSuQmCC")
index.append('basket_put')
catalog['basket_put'] = basket_put

#----------------------------------------------------------------------
basket_remove = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArFJ"
    "REFUOI2Nkk1IVGEUht/v6p2rt2kc5RpiZM70gxZTLSTsTyqsJCopmGhdEAXRMqpdRW2CWgUR"
    "LQSJFm1alIQSBYVETJSYLfrTfjTJuKN+d/x+zr3fbVMhgtULZ3POw7M5LzBfYrD9D5LxlluL"
    "CvMyAMrmOxxrWx61LtjDlrrZer91eNv4fdX134JzjzfFq91tbHnNdqQS9Uggbpxa9znzvU/f"
    "/afgyuMdcXbBZiyp3oAfwSiKpXEsSTWDsXDdj9zwkclH5upsvnyuIKLE1NDEM9sv+W7G2wgL"
    "FXj44Taef32FMrD0XN6au/gyer6t+P2C+3lqAICBZcUY9t+gM/cUGyvvLNx78tqavwo6s/Js"
    "XbkCQhuIDVgMlCOBkTcj8NgMtmZxdDbPBgcHr4dh2EZECMMwobXO5nI5dvlRHipSKIopzJDA"
    "2pnTYt/21sq+vr4ZIvokpQQRTVhEFNbW1jYzxpq11qccx2H9/f3P2tNnsd6cOHSg5hJ2sjMH"
    "Gz23sre392YymXSFEBebmpqapZRZVigUlhlj3k9OTi62bdvnnK+SUo6FYbiIc/6JMZYplUoj"
    "YRjWB0EwDqCOiIqO44z5vt9jtbS0fAiCYNq27dHp6endFRUVL7TWO1zXHYjjuCOZTL7UWu9K"
    "pVJDADrS6fSQUqo9k8lAKfWEAUBPT88DrfXhYrHoO46zUgjxTSnVAOAj5zxjjBkulUoNQohv"
    "URTVAvCllCNE1GkBgJTyBmNs1LKs3bZtDwgh2quqqgqc847q6uoXQRB0eJ73yhiz0/O810KI"
    "XUQ0BuA5+/2Orq4uiuN4Iee8kTE2wTlfqZR6p5RaAeCtlDKjtf6qta4zxqwmouPd3d2b/zRR"
    "a12ulBJEBKUUtNb49VoQ0Z+JogiMMRhj7s3t0H8nn88n8vl8AgB+AuFodtqolwGRAAAAAElF"
    "TkSuQmCC")
index.append('basket_remove')
catalog['basket_remove'] = basket_remove

#----------------------------------------------------------------------
bell = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq1J"
    "REFUOI2V0ktoU2kYxvH/uaUmTZNa29pqK+20VaszDHXlKIgLRcUbWmUU1zOLARdDVyLCKOh+"
    "QJRxdi4ERRActY07EakoqHht7cWkrU2iadP2NDk55zvn+1y1U2+I7+pdPM9v877wnfP6+sob"
    "L662it6zzdcAzG8WbrXW4FFjKTHu6lZXSI/uXByuIpUf3PVNYKh75T++z45AEvdUKBorq9RH"
    "+3JKU55WLKmerwKDt9vbpAieRuu2LYov34umApzRHrz0E+IRoQ2PT/114HTq5BeBoZ7WTsOq"
    "vFresI949Y84YxcICjlELovSolQ3LSGVzR8GPgaS3avrfSUvhpes21JRsw/LcHFSZ5Gug/Rc"
    "9PAilO+AWcXSCrNlrmcO/tfehuHfcYWsq2o+pFU27sabSGCP30U6Dn7JxZkuUhZShEyFChS2"
    "I+U8IDxxvrqtoz5Wu53AHUBkzqGLaZTwmJmwEQUPURKYlRoYJjKQTM/K7P+ArdrLyqtxC2/p"
    "671BKCSxVJQyIBa3GEnbGEphKA29fAWlmSKux4M5QC/a6mbm1TN83yMSaWHsVYxMNkJy5D3F"
    "2RItq6OYusRzBEGgmHyXx/eDf+eB9UeHf8/0v+1NPbrFip/XIopFftmzi46tv9I/LBl4Pklj"
    "iwVoBBIy6WL+yN9jiXkAYFPXmw3vhidfv7zbTf2qdjJDacKxCD+s+Yn7T/I8ejhFbY1F4Lrk"
    "bZleeHZ9btl2PLkq+yZ/rTDVx+DjeyQuXCY3msWUiocPbAaSDsJ1cEsy+kUAYO/J5P58bnq7"
    "PZFmaZNFY0eY/X9sZHNnE7WtUewpD88js7Dz2SceOJNMANqlLk6l+idP1C6roKGunEJWMToy"
    "i+/JxMK89imwcK4cxJhZ3HDMFxx1BYbyeayU8dufl1PJucwHhoBNh9ZYUGYAAAAASUVORK5C"
    "YII=")
index.append('bell')
catalog['bell'] = bell

#----------------------------------------------------------------------
bell_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAt9J"
    "REFUOI2V00toHHUAx/HvzOzO7nZfeWwe23Rt0yZpVmxrjIquImIsiVQtrQYUCqVXpadcFBGs"
    "IPTirUQMnjwIaqFgq0mrF61tQ5G2RFJiuptnu8mGfWaTnZ35z8zfUyqCofi7/z7wO/zgf2b2"
    "h55L0+e7xI1znRcAPI8s/NTVgkWLV4qsqXpHdDV0pDHQxGIp/fojgcx4z5e2zWuOS9SSeiji"
    "a1CXZ/JSkZZSq8uJbYH0lWS3K5ypUPugP9pxFEU6GMsTWCt3iO4Qyly2/Mnbny2e+U8gM9H1"
    "luZtOB/cdYxo7AmM+2M4m3lEPodUQsT2NLOYK70L/BtYGO+N29L9OtD81KvhlmN4NRNj8Ryu"
    "aeBaJmrAj7QN8DTRFvbs2+p50heT3Wj2r6Zw25s631EaEm9gFS5TzV7FNQzsuolRqeHTJbpH"
    "Ih1J1XDdh4CwxBex7r54pHUIx7yHWB1FFRWksFgvVBGbFqIu8DQooHlwHZfKhpv7B6jKpC8Y"
    "w9x8wMyNS+i6i1eG8AGRqJellSqalGhSQQ0+Rn29hmlxcwvQTg409jq20e9vTFAvC5ambUwn"
    "QLmYJRzUiHf42CjWueXE+b7Qxi8FnT81f+fOZyNK5trab9pX46WLw/3aoLFxP9HZnyI9Oc3L"
    "J4aJdexl6o+/qOXLzDUnmIn0kHr6eQaeGcLyFb352tIrwS4trAK8NDKfWpsrzt69Ok58f5LV"
    "zAqByA72Pn6AyTslfnzg48neQziqw6H4YRxF8NyBFCDfV7e2DH60sD83X7qwWZ4hffsal8e+"
    "Jb+cw+NK8htFvEqIN5OnARgZGGNf60EUFP9DAODomYXjpXxlqFpYoW2Pl0RfgOPvvUClusZ0"
    "9jpnfz4FwNkrp8isTSGRdWW7H3wzsvtTxZUft+4MMykEt3SV1MEX6W7v497qba5P/c7yfOXz"
    "bQGA74bR1ht3fWgLTk9qTnhWR3cUNAlVpBy9Obr6wd9Hj0nzjFSH7gAAAABJRU5ErkJggg==")
index.append('bell_add')
catalog['bell_add'] = bell_add

#----------------------------------------------------------------------
bell_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtRJ"
    "REFUOI2V0ktoXGUAxfH/vd+dl/PKTCZNJtMxSU1qAl3YZqUrRSHWV4k24iPg1o0odqWiVkEX"
    "btwUi6IIIi4kKNpqYn0QqVARFzYYTHWmZNK8hiaZydzM3Ln3u/f7XCXioxTP/vw258D/zO+f"
    "Hzw7PzUoL5wa+BTAum7hy8EuPLpCWq66ZuhE2Ezcm4llqdRK910XKE8ffNv3ORoo0p4OJ1KR"
    "DvPKwoY2tGe02nrmmkDp3MiQksFcomcsmi4cw9ABzpUZvLVfSN8gjcur9ZPHX6u88p9AeWbw"
    "IRHqmIrvHyedO4Sz/A5BcwO5UUUbCXL9nVSqtUeBvwOL08N5X6sPYp1H7kp2jRMSLk7lFMp1"
    "UJ6LGYuifQesLN1J66bdnlU6MzKE8L93perJDjxidBTvx9v8Cnv1PMpx8NsuznaLSFgTtjQ6"
    "0NiOUnuA9OTp3NDhfGrf3QTuH8j1tzDlNlp6NDZtZNNDtiVWhwHCQgWK7R1V/Quw9UgknsNt"
    "rrBw4SzhsCKkE0SAVDrE0pqN0BqhDcz4jbQbLVyPn3YB8cSdmeHAd0ajmSLtumRp3scNYtS3"
    "VknGBflChJ2tNk4lYO27JaqzJcJX7a7JA4gPL+sfxLvTtTMTo2LM2VkuDozeRunHeW6fnCBX"
    "OMDcz5dobdRJeQK53c2hY08y9Pgz9BZy8WazccfDqa2aAHj/XP29B49EHrNry53JzmG0Msn0"
    "JBGYzH47h3WpxuGJp4mVZzHOv0nIWSSc7TVXypXhvRnHXli8+bOX+SSRXhgvbVW4+LVNd183"
    "ltKYLUW0ZwDueXbvL9bJPEIb/cY/jzT1fP+YofVMvi9D8ZYCVuDz6xuz3PrAJPGlL3CddVqA"
    "3RD8VmblX8BuPjrR96qh9Iv7epNkGj5yXVHM+ljmMvZVn8V1EXht9dI1AYCPJxCNzP7nfMlT"
    "2TaJ+GbVCPs6qky9otCnj36jXv8THRZLAGMr4t0AAAAASUVORK5CYII=")
index.append('bell_delete')
catalog['bell_delete'] = bell_delete

#----------------------------------------------------------------------
bell_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs9J"
    "REFUOI2V001MXGUUxvH/vXdmmBnmzkxhRkFqKULBwRJsF36wMC40amzFfiRt07jUjemKRZdK"
    "jAuXJkRjF5o06opogrWgMSa1JsRqSVODbQlQxlJmph0+h5k79733vscVpCaYxrM9eX55FufA"
    "/5yZse4L06Nd3uRIx7cAoYcGLnZlUWTD4i25ZngoYiZe3xVrIr86e+ihwNx492e+z2uBJqUk"
    "kkg2pM07N8tiiDJqdZn4T2D2x9w+7QXXEy2vRFNtgxgS4NyZQBWukYp7xvzS2vvHP8wP7wjM"
    "TXQds8Lp0cbdR0hl9uMsniOolvHKJcRIkNnbTL60egr4N7Aw/mSrL/p8rPngS3b2CGHLxcmP"
    "oF0HrVzMWBTxHQg18agd6tzKhWa/y+3D8i+5nm5p6jhppB8/jFr+gcrSZbTj4Ndd6m4Es7Gd"
    "WDAHgVBxtN4CTE95n6Z2P92695mzRmNS4RU/waxNIZ5iY7nCetlBRzIknziFa2bQgWZ9U5e2"
    "G3gVyTU0ZnCrd7k5eYFIRBOWBA1AMhXmnpsg23mMZOsB7k/baHcNV3Flu0GtIt8Xb/yJ7yvi"
    "8U4WbyQpluIs/H2falUTsZuwM2mCjTEe6XubShUCrC+2gefOzL9TvHV3Mj91kT39T+HVajz/"
    "xiEOvHyC5XWb5txbUJ/iyvmvSKQdgsCip3tPdBsAeGHo9sC9+ZWZvy6P09qTozhXQLQi0z6A"
    "vauGdm+DaILN3+l4cYhAqQ9+/WjABrC2pC9/Xhs53B/tN9jMrRQK1Eol2g4OYukpxF/hsd4M"
    "omtE4g0Q7stuLP5R//ynwiXzwSMaHF44ulpef1XUJi373yRulxF/GQyLq9/MABpdnyHb3U6g"
    "1Lu/vNfba+x0yr99/Oxi3+mv2yxzAfFXAXlga2LFeihNX+PW2PDojr/guSp69dxRR7SgtQ5J"
    "ICERDYGIiFYiImgNWlr+AY5+V3NRobmaAAAAAElFTkSuQmCC")
index.append('bell_error')
catalog['bell_error'] = bell_error

#----------------------------------------------------------------------
bell_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtdJ"
    "REFUOI2V0lloXFUcx/HvvTN3lmaWTDqTfdomzdLYCtYNLViEqqlokKKCfbHPPvgUFNxAxeJT"
    "3oJLH1V80EBRQ5OUirRJEwpdRKgkNmk6SZtMMEOWyeTee8495/g0iksp/p7/vw/84A//M799"
    "3zV8fahDTg22nQYI37NwpiOHIOcYueTbTn/ETjyXiddRWJt9/p7A3EjX50HAs0qTFiaSSEVr"
    "7cXpVWMZYW17ZvSuwOzZnk4t1S+Jxt5YuuUFLKNwF0cRyz+T3iGtm0vr7790svDBfwJzox0v"
    "hpzaoZrWY6SzB3Bvn0JVVpGrKxgrQXbPTgora8eBvwO3RvY1BUZ/Ed/54FPJ3DGckI9bGET7"
    "Llr42PEYJnAhXEdDMry32gvP/tDTSSg470vdWNf2ilWb70OUxigvjaNdl8DzcTe2iUYMkbDB"
    "KEPZ1fpPQAr5abbzYFOq/ijKv4EsfoItNzBSsFkqIysC6UkGE7VUAsm7jmJjS6/8BZRNT7Qm"
    "i1+5w/TUMJGIxjEJokAq7bCwXCZkDF5M0Jq9jzcXr9KnzJUqEDpxJLNPBe5DsUweb12ycD3A"
    "V3G+jNlcqGguRyNMOWEaMl0caD7Eligzpgvd+b4dA4Uz28ICuDDQNplszjy+99Gj/HhqmN7X"
    "XuWN8W95ev8JlNEordAYihu3ydTUM3XzHFcWzmtt+XVhgMP984fGTpoZ3x/pauruoTi3jBcI"
    "lNEUSjeQOiDQEqkkm36ZB/JPsCW37UvzEyW7uqX3nVvdK/Nrpyvr08xeu4gXeAQqoCG1i8bU"
    "bprS7TihOLlkC1cXLzIxN/F7RfKw9c9HGnp7T69lzOhXu2x8IRBa4AWC9ux+Hmt/hssLk5yb"
    "OVsUiiPFj/n1X0A1X/fv/tDS5r365iStjXGOF65xf/5JJqd/KldC+pGlj5gBuCsA8M3LhDYz"
    "rW8FktcHWu7kfGNbB0vxw999tjVevfkD2wddzWNPGR8AAAAASUVORK5CYII=")
index.append('bell_go')
catalog['bell_go'] = bell_go

#----------------------------------------------------------------------
bell_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAulJ"
    "REFUOI2V0k9om3UAxvHv+7558zZLmrxJU5tm/bPGtmuoRXQXkUIGTtswhxQ3qcgQPXnozaMX"
    "PexQLyIMRfHkdaUFN03nrXjoFJRuUJj9M5J0ebNoapcm6Zv3789T1YIyfO7Ph+fwwP/M1jfj"
    "tzaXRp316yMrAIEnFr4b7cWmVxWOYcnq+0E5cjEeSlA62Hn1icBuYfwL1yXv+cRsEYxENV3e"
    "u18XkrClo45Y/U9g5/vsmO949yKpma7Y6deQhIe5t4pd3SB2ypEeGI8/vHyt9NG/Aruro68r"
    "qr4UHpgjlnwG8+GXeO06Tr2GkCIkz/RQqh28CZwEioWJflf4X4d6nr/Q3TuHqliYpev4lolv"
    "W8ihLoRrQiBBX3fg6eNeYOdmdgzFXbMcP5UYmZf0wUvY+7dpGj/gmyZux8JsHKEFBcGAQHiC"
    "pun7fwGO7XyeHHuuP/rULJ61jfPoM2SngXBsDvebOG0bp+MQ0CVQAvieT6Pl1/4GmiKrhZNY"
    "7Qr3128RDPqoIoIGRGMq5WoTRQgUISGHh+gcHmHZ/HQMKG+/FJ/wXPNcV3yQzmOH3Xsum/sD"
    "bDRepMIFNusJ4pKBgsvS9nlqwVfY88aGzk5kXV3X7ypfFQ5uXjmnzJith4MDz77AjW8NQiN5"
    "3rr6Dul0mmi8n7t7LuVmiotX3iOTGaWnJxm0bfvlYrGoSsdTbl8782vJio8/6JznjavvUrjx"
    "KXd+qZLqTzM1NUW1WqVer1M1KkS6o4WFhYX88vJyQz4GZj4onl3fsLcjkSgA4507dMwW8/Pz"
    "TE9Pk8/nmZ2dxTxqiVardRlA13XtxJF+LiqfBFPGx0Bk/WAQIXVYXFwkHA4D0G63EZKMqqor"
    "AJVKpSP9E5icnMxmMpnlXC6XGjqd0gLaqVCtVmNrawtN0xgeHqavrw/Xdf8ol8vy2traoxMA"
    "oORyualwOLySTqd7NU1TJISaOPyxHfAsftOnwz6ya9u2axjG7+12e+5Pj1lKlW6LVG0AAAAA"
    "SUVORK5CYII=")
index.append('bell_link')
catalog['bell_link'] = bell_link

#----------------------------------------------------------------------
bin = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAshJ"
    "REFUOI2Nk09LK3cUhp/fzGTCJJPBfyVSxCqJFhsTxFGQy4XWhYV0Uah22X6A3pUK3dXl3V1K"
    "QerWRbhwiRS6yxfIMgupghJMFgo3KzXEJPPvNzNd3JpW8EJfOKvDeXhfzjmC/6F6vf5zMpnM"
    "d7vdytbWVv2/PfGxof39/ZfAN/l8/vvt7e0FwzBot9tupVL53XXdP4+OjuoA6nPDe3t7PwC/"
    "lcvlb1dWVianpqZIp9NomqZZlvXi4uLiy7W1tbtGo/GX8hxA07RXOzs7uYWFBSYnJ+n3+3ie"
    "h67rFItFNjc3c6qqvgJ4AojjWMRxLJaXl5cLhQLj4+MEQUAikcB1XQzDoN/vY9s2MzMzKwAa"
    "QLVaVRVF+ezk5ORTQLcsy7y6uiKfz2MYBlEUIYRgOBwyMTFBrVZDCGGMALqufy6l/CWKoq+k"
    "lKbjOOLu7o7Ly0scx0EIgZSSZDKJ67rMzc3Rbrc/xK1Wq6bv+2+KxWI5m82SSCTodrucnZ1x"
    "fX1NLpdDCEEYhkgpkVLS7XbxfR8ARQjxdTabLU9PT+M4Dq7rYlkWGxsbZDIZWq0W6XQaIQSp"
    "VIpOp0McxwRB8AHg+/5P8/Pz3N7e8vDwQK/Xo9/vI4TAtm1arRZxHKMoCqqq4vv+U0AQBJ9o"
    "msbNzQ2u6+K6LoPBgOFwiGma9Ho97u/vR5vyfZ8wDP8FeJ53PRgMWFpaotPpcH5+Tq/XYzAY"
    "AOB5Hp7nEUURURQRBAFRFCGlHEV412w2MU2TUqnE6uoqlmUBEAQBYRgyNjZGFEXEcYyqqqRS"
    "qZEDtVarnZVKpaLjOF8sLi6iKAqKoqDrOo1GA4D19XUymQyapjE7O0uz2aTdbr8/PT39VTxe"
    "4MHBwR+FQuE727ZHVg8PD2PTNMWj5X8qCMPwvZTSrlQqt0++cXd390cp5WspZUdK+RCG4dvj"
    "4+Pj5/7lUX8DgHJnGQDeZkMAAAAASUVORK5CYII=")
index.append('bin')
catalog['bin'] = bin

#----------------------------------------------------------------------
bin_closed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcJJ"
    "REFUOI2l07+qGkEUx/Hv7s7s6qogV8E/VRKQSHLVC2kFA5JXsUidx8ibGEiTwtbK0kaIWGS9"
    "3GIV1yvqapBZd1IpKVZuIL9mmMOZD4cDA/8ZI6k4HA5fr1arL1rrT47jvBJCSMMwME1Tb7db"
    "T2s9KJfLXzudjieSgCAIflQqlXeu6zKZTACQUpJKpYxarfbmeDx+9n3/I/A+EQDqpVIJy7IA"
    "aLfbAEynU/L5PLlcDt/36wCJwH6/N+7u7tBa0+12UUoB0Gq1cBwHwzA4HA7mTWC5XBqDwYB6"
    "vU61WqVYLF5gHh8fmU6nPD09cROQUpLNZhmNRqzXa06nE1pr0uk0rutSKpXQWt8GlFI0m00a"
    "jcb1LqXE933m8zn5fJ7ZbAaAmQQIIXAcB4DFYoGUkjAMcV2XIAjQWl/3kghEUZRUxrIslFIv"
    "A+fzmTiOExGlFOfz+eUJLg1/J45joii6njeB7Xb72/O82LZtyuXyFdNaY5omm81GB0FwBLCS"
    "gPv7+wfTNO10Ol0oFArYtk0qlUIIgRACz/PUbrf7Nh6Pvyd+JoBer/cTeJvNZo3LyFEU8fz8"
    "HGUymV9hGH7o9/vhrff/nD9039Y0wLxRwgAAAABJRU5ErkJggg==")
index.append('bin_closed')
catalog['bin_closed'] = bin_closed

#----------------------------------------------------------------------
bin_empty = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqhJ"
    "REFUOI2lkz1IJHcYxn/z4YSMs7MaOHeJsNFm40bcqIMg2FyTwNlICtMlfRqxOSwSsTjShRSu"
    "vRA5kJWr7awVFAxaLewWJ9xWZsf9cGf+X5PmXHJwV+WFt3p5fzwvz/PC/yzrU4OdnZ281vrz"
    "crkcbmxsGM/zVKvVEsfHx70kSUStVks/Cdjb2/M6nc6PMzMzP9u2/a3W+gvbtvE87580Tf9u"
    "tVp/HRwcvAYy92OAh4eHnVKp9HJtbS03NTWFEAKtNY7jTPX7/e/6/f7q1tbW7P7+/iv7v4tZ"
    "lllZlln5fP7l5uZmrlKpkM/n8TwPYwy+7zM9Pc36+nrO9/1fAVyAer3u2Lb91cnJyZeAt7i4"
    "GFxdXRFFEWEYYowhyzKklDiOw8XFBZOTk5+NAJ7nfa2U+s0Y81wpFQyHQ6tYLHJ+fo6UEtd1"
    "EULgOA5SSpaWljg7OwPArdfrgRDij4WFhReFQoGxsTHiOObm5gaAubk5LMtCa41SijiOieMY"
    "IQQAtmVZ3xcKhRfFYpHhcEiSJIRhyOrqKrlcjmazyfj4OJZl4fs+7XZ7dA6ALYT4ZXZ2lvv7"
    "e3q9Ht1ul36/j2VZRFFEs9kkyzJs28ZxHIQQHwKklM9c1+Xu7o4kSUiShMFgwOPjI0EQ0O12"
    "6XQ6I6eeLB0B0jR9OxgMqFQqtNttbm9v6Xa7DAYDANI0JU1TjDEYY5BSYoxBKTU64bjRaBAE"
    "AdVqleXlZcIwBEBKidaaiYmJkZWO4+D7/kiBc3p6elOtVheGw+E35XIZ27Z5H1suLy8BWFlZ"
    "IZfL4boupVKJRqNBq9V6d319/af1lMDd3d038/PzP0RRNJJaq9WyIAisJ8nvW2qt3ymloqOj"
    "o/sPnml7e/snpdTvSqm2UqqntX59eHh4+LF/eap/AVVicNff8FRBAAAAAElFTkSuQmCC")
index.append('bin_empty')
catalog['bin_empty'] = bin_empty

#----------------------------------------------------------------------
bomb = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtpJ"
    "REFUOI1lk7tvW3UUxz/32rVv7OA0bRxbRYDUZkKkC+UZ0UQoW+jaETExIP4JJG8slRhQJQSd"
    "K5gIapCryCyhoiVSMdgJcmqckNgQObl2r+/j92SyFZSznKPz+Oiro3PgjFl7P2X37s78L7fF"
    "JQD1kI/sBpdslRl7n6lx3RkHyd6d6w78CM6OY00D7Hfpa4Matc/eNZpPreJFa/hFa173brFy"
    "DiD37nyOw1vW2rfD2PpS2dyM28jXHnfD5SsPpi5cXHGM30VFOz9bzT0M1anbtN0xwFga2tg3"
    "661Yf72hi0/28nnhvMTNqzu5C5ffdxwxTSou4YbFd4wkM3WbNsAEcG9Dv3A6ENnXrnnecbfF"
    "D5u/s/mojRl1McNDCCJ4HmETyVE/+0nwDWWAFEClUrnxz/HpF/XWsHB9Ic/TZ5bqwxqXX36P"
    "rc6rvHHxATJ+hpXPeeyX+PCr0vGXP81u9vv9oxTA0tLSx+Vy+dbWo23+7Ob4a/+IVqtFqVRi"
    "YfaQp4dXSITl2+YCOSfhMHmluP93tzsYDGppACHECkCxWKRarRKGIaurqxQKBX7ruQRBgf1/"
    "Lc1ejq32LNlsdjKTBoiiaNEYQ7lcZm1tDWMMUkpGoxGj0Yg4jvnjJE+SJCilyGazSCkXJ4Aw"
    "DPF9nyAIMMagtUZKSZIkRFFEHMfEcYwQAqUUURShlOKsgrrv+8tJkhDHMUoptNYIIYjjmCRJ"
    "EEIghMB1XYbDIVLK+gQQBEEtk8ksO47DaDRCSolSCiklQoiJ11rjeR79fh9jTG1yB77vr+/u"
    "7jYAjDFEUUQYhufkp1IpANrtdkNKuT65g06nczQ3N6cPDg5uzs/PZ8fyx0sDyGQyuK7L9vb2"
    "UEpZUUp9PwEA9Hq9X6enp087nc7VTCZT9DwPz/NIp9MopTg5OaHZbDaUUhWl1N1zzzS2crl8"
    "Q0r5gZRyRWu9aIzBGFM3xtSstetKqSdn+/8Die3TStGnNdYAAAAASUVORK5CYII=")
index.append('bomb')
catalog['bomb'] = bomb

#----------------------------------------------------------------------
book = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeZJ"
    "REFUOI11k71qVkEQhp89Od+XEBsVRSxMUCKIMelUUBC8ABGvwEIQSy/AiwlopVaKKFgYrCxS"
    "i4UQtIxFfsDknN2ZeS32RPLzZWAZWGaf+Xs3ATx4vrIo8zdCm5DuCCEBEtXp/wkvlH57/evL"
    "F1cAWoBwe0ri2tL1+bTxZxtp/xFUWKCAre2/7PUi1F5msBYAcW9pcS7dX77E3MUlVAmEomaN"
    "mv386VlmZ1ruPnzGYQA6s7Q4z8e1n2xu7qIIAGK/CgmF2NrZpeszB622ECm145arN+ZZuHAW"
    "d5CCCOEuPAILsdcVXr9dPQ4Qwj34tbHDuBnRdR2lz1jUe2OKdjTm3KlpQjoOqIMMzAt93/Po"
    "1kItvy4CSax8+UGZGXHk/VCBRPHAi2He8Gr1O30xzIVbYCRG4zHZ6lAnAsyCXAo5QM00aTSC"
    "RkQKIoLsiewnAqCYY53RF8c8KB6Dr3ASmLcoJgKG4L7QF6/tuMgDxFw0CSz75CFG1CwlV4CF"
    "yBa4ByVEKc4UDWVWk1sIiWyO9UZfghKBmyjhlDJoQU6xOGkL1KDstYUIzAIzYVa10CjhpqqZ"
    "iN+HdSBB03Dz9jJKCXdhLmLwGtSYsyFB7rrVoxV8/vTh25P68w7oH8GRn4l4t772/vE+4B9O"
    "lcycZa1hZQAAAABJRU5ErkJggg==")
index.append('book')
catalog['book'] = book

#----------------------------------------------------------------------
book_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl5J"
    "REFUOI11k82LjlEUwH/38b7vTFgw+WiEycfkY7xDydeQkix9/QcmJSWlbCzsWLBnFrJQrLBQ"
    "Fr4SwyRJEWayIFkQo7zzDmae+9x7zrG4zwjDqdO53e75na97HMDOIxe6LMoVwxrgegzDDDAj"
    "GfulKoHgm+8eXDy+GKACoBIP4FheX9nhhr80MZtwggRTTGGk+YNxb6hVFlFKBQBja71rodvW"
    "vYCF7XUsEVDTFFVT9NkzpjK1tcLm3Qf5E4DNrHd1cOPpGxqNMUwVAJ3IwgxTY2R0jNwX/C6p"
    "BHWuUqvQuaqDpXPbEAEzRdUQMUSVqMZ4Hrh89f5kgGGIKO+HR6llVfI8J/iCqOk+MoVKtcas"
    "aS2o2WRAaqQSJeC9Z+/6pSn9NAjMjAv3XhNaq/zlX2ZgRhBFQiRKxqX7Q/gQiWJIVCKOaq1G"
    "EVNT/wmIUSlCoFCwrAVXrUJmqFNUlUIchfwXACEKMY/4IERRgmhpE9zFJ3xoPmXRsiZt7aMs"
    "2FQ/fuv0y5MloHzsAz5IKkeMooTI+ADz5g6xdsUG5rd1cm/wGo9fPTyx/lD7jCyNMUUJRQIU"
    "URkPQhEEH5Wxb3dZs3w1kgmr23cgLrCx3gPYoWziwxRRiD7ig5IHIQTFR8F7ofH9M1U3nV0r"
    "DgNwdPs5lszpxuFas4keiBhSCD4kzUPEe6UolK+jDQY/PuLUnV4ATt3u5e3wCwzLy10wyDLW"
    "bejGnEPEiGJoaZ3fw+MXN+np3sL1l33UXIWB5/2AO+sAtu47c95gf9q83/4/BuWZ1n5oeQau"
    "wOAbZn1P+j4d+wm6UcsrZWpjSAAAAABJRU5ErkJggg==")
index.append('book_add')
catalog['book_add'] = book_add

#----------------------------------------------------------------------
book_addresses = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqdJ"
    "REFUOI1Nk79vU1cUxz/3vWu/2IlJjHGbIFxqA6naMtAoiKEKXSoxMGZBHcpQiYGd/4CpY9WF"
    "tUOlMFWoQyPUoa2IRIUoAleC/kidhICAEIId2+/5vXtOh/tCuHe451zpfu9X53yOWVxc/FhE"
    "bgAzjUajNBgMKE/eAQUAUVD1iQikKXS35b/rSw9aAFZVLxljWq1Wi36/T6FQoFbN3yuoA8EA"
    "0Nv1l2EhaJIvC5xtNBrMzc2xsLBAtVoB9n9V9I2bMCwyfnUTxoEro0fUm59ZEalOTEywvLzM"
    "36tfI45cYP+UPO714cvsIEsnfiDYfj47LLqKBUwQBNTrdeY/OANGUFH8zmP1qs6N+PHeFgDF"
    "gmHoqNk9u8YYQuvtO+1z5OgZQhthbcTqo5skSc8LqaIvnsFY8KYGqCppmrLz6iFjpWMc//As"
    "66u/Eg9eUoxKvH/8PO0/lghD4VDX8NO3kySJ++t72LbemsM5b/Od6SaD/haHj8xTrbUYjWIe"
    "r/3C0dZpNjq3UFEqjBGU4tnLQzRQVUSEJEkAmKo22Fy/TWgj7qx8w6D/lGebdylP1HEuQ/L2"
    "BUWDgVrgARHSNM3ByZAsRiQjTWJUMjIX47IRqgICPY33MMDuOciyDIDd7hMOHjpGebzGR59c"
    "IIoqNE98zquX/yAIVvvMm6vo62QnYtrX4G2Bzr8/c/LUF9z7/RoHJt9DJSWwJTYf/0ahWEUU"
    "KsG79MpbU9HAqVVVnHNexHlrTzZu05w9hzpHmg358/51CMHuUQZQKALhPgeqiktjxCVsrK2w"
    "1llBjSfRFHIqjaBAd7gOQ4BpzwHAzMwMxagLRvIJ8JOkRn3xAHGO1+WYT0/e+q7dbl9UZcqK"
    "yM1Op/MVwG7yFAHUa+Rd2XdtfH6j3W5fBDCGnf8BrRR3dVQ2UWYAAAAASUVORK5CYII=")
index.append('book_addresses')
catalog['book_addresses'] = book_addresses

#----------------------------------------------------------------------
book_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmRJ"
    "REFUOI11k8uLzmEUxz+/3/t733mNhXsIM4aRYcy4FEIpskBJ7CQrJVlhZWFhIfkL2JJZueRS"
    "E5kpExsLC0mSXEYkRhozk3nf3+85F4vnHXennk49Pedzvuec5yQAu45e6HTRK44PQ7LRcdwB"
    "d6LzH8c0EPKRN/cvnVwEkAGYyiESOrqWtyZDn0dwnwiCCDPc4OvIN2q5Y5610bAMAGdzV2dL"
    "sqV7AS1zu/BIwNxiVovZZ01tprmasWn3YX4H4NO6Olu5/eglw8PjuBkANqHCHTfn6+g49bzg"
    "V4slWJJklYwlK1ppnz0dVXA3zBxVR80Qc2r1wOWrA38DHEfVeDs0SiUtU6/XCXmBWLwXSmTl"
    "CjMnN2HufwNiIw3RQJ7n7FnXHuXHQeDuXLj3nFAt80d8Q4E7QQ0NgmhKz8Az8iCIOiqGkFCu"
    "VCgkNvWfABGjCIHCwNMmknIZUscSw8woNKHQ/wIgiCJ1IQ+KqBHUGj7Clw3eYPGLa6wZGuRL"
    "pcqUbemJ7f12tgFoPM4DedBYjjpFA9Lx+iYb8gd0HDhMU1sntSd3efbg7uk+f/4tjWOMWUIR"
    "AYUYtaAUQcnFmPe0h6Vb9lJ9NUBycR/Nr6+zsHVmSfFj2cSHKUSRXMiDEcxQcYIpIThTxj5R"
    "ndMGO4//rP3UXEqeLPzRA1VHC40lmCFiiDgizmjzDMYf9zL51hHy2kfGgbHRElriQ2MXHNKU"
    "teu78SRB1RF1rOFHVu3n6cNeWqZPIiuVGfssDH5M1N3OTSjou9P78GDcvF/+Pw4O/T6frbaa"
    "le/6mFGApel7w87v6Lcz3wEe9dEnQ0cEnwAAAABJRU5ErkJggg==")
index.append('book_delete')
catalog['book_delete'] = book_delete

#----------------------------------------------------------------------
book_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsJJ"
    "REFUOI1tk09oVFcUxn/vZf6kk2kmWmwU25n8K2rGiSioEFuhpdRCaUTqwoWgIIgrNeJSsHTZ"
    "RTcV7CKCYKHS2k1pKSWkhCjdqDUiqVWTDonESKKZzNCY99699xwXzxmU9sDlwoXzO9/h+64H"
    "8OnJi0W17gdFK+D1K4oqoEp8aeOIM5iwWh67dKYLIAEgzh7FY2Opt+DNL1RRrTdBDBNUYKm6"
    "zEqoiCY6eVEJAJTdpWLee7/vbfLrSmhMQFTiqRJPX9OWIdOcYNfeY7wKQFeVigV+vTFJpfIM"
    "FQFA6ipUUVGWas8IwoiXK15BPC+RSvDO5gI97atxDlQFEcU5xYlgRVkJDN9fGf0vQFGcE6bn"
    "a6T8JEEQYMIIK/G7pYlEMkVv+jZf9f9O00d9LB+qKMHsoUSdJE6wzhCGIft29MTyYyNQVa5e"
    "G2JH+jGvlQ6S69zKUnkDd38b+jJWoIpxgjMW63y+Hf2L0FisU5wVOtLX2be5SmtuF4tTd0l5"
    "Ea+3riX7Rj7XAFgrRMYQCaifxksmwVfeSv3JZ5sWaevaQzh3mVTGY3r8b6KV8GkQ/tv/AgDG"
    "OmxgCY3DOsE4YR03OVAsk+seIJj9Bj9lSWYLBIsTIE0f7hwcvu/HAImbQkNoHIFxrKqOsb97"
    "ilzPAMHsefykIap1MDNyg7MjrWwdHB4H8GMb4xVMFAPaatf4OP+IN4ufED0eoimlhLUCc2M3"
    "+XziAyaX0g0b/XpgIuuwoaXl0TAD+XmE9czd+RohYHlxPeXRO/zYfIInUfZ/cqDEgYkcvTpC"
    "77sXuHf5NPev/kE6v4Xqwhy/JI+SyaxGmcSJzLyiAFXwfbbv7OPe1ALRxM90bnmPlpYNPLz1"
    "gPH242Tbu7FWUIUoCBpx9AB2Hz43pHBEUdb+8wXbOtewfWMH01ELV8p9VEy28TNRfrr+3am9"
    "dcBz7R6pNArIEXcAAAAASUVORK5CYII=")
index.append('book_edit')
catalog['book_edit'] = book_edit

#----------------------------------------------------------------------
book_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnhJ"
    "REFUOI1tk8tLVVEUh79zvJrXVLQ0E8xL+eSalkoGBlGDhlIW1KRRQQRNiiYNgmjYH9CkUfQY"
    "9KBBEBU1iHJgz0FE1KWwKCJ6cL1Ses7Ze63V4Gh1swWbBRvWt36/tfcKAMYOn+0zL1cMK0Iw"
    "ahhmgBlpst9HxeHi0tT988fXAGQAVPwBAnr787ngy9cSZgtFkMIUU5gu/WQuNtQyq5mPDADG"
    "5v6+9mDrwCraW/uxlICapl017d7cUENNdYZN2w9SDsAa+/ty3HzyhmJxFlMFQBdUmGFqTM/M"
    "EsUJf0dqQYMgU5Wha22OzpZliICZomqIGKKKV2Mucly+em8xwDBElPdfZqgKK4miCBcneE3v"
    "PRVkKqtoWroENVsMSAepeHHEccz4SGcqP30IrPSUr28v8Vz28E/9vAIznCjiPF5CLtx7Sew8"
    "XoxQIsaartLRtZViYQKzbBkgXAB4ryTOkShYuISgMguVWfK1L8itHqW+dZDW5BGr6qf/BwDn"
    "BR95YidEXoickJXP9DBJXVMDMnOdtoG9bGt7RUW4CKB4UVzsUoATnBPy9oC2vp0QPePRuYvU"
    "NszRXfuBoba4HKCaWnBJCki8slwKrGsJqGucReMpMEV+PGbNlqOM54tMnBqt+wMwI/GCjz2x"
    "UxKXMCS3aWhfj84+x3SO4V09aPKJ6uoCg5t2AdGRshmIGJIIsRM63SQ9XYPU1H3D/HcIKnh6"
    "rQAoGhVo7s4hSXLo/ol8fn4XDMKQDRsHsCBg+ONdmvOnIXxHWN8MGCP7dvx2XZHtoGPbsRWv"
    "r588Of8PuHPrxuT+dPOM4d4SD8/sxtQw1bIcqJfAJEEV1Fb+AoPDoIDwy2OgAAAAAElFTkSu"
    "QmCC")
index.append('book_error')
catalog['book_error'] = book_error

#----------------------------------------------------------------------
book_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI1lk8trVEkUh7970x2NisQQMaIm+AI1dhDEB+rIuNCdiPgHuBBkFsMwuHLhXkGX/gEB"
    "Xam4UVHwlZiIDuosBKP4QGLAiEGTTtrOvVXn4eJ2S9QDRRUF5zu/80oADv7b3+uilx2fhGSX"
    "47gD7hSX/zimkZhX3z+4cGoNQAnAVI6TsKGyqSf5PFHFvekEBcxwg6nqN2Zzx7y0moaVAHD2"
    "Vnq7k319q+heXsELAuZWRLUi+tL2BSyYX2L3ob/4GYAvqfT2cPPpWyYn67gZANZU4Y6bMzVd"
    "J8sDc61IwZKk1Fpi/eYe1i3rQBXcDTNH1VEzxJzZLHLpysDvAMdRNUY/T9OalsmyjJgHxIp/"
    "oYVSuZXOhfMw998BRSEN0Uie5xzevq6QXzQCd6f//ivi/DK/+DcUuBPV0CiIplwcGCGPgqij"
    "YggJ9fQkH8drkBz7CZA2ASJGiJFg4Ok8knIblNuwchvW0komgZWdG2nvO0/SYr8qgCiKZEIe"
    "FVFjKvyDWSSYEERY0bGejV07mMm+8fXgEJ1Hli4a/Hui1gAYokbMI3lUohpigf29R1E31BTD"
    "+Vgdo7JyN7Uwy7MPg9WtZ+hotLFIIYYCIOZkGlA3Rr+8IZogFokamc5n2LLqD2qxnv73fvhL"
    "qTkwQRTJhTwa0YzMMkSFZYu7EVPUjfHqBzoWdfH/2EOG3w1PBOXAjxqoOhq0SMGMuuf0PzpH"
    "sEAmgbWdm9i55gBPRoe592JQs4Q/P51mpLELDmnKth19eJKg6ohexdQRdVyd62N7SNI2hl4+"
    "w55sv/bp7tDI3C7cvnXj8bFi8+bMPw6Nd221cv/1AO3jJ+48v3v2cLON3wFZNdgPkh5AUgAA"
    "AABJRU5ErkJggg==")
index.append('book_go')
catalog['book_go'] = book_go

#----------------------------------------------------------------------
book_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqNJ"
    "REFUOI1lk8tr1FcUxz/3N79MJDaNTRMfRRNtoymJExWrrQ8qLgKCL7pvcVEJLlyULsW/wa1b"
    "RReiyUbR+KBG0ooKASHgo6kSI4qYDpnJmMz87u/ee46L3yREPHA5cLn3c873PAzA4T/O9aoP"
    "VxQtgdmtKKqAKpnTxSPB4ezs5OiF098CxAAS/ACG7ws9nWb6/1lUFz5BBhNUoDw7T80qovEG"
    "6hYDoPxc6O0w+/vW0bGmgGYERCWLKln09hVNNC2L2XP0BJ8C0K8KvZ0Mj72gVKqiIgDIQhaq"
    "qCjlSpXEpiy1TIIYE+djNm7upGtVKyGAqiCihKAEEbwotcRxefDe5wBFCUGYmq6QjxpIkgRn"
    "U7xk954ccUOetuWNiOrngKyQgg8Oay2/7OzK0s8agapyfuQZ62uDnPphgsFqiaejSzNQxQUh"
    "OI8PERfvPcU6jw9K8ILH0OdH2La5QkvPn6z++gzHNn13YPuplzcXAd4LqXOkAho1YhoaIFLE"
    "CJuSEfq7Jmjp7md+apjWld1EFTs0fFKP1wHgfMAnHusCPgguSN0rHdF/rCgcJFSfsKxtLUl4"
    "wzf7tjb5uZmzdUD9sXVYFzI5QUnrkPe+FVd6RZQrYqJ58l8WIaky987m6m3MJLg0A3hRUi+0"
    "+UkOfHGL5mZF/FsiKUPUjLqU55f+TZ5NzA7ECwOT+oC3HusEJ0K3f8SO+B+27O1H09uY8IHx"
    "GzXSUhkjjtdT5V9/u/R6aLEGISghDZkEEX5qeczWfYdJi2eJ4xbG76bc+XCI0amY4ov7bx7/"
    "/WBoyS4oRBE7fuxDjSEEJU8ek3tLrrGd8dtz/DV/hJn2XdiXY5Rr7u6nk6jcuXn94e/Z5tXn"
    "f7XDFu9TmbFceN7DhDMoD0C5Ojl27dgC4CM+n9Eb/WEBrAAAAABJRU5ErkJggg==")
index.append('book_key')
catalog['book_key'] = book_key

#----------------------------------------------------------------------
book_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq9J"
    "REFUOI11k1+IVHUUxz+/8c69m+OfnVSGXdLBUijX0TcDS6kIISJEQdoKRBAkpIcgfBB87GXF"
    "IkJ86kHIp/Kht17SpHrYoBWEsNxVdJbde5sda2Z17sz98/ud08OdlUo78OMHB87nfM/3/H4G"
    "4K0PL06odV8r2gGzV1FUAVWKSx8dcTl5unz3hy/PPAvgAYizJzA839hRN0vtZVRXiqCACSrQ"
    "XY4ZpIqot5VheAAo+xsTW8yruzazZayBFgREpegqRfdNo6tZPeLx0sH3+TcArTYm6nz7y206"
    "nT4qAoCsqFBFRek+6JOkGf+MYgQxxvM9tu+ss632NM6BqiCiOKc4EawogyTnq8vXHgcoinNC"
    "c+kBfqlMkiTkaYaVIm9ZhVf22VgJENXHAYWRgnU5aZpyaM+2Qn6xCFSVi9//Tj5S5j/1QwWq"
    "5E5wucW6Epeu3STNLdYpzgoWQ9n3yWxh6hMB1gpZnpMJaCnAlMtQUsQIIkLmDJn7XwDk1mET"
    "S78/IF64yfqsxdbaRu7MR8QbdkNQ4eHdad55sUZzbIL2zpOn5ubmLgwBgnVCNkiYv36F3eNP"
    "8fZ7R4njmOcWFrjy488kuop3jxzGL3tEUcTMzMzZZrO5abjGYoTO/C22Vx6y77U3OfXxZ/x1"
    "71fGx8ZoNBpEUcSnn5wjDCPw13D6ow9oNpsnvJUHk1lHvDTPul2bARjZ8Qb932aYnJykWq3S"
    "6/Vot9t8fv4C93sVAEZHR4NHHjinGK9CGLUA6F7/BlCmpqaoVIqCOI4pGXhmbZ4AI4uLi8nw"
    "LyiUSux55XVu/3SZq99d5fCBlwm8fbRaLWZnZwmCgHq9Tq1WI+4PzPT0dDcMwz8MwP5j579Q"
    "OK4qkHVZ07vBeG0DQeBjgFuddVj1eaH6JwaRPEsHYRi24zg+9Ddv2qO4G3uCcwAAAABJRU5E"
    "rkJggg==")
index.append('book_link')
catalog['book_link'] = book_link

#----------------------------------------------------------------------
book_next = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAldJ"
    "REFUOI21ks1LVGEUxn/KHcNB5yNpVDAi04UimWmLalrowqIghP6AIAqqRS1aBoWraBFBi2pR"
    "tggkEBdCCUYh4ibLr9TK1KExLMGxFuOM3vue83pbWEOiu+jAsznwPOcH54F/nLyz9wcbRYTO"
    "qy0jAG23njeKCDmtCiKrDD24PLJtwPXOd75nhP7B4YvrwOGDNQ/xLaqKiqCqTCUWCQQLm1YW"
    "FyY/drWbTQGu6/p9o/M8ejW9aNVwobWu/OShyk1XGs/fo6ioiHTG21N9tPdxwWL4VFd7lwFw"
    "RkdHaa6rY+9Op7y4OMTu0ijj4+NYa8lkMsTjcYzxEFMArotxJb5S+P0DUA2Qt7S05KdSKZLJ"
    "JLW1tcRiMW5OXAPAqkVFEaMYTzCuUGB2YIwwPTMzMXz7fb0zOztLOBwmnU7jeV4O+0jJMey6"
    "Rdc1J7GWH6s/EatkMtn9mUvZofyqqioAfN/Pma1axArGmg2pwVODpy6eehj1MCKop+LMzc0R"
    "CoVyZt/3UVH651/nsI1r8FyDcQ27ImWkllLMfEqMJzqScaeyspLl5WV8389RtB+4g6qSTqep"
    "qKigpPkK4XCIwrKhtmTh8DPx5GuiI9kA4ESjUYLBIJFIhEgkguM4BAKBTYGqiqrybbJmrKJ+"
    "YaBgJXj6D7HTcO4uYoS2eA2+7/O09w3yu0D2t9HajW+4rDHX8eXE3x1xmhrqAOgeeIuKcry1"
    "edvO9/S8gLWte2d4bAoxQllpDGstfS/7tyVYtxbI3xKQB7DvTPuTbDbTYlUJhaOfE903WrfF"
    "+B/zC625eTTAVzayAAAAAElFTkSuQmCC")
index.append('book_next')
catalog['book_next'] = book_next

#----------------------------------------------------------------------
book_open = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhBJ"
    "REFUOI2lk89LVFEUxz8Td8yGnBmTsnSKfviIRGph7QZCIYNoIfQvuGoTtGoVtGrfxkULF0E7"
    "F0IFtol2FhqSbVQEbRYFI4SvUXz3nPNui+c8FKaVZ3nO/X7P55x7LxwzCgBTrxdG84yAIIgI"
    "b5+MLwFMvnw3KpLlRATZE0T2+DL9eKmQiQuLl/pKpKlhlpKakXhh6/efm957BvtOfycYqoqK"
    "oKr82PhFsXTqtgtpukjhBM8eXs8h0jRl/tsWqz+b86bKvVs1Hty5egR9dOoVXcXiogMwMwBW"
    "VlYwyzqNjYxw5Yy70NNT5mJ/L8vLy5gZrVaLer2O9wniu3AAqgpAFEWYGSJCo9GgsbnJ8PAw"
    "SVIiiiJEhDiOAfBJgj/ZhQsBVASAtbU10jRFRKhUKsRxTJIkeU1VabVaDAwM4L1HvMelpsiB"
    "QRRF2aJUaTabhBDymYeGhlBVdnZ2ssvyHhHBqSriPSEE1tfX8x2Uy+Vc3K61CWq1WmbgDxkc"
    "JvDes729TQghp2gTtHcgIqh4nEomAOju7s47lkolqtUq1WoV5xzFYvGIYXtUJ+LxScLdpzOI"
    "F0R8jjdZv0EIgTcfFrKOqtiB0MxQUZyIcHnwbMd3Pvv5KyrK/YmxjvW5ufe4/f19NuO/B52P"
    "EpzvP4eZMf/xU0eC1Cz7TJ3i2qMXM7u7rXFTpVzpXd2YfT7xv7PHin/ZG4/t2teD9QAAAABJ"
    "RU5ErkJggg==")
index.append('book_open')
catalog['book_open'] = book_open

#----------------------------------------------------------------------
book_previous = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2lk09IlEEYxn+r36op2mq0q+SaqRCKVihBgUEKGUSFIHapY6WX6OClQyWdOnYtPHQI"
    "tBIhoj/YRSJICytTO6gEbocg2vyz7ur3zbwzXwdzxT8E0XOZmWd4nnneeWfgPxHYTLQ/nszq"
    "P1erLvaMNKRJDRqN1preq80fAFpvP2vQWm81uHxvtNJmSAgCo2W7crHWYIzFGoOnNENvRjst"
    "cLS++i6+wVkTdk+2ZyWXip4vTsgN39phAhlcO70/bWytZfBjjKlve7uNKE4cLOXU4Yp1g9RS"
    "0RcjtnRtbYwBYGJiAmMMIkJTbS37ipyS/PwCopFCxsbGVkvoetvxuTi75ICIEJuPoTxNciGF"
    "5yqW5pN4riK5kKL3Uj+zs7PU1NQQDocREZyu4c53kWDkQHleBWKF0rwyxArLykVbzYp20Ubo"
    "63uI7/skEgk8zwNgenoax4rREhCUUYgVxAjaCp7x0EbjibfKKQHA9/30vVRVVeHcOdbT2PHy"
    "wqfU8vKhnMwdxH7E+Dkf3xBdeRrRskHs+z4zMzPrbTz/qG1KuapMEnVXstXxnsWFRZ5cP4vr"
    "uogISini8Tjj4+PU19cTjUZRSq13QQUy6rwV72nmYuOkOKsCgJycnPSJubm5hEIhQqEQjuMQ"
    "DAa3PqQz3QNHMpzM4blfc2it0Er/GVfnrY3V+L7PgxcjaK3XE6RrI/hda4/yPbs3bwEw8Po9"
    "ooWTLU0AWw1c18X6HrOJpW0TFEfCGGMYfDXEtn/hb6hsu3U/lUo2GxEKdhZOfR242fIv+m3x"
    "GyNqZPqcnASUAAAAAElFTkSuQmCC")
index.append('book_previous')
catalog['book_previous'] = book_previous

#----------------------------------------------------------------------
box = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcJJ"
    "REFUOI3Fk71qlkEQhZ83voVIiCQmxC8JSIxYiBAbvQYbIYWNjY1g4Q0Iol0KL0BBsBdsbaws"
    "LETESmwUgpDCXzAE1Hw/O3OOxb5fohgrCxeG3Vn2zDnMzoH/vRqAO9dOTU70d+7R6AJqJgzI"
    "IIwNdt1Vk++J715/8GEdoLl/ZWkm1G5M945Nz/aWoWmgA8n8EiYFJQpf379j68vm+o2HH2+1"
    "oQMvjiwuT88urPDp7XPK8AdKSEPKhCBsJChhpuaPMzW/Qoib6xd9uhWeWz17jpdPHtH/tlXB"
    "HShkMiFkSkKk2N54zcxgxImTq2x93lxrbZhbPMra5atoOMAKFIkzyUgcBUWgMj4nKsHE4R6v"
    "npnWBofob79Box0UQkW1SEmiCJXsQqjUYpOHlpChrc0RLkkOsjJEolGSITTqwN2dQmTUO7tT"
    "oJJoGOQwUAlyly27XLiMgZ26yKrAGEWSg0IZlH3lZhFOoVGgNM6qZFeBRyKGQfbLX+SqMkYt"
    "5HSNcQ9UkuwHORjtLzeFUjiEx5PVTWlrQxZxcPFM/YE01t5jq2OUwf7NB8Y0ty8tPMbNeWlv"
    "3qsX/vSBDa5IjLF4+s9u/Al21vbDVSQAhgAAAABJRU5ErkJggg==")
index.append('box')
catalog['box'] = box

#----------------------------------------------------------------------
brick = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAntJ"
    "REFUOI2lkz9ILHcQxz/779TD271FOPGp6VQk2Fnb+eCRUlI8CCkf+ITYhtcnkCa9NgELc4de"
    "ldrGziouKiIXZaOnIHjuLXp67t5vJpXHe8ZU+VTDzBfmO8OMxSvs7u7+3G63v0+S5A1AGIZX"
    "5XJ5Y2Fh4dNr+i+o1+uVWq2W6QtqtVq2ubn55qXeeu6Ypun7JEm+AuwgCJiammJmZgZV5fj4"
    "mLOzM9I0BZAwDM+DIPi976harXY/7xbHsW5vb2sURRpFkW5tbWkcx184qlarXQCnXq//5rru"
    "vKoyMjKCqnJyckKv1yOOY66vr/F9H2MMY2NjiAhHR0ekaeouLi7OuCLy3dzcHJ1OhyiKcByH"
    "y8tLlpaWXu6GYrFInud0Oh3K5TKtVutbG+iMj48zMTFBEASUSiUqlQqNRgMRQURoNBqMjo5S"
    "KBRIkoQsywjDEFXtuKoKwODgIJ7ncXd3h+d5pGnK4eEhAHmec3t7S7fbxfM8AFQVVcUVkX5C"
    "RBgaGmJycpKHhwdEhJubGx4fHymVSriui2VZGGMwxiAiuMaYIdu2UVXyPMcYQ57nWJaFiNDr"
    "9RgYGOjvIsuyfk1EBm1gd29vjzRNKRaLOI6DiPA82nOsqjw9PeH7PrZtc3p6iojs2Z7nfXNx"
    "cfFhZ2fnr/39fSzLwvd9XNcFwBhDlmUUi0WGh4eJ45iDg4O/W63WD4VC4Z31bG1jY6OS5/mq"
    "qn6cnZ0tT09PY4yh2WxiWRZXV1ecn5/fq+q64zi/Li8vX/ZP+XPW19e/Bj6p6vv5+Xmr3W7T"
    "bDa5v7+v93q9n1ZXV//81y+8xtra2lsR+VFECsAvKysrf/yX9n/xD16Kioq/LFKkAAAAAElF"
    "TkSuQmCC")
index.append('brick')
catalog['brick'] = brick

#----------------------------------------------------------------------
bricks = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtdJ"
    "REFUOI2lk01oXGUUhp/z3b+ZuTNtE0ubdDpQaR2bCaONllSQ4koEN4rgyoWgUhEVofsw1J2g"
    "YDeCQheFrrKsG4tpwErBiFbiD9ZixpAEa/Mznczcn7lz73c/FzEUIq58l4fDc855eQ/8T8ne"
    "wnetVinKw6kkTI6d3A6umKC70+jv4/Zo5VXPKSyVXP+H0xcuRAD2XoAa9Ocbg+yMSRJyk+M9"
    "/ChkGUlng1Oxviw6ZVn3FoCnANReQHl1Zdqt7KM8OQWuQ3/5Dv21NrgO5ZOP4foVysu/T395"
    "/u06gN36tFUKk3Aqy5Jj3hG54s62UfU64bffIKnm4NPPAtD75Xv6P91CpzElUZIruwRgp040"
    "P1ItnElSxTBLEKVw9o8ijUminxcJ27dBDFkQoRyFEgvkweJqW+5Pl9wSJw4fx1YOYu34alAU"
    "J5rYR2tknQ7KUciu5yZ/ABiSyONHn2Qr6JAZzVDZ9K5dBQST56A1xpidyUAa9Qj10MwVH3mo"
    "1bpasi2x8AtlGkeaVPd3mX/pABM3lqnd+AL/wCGKk00s22U4iBnE26yMHOar+suSjVTnNtdX"
    "F2wRRZalDLMEz/Eo12p8fnaTwuJpnv/zJtWb19G54a9ikbn6c6yMTTJx/BDZ/ZB2YE/bSotZ"
    "798TbTRaZyQ6JTc5izLOE2++z7VfV1nrJDTq4/gAS+v81t5gkKRYblFsp1t85vrC/CwVM9as"
    "NfE9H9tyUUooFzwaJ6rUwoQ/NgJ64ZAoSbFFULaFUv9E2Rgj711897XYCS86FeUbk3Nv6UXO"
    "vXCKrX6MAqJhxtc/rkFuEEsQUXS78U6URcQAl4BL5z88d3CrnwW2pNHdTiAGIdeaQZqjtcFx"
    "LIzJCfoD0jgy/3qmXb0x88nZSJdmc290bKoxTrnocuvOOnEypN+NKOTdzYqJXvlPwO5pb818"
    "9non8z6mMOpnuYZ4O66oYObyB+98BPA3aMRFSJfpxxsAAAAASUVORK5CYII=")
index.append('bricks')
catalog['bricks'] = bricks

#----------------------------------------------------------------------
brick_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuJJ"
    "REFUOI11kk9oHGUYxn/f7Eyy+TO7O4lskibxoIQosq3CWkor8RBWBEUPi4GCGPTgodCTl9CL"
    "t9KL10IiWPCQ7pIsUgiCQhCCCBb/ZCQhTXZJt8aUTUgyO91uMs7s932eGuxaf8eXh+d53pdX"
    "8AxWVlau1+v1jzzPOwPgOM7DVCr19cTExLVn6Z+iVCqli8ViqNsoFovh/Pz8mXa9eJLo+/5l"
    "z/OeB4xkMsnY2Bjj4+NordnY2GB7exvf9wGU4zh/JpPJ26eNCoVC8O+0arWqFxcXteu62nVd"
    "vbCwoKvV6lONCoVCABArlUq3TNPMaq3p7+9Ha83m5iatVotqtcre3h6JRAIpJUNDQyilWF9f"
    "x/d9M5fLjZtKqQ8zmQzNZhPXdYnFYuzu7pLP59tvQ3d3N1EU0Ww2SaVSHB4efmAAzeHhYUZG"
    "Rkgmk9i2TTqdplwuo5RCKUW5XGZgYICOjg48zyMMQxzHQWvdNLXWAMTjcSzLotFoYFkWvu+z"
    "trYGQBRFHB0dEQQBlmUBoLVGa42plDodKKXo6upidHSU4+NjlFIcHBxwcnKCbduYpokQAikl"
    "UkqUUphSyi7DMNBaE0URUkqiKEIIgVKKVqtFZ2cn9/Z/5d7+bzwOHhH8fUJm+ALdaiAey+fz"
    "b/q+/0JPTw+9vb1IKQnD8HT/RqPBWu1n9sU6l7LnmXz9bQJrn7sPvuOv2sOaYVnWOzs7O58u"
    "Ly9XVldXEUKQSCQwTRMAKSW/PPiBV186hzQk54ZySBFxIXORiu8+Z0xNTYXT09NfGoZxqVKp"
    "XF9aWqpvbW1h2zZ9fX04jsPBoz0s0ct7L18F4LPJOV5Mn0Ug4qL9t+fm5l4BrmmtL2ezWVGv"
    "1/n8zie8/+4kLRQzuVvc+P5j4rFObn9zJ/iPwRNmZ2ffUkrNKKU6vr3/1W58sDl18ewbjA2+"
    "Rrn2Oz/98SM79/0v/tegnfNXBm8gxBUBtoYGWt+8e7M28w+rNJghLvXdJQAAAABJRU5ErkJg"
    "gg==")
index.append('brick_add')
catalog['brick_add'] = brick_add

#----------------------------------------------------------------------
brick_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs9J"
    "REFUOI11kU1oY3UUxX8vea9NI/l4RlI6bUZF0lKGbqQL3RQRK4igaB2GirhUmI1Lh1mIq1m4"
    "dCPtRu2ik9BGFzIIMgXpDEJRJJHWWuKUR5uMU6Zt8gz5fPnf6yrFqeNvebmcc+49Fo9hc3Pz"
    "Rr1ef79Wq10AcF33fjKZXJmbm7v+uP1HKBQK6Xw+39Nz5PP53urq6oXz+9bA0ff9xVqtdhEI"
    "JRIJstksU1NTqCq7u7vs7+/j+z6AuK57kEgkbp4lyuVynX+7eZ6n6+vrWiqVtFQq6dramnqe"
    "90iiXC7XAQgXCoUvbdueVVVSqRSqyt7eHv1+H8/zODo6Ih6PY4xhbGwMEWFnZwff9+35+fkp"
    "W0Tem5mZodlsUiqVCIfDVKtVFhYWzv+GaDRKEAQ0m02SySQnJyeXQ0BzfHyciYkJEokEsViM"
    "dDpNuVxGRBARyuUyo6OjDA0NUavV6PV6uK6LqjZtVQUgEongOA6NRgPHcfB9n+3tbQCCIOD0"
    "9JROp4PjOACoKqqKLSJnAxFhZGSETCZDq9VCRDg+PqbdbhOLxbBtG8uyMMZgjEFEsI0xI6FQ"
    "CFUlCAKMMQRBgGVZiAj9fp/h4WGsX7/D/PwN/b8OEDeF9cI7SHQ6YgObW1tbr2SzWeLxOK1W"
    "i263y+A0ESFUvEW8+hOT715l+NlLtH/7gd/v3sZVrxJyHOf1w8PDDzY2Nv4sFotYlkU8Hse2"
    "bQCMMbTv3iT70ttE7v2I9fUi0f1veebik6T++D5sDWpaWVlJB0HwkapenZ6eTk5OTmKMoVKp"
    "UP/4RV7+LI/1/FtntdY/HeOXO8d6JjBgeXn5EnBdVRdnZ2eter1O9/MrzL3xJk8c3KLbfkAL"
    "aPwdZvce1f8IDFhaWnpVRK6JyNBzxa8OXKldzjxlbDtUofGwj/cgbHod+eR/Bc5z50rmWuvk"
    "/ochsZ6WkFYF/eK123LjHwq8nZtkNfZpAAAAAElFTkSuQmCC")
index.append('brick_delete')
catalog['brick_delete'] = brick_delete

#----------------------------------------------------------------------
brick_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAulJ"
    "REFUOI1tk11oW2UYx3/nK0tCltM0GsxKV9taIow4BC8EWRG0MCl40ykMppdCb4yIIOxKbwRv"
    "vPBGQUWoUBPb3ImIo4rxY3To2mCzGLqkpy3pGmeWnqY5JuecvK9XG13o7/Lh/zz/h+dD4QQK"
    "hcIHBwcHr7darTMAsVhsb2hoaGF6evrqSfqHyOfziVwu58oBcrmcu7i4eGZQr9x3tG37cqvV"
    "OguopmkyNTVFKpVCSkm5XKZWq2HbNoCIxWI7pml+/aCjbDbbPe5mWZZcXl6WxWJRFotFubS0"
    "JC3LeqijbDbbBdDy+fyXuq4/I6UkHo8jpaRSqeD7PpZl0Wg0iEaj9Pt9kskkQghKpRK2besz"
    "MzMpXQhxJZ1O0+l0KBaLaJpGvV5nbm5ucDZE5S20rWuEImkmWj+j+Ode1YHOyMiI6TgOR0dH"
    "KIpCIpFgc3OTyclJAKrVKhPxGsPdJqH0FczxpznYSnH4w1eqLqUEIBgMYhgG7XYbwzCwbZuN"
    "jQ0A1HaBsUc7RMznuFctE1BcTkcfw4wnFV0IAYCUEiEEoVCI0dFRHMdBCEFn/yfGH2lgTlyk"
    "dydLIKywvf43rq+y9t+TbbXf74dUVUVVVTzPw3VdPM9DURRo32A8voM5OUt37zMUo4UROY3R"
    "26c3NktHBgMqUFhdXcW2bcLhMJqmIYSgvfMjJiXMJ16mW/8E1fBwDx+nUVijkbzM7X0HIcSq"
    "ahjG7O7u7hsrKyu319fXURSF/r83CPpVEudmcfc/RwtIeodjNH75k1vmJW7WWtvNZvPNQCDw"
    "knJ/TQsLCwnP8zLc/eOtZ5+KhX0lQXz4N2KJAF17lH+u/8V1/4LjKJFPNU37aH5+vv7glI/z"
    "zYcvyFfmv6CSfYc963dOnT1Pr+lQjzx/7R7D72YymbXjen2wQGXzju+WvtXHz1/Avttk62a5"
    "709cfPu1zPsfn/R82mAgHvaubtdK+EdN0TvV/1WT/ouX3vvu+5OSAf4Hy0CHMaBdAToAAAAA"
    "SUVORK5CYII=")
index.append('brick_edit')
catalog['brick_edit'] = brick_edit

#----------------------------------------------------------------------
brick_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs9J"
    "REFUOI1tkk1oIwUUx38zk2k+NJmM1dim7YJgN1s0guyCCEtZD1XEm8WD+HH04EUQRNCD6MG7"
    "1yK4RKwJbUB6EqGCFcRs2SWRllpiu4NtxayE6ZjGZmcy73nQrru1f3iH996f//s0OANra2sf"
    "Hx4evu77fhHAdd3f8vl8ZXZ29r2z+PegXq8XarVaqKdQq9XCxcXF4mm+cVIxCIKXfd8/B5iO"
    "4zA9PU2pVEJV2draYnd3lyAIAMR13V8dx/nyTkfVanVwdzXP83R5eVlbrZa2Wi1dWlpSz/Pu"
    "6aharQ4ArHq9/lkikbikqoyOjqKqbG9vMxwO8TyPTqdDLpcjjmPGx8cRETY3NwmCIDE3N1dK"
    "iMir5XKZfr9Pq9XCsiwODg6Yn58/vRsymQxRFNHv98nn83S73ZdMoD8xMcHk5CSO45DNZikU"
    "CrTbbUQEEWHnpxUef+AHkokI3/cJwxDXdVHVfkJVAUilUti2Ta/Xw7ZtgiBgY2MDQ0NS3W94"
    "6NwVvJ2vsVOXAVBVVBVTRO4ERIR0Os3U1BSO45BMJom73+MWnyY3/iTpwQZJ+QOAOI4REcw4"
    "jtOmaWKaJlEUEYYhURRhGAYy+J2R3jrZB/PEf64wVn4N2/8OiYcn46VMYK3RaBAEAZlMBsuy"
    "EBFUBb31LQ/PzMPgBtcqX3B//hgr+JnkcZudnR1EpGHatv3C3t7eG6urq780m00MwyCXy2Ec"
    "tclYMVn3L+T2TVAhPlrnkStvM7z5VdTr7r8zMjLyvHFypkqlUoii6C1VfXPmwvl8vvM5xSee"
    "JWU3kHD/37+1se67SKdtsvfj1Q8uv3vjI4NTWFhYeKxI82r5wqOXxs6niY+uoRpyvb7FxfkZ"
    "DMuB9HOsf/r+LWMoz/xPAKDxyVP75VcWJyzTQ4c+oHdlTax0ic5mk+2VD5cTZwlEt8PU9YUX"
    "j1UUFfnHVPnPVxAB0bG/AR7MoFxpLCo9AAAAAElFTkSuQmCC")
index.append('brick_error')
catalog['brick_error'] = brick_error

#----------------------------------------------------------------------
brick_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtVJ"
    "REFUOI2Nk01oXGUUhp/5y8/QzJ1pyqRJJsVUh2EsQRdKBDELa4IguAkFFWkXCoIobsSf0o2g"
    "FruvkNkIWcQZklkrRUGzKAQVGUgax5F0OkPSBok31+lNZ+53v3NcpdjYhc/y8HLel/NyIjyE"
    "1dXVz/f398+7rjsGkMlkdtLp9OLMzMzFh+kfoFqtZiuVSqBHqFQqwdLS0thRfeTQ0fO8V13X"
    "PQVEHcchn89TKBRQVTY3N9na2sLzPADJZDItx3G+vp+oXC53/+3WbDZ1ZWVFa7Wa1mo1XV5e"
    "1maz+UCicrncBYhVq9Wv4vH4U6rK8PAwqkq9XicMQ5rNJru7u6RSKay1jI6OIiJsbGzgeV58"
    "dna2EBeR16empvB9n1qtRiwWY3t7m/n5+aO3IZlMYozB933S6TR7e3vnooA/Pj5OLpfDcRyG"
    "hobIZrM0Gg1EBBGh0WgwMjJCX18frusSBAGZTAZV9eOqCsDAwACJRIJOp0MikcDzPNbX1wEw"
    "xrB862Pu/eHzyiNXiEUSqCqqSlREAFBVRITBwUEmJiZwHIf+/n46nQ6u69ILDbkTRUr1dwkl"
    "wFqLiBC31g5Go1FUFWMM1lqMMVz96Q1UDIGEBGHI2PE8xZPTdLo+V2rnuTRdRkQG4sDq2tra"
    "C/l8nlQqxcHBAb1ej1ACZs9cwKpgxSIoO16bqdyz3A3u8f6PL3Lu2Ce/xBOJxEvtdvtCq9X6"
    "YHJy8rFCoUAqlaIbBlgVbu01MBISisFYw9+9Dk9OPMddc0Dp5ofTkcOaFhcXs8aY91T17WKx"
    "mP7yxpu8/MRbhGIJxWJVuO21OH7sJL+2r3Ptt2//DCxzEY5QKpXOABe/sZdf6wWGngR0w4BH"
    "TzzOM6fn+Ll1ne/q1+4ElrN3LnPjPwsOWVhYmBORj0SkD/ji6l/vlJ8+9Xzyh9+/3zYRzu58"
    "Sv3+M/0fJi/hW40le9jTu59x83D+DyVusCmsaHTtAAAAAElFTkSuQmCC")
index.append('brick_go')
catalog['brick_go'] = brick_go

#----------------------------------------------------------------------
brick_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv1J"
    "REFUOI1tkk1La2cUhZ+cnGNiQjwJiSYxpoI0SAlx1FnFTBrQYUkrCo2Oiv+gg87upOAP6KiD"
    "wh3YRJPaXyDoRAVFIoofAQnBJE2NxlM5+T7v29G9XOU+w81ir8Ve28ZnODg4+PX5+Xmt1WpN"
    "Avh8vprX632/sLDwy+f0rygUChO5XK4v35DL5fpbW1uTb/W2D46GYay2Wq0vAEXXdWKxGLOz"
    "s0gpubq64u7uDsMwAITP56vouv7nx0TZbLb7qVu5XJb5fF4Wi0VZLBblzs6OLJfLrxJls9ku"
    "gL1QKPyhqurXUkr8fj9SSm5ubhgOh5TLZRqNBmNjY1iWRTgcRgjB5eUlhmGoqVRqVhVC/JhI"
    "JDBNk2KxiN1up1qtkk6n394Gl8vFYDDANE28Xi+Pj48/KIAZiUSYmppC13U8Hg8TExOUSiWE"
    "EAghKJVKBINBRkZGaLVa9Pt9fD4fUkpTlVIC4HQ60TSNl5cXNE3DMAwuLi4AGAwGPD090e12"
    "0TQNACklUkpUIcTHgRCC0dFRotEo7XYbIQTNZpNOp4PH40FVVWw2G5ZlYVkWQghUy7JGFUVB"
    "SslgMKDdbnNyckKlUsHv91Or1YjH47jdbg4PDwmHwzw8PBAIBOj1ek4VODg+Pv42FovhcrnI"
    "5/MIIchkMpimyf39PUdHR9jtdtLpNJqmUa/XOT095fr6+sG2vb090ul01qWUP5um+WW1WuX7"
    "1VX+3tnh7OyMUChEIpGgXq/TbDap1+tEIpFOJpMZ3d3d/U9ZXl7ur6+v/64oyjd7e3tHTqdT"
    "AmxsbNDv91lZWWF+fp6lpSUWFxcxTXMQCoXmAHRdH1E/9Ly2tvbv3Nzc+/Hx8TjgeffuHZZl"
    "sbm5idvtBsA0TQDOz89/S6VSVKvVru3TZ4nH41/NzMz8lUwmQ9Fo1K5pmqfRaHB7e4vD4WB6"
    "eppgMMhwOHyqVCrK/v7+P68WAPZkMplwu927k5OT4w6Hwy6lVJrN5k82m60aCAR2Aa3X61m1"
    "Wu3BNM3v/geOhaRMyvpy6AAAAABJRU5ErkJggg==")
index.append('brick_link')
catalog['brick_link'] = brick_link

#----------------------------------------------------------------------
briefcase = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr5J"
    "REFUOI1tk0tonFUUx38z80mTOE35JpkUkolK25gS2wYiUbso8QGVLtSiuy4U7M6WNrhwo0IF"
    "s3AliuBzWzcBheomKmIDWqs0xjRoWvqg1YkJCW2ax3e/xz3nuJiZOi3+4XD/i3se9/+/J/fR"
    "4QeMu2AGalYLrXM1RA01kAZXIwB44eVjd9eoQRVTw8Qwr6hXTKTOhc8+/5gAqC4vzveUOkLi"
    "hd/riYZJPSETNBW0caaeQmsHm7b2o4IEOey1K3PnT3aOPM2f01cRMyZnrzHcVyETSL2QeOPy"
    "/AJbS2XSTDnw5DCzM7+i2CeFr3+7dX7fffJMsX1Ld6l3J4uXpqmuJIStRpzExElCnCasxxl5"
    "M3of2kubd0xOTS65OHk+DyDI6MU/ZiiFJfLFMgAuM1yqRKkRpTWdPQE7O7u4cHUOUR1995vV"
    "G7mGXu+92Hty9+Bjh1rby8RSIE6FTA1R8FJTfXMQ4Jev8dPs2dPvfLX0OFBz4YNXBop5t942"
    "Pf2zqLecN8s3W3WHnWbWdk8w1Wic+/RwpSQWXOrs3haWe/rudNFAmnwXhTTz/HP9AsvVy2+f"
    "+HLxzUCscLZc6Qu7Kg+yePEXJHWoGWLg6+NntwM2l+8n7O4n8/rG68+yKzAo9+8ZYu7MdyQb"
    "K8z8vfr/n6qOm7c2KDlPZfvDLM1fORgAtHeEDD+xH0kcj3qPSYZmgmQpmvl6pEgmmM9QEe4N"
    "i0yZEZjVHpuuXsfHG5zZeIR1KwIw4H6kJb7Jt36Y9SgmiiLeerU24dIPtZ0J1Az1SmvXHsQr"
    "LX+18NT+54iiiHPnSlSrVfYODjIyMsKxo0dY+L6HQv62++Tef6l3xSy3pbFxdOxi4MBxhoaG"
    "CMMQgLW1NSYmJjj9xYeEyRzWtL//lWrC2NjYcefcUefcjiiKiON4wTl3SkRGx8fHXfPdfwGR"
    "XM2Mzjm2VgAAAABJRU5ErkJggg==")
index.append('briefcase')
catalog['briefcase'] = briefcase

#----------------------------------------------------------------------
bug = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArVJ"
    "REFUOI19kl1IU3EYxp9zdtT5lWauEkPbnGarDMTVNnUiFBoGgUHS10WSF1IRkgVFXRVUNxFS"
    "FxEkIgWClBdGF2GS6LKaCn6h4cw5pDA/Np1nnnP+H125lpnP3cP7Pj9e3vcFNlHJOwd3tjtK"
    "AcD5+nBlYas1tL5HjDSlHY6sSM81Bq6SutpHFSaisW1MZdqmAK5ioqTdXr/mqcoURngh9at3"
    "DR6pQZCRUFVX+PC/AKqxACXsHgAUt9oCnPAYpvGUoazFMweL7PoHZbcFY7r5xvGL+dfXMkIk"
    "wNl6qJRxfBCoGNgiJSZV555GvC4ao3NeNLqbkZ+7BxVby3G/5yk44WCEQ3C22QKEifmuSpcH"
    "ABwvC1gUooTavVWY+DWIkCJDgx69M2NYXArAmp4Hb+vAREfbt2wAkBjlsQIlE45X1maJieU7"
    "9WnCicxijP3ox/JqALPyMkhMEi4VVGMuGMSz7udI0LPh8A66T36OpirrZRo7r6rEcMp0BOM/"
    "B7AU8mM2uARVl4CSHQX44umAxFfBNQGLRuGopT77SniJvefcdq5BMcZnYmp+HEtyALPLQYSE"
    "eJSkWTEy7YZ/xQ9AB6oQcJXHUcIaci6b+J8rrDKaJCUjSozDvBxCCLGwpezHsO8rVhQZplQL"
    "Rqe9oCqDyFZTxx97BKKyO7q1fGbZrkTv/HSRMTkbM0E/7IYDmFwYgawoyDLsw9u+HgxODQEE"
    "NWMN3h4AWOzzd4UncF113xRUsaupswXHTGWQyTIoBczbLZBlCXMLc2AqA1HIk93VGeFn++sP"
    "ACDvluUjOJyluU5Igg7vBzohh0IQGWooYR5K2BswJFENZl+Lz/MPAAAs13KaqErOUsJ1nHIw"
    "wl3fX3gLN+rdEBAp04WMT5zCRhRu9rX4POvr4kahSE02TtupSjVw1r9R/Te+gFQ/Nm7MlQAA"
    "AABJRU5ErkJggg==")
index.append('bug')
catalog['bug'] = bug

#----------------------------------------------------------------------
bug_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvZJ"
    "REFUOI2Fkm9I3HUAxj/fu/M8z3POLTflQvGcqWPTEq/dnaeHraFjUbGgVdSLjd6MNWK0oqJ3"
    "BW0vChokVC8qRkEh4YtBNHCRmbNlWdtsrtOViuTU0/vd7/a7u9+f77dXigmt590Dz/N58fDA"
    "XZT4Oqa6LsS6Abq+2ne4oz+c25xxbTTdg7H6jV5ZEmXap46/eyhkW3K7NKV1V4AymUpciJ5e"
    "844pC9JWHU7afLNy2nNOGASOnOo4+58Ax5KaY8u3ADr7I5qyVbG01LZr9avPtMajvjM9b4i6"
    "4K5XHnm+7eW1jtgI6Op/sFsqLgnHpW3xlJUfa3qaUreX35dn+HjsPG1NjRyq6OXtH95H2Qpp"
    "K0TXQESzpatt5PDINEDss3ZZRJE43nyEqaWr5AoGFj5G5ydZzWiEgy3M9I9PDQ780QDgkY4q"
    "EY49Ffs8fN4jXb1VvmrxWG0nk3//gp7XWDR07OJyTrQfYzmb5YPhjwj45PX1DYaf+NHrmHJU"
    "WvI507Qrnww9zM2FcTK5NIvZDKY7QGJnO1emB/GoPMoSrNaJA7tPN5xcH3H02bGosijUldby"
    "V+omGUNjUc+SE6UkqsNMzI6RvpMG3DgFG2Uqv2PLc/e9EFKe9QXz0imv2EqRy0/KyJGjhOi2"
    "PVyf+4m8WaCquIaJG78S39mMbmh3VvTU2aSh417r1/bcWzaTmo3XbW1gPpsmWrmXWysTGIUC"
    "lZ4gJX5JZ3uE/eFeLG/Ku2zMPmRq+vj6D0ZeHHtNmK6hT7/9goOhHgxbx3Fg147dLNye5/6m"
    "VhyXQ2v1ARxhEdkbA9SJfx3p59d/S5R6/UPvfdNHKmMT8NTw5XcXWdGXKBIBHm0+CcBL+z+k"
    "fkcLAuFzs0m3v1/6ZPu+ilByLrnnxmzSZRYshKXLe4LFYujWAPH6xzlz8Sh6LsW1ycm82AzY"
    "rNDRmst+jxNpbCwj1hKnoeoBkgvjjFwdZu5P7Z3/BQDUPBU0t5RI6fdjCihToKNU35W+hVf/"
    "AXXnVV1P4Xg4AAAAAElFTkSuQmCC")
index.append('bug_add')
catalog['bug_add'] = bug_add

#----------------------------------------------------------------------
bug_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAu9J"
    "REFUOI2Fkm1o1HUAxz//h83bg05dq9Zi105nc5XB2Gx30xtXyRwTWkYzM18k9cIeqJEFRURQ"
    "lBFFSRHRixhSUIwyMARrmmZr5dGotNR2w62mY7dz97S7+///v4de7VhP9n33he/38+LLFy6j"
    "zkMhHT4YigCEP7lla8dgW/7vGXOxiQyFVi322lNoV/Tvfr0nIDxVrVzlXRagXcY6Dwb3LHjp"
    "KkcJ3SGT7gs1MXufkaNyW3/HK/8JkJ5KSaFeBNg42J7SQi9Rnl7586q5e2/eEPTt7XrWaKhb"
    "/dSWB1qeXOgYiwHhwfURpTliSDO1zF5atatpOxVWKb/MTvB+dD8tTdfTs2IzL3/zNlpolNAY"
    "4QPtKaHMluGtwzGA0AetqoQSY/fabYzFfyLv5PDwMTJ1hrl0ira6dUwMjo4NHTjXCGArqcsM"
    "KcZCH7btt5W5+WpfrXGHfyNnLv5AppBiJpdBLKni4dZdzGazvHviPSp96lRxgxN3fVcqXTWi"
    "PLXTdUVNX+B2zk6Pks4nmcmmca1KOq9q5fvYELYuoD2DuQZjU/OexkeLI47cFw1qD6ehws/5"
    "xFnSuRQzmSx5o4LO2jZOT0ZJzicBC+kItKvLpVD71jwS0HZxwYKSVSuWU2KWk8jlyVNGcOWN"
    "nPr9JAXXIRK3qD78Bm/G40hLX0Drtx4K1NvWQt/fde3SicTkhobljUxlkwRrbmL80mlyjkMk"
    "bnND4hLrex+kccfjXFNXs2x+Ph3Z9Nv4Z8UfDD8WfdpwzeMDRz+iO9BFTmSQElZf2UzVyRHW"
    "3no3vthXGAPbKR//lOv8V1gS3f+XHwCse6b5GJpwpCmMbVh8MXqU1348x22vfozRcmcxl3y+"
    "lujXs/ofAIDmJ9YMSFfskEJbWmr2Tlxwu/t2llZMfo6TnyYHZNIWv8aY+lfAYgXur/+211Ht"
    "feVlsr5aWLb5B5m44Py0Jd2Ceu5/AQD199S5vRrVk5i+aCrDr0w9pdDvdH+pXvoTXLBZATco"
    "2hQAAAAASUVORK5CYII=")
index.append('bug_delete')
catalog['bug_delete'] = bug_delete

#----------------------------------------------------------------------
bug_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuhJ"
    "REFUOI11kmtIUwEUx//3Mbfp1F2WbatpMw2fZa2ipetpmApGIQkVPUgqikiSKHpBVF8KgiAo"
    "iiKKCilJ+pBRCZWtVvaw8pGPpk7zsdlyc6+7e693fVrkZufTOfD//zj/wwGmqIIGY3Np3Yqt"
    "AJDbkOcw3TUxU+kAgAw3q54VXFj1pCAHACiX6Bb9wdv7ThYXjvQPJ6kfunP/B6DDjTghVJM8"
    "XQEgmWeDK5ysAImaaLhqPAWbu6NxSO5TW+70OCIBxL+D8XZOCDyNbRnlSKLkqLOZ0e7+hqOG"
    "AzhVfxm0UoKWqvZJHmL5o6UhkQ+ZRBf5jUBwvCKtCCTnwqehz5Ap9PCyIkZHbECz68jTe13n"
    "oyKIgriT9olmn+jGrszN8PsHYOlvgodWwqjQQKtKxM3BHozP4PdY6xZYeX9GLaWYC9+vVwA7"
    "uJ3qvz/4RV3CaNLj5iyaJZfC3PcWfqiwTLcE3f1NmMZo0Ge3w6DyMKtT1lUwqWWYYSiBLFaN"
    "4Q5rPg0AlI/8RMhC8IaAMU4KozYDnQMWxMUlod3mQB490n24cMssRcLimN/W74ghOMQnaKBQ"
    "pST+Pci8M7NtqQnpKeWGYnzuew41kwynW4Letge4umkXmLQSBIdrEHAScHT6wQWCTjbozafC"
    "APuLsYvI4fZzghCrVabiTWsLYsaahy9t3BqvTC8DO3QNZIwfwHTwP77aA362aFFVfRsReVVN"
    "peo+BJoxyMU1Nyp3YnruerCDV0BKBHCeVIy+tHh4zrM6q/rDx6g/CNfjs5pyvWFTTebKDTRn"
    "vwWC4sC6dXA0NgUmOG921sH3fWEtFWm+sVdXmbtyxx2BmElOeGohiwsh4NJhtPGdA5xnYWb1"
    "h95JfxAJiNdnXM827UZnzSF0vX4LaUoeeEfnkJLC2vnHP/ZE6qM2mKeXnzDqEklGm4zfP39h"
    "oO27l5JQhabTX1umihsFUMXyx2w9bRC8TjEonTCTEItLz7V2TGUGgD+y2S8zxR3MyQAAAABJ"
    "RU5ErkJggg==")
index.append('bug_edit')
catalog['bug_edit'] = bug_edit

#----------------------------------------------------------------------
bug_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvpJ"
    "REFUOI19km9o1HUcx1+/u9/d7u82583cLlt3a9MttrHR0t10azJRURIXNNSCiJ4IRUgWBEVF"
    "UvkkamEPfGIlCsIhIkI9mYGssek2xVLc2rkpht1ynXc37rf7/fl8e+SaUn6eveDzeT14f97w"
    "mOn+MaG6ziV6ALpOr+/rTLYbj+64lkPPYKJ2OStLUKZ9YP+XO+K2JSvFFOuxAmUy3X2u4+AD"
    "dkwpiq06nfvmp5UpfUArEOo/0Hn4fwWOJVnHlkMAm5IbsspWJWKpil9rM3tbNnb4vtj6gRaL"
    "PvPezjfa3n1woy0XdCWf7xHFec1xZUv1cNnr6/YQdHu5fu8Wx8aO07ZuLTtWbOPzX46gbIXY"
    "Cq3rzIasLa624b7hFEDixHPiwaPtb+hn+q+rGMUCFj5G/rhBJpelPdrMreTl6cEzU3UAujjK"
    "rzn2dOJk+3FdXNtW+6q0XTWbuHF3gvxilrlCnobSlRxpaGVExfhm6Bghn/y2lMHQS6Nex5QR"
    "seRV07QrX473MvnnZXLGfeYWcmh6mJ2BINXRzcSt2yhLIxPTtjQerHtrKcSRV8Y6lEUxFqxh"
    "dn6SXCHLXH4BQwuyN/IUVU/2UlrVyqpCmpjuQZkq4NgyUP9mXP37hUVxyvRyPK4A8wUDAz9b"
    "Kup5In+HcKQcJ3eWaNNr7I6UUef1VU1+ldJsUz5cErgd98DFmUtkDTDETyLSTGX+d9Y8uw8W"
    "J7j4wwlC5QYtJR718dORjQA3j84eWhIMvz32vma6Lnz/8ym2x7cSKqZpXdVMeEUBKc6AEpyF"
    "S8R73tEyhvHt0OFEGMC9vAd3B9PfrXmhevN4aqymP6QTb9qOWyZQ9t9UN0ZQUsAbKKHE2xJM"
    "zYwGTp1P//RQEwGufna9+8Wwb7SutpdA+B7KngfNzfjpKUCQxSkq62uoUM6eCx81NmqPCgBG"
    "v15/p2nfyajbNYuyM4B6qP1u/1rS164wefaTpP5fAqto+saP9hlKFEoEU8SvRKErZSgRlCgQ"
    "AVGr/wFnX1XBtbD8rgAAAABJRU5ErkJggg==")
index.append('bug_error')
catalog['bug_error'] = bug_error

#----------------------------------------------------------------------
bug_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuJJ"
    "REFUOI19km9o1HUcx1+/3925m26ubQazy41uy01Frbnrzls7mSO1jASfWD0olCCkByVZZPQs"
    "w4LogdGDKAixgmDEIKEolxl1DlsTZ5w6b8y7uWltN/3tdve7+/6+f3q0MTN9P3vz+Xxe8Hnz"
    "hntoy/dxkzgR7wZIfBvd3dkbcf+7Yy823f3x5sXeeBoj5IH9H+0MS0/Xa6G9ewKMIL3lxOaD"
    "814JXdbSdKpb4t37R/1HrSJVew50fnBXgPK0o6Q+DNDVG3OMNBXaM3UXmm8+v/HxzcH3t79j"
    "PRRqefPpl9rfmL+xFgMSvY91a8PPlrKd5f7qmn1tz7HMt4TUdIYvBo/T3tbKztodHPn9E4w0"
    "aGmwEn0xR2q7Pbk7OQoQ/6pDBwhY+9fsIT01jFsu4hFkYOISN2cdIqENZHrPpfv7Rh4G8Gtl"
    "Ki0l0/GvI8f92t7REFxp7Wrq4tL1IfIlh3+KeWRFDa907GN6bo5Pf/uMqqD+67YXYl92nEGZ"
    "GAoOPrqX4YkB5kqzTBXyiEA13aEoF7LfIWSZs1fLCOEVLI9DqQ+vfLyQQfTzTaVwdVPFpvoQ"
    "12auMl0oUPItZeuqKBevDVGUGRpXtJGaGGI4LY2WxjLS4F9IsKRVTe19BOyl5Iou9Us8tJ7m"
    "fLYPISWhutWsaYiSLxXIuQPGC+jl48PLXlsA+JTv6NmxP956IPgUrq5E6jxPrHsRZTRKKzSG"
    "SWec9Q92Midc+8/saac2PFW30IPkq4OHLGH/euzUNzwZ3k5JCpTRZHJXGMuNMDqV4pabIzMz"
    "yiOrumhdGbFnXXK39QBgw9trT2NIrA8bntn4MlIrpFYoo7nuZKmrauDceJKfLv4wU9b03AEA"
    "WPv66mOtLd4LJSEQWlCSguYV64iFtzGYTXLy8o83hKLnxhFS/wtYrPDexjNGEatsGXcjTVsr"
    "fxnpn/AseiYPc/mOKt9Njc+GhK9l0q+MbZVR4b/fY2x+9i+NjWPU+6fG2gAAAABJRU5ErkJg"
    "gg==")
index.append('bug_go')
catalog['bug_go'] = bug_go

#----------------------------------------------------------------------
bug_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxlJ"
    "REFUOI19kV1oU2cYx/8n57QnetrlazU2amPTD1tLVEKrNq05K8wpOBAdrN1wKGFjuI8LoRUv"
    "vFPUIggqCiLohehViV6IY0g3wpzWUib4MdqYdkvYybFNtDlpPs95z/vuqqUdzOfuD8//B8/v"
    "Ad4z8k9BFrof7AOAUGTHwZ6RrtJ/dyzLQ99osGl5ZgYF08mxoxf2+YhBXVSnxnsBTEdcvt89"
    "uJhNnVYoYT1mVj9VNy1c4oqo6T/WM/y/ANOgmknoaQDYNbJTY4SJ1GDOF03zX27t7bae23OS"
    "a1zXfPzTrwNDix1uOSA0sr2PMvzCmRbtA6HWFm77AhJfjT8zCdycuIVA2ybsc+zF2d+vgBEG"
    "Shi40L2dGqGWwOODj6cBIHi7k1ahijva3o94+jlKlSIMWDGmTGI+p6Fr3RYkRp7FR+/FWgBA"
    "oCZbxZkkHrzTdUuglr1rrfXcfu8uTKp/YKGsYa64ACLa8H1nGJl8HtceXUeNlb5ccvDos6fV"
    "pk7HqEG/0nVS97nvY0y9eYZcKYu5fA46XwPZ3Ynx6VEIrAxmcJhv5HZvHmz5cUni2KGJbmag"
    "0ih58ffbKeSKGuYW8ihxEuT6LrxKTiBbyALgYVYImM5Wm4Reav3Bx4Qlg2Vq2hx2cMSKhWkr"
    "WtGJ9e4NiEenUHJSbKzfjMRvGgY3nYCqqpqiKGceln+u5Rf73j3raxPpZG/1axv89h04fOgw"
    "PB4P1rjcmJ8pYTaZQ3ggjOamZrhcLquu67uzz7XxFW8MfLvtZW9NqOPIkW9w9cZ5qK/fwlPv"
    "gd/vh6qqyGQySKUUCLaqyaHvhtoikYgmLAewce6B84CzHYBltX8Vii+KGBgYgMPhQD6fRzqd"
    "xsXLF9k/9kQbANjtdnEFwDTNv1RFzQGwTz6cYYwybnh4GJIkAQAKhQJ4jidbi4FfAXyiKEp5"
    "xQkdHR3tPp8vIsvy2oaGBioIgnN2dhaxWAyiKMLr9cLtdoMQ8i6ZTFqi0eibFQAAvCzLfkmS"
    "7no8njpRFHnGmOXpuye8zvRK6MOPTABVlUrFTKVS6UKhcOBfUXFlqaSUjDYAAAAASUVORK5C"
    "YII=")
index.append('bug_link')
catalog['bug_link'] = bug_link

#----------------------------------------------------------------------
building = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAbxJ"
    "REFUOI2Nk01rU0EUhp97M4mCKPZjYQNSTXaCIIkuCuIiCGo3IW5cdyUSuvYPdCPoyo39AfkF"
    "giEUlCLBCuJGjBQRRAoubjWJ2vZ+zJzjIpo2epvmhWGYA+fhmWEOTJivCwuaVvcnBTxdWkqt"
    "ewcPnU5HnXNYa/m7W2sJgoB2u00+n6dYLFKtVod95iAgSRIKhQIAqvvGqkqlUkFVabVaIwYj"
    "AGstAC82BzdzCk5AVHAObl6wRFF0OCCOY1SV0pkuqvrfgtOTATa2phAVrAwMrAMRpXbJEobh"
    "eADAlbntVAPVqfEGURShqqx/nsapYgXEDd5CRblzORlv0Hc9VJWrZ4NDDKb5pT/TAfdf3T33"
    "Pn7DLV1ERGg0Gvi+j+d5+L5PrVajH/X4MvdpBDD8ibHT8342w4f+O1QVYwylUolyuYwxBhGh"
    "u9cldyLH4pMbt0cAyxvLpzzxns9kZ1nbaiIiGGMwxgwt9uwuD16uMD87j0T24fVH1y7uG4Q7"
    "96Io1o/BJjvfdmm9fYZkhUwmM4Q0XzcxYY7vP7ZJrM2L81bgzyzU6/XUSfs36im9k11ycY5j"
    "8XFWH696R3cdkd98jBSIX07rOAAAAABJRU5ErkJggg==")
index.append('building')
catalog['building'] = building

#----------------------------------------------------------------------
building_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg9J"
    "REFUOI2Nk01IlEEYgJ/5vm/RrCQtQpcCdREy8KddixQPYQidkk519RS5eDLIU5c6bIFXD106"
    "eesQBMUWJJLaUococ0MsDDJXWFt/i/12Z+btsLgpbosvDMO88D7zzDszcMBIdXVJqbxzUMCz"
    "gYGSebV7kUwmxRiD1pqdWWtNOp1menqaYDBIKBSiv7+/WOftBuTzeZqamgAQ+WcsIvT29iIi"
    "xOPxPQZ7AFprACbmCyczAsaCFYsxcOWsxvf9/wNyuRwiQrhuDRHZN+DYwQCJpRqsWLQtGGgD"
    "1grXOjTZbLY8AOB8/WpJA5Ga8ga+7yMiTH6vxYigLVhT6IVY4XpnvrzBhllHROg5nd63+/tv"
    "k8SeTLFZtc6Ne5c217Z/PYw/mL1fvM87b282uLlDi7db75LJZBgfH8dxHJRSbFWkqGr4Q6Sl"
    "k1O1zUzMPSXx+Q2LX1dHiy8xZ6TRCbh82ZhFRPA8j3A4TCQSIaUX6DjTjnEM7fV9GJXnYms3"
    "IFEHYCgxVK2sen08cIJXSy+w1uJ5Hp7n4TgOme00AXWEqy1DAAxffkToZBsKVVnoQfb3LT8v"
    "srA9rw7nqokvPccGLK7ropRifTPD3PIMH5enGOl7TOzlAJVuBYJkFUA0Gi3503biJ0ncxhTd"
    "bT00151jYeUDM5+m+LG4MarKFe6OC4N1MZQaVHBUYAuRsXdjKyN/AQVXK5HJZJ4VAAAAAElF"
    "TkSuQmCC")
index.append('building_add')
catalog['building_add'] = building_add

#----------------------------------------------------------------------
building_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg1J"
    "REFUOI2Nk81LlEEYwH/zvrNkSaLpwQRbP+hSEbVbkNAhpIN2EQ8hHT2ElHjoVNE1wr+gzh3E"
    "boFRsSplieShQx+0KqWFbFqslWb78e47M0+HRVPcFh8Yhnng+T2/Z5iBXcZyW5uUynu7BTzq"
    "7S2ZV1sPyWRSrLUYY9jYjTGk02mmpqZoaGigtbWVrq6uzTq9FRCGIS0tLQCI/DMWEdrb2xER"
    "EonENoNtAGMMAM/nipNZAevAicNa6DhiCILg/4BCoYCIEKv/hYjsWFC9O8B0qgYnDuOKBsaC"
    "c0L3CUM+ny8PADh9cKWkgUhNeYMgCBARXnw5gBXBOHC2eBfihJ5TYXmDNbuKiHC2Mb2je+bl"
    "MHMPhjmz+InEeX9RkLsd425wE3D9VV/Th8JrOuUCzjmGhobwPA+lFNGVtxyPLBO7eJk9zUfJ"
    "vRttTE6O3h6T2czmSyxYafYiPjNr7xERtNbEYjHi8TjV8xMcPtdNxfwE6v4l9i08pCla51vk"
    "mgcwMD1QpZx6VhupYyz1FOccWmu01niex97MKhX1zTAwAoM/4eYCOjOLL6qpOEI+cyUIRT7+"
    "mVOVhSoSqSe4iMP3fZRS5Cr3k33zmMqRqwS5b2SB9d8+1mdJAfT395f8aRtxLDvDST/FodoQ"
    "7aVYTxs+f9eEOXtLlSvcGpM9jTeyP5b6PKeizpOvDrnXOe7u/AWkxTVXwbKW4gAAAABJRU5E"
    "rkJggg==")
index.append('building_delete')
catalog['building_delete'] = building_delete

#----------------------------------------------------------------------
building_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnFJ"
    "REFUOI2Nk0tIlFEUx3/z9pVjio+mfE6QGhEWGpZRCZGQ6KZlEG6KFi5ctQ4KJGhdhNsgqI1Y"
    "0iQogmNKhqb4JstUfHw+Jx/zfXO/77QYNCcNPHC5nMO9v/P/c++BI8Z8ebkcVrcfFdBSV3do"
    "3bY/GRkZEdM0UUqxuyul0DSNYDCIz+fD7/dTW1u7d8+5HxCJRCgoKABA5K9iEaGyshIRIRAI"
    "xCiIASilAOgYjzozBUwLLLEwTagqVui6/n+AYRiICBey1hCRA8vQBilztDLZ/FS2ljshPHfv"
    "UEDP7HEssVBWVIEyIVN9oMTeT9a5u3jzS1j/cYbRQNOzAwCA0hPLMZ1toU68rmkSk6+w+n0U"
    "t83gWHIWSWk53hiAruuICJ0/UzFFUBakqW6u+abw5t9Cn3+DO8HG9MAYxo6+EtY3L8cANsx1"
    "RISKbC3aPdRLqnMIr7+G8NxL7G6FKymXuK3BxfCOu+pSQ9vE3kd69PlB3nBKHyKCZVm0vn5M"
    "ovqG93QN4bkX2F0RjFAeMx29hLe3q0sa2gZiXsEwJT/R5WB0Y4iEX5PcKE0n4+xtjIUmHG4h"
    "vJHLUtdXXnnTmNx05gB9AA6A+p76ZIeyxrI8Pqa/NFPosWPafJi/3xGXKOysn0LrGea500b6"
    "ySJmF2bK8m5mt099ml6KWghvPdR1Qya1cXIXVymuuI9npouJ5iADgVX6W4J8tAoJGfGshpaJ"
    "KOWzTNuTPQvW2/hGiA7GuLGIMfye/PNX2dBWmOobZTDhOqGFbVJtGazMrJFt5Hk8RlxNO52x"
    "wwRwpyJl56I/01laVIC49G5d0+qqG4em/j23G38AqFhONwNA+C8AAAAASUVORK5CYII=")
index.append('building_edit')
catalog['building_edit'] = building_edit

#----------------------------------------------------------------------
building_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI2Nk01IVFEUgL83PzaNzjCWZv7M+DOkw4DQZAZKRglBqyRaBO0kIlq4alE7t9WqXUS7"
    "0GUtEopBUApFKxVS0lSyFlbQGykrx/fmvXtPC9Fx0MQDh8s5cL/7XTgH9hnf29pkt75nv4CB"
    "7u5d+8b2YnZ2VpRSuK7L5um6LqZpMjo6SlVVFfF4nK6urq17vu0Ax3FoaGgAQCRvLCJ0dnYi"
    "IqTT6QKDAoDrugAMz2/8TAkoDVo0SsGFpItt2/8H5HI5RIQTR38iIjsSIvsDjC+XokXj6g2D"
    "UjVFjRok3Hwdy7L2BgC0VmbyLysLWX5KJNZB9mt6bwPbthERXn05hBLB1VDrDJCKnSJcmcIc"
    "7uWgESsAFMzBqvqFiHA6anImanKuYoao/YJQWQT1+zlHkleJh5eYeNTi3wG4PXaj7kNkAhFB"
    "a01/Xx+LY48pb7oE1hRvn/RTElmnwpvBIHRxByCnpN7j9zK3OoOIUBn6Q6K+mlBpFm1/BtGo"
    "v++oP3uLrOM8GLnXHtoC9Iz3hA1tDB32lzG4/BKtHBpLPhGJHUdnpxG9TsvlJnTuG4HAArHm"
    "KzUZw76bN7DWbtp2ThbNedZWsky/eUhdooNgKIO4K2B4mXy2AGi0tUB5Yy1By7n2ujeZ9AK0"
    "FreP8NFvGItFOEvCyQPvaTx/B4/Pi+GP4gkkqE514AkkMIri+IqPEQzHfT/mhioKlmkzRu6n"
    "MuLqoGhBtN5IEfK1gNagZfIfJLsyWUToj5kAAAAASUVORK5CYII=")
index.append('building_error')
catalog['building_error'] = building_error

#----------------------------------------------------------------------
building_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAitJ"
    "REFUOI2Nk01IlFEUhp8ZdTFKY03+Tlo5gwuTQLIoqYiEotxIi6CduYogVy0iaBu4qEXRqk3t"
    "XQbFEJSSo1+UKUSGaZg5FDGZTc7P993v3ntaDFqDP3jgcjgvnOe8914ObDO+d3XJRnpwu4An"
    "/f0b6oH/i+npaTHGoLVmNWutSafTJJNJotEo8Xic3t7etb7y/wG+7xOLxQAQ+edYROju7kZE"
    "SCQSJQ5KAFprAF7OFG9mBIwFKxZj4NwBjed5mwOUUogIhxqWEZF1B3ZuD+CkdmHFom3RgTZg"
    "rXChQ+O67tYAgCONP9dNv+9cxlnI0qoubQ7wPA8RYeRLBCOCtmBN8S3yvqappo0J7xEX7zaF"
    "hq6nCusAGfMbEeFEc5p7432I9VFWo7QmGmmlreEoK26OqYKTPfWgtnrkWjq7BrgxfmX/B/WW"
    "89KDtRZtFWfa+zBiMdZgEb5lFjnYdJysKgQnvo5kOgeJrAGUkZaqijI+Zt5TJ1FcrTBiWVia"
    "xbcabX184/PHW6Gj+SRZPx98PT+6FAQYcAbCARt4sbuihuepZ1hrcbWLNpr68F4awvtorI5R"
    "URaidsce3i0mGfucXM75HC46cHNXPV9kNjsTqFJhEqmn5LXL4/E7KKtwtUe8pp1jsbO8WRhl"
    "eG5Y6io7ppybk1PlAHYoNAjFxchjmGGOKD0l3/Wq8JBAMMTYpzE6vZ5A5Ff9aYfJ0mXaKlpu"
    "kTNSVulhYj9uM7+q/wXdtU5LSeIa4AAAAABJRU5ErkJggg==")
index.append('building_go')
catalog['building_go'] = building_go

#----------------------------------------------------------------------
building_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAltJ"
    "REFUOI2Nk1tIVGEQx3/n7G7mJW+kbYuRrVRkFySxG1EiFF0o33uTpJDqKajovYigegqLiJ6E"
    "KIIoaLOHQkgsqGDJXV0vZaSY7LKrodues9/3TQ+SubSBA8Mww8xv/vMwsESb3L1b8tXtpQKe"
    "t7XlrVuLk2g0KlprlFL8iUop4vE4vb29BAIB6urqaG1tXZjzLgZks1mCwSAAIn8ViwgtLS2I"
    "CN3d3TkKcgBKKQDexOYv0wLagBGD1nCoXuE4zv8BrusiImz3pxCRfxzKlwZ4N16BEYMy8wqU"
    "BmM0B+077Cj+xNDtzSc3nInczwsAaFqd+Ge7/vKUwuJJ6o+dJ9F38/rHq5mJxsujL3MAjuMg"
    "IvSMVaJFUAaMBv/MM3ZVhSnbeIC5byF8KzZWlq1xnoTOSnsOYEZPIyLsXRPP2W4Nvqd861F0"
    "OsLylTVk9DiB/Q1FajbZuQC42He6NuJ+4LAcwRhDV1cXtm1jWRbbSpL468ewPQkse45lpQnI"
    "pJmddDwLAFfLumKfh4GZz1RLAK/Xy85NK6mRt1g+jVERbDMN9gok6zL4MJYZGJo55QE49+5c"
    "qUeZQX9BgGiyny1FDfz6+or1vjBr97RQWjmMR5KEQ0mmwj+Z6k/qnh/pSx0PRu/NK8jMdThZ"
    "keHZmFXsltI9/oJ9/jjB5lbcRCdebxn9rzM8ShbCplpi30dUpnZVMwze8gKYx4XXYP4x0mhi"
    "jLCrKYvlmcBTUEU4lOLFQBWObzXT4RTVbrCgwF1+/DU9uc+02N7faLxSUlHRPpdK/xoZmrpw"
    "4u7oo3x9vwFTJUkc60AhpwAAAABJRU5ErkJggg==")
index.append('building_key')
catalog['building_key'] = building_key

#----------------------------------------------------------------------
building_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjpJ"
    "REFUOI2Nk89LFHEUwD/rj0ZdzV3dsB0ha7wFCyIVLB4EIQg8iJeS7eQhI0Tq1smbEIJXo5t/"
    "godOQhS7JHnqEkjtXsatnXGcpWzZZWdmZ76vg2hKJj748uU9vu/D533hwSXDzmblvHrbZQFv"
    "5+fPrcdOJ7u7uxJFEWEYcnyHYYjrumxvb6PrOqOjo8zMzJz0dZwGtFotDMMAQOSvsYgwNTWF"
    "iLC1tXXG4AwgDEMAPnw7miwSiBQoUUQRPLgd4vv+/wFBECAijF//hYj8cyBxOcDOjyRKFKE6"
    "MggjUEqYHQvxPO9iAMDddPVcA5HkxQa+7yMi5M0BIhFCBSo6+gtRwqM7rYsNfkeHNJtNtP0C"
    "5XKZwcFBqo7DxMQEfX19bGy8Q9d1VlZWflqW9apUKr1uP25++enpzYO2gxf2R5darUYul0PX"
    "dfr7+8nn8ziOw/T0NIZhkEqluoMguG+aZueJQRDJrXrxEL6XeZh7zPLyMrZtk06nyWQy2LbN"
    "2toalm3RO9DzeWnh+fje3t5CB8DSztLVWBC898yAnt4eAAzDwDRN5ubmSCaT1Ot1XNdl/c06"
    "0Zg3AJBIJLQjA6/xzG+J1K/UYtZ+BYBiqYhSitXVVeLxOACNRgMUdH7pvsE9qFQqXgxgcXFR"
    "jh/UajWy2SzDw8N0dXXhOA7FYhFN0xgZGWFoaIim18SqWBQKha9nlglon5yczMTj8U1d169p"
    "mtYuIm3VavVJLBarpFKpTaDT9/3Isiy30WjM/gHTwkanGZeuSAAAAABJRU5ErkJggg==")
index.append('building_link')
catalog['building_link'] = building_link

#----------------------------------------------------------------------
bullet_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPhJ"
    "REFUOI1jYBgFFANGbIL5UyJq/v1nKPv5+zvvp68fP7//8rZrZ+flFmxqmdEF0vsDG8SkeBtt"
    "TS3ZnU09GH6zv2V/8+2RE7cKM+/T0192oatnQhf4+uNzuYGGPsNfpr8M+pKuDH8ZfzNY6Fox"
    "MDD8z8bmAgwDPnx5y8HKyMPgp5nLwMDAwFDsPItBWUyPgZGBkYMoA958fPnj6rNjDB27ExkY"
    "GBgYOnYlMtx9dYnhP8P/H0QZ8O/f/94Tl44xsDGwMGy+PI2BjZGF4ciFgwwMDIxTsRmANRbM"
    "siQ6GBgZsxgZGHj/MzB8Zvj/f9qpaS8qsKkdBQwMANrSULAqVbXwAAAAAElFTkSuQmCC")
index.append('bullet_add')
catalog['bullet_add'] = bullet_add

#----------------------------------------------------------------------
bullet_arrow_bottom = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAANBJ"
    "REFUOI3tkDFKxFAURa8fCcEJpMoKtHAnNqmmsbe1yx6yiKTLArICu+xCEISPhSFdeO/d/+cX"
    "Y2eRGbTQck55eFzuu8CFP3O1FdM0HVNKCCEghAAzg5lBVdk0zc323m1FSskAoCgKlGWJqqqQ"
    "5zlE5PVcg+utIHkbY3xzzu2yLMOyLPDeM8a4Pxdw0qCu6891Xe/meQ4k4b2nqt63bfv+6wbj"
    "OD6r6hNJqOqHiDyQfDEzI4m+7x9/DACArusOIuJUFSRhZt+DDsNw8vKFf+ALuo52TWcpn9EA"
    "AAAASUVORK5CYII=")
index.append('bullet_arrow_bottom')
catalog['bullet_arrow_bottom'] = bullet_arrow_bottom

#----------------------------------------------------------------------
bullet_arrow_down = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAKVJ"
    "REFUOI3tj7EKgzAYhK9YYmJ8APcu3fsmPor4JMHJp/EdOhUKJZkcBfH/kyC0e+rgUOjiNx53"
    "xx1w8H9OqTAMwzvGiBACvPdgZhARiIibpilS/zkVmJmyLCvKsoQQAlJKxBgxTdNja8FXwTzP"
    "F2Z+5nmulVIYxxHWWg4h1LsuAEDXddWyLC+ttXTOsff+aoxxuwsAoG3bal3XOxHd+r7fDB/8"
    "iA+4sExmNtsnpAAAAABJRU5ErkJggg==")
index.append('bullet_arrow_down')
catalog['bullet_arrow_down'] = bullet_arrow_down

#----------------------------------------------------------------------
bullet_arrow_top = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALpJ"
    "REFUOI3tkDEKwkAQRb+bLbIKgXS2VnoTD2O6nCDXSeEFrHIGGwmKIF4gxczObLawEYsYIaCl"
    "rxz+/wwP+PM1s+GhaZoQYzQiAhEBEYGZQUQoy9IO83ZQ3sUYjyIC7/3de79l5gMRMTNP+wAA"
    "6rpequo1z/O0bVvfdd2mqqrbWNZ8KJ+TJElVFc45F0I4FUWxmjSgqhdjzMJaCxGBcw5Zlrm+"
    "7/djA29SmHlORC95zIyn0PXYwJ8f8ACbJ2z81oX2kgAAAABJRU5ErkJggg==")
index.append('bullet_arrow_top')
catalog['bullet_arrow_top'] = bullet_arrow_top

#----------------------------------------------------------------------
bullet_arrow_up = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAJ1J"
    "REFUOI3tjzEKwjAYhZ8hJEY7OnQSnHoAD5RD5BI5Swan3sSlgyK4dO4fyJ9mcpcGCg4u/cb3"
    "Hh88YOP/7GpF3/ctM99TSldr7bu2E0thCKEloheAExEN3vvzakEIoWXmhxBir5SCUsoQ0eCc"
    "u6wSxBifUsqj1ho5Zxhj0DSNIaLbkkB+B9M0HcZxREoJzIycM+Z5Rimlq93Y+JEPnl1AYPsv"
    "KhAAAAAASUVORK5CYII=")
index.append('bullet_arrow_up')
catalog['bullet_arrow_up'] = bullet_arrow_up

#----------------------------------------------------------------------
bullet_black = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAKdJ"
    "REFUOI3tjLsNg0AQBcfWEdACEmhDWqEAWqANU4cLIKEeCwgudUbOZ+/kxBFaS7acMtJLnkYD"
    "J39zsc48zzPnXBNjrFUVVe1V9T7P8/PoOivgnGuqqrqJCKqK9/7WdR1Ae3SvVkBVaxHBe88w"
    "DBRFwbZtteV+ChBjZN931nUlhEAIwVLtwLIs/TiOiAhlWTJNE0BvFizSNM2SJGmBx3stkH0d"
    "OPmNF/PgR/8yPS+rAAAAAElFTkSuQmCC")
index.append('bullet_black')
catalog['bullet_black'] = bullet_black

#----------------------------------------------------------------------
bullet_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALVJ"
    "REFUOI3tkDsOAWEURg8hkUhQqBTYgJ6FzBZ01jASVjEL0MwaVEKlswUmEiGZGf7M438odJPb"
    "TeuUN+c7xYU/tWmI150b4VhitIctoMxCsnfAahJV1ZYYcCzXM+svBpDpNudH6W9OCmBdVZti"
    "QBfevG853gz7a8mw04Yi9SRVDhhFXBiS0pBbx0dbyGNRlQO5Ci9PxbQH464jeceQRqGkyj/Q"
    "SbA93EErjzz5jbNXILp/6vMFxAhOiaMXpSQAAAAASUVORK5CYII=")
index.append('bullet_blue')
catalog['bullet_blue'] = bullet_blue

#----------------------------------------------------------------------
bullet_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAO5J"
    "REFUOI1jYBgFFANGbIKHw2Ur/nz7kPnn63fZf0z/n/xn+D/NY8+/DmxqmTE1y5XzSks3GYRl"
    "C6lGFzBKSYvyf/36yTGM7937xff/nUJXz4Qu8PXt0zQ151A2jrsHGBgXRjJw3VvPoCAvwvyX"
    "4X8hNhewYDjpH6Mih4QiA4NXEUJRgyQD839GBaIM+Mf0/+m3C1tluDdlMfz8/oLhGwMDw+dP"
    "zAx/mRmeYTMAwwtcwmJzrx47+Of5D06GT8ysDO/fMTLcecL49////9OwGYAzFr69fZbO9I9R"
    "/h/T/6f/GP5P99zzrw2b2lHAwAAAE1dXvSc/zwIAAAAASUVORK5CYII=")
index.append('bullet_delete')
catalog['bullet_delete'] = bullet_delete

#----------------------------------------------------------------------
bullet_disk = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWhJ"
    "REFUOI3Vkr9LHGEQhp/5dvc8N6ecIEaQhFRpBSERbG1TpbSyEbHxr0gjKNjZBawkXSBdLKxE"
    "DMYipLAy4QTBE3+wh3u3u9/OpBDkVnL2vt07MM8MLy88e0m/Wd36bSNDkOaesUaN83YXcdCI"
    "A9SEm6TL3vH57J+djz/+S1vaOLKvPztmZvbt4Mwea3uvbYtrh9a/4/pNmhVcdzwAu0cXD/Oe"
    "hySDy9scEa0cDSs0JwQGRalsrMygahgQYMQhZFlGcpcPBtQjRy8r+PTlL07Al4qWigFmBgZx"
    "9MQHXo2s9AQuAgyhREQwNcwU7wvy3A8GdNKCSEJWPozgNb+PyMBEqYc11ndaXCV3gwGlGgER"
    "SpfPx8uMx68RHJfpGUvvNnHUSbMnMgjDgDeT8LLRYX76Pc3aFDi47U0x8cIT1yCUSnWqRZpZ"
    "/r7/9tXwXHOoST0cxWuBqCJWopJy0jqlnRT82l6oUp63/gFEqbA25HMz+wAAAABJRU5ErkJg"
    "gg==")
index.append('bullet_disk')
catalog['bullet_disk'] = bullet_disk

#----------------------------------------------------------------------
bullet_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWpJ"
    "REFUOI3V0L8vQ1EUB/Dva5H68eopVZY2UTR9g5IGic2AoU01pIlELX5MBqSJ6CBNw+JPYBQW"
    "CZEOZhGTqsGPwRswiQgGkb73bt+91yB+JFq19iQ3Oefek889OUDJh1Do4eZwIsINFuNUCLUO"
    "bT0W6jPlu1QOxq1MN5KSK9zLqL741wR5AYDM1zoDXmtzF6hmTF3sBrv/DSj7EZnquTmxQQJ9"
    "TcHhm5a4TpdP1/3lRQGeSJgIUeN2OWqDdoaTzW3USCoMlQQFiKGiwJUnPVhd74uKdVkw/Rbg"
    "DPQtjZb+mEAJWTle6xMLApc7kYqcqq9Kzk6w7Dk4U+Ef9YCRe1gsChwdY15AWygIaC8PM7a2"
    "gL9KfAI3ngHBjMyeAoCBaQrs7S5QQmaPErL8Eyj7TKhO4nZ5GDDdwWS1A+DomQx//WOudMM9"
    "sNR4nUomAUR+ATmdWDIbIypnHJyxj8M5vmsOMAYw3pRvmSUc76ugl/hfTcHnAAAAAElFTkSu"
    "QmCC")
index.append('bullet_error')
catalog['bullet_error'] = bullet_error

#----------------------------------------------------------------------
bullet_feed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALRJ"
    "REFUOI3tjjsOAVEYRs+lEIXIJGxAa3qNZdiHiGIkIqJQqxUSIgqFLYhCI1qjV6g8M08j5v42"
    "MMUkWqf88uXkwJ+fUUmjjMoHUFViXGLZ8Wagepdt0jeTaG1dTDKfIpFuE0ieUM/FMuqpBTIs"
    "Hbhnn3hiEcRTfDnj0E9f0L2ahHGDUG/wVAdXZni6lr6gaazJGStc9vi6QqSWhBRSC3CxOd12"
    "avIYE+ijWtwdXmInfv/8zhdJKkjQ/UXXDgAAAABJRU5ErkJggg==")
index.append('bullet_feed')
catalog['bullet_feed'] = bullet_feed

#----------------------------------------------------------------------
bullet_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAUdJ"
    "REFUOI3tkU8rRGEUh3/3IrlETcTimppRiomURDEbk9lbsPUBKNlZ2CE2tr6ArHwDIVNDQ0ZW"
    "akjDDGM0jeYyf+6c+77n2k7T3Gtr4dmdzu88nc4B/lHcmssHkyUSpBXaW7WjxVilUUZ1E1RE"
    "FXr3ENTPQnlhT2/7dYPVw6AtmZhYgISA7hlUR/UZXD+f4e41xlYLd0VWcsXamebaQjBhLrCk"
    "SpshWYJhI2OkMaJPo0gVNZ6KGOO78MTXYTQUmIIgbcZL/hEWCwi2YEkLX9VvjPUHUbTK6lUy"
    "mq+dqxOYEFKgt9MLwRLSZrwbKXg6+nCbvkD0KZojibDjDeb3fWwSgZhgCsJAT0CZ8odxk7rE"
    "SeI4SxKh7A7uHQX1DG8qpQnvrHb+cPpmKQhltpCoz7gKfBsoSbtJq0L6P7aRdMs6oq+h4f//"
    "Dj9rJporgp1X/QAAAABJRU5ErkJggg==")
index.append('bullet_go')
catalog['bullet_go'] = bullet_go

#----------------------------------------------------------------------
bullet_green = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAMZJ"
    "REFUOI3tkD0KwkAQhZ8iIihoFUWwFNEjWHuFNCKWuYaeI4WC7d7AA1hJRLQQQbCyMvib6O7O"
    "7trLdLZ+5fDx3mOAPz+T4Y69ebeunQtg4YMcrDLCSAoX/dXp281xAdq5YNAYjlqlDqSR2Me7"
    "0Ww9BYDxt5tldxH8ZrGNzXWLKI5QLlSAF/mcygY4ZZHoJ1KVgKyGpDcosWwXG2DeJI6XA2qF"
    "Kry8h8f9DjorwbnsD1xiw9lyAvMyvk0JOtZC3VTITvjzOx82Y1p7oPss/AAAAABJRU5ErkJg"
    "gg==")
index.append('bullet_green')
catalog['bullet_green'] = bullet_green

#----------------------------------------------------------------------
bullet_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWVJ"
    "REFUOI1jYBjygBGf5P96BqZbkgbt7EJiTr9eP52hln11Lkmm35ioUfDmZP7/359P/n++K/zt"
    "2TZlD3Q1zLg035ymmyaoazRJUMeO8evjUwyMDMKcDH8Zgjylf91feur9FZg6JlwGsHDxegro"
    "+TL9/XabgUNEioGFi4FByt6AS1FbZjqyOpwG/P3x8/rv9w8Y/v16w/D/100GNr6HDAw/rjJ8"
    "ef4TxdUs6BqvT9Yx4RSXnMbCyy3y789VBqZ/HxgYmHgZ/v/+xXBjxc0f1299TMNpwK0Z+jHM"
    "bNxFYhYhhv9/7WJg/PuC4erWj1+ZPz37wszIyHDj/ofs2BWP1uI0gF1YoljcOsrg15vpDCws"
    "/AzX9379du70qzzxz59Wi4gwMEQvfPsZI6xQAoSJ8Rcj81MGZnZRhqs73ny5eO5VVvrS+4tx"
    "hROGAc8evN7z6eM+ha/vv32/c+tVWcrCu6vwaR4mAACieoqNpo5gggAAAABJRU5ErkJggg==")
index.append('bullet_key')
catalog['bullet_key'] = bullet_key

#----------------------------------------------------------------------
bullet_orange = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALFJ"
    "REFUOI3tkD0OglAQBgdjpdYmit5BC4/CFeg9gT+JJ7DjCvQ2FrZaeQcSNZIQJeKDBw+0N2tF"
    "y5SbyeTLQkNtLOn42Y6HVJVLaRw+BvLMJ3t71orrr9sWs1XlMpsvsKdQagiOi2y/Blj+qi05"
    "UDjYEwhPEByg1ydROJIqB7SG9AkqBqNBJ7xS0fwTKJTP5QzdEXQG8Lxxj/AlVfyBMoWX7zao"
    "AidREMb40QNP3tBQmy8/00Vr8wx1WQAAAABJRU5ErkJggg==")
index.append('bullet_orange')
catalog['bullet_orange'] = bullet_orange

#----------------------------------------------------------------------
bullet_picture = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWxJ"
    "REFUOI3Vkj9LW2EUh5/zNpqam9wLSiutoC6Ki3S17ehU6OQixQ4laydBB0fBUUGLu7i1bm79"
    "AG4utji4phahUoyJydt775u8x0GiudV8AM90zuF3nvOHA4/epDtY+fJ9IwwKCxeWp0YEMUTa"
    "pnYrFk8c253NpXeLnVyuG1AqFj6W3089C4JSNzjqOI3Esb139Al4GFC3kg+Ckpyc1TmoLBOF"
    "f7Gp49f5EG9erjEzNYIxJjN1BiCiYQtoeU+xeM5A3yCeBN9f4U/V4tUjaNgToCp1VaIrm1KN"
    "Y9rapOESLmxMlQRUUKj3BNxA4Cr2VM4m8PljGs5yWR1jcjj/vxQAk4lEQ+/h8l+bV8MrlGvP"
    "mT0yzI6vk8vlUECQ3iugiqD8/P0Z5xyHaUr6oo/0eB7nHB/eHqKanSADMPhTbaejq3P73Og0"
    "U+CcQ/XuL+4BrE2+bX398dpjps0TECRStIbvdFAaTbv74DEer10DDxeZ9HOv2bkAAAAASUVO"
    "RK5CYII=")
index.append('bullet_picture')
catalog['bullet_picture'] = bullet_picture

#----------------------------------------------------------------------
bullet_pink = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALFJ"
    "REFUOI3tkCEOwkAQRV9p0Sgg4Qg9B1eownMNOEc9mF6BM+AQGCSCQMF0u+luZ/DNuNo+OXn/"
    "52dgYjSJddStbkhlH0WKSMATqqhdubwsn0M3M2tT2csuOSS5koWU7C6H+uQAjkN1ZuWj9IXm"
    "EbkF+mtkvkhpaAvLNQscHdIo4hQN0HuloTXHmgWetvKPDtYzdKU0zvHiXVmu+QOvrqzPPxy+"
    "cLS8+FRf/ZbmhInx/AFZp1UZr8NLSAAAAABJRU5ErkJggg==")
index.append('bullet_pink')
catalog['bullet_pink'] = bullet_pink

#----------------------------------------------------------------------
bullet_purple = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALZJ"
    "REFUOI3tkL0NglAYRY9EOmJlJYk6hg7CCqwBiTbGDViBzsLO0s7OBTQmhEYMoI/fB/byrGg5"
    "5c3JvV8+GOjNSBXuaGca2JLaqimpyH3B29uzCH7dsapAA3vtNo65hjrXuV0q57gRAK7C7SIp"
    "LXPVEJ4l91PFZKqTkVp/xroUCLJYIhJJVbQUnwZBrFLVBSXCf1wFxhKMecsriXkS+CpX+YOS"
    "xDtsQzKElZEQEfgpkac8YaA/X1CSTEruNs+UAAAAAElFTkSuQmCC")
index.append('bullet_purple')
catalog['bullet_purple'] = bullet_purple

#----------------------------------------------------------------------
bullet_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALBJ"
    "REFUOI3tjj0KwkAYBWcNEe0FIYh4DMFz5ApewSqwXsMrpLKwEBQrGytBxNomXSQ/uqhh83mB"
    "FQSxc8rHMDz48xukTSA+uvI43jyOqUKfIfg84KPtVEu1WspzMZcsiuSE0i634RqfNWE9GmJ3"
    "W6rNGr/boaQRfhwwAjbLsXmB3B/U1xu5W30biM3+AL0B0uuTZyUJzdjlKtd4gsCgxgYvLFAk"
    "NOMLrdmENHHe+PMdL9ziRhhMwH34AAAAAElFTkSuQmCC")
index.append('bullet_red')
catalog['bullet_red'] = bullet_red

#----------------------------------------------------------------------
bullet_star = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPhJ"
    "REFUOI3tkDFKA1EQQN/8qElg07kgpEgl3iCCZSCFpY0HsFBIZ58+uYKWtnapPICVCAo22xoW"
    "MWITsvGvm/93LNKEVTYeIA+mmsdjGNhQin0+6djHbqfM2SpbKm4AGcDhvwM6vqzb5LMtLunK"
    "dtjGBMzv9wc+W9w1au5BjmK76ksxkEZnV0LtXE0ds7OHeks+fcLPX9Hk47pxHF+s+qYYqB7M"
    "enn2Plq2l6OmgqaTUTCLe0X/V0Dk1jv1ff2K0NyCs+TTCDLpyyl+7Q8AxNkmpsri7SZRlyGV"
    "3cArTeBl7QUAxn+HuR0PnbEtn/qWJpOh4MK/3A3wAw+AZWhdGog5AAAAAElFTkSuQmCC")
index.append('bullet_star')
catalog['bullet_star'] = bullet_star

#----------------------------------------------------------------------
bullet_toggle_minus = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAJxJ"
    "REFUOI3tkTEKwzAMRX9xDZ686ULpCZrdV0xO0C5ecgTfwXMiI2XolJAmhrZ0zV8Ej89DQsCZ"
    "yx7EGB/zPDeqChHBMkXkGUK47fvXPRCRxloLYwyccytPKTW1DQ4CZoa1FjnnlRERpmmqnnAQ"
    "lFLgvUfbttuzwMzfCZZi13VvG5RSfhMQUZV/FIzj2A/DcN9+QFWhqn3VcOb/vAA/RlME/Jy7"
    "fQAAAABJRU5ErkJggg==")
index.append('bullet_toggle_minus')
catalog['bullet_toggle_minus'] = bullet_toggle_minus

#----------------------------------------------------------------------
bullet_toggle_plus = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAJ9J"
    "REFUOI3tkbENgzAQRV/iILGAx6EhE4SeFWGCpHHjEbyDawO6o0hFFAyKkNLymy99nZ7+3cGp"
    "Sx44557zPNeqioiwuIi82ra95/O3PBCRuigKjDGUZfnJQwj1XoNrHozjCECMkaqqiDECMAzD"
    "7gobwDRNADRNs/IFfLhB13UrX8CHAdZanHNYa3822BwxpdR77x/fH1BVVLXfJZz6X289NVj8"
    "b29D8QAAAABJRU5ErkJggg==")
index.append('bullet_toggle_plus')
catalog['bullet_toggle_plus'] = bullet_toggle_plus

#----------------------------------------------------------------------
bullet_white = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAJVJ"
    "REFUOI3tkDEOgzAQBDeR7Uek4VX+Qt7BO/iCX+WCtAga62TYTUUqRwLRMs2dVqs56YCbyzxa"
    "Yc755Zx7S4qSACCRHLqu+xyyjuPYL8uiUopKKZrnWTnnvtV9tkJJ0XuPWivMDN57kIxnBAAA"
    "kr99n4cEAJKZIYSAEALMDNu2pVbRtUKSwzRN2J9IMq3rOvw5dnOVLyHCW4OVPLtjAAAAAElF"
    "TkSuQmCC")
index.append('bullet_white')
catalog['bullet_white'] = bullet_white

#----------------------------------------------------------------------
bullet_wrench = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWtJ"
    "REFUOI3dkbFLAnEUx99PPevEoKY4HVqKIKLAIK5d+h9aW1wqGhICI1EqajhxqKFFXGosoeYC"
    "x4qajSjwyogDu87L09/93v2ahMq83IK+6/t+PvDeA/jrkN8KuVxunnO+hYgDnPP9WCy29Hnu"
    "cYPz+XwYEdPRaHRQlmU/IkrfO64CSulMKBQKC4IAxWJRt23bl8lkDhVFyXYl4JwTRARd1wER"
    "NcbYbCQSmWOMLbY6vk5wMpn0UEqXJUkCxhjIsjwiiiKYpgm2bWuuguyxmkJGV/t9z/5AIACV"
    "SgU0TQNKKaiq+sQ5X291276gHJXjTYo7Y0NBcnVrgOR7AKN8WeCcFxzHqRNCiolE4uVHQfrg"
    "Pt6wycb0aJ9f8BKomgzOrzXMrYx3XPXLEQ3LSU8NB/0eAmBaCCX1Hd4sku0Et92gZjmNV9Pu"
    "FXu8cHNXg9JjffMkNbHWtcCo0YXTi+pekzJvk5Hds+1JV/if5ANWtq4z52SN3wAAAABJRU5E"
    "rkJggg==")
index.append('bullet_wrench')
catalog['bullet_wrench'] = bullet_wrench

#----------------------------------------------------------------------
bullet_yellow = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAALVJ"
    "REFUOI3tkL0JwmAURY9isBG1FsERrM0CTpDGAbKGmSMrZAY7EcHSDSziT6Hk15B8eZ99eFa2"
    "nvJx7uXy4M/P9LSj3TPD4huDV9dQVUR5QbjYEHfdgVpr8WUebBmvcMTQ3E/b8hQABF21r+Xr"
    "Gk8mLm1xpHntcKZLshxPc9WC8g3SCmLe2KZAjJBk6tavBVEeH7FDFxmteVzOxFcizVV/kCaE"
    "t0NAWeKlOcQ3oueLUN/w52c+nYtPejxtNc8AAAAASUVORK5CYII=")
index.append('bullet_yellow')
catalog['bullet_yellow'] = bullet_yellow

#----------------------------------------------------------------------
cake = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp5J"
    "REFUOI2NkktwS3EUxn/3n+RG2pu0FUGqj5HEwmNhDGO8ShdmLCwMMzXGDHaGHWsdM2xszFix"
    "sbC1sLFkqlS1GBae45EKlUq0vc2jaZL7yP9vEU1rMHzb75zvnPN9BxZh5C77Xo0wyl/wL573"
    "ryjPFjaq0buc+19eLC5Qyh/weLfSuly/8KeJ83xLpM4DeBcLvJm8wlTxPhP5fmtoaPeHcOve"
    "Ne3daxm+t35aek8Oj6ZekjYf8C57NgOXANAABgcHE0KI00l7w5mlQUFmxuLEnhDjyTa64if4"
    "MnaDSPsE1wYsIiEfL8YK033r09t6e3uTAkAXxf5YLHbGlRLHUSjpIRAI8OTLZUaezvAkdZ5w"
    "OEzVBttRBHTPMl0U+xsnSC14NBqNEvxUJJtzWdvhByBdOUjF10em5ADQaXj4NGWzK2GgtCWH"
    "geNeAE2VhZSSIz1tv7hu2QrHVVg1CcDJAyuQUmKaJvnUQ29jgy5jQH1OxbVAk0FHRwcAtVqN"
    "dkPwedJme6IJgFwux9RklhY9Rau8tZCCUb2uIsvCTFQPYZomjuPgOlX2b/b+jK/M9LRkrlRg"
    "ZeAROt+pyPSCQOVOt5Crv7Jy520qlW00qXF0xkH+zB8/dnUVEU8aza4wN5zGSnULeF0X8G/J"
    "Svmx6ilcfYqe+IDqClGLNiNa6mbKQg4yacrjRexkHl+ngX9LVjY2EG2W23ww7rHHZrGTecqP"
    "v+Fm5pAFq/6uLX680WZ8XSGM/TH0eJBK2nIbAppSN93S82N6fBN64tckfoNycEvP0ZS6uSAg"
    "xEUnP2C6+XunvKHtSzQ9ivCF0TzBek9tFumYKDuDWxypKtQ1IcTVxivPY+aR0QP0aGiblVLr"
    "NFhVN5EJTdPeKtQzYGjpjtLQfM8PJss5Ma4x1VcAAAAASUVORK5CYII=")
index.append('cake')
catalog['cake'] = cake

#----------------------------------------------------------------------
calculator = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcxJ"
    "REFUOI2lkz2LU0EUhp+ZuXvh3sKPUtjKwiKkSzL3X1hrtf4Ci/gTYiVYWYT8Am0CycKSFGmy"
    "2y4bsgsbcbsUCirYBLPJnLljkW+yKuLbzMuB885zzjDwn1IrU61W3xSLxedpmh4aY1BKoZQi"
    "hEAIAe89IsJ0Ov0+Ho/f12q1lztJ9Xp9GEL4Ef6uWaPR+Lzqi1YmTdMCYJ6++vBH5OO3z+KD"
    "g4NHewHGmAggSRLuPXiI1hqlNVqptf/6ZXGx1pq9gBDCumiWDWqrWa+3BWGzuk0AgPee10cF"
    "vPc45xCR5enw3uML95eb31ymt5uNMVxdXdHpdIjjmNFoRL/fJ0kSnhy3OWy8Q0TI83yfwPtF"
    "0VpLuVzGOYe1FhFBRPh29II8z4miiHwDsCEQLwBcXFzQarWI45jLy0u63S5JknB9fU2v10NE"
    "8CL7BOIcAFmWYa0lz3OstVQqlbUvlUpEUYSIu4NAPADn5+c0m0201gwGA9rtNsYYhsMhJycn"
    "i5G83yeYu/maIMuyHYLVbqy1RFGEc3eM4OZz6Z+eGnFOAVsPtatPNzdhNru93QuYTCYfz07P"
    "HhtjUqWA5WdaJAUCEPKAE5nfTn8Of5P/7/oF8ekAsn4NhRgAAAAASUVORK5CYII=")
index.append('calculator')
catalog['calculator'] = calculator

#----------------------------------------------------------------------
calculator_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl9J"
    "REFUOI2Nk0FIVEEch7957+3mWzStkwt2EYwSy4LlGRZ0CA9dQlCwThbdVuigF6HjejDBU6hs"
    "EB2r22YHLTZi1cRCN3RTow7tGphmJasr1r6ZNx3WTFkov8v8+cPvmx8MIwA6Ozv76urqrgUC"
    "gSrTNBFCIIRAa43WGqUUUkq2t7e/LS0tPYxEIrfYy9DQ0KzWel3/n1/RaHR5b9YCCAQCtYB5"
    "pesR/2K4/6rf5/MFiwSmaVoAtm1zuOIIhmEgDANDiN3565fCxYZhUCTQWu8uzJ2A2BM2xN+A"
    "RhQLAJRS9LTXopTCdV2klDuni1IKVVsOgEDvExh/wqZpkkqlGBkZwe/3s7i4SCKRwLZtjg8/"
    "oSp6FyklnucVN1CqsHQch1AohOu6OI6DlBIpJWvt1/E8D8uy8PYXKDSQSgKQTCaJxWL4/X7m"
    "5uYYHR3Ftm0WFhaIx+NIKVFS7hMIgIGBAR0Oh1ldXUVrjed5eJ63O2utmfrwgmT6FdmtH2xs"
    "ZTfXc9/7nt1J9VgAUioApqenSafTtLS0MDMzQyaTobm5mcfx+2yVZrh4PkTV0RpezsfKpt6N"
    "R5yOYIUBkHfzADQ0NNDW1oZhGDiOQ2trK5ZlMb/2mjMn6lGGoj7YhBIu5041ArrDAnDzeZkY"
    "GzOl64rCW+9nLbuCT5Ry+eRNALou3eNpahDBcIkFkMvl3o+PjVebphkQAtj5TAWTZn3jO/PL"
    "k8wuT9Dd9IDe5zcoMQ+h0T8FB8AJB3uOVZffbjx9gZrKs3xcecvk3ASfP2X7DyQoSCp7ESIs"
    "oEzDJloPvhlc6f4Nn4k4dMH1GdUAAAAASUVORK5CYII=")
index.append('calculator_add')
catalog['calculator_add'] = calculator_add

#----------------------------------------------------------------------
calculator_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2Nk81LVGEUxn/vfa8377XSICJBUVsUmIsWeudfqBYhzKKihUGLQCLINkEQghIVtAqT"
    "WRfY0gRRbKBmbKlDjTEKEYxmptkH+DU59/1oMeYHA+WzeQ8Hnt/7cA5HAHR1dT1qaWm5HARB"
    "nZQSIQRCCKy1WGvRWqOUolAofJ+bmxvo6em5yW719/e/t9b+sv/XZiKRWNjtdQGCIGgG5IXb"
    "L/iXhh5f8ioqKmrLAFJKF8D3fQ7XHMFxHITj4AixXX/7WvrYcRzKANba7YbcMohdZkfsGCyi"
    "HACgtaa3oxmtNVEUoZTaeiO01ujmagAEdg/A+WuWUjI1NcXIyAie5zE9PU0qlcL3fU4OvaQu"
    "8QSlFMaY8gRal5phGNLa2koURYRhiFIKpRTLHVcxxuC6LmZvgFICpRUAmUyGwcFBPM8jm80y"
    "OjqK7/vkcjmSySRKKbRSewACoK+vz3Z2drK0tIS1FmMMxpjt2lrLyuvnbLwdYD3/Ee2Yzxb7"
    "9GzSPHABlNIATExMkM/nicfjTE5OMjs7S3t7O7lnDzn2M8OZ+DUONJ2mkB2rz42P9b6yM+su"
    "QDEqAhCLxYjFYhhjCMOQtrY2ALwPw5y6coPKT28g3UtQXUNjQ4OcnLG3XICoWFSpdFqqKBKl"
    "Xe+VWJyn8ngTnO/amX53LdKKRhdgbW1tZjw9fkJKGQgBbB1TiWRpCQ6x8W6YqqFONguLbACr"
    "KxItWRDsQ+MXa7u9g1V3649q13XmWV1W5BelLv429/YFKEHq72z8WLjuGNFgHPvFYPvPJc39"
    "P1NkPM+TydDCAAAAAElFTkSuQmCC")
index.append('calculator_delete')
catalog['calculator_delete'] = calculator_delete

#----------------------------------------------------------------------
calculator_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqlJ"
    "REFUOI2Fkk9MlEcYh5+Z2V3kK+xqVFTSYlVs44oxKvlIjT2VA6ENDYdKTUw42F56aCJtPHhF"
    "D5p48oBEPGq5kLRejPFfgFJN2GzBlUA1Wnbjgn8QrV12v/2+mZ0eRARp9HeZyZt5nvdN5hUA"
    "HR0dJ+vq6g44jvOhUgohBEIIrLVYazHGoLWmUCjMZDKZXzo7O39kcbq6ukattc/t+1Ps7u6e"
    "WsyGABzHiQOq5ade3pWLp76NhMPhDcsESqkQQHl5OdGVq5BSIqRECrFwfzL9qrGUkmUCa+1C"
    "Qc0DYhEsxRvAIpYLAIwxHGuPY4whCAK01vNngDEGE48xN3WNz8KXuPfbcTs30w9etj30GlZK"
    "kUqlSKfTNDc3k0qlyGazNDY2Un3hPPlIkn+ty/odB4lt2sWLvz9l/HLPyXlBCQDXdamvrycI"
    "AlzXRWuN1poX32xlbUUlFdHdzN4fJyJ8KqPrqVhdEwsBaKMBSCaTTE5O0trayvDwMJlMhq+/"
    "2EDsg4es3NREcbqXiCNIj0zgF4rPvGJu7ytBEADQ0NCA67qUSiVc12XPJyWiJIltacHLnkFG"
    "NOGKjayYu/3YK0SaGg5fuSsBtDYAJBIJ+vr6kFIyeuMsZV6CWG0LXrYLGQ7wX37M1I0EXj7/"
    "1a7DV0YAJIAf+AsTtLW18U/6OpvXeVRt/xL/UQ8qYim+3MjToT+57n3Oto7hxJJvDHxf9w8M"
    "KB0EIjc5wNZqjRbVTKdOs6oqgjf7EU9uppjZ8r19nhj3lu1BLpebGBwY3KyUcmrVEPH95/ir"
    "92fuDv5BWc1O8k8zTKh9zN6643uF/OhiwdK1Ajq/iwdHDv0QQhpGrv5K+sG9XHRNbF/TibHR"
    "t98CqLcLq53gaPrBGDr3rFQsM79LSk3NJ+5M/B8M8B881k6NOlvoKwAAAABJRU5ErkJggg==")
index.append('calculator_edit')
catalog['calculator_edit'] = calculator_edit

#----------------------------------------------------------------------
calculator_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmtJ"
    "REFUOI2Fks1LlFEUxn/3Xmdy3ho/YgQdKygX4qiQKO9AQdg6EHShSYugP6CFbtuEbQpatBIr"
    "goI+iAwRSqk2Ay0yx7GUEsEoTGaaEAVLR+d9770tNHVQ6oHDuffA8zvP4giAnp6eGw0NDd2O"
    "4xxRSiGEQAiBtRZrLVprfN8nl8stzs/PP+7r67vMbvX393+01i7b/2tjYGAgvdtbBOA4TgxQ"
    "bb1P+JeGb54PBgKBqj0ApVQRQCgUoqSsHCklQkqkENvvn5nNxVJK9gCstdsDtWUQu8xS7Bgs"
    "Yi8AQGvNtYsxtNZ4nofv+1vdQ2uNjpUCILAFAPnXrJRienqakZERgsEgMzMzJBIJQqEQNeNP"
    "OfbjDhtrSxhj9ibQenPoui4tLS14nofruvi+j/ZWWWsSHD7azq/5F5jCAJsJfO0DkEqlGBoa"
    "IhgMMjU1xejoKMW5FGVVcUqqmlj68gqHxX0AngdAPB6ns7MTpRSu69Jx7jR+NkE4UoZeGaai"
    "rpto0WeSA82BQoCvAUgmkwwODiKlZHIyxdy7u0Rq22E9xfsHDzlUlqNUf0cQbisA5L38doKu"
    "ri6klJyscThRXUG4fA2z8RWsQf8e53hrLzqf73t7/VQYQAGcbW29YqwVmXRaZLNZstkMeu4+"
    "0fpWlElh/SWisQjWrBF0DkCgsWJlIbl+700mobY2d6bTmXAmkwmk02nU0hixugbKox5mfQ6w"
    "TDyfJRqLgFnlYGUzC+Ov6y+dibwsPKstjd2KLzReeFSt5DesvwwFxyNRoVqynz4wO3z1WdF+"
    "AG8jXzxxuyNnjcUas1nWsvO3YAwYW/kHUSo+NdPjEm8AAAAASUVORK5CYII=")
index.append('calculator_error')
catalog['calculator_error'] = calculator_error

#----------------------------------------------------------------------
calculator_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqVJ"
    "REFUOI2Fkk9LXFcYh59zz50Z7lxNnI5BK0FBJFD/7GSyigPZZVModGEFSTftQiQL8xEMBCNd"
    "lanMJ0jSRbXZ6OKCXONGcIQqaFEQZtA7HUeaRObijPecOVlMmjoI7W9zDi88z/lxeAXA3Nzc"
    "i9HR0e+SyeRdKSVCCIQQGGMwxqC1RinF5eXlealUejk/P/+E61laWvrDGPPO/H8a+Xw+uM7a"
    "AMlkchiQXz99xX/lzU+T8Vgs9uUNgZTSBnAch1tdKSzLQlgWlhCf72fl1sOWZXFDYIz5PJCf"
    "AHENtsS/gEHcFABorXn2eBitNVEUoZT6dEZordHDtwEQmDaB9Q8spWRvb4/V1VXi8TgHBwf4"
    "vo/jONx78zt38z+jlKLZbN5soHVrmMlkGB8fJ4oiMpkMSimUUlQff0+z2cS2bZrtBVoNlFYA"
    "7OzssLKyQjweZ3d3l7W1NRzHYX9/H8/zUEqhlWoTCIBcLmdmZmaoVCrU63UKhQLHx8ek02nO"
    "zs6YmJjAdV08zyOVShEEwbsgCJ4fHR39YgMopQHY2trC8zyGhoaYnp4mDENOTk7wfZ9Go8HU"
    "1BRSSsrlcqpQKLwoFot3bICr6KpVRwg6Ozt58PAh+Xye7e1tent7GRsb4+LigsXFRcrlMh0d"
    "Hauzs7OPisXijzZAdHWl/I0Nub6+LtLpdOtD799nc3OTyclJUqkUtVqNarVKLpcD+BYIu7q6"
    "EjZArVb78+3G28H37z8k6/U6AL++fo3WmoWFBVzXBSAMQwATi8WWAU5PT+ttazUyMvLV4ODg"
    "b9lstre/v79p2/YXlUqFw8NDEokEAwMD9PT0oJT6u1QqWb7v/9W+lyCz2eyY67rLfX19dxKJ"
    "hDTGWOfn5z8IIU67u7uXgVij0dBBEFTDMPzmIy7QU0RWlhc1AAAAAElFTkSuQmCC")
index.append('calculator_link')
catalog['calculator_link'] = calculator_link

#----------------------------------------------------------------------
calendar = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjBJ"
    "REFUOI2lk81LlFEUh5/3w1EbczTmA5qoyEgCiyQQW1U7aRNU61q1CdpWtIhZRJsWbfoPAsFI"
    "MwrbhJBlfiFRRBBWOoSfM0gjxjBz7z2nxauOgRvpwOHcw4Xfec4598J/mgfwZGT1nqh3XVQO"
    "iAhOwIrgnOBEsU62ucNZxTmZenD1WFcI4FRvXunam9xN5VzfzEmAEEBEkwDx/hugCs6CODAm"
    "OlcrYKpQMWAMf+4MY4zUbwk40Q1dhf0pEBu52g2RCpgK2Cp8XQTAWEdNwEltJAsFUIlIRCIS"
    "txmBTAaA6oYAAI9fL+p62Wjvu2VVVe17v6Sqqk8/RPmzsSgfHI9ioVTWa4+mdIvAOEFUCQPo"
    "H1shCHwGxlcIA3gxucLo8n1GBgUVoW46x/HsHqomIvA3W1AgDDwun0kT+nCpO02dDxe70vhe"
    "QHvbUXw/4MLpTLRaK/xDoAKhD6+mC0wWHzIxpKgq4cfb+L7H7FyewA94PrFMNuGjbBewgqpS"
    "F0BPZ4qxIThy6DA/83P0dKYIvLt0t7ciTpmZL7GvuZ54fVhrwUqkFvgebz4VAZjN5/HwGP5c"
    "xAiIKN8XSrQ0xUg2N2xtLgSw1kYz8OH8iSRhcItzHUnefilytiPJwHiBH/NrJOIxUokGRJTA"
    "p0ZgXNRCx8EmFlfLtGUamV1aJ9sa49uvEtkEJJpipFsaI9LAw0mEHT0kK6O53plTRiRurMNY"
    "h7OCcYJ1dse/8Hut/HLHi93aX804TpCtCEjKAAAAAElFTkSuQmCC")
index.append('calendar')
catalog['calendar'] = calendar

#----------------------------------------------------------------------
calendar_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmVJ"
    "REFUOI2lk0tIVVEUhr99zrHsRQU+sqSX0QPSNOFWEjQqIoSiGjQqGkSgNC4KwkGEUOCkHDUr"
    "BEOjLAp6WNlDM8K8lmAhIYGaimQpdu/ee60Gx7RmRQsW/16Tf39r7bXhP8MAXG0ZPStqjolK"
    "vojgBZwI3gteFOflt/R4p3gvr88fXpuIALzqiYOJBVn/cnNV/ccigAhARLMA5jVWgCp4B+LB"
    "2vicToFNQ8qCtUycasZamT1t4EWnfBWWZoO4ONVNmaTApsCloXsAAOs8MwZeZkbSPwwqMYlI"
    "TOJ/KZCbC0B6ygCAS/cGdHzSat2zL6qqWv98UFVVr7+M64bWuL7ZFuvw2KQeqXmt0wTWC6JK"
    "FEJj6xBhGHCjbYgohFvtQ7z4co6Wm4KKkPGmig3L5pK2MUHwqwUFotBwYFsOUQD7t+aQEcDe"
    "RA6BCVlXsIYgCNlTmhs/rRP+IFCBKIA7b4ZpH7nAq7uKqhJ1nCQIDL2d3ei3CY7X7COVTpNO"
    "bZ4hsE5QVTJCKC/NBmD1ipUYY9hdkk2+K2RhpmfXju1UHKqkuHQVmYuaSFTmXQwg3jqAMDA8"
    "7BwB4FNfHwZDc3KEjg8NFK/fhA88m/J24o1la2EZoJUAnL7Wo6PfU9qcHFZV1cddsT6Z0vIz"
    "JXr33RX9PZqSl3VLZZ4G0zNQZePy+QyMTlKQO4dPg+MsWzyLns9jjI1/5X3/S6ofHAWg+v5R"
    "eoeSKPojXiQnL6rqPhZbkXnWeazzeCdYLzjvmJ25h7bkI8qKtnO7q5ZZJuL526eAuWz+9vMk"
    "KpZUY0yFgQUK31Gtba8dPPUTIAaHVsRZEPYAAAAASUVORK5CYII=")
index.append('calendar_add')
catalog['calendar_add'] = calendar_add

#----------------------------------------------------------------------
calendar_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnRJ"
    "REFUOI2lk11ozXEYxz//l8MYaZztjOGYeUnmLTVcITcjRSgpcSWlXJBwpXOh3bhws6zcSSnv"
    "LzF5mbeZDS0mKclmyd7O2Yqx0zm/3+95XPxn44786un5PTef3/f5Ps8P/vN4AGefDBwT9faI"
    "ynQRwQlYEZwTnCjWyW/hcFZxTl7W7JpXFQI41f3bqibG/+Xl1PkPiwFCABGNAxRe3geq4CyI"
    "A2Oiez4HJg85A8bw4+gDjJGxIwAnOsxVmFYMYqNQOwzJgcmBzcO7bgCMdYwCnIxa0pUGlUiJ"
    "SKTE/cpAIgFAfhgAQO3tbv2eNXqusVdVVc8/7VFV1QvPovpSc1Rfa4ly+mtWd598qSMKjBNE"
    "lTCAy819BIHPlZY+wgCuv+ijqfc4T64JKkKsNcWCsvHkTaTA/9WCAmHgsXVVCaEPW1aWEPNh"
    "U1UJvhcwv2IOvh+wYXkiGq0V/lCgAqEPN1vTvMic4Hm9oqqEr47g+x6x+ntUt72mofY0OqWU"
    "JUUbuTgCsIKqEgugelkxzfUwOzmL9s5PVC8rpuB5GVMGWpm78xBjyxeSfXOXSY0NrFgX7vch"
    "2jqAwPe435YBoKOzEw+PB28y5B7WMWf1Zgo+PsI7s4Px7VcpTxbh0AMhgLU28sCHtYvihMFh"
    "1lTGefw2w+rKOA39nykoLYcNB0cmF6amEqg3a9QDVSpnTqB7IEtFYhwdPd8pKxrD+89f0ckJ"
    "hl7fovDGPnLZHoaAwW8BLqArWiQrTalzH5YakUJjHcY6nBWME6yzrCrdwoSWOyQnjyMMYgym"
    "Le29vqq6U97ffp7G7TOODvV37fXFS4qvXwStW39fan4CNrlrNXVrUrgAAAAASUVORK5CYII=")
index.append('calendar_delete')
catalog['calendar_delete'] = calendar_delete

#----------------------------------------------------------------------
calendar_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApdJ"
    "REFUOI2lk0tsTGEUx39z7+31aKtFZ0g7fahHUEEiusFCIiIhFdItiYUuiDUWREREWFggLKxI"
    "BPFIoyEeqaBaBqXEI5pKlJppb40qfczc+51jcWVqYyFOcvKdb/P/fud/vgP/GRGAs/fTe0Uj"
    "W0UlLiIYgUAEYwQjSmDkjzSYQDFGnhzcPKfWATCqO+prC0v+5eV9FzoXAjgAIloCkH95G6iC"
    "CUAM+H5YZzPgZyHjg+8ztKsZ35dxOQEj+ltXoTQKEoSpwW+RDPgZCLLwJgmAHxjGBIyMWfLF"
    "A5WQRCQkMeE55A7xeW459q3DNLj3aDhRsxmA4zeS+nPE13MPelVV9UJLSlVVL7aG90ttKR36"
    "0qjJ5p068LJJ9UePfnt5SVuPrEk5AL4RRBXHhsttfdi2xZVHfTg2NCb68LztDBfWMGX2MtJd"
    "b3EjWQonTadgakVRrgUFHDvChtoojQmP9bUxmp72sarqHcP58yiuXk0meR53YoSPL94xOGxB"
    "1luUI1ABx4KmZx6J/iM8vq7EJcXI+HKKZ9Ux2nMKyw3IK6jEDbo5k97Eid31763QUUFVybNh"
    "3ZIoADXOMBunl1E0q47RnpNYeT7ZwSp673egS/fw040DYEH46wBsK8Kdjn5KBrpZrBOI1awl"
    "mzqN7SqZwUp6H7TDyqNEqxbmJucABEEQemBB2Y87lE6eSaAxkq+OMTnmMpoupz/xFmvlUaKl"
    "lYgotsUYgW/CFhZUFNDRcpr5yxsY96mF940PeXEzzevbz4ks208sXh2S2hGMhNjhFAJ5uO9c"
    "52JfJL+0yyP7uokZi1bw3ftKV3snd+MH+Hr1O/A4twsDgyPXctv4Z9QvLx5ZMnOas3ReNZqX"
    "ac143pZ1h159+NtS/QL+22ySEHdAsQAAAABJRU5ErkJggg==")
index.append('calendar_edit')
catalog['calendar_edit'] = calendar_edit

#----------------------------------------------------------------------
calendar_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq1J"
    "REFUOI2lk01oHVUUx38z85KRTmtSeM0jL9ogiUqFSECMrQQTUEviprQKiQjVTVosdeMquGgD"
    "aiQE24VV3LgShFb74UqwUCFNmtIkurDRNkbkxbyvvEdNxLGdd+ee42LyId2JFw7nnM3v/s89"
    "/wv/8zgAn0/cOSHqDInKQyKCFYhFsFawosRW/hUWGyvWyszo4ce6UgBW9a1Xunak/8vNI2d/"
    "eRIgBSCiaYDg/DFQBRuDWDAmqWsRmBpEBowhHL6CMeJvAqzoOlchuwskTkLjdUgEJoK4Bj8V"
    "ATCxZQtgZetJChVQSZSIJErsRgYyGQBq6wAAznxT1L/uGv3iallVVc9OllRV9dy1pP9qOukv"
    "XU9yZe2uvn56RjcVGCuIKikPzk+v4HkuF66vkPLg6xsrTJXfY+KSoCLUzY2wp2UbNZMocDdG"
    "UCDlOby8r4mUC4f2NlHnwoGuJlzH4/G2dlzX46WnMslqY9nywQcXcvrm/mYmfl4lNhFTcx+y"
    "M0yTbcqSL1VY3V0AHx64FdDW0k61eoebfzRQnD23PRkhFlQVV2NWb11mtzzCwBsDhGHI8vIy"
    "0ze+p2FHwPMDvXieR7FYxJ+b49v6+pMpSFwHsDg/S3FhkYHXXuWd8WFWbldobs7S0dHBUu43"
    "xsdnKJVKPLN3H709z5HL5Y64AHEco8DS4jwND24H4JP3PyWqxQwODtLd3U1/fz99fX3Uaoah"
    "o8cBaGxs9De3oKo88ejD/PjDbGLVd0dRsYyNjREEAQBhGCKifPzRKfa/+AL5fP6eA/D2Z/OT"
    "xkjnWvX34M+bX/Ls051kW1rYVu9SLpdZWFjA931aW1vJZDL8HQn55SUzOfHdr859f8Tr6enp"
    "CILgYjab3eX7vqeqbrVaHXIcJ59Opy8CdVEU2UKhUAnD8OA/hzl9PuYroUEAAAAASUVORK5C"
    "YII=")
index.append('calendar_link')
catalog['calendar_link'] = calendar_link

#----------------------------------------------------------------------
calendar_view_day = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAc9J"
    "REFUOI2lk79rVEEQxz/v7pkUp4UQDYgYFVQQE6yCEAmCELBKwGtsrLSIILZWkkLs7PwPRCUQ"
    "UbATFBJOLBQbIQgHppGoRESUnLydnRmLfe9+4CEEB5ZddpfPfL8zu/CfkQHcX/t+yzy7am4H"
    "zQw1iGaoGmpOVOsbikZH1d7cuXx8OgdQ9+vN6T1jO8m8tNyeAsgBzHwMoPH4GriDRjAFkbQO"
    "BUiAQkCE7ZsvEbHRLkDNS67DgX1gMQ2PJaQAKSAGWP8MgESlB1DrlWRzC9ySErOkRKsZGB8H"
    "IPQDYgl4NHGbS2f3/9P7yutNzoU4qEDUMHfyerr09P0KrY1VrpxZ5MPXdV60n3P+2BwLk00K"
    "cX51hCAJUKssOJDXMwAWJpt0QgeAb9tb3J2/R2tjFYAiKkGMGK0HEDXcIK/9LbkTOozUR7rA"
    "Qqwsdz8gGu7OrtJC62PK9u7TWw7tneDGk0XmTlygugvQGM37imhps15LFmaOzDJzdLbsS8b8"
    "qYtkWTYAqDqXADHipZwHa19S19wRBVElqBEkeR+pV8kY7IK7M3V4Nye1evve/QvDQi3JTg8p"
    "2qulh+3TYtaQqEhUNBqiRtQ4FPDj5+9nQw92Gn8AGpcuIyGyvtMAAAAASUVORK5CYII=")
index.append('calendar_view_day')
catalog['calendar_view_day'] = calendar_view_day

#----------------------------------------------------------------------
calendar_view_month = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeRJ"
    "REFUOI2lkrtrVFEQh7899240bAgI2V1QsAlYrU0CRhujrQiiqcXev8BSG1sb/wIbiW9B1kYW"
    "FTFRyYIShKBgEXAfdwmuJix7zzkzFufuIyZNcGCYMxz45jcP+E/LAdx7u1VT5ayoRiKCF3Ai"
    "eC94UZyXMfd4p3iRndtXT0zFACq6uLQwbQ5S+eby9wJADOBVDUDh8XVQBe9APFgb3mkfbAp9"
    "C9ayc6OGtZ4RQDTjKhwtgrjg6jJIH2wfXApfGwBYNw7wMhrJzwRUghKRoMQPIlAuA5BmAADu"
    "vmzods/qwJbfNVVV9cH7lqqqPloJ+bPVEJNuT6/d+aRDBdYLosrDlTYGiCLDk9U2cQTPP7aZ"
    "nDBU6wn5vKG61mK2dJg0m4EZtKBAHOVYOlMiNnDldIm8gUunSgBcmCuGOB9acE5GAOsFFYgN"
    "vFhLyMdQrScYk6NaTwCG8emHVjbucYATVJV8BBfni7srzhXJm1F+eSEoKByKRwAngRaZHK8+"
    "d3ZVrH3pYIU9Sgabi0M/LszAwPmTM7xe73CuMsOb9Q6LlRn+tY3NLlF2t8MtqCqV41M0tnrM"
    "lif50dzm2JEJNja7ewAAkh1fOCQnv2/d/zadesE6j3Ue7wTrBefdvoBff3rNfT8Oan8BS8wz"
    "nTw4DIgAAAAASUVORK5CYII=")
index.append('calendar_view_month')
catalog['calendar_view_month'] = calendar_view_month

#----------------------------------------------------------------------
calendar_view_week = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXRJ"
    "REFUOI2lkz1rVFEQhp/sLqZYBIuEgFinDNrkP9inTqo0AXsrSSFpY2GXygSEEK0CphEVwTTp"
    "bYKNoCsEQowfy70z806Ks5u7RViu+MIwpzjzzDvnA/5TMwB7H8+fKGfWlboniRC4RIQIJR6a"
    "iCA8idDJ1uricg8gMh+tLN+e+5fOm/unSwA9ACnnAPqvNyATwkEBZmVdV2A1VAZm/Hn8DjPN"
    "XgNCOeIm3J0HeYn0EaQCq8Br+DwAwDxoAKHmSL6fQao4kYqTGGdgYQGAegQA4PnRIH8PLTMz"
    "X7wfTM0Hx9/y7Ocw17ZPEqADYCGUSRtVlvz6a9RWHHTGI7Qrh8qD2oS7GoCFSE2tm3BQNiaT"
    "ABfZcgQbde7P9hqAq2X7CcD45noA7k4Cux9+0O2UrEx23g6wCJ69+UptwdNXX7jVLYXdDg3A"
    "oozw8MEdPMZvP6//wk0KFdvlIbk+bb48vW9S3zwwD8KFhfDwGwEXl8PD1nNP0xWHIy2+xFk6"
    "cAAAAABJRU5ErkJggg==")
index.append('calendar_view_week')
catalog['calendar_view_week'] = calendar_view_week

#----------------------------------------------------------------------
camera = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkRJ"
    "REFUOI3Fkz1PU2EYhq9zOC3HkJRQPk5QgdTUiAnEIAOTmrAwObgy6E/QkT9gXJx0IAz+AkZd"
    "jNFowmpIag0pJDpgQotge6ic8370fR8HpcbEWe/pXp4r1zPc8L8TAKyvrz9USi1ba8855wKt"
    "dUEpVdRaF5xzQRzHplwuv1hbW3sAsLq6umit/by5ufkt2NjYGBaRzsLCAiKC9x7vPTvbr7h7"
    "+zLm0zOevJmllFyl0di91+l0ngIlQERkaaBSqdTn5ubKSZKwv79Ps9nk6OiI89OzvH3/lUb3"
    "OtcWbxAEAQcHB3fCMByM45goioI0TW9GIlItlUrU63UmJiaYn5/HWotzjvHxcXZ2dtja2mJ0"
    "dJTl5WVarRadTgdrLY1G40rknOPw8JCxsTHs0DSPX+ec9gI8MBgUuHXxEuVul93dXZIkwVrL"
    "3t4ek5OTeO8Jvfecnp4yNTXF8w8GLSFxISQuhriwwLsvQyRJwvHxMdZajDHked63jLz3aK3R"
    "WvPdFYmLA0QhiEAggpEiSimUUhhj0FqjlEJr/dPAOdenAoj4n8chhCEMhAFZlmGM+cOgDzgz"
    "ODk5oSiGng/wXnBOEIEiOWmaYoyh1+thrUVrjbX2NyDPc2q1GgvDTQZ6Gdp7el4IXcYF/ZHt"
    "7e3+32eQM0CktSZNU1qtFqPtNkuVCs45rLV0u11qtRrNZpNqtYq1FqUUMzMzZFmG955gZWXl"
    "frvdfiQigyMjI4H3PnDO4b3HOYdSSrTWIiKISH8Dv/rLfzy9v+QHngiXRpqnCBAAAAAASUVO"
    "RK5CYII=")
index.append('camera')
catalog['camera'] = camera

#----------------------------------------------------------------------
camera_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAshJ"
    "REFUOI2l001oXFUYh/Hn3LkzuWnGkUw+bhNN6FSlKWRS01hTglZIKdSFBXGXhSLuiouCm1m6"
    "kXbhRoWECOLSRRZF05VaPzBuAiJOo2Em0AgpJpOP5t6ZzMw59+Sc00Uw4KoF//v34bd54X9O"
    "AMzNzX0kpZzWWncaY4RSKi2lzCil0sYYEQRBks/n75RKpRsAMzMzE1rr9YWFhYdifn7+aedc"
    "ND4+jnMOay3WWlZ//46333iB5P4XfPrDCLnwLJVK9Z0oij4DcoBzzk2mCoXCyujoaD4MQzY2"
    "Ntja2mJ3d5fB4RF++m2HSuM85yZeRQjB5ubmm57ndQRBgO/7Io7jS75z7vlcLsfKygr9/f0U"
    "i0W01hhj6OvrY3V1laWlJXp6epienqZWqxFFEVprKpXKGd8Yw/b2Nr29veiuYT6+26Z5KLBA"
    "h0jz2rOnyTcaVKtVwjBEa83a2hoDAwNYa/GstTSbTYaGhli8l6CcR5D2CDIexkvz84MuwjBk"
    "b28PrTVJktBut4+VvrUWpRRKKQ5MhiCTwvfAORDOkbgMUkqklCRJglIKKSVKqSOBMea4CuCc"
    "PTr2wPMg5QlarRZJkvxH8G/gWFCv18m4Tg5tgIcDd6TI0CaOY7LDgnLrLq3OA05M1NnZv4+1"
    "ltTY2NiH2WyWKIoY7uui1s6gRQoA37Z5JvmTtX9+5PRUjlcuTHL5wlV0sMdGUmY/OsBXShHH"
    "MbVajZ79fSYLBYwxaK1pNBqUy2X84kNeHJnCeIZzA1f4/q8FLhan+Lu6iB9F0Y319fWbzrmO"
    "7u5usby8LIwxWGsxxiCldCefMyItsrx+9j0APrj8OYv3ZsH75ugXHreL7w+237p2NTjEUrry"
    "Jbe+fZcg1cFXt7+WqScJDL6U7WwkO5dOhafYbT0gbm7z6x+/UI/UJ08kAHj5+slbCHFdwFMO"
    "Gjg3uzy7VXoErq+Qw8a/E8MAAAAASUVORK5CYII=")
index.append('camera_add')
catalog['camera_add'] = camera_add

#----------------------------------------------------------------------
camera_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr9J"
    "REFUOI2l081rXFUYx/HvOffOzK2BiZm83KY2CVcsTTFRYpCCrxDdqLjoSgzSdtelxVWWRVoF"
    "caWLkIV/QZZV8KVKtQEhWApjyjAJTaBjXibNtPdmnLn33JNzjovQgCsL/vbPl8/mgf85ATA/"
    "P38ty7IZrfUxY4xQShWyLCsqpQrGGBEEQV6pVL6dm5u7DDA7Ozuttd5YXFx8KBYWFnqdc/HU"
    "1BTOOay1WGup3fmJ8++fIl//hq9+GaccnqFeX70Qx/HXQBlwzrmzXhRFKxMTE5UwDGk0Guzs"
    "7LC3t8eJ0XFu3n5Avf0SL06/jhCC7e3tc1LKUhAE+L4vkiR5w3fOPVcul1lZWWFoaIjJyUm0"
    "1hhjGBwcpFarsbS0RH9/PzMzMzSbTeI4RmtNvV4/7Rtj2N3dZWBgAN0zypc/p3QOBBYoiQJv"
    "nnyWSrvN6uoqYRiitWZtbY3h4WGstUhrLZ1Oh5GREa7/maOcJChIgqLEyAK//tVDGIa0Wi20"
    "1uR5TpqmR0rfWotSCqUUf5siQdHDl+AcCOfIXZEsy8iyjDzPUUqRZRlKqUOBMeaoCuCcPTyW"
    "ICV4UtDtdsnz/F+Cx4Ejwf7+PkV3jAMbIHHgDhVFUpIkYVpsMvr9FUb3tjjtlWjsvsDvjwNp"
    "mlKtVpk6McmdZAjlB3hCULApz+R34fZ13os8zrz1MaXoedLqj9y9dYP1+wm+UookSWg2m/Q/"
    "esTZKMIYg9aadrtNtVrl3IM/GP/oU4J7N+G3qzzV+zTR2Biv1Nbw4zi+vLGx8blzrtTX1yeW"
    "l5eFMQZrLcYYsixzlbISwfEI3v3k6Af8K8MMoA9/4b/2w9te49UPL57suf8dKt2hC7T3PWr3"
    "2PSeJHDp5eO9D5tbr8miJ7XXIWk51rekMQfuiycSANz6YGSu29q6JK0Ys9JtWtz8OzfsZ/8A"
    "AF2VUGgadc4AAAAASUVORK5CYII=")
index.append('camera_delete')
catalog['camera_delete'] = camera_delete

#----------------------------------------------------------------------
camera_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwVJ"
    "REFUOI2lk09om2UAxn/vly9fsq3L3zap0nbNrLabjbObZYL/oEMjigMPuxR1HkTxNA8iRT0N"
    "RAYeRA+l6O5jZQfRiww3J1UPqzrblDSFdRvZ2iSLTdI2f97vy/u+HnqrevI5Pjw88MDzg/8p"
    "ATA9Pf1Ju92e8Dxvj1JKSCn97XbbkVL6lVIiGAy6sVjsu6mpqfcAJicnj3med2t2dnZDzMzM"
    "hI0xtbGxMYwxaK3RWpP74zJvvPIw7up5vrgyQih5iHx+5XStVvsSCAHGGHPcl0qlsqOjo7Fk"
    "MkmhUKBYLFKpVHhwYIQff7tPfusoR449gxCC9fX1Vy3LCgSDQWzbFvV6/VnbGDMUCoXIZrMk"
    "EgnS6TSe56GUoqenh1wux9zcHPF4nImJCUqlErVaDc/zyOfzw7ZSinK5THd3N96+AT77oUWj"
    "I9BAQPh5ru8gsa0tVlZWGO6t8lRwAd9QmkblGpWBFpbWmkajQX9/P98uukhjEfRbBB0LZfm5"
    "dncfyWSSvq4ch8J1etOvMTTxJgfG3+aF4Qi21hopJVJKtpVD0PFhW2AMCGNwjUOXmuf1U+OE"
    "o+Ns3MzhCJf9oV66kwPYSilc16XVagEOxmiMsRAWWAZGAr/zxGEfkYMZ5PoFnL2COzeW2W54"
    "nL10c2eClJLNzU0c49LRAq0NShlS9jzvjC0Reehl2mtfIfxV/F37caurfLNsU6y5OwWtVouF"
    "hQXGwkV8nSZSa3qbVzl9eJHw0Ena96ax/B7u5iD3rlzn86uG4raF1hpbSkm9XqdUKhGvVjme"
    "ShFoZjn6iJ/Eoydxi1/jcwzt+gGKP13nYmEYIg2azSZaa0QmkzlTrVY/NcYEotGoGOyqijNv"
    "PU9HJIjHfiaacGjX+1m9/CsfXNrQ5S0NOzcE+F7shuPiuRPm1LvnyV94n7XbvxAYOIJXvr8W"
    "8ZF5/KP57O68b7fx2OCej5/sC1vRB/rZuFuhsJTb9vl9J54+++fiv9H4j4L4Xu/DO6tLdLb/"
    "0jKg5iz0iy+dyy7/F85/A3CTd8eugI0LAAAAAElFTkSuQmCC")
index.append('camera_edit')
catalog['camera_edit'] = camera_edit

#----------------------------------------------------------------------
camera_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAudJ"
    "REFUOI2l071vW1UYx/HvPffauSbEaR2/1G0SYVSaNE1UuRFKlzaQBTFUKGULEv0DWJBYIjEx"
    "sCAWXqQQBAsSMASWwsCLQCAyQEoKpG4tx6KtlIJjN4pf4uTe4+NzDkNEwpCNR/oNjx7po9/y"
    "wP8cB2BhYeH1MAxnlFIxrbUjpYyEYRiVUka01o7v+51EIvHl/Pz8ywBzc3OTSql7S0tL287i"
    "4mK/tbaRz+ex1mKMwRhD8bdvefHKE3Tufsjb348Sz5ylVFq/1mg03gHigLXWTrm5XK4wPj6e"
    "yGQybGxssLm5ydbWFieHR/lh9SGlnQucn7yE4zhUKpVZIUSP7/t4nuc0m83LnrX2dDwep1Ao"
    "kE6nmZiYQCmF1ppUKkWxWGR5eZmBgQFmZmaoVqs0Gg2UUpRKpRFPa02tViOZTKJ6h3nzu4Dd"
    "roMBepwI04OPk9jZYX19nUwmg1KKcrlMNpvFGIMwxrC7u8vQ0BBf3OogrcCPCPyoQIsIPz7o"
    "ZXRIM3vxIVa36XQ6BEFw0FIYY5BSIqWkrQWe5+J5gojYj+ta0t4a5y48R0oUkVIShiFSyv0G"
    "WusDFcBag7XgCBACLsZ/JvPYNPFsnuPOn/SKOkEQHAL/Nmi1WkRth65xMMaitSUhauSjP9GX"
    "PIZuXefU+Wucjt+nqyRKqUMgCALW1tbI92/idveQxqCN4cnINwyduwrhTVY++phHjwWk3Cpn"
    "0uoA8KSUNJtNqtUqA/U6U7kcWmv6+Jt81tJ3fA/dugfWoNs3yD31Cs9uv8Gnf7QxxuAODg42"
    "yuXydKVScev1OoVCwblz+xaXhzcYmbqCa25iu9ucHEtizR7RR3qI+WMUV762d/5SXzlHPciv"
    "7116KTU2++6JMzF0ewVrO6x+XmTy+bM4bj/EnuHGB6/WnK55+kjgl7emHky88MkpV9zHduuA"
    "/c9V4MZGqN7+ndL11z7zjgKU7Pir718NrLFYY/ZjLYe7BWPA2BP/AIfDpm7zMdXZAAAAAElF"
    "TkSuQmCC")
index.append('camera_error')
catalog['camera_error'] = camera_error

#----------------------------------------------------------------------
camera_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAslJ"
    "REFUOI2lk09oHFUcxz9vdjaZtmElmz/TxCSy0WJis2gsEkGisMXePPSagz157zEHb1rqwZOC"
    "IQdB8JijnrSVCkmq0bQYQ8Nu0MWuNrsxsTPZ7M689+a956E0glAQ/MDv8jt8+Fy+8D8RAEtL"
    "S9fSNK1orU8ZY4SUMp+maY+UMm+MEUEQqGKx+OXi4uJVgIWFhQta6/rKyspfYnl5+SnnXDQ7"
    "O4tzDmst1lp27n7N22+dQ/36KR99M0UhnKZarV2JouhjoAA459xcrlQqbc/MzBTDMKTRaNBs"
    "Njk4OGB0Yopbm39Sbb/MixfmEUKwt7d32fO83iAI8H1fxHH8uu+ce65QKLC9vc3w8DDlchmt"
    "NcYYhoaG2NnZYXV1lYGBASqVCq1WiyiK0FpTrVaf940x7O/vMzg4iD4zwYc3EzqZwAK9Is8b"
    "Y5MU221qtRphGKK1Znd3l5GREay1eNZaOp0O4+PjfPGzQjqPIO8R9HgYL8+3v58hDEMODw/R"
    "WqOUIkmSk0rPWouUEiklx8bD93P4vkfee3SZ6CFNU/oqNW50PyBRXdI0RUr5qMAYc2IFcM7i"
    "HAgPPA9ynqDb7ZJmirHBae70fUaiOicC/3HB0dERPe4UmQ3wcAS975DLabAZ61nG08VzTJ+d"
    "o512+Gn+O+QvI/8IkiRha2uL2dEyd+NhpB/gW8Wb569gnMVYg8XxIG5QHnuNY5WwKT/Hbk7h"
    "SymJ45hWq8XAw4fMlUoYY/ghUxhn+e1wF20zMqvRRnMk27w0Ps+x7vL9pTX8KIqu1uv16865"
    "3v7+frGxsSGMMYwupGQmIyxMkFmDcZa9+D7FvrPcaayxfu82udvPrIknjeTyJyWbKoWyijRT"
    "PDt0Xrw6eYkf769zo/pVUxkuNq9z74mCf/PCe6LzykTl9K3azT+04OKD96merPG/UHqXjnG5"
    "0xIz2bpG/fH/b7KqnWZ0sUNzAAAAAElFTkSuQmCC")
index.append('camera_go')
catalog['camera_go'] = camera_go

#----------------------------------------------------------------------
camera_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwZJ"
    "REFUOI2l081PY1UYx/Hvvb19ISXYlpY7rUMJIHEm0BqGhauxkQR3LmZLDIaFC3bDjuWwUENi"
    "SNAFYeFfQOIsdIPGFxJcGhPFNC0GQuv0Bcp4CxTuuYdzjgsicdY++983n80D//MsgM3NzY99"
    "35+VUvYppSwhRNj3/YgQIqyUsmKxWJBKpb5ZWVl5CjA/Pz8jpTza3t5+aW1tbb1mjPGmp6cx"
    "xqC1RmtN+dfvWHh/guDwSz7/4QED7kMqleqHnud9AQwAxhjzdmh0dHR/amoq5bou9XqdVqtF"
    "p9Mhl3/AT7+cUrl4xFszj7Esi2az+cS27WgsFsNxHKvb7b7jGGPeGBgYYH9/n6GhIQqFAlJK"
    "lFJkMhnK5TJ7e3sMDg4yOztLu93G8zyklFQqlTcdpRQnJyek02lkPM9n31/Tu7HQQNQKU7o/"
    "Rurigmq1iuu6SCk5ODggm82itcbWWtPr9RgeHubr3wOEsYmFbWIRG2WH2f0rjuu6nJ2dIaUk"
    "CAKur6/vlI7WGiEEQgguVYRYJIRjgzFgGUNgIvi+j+/7BEGAEALf9xFC3AqUUndVAGP07dgG"
    "24aQbXF1dUUQBK8I/g3cCc7Pz4mYPoLAIvT3H+TsF7zuDvJno8VJ2KCUolarkc/nmZmZodVq"
    "obUmVCwWn/X39+N5HvdTMQ5/+5lH9wIWPpgnl8sxNJigUqnQ19fH4uIi4+PjZDIZpJQcHh7i"
    "CCHodru0221UpUI+meTx7AKrq6vU63Wy2SyFQgGlFOvr6zQaDRKJBEtLS7cBz/OeHh0dfWqM"
    "iUYiEXtubg6AcrmMMYbl5WWSySSXl5ecnp6ysbHB8fGxBuxkMqmdnZ2dDWADoFgsLjWbzU+A"
    "RDKZ/NbzvHfX1tbC8XgcgF6vRygUkhMTEz8C7zWbzXPrv581OTn5cGxs7KtSqXQvn89rx3FS"
    "7XabarVKNBplZGQE13W5ubl5WavV7N3d3dYrASBUKpUK8Xj8eS6Xy0Sj0ZAxxu50Oh9ZlvUi"
    "nU4/B8JCCNVoNE57vd6TfwDo7qWLgnCM1AAAAABJRU5ErkJggg==")
index.append('camera_link')
catalog['camera_link'] = camera_link

#----------------------------------------------------------------------
camera_small = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYJJ"
    "REFUOI3tkjGLGlEUhb/RZQfRGUgaUzix2kJYRNIEha1Tib8hxeKy2G5lmrQp7NL5LxJIENKk"
    "WlJpExGVdZlooXFgHX2+8T32pRphmSJ1IBcunOZ8cO858H+sWLTb7Q/AjTEGAGPMcZVSdDod"
    "q9VqGSkl3W736EvFQmt9U6/XKZVKeJ5Hv9/n/dU57978YDgc0mw2jeM45HI5Go3GOPadxCKb"
    "zTIYDKhUKriuS61W49vPObe3F1xeVtjtdvi+j23bbLfblwmA4ziUy2U+3T/n6ywFnHLxosCr"
    "szN6vR7VapXRaEShUEBrfZo4wbZtMpkMX6YpHh5tHrD5/jtLOp1ms9kgpWS/3xNFEVprEgAh"
    "BGEYYswjxgLSFiZlsVwuEUL8HbBer5lOp7x+FuBYe3KW4PzknvF4TBRFR7NSijipJz9YrVYE"
    "QYDn/eKt6xKGIbPhjLv5nHw+TxAEFItFhBAopZKAxWLxUUp5PZlMrDj7w+GAUgrf95/0whjz"
    "OVmpf3b+AIds0zTApzG1AAAAAElFTkSuQmCC")
index.append('camera_small')
catalog['camera_small'] = camera_small

#----------------------------------------------------------------------
cancel = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAelJ"
    "REFUOI2tks9qU1EQxn/3pklRiS1NBFESJcU/VMVitS4KClUohJaSnSB07QP0BQpduHBhwRco"
    "7QP0JSq0C7uTFIlYQWnJTW0barwn95zPxU1imrjswHA4zPfNzDczcN4mCARqu+3yCIJevNdD"
    "rnLvdpZnkyAhCZzruPv4Cbf7tZ6Cy23OQB/5+VOo/ES1Y3AOOQfWoqFLMPkAnE03vuxVL8AV"
    "AL+PfNyEt+8gn0fWQhShfB7//Qf0K8R7NIY/msueQrW7denNa7mZF9LOjlSvS7WaotlZRcWi"
    "FATSyYnc9rbMwzGZ0rTqoE4HQKw3OMItLYExkEqRWF0lsbYGqRQyhmhxEbdfQ9biWjwfiD/W"
    "xi1XKtiFhThJMhm7MTRLJVy5jKIoxvUOEedivdZCF6AlMS7Qins26sT+SWgByOdJrK93KssY"
    "vGSS5MYGFAox5r8SnEVDF/GXl2PNYYiZn8fMzaEwhMFBUisreCPpeLXd9gcCc+uGmq+Kas5M"
    "y25tKZyaUiOT0e/hYTUmJmQ3N9V4Mq7Gy8c6uZ5VDfbPXGIDAn80l/HG76DP33AHh7Gs9kxG"
    "0vh3c5jyHtGP4CADV/tO+RQCbl7LDNwvINs+YYucQA6z+/0MuS8BwBEEHmQ6y+l6BYfZrti5"
    "2F/4VDM6iJjjswAAAABJRU5ErkJggg==")
index.append('cancel')
catalog['cancel'] = cancel

#----------------------------------------------------------------------
car = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAf1J"
    "REFUOI3tkrtrk2EUxp/v4tcvUlraJrVQwWhQEqR4AWsx8QIWrRYREQcHxcmhuPkHONWh4Co4"
    "dFLQSUHrBSFqpCEaM9SQkgRMrJdqU0JJ035+Sd7zntchtLR2cXLymR544Dmcc37Af2krZmj0"
    "rc80zbtSyj5mZTERpJAgIptICiaalkKOfrh9/sXaAnPVGGYiEvQG9vo7oEODZAZxc0KDJIqz"
    "i5F7zz4+BWBsKLhw43WrMBCwF6ZxP5bF0TNXkE7GIKTC7JdP6B+6hGLiEeYzef3PFczTY+97"
    "lqWYGPB3YCYdR1u3H1WX4NQIc9+KIFZYdAgsgd7uNujHrquWrl15KeTZmccjee3UzcmHR4K+"
    "c4eCPhRKNVQcgQYxGqRQF4y6aPr2zQYCWzwgCbybKuBlLJ38+uTaQZNZDh/Y6UX+h4uqS6gT"
    "oyEYDWLUhWqWCUb1l8DnOResgMhuP94ksv1bT9zqNJnYUgpwvk/h+YM7sFps7D88jD0DJ0Gs"
    "QJIhGShkkpicGIdpefDTcxXWJgOOZbRq+wYvKloqgZbm4fN2Qtd1lMoVaO07oNwylFLNf9cX"
    "4PN2gZlRrjiQdi+Wewa3rXIQCoWK4XB4u23biEajmWw227f22it5rVZDKpV6lcvljq/jQNO0"
    "y/F4fEwp5SqlxjcQtz4f+TtO/4V+A0tYDFegLInCAAAAAElFTkSuQmCC")
index.append('car')
catalog['car'] = car

#----------------------------------------------------------------------
cart = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk1J"
    "REFUOI2lUz1rIlEUPWZli8SJ5mMNSAYMUXYgU0gKJ5VV/sKW2y1uxEa3SYpdAhFShWwSQipR"
    "gl1IkSqVW4nFgxQ2GxMYYWNmRUWxiAFn3p1528Sg7AeEvXC5r3n3HM45F/jPcr30Q6FQEJxz"
    "EBE45+9d5XJZAIDjOLBte6yJaKw551heXkY0GkWr1cL5+fl3txACa2trsG37n8iWZeHs7Kyh"
    "qmqgVqvh8vLyB+f8xO04DnRdx9TUFAzDQCAQwN3dHWRZhq7rCAaDuL29RSgUgtfrDdzf36Na"
    "rYJz/mFzc/ObOxaLuYrFopicnES329Usy2LdblczTZO1221tMBiwZrOpDQYD1mg0NNM02ePj"
    "I4joJwBMAAARwePxQJIkJssyPB4PCwaDmJ6eZqFQCDMzM0xRFMzOzrKVlRX0ej1YlmWMuXBx"
    "cSHW19dRLpfR6XQ0SZJYq9XSfD4fq9fr2sLCAjMMQ5ufn2f1eh07OzuuZwZPIn25vr7G0tIS"
    "JEli4XAYXq+XKYoCv9/PVFXF3Nwci0QisCxL/DEHp6enYmjXiNfPb8dxsLq6ilKpJPb29iZe"
    "HKTt7e3X/X7f5Jx3jo6O3gCAGwCy2exbIcQnIooPEUcZDOfDwwP29/ddiUSiP1zqfkrhu3g8"
    "/vHw8LDKOU8R0cHW1tbBKHo6nU4RUSqZTKY456/GNDg+Pv5MRJnFxUXIsoxarYabm5tndCKC"
    "oihQVRWVSgVXV1d6Pp8P/6bB7u7u8FDSmUxmjMHGxkbKtu2vtm0jl8u9+Aj/Wr8AALRoeunc"
    "DbQAAAAASUVORK5CYII=")
index.append('cart')
catalog['cart'] = cart

#----------------------------------------------------------------------
cart_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqVJ"
    "REFUOI2lU09Ik2Ecfj6bZLrP6ZSpYx/MttHEZYti35CwQ/MqdejYIcgEo4N1cNCkdCJ2kDqI"
    "hxBCPEQmNC9CsehQs94uQeU/2rD9aWxrS8INt/d9t6+LEwcRRj94Lj/48Tw8z/MD/nOEfz2Y"
    "n59XGGPgnIMxdkUIBAIKAJRKJRSLxQpwzivAGIPJZILD4UAymcTi4uKqSlEUOJ1OFIvFvzJT"
    "SrGwsBC32Wz6UCiE5eXlb4yxGVWpVEIwGERdXR1isRj0ej3C4TAkSUIwGITRaMTm5ibMZjM0"
    "Go0+Go1ifX0djLFrw8PDr1Q9PT2C3+9XamtrkclkZEopyWQycqFQIKlUSs7n8ySRSMj5fJ7E"
    "43G5UCiQXC4Hzvl3AKgCAM451Go1RFEkkiRBrVYTo9GI+vp6Yjab0djYSKxWK7RaLens7MT2"
    "9jYopbGKFHw+n+JyuRAIBJBOp2VRFEkymZQbGhpIJBKRW1paSCwWk5ubm0kkEsHY2Jiwr2DP"
    "pJG1tTW0t7dDFEVisVig0WiI1WqFTqcjNpsNTU1NxG63g1Kq/LEHc3NzSjmuA1mDMYad6iR2"
    "j6Wxy3LI5rLIZFMjL+5/Hj9UkQYeXLqnNzTcPdNxFgatBa9XfXj/5Q22gukpFQDMzs6eUBTl"
    "Fuf8epnxoIKt/DvYredRrCriVFsv/GvP4DzZja3g0o2qvRZe7u/vH6CUDlFKw4yxIbfbLXg8"
    "HmF0dFT4mf2BakGNvo6bAIDbFx7BpOuCAKFGAIDp6WkP59xrMBggSRJCoRA2Njb2VazsPsXF"
    "Phc4SnD3Psbky6uoOXIUT54v5Ss8mJiYKD/KkNfrfVjeOwbbxqXjmjvdXedgaT2Nr4mPWPn0"
    "FtGtX1OH/kbHYOskBGFQAEQF2IGizHyYSbh/A+09dM4cnOxlAAAAAElFTkSuQmCC")
index.append('cart_add')
catalog['cart_add'] = cart_add

#----------------------------------------------------------------------
cart_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApNJ"
    "REFUOI2lk09ImnEYx7+vvayWvmkluZzvUjIS9BA79HYYHVaDbdctOu02DHZaXXRjjTCQHQtk"
    "g9ElukWHLgvWHAychx+syyA18GVlKuoUR2Hp+/u977tLSsIYjT3wHB+eD98/wH8O968HGxsb"
    "OqUUjDFQSp9w8XhcBwBN06CqatsyxtqWUorh4WGMj4+jWCxia2trn9d1HRMTE1BV9a+fFUXB"
    "5uZm3ufz2WVZxs7OziGl9C2vaRrS6TSMRiOy2SzsdjuOjo4giiLS6TScTicODg7gdrthNpvt"
    "x8fHSCaToJQ+DQQCn/nJyUkuGo3q3d3dqFQqkqIopFKpSI1Gg5RKJaler5NCoSDV63WSz+el"
    "RqNBarUaGGM5ADAAAGMMJpMJgiAQURRhMpmI0+lET08Pcbvd6O3tJR6PB319fcTr9aJarUJR"
    "lGybC9vb2/r09DTi8TjK5bIkCAIpFouSxWIhmUxGstlsJJvNSlarlWQyGYRCIa5FcCHSYiKR"
    "gMvlgiAIZGRkBGazmXg8HgwMDBCfz4f+/n4yNjYGRVH0P+ZgfX1db9p1yWtQSuEo7sGWI+Cr"
    "JdS6jOhUTl7cj2pvrhSk2OytgHDTHhqdmrnW6fLi/PsuErFd9VcqNc8BwNra2qiu6wuMMX/z"
    "42WC298iuPfsJa7LX4DcV8BsQZkfwt7H2A/+IoUzfr9/bnV1NUkpfc4YWwkGgytNgk93ea3r"
    "hovDw4UWFb80iA6dc3IAEIlEXjHGlh0OB0RRhCzLSKVSLYo7++8x9egxjJkPaJwXcAbg9KQD"
    "SRm5Ng3C4XCzKPPLy8stgtjs4BJvEhaHrNTAG7I4/clwWOhQlbr2+sptjM2KwbNKfs6gcUOa"
    "Qc9p0N89iGrh36p1dPtNq+4KAAAAAElFTkSuQmCC")
index.append('cart_delete')
catalog['cart_delete'] = cart_delete

#----------------------------------------------------------------------
cart_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs5J"
    "REFUOI2lUl1IU2EYfqbT2pxn/qWxMd3cxH4mIZmz1IugwCgk6OciqOjH6taojKKrakg3CkZ1"
    "MQQRRMQL6cKIjJKwOOrFwOnJPE7H/NlPs6TJzjnf+c7XTUKDDKIXnrv3ed6X53mA/xzdvxJ6"
    "e3sZIQSqqoIQcl43NjbGAEDTNFBK06CqahoIIXA6naitrUU0GsXg4OC0njGGuro6UEr/ellR"
    "FAwMDKy43W7L/Pw8hoeHFwkhz/SapkEUReTk5GBpaQkWiwWhUAg2mw2iKMJut2N2dhYulwtm"
    "s9kSDochCAIIIVfb2tre6gBgZGSEGY1GJBIJD8dxfCKR8OTm5vKxWMzDcRwfiUQ8+fn5vJX0"
    "3s3XDO2ZpipsfB0FpOWLegBQVRUmkwmKovA2mw2yLPN2ux2SJPEulwuyLPNVpVFwyV3thqJG"
    "mB3V+L5QCeG170kGADQ1NemCwSBqamowNzeHeDzuEQQBkUjEEwgEUKo9v1dojKGgoh6pNQGp"
    "RR653E6YCkvN+t9MejAzM/PQ4XBAlmW+oqICkiTxVfYUdhgOevPKj0Je7Ue2UYeQ/zOUlJyQ"
    "5OShtB709PSwzbgIISjImsexegPMrmZIyy+Qka2CJMsQfj8BRUZ1desb/5axvXpccnZ1oo3R"
    "1Ce2IV5gqdA5th64z4SuI8x7+8q3zT09APh8vkrG2E1VVa8RQrBdmoatyoTivcehRHzIzGaQ"
    "1suwOjoOqD8c4WR2YFMg41cLz7S0tFxXFKUV8fFEvbsQFDasTnVBg4SNNStW3o0n+4Jly0/F"
    "mpOU0sy0DxRFQWdnJ7NardCkl9jT8Aiz/bfw5cNHbCvdh2RkAbHiZlPTqUaT3+/vmJycFDcF"
    "0kz0er2MLvThzuUbQAaFf2QIoeBckisyNwytNx6mlHZQStHd3a37owAAnG7IS+13lugP7C4H"
    "y5I/yvH4pRPtU8GtzP4JSA98ZcNVci4AAAAASUVORK5CYII=")
index.append('cart_edit')
catalog['cart_edit'] = cart_edit

#----------------------------------------------------------------------
cart_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsRJ"
    "REFUOI2lU01IVGEUPfNmEp2Z58t+1BmZHHNGyTHyL59EWtTGaFe0yrBF1qKVFUiLEDdCVuSq"
    "lQQmbmSKfsBFGEFo8GwmJNBBZzRFG2bUacgcffN93/u+FqkpSBBdOIsL554L554L/GeZ/nWg"
    "r69PUErBGAOl9IppZGREAADnHIZh7ABjbAcopSguLkZtbS3i8Tj8fv+4RQiBuro6GIbx182E"
    "EAwMDETLy8ud09PTGBwcnKWUPrFwzhGJRGCz2bCwsACn04m5uTm4XC5EIhG43W5MTk7C4/FA"
    "URTn/Pw8QqEQKKXX2tra3lkaGhpMQ0NDwmq1IpFIqIQQLZFIqOl0WltcXFR1XddisZiq67oW"
    "jUbVdDqtpVIpMMa+AYAEAIwx2O12yLKsuVwu2O12ze12Izs7W/N4PDict65V5I4i74Bd8/l8"
    "SCaTIIQsbAk0NjaaZmZmUFNTg3A4jKWlJTUUCiEWi6mh8TG4MrTZHMdxeLPe9wcCAaRSKXR0"
    "dKxuCWyYdG9iYgJFRUWQZVnzer1QFEU74viOnMJz7mxHJfaI9OWqslwQQsSuOejt7RWb56KU"
    "IlNagZo3hpJTzQCdwtp6KcKBN3gesImuB48kALBsF2hubt4SFO3t0rgv2Jt/9GoT9M8Y7X+F"
    "upa7yEiF4cgqWN3kWQCgp6enVAhxizF2fXP7U3McZ/Yfg5yzBmPlKyA4jNVPKDp9G8svu2zD"
    "90/IJ9s+/pQ2UnippaXlBiGklRAyx5l+p0oOBvceqgBf+wLB11F9sRScRJGZOYWS6gsSoLdu"
    "mUgIQXd3tygoKHhcX19f6Mtfe7jPe77aKi9DsARgMiP4YgoAB9encLCkEAYhNz+0l5XtMLGz"
    "s1NQSnFWefujqumZYpZmIVgSgNjGkmDOKkV8fAyTrzv8u37jcFflsmDcKriA4Pw3hMCfXgCc"
    "A1wEfwEUNoRVmS3KqgAAAABJRU5ErkJggg==")
index.append('cart_error')
catalog['cart_error'] = cart_error

#----------------------------------------------------------------------
cart_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqNJ"
    "REFUOI2lU89Lk2Ec/0xnodu7X9iqzbemm7TaCCHw3aE8Wf9Bx+iSdfCSXexQhAqehISgk4dk"
    "dREPQuChVhA45DELCtyStnLvlmy2YaaT932e532eLi6SSog+8Ll8v3z5fvl8Pl/gP2H714Fk"
    "MikZY+CcgzF2xZZOpyUACCFgWdY+cs73kTGGcDiM3t5eVCoVzM7OrtillEgkErAs68DNlFLM"
    "zMysx+PxQD6fx/z8/Bpj7KFdCIFcLgeHw4FSqYRAIIBCoQBVVZHL5RAKhbC6uopIJAK32x0o"
    "FovIZrNgjF0bHh5+Ye/r67OlUinZ1taGWq2mUUpJrVbTTNMkGxsbmmEYpFwua4ZhkPX1dc00"
    "TVKv18E5/wIATQDAOYfT6YSiKERVVTidThIKheByuUgkEoHX6yXRaBQ+n4/EYjFsbm6CUlra"
    "58Lc3Jzs7+9HOp1GtVrVFEUhlUpF83g8RNd1Tfc/Jbt8C5o1CF3XMTo6avt5wZ5IdzOZDDo7"
    "O6EoCunu7obb7SbRaBR+v59YsNDRfhrP+QQopfKPOZienpYNu7LKE0jBQAUH5RwBXzfOdpzH"
    "0tpLvC8RPLtZboIN8q9BGkxq8mLsKiwpYAkLAhLlrRK8Dj8WP6WwrL/iy7fNQ3YAmJqaOiWl"
    "vMU5v84YA2MMGf4YlhQo1D6CCQ4uGJjF8N3cRo96ATts1/7t3oLRtJfCywMDAzcopUOU0gJj"
    "bMjgBrjFcdR1AsdcJ3Hc3YWW5lYcUYJ4W0wjnVv4YGzDY2+kbHJyUgaDQaiqinw+f59smXi0"
    "OAEqKAxOEW4/g0TXJbwuLGBxZYk219Hz+QHMfRqMj483HmVobGxs8tdefKRl51yoz/Fm5R1E"
    "a/VwZgT0NxcOQugOvgrZ3K7brRaMgDfqPwC7boRe1eW4RAAAAABJRU5ErkJggg==")
index.append('cart_go')
catalog['cart_go'] = cart_go

#----------------------------------------------------------------------
cart_put = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq9J"
    "REFUOI2FU09Ik3EYfqYSxfblmjbLtoOD4Sf7KhHykyIPYnUIukmn6DYVD20d0kMhbLCTmJp0"
    "Ek3ETh7sYpeC0KZ8OEoJVKittX0Ko8Es/+B+f7u0D8Wk9/L7wfvneXif57XhhHg0fVMyQbB9"
    "8Bt77EDMdn8v/1dd2UkDOC+yW4GHuHe1EweEnFSGipMSVPIKLgWY4KCCWEBTU1OSUgrGGCil"
    "Dyri8bgEACEEOOd4sxlBkRG4zl4EFQxFTnHJ6ce1WFHuEwmfz4fm5mbkcjnMzMz0VUgp0dLS"
    "As45AGD6dQGe6gY0XNCx9SuLPbKPFt9t2MrOIJFa5ZqmlSeTSczNzaUppS9t8/Pz0u12w263"
    "wzRN1NbW4snbO/BW1eOy5wb26QGWf3zEaXEObfYOqKqK9fV1pFKp9t7e3vdlra2tNtM0kc1m"
    "kc/n9XQ6jfvumP5lcxlLqXf4nF3E0tfFxTZ7B7a2tvTV1VUUCgUwxjYtFRhjcDgcUBTF8Hq9"
    "cDgcxou7H/ApM4+f29uIXnl1XVVVuFwuIxAIoFAogBBiAoCttN3Z2VnZ3t6OeDyOfD6vK4pi"
    "5HI53el0GplMRq+pqTFM09Srq6uNTCaDSCRiO+IDQsiztbU11NXVQVEUw+/3o7Ky0lBVFW63"
    "29A0DVVVVUZjYyMIIbLUZzEAgMnJSflXXxzS2voLIdDU1ISFhQU5MDBQdmzA/6K/v//U7u5u"
    "kVKaHxkZOW85cWxsrF5K+ZgxFiwhHmZQend2djA4OGjr7u7ePWJlIURHMBjsHB4eXqeUhhhj"
    "Q319fUOH0cPhcIgxFurp6QlRSq3DsgHA6OjoU8ZY1OPxwOv1IplMYmNjw0JnjEFVVWiahpWV"
    "FSQSiW8TExP+YzuIxWKlQwlHo9EjDLq6ukKc8+ecc4yPj1t9fwA0g4QKzeXDeQAAAABJRU5E"
    "rkJggg==")
index.append('cart_put')
catalog['cart_put'] = cart_put

#----------------------------------------------------------------------
cart_remove = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArtJ"
    "REFUOI11U01IG1EQ/nb9qRiDgaSxtMYSqXTBPYilJvQnUMixh/bQY6GHYiNeYg/VQovUUE/B"
    "qoQeWtGKlF6keGk0B6GgsSyEYug28ZCgJltpZEmwSdHse7uvFxOUmrnMY2befMN83wC1jIG7"
    "v9LCbn+0x2rWAKirlfB5ruhu013ucnPnxbx7+87vL+UPZ9VxZwVffb3JOpquo8NyC8VyERvZ"
    "MMKJ5Xn5WenRwsICI4SAUgpCyEMuGo0yADAMA7qu4zte45LJhQut17BfzOLgMI/mRivWd1fw"
    "LRVDyPMZfX19yOVyWFxc/FnPGIPb7Yau6wCA+IYF6UIc+b95OG03wKMJq+lPkPd/gBiHhiiK"
    "fDqdRjgc3iGEvK03DAOpVAomkwmKouBeZxC7u7tYLjyH0+YGzzNs5xN4512HLMt8NptFMpkE"
    "IeTx8PDwKu/xeDhFUZDNZqGqqmtnZweqqro42gAwAxwD6tBgyLKMvb09VzweR6FQAKX0FwDU"
    "AwClFC0tLdA0TXI4HCiXy5Lxh0ck8R6FwwM0153jBUHA0dGR1N3djUgkAk3TlFMsLC0tMa/X"
    "i2g0ClVVXWazWcrlci6LxSJlMhlXW1ubpCiKy2azSZlMBmNjYxwA8JUGmqa9TCQScDqdMJvN"
    "UldXF1pbWyVBEGC32yVRFGG1WqWenh5omsbO1MH8/Dw75hcnuK6+DcNAb28v1tbWWDAY5GsK"
    "qZaNjo42lkqlMiFEnZ6ePl9d4szMzFXG2FNKaX8F8eQEFV8sFjExMcENDAyUKk3rj1X4oL+/"
    "/8nU1FSSEOKnlE6OjIxMnkQfGhryU0r9g4ODfkJI9YY4AAiFQi8opYH29nY4HA6k02lsbW1V"
    "0SmlEAQBoihic3MTsVgsNTc31/XfDsbHxyuHMhQIBE5N4PP5/Lquv9F1HbOzs9V//wBRD4px"
    "0TpV1AAAAABJRU5ErkJggg==")
index.append('cart_remove')
catalog['cart_remove'] = cart_remove

#----------------------------------------------------------------------
car_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlJJ"
    "REFUOI3tks9L03Ecxp/vj9wMUzSn6xeMxPB7iDJLJcw69MPSkpCCDkWBdLB16iJ06GSI4KFD"
    "QpAEFdjJyspCiGE6TbvocsQgh5ma277G5prbd58f7w7SWHXpD+g5PafX834/PMB/Kb9MQ8c7"
    "h67rj4QQu6WkHMk5BBPgnNs5F0xy7hdMdHzoaXmTDdAzRtPH6yqKy/a6CqFCgZASXK4npLlA"
    "cDFW93hw+hUA7S/AuVuePKahzP7dj77hTzh8+jJ8k8NggrD45TOqGy4iOP4U4ZmA+ucL+qmu"
    "CecPwV7Wugox5/Miv8SF1SRHIsWx/DUILgmxBIcUwLaSfKhHbpBt866AYKJ5bqAtoJy8Pdpf"
    "X+E4e7DCgdlQCtEEQ5pLpDnBYhIWW/cFGzWUleaCC+D91CyGhn2T8y/cNbqUovFAeTECS0ms"
    "JjksLpFmEmkuYTFahzEJa82DqDkGKx1DillwOndUy+PdRbrkMocISCxM4fWTe8ix2bHvUCP2"
    "1J4AlwQuJOa/DYI2TKDKqMH2onJ4/M/A7COQmqdTqTx6gXg8BB4Pw1FcBFVVETKjUAp2gpIm"
    "iAhVLTacb24CNBVnjOvofnsVGlT09T+3Mm0ahhFsbW0lt9tNhmF8zG666WYlDc7cp2wN+O5S"
    "zbUtlNmBoiiXvF5vFxEliag3G2DGQin/0ph9emkU7cceoHPoCuyaDQRKZUYRiUTmTdPsNU3z"
    "4crKym8XbN2flxtPR+pdpS6YawuIJcLwTo9gNWrdUfCPqm5zdkJR2hRgEwFxEPVM9iy3/wRr"
    "DEGVumjnCQAAAABJRU5ErkJggg==")
index.append('car_add')
catalog['car_add'] = car_add

#----------------------------------------------------------------------
car_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkxJ"
    "REFUOI3tkstLlGEUxp/vwviZ4qjNeCHFmYaGkZAukEnZhYjyQlRERIvCXSGuqkUQmAS6ENoW"
    "LVpZ2MrAsosoZTpYBmaDFhPNMKUjjmmo0/g58533vC0GTWrjH9Cz+q1+h/OcA/yPsgo1rW+c"
    "uq53CCEqmKWNiSAsASIyiITFRBPCEq3v75x5sV6gr4GmD1f7HJ6drjyoUCCYQZyekCKBcHSx"
    "+sGzjz0AtH8EZ2++yrY0eIyfE+gc+IxDJxoQGBmAJSSi376isuYCwsOPMTseVP9eQa9rf1f0"
    "S1hPq1x5iAT8yClwYckkJFYIM5NhEEssJggsgC0FOVAPX5UZm71BYYmTke7GoFLbNtR10Oc8"
    "vc/nRCi2goWEhRQxUiSRtBhJK832TRo8hZkgAbwdC6F3IDDy/UnTXp1Z1O/Z5kBw2sSSSUgS"
    "I2UxUsRIWjItsxjuLw/hCHXCmI+gOLcQNllZ2X3sdr7OxDYpgcTUGJ4/ugdbhoHdB+qxo+o4"
    "iCVIMOyjHXBRP3wNl5Hh3g4z0AvHYB/2B4ealF1Hz0uKx0DxWTgd+VBVFbG5BSj2rZDmHKSU"
    "aM4dxalrt5AZeg1EhwB7Lub0Moy89E/qH/o6FQAoLy8Pe71et2EYiPX3j3/yd1WsNu08orNR"
    "5FZQd+VP+y3FsElZsvYHiqJc9Pv97VJKU0p5f/2pWJXR5bGekqzuRiTNGSwDiC9pEBqmFWwg"
    "g+eKW2zZWTdKHULX1SnEfxAiM5pIrXDzhgRpSen15fnpSyorZazKKEPere3jtt/0aiXFs73c"
    "MgAAAABJRU5ErkJggg==")
index.append('car_delete')
catalog['car_delete'] = car_delete

#----------------------------------------------------------------------
cd = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtBJ"
    "REFUOI19k81rXGUUh5/zvndyJzOZZNJpmoSJ0AlOEDVW8YMkra24GakwFGwjLa5U6J8wRddC"
    "Z+O+0LoogpiAlAjF2QhaTItG6aaRMoVBm2KbkOZjOh/33rnvcWFbpUif1eHw42x+5xGeYP6z"
    "2kERPQnMAc8g6gmyrvC9Ovly4dPST//Ny6OhXL2UScV+VeHjD0vPJ/IjWdKpJH2+QcOA3/+4"
    "z/nvbkQC59s2qCxVjjUfHyhXL2X64+RiebZQev9wkbsPhJ9vNtEk5PM+B/b00QeoU77+sc7S"
    "1UatY7snlirHmgYgFfvV8myh9O7BKawRhgag1XE0H/Totx4+0HTQQjj11hTl2UIpFftVADN/"
    "9vKMipw+9FKBb3/dpL4JAwZyAz6djiPtGQKgG4IxEALHjxRRkdPzZy/P2Om3P/jko3deeONe"
    "y7LVimnca+MnUoxmPQaTjlxKAQ8FrIXQgVNhX8aX6/WNyAPmRnODXL8dAIoTaKzv0m1t8M2V"
    "W3cBjh8ujpVmJtltQyuETidmNDcEMOepMOHZBN0oAAErMDpk+Lx26y/notcBFq/Uf5l+Nj9+"
    "cz0kCB0Az431ocKE96hGp6Cx4lDkcbn/EkaOIFKCWAGHPtwbUdaiXojicCgj2X6yg2lOvFkc"
    "tyaxYk1i5b1DxfGd0OAnLENpn72ZJHEUIcqaByyv328eeHn/COl0kuEMRD145cVJpqfyY1EP"
    "moFlbTskiByeUfLDCTa2NgGWjTN68UJt1b2232csC+0AtltwZwf+3PVobAl3diJiJ4gIIrAv"
    "Y7hQW3XO6EWzcOboNVE9t/hDHaMQ9KAdQjdUOqES9Byxg9jFWKMU9vqs3GggqucWzhy95gG0"
    "bVBZutqYBEpHXi3iekI3dBA7UCVhHXtSlolhj99WGw9fOag8VaaRXJakn8Sp0u102dze4Yva"
    "6v/L9FSd/+E2sKwqXz2p89+DnkwBt84AyQAAAABJRU5ErkJggg==")
index.append('cd')
catalog['cd'] = cd

#----------------------------------------------------------------------
cd_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxZJ"
    "REFUOI1lk19MW3UYhp/fOYee0haoq1BIMSmbJUxlYOIMsD8aF+3UpFkMw2i8mZrsyisvWPTa"
    "hN6YeDOjzhuzCx1mQcym3YzGkQ2CaLZFtmCHjRs6VgRGS/+c057f54VuGvdcvfny5r158in+"
    "x8g7mV1KyUvAEPAASiyFygt8K1odP/F28vx/++pOSKUnmgKenRZ4/dXkQw2x1jDBgB+fbSCu"
    "w9Xf1jj29XxNwbGy6YxOjh4o3h1IpSeaGj3/eGqwK/ni3gTLm4rZhSLih1jMpm+LDx8gWvjs"
    "XJbJ6VymYlYPTo4eKBoAAc9Opwa7ks/v6sY0FC0hKFU0xc06jaaFDRQ1lFC8/GQ3qcGuZMCz"
    "0wDGyNjpAVHq8O4dXXz54yrZVQgZEAnZVCqaoGXgAFUXDANcYPiJBKLU4ZGx0wNm71OvvPXa"
    "/ocfv1UyWS955G6VsRsCRMMWzX5NJCCAhQCmCa4GLYq2JltdzK7ULGAoGmnm4g0HELSCXL5A"
    "tbTCyalrywDDexPtyYGtFMpQcqFS8YhGWgCGLFF0WmYD1ZoDCkwF0RaDdzPXbmpd2wkwPpX9"
    "offBWMdC3sVxNQA97T5E0Wnd0agFxBM0gror91/cmsapCY4ngEb+uVtKWKrV3Yig0UBruJFw"
    "c5CDexIdn5/LzgG8sDvRPnP1FFcWT1GqrFN1XfKJZ1GSWLKAC/m1Yl9/vJVg0M99TVCrw6OP"
    "bKW3O9Zeq8PUpZPkN8+yb89OOrck+G5+gpmfP2JlLY6hDfnk48wV/Vjcpj0MZQdul+D3Dbhe"
    "sMitK2YuH6e/pw/P8OjreBpP1RjoHaJUnttunDjy3IwS+WD8+yyGgFOHsgtVV6i4glPXrBZu"
    "0qBCpLa/AcCb+z5kW9sOUPgMgLLpjE5O5zJnpn8hYgshHyg0eBpE2NjcYP6PC4ydPQTA2JlD"
    "LOYvI0jVBFj45lN32zPDX+SuF8OZ2cX+7qjPvD9k0tZsEQkqKtVNfvr1K+LROH+Wl9go5Tl/"
    "aYrCbee9e4Td885/cyO/+r6Uq3M9oAMCRUSOzh5dPvIXFxJc9mA3JwoAAAAASUVORK5CYII=")
index.append('cd_add')
catalog['cd_add'] = cd_add

#----------------------------------------------------------------------
cd_burn = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwxJ"
    "REFUOI1lk01oXGUYhZ/v/sydvyTTzCQz46QwCZlY1DQWrCRpjVIXIwhDIE2KPysVunOhiwEF"
    "Nyp0Nm4U3LSItS40ImUKxbEiaLED2kI2jbYpDrapNlOa1Nzc3Ln3zv0+N2mVelaHl8NZnIdX"
    "8IAW3m8cEEK9AEwDuxHKEIi2gu+VFKe+fLv803/z4p6p1E73xEOrpuC1V8qPmIWBFIl4lIil"
    "oXyPX/9Y5/g3lwMBx7d1r1qvztr3Cyq10z2xMLpYmRouH5kpcWtL8PMVGxWFQsFioj9CBFBS"
    "8cWPK9SbrYard+br1VlbA4iHVq0yNVx+/sAYuiboS4LjSuytLjHdwAJsCQ6CF58ZozI1XI6H"
    "Vg1AWzh2dlIJcfTg3mHOXLrDyh1IapBOWriuJGFoeEDHB00DHzj8dAklxNGFY2cn9fFDL7/1"
    "6nOPPrnm6Gw4Ia21bSwzTjZl0BuVpOMKMFCAroMvQSrBYI8lllZuBwYwnU33snTDAxRSQKu9"
    "Sce5zdfnr90CODxTypUnR9jcBscH1w3JpvsApg0lGDJ0k07ggQBdQLZP44PGtb+kDPYDLJ5f"
    "+WV8tJC/0vbxfAnAnlwEJRgy7mGUClSokCjEfbj/yg8kXqDwQgVI1M5dE4rVoOujkEgUA6kY"
    "qd4E80+V8rpmXtQ18+LcwVLePPE6/TcvUXSWmVl6lzAIEIpVA7jQXrcnHi8OkEhE2dUDQRf2"
    "PTbC+FghF3TB9nRiTp295z4jvW8X3WQ/v228AXBBk5o6eaKxLJ8oWuRSsO3BXQdu/g3XNw1a"
    "GwLjVJVEcZ3MRBFxKIU5ZOMuvqOkpk7ql7/7fHX82Zdy3VDtHx1Kc7cDWx3o+IpOIBlZnuOh"
    "4FN6swMYXgz2AH0mD6euivnSVxkNYFv3qvVmq/Ft8yppS5GMgEBCKJE/xNB2A+bOsjYQETBo"
    "woe4GkC9Omu7emf+TPP3j9/8qBG0/7xO2nQYzUAyM4g6B26+jVIS1nbmb3Zhk/b/gD34zlbX"
    "E+99MtdvJLoCXw/zmbQihsGW8hFW6h8XVkGNQ1n2pQAAAABJRU5ErkJggg==")
index.append('cd_burn')
catalog['cd_burn'] = cd_burn

#----------------------------------------------------------------------
cd_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxlJ"
    "REFUOI1lk11sU2Uch5/3nNOert1HRx3tLJp12mLACUZdtoFAMLEqSYNmTDFeAQmJidfz41qz"
    "eqGXapwXEi+UmYlVp0XiB6gYwGSaCC7d1rjBHIMN17N+nK/39UJBI8/VL//88rt58hf8j6GX"
    "i9uEUPuBAeA2hDIEYknBV0qK946+lP3+v31xPeTyx1rCvplXcOhAdlMg2RElEg4RNDWUY3Ph"
    "9xVGv/jVFTBa0+3hwvBe68ZALn+spckPjeX6U9knd6RZXBOcmbJQIUgmTbasCxIElFR8cLJE"
    "4XS5WNcb+wrDey0NIOyb+Vx/KrtnWwZdE7Q1Q7UusdY8mnQDE7AkVBE8vStDrj+VDftmHkAb"
    "GpnoU0Ic3n5Pik9+Wqa0DM0axJpN6nVJxNCwgYYDmgYOMLgzjRLi8NDIRJ/es/uZFw8+srn3"
    "clXnWtWnfLmGGQgTjxq0hiSxsAIMFKDr4EiQSrC+xRSTpSuuAQzEY61MztuAQgooL1VoVK8w"
    "fmp6EWBwRzqR7eumUoOqA/W6TzzWBjBgKMEGQw/QcG0QoAuIt2m8Vpz+Q0r3AYCxU6WzPXcm"
    "O6eWHGxHAnBXIogSbDCua5QKlK+QKMQNuf/iuBLbVdi+AiTqn7shFBddz4kpJBLoiDYRbY2w"
    "78F054cnS+cAntieTqx++Taxr99ELkzjr7sVa/cBhOq9aAA/LK1YW7Z2dRCJhGhvAdeDe+/u"
    "pieTTLgeVI6PEr4wxsanDmGmNlP/5Tjnvxund+1nS5OaOvJO8by8v8skEYWaDX9W4dIqzFUM"
    "ytcEq5+/TmbX44RmvkG8u5/w7Ed03d7OxoWJbu3o84/9KJR6a+zbEpoC24OaAw1HUXcUticJ"
    "XJ0jlEjBcwUYWYEXZjGqvxH0vE4DoKbbw4XT5W4gu/O+NNITNBwJvgSl8NoT1CY/I1J4Fru+"
    "SA2wKjq+zoIOMHXifeeOhwc/Ls9Z0eKZma2ZeFC/pVlnfatBLCIQvsvVs5+iBQSuXmV1WTG7"
    "oPm+p169SdhN7/w38w/NH2kkZ8a7gp6XkJq6JFFvPHpCvvIXKgJbOHqC5QoAAAAASUVORK5C"
    "YII=")
index.append('cd_delete')
catalog['cd_delete'] = cd_delete

#----------------------------------------------------------------------
cd_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0BJ"
    "REFUOI1dk0tMXGUAhb//3jsPBpgXQajTUqYyVGiQamjtFKVYE6cpCcEEMJqu1FhdmpjQ2HWT"
    "slBrjDGtsGlIREgM0tiI8RHFThuiDQkveTRTFMpAnaFyGWbuPP7fjW1qv9VZnJzNOUfwCN3n"
    "xpqFUK8CR4E9CGUIxIaCH5UUA0NnI9ce9ov7or13pNRVcPQqePP1SL0tUO6l2OXE7tBQWYu5"
    "5SR9387kBPTt6FbPaE+H+SCgvXektKjgHG4PByOvtISIbwsm5k2UEwIBB41+O3ZAScWXvywy"
    "ej02ltYzXaM9HaYG4Co4etvDwUhbcy26JvCUQCotMbfzFOkGDsCUkELwWmst7eFgxFVw9AJo"
    "3eevHlFCnH7uqSBXfk+wmIASDcpKHKTTkmJDwwIyWdA0yAKdx0IoIU53n796RG84fur9N04c"
    "OLye0tlMFYit7+CwuajwGridkjKXAgwUUNj4gTtXzmLeXuBZMShEztxnAEcrytxM/mUBCikg"
    "trFFJnWXr8aX4gCdLaHKF6qnyS5EqWw4hSf4NPdi+0l+N9BiKMFuQ7eRyVkgQBdQ4dH4cGxp"
    "TcrcIYBbUwNTx334/KFmkrfmsIsspe5KfL5K3bhfo1SgCgqJQjwoF96tu9C6vzbs8wRPYK0N"
    "YncJlif/IFewcenusX80oVjJ5bMoJBJFubcIr7uYrudDu+rdc1NP1h4e8Na0kbnzOcK2ia2k"
    "FCOfoHDwbTald9kAohtJs/FgdTnFxU58pZDLQ41zmuZwwuep6SCz+hmaLU92K0j810mSTecw"
    "pR9Yi2pSU5f7x2ZlU7WDSi/sWLA+/Q32xDUeO9BGNt6HbldYW3uJj99ktuFj/FX19I/NSqmp"
    "y9rQmZM3hFIXh39eRFOwMjGI516UnHyctalPkGRIJQOsRueYabhAYHcVv83EEEpdHDpz8oYB"
    "sKNbPaPXY/uAiG2yjxff6Wd+8D0WxqM4qhrJbiWg9QPq9ga5ORv7b8pWD4AOMP/9YPaJlzq/"
    "jv1pekVs5FA44Ma3aw/Jlb9ZXVqm7OVP2dF9fDQ8kVtY2byU1q23/nemh+lq8VvPVFcYTXVB"
    "sWH48z9ZkW1TK78NRJUSXzx6538B+wde34wM1FkAAAAASUVORK5CYII=")
index.append('cd_edit')
catalog['cd_edit'] = cd_edit

#----------------------------------------------------------------------
cd_eject = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwpJ"
    "REFUOI11k99rW2UYxz/vOSdNmvRHNNauNIIpJBGj3WyDtJkuw4tlIoZedPUHXulg6D9QmNdK"
    "C96IoA4qXrT+LOrooHNFFDZnURSGIKN0LEyzrm2yxTY5ycl5z3lfL7TDTfzCw/NcPHxvPt+v"
    "4C5NvXHuoBD6BSAHPIDQlkBsa/hWK7Hw+euFi//+F3tHcfZ0d9gPzmo4/nLh4cBgX5RIOERH"
    "0EC7bS5fu8Xc179JAXNNsz29ND1Rv21QnD3d3emHFovjicJzh5JsNgQ/rdXRIRgcDLL/3g46"
    "AK00n51fZ2m1dK5lOseWpifqBkDYD84WxxOFZw6mMA1BbxfYLUW94dFpWgSBugIbwYuHUxTH"
    "E4WwH5wFMKZmlse0ECeeGE5w5pebrN+ELgNiXUFaLUXEMmgDjguGAS4wmU+ihTgxNbM8Zj76"
    "1EsnXzmaeXzLNqnZPqWtJsFAmP6oRU9IEQtrwEIDpgmuAqUF93cHxaX1irSAXH+sh0t/tAGN"
    "ElDa3sWxK3x54comwOSh5L7C2BALp97n8ORxXFfQH+sFyBlaELfMAI7UKA2mgP5egy++v3LD"
    "VzLrK5ldvLB+45MP50in05z9+BRr13cwzABaEDf2MCoNvqdxpULchvu3jg5sDqRTKUZHRxnO"
    "PMTaNx/g+z4AhtCUpeeiUSg0fdFOoj0Rjj2ZHDCNwM8Tid1yOpViZGSEcrn8j0maxbm3QKvr"
    "FvDD9q36/gMP9hGJhLinG6QHjz0yhPv7j/uSyRSZTIZqtYplWVQqFfL5PI1Gg63vvhoWUzPL"
    "Y0IbF+enjxg1Kag1wXbAdqF0/iNcp4Xrukgp75ha7U+q1WpLADz/5tl3nx0fevXIeIqNOuw2"
    "oeVqHOnjSg/f13i+j2lohu4LsX61xJnVq+99evLp1/4T5fxokootqDZ8fl16G9u2kVLiOA7N"
    "ZhOlFI1Gg3q97iilQv9bpr5YlOWFd8hms+RyOTY2NrBtG8MwiMfjzM/Ps7Kywl3A7qxzsrV6"
    "wJNtIaXE8zz2tu/71Go1b2dnp/0XuB93gv+aeAQAAAAASUVORK5CYII=")
index.append('cd_eject')
catalog['cd_eject'] = cd_eject

#----------------------------------------------------------------------
cd_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwdJ"
    "REFUOI11k91rW3UYxz+/c0568tK8aIxJbTtNRoZx1BVE7YtuItjIhDhhVhRhqIMy/4HIvPJi"
    "2Fw4r4V5ofNm65RRYdgLlbmXltXJQN2QVEJt0a2lq2uanJNzzu/382J2vsA+Vw8PXx4e+PIR"
    "/I/xIzOjQuhXgRGgH6EtgVjR8I1W4rOT75Yv/DsvtoZK7XQ8Ku2ahoNvlh8J9WZSxKJhumwD"
    "7XW4tniTY1/97As41jY71enqvuadA5Xa6XhEhqcqw/nyK7uLXN8UXPqliQ5Db6/Nrnu76AK0"
    "0pz4rs70bGPGMd2Xp6v7mgZAVNq1ynC+/MLoDkxDkOyGlqNobgZETAsbaCpoIXjtmR1UhvPl"
    "qLRrAMb45JkhLcTEU4/m+fLyGvU16DYg3W3jOIqYZdABXA8MAzxg/54iWoiJ8ckzQ+bAs68f"
    "fuv5nU/caJmstySNG23sUJRsyiIRVqSjGrDQgGmCp0Bpwf1xW1ypr/oWMJJNJ7iy1AE0SkBj"
    "ZQO3tcoX5xauA+zfXcyVhwpstKHlgeNIsukkwIilBX2WGcL1OyDAFJBNGhydWfhDKf9xgKlz"
    "9fm55UM9t5xVxga+BeDhXBda0Gds1ag0yEDj+Qpxp9x/cAOPvvtKnPp+iI6U6L/3ltAs+4GX"
    "1igUkElFSCVi5LYd6VEqWPZUgC8lqdh2Srknabotjs8O8P6LVxGaZQu4uHKzuWvwoQyxWJh7"
    "4uAHECiP53YeQGqFVBKF5vdbSwz0jbLpORw68QB5Pr9oKUN/+vHM1Ynj1TFj3Yf1NrTc2y9L"
    "rVhcq+OrgED5+NJno9NksP9pNv02c429B42T7+ydE1p/NHW2jqGhE0DbAzdwCWRANrGNXOJB"
    "epIFQmaETLyXH5YuMP/rtT/dDZ20ANpmpzo92ygA5T2PFVGBwJEen8x9gKc83MCjkC4xVBhj"
    "fvE85+s/NnuMA8WzHx517ipTJp0ibIdRWuM6Lm+f2k4pN8jswk+r/ZE3Sl8fnlz7j4131fk2"
    "S5fbL5U87YV/s2SI9wi28n8B1CBijOJTRWcAAAAASUVORK5CYII=")
index.append('cd_go')
catalog['cd_go'] = cd_go

#----------------------------------------------------------------------
chart_bar = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAa9J"
    "REFUOI2lkz1qlWEQRs+X3KiRQCrFxkKQkEqs1c40FrYWgisQC5vUdi5Be7MBW8HSTgUR16Bg"
    "lZ97551/ixskQiKBTDkwZ84zMNO0sspFanZac3fvZ2cVFpBZWBQaxbsXt6ZzAdSKB9tXiSqq"
    "IbJ5//ng/AbihWXxez/wbDbXVzmSOj9gLoFFMbyIbHS2wqHE6YDcfdkAVNEetAdPvFFrhjce"
    "xZW15GDkfwwe7kAVUyZTJoffCo1GNPGE9bXm4KwI7cEUAV+/QDjcucuRGMOLhS0jjEsTIX4G"
    "QG0J0AEe4MG+NuqFaOHZbFwual48//Cs3QIzx4ej6sxqKCsRMBTcwYyjeTGsESssl7coKR7d"
    "fEpkkhl4OXuf3jArOd6sCmYQQYgvDf4CipbAw/n+6wfmyta128h8MKvFWA6KLA3cqXkx7F9A"
    "SeJhiC1QV9SVMR/MeiFwMkIEJYWcMDBvWkFDERXUFQtDFsqsFseb792HTIigJbBobmyuEQXq"
    "TathYWxf3yLS8TBUlOnVzusuD1qD9qQ9ebvxmE7Ais6gAzqb69sfCS8ykoyispgu+s5/ANUJ"
    "nv/nEF39AAAAAElFTkSuQmCC")
index.append('chart_bar')
catalog['chart_bar'] = chart_bar

#----------------------------------------------------------------------
chart_bar_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAglJ"
    "REFUOI2lk71L1XEUh5/f9V5fwhAKQiHuEoEOqRCEqENgBi2NzbVaTQX5J7i0OrQEIc1GuEQv"
    "BCISFlkJDg0tiVjgy/Xe79v5ntPwCwq6RtAZD4fnPB8OB/6zinbNe493LKsSBXJWoihBlEc3"
    "63/MV9sBQlQmB48hqqiBZOPJ2kFbg7YAl5SYlW/7QspGX08Hh07/HdB0QhTFJ0WyEaoVGk7a"
    "A3T2rgGgiiXBknAtGSEaPhlJlO5a5sDnvxhMXQJVipwpcqaxrgQxXMikDD014+CoCJaEQgTe"
    "vQVJMDzKoYv4pLRiGcF3FohLRwBCLAHBQxJIwn4wQlJcUFI2ersUbSq3nl+3FIUYE8knQkhU"
    "1AcQAR/Ae4iRw6bio+FiaeGTMTSwQufnjG02kM1d6lrHNz1VdT83hwAxggjiUmkQlZiN0Fri"
    "4sQa54fGOH3iLK82Fln99IK9HaGirXIrzpUGKaFNxccS4KLSaiwyOjhCrmRGBqbJRWLs3Dix"
    "sU/FWu63CGUcdYpLvwC7h9vUil6uDt0G4M7UA86cGgYzqtpykBKMT0DOIII5IYrR31dDFL5+"
    "2WNja4X1rWVmpx8y9+wG3R1d5RXud11GF3awIFjKWMpob2ZpYQuiYlk4Wb/C6oeXjA9P8vTj"
    "PJ1FleX3rzn4PtT+G9vVhZn+OYpipoDjBg3M5t/Mb8/+ANb5e33P8V9pAAAAAElFTkSuQmCC")
index.append('chart_bar_add')
catalog['chart_bar_add'] = chart_bar_add

#----------------------------------------------------------------------
chart_bar_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhBJ"
    "REFUOI2lkztoVFEQhr/d3HXzgkB8EBHzAAujIIJgkdhFFK0kgmJnJxgrEUxpZWctgk00WAmi"
    "kCamCCpWKipopUHQRE0QyW72nnvOzJljsQEDbkRwymH+b/5/YOA/q9SqefXecopmBIUYjaCG"
    "V+PORP8f81krgA/Gkb2dqBmWQGPi4YtaSwctAU6MEI2VVUVioqejjTVn/w5oOCWoUYihMeGz"
    "MnWnrQE2eSUBYEYSJYlyRhI+JApJiBrtlUitiH9xMHYUzCjFSClG6m8MrwnnIxKho5KobRYh"
    "iVJShVcvQQUOHGTNBQox8tCMUGwpoU42AfjQBPgCREGUVZ/wYjhvSEx0Vw1rGJfmzicJSgiC"
    "FIL3QmaFp6wKhQcRCIG1hlGEhAtGiM1bnNL7nJ56Qlz6jPb24keOc7v6lczc+mbvIQRQRZ00"
    "HawD9ny4y+jAPPvGJqgO7ce9neX9szmGcZQtL5pC56AoQARrGEVoAlwwdr27xfDYOO0f5ylN"
    "naNz4QGD/b0c+vSFLOUONkZQxZzhNjjoqS/S3jcEJy//Pt61nfTmQma5awpHRiFGUCU5JWii"
    "r6eCGtS6dpC/nqHr0UW8+0YO1Gtt/KxmZDeqx7DpZZJXkkSSRKw7MjO9BMFIUdm+dZy+57MM"
    "busga6tQX1EWvpd57A+3/sZW9fTs7sn8x9KFspUGrJwWjXTzxJxd/wXTwHeEAuIx7wAAAABJ"
    "RU5ErkJggg==")
index.append('chart_bar_delete')
catalog['chart_bar_delete'] = chart_bar_delete

#----------------------------------------------------------------------
chart_bar_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoNJ"
    "REFUOI2lk01onGUUhZ+ZfJN0QuKMLcSQSmsSsdOWiEMUxKZuLBUliMTiqiBSkQa3xXapKyW4"
    "c+HCuHEhLgptdTVgK9Kq9CcSm0ViMNpaktFEYzPJzPt33/u6SBdCZyF4l5fLc86Bc+F/Tq7d"
    "8vRnqymq4gViVLwoTpRP39pz333WDuC8MlbpRlTRBBITF2402jpoCzBB8VFZ2xBCTJSKHWwZ"
    "/e+AphG8KDYoEhMuy7NppD1Az5xKAKiSgpCC8GpIOJ+wIRFE2VGINGxk6Vz1ldDad7ajZ4Tm"
    "n9+AXX5t28FzR0CVXIzkYmTzR8VJwrhIiFAsJJ7eeYnu0tGzxeHDlAar3P11H/O16aksBSEn"
    "Aj/MgAR4/Am2jMcGpeW3Iwx0f80b46uUHzzE+tI8nTlP7wP99OzaU8qS89sAZyEIBGHDJVxQ"
    "jFMe6brGS5UFykPP4+qf09md4/bsAg3n+KSjsSOv1oEIWAfWgvdsNRXrEw/nv2fyyRnKwy9i"
    "Vz4mV/ibQk8vWahTrzxL3RgyNfeUnQPvQQQxgfJGjeOj85QefRm7/BH5guAbg6xcvk6tf4Rd"
    "xV5M05Jpa1sVYyAECIFqdpkX9v5G38Fx/O/TdHQm7MZe/rhyg3O7q/xFnp7gsE1LPrXMvyI4"
    "FldnmJpYITJAfe5DFEtzfTc/1ea4OTLBmoJxBi8e03LktXVP+ZlDMHaYm9kSB8bepOvOFRYv"
    "fMtsbZ2rX84w+cVxNgtFKn2PcbC/QhCPM47cO0feSxqE5IQUIl3V87x94iTkI7NfnWfx5zt8"
    "sPAut9YH6KtcRIISJRJF0aj3f+OxsbIZHX4oe2r/EKngvnNra6+Pvz/3S9seA/8Ar3F5y8ps"
    "0/EAAAAASUVORK5CYII=")
index.append('chart_bar_edit')
catalog['chart_bar_edit'] = chart_bar_edit

#----------------------------------------------------------------------
chart_bar_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjRJ"
    "REFUOI2lk8uLDXAUxz/33qFrGGaEsnA9MmaEmonJeJWiKFFSiuzYWY6wkp34A2wslDwWShFF"
    "EgsWzHiGMiWv8hgk4977e53fORZXmXKTcuq3+J1+fc7n268D/1mFZs0DZ0csqxIFclaiKEGU"
    "U3srf7xvaQYIUVnd3YqoogaSjYtDo00NmgJcUmJWPn8XUjamTChRdfrvgJoToig+KZKN0FLk"
    "h5PmAD24zwBQxZJgSdiejBANn4wkSnlcZtTnvxisWw+qFHKmkDM/HitBDBcyKUPXxMccXX6d"
    "rmu7ZszfcHpkLKBoSUAEhgZh8C6IUHURn5R6VLLUWdRyhf6ePjSH/X8YWIgURCB4SAJJ+B6M"
    "kBQXlP62W8yas4zJM3t59+zcwKHLOwbeiZJ8IoREUX1oGPgA3kOMVGuKj8Yk+0Bv+SZt09rJ"
    "o5eoLNnNJjrYMm8nmxfuwtc8RXW/JodfABHEJWLK9JWvUlm8FfwD7p06w6R2x/iRF3x8eYMo"
    "AVfzFLXemIpzDUBKaE2Zlp+yohJp66ij4RWYkquDzF07QOfIc5KvNgys7sZEaMQphkSPnqe9"
    "0oPWn2DqWLqtC43vKZeH6ezewpS3Q7h6oKh1BynBylWweg2IsHHmHbo7F9Ha9gWTr1Aocf/C"
    "MKCoH2b6gtl0vHnI1BgpHF5/xDQJFgRLGUuZVTsfsHbPcUrF15h8A2zsz1Oa0MWnZ484ffJE"
    "8228faz3i4m2mhqm2jhm/L4bqILa/Z9lNHr77iIl4QAAAABJRU5ErkJggg==")
index.append('chart_bar_error')
catalog['chart_bar_error'] = chart_bar_error

#----------------------------------------------------------------------
chart_bar_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAltJ"
    "REFUOI2lkz1oU2EUhp+b3jTWlNZKa2qkdqiIDhUdHPyjUuvuT9GCDoI66SjqKDhIwW6KTg4O"
    "4lZcnBSFSinSiFVBCfiHptc2UWyam3u/+33f+RzSzSiCZzy8POd9D+fAf5bXrHnp3qKzIiQG"
    "rBUSIygj3D238Te93wygEmHvltUYEcSBsY4Hs9WmDpoCIi0kVigvGbR1dLa1UIvk3wFhZEiM"
    "EGvBWIfyUyxHpjlALl9wAIjgtMFpwzHtUIkj1g5thFVpSzW2f3FwYARE8KzFs5blOUEZR6Qs"
    "2kJb2lH9UwSnDZ4x8KIARsO27dSihFgL9aQRIW71MJH+A0AlDYCKQRvQhiXlUFqIlKCtoz0j"
    "SCicf3TK6cSQJBoda5TS+BIrUsZArEBr4nqdXDiLV/zGrtxaip8WqcswrUlC7+wm8uvyLFYW"
    "8XszPF16iC/RymSl0Epx//UbDm3p5/jxk4RhyMDAVx5PPeNgH4weHiXtpwmCgEKhgHkHvtRj"
    "SBKIIqYrP3g/0MXR4WEuXr3N988F8ut7GRwcRIcBE9cnCIKA7s09nDlymo9fPuC7egQrEeaq"
    "y2Q7OhrL2XqC2ttpxsbG6OrqolarUS6XuXHrJn07G5o1HWvwpR6B1rB7D72vXjMTBAAsv7xD"
    "yhPGx8fJZrONAwtDUnjo53Xogy+lr3hXRq450QanDFX1k1KuxI79+8jnN9DZnmJhYYFisUgm"
    "k6G/v59cLkc1jJkvlXgyNfPbN7YMDQ0NZrPZyXw+35PJZFqcc6lKpXLW87xSd3f3JJBWStn5"
    "+flyGIaHfwGsy2GeQvtNQgAAAABJRU5ErkJggg==")
index.append('chart_bar_link')
catalog['chart_bar_link'] = chart_bar_link

#----------------------------------------------------------------------
chart_curve = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAphJ"
    "REFUOI2tUmtIk2EUPufbvhpLatMiMp3RLGEmzQtKKjUsJLUaUWZLskwIUixtVIRl9quRCGHR"
    "/GNhKhWhGBRdhaUVSzMkL/Vj80JgKam7uH3fLt/79sO+4aBf1fPnHDjPeXgOzwH4H0g7/54W"
    "m+0H/2aXEZtvUz8i9Y32+0uHc4ePXJ8vMkzMFxmG5g4ZSv4kgAAAaefeUUlkTJqMCfb5pGyE"
    "1ajiHHv1vYhMBiIOEsQoiqBCgO+AVKfo7BwLd0ApfFCrBmc9kiDnJh2e7bprEvdCFnrdOSsf"
    "d6YrujrU6OIT0MuvIpwwXHBzvC7MQaqxlzqGLCpeW1K5Z/pTVcNnk8CweEfeZ60QiSm1Ew2s"
    "hFQhIpFKgTBI2Z6LGxcNpBh7qEic0Wwjk8m7fEvvjDs98UBdPRbYbLTf5bUZm7yp6bS92GQO"
    "EVLOWigAgH9NdDu/LiaQve8FJy8db4RCKlGcGH+uPD7Gry611Yp8XpNk8WqSHAAAUgAAQglc"
    "0u7fytgtBgQwvZUnEPBCDYMTFW4PIEPAEHgU/1AUkI0O6fgNan/IgfZMN6WwTE8Z1haWkd52"
    "If+ezlzQmv0xry1zILcto0gc+deu7wo5oJSADwR2ORGyRMJuc2Y+4NFqgRN4gswAlQhKitC8"
    "syVV1n1soIV18eWhGCkl0BoV/xMBpgEAdKbk27yTu8+7uJd8YGHLq5PWA6/L+nOCjsAtvzNw"
    "AwAAudmpUIxJFc+ogq2ODkgldRSZPACyAgFrrPXDTUsv2nElTuZjIkYFBp72Xx6pDHskN4fp"
    "nEfocNrkZRh0xljrh5uUibmx4rJSnRv75uok75sJZru+4IimXBMRcpB46gkFSoECBQAKQBYr"
    "/S0u1kXQUP+1uRDhX/ELTJsg8s3MDJMAAAAASUVORK5CYII=")
index.append('chart_curve')
catalog['chart_curve'] = chart_curve

#----------------------------------------------------------------------
chart_curve_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtVJ"
    "REFUOI2tkltIk2EYx//Ptw3NtJwWadg6bGbOzHlolUZIJ7Isi45LlMxuUixtdKKI7hrVLirQ"
    "6qKgiIpQOl2UEYmaLYMMD0HlnGGYiqc5t+9z83vfLtZGQRcR/W/eF57/8+f3PO8L/A9lHGvi"
    "+VX2Hf/SKwQuPb19UXmX7Xd/LQ7v2Xt+ZLepe2S3qW14l6nwTwEEABlHX3NFVFxGqDDZPKFU"
    "hdvMGnF0c14DkbCMiD4womhO0BDwHcSzI2tqun4n4BxvtZoPQ27FpOhi1e5V2ecUrvEs8rhW"
    "T3tUY4x8WK2lMSmBPNJ0Jsrtm644zv5GkG5u4KNtdRrJUFiW2/++3NpqkQUV3QhrtpUGjGln"
    "uq0qBSsnIqZUggnEVfUnF/gB0sz1PGAc0K9gX1PXTvw659xD3fe0FV2+hWb7TcmwLN6TbuR3"
    "8i1VQUPakToOAN6Zs+9IsXG+lVuei2FFjsvYyRWR+x3P1Pu6pBlFnWcCfkmfXOfRJ48CgBIA"
    "GGc4bdiWItjrTARYGsMSGDw4JVB3qcsNEhhMvge6+4GA0I9t2dI8rTe4A8Phl7zlUs5WCNxK"
    "zKcLouV1Ht+4/cA8osmlUeK02OneCLXXK00ZcztdWe96v5U9/qxX+h+BYQKyKoTJWYHeDVWZ"
    "G0EFFbIoS9FetUcXM2t2emIG4qLi8arjYURj+FCicU7sRSEQcDtaN0hAPwBkW1IrJad4VxoT"
    "ayXf+GJhXJ5vWJQCWZCRErsOMvmwPDkTAC/1EzCGWwX0abky6RonIUcc8k4l0HHbhfarAJB7"
    "KiRUReHISSwGAJjXXMeTtkoQHocGP5JLJKPolqudnWHFNOmMs11ov6pOWj8HAAad/VJHbxMs"
    "L4oAAJbaItgHWsHBJQKApINPOTgHBwfAAeY/+c/wEMUTaHVvkLlkJeJjUvGlrwVNrY3ocTit"
    "hL+UsSTGAqISAiI44ALnlc2VfSd+AJZYNiQKi9gRAAAAAElFTkSuQmCC")
index.append('chart_curve_add')
catalog['chart_curve_add'] = chart_curve_add

#----------------------------------------------------------------------
chart_curve_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAthJ"
    "REFUOI2tkltIVFEUhv+1z5kapqjxEmR4GdNuM0WTmnajTCLSMo0uNolREURFF5Oy6EJPJYVE"
    "BVkvRUVUlHahoqxgcCrMhxQ1qXBGIzWtvOTROWecOXv3YCMFPUS0XvaG9a+f7197A/+jkva9"
    "Erkl7lX/MsuCl09t7aFZZ9zXf212rV13ojvH0dyd46jrWuNY/ycDAoCkvS+FFBqZZGSBKp9s"
    "GFlZEK32ZGa5iFgKEdVwojBBiCbgM0ikmsvKPL8TCIHXcdE1nf1SQFV4af/81OOS0jeXvEra"
    "qHtlyea7pXHUq00irzaaq3r90rNNR38jSCxwiZ46Z7RmX79jWceb3cW1RToz0EVTVeX2oDDh"
    "SHOxQeK7iYjLMjgjYag4MH4QIKGgQgSFX6yz+ccZi3y/5ozZ2XwjLt/jn1jgvqTZUyZ4E5PF"
    "tdyikiFBwh6nAICBMeOuaRGR/nnLn6imjU1nsFpI5k1Nj0M2eLTwjY1HgnrNOs3ptU7rAQAZ"
    "ALjgOGRfMZ25nQ4Cil6YJnF4cZBR83alH8Q4HP5b8TeDBsaGulTNEjcwtAP7ruei+nR6Npgo"
    "Ju6PH0LLaizMWLnZQhSYueBdd4S9oXUYfe8L40y0RHWaFGu1YpMHH4HDB90wnOtzg7NLSuZk"
    "gPLydVXXFjcqykI+euyUzYfZ8Fgb1NryqAZXuf409N0OFjS4Ghb/jYAOAEgtmnFO+65e13rV"
    "cs3fN9VW/cE0OW01M7qdoMsOmDx3YIkJl3SI/EECznElj97Pkm0XBLF0tXNgBIEKK0/WnweA"
    "Q2lyrHFsLJCxZyidfDQCkiCLHPxIikrJgumlvvaRt82W1heVp1rUENviqO635Z84E63emoeR"
    "I+5vg09thxeA0itBl9BGAGDb+kBACAgIAALgg6f4aZ7pe4TsYS5YwgYgsxYoXwPwdBgQUAMH"
    "CX9Zrpyo/d7Oti2MUwxnopVDlKQ/48d+ADTsQgJxBI6sAAAAAElFTkSuQmCC")
index.append('chart_curve_delete')
catalog['chart_curve_delete'] = chart_curve_delete

#----------------------------------------------------------------------
chart_curve_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAudJ"
    "REFUOI2tU2tIk2EUft5vm4WoW0oWFbPSirTLSi1DKbGoMMsKK01KC7pKV7snERUpRQRJdDco"
    "In+klBgUdLHy1oUYzrKbupQ5L22zze3b1ve9px820epXdH4dOM8553k4zwH+R8Tsq6bMC41p"
    "/9Ir+JLWtvbg1HONt/sXremrT9lWZRhtqzIM1pUZa/82gAFAzN4qUgSPihksSK88SlVAba5W"
    "7F6c+oIxYSZjTM8ZCyEGLQPMYJSoKS1tGsiACC/DtXqLUyGJDl7inJ2Yr3D0xDOXIynoXukM"
    "zd2ScGZ3T2Aut5qLcv2iwuajAxhE576gbkOF1q1buy2l4+3OM3UFsqBiRf6vanN8wOlHjGfi"
    "h1TvygktY4qAyXB+ewa4TVm9xdzn5AN2Rs7iX6fN8/TXGbbdWLz51GXJ/GQ/ddeVEzlMZKu7"
    "Q9WnF7YreyVwAIB36Ihb3NYqL4+9xv11V865ekbv0gQa78dpniQdSzZBrY6HtbEBfsyLwKDh"
    "CAjRqpUAwIkjT7dsqtBYkcGAgkr/CRwuHBaYMSda85qdX9GEIWMXMo+5GH7+DF/1H8BtLohM"
    "nAoA0O14TAS/VBJUX/pT35B3oshqOEiyWEPOL1kktmSS/f0har44p90aO+4pACh7j8Dhgawa"
    "xOV4X/PZ0+H56YmOdeqIpXCbLkBQSfDax8BcUeMmrytldL21re+MRBw3QyK+MaADAPaeHP9g"
    "7qQlB0KjFsHbfhUKP4LHHgbzs1rpkGTxTtz9+g0TLf0GcI4ba9jHuD1Rl7J3jLNk69IWEMJg"
    "NhSCww2ndSQ6Kmo6Wxw9U9q+S5bY41GFfxjJIbIZolMuSR6hDY5M2IhBrZX4dK8K+odWGMoe"
    "td2vkzLnH3jZ4OmUEuwN7F3k1siAPiNFbSknEIFASJcPY//6TYAgQ//oLj43t+C6KhemH8N+"
    "7SSAem3z4doKxn5/jrQEjRgdPkwZO3EsSOWp9nR1rUspMDT9jvPFT8nEVa9pO9r4AAAAAElF"
    "TkSuQmCC")
index.append('chart_curve_edit')
catalog['chart_curve_edit'] = chart_curve_edit

#----------------------------------------------------------------------
chart_curve_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtRJ"
    "REFUOI2tkltIVFEUhv99jlPToGZGhGVjZTU1ao73zBCNXkLToszMkqIeutjVioKu+JBY04NG"
    "5ksPhRnlDGYWBAai2cVUBqcCLdMKLGu81DjnnBnP7NVDOCn0FC3YsBf7Xz/f2vzA/6j4E88o"
    "v6Jn07/MCuOXz/1fg7PLeqonPg5t2Vo6nJvXN5ybZx/anFfwNwMGAPHHW0gMDo3XCmqr20/j"
    "/6JIL4+sy25mTEhijNk4YzOJQc+AL2CUFmS1fphMQISX4XrboEtUZSe3uFLTLorO0RQmOVcH"
    "3rcmBtVawtlPxcAkZTqXva8zynvPTyKIK2qmEXujXjEVHMgc6Dhs7izxChp2Q9f6Yv+4MPZs"
    "n1kj8sOMMe7nBy4w0jSdWvgbILaoicaF34zJ/GPMGvfEPY+U3Wl5VHOSp55pq1ZMSYuluESq"
    "yi+p8AlijzYSAHhmzalSQkLHVmU9lnU7e8uQQ2LYntcNDfcO8sF396j7Uc5lAFCMUY2SMWrE"
    "9wecOE6bNkQLipwnjrouPdUZzJLEDgisz5M97/nq6MhEFhgSA6+i7rJbMhO0b+1pgiTpfASm"
    "Q0+IMCWbBM37iejphQ/MNst6RfleT0r/FRrqeUidt9fWtVXGaTyz59b6CIg43PBqwMdSxoez"
    "KpMzdq8o3xcauW0qlA603qyCf5AMVfZkMgRkaX4q+yYZ3Jq5yMGAAQBIK4m5pldwd2VIgjZg"
    "hgTu7gWIwzv6CgvTi5jX4yluOW9w/jHgHDe3s64VxyIqk45HfVKHxnI3TZvqCNKbwKVOEJcR"
    "t9EA7umHVtuN2cu3LAOUI5OC5JRZouzyWn681+0qnT+jeMHSLL0uwAFSBwEmot3aDYCDK92Y"
    "tSQMqttT2HTOaGQAELG3nkAEAgEgXFl0Fak7rkMU+kDqMABfTAAIEKcZMPDGhq66CzUMf6mn"
    "pTEOUrmOOIE4/32I8KcngHOAU/svZ49UQCCwcjMAAAAASUVORK5CYII=")
index.append('chart_curve_error')
catalog['chart_curve_error'] = chart_curve_error

#----------------------------------------------------------------------
chart_curve_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtJJ"
    "REFUOI2tk1lIlFEUx//nzgzVFDpoUYlNpi20kaZkIZW0GFJRQdtkthJE0cZQ0EIEEUkhQUHR"
    "S0Eh+ZLUQ8uDD6lT2EINFVSEjjVtVqM2M98y3/fde3qwEQOfovN0Oed/fvz/3HuB/1Elhx5x"
    "1aW21f+yK9KH6JdvWSvOt93oP+xav+FM97pAR/e6wKuutYFNAwEIAEoOPmRXVm7JYOE8Sbk9"
    "w1qDfqNn+YoWIlFKRGFFlM0EPwFfQVzua2ho/9sBMx4X+MMxzeUYCXVTm1d+2pVIlpGeWJBx"
    "u2GW79bNAoqbk0g3M5UhXy+9EDnxl4PiYAv3vHrgNws37VnW+Xx/7csaKTx0xfukdXdaOPN4"
    "R63HpfYTkXK7oQSxp/lwfq+BmcFmTgu/T5mjPhQtSvXPOXZvR33BgXZ7YrDtqllYOkEvnsV1"
    "VTWX+kVQAABrRE5dRndUVo05qLxbI+exhl2+bZH78bhaWVG0kedPW72l+gh9EobRtOpFXaAP"
    "oFjhWOGqGcI0Aq6kdjbknVSr67RHUIeV0FCR1LA5JXU7d/hkiK4evXp7d6XQdS8AuNFLwMnw"
    "nTwIbidlH0F9HvbVzT2qpE2WsmFJpz7HNxGTR5UiYWoIG61JneW9PgCzQgrSM0jJsnRuR1lY"
    "PG0zSVaQSkKB8eVXFNNzy5C0DLFkZ1NlMSGzD3A9e/zPHbF3nQBQXlN00XQsSFb4EHsPWzlw"
    "lA1b2oinEigcMxdJWxePI6FYL0ApXKumd7PdUy8ziUojZg01sxUc6WBkhh+OkpCs8PXXR2QN"
    "G4Xn0YcItYV+WBIVBADTd91llwyuZMFG6lsm+/I+h0ZP8GimZcFSFkzHQsGIqTQ7vwLPPj5C"
    "45vGONuDFkbPGs/c6VtQdOYWM0OMZMQ1RjzM4D+vlAH0mBtAYgia3r7A4Ni5DCFzngJriAb6"
    "IAPVuGPQJLu8Kcj8zlOIpPu/AaB3apXGw52KAAAAAElFTkSuQmCC")
index.append('chart_curve_go')
catalog['chart_curve_go'] = chart_curve_go

#----------------------------------------------------------------------
chart_curve_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxVJ"
    "REFUOI2tk21sU1UYx//n3r6xtqyFzuoV28GlazLTUEuz4Qu2DkKyIMIStSsgEROWCFOBZiTE"
    "Bfxi3ExG3DTug4kmEoKGbIPEBMVAuk0JkqjojLEL3Vql91pbWWN729u1PYcPSxcwfiKeT09y"
    "fs8//+cN+D+e/9hVtmc0/vz95HL14A/pz1U7R+Jn7/683b373YVQOLEQCs/cfjG8778ECAD4"
    "+75l/Ko1fgNXvV7WaE3XIo5SbsfOaUK4dkLIDUrIakbgIIAMwoKW8fG5ex0whu9Ex42/Fb5a"
    "ytMx5engO3y+8CQp5jtWXhhvs5wfE8k/qpsU1UZaqv2y/f35t+5xsDEyzXIzUYfq3ffas+kf"
    "Dg/9PFDjtOTjhuvXDtVB34nEkJanhwkhVKMB5QjTTh1ft2TAF5lidfCv1sdp8rGt5bvrdL6e"
    "+Ew8MldpicQ/Ub3truLGNnZmz8DoMuA7GmUAsNgknFEfWlN56rmvSg3750fwAuMtr8x/aX15"
    "TrXtv3mizqutnmix1ZMDAA0AUEbR7+3awMWjYQIMfNPgpijiTY4kDuUVEI4iXDm3/vO6gOHX"
    "maDaLC4u98D7xmX243DnLnBsaNuW4AaXy3VQEITjgiBYY4lY4ab9p1tlg1rxJDbZXWtbHpAk"
    "aaElOiV9RFi7ZmkIFGXUtDF9Y1Cn0510u919oVAIiqJAFEXT15P8IwrLV/bu3msx6FZAlmXr"
    "92azVXfp0sllgdOr12c/dDT4nnG7ezZ3dOBgf0+1LNd4QRCIx+MxyjLDe6eGIckSzCbzxd7e"
    "3s5kMtmzJEApPn2JxLgYvWhuNK8EANmciGhnLW93d3ebrFYrCoUCMpkMRj4Ypln/70kAsFgs"
    "ek19kfIl0lYrVKeklCQCMD2YELfn+JxhcHAQRqMRAKAoCjjwtGmmOYCtQCqVUgkAPPrqFwyM"
    "gRXTcOQnEXjCB0F4GOYVGqTTaczOzkKv18PpdMJutyNfqkJKpXB1+spv5F+3wQcCAY/RaJwQ"
    "BKFJr9fzjDEum80eIISkbDbbBABtuVyuSZKUURSl6w4wzUWylDoR6wAAAABJRU5ErkJggg==")
index.append('chart_curve_link')
catalog['chart_curve_link'] = chart_curve_link

#----------------------------------------------------------------------
chart_line = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdtJ"
    "REFUOI3FkkFI03EUx99/rkVgsyzIrcMOkhadtDKZtUGNLi1t4IgFRUJCRIe/RQWhjC5JDHMg"
    "HjxEEF1qxSLsWkrrYFPTsEaHMkGitWmsTPb/vfd+r1NSYYLr0Pf6+H7el+97AP8ooxTT98NH"
    "TK2UCQrjtlIAumhdWNd61CMWdaw6gYTDjoVP+YworBSkq/bVAr59zHcL4junx1VjJBK8YoJA"
    "dNIE5g6tqffJtYb41yZfSCvdZ0Ooc06kcgAAhjp7JglEQWAedNy8FfoVcLBzdDayx751an4O"
    "sukv471j/TvuuJt6Ei5vmWY8zkJxGyAF7S3Ndm1hs4pEGpa2d73wM1P57dTC3JsJ7uwZ7Xc+"
    "X189dNfduJ1YXTzmrfAwkmlYbaeSghQUxIwoKgfC3KONu98OuAJ+1HQyFfMNF3Y1Dghy1YZX"
    "6RYAgPrTD0yt6TyzuvFbB+HolMM7+/Tx/uz43urCTNGwrLwg1QCyJYvirnw/Vvizp6U/8EdH"
    "qnK4OPRwc/3nc9vat0CxeEiQaivaT5RpVGuXMwMAGIGul6Zovsya1gjR9eHYvtjP4fzOuqQo"
    "CgLpwU3Tr0PLAeDAlfSHvvuT4rv0LLvSSf8mG2uM3xspzDBSdymA/68fe5PzNtXQbdkAAAAA"
    "SUVORK5CYII=")
index.append('chart_line')
catalog['chart_line'] = chart_line

#----------------------------------------------------------------------
chart_line_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI2lk2tIk2EYhu9v36ZJTs3ANiMELUkCYZnLpk5IfwTN6SAJo5NREQNjJlGUIoHkTJaD"
    "UDCIIIIoiVFWUtFBWIKH1DxkYRaWieamzOO+733f7+2XYT8Ks+f/dT03D/cD/OcIq4Hm9+Y6"
    "FFl2QCZu1WoESlAqDduXH8clWvLPCXhBQcjcuG+QyySaE3pJ/a+C2TFfFSdkOCJOnyg0NrK/"
    "JsipeOcAYyWKQmtfXja6Z9LNNkVWrqkIDBE93kkAEGT7KQ8otYCxRyE3btqWC7LLOkcLU9Ub"
    "+6f8mOiY7qp9W5d0Ozbd1ag3iQojBxinbhUItajzrGpFIla5sND4a3t5exZjNPyWd87/voeV"
    "uTrrIt5oE17fjU3bSpl8dr8pMo4R6hCkoqMeTqiFEzLIZRoOSiYfrtvxsUGfk0UUethbY24J"
    "pKQ1cMJ0Ub0deQCw/fh9h6LQM4zJV3+7QUFFf4hp9NXjzImunQmBkaAgST5OaCIIk5zH4msX"
    "NKrTElnUzswHZqfn/FeeVvdViktwVkWbboHQ5g9hG743RaWYD35+0gzKLkSeOCQ2kU/qgDHG"
    "nJm6KzQ7dQ9IqD/Ut/B199rNolbIKe92cIWdYwrVcEqrW2oyapakU9sMHi5TS+mRGMGWlytC"
    "VMGaVAzXi5MQocIdz4OgSmHUkW/Q6BRG2HIYAKIHum3rh/o0vsUpUSOEw5pUDAAozb6OhJhk"
    "CBDWqJhC3PfaAiOM0Ko/9cEXmAgOjLXC+bwIAOB8VoThH73g4MEVVdlo11duio+8aErOwBad"
    "AUPj3Wjt9eLbl4Brxb9gtOucEAS7AGg5MAvO69vrx8//BG8zM+MqtYVZAAAAAElFTkSuQmCC")
index.append('chart_line_add')
catalog['chart_line_add'] = chart_line_add

#----------------------------------------------------------------------
chart_line_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl5J"
    "REFUOI2lk09IVGEUxe9785oQzT/RwtFkCEETV5aZaCmoi6JJExrEwEgwClfPyorSpjZWDOaA"
    "WLiIIFpUloIkkUopMy1sHFMRtUI0GEWZGc2/M+99371fq8QWhtrZ3989nHsuwH9K2snQ6qnT"
    "Kum6CjpzyDsBUEi7Gnb2jFlovGrbDoTValyZ9Y8Jne0VjN9TtgtYnvHfF4xNRJpNSVJLC/7T"
    "QYFtSAXEKiLe8LEuw7GUnVNMOjXKDNIiB10+AABJr7zcBpxbAPGd8emz4o2A/Jp+b+kRJX5k"
    "PgBz7oWBBk9Tyou47PoWU5aBkJ1DwR0yMG5RigoV0lihXlqasb699ksuIo947loJjA5iTX1/"
    "U+TnPYk9r+IyD3LUq0uyoszIuCpp5RfaBOMWwdiY0HkEcOZrj0n/1mwqyGXEz7vsOb2LhzOb"
    "BcPY6GF3EQDAoYq3KhG/gqg/+isDq23EmOX91HF8buBo4uLPkKRpfsF4EjDUxlN89lBovpyv"
    "BhNIFl4B4vGJbnqwDsi19cVKTGoVyCY1Xap477qWDBw9URfL5B8vGymYHsOT863G3QdSITjc"
    "CaPOTvw1Pl4lFdR+VQXhDSS+S3D+sNd+zP4HOp+a1iZ0bhmK/65lVteFh030AEy7AKKiwa+Y"
    "wfPBOQl5t9xTjW+GRM5159xm5+zKU4g8rWKjFmyxoitPIQWJOV73BVXi6NgMQLKYXhvs2B/e"
    "XglacBbWAGB5yQBogJktVdlZYrprjAi/nbAPFUX2wrKPw9SsAfUQ3dnyLzhLEm6uBWYuySSZ"
    "SRbTBOLJyW6q+w0BTU7hWkQGWgAAAABJRU5ErkJggg==")
index.append('chart_line_delete')
catalog['chart_line_delete'] = chart_line_delete

#----------------------------------------------------------------------
chart_line_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApJJ"
    "REFUOI2lkl1Ik3EUxs/efchM51LJmdk20kzTwDSFmnmh4MjPMINFVGZIebUZGUQiYmS2i4SC"
    "CjShi5AMLEsrkkxTdCWmqKlFtpHze8u1zb17/x9vV4aZBNa5PPB7nuccHoD/HMG/QO7MbD3l"
    "OD1wqJb5FwHKes9Lj+QpeS82bDgBX1Agcc0ujvEcCuQRrhRtVMA5vVjNI/RFpgzdKWhqIn9N"
    "kF4xpAdCDJTiG6+vJtVaK5OvOyPUF4R+ceBe7ARgrScFXMnZZsA4Cwh5JqlvOLxaIO1y/5Ru"
    "nyhsxG4D9UKb+WiiSCUNToEAdTwsfe2FoRcNTgYQzhLl5oioF+VwOl3SL/fyd6mEYL/73S5b"
    "pLO58XiGrzIw8gB47GPgMZvAX6YAWWC4n8BbeKqZRziLR2iM57AfYLTQsjlx4m5oeiqi+MSD"
    "tELppq26NnmEVuCdaQSPTQDzE8vw3UXprY+x1377QUHFiGT/VEdrytxA8g6HheVUS6y4LCM8"
    "ICIHWOsdYCQYkEsJtq6euSWPRBtveDUoXIFTK0yKZYSfj0tDrE/lCQcTQu4ReXF2ftCuXGCt"
    "t4ERY+Ccaljo6HNyrDsjrvTtAACAKL38g56n5CLhsJjHqKbTqDG2XlHkyxOPVW3ZnQncbB0I"
    "JTywDiXMd/V5CHLviS59b14xZijB+rx4sYISRDqNGmP9uW1Fqr2nHyF+u2Rm+CZQYMFtD4O5"
    "N73zvNcRG20wmVefzRCKah+aHBaCcDUAgL8qqi5GUww+37rh05MeGHxph+GW9mnPD1daVGn/"
    "5Nqu/FGkqjMxqKyoRAQMgcH2x2CZ/OySBQdotDWjQ+uVTbh2EeSLLlkmRwG7bNTrQ7oZoNpD"
    "NSPj68EAAD8BzCM5j/Fs7WwAAAAASUVORK5CYII=")
index.append('chart_line_edit')
catalog['chart_line_edit'] = chart_line_edit

#----------------------------------------------------------------------
chart_line_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAohJ"
    "REFUOI2lkllIlHEUxc83Y4OWY6MtalKDhktComlqYzmIFoHmkkmatPggrQ9j4lPJIEUiRk4Y"
    "REEFgUEqGVYEPVSWD2qOWRjiUJRk7kuuM99/7SE0Awm0C/fhcjm/e7gc4D9LWYloNvWARRBi"
    "AaE2zUoAwqUWexzKNEqVFS3bgczJ0c0MjnZLQn0kZWVuywVM94+WS0q/eBn9Q5S6Ov5PBynW"
    "DxZwXiQEq3p5JdY2lZCYJYio1lBEeXU2jwCAQs6cagBjaeD8qe7OvazFgOSL7X15O90CVNWO"
    "SK19Nuhmj7ZGv+tqnb9JKzg9wiWzaUBZmltGuptQaTrJy4tduF7aZuaceda3TIwneLwdCYtI"
    "WvN9v9/Aw03xYYyTksOmtUZOmUVRC040SMrSJKXdkjBPMDrS6B3Tc8s/xUwFO3Y3qdrsHZhR"
    "Ztgcj88vSn4ySfcdf16QIAQ7zzm59tcPcqxdOlPfq2d7hjritk72urg3nx7LNQQZ9xYC1IE5"
    "Zyj6Wm88IdPD2TEn7RQAFnJgtrb6jdC514/X7xg+F1zoC9D9U1G6wHXRRwFXB9ru18DT4ARz"
    "kjQF+vR5nSal9L0l+UL7gEJkl6SkoakiIb+lyuT8cVq/UUmMVfTecxDqV0AK8Jl3CEoqVjgh"
    "l5orTHoA0AjOLJlRq/wEp7ypcnclAHTV5uioU71s2BIJMfcRUjgRnR0KQfrh7u6Ab0TuNsBV"
    "BAAaLqittnWyl1NWPm/LNT5Y6BOcGr1aPwrJxgBFC/sjBwAB4XJgQ4gRnJCzb6zh4UsGqfV6"
    "XN/2/AcBWs03SDYBQC7aaqD1CMXQp070NJbVLxllqhJ3++2DTikkpBC/W0r8mSUgBCCk3y9M"
    "DU32b/GlCgAAAABJRU5ErkJggg==")
index.append('chart_line_error')
catalog['chart_line_error'] = chart_line_error

#----------------------------------------------------------------------
chart_line_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArtJ"
    "REFUOI2lkk9IFHEcxb+zM+MUa+tmq+5O4MCuRCJSVpqoOIeMlMwUlFQyFAoiPGxFdDGkQ4WF"
    "uRAGHSKILiW5kJHiIRKsMDUtTEkpbGlGF0dFd4bdmd+f6VRUh0B79/d5j8cD+E8xmzEZR48F"
    "qWUFwUIhx2YANGFe3FpbLdkmPr/hBnZdXZK+qM3YFkq1Eb7KbRQQU7UbNkJfXJJvF9PTQ/7Z"
    "oKz9QxAIOU8p7np5vSC0XlxaQy16x4EgzzU5vAQAwFjnzoYB40og5HnS/Qc1vwMOtY19b8jn"
    "dk6tLEN0dPV913h39iOxuLPHV8RSghqJjUMOQLiSO17FURNVWQ0NBb/Sr7yTCcHJD4f15elJ"
    "0tY51u16vS3w6rFYuBsT69KJohSJIBxkzJbmsI1wpY3QjG3hZMBo6dn2A5/v+cpkRPGp4Vul"
    "Q2v7C+/ZiHjdH0ePAwDsO/00SCm+QIh1+48N6tqnkvIjgwMea6ZoOWtn0g4pk9E+TcORt+OJ"
    "kfT0Pd9ysvoDgYBfVdVVVVVvzM3N3WV/muX2EW/cjA9EViY80sGAt7G5mRFFEVw+H7xJGNyC"
    "L21vU1NTtt/v5zwez1bLsg7Pz8/zTNmViaBNyWVCMZ+Y7esrkuI1J1taUm5eu9avx2LlPlFk"
    "cnNzYWFhATRNA0VRiMvlGmxtba3o7e1dc1CCg9V5vJcSRMyvL5bcbrcAAKDreu16LGbU19dD"
    "SUkJVFRUQHl5Oei6Htd1vRYAwO12CxyhKPRkJB6kmIQIIaaiKAkA2MLzfJhlWaGjowOcTicA"
    "ABiGASzLCjzPhwEAFEVJ/DFiTk5Ott/v75Vl2ZuZmUk5jkuNRqMwOzsLgiCAJEmQkZEBGOOV"
    "SCTiGBoaWvz7iawsy7lOpzMsimKaIAisbdsOTdPOMAyjeDyeMADwpmkSVVWXDMOo+QHffVKj"
    "WMOgogAAAABJRU5ErkJggg==")
index.append('chart_line_link')
catalog['chart_line_link'] = chart_line_link

#----------------------------------------------------------------------
chart_organisation = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAVpJ"
    "REFUOI2tkkFLVVEUhb/7vL/CF4KjkMLEsQhiIWWTpirZP/CXOBCcNEinTqzgJRGpTZoWCo79"
    "Dd7nvefsc+7Z+zgILhI+qV5ruM7iY7H2KYreBOOoHPWwe1plFxO1RCon7KxNF3fleqMALiQW"
    "J2G5X3JVu79vMPQB70tElKr6B8BVLez/dFTXjuHQjwQU4444cgOAo0+D/PHD+3xfpmtwcvw1"
    "mxmqStu2iAjOObz3NE1DXdc0TdN57/b2C7i1QYyR5y9W7zzV79pYX+tajb1BufXtTVZT1Awz"
    "5e3KQQHwevAqhxSQEJEgfNn8XgA82Z7JMbSkNoFlekkTT/svefZglVZTR5ZWWOwvsTC1gA+h"
    "86NE5h4+Zv7RLGaZMqmilrCsJNUu6CUwjBV1vMaLdH5qE2qK5Uz+BUgMLg9RM9RuAYJwdPGZ"
    "ECIhxM43zfw4PyPn/zTivR/pT3QDggTUKlAVg08AAAAASUVORK5CYII=")
index.append('chart_organisation')
catalog['chart_organisation'] = chart_organisation

#----------------------------------------------------------------------
chart_organisation_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcpJ"
    "REFUOI21kj1oU2EUhp8vjbSDReggjakdlIIZbBWlSAkFqZkUJ4cuQcQtIAqCFHTsUAXBQYtI"
    "oJOjYJDG6BAVSxEHRW1BEHQQQkFK7r25P9/N/X7cQhVvKYrveM7Lcw7vOfCPEmmNey99G3YV"
    "vuzihpI7s6N/9GbSAGGsmN4HM/ksjh+mbpBNa3hRTBRlkVLjun8BcHzJ0rsQtxPieVEq4P+q"
    "Xq/bWq1mt/P0km02m9YYg9aaJEmQUhKGIVEUEQQBvu8TBEGvVq1Wf71Ko9HYdtJWlcvlnjf1"
    "D37X5buzN4zlWpxEg17gdtr+5q1nNz/NiyuvLlptNNoYjNHcLz0UAOeXz9lYxci4y0BbUBjK"
    "caxwnJGhMV6sP+bN2ms+txwySitO5c9QGjlNolVvokwk0/mTFEeLZNuKI4cm0BnNRK6EFgkn"
    "Dk/RHykySmu0UWijUFr3AJGM8boujmzjdDbZJXZztnAJgKszDzi4dxxhIau04snXR2hj0GYL"
    "IJYsrz0ljrv0eT9Yb63yobXCXGmJhecXGOjrx4odhjhZyc3vP7Dn+tR4kbHho3zZeM/qxxW+"
    "f3Nv7/gKk5XhBYSoCBi00MHaxbeLG3M/AQOz65/36w9AAAAAAElFTkSuQmCC")
index.append('chart_organisation_add')
catalog['chart_organisation_add'] = chart_organisation_add

#----------------------------------------------------------------------
chart_organisation_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcFJ"
    "REFUOI21kj1oFGEQht/dW86LZ6eC8byEWJhCULAOgXAGNIqVIVocFhailVgJgqQSSxt/igOx"
    "sBQ55c4jCUfkegkSLASDRQwnotzu7X5/+818dksUN/iDbznvyzPDzAD/KC/PuL8aO2EsYmUQ"
    "CoV7F8Z+mfXzAEJbTB8EapUAg1jkThDkGZHUkDKAUoQw/AvAIFZ4/EYgHApEkcwF/F+1223X"
    "bDbdTplss91u1zEziAhpmkIpBSEEpJRIkgRxHCNJkqzWaDR+vEqn09mx03bV6/Usm/sHP6u3"
    "UL1pxeCqTWSVfbfp4B6cWuG73vXXlx0xgZjBTHg0+9QDgEut805bDaUNTrz7jHNRyUzW5ou7"
    "Jo5Cvl3Cem8ZjbQP35LFycpZzB46g5Rs1lGlCtOVGUyNTWFy7T2O1OaLpQ+r8J5cxO6N5zg8"
    "vhczWxECSwRiC3YES5QBpNKITIjYDHE8MigdmADmbmR+sDiK/YIQWLJ4ufEMxAzibQCt0Fp/"
    "Ba0NjpULEGstlF9cg5Z9CADDqIBvI4XfW2JvYXSxuKd8q7qPgsDfxPCLxcd+gYzi2390BfF1"
    "64rP3jj77hPDPTy9wne+A2cD84cR2i1IAAAAAElFTkSuQmCC")
index.append('chart_organisation_delete')
catalog['chart_organisation_delete'] = chart_organisation_delete

#----------------------------------------------------------------------
chart_pie = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAyNJ"
    "REFUOI21k0tMXGUAhc+9c+eBcxk7Q8troEAZidKWUKlj0qrtBlNDotHEjQsTNrpyIabG0DZN"
    "N6ZpZUHQErtok1rdUC0xNnUpiNBiqBSYYTqMQijUGQgtTP/3f+8dF9qkjW49q7M5X87mM/BY"
    "Pp87aT9UqkdIeURokRRKQkgxyYS6Lty3P42GDgbPvx5nj2+MR6Vv5sQhodTF57e93OSzQtCG"
    "i8qyHVhYSePb1DeDdebgrJTuUamd7ovvt4w8ATjzW++bOwMt31WEa7GqNjBN0vCVTByw9+Hy"
    "jfP3A6U3klGvczKZKI+llopYzhffGvp431UAMPvmTsaEUpcq7Z24RbIY3ZzApt5CoqwBhfxd"
    "UMqPP+10ftRSWRariobwTI0NyvSlVz8cjwGAWSSkpyN6yM7xFaTZHTBHYIcvBlv4MXx7aLrW"
    "98VNwdR7ifowMvcEYpEgWuoiNte0BwBMJkmXzx/ELMlAORIR00Zb5FlMZn8BZfIDRxr97c0R"
    "n9IeVjYUsnmJ6oowOBddAGBRLlul4cCEgXZ7DxqDcSz/kcPUwtSFpshXtZzJjnhFGSayDIy6"
    "oEUXz8X9kFI0/QNgvCq0PfBS+X4U7t3Fuam++5Kq/t6trnPLWxPW9fDu3NoDsdeCAUY9lDwP"
    "UllQjPsAwOKML/46P97+/dzVdcnF6d5849DhjdC7JTZ/xyHTh4d3JyCkC8ZK4NRFRdSP1TUC"
    "rXju7weEXx6euTL42dKua60k2ONxnta76m0j+ztAKbhgYMIFZyUI4qC++SmM38hBSX4NAKwf"
    "Fvdf0KR42mNiQDc3BHRzAzzXhXVrFiYlkExCSBecAx17y5FZLGAmdZs4nPUDgAVKLfchfUcf"
    "SAac6DaI+TT8NXXwCIVLKARn4MJFIh5GJruKbGoBDpfd+bFj6wBgGgMD616RdRs3p4BUBv7q"
    "GnicweUciiooIVGkGmOjM/h5ZHRx5c+l1/Jjn1z5lwubB1/pNLj6UiUam5yq7TB/mkCpUGh7"
    "8YVjX3tScsdVPzoePbs+cor8p0wAUGhttU3uHvWkPlLSOglHtlU/WJvF/5m/AJ2FvlMcUiZg"
    "AAAAAElFTkSuQmCC")
index.append('chart_pie')
catalog['chart_pie'] = chart_pie

#----------------------------------------------------------------------
chart_pie_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2NJ"
    "REFUOI19k0tIHHcAxr+ZnX3Ijpvu2uiujxifRNMYrWFbbIqBYggIKS300kPBSwuGHGpIKbYl"
    "l1KWEg/BVsFDAmnoxbRK+gg0hJI20WaLiVXX6LrJBjWyatXddf7P2ZnpoQ+SS3+n7/L9+C6f"
    "gqf4Yu6cvitlHxfiBDd5lEsBLniccnmdW299FvS94h05WUGf7ij/hoGZTzq5lJdefO7VGpfm"
    "g6lYKC3ai6XVeXyT+Hq4Uh2eFcI6K8xCz6X3Gm89I/j8fv8b+zyN35b4y/FEbmHamIfLUdGh"
    "t+HKbyPbHuf1aNDuikfri0OJx3ksZ/Jvjn7QNgYA6sDcuRCX8nKpvg/3jCR+yU4ia+ZQX1SN"
    "9cwKCGEf7yl0nWksLQqVBX1oiOgg1Lx8/P2JEACoecPoaw926im2inm6CFrg2OsKQedujP8x"
    "Ol3u+vIup/Ld+io/FtY4QgEvGisDOjNJHwCoVBjdLrcXs8YCZEEgoOpoCRxAPHkHhIrTBaFc"
    "aK0LuKRpY3VLIpkRCJf4wRjvBgCNMNEslAJUKGjVX8B+bwWWH6UwtTR1sSbwVTmjor2ipAiT"
    "SQpKLJC8haYKN4TgNf8IKCvzPe85WnwE62srGJoa2BZEXujPdQ8t5ya16/6DqY0dfkiDAkps"
    "OLYNITVIylwAoDHK0r8/mGi9Nje2KRiP9Wf2jx7b8r3j0AeLBWP62PjBenBhgVIHjFgoCbrx"
    "ZMOAKVnq7wUGuzI+c3X4/OPaH5oNb5/N2LxZW6UryYcAIWCcgnILBXYT4cAtSJ7FJmEoK/fn"
    "HgHQvk8fuWga+ZhN+aBZV+0x66phWxa0e7NQiQFBBXayPyIcjqO9KYrKUAN+TozD0X/ttE5F"
    "zqsgRLN2ydvypXaPbKgBW1yATRhsg8A0CDij2M5eQ+uBw7BUC4cjXbAUEy8f6gDgnFKVwcFN"
    "O097lLtTQGIB7nAENqOwGIMkEpILbO9m4FZ0nGw6DQA489oI6kpboEDxqQDgHxu9ai2mjru+"
    "u5HGzduwU2lYlAOSQEiKP3e27MTaBGI3egAAsZ968HBjBg4c/t+ZAGC9uVlXmXXWFuYJxzSj"
    "KIiW8M7GbLQ38mlV7Z6POlqOoiHchqXMfUzM3MZKOjfwjOD/iPaGY1CUXgUodoBdOM5QfCjz"
    "4V8PgspZXCDHrwAAAABJRU5ErkJggg==")
index.append('chart_pie_add')
catalog['chart_pie_add'] = chart_pie_add

#----------------------------------------------------------------------
chart_pie_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2pJ"
    "REFUOI19k0tMXGUAhc99MDN0LqMzQ3mWzkyZkha0oaXBxNa2LmhqSDQ1MY0uTBoTSUxYFFOj"
    "+KhuGmJk0aAlNqZNW+KGKoTY1DQuVGKxGOqUx3QYKBAKZIAAw3D/5517rwsfaTd+q7M5X87m"
    "KHiML8fPGVtStnEhTnCLN3IpwAUfplze4vZr54O+Q95LL1fSxzvKv6Fz9OOjXMorB55+Iabp"
    "PliKjZLC7ZhaSOK7iW+7d6jdY0LYZ4WVP32lpeaXJwSf/9l+cqen5vuwvwKLcg0JMwnNVfG8"
    "sR89v19a97ivNAadpuHGeFFoYi6H+Uzu1d739vcBgNo5fi7EpbxWYuzEPTONX7NDyFqbiBdG"
    "sJx5BELYR0/lm96tKSkMlQZ92F1ugFDr2vEzd0IAoOZMs60heNSYZgtI0knQPMd2LQSDF6D/"
    "fm+iQvvqLqfy7XiVH6kljlDAi5odAYNZpA0AVCrMZq3AizEzBZkXCKgG9gX2YDj9GwgVrXmh"
    "XKivDmjScrCwJpHOCJSF/WCMNwOATpioFUoeKhTUG88g6q3E/Mw0RqZGLscC1ysYFQ2V4UIM"
    "pSkosUFyNvZWFkAIHvtHQFmpr9hzuOgglpce4eJI57og8kL7ZvPF+c0h/Za/bnplgz+rQwEl"
    "DlzHgZA6JGUaAOiMstk/HtypHxjvWxWMd7Rnor3H1nxvuvTBZN5MHOuvi4MLG5S6YMRGOFiA"
    "xRUTlmTTfy8wWU//6I3uL+Z23aw1vW0OY0lrV5WhpB8ChIBxCsptxKd60DR1Fduys8j6wgjJ"
    "yMZnAPQfZg9etsxch0N5l1Ud8VjVETi2Df3eGFRiQlCByuR1HLB/xN63WuCN1YGN3kZk8PaR"
    "w67eqoIQ3d4ib8jnGjxydwxsMgWHMDgmgWUScEYRvv8N9rx4Er6HP0O5+jq2zfQhGinWbLhn"
    "VKWra9XJ0dPK3RFgIoWCsnI4jMJmDJJISC5QtLUIX1kMaB0AOtaBD2agkxQ0V4nqAODv672R"
    "PXTkuJZIfm3HozGntBigHJAEQlJsqH5JEzc9/oF3IFgGFMBWToOtYem/MwHAcm2toTL7rCOs"
    "E65lNSIv9pVtrIwNnir/1GP4P6wqtnVdXcDWah5zGc2W3PnkCcH/MXiq6n26ttSiOkrEUd1F"
    "B273Sz855/8CgsPMPnmI/moAAAAASUVORK5CYII=")
index.append('chart_pie_delete')
catalog['chart_pie_delete'] = chart_pie_delete

#----------------------------------------------------------------------
chart_pie_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA3tJ"
    "REFUOI1tk11MW3UAxc+9vdzbrrctLdApjG/EBRyDQWocKBiDI8PgpqKJMRoTM8ODD6CYiZrF"
    "F7PN8bDoQLfJlrksSxBHzHQu2UMxjE0M2A1KoTAon7apdG25H//7VXzSYOQ8nfPwO0/nUNii"
    "ryaP8Ruq2kEUpYloxENUBUQhoxJRbxCj9XOnuZY725IjbWWof0z3/U/riape2Jf+dKGJMUOj"
    "DLgtWZhdmcKA/0rvLrp3QlGMTkXT377wbunQfwpO/tF1OI8t/SHDmo1VdR0+YQqmTRr7+Spc"
    "vns2xm6+6HGmGkc9JTaXP5TEUjj5Uv+HVdcAgO6ePOYiqnrJzedhXAji1/gdxLUESiz5iISX"
    "IYryJw698f1St8W102nGY4/yECXt0vPtIy4AoJOC0FHtrOfn5BVMSTOQdIIskws8ScPgvX5f"
    "tunMb0RSj5TkWjG9RuCycyjdZedlTewAAEZShGZTGoeJ9WmougI7zaPCvhuj416IkvKeDur0"
    "vmK7SdVS4OJeVPw1gKqsPRCrhj7GmfIgI8pKmULpoEGhkn8CBVwOlubnMDY71ldo/y5blpTq"
    "nAwLHoYG8XJWAJbMN+AorEJ84XEEbp4/yYiyJO80Z7J1thpE1pbRM9YdU0T1dFeiuWcpcYe5"
    "YS2fY2I/7zm0OwS7oxaxBwGwlAqb/RHwGXkORpbkhd8DI5U/Tl6LKjI53hUu6G9YN7+5KQVm"
    "dMHXsPRswtaQt470ogNQ/rwKdgeFRd80EhuGThnxvYwoyJcH73/feypU9FOZwHWkZHlKK8rl"
    "qeADxJ6bqzt6oKzAUdwCsvo1aFZHGp8PLTmPL25XXBy4cjHIXF+o6dOE5PGURL7UivNZrTgf"
    "KcNAfNGLHfUv9DhKWkBWe0Gn6VCThVjxjqPdWy35w5YuAGAgioyxIb6u7fewujMdJDAFwbUB"
    "41UPCsqboYbPw8RugiTysTY0hva7h+APx98KDx+N/rtE8XDrKymnrV/LzcE8F4GlMhM65UaG"
    "6zacbhYkkYuQdwJtt2qWF+Lckehw1y//+0K89plGSla/ufmatbC17VvMXP0Aa6ERcHl78XAl"
    "qZ4LPtk3ErF1Roc+E7Y9EwBEysr4c09Ric532mjQBny3BrE4PyvYMx11TSf897CNTFvDqWhU"
    "dVm1jxbn/dCF9ZTCGcM0Uk0HT0xObwcDwN+x8qR2EPPudAAAAABJRU5ErkJggg==")
index.append('chart_pie_edit')
catalog['chart_pie_edit'] = chart_pie_edit

#----------------------------------------------------------------------
chart_pie_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA3VJ"
    "REFUOI1Vk1tMHHUYxc/MLHspw7K73XKHBYGtpQV3C6IVK5iGakRrtPZFE5PGtPXFh2JqFC+N"
    "iTENCQ8EbWNj2thU+wC1LbE20cSkRlu7ZAtyZyGAlOJCC7LLzPwvc/OhqcJJTvKd5Hy/5Hv4"
    "BKzTF8PH5TXOWyljz1Od1lPOQBmNaZRfo+aBz/3uBtfpfYXa+h3h4dAx+HEj5fzsTt/uMsnh"
    "hi6YyPFsweT8KC6OfHeqSDw1xJh5jOnGwbNHwtc3ANr7214pcYa/35xZgLt8GQPKKCRbxFNy"
    "FOf/OL3itF+u91vNsfqKrMDIbBpzyfSr3e9FLwGA2DF8PEA5P5cjl+C2ksCvqzexqqdQ4Qlh"
    "MXkHqko+yjaa3w3neAK5fjcq82Womn5u79EbAQAQ04rSWutvlKfIPEa1CWgGxRYpAJlm4PKf"
    "3QMF0pe3qMYPVxRnYnyBIuB1IVzklYmutgKAqDGlRcpwYUgZBzcYvKKMGu+jiCV+h6qxdwwm"
    "dEbKvRLXLcwvcySSDHmbM0EIbQEAUSWsigkGRAiIyDuwx9+A5PRfiE/Gz5R6vikgGq+t9k2g"
    "8H47QFOY+5vB5XCAMVoGAA6VaCTXHXQ+nVWHxYU7OBnvWGEq72xLtZycS910XPdVTueoV7YX"
    "lTcguvwLflp9AYw7wDUiAYCDaGSmb+xGpHf40j1G6Im2ZGl307L7TVsbmzCUgSZh365gQXEd"
    "vPlRVLs+wVTWY7i7lAudk6kHJyjk/OXBniPt06Hoz5M1hY1LGaN6qPgzU5IC6YhZvivYH8wK"
    "+mCmexGKvoHd8o+YTcyBM3IVABw/zNSd0ZX0CUujXXp5yKmXh2CZJhz9Q1gL22+V1ByQQG8j"
    "9u0VPHnoAwRJHzaldGoQfycAiFBVh7mmvs6fqHXyyjKQiXFYKoHm0+AqibyY5ddgsRnAtmAq"
    "fShrasXb1bHlnpeuUgAQha6ue1ZaOyjcigMj48jIy4dJFKzsMOAricDSBmFbBLX7t8LiC3C7"
    "E3hk52uFAD264RdWG55pFgj/ileUlqW2CcjY8zjywh6YSgy2zRG/OIba/dsgSNmA5zn0ff3h"
    "kmBYz/4HAIDFqipZJOax2cPZ728/dMEpibOwjX8A2OtaIiTPViyODGCi99OeDYCH+q09et82"
    "rE22ZcO2rAe2bfyfbcCyAMuO/wtY2LaYjaxykAAAAABJRU5ErkJggg==")
index.append('chart_pie_error')
catalog['chart_pie_error'] = chart_pie_error

#----------------------------------------------------------------------
chart_pie_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA5RJ"
    "REFUOI1Vk11MW2UAht9zTtvTekppTwsdbVmhIMGxGhiGi63CsoQJwagzanAmW5ZFjCbGiD8X"
    "RLM7I2aYLHMjmYkkc1ETpiUaMy+MCSYbA4NDxt+6RqHQrqWF8XO+c77v9LT1wp9s79Vz8z55"
    "b14OD+SzuTP2XV3vp4x10TxtozoDZXRKpfo1WnjxI5f1kHjpGb/6YIf7D4ZmP+yguj5ywPlk"
    "rWCyIs8VUGmrwN21BXw7/9VwgB++zVjhPZY3To281jD+kOCTWwPH9loavnNLPiT1DcwoCxBK"
    "PA7aW3Dl5qVNS+nZNlexc6qtvkyeX95BIr3z/Oj7LVEA4IfmzshU1y9X2vfidyWGX7cmsJXf"
    "Rr0tiEx6FYRoH5Qbne80VNpkr8uKR6vsIGr+8tG3b8gAwO8oSn+rq8Me19awoN6BalBUCDLs"
    "1IyxP0ZnfMKFSarqffXVEpZSFLJDREPAYdfypB8AeJUpPYJZxG1lCbrB4ODteNzRiKnYdRCV"
    "vWkw7lxznUPQ80WsbeiIpRn2uCVoGu0BABPR2D7GGeDBodm+HzWiH4k/45i+O/1FreNLn6ay"
    "Vr/bhomYCpUUQHYKeMxvBmO09l+BqnmtHkuk7AlkUqu4OD20yYh+bmC752Jie8J0TWqKr9+n"
    "YRM4qKSIUrEIppugq5oAACZN1f76bfFG8/dz0SzT6McD6ZrRwxvWEyV18Y6hzBwea6oHZQWo"
    "agkaKcDtMiO5riCva/F/FijalbHZq8Nnl0M/7lPEfo2QxZ/9FdJSmQNyIDB7IP5Lfjv7FOhu"
    "GULaD2isqsRqKosm5/2Nus5OSYjtf2np5bTzhEcpjmg1wcg3VoslF6jG8ZMn4fP5sKdSFhKL"
    "k+BIAqdfeRp1oRAqPC7YuN3Q8vKy2QRCTIVdcjx/sM1yPbeB1WIJLxw5gs9ffwM3GS36/H4+"
    "HA6DKSl8OnQWqdQ9mB+Rb737Vl/LyspKH8+dP58t7qinuMlpzM3MQip3AgBO31uHQgjt7e1F"
    "JBJBd3c3urq6oCiKZmibEQBwOp2iCQCk6OjVrUPtR2VF+XreJbsB4IKzDAKjlsHBQUiSBAAg"
    "hIDnOZPZbI4CQDKZpP+fCQCea2xslWpqf2prb3dVV1UJKHcgk8kgFotBFEUEg0F4vV4YhrGZ"
    "SCT48fHx9EMCAEJHR0dYkqSoz+erEEVRKJVKfC6Xe5XjuKTH44kCMDPGCqlUKksIOfY3yfWw"
    "KF1CoWcAAAAASUVORK5CYII=")
index.append('chart_pie_link')
catalog['chart_pie_link'] = chart_pie_link

#----------------------------------------------------------------------
clock = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA05J"
    "REFUOI1t0k1Mm3UAx/Hv8zzt2j48o0DLigxwrDgVh4kvIBHRZCY6NSYjbslcosbDYuLReTBZ"
    "MqNxXsy4mrn5clFjxg5zpNGR6TjIlrk4SMOLwMYAkdKyp33a56XP0/b5ezCiB7/3X/I5/CQA"
    "8T6y2ccJSTAkwNVkBqUXcflPpQskJIVLQqLsy7wefYHfASRxmmA+zslgx5Ejoc6jO+3bZ7Nz"
    "GWPhnHq+KkEPgID0Qeuw/FBHojsQiknl2ZOLQuZgbIhVKfMtx8O7X3s7cu/hVmNppLC8Ohe4"
    "3HpR00I1IkEfAKci4zkW+9ZfsXd1H0CpFS1r5tRqokS/7JWR5VBHWF8YKSwuzmlX27/TOrd7"
    "NDkO7m0da0FHK1q0bN/Gby3D6p9Lv4Tlpv4moT6orSnslm59xmBFqGc3lWTbRPKC2q4GCNk1"
    "Hu5qoqFeRiChGzWuz+WoRBTq9PPcb55zt5kzM+Fa6VUJ4NjnFz8JNOx6N5nQaHAFh/Z1kjcM"
    "Ni2H9tYWAKoCvk7dwtcEmew6OUv5+NM3B47LAJnKPb2+AL/ksXdPDLsqCAaDjP34A0XDoOK6"
    "XBr7me49cYysgyM3UnRDAwABgHLZ6ql6MobrE4tFcGuCOlXlj5UVxn4aJz01ybPP76dxh0pu"
    "00E0BCmXrR4AGcCzLSy7guP5uDWo+JA1StRpGumpSV46MMQjvX24Vah4PpZdwbMttgRe2U4X"
    "S5FndsYDLGVs7muLghzm0cf7eaBnL2q0HtOF1YxFMCKRK9l4ZTv9r8CxrhQNA73scvXmBsEQ"
    "1IWDPDX4JPHGekKAFoZfb2bx8CgaBp5jXdkSuLYz6jrmodma0i23VfliRPBcb4KuRB0IWMla"
    "jF7LUDTWmd+wMPNrMwhlFED65+t9R0+99Vhyx/BCQVNb4xqxUAjFl6n5gopUxfBcqtUqqrhr"
    "p+9svnP9zLHTWwKA4TeemI9Go2p2M187MTKvzEoqshIGwK+VaVYrvPdyUshyY0Sia3bgzN87"
    "GSCVSjUXCoXvw+EwZqlgmPk7H9q56XFr44ZubdzQ7dz0+PLy/AeFQt5sjsclXdcvp1Kp5JbA"
    "NE3HcZy1iYmJTiHE01PffDTN/3R3/5dfXdP1ScDyfd8C+AvBLp7YWS6FhQAAAABJRU5ErkJg"
    "gg==")
index.append('clock')
catalog['clock'] = clock

#----------------------------------------------------------------------
clock_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2xJ"
    "REFUOI1d0+1vE3UAwPHv3bVre+vWsU7bDTa6DREHZYpsLkyi2UJE0YRFTJBEHS9MDOorfWFC"
    "gq8wJEQSXhijQY0vjGEbMQhZgMUZmZsLDsOy7AE2trCHsrVjfby7Xq93P19pjJ+/4PvmKwGI"
    "T5FzrZySBF0CTL/MfukVTP4je5mQpHBDSOQdmbcDL3MXQBJf4U5Wcdpdd+yYp/7dzfr8hfjM"
    "anq2V71UlCAKIGDiiHZU3lkXanJ5glJ++vSckDkS7GJJWv2Rk96Gt074th6tSS/0pR4szbh+"
    "qbni93tsfG4HAMOSKRgaHQ9f1yNNh1HsjKZNfb4UytImF/LIsqfOuzHbl5qbm/H/UXvRX19W"
    "oNIwMOc30GY38Gc0wmUl/BU+p8YWhr1yZVulUJ/yryg0SPe/Zr8l1AvrSuOWkcbLaq3qwqPb"
    "7N5WSUW5jEBiI21zayaB5VMo3bjEk7lesyQ3NeW1s29KAB99c+WsqyLycWPIT4UpeKOjnmQ6"
    "zbpmUFsTBqAo4If++zh+wWr8IQlN+ezL4+0nZYBVq7rFEeBkC+zaHkQvCtxuNwPXr5FJp7FM"
    "kxsDv9K0vYp03MCQN5ExPe0ALoB8XosWCzJp0yEY9GHaglJVZXlxkYHB35gYv0PnSwfZ9LhK"
    "Yt1AVLjJ57UogAxQ0DU03cIoOJg2WA7E01lK/X4mxu9w6HAXz7S0YhbBKjhoukVB1/i3oJDX"
    "JzJZ3wubq1wsrOo8sSUAspc9e9vYEd2FGihn8NZPjI7/jOkkya4ZFPWtGQAFoK71UMRxeFFV"
    "vaSSDnt3B/HICpFILarPw+DoRaZj/bQ/20Jny0GskjiJ3EhF6TalTAYwdeNqan1lanrxEWvJ"
    "Nb7tu8uDlRSSaSEZFv3D3/P0jmZs2aa5+gC2ZNEW3QeI9xWApT+vxqqbO+2dIaVjetV25608"
    "s/OPuHk7xuDYMkvJXtqiz/Nq03sA7Gt4jYS2yNDtIZfrn1nOvfPcvUAgoMbXk/apvnvKtKQi"
    "K14AZHuDydgI47Hf+eTAd5y5cRyv4kEg8gpAf3//Y4ZhjIbD4ZKVleXU9bHJs2YujqXFyi0t"
    "ZghyCc2ZDkRCEdb1ZdJanOHxITIp87wE0NPT4zcMYwyoF0Ls6e7unuR/Wk+Ez8jIHwhJlLqV"
    "EiFLyhc3z89/+DcIRptY1mKkdwAAAABJRU5ErkJggg==")
index.append('clock_add')
catalog['clock_add'] = clock_add

#----------------------------------------------------------------------
clock_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2lJ"
    "REFUOI1dk0tsFGUAgL+Z2efsdLvsFrotbWmpIFYKgUCtItHgQaRGacSAJWI9kBg8mKgHDQl6"
    "QRMbaqJRosGjUQvE0MZGaHyFiI9UU7LpQ/oSSttl2247u52ZnZ2d+T1JjN/xO32XTwIQbyGv"
    "tnBKErQLsDWZvdIBbP5D/hKVksIVIVHwZI6VP8FfAJL4BP9yBaf9dR0dwYbj682pc5mxtD5+"
    "Xr1YkqAZQEDqkHFEvr+usskXTEiF0dMTQuZQop0ZKf0FJ0Mbnz8R3nCkWp++sHJzZsz3XXWf"
    "pgVdwn4PAMuRKVoG++afMeubDqK4OcMYOTNTmadVLhaQ5WBdKDt+YWViYkz7pfYrraGsSNyy"
    "sKeyGONZtJxBsizAn8ludW7655Acb40L9T5tVmGjNPkpex2hnltUGmuuNV5Sa1UfQdNl2z1x"
    "YlEZgURWd/l9bAEnrBDJXuTe1fN2YHVkJOTmn5MAXvusr8sXq3+9sVIjZgue3dfAsq6zaFjU"
    "VicBKAn4vH8STxOkM/MsGMo7Z1/cc1IGSDtVuz0BXr7I1s0JzJLA7/czcPlbcrqOY9tcGfiB"
    "ps0V6BkLS15Dzg7uAfABFApGc6koo9seiUQY2xVEVJXbt24x8P1PpK4P8djj+1mzTmVh0ULE"
    "/BQKRjOADFA0DQzTwSp62C44HmT0PBFNI3V9iLaD7ezY3YJdAqfoYZgORdPgbkGxYKZy+fAj"
    "6yt8TKdNNtWUgxxi565WtjRvRS2PMv/1x+R6P+Tp2UlykQSj8Qf1PkABqGtpq/c8HlXVECvL"
    "Hru2JQjKCvX1tajhINnes5R++5LtTx5l09FX2FCpoqX/iB2OLmUVgOod+1cLlv5wrhhYqwZK"
    "jE8XqCjzkQgpSI7H8LsdbH/qGOHJH5Guvo/f+ptgvEqanby5xQdw7aOXBluOn/mgMbLSnZou"
    "qUt5m/SdDIon43qCtjszhJINcODVu2/43q5CEVK971/R/cIDN8rLy9XM4rJ76sINZVRSkZUQ"
    "AA8FY5hD3xDpPYFtpTGBfE7BVZhTAPr7+9dalvVrMpkMzM7eXrk8ONxlr2ZwjLmoY8xZ6wKl"
    "TFkmFVUCsuQoBvqSYGpOdt2SeE8C6Onp0SzLGgQahBA7Ozs7h/kfVw/XvmFm519WXKnGiURd"
    "D9HV1pd98x9TT4y3N1K76gAAAABJRU5ErkJggg==")
index.append('clock_delete')
catalog['clock_delete'] = clock_delete

#----------------------------------------------------------------------
clock_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA31J"
    "REFUOI1NkVtMWwUAhr9z2tLT9kCxBbnIZQXCAhvWFxzJZEbERMmi4qZB4tTF6IOJPvlmonHJ"
    "ksXEPagJc0O3N2cGyyakzi3TbWq3DHdRImVcBwzocBx62p5bb8cHksX//fvyJb8AYH+KmH6S"
    "TwSbXhssWaRT6MHif0udpUJwcN4WMAsib/pf4A6AYH+Da6OMg666/n536N3H9LnBtcm4On3K"
    "O5wToA3AhvG9Wp+4ra6i1ekOCmbs4IwtsjfYy5IQ/56PpYZ973vq+6rV+aHEwtKk82L1iCy7"
    "83hcBQCMrEjG0Oha3aNvaX0ZRz6paRNfLFWk6BAzJqLorpOU6aHEzMykfLX2BzlUnCFgGFhz"
    "Ctq0gpzUqCwu4mblYe/K/B+SGOgI2N4WedlBgzB7lM6s7R184GisiTae9dZ6nbj1PI83BSgt"
    "EbERUNQ81yf/Jetx4FOG2Zo+ZRWlJyakfOp1x5cjLLp7T9fPPPLO09UlbrxGgT3PhBBsk3VN"
    "p7wsgN/vprkhwOp4hO2pS7jlXU7TzFdZOWlMBIhnq9oLNhRSGbY3B9FzNi6Xiws/nyOpqmQt"
    "ixvnD9Hh+5vKtjdo6nqb+vb30PXaz50Apqm15TIiqlUgGPRg5W18Xi/3Fhe58MtljKUzvNJd"
    "j1yyE2U2RpGQobikEjlY53cCZHQNTZcwHAJWfvP3NTWFT5ZJLkToe64Gf6gba/UkRV6BhduT"
    "qDq2kFkPiwAZUx9PpnQEZ4H5uE5eEEGU6Ax76OsO4G/swVw5huDawCUXk9PifHf/iZs7Pjgz"
    "tSkwtEtJVUUxLa7euo/LDebdn2guXcDf9CLm8gCiK0smuYV7v97i67XdTKdKRgGcAJZujFpG"
    "+tVY3tEq1uQYPn6ZXTUzPNq5m0x8EEeRjanWs3rlTw6s7WNxXZ3ANkYBHABLY6MrVeFn89sq"
    "HF3W4u+u18JJclSSTw0h+WyMRA0LV8YZSPUjigU9vp48cO3IhyMPCwAOv7Vjyu/3e2ORE7Q+"
    "9S13Tn7E1G9R3HVhlPgyp62X2N8TskVR8Ag0xXYe2+REgEgkUp5IJH6UJImp2TUy/4wSCnfi"
    "821lfixmH73bcuP63IPPEomNdHlZmaAoysVIJNL4sCCdThuGYSxHo9HQXxPL9uEjXznaWxqw"
    "JSFaWl68f+TQwBzA+vPHT1xTlNuAVigUNID/ADmmm1a2q6g6AAAAAElFTkSuQmCC")
index.append('clock_edit')
catalog['clock_edit'] = clock_edit

#----------------------------------------------------------------------
clock_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2BJ"
    "REFUOI1N001MHHUAhvFnZj9mmZ2tCwvZXRAKLCztUsRiVJKGhKDGVD20sSZtEzUevNSb9aBp"
    "Yk/1YmziyWhqY0waLaUmlYZoBYQmtqat9IABCrRUKLBd6MJ+zMzO7M78PRitb/Jcf7dXAhAn"
    "kYvP8bEkOCjA0mT6pFew+N8Kl4hKHq4IiZIr89YT+7kDIIkv8W3VcsrXdPSo0vJug3HvTGYu"
    "nVu4oF6sSNAFIGD6kH5Y7myKprxKRCrNnloUMociB1mR0t9xItD65rGqnYfrc0tD23+tzHnH"
    "6oc1TXGo8rkAmGUZ29QZWH/daE4dwOPkdX3ms5VogV7ZLiHLSlMguzC0vbg4p11vPK+1hGxq"
    "TBPrXhZ9IYuW14mF/EzFTqtrS78F5JreGqHu1lY9tEp3v6KvLNQzm57Ek9cSl9RG1YtiODzV"
    "VkN4h4xAIptzuDG3QbnKQzB7kY7iBctfnJkJOIUjEsDxr4c/9YabP0hENcKW4I2BFrZyOTZ1"
    "k8b6GAAVAedG7uJqgnRmnQ3d88kX7+w7IQOky/FnXQFuwWZPMoJREfh8Pn75+SfyuRz62jXu"
    "j7/PnoRCLmNiytXkLWUfgBegVNK7KrZMznKJRKqwHEFQVXmwvMz4r6Mk5WGaU6/h1cfY2NyN"
    "CPsolfQuABnANnR0o4xpu1gOlF3I5AoENQ1pY4Km5EvsiO9FrIxSzSq6UcY2dB4DJWM6XzCQ"
    "vC5LaQNHkkEO0NvTTnd8m1BtGCf/I7HUEZ7RJikWitglY/oxYOoT+VyObMni+u2H+BQIKl4S"
    "6gJ1yQNQmuLGt+fQwibxyp802LexTX3iP8AyzMvbm6szs8uPeLj1kLNDd1ieuQp6llC1gWst"
    "gXBxijdp6T9Ov++KFXeXxwE8ACs3L6/Fu19wOqOegdm04yuXddq2vqG1ux+PO4WoZKlP1SJc"
    "A7+qEFQ6vB1b398/O7o+Kf97ltNvPz9/7NWn1Y9ejjjR/BjtyR7U0Cai8ggkD3/8MA+4uKV5"
    "6pI7cWz7vasnUykPwMjISJ1pmr/HYjH/6uqD7U7jfCX54oeK7PUg+RqRA7to2NuHHNiF5E/g"
    "DbbjD7UFM7PjUQlgcHBQM03zFtAihOhpy3w+KSquKlyBcN1/EgLhCMlFVoQrkCq2hRC3/gZ3"
    "wJ/qk/xWFAAAAABJRU5ErkJggg==")
index.append('clock_error')
catalog['clock_error'] = clock_error

#----------------------------------------------------------------------
clock_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2hJ"
    "REFUOI1dk8tPXHUARs+984KZC4MMdigFysO2YShqNCqRYCNGE+mmxJK0TbRxURfujC5MaurG"
    "PoyPRWNiNNW4UWOgi0olWizQBGnUKiVUwEJLy7R0GOgwd+a+79z7c9H4iOcP+JLvJEcCEG8j"
    "a49zRBL0CbAVmW6pF5v/UDxDUgpwTkhYvsxL8ef5E0ASnxDaqOFoqPHAgUjzoS3G9VPZ+Yy6"
    "MBA9XZKgA0DAzF59n9zemEwFIwnJmju6KGT2JvpIS5mvOVzW8uKr5Vv31alLg/mb6fng+boh"
    "RYl4lId8AExXxjF1eu68YDSl9hDwCro++0E6WaRTdixkOdJYllsYzC8uzisXG75Rmiscqk0T"
    "+3oOfSGHUtCprQjze+2H0ZWln8rk6s5qEW1Tbgdoka59SrcroqfWA631k61nog3RIBHD48EH"
    "qqmqlBFI5FSPX+bXcMsDxHKn2aEN2GFtdrbMK+6XAF7/bOi9YFXTG61JhSpb0N/TzIaqsq6b"
    "NNTVAlAS8OXwNXxFkMneYU0PHPv45a7DMkDG3fyYL8AvOuzcnsAoCUKhECM/fE9BVXFtm3Mj"
    "Y6S216BmTUz5Pgp2pAsgCGBZekfJkVFtn0SiHNsTxKJRbi0vMzJ6gZnpy5jbfsRc0VDMk1AV"
    "w7L0DgAZwDF0dMPFdHxsD1wfsmqRmKIwM32Z3Xv6cESJ+po2VuRDaIaOY+j8O2AZM4WigRT0"
    "WcoYeJLM+9/tJpscQG0d4oupg9Qo9bTVPkFDYgc3iv3Y1vrsPxccUx8vyMFdOSXCxalVUq1x"
    "Sr7Ds+0H8YSP53v4CFbUNB31XWiOyW/mK12PniAeBLAN86xtav1zXiAl15f4fFBglRw84XPz"
    "7gKuX6Lku7ieS8Eu8nBDN5prSD8vTdwNAKR/Pbuy+aFnvPZkoGcu44Us18IND7Ft0yNEw5VE"
    "w5XEIlUYjkFNRR1T6UnGFkbXrBLd0t+xTExMPB2Px0ez6xvekcGrgU07j2E5Do7vYJUcWmtS"
    "dLY8x6XlSS4sjOV01+3OHGc2CDA8PHx/Pp//NplMohXzqrZx46P8+P5dkiTuxSSkmUupE09K"
    "cnnoyq0rvNlxMr4lttXuPd57T6KmaaZpmrcnJyebhRBPTX/1zh/8j+a30Meujodea3q3GDai"
    "xVVtVQf4C1yXs8pux1BlAAAAAElFTkSuQmCC")
index.append('clock_go')
catalog['clock_go'] = clock_go

#----------------------------------------------------------------------
clock_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA3hJ"
    "REFUOI1Nk99PGwUAgL+7thxcD2gprF2R38uMKNNFh8vGMjODg+1lxJkACzM+LBp9dE8u0aeZ"
    "EHUPJkZdJtEHY8wYkSzBOeJmTZy6mWUT00GBjl+lBUrHld5dr+3d+WA0fn/Al+/lEwCc9xBz"
    "nbwrOPQ5YCoih4RjmPyP7XGCgovrjkDeFjld3csMgOB8judRLec9jYODUsuZej1+aX06pc5e"
    "lq+UBOgAcGDqpNYvPtkYbHdLASH/4PycI3Iy0MeykPqGc+WtQ29WNPWH1YejW4vL0+4fw1cV"
    "RbKo8NgAGEWRgqFxJPmy3tx+ApeV1bToR8vBbfaLhTyiKDWWZ2ZHt+bmppVfG75VWioL1BgG"
    "ZjyDNptByWqEKsu4G7ogrz78pVys2V/jyE8oCRetwvxFDhUd+VLa1fbYrbZxuUF2I+kWe3bV"
    "4KsScRDIqBa3pzcoVrjwZq7weO6yWZaLRsut7QEB4O0vrn7g9jWfbQsq+EyHV4608EhVSWsG"
    "DeEQACUHvp6Yx1YcUutJNjTX+5++dvCcCJAq7txnO2BvF3hqdwC95ODxeJj84RpZVaVomlyf"
    "vEn77lrUdQND9JM1pYMAboB8XusoFURU0yYQqMC0HLyyzMrSEpM3Ikzdv8eLR3vw75DZSBs4"
    "Pg/5vNYBIAIUdA1NL2IUbEwLijasq9t4FYWp+/c4fqKPvfs6MUtQLNhoepGCrvFfQSGvT2W3"
    "Kw7X17qZWcyQXZoiHv2TcI2fdcvCW1XJ2maW77+8yN4dAVZSG+Q22eru7va6ABo7jzfbNi9U"
    "lHv4K3INqbjJ4OAA4XCY6qoqfvs5QiIe49jRl2hrbaUu4EfUN/wLCwseAeDAW589h2B9VVbQ"
    "25+t3uTU6VOMjn7H1N3bhEIhOjo6SCaTpNNpVpNJPP763NnXh5SxsTFVBLj1yRt/lMz8x151"
    "plhZ6QVA9x8gp+fp7++nq6uL3t5eenp60PU8KU/jOwA+n09y/zvLhVefj925I3rm43EAYr+P"
    "gmMzPDyM1/uPVNM0XCLsKjwYgsMkEom8ADAxMVFn23ZclmVlZGTE2vP0M8XQzrBbkcvda2tr"
    "xGIxJEmiqamJYDCIZVksLi5mI5HIqhsgl8sZhmEk0ul0i6Iogz/dvPFhOByukySp5DiOmE6n"
    "zwiCkMhms+PRaNRrmqazsrKiapo28DcOip2lxaGlAgAAAABJRU5ErkJggg==")
index.append('clock_link')
catalog['clock_link'] = clock_link

#----------------------------------------------------------------------
clock_pause = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0pJ"
    "REFUOI1Nk0tsVGUUx3/fvTPMdHqhZaZ1SqWVUlLj4NikUWzExqQsfCQmEiBBErUu3LjVrkiQ"
    "DW6MrEyMBt0ZYykLhDRK4zMREhVQGttCSwf6YvqYx52ZO/d+95s7n4vBxpOc5fmdk9/JXwDo"
    "DzAqBzglNIc1SMtgSLyC5H9VvkhSmFzRAq9u8GbLy9wGEPozwoU2zoS7T5yI9LzzaHXh3Pps"
    "1p47H7tQE5AG0DB11Dlu7O9OpkKRhPBmzsxrg6OJwyyJ7NecjO59492mx4532pnx4v2l2dAP"
    "nZcsKxLQFK4D4CoD33UYfnCkuif1GmZQcpzpj5eSZQYN38MwIt3R/Nx4cX5+1rrW9Y3Vs90n"
    "7rrIhTzOXB6r5NCxfRs3Os7GVjO/RY34YFzHnrBWTPaKu58zpHTs3KbZu/tq78VYVyxEpBrw"
    "1L44rTsMNIK8HfD77AaqyaQ5f4HHK+fltsr0dDQovy4A3vvi0keh1j3v9yYtWqXm2HAPBdtm"
    "03Hp6uwAoKbhq4m71C1Ndv0BG4754advHzxpAGTVrmfqGuplnyf7ElRrmnA4zOT331GybZSU"
    "XJn8iVRfG/a6i2vspCQjBwFCAJ7npGu+gS3rJBJNyEDTHIuxvLjI5I+/MPX3Xxx68SV2PhJj"
    "Y9NFt4bxPCe9BfCrDk41imsKZND4+7pdptmyqGyssW93Jwu3bpJdWaFdFjCXc7QpFU+fPn3d"
    "APC96lSpXEWE6mSyVQJhgBFl4OlBTEOQSqXo6+ujkM2CskmlUvT39yOlHGgAXOfnkm2T9yTX"
    "bq4RjkBzNMzzQ8+hlKJWq6GUwqm6SF/i+z5SSqSUGACy6l4ubq5MzyzmWCus8eX4be6vFBFS"
    "4fv+VkspcV1va1hKiQmw9Mfl1V39h4L9SXN4JhuEPeUxt5Dj1+urRP17JBIJPM9jcXmVQEnd"
    "loiLIAjIZDINiQBn33r2TktLS2x9sxCcGr9jzogYhhnl1fbGdqUURt2nrgMhZSNnvu83ABMT"
    "E+3FYvHbZDJJpVy0K4V7n9QC/YIQOi13mHEpJZ7n4Xme1loLpRRaa3zfRwCMjY1Zruv+CfRo"
    "rQdGRkb++e+y0dHRW0qp9EOZVyORyIFcLhd6KPbGvzYkzT84ciuOAAAAAElFTkSuQmCC")
index.append('clock_pause')
catalog['clock_pause'] = clock_pause

#----------------------------------------------------------------------
clock_play = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2FJ"
    "REFUOI1dk9trW3UAgL9zkjQnp+maJtO03dqlq3Za7WBjdsUxJ/XByx5sdUIdqPgwFB9E0LfB"
    "BHG+yPogiihThGFF1j3sQtUWbw9GVoe0Rttu7Zpe1zTNcj859/PzYSji9wd8Lx+fBCDeRq72"
    "ckoSDAowwzKHpacw+Q+Vi8QlH+NCwvBkXmx8kusAkviEQGE7pwPtx48HO07sqC2ezc5lSvPn"
    "1QuOBD0AAlLHtCH5gfZ4tz8Yk4zZ0wtC5lhskFUp8xUnld0vvBbaNdRaSo8Wl1fn/N+3Xg6H"
    "gy6hgAeAbstYukb/xrO1RPcAPresaTNnVuMV+mTLQJaD7Up+frS4sDAX/rXt63BHg0VU1zEX"
    "82jzecJljeaGOn5vHlZvpX9R5GhfVKj3h9d97JZufsphW6hnc77OncnOi2qb6idYc9l7T5TI"
    "NhmBRL7kMjm3hR3yUZ+/wJ7qebOuOjOjuJXnJYA3P7v8vj+SeKszHiZiCp7r76BQKpHTdNpa"
    "mwFwBHw5dhMvLMhkN9jSfO99/PKhkzJAxm55yBPgVSwe7IpRcwSBQICJ776lXCphmybjEz/S"
    "3bWdUlZHl5som8FDAH4Aw9B6HEumZHrEYiFMV1CvqqytrDDxw8+kpqd47PEncBu22MrpiEgA"
    "w9B6/hVYNQ2tpqD7JEz3TvdsqUJ9OExqeoqjA4OM21+gLVRx7nMw1wawan4AZADLqKXKlRqS"
    "3yOdqeFKMsgK+w/08crrb9DV04NtO+xv2UcisgslfgnkxSUAH0B779GE5/GoqioUCx4H9sYI"
    "yj4SiTbUUBBZwE/pK8TCUZS6EI7jYPn/bNnR3/qNDGDW9CvF3PrM7MptNgubfD56neX1IpJp"
    "I+k2K6tFymUd07G4VVujqbGJWCSKWdWv+gGSH716rffEmQ8664vDqbSj3q6YZDaz+DwZ1xPY"
    "koN+t4HpWui2gSJbmJaJrumG/59Zhl86eKOxsVHN5gruqdEbvllJRfYpAHiuQVu9gemYbAtE"
    "SC8vMXXtD9s07CN+gLGxsbuKxeKleDxOtVIsVQtLHzquOCJJ4s5MQkoZWvWg4ZjKxkaGqckU"
    "9zbsGTr3zsikH6Bareq6rq8nk8kOIcQj0yPv/sX/iO97OH81+ZuSzxZ5euczueZQa/IcI/wN"
    "fjCnWxDPxQYAAAAASUVORK5CYII=")
index.append('clock_play')
catalog['clock_play'] = clock_play

#----------------------------------------------------------------------
clock_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAz5J"
    "REFUOI1tkd1rW2UAh5/3nNOeNj1tiP2cramts7NCBIVqa5h1im6LQ5hacAO9EEXsZRVFh/Zq"
    "ooheeVNRFGXIbmSOEqqoy6T2gxJ1ZqYf66Cl1M1+LIn56MnJed/Xi0md4PMHPPx4fgJAj2IU"
    "7uUtoTmqoewY7BcxytxA/mtahcm3WuAqg2eDh1kEEHqMqkwTJ6vCx4/bXS+0V5bHNtRvs5dq"
    "L8Z85asIUqJ9P+Xe/Z1h9R+8UwRahDt/clkbPNV4lDVx9UtO1HQ/M1zb+fTN5eVTWT+dsOzc"
    "sCMb6pB1taA1Rr6I2L6K1/hJyb5/GHCLxfT7a615+g3PxTDscE1h4VS2dOG8Y1qvO/L2bmx3"
    "h+DPFwjOJbHzOXRPBGE8HyhdjNeYob6bdKDXWTfpFpc/Yr/wrY+rvFBHQ8ObActpQJd9rAOP"
    "Yja3IbSm8ucV/DNfYThV5N1JfGuuXPZW08KUxwRA/uVj74m2nlfU3h6MaznqnnsJKSWZTIam"
    "piYAtFLk330HfUsL/i9TmMmFt0Pnp08YALVusE/WB6meX8AYPAyAaZqMj4/jeR4A5xIJ1KEj"
    "2NMziKZbEQURBTAAlK8iKlBL9fIydrhj97qVlRUmJiYYHR2lvr4eqzOMnZ5HhRrQfiWyK9CV"
    "CmgNxRJKSgBc18VxHJLJJENDQ/T19aEqPkgPrUF7PgAWgPZlSuTyg17bHkrpRUL33IVlWUSj"
    "USKRCI7jIKXETS9R3R5GbG6jpUzduCBhbGYo3tePOP0FSiosy2JgYADHcQAQCKzTn5M5+Bhi"
    "ZR0qlcS/DTxv3EwtpsXWBrp9D3+98RrF+UW01mitKS4ukXt1BNnVSdWVdURiOq18NX5d/A/F"
    "2JEXC729HxjhlkClsZnQuW+w/1gF36fc0sHWI49jFHLoxGzJnp0baV67NPYfweTk5IFgMPhD"
    "aWNT3nb2jElzCBUKXp+/cQ0vW2D1ySe0NgwQ4sFoNPrjbsR4PN6czWbPtra2slrI53qmkh+K"
    "sjeoKn5E+xIt/VSNlInMww+N7N23r35paen7eDx+RywWu2wBFAqFnZ2dnfWpqakurfUDobmf"
    "fud/+HR7+7OtmZlfgaJSqgjwN7iXi/hLLq32AAAAAElFTkSuQmCC")
index.append('clock_red')
catalog['clock_red'] = clock_red

#----------------------------------------------------------------------
clock_stop = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0VJ"
    "REFUOI1dk01rXGUARs9770xm5uamM80kTkyT2jRaa2yEio3BNgaiYNVNgxVqRUWwIO5EN1Ko"
    "LqwbaRaiiFKXKtJ0UQtBG6t2YQoipmEwiU3aqU3STCdxMl/3+973dVEw4vkBh+csHgGg3kVr"
    "DHBCKEYVeKbGkHgGj/9QP0dO6FxQAldqvJx+mj8BhPqM+EYbJ+Pbjx5N9BzbZl8/XZovVhfO"
    "GGdDAf0ACvKHrSPag9tzfbFEVrhzJxeVxuHsKEui+DXHkztfeiN1z5HOamG88tfSfOxi53nT"
    "TESk4hIAJ9DwHYuR1efsHX2H0KOaZc2eWsrVGdR8F01LbE+WF8Yri4vz5uXub8yeFp9Wx8G7"
    "XsZaKGPWLDpamvi9Y8y4VfglqbUOtirjAXNFZ6e49jlDgTJOr+u9XVO954xuI0bCjnjo3lYy"
    "WzQUgnI14tf5NYKUTnP5LPc3znhNjdnZZFR/QQC89cX5D2OZHW/35kwynuL5kR42qlXWLYfu"
    "zg4AQgVfTlxDmopiaZU1S//g01f3H9cAisHd+6QCWffZsyuLHSri8TiT339HrVol8DwuTP5E"
    "3642qiUHR9tKzUvsB4gBuK7VH/oaVU+SzabwIkWzYbB88yaTP14iP3OFJ546yNa7DNbWHVQm"
    "juta/QAagG9bWHaA40u8CAIJpWqdZtMkP3OFZw+NsnffAF4IgS+x7ADftvh3ge/a+Vo9Nbyt"
    "LUahaHNfVxq0JA8/Msju/j0Y6S00PFgqWsRTgrW6je/a+U2BY/1c02LDZTPB5enb9PWmSepx"
    "Dgw9BgIiCanXXuTJiz8wohQRIJUa9rPZgg7Qufdgw3WqB2p+U7vRFLJQcGlriZFN6ohAcmO1"
    "TuadN9GHhhBdXdDZiejowF5ZycQApj55/beBY6c+6m2ujOULofF33aN4u4QuNSKpCETIe0qB"
    "7xMuLxOFIbS340h5JwFg7JVHr6bTaaO0vhGdGL+qzwkDTU8CICMXR0qE5+G7LjIMEb6/KZiY"
    "mGivVCrf5nI5GvVKtbFx4+MwUsNCqDtnUiLvKDUc931UNouMIqTnbQoajYbjOM7K1NRUj1Lq"
    "8Zmv3v+D/+Gl03O3pqd3R0rhK4UCAik3/gG90qcauiC+1gAAAABJRU5ErkJggg==")
index.append('clock_stop')
catalog['clock_stop'] = clock_stop

#----------------------------------------------------------------------
cog = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwhJ"
    "REFUOI11U09II3cYfb+ZTMw0kSGCScaCf0BcKksiioRID+LJs+c9dVlowWMPsrISFnbx4lkk"
    "tIeweFDxLFgIpOgGJKv5A2XBi0pxoxlDNDOZ37+ZXmpY6fadvg++98H3vvcI/gcnJycvOecv"
    "PM8DY+zDwsLCb9+aI183tVrtB9u2/06n051SqfRleHh40Pd9lEql21qtlkin0xHXdb9fWlr6"
    "65GjPBZnZ2c5xlhdUZTPxWIxzjmXlFJQSqFpmkwmk3HHcT5TSuv5fD73yFMB4PT0dLW/v/9X"
    "0zQJgEin0/mZcx7VdZ1wzmFZVtjzvF9GRkYGkskkeXh4mE6lUuLw8PDPAAAwxpTr62sfAKGU"
    "Ih6PhxVFAeccADA5OUkopWFKKS4uLlAsFv1ut6s80eDo6OidYRivXdeFlBLtdhuXl5fQNA1j"
    "Y2MIBALgnMNxHFQqlfcrKyurAEBKpVKZcx4TQoRN04zato1Wq4Xj4+OPjuOs9fX1wTCMt7Oz"
    "sxnf9xEOh1EoFFqMMVsIcRPgnE9NTEwolmWh3W5D0zQ0Gg0QQtbW19f/AICtrS00Go3DRCIB"
    "y7IwNzcXjcfj0Y2NjSFFCAFKKYQQkFLC931EIhEYhtF7r5QSQgh4ngcpJRhjsG0bjuOA5PP5"
    "crPZjEWj0fDU1FS02+0iGAyiWq1+5Jyv/bv87czMTIZzDikldnZ2Wp1OxxZC3PRE3Nvbe2ea"
    "5mshBAKBABRFwdXVFaSUGBoagpQS3W4Xtm2jUCi839zcXO35YHd39w1j7M3o6ChhjCEYDCIU"
    "CvVOCYVCvXMSiQTq9fqPqVTKK5fLxQAAuK7rmaZJdF1HpVLB+fm5rSjKd/Pz88TzPGxvb/sA"
    "nEwmEx4cHMTAwACpVqveEx9ks9nc3d3dT47j3MRisWld1z8tLi4mhBDI5XJfKKXTUspPtm3H"
    "OOe/HxwcvHqShWw2+4oQ8lzX9WeapjWklOr9/T1ub29BKVXHx8cbqqo+U1X1+SP5P2n8GsvL"
    "yy+bzeYLSikIIR/29/e/Ged/ABs7pW66cvR9AAAAAElFTkSuQmCC")
index.append('cog')
catalog['cog'] = cog

#----------------------------------------------------------------------
cog_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzxJ"
    "REFUOI11U09MI2Ucfd90prW0pBQj09ldKbBZBLK2jUrqEk8Yr8Zw5mI2Jv7Bkx5wNxKyyRou"
    "HCXBjQebvUHCGg4kYtJYpDsRN/wpRiAbTUFlazsh/TPT+eb7vvm8CNlN9J1+L/m9d3gvj+B/"
    "sLW1dZMxNun7PjzPuz8+Pv71f/2Rp0mpVBq2bfvPbDbbMk3zSW9v7wtSSpimWS2VSolsNht1"
    "XffyxMTEr+ca5fzY2dm553nevqIoh4VCQWeMCUopKKXQNE2kUindcZxDSul+Lpe7d64LAMD2"
    "9vbtzs7OTw3DIACirVbrfcZYPBwOE8YYLMuK+L7/QTKZ7E6lUqTZbL6STqf5+vr6hgoAnucp"
    "p6enEgChlELX9YiiKGCMAQBGRkYIpTRCKUW5XEahUJDtdlt5JoPNzc27sVjsluu6EEKgXq/j"
    "+PgYmqahv78fqqqCMQbHcbC7u/vF9PT0bQAgpmk+Yoz1cM4jhmHEbdvG2dkZisXiQ8dxZkKh"
    "EGKx2J3R0dEbUkpEIhHk8/kzz/NszvnfKmMsMzg4qFiWhXq9Dk3TUKlUQAiZmZub+x4AFhcX"
    "UalU1hOJBCzLwtjYWFzX9fj8/PwlhXMOSik45xBCQEqJaDSKWCx2Ua8QApxz+L4PIQQ8z4Nt"
    "23AcBySXyz2q1Wo98Xg8kslk4u12G8FgEHt7ew8ZYzP/mt+JvIgbh9VttNwGWs2mdP6SzUCt"
    "+/FFiMvLy3cNw7jFOYeqqlAUBScnJxBCwCLHsAIHeHX4NVzpvob8Lw9g7m/g98e1eQUAlpaW"
    "PqeUftbV1QVVVREMBtHR0YFkMom+vj78XM4jM5SGUATSxlsQhOH1l8cAyI8UAHBd19d1nYTD"
    "YZTLZaytrdmrq6uSMQbGGGqNCjQSxdvDHwMAPnnzK1ztSYGAPBcAgJWVlY2BgYEr+Xw+c3R0"
    "VAmFQtdVVZ0cGhqKEkLw7dY38vlLQVL47QHeuPoO5r57F822hdLBgXuxhdnZ2fcIIdfD4fBL"
    "mqZVhBCBRqOBarWKzvbltrlXRBAqVksLCBIVP+78AIB8+cwan8bU1NTNWq02SSkFIeT+H4ni"
    "NRDyIQE6JdCElAs/LTyZ/gcjPKOlcoGYJAAAAABJRU5ErkJggg==")
index.append('cog_add')
catalog['cog_add'] = cog_add

#----------------------------------------------------------------------
cog_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzNJ"
    "REFUOI11U09Im3cYfn6/5Iv5lkiI0CRfC8Zc7ObaGMok1JPIBm6n4WG79LKVsQ28dOwgLZVQ"
    "aPEiu22I7BJ6U3bbpRbcIqah0mpMt1ZQqLqoqYlZ/nxfvt+/79tlBgvbc3pfeJ8HnufhJfgf"
    "rK+v3xRC3HAcB5zzh+Pj4z//1x05v5RKpfdM0yyn0+l2oVA47u/vv+C6LgqFwkmpVIql0+mg"
    "bduXJicnX55x6Nmwubm5wDl/QSndzuVyUSGEYoyBMQZN01QymYxalrXNGHuRzWYXzngeANjY"
    "2LjT29v7vWEYBECw3W5/I4QI67pOhBCo1WoBx3G+jcfjfclkkrRarWvDw8NyeXl51QsAnHN6"
    "dHTkAiCMMUSj0QClFEIIAMDQ0BBhjAUYY9jb20Mul3M7nQ59K4O1tbX7oVDotm3bUEqh0Whg"
    "f38fmqYhkUjA6/VCCAHLslAsFh9MT0/fAQBSKBSeCSEiUsqAYRhh0zRRr9eRz+efWJY109PT"
    "g1AodG9kZOS667oIBAJYWVmpc85NKeUbrxAiNTg4SGu1GhqNBjRNQ6VSASFkZnZ29jEAzM/P"
    "o1KpLMdiMdRqNYyOjoaj0Wh4bm7uIpVSgjEGKSWUUnBdF8FgEKFQqFuvUgpSSjiOA6UUOOcw"
    "TROWZYFks9ln1Wo1Eg6HA6lUKtzpdODz+bC1tfVECDHzr/i9D+jhdefpL5DHB2hrfmfbF289"
    "9V3e7Ya4tLR03zCM21JKeL1eUEpxcHAApRQuVZ4jVM5jcGwSPYn30dl6hD9XH6m/X7265QGA"
    "xcXFu5zzuwMDA4RzDp/PB7/f37ViL2aQ+vQL6Lu/gaz+AK3zGr6+i7S8u/euFwBs23YMwyC6"
    "rqNYLGJnZ8eklL4zNjZGHMcBqofwxxLAJ991c/FmDHhcMtC1kMlkFk5PT7+0LOtNJBK5puv6"
    "84mJiZiUEpXMR+rDzz73BPZ/BescwwLQanrwchdlek7gK0LIFV3XL2uaVlFKeZrNJk5OTvC6"
    "7yr7I/+7PLJ1ND0a6qcEO38R5bruj29943lMTU3drFarNxhjIIQ8vKWtX7Bqh19Th8Qd6pYd"
    "uD99/Nh58A+8Zq4hX5DTQAAAAABJRU5ErkJggg==")
index.append('cog_delete')
catalog['cog_delete'] = cog_delete

#----------------------------------------------------------------------
cog_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0BJ"
    "REFUOI11k11oW3UYxp/zlXCWZCepW87OQlPibMdql7jJCMNVpVUQRRxFvRKUyYq7dOzG6UYQ"
    "Br3wzgvB2jmKSKGhVw6C1YtFmh5tpMHTsWVjru1o06xJTrPkpOd//ufDqxaL8716X3h+78XD"
    "8zD4n1lYWPiYUvqB67qwLOuHoaGhiafpmH8fmqYdMwxjLZ1Ot1VV3YjH4wc9z4Oqqpuaph1K"
    "p9NB0zRjIyMjd3YYdmcplUrjlmUtsSxbzufzMqXUIYSAEAJBEJxkMil3Op0yIWRpcnJyfIfj"
    "AGBxcfHzUCh0SVEUBkCw3W5/QimNiKLIUEpRr9cDrute6Onp6Uomk0yr1TqZSqXs2dnZ33gA"
    "sCyLrVQqHgCGEAJZlgMsy4JSCgDo7+9nCCEBQghWVlaQz+e97e1tdo8Hc3Nz1yRJumyaJhzH"
    "QbPZxOrqKgRBQCKRAM/z4I0i9j8ugAseh1G7BZhrHzKqqv5JKY3ath1QFCViGAZ0XUehUJjv"
    "dDpX/X4/JEn68tUT9mnFq0M8MAgpcQJbD+fxV+4G5SmlL/T19bH1eh3NZhOCIKBarYJhmKtj"
    "Y2O/AICaffPl+MFTp0PSS2g8uAMfYyG0/xCkZw4LvG3bIITAtm04jgOe5xEMBiFJEgBgNXfk"
    "jUDs5BfhZ18HqUzBt4/BSukuqM3hxh+myw0PD79TLBYdXded7u5u0TRNRCIR6Lre++n7rNzd"
    "+8r18HNvM+b6t2B9HQBRbJWX3AnVe/xIp/d3Tcxms9cURbls2zZ4noezOY/e2CaiA2dhrn0D"
    "VrBhtRLYyBdx8+/I9xe/mjq3G6Tp6ekrhJDPwuEweJ6HpxdxQKwi+vxbsDa+A+fzQJ70oJov"
    "on38Ipat6Eejo6NXdh+YpunKssyIoogHv2cRYaugbgwV7Wu4MGE0Ylj+tehpobMQJAVdXV1M"
    "rVZz9+Qgk8mMNxqNc2dit9n3LkygPHUJ68sF+OMptNZ1t033vZZ9GP3RMIwopfR6Lpc7v6cL"
    "mUzmPMMwA+X7Fdu6/RMSqUEEAkexVrqHm48ONzXf4C2O445yHDewA/+njQDw7pnw9otHZP7U"
    "sQRbo+6TnzWhvGX7x2dmZp5a538AKXyNyEqJVIYAAAAASUVORK5CYII=")
index.append('cog_edit')
catalog['cog_edit'] = cog_edit

#----------------------------------------------------------------------
cog_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0FJ"
    "REFUOI11U11oW2UYfs7JOWljkqWnqz073UyXbqSsapqtFxkFh1RBvJHRXW5XFVF304FedBtu"
    "CE6KULwSwbGb4ARpWZlgmVQIZLYLLSVp0m00c2g6as1MDLE5P9/5vvN9XmjLCvpcve/L8zzw"
    "vjyvhP/B8vLy25TSc5xzuK779cjIyI3/4knPNqVS6ZhpmpupVKqVy+V+j0ajzwshkMvl/iiV"
    "SgdSqVTIcZyDo6OjD3c08k5RKBSuu667Jsvyejab1SmlHiEEhBCoquolEgndsqx1QshaOp2+"
    "vqPzAUA+n78cDoc/NAxDAhBqtVrvUUq1QCAgUUpRr9eDnPP3e3t7OxOJhLS9vX1icHCQzc/P"
    "31UAwHVdeWtrSwCQCCHQdT0oyzIopQCAgYEBiRASJISgUqkgm80K27blPTdYWFi4FolELjmO"
    "A8/z0Gw2sbGxAVVVEYvFoCgKKKWwLAurq6ufTkxMXAYAKZfLrVBKuxljQcMwNNM00Wg0sLi4"
    "eM+yrCttbW1IHPG+ePGQFa/53kAg1IVMJtNwXddkjD1VKKXJeDwu1+t1NJtNqKqKarUKSZKu"
    "TE5O/lieO7tPSGjveuE0SCWPav0EhoeHNV3XtampqR6ZMQZCCBhj8DwPQgiEQiFEIpF/l3Mv"
    "dB5+M7rPOA61VYCPbsF1XZimCcuyIKXT6ZVardataVowmUxqtm3D7/ejWCze61Ye34gFH35+"
    "5NRYGLQMy+7H4/wcvrpjN/7aNk3G2NPdI87MzFwzDOMSYwyKokCWJfAn36J/8BWEnnuApZu3"
    "cfKdi7h/+0ssPem89e7V6TO7QZqenv6IEHKxo6MDiqLA7/cjyDfRsz+EsGaBk18AweG1lhF7"
    "9QP0heujF86PfbJr4DgO13VdCgQCqFQq+OHOnPnn2k10RJPgVhGC2xg60w/u/ob29jLiQ6eR"
    "CD86uZvE2dnZu319fYcymUyyXC5X34oVpw6/9PprWg8Fd34GILByax09A10ANxE8MAR77fvQ"
    "2KmuuT3PND4+foxzvnnu6NKDl89+c9An/wrBGgDEMywZvkA/qvcLWP/u45k9Bjv46bPjNe4h"
    "7HlCAecA9xgE9wQXEJxDcIF/5mLlb0FDpBHzZN5XAAAAAElFTkSuQmCC")
index.append('cog_error')
catalog['cog_error'] = cog_error

#----------------------------------------------------------------------
cog_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzRJ"
    "REFUOI11U99LW3ccPd/beyPZjYtJbdJr24gtk5lBDDLJJpOBsP0Bwt4Kg/VlA6ms7MG1tLOF"
    "Dvfg055E+pKVMtHtH7BMzKaN1VZD3FqpyJK281ei3pl7c78/756Ulm3n6XPgnIdzPhyC/8Hi"
    "4uIlzvlFpRQYY3f7+vru/JeOvEqKxWKH4zgvM5lMLZ/PbyUSiVO+7yOfz+8Wi8XTmUwm5Hne"
    "mf7+/idHHu3oWFlZGWeMrWqatpbL5eKcc0kpBaUUhmHIVCoVd113jVK6ms1mx498JwBgeXn5"
    "WmNj41eWZREAoVqt9jnnPBIMBgnnHNVq1VRKfdHa2hpNpVLk8PCwq7OzU0xPT/+qAwBjTNvc"
    "3PQBEEop4vG4qWkaOOcAgGQySSilJqUUpVIJuVzOr9fr2msdzM3N3Q6Hw1c9z4OUErZto1wu"
    "wzAMtLW1Qdd1cM7hui4KhcK3Q0ND1wCA5PP5R5zzmBDCtCwr4jgO9vf3MT8//8B13RsNDQ0I"
    "h8O3uru73/d9H6ZpYmZmZp8x5gghdnTOebq9vV2rVquwbRuGYWB7exuEkBsjIyP3AWBsbAw/"
    "la5PO9zGJ2e+Q09PTyQej0dGR0dbNCEEKKUQQkBKCd/3EQqFEA6Hj98rpYQnGM42d+DOxmUw"
    "xuA4DlzXBclms48qlUosEomY6XQ6Uq/XEQgE8MPal1CSSqYEuFBay8m3SOrsB3j45y8oPF9A"
    "dOHDF0KIneMSp6ambluWdVUIAV3XcW/jCj5651NIX0EqCQUfW/YLRMwYHmzcx1J5ViwN0YAO"
    "AJOTk9cppV83NTXh4OAAgUAAnmCQvkKp+gxcCQjFwSXH3/QQ6XO9qHFXP/jmN08HAM/zlGVZ"
    "JBgMolAoYH193fEszxRSIP5mAkJJSF9h0y4jGjqNx8/nsPD04a5H0XocYXh4eHxvb+8z13V3"
    "YrFY15NzP/5FGQNTDHXBcKE5iffOf4yl8jxmV3N7xPVa1r8HfW1Mg4ODHUqpl9FotEYI2ert"
    "7T3lOA4mJiZ2V96+R95N9DXPPp35/Y2A6vrjJti/1vgqBgYGLlUqlYuUUhBC7j5O/jyi/BPN"
    "ZV0auAlxpPsHvlnA1tbJjV0AAAAASUVORK5CYII=")
index.append('cog_go')
catalog['cog_go'] = cog_go

#----------------------------------------------------------------------
coins = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnNJ"
    "REFUOI2NkM9vFWUUhp/5ZqZzL/YXbakgalIoiUJqJDEhGJeycOPSP4GlO2PiritX/gNdsjIN"
    "CWFpGhLjwrpQFGsqpkqJCOXC7b23987MnZnvO+e41l4S3vVznrzviZiQ8W+vr0aN+1bhNKqx"
    "itVm7Lqg6698cHB70s1/Ut59c+QPbpiVO2b5ttnRlvnODRt+d+bP/7PJRIPqdDL/HlRPIPTB"
    "93HZDCp2/qUEKqD1P0R+AFYh432oHRLsGDtRYGLI8Cd85xu0ztHyiHTxChqOsy9ooLjsLOns"
    "21j9FE1PoKZI0OMC+2F1torrXTU9jRKraG0SEUa/E3o7WJUj5Yj2uXcmTyhd9UW6/NnZ1qsf"
    "g1UgReaLvyj/WKe99D7Wekqc9cEC4idMMLXPk+WPIAxBhiA5SXsZXxwSu11sPEKKEWm0jPgJ"
    "EyQAWmAhB2vQ+jk0Y0JQpuZWsdYzJOsRT88jk56oQZFiDxncRZsOVj8inj2HNEbdu4+VBVHT"
    "x4rHnFpwDG4tWghWi9iuBVtPxBtRukjcXsGlJ7F0EbM+wRvZyQtoq0PTfU776k1cMg1UmB9m"
    "1dG9y907X37lJCiRc4RyjzD8lTD8hWT6EqExfNGlOXyGNILLlsD3YfyYqDqgNX+Bxtt5Fzyb"
    "4+7PpDMXSWYuki5coTx8QJwtICdeo/XWh2h2hvLR15hVGIEQBoz2N2kq3UyC1+26d+8Td+oS"
    "cRrjxzl5b49i0L1TfH9rXoOtTU3RWZr58Q3IcYkRiifknb/xDdvRw825Fd/E11XsmgbWJLBj"
    "qlvi2Xj306N9gIcbcyu1cF2DXgshWhOvO2LRlm/cxr9yPYpgZzeXlAAAAABJRU5ErkJggg==")
index.append('coins')
catalog['coins'] = coins

#----------------------------------------------------------------------
coins_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqNJ"
    "REFUOI2Nj81vVGUUh5/71ZmhM60WMqXQGAolKTVAFxgMMfGTRDddudIVLtipC6Mm7ogsQBP/"
    "gC5ZuGClCxdYDQSikhir0FLByofaQDvtzHTunXtn7rzve45r6Jj4Wz/nyXk8+qyzND7p9fwr"
    "ArsRCcRprsqyb+XM4AuPvu5389iyhWcS8+iCarao2v5JtTWvZv2CxlfH/nySDfsaRMrhU8eg"
    "+xBsE0wTv1BBnB74XwJxIPkqntkC7eI69yH3cVa3sX0F6hQX/4JZv4TkbSRrEe08jtjt7H98"
    "IPiFvURDh9B8DYl2ICo4K9sFen1yqBvky6KyGyEQJ7k6D5v8jm0sot02Lkso7T/SPyHzu59E"
    "1Q/3FkdnQbvg0oJJ75LdOUNp1wm0uEZQaIJanOmToKIfh9U3wMbgYnBtwlIVk9YJ/GW0k+DS"
    "hMir4kyfBGcBSVHbBu0h+Qb0OlgrDAxPosUartDgSr3M5a1XOP2F0ThtJc12/bNL5xfPhmIF"
    "l67gthaQ3jqa/0MwtB/XU/LGbTRL+W59kKXBkJdefJnxkYNcvvVV5frStU/f/mj0mO+M4kU7"
    "CUoThINThOUZUIc1SuHpgwyMjPHNWoWZqaM433F07CTOMzx/+AR/Zf6s76zg+T42W8HGN7Hx"
    "b4TlZ7E9xaSb9Oo1akmDyCsze+hdAD54dY4D1SMYxfOt4WJn81eiyjRhZZpo5DhZ/R5BYQS3"
    "Yw/FqddIkg1uPfyRc/OnADj37Snu1m7ie7jg/TdL48HA0Ot+sYwXepheg2TjD+LVle/jv283"
    "N+8s7OpCutCsF/aN7mMzW6WV1vjhxjX2ZOlV78HF4QnTC06L05NiOewsiyoy7wxzM++17gM8"
    "mBue+PzewJc30vA5IwSRh5sump/fGTZv/Qulunaad46ZygAAAABJRU5ErkJggg==")
index.append('coins_add')
catalog['coins_add'] = coins_add

#----------------------------------------------------------------------
coins_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApxJ"
    "REFUOI2Nj81vVGUUh5/71XunLVOhTWlpUaaWRCUaFiQmhIUxIUEWrAgJGwIbFy4gMTEmboCN"
    "8S9wwcJElmyIJi6kaoguYKGFUKhAoRBobDudznQ+7p25933fc1wS7Zj4Wz/nyXk8+qx7f3rW"
    "K/ybAhOIBOI0V2XRt3J56Mjqd/1u/rFs/vW2Wb2qmi2odm6pNufUrF/V1q+TT/7Nhn0NIsPh"
    "a4eg9xfYBpgGfrwDcfrm/xKIA8lX8MwWaA/XfQa5j7O6je0rUKe41h+Y9R+RvINkTaLR9xG7"
    "nf2PDwQ/niIqv43ma0g0iKjgrGwX6O3Zci/IF0VlAiEQJ7k6D9v+E1tfQHsdXNamNPNe/4TM"
    "730RjX82lew+AdoDl8YmfUr26DKlscNoskYQN0AtzvRJUNHPw/GPwLbAtcB1CEvjmHSTwF9E"
    "u21c2ibyxnGmT4KzgKSo7YAWSL4BRRdrhYGRWTSp4uI6G/e2WPnFMvdhKOLriqJfH/tJvgrF"
    "Ci5dwm3NI8U6mr8kKM/gCiWvP0SzlNrdJml9ikNnLhJXDnjdezf2Pvht7svb00szvjOKF40S"
    "lCqEQ28RDh8EdVijxDv3M7Brkpe/V5n94BTJ05t4355mcPk6lTdGvXTTng2dFTzfx2RLaG8V"
    "LdaJp45ji+uYtIZrVLENIZmowPFPX7VfmkRTotAarnVrd04lO95Bop2g+8g2lwniXbjBPSS7"
    "DxCMPCa7+wND339C3l0jA9qtAEm8bnDhZGk6GCgf85NhvNDDFHXaG49prSz93HrxsFF7ND8W"
    "hYNp9Uk19iMfE6Q0N5XltYCo7N3wnl8bqZgi+FicHhXLu86yoCJzznDl4PnmM4DnV0Yqtful"
    "b7aWa4fJGNCEIhrzbyX7S+f+BtFqdkj3XdhMAAAAAElFTkSuQmCC")
index.append('coins_delete')
catalog['coins_delete'] = coins_delete

#----------------------------------------------------------------------
color_swatch = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAH5J"
    "REFUOI1jZGRiZqAEMFGkm4GBgQXG+Jub8R/GZp48g/HfigI4nyliAuP7yylwvqDuHEaquYBi"
    "AxgpDUR4GJx/uR7uR0PxQEb/U1lw/kazaYzx617A+QuDJIZlGIRXrIX7cWVHMOONmbfgfI10"
    "NcZ/pesQ6aI7aDiFwcB7AQDLxiQ7BvBImgAAAABJRU5ErkJggg==")
index.append('color_swatch')
catalog['color_swatch'] = color_swatch

#----------------------------------------------------------------------
color_wheel = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwpJ"
    "REFUOI1Vk0toXGUAhb//3v/+87pzZzKZZJJJ0poKTduQOOBzEVoFG9SKbXZCcK0LV+4qFhFc"
    "uBFERHci6EZdFCmYhdZiEWlBWg0VsTbvadJJJnPndWfuPP57XbRieuCDszjn7I7goELMzLK5"
    "cCSMLk4a8enDhpnPCXTO7G3ljM6NyUTvy6NjnR8OVsR/JrI8d0QExQ+fjOTPnUoVmE0eIq8c"
    "UoYg2q9i+RtY7e96llv7XG213k6/QOX/gb9efyQZ3L14xj5WeG5ohmRM47NCGo9RYBybHMcR"
    "XoNu8TJybWlJ/d5cFOdxJbfeVVGj/dFLiZnC6dwUf6ibRHGZJEYUhzgBMdrI/jVEM4aIzBOa"
    "4Yvt7qUL0HlLkhh+uWAkzj6bneam2sIhzyCD2AQ4xHAIsPEQzQjslTDrK+jESXT5yhvuQucr"
    "GVETi4+pLDKWwaRLhoAsPdL0SCBJAZFOA1wD3A5s3MXMH8Uano9Vrn3zqlRWfnYsPsItBHHG"
    "iAEOIVk0A4AdaqiVodyGexW4p2DvNqaZp1+2npAYh0bTVorNQGADJiEKgS0gBVied79cisKO"
    "gqIJXRfyY/T2xIRkP6IDpQja0AsfALRDaIXgdJIYtQFo1O/TrkHg0/MV/X5ay/62LFZleCLe"
    "FHgtqAMVDWYHlAE2Jk5tEKoeeE3wmzAqae2W6PXTa7K9o66vh+GJuYzgyiooDaEPWoMdhTQQ"
    "b8SRuwOw34BaneDpYWrX/0b3k1clK+EX3/7ZfW32pJSpumR3E7o+WBZUFDghJFuCTD0Nbh1m"
    "pnBXi7i/bpcDkl8bXFBXvdv+Z9//5HEspckasL8O1SJUNsHdgP1t8EtROD5CPRZh6+cizW70"
    "/ae4vCoBaOh3frzkjff/6Sw8/3iKwukI9VUIy9AzIBgHP69prLXZXFqneqP+cRr16UNnYqhk"
    "UymdTwjx5itzjjP9aJKJtMVAoJGlJsGdCuFvezsqqH4wz/IngveChwceyGJ5Nkf13BD9ZwYF"
    "h4dCrUfRd0YIf5kifvEsp9YO5v8FbSlEs7CsPfcAAAAASUVORK5CYII=")
index.append('color_wheel')
catalog['color_wheel'] = color_wheel

#----------------------------------------------------------------------
comment = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYRJ"
    "REFUOI3VkTFIW1EUhr/zXoi2pA42FYoUpBUHh6JLN4cOUsVJMLzQ0bFbxwoiLnmTk1OhzmIV"
    "QajmSQQREalLHRShRi2C1EFSwRQT8+49DpI0YtRupd90ued+/zncA/8aKR8SY0GjW9RxRAaA"
    "6G2CqmYs8m56qCd7reD5wdzUyncthUbv4svXA0366d3EyOcoQAQgMbIcEy32DXS1claAYqgY"
    "BWvBKBgLxioC9L1qYX3nuHX/WDqAjQgAD8LG+KN61xGhUFKsVokK1iqhvQoEaHgYRdEnlQmq"
    "KYu2qvOfKW7+yVXAeSR3YgvGqroRBy5CMKoVqRwgKAD5Qgmx5AAcgOnR13kV5mdWs8Rj0PJY"
    "eBF3aGtyiNUJxsDTBuFls8v8xg92j35lw7qzzdprRDwEF6C78xmDb9oBOM0XmV3bI/PtcMuo"
    "9N9YYy2SqSD7M/dbJ4Jt9fz0uZdKD98rVWQ/GPu4sKVeKp1P+ovvb3sntS7f+pnnlnBJIDX5"
    "offTX3f9P7kEidbZD7dlIP4AAAAASUVORK5CYII=")
index.append('comment')
catalog['comment'] = comment

#----------------------------------------------------------------------
comments = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI2tks1LVGEYxX/vnbmT1oyJ+bEKKj9qkYvwY9OqhYFSS9H6A4qCaNkIkW1qIOgfEMVw"
    "IzitInI0zIUStsiQUjFNSVESnEpKZ+7ce5+nxcxEyUyrzuZdvOc8H+c85sqDxBkxeg1jaikE"
    "JY3KuATsl/Fo2/rB76BY3Lje0Xi2qa6qgBYc1wtPvd+6Gp9eOQ7cP8ixUD3ZVFeFD3gKng+O"
    "D44HjqfYdpDWhhoM5lShAYO/u+XEoKiCL4Jqtse/EDQGgwHNiX2FjxvJsmcza7U7u/sRk1sF"
    "kK7Y6GUAg9lTGLKEoaAqjuvq4UipTXLfRUV4/mat/lLriaPN9dV5cb5KKOdL+fSHrZ741Mpp"
    "yzIknowvMP95h2Nhm8qyQ2x/2zvSXF+Nr+BLdrWMKBlfcTwhZAdpaahBVRut4Z72/refvvQ+"
    "evou+f1nmsm5TVxP0Lwvongi+L7i+oLrKxlP/kgBGI52TKOamltNMji24AJpY0AUVBVRkPwr"
    "iogSsAwGY1sAnY9HSjFUDIzNZ6yAdUthL5MRwiWBv4oELUOJbVERDuH6AuBkM0qHwyiz4lk3"
    "h+9cXDbK4NDEIksbX7O+REJURkK4rsePfYeRqWWiA69TivaZYvl2xUY7wfT33b5QNrO4zeDY"
    "vIJZxWhKMa/EBO7Fo227/zyS7lhiaXx2XbsfJtLdsRfnCnGKTtDZOxm2SpxN0JD6nB+52z5b"
    "iFf0TkOlqXKUCRWrpZj4v+AXd34hIsodX9cAAAAASUVORK5CYII=")
index.append('comments')
catalog['comments'] = comments

#----------------------------------------------------------------------
comments_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAopJ"
    "REFUOI19kk1sTHEUxX//N+8NrWnVR6sbgpoi1AIzC5GINFJtEBaNEJtuKiRY2LQ2tWk0xEp0"
    "IYTYNJQIFe20EZGOppWIMh1fUQ2ipjKTVhmdmffe/1roiDQdZ3MX9557zz33qgPNXWu0knqU"
    "KmM2CClEd2uP1dPesOPTzLSpDY4crqlYv2lV8SxcSNuOrzcyerA9/H4pcHpmjYHIik2rinEB"
    "R8BxIe1C2oG0I1iWSbB8CQq1cjaB5t9p02QQRMDVGpE/M/4HUykUCmSa7Aq8+5wovNc/Uhb/"
    "/qtATa8C6P1nOncDKFRS4LqhuW6KkLZtyS/Is0j8shGtuT8w4t8VXD5/s78kS8528U77UhQe"
    "Gm1s732/2jAUXde6XxH9GGeRz2Jx4RzGxpPzNvtLcAVc/We1jBYyrpB2NF7LJFC+BBGpMNoa"
    "qy8/G441nb31PDHxM8WjF1+wHY1kfdGCozWuK9iuxnaFjKP/uQLQ1lATRmTqxYcEV0OvbCCl"
    "FGgBEUEL6GzUgtaCx1AolGUC1J6/mUeGhVdC0Yzh8RzX2u3NZLTPl28xntSICE8iHQy8fsBk"
    "chzbsQmuqQb8aQ/Aum11CwzUUu0azTdOVQ1XVB5aFP+R2lqYb7Gs2MfjwdtEYiG2bAxQGdjJ"
    "lCdG+O0dxr4ODqlc991/prMW1OVLJ7YXnriwl301VeAx2LP2GOcf1uPBoO3O3VTOL7nRWN2u"
    "IDbwZoz4ZAxL+diz9hgAJysvUVayAYWam7NBbdMjn0DplVA0lZj4lomO9tHSUwdAS3cdw99e"
    "IkhuBd68qSKEh6KNgCv6XP/LPryYdERa8SqT8OBjQF3M6cFMBI+WtqDUUQUFAj8QaX3aGmv4"
    "DQwRPvavUuXtAAAAAElFTkSuQmCC")
index.append('comments_add')
catalog['comments_add'] = comments_add

#----------------------------------------------------------------------
comments_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoZJ"
    "REFUOI19kk1IVGEUhp/vzr3K2DhZpkZgv2pCuspcFZERkdRSLAkqgqKI2lob25QQtO0/ijZR"
    "RosocqywGAkl7IcyqDTJ0gqcJjVn5s7ce04LNULUd/Mtzvecn/ccs+tUa7kYPYAxq5hJSgqV"
    "Ngk4j1oatwxMD9ticehgbWXF2pKCGVhwM14o+naooaWjtxg4Of2PheqKtSUF+ICn4Png+uB6"
    "4HqK49hUlxVhMCtnatD+V20SBkUVfBFUJ2rMJdsYDAZ0EvYVPn6Nhe919q8aHknkmslRAKlv"
    "frgDwGDGFW5Ywg1bFTeT0ZzcoEMskUFFuN/VX7q9evn8qtLCKXgqS9akL3kd74aOt0R7V1uW"
    "ofV623t6vgyTH3JYFM7mZ3x8XlVpIb6CLxOjpUVJ+4rrCVmOzbqyIlS10rp5fNuV7r4fTWfu"
    "vIr9/pOi/c0gGU/QKV9E8UTwfSXjCxlfSXvy3xaAm421Hagm33yOcS3yPgOkjAFRUFVEQaZe"
    "UUSUgGUwGMcGqDt7O0iahVcjPWkrEDgq4kfTaQmFchzi44KqEm+9xO/IRZJfP2EXLSFcsx+o"
    "dgMAazbuW2BhisW3Tt06sbWvcvPu/OGx1PpwjsPSghAjbZdJvrhNRW0DpQ3HKMzL5mfXA+xv"
    "b6Nmtv3WNz+sA3Pl0rFN4c695WzYc4Rg31MY7ID5eQzby+iORPvnPJKdza0f2l4O6OMaR6X7"
    "rv6veNNifVRjiz0bXNfUHlLcxVcjPak9thlJvH5QNO/eYdzkDxLA2GgAP8DQrHeaFUzmoTxR"
    "sdblLsi/0PP8mfc9FWQ04BD/Zej9ZnxVPTerB9MVrS9uTMSGDlpilomlg4Ke3/ZYTv8FQ+hU"
    "kT8ZXDEAAAAASUVORK5CYII=")
index.append('comments_delete')
catalog['comments_delete'] = comments_delete

#----------------------------------------------------------------------
comment_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiBJ"
    "REFUOI3FkVFIU1Ech79z75ozppCZZSkMZ5FBaiQSgYHEqBCCQFF6MwjCCAJfzBcJovkiEYJE"
    "Qb0FpmBl0sgHK9PKh2iQBDk1yMRyqXNqd+7e++9BZhNzr31P53D4fud/fgf+NyqxqGkLZOkx"
    "aUepasC5lSAi/Taqoav5dGjDQa0/8KTz1ReJm5ak4tn7SanzPx+raXnkBHAA1LQMuJXEqqor"
    "CokaEDMFS8C2wRKwbLBsQQFV5R7efp4pnJhRpcCIA4B0Mys7w6VrSmHEBVuSRAHbFkx7LRAg"
    "c7sTQXatT5BMQrSTbv47xeZO1gJ+O+bCtmHZIrpDg1UTLJF1KRGgEACWjDjKZg5AA+i6Xrkk"
    "ir7uwRDZbvDsVHizNQ7kaLjTFJYFuZmK4n06fSNfGfs+HzLToh83PMF2Ut8zNN7eMzRRi0IH"
    "8B3J58KpQ+TvUDwd7mYg2MuKEQEzkru48KsRuKFIQd3NQOjWpQrvvb77iOsDR4vKyMvaz8Do"
    "Y959GmQyFG7TtpT9gbbK0jzv1Tuvl8emes3SgyVYmkVJrg9LxTl2+Dggl/8ZcN7fXwBy7mXw"
    "28XO5jPu+aVZxzbl5mzRFQAaT97Fm1OMQrk2fSPAw2u+CaAgsQ9Hfhij08Ou4PQbmnwPaH1R"
    "j0tPQxBDT9VBgr1l7vTo6uwJz24P4ZUpIss/GQoOsrgQu52yxGTKG/a0olSDggyBKCIdIx0z"
    "TX8A+HETi/lME5gAAAAASUVORK5CYII=")
index.append('comment_add')
catalog['comment_add'] = comment_add

#----------------------------------------------------------------------
comment_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhBJ"
    "REFUOI3FkUtIlFEYhp/z/3NrnKTUrhY6KRYFYpsWgcUQXcxVMKIFEQRRCFHLciNtmjYi5KZt"
    "S8fuJA1OlDVFJAQVSJHjaDeaQGcwnZsz//layJiRirve1QeH5znvOR/876ji0NIVKjNz0oNS"
    "fsCxFCAiYY1q7+s4Ev3roDUQut/77JPkC5Ysl4evx6Qt8GikpTPoALABtHQ+9SjJNfsba5nO"
    "Qq4gWAJagyVgabC0oIDmPdW8+hCvjcVVAzBkA2BVoaxitcs0lCKbF7QsAAW0Fgp6TghQ6nYg"
    "yLr5BgtTBPWCm/+0+PdP5gQZW2JCZy0tYtoMmC2AJTIPFQUKAWAmm0dpEgAGQN8V34wo+m9F"
    "olR4oLpcUVNhULfewONUWBZsKlXUV5r0D40z8j0ZLTin3y6+RlQrChPg4O6tnD68E4BwTzvW"
    "izvYJyaZcjvkm9v5+EIweUixTNquhqLd5xprBq6fpX5mlB0+P07vLjLvBxiOhAnFx58YS8KB"
    "UJevYUvNxRvPUyVv7sl2nx/X6CDq5nHcsbt4q8qpS+d8iwpOBMLbQI4Nvvt6prejybMmlVWu"
    "jV44/wCuJeByDFvqI+U5rZZ9QjHBJoc+6j+pSr70k8vESQPTv0yGPhtirkSwb++GA7b4jyrT"
    "bpI3U0xNCqNxg2Gn4+WKGgB0n9o8WPlzonHtrDaSTiUxtz1y6XZ6/2+atg8OVMA7VgAAAABJ"
    "RU5ErkJggg==")
index.append('comment_delete')
catalog['comment_delete'] = comment_delete

#----------------------------------------------------------------------
comment_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm1J"
    "REFUOI2Vk09Ik3EYxz+/d+90utm00lLxz5xQGBUWEmnejJJUsjTFDkGHbh7qEgVdt0OEhw5R"
    "GXWqJLEE1yZaJCWBJA3LMp1Siq5/Ts1N371u+3UIRSHSnvPzeb7P832eR/AfMfq48OTSwo5W"
    "g2U3oZ89oE2eMWwUHvfkNZjMVS0ptkoy9pVjStyGf2i0WN0I/KXDVmvOOn3XsqmIwOhH4oRO"
    "0qbtWLZkW8X6yvaj5sx6V7K9XAn7H7I4Lfj+aQF9MTythYPFyr9gX1tOuSXzlDs5v0LRpm4j"
    "jDMYLUmYQr5vsdC3sgONT4bV2muezYawvI4QNUDcMpwr+zBnhbDmV6FN3kAxRtB/2fjx4vX8"
    "kr5QUXihxwugKjp3q0vsVSdK7KiGPw19HXIxOxEkbVcF+tdmDHESbS6HqZ43ci6UsP/gxecj"
    "y0KqkByrKc1nXoNwRPK5rwWL/o6IyMD/7jopaXFogSxm+4doT2gUA0E1BVwrYypbrSaDIgTa"
    "EkRj8KW/mYJD54ifeMVwey/ezgAfur1kVF5FSUpHIlNX+7RiYlRCJAbDYz/QBzuw7S3FbN6B"
    "f2CMxLImTKn2vxqt/pzTojEpDaoCegQGR77TdOsGRTttGLP3kHv8Hqo1E4CgtoSIEVhTQApc"
    "rS99VTWl+ShCcP+ZH4CJGUkgJEm3CtKSBK6+z4xMzvii8fPe1QXEyhoRdQgMAIcLszh7pACA"
    "2WCYtt5Rut6Ov49KUf3o8lHfv24HgHqHx+cPhOQdz6Csc7oX6xzuK+tCK7DTc+3m0/eyzuEO"
    "1js7z6+Xv+YXGpxdeTEi3QIcDy6VN29E8DcpmPqTFKKsowAAAABJRU5ErkJggg==")
index.append('comment_edit')
catalog['comment_edit'] = comment_edit

#----------------------------------------------------------------------
compress = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAplJ"
    "REFUOI1lkk1olFcUhp9775dvdH5MJpjWiNEW1ERRERf2J9DuunQjKaIW6kqCC+OikNaFZOFC"
    "XBg3iiAiWlpIl1101+qui9JW1PhT0DhpWlAjTWYyM998557bxfyY0QOHAwfue57znmtoxczM"
    "jFta+mc9mE3ZbP4H7/37IQS894CiqqRpmjrXc3VhYXFyampqGSACuHV9+IBWzk3Y/BejjVCI"
    "c7k869b1EkJAVTtV1fc8enR/PIrkPNAUuHVt+LAJ3CyO9Nn//jXIivDq1SKLiy9RFVQD1loK"
    "hQKFQh+iBhHv2uSRhePv7h2ycW/M1vy3iASCKi7KovWYF/cqD+erO86VlndeHtleWBMUIKEj"
    "gOGToe37UH3GwEAW8K0UrN1E5cHtkZfVDT/bXMZ78WANq8M2i+fvhSdgDoIZA/M5pdJjCAJA"
    "rQZJbQUNSpo0SJLVBAAomdgxXzoLQQikZDIRIK8nuR6CKtqe2S3gGRhYD/Q18UPaetwWqJFU"
    "V/CqiNS7CDorzJf+AnMEzFGwX/J07n5HQESMcz2mSdDtQYtAiDOOubmvQVMCDdasWiFJXJTJ"
    "lLPGAOkKqwCaAkm5wuCG/R3321kv1xB1hCD9xhhUFe9D9xkD4dTdn3670G4EDKmPEbWIWu4s"
    "7PnVOXOjWOxv/8buFT499ngamG43JifHi4ODW25Xq5XdqkrDJh+m6ZI651oE2mVityPA2NiY"
    "y46e+UZt7rhrPP+u8OzK9yJ+YxxHP6ZpgjGW8nvj51m78RAw7d4UmJ2dDcUPvrrx8XB+6M+S"
    "7Oqv/FI1Jow0Go3NIlIXSZfnM5+N7t9WfOf3p/UdbxEAbD3xcMIYJiKSSx9VL16OorIFydbr"
    "kfVe9I/e04dTmzsZCBf+ByZ5VTV+OVeDAAAAAElFTkSuQmCC")
index.append('compress')
catalog['compress'] = compress

#----------------------------------------------------------------------
computer = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkdJ"
    "REFUOI2FkztolEEUhb+Zf5NAko2bmKjxibVRFJ/YSBRFEbSxtBNsxcrWUizCbm3QzgfRQi0k"
    "jaS0SGK3uIJoowGFZLOLa/6ZO3Mt5t8FxeDAnRkY5pxz7z3X8J+1tLT0SESue+9LIoL3Hu89"
    "zjm890/NZh8XFxe3ALOVSuXawMAgufcQIwqgyuhohfn5N5Q2Yb0YY5wdHx/fNTQ0xOcvXxER"
    "YlSiRohKiJE8zynV6/U8hNAfQkBEEBE6nQ4iwtra2t+SWV1dI8bI+QuXcM5RCiH07969l2Zz"
    "HQBFUQVVRdOFCIyNbuH1q5ccmDpCiBFVTQq89zSb69yZXQYMxoBJG6aIdqvF/ZvHcc7xfvkd"
    "IQQmL19NCkQERTHGMDq2FWstxlpsEcZa2q0WGhPj1KFjaFS0qIH13hMVjLFkWfZH2OIEiBpx"
    "zvGj/JmHzSoRkgJftMdYQ1Yq9diNtVhjMNam2mhifNh4wM+2oFETgHMO1ZSCzTL2bxsE07WH"
    "4du6FAoS4+2td4ljCdB7nwBskWe71eLTx38bK7MZzrnCC6lTPQV9fSXu3ThMiBHvhU4nRzXS"
    "39+HNYoC1qS3oJocqZoUbGxszCwsvD3TNUqe52MjIyP7RYSVlZU8y7IBm2WowtTBQ+zbsxOA"
    "HdsnEBH+mIVqtXrLOXfl5KnTZ8vlCi+eP/klIo+ttSe89we7w9R1bAjhQw+gVqtNGGO+T0+f"
    "Y7hcRiRQyizV6szPWq02vNnQ9YZpcnJytdFoLM3NPTva9X/BVN/sM8BvM0uOIHds4G0AAAAA"
    "SUVORK5CYII=")
index.append('computer')
catalog['computer'] = computer

#----------------------------------------------------------------------
computer_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsBJ"
    "REFUOI2Fk81rlFcUxn/3vu8kxTTJZBpTpaEYqv2gtrU0ldKCRWT8oNBuugpurODCTRcu6p8Q"
    "WpBkkSzaVOmqZVqhVaEofkHSojWJiGYgUjGCJq1R54tM5r1fp4t3RmhFeuG5527OeZ5z7nMU"
    "/3NmZmaOOef2Wmtj5xzWWqy1GGOw1v6gnpY4PT3dDUxks9lP29vXkFgLISAAIvT0ZDl9+lfi"
    "p7DuDiFM9Pb2vtDR0cHthXs45whBCBIgCD4EkiQhLhaLife+zXuPcw7nHPV6HeccpVLpv5J5"
    "9KhECIH8zj0YY4i99239/S9SLlcAEAQREBEkfRCAXE83J0/8wuub38aHgIikCqy1lMsVvpiY"
    "BRRKgUovVBO1apUvD7yLMYars5fw3rP+o09SBc45BEEpRU/uObTWKK3RTSitqVWrSEgZN785"
    "iARBmjPQ1lqCgFKaKIr+Bd2MAEECxhiWO29ztDxCgFSBbX6P0ooojh+zK63RSqG0TmcjKePR"
    "+W9YqTkkSFrAGINI2oKOIgb61oBq2UOxWHEAzC5MstxdZOPDXlYbq5y/cRxrbVpAN/usVavc"
    "uvmkL7q651hYvUd++wf05zZxYe5nLt0o0EhyaYFMJmZ4/xZ8CFjrqNcTRAJtbRm0EsYvfMeW"
    "V3fjteet9XnOFn/kvTfep/DnKeJGo3Hk4sXzH7aMkiRJrqura8A5x9LSUhJFUfuD1b/JqGfZ"
    "89p+AA7t+JqT18cJnCAeGho61JI6MjLyuTHm45c2vjzQ2Znl+E/fB+fct6WVh5/NLf6uri1O"
    "cTh/jOEz+3gmakehJWolj46OrtVan8vndw2s7esjk4kZHBzMTE1NvnLHX/+qZpa3bXh+Aw/q"
    "d6ms3Oe3a5NUyo0jj7exUChE8/Pzl62177T831zfK2NjY1u3Hlw3jFIHFXQK1BAZ/2P8r8P/"
    "AHwmniS499yQAAAAAElFTkSuQmCC")
index.append('computer_add')
catalog['computer_add'] = computer_add

#----------------------------------------------------------------------
computer_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArpJ"
    "REFUOI2Fk09oXFUUxn/3vjeTkJBkJk2DQ2vrLKSLFlE6YqhKoRC1CiqouJEuKthloZsu7UJE"
    "RSRZddHQ7tRQXaiIVGwJNoKLpBGLA1FjVNqMf2rmn5nMu/e+c1y8SaBK8cJ3z92c833n3O8Y"
    "/ucsLi5eCCG85L2PQwh47/He45zDe/++uVPiwsLCCDBTKBSe7+sbIPEeRFAAVYrFApcufUZ8"
    "B9YnRGRmbGxs1+DgIKs/3ySEgIgiKiBKKkKSJMTVajVJ0zSfpikhBEIIdDodQgjU6/V/S2Z9"
    "vY6IMPnYUZxzxGma5nfv3kOj0QRAUVRBVdHsgQCjxRE++fgj9h94gFQEVc0UeO9pNJqcnrkG"
    "GIwBk12YHtqtFm+98iDOOZaufU2appSeeiZTEEJAUYwxFEd3YK3FWIvtwVhLu9VCJWM8cF8F"
    "FUV7M7Dee0TBGEsURbfB9iKAqOCc48+hVc43phDIFPje9xhriOJ4m91YizUGY202G80Yzy+f"
    "Y6MdUNGsgHMO1awFG0WUxwfAbNnDsNYMAHS/mqWydI6JK38QCjvY8DN4b7ICttdnu9Vi5fv/"
    "+mKiPUf+x+84fPwUfeX9bH77OdX5y+yqF7MCuVzMGy/fTyqC94FOJ0FVyOdzWKM03z7Nvc+e"
    "pH9lDr58jYGRAvfs2cuNlW+Iu93uO3NzVw5vGSVJktHh4eFyCIFarZZEUdQ3catG/11lePLU"
    "tqr4TImh5G9u24WpqamTzrmnH5o4dGRoqMCHH7y3GUJ49+HrZ48dee6F3OCvn5Js/kYHaLci"
    "llb7Q7SVPD09vdNae3ly8vHyzvFxcrmYSqWSm5+/uu+g/+HN9d/XHrH5yPpog+Zfyk9rNjXe"
    "v7q9TKVSaX15eXnx4sXZg1v+7+1G9dHZ2pmrL97dvf7L2gkrZq9Ye1OQs0e/kNf/AZXnl40I"
    "lh8oAAAAAElFTkSuQmCC")
index.append('computer_delete')
catalog['computer_delete'] = computer_delete

#----------------------------------------------------------------------
computer_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr1J"
    "REFUOI2Fk8trVEkYxX917+1u0umxH+l0Xk5iS1DxQYygCDKMAzNDXIwKPkBwNyK40Y3gxj9A"
    "XUgHEV1ExF22PkAi+IaZQdISNSZRzGuRh+h09+1g5vatulUubiJElCn4qr7NOd/5qHME/3OK"
    "xeJ1pdRRKaWjlEJKiZQS3/eRUvaL7wEHBweTQF8qlToYi8WpSQlaYwCMIZ1OMTBwF+c7U3u0"
    "1n3ZbLatvr6eyakZlFJobdBGgzYEWlOr1XBGRkZqQRBEgyBAKYVSisXFRZRSlMvlryVTKpXR"
    "WvPb73vwfR8nCILo6tXtVCouAAaDMWCMwYQNGsikk9y+dZNNm7sJtMYYEyqQUlKpuJzpew4I"
    "hAARXoilWqhWuXB8O2nrDa2z97ATW/j092Oyei2OUgqDQQhBOtOAZVkIy8JaKmFZLFSrOAv3"
    "2dkOddmjJPPdVCbX4w7cCBVoA0JY2La9gmD53ZYbJhOPkGjeRWl8lKjw+WFVM8mG1pAArRGW"
    "wHaclWAhWFM3xJGdglT+V2pz/UTjgumhMaSyuTORwPF9H2PCFSzbJp+Lgwjt0cggPZ2jJDv3"
    "4s1cxYoqIokOHG8Cb8NJysP3QgJrac+FapXxt6EXOqNDHD4Ayc79eDNXsCIKv5rn/ZMiEw2H"
    "ySXawm/0fZ9IxOHcn1sJtEZKRXX6IU11mtymP/Dn+7CjBs/tYO7xM941H0PaqzDGIKXE8Tzv"
    "4qNHD35eNop+/0/H7h1tWWnamHt1iXQuilf6kdmnzxmO72Pd2o0ANDc1opRiRRYKhcKp1trt"
    "wqET13jTf5rZqb+ItXfxad6Vz/7rinysxZBSfnFsEARjX7LQ29vbKIQovJ34gP/6Dvmun3A/"
    "/Mt4cdRkMvXbz56/8uJbubGWm5aWlpLrusWXY7NcvHqZpw8HmBYJXsR+edVz/vU3wQCfAdr9"
    "cQFCw/cnAAAAAElFTkSuQmCC")
index.append('computer_edit')
catalog['computer_edit'] = computer_edit

#----------------------------------------------------------------------
computer_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArlJ"
    "REFUOI2Fk01onFUUhp97v0nidPIzE9PSkMESSQ2hpRjSgkKpTVu1IlQwoiBuRBR3LkTEZXfi"
    "oiS4qRh0JdhQF02hbbqQgqW1NRN1YWpSJFWw0BY7k0mYznd/znHxTSMVSg+8l7u573nuve8x"
    "PKIqlcrXIYS3vPe5EALee7z3OOfw3n9rHnZwfn6+B5guFouvdXRsIvUeRFAAVUqlInNzZ8k9"
    "pOthEZnu6+sbKBQKrNz4mxACIoqogChRhDRNyS0uLqYxxvYYIyEEQgg0Gg1CCFSr1f8jc/du"
    "FRHh+RdewjlHLsbYXi4/Qa22CoCiqIKqotkGAXpLPZyePcWOnaNEEVQ1I/DeU6ut8vH0AmAw"
    "Bky2YFpaq9f57L09OOf4eeFHYoz0v/xKRhBCQFGMMZR6H8dai7EW25KxlqHOZdpufwlxMzt3"
    "7UFF0dYbWO89omCMJUmSB2SThHxb5PCT1yj172Zb91/c6Vrhq9okAhmBb32PsYYkl9vobqzF"
    "GsOurstsH9lHd/8oA/kTzFz/lT9Xm6hoZuCcQzW7gk0SBrdsApPFo5M7jOhFuvreJNZnKY++"
    "zfuVM9zadgRVwXufGVhrWavXWavX+WM5y4JBeX3oMuWDr0JzgavfnOKZdz+hff13OhhGdeA/"
    "gra2HJ++8zRRBO8DjUZK7t4yW203XaUGsb4CKsT1nxjc/yGN88fR8GxG0Gw2j1248P1z94OS"
    "pmlvT3fn4HY9R3HfG0jjCir3GJsYRtxNHissUx45xPo/PxBC4IFZmJyc/MA5d2TvsD0wULJs"
    "fSpPXL+KqqPy3TXGJkYwSQ/kX+TiF0c5e3NoZcNgampqszHm9vj4QZqXPmLHxOck9gYaqpCN"
    "UKssSX6YW7/9wtLs0ZMbBjMzM8nS0tIV7/3YeGEOG/39wIgRn6rqRoBUFERAtPIviQCWs4SM"
    "WiUAAAAASUVORK5CYII=")
index.append('computer_error')
catalog['computer_error'] = computer_error

#----------------------------------------------------------------------
computer_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArJJ"
    "REFUOI2Fk89r3FUUxT/vzbTF/JgmcaoNxkAVFzVVEmppUaq0pcUiqAuX0oKKS136B7SLIqXM"
    "LJWgXSpdqYgUqWZRRSFJQWxsErSa2kjEZiYzzeT7ffe++1x8Jy0Vig/Oe29zzzn3vXsc/7Nm"
    "ZmY+VtXXRaSsqogIIkIIARH5xN2vcHp6ejswOTAw8Nq2bT3kImBGAkiJwcEBLl78ivJ9VF80"
    "s8lqtfpIb28v13+/iapilrBkYIloRp7nlOfm5vIY49YYI6qKqtLpdFBVGo3Gfy2zutrAzDh6"
    "7DghBMoxxq0jI6M0m2sAJBIpQUqJVFwwYGhwO198/hljeyaIZqSUCgciQrO5xnuTs4DDOXDF"
    "huui3Wrx/tv7CCFwZfYHYowMv/RK4UBVSSSccwwOPYj3Huc9vgvnPe1Wi2SF4p6nnyFZInXf"
    "wIsIlsA5T6lUuge+ewJ8cOUNfq6cZ6V3kY+aNQwKB9L9HucdpXL5jrrzHu8cznsAMhVGqrv5"
    "8qezLGmFZKkgCCGQUtGCL5XY9VAPOMdvnbcQE4Ip1TFlR+UJdu/cTztbp/Hnj2S6jogUBL7b"
    "Z7vV4teFYhZGJwJHx04SkxEtYiSW127w1Mhz3A4bvPP18+yVEwXBli1lzrw5TjRDROl0cs4v"
    "BmIy/ri1iJiiJkgUWnmb8UcPcls6XNr4kHKWZeempr55YXNQ8jwfqlQqu7KYoVF5uDKKWiQm"
    "46+1JYb6djJ74zuuLv/C+Mqr3JOFWq32bgjh5f0Hnj1cu3qCLOQEC2QaeLw6xoHHjjG99D2X"
    "r11m4p/jPJD3X7tDUK/Xdzjn/j506Ah9/f2oRsolT612br1er/c9ecqt7xs93DO1cOmmOI4s"
    "n2YeuBum4eHh1fn5+ZkLFz7duzn/3WzMAWzkiW8Xpsjh4Mpprm/W/QsX2Kz40E/V3AAAAABJ"
    "RU5ErkJggg==")
index.append('computer_go')
catalog['computer_go'] = computer_go

#----------------------------------------------------------------------
computer_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqpJ"
    "REFUOI2Fk01olFcUhp97v28SkzTz50RqHMR0k0UUlEaUgghCiqnSUuhK2lXBhZtuBLddli5K"
    "shIhKNJNmVW1JVZBEUuhhSRaSYIRYlViKjI4kxnzOd8998fFjAH/8MJ7792cc95zzvsq3nNm"
    "Z2fPWWu/FpHYWouIICIYYxCRX9S7AmdmZnLAVD6f/6q7u5dUBLwnAIRAoZDn8uVLxO+oeth7"
    "P1Uqlbb19fXx3/1HWGvxPuCDBx9w3pOmKfHi4mLqnOtyzmGtxVpLkiRYa6nVaq9T5unTGt57"
    "xj4dxxhD7JzrKpe3U6+vARAIhAAhBEL7gweKhRy/XbzAyM49OO8JIbQZiAj1+hqnpuYAhVKg"
    "2heqg2ajwY/H92KM4ebc3zjn2HrkizYDay2BgFKKQnEzWmuU1ugOlNY0Gw2C8+xwfzE0pKm6"
    "YUJnBlpE8AGU0kRR9Ap05wXg4UVGR4t8NHaCD7P/4p7MtRlIZz1KK6I43qiutEYrhdKa/dlb"
    "lHr/Jzc8xvqDS+Syw4R7v5J/niE2xhBCuwUdRQxt6QX1Uh6K1TXLSHGV3K6juGSBTaUyLbfC"
    "4IERxtZutBPoTp/NRoPlu2/qYkcpi9Tuo6MqSq/Tla1CK2H9caudIJOJ+eHb3TjvEbEkSUoI"
    "nh5ZodCcJtPj8XYB7eug+wliuFO5x+8rZeJWq/XT9evXDr4USpqmxWw2O7RZFukJ82Hwsy9V"
    "MFdQrsn8dEImXSdSinjfSR4/vMorXpiYmPjOGPP5vv2fHCrXz7Jt9CCmepo4zjF/NWF6YYCa"
    "HsA5y3MLzrk7G16YnJwcUEpNjI8f4YP+fnTShYoeEXUPsPBH9dntuScnvj//58+vz2eDQaVS"
    "iZaWlv4RkY9FhOFNd9k5mPCslpjV5ZVvjp1ZrrzNeC8AHel+NUN15I4AAAAASUVORK5CYII=")
index.append('computer_key')
catalog['computer_key'] = computer_key

#----------------------------------------------------------------------
computer_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs9J"
    "REFUOI2Fk89rXFUcxT/3zss8cJCZaZJJh4xGkcaFjUSpSxEKFcWFNBUaY4VCoZtm778gLppm"
    "GQwVCYi4EXUh3UyaRaHqzPiDJMWg1AlNnpnBzM83zLv3vntdvCFQoXjh3Hs333PO93z5Cv7n"
    "VKvVz4wxV7TWnjEGrTVaa5RSaK2/FE8qrFQqWWA9l8u95/tPEWkN1uIAnCOfz3Hnzvd4T1B9"
    "y1q7PjExMZ3JZHj41wHGGKx1WGfBOmJriaIIb3d3N4rjOB3HMcYYjDEMBgOMMbRarf9a5vi4"
    "hbWWC2++jVIKL47jdKn0LO12BwCHwzlwzuGSDxY4lc/y3bff8NLZV4itxTmXONBa0253+Gi9"
    "BgiEAJFciBF63S6fXH8NpRQ/1+4TxzHFd95NHBhjcDiEEORPjSOlREiJHEFISa/bxdlE8ezL"
    "53DW4UYZSK011oEQklQq9Rjk6AWwzqKUovn0Q263b2EhcaBH4xFSkPK8E3UhJVIIhJRJNi5R"
    "vP37p4Q9g7MuIVBK4VzSgkyleCafonu4gx8dcLowzp/7R/hunH44YDgcciW+RqPf5NdfqkmI"
    "SinkqM9uu8Uf//zGhXPTXL76IWEY8sKjR7jyPX64f4+lpSV83ycIAqrVKo1GIyEYG/P4+No8"
    "lUqFBw9SvH7+PDdXbrG7s0OxeJq5uTmCIGBlZYUgCDhz5kUuXbpIvV7HGw6HN+/eLb+hlGJz"
    "c7M0OztbAMTzz81Q+elHFhcXyefz9Pt9ms0ma2trXF78AKMHZLNZHtuFhYWFrwqFwsXrN254"
    "X3y+Qa1WwfM8MpkMAGEYYoyhUCiwvLzMxsZGfEKwuro62W63G/V6nfn5eaZLJQRwdHTE3t4e"
    "vu8zMzPD1NQUxpjj/f19ubW19ffJMhWLxeNOp1PL5XKvlstlJicnSafTAK7ZbF4VQhz0er2v"
    "t7e3x6Io8g8PD5thGL7/L4Bnnqv7sJSzAAAAAElFTkSuQmCC")
index.append('computer_link')
catalog['computer_link'] = computer_link

#----------------------------------------------------------------------
connect = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAohJ"
    "REFUOI2Vkj1PFFEUht/ZOzPOwBpB3fClNgYKCws/ChoKoiZYWJjYWJkQC0IstDKhMEZbjQkJ"
    "If4AYrCw0AYN2VCIBCQqUVlUCCzs7Dczs7sz9965d3Zs1LhxMXrq931ynpOj4D/n3pO1AcbE"
    "bC2QglJ+WflbOJmM1C/S6g5o1MNFkPACcUFBNGpqEbiQWFkvU3Wv8vR82kxVsrNS1vtFJBHW"
    "JVp1BXGDgAUCeZtjt+arewKKNrlhaPX+w20EPIjARATKBbK7HnQCrO/YYC4731Th8av1vhLL"
    "rh5tPRajPETJ9UG5gM8F9hsE6byLtfXSxOvJK6MNG0zPp03HVacY/XhRHpqNbRQH0I7jMPUY"
    "8jYHZQGIoiFnVSCrbAYAfgHuJCO15FgfTK3eq6knUNnMhOLIHFlYFmHC6CBxQ0Vhl0MngFfx"
    "EHheEQBiPwHtVaubC9EbN2PQ1DpajH5SWTklQiHGUulvYdpy0NaiwmMcvu2D11imAeBLvycI"
    "BCgX2C7WoOsKzHifZqBw/+y5RZIvpmBZDjZTOfhO5WtC2FaDgu/xRAyAzxT4NEDZkTjQQtDR"
    "flrNvc/hzNAqXk5y6bvKiwrF1U8Ld2UDwPWC4a42DT4NUKMclAkUHQFDI0A0iOVnSRlCnvyc"
    "vL36++FVABgZX7plarikqzHkbA+tBoFGIuzTFASBwFa6jILVNfbu+UhDGQDU64+Wbhq68qBV"
    "j4GyABqJsJVxUSpVQasMrEpBK+yNadPxZj+j1hh72HkwjigKsZ2vYttyYBdqE1LKmZCxIpcs"
    "k/Bta+6H8x8At0qRzoYgiJDZcWCX3cHFqWvJZuGmAFalnRu7bk76ggqfDr19Ojz3r2UA+A5Y"
    "z3SvHbteLQAAAABJRU5ErkJggg==")
index.append('connect')
catalog['connect'] = connect

#----------------------------------------------------------------------
contrast = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiRJ"
    "REFUOI2lkz9rIlEUxc9EmRkcK0XBYougpFgLi0DadEvAymIkpfsVhO38BgsLgbBdmg0IjtMF"
    "Qdhm20hIGwmSIJtCjP8Y583EmXnvbuM8kshWufDgceH83r2H84APlvK+YVlWRgjRJKIqEe0T"
    "UQLAiIh6qqqe1ev15/8C2u12LZVKXR4eHhq5XA6qqgIANpsNptMpbm5u2Hq9bjQaDXtnFMuy"
    "jq+vr4kxRmEYkud5tFwuabFYkOM49PLyQq7r0vn5OZ2enp7Eur2tOK3r+mW5XEYikcB6vYbn"
    "eQjDEEEQwHVdzOdzDAYDjMdjCCF+mqaZlgDOebNSqXzSNA2MMQghwDkH51zeu90uWq0WDMNA"
    "JpPZF0J8ew04yefz2Gw24JwjiiIJiKIItm2j0+kgiiLc398jnU6DiE4kgIiONE2D7/tSGJ9u"
    "tyvFQgjc3d1B0zQQ0REAJLcAbCeRYwshYNs2LMsCEcl+fI81e1szB77vQ1XVnZfjNWIvisUi"
    "PM8DEQ1ee9CfTCbQdV2KLct6s0rsS6lUguM4EEL0JYAx9uP29vZvEAQYjUZy5/d+VKtVOI6D"
    "2Wz2qOv69zdJvLi4OF6tVn+enp6QSqUwHA7x8PCAZDKJQqGAg4MDMMawWCzged6Xq6ur3ztR"
    "rtVqNQC/stls2jAM6Ukcptls5hLR116vJ6O885lM08wEQdBUFKXKOf9MRL6iKI8AemEYnvX7"
    "/ef3mg/VP2mgoIEzH0stAAAAAElFTkSuQmCC")
index.append('contrast')
catalog['contrast'] = contrast

#----------------------------------------------------------------------
contrast_decrease = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmZJ"
    "REFUOI2lk0FrE1EUhc+YMjNmBiqhjbVQsNi6aBepVIsiWOqq0JWLlK4kf8GC4KL/QBSE4q6r"
    "QqGTrApClxXcJJZQREhJQ2owQoy0SZNMZt6b9951kwyNRVx44cHlwPk49/Iu8J+l/Sk4jhNT"
    "Sq0T0QoRTRJRBECJiD7ouv5udXX1118BOzs7z6LR6Pb8/Lw1OjoKXdcBAIwx1Ot1HB4euu12"
    "O5VKpTJXojiOs5jNZsl1XQqCgLrdLjUaDTo/P6dWq0W+71On06HNzU1aW1tb7vuu9cy2aZrb"
    "s7OziEQiaLfb6Ha7CIIAnHN0Oh2cnZ0hl8uhUqlAKfU+mUzaIUBKuZ5IJCYMw4DrulBKQUoJ"
    "KWXYp9NpbGxswLIsxGKxSaXUy8uA5Xg8DsYYpJQQQoQAIQQymQx2d3chhECxWIRt2yCi5RBA"
    "RAuGYcDzvNDYf+l0OjQrpVAoFGAYBohoAQCGegD0koSxlVLIZDJwHAdEFOr9vu8Z6i0z53ne"
    "I13XwRgbMPdhj18nEHABzgNU/SKoQLnLO9iv1WowTTOM7TjOwCjMD7B4ewlLd57C6zIopfZD"
    "gOu6b/P5/HfOOUqlUjjzAMBjYILBEz5MzQS7f3Ew8BO3trYWm83mQbVaRTQaxfHxMcrlMqae"
    "T8CID+Hm8Bimxu+CS47TH9/w+SjnM198jPQBe3t7FcuyvjSbzRWllD4yMoLp6WnYFzdwYTWg"
    "GzqG7WFwwXByWsLPWr3sXRdPrhxTMpmMcc7XNU1bkVLOEJGnadqp97A1PnYrHuc8QOmkdJR/"
    "8/XelXv4Vz14NZedezHz6bL2G2oMrJn2uL60AAAAAElFTkSuQmCC")
index.append('contrast_decrease')
catalog['contrast_decrease'] = contrast_decrease

#----------------------------------------------------------------------
contrast_high = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiJJ"
    "REFUOI2lk79rIlEQx797a/yBP4oggRQWKRUrixiw2O4IpAoc6Y8U6YX7F2wODgS5Zv0BZ2Nx"
    "bSBwzQmSIiCYIIGAEMmliSL+euru+t7MNbfLJWJzNzDwePD5zAzMAP8Z2tsP0zR3dV3PE9EJ"
    "gANm1omox8yXOzs7xfPz8+FWW6VSOW00GuLp6Ykdx2E3bNvmfr/P9XpdlEqlD9tgo9Vq8Wq1"
    "YiJiy7J4MpnweDzm+XzOjuPwcrnkQqHAhmEcu9w7ACiVSpFIJFLPZDLQdR3T6RRCCDiOA9u2"
    "MZvNMBgM0Gw20ev1AOCrYRgRTxAIBPLZbDYRDAYhhIBSaiOr1SouLi4QjUYRj8cPpJSfPAEz"
    "H+/v78OyLEgpN7JWq8E0TazXa3S7XcRiMQA49gREdOj3+7FYLKCUgpTSq1ypVDyYiHB7e4tg"
    "MAgiOgQA358OAMCDiQhEhGq1inK5DGb2hO7bZdwRbizLQiAQ8CRu5bcdJZNJCCHAzDeeQCl1"
    "9fz8jFAoBCmlV9mF3VRKIZVKYTKZgIiuPIGmaV+ur69/2baN+/t7mKb5CnJFZ2dnGI/HeHl5"
    "eVwsFp9frXKxWDRGo9HPfr+PcDiMu7s7PDw8wOfzIZFIIJ1OQwiB4XCI+Xz+vt1u/9i4hVwu"
    "d0pE3/b29iLRaBR+vx9Kqb+XSTDzx3a7/X3rMR0dHe0CyDPzCRGlmHnFzI+apl1KKYudTmf7"
    "Mf1L/AZVcKkKKqdBPgAAAABJRU5ErkJggg==")
index.append('contrast_high')
catalog['contrast_high'] = contrast_high

#----------------------------------------------------------------------
contrast_increase = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnhJ"
    "REFUOI2lk0FoE1EQhv814W3IBoS0iaVQNab1kCAVgoWK2kM9FHrKIaV4kFzFkwVvBT2LCEL1"
    "1ouFQjd7KILQY/WijSUIFltDaA1WTCttQpPdzb7d98ZLsrQWvTgwMAz8H/8MM8B/hvJnQ9f1"
    "qJRyhogmiShBRAEAFSJ6wxh7PjU19euvgMXFxWw4HF7IZDJaLBYDYwwA4DgO9vf3sb6+bjab"
    "zXw+nzdOWdF1fWxtbY1M0yTXdcmyLKrX63R4eEhHR0fUbrep1WrR3NwcTU9PT3R1ZzriSCgU"
    "Wkin0wgEAmg2m7AsC67rgnOOVquFg4MDFItFVKtVSClf5nK5iA8QQswMDw8PqKoK0zQhpYQQ"
    "AkIIvy4UCpidnYWmaYhGowkp5cPjgIl4PA7HcSCEgOd5PsDzPBiGgaWlJXieh3K5jEgkAiKa"
    "8AFENKKqKmzb9oXdLBQKvlhKic3NTaiqCiIaAYBgB4COE9+2lBKGYUDXdRCR3+/WXU2ws8yi"
    "bdujjDE4jnNC3IUREdL3LiGgBGFtWCCi4vEdrNRqNYRCId+2rusnRknfTyIxlED/hT78HKxC"
    "SrniA0zTfFYqlb5zzlGpVPyZhRCQkLjyYAgXE+eR7E0iEU+ity8K62b9TupRivmXOD8/P9Zo"
    "NFZ3d3cRDoextbWF7e1tDN4dgBoP4tzZPgz2XwYXHDs/vuHjp2LbaXtvT5xyNpvNAnjV09MT"
    "0TQNjDEIIcA5RzX1FeOZcXDBsfr+HWp7e6OlJ58/nHqmXC4X5ZzPKIoyKYRIEZGtKMqOfatx"
    "dfz6bbjCxfLrZZSebiinnulfcePxNXIcF27bBecuvrwoKwDwGyCQoUlLbcDQAAAAAElFTkSu"
    "QmCC")
index.append('contrast_increase')
catalog['contrast_increase'] = contrast_increase

#----------------------------------------------------------------------
contrast_low = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhFJ"
    "REFUOI2lUzuLGlEU/ib3OqM4biEqCFrYxspm2+3CwlaLYJ38BSG1iIJFILBNfkC2kxSyIFlI"
    "sWmzheMPWFgGG1+IrI6PuXPPSZMZdCXVHrhwOJfvwbnfBd5YxutBt9tNW5ZVZ+YrACVmFsz8"
    "xMx9rfVNrVab/Zeg1+tdx2Kx22KxmLRtG1JKAEAQBFitVnBd11NKfaxWqz9CjAibu7u7i3Q6"
    "/bNUKpmJRAJEBN/3EQQBACAejyOTyZiu69Yqlcqfh4eHJwB498+2LYS4zefzMAwD+/0eSilo"
    "rREEAfb7PTabDVzXxWKxABF9azQadkRgmma9UCgUpZTwfR/MDCICM0e94zjo9/uwLAvJZLJk"
    "GMbniICZL1OpFIIgABFBaw0iis5wOMRgMIDWGtPpFJZlAcDlIcG5lBJKqSPVUHkwGESOxuMx"
    "pJRg5nMAkIevEIJCklA5vDskZ2ZEDojoUSkFKeWJMjNDax0BM5lMuKfHiADA/cvLS2gNjuPA"
    "cZwjR2GfzWax2+3AzPeHDr6ORqOR1hqz2QyO45wskohQLpex2+3ged6zEOLLURK73e7Fdrv9"
    "vVwuYZomJpMJ5vM5hBA4OztDLpeD7/vwPA9KqQ+tVuvXSZSbzea11vq7bdu2aZoQQoCZozCt"
    "1+u1YRif2u12FOWTz9RoNNJEVAdwxczvAWwBPDNzn4huOp3O7DXmTfUXSLSFFf70IKkAAAAA"
    "SUVORK5CYII=")
index.append('contrast_low')
catalog['contrast_low'] = contrast_low

#----------------------------------------------------------------------
controller = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmxJ"
    "REFUOI2d0k9Ik3EYB/Dv+/6s5mixLhEhM6g8ufIfA+mmXbqOCR2M8FAKHUICV4GsurgkPfkH"
    "XgShXfToCCG2RS9EzSHEQGj4dwvzMInl3Pvufd/f89uvQyWEl+Vz/34enj+Ym5ubnJmZuYMT"
    "liqE0IjowcTEhP9EwODgYM6yrGXLsuYjkciF/wUUAIhEIqcBLNu2rQLoi0ajP9Lp9JjjOGEi"
    "AhE5nPPPtm2PBoPBj8cAANB1/eHS0tJoU1PTYUdHR1FV1faurq5GALAzK/h5cICVqmUT0Yv+"
    "/v6xf4BsNvtOCNHLOSciOtPS0gKXywXDkTBWv0B59ggAcDY6jnjhmySi2NDQ0D0AYNls9rXX"
    "673b3Nyszn/VGoKBEBhjMByJp0kP3huXcfX6JVxsuwZXTy/aOjsV0zRv+P1+VyKRSCmpVMoI"
    "BAJuIQQmP706mm24ewQmV8CFgvNugDEGAKjVaqjVapienq45jtOnVqvVRgDHwgDgPiUBu4R8"
    "Pg9N06SmaZKIwBhDKBRSHccZVznnUkqJ4e6Ro+DfTplMBmtra9je3ka1WrU45y+npqYkYww+"
    "nw+c8ysq59ysVCpQlN8HeXzzCYQQ2NzchG3bMAwD6+vrkFLq4XD4OedcTyaT4JyDc44GIkrv"
    "7Ozcam1thZQSnHMsLi5+LxQK58rlsgfAocfj+eD1eu8DgKqqt3Vdf5tIJNqJ6A1isdiTeDwu"
    "C4WCLJVKslwuy9nZ2cN6P1ElooW9vb3K/v4+DMMAYwy2bbvrBgYGBvJCiIXd3V0Ui0VsbW3B"
    "NE2qF2j4s/HIxsZGTy6X8wkhQESr9QK/AEBYYP4wdN8eAAAAAElFTkSuQmCC")
index.append('controller')
catalog['controller'] = controller

#----------------------------------------------------------------------
controller_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtdJ"
    "REFUOI2d0ktoXFUcx/HvfWQ6GZIYK4hKMII2tIsxaRqCr00bLQhdhRRcRGQQmtAuRAqaqmVw"
    "1XEwdZVBLoEK3TSLgGnJQI1jGAjpNAzUaQ0NhiGxTdN24mDCvO6955x7XGhLpCv73/8+f/4P"
    "Jicnz6dSqQ94yjKVUo6U8sT4+Hj0qYCRkZEV13XTruteiMfjz/9fwACIx+MhIO15ngkcTyQS"
    "5Vwud873/c+llEgpfSHENc/zzg4ODi48AQBks9lTMzMzZzs6Oiq9vb0l0zQP9vX1NQN4S9fZ"
    "3tnhesP1pJRfDw8Pn/sPUCgUriqlBoQQUkq5p6uri3A4TM3X1PI3ML74BICWRJLLf9zRUsqL"
    "o6OjHwFYhULh2/b29g87OzvNC7cde7B/CMuyqPmaMz+38kvtFV57/SVe6NlH+MgAPYcOGfV6"
    "vTsajYbn5uYyRiaTqfX390eUUpxf/ObxbJ+++Rl1YSCUwbMRsCwLgCAICIKAiYmJwPf942aj"
    "0WgGnggDRJo0eH+xvr6O4zjacRwtpcSyLIaGhkzf95O2EEJrrY1Hoe+uJR93yufzCCEQQlAO"
    "7shK+KEe+yEbEtLncPcxhBCv2kKIerVabYlEImitOf32GEIIisUinufRaDS4cXeB5s5q09ED"
    "79Cxdx/zyz8y+9v3eN5zmFLK3NraGobxz0WFEExNTd2bnp6upNNp5ufnK/fE7aBnfzfKVHS/"
    "+B7KELwRfYv76ndpK6Uy5XL53e3tbdra2giFQpim+UwymWx9tJNjXx7UTUYL7x/4GIDTAw5X"
    "bqXAuGybUspLm5ub1a2tLWq1GpZl4XleZPe3/bnz0F3eXCQxFwMg8VOMYukmGu2asVhsXSl1"
    "aWNjg1KpRLFYpF6vy91AEOjx3M1FQthcuZUiZNgs/JoFjAn7343HV1dXj6ysrLyslEJKmd8N"
    "LKXuf8VJbU+tzZ40mG3VUEHr1FLqwdjfxiuHAhtK9t0AAAAASUVORK5CYII=")
index.append('controller_add')
catalog['controller_add'] = controller_add

#----------------------------------------------------------------------
controller_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtdJ"
    "REFUOI2d0ktIlFEUB/D/d++XjV8+C6wma4rKgrSHiRDRxtrU0oxaGOGilCKigp7EGETZkLXS"
    "YDBatEmCwCihbCJ7agzVFJVhgzOhYwimjc73uud+t02J0arO/v87nD8HbW1tl1tbW3fhP4dJ"
    "KcNEtK+5ubnsv4D6+vo+27Y7bdu+HgwGi/4V0AAgGAxmAeh0HIcB2NHU1DTa09NzwXXd40QE"
    "InKFEC8dxzlTXV397C8AALq7uw90dHScKS4unigvLx9hjK2rqKjIBgDnVS/Gf/xAr2U7RHS2"
    "trb2wh9ALBa7L6XcLIQgIppZUlICn8+HjKuQib6BduoQACCnKYQ7ya+KiG40NDTsAQAei8Uu"
    "FRQU7A4EAuz6p7BeXVkDzjkyrsLJh7l4lFmMZav9mLd2OXxVm7F2/XrNNM01ZWVlvq6urogW"
    "iUQylZWVhpQSl19cnLrt8IZjMIUGITUUGgDnHADgeR48z0NLS4vnuu4OZllWNoC/wgBgzFCA"
    "M4ZEIoFwOKzC4bAiInDOUVNTw1zXDelCCKWU0n6HrrwMTW2KRqMQQkAIgaKvz2l+4qn5+u6x"
    "fH3uAvi37YUQYqkuhDAnJydzDMOAUgpHN56AEALxeByO48CyLFDvbaxiKb5y7/H8mUtWwXr3"
    "AB+f38KCsdnQiahnYGBgS2lpKZRSEEKgvb19KJlM5qXT6VwAE1sTnXzFwUbDF38MPDkHI78A"
    "ixcGMPy5N61LKSOjo6NbxsfHkZeXh6ysLDDG8kOhUO7vTrZX6Z5v3hJg25GpnvTG+cgmN1cn"
    "opupVOq03+/P4ZyjsLAQjuMY07/NY2rIfHuveNad/XCsbzABTKQ5JEeK1dXVJaSUNwcHBzEy"
    "MoJ4PA7TNGk6YMwpuvbhRTcN29lI8xkY+67hy6AmlVKt+q/Gg/39/VV9fX2LpJQgouh0YFP7"
    "cOPTnQvt98lUPfO0gMfYkAfv6taH3vmfCO5+sxMs1fQAAAAASUVORK5CYII=")
index.append('controller_delete')
catalog['controller_delete'] = controller_delete

#----------------------------------------------------------------------
controller_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAulJ"
    "REFUOI2d0U9om3Ucx/H38zxZTJPGZVKtmzWdm62j0Lm0tdD5B0EvRbxkKXio6MkWdpAyqE6Y"
    "0dPisGVQ2kIpbCiCvQjZYDq7DKrSpZvbyA5O22lRXJB10WTmyfPn9+fxMKjITu4Ln8P38HnB"
    "ly/z8/OTMzMzr3GfYyql5qSUb01MTHTfFzAyMvKj67pnXNc9kc1mH/m/gAGQzWbDwBnP80xg"
    "KJfLVYrF4lHf99+RUiKl9IUQFzzPO5JOp7+7BwBYWlo6mM/nj7S1tf3d09NzyzTNVF9fXxOA"
    "d3GFaq3GiuN6UsoPh4eHj/4HKJVKZ5VSLwkhpJTygc7OTiKRCLYfYH9/FeO9twFozh3j1K+/"
    "BVLKT0dHR98AsEql0seJROL19vZ288T1uVC6P4NlWdh+wOFzcc7bO9m7X9M8GKZp76uknhkw"
    "Go3G093d3ZHFxcWCUSgU7P7+/qhSisnljzZvGxsYpyEMhPDglxzxR/fjOXdo3jmE1prp6Wnt"
    "+/6Q6ThOE3BPGSC6JUCXTxNr6eXB7Slur32F8+calmWRyWRM3/ePmUKIIAgCxgbGN4sAWmuu"
    "rpzF+f0c8ZYE6s4p2va9ybXFSUwDkskkQojdphCiUa/XMYy7Dzn07LsopbhxY42ovUJrVwbc"
    "K1z85DOaEw4t1h8sfzmHEAIhBKaUsri+vr4JCCFYWFi4Wfz6pNOaiBLf1kB76xBoVP0ST7x4"
    "iNDN0/YH7x/+y/f946ZSqlCpVKhWqwCEw2Esk60v7Fj7IZHch25cI9AOvQeeQvtlIpFVdqXS"
    "sfT2C8dnZ2fHTCnl5+Vyub6xsYFt21iWxTb5U+yhjld6o/HbBLIChsXlL1YBjXZXebizHeX7"
    "B7/JdnVZ+Xy+Ojg4uAvoCYVC1Go1Qj+fpOPlccMMWRhbHseM7OGx1POYkT0Y4d2EYh2E40/G"
    "bl0/32oATE1N7XBd91ulVFIpxXOhPKbyRKADAq3vJgj4dw9Aa9DB5X8A6Bx78dG7/4IAAAAA"
    "SUVORK5CYII=")
index.append('controller_error')
catalog['controller_error'] = controller_error

#----------------------------------------------------------------------
control_eject = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkJJ"
    "REFUOI2lk7FLW0Ecxz9NQp45nxXlgQ4iCE4Bp+hc3V07dzM4GLCF/gkKxaXaxbGLq4uDg4OT"
    "oLg9MGQTNA6KYEIuXt67+/06VEKtdOoPbvlxv899jvse/Ge9+7vRbDYXgVVgWVUXVBURSUXk"
    "1Ht/VKvVLv8JaLVadRFpJElSNcYQRREAzjl6vR7tdvtKRHaXlpb236i0Wq16s9nsOOdUVdU5"
    "p91uVzudjj4/P6uqqrVWz8/PO2dnZ/VXBi/aP+fm5qpRFPH09ISqkueeKCrjvUdVSZKEfr/P"
    "xcXFFfBpZWXlsvACWk2S5NVwr2fZ29tla2uLQqGAiHB/f48xhtnZ2Wqv11sFKACIyLIxBucc"
    "IoJzjh8/9hgMMorFEtvb25RKJVQVay0TExM455b/BCxEUcRgMADg+/ddVAEU7/MhpFgsYq0l"
    "jmPyPF8AKAHo7928PBlfvnx+01NVsiyjWCySZRnee4YAEUn7/f6HcrlMlmXs7Oy8AgCMjIyw"
    "vr6OMYbHx0eyLEuHVwghnHa7XSqVCqqKMYY4jjHGMDY2xujoKKVSCRGhUqnQbrcJIZwODbz3"
    "R9fX1x/jOK5OTU2xtrY2PP3PNTMzw+3tLWmaXqnq0asknpyc1EMI32q12vvJyUmstVhrh0bG"
    "GO7u7jg+Pu4OBoOvjUZj/02UDw8P63meN+bn56vT09OMj48TQuDh4YGbmxvSNL3y3u9ubm4O"
    "o/zmMx0cHCxaa1e998sishBCIISQishpuVw+2tjYuPx75r/qFxVtcA2Z25GNAAAAAElFTkSu"
    "QmCC")
index.append('control_eject')
catalog['control_eject'] = control_eject

#----------------------------------------------------------------------
control_eject_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvtJ"
    "REFUOI2lk89rHGUYxz/zzszO7O5sdrObSbqJNI1N12WDEpVY8VKULfgPCEXwUDz4oxWh0INH"
    "ES/iQZqCB4Ve41lEhVjoQUptardW1jXQlNDMpsm6mJ39NTs7874ebKuoN5/Tw8P3+3lOH41/"
    "THVVzSrBnCZwgeyDc0dJWprEW39Ha/49rz1cTlxUjmlQXnE7x1eK3cpsaricMuOykgp/JBrN"
    "fqL2436ufqM9eW0c0bhyVus9Apy4qBxb8PTpJ5vVytTw1LTrltKpJLZlADAMxnR7fbbveZuN"
    "dmrtizuPrweSm1fOaj0DwDQon15qVpfc0bnFI/OObRkMw5juIEIBlqkzOz3JRCZdkrd/OffK"
    "wiZr26UhsKFXV9XsyqFO9aV5//VjC4eLtmXwmx8yGiuCscTQBYMwpjuMKWQs8vl8wt+7U/RH"
    "pue8+LEnlGBuZaZTmXbd0sOyVNDpR5y/9DNvXLiKrmlIqdhpBzjJBPNHFkpHre2KEswJTeAW"
    "08FyOpWkP4qJJQxGMe9d2iAMBgjd4q3Vq5i6QCrwBxH5XJaMbC1rAlcA2aQelW3LIAglAOc/"
    "v4lSAIo4CtD1BG9f+B5D1/CHEVnHwoj7ZSBrACj1Z1EpRawUn7z5zAMASAVSKqSCIJQYukYQ"
    "xkTRGAAD6HRD0egNwhcsUycYR7z76TWQf0EBEqkMH762RMY22P+9TzfUG0BHKEnL862a7/dw"
    "bAOpwE7nSE4UsJxJUtkp7Ewe3UggJThJgx1vl3aUrSlJy9Ak3vW9bH0msbXpOOnS4SmbD14t"
    "PfquFCgFEsViMcVW84Cfajc2d3i+rkk8fevr97vpkx+pgmiPu/t3n83mC4nHCimEphFJhRCQ"
    "c0wO5Szu7h7w1Tff9u6H+c/q4rnL62e0Xw2AcUTjy92nkidzP3Dw3eVTx0qVUnHGZXIiRRQr"
    "7re7XL/ncfvWxmZLzqzdMl5eH0c0/lOmRXP7+JxsVNLR3nJCDspRHDOUdsPX8rWmWal74ol/"
    "y/R/dP4Dap5vXp5YAPwAAAAASUVORK5CYII=")
index.append('control_eject_blue')
catalog['control_eject_blue'] = control_eject_blue

#----------------------------------------------------------------------
control_end = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj1J"
    "REFUOI2lk7FrIkEUxj9z4uIUuwS2SBUIpIlopZKU/gH+D1dqEyG1+Qdypd01Oa5JGzgDkio2"
    "ERbslkSsg1pEQZedzejMvHfFxb1cwlV5MM3jfT++N/MN8MnKvG+MRqMKgDqAGjOXmBlEFBJR"
    "3xhzUy6Xh/8FjMfjBhG1fN8vCCHgOA4AQCmFOI4xmUweiahTrVa/f7AyHo8bo9FopZRiZmal"
    "FEdRxKvVil9eXpiZWUrJQRCsBoNBY6vb2domotbBwYHrOA7u7wdIkgRaaxhjIKXEfD6HEALF"
    "YtFdr9etu7u7SgoAUPd9v+A4DpbLJbrdX3h4eAAAMDMuLr7h8vIHoiiCEAL7+/uFOI7rAJAF"
    "ACKqCSGglAIRgRnodrsgIhwdHQHgFCalxO7uLpRStbeAkuM4iOM4HQSA29tbzOdzMP/pvQVo"
    "rUvpClvB65MBALLZL9BaI5PJpOLtzGazgTHm7yUSUZgkCXK5HIjoVWzQbrdxcnLyzwpCCCwW"
    "C2w2mzAFWGv7URQhn8+DmaG1xvl5G1JKMDN8309d5PN5TCYTWGv7aZCCIKhorX8Wi8WC53lY"
    "LpdIkiQVCSEAAK7rYjabodfrPTLz12azOdwBgOPj46FSqhMEQbRYLOB5HlzXRTabTY/ruphO"
    "p+j1etF6ve40m83hhyhfX183tNatw8PDwt7eHjzPg7UWz8/PeHp6QhiGj8aYztnZWRrlD5/p"
    "6uqqIqWsG2NqRFSy1sJaGxJRP5fL3Zyeng7faz5VvwH+WXvTugCrUAAAAABJRU5ErkJggg==")
index.append('control_end')
catalog['control_end'] = control_end

#----------------------------------------------------------------------
control_end_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvBJ"
    "REFUOI2lk01vG1UUhp+5nvGMv+LEycQ4kZoGGtdyBUqFQlFZVCBXgh+AVLGrWBLU0n9QiRVi"
    "12woK9iQrgEBVajoCkpTcKlkJpbSyrTjJjGmmfFnxjP3skhaVS07zuro0XvO0XukV+OZqlxS"
    "M0owqwlsIHuAPSVpaRJ37UOt+bRee9ycWlFpQ6e0ZHsnlgqd8kxysJg0opKSCn9POM1evPrb"
    "znjtVnvixijEub6sdZ8sOLWi0pbg+NmXm5Xy1ODMtG0XU8kElqkDMBiO6HR7NO67daedXL2y"
    "+eLaUPL79WWtqwMYOqWzx5qVY/behSOH59KWqTMIIjr9EAWYRoyZ6QnGMqmivPPnhXfn66w2"
    "igNgPVa5pGaWXvAqb8357y/MHypYps436y3ssTiRBClhGEo6g4jJjEkul4v725sFf89w029+"
    "6golmF3Ke+Vp2y5aps7ffsAXVzf4pb4LgESxvHKDi1c2+ac7Ip2IM3d4vviS2SgrwazQBHYh"
    "NVxMJRP09iIiCUrBl1cdft7YRUoFKGCf+/2Q3HiWjGwtagJbB7KJWFiyTB2vFx4IJQBf/XSP"
    "5qMCSFBKoZTCH0RMZ030qFcCsuLpAaUUkdq/FtMNwtEQTdNQSnKAkQqGQUQYjgAQgNcJhNPt"
    "B5iGQEpFTDeIgoDL507yzvGpJxakgowVY+dRj04QcwBPKEnL9c2q73dJWzpSQRQMufzRSbx+"
    "iFQwaeeRav8H6YTOA/ch7TBbVZKWrkncm9vZWj5+t55Op4qHpiw+O/8GXj888A0fv7cAQC5j"
    "8NeWxx/VW/UHvF7TJG7s7ncXO6nTn6hJ0R51du69ms1Nxu1sAqFphFIhBCTMGOMpg8bWLt9+"
    "/0N3K8h9XhOvXVv7QNvQAUYhztcPX0mcHv+V3R+vnVkolouFvM3EWJIwUmy1O9y873Ln9nq9"
    "JfOrt/W310Yhzn+G6YjRODErnXIq3F6My34pjCIG0nJ8LVdtGuWaK44+H6b/E+d/AQg2eOdW"
    "FgEKAAAAAElFTkSuQmCC")
index.append('control_end_blue')
catalog['control_end_blue'] = control_end_blue

#----------------------------------------------------------------------
control_equalizer = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmFJ"
    "REFUOI2lkz1LK0EUht8bQ5YMQUlIkUZBsJCwQSTaL2i5rb8hlQsW3h9gI6S0sxUUiUWaFBaC"
    "qQRBsFgwBBUDGgs/iLtkdDY7c85tbhavcitPM8zA+/Aw8w7ww/n19aDT6SwBcAE4zFxhZhCR"
    "T0RtrXWrWq1e/BfQ7XZrROQVi8WyEAKWZQEAlFIYDofo9/tXRLSzvLy8+02l2+3WOp1OoJRi"
    "ZmalFIdhyEEQ8MfHBzMzSyn5/Pw8ODs7q41zqbE2EXmzs7OTlmXh7e0NjUYDcRxDa41Go4GX"
    "lxcIIWDb9mQURd7p6elSAgDgFovF8jhsjMH19TXiOMbh4SGazSb29vbw9PQEIQRmZmbKw+HQ"
    "TQBE5AghoJQCEYGIMDExgcFggJubG2xvb6PX64GZIaVEPp+HUsr5DKhYloUoivB3D2ZGPp/H"
    "wsICNjc3Yds2iAhSSuRyOcRxXEkAzIzxGkURjo6OcHl5if39faysrGB+fh6u64KZwcwYjUbQ"
    "WuOzgf/+/o5MJoPBYIDb21vU63Xc3d2BiJKXYmYIIfD6+orRaOQnAGNMOwxDZLNZFAoFLC4u"
    "YmtrC7ZtI5VKIZ1OJ3eTzWbR7/dhjGkDQBoAtNatXq+3lsvlyqVSCaurqwiCINF2HAdEhOnp"
    "aTw8PMD3/Stmbv3TxJOTk5oxpl6tVicLhQKklJBSJtpCCDw+PuL4+DiMoui353m736rcbDZr"
    "cRx7c3Nz5VKphKmpKRhj8Pz8jPv7e/i+f6W13tnY2Eiq/O0zHRwcLEkpXa21Q0QVYwyMMT4R"
    "tTOZTGt9ff3ia+ZH8wfJkHt0cHtuQAAAAABJRU5ErkJggg==")
index.append('control_equalizer')
catalog['control_equalizer'] = control_equalizer

#----------------------------------------------------------------------
control_equalizer_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxpJ"
    "REFUOI2lk99rW2UYxz/nzUlOfrVJT3bapinrurZZTGdX0VrwZkw70T9A3O0meLMpOLzyyl2I"
    "qMMLO1HwUpAKouIcblAHRW82p3YOaozNktCm3RqDzUnSJCfnvK8XuiHqnd+rhy/P57l6Phr/"
    "yMKiGlGClCawgNhfdV1JqpqksvyCtvX3fe3ecPSCivp1MnNWfX4u2ciOhNuzYb+XUVJhd0Vu"
    "qxVY/WEnvvZ9beBazyW3ckZr3j9w9IKKBgUPnXxwayG7r31i0LLSkXCIoKED0O70aDRblDcq"
    "+VwtvPRx4eByR/LjyhmtqQP4dTInp7cWpq3u2ckDY9GgodN2PBp7Lgow/D5GBgfo74uk5a2f"
    "zz4znmepnG4DN3wLi2pkbri+8PiY/dzU+P5k0ND5zXZ47/IGM2P9SAnvX9lgIhkm0WdgmmbA"
    "vltI2l1/JXrsfEUoQWpuqJ4dtKz0PbgnFT8Vd+m6krcvlvji0494/ZPbbNY6REMBxg6MpyeM"
    "clYJUkITWMlIZzYSDtHqengSpFQIn87OrkN+vcTiuRcplwpIBfaeixmP0Sers5rAEkAs5HMz"
    "QUOn40gAPAlKKQbjAR6ZmeT0K+eZmT6ElAq77RKLGuheKwPEBIBSf4JKKdqOxzuXyhSufc5b"
    "nxV59rFhRg8f49QTo0gFUkHH8XDdHgACqDcckWvuORh+wU7dYb1Q4t3XXqJU/BVPqftPo5Si"
    "L+hj5/cWDceXA+pCSaoV21i17SbRoM5QPMD8kSlefuNDZqYfwKdp+PwGUiqkhGhIZ7OyTc2N"
    "rSpJ1Tfx9Kt4Uu6zZHEyNpBIJM0QqUSQzW6C558cBSASDpI0DaaSEUrbdb79ZiW/zpEv6555"
    "3Xf7q3ONyPE3VULUeo2d4sMxMxEYTYSZT8dxpUIIOLy/j+G4QXF7l0uXrzTvOOYHa+LRq8un"
    "tV90gJ5L7uL2TOh4/Dq7X189MZXOppNDFgP9YVxPcafW4LuNCrdu3shX5dDSTf2p5Z5L7j9l"
    "mvSX51Myl424d2cDci/jeh5tGczZmrm65c+uVcShf8v0f3T+A8f+ctvh9YATAAAAAElFTkSu"
    "QmCC")
index.append('control_equalizer_blue')
catalog['control_equalizer_blue'] = control_equalizer_blue

#----------------------------------------------------------------------
control_fastforward = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAklJ"
    "REFUOI2lk7FKK1EQhv+bXbJkMQlCQBERBKtgKhXbPEDeIzYGrLNPkYgQb29rE7A0lRBIt5CQ"
    "TgiLYAyadc96ds85MxbRvaLcyulm4PvmL2aAX9af74PJZHIIoAGgzsw1ZgYR+UQ00Fr3Dw4O"
    "Rv8VTKfTJhG1KpVK1XVdOI4DAJBSIooiBEEwJqLO0dFR70eU6XTanEwmSyklMzNLKTkMQ14u"
    "l/z29sbMzEIIHg6Hy7u7u+Ynl/uMTUSt3d3dkuM4CIIAcRxDKQWtNebzOZ6enuC6Lvb390tJ"
    "krRub28PMwGARqVSqTqOg5eXF3S7XUSRAAAwM7rdc0RRhMfHR7iui52dnWoURY1MQER113Uh"
    "pQQRgRk4P+8iiiIQEQDGxcUFhBAQQmB9fR1SyvpXQc1xHCRJkm1lBnq9HpIkAfNqdnn5F8/P"
    "z1hbW4NSqpYJmDkDVxsB27aglEKxWAQzw7IsKJWiWCwiTVNorfE1gR/HMfL5PIjoA9Zot9uI"
    "4xi2bUFrDc/zkMvlsFgskKapnwmMMYMwDFEoFMDMUErB89oQQnz0K9nr6ysKhQKCIIAxZpAJ"
    "tNb9+/v7cRiG2NjYQLv9DyYieN4K3t7exsPDA3zfHzNzPxMcHx+PpJSd4XAYLhYLlMtllEol"
    "2LYN27ZhWRa2trYwm81wc3MTJknSOTk5Gf045evr66ZSqrW3t1fd3NxEuVyGMQbz+Ryz2Qy+"
    "74+11p2zs7PslH8809XV1aEQoqG1rhNRzRgDY4xPRIN8Pt8/PT0dfWd+Ve/rr4cZiPnqIQAA"
    "AABJRU5ErkJggg==")
index.append('control_fastforward')
catalog['control_fastforward'] = control_fastforward

#----------------------------------------------------------------------
control_fastforward_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwFJ"
    "REFUOI2lk09oHGUYxn/z7czO/ks3u9tJslkwiU3WZYuaIrFQikXdgp5F6LV4tKLtqT1U7FW8"
    "tQeJUAU9xLOKCrEQ9GJNa0okrsEYQ7tJmu2SzOyf2Z355vs82IqoN9/L+z4P7/Pcfgb/mNpV"
    "Pa4FJUPgANmHtqsVTUPRWHzD2P77v/HoOHVNZyyTypzjHp8rtqvjKX82ZUUVrTTeQNS3u/GV"
    "23vDa7daue9DSX3pnNH5q+DUNZ1JCI6dfXK7Vj3snxlxnHI6lSRhmwD4/ZB2p8vW3cZ6vZVa"
    "+HTj8cW+4selc0bHBLBMKmePbteOOoML05MTmYRt4gcR7Z5EA7YVY3wkx6GhdFmt/nzh1al1"
    "FrbKPrAcq13V43Njbu2FCe+1manHignbZGO3BxhECpSCB17IQCoKQzb5fD7u3d8oegOrkXn+"
    "vYbQgtLcqFsdcZxywjZ54AVcvH4btysBUGguXl/moBtyr9Unk4wzMTlVPmJvVbWgJAyBU0z3"
    "Z9OpJN1BRKRAa7j04TIHvRClNKC5/NEt3J7E60nyw1mGVHPWEDgCyCZjspKwTfqBAkBrhdbw"
    "9sc/4Q8UKEAprnyyyp4bkM3YmFG3AmTFo8CfWxNpDUDMtJBhn1zGQmuFMC1k4JPLWPSDCClD"
    "AATgtgNR7/QCbEuglCZmWkRBwPybJ2j7kphlEYUB8+dPIgzY2+/SDmJ1wBVa0Wx49orndcgk"
    "TJSGKOgzf/4Ebk8+1AHvv3WS/Y4kkzS519ihJbMrWtGMHXn5HSKlDjtqczqbKxTGcglePFbC"
    "8yO01mgNrzw3yX43ZKaY5vcdl+++XVr/lac/d6P8zdhvX15pp0+/qwuiFbb3Np/J5gtxJ5tE"
    "GAZSaYSAZDzG2LDN5s4BX3z1dWc3yH+wJp69sfi68YsJEErqn+08lTw9fJODb26cmSlXy8VR"
    "h9yhFDLS7Lba/HC3weqd5fWmGl24Y760GErq/wnTtLV1vKTq1bS8PxtXvYqMInyVqHtGfmXb"
    "qq41xBP/hun/4PwHVy2FMSIzPs4AAAAASUVORK5CYII=")
index.append('control_fastforward_blue')
catalog['control_fastforward_blue'] = control_fastforward_blue

#----------------------------------------------------------------------
control_pause = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhNJ"
    "REFUOI2lk7FrIlEQxr8Li4vLokgeaCUIVoJVEmy1t736Ok1jwP/CXGl3RTyuSZtGSGslKHYL"
    "ip0gaiFCXHbNW31v5gr3Nhq5KlPNDO/73m8e84AvxrfPjclkcgugCqDMzEVmBhE5RNRTSnVv"
    "bm5G/zWYTqd1InoQQhQsy4JpmgAAKSU8z8NisRgTUfvu7u7XBcp0Oq1PJpOtlJKZmaWU7Lou"
    "b7dbfn9/Z2Zm3/d5MBhs+/1+/YwgxP6Ty+UKpmni7e0NzAxmBoAoF0Jgt9thOByOAfyoVCqj"
    "q9CoKoSIxK1WC09PnUj8+PgTnc5vuK4Ly7KQzWYLnudVAcAAACIqW5YFKSWICMeLOcwZwAeJ"
    "7/tIpVKQUpYB4Co0KJqmiSAIzpD/GTB/9Hzfh23bOBwOxcjgdFYiCnOcmZ2e2e/3UErhlMDZ"
    "7XaIxWKhAUcjfNRHsWVZ2Gw22O/3TmSgte65rot4PA5mxvW1OBtBCBFRxONxLBYLaK170SMq"
    "pbqz2ey7bduFdDqNer0W7YfneajVjnUikcBqtYLjOGNm7kYEpVJpJKVsDwYDd7PZIJlMwjAM"
    "BEEAwzBgGAYSiQSWyyVeX1/dIAja9/f3o4tVfnl5qR8Oh4d8Pl/IZDJIJpPQWmO9XmM+n8Nx"
    "nLFSqt1sNqNVvvhMz8/Pt77vV5VSZSIqaq2htXaIqBeLxbqNRmP0WfOl+AvvrXwWgcqhRQAA"
    "AABJRU5ErkJggg==")
index.append('control_pause')
catalog['control_pause'] = control_pause

#----------------------------------------------------------------------
control_pause_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAslJ"
    "REFUOI2lk09vG1UUxX/zPOMZ2+M6sT0xTqSmgcRYrkBhEZVdBTISXwCpglXFCinZ9BOAhLpi"
    "13wIdw2LLgxSN0huU3BbyYwsBWHacZK6ofH4vz3zXheOqwi6427ePffdc+6V3jsa/4ryHbWq"
    "BGuawAFS5+WuknQ0iVfd09oX+7VFcn1f2YZOccfpXtvJ90qr8dF23AiLSir8iXDbg2j9txdL"
    "jUeny7VZgHt/V+u/Ebi+r2xL8NHND9rlUnZ0Y8VxCol4DMvUARiNZ/T6A1rPvKZ7Gq/cPXy3"
    "Opb8fn9X6+sAhk7x5tV2+aozubV5Zd22TJ3RNKQ3DFCAaURYXVnmUjJRkE//uPXFRpNKqzAC"
    "DiLlO2p1551u+dN1/+utjct5y9R56U+ZzBShBClhHEh6o5BM0iSdTkf9k8O8PzE8+5MfPKEE"
    "azu5bmnFcQoL8jf7D/i2cgiARLG7X+O7u4f8059hx6KsX9kovGe2SkqwpmsCJ58YbyfiMQaT"
    "kFCCUgCKUCmUUoAC5nV/GJBeSpGUnW1N4AggFYsERcvUGU/leaNEAlKquZgEdS7mjwJStoke"
    "DopASiwI83M+dTENQKr5/UU8noYEwQwAAXR7U+H2h1NMQyDlYmVFKNUFPCcnrQgvXg3oTSMu"
    "0BVK0vF8s+77fWxLRyrIZLIoxfwVFGSc3PkmYMd0nntHnAapupJ0dE3iPTxJNXLRP5u2nShc"
    "zlrc/mrrzVc9GwR8/+Ucp5MGfx93eVJ/1HzOxw1N4onqntZ+4mdrjZdm5dfaQf/k1YBMMooe"
    "EQynEkPXMHSNdNKgdXzGT/fu9Y9m2cpfbNaqe1pbB5gFuD8efRj7bOkBZz//cmOrUCrkcw7L"
    "l+IEoeL4tMfDZx5PHx80OzJXeax/Xp0FuG8106bRurYm3VIiONmOymExCENG0nJ9LV1vG6WG"
    "J97/r5n+j51fA8I/e2uTZnkjAAAAAElFTkSuQmCC")
index.append('control_pause_blue')
catalog['control_pause_blue'] = control_pause_blue

#----------------------------------------------------------------------
control_play = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAihJ"
    "REFUOI2lk7FKI1EUhv/dyAy5iKIETCGCksZgqtE+D5D3SOVAGpvNE2xp5wuktTCFLoKpBMFG"
    "BjNMJ2gimAhmmDvembn3nG2Sy6ps5enugf87H4dzgW/Wj8+NMAz3AbQANJm5wcwgooCIBlrr"
    "vud5t/8FRFHUJiK/UqnUhRBwXRcAoJRCkiQYjUZDIjo+ODg4+aISRVE7DMOZUoqZmZVSHMcx"
    "z2Yzfn9/Z2ZmKSXf3NzMrq+v24vcz4U2Efnb29srruvi7e0NaZri7u4OWmtIKTGdTiGEwN7e"
    "3kqWZf7V1dW+BQBoVSqV+iLMzGBmnJ31cX9/j/ke8PLyAiEEtra26kmStABgCQCIqCmEgFIK"
    "RAQAHyBEhN3dXTAzpJRYW1uDUqppDYio4bousizD/D0HMQDGxcUfPD09gYggpcTy8jKKomhY"
    "ADPbqURkpwNAqbSEPM+xs7Nj+3meQ2uNfw2CNE3hOM4HQKlUQlEU6HZ/IU1TMDOEEHh9fUWe"
    "54EFGGMGcRyjXC5bCyKyYSml7ZXLZYxGIxhjBhagte4/PDwM4zjGxsaGteh2u0iSxIY3Nzfx"
    "/PyMIAiGzNz/cImXl5dtY8xvz/NW1tfXIaWElNJqCyEwHo9xfn4eZ1l25Pv+yZdTPj09bRdF"
    "4ddqtXq1WsXq6iqMMZhMJnh8fEQQBEOt9XGn07Gn/OUz9Xq9fSllS2vdJKKGMQbGmICIBo7j"
    "9A8PD28/Z75VfwGM35vsLpav1wAAAABJRU5ErkJggg==")
index.append('control_play')
catalog['control_play'] = control_play

#----------------------------------------------------------------------
control_play_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuZJ"
    "REFUOI2lk81vG2UQh599d+1df6R2nG5SJyhpIDWWq6IgFHoAqQK5Ev8AUq8VR8qh/Q+4Im7t"
    "qdx6CmeEgCoU9YIKbcGlktkaJSU0dj6MVXvX3959h4MJQsCNkUYajeYZzYd+Bv+w8nVZFMWS"
    "oXCBzJ/pjmiahqa+9YHR+Hu9cRxcuCHpmEVxw+2c38gHpcXkYD0Zi4qiBX+kvEYvXvnhKFt9"
    "2Jr9bhLi3b1idP9qcOGGpB3Fq5fPNcqlk4NL865bSCUTOLYFwGA4Iej22H1Wr3mt5Oan2y9u"
    "DTU/3r1idC2AmEXx8tlG+aw7urZ2eiXt2BaDcUTQDxHAjpkszs9yYiZV0I9/vvbuao3N3cIA"
    "eGCWr8vixqlO+e0V/70zq8t5x7b43R8zmgjfPmmTn3UYhppgEDE3Y5PL5eL+4XbeH8Xq6bc+"
    "ritRLG0sdErzrls4hrWACNy6XeNerY0IaC3stYakE3FWTq8WXrJ3S6JYUobCzaeG66lkgt4o"
    "ItJTWCOIaG7d9rhXawOgBfx+SC6bYUY31w2Fq4BMwgyLjm0xHGsAIhG0FmDqm9/8yi/7fbQW"
    "/EFIJm1jRb0ikFEAIlNQRIhEEBFEpu81zTjhqM+55TRaplMMxxFhOAFAAZ1grLxuf4wdU2g9"
    "hbWAacYIx0NuXn0DfxAhIsw4JkfPewRj0wM6SjTNum9XfL9L2rHQApGernAMd/ohWgtaQzph"
    "sVffpxVmKqJpKkNTv3+YqW7v7NSeB0OWTzpEejrBzatv0u6FaD29y1o+yW8HHX6qPKztUaga"
    "mrq588WHQeriRzKnWpPg6Olrmdxc/IW5JMow6I4ilIJsOsaprM3T/Taff/lV92Cc+6SqXr+z"
    "9b7xxAKYhHif7b+SuJj9nvbXdy6dKZQK+QWX2RNJwkg4aAXcf1bn8aMHtaZe2HxkvbM1CfH+"
    "U0xrsd3zS9orpcLD9bjuF8MoYqAdzzdylUasVK2rl/8tpv8j5z8AQS2VYZW03LAAAAAASUVO"
    "RK5CYII=")
index.append('control_play_blue')
catalog['control_play_blue'] = control_play_blue

#----------------------------------------------------------------------
control_repeat = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlJJ"
    "REFUOI2lk7FLW1EUh7+WkocPqShPFJFI0CmQxVQwi9Xd2bVjFg249I/o2K2DQxeFLDpkcHBw"
    "CIKS7YWEbM+IOkjAPLzxJe/eczpUQqt06pkOl3u/8x34XfjPevf6oN1ufwK2gU1VLagqIhKK"
    "yLm1tlYsFhv/BHQ6nbKIVIIgyPu+j+d5ACRJwtPTE7e3ty0R+b62tvbjjUqn0ym32+1+kiSq"
    "qpokicZxrP1+X5+fn1VV1Rijl5eX/YuLi/JfBi/aP3O5XN7zPB4fH1FVVBVg3AdBwGAw4Orq"
    "qgV82draanx4AW0HQZD3PI9arUa9Xh+b/QlZXl6mXC6TzWbzrVZrG/gNEJFN3/dJkoR6vc7O"
    "zg5LS0vjyarK9fU11WoVYwzT09MkSbIJ8P4FUPA8j+FwCEA2m0VEEBGstRwdHTE7O4uqYoxh"
    "cnKSNE0LY8DrXaMoQlVJ05RqtUq32yWKovGd0WiEtZY/DcLBYEAmk6FUKnFwcICq0mw26Xa7"
    "qConJyfkcjl836fX6zEajUKADwDOufM4jj8vLCxQKpVYX19HRCgUCvR6PRqNBru7u3iex8TE"
    "BM1mE+fc+djAWluLoqgVxzFzc3OIyHidjY0NVldXEREWFxe5v78nDMOWqtb+SuLZ2VnZOfet"
    "WCx+nJmZwRiDMQZVxfd9fN/n7u6O09PTeDgcfq1UKj/eRPn4+LicpmllZWUlPz8/z9TUFM45"
    "Hh4euLm5IQzDlrX2+/7+/jjKbz7T4eHhJ2PMtrV2U0QKzjmcc6GInGcymdre3l7j9Zv/ql+U"
    "h4CDhh3OBgAAAABJRU5ErkJggg==")
index.append('control_repeat')
catalog['control_repeat'] = control_repeat

#----------------------------------------------------------------------
control_repeat_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwpJ"
    "REFUOI2lk91rW3UYxz/n5CQnb13apKddkm1dNE1DhtIp2XQIQ8lAh4g3wsCrsTudN/sPFLyR"
    "CcIGXghe6E29HDqq0BV2IdK91HSF9Cyw1rQ56UsWzGvzds7v58Vqkemdz83z8PC8fuGj8Jzl"
    "bsiYVIkrKgYQOkg3pKCqCKyFT5TKP+uVv4PzN2XQrZHOGo2z2WgrE/N3Z/1uJy2FpNlXzUrH"
    "k1/eGy08rI0tDW3Mu1eV9uGA8zdl0Kty+vJLlVxmvHtpwjBSAb8Pr64B0O0NabU7lLasolnz"
    "z/3w5IWFnuD3u1eVtgbg1khfPlXJnTL615Inp4JeXaM7cGjt20hAd7uITYxxZCSQEqtr1z5I"
    "FJkrpbrAA1fuhoxljzZyb001r0wnTkS9usbT5oD+UOIIEAJ6tqDVdYiM6ITDYU9z90m02Xdb"
    "wTevW5pUiWcnG5kJw0h5dY1v71jML20ciiSlOPCSdCLG5x9OM3UykXrxaSmzqh69pykqRjTQ"
    "mw34fXT6DvNLG3z0Xob0sQBSPmuUEsxyh69vPaK5nyA8GmJEVGcVFUMFQj6XnfbqGr3Bs20z"
    "8QBCSISQDG3J9Vt/EIvoSClpdm1CQR3N6aSBkPr8mVIK1rbaSAn9oeCrn0psbpZZK3cAEBJ6"
    "AwfbHgKgAo3WQDXb+wN0t0oum+DL7xcREn57XGdzs4yUgu9uL5NMxBnxutj7s0Nr4DKBhiYF"
    "Vaup56ea7XPHoxEuvmLwzul3EUJyLj3GTj3Jr8tFPrvyBn6Pi6BPY6WwTc0O5aWgqikC6/5u"
    "qDDpWS8Gg4HUiXEv67vdw5fePzOBc6BHMupnvVLnUf5hscxrBUVgudbnP20FLnwhI2pt2Nrb"
    "eDUUjniORfyoioItJKoKr8+Mcnzcx8Z2nds//9LeGYS/KahnFhc+Vh5rAEMb88ftl30XRu9R"
    "v7N4aTqVSUUnDcaO+LEdyU6txf0ti9WVB8WqmJxb0d5eGNqY/wlT0l06GxdmJmDvznrEftp2"
    "HLrCazaVcL7izhQsdebfMP0fnP8C9GuCUkaZuZIAAAAASUVORK5CYII=")
index.append('control_repeat_blue')
catalog['control_repeat_blue'] = control_repeat_blue

#----------------------------------------------------------------------
control_rewind = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkZJ"
    "REFUOI2lkzFLI1EUhY/j0zFvBoIQMAERBKtAKhXb2Oc/bCEYSVD0X6TJFiEEttzG1iZgm0qI"
    "pBtISCeEICgBM2SSNzPv3buF7qwxbOXt7oHzcQ7cC3xz1r4Kg8HgCEAJQJGZC8wMIvKIqKO1"
    "bh8eHvb+CxgOh2UiuspkMnkpJWzbBgAopTCbzTAej/tE1Dg+Pv61EmU4HJYHg8FUKcXMzEop"
    "9n2fp9MpLxYLZmYOgoC73e704eGhvJTgI/bv/f39vG3beHt7QxRFEEIAAJgZURQhl8thPp/j"
    "8fGxD+DH6elpz/oAlTKZzJK52WwumVutFl5eXiClxN7eXn42m5UAwAIAIipKKaGUQhiGqNd/"
    "4kNHGIao1WoJLAgCbG9vQylV/Awo2LaNxWKBer0OZgYzI45j1Go1ML+biQhBEMB1XcRxXEgA"
    "zAwAsCwLUjogMgCAra0tOI4DIdYT6N9KWmt8TuDN53NsbGygWq3AcVysrVkIwxDX19dwHAeW"
    "9Q6RUmIymSCKIi8BGGM6vu8jlUqBiFCtViDEOogIxhhUKv/2VCqF8XgMY0wnAWit209PT33f"
    "97GzswOtNc7Pz5PeWmucnZ1hd3cXz8/P8Dyvz8ztBHByctJTSjW63a4/mUyQy+Xgui6EEBBC"
    "IJ1OI5vNYjQa4f7+3g/DsHFxcdFbOeW7u7tyHMdXBwcH+Ww2i3Q6DWMMXl9fMRqN4HleX2vd"
    "uLm5SU555Zlub2+PgiAoaa2LRFQwxsAY4xFRZ3Nzs315edn76vnW/AFP9XLbnh0vwAAAAABJ"
    "RU5ErkJggg==")
index.append('control_rewind')
catalog['control_rewind'] = control_rewind

#----------------------------------------------------------------------
control_rewind_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvlJ"
    "REFUOI2lk82LW2UUxn/3vfcmN19NJtNkzIx0OpqmIYMyKmOXRUnBf0AsLixFXFmxdiG4UxCE"
    "oau2i4IbcTWuRVSYDnRZO9XUYoyBmTJ2kvmIoc3N982973Extoi686weDuc8nIfDz+AfVb4q"
    "s6KYMxQZIPlXuyOalqFprL1nNP8+bzwWp69J3LYoLmc6p5Zz3dJsdLgUtYOiaMEdq1qzH6r8"
    "eJCq3mlP3Zr41G5eMHpPDE5fk7ijeOH8c81y6ejwbDaTKcSiEZywBcBwNKHb67P9oFGvtaOr"
    "X20+szbS/HTzgtGzAGyL4vnFZnkxM76UPz4fd8IWQy+gO/ARIGybzGanOJKIFfS9Xy+9vlBn"
    "dbswBDbM8lWZXX6qU3513n37xMKxnBO2+MP16A4DwEBrGPmatjshm3JIp9Mhd38z547tRvyV"
    "yw0lirnlmU4pm8kUHi+PJpoPv6gCoBHGnuajL39hpz0iHgkxf3yh8Gx4uySKOWUoMrnYaCkW"
    "jdAfBww8zcXrGwAEIgzHmvevrB+aCbgDn3QqSUK3lgxFRgHJiOkXnbBFfxTwwfVbiGhENN5E"
    "c/HKDURARNBacIc+yXgYK+gXgaQCENEAmMrAiU0hgQ9ANGzixNOYlo1ojZbDK0ZegO9PAFBA"
    "p+upWm/gEbIMVs4VcBLTGMbhJy6/8yJOIo0ybUSEhGNy8LBP1zNrQEeJptVwwxXX7RF3LAIN"
    "K+dOYlomgQY/ED57axHTstAa4hGLncYubT9ZEU1LGZrG7f1kdXNrq/6wO+LYUQfPFz59M/8k"
    "98QXPn4jTz4X5fe9Dj9X7tR3KFQNTcPc+vaTbuzMikyr9qR7cP+lZHo69PR0FDDwtaAUpOI2"
    "2VSY+7uP+Oa773t7Xvrzqnp5fe1d4zcLYOJT+3r3+ciZ1A88urF+9kShVMjNZJg6EsUPhL12"
    "l9sPGty7u1Fv6ZnVu9ZraxOf2n/ClLe3T83pWinm7y+F9KDoBwFD7dRcI11p2qVqQ538N0z/"
    "B+c/AfbSfS/7zfqzAAAAAElFTkSuQmCC")
index.append('control_rewind_blue')
catalog['control_rewind_blue'] = control_rewind_blue

#----------------------------------------------------------------------
control_start = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkBJ"
    "REFUOI2lkzFPIlEQx/9eYDe8kCWbbGFlYmJFpFLj2fEBaO8jHNhIYqt+Aq+ju8IrLc/iSCyu"
    "kFDgkdCtQLYzQRqFYtd9+GDfm7lC3Quaq5xmksnM7/3nn3nAB2PlbWE4HG4DqAAoM3OJmUFE"
    "PhG1tNbNra2t3n8BQRDUiKjueV5RCAHbtgEASinEcYzxeDwgosbOzs73d1KCIKgNh8NQKcXM"
    "zEopjqKIwzDkp6cnZmaWUnK32w07nU7tde7Tq2wiqq+vrzu2bWMymSCOYyRJAq01pJRot9sQ"
    "QmBzc9OZz+f1q6ur7RQAoOJ5XtG2bURRhNPTbzg7+wEAYGb0+310Ote4v7+HEAJra2vFOI4r"
    "KYCIykIIKKXAzAAYL3Xc3PTx89fvFCalhOu6UEqVASDz0liybRtxHIOZwfzc3G63cX39B1kA"
    "QB5ElAKSJCmlCp5fXc7MjJWV1w2xVF8sFtBa/zORiPzZbAbLspZW2Nv7jJOT4yWAEALT6RSL"
    "xcJPAcaYVhRFyOVyYGZ4noeXA4KUEsfHR6knuVwO4/EYxphW6oHWunl7e/sln88XHcdBtVoF"
    "AMxmMwDA4+MjqtWvcF0Xd3d38H1/wMzNVMHu7m5PKdXodrtRGIZwXReWZSGbzSKTyaBQKMBx"
    "HIxGI1xeXkbz+byxv7/fe3fKFxcXtSRJ6hsbG8XV1VUUCgUYY/Dw8IDRaATf9wda68bh4WF6"
    "yu8+0/n5+baUsqK1LhNRyRgDY4xPRC3LspoHBwe9tzMfir+rWW3xec/YTwAAAABJRU5ErkJg"
    "gg==")
index.append('control_start')
catalog['control_start'] = control_start

#----------------------------------------------------------------------
control_start_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAudJ"
    "REFUOI2lk99rW3UYxj/n5CQnP06bNO1JTAu21TWGDEdV6tSboWQg3gtjd8NLN9D9BQq7Eu82"
    "L9QLb+udIEMH7WBX0m3V1EFMA22pa9K1IWtz8jv5nu/rRV0Z6p3vzfuDl4fneV8eg39E4aZM"
    "i8mMYeIC8b/HTdHUDU115ZpRe37feFZcuCVO0CK35DbPL2Va+elobzEa9HOiBW9glmudUPHX"
    "w0RpvTGxNlKU71012qcAF26JEzZ57cqrtUJ+qncp5brZWDRC2LYA6PVHtNoddh9XK+VGdPn7"
    "rZdW+prf7l012hZA0CJ35WytcNYdXD8zN+uEbYve0KfVVQhgBwNMpyYYH4tl9aM/rn84X2F5"
    "N9sDHgYKN2V66YVm4b1Z76OF+RczYduidjRgoDRag9bQV5rVjaecmxsnmUyGvIOtjDcIVp13"
    "v6yaYjKzlG7mU66bDdsWT9sjrn21xmfLWwBohLXNJrfX6+w1+jiRELNz89mX7d28mMyYhomb"
    "ifUXY9EInYGPCIAA4Ivwy2aT7+78eQIm4HUVyUScMV1fNExcC4hHAioXti2aHYWIgAYR4Ye1"
    "A1bv73ByyghaC15PkYrbWH4nB8RNABHNSRae9SJgGKdfPmWgBfpDH6VGAJhAszU0y+3uEDto"
    "op+T8MHrU3zz6TunACLCWDjA4VGH1jBQBpqmaOpVzy56XhsnbCECk24aLeBraHYVX3/y9gkD"
    "DU7EYq+6T0PFi6KpW4am+uAgXkqHtiuOE8smx2xuXF4AoNVTABy1FTcuL5CKh9iuHfN7cb2y"
    "x1slQ1MNbP/0eSt28QuZNBuj1uHOG8nJqVAqEUFpQWnBNCHhBEnEguzsH3P75zvtJ8PktyXz"
    "zbsrHxubFsBIUf5x/1zkYuI+x6t3Ly1k89lM2mViPIryhSeNFg8eV3m08bBS1+nlDev9lZGi"
    "/J9mOhPcPT+jy/mYOlgM6W5O+T49HS57RrJYC+ZLVfOVf5vp/9j5LwlecWi2Wox8AAAAAElF"
    "TkSuQmCC")
index.append('control_start_blue')
catalog['control_start_blue'] = control_start_blue

#----------------------------------------------------------------------
control_stop = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAglJ"
    "REFUOI2lk7FrIlEQxr8Lh4sPOTGsKCJCIJVgtUkd0/s/pBBiFcHm/gDLK9OlvCZtGgsLCytB"
    "SbdBsRNCIihCXPeZt+t7M9foosndNZlm3gzMx+8b5gFfjG8fG6PR6AxABUCZmUvMDCJyiair"
    "tW45jvP4T4HxeFwjorpt20UhBCzLAgAopeD7Pl5eXoZEdHt+fn73CWU8HtdGo9FSKcXMzEop"
    "9jyPl8slv7+/MzOzlJL7/f6y1+vVDgi22L9PTk6KlmXh7e0NzAxmBoDobds21us1BoPBEMDV"
    "5eXl49FWqGLb9n+HiQiz2QxCCBQKhaLv+xUA+A4ARFQWQkApBSICADSbzUggnU7j+voazAwp"
    "JVKpFJRSZQA42gqULMtCEATY1gcUux4RQUqJRCKBzWZTigj2cXfDu9i3sKvDMITWGvsW3PV6"
    "fRGLxRCGIQAgnU4fCO+yEAKLxQJhGLqRgDGm63neRS6Xw2q1AjOjWq3+lSwej+Pp6QnGmG60"
    "A611azKZDD3PQyaTOdjBzjsRIZ/PYzqdwnXdITO3Di6x0+nUjDG/HMf5cXx8DCklpJQRthAC"
    "r6+vaLfbXhAEP+v1+t2nU354eKhtNpv66elpMZvNIplMwhiD+XyO5+dnuK471FrfNhqN6JQ/"
    "fab7+/szKWVFa10mopIxBsYYl4i6sVisdXNz8/hx5kvxB9daiHTqrkSmAAAAAElFTkSuQmCC")
index.append('control_stop')
catalog['control_stop'] = control_stop

#----------------------------------------------------------------------
control_stop_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs5J"
    "REFUOI2lk0tvG2UUhp8Zz3h8S33rxHUCSQOJsVyBglCo1E0FciX+AKJiV1ViQ9n0F4DECsGq"
    "3fEHwhohQEordQltwaGSGSwlVWjHuRgr9Ywdj+2Z77Bw0nDbcaRPOjo6z9Gr99Or8Y+q35I5"
    "0ZnXdGwgezzuiaKjKdyNj7T2X/e1k+bybcmYBtU1u3dxrezX5lLD1ZQZVUUJ3kh32oN446eD"
    "XPNhN//DJMS5d0PrPz9w+bZkEjqvX3u1Xa+dHV6dte1KOpUkYRkADIMJfn/AzhO35XRT619t"
    "vbQRKH6+d0PrGwCmQfXahXb9gj26uXx+MZOwDIbjCP8oRADLjDE3m+fMTLqiHv16892lFus7"
    "lSHwIFa/JXNr53r1txe96ytLC+WEZfCHN2Y0ESIFSkEQKvxhRHHGolAoxL39rbI3Mt3MW5+7"
    "uujMr5V6tVnbrpzASkBk6o1CEAGlhKfdgEwyzuL5pcrL1k5NdOYNTccup4PVdCrJYBQRqSn4"
    "wRd3po0o8qUFPn1/BSXgHYUUcllmVGdV07F1IJuMhdWEZRCMp3QkAqKm77giJSgleMOQbMbC"
    "iAZVIGsAyPGiiBCJICf6j2ciPFemBIJxRBhOADCAnj/Wnf7R+JJlxggmIQD50sKpD3J6bCZh"
    "cHA4wB/HHKBniKLjelZj0etferFc5HAQIiJ8/N7y30ClpkoySYPN5i7dMNsQRUfXFO79/Wxz"
    "a3u7degHLJxNTL9PTkGlpr4sl1P8vtfjl8bD1lMqTU3hxra//cRPX/lMinp34h88fiNbKMZf"
    "KKbQNY1QCboOuYzJuZzF491nfPPd9/29ceHLpv7m3Y0Ptd8MgEmI8/Xua8kruR95dufu1ZVK"
    "rVIu2eTPpAgjYa/rc/+Jy6PNB62OKq1vGu9sTEKc/wzTsrlzcV45tXS4vxpXR9UwihiqhONp"
    "hUbbrDVd/ZV/h+n/xPlPq0eBJ+ktxFQAAAAASUVORK5CYII=")
index.append('control_stop_blue')
catalog['control_stop_blue'] = control_stop_blue

#----------------------------------------------------------------------
creditcards = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk9J"
    "REFUOI1tks9LVFEUxz/3vTdNjo1OpegYOmiFjT+oQJJZtIhyEUIgQtCiXdA/0LrdbAr6B2rZ"
    "uhHaJLSJFoIyIcSMg0JMWoipzTN1nHnz7j0t3jg6jF84nAPn3O/3y7lH3X85//pmf+R52LGj"
    "ACKAGEQEMQImyGIMxgj5ovvh05vZWepw7gxGX1zsuQJYICfDLVkL2vdJdFcecAoOAogCCRSo"
    "K4kRRJtAWZ+QhC3VcZpAFQoFGR4e5mtul66Oc5Sr+nSfZH+U+W9/mEnFAcjlcoyNjanjviUi"
    "AKxvH/F2/mejPo6VjX0yC5usbOwT7EiaBJzj4u7oZQAiYZtI2Gagu43CrwPWt4+YScXZ+edx"
    "FlQ+n5dkMgnA8vIye3t7RCIRbNs+84GIUC6Xq8Vi8XM2m33lVLY+IuffgxFKpSkmJydxHAel"
    "1JkEAJ7nhePx+KAx5pkj2of69js7OwmFQnhra8jcHFKtYiWT2LeuQvsKVH8ABis8QrxnaiSR"
    "SFy3nz681LtT6ZvY/Guj2m/QrRQqncba3cUulbBWV+HLAjplY0kZdBVV+03I9nGrvXaTz2w2"
    "KyPr65DJBCdpDBjD/vQ1orcPQRkQDeJjx1J83xrFalmS54HW4PuNiGby+DULTC0IXQvIT39j"
    "g2BoCKV1Qx2tOZjs44J9CMavP/SB4OBaHITGx/EGBk4caE1k4h6E4yAGMNDWj+qabnXgui41"
    "rYmk00ilgngeKholuIhHjTmlFJ7n4bpuM8HS0tITY8y7WCzWblkt5prgui6Li4uP/wOvyUdx"
    "OavZRAAAAABJRU5ErkJggg==")
index.append('creditcards')
catalog['creditcards'] = creditcards

#----------------------------------------------------------------------
cross = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi1J"
    "REFUOI2dkbtOG0EYhc/M7Hpv3l1ILBQcISuiihaJNwCRgoIqVWKlgCahoEKyROtXyCvwIol4"
    "ALpFdDEoXq8jEPiy9t7mkiKKhW1RJH83Ov93NOf8wD+OOj62n77pnNhqNdTZWfAcnB9+DvLJ"
    "5Mv0w6edJQPVajWgGTcKLFSnp0sm+eFhoBhC4vpfeZGfjA7ev50Z/IVhGIBpQhItzE9OgjmY"
    "aCGrOqjUaqj4/kcu8n3VblMCAKrdNuUwmRDbpsR1IUcjyMEAcpJtAQUUWEg9F7rnI4u6yHqx"
    "WHm4s8jlZUlmEY7aJq8+JtSyGPV8iOEA/PEBquRgrgvd95B1I6RxLIZlVn1zcZEBAHmaUx0d"
    "mblmJMy2mba6AggJSAlIgSyKkMZ9MeT5DF66Ajk/zwyeV4v7e4lSADc3QKcDCIG0F8tFeMkA"
    "AJJcbVJKKAQHyhLgHOAcVGPU43xzcX/OYNxsBozKkFk2wEugXgfq6wDnMHwfhGphvL09d2Iy"
    "BxMWarYD3fOQxj2k/b6QnBNr9QV16q8wjfuY9nrgk/HW+vX11ewH42YzYGChZtnQXQdp9Kft"
    "kRLVhBEn6XbF+EcHdu0lrFoNVKuEtxubAQBoAICiWFNaBVASaRRj+qsvxkTNCus0dqsi7yaq"
    "KJjuOCCUgkq+BuBqFuFx/2CPVfRvxWggxwTOYtudRsPUmJ4Yrsvy+4d3G9Ht98VCcbezs9fZ"
    "3TWXhCcmP1839p7T/2t+Ay4yDJrl8k3tAAAAAElFTkSuQmCC")
index.append('cross')
catalog['cross'] = cross

#----------------------------------------------------------------------
css = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAaxJ"
    "REFUOI3Fkz9rVFEQxX+7+yDhLQsSwSJhF9IkzWqRaGGTQuv0fge/jK3gN7Cz0SKwTRKsTBHY"
    "sMEkYJA1RFiyLnm5784fi/veGsUugheGw2XmnDvMnNtoNFvc5TTvxP4XAo3d3df+t4SZYOa4"
    "C2aKWYmIoipARESIMZIBLC8/nBPdHXerIgm4G2Y6RzPDXTk62kkCACH8wN2rZCpIJK1IdaSO"
    "Fhc7xFgkgaRs5Pk9ut0Nrq8nXFyM6PWeYBY5PHxHv79Nq5VxfDxgMvmCWUQk0BSJc+Vud4Oz"
    "s4+I3NDrPeb0dI/Z7Durq08RCYxGO+T5EiIR1UiMgaaq4C6oRgCm0zEnJ3sUxYT19We020uM"
    "x0M6nQesrT3n6uorqulRkRuaZgWqQhIC1YhIZDj8wP7+G9ydlZVHDAavOD//RL+/jVmsOIEs"
    "xoCZoFoSY8Hm5gtiDJTljDy/j5kwnX5ja+slZsLl5WdUZT7UTCRUaiUHB29/m3QdtzdSDzyh"
    "kIUQMIssLLRvFf/ae32vfQE1Jv9lIgXD4XtEkrvcAyKOWYmZVu0K4BX+YeX//ht/AgYVj0lu"
    "Ur2gAAAAAElFTkSuQmCC")
index.append('css')
catalog['css'] = css

#----------------------------------------------------------------------
css_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAixJ"
    "REFUOI3Vkk1IlFEUhp/PmZjPbxoLA/GnkSxUCjXUChMXkbgRCloEbdsKrYIQ2rZw01awTatW"
    "bsQW/QkuGkVaJGWOaKlQ5A9ak6M5fnPPPbfFp0LQwm0XXu7inPc5h8ML//3zMpkh96+CqqDq"
    "cE5QtagWEbFYK4BBRDDGEAeorm4+NDrncE73FQGcU1Tt4a+qOGeZmxuLAABhuI1zbr8YNUQm"
    "u286ULSR76cwphABIrISBCdJp9vY3c2xvj5Pbe1lVA0zM6M0Nd0gFouzsDBOLvcVVYNISImI"
    "OSSn020sL08hskdt7SWWlibY2dmkru4qIiHz82MEQTkiBmsNxoSUWCs4J1hrAMjnV1lcnKBQ"
    "yNHYeJ1kspzV1SypVAUNDd1sbX3H2mioyB5x1QLWChEIrDVYa8lmX6JqaW29TU1NC0PDD/jy"
    "c438bp698DcXKs8Q2JC4MSGqgrVFjCnQ3n4HY0KKxR2C4BSqwujkM9a9Ta51dXC6vJ7x2RGm"
    "Pr3F/6HERcL9DYpMTw//dekDvXr/hlu9vdgSy8WqHsayw3Q0dzI88pySMAxRNSQSSRKJJL6f"
    "xPdT+H6K0tIygqCMzfwGx7zj3Dx/D4D73U84V9GCdY64SIFs9gUiUbqcCxFxqBZRjZL3K7/B"
    "7MokH1Yy9Pc8ZeD1XfxYgpjn4R0l71f6qh6lz5542NnSRX1lK5/Xppn8mOHb8tbjIwEiSOUA"
    "ntfnQcrBNs4Nvhtc6/8Dh0J8xTtya4AAAAAASUVORK5CYII=")
index.append('css_add')
catalog['css_add'] = css_add

#----------------------------------------------------------------------
css_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhlJ"
    "REFUOI3VksFLVFEUxn/OvHR606BZRCozNkG2yAK1ghYR1KqgZRi0ahW4bCUE4SLaBkFEf0OL"
    "QogiBgobodooCSMKaljmSMWkDvPmzj333BZvmgpauO3Cx12c+/3O4Z4P/vvTViw+8v8qqAqq"
    "Hu8FVYdqAxGHcwJYRARrLQFAb+/xltF7j/faVAzwXlF1rVtV8d4xP1+IAQDGbOO9bxbjB7HJ"
    "NU2/FE+USmWwNooBMVkJwy6y2WFqtQobGwvkcqdQtczNTTI4eJlkMmBx8RWVyiqqFhFDQsS2"
    "yNnsMCsrbxGpk8udZHl5mmr1G/n8GUQMCwsFwrAbEYtzFmsNCecE7wXnLABbW+ssLU0TRRWO"
    "Hj1POt3N+nqJTOYAAwMX2Nxcw7m4qUidQDXCOSEGgXMW5xyl0gtUHUNDV+jrO8HUvWskZt9h"
    "1lbRzgz10+dwoSGw1qAqONfA2oiRkatYa2g0qoThPlSF1Sf32Vv+xJHRMTryx4g+vKRULNCV"
    "rBOImOYEDWZmHv/10y09fcDZ6+Okll7D1B3Czi4O5fopF98TGGNQtXR0pP9Y2++9e++IKj9I"
    "HczDpZutvAQTPeyuNghEIkql54jE6fLeIOJRbaAaJ+9wuIva7DPSk2OYqEwN2N5KUk+307aT"
    "vL8Z7Zlo35O+ld3vgiDxme2vwsdy0jXqentHgBiSHa99/3IjoW39mvBrin94saB3fwI3x48B"
    "j2QMqAAAAABJRU5ErkJggg==")
index.append('css_delete')
catalog['css_delete'] = css_delete

#----------------------------------------------------------------------
css_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhpJ"
    "REFUOI3Vkk9IlGEQh591l1x2NcqERNwFjRBTwfxDRXgx6lYH6VCnrgXdxYg6VOfoFEHHyEOX"
    "CIIOSR7c7BAZSYmmLim5CMWiru5+3zszb4dvXTp08NrAMDAzv4dhZuC/t9j09BP/r4KZYObx"
    "XjBTzEJEFFUBHCKCc44EQGtrb03ovcd7q3oE8N4w01o0M7xX5uffRgCAINjGe18tRg2RSKui"
    "PY8mSiYbca4cASKykUodIpPpZ3e3yMbGAtnsEGaOublX9PRcJB5PsLj4jmJxFTOHSECdiKuR"
    "M5l+8vkPiFTIZgdZWclRKv2ivf0Mt15e4ubzYQ4kGxFxqDqcC6hTFbwXVB0AW1sFlpdzlMtF"
    "OjtHSKebKBS+EaijrbmLO5PXCaSMmSJSIWFWRlWIQKDqUFXuvr6KN0fohVCE1sPH6Wo5xXZl"
    "h4dfHzF2chzVgIRzAWaCaohzZQYGruBcwLOlx5zvvoZ6Q00xPOuba/S2naUUlhmfGeNycpCE"
    "SFCdIGR29kVtHxUJUW/8+P0dZ4KYw6ljK9imLzNMye3yNJ8jEQQBZo76+vRfZzMqUkFUOHow"
    "i5ii3ihsrtLU0MKntRxf1j4zmu4jNjFxw3sfIhJ9l/cBIp43NkslDAktpCIhx5q7Od1xgY+r"
    "75lZmmK0oYcj8RSx/f78iXuxnaHsSGpqcfKni3Fu/T4LwP4B7bfZUR9PBWjHxgPye/k/rR2U"
    "NMh1fdQAAAAASUVORK5CYII=")
index.append('css_go')
catalog['css_go'] = css_go

#----------------------------------------------------------------------
css_valid = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjJJ"
    "REFUOI2tkk1L1FEUxn8zDmUzTKWWouMMSaGQkwutIAIhK1oZFBlBrdu06gvUV2grzL5FGdmi"
    "IgRXSqsMjDElX2is0QwGZ4YZ7/+ee26LecGdER24POfAeZ7z3HNviH+M65mxCRE7Gf6b5vtv"
    "b/XefXn7cqO+lrly09rgeaKruy10EPnB9MQZG9hBY80ra/WGNXutgXOvuzu7WjY2c6UDHQQi"
    "bSYwU8mTvWEbBB8C1elTvcmWjc1cyUt4ODQ5/8QDqHpUFaeKOocVQcQhYvm1t0velzgWj1Ou"
    "VPiZ32Iw1sUhwkQGNUFPz7nmRO893mv9eLwXvFc+73wl82WKkA/x9OJDTrQeZWlphkiDaEwJ"
    "72suamSHqmvi6dYOHp+9A1454gTnLNZWawLeK6pKNHqcZHKYSqXA9vYyqdQFVC2Li29Ip8cZ"
    "aomwsjJLofAdVYuIISxiUXWoCsnkMOvrHxHZI5U6z9raHOXyb/r6LiFiWF6eIRptR8TWHRjC"
    "zgne1ywBFIt5VlfnqFYLDAyMEYu1k89nicc76e+/yu7uD5yrDRXZI6xaxTmhJgTOWUQs2ex7"
    "5uczeO9JJIaYnX1GLveJdHocVVvnGCLWGlQF5wKsrTIycg9rDUFQJhrtQFUoFrcYHX2EqrCz"
    "8w3npH5tR0TE1NUCFhZeNPfRaNj/Et675sJrKESMMahaDh+O7WvWeq7NuvEvoIEegIhIlWz2"
    "HSIWEcF7g4hHNUDV1e0K4Ov4n+MPYk/BOUmcYdEAAAAASUVORK5CYII=")
index.append('css_valid')
catalog['css_valid'] = css_valid

#----------------------------------------------------------------------
cup = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAklJ"
    "REFUOI3Fk79rE2EYxz/v3SVN0yalF/BIxaC1CFKoQsGIYLG9FoqjoJOSri5uTuLkWPBfEHGs"
    "m4ODCMFBpUtbpwshWA017RFsk7tLetfc+zqUhAql4OSzPQ883+fX54H/beKk4zjOjBDiqZQS"
    "pRRSyoxSCsDrx+I4Xp2dnf32l0ClUplTSr1JJpOFbDaLEMe6Qoi+EABSSprNJkEQ/FRKPSoW"
    "i5+E4zg28MGyLNHrePzY+Irn/qLtNuiFXQASqTSZc3my1nkK14qoxBC1Wk1JKZeE4zgblmVd"
    "Hx0d5f3L59S+fDxz5su3bOYfP6Pb7VKtVjf1Uqm0ur29PTQ5OcnUzTsEXguAOApRvR5CaAxl"
    "xsgVprh4Y44rc3cZHjORUuK6btqoVCrtxcXFTBiGJBIJbpeeoOs6AEEQnNqF67rouo5Sqmns"
    "7+9/tizrPoDv+9TrdUzTHIgAg0WGYcje3h65XI6joyOklO/0brfbXllZeQjQarXwfR8pJXEc"
    "E0URYRjS6XTwfR/P8zg8PMQ0TXZ2dlBKLRlbW1vtfnXXdRkZGcEwDJRSg8qapqHrOrquUygU"
    "MAyDXq/3e2Fhwdc8z5PVanUznU5jWRYAmqb9ldT3x8fHSSaTtFotpJQv+iANG4Yxs7a29mp6"
    "evpqEATk8/njS8Rxnz4SiQSpVIrd3V0ajUbZtu35kygLIF0ul18bhnFvYmJCmKZJHMf0ET44"
    "OKBeryvgrW3bD079BYD19fULURR9V0rpUsoBxkqpOIqiS8vLy/UzSftX+wM9djfziZ3Q7AAA"
    "AABJRU5ErkJggg==")
index.append('cup')
catalog['cup'] = cup

#----------------------------------------------------------------------
cup_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqFJ"
    "REFUOI3Fk09oVGcUxX/f+2Yyr5NMJBPqU6zBxj/VgIltWpMGDSlJEFwUsnApwV2r1I0IgrgP"
    "iF26cOuuUChxYVHKQK3RjouE0LRvnA5JDEyTlyGT+ObN+GbefNdFUQzabj27e+H8uOfAhfct"
    "9ebgum6vUuqyMQYRwRiTEhEA/9Wu2Wxe7+/vn98GyOVywyJyu6Wlpau9vR2l/uUqpV6BADDG"
    "UCqVCILgmYicHRgY+FW5rjsK3HccR0VVn+XZx/hekefeP0RhDYC4nSS1czftzh66+gaQeIJC"
    "oSDGmHHluu6s4zjH2trauPv9NQqPfvnfzPuHRvnq26vUajXy+fycnpycvL60tJTo7u7mwOAI"
    "gb8FQLMeIlGEUhaJ1A46uw6w7/gwh4ZP88GONMYYPM9LxnK53POxsbFUGIbE43FOTl5Eaw1A"
    "EATvvMLzPLTWiEgpVi6XZxzHOQNQqVRYWVkhnU6/hgCviwzDkLW1NTo7O2k0Ghhj7qiRkZFT"
    "mUzmZ4D19XU8z8O2bWKxGCKCiBBFEb/nM8w9e4hf26LeCPnkw88Y/Hg8pTo6Or7c2NiYqVQq"
    "LC8v09raus1sjOHBn3dZrD6h/8jnfJQ+SGbhJx7/8YDFv0s3LN/3TT6fn0smkziOA4BlWViW"
    "hdYarTWZhTscO9xH02rSt3ucpmoweHQIkAtWFEXzPT0930xPT/9VLpfZ3NxEa00sFkMphWVZ"
    "rG+tEldtfH3kOwAujd5i/85eFMq2gFoURdmJiYkvisXij0EQSLVaxbZtbNsmkUjgB5ssFGeY"
    "un8OgKl75yh48wjyYtsvAGSz2b31en1RRLQxBmMM9xZ+4OmLDEO9Jzi461Pyq7PMzP/GyuLW"
    "jbcA/6Xj53dNodR5BSkBH5Gb2ZurV14C3e1METMqVboAAAAASUVORK5CYII=")
index.append('cup_add')
catalog['cup_add'] = cup_add

#----------------------------------------------------------------------
cup_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqFJ"
    "REFUOI3Fk0FoVFcUhr9775tknGQimZS+NiVpTKOLCK0SMLbQMMWotHRjoYgLybIKVnAhtEi7"
    "LAWhW1ddiNpdESKlrVEy2KISBCXS5k2H0YkxmrzETJo3L9M3ee9cFxJpaOu2/+4/cD7O+TkH"
    "/m+pvxvP895USp0UEay1iEjWWgsQrNeSJDk9MDAwuQFQLBaHrLXnmpqautva2lDqGVcptQ4C"
    "QERYXFwkDMMH1trDg4OD15TneXuAMdd1VbwaMH37JoH/iBX/MXFUByCVzpB9+VXa3NfofmsQ"
    "m2qmXC5bEdmrPM+77brujtbWVn785gvKN66+cOc33tnDe0dPUa/XKZVKd8zIyMjpSqXS3Nvb"
    "S9/uPGHwJwBJI8LGMUppmrOb6ejuo2fXENuGPmDT5hwigu/7GadYLK4MDw9noygilUrx7shx"
    "jDEAhGH4r1P4vo8xBmvtolOtVq+7rvsxQK1WY2Zmhlwu9xwCPA8yiiLm5+fp6OhgbW0NEbmk"
    "8vn8/vHx8Z8AFhYW8H2fdDqN4zhYa7HWEscxQeEC4bXvaDyuoF9yYceHqN0Hs6q9vf3tpaWl"
    "67VajenpaVpaWjY0iwgr4+dh6me25Q/QvGU79cnL/P7rVZanfjuugyCQUql0J5PJ4LouAFpr"
    "tNYYYzDG8GTsW7bmD5AuF1BnD5G5d5Ge7nYS7Akdx/Fkf3//kdHR0alqtcry8jLGGBzHQSmF"
    "1hrxZ0m/sgU+HYWvl+Dzezihh7GqZ/2UFZApFApnHcf5qLOzU+VyOZIkQUS4e2wnu/btp+XB"
    "D0T1OVaBYMUwVWZ2wy8ATExMdDUajfvWWiMiiAj61vek/xijK9fA0Q8JFmIqcyZp/CVf/gPw"
    "X/rlYNdnq08efaJFvS7azgr2zPtX5KunNqFJ5gM1CoQAAAAASUVORK5CYII=")
index.append('cup_delete')
catalog['cup_delete'] = cup_delete

#----------------------------------------------------------------------
cup_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArpJ"
    "REFUOI3Fk8trVHcUxz+/uXNnknnGGOdqpIlOIhJCDTYNcWF0hokt2sdG7U6CSxHctNI/wEUV"
    "uy/Y2lKyCaQBF4ILH4yvqIiaWNQZhpE8dKbcjBkzd66TO4/frws7JVKy7tkczoHzOXwP3wP/"
    "d4i1RSqV2iWEOC2lRCmFlDKolAKwmr1Go3F+cHDw6QeAdDq9Tyk17vF4ukKhEEK85wohmiAA"
    "pJQUCgVs215QSh0bHh6+JVKpVAK4ahiGqL+zmH9yH8vMUTLz1J0KAHqLj2BkCyFjK10Dwyjd"
    "SzabVVLKA27gR8MwRCAQ4MqFc2TvXV9Xb2e3wl/sRQt8TGvhpnA2jvyqjY2NnZ+bm/NGo1F6"
    "98SwrRUAGlUHVa8jhAtvMEzfUJCh+B42bP+Kzk8O0uIzMJ9cC7nT6XRpdHQ06DgOuq4zMnYK"
    "TdMAsG0bgPqba2jV5/iDu1nOvsAjqgRDmwmEI7iLxeK0YRhHAcrlMouLi7S3t/8LkSv30Vef"
    "Eo5+jpOfwOMTzM+kqDU0ipti466pqamLTY2VSgUpJeVyGdu2sXI30CvThHsOsZr7GaEX0QNB"
    "WhoFSptHkf4tJ12zs7Ol5nbTNPH7/Xi9XqyFG7RWHxPu/ZrV1z/h0mtUS9swb8/g/vRbqp6O"
    "5Xg8XnZZliUzmcyMz+fDMAwArIUkWiVFpP8Lqn/9guZROKVuzDuP8SXOUtY2IaU80zRSq9vt"
    "3jU5Oflbf39/3/yjS3SG31IXETa232VDxMPqykcsP3xB22c/sGRDPp9PJhKJ+ForC8CXTCZ/"
    "Nx+cOXz0xEXSE9+Rm5vG2zUAtqRj//e8WlEK+CORSHzTvJvrn6wAOxaLHUln8vXqs8tsHxjB"
    "799JbiaDs+MYr0s0arVa99rh/zwTwJG9bZXBHsM91BdF6c60s7R0/Muzf75cz51/A4HaNAlx"
    "1ICiAAAAAElFTkSuQmCC")
index.append('cup_edit')
catalog['cup_edit'] = cup_edit

#----------------------------------------------------------------------
cup_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq5J"
    "REFUOI3Fk09oHHUUxz+/mf2X3ew21rbTok0xWoMRa8seIsVql0a9eNGCF5Fc9eJB8FR78OAl"
    "BY+e9KDFW3NZD0JEjSIqW2uzgbqzLkvSQFsc153Nzkymm8y856EEUwSvPvgevo/HB77wffB/"
    "j9lrXNc9YYx5V0RQVUSkrKoAwe4uTdNL1Wp19T5Au91+TlUv53K5yUqlgjH3uMaYXRAAIkKv"
    "1yOKog1VfWN2dvZ747ruOeArx3FMshVw8/rPBN5tht4dklEMQLZQpHzoCBXnISafnkWzebrd"
    "rorIC8Z13euO45wcHx/nyw8v0v3p6//M/Ojpc9TeukAcx3Q6nRV7fn7+0vr6en5qaorHnjlL"
    "FGwCkG6P0CTBGItjTzlUX3yY8tFnOX7mZcb27UdE8DyvmGm328O5ubnyaDQim81yZv5tbNsG"
    "IIoiNL3LsLVA+fBp9kcDSseO43ketm2jqj3L9/0fHcehUCgQxzFra2v0+302NzdJkoTo1hKl"
    "A1UqR04RbnxL98Z32LbNzs4OIvKFtbi4+MluvjiOERHCMCSKIoJel/DmEuUDE6TDOoeefB3r"
    "z2/IZiw8zwN4z2o2m0OAMAzxPI9SqUQ+n8eyDDt3ljg4/Qrc/ZXGZ58zPhFj/N9I/mqSJEm/"
    "VquFVhAE0ul0VorFIo7jAGBZFumgRU5HlB/YQkZroEIaXuWRs+/Qb16GbX8BwEqSZHVmZubN"
    "er3e8n2fwWCAZZSoc4WJyZPI1ioqMdXz08j2bQqF3zk49Ty55gf5vVU2QHF5efnTTCbz6oNp"
    "yxRNwOHHx0jDBqrbXFtsUT3/BMbeB2MvcfXjC55JpHbfLwA0Go2j8svFjROvfYRtraOJD+ie"
    "Cwt7bJo/bqzQrr9/5V8AgB8WTvU0kaKKoiL3pMo/XkEERK/9DR+wZXpo+af/AAAAAElFTkSu"
    "QmCC")
index.append('cup_error')
catalog['cup_error'] = cup_error

#----------------------------------------------------------------------
cup_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq9J"
    "REFUOI3Fk81rVGcYxX/v3DvJmGQm4NfVmKR1YgUjxkDEiNYwJdHSLlrovgzd6UIXRV34sRAU"
    "F4Ib/wJx6you1LY2QdJUh1KTLNo7HYaJitHexEwmM9eZufe9z+tCIkrBbc/uOYvf4YFz4P+W"
    "ev9wXXdAKXVaRDDGICJJYwxAdc2Loujq0NDQ3AeAfD4/Yoy52dLS0ptKpVDqLVcptQYCQERY"
    "WlrC9/2nxpjvh4eHHyjXdUeBnx3HUfp1lSePH1L1Flj1XqCbdQDiiTaSm7eScrbRu3cYE2+l"
    "WCwaETmiXNd97DjOYEdHB3euXaD4+/2P/tx3cJQvjp+jXq9TKBRmrGw2e3V+fr41nU6z40AG"
    "v1oBIAqaGK1RKkZrspMNvTv4dP8IO0e+Zl3nekQEz/Pa7Hw+vzo2NpZsNpvE43EOZ09iWRYA"
    "vu+/S75451v85gyXe7J4nodlWRhjlmLlcnnacRwSiQT1ep1SqcTy8jKVSgWtNVprwjCkoQO6"
    "N+7ixK0MwltPRG6rTCbz5cTExF2AxcVFPM8jkUhw/dEPGAkJRBNoTdf6zxjo/pzc/K/MPc9x"
    "Zu8NLOJJe3Z2dhWgVqvheR7t7e3Yto2WgCO7s0RGiCRCMCxUnrGn+xC1oM7Zh98QqYZlV6tV"
    "KRQKM319fYOO41Cr1YjFYjR0QGSEJ68KhKLREhJGIavNKoM9h6mFr3lUmnoV01rP9ff3Hxsf"
    "H/+7XC6zsrKCZVk0dAMdaZxUL1tSn7C1M03cWsem5Db+fPYbU8WpRT9k31qVFdA2OTl5w7bt"
    "77q6utSpe2M0goBAAho6IL2xnwPpo/zxdJpf8j+9DCJGX17hrw+2AJDL5XqCICgZYywReVfj"
    "H6e/YqD7EJP/3H8eKkYXLpH/z5g+pu3n8SNjtTWJ0v9eprTmvwF4sGf3/agM2gAAAABJRU5E"
    "rkJggg==")
index.append('cup_go')
catalog['cup_go'] = cup_go

#----------------------------------------------------------------------
cup_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAq1J"
    "REFUOI3Fk0FoU3ccxz//914STdpEO+mzVYN2BdFCp0TMlE0cttCz4KUqKWMMdtltXmTHISh6"
    "lV2U4kG0Fj1MBIvS7VBnL9qBy0tiamrE1iwua15eXt/Ly//vQVqUOa/73n4/fny+/Pj9vvB/"
    "S7xbWJY1KIT4QUqJUgopZadSCsBe7bXb7XOpVOqP9wC5XO6QUupKOBxOxuNxhHjLFUKsggCQ"
    "UlKtVnEc57lS6mQ6nf5NWJZ1BJgyTVMETZuFR79jV15SrywSeC4AoXVROrt7iJtbSH6WRoUi"
    "FItFJaUcFpZlPTJNc09HRwd3LvxI8cG9j+786cEjfPXdaVzXpVAoPNYzmcy5UqkU6evro//z"
    "wzj2MgBt30MFAUJoRDoTfJLsZ286Qd+OFWTLR9/QT6VSiRq5XK4+NDTU6XkeoVCILzPfo+s6"
    "AI7jrDk3s9eI6FkSu0f56+FFXrshlNpcNWq12oxpmscAGo0G5XKZrq6uNQjASvEXIq0ZEruH"
    "cRbuEI4lCc3fwKsn87rruvWxsbETAMvLyzQaDaSUtNttfN/H8zyC0k269w0hXQsjtgXp19mw"
    "04SnM93G3NxcfdW9UqkQi8UwDAOl1NoJVdikVSuh6VWE5hCOV2GlSePliqbZti0LhcLjaDSK"
    "aZoAaJqGpmkIex4te4b1xjwyeAKtF9BaQnlNslfzQTa/9K0A1huGMTgxMXF5YGBgl+M49PT0"
    "0CrfJ1i4jbn/EMq/i2jbZKc89GYIZMt/kn02enz8+eTqKwsgOj09PW4YxtHe3l4Rzp9l0+AB"
    "/OpFDCOB9avPAodVPLnnVmTy68wXl17b/8oCwOzs7Dbf959t/vuSvi3dT/DPA/6csllcNyzD"
    "W1PbR0ZGyv8Zpnf18Hzqp46NG79xak33af7VqdGfi9c/NPcGKaZLcEMEB5sAAAAASUVORK5C"
    "YII=")
index.append('cup_key')
catalog['cup_key'] = cup_key

#----------------------------------------------------------------------
cup_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsVJ"
    "REFUOI3F089LI2cYwPHvO5k41agJxnasFS0mFKpYtwi1BOsP1raxtwoLsiBSodJeerGelv0L"
    "Vnr27m0vgntooRZJF2pBh1330kmCoElMzBjX1jjVMZP37aEoFcpe97k97+HzPO/D88DrDvHf"
    "xLbtD4QQS1JKlFJIKVuUUgDV67d6vf5oaGjoxS0gnU6PKqVWGxoaultbWxHiX1cIcQ0BIKWk"
    "Uqngum5OKTU7PDz8q7Bt+y7ws2mawv+7ysGz36k6Rc6cEr53AUDwjSZa3nqbVvMdugeHUUGD"
    "vb09JaX8VNi2/cw0zTvNzc38+MND9rZ+eeWfY4m7THz7gIuLC7LZ7PPA3Nzco/39faO3t5f4"
    "x+O41b8AqF95KN9HCA2jJUy0O867H43y3ugXNIbbkFLiOE6Tnk6nzyYnJ1s8zyMYDPLJ3HcE"
    "AgEAXNf93y4cxyEQCKCUquinp6e/maZ5D+D8/Jx8Pk9bW9sNAtwM0vM8yuUy0WiUWq2GlPKJ"
    "GB8f/3xzc/MngOPjYwqFAplMhnw+TzQaxXEcEokEjY2NbGxsYJomJycnhMNhDg8PTX13d/fs"
    "unqxWCSVSqFpGrOzs7iuS6FQYHt7G13XmZ6eRtd1SqUSlmWxs7PzvV6tVmU2m30ei8Xu5HI5"
    "HMfh3v37rKysYFkWHR0dDAwMUCqVWF5e5ujoiMHBQZLJJAcHBwua7/sv+vr6vllfX//DsixC"
    "oRAA8/PzXF1dMTMzw8jICFNTUySTSTzPI5FIPAWIRCLG9SoLoGlpaenp5eXlh18tLLD2+DFb"
    "W1tomnaDuq5LrVaTkUhkY3Fx8bPV1dU/b91Cf3//+/F4/MnExESsq6sLTdMol8tkMhkMw6Cn"
    "pwfTNPF9/2Uul9NSqdTRLQAIjI2NDYRCobXOzs43DcMIKKW0SqXytRDisL29fQ0Iep5XLxaL"
    "x67rfvkPBzZQhBiV7eYAAAAASUVORK5CYII=")
index.append('cup_link')
catalog['cup_link'] = cup_link

#----------------------------------------------------------------------
cursor = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZZJ"
    "REFUOI2d0D1LQmEUB/B/3UtZDi0O4rt4/QAXh7boA/QVmkUI4vpQBkESJFqQBoGbq9Cgtggu"
    "TupyIYWLk1MERiIIDqLe58WmIC6Z5RnPOfz4nwNYStf1K2vvt9q0NoQQ161W63ptgDEGh8Nx"
    "Va/Xb9YCOOfw+XxwOp2X1Wo1vVYCAHC5XHC73ReVSuXu3wDnHJxzeL1eeDyes2KxuBT5ERBC"
    "gDEG0zTh9/sRCATOCoXC/b8BSilmsxmCwSAURYnn8/mHPwNfZwghAAChUAjhcPg0m80+rgRk"
    "WYYsy5AkCZIkoVwuT0ql0othGCal9CSVSj0uBSil6Pf7qNVq89FoBLvdDkrp7nw+PyKEbCcS"
    "iQ2bzXauadrO0gTNZvPDNM2DRqPxOhwOoarqxmKxyHztEEKmuVxuugzQhRD7sVhMZ4xp3W4X"
    "qqqCUnqcyWT2Vj5xPB4fRqPRNwDQNO251+t9DAYDRCKRzclkoq0ECCFTS6LzTqcDRVHAGIsn"
    "k8mt73PZCvxw0pNhGLftdvudMVZNp9Pm9/knqKDhmC8VkJcAAAAASUVORK5CYII=")
index.append('cursor')
catalog['cursor'] = cursor

#----------------------------------------------------------------------
cut = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjtJ"
    "REFUOI1jYMADVNKna9lWLZvHkDaTFZcaJnwGSIvw2XuZqLrJvP/CgiJRXw/Xh9cAFiYWVjE+"
    "TpGvgjxsMDGltJm6Pqz6m4kygJmFiU2Qh4udg4GBn4GBgUEqqV+9IMBiu7QwDyPcEnwGsDEz"
    "sgvxcDAw//3NJhjeI1sf7rz17z+Gv+tO3EoizgXMzJx8XOwMTCzM9nXRTuu0ZEQUOjYcjXq9"
    "MOcFPn1wENy5qfPyo4//+zaf/3bn5df/ZmWLctDV4HABJJTZ2JiZuNhZGNSkhDlbVx9eeKor"
    "bgq6SpQwEHZJkpJXsZrILyaq/urVvEt87Gyan7//Zlh1+MqxRetPpmCzCm6AqH2WhK6l20E5"
    "XR2Vz18+f1ExtdQ1Yn/HIMjNwfDjx/fv3L+v235lYNiPbgAzjKHhlbZA2cjAatfy6Q4Pr5zb"
    "rqxvGSHP9Y/h+U9Whle8ikoqembx7779evrpztlzWMNAXFHJ7fHNyztfbJp4SEZZ04ONmZnh"
    "5pO3/w89+cZwdNmSQx+e378ip+YxgcHengOrAb9//Pgqpapn5NC49qiJZ1jGhb37bx4+/fjt"
    "yyf3v1xZnGt/8+T+xWycnNxCP8WEsRpw8+LB/O9fPrBIqWhZXti288yVE+sd/v35/Y2Nm5ed"
    "Q8tFjl9EQu3f379//37/9RVbYMIDUtw9XQHG14ubdyx50/P//hP3P01affe/YeLCG+h6GNEF"
    "UICKB7uBbcQFPhFRhW8f3r28cW6lyZezW94gKwEAu8TLuuvYe8AAAAAASUVORK5CYII=")
index.append('cut')
catalog['cut'] = cut

#----------------------------------------------------------------------
cut_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjFJ"
    "REFUOI1jYMADVHLnGDrVrVzIkDaTFZcaJnwGyPJxW3gYKdnLvP/CgiyuFVrPRpQBbKzMbCI8"
    "XOLMXEzsMDGljGk6itpaR4kygJmJiU2Ql5ODkZmVn4GBgUEkdrJapLXufgkBbuK8wMbKxC7E"
    "w8nwl4mBRyiuVzrf0/CgkqTQt/+MTNOJdAEzBy8XOwMzA7NVpovpfkdDFbGNx67OmpfvNQ+f"
    "PjgI797UeeXRx/99G89+efD663+vuqVz0dVgdUE9VJyZiYmdk4OVQU1GhLt20Z4D25qik9HV"
    "okRPtwCDvLSYVJUIn4DxnOfP9p7lZrf5/O0Xw6rDV4/tOn/LB5tlLMia9VS1d4gJCmr8/vHt"
    "s6yhvvE/FVkGQS42ht+MLL+Y2NkNGBj+H2NgYPyP1Quy4rK1woICGodOn7E+duVK4t8/fxiY"
    "GJkZjj76wdC6u81hx4MVR2ZK8GfgDAMpUZGAhy+eb8h//+OYhJCI2z8OdoabT9//N2gOZjhy"
    "5dq891+/XFVRkC+rl2TgwmrA77//PskICpttMlA5ZKqmmnbr1t3Dtr1RZz+8/fCZ48GrtDuP"
    "Hy/m5uRSEPjGLobVgFsPHrT++/tXWFZQ2Pbsvfsb7z14GMb0798TVmYW7gdcDKLcPFxyf//8"
    "/fn3788v2AITGpAc8j28bGqrGBiYGRgYGGZJCxXc9Hb4v99U++5Fd9v/K9Vkl+DUjA3USzJw"
    "LVOTnn/SzuT7el2lnR2cDDLoagC6MLeyQGvuwgAAAABJRU5ErkJggg==")
index.append('cut_red')
catalog['cut_red'] = cut_red

#----------------------------------------------------------------------
database = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdVJ"
    "REFUOI2lkr+qGkEUxr/dHdllJaTyz2IhwQRiAml8ijS3uSBJlzewsssj5BFMEVME8wCCYEgT"
    "sNzGIkUaBeVqsaILsuvMOSfVLF5UUuQ0M2fmfL/zHWaA/wznPBmPx75S6g7AeyJ6KSIvADAz"
    "z0Xkj4h8zrLsR7fbpQvAdDp9xczfqtXqm3q9jnK5jDAMISLY7/dI0xTL5RLb7fYXM7/rdrur"
    "R1Ymk8nPxWIhzCy3QmstcRzLaDT6YnXuGeN1rVb758yNRgNE9Nbmym6YGSKCzWaDIAjg+z5K"
    "pRJEBMfjEUmSYLVaodVqgZlxASAiiAiUUtjtdsiyDCICYwwOhwPyPIdSCiICEbkE2AvP8xAE"
    "AZRSUEpBaw1jTCFiZhDRJcCOYIwpRI7jgIiKM9d1ISLXR7AOrMAYA8/zQETQWkNrDc/ziiY3"
    "HdhiIioA1oFtchPAzEV3C7SrnZuZked5ASj+gTEGSZKgUqnA9/1Hb+84DqIoQqfTwXq9vu6A"
    "iD7MZrPv7Xa73Gw24fs+HMeBiCCKIqRpivl8jjiOH4joroCfdxoOh8+Y+aOI3Luu+zQMw8JZ"
    "lmUPWuuvnud96vf726uA8xgMBk9Op9NzYwyLyO9er5dfq/sLg994i8xMQqcAAAAASUVORK5C"
    "YII=")
index.append('database')
catalog['database'] = database

#----------------------------------------------------------------------
database_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI2lkzFoU0EYx//33oX3SCyK2DSlQpBYaJS2ukgp4qAUcekiBN10tTg52KGLKKiDawep"
    "iAGROIhTIdJSh9CIKFHbQouKNCWlKZqYxIaX3N33Ob2QEMXBb7rvjv/v/v/7OOA/S7Q38/Pz"
    "jpRyEsBlY8wQMw8CICJaZeYvzPzI87zFRCJhugALCwvHiOhZOBweiUQiCIVCCAaDYGZUKhXU"
    "ajXk83ns7u5miOhSIpEodFhJp9NLm5ubTET8t1JKcS6X41Qq9cTXWW2M4319ff/MPDAwAGPM"
    "Bb+X/oKIwMwoFotwXReO4yAQCICZUa/XUSqVUCgUEIvFQEToAhhjwMyQUqJcLsPzPDAztNao"
    "VqtoNBqQUoKZwczdAP/Atm24rgspJaSUUEpBa90SERGMMd0AP4LWuiUSQsAY09qzLAvM/OcI"
    "vgNfoLWGbdswxkAphfXie3z9uYJfuSrq9b1D528Oz6Tvr9zpcqCUglIKxpgW4MNWBj8CGzh7"
    "ZgyHDw5iae2leLNavH1qqv+A1Q4gotbt/qMSEd7lX+PE0CiMZTDaPwEjFMaGxwHwVAugtUap"
    "VEJvby8cx+mY/fdqEQGxD5Px6wCAG+ceIhYegYBw28d4JZvNPo/H46FoNArHcSCEADOjtlfB"
    "2vYyPm5nMD3xGPdeXYVrO2Cw1/GZksnkESKaYeaLlmXtDwaD0Fpjcf0Fyj0rGB85jcHISXze"
    "yWH5UwZb3yoPOgDtNTc319NsNo9qrYmZ159u3L0FIa4JoIeBGphn387uTP8GbcWBhGWdLyMA"
    "AAAASUVORK5CYII=")
index.append('database_add')
catalog['database_add'] = database_add

#----------------------------------------------------------------------
database_connect = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqtJ"
    "REFUOI2lkk9rXGUUh587988kmYTUFpPcpoPgNCUYMIhIzUqhmwoScWFo136A4CrgB3BlltlI"
    "3CgoRNBdcGRCNloIIkEYix3qlEyStkzDpHfu3Dv3vfd93+MiWIoNuPAszwMP53fOgf9ZznnN"
    "7e3tsud5y8BtY8y8iMwB1lrbFJH7IvJllmU7Kysr5gVBo9F4zVr77dTU1OszMzNUKhXGxsYQ"
    "EaIoIo5jOp0O3W73Z2vtrRcE9Xp9d35+/t1qtYrjnDsgWmuazSatVuur0jl8YXp6+j+zz87O"
    "Yox5z/s3KKxf2tvbI0kSlpaWKJfL+L6PiJCmKb1ej+PjY2q1GtZangm27nRGB8ORbx5GnYtV"
    "nhAEAY1Gg4WFBUQErTX9fh+lFJ7nISKIyJlgd1e8+8mj30d8O+e/FPLHgy6vXuhjjKFSqeB5"
    "HlprtNaICJydBGMMJYCWfng5U2ZuLADXsbgX57hzUCasvUG9XmdjY4OiKNBaUxQFxhhEBGvt"
    "mSCK81mV5wyznMMnCb5rCS5c5osffkUpxeLiIuvr6+R5/kz0T6wSQJJkL6dZTpLlDNKMB4/6"
    "jPgQvlLjl3sp7XabMAwxxpwviAbDa3mhSLOCfqqIk4zWUY+nsWL0ypv8+Jtl+YMPERGMMWit"
    "sdaeLfSjrWZwehB9dmlynJMoYbxcwi95BC6oouDo4IT3b7xF4Ls4jkMYhlSrVdrtNlprPO+v"
    "08FoxfWN1iRDxeFxRHyaMBxkZAPF1bDCx7euE/guYRgSxzHNZpP9/f3Hxphl72mS7rgEN++e"
    "xBwd9oo8HX46PWGj69dYvjTpvDM5nk/sNH5Ca02v1yPLssdFUXztuu7na2trXeftT7ZG3YHz"
    "vRmqG30VjN/9biV//jM3Nzcn8jy/qrW2IvLn6uqqep7/DQMWlkpAltvuAAAAAElFTkSuQmCC")
index.append('database_connect')
catalog['database_connect'] = database_connect

#----------------------------------------------------------------------
database_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkRJ"
    "REFUOI2lk71rU1EYxp977gn3coMK1SaRiGmJX7Xg4F/g4GAdHBSCxcVN0KlODiIOIg7uLnVo"
    "F62LpWIwNaLgR4eCKSJSRMVGU5KINzTB5CbnnPd1kHtNieLgO533HJ7feZ7zAfxnWf1NPp93"
    "pJQnAEwaYw4w814ARERvmfkDM98OguBJLpczA4BisXiQiO4kEolDqVQK8XgcnueBmbGxsYFW"
    "q4VyuYx6vf6CiE7ncrnKJiuFQuHp2toaExH/rZRSXCqVeG5ubibUiT7GeDKZ/GfmdDoNY8xE"
    "2MtwQERgZtRqNbiuC8dxEIvFwMxot9vwfR+VSgXZbBZEhAGAMQbMDCklGo0GgiAAM0NrjWaz"
    "iW63CyklmBnMPAgIF2zbhuu6kFJCSgmlFLTWkYiIYIwZBIQRtNaRyLIsGGOiOSEEmPnPEUIH"
    "oUBrDdu2YYyBUgrW6wdAaQHva1+Q8rZuf3RUXDpWpBsDDpRSUErBGBMBaHkeQ/Vl7D9zAc7o"
    "ODpvFsW754vXHvPqD9EPIKJo9/BQiQjBy7vYd+Qk3I/PYM1Mwvt0HyOZHbYBT0UOtNbwfR/D"
    "w8OoVqvodDpRTuHX4KZGgeMXf2e/uhM2WyP913h2aWnp3tjYWDyTycBxHFiW9ettJFJorzxE"
    "fOE8up0q2gBaTRvGxvqmzzQ7OztKRJeZ+ZQQYpvnedBaI1aax67GCnYP9SDFV7S+aXyu2qYX"
    "0JVNgP6anp7e0uv19mitiZlXD7+6OdX+vn5OkJUhwRUC35oo0vWf9KCIeh8RMJgAAAAASUVO"
    "RK5CYII=")
index.append('database_delete')
catalog['database_delete'] = database_delete

#----------------------------------------------------------------------
database_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqtJ"
    "REFUOI2Fk0Fok2ccxn9f8iZfSFNzqG0zA0rWDacyRRAHbscduimyy8IGwobbRWEXWWWM3cYO"
    "evXgYXqwHmZvDkahrGUrqwbRrd2mqEutJiytifOLTZrkS773ff87TGs6K/4uL/zheXgeeF6H"
    "x4yPj7tKqYPAh8aY10TkVcBaa6+LyLyInPV9fyqbzRq6cAAmJye3W2u/GxgY2JlKpejp6SEe"
    "jyMiLC8vU6/XKRaLVCqVGWvtB9lsttRtwsTExE+FQkGstfI8giCQ2dlZGRsbO9etDT1+dwwO"
    "DvIi0uk0xph3um+K/4oiIpTLZWKxGK7rEolEEBGazSae51EqlRgaGsJayzMGxhhEBKUU1WoV"
    "3/cREbTW1Go12u02SimMd4k9zg/9+e+/kcY/0+CXPlIAIoKIEA6HicViKKVQShEEAVprRISE"
    "zqEqHqnXD5HM7ObR3a3cnDhzck0FrfWqyHEcjDForXH9HFs2tUgk38S7c5Oo06F3Q4pE3+bk"
    "mgRPBFprwuEwxhhU6zcym+okXx6mvXSBaNyhMHeLTqv90G+v7At1JwiCYDWB1hq7fIVMX5Hk"
    "0H78xW9xIlUiiV5ijfmybZTffuOzi3+tVrDWPhVaS704Rap3geQr7+GXThOKaDq1DIs/XxU6"
    "zQO7j03Pre5Aa43nefT39+O6Lq3FGdxgnoEd++ncP0M4KrRrWyj/8itTzX3VbceuXlszJGPM"
    "x7lcrpHP56nfnSZh/yawaZb+PIXFp+GlWZr5gx/rex/UdHT4mb8AMDo6mrHWfhUvnz/8/pGz"
    "3L7wOYv3LuNu3kXrQd3ei+49Vw299MXIyEhlXYMnfP3p9uD4J0cVIcPc5EUKC/mVDRuTbw2f"
    "uPH7evMO///QFw++LCzcQK88tG3XzISww++euH5rPTHAv5qhoZeywxTuAAAAAElFTkSuQmCC")
index.append('database_edit')
catalog['database_edit'] = database_edit

#----------------------------------------------------------------------
database_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI2lk99Lk1EYxz/ufdfW1kSp+RMssTKsLOsmuqmrIIggglFB4H1XdR1El/U31IWDCCG6"
    "kJIEox8IQjJdUUQa5EaTZjZb6ny395zn6SJmLpMu+sKB83DO+Tzf7zkc+E/VrS+Gh4dDruue"
    "BS5aa/ep6h5AROStqn5U1bue5z1NJBJ2A2B0dLRHRO43NTX1trS0EI1GiUQiqCrFYpGlpSWy"
    "2Szz8/NjInIhkUjkaqyMjIw8y2QyKiK6mXzf16mpKR0cHByongusY+xvbm7+Z+b29nastaer"
    "tVudiAiqSj6fJxwOEwqFCAaDqCqlUolCoUAul6OrqwsRYQPAWouq4roui4uLeJ6HqmKMwS+m"
    "ifppcE6hqqjqRkB1wXEcwuEwruviui5+eZnywgTbO05Qnk0jcgBr1x7h9x1UIxhj8H0f3/ex"
    "1mK+vqCx7Rj1rX0EV15jl2drIgT+dGCtxRjza6zMUfnynNiOBuyPIVoPXmY18whrKps7qHY3"
    "xqf8+Qnx7nPgTfIqeY9tDat4cynqZTb0V4CIrHW3xfeE6irEGktI+ROoYJcn6Dx5jZbKZHTs"
    "1vFYDcAYQ6FQIB6PE9riINnHNHQcRkpvUFnl6PlupDJHODzNrkNnHPCu1gCstf3j4+MrMzMz"
    "BL+naGzrJRJbQM03qHNIPZwGBPGmie/dia1Urry80dNT85mSyWSniFzf/WOg/8ilOwEnMIua"
    "RUDX7QrgbO0m/y7Nh6GbD2oAVY3d7ltQIxGkLqAiiBhRVVQUFUFFQQREUz8BEx6BydrVaSAA"
    "AAAASUVORK5CYII=")
index.append('database_error')
catalog['database_error'] = database_error

#----------------------------------------------------------------------
database_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAptJ"
    "REFUOI2FU81LG3EQfdn8bJZIo2CiiR5K1zaWCMWPqyAUahFsqRQWe/RUwUP/gd78Dzyblnqo"
    "eLUSKkSC0IPgIQdbVKiIsgaiYTWGxN3sb2Z6UmhE+o4zvDdvvkIAkMvlIkqpNwDeE9EzEXkK"
    "gJn5l4j8EZGs53mbtm0TWhDK5/MZZl7p7u5+nkwm0d7ejmg0ChFBtVpFrVbDyckJzs7OfjLz"
    "jG3bp/8obGxsFI6Pj4WZ5T4EQSDFYlFWV1e/tjowAAz29PS0xu+gr68PRDTZGlfMDBFBuVyG"
    "aZqIRCJoa2uDiKDRaMB1XZyenqK/vx/MfEdYERFEBEopXFxcwPM8iAi01ri6uoLv+1BKQUQg"
    "IncFbhLhcBimaUIpBaUUgiCA1vqWtLKyAq114t4WtNa3pFAoBCLCwcEByuUy0uk0LMuCiGBh"
    "YeFFEASfLy8vfywuLs4ZNw6ICFpraK1BRCAinJ+fY2xsDCICy7KQTqeRyWQ2JycnHzHzh6mp"
    "qeitgyAIEAQBiAjhcBhEhGQyCQCoVqsoFAowTRMjIyMgIsRisS/r6+sNg5nBzP9UFxGsra0h"
    "Ho8jlUphd3cX8/PziMfj53t7e43e3l4MDw/Pzs3NiaG1huu6SCQSiEQit8Op1+twXRe+76Or"
    "qwulUglaazBzUKvV4DgOSqUSwtPT078dx3lrGMaDVCqFRCKBWCyGoaEhVCoV+L6Pzs5ObG9v"
    "S7PZlMHBwRgRIZfLZR3HeRkCgOXl5cfM/ElE3hmG0RGNRqG1xv7+PsbHx3F0dISBgQF4nofD"
    "w0NYloVsNgsiUqHWvS4tLT1sNptPtNa8s7PzsV6vz3Z0dLweHR39XqlUUCwWZ3zf/3Z9fZ3f"
    "2tp69d8fuIFt2zIxMXHnFP8CrK+1GKhZEdQAAAAASUVORK5CYII=")
index.append('database_gear')
catalog['database_gear'] = database_gear

#----------------------------------------------------------------------
database_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl9J"
    "REFUOI2lk8FLVFEUxr+ZuTLDGysQxxnSGtSERimKFgUh1SIhgjbBUKv8A4JoKQRtilq0iGgT"
    "2EI3YbY2BE2EiSmi3ESUFTJjozPKPJkZHd9799xzWj0bG6RF3+oe7j2/+51zOMB/KtAYTE1N"
    "hZVSVwBcN8YcFZE+AMzMn0Xkh4g8dxxnNp1OmybAzMxMPzO/6OjoOJ5IJBCNRmFZFkQElUoF"
    "tVoN+Xwea2trGWa+lk6nC7usTE9Pz+VyOWFm2Utaa1lYWJCJiYkxPy/YwBiIx+P/rLmzsxPG"
    "mEt+rPwDM0NEUCqVEIlEEA6H0dLSAhFBvV6HbdsoFAro7e0FM6MJYIyBiEAphY2NDTiOAxEB"
    "EaFarcJ1XSilICIQkWaAfxEKhRCJRKCUglIKWmsQESZzI9jWWxjpfgVjdobwpwd+CUQErTW0"
    "1jDGwBgDIoJLHrraUxh5fRma3cCeDvyEJ++GIazhMcEjwsG2PqQSp1FztjD56277uaex1vmb"
    "65tNTfR/J/ZwceAGjDAMGzAEK5VlHOs6i01vGx/z85VTD9G2C8DMICIQERzyYISRK3+HZgKx"
    "hjYaVbeGE4cGsanrwfdLmfIOgIhg2zZisRiKxSIcckCGEN9/GMQGRhirlTzaWhP4tPwWmZ+Z"
    "dc9gqHGMw9ls9mUqlYomk0lsk4ux7CN47MEhDz3t/TjTM4QPuQzmFmfLDuF88QG+7Fqm8fHx"
    "bma+IyJXg8HgAcuydpw9K9+Wk8nBwPzim1UvIBdW7uEb8Nc2Nmp0dHSf53lHiIhF5Ovj9Vu2"
    "kZDlwvSU7mPJf/cbkA2mUrTVB2kAAAAASUVORK5CYII=")
index.append('database_go')
catalog['database_go'] = database_go

#----------------------------------------------------------------------
database_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqZJ"
    "REFUOI11kk9IVFEUxr/33nVmejM6TjijOYmUiZkaQS4nWvVHgjbBUEEQJC3Kdat2UYugZUhg"
    "gbZIDXFT/inTTTCElQSZZprN1JgO0xvnj2/ezHv3nhb1hhrr21z47jm/893DlQBgbGzMyRg7"
    "DeAc53w/ETUDEEKI90S0TET3DcN4EQ6HOcokTU1NHRBCPAoEAgfr6urgdruhqiqICOl0Gtls"
    "FrFYDIlE4qUQ4mw4HI7/RZicnJyJRqMkhKD/yTRNmpubo6Ghof7yBDKAttra2nJ/m4LBIDjn"
    "XeU+E0KAiLCxsQGXywWn04mKigoQEXRdh6ZpiMfjaGpqghBiG5hxzkFEYIwhlUrBMAwQESzL"
    "QiaTQaFQAGMMRAQi2gaQ7QtFUeByueDxeODz+VBdXQ1VVeFwOCDLMgTnaChMu78MH59dutt2"
    "qQSwn2BZFkzThGma4JyDc17yOOcwl0fR3lGlBrtudFY2t99+c6vpJAAwO4HdYFkWFEX51fQb"
    "6M3NwuP/BG/LMWxFx1FR2bLT21AYGe+h7tIS/5xuA+wEqrUKb8cpcH0erprdMPg31B89pFo5"
    "rZcJISCEKE23gfbJOYfOq2CmvkBWkpDkLTiqkoChI/e9oDDLsqBpGvx+P9bX15HP50sbdhhf"
    "0Y4Z7NglQ1gaZLEJyJUgs4jFwY/GwlL6MuOcX4xEIsOtra3uxsZGOJ1OSJIE/fME1PxzBDpD"
    "oOIzSDyL+afpvJJZyyiShMXVzasXBmMjEgAMDAzsEUJcJ6Izsix7VVVFG41ib+gEisleMObF"
    "wnQu/zqy1lObzTyuqQFCD35kAUAq/xh9fX2VxWJxX1fgyUD9kVC7tRnBh4lk7t3bxJXu/pWH"
    "5fXbALZe3Tl80+PzdW+l9Pzy0sa18/dWhv9V9xPyJrAgr2pENgAAAABJRU5ErkJggg==")
index.append('database_key')
catalog['database_key'] = database_key

#----------------------------------------------------------------------
database_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArVJ"
    "REFUOI2lkk9oXGUUxX/vTzLJG5LaJjNmoI/Rkpaki5YodCEuaguCLropBgsiCII7Q4XsunRZ"
    "cFF3RhcptFAX7gLBEUEEQZQgfWIZNZVU6GMymck4mbw3833fvS7SjIVm51neezmce86B/wnv"
    "qOHa2lohDMMrwDXn3JyqngZERBJV/UNVP8/z/JvFxUX3DEGtVjsrInfL5fK5mZkZisUiURSh"
    "qnQ6HbrdLltbWzQaje9F5O1nCNbX17+dm5u7GMcxnnekQKy1JElCvV5fHV5s//zqZbHcyu2x"
    "M+OFKEBAnSDW4PlFpl/6hGDs+SFBu92mVqtthwB6761g26RXo+kL8xOjZcQa1DhkkJG1fmPs"
    "5CKWSbbTlE6nQ7vdplqtIiKEAGnciBF5Z6T4ArbzE/7YAtY2yXfrPLav4HZiXOM+zWYT3/eH"
    "nqgqYZKcHaUzeD+aWpiAAMlSCPvsPvoab+Y9pk68SRiGGGMIw5BerwcHkeCcI5zqnlhA7AeF"
    "ydOozSCogDGoBMjeI9w/n+HU4oiQ4GWMKeD7Pqr65AVjbo2XLkxnzQeIU0ajWZCQ5yqXyVq/"
    "I2bAXvM+Wv2QgRQwxhAEAaqKtZbQOb3X/fuH79Q6o05GBu6X66Xq677LdzH7O/T8UwTnv0BG"
    "Spg0xZj94f/WWsKTr/148zDK+trspJfzUdb8lb3dx5jSNezxi4yPjSPGoKo454Ye9Pv9gxQO"
    "Ee6PfDUalbyePU750qc0dnrYLPuv955HpVIhjmM2NzcPFBwuH345/4Z17tRWe+rjh1y6Pv9X"
    "WqxWqxQKBTzPQ1WpVCp0u12SJGFjYyN1zl0ZNvHPO2fOqbUy++5msrq6+qKI3FDVq77vH4ui"
    "CGstrVaLPM9TY8ztIAhuLi8vN44u+1NYWVmZGAwGs9ZaUdUHS0tL/af3/wI28YkJ3vzOHAAA"
    "AABJRU5ErkJggg==")
index.append('database_lightning')
catalog['database_lightning'] = database_lightning

#----------------------------------------------------------------------
database_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI2lk81LW1kYxn83ntsbcrEopiZ+gIIUBovduhJXs+imULEhLQS6LO77R9g/oLiZxaym"
    "UkfJRhAcBnEWgaCCdqUtkmi8Xr+/bkjMOeftKkFxyizmXZ33vDw/nofzHvif5dxtFhcXPaXU"
    "S+CNMeYXEXkKWGvtVxH5JiK/1Wq1vzKZjHkAWF5eHrbW/tHd3f08nU7j+z6JRAIR4fLykuvr"
    "a8rlMkdHR/9Ya7OZTKZyz8rS0tLfpVJJrLXys2o0GrKxsSGzs7O/N3WxO4xnqVTqPzP39fVh"
    "jHnR7FXzYK1FRAjDkHg8jud5uK6LiFCtVjk7O6NSqTA0NIS1lgcAYwwiglKK8/NzarUaIoLW"
    "mqurK+r1OkopRAQReQhoDtra2ojH4yilUErRaDTQWrdE1lqMMQ8BzQha65bIcRyMMa27WCyG"
    "iPx7hKaDarVKoVBgb2+Prq4uwjBkeHgYgK2tLXZ3dwmCIDk1NfVhZ2fn0z0Ht7e35PN5AHK5"
    "HFEUsb+/T6FQQESYnJzEdV2CIHDW1tY+lkqlJ61FmpubO0okEk9WV1d5/fYtf37+zObmJul0"
    "mpGREYIg4OTkhMPDQ3p7e29zudyj+fn5y5YDrTXFYpH29nYAJiYmKBaLZLNZOjs7ubm54fj4"
    "mJmZGQYHB6+AZEdHh3f3Gd9dXFwsaK0fAeTzeUSE6elpfN8HIIoijDGsr69/HxsbS1Yqldq9"
    "z5TNZn+11n4ZHR193N/f77iuSxiGbG9v43keAwMDpFIptNZn5XI5trKycngPALSNj4+P+L6/"
    "0NPT0+15nnIcxzk9PX0vIqVkMrkAuPV63RwcHBxHUfTqB4eVfvWHuBFKAAAAAElFTkSuQmCC")
index.append('database_link')
catalog['database_link'] = database_link

#----------------------------------------------------------------------
database_refresh = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsBJ"
    "REFUOI2Fkk1oXGUUhp87ucmYmZuJGZxJdFqj0kqjWAltIQoiIrUiqAvJaPFnJaJSEMSVutCN"
    "O6F00VW6aGAsJAVbq8EhE2ytFDdlaOjPtE1/bjQ6k8hIMjaT3O9833EhE9rU0nd5Duc57+E9"
    "HsDExETc9/1XgN3W2i2quhlwzrmzqjqjqgdWVlam8vm8ZZ28Uqn0mHPuUDab3drX10cymSSR"
    "SKCqLC4u0mg0mJ2dZX5+/hfn3Bv5fH7uFkKxWPwpDEN1zumdZIzRcrmsnxY/vj48Ntx283wM"
    "eLy3t3e9s9uUy+VomuVcqrN96ua675xDVZmeniYIAoIgoKenh6uNy/wYfsf1xhVELGIsudQG"
    "v0u6nt1deLV46M2juwB8ay2qSjqdZmFhgWq1ylLH35yOTnF/KsfzD7yIVYtTi3UWq5bl5eYL"
    "L+/fOXPsw8lNvqqiqgRBgO/7iAhT9XPc154hE89yplbm6l9XMJFhQ2ojIkIlvFT6fs/kToBY"
    "6wQRwRiDMYbLSxXO1Mocu3SEpfoN3rn3fb56ai9zv/8p58PKyW0Lk7uGvh7qBFhzYK1FRBAR"
    "3nvwI4wx1Go1Gv80EBFUlfaowyaz6ee+3IODX5u3OGhtb0HWgEb44Y8jqCrbvaeXxvPj9rYU"
    "nHNrgy1gJKs4dRytHmY5uoFzjtXVVYY+G/zZRPKMiQSJJPRFhHq9TiaToVqt0mw2/yPH2jkc"
    "fkNHqg3PdPL26OuYSDKPbHwos2NwkPMXL3Li5KmiVygUXgLGBgYGkv39/cTjcTzP493CW3R3"
    "dfPko0+sxdeKc+baNUqTx08baz7xAEZHRx92zn2uqq/FYrHuRCKBiPBtOM49GR8Ry7nKBSQS"
    "xFiMyAlr5Yvw4Nxxb/3LjoyMdEVRtElEnKpWDv42UpRI0tP7Lmy967//n4aHadvyweaxO/X/"
    "BYr20Tj6dpFTAAAAAElFTkSuQmCC")
index.append('database_refresh')
catalog['database_refresh'] = database_refresh

#----------------------------------------------------------------------
database_save = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAppJ"
    "REFUOI11ksFrXFUUxn/3vTt5zzeJpmCSgUFTiFZTUSFgCy7tqiB1URiUQCgUKf0D3LW7Lrpo"
    "oesSBbOpcSdIIJpSF0oslMSELlxINaMRJ4OTZoa+vDf33nNchESS0G/5Hc7vfOdwDMDCwkJi"
    "rb0AfBJCeFNVXwdERB6r6m+q+nlRFPcbjUbgiMzS0tJpEbk3Ojr6Tq1Wo1qtkmUZqsrOzg69"
    "Xo9ms8nW1taPIvJxo9HYPERYXFx8sLGxoSKiz5NzTldXV3V+fv7Lowki4K2xsbGj/jHV63VC"
    "COeP+lZEUFVarRZpmpIkCZVKBVUlz3M6nQ6bm5tMTEwgIsfANoSAqmKtZXt7m6IoUFW893S7"
    "XcqyxFqLqqKqxwH7hTiOSdMUay3WWm5+02EoOUHe95wYHOCrlX8w0emRz+7+oqKG7e4uD1b+"
    "Pnuwgvce5xzee4wx7OYFH5x5g4+mBvn257+4Pj15aPLcD21EzMNoP0EIAe893ntCCOSlo9Pz"
    "AHz/qHXQWHjoltB+2scY+f+Izjmcc4QQiOOYKDLECi4It69OIaIoEKNkFsqypPusvwcQkYPp"
    "+8C0ElGUjhvzfxAZ8EGQICjsHVMhqwiR955Op8PIyAhJkhxE9aKUwRNHFYyxGGKMiUEjVA3O"
    "e/p9jw0hXFpeXv56cnKyOj4+TpIkGGPo5S0qxnL1wyG89Pd+TkGNkNoBbt1r8m/3GXZ6enph"
    "bm7u7fX19Wtra2sXoyh6KcsygtSIqSDs8sXKFV7OXsUQ0c7/5NP37hCRkpd9LMDMzMzvwGXg"
    "8uzs7FC73X7N2vrKyRqMDfY49+4ZhgfqEMHTos5o1ZMNgDUG87zfn7ry3U+nXnnh/eFkmNS+"
    "iBeHEcFoQEzOr80nbHUd/wEeyZOnH6V89AAAAABJRU5ErkJggg==")
index.append('database_save')
catalog['database_save'] = database_save

#----------------------------------------------------------------------
database_table = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoRJ"
    "REFUOI19kk9oVFcUxn9z5703o2+IwX8DmpiAC5vG1iIiFgrq0o3SGgqlraLQXZcuXHQhgkuh"
    "YLsIXXRTFAUVcSG1QhQVggHTCYEmpCKpJdOMoTFTJzrvnnNuFwkvFlIPXC7ncO/v+7j3KwwN"
    "DXV6778ws4EQQr+qllX1iZndVtUfBgYGpnhLRd7777q6uj6vVqtUKhWcc7RarV2zs7O7xsbG"
    "DgPvvBWgqod6e3sxs3yYJAnd3d2Mjo7uuHCrHtQCovbGUlQCqjYSmZmICPV6nTRNMTNmZmbo"
    "6+tDVTlxYOP/qp+5PPV+FEIISZLgnCNNU6anpymXy3R0dKCq/Dj+Ld4Erx6vgpggKpz+8Bze"
    "WykSEQCyLAPAe58riAhf7zm1qnrrteBFiVQ1P6yqZFlGoVDIZ5ceNFYFHN6znkyUKIRQds6R"
    "JAmLi4vEcUwcxwC0222++mgzAFeHZzm6r5oD5pqvlxyIyM+1Wu3Tnp4ekiShs7OTLMsYGRnB"
    "XInrjxq45Us3HjUgBOII+rauJfNK5Jz7cmJi4l5t8s/vO0pCs9UmLRVpsY6Txz6jUqnkDo7s"
    "3Zw7+H2miYhRABgcHIwXNuzPPt6d8vjJPFFpDcW4TDEuLYXFQau9lJOoAAa8u6XMNz+NrzzK"
    "2StPw/w/7XDrcSOEEMIvvz4Pb9bt0UZoLvq8n/jjRTh+fjhE+ZctJ7HoCtypzQHkuyuAN7j/"
    "23wuuH1TgqqxAhAhLNs9+N5G7o7PcWDnSgqvDT/nk32b8n7y2QJFxwrAqxFCYOe2CvW/X7G9"
    "uoanf71E1VAL9G9NmHy28J8sqJnlABV7eObi1AfeLPWieFFUDK+GqKwSJXjRfHXzX+mZehw7"
    "gJXYAAAAAElFTkSuQmCC")
index.append('database_table')
catalog['database_table'] = database_table

#----------------------------------------------------------------------
date = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhRJ"
    "REFUOI19kF9LG1EUxH83uzapMcYgQqWIpJEtoUVJxaf2UbAI+XA++zkEv0ApKQgSZTEmFsoq"
    "RQRREt3Eu+eePjTZpP7pwMDlcGbunIExTLVa3dzZ2fkRBMFXwAfMkP76+vqX3d3d79VqdXM4"
    "+ysC6IBeAf7eHm9rNaKDA1y9zsJw6QrI7u/zZnWV34eHPGxvswCsgBn9Qj6bxS8WERFmSiWs"
    "51FSBaCrSrZQQER4PTtLZiJ1+s75PidnZ4gIrXYbVyrRm5ujNzOD5HKctFqICCenp+Qm7wZM"
    "B1yxWKS5uEi712PF8yirkhFBrWWQJPy0ljNreeccn6zlXpUVyPiTCT7Oz/Mhn0cfHkisxVmL"
    "8zxeifB+aopABCNCttvlPknGKRqNhiZJ8iKttRrHscZxrKqqSZJoo9FQhiU+wWAwIAxDKpUK"
    "nU4HEeH29patrS10WOwImecMwjDk/PycQqHA2toa5XKZ6elpkiRJOTL6x2A0rNVqqGrK4+Nj"
    "KpUK1loGgwFxHKeaJyc8jnhzc4NzDmstl5eXOOdwzqV7z3YwaRaGIUEQICIsLy9jjCGKInzf"
    "B9AMoADOOTcprtfrqCobGxvk83mccxhjuLi4SI3SDrrdLnd3dz1VdcYYJul5HsYYRIQoilha"
    "WqLf72OtHZ/QarXwPG92GOtFjBKICEdHR2OD6+vrb81m8/N/1Y/Q7/d/AfwB7h4+GltqMzoA"
    "AAAASUVORK5CYII=")
index.append('date')
catalog['date'] = date

#----------------------------------------------------------------------
date_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnBJ"
    "REFUOI19kcFLVFEUxn/3vaczqTPTFIVSBKZODZbTZEaU0CLDEqb/obW0atfWjdHKRS0SXLYW"
    "wpAiKpByAmMwfTg6ttFKMmimmXFy7rvvtGisCa0PPjhc7vnOd74Df6Di8fjA2NjY21gsdg1w"
    "AFWj09vb2z8+Pv4mHo8P1N5+NQHkQDYBZ2qKI8kka3Nz+KkUh2qfNoHA9DStPT18zmSoDg1x"
    "COgEtTOF5kAAJxLBGENLNIq2baIiABRFCIRCGGPYFw5j1bn+XQcdh6XVVYwxZFdW8KNRSvv3"
    "U2ppwQSDLGWzGGNYWl4mWL83oHLgRyIR5tvaWCmV6LRt2kWwjEG0Ztvz+KA1q1pz3Pc5qzVb"
    "InSC5dQ7OHXwIN3NzUi1iqc1vtb4tk2jMZxoaCBmDMoYAsUiW573x0U6nRbP8/5JrbVUKhWp"
    "VCoiIuJ5nqTTaaEW4i5sb2/jui4dHR3kcjmMMRQKBQYHB5FasDuw9hJwXZf19XVCoRCJRIL2"
    "9naamprwPO83d4T+ciAiKKVIJpOsra0hIogICwsL5K2P3JmYoFD+htZV4q3ndgvsiNQjn8+z"
    "uJEmH8hx+VIfRw908WJxktmFSc4Pt93bc4V6Mdd1yXya4czJBMYyJNquYpTmwumLgAxbgAD4"
    "vu/XN6dSKUSEvr4+NgsbNKgWbsRvAXD7ykM6DvegUEELoFgsUi6XSyLiK6Wop23bFMsFFj+9"
    "ZvTZTQBGn95k9cs8gvxwALLZLLZthx1nz6vS33Wd2fnnXOzp5/H7BzQqh5nMK0DdVwAjIyMz"
    "4XD40v/yyHx9yUr+Hdqv0mA1cqyp+/uju08iPwHWR0BCkHJtKAAAAABJRU5ErkJggg==")
index.append('date_add')
catalog['date_add'] = date_add

#----------------------------------------------------------------------
date_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnRJ"
    "REFUOI11kcFLlEEYxn/fztiuruu2mqBF0aYZS6GsQpeCogIj8BB06dQlCIKg/6Bbdy9BeIj+"
    "gYJAqCzoUNSXCLLYh5trREpFhmnfuuvuzHxvh1bbyH7wwDDMPPO8z8AfvFwud258fPztwMDA"
    "eUADXkN6ZGTk5MTExOtcLneusff7EkAJZAXQk5Psy+dZmpkhGhuju3FoBYg/fkzP4CBfZmep"
    "X7hAN9AP3tYrJONxdDqNc472TAajFBkRAEIR4qkUzjlaOzqINaXeXie0Zn5xEeccxYUFokyG"
    "8u7dlNvbcYkE88Uizjnm378n0Tw34JUgSqfTFHp7WSiX6VeKrAgx5xBjqFnLB2NYNIZDUcSw"
    "MVRE6IeYbk5wrKuLo8kkUq9jjSEyhkgpdjnHkZYWBpzDc454GFKx9k8K3/fFWvtfGWOkWq1K"
    "tVoVERFrrfi+LzRK/IdarUYQBPT19VEqlXDOsb6+zujoKNIodovYTgZBELC8vEwqlWJoaIhs"
    "NktbWxvW2m1tGf2VQETwPI98Ps/S0hIigogwNzdH75dppu9do/KphOruJTY89q/Blkkza2tr"
    "qNlJ7Ldp8peuEs8epVp4SvDyOU9O6xs7jtBsFgQBMvOQw6cuklh8gXf/Mm0fHnLwQAZRchMA"
    "3/elXq87Y4w0a3NzU8IwlGdnWySaeSDN/LjVI1NndKQBwjBkY2OjnEwm22Ox2HYqz/NQSqH2"
    "9FCZnST56Dq16lcqQPhT4RSfNUCxWEQp1aH1jr+KPn6Rd2+esL+zFa1aCFcsH78pROwdDbC6"
    "uvqqUCic+G8Zuo+ezAgr81MkQqglO/m+d3jtyt2p278A8CJiLIYmOpsAAAAASUVORK5CYII=")
index.append('date_delete')
catalog['date_delete'] = date_delete

#----------------------------------------------------------------------
date_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsNJ"
    "REFUOI11k8tvU0cUh7/rexMnxfHFhIQgkpqQNMSlBRuLTQkrkKhSRWIDS8SKJYj/gXWlCAkE"
    "QaxRVy0qCKSyQGqwUjWKFRfjJxVg52EnBuIH1547MyxISHgd6UhHR/P7zm9mdGAzjFAodGJy"
    "cvKfkZGRnwELMNbTikajY1NTU7FQKHRivfdeBJADXQasu3fZE4nwcnYWNTFBz/qhMuC9f5++"
    "gwdZjMdpjY/TAwyDsTGFbV4vlm0jpcQXCCBMk4DWAFS1xtvVhZSSTr8fzxbXH+oOyyKVzyOl"
    "JJ3NogIBatu3U/P5kB0dpNJppJSkMhk6tt4bMHKgbNtmfvdusrUaw6bJoNZ4pEQLQdN1eSYE"
    "eSHYpxSHhaChNcPg+QDY1d1NY3QU7TjoVgtXCNRGSol2XQh7cc/+hOn7kfrKI1SjcM4AjJmZ"
    "GRWNRvlaaK2pF3/n7bN/6dx5DHswwuv/Yzx9cHPZ+pKg2WySTCYZGhoil8vR/vYxA92v2PHd"
    "USr5p7QbLbr8ffi6v7W/CEgmkxQKBcLhMKH+KqKyir3vJM3F27R/Y/A8nqIlPFTfLIc9W4V6"
    "/dsikQhaaxqlR4jVv7CHxnEWpjDaXtHm66JTreIExxm7dCfzmYMNiLk2S2PBpfeHUzjFa3ja"
    "XFprg5Sn59CHL6JcPwCeTwEApfQ9hvua9B74hdbSTcx2TXMtSHl6jv4zN2jr2Y9lWQDaA2gA"
    "pZQCyMZ+4/WLGVzdz2LiCgqHemUPpdgT+k9fp1RVBINBDMPYdFCtVqnX6zWttfovdovvx87j"
    "ffk3mT+miT+okHo4hwxfYGlNMjAwgOM4CCGA9xtHOp3GNE2/ZVlk8iVaT/5k8NAx3pRXeRHP"
    "0jtxmZWmF6NQoFgsIqUkkUhsAiqVyvT8/PxRgERmiV+vX+XI6F4anTspjxxnIbcMLH/0To7j"
    "PAd4B2xWTn5WIjpwAAAAAElFTkSuQmCC")
index.append('date_edit')
catalog['date_edit'] = date_edit

#----------------------------------------------------------------------
date_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn5J"
    "REFUOI11kk1rU0EUhp+be2PSjzSJMWAR1EpNSZTQ2JWo4MKFCOJCEPwb7kUE/0AXddOdqKvq"
    "olApRTeC1FRrSsSapK0fNFqsGiVfNbkzc1w0SVNoXzjMzOGcd545DOzIisfjl8bHxxdisdhl"
    "wAGsVjhjY2PnJycn5+Px+KVWbrsJYBXkJ+DMzHAklWJ9cRFz9SrRVtFPwDc7y+Fkko2lJZpX"
    "rhAFhsFq30Kfz4cTDKK1pj8cxrVtwiIAVETwBQJorekZGMDTRd3Z+x2H3NoaWmvyKyuYcJhq"
    "KES1vx/t95PL59FakysU8He/G7BWwQSDQbKDg6xUqwzbNkMieLRGXJeGUnxyXdZclxPGcMZ1"
    "qYswDB6nm+B0JMKpvj6k2US5LsZ1MbbNAa0Z8XqJaY2lNb5KhbpSOxTpdFqUUvtGeWNe1hdu"
    "S628KSIiSilJp9OyawbdajQaZDIZyuUymcXXbHx4SG84Sf3bLNIabFt7GiwvL1MsFgkEAhwL"
    "Fjl45CwDgylKa3PUfuVQSnWMdhm0k6lUChGhWVnnz+oMgUMhdHmaaPwmm+8fU69X9ycQkZaR"
    "8Dv/hMjJa/DvHQsPHtEf2qL89TU/ci/2JuhWrymi638JhOuYxmcQg66+YejiLbYKUziWBhAP"
    "IADGGNOhMIrj3o+Ejo5i6lnEbDF2fQTT/I7fXyAydAGz/nyHoFKpUKvVqiJiLMuilH9GTzhG"
    "b+AXon6DZbP4tAAYzL8C0dgxGp/meHknkbAAJiYmJJFI4Djb/8r7/h7JG/exPV8Q9acN2Rmb"
    "3TPCjw9L5KfvTjkApVLpVTabPdcuGW2WeTt5AzGyHWIQY1rn9qrFo/Xh/4gLbABxTu/dAAAA"
    "AElFTkSuQmCC")
index.append('date_error')
catalog['date_error'] = date_error

#----------------------------------------------------------------------
date_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApVJ"
    "REFUOI11kstrVFkQxn/3ETvS3WnbKBOfkIeRq46ZNo4KOjsNEnAnLgbBhXtBQVxk4V4ECTKr"
    "MAthmGH+AMGdA75oxSG22KQfGYmJikQjmb6de/ueU+e4sLUjakFBcaj6zvd9VdAJJwiCo5OT"
    "kw+Hh4ePAz7gtNMfHR09MjU19SAIgqPtt49DAHWwi4B/8yZbCgXmHz/GnDjBxnbTIpC6dYu+"
    "vXt5PT1NMj7ORmAInE+/kE6l8HM5RIRMPo/yPPLWAtCwllQ2i4iwtqcHdxXrz3W37zMzO4uI"
    "UKnVMPk84bp1hJkM0t3NTKWCiDBTrdK9Wjfg1MHkcjlKmzZRC0OGPI9+a3FFsErR0pr/lGJW"
    "KQaMYZ9SrFjLELj+agZ7envZnU5jkwStFEYpjOexRoSdXV0Mi+CIkGo0WNG6w6JYLFqt9XdT"
    "KWWjKLJRFFlrrdVa22KxaGmb+FW0Wi3K5TKDg4PU63VEhL9mLxKpJtdP38d3uj73ut8CKJfL"
    "LCwskM1mGRkZob+/n5ZWbN0QcOb3AiutENve0BcMrLU4jkOhUOCP6gVu/32FxGgSpdi8fgdB"
    "30EacZOTUwETP//5NcAnEABtEo7tPoNYgxjBYHm1PM+PWw8TJhEX74wzcpncNz0AiHWCWMPc"
    "uxrKaLRRKFH832rw07ZfCNUKxed33/qABTDGGMfpHFasY7RofujZjjaCWMPr5Resz/Tx7/w9"
    "ni48o6nY7wM0Gg2azWaYTqczruu6AJFucePBVRKTEOuEgQ27ODQwxqO5uzx5+YSJA79xauzX"
    "aR+gUqngeV6P73cUnd9z4wtJ5+6M4bhrKb0ocWn/NRZr7zsmLi0t3SuVSoe/5wdAGAu3q/9w"
    "tneCN9V3xHE8B/ABp85fDAe2u+AAAAAASUVORK5CYII=")
index.append('date_go')
catalog['date_go'] = date_go

#----------------------------------------------------------------------
date_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArRJ"
    "REFUOI11kE1LW1kch5/k3uQ65t1QYulCHcUSnDRU6WoENw1qIatusnQ138HNbFxIQBdZ+wX8"
    "AoVuuikDIUqg6SJ4YxyRiTESvL4kt5ncc889s5holZn+4AeHwznPec4fvseXTqfflkqlg/n5"
    "+TVAB3yj6ktLS8t7e3vldDr9drT37yWAJqguoH/4wIvXr/mrWsXL53k2OtQFjI8fmXz1iosv"
    "X3DeveMZMAe++1cIGQZ6LIaUknAigdA0EkoB0FMKIxJBSslP0Sj+R9YP6zFd5+jkBCkl5vEx"
    "XiJBPx6nHw4jx8Y4Mk2klBw1Gow9/jfga4IXi8X4+vw5x/0+c5rGjFL4pUQJwdB1+VMIToTg"
    "Z89jUQi+KcUc+PXHBr8kkyyEQijHwRUCTwg8TSMoJS8DAealxCclRq/HN9f9blGpVJTruj+s"
    "EEINBgM1GAyUUkq5rqsqlYpiNMT/ZDgcUq/XmZ2dpdlsIqXk9vaW1dVV1Giw9/H/H6Ber9Nq"
    "tYhEImSzWWZmZhgfH8d13Yfeg54YKKUYDodYloVpmlxfX3N1dcX09DTZbJZSqcTExASWZZFI"
    "JFhZWQk9AQgh2N/fx7ZtNjY2sG2bVqtFuVym0+mQz+fRdZ2Liwuq1SrhcPj3J4Byuczp6Snv"
    "CwWKxSLNZpPJyUkymQztdpudnR06nQ6Li4vkcjnOzs5+8wMKwPM8r1arEQqFANja2kIIQaFQ"
    "YHl5mfX1ddbW1nAch83NTQDi8bihA/R6PWzb7qdSqcjh4aEPYHd3FyklxWLxAWrbNkoptre3"
    "yeVynJ+f/60DmKaJpmnRQCDAzc0Nnz99YmFhgUwmw+XlJY1GA8MwmJqaIpVK4XkeBwcHtNvt"
    "jm+k+0c0Gv1VKcXd3R21Wo1kMkkwGLxXJRgM0u12UUrhOA7dbte1LOvNP6ofcNR3oPQsAAAA"
    "AElFTkSuQmCC")
index.append('date_link')
catalog['date_link'] = date_link

#----------------------------------------------------------------------
date_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmBJ"
    "REFUOI19kUtPU1EUhb97z6G39AKlQQSiCQ8RrBpIIXGizBgYYgfOHPpD/BOMif/AxBEJiWHo"
    "o0QMdtBQHg4EAYsWsIU+zssBpdSIrmQnJyd7rb3W3nAJL5lMzs7Pz6+MjY09BiTgNUpOT08/"
    "WlhYeJ9MJmcbf+ckgC1wh4BcXORGKsXO6io2naa30XQIBEtL9E9MsL+2Rn1ujl5gFLyLKYRB"
    "gIzHMcbQkUighCDhHAAl5wg6OzHG0N7Vhd/iuvmOSsn69jbGGPKbm9hEgnJ3N+WODkw0yno+"
    "jzGG9Y0Noq25AW8LbDweJzswwGa5zKgQDDuHbwxOKWpa80UptpVixFqmlOLMOUbBl60O7vf0"
    "cC8McfU6WimsUlghiBjDeFsbY8bgGUNQKnGm9aWLTCbjtNb/LKWUq1QqrlKpOOec01q7TCbj"
    "aCzxL9RqNXK5HCMjw7xeXkHJdqomRkRKhD7h+ZMHzd4rBXK5HLu7u2wVzogPjDN5q4+2iKRw"
    "Uuf7jxNevfnE6PUIQOtFwDXOlkqlcM5RrLVzd6iX47rP/i+D9gRDN69xXBVNzh8CFyIXQlVl"
    "CYII2lisdVTrFmU8nAiaPVdGuEAgPKo1hTIe2p4TnAfVShUpAwDnAw7AWmtbyel0mt7QclA4"
    "Iox4xKKSrlgb+0WFPN2hsJG5dFAqlTg9PS2HYdjh+34z1szUbbKb+3z4+A1fRKjUNN7JV2b6"
    "jyisv+PF08FnEiCfzyOE6JLy70QhMNkHoPE8j8LZDodbnxm8M8Xe3u5LCVAsFt9ms9mH/9vH"
    "JQTVnzEODpedQsR+AzluOAV579DUAAAAAElFTkSuQmCC")
index.append('date_magnify')
catalog['date_magnify'] = date_magnify

#----------------------------------------------------------------------
date_next = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI19kU1rU0EUhp+595rE3qQx1OLXqrZEroolluJC0Y1QEeLejW71d7hXCu66FDfuRZdu"
    "RCIIpZRL06aCtCpSiK1JTJOZM8eFSY348cILwzDvOc85A79kkiS5vri4+LZcLt8AIsAMHM3N"
    "zV1ZWlp6kyTJ9cHdzxBAA3QHiJ4/51Slwta7d/hqlcnBox0g+/Ilxy9c4PPyMv2bN5kEZsAM"
    "uxBns0TFIiJCvlTChiElVQBaqmQLBUSEw+PjBCPUB+dcFLG2uYmIUN/YwJdKtI8coZ3PI7kc"
    "a/U6IsLa+jq50bkB0wBfLBZZOXGCjXabmTBkSpVABLWWnnO8t5ZNazntPRet5bsqMxBEowTn"
    "JyY4F8dov4+zFm8tPgzJiHDm0CHKIhgRsq0W3537RVGr1dQ5909ba7Xb7Wq321VVVeec1mo1"
    "ZbDEP9Tr9UjTlOnpaRqNBiLC3t4eCwsL6GCxQwV/K5CmKdvb2xQKBWZnZ5mammJsbAzn3IGH"
    "hX4jUFWMMVQqFba2tlBVVJXV1VWSJOHWozUCA/evlTj6L4JhaKjd3V2891hrUZSTExkev/jC"
    "8vZ/RhgtlqYp5XIZEcH3HBljOF7K8uy15+q9V7cDQAG89340XK1WUVXm5+eJ4xjvPbLvsH1L"
    "FCiTRzPkMsHTCKDVatHpdNpxHOeDIDigMsYQhiHGGEQE6TjsvtD51ufT+lf6++5OBFCv1wnD"
    "cDyK/vqrB5Kuo/U14vN6k0vTX3j44O6TCKDZbL5eWVm5/N80IJ2zfEybXJr5xLH8zgeAH5Ss"
    "RfvGMRAIAAAAAElFTkSuQmCC")
index.append('date_next')
catalog['date_next'] = date_next

#----------------------------------------------------------------------
date_previous = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnFJ"
    "REFUOI11kk1rU0EUhp/JvTa1aUxjrChSSm2JXJQWLcWF7hQqQv6AC/9Aly5cuHDlxpVddyeu"
    "xK2gOxeKRGgRGy/9SBW9rVoETWlsks6cOS5M04j1hReGYeaZ95w5sC8TRdHV2dnZN8Vi8RoQ"
    "AqbtcHJy8vLc3NzrKIqutvf+XAKogn4HwqdPOXX+PMn8PL5UYrB96DuQfvaME+PjfH37lt3r"
    "1xkExsDsvUImnSbM5RAR+vN5bBCQVwVgW5V0NouIcPjIEVJdqTvr3jBkaW0NEWF5dRWfz1Mf"
    "GKDe34/09rK0vIyIsLSyQm933YCpgs/lcrw7eZLVep2xIGBElZQIai0t5/hgLWvWctp7LljL"
    "jipjkAq7E5wrFDibyaC7uzhr8dbig4AeEc4cOkRRBCNCenubHef2U5TLZXXO/dfWWm00Gtpo"
    "NFRV1Tmn5XJZaTfxH7VaLeI4ZnR0lGq1ioiwtbXF9PQ02m7snlIHAeI4Zn19nWw2y8TEBCMj"
    "I/T19eGc63gP1Enw4n2N+08+I7uW5/cmSZIEVUVVqVQqRFGEtRYRwXXVHwK8+2J4vPCRE4Ue"
    "krVff8Ws1Wp477HWsrm5ifce7/1+git3yjcel5Xjg2lCY3A7+3RVJY5jisUiIsLw8DDGGJIk"
    "IQxDAE1lelKPjhd6CFOKbTlkpwVAqVRCVZmamiKTyeC9xxjDxsZGBwSQ2vrauJks16j/aGGb"
    "gjQdxpiOgyDAGIOIkCQJQ0NDNJtNrLWdSeTW3Yf6qnKMwnCGbys/eXC7cNDndKAiwuLiIjMz"
    "M3/mYCD89Opi0V56WTmK956FhYUDAd1qNpufAH4Dgctg14RHe0QAAAAASUVORK5CYII=")
index.append('date_previous')
catalog['date_previous'] = date_previous

#----------------------------------------------------------------------
delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl9J"
    "REFUOI2lkltL1GEQh5//nszdskKLde3sQiVZdiBKiNiLIlK62YtQzK5j2S/RV+gLlEkRYRAd"
    "ScWwIBCiICqK1m13azNrPay5/g/vvG8XkpVaN87lwPMwM7+BFZa1uJFLpxuNSKcY6TauF9Vo"
    "tJExbeke8dS15p4bmX8KCqlU0jPm0trd8fpISwvWuhqwbbyvRSYGBpicKH1RWqUP9t7uWyIo"
    "pFJJJfpK7YlEJLJvLzL6Br4WwHWxVq/H2rKF0t375LMfZo1xzx++/qhvQZC7cGGHNjypO94a"
    "Cx/ajwzdoTJnY4lHVSiIpQ3GtaHpAN8e9vNpLF9USh87dmtw1AdgoCvSUBerbm5Chh8gzhza"
    "qRCslNFTJaQ8gbYreE/62ZBIUO04MeP3ugACABo5F9mzC/32JZXJ76hX83eqLDpwKLoWlc1Q"
    "39LK1Kvhc8DFAIAy0hAIh+H9e3Acai/fXDay8c4zBGc8Vh08grzwGgDmV/AUulxGz0wTEvu/"
    "uSulwYC2FL9X0OrzXO5jvDpSg+RLjHeeWZ72+Qht3sp0Novx5PPCBKLV1dLICCYWR6YdgmuC"
    "S1gxBjF+gtvi5F8PoVFXFwTa5/X+CK8qlh4PETzVhnZ8WH7/PIiFiAEdoOZUO7nBe8w4laKy"
    "vF7445Ged7QnxciVjWtqIxsSJ3A/ZnAzGbSrqdoZJ7RpO4XBO2RL72aNkfNtD971/SUAeNZx"
    "MmmUuhQSt37TrqOEojEAKsU8mdfDzIr9xRiV/gUvEQA8PZtoFNvuVH7dbbSOGtdDBfQYonqM"
    "uNdOP/yQWcysqH4Ct+5AeSaDkFQAAAAASUVORK5CYII=")
index.append('delete')
catalog['delete'] = delete

#----------------------------------------------------------------------
disconnect = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr1J"
    "REFUOI2FkktoFGkUhU+9urrS6dGEpMVEHYY4UUFwIS6iLgRH0NWAoKC7yCxEmNUQHBwYcSOu"
    "dOHKnW5ctMFHUIlxgo8hj9VEMIpRY0zHTtOdTlWq+q//Vf/fPQtRBNN61vd+nHPPNfAdPXrU"
    "sAt20JVw2S256iRS9lKZnKdUjM4VzF+Nby3nxwse5d6o1qpPJhqJUtBKwnNNFCo1vF0kw/a3"
    "ADXq/u7aum9tiwmR1CGkASZMhLFA2jHgh+H+pg7y+elUMfVDuL7NSTMhUI04mJCIuULWs/Dq"
    "/TLmF4IBsxng6NHtMqT04vtKhJhLuDawQgTCGgWhDH6VQEb09VcRrv3rb9Jvbv8tpbROHt/a"
    "/9ulCRYx9df6tlQ6mzZRqnJYpgsSEsgwXvocIT9e8AhLX1fhwqGNXsV1HAdTU1NXBwYG+n85"
    "fX+vivnIhnVZL9PqQCQJno+/AyPsR+tTVSVBp10be5x0xp4tLKqMSc1SqfSso6Pj7s+Zam0u"
    "yA1XSv6xRqPulOd9BJWVNzkdXjAA4MrD4iYp6vNd7Q6ETFBe4ZifnZG+zB5oL9/qp5T2CSH2"
    "TZV3bVZSPtANNRIz6/iHyT+YDQBhTXabqIPxBorLFJm0gZb27lRpZvqfnp4eJ5fLYXBw8PGW"
    "7JPdLxZ3bpsZ+7PwKboNAHHMOy0LiHkDhHJUggRrWmxs/GmzM/b8KXaQdxBCTAwNDfnADf/L"
    "o390QFhva4sJyoGICjAuUfYl0rYFb8NO3JscT5Tbc2q1uq0j+emUXiKjubWuFcUcKcuAbQG2"
    "aUDXNQpzS1he1mf+u3P2yWoA254NiJexHK0UYiawUAxRC2IwwsGJAI3iiZCoy80ezl6J6aiF"
    "1MGX1Ro+LPiJpOyMlslrULkktC52JsHii8lzqikgiMPDUdm4qZnYH4lU68sbJ2Sz4dX0P7YL"
    "jqnaHUJ7AAAAAElFTkSuQmCC")
index.append('disconnect')
catalog['disconnect'] = disconnect

#----------------------------------------------------------------------
disk = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgVJ"
    "REFUOI2NkjtrVkEQhp85Z798GJREBSMkIl5QsAp4gRi1FfwHFqJFmlgELbTTxspKRBQhKURb"
    "wcYm2FilUMQi2KlYiNiIYkK+y+7Oa7HnCDaJ28zAzvA+78zYqauvrgv2Y5wBDhpsBwUwQwBQ"
    "V0ZVGZKTs36NdOzjRox33z268DwAx5Zuzs6BcXSyiwC5GCYxjE5dGdu6FWaw3nPWemns8/f1"
    "6afLnx7X8y/HKoyzCF68+Y0LJLHw4C3uAjM6oagPk+hFJ8vMqcPl84d3d7vdhxXYXgHuIiYn"
    "psIdXYQaOsFwF71h8yfxenWNkU5NfxBHAmg0uYBSBFCZgaATKgyjH53eQLiEC1zi248+CAug"
    "kCUkGDTqt65M0wkVoYKYxcbASe64gxByJ6aM5AQw8wxI3HnyHjOjslYdkouUvF0IAOPju4ip"
    "BomAwOW4Z/ZMTIKBIUpHg+yO1FhwBzNiTFAIIGdQI2F/EwqyynxKECYhOTFaawFSdhpJhDAM"
    "JKTiV5TcPSMXwhlEtQQie0G+fXGK/3k3Fj+QUiEJlRm5na7g/srcps0LM4vknBg2NxGKV2FN"
    "wempS1sSeHZyFOAEyZVd1s5g5euzTZtP7DtHzpmYheQK2e3LMPmB44dGMYNrs0tbEkzscHIW"
    "iJ92cn75HuiIYMaknVB2jhzJ/4ntZsoxs2Zmq38AgMJvXVyB7IAAAAAASUVORK5CYII=")
index.append('disk')
catalog['disk'] = disk

#----------------------------------------------------------------------
disk_multiple = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmhJ"
    "REFUOI2lks1LVGEYxX/ve+8dx3E0xSjBiqxQ2iQIabXUhZsgstxkK0HETf4FtahoU0GryEVi"
    "EWirFolBSbaxNHQoQ3CTmuMHzuQHM87M/XzfFkMNmpvorM/ze85zeOA/JQBuPP42WRqGjBtQ"
    "URJiLZlDSCgpNtAINlM5RqfjnfGh9tm9ABMgl3VobqrjUkOU1xPL3Lp+epfp+YcEWtE/METT"
    "vgk67n2abDlfx0I8UR94LlZIciBisb5h5x0CXE+xnbZXx2ZWLy++uPJ1VwIhBAZg52xazp2k"
    "9UyU0ek1ettqkUAq6+F5AcOxNFrJVwNwYheg2BLYtsf6lk38p0Pvkx9FpUUwMpWgIhpiNZHv"
    "JBoxaiorwnTen9BjsdWmhcG2zyaApzW28pFSYmhBLmvT3JjvZHhimZsdeztJopSYXBhESIB0"
    "1sPCpLLMwJABWcdjM+0D8G5q/c+g7UPKgeS2ixCqcIIKwMDCV4qtXBIpBYYGL1A87GlAKY0G"
    "DDQRExzHIZVxCwDTlNRUwdScT7SohLCVwXY87r5cRArwA4UKFBrQWoOGiJVPIAHmV3Zmno7M"
    "splSuJlSfKVxAh9DWghhIjAQwgAt0Vrg+T6u6xcSTPe1dk0D7bfH508dEbz/4tVYwqTnYim+"
    "cvN7NGihCJshHgwusZHKFAC/9X1lJ9b/ZrYhUPlOFDn6Y90cjBxDIElm43SdfYQkTNZx/wbE"
    "+lqvxoD2Ox/18So4HE3TUt9IeagaJGzb1Rwq8YmEwBSi8Mp71dD9drz2aPGF8qJywmYZvvIQ"
    "SiF0gBJZ5pbmSaQ8Zp5d23f+n/QLT0IXTQxChrUAAAAASUVORK5CYII=")
index.append('disk_multiple')
catalog['disk_multiple'] = disk_multiple

#----------------------------------------------------------------------
door = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATZJ"
    "REFUOI2lk7EuhEEUhc/sElZhs0KBeBCleAyP4A2U3gGFd1AIOpVX0IhKIUhkE9XPf+85V3F/"
    "/66En2QnmdyZYs5858ydUnp9zDJ6M50GMDe9uT3dD0mIIEhCykl6W0nHzsF5+VFAIta2d4Eg"
    "QgFJCBEQ2/X99dnvBKQjSLy/PSKa24NENASLy+twr7sFJEJ0hFJMdIhEyEFat4C75W1uSUDP"
    "PYmgIdxg1knQCLR1QlGihsi/COpEtjr9u0NyrAzH2Nx4xcPTEO7WbUGNhRZfWcfjAaqP+f8Q"
    "GOj1NwsvzwsI9rG0qm4Cs3oSIq0JrxFSrslOCzXkmUEo0/+iCOXT/pFBWhiMthAhBB0h5QxC"
    "zHaeHqX0+ri6vIiqqmA3h22/T/f/5E8QEcTdaA8AcHR8Usqs3/kTB9l0zpDbjAIAAAAASUVO"
    "RK5CYII=")
index.append('door')
catalog['door'] = door

#----------------------------------------------------------------------
door_in = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2dk71r1WcUxz/PfQ1JA03xDXILMQZp2mI6uHUrnYRMUtDFIahEUQT/AAnd3EUIiEuX"
    "ioOF0lI3KVQqJkHRSsRiribSoibevNT8nue8PB2uXr24tB44fKfz+cI53xN4j7p74eRZdz2t"
    "puuV/zN47+KpB+4+Utu6g4XmHwyUqtoBTE1NZXfndZtZRyc+z5Rwalt28MHOEdycvHAHTYkO"
    "wMxoNBoAhBC6NOe7DOz9EgjEjWVMIjk7SYXS2wCAa8VVMpkQQqfNDDejaC0hL1dxSWQ3NKVu"
    "QAiB5/EZP7d+6AKoJtwE04RrwjWS3YmySWX83NfZzbmtvzP34jpDg0OoGlcWL7F/8GAbroms"
    "ikvCNEEOZHc0FVRMjW++2o+4oaaoK2LCzWKW7x9+x8Fdh5BXziaRrAXbtz7lz6yIJCoqRlJh"
    "pVghmSAmQGD000+YK27xS/MnhnrBVLEU6e97wUcfLlMtb7Imm5RUjWiJWqlOvdxDvdxDOZSZ"
    "mZ2jtbTGvuFxRApcIyaR1kqZZnMLMVXbZ1RRLv14GRXD1Gg0BlE3VpfWObxnkhACKUVcBZeI"
    "ibAcK+BO0kjp1zM3wm/fzoTRv8Y48dlpVp9ssPy4xZGxY2+uIEV7ByqYvoK5oyJvgqSqhBDI"
    "lpn84nhXmJLE9rBEXBIhODk7pvFdwMTY0Y7za4BI27V34GNcBY0vIf+NuhGmp6fz/Pw8i4uL"
    "Xfl/Ww8MN+nr76fe00etp5dqrc76RotH92efhf/yhecnh7eV/il2KWnUTXe7ayNU6gdcitV/"
    "AeCTrcuGGFT8AAAAAElFTkSuQmCC")
index.append('door_in')
catalog['door_in'] = door_in

#----------------------------------------------------------------------
door_open = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAY9J"
    "REFUOI2dkstqE1AQhr+T5lIbC0Zq6SIurEUQXLrri3Ttyo0IPkG2voAQEN/IlVUiLhrJJiDR"
    "SqrJmdtxEXNVMTowzGz+7/z/cBL/UecvnzyPsGfmNq7+i/Ddq6cfIuKkfuuIi/5bWpWaLQCd"
    "TqdEBPN298V89KBQIagfHHH9zgnhQbl4g4mwALg77XYbgJTS2izlnNbDUyCRr0a4ZkoJxHQd"
    "sCme7+5OuCPjIW4CVCjhvzpYFa3uZkK44iaECZAoEWSdLAFm9keAm1DMCJWZgzIDmEyp/M7B"
    "ZuvPl10zRScctvqUYqjKErDqYNOJquBmuGSa175w88aI2s4E+VuEJWBKWMY1c/l5h7ADsgzX"
    "jzgHbOZPKSGSCVNCM67KKFchArG8HcB0OruBKW6ZlKpEBKa6pQPNM7FmQoWUglIC39aB6izC"
    "Xus2YYrl71CGWDip2+2WXq/HYDBY+/+r8+y4T3N/n8Zuk/ruHrV6g/HVJR/fv/6U2KJePD4+"
    "rHyb3jXkfrjdi7B2qjbOQqdffwARdkfhusDSKwAAAABJRU5ErkJggg==")
index.append('door_open')
catalog['door_open'] = door_open

#----------------------------------------------------------------------
door_out = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAktJ"
    "REFUOI2dk71r1UkYhZ/53Zvkmhgw4kdWI2oM0UCCoNvJ7lbu32C3aCHbiLCoYCGkFWuFiAhi"
    "HawsRAvRRhFh1SRc40cisVhcsnujbu5v5v0Yi7smudioAy+nOs+8czgT+I4zdeXEeXf9Q00/"
    "VL/FOHP15At3H+rc3M/c/DR9RYeuAMbHx7O783nMbEWPjWYKnM5N/azfPYSbk+eeoSmxAjAz"
    "BgYGAAghtGnOU/T9eAgIxI+LmERydpIKxVpAJnO3vLVi/jxmhptRNt4iy0u4JLLblxvcad5k"
    "KTUI3atmANWEm2CacE1AILsTpbkKqG/8k21bf6DPNnD99RVMDRXD1Li44wBZFZeEaYLcAmgq"
    "W4BfL/zytH97P2PDY6gr+4b2Iq6ICZOTN5D/bzaJZC3ZuvkdL7MikqgevvDTtV3bdo6NDY/S"
    "KBssyzJiQnKhp7oeVUMkYapYivT2/MvGDYt0VJq8lybF7dP3f6u/np1++OQRRajQValRq66j"
    "VllHtISKIVLiGjGJNP6pMD+/iZg6VkO8d+7B6M9nQm6WTVSVV6/mMHVMDTcnpYir4BIxERZj"
    "FdxJGldDHHy3l7kwS5ErnDp4tq0LOnO5lYEKppEQqrg7Kmt6oKocHTlOttzWgRACSWLLLBGX"
    "1OpBdmztBqpKURQc23+8rQMhBERaT+ju24GroHEZ8l+oG2FiYiLX63UWFhba+r9WjwzO09Pb"
    "S1eth85aNx2dXXz42ODN88d/h6/5hZd+H9xS/FfuUdKImw6760Codh1xKZc+AR0ym5uzjKnS"
    "AAAAAElFTkSuQmCC")
index.append('door_out')
catalog['door_out'] = door_out

#----------------------------------------------------------------------
drink = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnNJ"
    "REFUOI2lkM1LVGEUh5+ZeZ0PUtSuYdKnkiTGiJuGpCIkcuumpYtWtnHj2hZt+hsisIXgRqmF"
    "q0AIKQ3ENpEgZDMZNQ3mqIw14/Xe+77ntMnQrDb9lofzPPzOgf9MDGBubs4kEomrqnpZVXtE"
    "5KKInBERT1Vxzm2p6mcReaeqb621r5ubm1/19/dbA2CMuZ/JZMZSqRTGmF92VSUWiwG0iUhb"
    "EAQ53/fZ2dmhXC4/AO7FAURkrKurC8/zSCQSRFGE7/vUajWq1Sq+7yMi1NfX09HRQV9fHyIy"
    "BmB+CsJyuZxsaWkh/72O7XgCyaTRRBIUbLiHC2p4EpFrPcZaIY9zLjwouJXP55/X/MB8qqQR"
    "k8Gk6qhLCgrsWUu1FvJ1r0bla5FoI2+BW7+eCDA7O3vFOTffeuqsWd5U1iu77AaWIHI4URqP"
    "JbnkxaiV3lvg5tDQ0EuA+L5gYGBgUVWvFz8WbI+ntDZmUBRR5Xh9it4T8SPwoQb7mZmZueKc"
    "mz93vt3sxBup7IZk7De2Pq0egQ812M/g4OCiql7/UMjLte7TDPScZvvze/kT/M9MTU09XV1d"
    "1aWlJZ2YmJj82575fTA9Pd3unLvhnDtnjCEMQ1S1fXx8/I6IvBgeHl47uB87APYCj5LJZK6p"
    "qQnf98lmsywvLxOGIfF4nM3NTYIgWLLW3h0ZGXnze4Pn3d3dxzs7O7HWUqlUAMhmsxhjaGho"
    "wBjDwsJCbmVl5RnQdkggIg8LhcJYtVrF8zzS6TSe5wGwsbHB+vo6pVKJYrGIqj4+cgLA5ORk"
    "r7X2tqreEJGTInJBRBCRNVX9IiIvoih6Mjo6+maf+QGUXGiVWqkKyQAAAABJRU5ErkJggg==")
index.append('drink')
catalog['drink'] = drink

#----------------------------------------------------------------------
drink_empty = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnJJ"
    "REFUOI2lkc9LXFcUxz8z7+roMP7qc1FhSslQiQhT3FQiRYJI3Lrp0kVWduPGtVlk07+hBMxC"
    "cKMkC1ddFUlqoNiNVHha33sE6VTFMaA44/PNu/ecbupgYppNvnA2h/P58L1c+MzkADY3N43n"
    "ed+r6neq+q2I3BeRr0TEV1Wcc+9U9W8R+UtV/7TW/jEwMPBmamrKGgBjzNPu7u6lQqGAMaZt"
    "V1VyuRzAkIgMpWk6niQJFxcX1Ov1n4AneQARWRoZGcH3fTzPI8sykiSh2WzSaDRIkgQRoVQq"
    "UalUmJiYQESWAMx/gla9Xu8cHBykWCyiqu3Jsow0TcmyjEKhQKlUIgxDnHMtgJsGj6IossfH"
    "x3ieB4BzjjRNSZKE6+tr8vk8fX19hGFIEARWVR+1BdPT069VdTKOY1ur1TDGYK3l6uqKy8tL"
    "rLX4vk8URQRBYIHpubm5120BwMzMzO+qOhmGoT08PKRYLNJsNrHWUi6XieP4Dtz+xtvZ2Nh4"
    "4Jz7rVKpmHK5TEdHB1EUsbe3dwd+r8FNZmdnb5pIb28vnuexv78vH4M/mbW1tZcHBwe6vb2t"
    "Kysrq/93Zz5crK+v33POPXTOfW2ModVqoar3lpeXH4vIq/n5+be373O3wDHgWWdn53h/fz9J"
    "klCtVtnd3aXVapHP5zk7OyNN021r7Y8LCws7Hzb4dXR09Ivh4WGstZyfnwNQrVYxxtDT04Mx"
    "hq2trfEgCH4Bht4TiMjPcRwvNRoNfN+nq6sL3/cBOD095eTkhKOjI2q1Gqr6/M4TAFZXV8es"
    "tT+o6kMR+VJEvhERROStqv4jIq+yLHuxuLi4c8P8C6eiceQc1eGsAAAAAElFTkSuQmCC")
index.append('drink_empty')
catalog['drink_empty'] = drink_empty

#----------------------------------------------------------------------
drive = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXhJ"
    "REFUOI3VU7uqIkEQPe30MI2vZNBAQTAz8RsuaLKf4Rf4AxfubznJynyD4gOMBAPBTBDt7qqu"
    "jaYZ7262m2xB0dVNnVOnqGrgvzdVBYfD4WcIYcbMICJ476M756Jba+GcWy8Wi3kk2O/3H8aY"
    "stfrwTn3WxURiXGapijLEufzeb5cLtcaAJj5q9ls4nq9IsuyCKoDRQSXywXdbhfj8RjH4/ET"
    "wFptNpuPLMvKPM9xv9/f5BIRRARKKSRJgjRN0el00Gq1UBQFTqfTXBPRV7/fh/ceSZLAGANj"
    "TKxeVyIiCCHg9XphOp1it9t9au89Ho8HbrcbrLUxiZkRQoj36k1EoLVGu92GtRbaOTcDAOcc"
    "mBnb7RZKKTQajTcFFdFoNAIzYzgcwns/09ZaEBGICMwMZoZSCiGEtwl8V1GNWFtrIzCEgMlk"
    "EpNF5I+tVHEkyPM8Mtfl1qt/b2cwGICIoJ/PZ7FarX7Utiyelde3st6qiBR/9xH+hf0CrzJz"
    "5J8g6VMAAAAASUVORK5CYII=")
index.append('drive')
catalog['drive'] = drive

#----------------------------------------------------------------------
drive_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAihJ"
    "REFUOI3Fkr9rk0EYxz+X933Ja5tkMLRqK6UdhHaILlJqBwsNhboI4j9QcSvSxaVQ6NzVpUMX"
    "RxGHahUaRGtABHHSxiSFuAQiRlOpTUmTu/fuPQfJa4ogbj7w5Z477vvjuAf+d4luUy6XX4Zh"
    "OGuMQWtNEAQRlFIRpJQopXYWFhaykUCpVJrxfT8/MDCAUuoPF2tt1HueRz6fp1qtZpeWlnZc"
    "AGPMal9fH/V6nXg8HpF6idZaarUaqVSKsbEx9vb2VoAdsbu7OxOPx/PpdJpms3kirtYaay1C"
    "CBzHwfM8kskk/f395HI5KpVK1tVarw4ODhIEAY7j4Ps+vu9H7r1JrLWEYUin0yGTyVAsFlfc"
    "IAhotVo0Gg2klNElYwxhGEb77pm1Ftd1SSQSSClxlVKzAEopjDEUCgWEEMRisRMJukIjIyMY"
    "YxgeHiYIgllXSonWGq01xhiMMQghCMPwxA8ciM8cel8oV/O0O8dcbF0hCAJcKWVEDMOQ8fHx"
    "KLK1FmMMnw7e46S+MzcxzfnTF3hVfMzbj5s0Y4lfAul0Onpfb9yu+1ZlgxuT85iY4dK5OV6U"
    "HjGVmeZh5Rluu93ObW9vz/dMWbR2sR//iicSXJu4DcDd7AZPC+tYsfV7lP9WU3eG2jevz/ua"
    "kOW5+6w9v4XvxHmw+aTj/IvA0OXEqSPVuDp6ZpT94xqHrW+8+fCa5g95758SAEwunl1DiEUB"
    "SQtHWLv+br2+/BO8Y3V9/fDsbgAAAABJRU5ErkJggg==")
index.append('drive_add')
catalog['drive_add'] = drive_add

#----------------------------------------------------------------------
drive_burn = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAghJ"
    "REFUOI3Fk01rU0EUhp97c6/3tvloyjW1WqmULoxCEVeupJBuiv/AXX9B10KhW9f+B6si7lwY"
    "EEt2rkRoaFJJXUSLtE3FGo12vt2YMUWkSw8c5szLnPe8M3MO/G8LhkG73X5lra0ZY9Bao5Ty"
    "LqX0LoRASrm5srKy5AlardZimqaNSqWClPKvKs45H8dxTKPRoNvtLq2urm5GAMaY9fHxcfb3"
    "90mSxCeNJjrn2Nvbo1QqMTc3x87OzhqwGWxtbS0mSdLIsox+v39KrtYa5xxBEJDL5YjjmGKx"
    "SD6fp16v0+l0liKt9frU1BRKKXK5HGmakqaprz6qxDmHtZaTkxMWFhbY3t5ei5RSDAYDer0e"
    "Qgh/yBiDtdbvh5hzjiiKKBQKCCGIpJQ1ACklxhiazSZBEBCG4SkFQ6LZ2VmMMczMzKCUqoVC"
    "CLTWaK0xxngfYkP85tsnlI/eUz7e5ca7h/6LIyGET7LWUq1WvWTnnMevfGxx7esbsmAScanA"
    "kbV/CLIs8/cblTt8vOLzB+TnB2TJPNQC0u6A67vP0FoTbGxsvFBKLY90mV+llCxnT7ka7zIx"
    "fYGkPwl3AO2g84P2l7ED38r/sk+3eBTf426RaZLPZbgNTAA9Cfe/PQ7PnBbJoXsJPy8e4pyF"
    "g9/4aw19Ds9U8OEyY1HIMSXOBSLU05XzMEbEdycJkvIvlbh5SKyjiWIAAAAASUVORK5CYII=")
index.append('drive_burn')
catalog['drive_burn'] = drive_burn

#----------------------------------------------------------------------
drive_cd = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp5J"
    "REFUOI2lk81rXFUYxn/n3nsyE28ywcgQcEwgE7WUUSru/IC0CVoRXFZcWEQIusvObiLBYsWF"
    "/4AupaALdamNkXxLUsRNBUs1TrCZSRrHMJNM25nMPR+vi5LLBHHlgRee95zzPO/DOTzwP5c6"
    "BhsbGwve+wlrLc45rLUnyhjTjRenpqYmU4H19fXxOI6Xi8UiSZL8a4qIpFhrzdLSEtvb25PT"
    "09OLEYBzbnZwcJC9vT0ymUxK6iaKCNVqlVwux9jYGOVyeQZYVKurq+N9fX3LIyMjNJtNkiRJ"
    "y1qLiKCUIgxDtNb09/cTxzELCwtsbW1NRs652Xw+jzGGMAzJZrNks9l0ercTEcF7z9HREaVS"
    "ic3NzZnIWku73aZer9PpdNJLzjm892l/vCciRFHEwMAA1loia+1EGIY0Gg1ardYJwn8JxHFM"
    "oVDAGDMRHX/P/Pz8CYFuy91YRCgUChSLxdQBv+3eozZ0nvffOsutmuWhnoC79b+4fnOH6v49"
    "zj0zzBPFUeotz+khzZXPl/ix3MJaS2CM4c+G8Pb5ErtNTysRMpHi+s0dXnpS897LeVZuVOjt"
    "UXSscLthmb34HJVDUoG58u0q2Z4I4x68dqDg7Jlhfvjd8Mn834yfGaadPDgzDo6MUKvVcM7N"
    "KYA3Pv7uzRdLj1194dlTWC88mgvp1QE6hFbiubFraLY9XmD44YhqtcI3a+UP7nQyHwUAWvS1"
    "tV935irVHR5/JKJXBzgR7ifCQVto3PfksgGnhyIO9vf4eu2Pn1QYfLFy+ZxNw3Thw+9Hw9Bf"
    "Ebjw7qtP6adH8+geTccIdxptDg6bfPrtL1aEa4GoS1/OvHLrRBoB3vnsZ313v/a8BMFFEXlN"
    "QR6lFEhFRK2Auuo7h8tfXX49Tdw/FhO23NqeK4wAAAAASUVORK5CYII=")
index.append('drive_cd')
catalog['drive_cd'] = drive_cd

#----------------------------------------------------------------------
drive_cd_empty = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXFJ"
    "REFUOI3dU71qAkEQ/o69w5P1BxQbDyzO0oeIaJMHsfYFAnktg6AGC30I0UIsrBQsPL2d2UkR"
    "djkjqdJlYODbYeabb3ZngT9a4MB6vZ5ZawdEBGYGET24MaaI56PRaOgJVqvVi9b6M01T5Hn+"
    "1EVEPI6iCIvFAvv9fjgej+chADDze6PRwPF4RKlU8kXFQhHB4XBArVZDt9vFdrt9AzAPlsvl"
    "S6VS+ex0OrhcLsjz3DsRQUQQBAGUUoiiCNVqFVprzGYz7Ha7YcjM761WC8YYKKUQxzHiOPbd"
    "i0pEBNZa3G439Ho9bDabt5CIkGUZTqcT7ve7T2JmWGv92cVEBGEYol6vg4gQEtFAKYXz+Yzr"
    "9fpQ8BuB1hpJksAYMwjd80yn0weCouQiFhEkSYI0Tb0CMDP6/T6yLHvq7kYB4GPlchnW2m8C"
    "YwyazaaX59wlu8LihYoI2u22J/iYTCavbpQfG/e0kW5LmRnM/PHXr/Af7AunwXT+IlQl1wAA"
    "AABJRU5ErkJggg==")
index.append('drive_cd_empty')
catalog['drive_cd_empty'] = drive_cd_empty

#----------------------------------------------------------------------
drive_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAh9J"
    "REFUOI3Fkk1LlFEYhq/3Y5rXGR2LQVGssWmRQrhsZSBoC+sHFK2aVu4sWgWCtIgW/YH+QvsK"
    "p1AZylWLFiPOCIORpsOEaTQyjue7RczbSBDteuDhPOdw7o/DueF/l9cZqtXqirV22hiD1hql"
    "VNxSyriFEEgpVwuFwkxMUKlUpqIoKg0MDCCl/EPFORfPiUSCUqnE9vb2zPz8/GoIYIxZTKVS"
    "NBoNkslkDOoGOufY3d0lk8mQz+fZ3NxcAFa9crk8lUwmS9lslmazecqu1hrnHJ7nEQQBiUSC"
    "vr4+0uk0xWKRWq02E2qtFwcHB1FKEQQBURQRRVGs3u3EOYe1lpOTEyYmJtjY2FgIlVK0Wi32"
    "9/cRQsSXjDFYa+N958w5RxiG9Pb2IoQglFJOA0gpMcawvr6O53n4vn/KQYcol8thjGFkZASl"
    "1HQohEBrjdYaYwzGGDzPw1p76geG9j6Q/byG/7KBypzjaPIWSilCIUQMtNYyPj4eW3bOYYyh"
    "p7LMMDuM3XtAMn+FdvktlbUVLn3v+UWQzWbj93Xb7agfvnjF5bv3ibZK8O4Jqf6zXMyNMlb7"
    "SNhut4tLS0uzXSmL107PfqsTDeXh5sM4F+HjYfrV8e8o/63eXA++TN4pnE/vvEa0GxwDR82A"
    "6hZ7wb8QzF0d6j/8Wr/mnwl8FbT4ceD4VPeN0e7ZPzkAeH/7wqPjg/qcb71R67s9i3t+Y9k+"
    "/QmZLHUjjvoOfgAAAABJRU5ErkJggg==")
index.append('drive_delete')
catalog['drive_delete'] = drive_delete

#----------------------------------------------------------------------
drive_disk = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlBJ"
    "REFUOI3Fk71rk2EUxX/P+9G85otKbBSKYheNk1C0g4OFBkRBEOcsXaR06T8g1sVFUPEvcHAR"
    "dyFBsQZEcBChpSSRgtg2SG1QS9IkfZ73+XCoja0fsxcO3OWce7j3HvjfJfaaer3+0lo7ZYxB"
    "a00cxwMopQaQUqKUWpieni4OBGq12mQURdWRkRGUUn9Mcc4N+jAMqVarrK6uFufm5hYCAGPM"
    "fDKZZGNjg0QiMSDtJzrnaDabZLNZxsbGaDQaN4EFsbS0NJlIJKq5XI52u33ArtYa5xxCCHzf"
    "JwxDMpkMqVSKSqXCyspKMdBaz+fzeeI4xvd9oigiiiIelLfJJKCnNIfTQ3ze7CM8QzrZwbpt"
    "vrcL6M763SCOY7rdLq1WCyklzjmstfR7WaYmTnNtPM2zt01ulc4c2MvjaotX9tI5Tyk1BaCU"
    "whjD4uIiy8vL9GTMt44G4MW7LwPijoa2hNaWQghLIKVEa43WGmMMxhiEEHiewHcQG8v92XGs"
    "dTjAx5EMQEpJu6t2BfaI1loKhQLWWmofPHZkzJ2nn/AEaGOxxuL2zuogGf50kMvlMMYMTuec"
    "Q9cl0mh8LwQcgl1nzjqcs2gdo5Qm6Pf7lXK5fHnflyGlpBNfJBQBs1czaKsADxw4YYmCIe49"
    "WeNru0tQKpWu/O3Hr99+7XxCLH0evZ/hSPIEAo9Wb50b5x/iEdGTiuBfIQkCn5PH4Gi6Q/Hs"
    "BMNDo+DB1s4o+ZQmOQSBEL/C9HuNzzx/c+r4oQvDiWGiIIu2McJahDNY0aOx9pHNdswPOolk"
    "g+Z5nTYAAAAASUVORK5CYII=")
index.append('drive_disk')
catalog['drive_disk'] = drive_disk

#----------------------------------------------------------------------
drive_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm5J"
    "REFUOI3Fk8tLVHEUxz/33rnecdJRGx81vZwoMKQXkQUVggbZc9febRtp0aqiRTv/ghY9VknS"
    "P5AQyvSGSKvxMVPYY8imwVc1Nej93d+jRXgxdd+BL+dwON/vORzOgf9t1lKQzWYHtdYdSimk"
    "lARBEEIIEcL3fYQQQ93d3Z2hwMTERHs0Gk03NDQghFjVxRgTxq7rkk6nyefznT09PUMRAKXU"
    "tVgsRrFYxPO8kLScaIxhamqKeDxOKpUil8tdAYasTCbT7nleOpFIUCqV/hlXSokxBsuycByH"
    "WJDB+fQQp2o35dlHfPuueq2RkZHBZDLZYYxBCBF2Xe6NMdi/hojOT1JZf4ya1H5+fHpBZuCO"
    "iARBQLlcZmZmBt/3McagtUYphdYaYwzVepiWrYKqnUeY/5ClwhJUxzdQU78pEhFCdAAIIVBK"
    "MTo6imVZ2LYNQGPlZw62Rand3oX/rZ+KmEX+TY5A2tx7i237vo+UEiklSqkQUkrWu5Mcb3Op"
    "3XGaxcJNLPc7blU1zkIBv/kMc2VDxPf9kKS1pqWlBa01zL/kwC6Pmh3nWPx6A9uViFKK4uNX"
    "5NadpKmyiSAI/gokEgmUUuHCFgpPiDct0Nh6FlG8hVNhWPy5jemnw5RaL9Lk1ZFMJpFSYvX1"
    "9T0IgqBr6cqYfU3HoQ1Iq5HE+mfUNVaw+HMLX9LD3H2fZG7BDic2xgyEp7xk93s7zfkLt3nX"
    "f4nC5+d4W/cSTM8Uah1O7LvyamxlvbMysae58urhzTV23cYtzE/N8mU8+9txnc6j19+OrvVM"
    "qwQSseBy/uM48vec9j311EZ3neody61FBvgDkTtp1juligQAAAAASUVORK5CYII=")
index.append('drive_edit')
catalog['drive_edit'] = drive_edit

#----------------------------------------------------------------------
drive_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmRJ"
    "REFUOI3Fks9LVHEUxT9v3pvmOTqTMjqZU4sxLAsFxYWbwnIWtS0XEbVwH7hpKQj9CUGLqFaB"
    "LaKEBMlNMpsWakYo4w+GUGEWYy6iSRu/v1tULyP3XThwL5dzzoV74H+X97tZW1t7a60dNsag"
    "tUYpFUFKGUEIgZRybnR0tBAJrK6uDoVhWGxra0NK+Y+Lcy7q4/E4xWKR7e3twtjY2FwAYIyZ"
    "SCaTVKtVEolERDpMdM5RqVRIp9Pk83nW19fHgTlveXl5KJFIFDOZDLVa7a9ztdY45/A8D9/3"
    "icfjpFIpGhsbmZ2dpVwuFwKt9UQ2m0Uphe/7hGFIGIaRu3MO9kvw9R02fQtrLQcHB/T29lIq"
    "lcYDpRT7+/vs7u4ihMA5h7UWYwzWWjwnOe3NkO0sUN6Yoqr7CYKApqYmhBAEUsphACklxhhW"
    "VlbwPI9YLAbAmeZtWgcukj7ZT3L5BcfooG5ayeVyKKWGY0IItNZorTHGRNBaE3o1cg1bpFqb"
    "MbVpTvWN0iKXMFpGL44JISKStZbu7m66urro7MzT075LR89NOPjAwrNJmprrhPVPJOUm1lqU"
    "UgRCCDKZDMaY6HXOOdy3dZplklTLd0xtE5zF7C2Sv3wPNfeEE9kRtNZ4k5OTb5RS1w6lDCXr"
    "DLYs0le4Qxifx8rKr9zG8RsH2CnHmHo9w2I1MxtF+XC9f3TpbtuF6w/bzzZg9hZwTrL0ao2B"
    "kfN4/nFouMri0/HPnrZXjhSYfzBY6b39POfHtnD6C+AObWP4DefYKX1kY/r+y+AoASVkuPT4"
    "Rt1Zh7P2J5zjz+zAWrCu/Qe62HrCDMEMyQAAAABJRU5ErkJggg==")
index.append('drive_error')
catalog['drive_error'] = drive_error

#----------------------------------------------------------------------
drive_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkRJ"
    "REFUOI3Fk81qU2EQhp/TJOSYpkGNqUK0kEqlVQJuREGkkKB0qXgB9gqK4M6qCP7dgSsvwJ8L"
    "aBAtcWEXVVy0NG2tIrG1RoKK1Zjz/cz3uRAPrSIufWFgZpj3nXcxA/8bwa9kcXHxsXOuIiJY"
    "azHGxKG1jkMphdZ6enx8vBoLNBqN0TAM64VCAa31H1u893GeSqWo1+s0m83qxMTEdBJARK5k"
    "MhlarRbpdDombSZ671lbWyOXy1EqlVhaWpoEpoO5ubnRdDpdz+fzbGxsbLFrrcV7TxAEJBIJ"
    "UqkUfX199Pb2UqvVWFlZqSattVf6+/sxxpBIJAjDkDAM4+2bnXjvcc4RRRHlcpmFhYXJpDGG"
    "TqdDu91GKRUPiQjOubiufbpJ13QY236RdGob2WwWpRRJrXUFQGuNiDA/P08QBPT09Gxx0M0q"
    "9hZGuP/uMmd3XaVYLGKMqSSVUlhrsdYiIogIQRDwOv8A5wzaWbS1FHcMMbLnKF+jDndWz3O5"
    "eA9jDEmlVEx0zjE8PIxzjlefNScPnUO8Q5zg8Kx/WaW89zjfdJcLT8Y4IKd/CuTzeUQktuu9"
    "J2prxDuaH1cwzmKdwYhhQ33l8L4TfDPfme3eJdntdmtTU1Njm64MpRRRIcKKZXduAOsE8Y73"
    "X96yM7uHF6tPmX35jKFWdSY+5d9x5nbJRVqjnSaymv2FQ8GxwVM8fzvDo+WHLS1UW7do/FXg"
    "dxy8FnSODFQy9ZeP35mA6vp1lrc8079QukRHfCKjkMEPN3jzq/8D8mmDC9o8s5AAAAAASUVO"
    "RK5CYII=")
index.append('drive_go')
catalog['drive_go'] = drive_go

#----------------------------------------------------------------------
drive_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk9J"
    "REFUOI3FUktrU0EU/uY+vNeU3ErzqnXTgmCoBISCG5VCCyoobty56kIRBLt0U+i/EHeCqBvT"
    "nWCC2JCudCGKKWmi6SuYltAbic2zM3ceLmqHWu3aAwfOGb7vO98cDvC/gxwUpVJpUUo5JYQA"
    "5xxBEOhkjOmklIIxlpuZmZnWAisrK5Ou6+ZjsRgYY39NUUrp2rZt5PN5VKvV6dnZ2ZwFAEKI"
    "+VAohHq9DsdxNOkwUSmFWq0Gz/MwNjaGcrk8ByBHCoXCpOM4+Ugkglar9YddzjmUUiCEwDRN"
    "2LaNcDiMgYEBZLNZVCqVaYtzPh+PxxEEAUzThOu6cF1XT9dOlIJcfQFzq4aedxGp1ASKxeKc"
    "FQQBut0ufN8HpRRKKUgpIYSAlFL3XnMJybN7GBy/h/r7x+g39hdqMcamAIAxBiEElpeXQQiB"
    "YRjawRlSwkSqjcFzV9GtZnAyPIphfwlxEUwZlFJwzsE5hxBC58Eb5xwJx8ep1E2IXgVudARW"
    "CBi5ch63xndhUUo1SUqJZDIJKaW2L4SA6qwjaG7CMBsgRhcnvAaw10OvTvcFIpHIPvD3wg7+"
    "TTrr8JpvYA9LSF6EIX8CRhgqYPia3sDC2hCsfr+fzWQy1w9dGSilGDHXMO59x+kbt6HYWxDR"
    "RuF1G6LlwyQEC5UotjGU1ad8NKrpa58Tl+5cYI0nsKxBlBY7vY8fth8m2q10NApcfvqjDQDW"
    "cQKGQRgxt2A6MRSzjc6XTzsP7r/ceH4Ud6zA9qb/rrWbG+02e/3VbzuP7j5be/Uv3C9Ub3vA"
    "PdoSQgAAAABJRU5ErkJggg==")
index.append('drive_key')
catalog['drive_key'] = drive_key

#----------------------------------------------------------------------
drive_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAodJ"
    "REFUOI3Fk89KI1kUxn+VqqJKS03biRoUIprVoPENhtARhhlwMytFN256MRtfoKGXAy7ciM8x"
    "vVQG2okL3enCwj/oxoimDJEGkxR6b91bdxaNRcs8wBw48J3D+b7zLc6B/zusV3BxcfE1TdO6"
    "1hqlFEmSZCmlzFIIgZRyf319fTETOD8/r/m+3xgbG0NK+Z8txpgMu65Lo9Gg2Wwubmxs7DsA"
    "WuvPg4ODPDw84HleRvqRaIzh7u6OkZERZmZmuLy8/ATsW6enpzXP8xqFQoFut/vGrlIKYwyW"
    "ZWHbNq7rMjw8TBAE7O3tcX19vegopT6Pj4+TJAm2beP7Pr7vZ9t/dGKMIU1TXl5eqFarnJ2d"
    "fXKSJCGOYzqdDkKIbEhrTZqmWf3aM8bgOA5DQ0MIIXCklHUAKSVaa8IwxLIscrncGwevQuVy"
    "Ga01U1NTJElSd4QQKKVQSqG1RkpJr9fD931KpRI3NzcMDAxg2zb9fp98Pk+73ebp6em7AyEE"
    "Wmu01iRJQrfbpVgssry8TBzHVCoVjo6OUEqxurqK67pEUcTx8TG9Xu+7QKFQQGvNyckJSil+"
    "rtfZ3t4mDENKpRLVapUoitja2iKKIubn51laWqLZbOI8Pz/v7e7u/iql5PDwkEqlAoDjOMRx"
    "zMrKCqOjo/T7fTqdDjs7O9zf3wOQz+dTZ21t7bfXY1lYWPjD9/0/gXdhGP5tjPmwubnpBkEA"
    "QBzHAEm/3/8H+KXVanWzXwCYm5v7aXZ29q9arVYql8up4zjv2+02V1dXeJ7H9PQ0ExMTKKW+"
    "3d7e5g4ODh7eCAB2rVarBkHwZXJycszzPNsYk3t8fPxoWdZ9sVj8ArhCCN1qtTpxHP/+LwIR"
    "hH+tWgupAAAAAElFTkSuQmCC")
index.append('drive_link')
catalog['drive_link'] = drive_link

#----------------------------------------------------------------------
drive_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAilJ"
    "REFUOI3Fkr1PU2EUxn+3997e21sKmIYCJSaUwbA06uCoRFg0/g+GRUf+ARLi5ODo7ODo6CR1"
    "kJTVRAYItAZMbEKkEZXY0o/32wWvGImJk0/y5D3DeZ7z8R743/B+Bo1G4421dtEYg9YapVRK"
    "KWVKIQRSyo3l5eWl1GBvb28hjuP6xMQEUso/qjjn0jgMQ+r1Oq1Wa2llZWUjADDGrCVJQrvd"
    "JoqiVHRe6Jzj8PCQ0dFRKpUKzWZzFdjwtre3F6IoqheLRTqdzm/taq1xzuF5Hr7vE4YhhUKB"
    "fD5PrVZjf39/KdBar5VKJZRS+L5PHMfEcZxWP9+Jcw5rLcPhkGq1yu7u7mqglKLX63F8fIwQ"
    "Ik0yxuCcZZhMIzMxpyIiCgPGchb36R35wjhCCAIp5SKAlBJjDDs7O3ieRyaToXTlBklukqvl"
    "EYLQ5/N3yUlX0M3NUh5zKKUWM0IItNZorTHGpNRaw8hl5iYTToTHUcegPZ+ZUgGTHU+/OBBC"
    "pCJrLfPz81hrsdbyZSDJZkO00FgHQjviwEe7AGvtL4NisXg2s0tpraXfD5HKoAxoe7ZID/q9"
    "HuVKGa01wWAwqK2vr985d2XpO1O9TXfqOoVcFmEcQcbj6JvCfX3Ps8fPcS6upad8EZ6+/liJ"
    "Pe5fGsk+sg46vaFV7YZ3s3Tk9Q42ux8aWw//anARXq7dfTA1Pf2kNHdtvPn2Vd//V4MXmwdb"
    "t2ZPW0oM72V8P/kBnatu3Fd1F8EAAAAASUVORK5CYII=")
index.append('drive_magnify')
catalog['drive_magnify'] = drive_magnify

#----------------------------------------------------------------------
drive_network = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfxJ"
    "REFUOI11kr1qG1EQhb/du8uKyFKIjC0wyMWqCiZP4MIgNXmFlAFVErhIa+JHSOc6ZR5BhiDJ"
    "uJD6YEhhVoVQYaWLC8nauT8p7L3YljIwMHDOnHvuzAQ8xWQyGVhrW1prjDForV+kiDyvh51O"
    "pw0QAIzH45NyuXyVpil5nvM6nHO+juOY0WjEbDZrn56eDiMAY8x5rVbj7u6OJEl80/NG5xzz"
    "+ZxqtUqz2STLsjNgGFxfX5/s7OxcHR4ecn9/T57nPrXWOOcIggClFHEcU6lUKJfLDAYDptNp"
    "OzLGnO/t7SEiKKUolUqUSiX/+nMnzjmstTw8PHB0dMTt7e1ZpLVmtVqxWCxYLpe+wTnnHVhr"
    "ARARnHNEUcT+/j5aayKtdUspxc3NDUEQ+OY8zwnD0AuIiMcB0jRFRFpRsZ5Go8F6vcZai7UW"
    "pRQigjHGz0FEsNbinPNrjYq9T6dTwjD0AsVMCgER8Y4ArLWPAiLC7u4ux8fHnlyQjDGeHIbh"
    "C/zg4MALXPb7/Y+FpVcXt3GRxZUaYzDGXAYbZwf0er0PSZL8qtfrAMxmM3txcaG2cYNut+u2"
    "Aahkmat3CUCs/y4Du6pso0UAzWZzA8iy7E3a6gEw//m18h/Oo0CWZRvgH9eQt0sTFzVZFm/9"
    "wlb7QP3T7284Pj+xvi9+vP+yjfcPcs6PXwngtjsAAAAASUVORK5CYII=")
index.append('drive_network')
catalog['drive_network'] = drive_network

#----------------------------------------------------------------------
drive_rename = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZtJ"
    "REFUOI3NUruKIlEQPXe7m24U2+AiDSbiBxgZTTSgyf6DifmyjpgOzCcMyuIXSH/DmIw0GExu"
    "YAsmCgbGguJ91gaz3nF2d2CznQOHKgrq3Lp1CvjfYJckz/Nna23LGAOtNZRSjlJKRyEEpJSz"
    "brfbdgLL5fI2iqKsUqlASvnHK0Tk8iAIkGUZttttu9frzXwAMMY8FAoF7Pd7hGHomq4biQi7"
    "3Q5xHKNer2O1Wt0DmLHFYnEbhmHGOcfhcHg3rtYaRATGGDzPQxAEKJVKKBaLmE6nWK/X7S9a"
    "64dyuQylFDzPQxRFiOMYnHMkSYIkSTCZTDCfz5GmKay1OJ/PaDQakFLe+0opHI9H1Gq1Dzc9"
    "Go3Q7/cxHA5dbbPZQAgBX0rZuhTvfryAMQYQgbHXFTMAj99ucDqd3on+mrrlCyGgtXaeMvba"
    "7CIIf8PFYl8IAWMMAGD4/ebDb/wOa+2bAOcceZ4764gI1lpn43g8RrPZxGAwQKfTARGhWq1C"
    "aw2WpumTUurr1ZW5eOH1VWqtYYyBMQZENP3nkT8vfgL/UgnFeOFrowAAAABJRU5ErkJggg==")
index.append('drive_rename')
catalog['drive_rename'] = drive_rename

#----------------------------------------------------------------------
drive_user = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI3FkstLVHEUxz/Xmdu9zUuYy0xTbVKw7OGmSCJ6gG6CNtU6SKpluGoXtKho26JFf4EV"
    "BEEtykXKEFGJkI9JRx2sNKsZJ4lMnX7392pTtxetO/CFs/l+zuGcL/zvcn405XJ5wBjTpbVG"
    "KYWUMlIYhpGEEIRhONjT09MdASYnJw/7vl/M5XKEYfjXFGtt1LuuS7FYZG5urru3t3cwDqC1"
    "vphIJKhWq3ieF5l+NVprWVhYIJPJ0NLSwtTU1AVg0BkfHz/seV4xCAKWl5d/W1cphbUWx3GI"
    "xWK4rks6nSaZTNLf30+lUumOK6Uu5vN5pJTEYjF838f3/Wh6o9Hg0a0bfB29y1cDjexOjp27"
    "REdHBxMTExfiUkpWV1ep1+sIIbDWYoxBa40xhsnnAzTG76GtxDoxVuaH6bt+hRNnzyOEIB6G"
    "YRdAGIZorSmVSjiOQ1NTEwDV0QHyG1oJmtNMT0/TXNjIUn2G5kwGKWVXXAiBUgqlFFprtNY4"
    "joMxBoBUYQsnTx0nud7ny9IH4qmAB/fvI7+/Oi6EiIzGGNrb2zHGYIzBWsvTD4uUR4bY3dlJ"
    "JpvnzasZRus+24z5CQiCAK119LofdxgbG+PV61kG1+9g6M4TEi7MfkmwYj2Gh4dRSuH09fU9"
    "lFIe+SVlCCGoLy6STCap1mqsra2xb/8BNhQK3Ll9k3Q6jeu61OuLU1GU/6zS5T2vq5uPbnk8"
    "v46Vz0vUajWUUnieh+slObQrx175TDX9C5AKNg19elNifuE92WyW1tZWPM+jra0NqQ3z5Rck"
    "MqnR+L8AfmrrGcd7d3W2Ujm98ql20FqbEkIwMjKi31Y/vtzeWbjm5vIz3wCbGX6/Q+pxhQAA"
    "AABJRU5ErkJggg==")
index.append('drive_user')
catalog['drive_user'] = drive_user

#----------------------------------------------------------------------
drive_web = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlZJ"
    "REFUOI2FUM9LVFEYPW/uHX363jTjDGM2TjI2JIYGgSTlRjAjCVrVoiA3bWrRrqUg9B9EmzZu"
    "hLaVQTW2mJKRUag2aUQ2OTMqTcNgI2k589791SLe4/kKunDhft8953zfORr+cW7lJy8cix2+"
    "393Wl/7FNFT2P258qWzceTjxeM6PJf7GzcXr5yd6h59dSlzt7Gg5GWByMBCSpzrCZv1K6xm1"
    "uvak9MmLD/gFUrHYg+PR4eCGFFj5Abys1ZEj75Hs7KIRw7znx1N/o+9QKvXOKiAiTuP1VgMi"
    "+Rkfgk9BvhvojXQn/ysgpIV9C3hTkSjVKfT9JNr2bkALL8Dihb/yci0sLy9n8/m82tzeIZ2s"
    "gZ+NArSAjtq3COTOFtI6UNzcJrOzs2pmZiZ7IMSlpaVRwzDu9vf3w5BRvK0+x1D8BFpkF44Y"
    "TQwffYG1r6u4Nngb42fHUavVekdGRhYzmUyJAoAQYjoajaJaraKrtRtDrZcxt/IIXCyCBm2s"
    "Viq4mJpE+147yuUy0uk01tfXpwC80nK53Khpmgs9PT3Y3d2Fbdvu5ZxDKQVN00AIQTAYRCgU"
    "gmEYyGazKBaL56gQYjoej4MxBkIIdF2HrutQSgEAlFIH3lJKNJtNDAwMoFAoTFHOORqNBur1"
    "OizLckFCCEgp3drpKaVAKUU4HAbnHJRzPkYIgW3bLsBP8NdCCJimCcbYGGWMgXMOzrk71TvZ"
    "L+L8OTzqEB2yX8RvxclESvlHgDGGWCzmTvICnPCklAcCVUohkUi4AvOZTGbCWclryfv22vRs"
    "Pf8bqgrLGitO17MAAAAASUVORK5CYII=")
index.append('drive_web')
catalog['drive_web'] = drive_web

#----------------------------------------------------------------------
dvd = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAu1J"
    "REFUOI2Nk89rXFUUxz/3vjcvYZJMpliToelAmISIUJtxIYzJdBMUXbhSGPwVEXQThDTMpmuX"
    "s3mLELtSFxJLnaoVkUKJKZ0mmcwyf8Grtk4wE3Smk/S9ee/eO8+FBGJQ8LM6i+85nO/3cARn"
    "qNfr82EYvqOUmlNKZZVSdhRFrTAM78HxN4uLS/dP68VJsb29PSKEqERR9PHU1FRieHgY27ax"
    "LAutNfv7Te7fu62l6N/sKf3J1aufdgGsk2Yp5a1MJvN2Pp+3BgYG6HQ6BEGAEIJUKsWzz4zw"
    "4uWL0vd7lx89bl6Zm3/lu1qtFkoAIURlfHz8tWw2ixAC27ZRSqGUwrZtpJSoqIPpG64UXyL/"
    "wvNFGf/5GYC1tbVVUEpdn5mZEc1mE8dxGBwcJAgCer0e6XQay5Ko3u9Y8m+7k5NZfrqzfalY"
    "fHlTGmM+mJ6elu12G2MMzWaTbrdLKpVidHQUYwxG+4BGyCH68jwiMcmbb70vj47Ue/bKysrS"
    "2Uv8F7u7u2il0YHPxMQEYRjO2QDr6+s4jkOr1cLzPFzXpVwus7CwgO/7NBoNXNfl8PAQYwxC"
    "CJLJJFEUXZQAjuNQKpXwPI9cLsfa2hqFQgHf9ymVShQKBQB+OzK0nhoOjjWdsI/f00KeXdPz"
    "PMbGxv7VgooloXBQ1iC/HnYJtDmQAFEUUa1WyeVyuK5Lo9GgVCqRTCapVqs0Gg0AjNZorbBs"
    "m8cPPYRROyKfz8f/N8Qbt25zEMSkRs9R/ujdvm31i/be3p5YXV29Pjs7u/TcbI4nT9sYbTDG"
    "oLWh3zfEcUzKOU9CQm4sxY1vv8eW4svNu3d3JUAQBNce7NQ2aw9qJBIJLNsCICYGIRBC0JeK"
    "dDrN5p0f+fmHmxvBcacMp56pUqmMtLt/uJ1u+8PX33jVzlzIMDSUJI5juk+6/PLwEV9/UVUq"
    "Up/7vn+tXq8f/WPACcvLy8VA+YtBL5jvBcEFHSl03+zHOt6JQv3VxsbGzmn9X+ita3L3FA1i"
    "AAAAAElFTkSuQmCC")
index.append('dvd')
catalog['dvd'] = dvd

#----------------------------------------------------------------------
dvd_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAw9J"
    "REFUOI2FkUtMXGUcxX/fd+88MtJhDG0g0omTATEkFQaNZoRhg0ariZr4mNQoJo3GBImU4EJ3"
    "6q5dOIkEWbhxIQucqo2PuLCAHaAwcYWvuPJqaoe0QyPDDNzXd78ZF6amITH+VmfxP8k5/yM4"
    "xMbGxojnec8rpYaVUkmllOn7ftXzvBXY/2R8fOLSrffiplhfXz8ihDjn+/4rPT09oba2NkzT"
    "xDAMgiBge7vCpZULgRTNRVcFk2fOvFsHMG6apZTnu7q6TmUyGSMSiVCr1XAcByEE8XicYx1H"
    "GBo4Lm3bHbjyZ2V0eOThz0qlkicBhBDnOjs7H00mkwghME0TpRRKKUzTREqJ8mvopmY0dz+Z"
    "e/pzsvXXBwDG2tpaVik139fXJyqVCuFwmGg0iuM4uK5LIpHAMCTKvYYh/6mbSiX5+pv1E7nc"
    "g8tSa/1Sb2+v3N3dRWtNpVKhXq8Tj8dpb29Ha40ObCBAyNtoyqOIUIqnn3lRNhrqBXN6enri"
    "8BL/xebmJoEKCByb7u5uPM8bNgEWFhYIh8NUq1Usy6JQKDAzM8PY2Bi2bVMulykUCuzs7KC1"
    "RghBLBbD9/3jEiAcDpPP57Esi3Q6zdzcHNlsFtu2yefzZLNZAK42NNUDzfX9gJrXxHYDYR6O"
    "aVnWv4ZbuXPoKJ+uvsO+U8P1Pe7qHsUJ9HUJ4Ps+xWKRdDpNoVCgXC6Tz+eJxWIUi0XOr3zE"
    "vY8nGRt9gNdOTTJ0X5qfbyxy0PFrIDKZTOv/nnfi2Q6ee+oJMCRP9r/Oe8uvYiBZ/PwL39za"
    "2hKzs7Pzg4ODE3cPptk72EUHGq01QaBpNjVvfzxJSLTxWP/LALzx0Id89dM8iC/DEsBxnDdX"
    "L5eWS6slQqEQhmkA0KIFQlDf3+WX7Q3OXjwNwNlvT/Nb9UdatFwDYGlpyT/5yMkLv1t/HFu+"
    "+N1AItEuI9EI0WgEKSWNgwZbV9ZIdaa4YV9l76DK5R/WqNe898XhvlNTUzlH2eOO64y4jnNH"
    "4CuCpt7eu91SfqzeB61YCxq0WvPfz197629eZ2l166FgRAAAAABJRU5ErkJggg==")
index.append('dvd_add')
catalog['dvd_add'] = dvd_add

#----------------------------------------------------------------------
dvd_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAw1J"
    "REFUOI2Fkd9rW2UYxz/ve06TmHVJZh3N7IJdWiqCthGZxrZDqbJVb4QNs4nWKxHqoCtF2K2C"
    "iNtFLmqd/0AFjcjAXyDrZmtjG7yQghfOC4/DLaFrnUnT9fx6z3uOF7IxCuLn6nvxfB+e7/cR"
    "7GJlZWXE87xXlFLDSqmcUsr0fX/D87wrcPuziYnJxXvnxR1RrVb3CiHO+b7/Rl9fX0dnZyem"
    "aWIYBkEQ0GjUWbxyMZAi/NRVwekzZ95tAxh3zFLKz7PZ7KlCoWDE43FarRaO4yCEIJVKsb9r"
    "L48PHpS27Q7+eb1+ZHjk+S+WlpY8CSCEONfd3X0sl8shhMA0TZRSKKUwTRMpJcpvoUPNkdHD"
    "FB57ZFRGf38EYCwvLxeVUhcGBgZEvV4nFouRSCRwHAfXdclkMhiGRLnrGPLfuL29Ob7+tvro"
    "6OjTl6XW+vX+/n7ZbDbRWlOv12m326RSKdLpNFprdGADAULuIZQPIDp6OX7iNbm9rV41p6en"
    "J3d/4r9YXV0lUAGBY9PT04PnecMmwPz8PLFYjI2NDSzLolwuMzMzw9jYGLZtU6vVKJfLbG5u"
    "orVGCEEymcT3/YMSIBaLUSqVsCyLfD7P3NwcxWIR27YplUoUi0UAbmxrNnY0N28HtLwQ2w2E"
    "uftMy7LuGu7laJeL/8E4QcMi7MrSevIkTqBvSgDf96lUKuTzecrlMrVajVKpRDKZpFKpcPWT"
    "85wczPDUqTcZ+/ArRo6/zL5rl3jW/aUlCoVC9H/lnd33Gy+9/R73/b4I9SqkM/xlPsRP31Ub"
    "5trampidnb0wNDQ0+fBQnq2dJjrQaK0JAk0YapqnnyGRPQQvztxdar5zgFjEARPAcZyzP/y4"
    "NLC+df25w8UnANBaExGBEET3d2GvfcOeL9/Cc9axge22gTZoGAALCwv++NHxi39Y1/ZfvvT9"
    "YCaTlvFEnEQijpQS7fnc+nkRo0OijB22bkVYDal1EJ0Xu/NOTU2NOsqecFxnxHWcBwNfEYS6"
    "cUze2DnU/jUXD6NsKKN6SPTxCwvh+/8AqExtAMnwTekAAAAASUVORK5CYII=")
index.append('dvd_delete')
catalog['dvd_delete'] = dvd_delete

#----------------------------------------------------------------------
dvd_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0ZJ"
    "REFUOI1tk01MXGUUhp/vu5cL2mH4HyBlDAw4hghlin9IQSNWJaZpYkyJmrQutAt0UTPRamJN"
    "auOGmMyCYE3UmqjEULQZNdomQBsozEjUKDWxWGOHWhiKUBmg7Z0797sXXBBMJX1WZ/Ge5Lzn"
    "nFewiXg8viOTyTyrlGpWSvmVUrpt2/OZTOYMXD++d2/n8M16sVGMjY3lCiG6bNt+sbq6Osvj"
    "8aDrOpqm4TgOs7NJhs9EHSlW+yzlvHzgwNsrANpGs5Tyi7KysmdCoZCWnZ3N0tIS6XQaIQRe"
    "r5eSoly2b6uQpmltuzydbG3esfPEyMhIRgIIIbpKS0uf8Pv9CCHQdR2lFEopdF1HSomyl3BX"
    "XVpb7iNUX9si1xbfA9BGR0eblFJHg8GgSCaTGIZBTk4O6XQay7LIz89H0yTKmkOT63YrK/18"
    "e3KsrqXlwdO667r7ampqZCqVwnVdkskk5eXleL1epJS4rovrmICDtfAbV+JRNE89z9dPyZ8u"
    "ySMiFAqtbb7ErXg4pHhj3y5uK24lr2o7S1Pf88upjx0doLe3F8MwmJ+fJ5FIEIlECIfDtLW1"
    "YZomF38+xj21WeQV3s/ixUkMYZPrLaOgqGLdlWEYdHR0kEgkCAQC9PT00NTUhGmadB16mgfq"
    "DIrubMe1BzBuv8xfE99xfvgzekZSK3LzqIlEAp/Pt/4k13/k3bd2kVf9JNbsh4isFFmeXAzn"
    "KguVe5hZXp2VALZt09/fTyAQIBKJMD4+zjvh3XjcX8mr2Y2VfB+ZpbBXKpk7O8Fi3WtMLdgI"
    "V8VuucS6rRkOvtTO3Y88hf33JwjNxlquYGFsgiuNh9lSFiT8wnOrurbaIgC6u7uPNjQ0dN7V"
    "EOBC7DjFYhFH+CgqjFHgM7CW/fzzw3n05jfRiqv5/MuvGfrmxEenB07u1wHS6fTrZ2Mjwbnl"
    "6UfF5Cke6jzGhb5X+WM0TvYdDbjX5ih57CAlW4NEo1GGvuobTJs3wv9lYWhoyG5/vD06lbhU"
    "sjI90dhU4aWg3M/izFWSf06xZecr/D67zOFDR9S5iXMfpE1zfzwev/a/NG6wp7Uw01jl0++t"
    "rRJztusOTMobKUvOrDlrMTvjfDo4OBi7Wf8vAh1ozvty7/AAAAAASUVORK5CYII=")
index.append('dvd_edit')
catalog['dvd_edit'] = dvd_edit

#----------------------------------------------------------------------
dvd_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAyhJ"
    "REFUOI1dk19InXUYxz+/3/ueoznP0ZX/hrPp0VyNTc/YAnPKQqJBUBcJWkxHF91I5MSbLmOX"
    "3hxCbFEXQWHgXDWQiCC2dpyKq4y6CMrgdbWOzdPsnJ3Zef/83t/v7WItlp+r54Hnge+X7/MI"
    "drGysnLC9/2XlVK9SqkWpZQdBEHe9/0rsHNhdHTs6oPz4n6xtLSUEEJMBUHwant7e6y6uhrb"
    "trEsizAM2dzMcfXKpVAKM+ep8LWzZ8+VAKz7y1LKi01NTS+l02mroqKCYrGI67oIIUgmk9Q/"
    "kuBo135ZLntdv93M9feeeOaTbDbrSwAhxFRjY+OplpYWhBDYto1SCqUUtm0jpUQFRbTR9Pc9"
    "SfrIE30y+uttAOvatWs9SqnznZ2dIpfLEY/HqaysxHVdPM+jtrYWy5Io7xaWvGe3tbWFzz5f"
    "OtzX99RlqbU+09HRIQuFAlprcrkcpVKJZDJJTU0NWmt0WAZChNyDkXWIWCsvDo7Iu3fVaXti"
    "YmJsdxK76U3X8MLJOvoH38GIOKFbprm5Gd/3e22A2dlZ4vE4+Xwex3HIZDJMTk4yMDBAeadA"
    "4Eyz77Fn2frpIqL+OYQQVFVVEQTBfgkQj8cZGhrCcRxSqRQzMzP09PRQLpeZf2+CxraTJPcd"
    "xftjme3tG2zthBR9Q9kLhdwt13EcGhoa7jV+nlPHq0nU1aJLCzQdPo289QVKxvj1zxJuqLck"
    "QBAEzM/Pk0qlyGQyrK6uMjw8BLe/ou3YKHjf8fWHH1Fd6yLya8SKP3Bzw0FotWwDjIyM/E9F"
    "JpOhq62CmPFI7C2jSxsQGfTON7Q9Pcn64gdcmLtjTBS9LwCmp6fPd3d3jx3sTnHn7wI6CAi+"
    "neZA+nkqY9cxwe//Hn4Ma88xtn6RLFyaW3v9rZXjEsB13TcWl7OXs4tZYrEYZnOVvY1pqhK3"
    "icJtEBZrn64DBuOtU995gCMPlx5dfPPQof+eaWpqKlEobWeKpcIrZx7fsNPD72LJG0RhAYge"
    "MCixHjrI1o/f8/PCuY8FuxgfH+8bbF7+MtImHulIGG0QmCjS2ggiHRljIhOBMWCitX8AKf1v"
    "ZAGH/HAAAAAASUVORK5CYII=")
index.append('dvd_error')
catalog['dvd_error'] = dvd_error

#----------------------------------------------------------------------
dvd_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAyVJ"
    "REFUOI11k11IpGUYhq/3m29HGXWUshzWMWR0XWxbnViW/dRZA9utWIKgYOjPCrYTyVQGoqMO"
    "llhICA9E9zzwwIzoJLY/cleddVyExZMNYmFilbHdgW1+1O/vfd9vOgijpK6j++B+4Hmem1tw"
    "hPX19SHP896QUg5KKTuklKbv+0XP85Zh/8vR0bGb//SLQ5HNZpuEENO+77/f1dV1rLGxEdM0"
    "CYVCKKXY3S1wc/kbZYhg0ZXqg8nJK1WA0OGwYRhfxWKx15PJZKiuro5yuYzjOAghiEajPPF4"
    "E8/2xQ3bdvu2dwrnB4cufL2ysuIZAEKI6ba2thc7OjoQQmCaJlJKpJSYpolhGEi/jA4051Nn"
    "SZ7uTRm1P+YBQmtra5aU8lpPT48oFAqEw2Hq6+txHAfXdWlpaSEUMpDuA0LGX+d2dnbw7fXs"
    "M6nUwM+G1vqd7u5uo1QqobWmUChQrVaJRqM0NzejtUYrG1AIo4HAaEUc6+TV19429vbkW+bU"
    "1NTY0ST+j1wuh5IK5di0t7fjed6gCbCwsEA4HKZYLJLP55mZmSGTyTAyMoJt22xsbJBT80ws"
    "DvLR8CLhUB2RSATf9+MGQDgcJp1Ok8/nSSQSzM3NYVkWtm2TTqexLAtX+8Rbe/nkp1coVA8o"
    "ewG2q4R5dM18Po9lWcxvXqYWSM5NhfhsLU176wl6Y+fYcw+4snyBDweu4yj90ATwfZ+lpSWK"
    "xSLj4+NkMhmU8Ll46l10LUAHmoAau5UdTseH2PcdPl0eoNl4blMkk8nafz3szKTgUt9l7j+6"
    "hwwUKpBILTGMME82xcnmf+B2PhuYW1tbYnZ29lp/f//Yyf4ElYMSWmmu/vgmSivaok+hAo2u"
    "Bfxe2eaxxhh3dm6R+3XDdQQDJoDjOB+v3lrpeVDZef6sdQYAR3l8kfscP/BxlU+i9WmsxAts"
    "3s9y4+4NHzsyvDtb3fq7TNPT002l6qOZcrX03ksvXzRjx2M0NESo1WpUK1XGv7tEfzzF6i+r"
    "B3o/Mrw9X7nzrzYeMjExkXKkPeq4zpDrOMeVL1GB3r176vuTGmF66MTDq/x26P8TChuCk/SN"
    "0coAAAAASUVORK5CYII=")
index.append('dvd_go')
catalog['dvd_go'] = dvd_go

#----------------------------------------------------------------------
dvd_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAyJJ"
    "REFUOI11k11om2UUx3/P875JQ9amtfZL24ySlg7FtdFNzNr0plT0ojdVCBNXGagXVWhLb3ap"
    "XhYhYK3DC0GQKjMiQ5Dq1rU2axvjx7yQjW5+hH2Y4sJcYtK9yfs875t4IYW16O/qcPifw/mf"
    "wxHsI5VKDdm2/YLWelBrHdRam0qpnG3bq7Dz6cTE5Nr9erEbbGxsNAgh5pRSr/T09Hjq6+sx"
    "TRPDMHAch+3tLGurZx0pqmcq2nl9evqtIoCxWyyl/Kyjo+N4OBw26urqKBQKlMtlhBAEAgFa"
    "H2zg8f4uaVmV/pu3ssODQ6OfJ5NJWwIIIeba29ufCQaDCCEwTROtNVprTNNESolWBdyqy3D0"
    "ScKHH4nK2t33AIz19fWI1vp0X1+fyGazeL1efD4f5XKZSqVCU1MThiHRlT8x5L92u7uDfLm0"
    "8Vg0emxFuq77Um9vr8zn87iuSzabpVgsEggEaGxsxHVdXMcCHIQ8QFW2IDzdPPf8CVkq6RfN"
    "mZmZyf2X+C+EgKV3J6havyGbB+nsHMK27UETYHFxEa/XSy6XI5PJEI/HmZ2dZWRkBMuySKfT"
    "XD33Nh7PTRqPneTO9+8jCaCU6pIAXq+XWCxGJpMhFAqxsLBAJBLBsixisRiRYInpV8M0HjrK"
    "vRtf4fEHca99TKdxu07uHzWTydDW1rYnJ3eu0tQ/hmv9iq/lYUw/PDT8KCeecvwSQClFIpEg"
    "FAoRj8dJp9PEYjH8fj+JRIJbOY3OX6eq7lBT1/AGbkDlCuWcckU4HK793+JCrTVeG2umufUA"
    "vUeaMWUBIRuoasXlT37hwmX9hgCYn58/PTAwMHloIMTf9/K4jgt/bGJmk3RFRqmp8wi3xNb5"
    "CqbtQ9k2iz9WVt45+92oBCiXy6cubiZXkheTeDweDNPAV7jEwegYTuFDhNpha1Ujel7mp8A4"
    "b66Z3/xw2xjf80xzc3MN+eJf8UIxf/LZsafNw+7XdB3pxSl8y9aFElecJzhzbktrpT+wLOtU"
    "KpUq7Wmwy9TUVLSsrYmjD1wfDx+ULTt3rdoXP7P9+07DkrKdj5aXlzfv1/8D4P5jGQo6NQQA"
    "AAAASUVORK5CYII=")
index.append('dvd_key')
catalog['dvd_key'] = dvd_key

#----------------------------------------------------------------------
dvd_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzBJ"
    "REFUOI11k09MI3UcxT+/6TDlbykitgIVQgmJRpYq0VSWhSxoPHhxIWkwynrhQkxcwkXDAbPH"
    "xqSJBPfAwXggUVHx4MbbrtstS/FAwrnRHtBpC+0uCJ1pZ34zrYfNmpXEz+l7eC9537w8wQV2"
    "d3cvW5b1npRyTEoZklKqtm0fW5Z1F8rfzc8v3ntaL54cOzs7bUKIuG3bC+FwuKG1tRVVVfF4"
    "PDiOQy6nc+/uT44iat9WpfPRjRs3zwA8T8yKonwfDAbnIpGIx+v1cnp6SqVSQQiBz+ejq7ON"
    "Vy71KqZZvXT4p35l7PKbPyaTSUsBEELEA4HA26FQCCEEqqoipURKiaqqKIqCtE9xay5Xxl8j"
    "MvziuFJ/9CWAJ5VKRaWUt4aGhoSu62iaRmNjI5VKhWq1it/vx+NRkNUCHuXxu/39IW7/svPy"
    "+PgbdxTXda8PDg4qJycnuK6LruucnZ3h8/lob2/HdV1cxwQchNJCTXkW0dDPzOwHyvm5fF9d"
    "WlpavNjE/5FOp3Gkg1Mx6enpwbKsMRVgc3MTTdM4Pj4mm82SSCRYXl5mamoK0zTZ29sjkUhQ"
    "LBZxXRchBM3Nzdi23asAaJpGLBYjm80yMDDA+vo60WgU0zSJxWJEo1EA/jp3OTZcjsoOp1YN"
    "s+oI9WLMTCZDU1MT6XSazs5OpqenKRQKaJrGrz9v8fxzXRRLD2nt6sGUTlEFsG2bra0t8vk8"
    "q6urzMzMMD8/j2EYhMNhUqkUo6OjzF57lwZVJZ/Ps7+/j1qzLRGJROpPJ5icnOTDhQU+W1mh"
    "VqvR3d3N8PAw+XyeUqlEvlBg+NXXeeetq2xvb5fVg4MDsba2dmtkZGTxwd596s7jsm9+vsKn"
    "H68yNzdHR0cH5XKZYrHIxsYGrc8EAPD7/aoKUKlUPrn/IDl0bvw9XS1LAL75+gdqtTrxeJyW"
    "lhYADMPAdV1+u3P74eToS526rlf/HVM8Hm/7/Y/MV6XSo9mJiQkRCoVQhMLR0RGZTAav10tf"
    "Xx+BQADHcU4ODw9FMpksCP6LJxaLXTcM44tgMNjibfQK6ohcIafXa+5Bb88LVwHFsiw3l8sV"
    "DcO49g88M3TlyhDM9AAAAABJRU5ErkJggg==")
index.append('dvd_link')
catalog['dvd_link'] = dvd_link

#----------------------------------------------------------------------
email = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhFJ"
    "REFUOI3Nk7tuE1EQhr85e7xeb7y+5GaI4yCMFGregZoH4AWo6XkAajpaJArSIYHEpQgSKRCC"
    "PkWECLZisr7Eji9Zn70cChsiaCngb2amGc3/6xv415IHjz/s5/3ird4kWZlEscosZFjSzJJZ"
    "S2otWbaY08ySplhRaWxmw17r8OhIr6+WGvfu7JZMgnh55/ftf/ayqBfzxJlFydbdhyZS3VHS"
    "jFMrT/c7tHqG6dxy3M9oDTLaw4zOKCMcW3pTS5xCu2949KLDcGZUsLF9Q01NJvmcon61xJvP"
    "IcNJTK0k5BxwHcHVgquhUhD654a9g1MqqyXWKnkQETWLEgCaV4ps10q8+hRyNo5ZLypcDa4D"
    "ZU8YjA17ByHrayWa9SJiF9bUNEoB0A40t4psVH2evWsxGBvKnhB4Qn9sePK2Rbns09wqUtCX"
    "2ajpxeICEUjiBE9n7NQrvPwY0u5FtHsRzz+ENOoVAjdF2QRXXyarZ/MUCxiTcDoY06gFuG6O"
    "zsDj/eE5CthtVKmtFZhGhk5vzHo1wFrACno2j22aWQn7YxobAQUvBxaub/rsbPoIIEs2tO+i"
    "NwNOuudcVAqQpVZPBydfo3l87Wbdk8BXIipFLS2JyC8GfnIAmp1KMTv+PjGjbvtEzyfh8e37"
    "r6v5wF9xXEdyWqMcwXFAKUHp5YIlVWKtTZPYzEZn/e6X1re//IT/QT8AiN/zcibBciIAAAAA"
    "SUVORK5CYII=")
index.append('email')
catalog['email'] = email

#----------------------------------------------------------------------
email_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAphJ"
    "REFUOI3Fks9rFGccxj/vO7Ozk83sZBPzw+xmRbdU7aGkoi0ipaW0Qnuol956kx4K4qX04qF/"
    "QK71ENGLYCmiF6tRMekhgrZIaCmhLYQitLKLWye7m81OZjM7M+/79pCDVij15nN5vt/D9+F5"
    "Hr7wsiG+Ov9gOV/wDrW2suGtOJXagMagtEEbgzIGrXd2pQ1KYYRUadLvtuprDx/a42N+9fMT"
    "+/0kQ7h569/qz89ih7cHmdWPs/Knc0ks1zezWqqM+Ha5Sb2VEA0Mj9qaekfT6Gqam5ogNLQi"
    "Q6qg0U44e7NJt5/I4sTMKzJKtMjnJJVpn6WfA7pbKVO+IGeBYwkcW+DYUBoStHsJV+8/oTTm"
    "s6uUByGE7McZALXdHjNTPnd+CtgIU8Y9iWODY8GIK+iECVfvB4zv8qlVPITZiSajWAFgW1Ar"
    "e0yMFrhyt04nTBhxBUVX0A4TLn1fZ2SkQK3sMWQ/7UZG2zsOhIAszXBtzZ5KiVsrAY1WTKMV"
    "c/1BQLVSougopMlw7KfN2v2BwgBJkvGkE1KdKuI4OZodl3trPSSwvzrK4/VFVv5YIOxvECcJ"
    "785+DOYwdn+QGqWNCNoh1YkiQ24ODOybLLBnsoAAfly9wp8bS7z39pvMjL3K8u/fsfTbOXrt"
    "Y8io8/iveJDqAxXXlEclY8OKcU8xWVSUfc20r7n7yze8cXAWJRWz08dRIuXo68eIereNPdgK"
    "Hn3wxeJovlgYthxL5GwbaQksC6QUSBusqGnnhMdHr30GwJfvX2Dh13nghnj22f4TR0+Xtz85"
    "8aGboTlz/CJzSydxrTyXr12Prf8/h/IRbyhM1t/ZO7WXVr/BZhTww+o9et3B1y/kAOCtU7vn"
    "EOKUgKKBEGPmV+b/PvMPjWweOQoIgjwAAAAASUVORK5CYII=")
index.append('email_add')
catalog['email_add'] = email_add

#----------------------------------------------------------------------
email_attach = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqxJ"
    "REFUOI3Fkk1oXGUUhp/vu9/cmdzcmdy0SSdmOhWnpbpSQiykmo2QImrHBHUlCAEhQooQpSiI"
    "24JrXYi0dNEi0mQjqGDsooJZDGpKRcFCoiSd6rTXmTHtnd/7831dpOBfEXc+m3MOB17Oe3jh"
    "/0a8/UHlUtpxJ+qteLDVi6Q2oDEk2qCNITEGrXfnRBuSBCNkEoWdnXr16uamGtmTK77y7OFc"
    "GCMyaeuv6n/vxW7t9mOr04vHX3wn7MnfbsWlKDHiw0s1qvWQdt+w3dBUm5rrO5raLY0fGOpt"
    "Q5TA9UbIu5/W2OmEMju6/6Bsh1qkU5LCfTm+WPfZaUXkc4KUBbYlsJXAVuANCBq3Q5bXbuLt"
    "ybHXS4MQQnZ6MQClMZf9+Ryff+vzexAx4kpsBbYFQxlBMwhZXvMZ2ZujVHARZteabPcSAJQF"
    "pXGX0WGHC19WaQYhQxlBNiNoBCHnLlYZGnIojbsMqD9+o9rd3QuEgDiKySjNgYLHZ1/7HJsY"
    "QQhYvVynWPDo1jc4feY9XNflfByjCjOoTj/BAGEYc7MZUMxnse0UtWaGr67eRgKHi8MkQZXV"
    "tRUmjjzG1DMv81Ae3jj5OqrTj0yijfAbAcXRLAOZFBh4YJ/DgX0OAqj+9COfLJ/mkUeneXj6"
    "OG+eeInZ8pPcqP2Cajd/3er1o/sfLGRE1pFCyAR515IQgu+/u8LHH51nauooc8/P8cJzc8w+"
    "9bRZr6yJ7sHZa6rf8rdnXlsdTmedQcu2REoppCWwLMjrbSm3LsoffMzmWCE59fgT1vTMcS6v"
    "fyO2vGNVf/vGz/+a84WFBWPb9vvlcrnleV6wtLR0dn5+3kxOTqbuldZ/oJRaj+N4cnFxccwY"
    "82qr1XprY2PDqVQq3f8kcJcrjuMMlsvlQ1prtbKykvx5eQdzICBGYEsCuAAAAABJRU5ErkJg"
    "gg==")
index.append('email_attach')
catalog['email_attach'] = email_attach

#----------------------------------------------------------------------
email_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoNJ"
    "REFUOI3Fkj1oU2EYhZ/vu19ubtP89c/WprE2gg7SwUEXHbuo4Co6OYjFUV0cHBxExEUQRNxE"
    "cLCboKhVsPgDIgqioA5VrGkTG5P0J73pzf35PoeIVUF08yzve4b35ZzDgf8NcerKs4fxRHJb"
    "dSXsXPECqQ1oDJE2aGOIjEHrNo+0IYowQkaB31ysFt9PT6ve7nR+fN/mtB8inLj16/ffd9Ge"
    "q63Qanrh4MFzvie/LoWFIDLi+sMyxaqP2zLM1DTFumZ2UVNe0lQahqprCCKYrflcvFVmsenL"
    "VN/QJun6WsRjktz6NJMvKyyuBPSnBTELbEtgK4GtINshqC37TDyZJ9udpicbByGEbHohAIWB"
    "JEP9ae6+qLDQCOhNSmwFtgUZR1Bv+Ew8qdDbk6aQSyJM25p0vQgAZUFhMElfV4IbU0XqDZ+M"
    "I0g5glrD59r9IplMgsJgkg61lo10V9sKhIAwCHGUZkMuy+3nFWarHrNVj5vPKuRzWVJ2hDQh"
    "tlpLVjVbEQbw/ZD5eoN8fwrbjlGuOzx+v4wENue7yLy6inv/Ev7cNF7PIOW9R8CMoZqtwETa"
    "iEqtQb4vRYcTAwMj6xJsWJdAAO7kZXhzgx37DxMf2crq60nePp1g1CwY5dZLn7xWMLwl54hU"
    "QgohI+R3S0K0m/DizgW2HziK82EKHp0hkcmyMT/M6NS1SLVWKjNjx+51xVOJTsu2REwppCWw"
    "LJBSIBWcKM0oZ2AE9hz/EZ46vZ4ub0H9XLY/4t6YVdx54NBQ5+fbtFa/0AQayxbvPjBn/fUa"
    "GN8+kKnPl3ZJ25KB5bJUM3wsySgKzfl/UgDweH/+ZLNWGpdaDGtp5jTm8u4H+uw3TScZlxCy"
    "dYUAAAAASUVORK5CYII=")
index.append('email_delete')
catalog['email_delete'] = email_delete

#----------------------------------------------------------------------
email_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn5J"
    "REFUOI21k0tIVGEYhp//nP/MTHM1y0wnb6NkRWIZtSjbBVGUBC2CNi1bB+1qH1RQ0KI71CIq"
    "CFpUoG2shIjQECIyw+vkjM04o6Mz45lz+1soRbsietff8/J+L98H/yjxN8NjT3cet8vtT/Rw"
    "B6W512DOnNL/FJ7uTZwMhHoer205Sn3XIQLBWtIjY3vl+Zvv+v3B8M65ohMqmrbmKfBQuJ7C"
    "UwpXKTrC70QgXhCxqi7yY5/xCYtIdCOB6sYaub462nC6Z3PUchAB/++BBGDl3mBl88QSB6mk"
    "H+ELCqaGR3A9H5cmdie1bMFJ2K4SD/rTJOcsShXFVM4jmfdITvRjZXqJtR7GTN1GGPMY4QiY"
    "c+i7TrMc296olSxP+A2NeF2Ul0MZFoo2tVHB8uQzggt9xNp6MGeuoxk21mIzqVfDDNaeo6Z5"
    "CwghZNl0AEhsDCMU9A5m6F43hLH4lg3dR7Bm76D7FGahidmBDwy1XWV9QytCrXBayXQBkDok"
    "6sPEcn3o+fdYbj3pj9fwMCnl4yQHPjGYuEy8pZU18ldPsrS84iQEOLaDkX7ItmN3+fLoLKMD"
    "b/E3dmLOZ5nvuoARrkFTDtKQP1vWyhUXBViWw/f8EqPjWaxPz2np3E8o1M7M8Bhq30W2dOyg"
    "uS5CfmEJz3FQClACWa7YyvWUyOSWaKiJcO9rhiu3rrNnawu+pk46TtzHF92Eh0IGfcgNEVLZ"
    "RZar1oDnKlnKpybNit3UHg+ISFATN14k0VZXEkKsJvVWbl4ASBqrwt7UbNEqZL+lZKWYmTpw"
    "pm+tPxIM6T5dGFKi6QJdB00TaHKFW/VCKKVcx7bKhflcdjw5/ceP9N/0A/dWEq8cDbr2AAAA"
    "AElFTkSuQmCC")
index.append('email_edit')
catalog['email_edit'] = email_edit

#----------------------------------------------------------------------
email_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArJJ"
    "REFUOI3Fks+LW1UUxz/3vpeXZJKXSWYSZybpWCbFlraMdejCjYUWCu7U6q7+AS6ELrptoXTX"
    "jQvFhRVxUZqCRRctLYhgR7GCnR9VBK1ji51hYsekSTrTJC/v1723i4hTpXu/cDjny4Ev5/vl"
    "wP8Ncfr8D/PJkexcqxdnen4ktQGNQWmDNgZlDFoPudIGpTBCqij0Nlvrv927ZxfHctPvvLY7"
    "F8aIVNL6t/p/ZzHsgyC2PD8uHz8X+vLhVlyNlBG1+Q3WWyH9wLDW1qx3NPVNzcaWptk1tPqG"
    "SEG9HfLBtQ02vVC6pR27ZD/UIpmQVKZyfLXcZLMXMZETJCxwLIFjCxwb8mlB+3HI5ZsN8mM5"
    "xvNJEEJIz48BqE5m2TGR48ulJo+6EcWsxLHBscDpLdJYPsOV7/+gOJ6jWskizNCa7PsKANuC"
    "ajlLqTDCZ9+s0+mGjKYEGdunc/cybnGW/envqJazpO3tbGR/MLxACIijmJSteb6S5/pCk3rL"
    "5887V3BLc+Sm5ih53+J4Kzj2drLSCxQGCMOYRqfL9ITLgWqBF3YWWPp1BW/tOm4xj3p8lfLs"
    "ceRqDR0FGAMYgfSCyChtaLa7TJdcRjMOaVsw81yaF+2vmdr7Bvi3WbhQI5sfkGwv4K/dYBBE"
    "oJWR/c6DVT+I9J5KypQLkrGMophVuN4SqbiDW/DQwX0wGtVbZObwScb/qtFodPyth/X7Yt+x"
    "9+aTY7teSrojGcuxRMK2SdiKE1OfWq8cfV2kErfQYf1vzwmszEEadyUXb/y+Vft55senn+0f"
    "LH106N3SvmMfTu5Oo3oLGBOy/MUdDr61F2GNQvpVFj851RSxPvJMgVvvv1yffftSxZKrmPgR"
    "YJ7aSqz0Hhq//MTK1bOf288SiIIwtfzxmwOjDUbrYRnDNjegNWgz+QSqqEY9rkkQ7wAAAABJ"
    "RU5ErkJggg==")
index.append('email_error')
catalog['email_error'] = email_error

#----------------------------------------------------------------------
email_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI3FkztoU2EUx3/fvTc3aZukD1P6bjUFRaugiwqii49FLLq6CC7OrlIQcXHWoTgKOugm"
    "qGjxNfgoUh0ctGJA25QW0yQ23iS997vfw6GIVkTc/C3nMRzO+fM/8L8RE1ennyRb07vKddVW"
    "D2PHWDBYtLEYa9HWYsxarY1Fa6xwdCybK+XibKHg5bqyQ2fGN2elQqSS7vrpv+diLa5Gym2G"
    "qv/kJRk6yzWVj7UVN54sUSxLGpFlrmIoVg0LK4almqEUWMoNS6xhoSK5fGeJlaZ0Mt2Do05D"
    "GpFMOAz0ZZl6XWKlHtOTFSRc8F2B7wl8DzpaBJVvklvPvtDRlWVDRxKEEE4zVADke9MM9mS5"
    "P1PiaxCTSzv4HvgutKcE1UBy61mJ3IYs+YE0wq6d5jRCDYDnQr4/TXdnKzefFqkGkvaUIJMS"
    "VALJpXtHmf06Tr4/TYv3Uxunsbq2gRCgYkXKMwwPdHD3VYmFcshCOeT2dInYKgZzW5l8tB3f"
    "+6ms14w0FpBS8aUaMNSTwfcTXH18gncPNdIopFb0d46ytXcPQdjgwu0Rrp8ugBV4zSi22lhR"
    "qgQMdWdoSSXAgjKSw2On0NagjcZgWawV2TG4j7pc5dhkjl4xZb1GdfFzGMUjWwZSItPqCOFo"
    "HCBUEm0Nc5WPxEahTEysY75FATuH9lOPm7z6dAAvqpfmDp190JnMtLa5visSnofjCvqGQ09p"
    "RU92GGU02hqWavN0pXt5U3zOdKEQ++8vvvzVbOs4PrlJh1IijSRSktHcmLM3f4SZ+Rc8/DD1"
    "1q+xu3CF6J+fZuyiWD517aAdOcfMtvP4f7L7X9k4wbKxbm7e0wkuoH70vwN63z54E/B7rAAA"
    "AABJRU5ErkJggg==")
index.append('email_go')
catalog['email_go'] = email_go

#----------------------------------------------------------------------
email_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuhJ"
    "REFUOI3Fks1rXGUUxn/vve/MnWS+JxNmOtNOYIRKjQkoLdLVWFsEN0HRRRDRlYi7SreuxUBX"
    "SsEu/EBwYRYNBYtatW2gaqxNQS2iIdIkM53PO9NJ79zJzP16XQSp9R/w2ZzzbB7O+fHA/y3x"
    "9vm1q8Zk7Alz4EUHI1cLFAQo/EARKIWvFEGw7/1A4fsoofmuM+yb1T82N2U2kzj0xsLhhOMh"
    "Iob+cPp/d7E/98aePhx5hZffdUZaZ9cru74Sn11tUDUd7LFiuxtQ7QXU+gGN3YC2pTBthetD"
    "revw3hcN+kNHi08ffESznUAYIY3igQSX19v0By65hCCkQ1gXhKUgLCE1Iejed1i+3iKVSTCV"
    "MkAIoQ1HHgDlfIyDuQRf3Wxzz3LJxjTCEsI6JCOCnuWwfL1NdipBuRhDqP3XNHvkAyB1KBdi"
    "TKcn+fxalZ7lkIwI4hFB13L49JsqyeQk5UKMCfmAjWbv7V8gBHiuR0QGlIopLt1oUzNH1MwR"
    "F9faHCqmiId9NOURlg/IyuHYRwGO49HqWeRSIXZv32B381dWmxl26h0eP75AKR/j2wufYE9n"
    "6HTv0T7yGMqLIYdjV/mBEu2uxYF0hO8uLaN5Fq+9+gq2bVOr1bh56zL1Pyd48fkFpNRpNBqs"
    "r6+jtiyk3atvjcbuzKPFiPjt1k+iU/+LlxYX+fCjj1n78Qfy+Txzc3M0qnc4e/Znms0mR489"
    "pU4+87S4s30xkONBe/vUW1+njfhkVG19qT/35JQGcG3vmOfYV+TpxUXS6TSDwYBOp8P75z5g"
    "LTg6PAnRVDKO/H3lzIl/iM7Pz7/ZyB1/B0jFbp+70lfeiaWlpVA0GgXAtm2E8tzIL+e/59SZ"
    "Zxv1u/f/3VZmZ2ePlMvlC5VKJV8qlQIpZabVarGxsYFhGMzMzJDL5fA8r7ezs6Otrq42HwoA"
    "9EqlMheNRlcKhcK0YRi6UkozTfN1IcTdbDa7AoTG47Ffr9c7tm2/8DevH1u2uHLVtgAAAABJ"
    "RU5ErkJggg==")
index.append('email_link')
catalog['email_link'] = email_link

#----------------------------------------------------------------------
email_open = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqNJ"
    "REFUOI2Nkk2IFFcUhb9b9aq6p+1OOspodP5n4QRcmKwiCKKY7ARBCYFsdeVGJYskS02UCC5c"
    "iLMJZhGIGIkK/mBCSFy4kUEMAVHjz/w1k8x0psfp6e7qrnr1bhbT0zgEMWd1eZxz3uXcI7wC"
    "39ya3mUy4a++CK0kPnDww97zr+L+B1//8PTEpTuzOjHb1JlKS2+M/aOnLj278L/Ex79/cvvm"
    "2JxWI6ctq5pY1Wbi9M6Dih777sn4qauTm17my8pw9nrpXRG9u22kGG7uWQMiLDVTAN7s8jAe"
    "TJab/PL7AotRvO+L/UNXOgZnrox/uq6YPf1gvLzspopTcKpY64itY20hoBZZFHh/Sy8PS9Ho"
    "l58MHuLc9an0xti8/vXC6ufn/9DX4cjoPa1GTn++v6BfXZxITdyoT+/e2jPQShTnFIDRh6tz"
    "eVROKFVTftyTxSmIpkSNGr/dG5sy5WrSH1vHiQuPO4KPe2NEQBVs6ojWWmqRBbJMz9b57NtH"
    "HN7bT6G7d8Crx04ygcf29/oQWd5AZDkc34PA98iGPtnQRxXyuZAtI32sK2ZARLxG0wIw/Hae"
    "7VuHOHft2XKyAiKC7wth4JPLGE5e/JNd295huCdP+y9MvX0q48PwpjwZP+H05ecEvvAyYqvs"
    "3TFIlAar3k09sp21bWKJE+WjnUOYYDXRJgmPS1U2dr+BCUynRV6jlaJAHFtmK0v0bSgQhqvF"
    "ACYIGNxYoPJiCWctqoAKptFKNHUqc/NL9HUX6MoGoKBA2m6aKDgUkwsx6wvMlKtExS5wqZp6"
    "ZWai2UoGRnqyUsh5Il6Kt3IJkU7fV4IFQ38x7yb/rsWL5dKMadXmJj84+tNbmUJujR/6EhiD"
    "5wu+D54neKZt0M5UVDW1SdxYXJgvP5+e+hcNv1PsdCC6wAAAAABJRU5ErkJggg==")
index.append('email_open')
catalog['email_open'] = email_open

#----------------------------------------------------------------------
email_open_image = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr5J"
    "REFUOI2Nk01oXFUUx3/3vvvmI5lnRtppTdIkNVCzEOsHtFgVoUZdCVLduSloRXQj4qK0u1or"
    "Fl24kIogdiEYtIu6qKIi1kI3GhWhlFr6lUnCYDJ20pnJfLz37r3HRSbVUQoeOIfD4X8O538+"
    "FLeQj75e2G2yme8DpYjT5IV9T2z5+FbY/8jbn18+cuLskswtdaVSi+XL2T/l6IkrM/8r+Y1P"
    "L/3w1eyyNDpeYiuSWpFu6uXs+Zoc+uTStaNflEf+iVfrzvunFu9TSn58cKqYuWt0EJSi2XUA"
    "DOU1RkO52uW731aod5JnDjx758mbBd47ee31DcXcu5fLZUQE5wXnHNY6UmtJrUMhJNbivTD9"
    "0E4uLHY+OPzc1lfMsVPzbmLzoH5g2xAXrlzl+ceG2VQqoZRBgNQrPACCswkHPzzDUztKbIzq"
    "L7/52dxLJmm3FqbvHZ2IUyFNLaWNJarvHCOXy/3NMzBYE5DbtxcElDg67VVO/zI7b6qNdDyx"
    "niMzF7HOorVBFSJG7tkOmQBMAEZT+elXvIeVuMj+47/z6tPjRKUtE7qVeJUNNQ/fP8aNRhMP"
    "ZEMDQ4OQz0JoQOkeCWHAtLh7aowNxSwopXS7awGYvKPAnid3c/j46X8taV1h5ttzTD+6i8nR"
    "AkrWEKbVW5UJYHKkQPaRnbx1Jk/wc73vPizb2LtjOx0X9sVNq7PWgVJgU0uSCi/u2YUJ+4E2"
    "Tbm42GC4dBsmNDcb1O3YIUCSWJZqTcY2R2Qy/ckAJgzZOhxRu9HEW4sIIArTjlNxXtTy9SZj"
    "pYh8LgQBAdz6BAQ8ghnIYDZFVKoNOsU8eCemVavMdeN0Ymo0p6IBrZR26B4lpVTfKNeMYbxY"
    "8OU/VpN6dbFi4tXl8uOvfXN7NhoYDDKBCo1BB4ogAK0V2vQK9L5GiYizadKur1yvXl2Y/wt9"
    "jTElxd2CPgAAAABJRU5ErkJggg==")
index.append('email_open_image')
catalog['email_open_image'] = email_open_image

#----------------------------------------------------------------------
emoticon_evilgrin = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmZJ"
    "REFUOI2lk01IVGEUhp977/yY3tFxrFSqGUejhfYjCrowkhaSIARJuWlVu1oKrqSgtdCqTbQI"
    "ahGo1CZliDLGwIUR9kNkok4WKeboDOM4d+7c+31fi2DMhla+ywPnOS/vOQf2Ke3fgnqN6QgG"
    "paRXKjqUAiWYlYqYleNu7QDZ/wIKU3QjeaiFh6JasAPlC4ESKCuJSM1hL4wkpOJaqJ94CcB5"
    "ySVV3f1Ur7uKpfv5HJ/mcL1Bhemy/MWlLhqhvr4W+/sY1q94f90Az4oAFSNkG6x4Tj8xpZ5B"
    "5BOk1lK8n0mjFByLSKJNEs0fxvCfIj1zPet4iYQH2NIBCgaDRsOwqXwg7QRT4wmqqmy6e/10"
    "nVM0RLaZfqXhZj4h7CUqmodNLccggA4gBX1adScyn0C5FucvVv8JVDoYHgeArrNJlJPFTb/D"
    "EzyBFPQBeACEotnrr0RaaRY/VoMWKN2PUih3i6OhF4CNlESLAASWcvM+hEso0k55TROabuzt"
    "l4Kd9Q+ozAQohZQYuw4ECRyrFXxUmBaB2uPoHu8egHBsxOYkml6OFB4KNou7GUgmnOQcmi+M"
    "bsdxcquA+ns+TmYJNkfxVJ7BSq7g2EwU15gZ5VBBY9nsfGxK5yvuzgpGsA9vsA2UwN54Q+HH"
    "A4wDR9AqL/Dt+Y2scGhsG2ajGNX6KJe9B3vGysL9YGzjpt4irFWUm0fzBDACrQgaSc1Pkp6P"
    "XWm7zXjJKf98RI+U3DdbhqK+mhZ0rw7SxbUFO2sLrM2MJKTLzfZbxEpOuejkHmaujCEl6BWS"
    "DrcAToFZ4RDz2oycvLP3mfat39KhHxfGgLt2AAAAAElFTkSuQmCC")
index.append('emoticon_evilgrin')
catalog['emoticon_evilgrin'] = emoticon_evilgrin

#----------------------------------------------------------------------
emoticon_grin = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlZJ"
    "REFUOI2lk01IVGEUhp9778w46dV0KgyKKSta9I+CrsI2kuQqKTetaldLwZUUtBZatYkWQS0C"
    "iyJIGSoMC1wYEdXGQpssUqwxZZyZO/d+9zunRWCZtepdHjjPObzvOfCfcv4s6FN8Y+kXoVuU"
    "dlVQy6QouaDCleY+Sv8ERGN0ItxwsgMtTmM7msqAWjQoYJdeEb4fyotyNtPL+DqAecJJbeq8"
    "5249g9ZuxFamkHARjavgpHHTe3CMS/jpDsHX8d6tfdxfBWiOTOgxmzh02xe3iK3mwawgcYja"
    "6k+IKE5NFq/mIMsT50omyY5sH99dgMij39s56GsKJMxDXGbsQQEkAhvx7DGIKREX32LDGer2"
    "DfpOhX4AF0AsPU5TB1LNo3GAiuHYiQ2oGNQajnaWUAlRUyJefkmicS9i6QFIAFhlX7KmAQmW"
    "mX7TBE79+nxU0fg72zOPgBARWlYBWAKNqylsTGZHG7WbduO43tp+sZQXXqPFEVBFBO/XBpY8"
    "JjgCKer8gPrmPbiJ5BqANSF2cRTHrUVsgihk+pcHwogpvMJJZXHDcUxlDtDf52OKM7A4TKLh"
    "MEFhFhMyshpjcZgtkcMHv+OWL+YdcXkWr7GHZGMrqCX89pzo83W8DdtwGo7z8eH5kjXsah3k"
    "26pVC8OcSm7uupPO9oK3Qrz0AhvMoXEVJ1GPV38Eyy6WpkZZnsqdbr3E3XWn/OUmXSJc8/cP"
    "tKQ27cdNuiAxcWgpz79nfmIoLzEX2i6S++svACxcxa+kGVBLtxXa4whMxKQ15JIhQwcur32m"
    "/9YPOOkxhznht2MAAAAASUVORK5CYII=")
index.append('emoticon_grin')
catalog['emoticon_grin'] = emoticon_grin

#----------------------------------------------------------------------
emoticon_happy = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmhJ"
    "REFUOI2lk01IVGEUhp9778xoev0bFYVC04RAzUzDQAI3SkarpIRoEdWqloIrKWgttGoTLYJa"
    "FBoFkTJEKBK4sIWlLVQ0s0ix8a9J586d737faREMmbXybA4cOM85vOe8sM+w/i7IKK7S9BhD"
    "pxFaREA0E0aIeUnulnWz/V9AeoQ2DA+tit4qq7AFiURBNOKtoTcn8ef6F41wNdrF2B6AesN5"
    "KWp7bpdfRnIK0MkZjL+OBCmwsrGza7CUjf9lEO/7WFd5Ny8yAIkR9R2WQg1PXGMnGH06RHzF"
    "42hDAYgwO52gpBROn63HyTrG1vi1bRWmsqKbDRsg7dDjHO5zJQLGXyS+4tHaXs7s1A9mpxO0"
    "tpexFocgMY32F8it7XOtJD2ZDbwYk+GTLxu1+ojxVxHtI0Hqd1YpJPAwOoWoFJZTSKTsEvGR"
    "K+8rr3MiBKCF2nBWPsbbYn6qCKy8vfcRQYINDkVfAz7GUAUQAkDjSZCKoAOilc3kFB/Bsp3d"
    "/Uazs/oBSQyBCMbgZABas4jyGiFCruuRV1aDHQrvAmjlo9eHsewcjA6R9pkHsAGMYUitTWJF"
    "KrD9MVRyGZA/56MSC7A+QCj/ON7aEspnKCNiYoDStMUn99Rj16hZgp0lnMJzhAubQDR+/C3p"
    "rw9wDhzEyj/D51c3trWiuqmPeEaq1QEuhEs6BrMrusD5SbD5Du0tI0EKK5SHk9eIpprNmWG2"
    "ZmIXm27zbM8rf3tEhzHcd+t6qyLFddhhG0xA4Gt2VuZYGe9fNAE3m28R+6cXAFbv4Saz6RVN"
    "pza0BGlQaSa0Ihb26a+/s9tM+45fQ4Euif3E9BcAAAAASUVORK5CYII=")
index.append('emoticon_happy')
catalog['emoticon_happy'] = emoticon_happy

#----------------------------------------------------------------------
emoticon_smile = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmBJ"
    "REFUOI2lk01IVGEUhp977zjazDCpJQmBZURB/xiMbsKIIslVLty0sl0tBVfSorXQqk2rwBZB"
    "QSIkGIVhCxdFSFSYpo1/YeWYYtPMfPe73zkttImSVr6bczjwPhx4z4Ftyvt3oM9JWUe3CG2i"
    "ZFRBHS9FGS4WuLWnk/x/AeEIrQh3vYaeRq86g8ZrQR1azOFWxzFTfVlRumo7GN0CsM+4rDWt"
    "j/z6K2hiJ67wATEraFQCrwq/6iCe9THzDyl+G+2o72SgDNBhak3AXOzE/ZT467hSFuwPJDKo"
    "K21ARPEqGwgqj7M2djVvK9jX0Ml3HyAM6A7296Y0DmKyEP1kZDAHEoILefEUxOaJ1t/izAzJ"
    "I70pr0A3gA8gjnavphkpZdGoiIrl7KUdqFjUWc605lExqM0Trb0mVn0IcbSXAU45QmUaidbK"
    "JhWLRiHqws3eoi5ETA4wiNBYBuAoalQCF/FsYIzZqcUNo7Ob1TA3s8LIk0VULKgiQvBnA0cW"
    "WwTitLQe5uP7BRZmvqDOoGKZz64yPblKpjmN5ycQFyM0TAPEAEQYsrnxU351A4nkEi1nGnn7"
    "apaJNwvgLMkdHpnMTpKJgFj6JMXcHNYwVI5x/QF1ocenVPO9lNhJXH4CCdfQyCDR7xghSB7E"
    "S19k9vG1vLMcaOpl2QdId7LslK7CdD/oXoJ0M15Qi4qCKH58NxV159HEOVbeDeJKdDX1srzl"
    "lD/3c0GEO6mjPY3xXUfxK3yQiMg4fi5NsTTWl5WI66dvMPzfZ/p6m1Shih51tDkhE4VgQ146"
    "y3CFoe/Yzb+fadv6BZICYdMojMeqAAAAAElFTkSuQmCC")
index.append('emoticon_smile')
catalog['emoticon_smile'] = emoticon_smile

#----------------------------------------------------------------------
emoticon_surprised = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnJJ"
    "REFUOI2lkz1oU2EYhZ9789Oa3sSk/rUo0Yo6+I9Ci4PURRSdLNrFSTcdC52KgnPByUUcBB0E"
    "FUVQCSiKDoIVcXCpWo0VbE1728Y05ube737v6yBEVJx6xjM88L7nHFiinL8NfYpnLEMiHBal"
    "VxXUMiZKKWhwcc0g9f8Coif0I1x1isM9Tr4XTXeCWjTwsQtvCN+PlkU51TnAs38A5jHHtNB/"
    "x+06iWaWYxvjSDiHxk1w2nHbN+EYl/DLLYKZZwNdg9xtAbREZ5hgMrnzhiduDdssg1lE4hC1"
    "zV8QUZy2Iom2HVRfnK6bFOuLg8y7AFGCocSGEU/TIGEZ4h88ueeDRGAjnj8CMXXi2lts+JGO"
    "rSOe02AIwAUQy1Gn0Ic0y2gcoGI4cGQZKga1hv39dVRC1NSJq69J5rcglqMASQCrbE215ZCg"
    "ioqhsWiZ/ZamOt+BouSz3ylkK7S5ERr7QIgIPS0AlkDjZhobg42oTCXx1h2nuG8HAP7kW/yJ"
    "K6wtVFBcUEWEROsEayljAiCNimF+LkX35j4yudVkcqvp3tzHwuIKVCIcN4PYJFHIxO8fCA+M"
    "/wYnXUQFCoUG0x9e0qjN0KjNMP3hJflMBdQlmdtF4E9iQh60YqzdZFXk8Mnru+6JeUfdn8Cf"
    "SVCtZUGFXGaWQmaKjnw3Tu4Qn++fqVvDxj0jzLaKVLnJ8dTKg7faiwOQWCReeIUNptC4iZPM"
    "ksjuxrKRhfGHVMdLJ/ac5/Y/Vf56jYMiXPa2DfekV2zDTbkgMXFo+TH9nukXo2WJObv3HKX/"
    "jqlyCa/RzrBaDluhN47ARIxZQykVMrr9wp9jWrJ+AozrRzh66ZC8AAAAAElFTkSuQmCC")
index.append('emoticon_surprised')
catalog['emoticon_surprised'] = emoticon_surprised

#----------------------------------------------------------------------
emoticon_tongue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmNJ"
    "REFUOI2l00+ITWEYx/HvOffcc+9wBzOU2biMpIw/IzI2NDZKZGFiNmxYWk7NaqLYTqkpGytl"
    "oxBZ0C0ilAXJQmoSbpfQcLnXzJl7znve930eCzVCVn7LZ/Hp6en5wX8m+HOg96lYz5gI+0QZ"
    "UgX1PBGllnY4t3KU5J9Afo9hhItBdbw/WDaExr2gHk2b+NZzzKvJuijHe0d48Bdg73JIe4av"
    "h31H0UVL8Z1pxHxFXQZBmbC8jsCGmHdXST8/GOkb5cYCoDV6TYFGtOVyRcJZfFYHO4c4g/rs"
    "JyJKUKpSKG2m/fhEYousro7yLQTIC4wV1kxUNAYxdXDz3LvZBMnB5zy8A2IT3OwLvHnD4oGJ"
    "StBhDCAEEM+BoGcnktVRl6Ji2bO/CxWLesvu4QQVg9oE135GtGw94jkAEAF4ZaBYWoKkbWYa"
    "3+jqgmLsiMhRl2ONJZv3pPOwvLcJGEToXwDwpOqyGO/48v47nbmcPPNYK9iGUIlC8CFJquw6"
    "ZkEVEQq/NvDUselWiBnY0YM6g7qUz/WE9tsSK4IAmwa8b6UE4SLER+SG179uINyyzecEcRUV"
    "UJ+jzhKXPaaToWmOm0uRqEO0ZJC02cAabi0ABctU5+XZBNdNGK8CDVAxdC91FDfM8uZLi8bs"
    "d1Yd7ENLg3x8dDZxOVO/PdLMFQ4XV+y9Wq6OQGEO13qKTz+iLiOIuil0b8Wzltb0bdrTtSPb"
    "TnPtr1f+cIm9IlyobBzvj5dvJCyGIA5nPPOfXvHp8WRdHCe3n6L2zzLNnKfSKTOunn1eGHI5"
    "2Jwn3lIrGiY3nfm9TP+dH9w9VvwS8QG+AAAAAElFTkSuQmCC")
index.append('emoticon_tongue')
catalog['emoticon_tongue'] = emoticon_tongue

#----------------------------------------------------------------------
emoticon_unhappy = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmBJ"
    "REFUOI2lk01IVGEUhp977/w4422yqag0NCMCtTIKdBVG/+SqFm5a2bKl4Epa1FYIhDatgjYt"
    "gsKFIBRGP1QU0aKCKGMwSKmmNL3NnXu/7zunRTFR0ap3dThwHl4O7wv/Ke/Phd4mNI4REY6J"
    "0qcK6ngsynRc48KGIaJ/AtIZBhAue+2jnV5LH5orgzo0ruIWn5G8Hq+IMlw+yZ2/AOYWJ3TN"
    "wHV/4ym0uBpXe4Ukn1FbB68Jv2kbnvFJ3l0j/njn5MYhbjQAOk05CZjL7Loair+Mq1fArCA2"
    "QV39B0QUL99OkN/J0oPTkcnS0T7EFx8gDRgJtoyFmgNJKmC/MTNZBUnBpdy9CWIi7PJzXPKW"
    "5u6x0KsxAuADiGPQW9OP1CuojVEx7D9eQMWgzrBvIEIlQU2EXXpKpmU74hhsAJzSTb6E2KXG"
    "kYpBbYq69OdsUJciSRVIEKETIAOAI1Zbz+EsuJTo6zLPn8yyvBiBWJqLHj09JYp5h+KDKiIE"
    "vxw4KpgYyBF9XeHhzEta20IOHt3KgSMdbGot8Oj+AtFKjOcXEZchTZhtOBBhylSf7fZb2ilk"
    "39A/0EVzNkZcHXUJm1tzlDf1UnDzZEq9xNU5TMJUw0FgmKi9PB9hVxGEXYQFUEnApY1/FNw8"
    "QfM2NN/L/L3zkU2ZaABKQ3xyynBt9gpoG0GpHy8oo6Igip9bR3b9IbR4gM8vJnF1hveM8emv"
    "KL+/wmERLoU9o525tT34WR/EYhPHt4XXLDwYr4jlzN6zTP+zTB8uEtaaGFXHMSf02RRMymNn"
    "mM4mjO8493uZ/lvfAcIIUE4SmPhNAAAAAElFTkSuQmCC")
index.append('emoticon_unhappy')
catalog['emoticon_unhappy'] = emoticon_unhappy

#----------------------------------------------------------------------
emoticon_waii = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmtJ"
    "REFUOI2l001IVGEUxvH/vXc+1CY/xikNyzKkQM0sYdwEUZQotqmFm1a2bCm4kha5FYKgTavA"
    "TUFQtBAkIrHAQAgXFpQo4keONqaDztx37sf7njYxYOLKZ3kWPzic88ARY/0/kEkSgWbQGHqM"
    "kBYB0cwYYUK5PKnrJ38o4H/kOoYXVuNQk1WdRmJJEI2oLfTOLN786JIRBpL3mDoABB+4KzXX"
    "39j195GKKrT7A+P9QcIiWGXYZc1YgY238hr1e+pefT9vS4BMkPQcliPtLxPG3mXy1TjZjOJi"
    "exWI8HNul9QJuNbbhhO/RG76QT6Icraxn20bwHcYdM4NJ5S7SW7pPVFb0X2nnLWFHdYWc3Tf"
    "KScWA733DbU9y7GW4YTlMghgAxhNn1XThdn7StzapTMN8ajiRk85N3tjxKOKzvS/Xb0fRKov"
    "YDR9JUALLcQr2fy5su8iuY08Oxtq3yy7qgAPY2gqAWiUhEU8/xhbqx5GC37RUCgIawuKzKIi"
    "9IXMosLNuSCCMTgAEQCtWSJQHanzjSx++c7cpyyRmE3qdJxUncP2eoH5mV1qT2kamhMYHcH3"
    "WCgBxjAebM121Jxtp6NaIcEeEhQxuoiEipOnQC6HIEK09gpqa5nAY7y0ghPw1P0+kic8jh07"
    "A2IhxgPtIzpATADYOImLSPwy659H8qHP0xJQ2U9WCwPuwhhIA05lF5aTRIyAEexYiuiJW0jF"
    "Tf58e4cuMnB1mOyBV/41xm1jeJ5oHWqK1bZiR20wIaGnKWTmyUyPLpmQh52PmDi0TJvPSLhl"
    "DImmRxvSoQ+Bz4wOmIh6jLY93l+mI+cvGYE2OypTjxEAAAAASUVORK5CYII=")
index.append('emoticon_waii')
catalog['emoticon_waii'] = emoticon_waii

#----------------------------------------------------------------------
emoticon_wink = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2lk01IVGEUhp97Z+Y66GijSRrklNVKI8VMl64EwVVSQrWqdi0FV1aQWyEQggiCoo2Q"
    "mVAos4hCCkHDXKQg089gkKJpmk5z/77vO21iwKZWvsuzeM6B87ywz1h/D+Q1iVDTZwxdRmgT"
    "AdHMGiHt5rlT00vuv4DgFR0YHlqp/nor2YY4VSAacTfQW/P4maGsEa5U9TBVBAhfck4qO57Z"
    "tZeR0gPo/BLG30SUB1YcO34SK7Txv47irk/11PYyXgBImio/wnL09EjC2DtoLwvhLkb5iPbY"
    "2czz4b3L6fZ6koda2Z6+mgtjHE318sMGCCL0RY4NJMQB42cZuzfH2IMM44+WQQdkFvPESzQL"
    "Mx/R/mfKGgYSVp4+gCiA0XRHKtvR3gKiXHqunUCUh2gfCT1aWsHoAAk91PYcTs1FjKYbuBEF"
    "0EJDrKQC424jJuTLYjVWtBwLARFAAFBKcST5HPAxhvrCBWhcUZ6DVqAD6s5eAsvZ+16jKU0e"
    "ZndmDEQwhkgBoDVZQrcZHMSEJJJl2PFUkTSiPSy7FKOjBD6fAGwAY5gIN+axnBRiQP18C6KK"
    "AOHmFNGKJtyNZUKfiQIgEjKcXxzMocqxnTqC9Rf4qyOY4PufzS7B2iT+yjhS0sTKm8GcChje"
    "I9LaE87HqjtH46keiOyitt6h3RVEeVjRciLlzWiOs7U0yfZS+kLLLZ4WqfztMZ3GcD/R2F/v"
    "HGzEjtlgFMrX/FrNsDo9lDWK62dukv5nFwDW7pLIx+kXTZc2tKkAwoBZHZKO+Qydur23TPvO"
    "b60jN27zp9/ZAAAAAElFTkSuQmCC")
index.append('emoticon_wink')
catalog['emoticon_wink'] = emoticon_wink

#----------------------------------------------------------------------
error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI2lkk9IVHEQxz/v7bO1dTdzS7E/GImgKKRgh9WSPGdQlyy0rgVdwujWKeggQRBqZAQS"
    "JREGkZBkEljSIToVbIViGBq6uprpKvr2vd9MF40oLaM5zMD8+c73Owz8p1nrFbTreCCZM/EO"
    "MbO5c7trrfqHZq0+Zz2AZHS8JZh/uEyNYcL0nAFubpjWt95YNNFXNW/Sc5qefa/j3ftnRrti"
    "0bV67bWSy5Z9N1TQGLFsGycrSqiwMWpZ7pUNbZ98Vl0x8TRm1LjqTrZpOtmhkp7Wzw/2+SOd"
    "pRV/ZaBGOiMlTbb4C3zq62K49w7iJcgpvxhQtVr/CJDoiTVkRKvKsvYcY2msCVVQheUvzUSK"
    "6gjm1xwcul3UsCbAZP+hsKi0hApPIP4MyMq0KiIesjxEdslJRPRqvK00/BuAn1rqCBXUbwvm"
    "FOJNPwKUzK2hVWG4iRtszi0gu7hhl7rzl1bnLIDR7liRrd7HnXUvHLP0Fm/qFiJgZ2SyOJ0i"
    "mCUEAkpgSy2ByFHirZVpWdayysvJYRvAFu9+pPico7KASb0GFUAZGRhk6sM4oKCCP/scy14k"
    "L3Zhk++61wGssceVdRnZ5U/yalrwUy/xkvcAEFFULVCwA4qlaVQNdmA7mXubibc3MDs4cMRR"
    "X9ojRacAcMLVOOGqFXHWqvwVpz/ugbWJHQfO8jXef81BpD/56vxpNYIY4edoPINxPXzXw7ge"
    "xvUxaR/jGcQ3iDFvfv2Lf7bvSM4aer9Gl2cAAAAASUVORK5CYII=")
index.append('error')
catalog['error'] = error

#----------------------------------------------------------------------
error_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAntJ"
    "REFUOI2Nkl1Ik3EUxp//67tmcy9zbwgzP4IxaSk5I5U5DKPworzpJg2tiwi6MCKsLgRvvRhB"
    "BGb2BRYhFQahhWTeWCYiQR+WI7NiqTGnU2wffrx79/+fLlKInOVzc+DwnN85DxyGDUSdR1NC"
    "1ukRCL6QEc7ez6of8WQ+eSNASA20GG2HC4hzTPOe0wCub+Rdp5+9bjXYVxbh8TDFF3wU6C6e"
    "n+x0q8m8UrLmCpPumXLrFCZJkNNUmOx1KmNa86a2zzz3FE0/c3PiGmkzrRQPtZOIz9H3h4UJ"
    "f0d+0X8vIC46FGeDJBIxfOvrxNfeuxB6EFbXxRQidvWfgGCPu9aglhWk7TiC5akGEAFEwMoP"
    "LxRHFYy2feXjtx21SQEz/RVmQaLFZK+BSMwDYnWaCELoECvjsDiPQQi6NNqab14HSESX2025"
    "1duMVjv0uccACKnpprVg0ILXsDUjF5adtVmkRZrW5hgATHa7HRLpn7ZXvZD58nvoszchBCAZ"
    "UrE4F4UxTWBgguHlhAHhpRi0pQXEY/NXHnh952UAkIR+X3HWyyRi4NFhgAQABv/AZwDAmDUD"
    "o5oFFeXFyFbz0O/rwvDoq4bSM5lCmuraWyWnu0qUvBrwpbfgi29AJEAigZzSLOSUZKFnLIoi"
    "pwtc4nBlVoIzHe7dHkhEZ2VKiBuK4zgAQDZ7IJvLVsOxtfiYDR+AgZlxaNcpAMCFg7fw9GMb"
    "iD3ZIkOI/tDguRPEBQQX+LNynYNrOiIRwBcYwkhgEI2Vd+DtO4nUFCMkgLO/HyOZSuszm3Ps"
    "liZPYTnybHvwJfgOQx8GMeUPX94U4DfE5gVj9QxQCIiCqO11W7DxFxUDJjtpXW+fAAAAAElF"
    "TkSuQmCC")
index.append('error_add')
catalog['error_add'] = error_add

#----------------------------------------------------------------------
error_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm5J"
    "REFUOI2NkltIlFEUhdf557e5MzqlaaWiDDQopFDBKElB9JC+9JKG5muBL2IXCISSiIigFzMs"
    "AomSCIPIyjIVtEail8gikSRRvMylGTEdndv/n717SCNyLNfLgcNa39lrcwQ2EHcdN4Qy/J9A"
    "ciFzcdchUf1YpvKpGwFCTl+rMbuymKWEX/acAtC+kXedfvR6nIG+siWZXOTkwij7uvfNT3d5"
    "nKm8SqrLuFDuW/Lq7EJRoFqdsBTWOYVIXNnU68HX5aX+Vx7JMsGJYBsnQx1MyTBPPdqjT3YW"
    "lf53ApbUaXc3KaQvY6KvC99674G0ADJKzhmYxc1/AgI9nto0Z1mxNf8YYjNNYAaYgfjsNdhd"
    "VTBmVxwYv+uqTQkIDh60EVOrpbAGpM8DtJpmBpEGio/D4T4BIr7+pa3Itg6gR2IdlrzqrcaM"
    "QmjhJwAYpnTLWjEkArdgzsyDY3ftTk4sNa/lBABMd3tcCmtjO6qGVBkbgfb9DogAJc2ElXAE"
    "Rish/M6HoHcGK7N+sBkMgRtHnmvnVQBQSHtodzeoTMuQkfcAEwCBybdfAQCmJGFlnFBa3Qhj"
    "QTFin/vEqLf/bP/hsWkx83RvVZqj5EVWRSv0yBtooQcAACIGswAY+Hj5JfbXX4J5YgiYGwYc"
    "6Qir+fgw4A2qrNNtu+skAEC1lUO1la2WE2v1oYWyYMouACrP/N6+2pIDVRfbVRANhoYb61kS"
    "SBL+PKUmIRMa2AxER3pgfdaARCyAKIDIkgFSRVT8/TFSyVuT07LFZm3O3SZVVZlFJKRjKmCQ"
    "yThd3BTgFyT3QnTed1ohkU8KzxG4/egAXf0JYe4suBG61DUAAAAASUVORK5CYII=")
index.append('error_delete')
catalog['error_delete'] = error_delete

#----------------------------------------------------------------------
error_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm9J"
    "REFUOI2Nkl1Ik3EUxp/33WvG3KotI6ulMWaYIxUq2PygIOoib7rRQAvvuugqoQv7oBl1EV2a"
    "UBFImUQskLyQzKASKjQsigopK3Uzp86P9lHb3vf/P6eL2kW5lc/NgcNzfucczlGQReyvM4Vt"
    "oTcgubgu4tij1N+VmXxaNkDYPtWWW3DAzVIiJHuPAriSzbtE3/o89ul+b1TqEdYX3/NUz875"
    "gN9jz+RVMyWTitppLmy0KqoKLc8Os7PRriipC8vqPvOgsiJ03yNZpjg10856uINJn+PxO2Vi"
    "rKu04r8TsKQua0mzSiKOz/1+fOq7ATKmYSs/YWJWLv8TMN3racixe915RQeRCDaDGWAGkpMX"
    "YXXVIregpvrjdVdDRsDM490WYmozOw+BxDxAv6uZQWSgpbsOrZNDIOJL79pLLUsAIpboMBfW"
    "r821OWHMdQNgrFxjTi+GpBGFI38bfJyziVPR0+k6BQACPR6XysbIxtonmky8hjF7DSeHJgA2"
    "oJOALgQ22IpR5qjGi/FHeDs5iNaY3Oo9OzeqAYBKxm1ryTGNKQ4ZGwSYIEjHPncTJBMkSRAY"
    "U5EgtjuqENcTOJ4Y+ACGSQve21GrrS7fZS0+BBEbgPz+EgCQFDokEybmR2GQgCADhjQQTcVQ"
    "sbkGceOHsuB7qmss6KrVdRgAoFkqoVm8vwADVRBSYP2qQgiSkEwIRQKwWwrwKvgMX2fH0D5r"
    "+qIE/OWdJOkISwJJQjq2CIGkrkMnHUmhw5nvhse5H8OB5xgdeQjfggpVyFtZP/Jvuc8r4aab"
    "e7noFIZLfVjxxxWWoy1nECY25Qc0mYNzEOn8Txg1QQ+znYn7AAAAAElFTkSuQmCC")
index.append('error_go')
catalog['error_go'] = error_go

#----------------------------------------------------------------------
exclamation = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlZJ"
    "REFUOI2l0stL1FEUB/Dv/HxMqEw/LdAZ8TWmScyqFkEghFFQtJBmlfgAV7aQ/oJwkZsiaDGb"
    "FkH4wCAQahFRIAlZEFGJjQ3mjKLpaDWNj3Qe995zTgvzN6i08ru7l3s+5x44wCHj2n8ht3vr"
    "tUu3CXMnMVcwMYR5lUQGoWTEvjcY+y+Q6e8JugihbavQW1h/AvkeDwBAb24gFYnASq2vMHNv"
    "+f0noweATH9PUAwPqPLq4qLGBlB8ARxfAABY3mpYvhpsfo0gPTO1DeKuqgfPRh0g3XfDL2Le"
    "KG+1r7ixEertKwBA0a2HAICtvm6ABYXNl7ARnsafyKe4Iav55KPncxYAEKv2VJ47VywCYXFG"
    "Y8MgI0iNvYCn6RRQctxHJt0OADsAmQ53QwNoaR7CAiaBGN4DsCaQYmTnYjjaFIDWusMBjDGV"
    "BbYN830eYtjpuBtSDNI795loDAV2GUhRZQ5QBkLiFO521N/CuRH0P4QYIIYxCjmA1HI2kYTl"
    "rXG+SpqRnhjD1tPHTnfWjPyqWqQSCWhjlh1AKxpaD08hz1frPCbN8HTfREnrdbBmkGEQMdy1"
    "fvyc/AAyZsgBsoqGVSIeX5sOo6jlsoMkQ3fxO3QHRDtn+8pV/ApPIrk4G89SdnjPIn1pPx+E"
    "4QE7cLa4tCmAzPwcMtEYRATuOj/cdX4kwpNYfPdyW1i6WsZnRvcAAPDx2rmggENHynzeY4HT"
    "cNulEAEya0n8+PweyaXZFRHqvTgePbjKu5loPVPv0tTGxJ3CXMFMIOZVJhm0LB658Doa219z"
    "qPwFxTSLV+ldGkIAAAAASUVORK5CYII=")
index.append('exclamation')
catalog['exclamation'] = exclamation

#----------------------------------------------------------------------
eye = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI3Fk0trVGcAhp/vmzMnk5mjjEnGXCZJk3qhYJoQuxBLUSLYhaDortLfIFJKqC77B4RS"
    "SBddue6mYtsg6CJglahNCvGuaS5jMsbGZJxkZs53vlsXYlBcttB3926ed/O88H9HvF0WFhY+"
    "S9n6edFYG0E3moUzYA04i0AqorY7Lt97rlgsXn8PsLi4eDGIX3wh1VoYygCdxFTW1zFJQlMK"
    "CttyWK3Q1nm6h39p3z14YgtQKpWupCqzn4doni0vUyqvEYsI3dSBtoLEOHJmhS6WGehpRTqL"
    "7fp4pjB4ZFDMz89fCOtLX4W6yszjecIPDvMs6UQbUNoTa4/SjkbiGOgO+WjjV3LVOaJ0imr/"
    "yEVRejLzXFYet7/yefYMH2J8qk6l7lDaM/rlEN47RsemibUjkxZ8c6qF1QeTuLvjrG5qE+i1"
    "2Z3ZziH6C0Xg9WpdWZQB7xzeO+qJRSmH8BKA/J5PqGW3oy+PBUF654ALo5aUtRYpJa3boPTS"
    "EieOs9/fQiWeesMQa8e+3izOOay1yJZu8v37vGRjqaqrKxhj0FrT2yqJQketrqk1DLVYsxlr"
    "2iLBcF+A1hpjDKo8S6qypKXLtP3kn98nKf2Jqq7SmrMc2CXZ2+EJvCJNwnCP4Pj+kP6CIKlV"
    "UY9+R0/8SDnJ/CEAHk7fvJF7ee9gcyBw+b51kSvEPtqRiCDj3njivce9+Cvj5yY7k9I9HjWi"
    "8tGvLxS3RLo9ceVSUn5yrEO+CqJsBpq249JZvAfhDGZzHVaeMvf3pt/Y8eGd7Mq1T0e+nTDv"
    "qPzbd2eaTE2dVEqdSgtGQuEj6Z1w1rhGQ03FKv5ZGj1++oerD/67N/3b/AOWglVDnpaoLgAA"
    "AABJRU5ErkJggg==")
index.append('eye')
catalog['eye'] = eye

#----------------------------------------------------------------------
feed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlJJ"
    "REFUOI1V092LVVUYx/HPftOxOTZncJxzMkwmMjCUxomhEYOwq4KghOjGwLu6y0MIIgST+A8M"
    "QhDeRNF9IL0ipNnLReGEGkJkhxoZFSdSTD1ve5/dxdoT44KHZz0L9u/5re+zdlQeVDdlXqZl"
    "dcVVrK3XrhzLFlx1LDVl3pP7WhrPkGTEKVFEHBHFIccREiIhyoJrP7d8cUoqEz7uJTRnSXDz"
    "Mn8vEscklZ1EECxLahNMzjB5qpWi6jzC7v2Vx/0M7vH7aa58TnE3tC7LkG/dYGQTQ2JDRCn3"
    "r3PpU9rfc2+FbJSnXuWlE2yZq4QjBgO6A/I+fdIALAoCv34S9mnMxDTTbzD2GM8eYvEkV07T"
    "y+n3GBR0if8n3pzltY954ThPvMKdNt8cYelcaD7zJo1pej26OYOc/uoVVglno2zewdMHePEE"
    "9SnOf8CfZ4PInkOU68MVHnAQ4Z8LfPk2509WDB7iuXepPcq5Be7eYF2NnS9XDoaVg1gYVxnT"
    "ucnSGc4c5a+zQWTPYWR8935wsft1Ojn9ooI4rOgmJXOHyWosfcvih0zsoNagOcPFr9n3LyMb"
    "Gd9KXlQOIC7ZvJMts4HB1r3cuR3GCo/vpVPQ/inU23aRl2sERHRWGNwP5cofgfbyb6GuNQO4"
    "q5dDvW4DRUFOqo8yR8FX75CNsXQhzLv9Cx+9FUbWKfjhMy7+GOxvHA0v/L3t6pob5oxvD5Tj"
    "kocnGWtQbwTAccJkk7Fx1mckKe1L3Lq+EJXPq9tm3iNahtWv2kW/im511l+TU2QWbi879h/L"
    "jtG0Z7ykQwAAAABJRU5ErkJggg==")
index.append('feed')
catalog['feed'] = feed

#----------------------------------------------------------------------
feed_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp9J"
    "REFUOI1V001oXGUUBuDn3plJY2bSRE0zaf1pg0aMNCZWQ6MV4g8BBVELbooFcaMbtUGFuhCi"
    "dKO7UhAkm6K4VKv1l1b8SVM3mmgwVcQ2lGhjm4TWxGScmTuT6+LeSD1wON/54HvPe95zviB+"
    "QqtOI3KGrVuY+uX55VbDOQf97tWsTiNuundY8XYyOcIsQUAYEIRJDANkCCQe15n7btinR2Xl"
    "JI8rGTr6yWD+ZxYnCUMyKZ2MBDCOKbTRvoP2o8NZpJUbuW13ynE30Sq/Hef0J9RXktJxnMRL"
    "52m8mjVCawiylP7kpyPMjLO6QC7PLY/y4CG2DKTAAVFEOaJWpUo2ESxIAKbfSc7ZkLY++vbS"
    "cj079zE5yunjVGpUK0R1yoT/Kd7Rz2Nvc98BbnyE5Rm+3M/sWFJ8x1MU+6hUKNeIalTXW1hX"
    "OJdnUze9j/PAIVo7mXiTs18nIHfuI96QtPA/BgEuTvHZc0yMpho0cffLFK5h7CAr52kosP2h"
    "lMEaVYL4dbHBA8xOp6MKEiY9e9l6DysXeP8Zx7JFX6yULK1eFJWWDOWb7Rn/SDZpISATM/Ai"
    "uQKz3zB5mLZuCkUfZ4omG0oGd93h2qu6fHXqAx9On7DQtDFd0jBm03a29CcaXLeL5b+SseLI"
    "3Bl9N/eqh3W9m4fUg8hAz13ebW5a3/KAfxaISkm6cCZR+9yvYH7pglxQ8HD3s+CF+0fd0H6r"
    "ahDIqiKuoc7nz5NrYXYqmffMD7z1tL+XF52a+9bU3LiXhg577diTGjMbNMSxzCtdWnVcMeDK"
    "rkTlMGZjOy1FWouEoXIUGVv8xbbiNoulPyytzjs5dULP3NJEEA9qtdWIzYatpV+1jGrq5eTu"
    "jXyz95rzSmGgaS22s1T5fv+Pl4b+BTWH7yK0JQYwAAAAAElFTkSuQmCC")
index.append('feed_add')
catalog['feed_add'] = feed_add

#----------------------------------------------------------------------
feed_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo1J"
    "REFUOI1V081rXVUUBfDfPfde+2xCk9o0L62k4UErVCvGSjBFQevIL9CiDsSCA0FRxIZScCKk"
    "4j9QOlE6kYpjC4GqWNFaSgUl0WrRatskxtQ8X9RqzNf7yLsO7kuIBzb7nANn7bXWPjvKntep"
    "ZFhqyOoKrVh/Xr8auO6YX72ZKBl22/4hxXuIU0JCFBEiopDnECEmkke2wm9fD/lwRCKVP67G"
    "9AwQo/IDf4wRAnGLTiwHzDLau+jeS/fIUIJW5QJ3H2hxPEB9gStnuHqalfm8dJbl+UaZwhaa"
    "BE1ECYszfH+K8fMszJK2cfuTPHKc7YMt4Ih6neU6jRo1ktywKAe49H6+TwJd/fQfpGMH9x5i"
    "7ARXz1BtUKtSX2GZsOZ4zwBPv8dDb7HzCebG+ex1ps7lxfe+SLGfapXlBvUGtVUJqw6nbWzd"
    "zV3P8fBxOkuMvsPk2Rxk3yGyDbmE/zGI8NdFPnqN0RMtDzZy/xu038q5Y8yXuamdPY+3GDTX"
    "exDIAksVpj5n5ivuPEjfg+w7wgevmn77ZdOXf7bwyxVpIdE731SqkeQSIuKMwSOk7Ux9wdi7"
    "dO2mvWi6ErlRKet/6gUbSndY+u4TP57/VLIYWp80ZGzdw/aB3IPe+5j7O28rJka/tHP/MwrX"
    "zopOPmvj+Cl9O24xWY8ka/1dqlBfzLXPXsvdvv4TqM3+rtBT4tHDa+OQHN2m1owkasgaWOHj"
    "w6QdTF3M+z3+DSdfkrYVLH57WtvIK6pLZYv4dy6WxMRHd+nUc/Ogzbtyl0PGpm46inQWCUEU"
    "UpOXLwlpUI8X/PNnZmImtqXZvBBlD+jUZ9g2Q5qtUV1GrRXL+d20TSbmF9RWImmc2RyyC73l"
    "5mP/ATKN6mYTpdRFAAAAAElFTkSuQmCC")
index.append('feed_delete')
catalog['feed_delete'] = feed_delete

#----------------------------------------------------------------------
feed_disk = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAotJ"
    "REFUOI1V001oXFUUB/Dffe9NHJLURkzS2mJtN0pEaEyb2pWirgRBu1YQhCLdtIO4VILgUiG4"
    "7MKFFMSNQvELgqgg+NlAUES0FklrqoltQ2JmMvPe3OviTWo9cDj3Ls7/45x7Q3rOmEPmNLTs"
    "RDbIW++3RoU/zLvs1cIhc+59tGXPEfIGWUEIZIGQ1TULyAnqTH1Wvmv56LxCQ93czdk7S47V"
    "n/h7kSwjH8jJ1YApMTrO5AyT51sFBsxNHjwx0HiCcotfF7j4If1/auqU6nrjT5p3EslEhIL2"
    "VX54n0tfsrVGY4T7n+aJN9l3fAAcKEu2S6oePYp6YKEG+PFcfS4yxqeZfpbdB3joDItnubhA"
    "t6LXpeyzfRNA7f/hFuvLrCw689W0XZc2tXtL7hgdsrJ6VMiOGh3OxRTcWOo43XlPIfpvwo0R"
    "JqaYmNL59ILHjt3nqZlRH3x9xSvPTP1vk29/vmY+npPJBqu5vsTHp7lwlq017W7p+mYFFr7/"
    "62bjdsVGl7X1nhDijoWMlNFZZfkzrn4ry07KE2U/euPUjBiThFwyXNDtdm1s9XYsBPLE8Zdo"
    "jLL8heYvme1u6bV3f5cFqn4U+1FCSonEcCOq30GWmHiAfbO1zlSpYke3X8mzBpKgL4QgxSSl"
    "qKpKvV41ABBq+WWbxjBrv9lsT2iEwqknd6lir15VIoWoWQx5/Z1l1za2FHo1I30+eZHGbpaX"
    "9OPLcg1Rx1uLLxgfPiDIrLUvOzk7L9PU7vYUrpi38k3L5CxN9EsOHlas5g7uZc/opscPHzM2"
    "tJ+M9e39Jkcqw0MUIQjpEWPuMecuLXHwVbd5Ps7r3H3E2G1jmsXtqlgKMQqpL4a2n5cvWd0o"
    "/Qu1JAns7Um8HgAAAABJRU5ErkJggg==")
index.append('feed_disk')
catalog['feed_disk'] = feed_disk

#----------------------------------------------------------------------
feed_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArtJ"
    "REFUOI1N0ktsVHUUBvDfvTO3jJ3CNNo3ZMqE8CitUiBEEgXiTsOGLgwLSdzKRhtD4sakITFx"
    "2+hCQnTnois1xFdiIhAQI2q1gPJsjbWlhdI6FDp0Hu11cdvYk3w5///ifOf7Tr4gfl2jggGR"
    "fqsVrmDtf23VMGnQP06mFQzY9lK/1r2kIsI0QUAYEIRJDwOkCCSIl7j7c7+vz0iLJMPlFG37"
    "SOH+nzwYJgxJrchJSQjjmIYmWvbQcqY/jZXNGXb3rWjso7rA7e+48xVLj5PVcZz0f6fJPMMy"
    "oWUEaUpTXP2csYsszBBl2XmEVz6gY/8KcUC1ymKVWoUK6eRgQUJw7dPknQ5p6qX3GLk8z7/F"
    "8GkLY1+YqOakcr0Wxs7Lr2tcJZD4P9hPcZy7w4yf5ft32Huc/EGl9jaPHj6nremAXGG34l/b"
    "jT6oSVv2/4WjLM1dCXb2cfE9fj2lVLysHJU8vfUFc6PX1QUV6ze0yTQVVhQEmBvhmzdp6WFH"
    "H9lmXnzX4tk3lFMP5Ta/rDw1pK4+8PfvNyyXq7b88NmqhZA45Mn9RPrUZZ49ppSh3LFJbsth"
    "i5OnhHU1UUOn7KMrmuq3ysw/XrUQkIrZf4KogfHzps+9T/duLT1HLE5+JIxqKvMFs5dGtJca"
    "ZbJpKqshDWOae+jYR3OX6Vqs2NqjpfuwyvTHUnWx8nynmQu/2HT0tEznXmrxGgIBT2aolty6"
    "NGRubkJF3tTVDy1btDC30ezZH+U3HhJtaKfuKZaWqJFWQVzDEt++beT6Ha8e/8TNoRNuXbhk"
    "XX6XcHZMb7EmmjnHjSvUllifJSQ0YdDdn5J851rdHr2n8seXCrsOyGa3u/fbdd2t22S697C5"
    "QGNDMjx2lchgEB/SqNOAdv2Wee1yo12bW+3bUbChcl/XzWvqnySxVZP0NCKDxUkn/wMZSPeN"
    "olecpQAAAABJRU5ErkJggg==")
index.append('feed_edit')
catalog['feed_edit'] = feed_edit

#----------------------------------------------------------------------
feed_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAppJ"
    "REFUOI1N08trnGUUBvDf981MM2mSOtVcmkpSoqRtJGhiLAYaL92puGhxJQqu3ehQF0EQo/+B"
    "dKN0oxTdKgTUQsG4ELGtHdBKF0mxF+1UkjRJSzIzmcv3uvgmJQcO55zF+5zneQ5vFN5RMGJO"
    "TtFOxO3cPe+OJu74zD8+zRox5/CJooEpMjniLFFEHBHFaY0jZIikGVqULxf9MC8rJ328neHA"
    "MTJYvsZqiTgm06aTkQKGQHcv/c/SP1/Mor05z+SpNsdTNLZYusD172ltpqtDSOv6f+QfIyGW"
    "IMpSucvV7/j7F7ZWyHXx1ElePcPB6TZwRKNBrUGzTp1saliUAvz1ddpnY3onmHibR4Z5/n1K"
    "Z7l+ge0m9W0aLWoPAaT6XyyycZtyidsL/DTL1Lu2OvPuJ2UDA+MySxdTkEaT+o6EHYdzXfSN"
    "8cxbvHKGwoik9IW1a1/JF8at9w4ROlIJbQaxuH2atT/48T2unG17sJeZj2x0duscOG7f4KT1"
    "mwuqR2aoNWkkbQax9FwhprqcUl/4kFs/q9fW3GtW9fQWtB7M6x1703JrQ6g1qbd2S4jIBKY/"
    "YOZjBp+j9KWVq+c8OnqSWsmlc9/oLlSt3/zN/b5+mjsAEAf6xjl4LPVg6LjNzXWNWkXP/opk"
    "+wYh0dq8bOTl0/7tqGk1dgOIqK7QqICwvKTcqCoMT0gqfwpJ1dQbRyT1snx+0b6x15UrZZrE"
    "6ghNtDh/mvOzVn/9XH70NXt7VoXmPaKMK98uIpHUFvUdPuTOg7JKd4fMJ6MKDnRO2z/Knm7i"
    "YGn5luETs+JsRpQbEuePenzyBXH+qGjPk7JdozI9T7hRvrgUhZcUHDJnUFGSftVLA09rJYQk"
    "CK1ESJK0T8LDPklazRD8/j9JfxgTZ9hUEQAAAABJRU5ErkJggg==")
index.append('feed_error')
catalog['feed_error'] = feed_error

#----------------------------------------------------------------------
feed_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApZJ"
    "REFUOI1d00toXVUYBeDvnHuvpDbYh2kSY422SiAPNVZDAypSQbED0YJDsTOHeimCEyEWnTkJ"
    "4kDiqCLiQLEUfEBFMUaM1kRqi1bTVntjE2l9tGke556ng3O1wR8W+wF7rfWvvXdQ7LfZDmNq"
    "6v6tsIX16/WV4rxx8w5W7TCmb09d191UaoRVgoAwIAjLMQxQIVCiyFg4VvfhEVU15eFmhe4R"
    "KrjwA3/MEoZUWnYqSsKioL2Dzl10HqlX0VJu4659LY/7SFaYO8rpD8iWS+miKMe/f6ftenJC"
    "OYIqq4uceJ+zU6xcpLaRgcfZ+yo9oy3igCQhSkhjYqplYEFJcPKtcl4N6Rhm+Ek29bL7WWYn"
    "OH2UZkrcJMmICP9LvHuEJ97kwZe47TGWzvLp8zQmS/FdT9M1TLNJlJKkLQe5qwnXNrKtv8TA"
    "PqZeZuZ18tyB6RctR0teK3pdE639z0GAv47z0TPMTLQyuJb7XqD9RibHRUnT9o5+T+U/iZsJ"
    "Sb4+g5AiZO0Cjc9Y/EZ96WdFkYrzRJwmerb26e/e7Uq04tG1aYebQzZcbSGgUjD6HLV2Gp9L"
    "L5300OB+WZHL8kyusHB53u3b77Ucr9nTOOSTjPIdhAXbhugZKQMrUtGJCVmRO/fnnCRPpXki"
    "yRJLzSuGb7rfcrJq5I6pFoGgtJ+slr1fPCNKI2mW6rquV5pnsiK3eLlha3u32fkv/fjLt979"
    "jqq4VCTj4wPUNtE4bi2PHPrqFXEei9LYzo5BozsfduzclO/nJr295RF90WFVvxm38HVd5wht"
    "yBJuudN7yVB5VXFGkrnn1zcE4Qanzkx7Z8tetzYa1IwHxQM2u9mYG9Tlra8aIW4hKvcGB1hW"
    "8cVMpjdDzfil8w7+A+GYI3dex4ktAAAAAElFTkSuQmCC")
index.append('feed_go')
catalog['feed_go'] = feed_go

#----------------------------------------------------------------------
feed_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqZJ"
    "REFUOI1N00tonGUUBuDn/+efmOY62kkyppgaepEEpa02GEGodScuNKAbEdy41lAKIgix1KWL"
    "4EbtRhA3roSCRqxtvWQj0tDaKsbUYGNrYnPtJDOZ++/in9QeOJzz8fG973tezhfEr8kYNCFt"
    "3E6Ezbz3fG/UcMukv52KDJpw8Pi4vidIpQkjgoAwIAiTGgZIEUgyrvPPz+O+OiuSljwup8iN"
    "kMLt31iZIQxJNeWkJIBxTEeW3sfpPTseocncypGxpsYxqgXmznH9S+pbCXUcJ3V9idbdNAg1"
    "EEQUF7n6BfPTFJZJtzP8Is99QP9oEzigWqVUpVahQpQYFiQA1z5L+igke5jDr9I9wJNvMnOG"
    "6+co16iUqdYpEd51PDfCS5/y7Gn2v0B+ngtvsfBDQn7kdSthylLLtnw5T7XWVNDwv8PpdnqG"
    "khweY/o9Ln1Eo2F9Y0EwkJMdPmFt+n1Wl3TdVRBg7QpTb3DpTNODNp5+h4497lw4rZY/r/uR"
    "owo3pqQyQ1bjosWgY2eEkDhk+zYLF7n4Nje+S0CeOqkUBbofe169OKc12y9qI3fskMLRQzsj"
    "BKRiRk+S7mDhe2Y+ITtER5/ovpzq+l/C1IogLGjpWqFUtPVvRbIHYUzPo/SPJIbFNa5NKf30"
    "sY14WdATadR+FTY2CDvF1Yo/Pp+TuTzXBBAk8qvFRPbynzbLd+Rv/uiB4y+LK98I6pt+nypI"
    "18pSlW270wMeKl4WqTQZ1fn6BOluFq4odLbKPvOKysqHoqjb7PmCtvmGfX1dgnq7VHdXsuHv"
    "HpCR2zXq/gO0dCTjdPUq2rRrbye1NbPf5nUWsw4O7hO2tgijNPNXWV+cDOJjMvaa8KBxjeZX"
    "LXEzs0fx4f1Kq1syv8wa2NxK7iqIkDa5ccup/wBSMffA4EVY+AAAAABJRU5ErkJggg==")
index.append('feed_key')
catalog['feed_key'] = feed_key

#----------------------------------------------------------------------
feed_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsNJ"
    "REFUOI1V0l9o1XUYx/HX73fOdP+onc25LVkybAPD1TSlyRbV7KLAMFFosCIvorvy3HUTWETB"
    "8EbsJrQLiaDLYFIGhohMC20jsxWkbtGcZ3rU6dppO//26+J3JuuBh+f7vfi+P5/nwzeI3tKg"
    "wyFV0lYqrPTq++oqYcYR0z5K6nBI14tpLc+QqCJMEgSEAUEYzzBAgkDcUZmbl9K+G5FUJX6c"
    "T9C6gwRu/86dccKQRMVOQgyMIurXsX4b60fSSVSUq9m6t+JxL8UcV09z7VvKC7F0FMVzbpbq"
    "JpYJLSNI8m+GK98wOUouS1UdT77GK0d5rLcCDigWWSpSKlAgGQcWxIDfvorPyZB1PfS8waOP"
    "8+xBxo9x7TT5EoU8xTJLhA8Tb93B/i8Z+Jgn9jA/yZn3+ftcLL7tHVp6yOdZKlEsUVhZYSXh"
    "qjqaN/P0EC8fpaGDsc/562wM2XmQaG28wv8cBLh3mVPvMXaskkEt/R9Qv4FzR1iYZU09W3ZX"
    "HCyvziAkClm8ben6GaMXxvya3yTV1OzunWb762c0/vCZLyabpFIpc17y1FRWfz4hGa8QkIgU"
    "t6d9ffK8f6I1ht58XS6Xc+PGDSM/5tXeynp16IBEIiGTyRgbGzNd6BL/gzCieYsLUwXXM/ft"
    "Gxx04pN3nZ9a1NrWpru72+SDRRcPHzY7O6tvU4v+/QecmtpVAQhYvO2XiUvq6upAevO8s38U"
    "DA4OSqVSFhYWZLNZx48fl36u08+oa2iUVEBUQlnb3VE/PWgDw+NrlZcLhoeHH0JzuZyoVDR8"
    "8qJdb/fJzkxLfNipQWtNr1Snmppa5yZm5RfzurbutL23T3t7u3K5rKWlRW9vrxcGBrR1dPpz"
    "4oqrE5fvBdHzGmx0SJt0uczUQr1Pb+5Qu36jqrXVliP23fpeY3HRiQ17lINQMb8km5mef+T+"
    "3O7/AIzLDZub0MSmAAAAAElFTkSuQmCC")
index.append('feed_link')
catalog['feed_link'] = feed_link

#----------------------------------------------------------------------
feed_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoNJ"
    "REFUOI1N001oHVUUB/DfzJtJ0nz4qiYvbQpKRIrWojESrCBIFZG6qQGXluLCLvUhirgKfuwV"
    "Fy7cCOJeKNQqBdvabkQIFKsYmpQ20qS+1Ibm882bmTcuZtL2wJ9zz73c8/+fc+8JiuN2Gzcj"
    "1rRjYYX74/stww1f+scnkXEz9h9uGn2OWkwYEQSEAUFY+jBAjUCJImfp96YfT4rEystJjT1T"
    "1ND6i1uzhCG1Sk5NmbAoGBymMUnjZDNCxdzHs9OVxmnSTa6cYf4U+UZJXRSlX71J38N0CXUR"
    "RGwt88cPXL3I5grxAAfe4MhXjB2qEgekKe2UrEOHqGxYUCa4/H25jkKGJ5h4i/ojPP8es98w"
    "f4Yko5OQ5rQJ73Z8zxRvfsfLn/H4Udau8stHLP5akk+eYHSCJKGdkWaVgq57HY4HGHmyxIFp"
    "Ln7uwrVU68YVG0mv3vht9cnjXjt3TFgpKEsIcPsSp9+lcZAnphkYcWH4hLW03zNjg6K4pnWn"
    "Y3U9cX7/hw63f6Zzt4SQImS7xeJZzn7M9XNubvR6bLTfahJYXstlQc2+xpBW/Sk6+f0lBNQK"
    "Dn1APMjieWa/tVH/VE9PLEsy3YIkK/RFNVkRke0kgLBg5CBjU2XDiozLp/U3Yp00l+Zk3aI8"
    "Ctja3CQrqhJ23nd7hXSrDFcWSBL7tuesb+eGdkX6+yIP9MeWb6eK/+Ysrd8hI9KpGOX89D5x"
    "ncVLJJmn//za/NpRC3tf0S1Y32xL//3biyMtS2s90npdULzjC68faWpMlVOWp+Un2UGn8llO"
    "zvW1dbd29XlofMLcb6eyoHjJbo+asVdTtxrVNjoV2tVe556/9uCQhRdezbpFN/oflQkMAcdI"
    "A5QAAAAASUVORK5CYII=")
index.append('feed_magnify')
catalog['feed_magnify'] = feed_magnify

#----------------------------------------------------------------------
female = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgxJ"
    "REFUOI2FUTtvE0EYnPVdfHYeKA0ClBQIKcqPCP8hDR2uKB2gp8CyaFLRBiFBx6NAQkpBRYcU"
    "iTyIo9giiR0LP5KAlXBn+3LnPZ93h8KxZDtxGGml/T59MzvzrcAQSIryx8JDa9JajMTNBWpC"
    "eeGadILVe4/m3wshOMwZIFc/FdPO9hlbVY9BTTL4I+kdNvn3W43F13tpkmKkQOlDPuFsnzGo"
    "SbbtgO2zgO3T7pHHPmtfjri/nEn0cyL9hTVpLcZuxiEMgdBuo5Gx4Xw/hTzxIUyB2J1xGMpY"
    "7OeY/YWwjIVI1AAIeEUX51XnLiTQqYcl69ZtjE1HoQO9MFJABxq4WBGlAiSAFqDHOhdNgFIP"
    "xB6I0PE6a2EjALVGbHYC0Yl4aWwqWhqfvwFqQp74UB29NtJBaLdW/fL5g6nYNGIzccRm4qDu"
    "WlK+gpurQ6lw9dL2eyApCi+z6d+fK3Rzdcpjn/LIp7vjsPIqz+yT9TRxzTf2RPIvdhOF59lf"
    "3kGTrZLH/aUf7u7jjcRV5MhwYy+VeUvJlG6pkIqgIrSiNrVI5Z6uL1/7OgAcPNtpu7k6z382"
    "KCs+W2WPftFlM2Mzu7SRH543hxtKqm4UzYEFQgBXhb8soDvvyiuF+waB2eTcHAAcrRQKSgA0"
    "dOW/EXrIJTfzjYzNZsZmLrl5yfpIBz1oQ32tvjns3k1ujZr7B+okSSnzRZWNAAAAAElFTkSu"
    "QmCC")
index.append('female')
catalog['female'] = female

#----------------------------------------------------------------------
film = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjFJ"
    "REFUOI2lkj1oU2EUht/c9t7kJrUZmjZFWmposFVpAv5AtzqpIFiMQ0AQRMWhWwYHJ0cnOwXE"
    "H1TQpTgVh1DcdClYsBWRWmozOdSW0lgTyHnPudfFuOQ6+U2Hc8738J3vOcB/nlgnqFQqn4Mg"
    "GDOzH9VqdTyquVQqfRGRcTPbqtVqxwCgt1MMgiBvZi/N7Fa5XA6jAK1WC6o6T/JCJ/cXYGZx"
    "MyuRZObGvPpOHG0LIQFwe7CK0RRwrbLcS3KG5PHOPacTkPxE8qGZbXzwHvvNZMPvSWZ8+Bm/"
    "jqKfTm77IrLZbrdfiMha1wtUtV9VZ1RV0+4q3jdXcLrnARybwNLeZaztT0HkuopIWVXTUQCq"
    "al1Vp7Jx4MxAH/ZlDr9aBew1zmHjYBAiEpCsq2o2CiB/iifOZ8fhxZJQ5NBM7wCHXyGIEU9F"
    "oKp1kie7ACLST3J2eHi4uHTne4QDBySPisgsyf4uAMmfJBfr9bpO3Fs85Ttx0AAJgZuZRxjp"
    "i2F6ZmVdVd+QvNJlQUQ8EcmJSM9y+z5+2hYCA0jg28EQ+vUjSDokc6rqRY3gqmpORGL/skAu"
    "OiRzZuZG7UGD5AJJNxsHLo32IZmZgx6qYCes4d3BPlTVVdUFVW1E/UFRRK6SPHJ2YCz0Yj6Y"
    "GEEztQMMPUcAYlVk1MymzawYNQJJPvE879nbu9tdBoA4UqlUand393UYhhe7JBUKhfXJyUnJ"
    "5/MrEQ4BAIlE4qvruqHjOJud3G+WuW39/MXaIgAAAABJRU5ErkJggg==")
index.append('film')
catalog['film'] = film

#----------------------------------------------------------------------
film_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApNJ"
    "REFUOI2lk0tIVGEUx//3jjPjHU0Jp5wie2ikFs5E2QMJjMRqVeRGCIJetDCKhggKgjYtisiV"
    "FT2ooDa1iwKxVpFEVIvUioqhCUPLFF81Q/f8z3dvixqxnF3f6vCd8/04nN/5gP88Vi5IJpOv"
    "Pc9bZIz51tHRUZWvuKWl5a2IVBljPnZ2dtYCQEEu6XneUmPMLWPM/tbWVj8fIJvNQlXbSW7N"
    "3U0BjDFhY0wLSUb3tqtjh+EaH+IBB+Z0oKII2JV8VkCykeTy3Ds7F5DsJXnJGPPhReiKk4lM"
    "OIFI1IETddJIOKWRIUdEUq7r3hSRnhkdqGqJqjaqqpYGX+FJ5iXqA+dhm2p0je5Az3gdRHar"
    "iLSqamk+AFU1rap15WFgTVkxxqUNP7JxjE5sxofvcyAiHsm0qpbnA8if5Iot5VUIWREoliBT"
    "OgzMvw3PIq6JQFXTJFfNAIhICcntsVgs0XVsII8DGySXich2kiUzACQnSd5Lp9NafereascO"
    "gwYQH9gXvYxPA/0o6/XC6ktibHzMq3FLTnad7TsdyAEqKyuPkMyQjKU3fI6V2QsRMLPhKjDW"
    "/wAD2QE0rmuwmtZshXFGrZFs/6aipYFZUxpFJEhyieu61m8LhzHO9yCBvtQLrKxJwNgGiXnN"
    "MBaxvq4BgH9w+h5MkLxDMlgeBrZVFCMSbYPOSmJs8guCVjG21R4CABxtuoKquXFYsAqnzyAh"
    "IjtJLt5YtsgPWQ5YuACZomHczYxYbwafomewG8ebb+DMwz0oDIThw/853QJJXg2FQtcfnRj6"
    "a/6RyHw8632KhvgG3O+7iJBVgO5XjwFYF6Z+Yzwefycilaram0ql6v+VuLYtdsZXHLODlu2J"
    "71lBnHt+8evxX5Qkdg4IU4MqAAAAAElFTkSuQmCC")
index.append('film_add')
catalog['film_add'] = film_add

#----------------------------------------------------------------------
film_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAodJ"
    "REFUOI2lk0tIVGEUx/937jjjHWOsHHGKzFclPVQoaxVYm7I2kYRDRRAVQS7CCQJbFS2iTa2k"
    "6EEYtWkVBSGWUODCsBYlEmbWBNLDDJ/NyD3/893bokZMZ9e3OpzznR/nOz8+4D+PlQ2SyeSA"
    "53llxpgf7e3tVbkuNzU1vRORKmPMp87OzvUAEMwWPc9bY4y5Z4w5kUgk/FyATCYDVb1KsjGb"
    "mwMYY8LGmCaSjB27qk4gDNf4EA84WdyO0gLgSPJlkGQDyQ3ZvkA2INlP8roxZuhV6KaTjkw5"
    "diTmwIk5KdQ5hZFRR0SGXdftEJG3iyZQ1aiqNqiqFua9QU/6NertKwiYanSN78fbyRqIHFUR"
    "SahqYS4AVTWlqjUlYWBr0RJMSgt+ZWoxPrULQzPFEBGPZEpVS3IB5G9x4+6SKoSsCBQVSBeO"
    "ASvvw7OI2yJQ1RTJzYsAIhIluS8ej9d1nf2Sw0EAJNeJyD6S0UUAktMkH6VSKa0+/2iLEwiD"
    "BhAfOB67gUhfLwanvtoR+VU34VuMrg20NXZ7l+0soLKyspVkmmQ8tX0kXhRYDdssg6vAqr4O"
    "RD4MYFvzKXvt4VZUlMbsdHp6Z3N0fGJOo4jkkaxwXdf6Y+E0JvkeJDD7/CnWNBxA/scXsO4e"
    "ROTTQ5SXxWwDPzn/CVOq+oDkqYUWouOfkR+vAPaemdtI8MIK2L5VPh9QJyKHSJbvKCrzQ5YD"
    "5q9CumAMbixsZd48QcHjFriz35EBMDNtw9j4Ot8CSd4KhUJ3np0b/Wf/tDZheW8PyoocBO08"
    "zIwpPn+3jO971+Z+Y21t7aCIVKpq//DwcP1CiT2J0raRb98uFgeR91N9XRryz+/p9i79Bov/"
    "eORaAsmXAAAAAElFTkSuQmCC")
index.append('film_delete')
catalog['film_delete'] = film_delete

#----------------------------------------------------------------------
film_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwZJ"
    "REFUOI1tkktoVHcUxr87M/dO7mSSSZoxGYUYpxMIiSZBfIEPdFEfaIgYxEgl2NriotDClLbQ"
    "VRdd9AFmoQFRsxBa0KxsRAiDD/BJIArRVI2p5kYl0ck040ySO5l7zvnfcVEqbZyzPB/8OJzv"
    "p8Xj8T9d161TSk339PTEUGQ6OjoeEVFMKTU+MDDQ+N/M57puvVLqN6XU552dnYVigFwuBxHp"
    "ZuZdizOfUsqvlOpgZg4f6RbT44ejCiAXOLqkB7WlQFd80MfMW5m5aTHAw8wPmPmkUmpsyDht"
    "2oGs6Q2ETZhh00KrGQokTSJ66jjOWSK6/94FIlIuIltFREL6MG7ad7HWewwe1YBEeh/uZ5pB"
    "9IkQUaeIhIoBWEQsEWmu8QPrqoLI0BeYz7Ugnd2BsbklICKXma1Nq1Ts3DcHC95gM+y/rwP5"
    "ycM+ESFmtkRk5c6aGAwtAEEUdigFLPsdrsboJcKh7QulXbv3LTXDWxCKrkbGasDjRO+vPiIq"
    "Z+a9kUikNfHtZJEOPNjYtNB4uOtAS8UH65F+9hiGRigrjyBYtTzkY+ZZZu63LEsafuhfY3r8"
    "YAVQAfgsfArLChPwSr1RGdsF59V5GAENz4dHQQvOTN6Z3+ghIoOIokTkHXR+wqwah6sAZiCV"
    "SkMXDZX1bchPnYGmv4EeLEOJ/TTp2smPNnz5x5iHiHRmjjqOo/3TwlfI8BNEkhfRXJJFqL4d"
    "+cmT8OgMml2B6WuDc/lcrm11/PLwvx5kmbmPmfUaP9BeG0SMu7C/4gaqV+4Bve6F1yjAma3D"
    "y6t3XGa7pfHrobvvamTmViL6mJlXbKuqK3hHprBe366JVo1XIydQWW0gn67Fi6u38ge6H5T8"
    "NZmd+N+LiYiZ+YxhGIHL3ye10tE3WtPmo/C/vIWx/tsYTqRx81wCv1ywvpuYzmXeE4mIxono"
    "lG3b9/r6+tauKmtienjJF23dgmxqBs+HRuZ/vDI3MzqVO66UerYYoC1e7N9csbAmVuNb1/gh"
    "Crpzx0mlPm37eWS8iCAAgLcLMrN1Hf2rhgAAAABJRU5ErkJggg==")
index.append('film_edit')
catalog['film_edit'] = film_edit

#----------------------------------------------------------------------
film_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtJJ"
    "REFUOI1t01tIlEEYBuD333V3/f/c1XJt7aSZ1ZblqmkE3XSgrIsoMsoOBGFRURAtEdRFRHQR"
    "BQWBFNVNdIKggqKQ6K68sKwoO1CbtEIWWWpquvp/3zczXXQSdWAuhhceZni/seLx+Gutdb5S"
    "6lttbW0hRlhVVVVviahQKfWxrq5u5uAsTWs9VSl1WSm1rbq62owEpFIpiMgpZl4+NEtTSgWU"
    "UlXMzOGaU2J7AnCVAWlge04tJo0CNscb0ph5ATMXDQU8zNzEzGeVUolG/3m7z+m2vU7Yhh22"
    "kyixM502m4iaXde9SEQvh91AREIiskBEJNP3Ao/6nqLCexIeFcX9ztV42VUMoi1CRNUikjkS"
    "wCKSFJHiSACYm52BLtqF3lQMnd2VSPzMARFpZk6KSGQkgP6Es5ZFCuG3HAgK0Jf5HRh/Bdpi"
    "JMtGZa1bOnbx3hOve4cBRBRi5lW5ubkl9/d/HtZAwOdBTeWYvGmla621i9t+NjQOAZi5h5lv"
    "J5NJiR6+XW57AmAFkAG2hs8h3NeCdGe2FRpXhoUlIefVzRVzi9fc/cd4iMhPRAVE5G1wj6FH"
    "fYRWADPQ+iOA1OcPCIazoHruoGDeTq9x1aGn58p9gwEfMxe4rmv9bmEPuvg9hA3oayeyoxuA"
    "ged4cukqMrL6If20wkJw5eA56Gbm68zsiwSAlZMy4IR3YWLaDswJdSI4OgXtJgGjoXobMWXR"
    "PksRHa0/Pj/4FyhxXXcjEU1emJ1vZqRPNhUZpWZJxydk5ZVCp5pgdD/K10Sh6QvS0xOIxNbP"
    "BAbif5/AzHzB7/c7Dw62WfcOtFjfz3yw8iKVcILtMNIBWF48u5UAoKEHEsiZng9FtPvh4aIi"
    "KxaLvSOiKSLS1NzcXAEAj0/Pay3edG2C19MCIz8ADP5jHnjtKNrevMD7O0duWMOKB1B/oqzd"
    "iHaMNjBa/97G4P/ZAFoD2jz7BU6hpg46SHrFAAAAAElFTkSuQmCC")
index.append('film_error')
catalog['film_error'] = film_error

#----------------------------------------------------------------------
film_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtRJ"
    "REFUOI1tkUtoVHcYxc+dmdzJnUycks6Ywag1M7VW0zyqIwpiIgZjt01JAoK0iCgp3QRRKBRX"
    "ioWiq4GiiAi6UVe6iRYFxdSmNoqaIiZNejVRq4Y8Jpnn9/jfbqyUOGf5/eDH4TtWX1/fn8aY"
    "j1T1TTqdTqJMOjs7HxNRUlX/7u/vX/t/FjDGfKyq51R1b09Pj1dOkM/nISInmPmLxSygqkFV"
    "7WRmju45IY4viJJ6IAPsi6WxogrY3TcYYOY2Zl63WOBj5kfM/LOqjv5hn3JyoYzjD0UdOFHH"
    "RbMTCb12iGisVCqdJaKH7zUQkSUi0iYiEql4gNu5IaT8x+HTNbg28yUezjWC6Bshoh4RiZQT"
    "sIi4ItJYGwQ2fhjGHH2LbL4JM5kOjC7EQESGmV0RqS0noLewYWdtErYVgqAeucgUsOw8jMU4"
    "TQQRcZl5/WKB1dXVNcHMM/F4vHl2drbcCBgeHi60HgwHFeybqwqGLnUPFt41YOZ5Zr7suq58"
    "evjKBsdvgxRgA3THrqIu7MeOtt4nJWN/tmrpOt/8i/v5ruPLQ5cOPC8AQICIbGauFxH/3dxJ"
    "tDhfIegtg2+yFRefMtgTbP0+/HldzWqsjW/CQjGHB4XBbFs6Frn13VQ2QEQVIlJPRFZ1YBy/"
    "zfyE5qoDCBvCjoavoZ6BGoWBh5eZSTQu34IsFXz3Jm5lNvyImgAzZ0TkAjP3RoM2Wmo+wGzx"
    "FIpCUM/g2fRfYCMQw2BlzJcW0LJiK7Kc9/3uDkwHmLmZiHYx86rWWJ1XgWqw48dtKVqigtol"
    "KyFGoZ7BP5kJ1ITjuD/5KwbGB6ZI0WGlUili5v22bZ9JJBLvPk/b7qJIBDKEohCS0QZsTnRg"
    "aOIOro/88ooU7a+O4bHV1NT0hIgSIvJobGwsVW7GysrKkcSh0icbk9txc/TGC7bQ/vIIRgDA"
    "Kjt8mdT/gJx6/lAJmnh9FO5/938B5iav0GsqKwUAAAAASUVORK5CYII=")
index.append('film_go')
catalog['film_go'] = film_go

#----------------------------------------------------------------------
film_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAt1J"
    "REFUOI11kktIVHEUxr975zp2x5rbY0oRI0VrRiMNMmpRGBE96AENiGAE0UPoATUtggpqV4vI"
    "lWBvilpUINFqekgbg4ykUnvo9BgrsszJmdFm8p5z/ve2iQibzvY7/Dic36dFIpEXjuPMUUp9"
    "a2lpKUeOCYfDr4ioXCn1PhqNVv6dGY7jVCilriqldjY0NLi5ANlsFiLSzMxrJ2aGUipfKRVm"
    "Zg5sbxZTz4etXJADNM1swewCYGuk02DmOmaumgjQmbmHmVuVUrEn3nNmxpc2Pb6ACTNgxlFj"
    "Wr4hk4je2rZ9mYi6/7lARPwiUiciYuU9R0emC7We09BVEHdHNqM7tQBE24SIGkTEygVgEYmL"
    "yILCfGDxjMlI0R78yFZjJL0asbGZICKHmeMiUpgLQL/D+WsKy+HVfBCUIWMNA8XX4GiMC0Rw"
    "HBnYsVxbt/nY6ic0/PnMvL0vLwKAVl9f/5GZR4qKimqSyWQuCejt7f0ZXijJA/vXFVtVjUg8"
    "ah4Z7OrasujIuzsGM48y8+14PC7B47cXmXo+WAHkAjsCZ1EyWcOpg92JfbuWlFjBWmQ+RJE3"
    "JTjdmm23Rfe5O3Ui8hJRGRF5Ou2TGFXv4SiAGXg3Ngt+eYbaUIF/Ws0GTWXfYFKgGIYPKK5b"
    "6CubX9JqEFGeiJQRkfY/CwWfNxEnB6B7EtD0DLz+BDCexY8vtsdg5rSI3GDm3RMt+L5VYSV1"
    "wr+ydKojL6E7KUCfApcJfdf7x1/H0k0GM9cQUSMzl66YMcf1aiZ4Ugms0RjK7WdacGkjXLqX"
    "p6mveHorCd/44JBH09AXT+3dev1jm0FEzMznvV7vpfuHh/58/sAqB5Xrt4MSrTAMCy/ax+yj"
    "F96oSMgzNxAAtlz5PgYAqK6u7guFQlRRUdH1t7pPbWsf20Mn3Ez/Rrfj9FK1LDjV1XX97T9F"
    "6unpCeVyPzgw3D6aflCaSWZ/fooNH3rYn7qZa+8Xt8euVdBzLUwAAAAASUVORK5CYII=")
index.append('film_key')
catalog['film_key'] = film_key

#----------------------------------------------------------------------
film_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvZJ"
    "REFUOI1t0UtoXHUYBfBzH3OvdyaZyeiN86Bm2sS0tGUm+Ci4UC4UWnVVJhUmVlrER4klC1Mo"
    "rsRlycJiQlB8IIJu3BiKQmgRIWih0II2FCkzxUlS79V0Yto0c8fM933/O25clGTO9sCPA0eb"
    "nJy8GUVRQSl1d3Z2dghdMjo6+jsRDSml/pifn9//cGdGUfSkUuprpdRblUql0w1otVoQkQvM"
    "/NL2zlRK2UqpUWZm940L4ug22qoDioDT/bN4IgGcnLxqMrPHzAe2AzozLzLzJ0qp6jXrMyeM"
    "bzhG3HXguE4dI04qvuoQ0e12u/0VEd3YsUBEkiLiiYikYr/h5/A6njU+hK724dJ6GTfuF0H0"
    "uhBRRURS3QAWkbqIFDM2cOixHtynM2i2SljfOIrqZj+IKGLmuohkugH0f3nwxcwQLC0OwR6E"
    "qQaQ/waRxviCCCJSZ+andwBElGTmY9lsduTSOb/LBzqYeS8RHWPm5A6AmR8w88V6vS77Prj4"
    "jKPbYAVQB3jT/RS7ejQ8512/JSLfM/PxbgssZt4jIsbV9nk8hQqsmo/MvUX82p/Gj3dvI5VK"
    "9Wxubh4ol8t7S6VSJwiCe0EQnK/Vah8bhULhrIgYRGT3HnmQ/euny3g+lsSp115FPp9Hb+px"
    "iEhvLpcrjI+PO8PDw5rrug4RHVlaWoqZzLwhIt8y8zvx2hZKfBAvHD6Msx+9h42b/yCfy6FY"
    "LFqmaVozMzPwfV8lk8nLExMTLy8vL582mXmEiE4w827XfwR9PWkAwKFTUeeHd5va2NgY0uk0"
    "ms0mGo0Gpqen/9V1/RUAYV9fn20SETPz55ZlfXnnyhaM3X8CAH55v6VFrGFqagqJRAIAEIYh"
    "DMOwY7HYHAD4vr+llUqlW0Q0KCKLtm2fHBwc/M7zvOzAwEBkmuajq6urqFarsG0bhUIBmUwG"
    "IrK+srKiLyws/K1te8XwPK+YSCTm8vl8v23bRqfT0dfW1t7WNM13XXcOQKzdbqsgCBphGJb/"
    "A+taora2TLgoAAAAAElFTkSuQmCC")
index.append('film_link')
catalog['film_link'] = film_link

#----------------------------------------------------------------------
film_save = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAspJ"
    "REFUOI1tk01oXGUUhp/vzp07c6cxiXTqBNrYhojxhzoQ2yhuKgr+QLEYkIA/IKKWdlOycOFC"
    "XCi4scVFQFQo/ixklgUh1C5URIlYgxURKZKRqoUkGJOJM8k953zf50Ittc7ZPvDw8r4cNzs7"
    "+30IYa/3fmVubm6cPjc9Pf2DiIx775fm5+dvvZqlIYSbvPcfeO+fnZmZif0EvV4PMzulqg9d"
    "y1LvfcV7P62qWn/mlOVJhcJHJMDzu+YY3QFPzS6kqnpIVW+7VpCo6neq+qb3/uLX2dt5t7aR"
    "l2r1nLyet2nmQ7XlXER+KoriXRG58L8EZjZoZofMzIbK3/J59zwHSidJ/ARn1x7lwvp+RJ42"
    "EZkxs6F+AjWztpntb1Tg4M4B1uU4f/buYG3jAS5u7kJEgqq2zazRTyD/wNsfbIyTuRrGGItf"
    "PsloBXpiXH/iveblla2mS+DhWimG6Pijs8Uni5fvSkVkUFWPjIyMNM++8NsV8+DUNvdNTXBk"
    "coCPFn7lpSf+sx7vf7pKCO6rVFU7qnqm3W7bxMtn7syTCuph+bMF1jYNgHPnlzl89x4Atg3E"
    "w+q64FwgEZFMRMZEpLRQvEbHLxE8JImjFEF94OSxSUKI+BApEailgaIo6HSFVETKZjYmIu7q"
    "FarlhO1CebX1M4kD84HgAxGIMUKEWjmQqOqGqrZUtdyowCOjA9Tqx7EQKbxRSso4l+Io4VwJ"
    "YkKMDjVDxEhVtSkij6vqvnt37o2Zy9HqHuZ76sou5djh67AgQAIRogtU04zXP7zE750uqYio"
    "qr6TZdnpcy8uX2nZ3xIpUSawxenFo9RrN+JIWO39wnMH3yChSq/4u4MlEXmr2+1+02q1Dvwr"
    "eOyVE3HfCDQGNrm/OcVwthsSWN/ezQ07jFoGqXO4ft8HMHn04y9uHs3vGa4MU00HsaC4EHDR"
    "E1yPHy8tsdJR/gIAP6Jg4l1lcgAAAABJRU5ErkJggg==")
index.append('film_save')
catalog['film_save'] = film_save

#----------------------------------------------------------------------
find = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAltJ"
    "REFUOI3FUk9IU3Ec/7w/e5tvuixKmNbCuXTEBimDGJV0qIueCiIJT1mH6OChbh6UoK4dugQF"
    "Fl2MoHOhIKlgohOVElMzF2tqmW9v23t7v397HUpF6e7n9OXD9/vhw/fzAQ4a0n7iweNn38P1"
    "9SfS6TR6urukJy/eunnTwMzU+NKbV88b9+/L+wmrUIDu82Jm6iMA4PPcNCp0P+ItZ/X/OVC3"
    "h5t377vR2BkU8iYWFpfxbfkLAGDh0wxkWYameesSyVZX82gDuc3s7fn5eRtAWenvH/aFY02X"
    "gnWhTtctI7f1G6mJMWiahrYrHX1enw+WW4lgqAHHT4Zhbv2MzU5PWYzRUQCQenuH1WP1xtdA"
    "oDI0OfHXdqA2imBNNYjgrFigHm4bWFnNgNtbaGyM4FFPd1pw3gBAqLW1i9KmqYZkRUG5LCCE"
    "wMZyCqtzFibHRzzhU1FEmk6jysPBdQ3plSUIzkP//ifUVCqFNcOmv9az2pGjNdhY+wGnZMM0"
    "jSyxCu2zeePh9MRYm677YVlFOCUbkiTlXNcVOzG2X70xeu7i5fOJ5jhyZhHpTBYDL5++To2P"
    "dESisYFrnbeuJxItELyMzNo6+u7dGcvnjQs7KVDiJDeyGaA5jqGh9yCOA0pJHAA4IfGSbQEA"
    "BgffQZYVUEaSe3rAOVO2Cdd14avQQR0nAkAqkVKw6lD1bvMkCYJzZY8ApQSSLKNolaAoKlRV"
    "heb1aofD4YDu92cBwLIdKIoKRVHAOdsVBIBEstXljIExCkoJOGOghMCxC3WUlz9wRiNCcAgh"
    "IDjfc3vw+AP3HR74kwWfiwAAAABJRU5ErkJggg==")
index.append('find')
catalog['find'] = find

#----------------------------------------------------------------------
flag_blue = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkFJ"
    "REFUOI2lkstLVHEcxT/3d+88rledSZ2xGjUqI5CyJHIh2CpcSRHSE4ISXLkOso0ESUlRG2v+"
    "gKAkBanEIjchSIgIYYigiD1Mx8fMqDOjzsP7bSGKRS6sszwHPhwOB/5T2k5BVWPr/oR5ILjq"
    "KTopaVucidDI9aXWkMTn6kG6RZPgnZc/e3YkWw9D9oV3KRmctaVzwpaKjoyUt41KejUqvfcq"
    "5f6VorcABs3NyuW81Wnb1IrSHCgQBQ9qXJwt0fG6QOnw7IxOcnCAmf5pZiNrAF0ARvlEtjl+"
    "Qve11bodhoKMQLEFXidMxiBgw3AYVjKgPjyltO4a8+EYCu39RgOPJ6BbmgfgzTcQoCIfSnLg"
    "SC7E02ALjM0tpqotnKuRSdaSGZraf0wDqISxtywrS3mVAl2By9hY1qnA1GE5DesCh5lZLcjP"
    "wXB7fttKJczA6dsVuudrDNwKXNoGyKFBnnsDFLBgPTTq8fsLCI0PICIjmwAjllV83HIoq28W"
    "kjacKoDSXPCb8PF7xu6eXEmmcDluWLbBIswuxAGta6sBZk5h2ha97iBcPQSVPuHRUIraFwvS"
    "0fflc1WRVZ+XCj9vaWzEzqwzt7CEJtK71aBkunv4bnvZsYTpNxEbt0TTvujwUPzxpaoeoAdo"
    "uVwyX33Of1MZOuHIMk2vpvq2AKNPLjYADZvGChD541QKqfH5vH89nNrxitskGuf3Fe75d4AG"
    "R7Mtk9BcFJDuXQM2FYnG0ETr3zVAkODrnk+MTUwFsR3B7dkvdzbgRU++X48AAAAASUVORK5C"
    "YII=")
index.append('flag_blue')
catalog['flag_blue'] = flag_blue

#----------------------------------------------------------------------
flag_green = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI2lkk1I03EYxz+/3/+/7f93c/Nlm+nEt6xUSAUZgSgoCYpQHSKK6miX6NghKxAhii7d"
    "Yvc6KEGIJNIL4kFENMKCvFRL0fk2bWrONue2X5e0giSs7/XzPB8eHr7wnxH7gbYbV/yGXH2h"
    "5cSccbtGct2+0RQMThINnwQ1oIQK3OyZH9T2E1R3aPMVVT7zcts1WVteKWXhivk2ESt70D1E"
    "Ith/dDEcdQ29/9qj09UlWw1jylL0tAKR+nGSoqXwFLWVzViklRQJGrztNJXUsTgaYDkSB+gD"
    "0KuDDlOveVNwveU+yfQOoLDpGViEhaXYLE5LDguxGRIpJ9svH1J+9iIrXzaRiOcAOi6Xz2as"
    "mcuxEJNrIwAUmCVkW3NxG/lsp+MoFPHNRbx2iEWmiW8n6eydWwCQxWak3bCmNSkEEomODoAU"
    "Opqwsp36RlqlcCRcuHMz0Q3Xb7+SEduhmjP1l+R6IoImdKTUkUIihUamxYWpOfAaPiKz63i9"
    "bpY+jqOUmtoV6FFTHLdlmXxaGSGlkhSYpfgySsnQMwlFPzMxP8qOcKkGwy+IjbO8GgVE357A"
    "njVVtLVzhLqcJgBsmsFEeJh3C6/Ji/rj/trTj6dDyYq7VzsaH3U3El7dQCj1aq9IzXcuBPXi"
    "UJl0xUABUQvJGc/W0K1njt2he+eLznnczif1J6roHxyjs3dur4D68O3ew/uV6WfSDR5P1h+J"
    "/PsyKCFa8/Oy/10g4JjDbrIUXgPUwIEFu4msbSKUGD2wQKEC/YNjfAiGAqQtgV/ZdwB70X9C"
    "8C3xAAAAAElFTkSuQmCC")
index.append('flag_green')
catalog['flag_green'] = flag_green

#----------------------------------------------------------------------
flag_orange = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj9J"
    "REFUOI2l0ktIVAEUxvH/fc3Dq46pM5ajtmgiMBMlcuGiTY+VGCE9dw24aR+oGwmKClpVNKso"
    "alGUINU0RG5EkIgIQpMhxZSymvExU87TedzTQrSEXFjf9nB+HD4O/GeUzQbX/O21Ox2pQJ0z"
    "02JpIpG0beJT1hGR5LwfJCiKBPoefg1tKkf6TCt3/7hYc2/F+jAghZutEu5vlnwmLkOX2uTK"
    "6brnAHp/P+qFEvsAYnUoiEERsAT7oatovsPgqABUtM7bRMc/Yo4GiMayAIMAeul0s1NrnHI7"
    "jtwyUHUoFqCifnUxPgPlXoiOQT5N+NU9fF1nWVhKoKK8BNBdDrxKTnMBEH4GIlDbCq4GqN4N"
    "uSSIxY/Pkzm3iS0TmyG7UqD30ZdvAOp2M9WoGiUVoIKigWYHRQHNBoYTsstgFflu25WpripD"
    "d7g2dKV6zdQB7WCPi/gsGA4w7KuQboCzchUq95JWTZfHU01k6g0iMrEG6PWliX2q3TSZHYH8"
    "Cnj3Q5UPTA+F6WErPR5csSs5Q7c16QDRxSSgDK5fUKZTI8W8xt4uaDmD1LWRG7nO4t0OGR9+"
    "8t70tfuX1MoH/p47WIUi84s/UUSG1i8IzjWMNb642OQxUk5LIJ525McS7ncnA8l2CAEhLp9q"
    "WDjf6Tmn6hpLsWV6H8+NrAMnboS7ge7ftaSB2MaikKNud8VfH07d9BX/iCgc21Gz7d8BBfaU"
    "mk4i83FAglsG1hKLJ1BEGd0yIEjgaeg1k9NzASwj8OfsF1af3QqjhoJMAAAAAElFTkSuQmCC")
index.append('flag_orange')
catalog['flag_orange'] = flag_orange

#----------------------------------------------------------------------
flag_pink = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI2lkk9I03EYxj/f3z83t7G5nKZToZKUskjCDh06iAhB2cFDf25JEnjqqh28FJ46Razo"
    "2CGpQCqRQCjIrCQDM1QoIy0T3dzmdDrn5u/tYIpCHqwH3tMDH5734YH/lNrJuF3dXnwwXBLa"
    "lwgeE0nLtCsyMtBwb0aS4SaQblESanv4q2dHcoI+W05PirxdEumMi1SNy7z/g2RScem9cUI6"
    "LpQ8BzDaadeuc+rJGvYZ0EzQEBTOWxVQ7wGfAboGoSKGEm/Y39/LbGwFoAvAOHDU7dSHHQHz"
    "bqWJoSALlBrg1WEiA8XA5xQs24yN36G88RKR6CIa6gWA4Z5TQU13eQF4lgQBqnOgzIJyC5I2"
    "2AKDmdVAECsV+85KOktr589pAKNwwXcIj+VDU6D/OSVgKXAqiGRhDSYrY6l8y2MZDu+2rrTS"
    "pL+GtnwvExlwADms/2wCfmMdFDQZ0se9BQX5zHwdQERGNgCGH88R3JqLvmVICxx3rEcPGPAy"
    "YfN4KQ1i7s1TBmdhdi4JqK7NBC7lKGQVnUYPXPRAjRM6wizXfZIf98eGqMttShurD1reX8HO"
    "rhGeS6BEejcTvPKPDh++Nl+VS67TxiaFZEb3TH6spfkkg8Ag3DxfFmlpKLisGTrR2AKtj6Ze"
    "bwJqo1ebgeZtzUS3j0pD6gMB318Hp+04xS0Sxbmiwrx/ByiocLuczITjgHTvGrChWHwRJap/"
    "1wBBQk973vHl21QI2wxt9X4DSNjRL/0OS8MAAAAASUVORK5CYII=")
index.append('flag_pink')
catalog['flag_pink'] = flag_pink

#----------------------------------------------------------------------
flag_purple = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjtJ"
    "REFUOI2lkktIlGEUhp/vv8z4O+PcnFEnJ110MS2hjd0WuQgKQpBwEbQQEhS6bAI31sJVixYt"
    "Y6CNQWIXAglkiBK0QCMoKSm7ilAzjo7OiM7Nccb/azEotTCy3s2B857z8HI48J8SWxk3Lg3s"
    "cKb9QWuu4mBNVSAwK5cLkdSZfpmKdYAckkIGr96LhLStALWfTocDh8pEQ7ugsCoofeCw6Om+"
    "jra+nYzePNXy+v0sQEjr7e1Vjjy/9siUsgUpdBMwJdRf0KhqEuh2yKehvgtyUxNEx4aYT6wC"
    "DAJo9uldxrpQfPu7VR0VzHWwVYBuh3QUDC9kYrCeg49Pb7G77RwL8SQK4gmAViLKq9dUnADR"
    "MZAS3HvAqAR7AArZYi8ZMfHZIJuYYTVXoOf+j1kAxSi4GtQS1SUFCAUUS/G0igaqBfIZwAS9"
    "Kou33IFW4vztVkpp2tdU144zM1dcUHVAKQIsjmK1uiCZj1PuPszc11dIKT9sADRb2t+oG9ji"
    "76CQB89esFeD1Q2xCdP8Pp7LiTVdN8scmsdbz/ziKCAGNxNoGJVyDbW6GWpPgGcffB4wGelO"
    "ycmRmbf+RksHzpW7l28fRShTxBaXEVI+20wQ8Y9Ppu7UHtAzHkNikrWk8iueb28uDjcfY7g4"
    "dP1szcKVVsd5rXSaeGKFnofhF5uArv7jnUDnn95VQZ70+VxbeH8hKWj1V7r/HSCgzm4zmIst"
    "AXJo24ANJZaSCCnGtg2QyODj0Eu+TIeDmHrwV+8nBHDPGPqq448AAAAASUVORK5CYII=")
index.append('flag_purple')
catalog['flag_purple'] = flag_purple

#----------------------------------------------------------------------
flag_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkVJ"
    "REFUOI2lkktIlAEUhb//MS9Hm3Fyxmx8QE5IoZJIhga1yFoZEWJZuBJctYkgqKDaFBa4rGZR"
    "i6hFkZJkooKbCDSkRWH4SCkLe8yMjzF1HOf13xaiKeTCOst74OOew4H/lLKZcbu6amdBJOLP"
    "jUf3GapIQDMPfS62BmQx1AjSKYr4rzz53rUpOZBvN+INJ8V491aMjjZJHiqTkcpSSUTD0nuj"
    "Qprrc18C6NdBvVhkacMwahQREykgJViu3kI7XA3bnICK1nKPYOgj9j4/wdllgHYAPf1oqU2b"
    "GHdbr90xoemQSEJuHjid8HUCcrwwPAjRJUYGH+KrPcvUzAIqSg+A7pjDqyQ0BwDdHSACpWXg"
    "zYfC3RBZBMNgbnQs7rZjjs5OsBxLcvnp5A8AdYcS2ata0pyggqqByQKKAmYz2GwwPw+pFD8L"
    "CqNZ2zPQrY4NXaneWGS/dv6Sg8kvYLOC1bICMpvA6VoB5XhJmMwOjyeLwPgAIjK0CtDz4gsl"
    "qs1up+81LMdgXzns8kGWh2T/K2OpuzNmScRNYUem7jkIwelFQGlf+yBDyJZkQuN4LdSdQcor"
    "iN9tYbqhRj48b31vr6xqnHG5Hl/o6sFIpghN/0IR6V3L0Hpgz/2hEndkypdmBH1pxqjPFXtW"
    "XtS/PufN0/lHHpwrluFHp6S5Pk/We3rdwEgT0PTntATMbiwKOeZ2O/86OHWTIW6QKJzIyc78"
    "d4ACRel2G4FQGJDOLQNWNRteQBGlb8sAQfwvut4w9umbH8PkX+/9Bnjf3vQJuD8BAAAAAElF"
    "TkSuQmCC")
index.append('flag_red')
catalog['flag_red'] = flag_red

#----------------------------------------------------------------------
flag_yellow = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkBJ"
    "REFUOI2l0stLVGEcxvHv+54zxzMzlg3jmOEoVF4WFUSg3YQWhRAtDFoY4aqF0J+gi9oUQas2"
    "MUhBuyyLJDQVbCEOUhGtVEKjErw049zQGZ2LM+fXSlHIhfVsH/gsHh74z6i9irf991rtzanB"
    "g6Xpg07JYb5wLrb85dt7yazcBhkSJaGevqXhPeWvT7REw6cklxiX9YWnsjhiyXivSzazKRm7"
    "3yIPbwYHAcze3l5X0BeO+iOvfdrJozQoBfVXerBrrqNNP2I6+M4OoCXG78kQ0WQOYADA9Pli"
    "VZaK2yeu3UVpC2QTw12PtvzkN6aw7AayaxNIKc3M6ATHbtwilkijUaMAJjjnPeaaCZBdeg6A"
    "y9eK6WnAqGiiVEwBDunVWQJeyCZ/kcsX6X65sAygcQptXiNhKGWCcqEMN6BQugylvZSKCRzy"
    "FHWLVPoPYNoVu7bSplq9UNfYoYrrsyjDA8pmCzOsarR2Y9mNZDJlqqqqksj3z4jIzBZgWhIN"
    "usxqlYt/AieHy3cJs/wkhh0kE3tDIvIKbSSQOQ+oZqLxDKAGtgGPjtsiOTzBLkQctBUgNd1F"
    "5GeeYl1H3qx99GxmZeN0xXznxeO1Z1iJr6JExraBdKE6PjXyuMYl64iAaIuU3Zy7eifshj6g"
    "jwcddZcLlY0fGo4aJJJrdPcvTmwD7Z0vgrsvlAPCu4dC2gKBQ389nN7zijsiivYjh33/Diho"
    "Kve6iaykABnaN7CVZCqNEjW5b0CQ0Lvhj8z9WAzhuEI7uz/p7OelYkBTlgAAAABJRU5ErkJg"
    "gg==")
index.append('flag_yellow')
catalog['flag_yellow'] = flag_yellow

#----------------------------------------------------------------------
folder = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAa1J"
    "REFUOI3Vkj9rFFEUxX93dnbdqBMiipigCFabtIJikSLoF/AT2PgVxEIQ63wBLQU7S7EUVLBX"
    "rCSFQoKQxODuzP6befPeOxaz7iZNSsHbvMd955x7zuXBf18G8O3tzS9L2caGWXLsSVSj73s2"
    "Le5YaFcnWBdgNz0/3tr66FMAi63etc2XbTMDNWTM8OXRjYPPz/ZkTReg1VlW9PXh6v77R8Dr"
    "FICgkujOVPvPCa4FyTJmGd21u6zd3u4gAREUAWF27srOm82ncwFzJIqO4DooijjdpR4fMDr8"
    "QLu7CqohOiQPeLLe444RrwM0DhK60U9xE5AbUw8Lst4DuhfXZ2v660CNg3QFBUsXAnVCunSZ"
    "lfWHc6CIRPcTP3iHQo58jnyBwoju1SdQNWtpBJykUBInXxtwGCI/INZ9FHLwg1m/QGEMqsCx"
    "EJBDip5Y/2omhRz5wezen00u5gKSh+qYAFWUEZD/PSMOFrZDjvxwQY5lE9NzIkK/nhyddcNO"
    "ZsoSqQ0xA11CoQIcSprTkoCfTqVa1SJCVW7/eHH/lsQ9zLJT/64A++QsxFen4v5Z/QFgBRmd"
    "QQ2DBwAAAABJRU5ErkJggg==")
index.append('folder')
catalog['folder'] = folder

#----------------------------------------------------------------------
folder_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAixJ"
    "REFUOI3VkstLVVEUh7997sMjecyKxCtKoAhXI00KK0lCzGnQXxBBIyUIQhKEaNBApKYWTWrc"
    "KMJJEZlgDppYliEJGUpyNe2+9D7O2XuvBse0GjltT9Zm77W+9VsP+O+PAliYOPW+0mtrU8r5"
    "40sob31dUcXcOWVi5b+iDsFytGq7t3dKRwGUjSQbe57ElFIgYTBKoUsbTWuzd1ZEha8AkXi1"
    "WB2sJ1KTQ8DTKABGSli/opx6gPEj4FSjlIdb30f9mbE4IoAFsYCg1IG6L897bu8ClI8j1sf4"
    "ccQKtrhMsL3G1vobYm4CJADrI6IBjZe8FVfYYwChAgfX6iJ+AcTfJsjn8JJXcI+07rTptwIJ"
    "FURrEKOie4DAIVpZS03rtV1HwWL97+jMK8RkEZ1FdA4xW7gNI1AO2xICfBExJWxhLnQ2eURn"
    "sEEaMVnQGV4vppn6ZsgWiwT6Bp2O2VMgPiJWY4MfYSaTRXRm557mxUKajyWPCz2naTjcwuT8"
    "M95+Wo12DSbuhYMvW1EYRP9E9CYSbIRWbyI6zcTnDCeTHRjH0JHox6iAsye6ARl0dkpIB4WN"
    "rJ+PW13w0OWjGL8Ba5qx5jjruU1iqopLrdcBuNn3iObadhTKDUsol8aWHl7uEuEiSnn/rmsu"
    "l3bnV2f4sDrNcP9jRl9exY1UIEhJ7WffuwYSdxubDo50t5+npa6TxdQsM3PTrCxl7+8LEELq"
    "RlFqQIEnkEdk/N14avgXQ10qhTEgEGMAAAAASUVORK5CYII=")
index.append('folder_add')
catalog['folder_add'] = folder_add

#----------------------------------------------------------------------
folder_bell = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApJJ"
    "REFUOI2dk0+IjGEYwH/vN9/MziyftXZQa1etPZBI/iQHQqk9+BdFHLhRCkW5OHBykYPaiwvJ"
    "yoFy0CpyUfa2q1CyrLVrZneYwezOfDsz3/vN976Pw/iTFPLU01NP/X49Tz0P/EdcPcmp3G2q"
    "d45zz/1X6MoxjnYuYmPCJdmdpsfPkiqXmPVX8PRm0k966devj4hkLoh9slaK11zp3cfNXUtp"
    "j/0JvnSIHQcPL76xauuZjXH1ASavQXGcRKuHntHJkdfc+m2F8+C4B9iyu4dLS9ZsXzGrc2+c"
    "XB86N4CeinAFkok6iRhevImEO9y/9lnKW75cKQeA0lRFRcXHsZXbd6ugMEE0cg5TLlPOR3zJ"
    "QHsHYOKMT5ItzFBzlY0t69x0Pa6UAoG5U3mG+0+gP43x8c0E75/nmdMS0d0BbXPBBOBX4MUb"
    "7mZayDsYCbAhevIy1fFeYv4DFq/qYfBRgXjKpbV9Hav3HuPVqEslgNY2yL6fkXc57j99St1V"
    "IY7YEBMmECvYWgY1PcbCdAfV0S+kMIz0DzHPW00dGPkITc2oWn1QAFwckjaqUflQQOdHsWGV"
    "WFML3fv7EGPIDQ9hpl/RutASBZrZXhuZh9fRgm4I6g5uagHzN5wFLIgg1icqD2CDMRakNTPx"
    "IoXsJCooUJmzEwAnSbYhCEXEBNjqC8SUEONjg3EQi9gAbI3mVECqqwkxbaS69jP68iYP3n6b"
    "QEJEbIStf0KiUkNiNUgEohFbRUwFG/mI8UGpX+7GRVtRGCQqItF0I03ppyzyEVNGTAWxAVZn"
    "EJHgpyCUqXr1c3PoJzwlniMSB+uBpBGjgRBxGlU5hqhWE6mL/iEQHVwcu7JnvQjbUMr742cJ"
    "oAZCZWzf99ZXrWZtz3fR84IAAAAASUVORK5CYII=")
index.append('folder_bell')
catalog['folder_bell'] = folder_bell

#----------------------------------------------------------------------
folder_brick = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnRJ"
    "REFUOI11ks1rE2EQh593d5MmbdeWkhSxJiIUkd5awQ9EEPHYi2f/BfFo0ZtHvYsePAge/AMq"
    "9NiLiqUoraWtRUqlkGhtmzTZZLO72XfGQ+onZGAYGJhn5jczhj62uLjo1Wq1Yq1WG52cnHzf"
    "bDZPAPi+39za2royPj5eHxsb2zf9AAsLC/fK5fKjKIoIw5BSqYSIUKlUGBoaIpfLsb29Pef0"
    "A7Tb7bujo6PMzMyQyWRYW1tjfX2dTCbD9PQ0IyMjHB4eznn9AGmaToRhyOrqKiLC7OwsAEtL"
    "SywvL9NutxkeHh7rC3Ach4mJCY6OjqhWq2xubiIitFotXNfF87xe/Pz6wkren5oy5m81ytKe"
    "+Q0qFouEYcjBwQGu6+K6LgDWWjwj7vnStRcZYwxorxhjWJmfZ2Njg1KphKoiIlhryWazqCr1"
    "ep1Go1HzsBohyUD8/Sk2ccE5gTE+N65f5ePKJu/evaVcPkOhUCCfzxMEAXvfK9oMwldpmt73"
    "TIKjkmCTLCqKdHbp7O8QfXjJyWqVkwAViIHCsZ8Fc+7O8m0AD4ecpB3a334Q720jSYg7MMLp"
    "2ecYDNKNwYCKYIzBHTzFlyeXfm/Lo+vg5ccpXn4ACKiiEpA23yDRDmiM2hC1bVRCcuWH/1zL"
    "I1FVGyHhJ9Q2UBsg0VdQQSUC6aDSQm0LtSGo/AvQBFVJke4+mjZ6EIlB01536XWXNEBtAMb8"
    "N0EsarBoWkPTo57bxh9YGqC2eSwhQuJdVDX6W0K9Gx4MJkHWN+o7qhkQH7SA2hhIUKcXjWNJ"
    "Ox3VrsZ/JMTR451nty6qchNj/H6vffygYN4kxsrLX6mfOll2h17qxIsAAAAASUVORK5CYII=")
index.append('folder_brick')
catalog['folder_brick'] = folder_brick

#----------------------------------------------------------------------
folder_bug = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs1J"
    "REFUOI2Nkl9olXUYxz+/d+/+vLMzEf/QwbawIc05N2XaWW2lYmSaqUPYhV54KQpCVnrhjUJB"
    "0NUulLwwKkZEXkhmUGisTC+cWeqcMKdu083jdnZ2jtvr+/e87+/p4jBW4KAHHh54/nyf75fn"
    "gf9h6y+8fmr9z28MADR0N8qmb9YtnKkZcw29dbFl1cYLbd0AgROezDjZ5Qc/2LzDe2Sz8IyX"
    "mulTc279sXmRLimbMDJlVr4s7yVfWMr02CSdu48zeLaXz66deNdfVuU8l0HbuVTjpe1/ZV3b"
    "2Xs3HPCOrNjHR8t3s6G6hdQnW5GGeRQs9UtFufnVcxm0nU2J5/of6oJ5+FDT3uST8b8ZfjZB"
    "by5DR937nDj/JfPvFWqun0uPqP6fmm9aifp6pWbJ3AocdaC/x9y/cg9WIccDO0PPeJqOV1op"
    "NTXfXb/Kw9wIVW7FIVPpkrrqN78uVUqBAAjVSnGsv5maxBJuPB7kTjbHntpN3EhfpunlVpyc"
    "S2VgrBKR2yax+OiwPBj7gjgsAaMKpRLsenUbP9z8DVdFbEk2cT/zJ2tr3uPYt50cqF8w9unH"
    "o32AUgPfr5uubf814Y92IVrQQQ5vYgg/lydIp+c6Eu/0jP0+3DWy0cSgQkcezpMMwfgDdOhS"
    "Uj6fl7adRqHovnWRzNNJ3NCjLllL65qd3DuZwgjkIIBJwcC0lrC45SigQQTRNtH0FbQ/RNuL"
    "AbLY5XE+yx/9l2lYthqAwTOjfUWAUERiH+32IvEUEttofxhEI9oH7SH6Gcl5Ph2rLSzLIvMv"
    "KaaEiOgIXZhAoqkiiA5AIpAA0S4SO+jIRmIb1H9fxyTQooiRKIdET4seT82CRTYSTyOxg2gf"
    "HTxCRPxZgFDyBTdbGdplCSUJQ6QUdAJkERIHQIgYxaiMmMjzRAoSzEoI/M+HTrW/JsLbKJWY"
    "827FHwN1JVSx7ppJ/QN6Hno3ssN1kwAAAABJRU5ErkJggg==")
index.append('folder_bug')
catalog['folder_bug'] = folder_bug

#----------------------------------------------------------------------
folder_camera = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnJJ"
    "REFUOI2lk0FoVFcYhb97581MXsLEtNVGaBRcCOIiBEuLmTarhIqFErrorlt32boxG9cKQ+lG"
    "hSwK7TaL0oGWQBcpXWSRgikSTIvaNoiSmtbMZN67775373GhWExBEA8cDvz8fIvD/8Nryhwc"
    "LC4uXgEuSgJA0nOXZUmn0zELCwtyzrG0tGRqBwHtdntlfn4eay1pmrK6usqNy3N88FaXa98+"
    "ZnZ29vLY2BjWWsbHxz9PDgJGRkbY2NhgamqK0dFR2u02P27eZ21thgsXphgMBmxvb9NsNtnf"
    "3z+e3O6+ezNtnT5tjAVg+ZcWk5OTfPfnm/zwhwUazByd4MzJk6ysrDA9Pc3W1hYTExNUVdVI"
    "TKydOjbzVd0YA4Lmreukacr3dyw90wQLPz2C947W6PV6OOfI85yiKKiqioQgR/TN4uE1gq+R"
    "ZSX9fh9pBFkwNYOsYWdnhyzL/g8wHqvoCb6Botjd3eXh72tcPXSTY/rthX4+ngP4hvPnoHPr"
    "HSSRYBmKVc7gwQ6Du+vMHso5URum8ckXJLU6pS9wzuG9p16v0xwew3c/I8syyrIkobQk6dsc"
    "OXuJI2cj43nOUKOku9xBoQDAuQGhcoTgqL8xzxlgfX0dSd0ELyk4YvYrCnvY7DZeJR99eBhF"
    "hzEilhGFgEJJemKOO0tfsrm5aQASeaRYEcu/UbUHJkFhH1SBCiSLwoBY9VHog3nxeBOKKENA"
    "1T+oevzUYQ9Ve8+yj0IPhQGKjlj8hST3H8Dr3zJ7NOz7jZZRy0p1iC3Q4WcdeGSfprGBKs+l"
    "UsVzgAp35d71T9+XmMOY1ktfT4D52ZsQv37p3qvoCVFTZf8KhHwkAAAAAElFTkSuQmCC")
index.append('folder_camera')
catalog['folder_camera'] = folder_camera

#----------------------------------------------------------------------
folder_database = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkZJ"
    "REFUOI190j1rVEEUxvH/zO69u3Gz0UINSALBxkQLC0FsBEEbQQQh2OjnsJC0NtaCohaCX8FC"
    "BUmjpSABUQwxorJrzItJNrt7Z+6ccyw2L9rswDBwOPPjmRfHkDE/P3+kLMvbqjprZmdEpC4i"
    "S6r6WkSezM7OLlaHAWVZPpiYmLg1Pj7O6Ogo3nu63e7ZlZWVswsLC9eBaT8MEJGrU1NT1Gq1"
    "/Vqe50xOTiIipwCGJlDVlFKi3W7TaDRQVVqtFjMzM4gIAEMTmJnleY73nkajwcbGBvV6nbGx"
    "sX2g+vnFuQ8jzdOnnfvXMsLO1x8fY/IAMca9O9nvSCkNAKeV6cmLzzLnHNhgM86RirWTn16+"
    "sb1mESHGiHPufwCxAo218OshEivgx3CuSf3EZcyPOO89eZ7T6/XIsowsywAIIewmiHjTiMQc"
    "U0P73+mvLrP6/jkzrRbfHt+jAhTAkd34i++gKG5+GSTw1DX16bZ/E1aW0NijUjvMxLWnYLC5"
    "vs7WdoeUBFWlMnIUe3WLEMKlAVB6qiPHOXbhLqBghmmHtP0WLZY5ZIEsKyitIFmf5vgdfgJz"
    "c3PtARDNTAq0t4DJFiYdtPgGppgWoH2q7FCp7GD0qOWV/566ahEzTWi5iqWtAaIBLIEFTHuY"
    "dNHUwaQDu6+wDxDUHIKlDSxtDqZsHWCpg8k2Jl1MCzR8x8yKAyDan7K3dih28qazpjfLQJtg"
    "RzEJQMT8YHVeSP2+WWnh4AihuL/86MZ5M67gXHPY18YA9zY60ed7pb80KGtkHD8+CgAAAABJ"
    "RU5ErkJggg==")
index.append('folder_database')
catalog['folder_database'] = folder_database

#----------------------------------------------------------------------
folder_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAixJ"
    "REFUOI3Vks9LVFEUxz/3vTfjjPrEUMSRTI0WaqsIihZCYpvatYhq1SYIghYFYRCIqxb+A7as"
    "bZtCapNSI7VPDDKELDRt1NH5pTPz3rv3nhbPH9Wmtt3Nvdx7zud8z7lf+O+XAvj88vRc2h8c"
    "VMr55UkIdpZWVK18TplE8FvWEVj2mneHh2e1B6Cs29899CShlAKJk1EKXc8fX/8wviIqvgVw"
    "ky1idbSRyb29DzzzADBSx4YNQW4SE7rgtKCUT6prhK6zE0lEAAtiAUGpps7FqaGxA4AKccSG"
    "mDCJWMHWlol219nZyJJIZUAisCEiGtD4/aNJhe0BiBU4pKyuEVZBwl2iShm//waptoG9Me0r"
    "kFiB14oY5R0CIgcv3UHrwM2DQMFiw1V0cQYxJUSXEF1GzA6pow8hiMcSA0IRMXVsdT4ONhVE"
    "F7FRATEl0EVy2Y/kZheorm2T6HhDuss9VCAhIlZjo824kikhurh3LrCeXWBnUXPq2igNfSep"
    "zb/m0/tpb3rkx5344wMrCoPobURvIVE+3vUWoguszMxx4vwVUl+yqKfXaVx6Tu+xNgxyd7+F"
    "QlTNN4aVpK/Ed0QSYH2QdsQERPkXpDr74NK9Ay954xlcUb1xC0F94uvjy2dEuIBS/p92lbTb"
    "UJ17pZqmbhPUclSBStnFuKypv3kd4N3VzHiyuelhd7vxPOc7lU3Nt5xrwrod+ydADOl+UN1a"
    "u+VY1WMdWbXI5MUZ++gnjv4sCD3ATiIAAAAASUVORK5CYII=")
index.append('folder_delete')
catalog['folder_delete'] = folder_delete

#----------------------------------------------------------------------
folder_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnJJ"
    "REFUOI3Vk7lrVGEUxX/fm5k3Y5xFzeKaxA3UBI1BUAQtRItgQLCwExS0UbBTCyvByrQisYgg"
    "WBitLGwUwS24IRg3HBNNjDFkkolRs7zle9/7rsWgqPgPeMpzOYdzuPfCfw8FULyxqXdOrqlJ"
    "Kee3kRDODAwrf2qrilPhH6r58CmZnd2x455JAiibWFu//VJKKQVSEaMUJphYOfb89LCoCguQ"
    "cPNiTTS+uHTnBHAtCUAsAVanw1InsU6Ak0epHJklO1mypcNFBLB4o3f5fP8Kiez6hmCi5mrv"
    "+eZMJYHGEauJtYtYwfqfiGbHmBm/SyqzGCTCzPZj/GUsWr+fwopWvg2u4e3Nro5KAoeMNT7a"
    "A9GzRNNT5NYeIFO9DlD4pVtIUpFf1srkh7e4SpPLLyJb3VCoGEQOyTl1zFt3GLAggmCxegRv"
    "uAsTZSisbCMc7catUgz1FokCX/zAa6kYaBGJA6z3Eom/I/E0Yr7hTbxAJEthdTvByAUc15DK"
    "NjLXfsSjHG049rjPARCNiDXYqIzVZaweo9TXQ+BXUVi9h2CkEycVoaeWU77/iAXbDqKMsZX2"
    "AKEVRYyYScR8Yfz9Uzy/mrrmdnSpi4QrhFONlB88Yl7zKOnaejCVtf6s8DXyJqr0tJsbfNXv"
    "JNJLMaqO0VfnmF/nEkzW8/XJMxZsXEUiswbj+yKRhL8MJAw6Bi/s3SzCrqKzsHbfkYu86z5O"
    "34OHpBtaiMeLUpMyeuxeSRBA9WgV28u/Tvl3nDncFJ08dDSJE9N7+zpDA/0z+ZrCtrazb178"
    "6xcSfxPVVdGpoYE3mJkvNkzHPQ62bffZ18V/iQF+AG92Nauar+3yAAAAAElFTkSuQmCC")
index.append('folder_edit')
catalog['folder_edit'] = folder_edit

#----------------------------------------------------------------------
folder_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmlJ"
    "REFUOI3FkjtoVGEQhb//7s26a3LjLjEhiUrQwjzQQgKKRcCoYGGl6bSwsdNOxEIRbdMJgkFE"
    "RNBCtIk2YqGWPhJF1KhgInlvsjHJvu9/752x2JBESe+BKWaG83EYBv63DMC3Z90fk15XlzHO"
    "upXiF0YnTDl30EQ1/l+uNIy7dcXe3tehC2Ak1rGj516NMQa0asYYwkp2V+bDtQk11SlALF6v"
    "EgZzLbMvLwKPXAAirSB2kz97i8jGwKnHGI9E6xFaD/THUQUEVADFmNrmH4M9V1cBxuKoWCIb"
    "R0WR8jhBMUNh7hU1iRbQAMSiGgIhXseluEHaAKoJHBISlrElUFskyOfwOs6QaOgEDKXsMMsT"
    "L2jqOk8sXodxU2hk3DVA4OAmm0h1nl2JqiiC2CmC389Z+PmButbjZD9dwUsLie2Xwa+epQqw"
    "qhpVkNInNFpGozwaLiHBIrnZUTY3HaW+ZR+jXx8Sd4sk1AfLSnhALaoSIsE8YucRm0FsBluY"
    "Ymkmg7c1RZQbpHHPWRZnAiTywV8HwBc1RGj4Gw0X0CCLhgssTU7R0H4KKsO8vf+AulSZfNYh"
    "N/0ZwvUAq4tBKbts83EJSx6h30ghm0Sc3XjpEuKPgQpR4R07D11g6v1TxIpdvYH6lf6xgRP7"
    "VTmKMR7G4KfT8bbe846U3qBSpruvHbHTJGp/kGo7zPz03ZHVV/5X7wd6zjV2nbjZvDtJVHiL"
    "qmXoyQjdfZ2Y2BZIHuPdnctzJpTeDQFvbhyY3Hv64baY8wsNF2HtkwGHWLKdzJePfB+8/tjd"
    "CBD4NjF0+2RZRVGRaqmy1iuIgGjzH7M6TzACduvDAAAAAElFTkSuQmCC")
index.append('folder_error')
catalog['folder_error'] = folder_error

#----------------------------------------------------------------------
folder_explore = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkFJ"
    "REFUOI2lkk1LVVEUhp91vryapxTD7i3CdJJKgyAoCozCIKJRf6AaVP8gmok0dNikhjWLRhER"
    "GEg5bVDRRAnLUkKvilfv99lnn70aXPKDwoge2JPFfh/evVnwn8jsy1Mf2+PhYRFvx1hJql8X"
    "pVE+K1mY7Ep0w0LQWbt4cdoCBOL8waMjj0MRAW2FEcE21waKH8YXVVpTAD/ar86mK4XlN3eB"
    "ZwABmTZxpi1ZfkhmfPD2IxKTOzzK4TMTEaqAA3WAIrIv//nFyNiWQAyeOkNmItQprrFAWitS"
    "XXlLmCuApuAMqhawxIP3IsH1/WoV4JFztoGpg5oaaaVMPHiDXM8QIK0n4Wg1USToQjMJtgWp"
    "R9DeS9fQra2LisOZH9iNKebWDzJf7mO1kae9LaRnX5VC2i3bAqOqWRNX/4Rmm2hWQe0GLi0x"
    "V8rzPb3AYH8nJ0KflU1DqZIwH98M4DUAnhpUncWlqzizijNFnCmi6Soz1VEGDnVQSoSlcoYV"
    "nyO9MfUD5/ztBolTIUPtOmo3WifbRO0m1YYhikJsYnEKiVVygY/VrS8gwGgpra91mEoUi8ae"
    "agguBj1IR1uISTPSDKxrrYMK1Gu1bYEmzYn5R9dOq3IJkXjn0sXH+8NK/qoft0ckmRJ4wtJ6"
    "ilub1cmx0RuX7089EfbgweS3/pxwvbszGncK5VrTpcszMtK7JLW56cqXmfd39hT8iedjV27n"
    "C4WJ3oGTXbPvXtX9v0d283R67v35Y9XvadK86vl+x7/mf+MnCsAq1Rx26uEAAAAASUVORK5C"
    "YII=")
index.append('folder_explore')
catalog['folder_explore'] = folder_explore

#----------------------------------------------------------------------
folder_feed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAklJ"
    "REFUOI2lkjloVFEUhr/73puJM5kZTDQu0YRYBGICaeICogTEyqVQEEQbBStbOyGi2KUSLBQr"
    "F9BCLOIGEkWUYGsIZBEMGgxkcZnlZV7m3ffuPRbzEkgxlbc5l3PP//2Hew7851GNHuJrXHSb"
    "uIWlGQVkAA9QKXAsGFM10ww1BMgNFhm8vp2uoxAsgf8V4hXw0uC4EJbhw+0lr2FvQpZCO+Ta"
    "Ydc+CAdh9i3MjQICW7ogItsYkCJGF2HmDeg/sHs/9F+AbAt8eQxBAD6xN/NqYDyT7+1Vytlg"
    "bz4/cd1CF3SfgsoCTD8D/ycMXIHlOViehAp4yro9HUcepJRSIHUxSsH4C6hMwtgEdJ+AQ1fh"
    "/U2YGoH+s/BuFkrgYaSG1U3h4l2MdsEpoFSeDEBTC7T1wdwnsBb6zsPHO9BzHHI7kw40jliN"
    "0WnECro4SbDwjSjViR0fQZzXSLQKUyO4uVakVsZ7eY7OHWdgFc/DYZONV9EBiK4SrQhth4dJ"
    "RyEUOsEaMBqMgXQOUPx4ehLmR8El8IgcvMw2Nu+9DFgQQbAEE5dQ1XnEcet/YwUsZPfch3IZ"
    "nj+cNy5DHlpETA0bTCCmjBgfiUs4bQeR1h5UXEryFcRUkfYOdHNa1BgdAJ5oRGyMjX4hcble"
    "HJeSexGJK4k4AdgayiFeG7hHaEVhkPhvIkwc12H+BjFSg6g+8DpASzEKfme1n84ryTsiKbB5"
    "kK2ICQGNOPWoHENc80UiE64DJKwNf793+oAIx1Aq33C1kx1DjWll7KO11D9RTEKWshouXAAA"
    "AABJRU5ErkJggg==")
index.append('folder_feed')
catalog['folder_feed'] = folder_feed

#----------------------------------------------------------------------
folder_find = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqxJ"
    "REFUOI2Fkl+IVHUUxz+/O3d3dtbuzLDuLrSW/bFSDCrMVEKhsAhC1H1I6qG32JceCwQfFJ+K"
    "yMelHoIEIYjeTKHIF0WEHjLbSPdfM9uOze7sjHd25u7c+7t37u93fBhDDZoOHA4cOJ/z/R6O"
    "4n/i1JkzI5XSanUjCNZf2LX7w1u///pNeXHuxrXLl/YCZPoNT00dL+Q3j50aGR3ff/3nK0nU"
    "6Xzf9Bvv7d53wIt0lBspeNecfoCx57bmb85c/6BRq2ElU9jy1LPTsXFgIJcvFEdP1oJgtK+C"
    "MAiO53LDB3e9+hp3fN9xs94jadxh+/MvUV0uUVmc16of4Nj7U03HzRTX/TtUlhZKK39Xzk5s"
    "efKj4uaRQhRG/PHbL4vu7IWXb+S8nTuVetCNEG+UKp9ezA8fOnyU0l8Vzn/39a1idu2nR595"
    "8eOj77zLSq3O9Oenm66ymR2PHzg7oJQC6Q2jFKluPJ2e/4TUGOZuzjBWcN+ePPL6mz/MbBpU"
    "jkN5cZau1k+4GNHYJBuvfoFJMuDkUcpjaOIgnaDN8u0qOopYaSQqO/7WYKv5I/NzczTWVtE6"
    "LKr5b19pb5u85Onb5xAr2NgnqpfRfpO4Wv3P++w5uTTfbvkNF4chm0Z0VtaIa39ik5BMtsBj"
    "h75CobDdGBQgAkBmeIKF6b2s+/XtAC5dBzc3zti+E4AFEcQGpO2rWF0GiRETIqaD2JChracf"
    "UuKSiIjR2HAGMS3EBFi9BGIRq8FGiN1AzAZiQhD7MEASRGyK7daRtNWD2Bgk7W23ve02DRAT"
    "gFL/UhBbURgk9ZF0vZemdR+WBohp37OgsfEyIqIftNDsho3hJBj0lHiOyABYD2QUMTGQIE6v"
    "KseQRpFIV+L7FmL9WfnLyT0ivIFSXr/XRgB1NVHGnvundRf/hoeGWHBfrgAAAABJRU5ErkJg"
    "gg==")
index.append('folder_find')
catalog['folder_find'] = folder_find

#----------------------------------------------------------------------
folder_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI3FkstLlFEYxn9nbo3liKaUmnYxAschCAJNwoVYLaJFrVsY1L8QQkUW7dwUtLBV1CKI"
    "lhEEIWiR0UIq3HTFaIbKW82Mc/u+851z3hbTqBWue5bPeZ+H3/ty4H9LAbx7dPBNXaKnR6nQ"
    "uifBL85lVGWlX9mo/0eqCdKR+tLg4FMTAVAu3N05cCeqlAKphlEK4y13Lby+khFVdQHCsQZx"
    "Jlhsm588DzyIAGDFw+lN/vw4Voch1IBSCeLtQ7T3jcUQARyIAwSltrR+eDhwebVAaULiNFbH"
    "ECe4SpqgtEBxcYpovA0kAKcRMYAh0T0SU7hdAFWCEHFnKugyiC4RFFZIdA8Tb07+PlONQKoE"
    "kUbEqshaQRAiUreNxuS51UHB4fRXTG4CsXlGpx+TrZS43p8i3nER/OpZqgVaRKyHK88iNo/Y"
    "AmJyuCCL2DyYHJ7x6GhJcnZqhnunfdCsFYhGxBlcsISYPGLzjEzeBwnQzqCNoa1pH8nWPgpe"
    "iRO3j3Mj1r6OwHeisIj5iZgcYnIYpzmaGsaKwzqLQ/iWz7C/4zBFXeFM+lkcQdVWyAbl5c26"
    "EEsoSYREonhGY8Xx5cdHAmcwLiCwASt+gQOdAxSDMsujz73qCr439vnWqV4RjqBUAsBrNnFj"
    "DdsbdmKcxYrjez7N1vpWXmWmeTv3MusV2KE2+uMnx/dYT2u00/hGs7clFTrUdYyZ9Asm3j+Z"
    "jeXp/XQTf6P8P0pdU0vDd4dk1wVmekaJ1fwNCf7W7kssOQm3pCM2ylVMzf8F+ShD6iYvLYgA"
    "AAAASUVORK5CYII=")
index.append('folder_go')
catalog['folder_go'] = folder_go

#----------------------------------------------------------------------
folder_heart = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoRJ"
    "REFUOI1lkc9rFHcYxj/fmdnd7G6MSURESWOFVko0UhEpIoLgQbFCDy0KaoWe/C/MoRB6U8Gg"
    "CGoRPHiRtnjy5EVES9EgaGsai5Sgppsf62Rndr4z7/v2MLVo9j29vLzv53l5HseqsomJQPqa"
    "JyW0o6Y2WLTmp7PW4g/SbhcSuYnK6Mcn8n/ml5ann1ym2z0frQZIpXLKNgxdqozvqIERthb2"
    "pj//srPwfdnQkS/3923ZjIn21x88/H72yrV6L6DZOF0d31YjjqGTEDUaDB/9eg95TuAVnv6B"
    "A9aOb8dVq9/2ANS5EXKFhSUwheW3BFEIKtBugyp0EuhvYiK13g86cUbuIelAISACWQZFAaLg"
    "M0gTQCmksOj327se19eMjTkXABDfmw0rc5upDjTh5RxIAWogOaQZZF0Y2cTio8cstd/ejpyG"
    "n32078eKcw4M5NPXLJw7y5qRjdRHR2D2BSzFJaBWgbGtLD6Z5rebP/26kueTEWJd1Ney1xcR"
    "H0IwQOPkOO07c8xfvcbGwwepBg6SFN9f59n5C3Q+WZE4Sb76ptV6FTlPAKBFAzBWXtyn/fQR"
    "1IBD8FJvlH2t9KjxXUSDwXDvzZlXAJFpGBKExH89xy/+jWYJ63YfY/Dz4zgcWuT4VgqqVIar"
    "RANbmJn64n/TIwQcIev3nQGTMjoE37oF0gEEh8dI8a2UsDn5QWqR82Zmgn9zHVAwA0qQWQ6W"
    "Y5qWME1Xp06EVwUDrFQ3wcyDFWAe0y5IgkqMyUop8j7AMhTn/lMswHLQDNMMrItpF9NOeawp"
    "lJ6/ByikJp1lcBtwzgEhFgY4QgAcAeDAXGlZGq8CdP3dP6cO7EF74L31bkfs/rvRv+SNWoJL"
    "97oOAAAAAElFTkSuQmCC")
index.append('folder_heart')
catalog['folder_heart'] = folder_heart

#----------------------------------------------------------------------
folder_image = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjxJ"
    "REFUOI19kj1oVEEUhb+ZN/sXshJDNv6gIGggBhsV/CmstLNSBCsJEpu0VopFOgvRwkJiGUwf"
    "EbQJamVjI6JGUgRdEpSYBDebTbK7783ca/Ge+UHWW8wdzsw5M+dwDR1qZGzqqrE8MbBfMaCQ"
    "LdulOu46CRirk3dunOzqr1QwxqFAIgZJmQQfc+/xm9GOAqjpqvRVGH30jGMDA1twZA3zs5+5"
    "f3sUUaWzAGCtY+DoEU6cPUdkI2yUw1pLLrKIgMh/BEQVAQqFIsVSN+hu/4oSRHGzL09/LJWH"
    "hoyxu47HXoMX+PBlkWWtpmhIE1j4+pPhi+BFcEaiwcMXJnLG7EjaGML0FKpgozw2KmQBZC1X"
    "RAHvBUfQFhIX2ovjhDgCuwdjyvggoLBUnfnH3lJ1BvQySRCcibEqMSHOo6JIc55k4xd3Ty3R"
    "fD/NxHUBqlkGgsSB9vl8E0zJB8FhKYpvEm+CxhskjTXKg8PkKwfYd7AHY0xqSzXtUZmFtyOR"
    "M+0QvNYdicWV+uk5fgsQUEURupNvzM28IvgNJKyjfh2VJvn+m/yYW+Hh8xc1gWuOWFVDC9n8"
    "hIY6GhqoX6VXa+ztrYNfzfA1NGxQOuRwxUWZHh+uADiNURWPJMuor6eX/Wq2r6F+LSOnAqoe"
    "2tuBOtqihoD63xkxe3FLrLFNllZq0+8UiLWWbK50xY182WjZquZAyqB9aGgDMWrTbmzAN5uq"
    "iW79wWm79eD70ytnVLmEMeVOo50NKJh3sQky+Rf6A/2ZWDwCKjJ5AAAAAElFTkSuQmCC")
index.append('folder_image')
catalog['folder_image'] = folder_image

#----------------------------------------------------------------------
folder_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmFJ"
    "REFUOI2Nkj1oVEEQx3/73stdEriYb9FooxBi1BCRBEFUFBEtFBTBQtRCCQQL7RXtFCwEG5NC"
    "QbDRwk5QRFTERkGQSPQUNJoYk5Azd5f7fPt2dywuerGR22aWYX//2f/MKGo8chnv86r+q/HW"
    "zj16fnq0++z47VpZAJI3es6nXp+TKPdaZp4c+/X2yvr9AH4t8PubA9fbN/ddatm0UxWm3qBo"
    "a8By5ECXnghqEQjiscHmvoOeLY5T376Gsv3B6l39jSa/MFKTgNPme5T+tt3zUyivQKwpBeUi"
    "+ZnQD5IPt75rSPT2KuUtQ4Qw/3VKfqaH402rr/pNjW3OjOO5DHgJJNIk730qf/ycHQqU83vW"
    "7rhTp5QCqcAoRebD/XUL6VuPO7YdVaKfoOwsHx/nCQrzVhmbT05kTp+4N/kgwEoZp+Ph7AhW"
    "++A1oVSC0vQLunafVDo1QhCs4NNLQ+PGIdYPHLJfHu37efzi5AMAT2k8cRqrY4jzsIVJSnPP"
    "cHoO5U/jxztIPi+iVnSysmUMFUQxP2Dt3wbjUe9MCV0E0QWi3CKJnlO0bOkGoK51mP6ham9U"
    "0IxYFVQFIo+goZPmDWcAByIIDqenMZmniM0iJouYRcTmqV9zAUKpjhgtIraMK45VHtscYjK4"
    "KI3YLJjMUn4RsQWQEPSyHRGNiDO4aL5SyWYRk1m6p5cqL/4VEDEQLhMgdKKwiFlYAjPVb9ss"
    "YnJV2JUrNg3/WEhHxVSjzsUSShKeSB24BEg7YkNAI14lKs9iSiWRSMKqhbB8bWL08KAIe1Eq"
    "8d+dFkC90sq6u39SvwHJw2QArdqv4AAAAABJRU5ErkJggg==")
index.append('folder_key')
catalog['folder_key'] = folder_key

#----------------------------------------------------------------------
folder_lightbulb = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn5J"
    "REFUOI110slrVFkUx/Hvefe9qnpVpVGSdsAKURSHEIfuRsGFbuJWF4IIbgQXus/GTdNu/BdE"
    "3ElQECNCQ69EaKEFhW66m0aNQxyiEZxTZdWb697joqJEE8/ycO/nHH73Ct+pv88dD9aMrDse"
    "VkvHSmW33mmnaqNZazvNVtxMrmVtfll/dOK5LHb5zuVTpdVrwwv1wZFDptZAgiri+ajr4pKP"
    "ZM9vEj2+Pt1JBvb7iwEDqzldbwwfCgZ+7DXUgABS4NWhtvUAlPqH7D8X9y0KVML4mN+3CSiA"
    "GvgVBAM4KKCb3Ccc2kw2tfzEooDnkj4Jyrh0Bgnq2NkIVNEixuvzcckdvPo6pNS/yb//+8//"
    "hUuGh0W8L0DaapowiUGfkTy4gYvLiAlwaRuvVOA3fEy4C9t6gy/ObB7ccz4QEVAApfPkD5IH"
    "E9R2HKSYvkRl1za8IENKg3z87QrhlpO0707Sev32to/VFJeXs1dnsbkBbykmWEKUBcjdPwmW"
    "bcdzitgKUijlVT8RP0yYvT3+csPYzd2+5HgArludm36L1r1/vw5l8tuUJtk49lcDwFdnDJ6h"
    "/fQh+YcXuCymf+dhlu04giC02orD4FyKcwFhtc6r8dEvlI8FwfDDnl9BLagDLPm7q2Aj4qbF"
    "VFYRlJbzoZnxqLWCFfN28SVXVbXkr8d776wK9CDVgmoZHk3P0IpmePc+Yu/oUaL/5wHkzvXi"
    "1950tajmoF3QnLKfMjIU42wbtR1qaxpMzd9AMxwicxO7oAW4DHUZaIq6FHURajvgEsCDr4Cu"
    "LduoCbISEQEMary5rwuCBwio9CJL2t8AaX5j6szobtwCfGF9PmP11ufWJ+zvLcLhacf9AAAA"
    "AElFTkSuQmCC")
index.append('folder_lightbulb')
catalog['folder_lightbulb'] = folder_lightbulb

#----------------------------------------------------------------------
folder_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArpJ"
    "REFUOI3Fks1rVGcUxn/v3DtzZzJNnGg0k8EmkCBNHJJNEQnEDlFSEqQB7aKhRUSwgutSBAXj"
    "qpDYhV0UXbhw5ULwgyKiotikUCmpVQRLySJtxkxmxozJZJKbmfv1ni7Gz7/AszzneX4853Dg"
    "Q5cC+Ofmp09ijTt3KhV6ZyQ463PPVbXSr4Kw856rGbLmR/bg4JRvAihtdH+851JYKQVSN6MU"
    "fq3UWXx85rmoehfAiDSJ9r0XbYUH3wNXTAACqaFdyymcJ3ANCDWhVCPR1D5SuycjiAAaRAOC"
    "UvHk7C97Tr8BKJeQaJfAjSBa0NUsnl1k/cWvhKNtIB5oFxEf8GnsPhFR6A6AeoIQUe1XcTdA"
    "XBtvrUJj92GiW3penel1AqknMBNIoMy3AC+EGdtGoufoG6Gg0W4Ov3wPCVYRfxXxK0iwTnT7"
    "KXDqZ6kDXBEJauiNp3VxsIb4ZbS3ggSr4Jdf9StIYIM44PIWIC4i2kd7S1Ttl/w+M8/fcybN"
    "W9ooFZf5or/MpoYyl+9/wubWNCt37pKspsyhoaF4PYGjRRHg1pa4cuMvNmQH3xz6Ctu2WVjo"
    "4s7MbSxjE6MHj2CYMfL5PI8eWWYkcnf89Qor3kap4bfphab/8g3qy6/3cvHncf54kiOZbKO3"
    "t5dsHs7++BOFwiL9u9J8tneU+fn5YyEAcWqT/144cGv6xtVqQywGwGjsYc2xK4yNjTEwMMDI"
    "yAjDw8M49hr7jdtrAIlEwjIBuk8+OwfQ19d3vD9R+AFIjM90TXtSHpyYmAjH43EAbNvGE8M7"
    "82fXw+8yfJ7L5Wrq3RdPp9M9nZ2d1zKZTLK9vV2bprm5WCwyOzuLZVl0dHTQ2tqK7/vL2Ww2"
    "NDU1VXgPABiZTKY3Ho9fT6VSWy3LMkQkVCqVvlVK5VpaWq4DYcdxgsXFxSXbtg/8D3+zTWr1"
    "xW4AAAAAAElFTkSuQmCC")
index.append('folder_link')
catalog['folder_link'] = folder_link

#----------------------------------------------------------------------
folder_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj5J"
    "REFUOI3Fkj1PVEEUhp+5d3ZZFi/BgKjBD4QG0EhBNCZIZ2NjQmFDQ6GJv8AKE2NrYUxobEyM"
    "dhQWRhtiAQkhGmNi1PjRiGGDwErYvbuwez9m5ljsslDROs1Mzrzvc96TGfjfSx12OTd30y/U"
    "pxbzQdd4ZPNktcY3Ierr3Y47Dz7WAPRhgEJtavHM4MXx0cHjZLKaYpiwuRXys3J/Hm5cBfAO"
    "A+Q6+8ZH+o9RTjzWKxajfPpP9dAedI/vafSP12Of2oOREaUOsoR451fhVdXR1pYlrBqcQGyE"
    "nPYRv62l1Mr5Q6cnnmWUUiANM0phoq2BtjcrRHFKahXGSQOtIKpHLYCHlQiXEK89pvZ7ltrq"
    "c+qrL/F1ht4jlo1iiY6sIp/TdOYzrG+n6N0Cj25dmm4kSPDEJdgkizjB1VdJdzfZKS4w1tXH"
    "97WjvFsZxfOz1OMUFRaYOFFic+Ds7L3JYqzxyDlTJ6mBJLuk1QrB0DS57mF6UJxDAAcigPBl"
    "eYO19wvSf+FKsF4sPtWkHrq9l67h2y2h4HDJGqb8FrEhYkLEVBC7w/mxGf4sfTMflssmxc9r"
    "EhGxEa72uSG2VcSUcWkJsSGYcrNeQewuSMzAyZy9PjOfB9CSIOIMLv3b6GRDxJSb51Kzc6UF"
    "EDEQ7z+4JnaisIjZbhrL+7FtiJjqvtlFjTHNQUAipbS2lU+q2UBJ4IlkwAUgPYiNgQTxGrvy"
    "LKZeF0mllUFLHD1ceTJ5WYRrKBUc9rURQC0lyroXe6V/evBY1T0UoYkAAAAASUVORK5CYII=")
index.append('folder_magnify')
catalog['folder_magnify'] = folder_magnify

#----------------------------------------------------------------------
folder_page = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk1J"
    "REFUOI19kb2L1FcUhp9z753fzGRxsjaJGGKpYVsRiyjBJlWaNIJgIakS8k+ki6BgZ2wUBfs0"
    "WpkEQj4NBJImiKybZndxV/zYcXfm93HveS1mFC3GF05z4DznPe8xFujqL9tqciZnB+D+xuMJ"
    "RTauu/X19ebmpN688Oel01NbBLj804a+PHWQR7uOAS7RFSdFuHH3GX/fXb+1vbl6Ji0ClCKe"
    "TsTqIxGC6LIznmY+OTzkxJFllqrw2e07u9+GRQAB0WCQoIpGFY1BFdh+NuXIfjh3/F2Wqv7X"
    "CwEAZtCLkAxSNAYpsPbE+HWtYWcqeimQ7t06+s9w38qK2ess8X0DhhHDvG/CXdCPWDBijAhI"
    "5vGjD09e75nZzDearb6zySx/w3CiQZUCJuFumBkSJIpqvO03D7+jtBHCCLN9/PzXIc6d/IAU"
    "IFjANcskOFDBMIEkkrUEeUtpK+Rib+03du79y/ll2LoKNg/UgDivAeBf/A5uJAIDz1PGa6t0"
    "Tzbwrmb/sbOkla8YLUWk8CoXCUKAB5eP0+RdTNESXSAN3+PAqfOAg4RwJg+v0z4HYXOIIYw0"
    "+hiAKowo6tpEK6nUtFvX5mYBnL1poM3QdNDlQt1mpk3L8vtPScDpb/7YGr1TDZNaJM/zYzVz"
    "4R2jfgdVg0oNvoeXMco7DA5+yv/ADxdPHABINC6jzIZVQC3yBrxGmqIyQWUX5TEqz2cLXlOi"
    "85Qnj/HcAwVQROqB95EvgTqkFqyFkCl1/SbA6+a/B1c+P/zqV2+TAPsR3O+/bL0A35s1RfVC"
    "hO4AAAAASUVORK5CYII=")
index.append('folder_page')
catalog['folder_page'] = folder_page

#----------------------------------------------------------------------
folder_page_white = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgtJ"
    "REFUOI2FkztrlFEQhp/5vm/dS1xNxAvihRQWmlaMjYKFhW3+g7U/JF1IEQsL0c7ayjqFFqII"
    "ghDBCxJlDbtZN9n9LnPOa7GXJIVxYDgzh5nnvDNwjH/bVeACYJPcAE3iDvAdiMf0c6soisLd"
    "ddjzPNf6+voasAgkxwGW3V2j0UiDwUC9Xk+dTkfuruFwqI2NjTVg0f4DeOPuxBhxd4qiYGFh"
    "YVaQZdntYyUApGlKkiSkaUq9Xqff79Ptdg8gn17efN9sLy2ZHWaJzdfvOgBmRpqmTGMzw90P"
    "ABbT61fuPq2Z2WTHAjMW7dWladEUYmazfAYgKCeW9eLXBqFMITmFWZsknT8yyvT1w6CxgpIk"
    "hgIvaiiKqveR4c/PtLc7fNuaQwrISyCStOZBgfT0GS4/eD5RkNBQyKlGhsp9qj1x7s4qC9lF"
    "WnMnkXREBcDXFyuHRqgSsuZ55m88BCJIiEix9YhhVgOFI8ttXnuCJNx9DwgZpaSQE4cfUOij"
    "MEC+S+EtqlFOgo/BBGIMlN1tBjs/1Gg07gGdTCVSdGL1G3l/DPFdWk2Duo0VyUEVihWtdo1m"
    "I3Hg7XiEIsoIyLvId8ce+hBHE9gAhT8o7KOYg3KoZp+KjFK9arjTKgcn2qZ2ItUgtkFnUSiA"
    "EiXj05KA5wOpCsUMoCJf/fJ4ZVniPmZtjjMBtllaiM+mV38BrDc9yBrlFo4AAAAASUVORK5C"
    "YII=")
index.append('folder_page_white')
catalog['folder_page_white'] = folder_page_white

#----------------------------------------------------------------------
folder_palette = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAshJ"
    "REFUOI2Fkk1oXGUUhp/vu/dOZpzMT7VJ06ptY2kJE7XQQEcoriq6cFO7qBUES3EnuCqIghTc"
    "6c6NCuIPulRqFyoIKqhBW3+bFJxMZawZpzRJJ03u3Pm595v7fcdF1CgEfeFw4MB54OV9Ff+j"
    "p49X909OjD01Vh49KqT2Rtj9dPHa2hsvn79YA1D/9fzCqaOn992+4/kDU/v27tglIEXaywOa"
    "vy5cn28uv9j6MXxlS8DZs+jxzrF3pneXT1Z2Z7xb77J4t9VxJkvYehyXCWjUvrfnv/jupLcV"
    "4Pi9D79+5FD1iUOTWufkZ9Kwgypn6Rl4a22eK7bO4WJV95OwqLcC7CqNPjZ1+XfSD66RuhJu"
    "ZC+d1gma9Wk8LWAGBHHEeClb8Rc+nLmUK1QqSm2y5r70AhmCy/j0Cg+xULvQKeXmAtlZyb2/"
    "WCVvDY+W62go+Mp5U3fe/3aglAIBEC599STtB6uMBo5o/SbLq1dGQ3yV3z7NgCJauqAcIL6P"
    "lRhnRpKlV7HGA13E35bnpx8uELiYew7OcPeBIzrwNNmowTOrF9mz8w6iIEejvfaRrwxanMGa"
    "DOIEN2gyU+nSW1klXVkibtQI/rQWAwfzQGeer1uT3372Te1ZH03WpQN611dIlhs408cbKbHn"
    "2JsoFK1f5sjaPrkgS2qHJDpP5/MzvDd7+cS5T+qLPkONnxtn7L7nAAciiItIO7O4+CqlbI/V"
    "pXW6doioPtv2nwHg3Me1RQAfIyI2xvXnERsiNsLFv4E4xMVk9ICJCYPYLmL75Mol2v+I3BeD"
    "iEtxwxtIGm5AXAKSgiSI6yO2h0sjxEag/l1en8SJwiLpTSRd3xgbbsLSCLEdxPYQF+OSJiIS"
    "bwKMrA377VtMlCkoKWiRAFwBZDtiE8AgemMrbUkHA5GhJJsWkvilq689cliEB1CqsFW1/5YA"
    "atYo69796/QH5od9LaYWM+AAAAAASUVORK5CYII=")
index.append('folder_palette')
catalog['folder_palette'] = folder_palette

#----------------------------------------------------------------------
folder_picture = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmFJ"
    "REFUOI19kj9oXXUUxz/n5iYvLy/vRdS0qKiTErqICBIUddCxi5MUHcRF0MnBoW6ik+iiguKi"
    "pZtdHZylTnUIJYUgaEiQqmnN+3/fvb8/5+vwGpsOzwOHczh/PnD+GAvk4uc/ftbrrL1+XLFa"
    "mGEFG8oMT/JmTl1X35aLAN31tTfeOr+12el07VR448SZNJEvv995cyFgVFmr0+na3s0RVw/e"
    "Z6N3mypEDo8e4LmHP2Z76xGKorCFADP1EpDcWV8/or18P06Drxzwd7/C5RjqLQRINpLYGFeB"
    "fl2TNWUSG46rmj4NyBCMyr0fntlpd8+dMytOt/PNjWZJgnHtHNx8Am/tMokVg/7jPHm29V9l"
    "ab609egL3y2bGWjejBl592fcYTDLPHX2Ik8fvMeNXw8ZvPQpKSYEGNYryarx0Gr++ooclqDo"
    "YdYFncEQ1/94lxgj10IgPLRM2H2NGCMXnr+GBKUFCnkghxXkwmeHzG7tc94q/rm8zzunF7ME"
    "tEtol5QWkRiWFKx6mjH984jp77+gFLGyxdaFS6QkmiaCgTsUBVjZYXblZb64sjOcTKtLJbGg"
    "bJ9hc/sDNrd9vsI8Io1+wpt9IKI4QXmKvGL1sQ/5Dfjo7RfvAygJknKNV9dRHpKrPVAEOfIa"
    "M6E8QHmCcgXye85dKiB5wuMtlIZgJcoTUAI1SAXKUzyNUR6D2b0AGpeRUTpGaTDXPERpeMeO"
    "UR7dGaHGm0Mk1XcBQf1Y3V4L45WuqVtIy+Bd0IMoN0BAxdxakUmzmRTV3B2hqT/Z//rVZyVe"
    "mT/A/4gAuxos++WT0L+pTW5TrdE9fAAAAABJRU5ErkJggg==")
index.append('folder_picture')
catalog['folder_picture'] = folder_picture

#----------------------------------------------------------------------
folder_star = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoFJ"
    "REFUOI2V0s1LVFEcxvHvuffOqDm30Xwvi7JXXEVFFGgtiiKiRZug2rTqD4hW0aad9A9YroKI"
    "IAh6sUVQi0AqekcrzF4sFzPqqKMzzcu995zzazGpFS7swOHAOfw+nAceWMYavpvc8O3hFnne"
    "V9P+75uzHEBZeZFoOYEKeP9fwI/+ZP3nB/45v+1kY137fpo3HU6+6V1xfvBGsn4BX2pw5F4y"
    "whHX8epUovE4fms3rmSJQofsj8cUMo/RpbwtjltxlwJOd7tlr7brUGPHGerbu0CPE80M4MYS"
    "JFp2YGllOl1SU+n0RW+4f+e7Gr+zU6k/0wi51IuJqU/3W/ymTejcEKKL6NmnOA3HSH14wsy3"
    "t6eO9kQ3PWXdbWu7r8WUUiCVYZRCl6dahm/vs7mxZ05t/Trc2k5M4Qu51BD59MfBIz3RTQAP"
    "I2VsWBWM92JCF5yVKOVTvfoAtQ3rHSfmo91msiOPaOjYSzw+iouzef6vngpxxIaYMI5YwZbG"
    "KGVGyby+jk5NM/311kKw1KePALSt2loDLysADtVWlyikJwkmvmLDIm5VkvajV5kcukU8uZHk"
    "mu0gAkAhm2HiztkF1CNy8GqaadpzAbAggtg80dwAfl0Or2qQaPI5YgqILZJYd4kJ4NVZYrv6"
    "iDxCETFlbHEQMXOIyWPL30EsbswiuoDYn4j5iZgiiAVgVx8RgCchIlZjowyi5yqIDUA0SIDY"
    "ImIKWJ1HTB7U393zCKwoDKJnED1b2WZuEdN5xOR+RyhjgzFEpLwIhJKNilMrwnzcV+I7IjGw"
    "PkgjYgIgRJzKqRyDLpVEIgkWAAnKl0evHN8twkGU8peq9h8FBTUQKmOvz1/9AoJdXFtUqnkU"
    "AAAAAElFTkSuQmCC")
index.append('folder_star')
catalog['folder_star'] = folder_star

#----------------------------------------------------------------------
folder_table = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjhJ"
    "REFUOI11kk1IlGEQx3/P67vpGtvBrw7VITpUEl4yMcibh06GVIeiW3TsHhLRpUt0r2NmEB0U"
    "+qBLlwghQ4LQDoGZ4sFcFdNdd/d9n/eZmQ5bmrAODDPMwG/+zIyjgY193Lin5m6p6VFVpZoG"
    "0kwIon9dkGCI6HTcCCBmt6/0FToa9f63+y/nehoCVK0D4NXPUYIGSkmZalYjk0DQQJDAnfMP"
    "yDJtbqxADYDr3Tf3nV5JAlkQGgNEAXgxubovYKi3DR+E+Pvbs1/zhe5u56Kd5uuK7uTXLnQx"
    "PlXkcv/hPYD1UlJX4LTp1LGBpznnHBiAkb1bQc2Im2D80yo4GJ8qEkcOzMjFcPpIKz4TYsQS"
    "1DenK48R3wTRIUQGMSBucgz3dTZU8GO5RAhK7DyRqUf8AUwNrS1xMJmnPD3BmdnnzE1DDzD3"
    "Ze8OdOg9hhIT0aKhRuXXKmlxHvVVLuYWaT/3iLbeG4j3ZKJY/TBELe2sjQ4A0BKjMVlEnO+i"
    "s38EUDBjZqHI8rcPZFmKqJJ6j0iKaUau/RIngJFns2yWam9ivJlJglZnMNnCpMzJ/CK0KKYJ"
    "aA3TbUy2MamSP36V+c8wcXfAAcTmMdOAZmtY2KpDNAULYCmmVUwqaChjUgbn9uwiJlVzCBY2"
    "sLBZd9nahYUyJiVMKpgmaLqEmSW7AG+/s+p6qy8fKDgrRGY50AJYByYp4LGoHl0khFrNLLN0"
    "B2Bp8nDhyXCfGYM4V9j3d+s/Bm7SO9Gxf6U/djFz3o9mgMYAAAAASUVORK5CYII=")
index.append('folder_table')
catalog['folder_table'] = folder_table

#----------------------------------------------------------------------
folder_user = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI19kUtIVGEYhp//zDnjnBmZzPKaBo1pkGSgTUibaBFFN4KCoE2bCIKgti2iXUS7FmE3"
    "ahHYIoqi6IJEoFaUUUkQlVZg2UVSScczcy7//7WwqRCmd/nx3ng/xX9waENHXWOle6M84Wa1"
    "NhiQmBu/vf/MnS1FTqyU+OhRrAUzmbvphNupRdAiaCMq9MOWbFP1p943oy8ArFIGVa+XJyvc"
    "1Bo3PY/MsiXUN9RgjGCMoSLpni/y7FIGejoIa1tSpn3rLqvKyQGQlwTT2qGv+6xf5JVscPDu"
    "UDC/KjWdxCNQZSgnCUBhZECamuuDPw3e3Orw3HSrq9S/XsLY2Ppo36kVLy+m+lc1Ls6QVw6O"
    "Cvg8+kO637d1F5nq3c3VsnTzY5RSILNiz9ccOPGETNMyslmfgXuXUSqBE0/TsGoPl073RD2D"
    "I7v1071X1NtrWdO8rVcF37rQQQysNMe6Q/KVm6hYvYjhHGj9t5stsBDh+eUH/quhwR02oUJM"
    "gA7iiBFmPjxkT3oQonPwqNRCcG7n9bKTz45ctZUlykR5pj4ME06MYsIC81u387P98ByJAFDu"
    "wNSFTr7G62hcuTZuE1rYbjW1644DBkTQUUBs8g7fvAJaNHkdw4sg0iGNNR0oIBp4kZ+M90c2"
    "oSC6QPD9wp8UMJQZTZJypk0cZRSOGLQJsfHRgG5rb8hs7Juw8UFMBAoQmW1hQiwJqbF/Uq08"
    "ROUQK4cwTsJt5yNwZaOaALAJBIWeFYsGCRDjgykgkke0h+gcEk0h2psN+Ae2BIbIG8dEDogF"
    "EkPEAVOGmBRIiEgAKgArQhcKcwzy/pf3XdtrEGUpC1X6cb8nUvdBy3jx9As0kzdT8NGq/QAA"
    "AABJRU5ErkJggg==")
index.append('folder_user')
catalog['folder_user'] = folder_user

#----------------------------------------------------------------------
folder_wrench = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAntJ"
    "REFUOI2Nks1rVGcUh5/35s41d+JkDDGWcdCC1o9aF4WgnS7cha6soH9CN1kpBXcGGlpQ0EV2"
    "YtNFCC12K4grdwahRFOI7aI10agNZtRRcyfzed/7nvd0ESXaRc3ZHDiH33M+DZu0qampb1T1"
    "gogMqOrk6OjoGYBgM+Lp6emyiPwwMjLyUaVSiUSk9DYXbgZgrf2yXC6Xc7kcMzMziYiEExMT"
    "v6rqi00BVNWICEmSICI159xXw8PD+dnZWf9BwPj4eGCt/bZUKuGco1Kp7IvjmGazSZZltfDv"
    "G8PzceHQIWPeXYeSNpeWb9rJa92s9/S2sBrl83lWVlao1WpYa1leXn6qqt+Fxvcc3HVsOmeM"
    "AV0XYwx3/nq+Z+3P9Oynu/uYW4C1+UcUO7/JzoE0qa5Wfw6CvRfHxsaem/vXjiT7vp4p2mdX"
    "ENsDQT+/V/dza2knn+/tJ5eDWt1xa/4lP50uYUyfXbh+bPHAqTuHAUJjCdRbxEaoV+4+KXDv"
    "cYfjwXn65u4BsAf4IoIHkwBEBj7bOGNAr3cdWtUXtJbm6Glu58TWVYonrqLe0Ghb4giG+kNA"
    "CaIii5ePsgHIAsJ4B0OVcwxVPIMdz9aoycLD27xKmnw88Ixib410rYX6Nr27v3/vSiFWVaWL"
    "b/+BSh1JFrG5LlmnwGDcZTCuoy5BpYlKG9S/D1CLqnf4rIa6OvEWg7qUTwZboClogEoL7xqo"
    "NMCY/3SQejUI6l6vV3IJKnXU1d/4BiprqLRQ38Wn/6Cq3XdHWM3aL/O2ERWMFgLVHPgC6HZU"
    "UsCiwbo3geA6HdVM040R0u6lRz+ePKrKCMYU/vevFTC3rRH/y9vQvyU0YeaYnRUgAAAAAElF"
    "TkSuQmCC")
index.append('folder_wrench')
catalog['folder_wrench'] = folder_wrench

#----------------------------------------------------------------------
font = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeBJ"
    "REFUOI3VkMtrE1EYxc+9czMzTicZ2jRBC5LaWluDQnwWEalSBBcuusmiSBfFooibLt25EKwr"
    "/wAFoVAQdOXGTQRxoxRrtDZY8EHR0hppkoY4ifO4D1cRrY5b8WzP+X6c8wH/WiTKGJlZPsk0"
    "cjqmUSfkKuShIgTK8mthndQb157eOe4CRLEogBRIDmWs8T1pY5eUElwAa5WALwbNQsM1BUAU"
    "AEQC/DCY39iMvTcouqGkJgWhxVJjlpQr0y9mT3ntHI0C6L52bkenfqK04hVevWne77I0kzdD"
    "8uSn48gGh6df9w32WZdrm365uurepYrsC0IJgNpbs781yOfvaQmH3TAYUsuLjRlw+VB4whRC"
    "wYqz/dl8Sf8rYKV7YHxgp3n2c5W/FZ4oiybvjelkOwHg2KxX+HUjckJuspjam7VvdnWwbZ/W"
    "A2rabEpJpdmdRr9BKTRCDOl6CQBf/wBQJJFcup5JG6nCoy+35m8fudh2jp5feNDyOgaZRnQE"
    "6pcGFAAOXViwchPPR4dzztS7Va/aqvlz7cDQaCFZX2sV3ZaArhNwjRwErv6YzgCAUTqXPRAf"
    "26gE8L4JIrkay4w8XooJ0UMt40rP7viZ9XIALhWctHUpc2z4w8dneLn1f/+pvgO2br65Mjwr"
    "NwAAAABJRU5ErkJggg==")
index.append('font')
catalog['font'] = font

#----------------------------------------------------------------------
font_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlJJ"
    "REFUOI3Fkk9IFGEYxp9vZnZndth1/bemYrhpmyZtbmWblGWxCB5CAvEg0UGIAi0QunjpZKR1"
    "iS4eDApBEOpQXYJcQUKKLBPNNSMjDxZt7a6O6846szPffJ2Erdjw1nt9nufHw/u+wP8ekkto"
    "Hlg6LfCkxcZzbsNkhmkwQsBkfc1QiJLsf3X/RAogTMgFsCiKaivlzn0l4h7LsmBS4Fs8Y85n"
    "1HAyJVGAMADICdCNzHRs3fZZ5FAMZvEWJdxsJDlCovHedyNntG0flwtg1/nzZQX2k5EVLTz3"
    "QX1UKPOSqRrkRVY4Z4OG3vdVNVVyz9q6Hk2spsY4Rg5kDAsA5/zT+1eDjo6HfJ5bGBQFeJbm"
    "kwMwrWdUoxKlDLJL8Nd1ROz/BKwU+zp9u6Wz3xPmJ6rRKFVNr81OSgkAt1PwUl0Rs/2/nTHQ"
    "NevxH3YtVhSLnrnldESJpleYxXhngVjd4JupUdVJ6IaCpLqxuZ5K3H5+a+FG1g4YyStauFlZ"
    "InrCEz+Gp+8dvbyttF/v/+hwfUFTMIiKQh8mF5+4Xkem+oM9ZfkcABy5NCMHLrwNHQu4Ly6v"
    "aon0mj66Ha4NhYscjqnqQG09KEdRX9YCSgw0+o8DYD0cAAgcN+o/5B6PxTPQtiixTHausnky"
    "f2/TRB0nS3cUNSbYiBNt+68CAK6FhlFdchAERMr5ytnTeKV8q72tVTJhoa/lAQbHuyDxIsYe"
    "P9X4nQDKG5yOzUzslHeXF/H0V2yoP/FyfgpJRb+7owYAEOwuHQQh3QRwMWATjA29GYr2/QK6"
    "3e/L1gvQ8QAAAABJRU5ErkJggg==")
index.append('font_add')
catalog['font_add'] = font_add

#----------------------------------------------------------------------
font_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk1J"
    "REFUOI3FkttLVFEYxdfe+8yc00mdvIyNocxomINl2EWCLCwqqOjBF4uhgorIqBfryYcegkSl"
    "P6CgoBCEoN6CghyhixBIKV7GC5kNZOqIzjhNcztzzt67J2kqJnxrvX7r+7H41gf8b5Fcg6au"
    "qUMKI8dsjDpMS5qWKQmB1I2IGSXR2J33jxrjAJFKLoDgKPa6dd+2UrVSCAGLA/MrGWs0k/DH"
    "4hoHiASAnADDzAwur9o+qxQlkIIJTuhwINZDQittQz2H02s+mgtgN9jZskL7wUAw7R+ZTDwr"
    "0plmJUzyNms5Z4K9bWNVNVX69ciqEQrPxZ9QSXZkTAGA5v3p/StBS8tTVuBQulUFzqnRWBcs"
    "8ZKnuca5hJ6v1NW2BOz/BARLqn3VFdqpxbD1iad5iCcsj81OXASAI0/xcCOqZvt/q7H+4rCz"
    "bnf+RHmJ6hyZSQaioWRQCsnyCtWt5zc8rykafSy11SAEld8k5L3j/aI76waSFBSPd7pLVae/"
    "f+nB4MOG1rVJ57lrEztdY/BeukrUyu1IjfVVTA70dfjldEIBgD1XPuo89WH/vvrNl2fm0uFk"
    "xOhdW/Ye8Rd7F0+X1fhuQZt9A7zrgO7YBI/bzYam5Q0FABRKe2t35Tcvr2SQTnEiLNnsbno9"
    "buN8C9XV9oJEvFBzVQInb/6q73YZmCSenK+crVdH2Vyj70L5xq8vYKRCSAL4EWOYmsU8Ww+g"
    "tcHliCwtHKB2Rk2WwPewxJcFyrkl764rAQAMnKloT4YXWqkgbkHlvIC8f6JfdP4E3IP5xdFz"
    "96UAAAAASUVORK5CYII=")
index.append('font_delete')
catalog['font_delete'] = font_delete

#----------------------------------------------------------------------
font_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI3FkktIVHEUxr//vXfuTEPOmM74qLHREc3SEc3KyMQibNXCjYW0kCBr0ca2EUgI6b5F"
    "UVBIQlD7Fo4UgkrWJGqWlQOW00MZx8c4o/fe/6tNRuZYy77l4Xy/czjfAf63SLpiQ9fUCU0l"
    "jTZVcVMmKaOSEEinuUiXyXKic/h+XRIgEgC0dADBkV3md7aU5tiLhBBgHPi6YLFxKxVKJB18"
    "w7wtwKTWSGzJFrEr8EAKVXCijE4mesjcQvvrnpPG771KOoBuqufzd+n1kzNGaOxd6kmWU3Ww"
    "FCUDf5jTbnCofSKwL+C8srhkzsWjyUeKJBUWFQCUnemGbdqgufmx6nJr3XYN3qnxRBeYeMoN"
    "7uBcorLm6tm2B9Xyr4AZT0lLSYHjzPc4+8gNPsdTrNCmkzwCwOJM9Xn249ydsk2QXzFWXRj1"
    "Bg9mvPV57N6x6bXJ0uK2Cs6YpJKBck52ZxWj0nccLz89w/iXFyzUPq+DQP68gSSu7Dc3/Tl2"
    "b6h//u7IvcOXAw9rZWOwlXApwAWHgMS3lSiCvjokrXVtqXvACktT12ouhZ18/dWx2qrci9NR"
    "I762aPYCgMEscCnwOT4NKhiYoKCcImGuoqqgHkm6pi13DBqKpii9wWp3X2zBgrHOiWCyyd/w"
    "PNNgBhhnyHXtRZ7Lj3x3ADZ1B7wZezAaHcJQZPC9sYrMtK8MAE23i7hhWbCEBZNZKPaUK0cD"
    "pxGeHUb/h74JfQVHIrdgbuffovJOEmvtOSX91xA+0AF9Swr/UuF1xIRUPbMat+EG2Eb9ByEe"
    "FvL3EUo2AAAAAElFTkSuQmCC")
index.append('font_go')
catalog['font_go'] = font_go

#----------------------------------------------------------------------
group = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArdJ"
    "REFUOI2NkktME2EUhc//z/Q9HbVgAxW0FAygPMUgkLpo0KjRBI08Fi6AxGBgoQt15VJ3xsjC"
    "DXGFSDAhGmOUGCQYJdFEAsTSoJVaCyLU8izQznQ6nXFhQEWC3vU5X8499xL8Y65V2xrrKk2t"
    "Fj7KS5JGfjVC7/X06Zu7x8YkAGC2Ml88bqtsqdF1mw1RPSEqWDZBM9Pk4jil/NPBxecAQLcC"
    "FFqlKp0piRLLKexwXAHROQDCwpmP+jXNloBYRIpTxw2YzMXQ6JNhTj0HNacNoTl+6b8AfeIx"
    "78Jor0o4K6jODMrbwIR9GBjnh9c07O+GJldWY6E9vTUhg2cplUfFj+/7PFa51vhWE2Z5sETG"
    "5+lFPNTOGQouF5jct9wRsmaudzoqS7MyeuNx5Y9U/MECRIw7EY3HEBVFHDhRCE/Ij67+++06"
    "utKyfoWGcnuHnrfuSd29C4fK92F5RYAYFYHwLIynU8CkxcHY4/guB7HXkgmNlisKusOW9RVY"
    "NTzjqq2DVbsIo8mEdLsNYYMdA903EVRkSKoCSVEhIobh8BDC01F05tua1+O+jJS8kKYG/yps"
    "0pAEDSHQEAqO0cLKcIjPEsRiEvQa5VeJj2ecSa4xn1y9obAOtx1lGV/BsgmoKpCQE/AGvgXK"
    "Jo+0CxWfxn+WWPHg/JnyrNuXrpZwb14/grAqQVyNIbusDt5387jTOdAuSMstGLoQ3XhqJuNk"
    "W83R/OS2+qbDpkGBIGDMxTyXh3lTEfxBFnk5PHiFKRJDQ5aFL/3PNgKI+3qJLOU2MF1MNeYM"
    "KYCoQhYAKaZCFCggK6jheuAU7sLR8oRsBFCO50IBrx/TIxPQUYDqCBgDgd5CsS0dMEYm4PN4"
    "oNcom34rm9iefdawFHD5P4yXJpaZKjOvA0AARYGiyJga9gWc+33tAmse3wzwAyU+FElkqAp6"
    "AAAAAElFTkSuQmCC")
index.append('group')
catalog['group'] = group

#----------------------------------------------------------------------
group_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxNJ"
    "REFUOI2Nkl1sU3UYh5///5z29PMMCgxX2Og+iKihYwzQYQnOJgLRyCICMUZxgWjgwqh4YeKt"
    "Go0xwQuX4B1+RMxiIg4WMxfIGCq6OKQlY5NtbGRfltr2rGt31q/jhdnUm+l7/XuevG/en+A/"
    "5s2n/a2Hw+5TPj2r53K2Qs81+Ulnt+N4+8BADkBZDn55rz984qDW7nVmHUJYqGpR1q4vNOSl"
    "1M/3Jb8FkMsJ6stz+zX3Kil8T7Cy5nWEVgNCJbSZI4uZZQULmVxe1ryF29uAzbEab8WzWJtO"
    "E4vrqf8l6Db3DCWiXZbwlCM1L1L3oxjD9N7S+xcz6j+BF5vrWusDlaeKBXRVykLUHLzefaO8"
    "cMj1o81QdVRRYGQqyVf2uDN4MuiOfBDJiEX4SKgmvKOuuiufL/1rK31bkIxrDdn8AlnTZOu+"
    "em7ERvni4mdnNJk+sfSFF5oCnzr08g0VVet4sOl+ZtPzmFkTjLu4Wu5BWZ9HCeT5vTDDRl8t"
    "Nrtny0zE8C2doFrGdPOhw5Tbk7jcbioDfgxngN7295kpFchZJXIlC5MF+o1fMKayfL7Zf3xJ"
    "cCnT+N2jE30HRHCnkHaJVMtQ4sPcca7CLQSpiTTG5CzZ+QxzZhqzpOBYq/1dpCHvS49tKovv"
    "3uiYVoykQT41ycjtSd65uhq7NkaZXRJqfIjw9r3kbHGmUwNcHL/b+Zdg59ljLbu2vP3ka0ed"
    "HWNz/GSsoDemw/ZXWWmrJ5E4WwyHdklLgd3Vz/D97XNUra2iJ3K9Uq1+/PTBbXWeD5871uC6"
    "koDxwFMsZMGcgzsj8HDDOm52xhWb8LDvvqMAnAx/TEe0DcE3DuXy89ORpsaAdj6xgYmsh2LS"
    "opiEYtpifk4wOlkiNf0evgqVy6NfE6pt4d2uVtLzfxAdHDSlR/fExoZGmbo2jiZBagLFKXD4"
    "JGWV4MqMUymCXI38gB2VjmgbdqFy5dceQHykFlfce8CZGmsevXlrR3FW2e/VNUBAqUSpVGCi"
    "f3jslQfWnOmL/bb1y3MXHhFc8FqQxrLafm6beeNPtq4yC+MkvkEAAAAASUVORK5CYII=")
index.append('group_add')
catalog['group_add'] = group_add

#----------------------------------------------------------------------
group_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxNJ"
    "REFUOI2Nkl1MW3UYxn/nf07px2lPtxYbKGOUrmT4MbBCtoEkBknUqcvUuZFozLaEaMaFmqlX"
    "xsQLsxtjnDeaeTenwYQ4o1EzN+IXy0QXmMJEyCgDwte62nIobU+/zvHCgHqDvtfP88v7vs8j"
    "8R/z6pPBY91d6imfltUKBVvp+6vig68GHMf7x8cLAPJm5ucfCnb1HrL3e5xZhyRZKEpZ7NhW"
    "ihaF0L64kjoPIDYDNAcKB+yqX0i+R9kafhnJHgZJoWMXR9Y1mwLymUJRhN9A9USxOSrxVD+N"
    "1XiaeEJb+V+AAePByeTYBUtyBxB2D0ILIutTDF7XRtY1yj8Nz3ZGjjWHak+VS2iKEKUxY+LX"
    "gWuB0mHXjzZd0VCkErHFFJ9UJJxNLzWpo2+NZqR185GOcNfuSP2FYtH811ZaaxMZ121ki3my"
    "hsE9+5q5Fp+m75sPz9hFuncjhaNtobMOLVBXvb2GPW13sJrOYWQN0G/heqwKeVsROVTkZmmZ"
    "Bt8ObBXuu5dHdd/GCYqlL3Ue7iZQkcKlqtSGgujOEIP9b7JslihYJgXTwiDPiD6Mvpjlo13B"
    "4xuAbzMtF++fv3JQamqXRIVAKF7kxBRzTj+qJFE1NIH/8jBiKU7GqzIeDONorvm7SJOe5x5o"
    "9Cbua3AsyXpKp7iyQOzGAieHKokmf6LlZpqW/T00PPUi2yu9qLMxKxmbO/vXE9s/7nm8LfL2"
    "C6+0uC//cI7cWgFjLc/Ovd1M/vwHrZ/eld5/4jWPM/YdLFwC7xYSSh3DXw/eUOofOX2oNeJ+"
    "55meqOtSEmZDT5DPgrEGczG4N1qD/1zG46iqh4dPbKSjvF6NbEkh5bO97/cVbj8q903ESTir"
    "wLAo58DKW+RygosJk4hnK9lfvkT9vJd8bpkskF6VKcssCrfmjs9MTrN4dRa7AGGXkJ0SDp/A"
    "WwuuzCy3Au38NjTIkuFkVbaRSkpMzUtly7LeVcpbdh50rsx0Tv9+fXd5VT7g0eyABKaJaZaY"
    "H5ma6bjTf0YY9sax4dgeYUp1phALJuZ7+wbMk38ChvAxzDaOo/MAAAAASUVORK5CYII=")
index.append('group_delete')
catalog['group_delete'] = group_delete

#----------------------------------------------------------------------
group_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuNJ"
    "REFUOI2NkltIUwEcxr9zmTvb2Y7z0syltk1JJ5mYaHmrREvD0iIvDz6oEIIRRWFPPdpbRL6Z"
    "hg8VlGBEDyJRgmhgl5lmljnnFS/Lac7j5nY8O/P0EIqCWP/n7/v9/3z/j8A/5m6poaYij20M"
    "5bycKCqknkHyaWcXU9c+MiICALWf+UahIe9ambJdq/IyBCGDpgNkbJSU4idJrsPqegMA5H6A"
    "ZL1YomTDSCL0AkLM9SCUZoCgkZ2Eqi3NvoCNddFPmu+B1aZAwYRDG1kJOaEZzmVu9b8AXUKB"
    "bWX4rUxo9CCVWpCcARQ/jvd2bmBLQ+w01ObG1SQboxsDEjiaJKVhwTmUYDx1rDydUUg0BwJz"
    "8HjcoDRJWF/uAYT5qu0Qq7LNealmY7vfLzOyDAQ2ZTKcVBu4I5HUkD8MK347THo9QkwXYTh+"
    "How6Ag7bRNY2oDrD+Izh9IcjYw7hREYi1tw+CF4B4JdgLBCRYzZBZzgJ98IoKNELNRcBl2OK"
    "obcAtMw7cssroA9yQc2yiDYawKuM+N7VgDRtDHSmc9hwtCFITWDm6yjcgogQkae2Q+xeT30n"
    "zll3BYblLqQXnoEutgjCwmMQChcUGi02hRk892yADdrE9gWvHdlhuSPjUqn6g4KnOXj4Megs"
    "UQiOK4Yw3wRSIUFcM2G+9yPur3odB6ayWnyZY/a/X8hsu3o5I+7hzTupmr7eV1Av9SPf7Ifl"
    "dDHExScgKBECHwVn72dfQPQkWm59mt5aTJmKmsvOJoU3V9XmsFYfgfW5IVwyOBEgIhFwvwTD"
    "yvCtRmG2u99HS/zRhNvWqZ2vJ741pEqipZp6QZViWXUQRUP5KKtrha2tHgvTfVDGJGPjt4CY"
    "YBXirnfu6g0AkBpO45y2TWJhcAZKEhidWIL4owOm5BywbDxmBsZhdaVDrdy7tHRAF39FtTqd"
    "O/nTnh5Yo0pWbIt48KgJaRYjZqlYtPwqm6vUfmn10Vr7XoA/KwYW4QUt5wwAAAAASUVORK5C"
    "YII=")
index.append('group_edit')
catalog['group_edit'] = group_edit

#----------------------------------------------------------------------
group_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxdJ"
    "REFUOI2NkV1oU2ccxp/zno+c5OQcYz3LmpPWxLSxtRrbUHR0tJuhyMSNKfiFOOysIjqGDN3Y"
    "xa4G26XgjRdlsAuHUCiT4cQNLUrdhdTauCUu1dmGMkIiWWyauHz05Jz33YVY9abzf/08P3h+"
    "fw7/c1/tNY4cGFTONWlVzTRFa+IeuXB1XD45lkqZAMCvVD61wxj8ZJ9jTHVWZY5jEASbtLVY"
    "0QYh2pWp4q8AQFYCdHvNXQ5lDeGaPsDq0OfgHCGAE9AfwdDzzIqApYrZIKFvoKhRiLIO1XcI"
    "rHME+YK2+FqA8fp7DxeS1xjn9oI4VBDNAF+axW+PtPjzjPBy4Xis/Uh3sPWcbUETCLGS9Qd/"
    "jN/3Wvtdt8WSoEHgLMxli/hRKjg3n9msJM4mKssSh/pDg72h4FijwWTGAJsyohOXoa338XlZ"
    "gujM4dIcD3dsC7xt/nAyE/e3xqRry4CP+4I/yJo34Fvrx1t9XSg/raFerUOoFtC9hcPa0E5Q"
    "JYn7fBHhpjaIkrvncaLUtDxBYKVcbP8BeKUiXIqC1qCBkjOIucnzaPZth+aLwkiNIiUSxK1p"
    "lLJVXIwYJ5cl3qz0XjczU68I44oJeHQJqu6BXb6Mlk3DiD55CvsfYGnJhCzSF1/4Kde/5kaq"
    "YVVmbyP7VxLl9DTy2d/hjxwC6nHcuXARbk8NnkIB5oNk3p8Kf10T1I+eOXh79NjugZ5vPzx9"
    "1Pnz/L+YLHmQXqygJ+CGHlgFWr2H7J85+DqcUAMHYaQn/g6r6eGeT3+5y697f2Tf9og+MnR8"
    "QJmqcZh3bcCi0ol3a6No39QHnsbBrAUYXToYrUJyOQAx8kY5c7f+/Xhugr91OJfo6w06riwE"
    "kKm6YRcZNuYvY9s6HquNBmh9FgDD9KWHMLp0gFagNPciM3V94/A7+lX+i93rT8zkZPVOpgWu"
    "QAsY4bDj8ZfoiH0GIvDgxFYQuRP+6ACI3AlOaoOghCGp7Up+5sabgu3p2ONcnI+lZx5ttcv8"
    "LlVzwFZKmPzuIBhloA2LCZxpM5tSxpjNKAWjDKAUoKz5Pw4FMaMVIkTlAAAAAElFTkSuQmCC")
index.append('group_error')
catalog['group_error'] = group_error

#----------------------------------------------------------------------
group_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxZJ"
    "REFUOI2Nkk1MHHUYxp/57+zO7g4z27JkKLNL3Q4sUJEihVpbSWRDYmtqwqFfGmOg0Yj1oCYa"
    "D3rw4s2YND2VJo1YidhMeihpjPKRxvTQmiZIodnuit3ls8B26TL7MZ2dnf+OF8H2gr7n5/kl"
    "7+99GfzHfHlCPnO6mz9XKeqiaTqt3/4gl38ed59Vo1ETABzblT86Knd/eJJTBY/uZhgbLEtJ"
    "XdBqKxEiXr+T+QUAyHaAVsns4Xg/YSrfwE7lMzCcAjAsOlvQu5nZFlAsmCWifA1eaIPTXQWh"
    "5m3YTQNIpcWN/wUYN47EH8+M2kyFBMIJIKIMh/YXbs6Kk5sZ9unC+5H6M62h2nPUgsgSYs0Y"
    "sbvj9yTrlPeWU2NFsIyFBw8zuOpKe/Z9uo+f/na6sCWxt1PpbldCaqlku20boGWbVBGvLDbU"
    "OO6W/LAqO7CMAAqtVZDqAuGZpclAbcQ1ugXoOxT6wS1Kz9XsDuDgoeeRzT2BGG5HdXMXynWP"
    "4Lf3gGVZ/FmaQjAdRtjf+GI8Ol+5tQJrayuRU6chuTLw8jxqQzJu5esRCoXgXPZAqpZACIE5"
    "dxDBxiDmry/g8gvBs1sSbxTax8ylO88I8+MRDMNAOp2GqqoYGRmBZVnQdR0FTwG8y/r3keJC"
    "/2tNvvSrYfeKQ8touJ0NwuvfDVmWMTExgeVwFI/FVXApAe37O8BRDr8mXf+c8fBP7/VEXvmi"
    "5ePzzu/oYVxcb4CmaVhfX0exWIQkSbjwTRc/8NYwA8pouVwOi4uLSCQSYPYcGzjZUR8YfOeD"
    "173TNsF8HijqQDlnQtm4h2MNFvL5PGLxWatMSwVFUXyCIEBV1Uu6rn/OXnv54rC5t88xHEsh"
    "7dkFGDboE8AsslAwA2AvVldXcaBjP2sYhi+ZTMLn8wHAu9lstp+tECtSk/FEzcPiPITOXShx"
    "DBwA3DyD6IqE3wcHUVUhg1KKtbU1xGKxN8fGxn6klI6rqkpZuqPxuGdjLpK4P/sSzTp6BJED"
    "wADlMhbK1VhKds190jz6/dRU5qtUKoWhoaErAK5syv8bPP87hP6uga4AAAAASUVORK5CYII=")
index.append('group_gear')
catalog['group_gear'] = group_gear

#----------------------------------------------------------------------
group_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwlJ"
    "REFUOI2NkVtsUwUcxn/n9LSn1yO72GwdxdLVAMOtoAQdlphlgBKIM3HAgzFjiRHhAR80MWp8"
    "koQHY8KbIT4oXoJm0ewBzbKMixLxQdm0LIWuuzDQrmzT7axde3quPuimvkz/z9/3y/f/PoH/"
    "uDe7I71HOgNnapWyoutu85sR8aOvh7zH+zIZHcC1lvnkU5HOE4fkvpCv7BUEB0myxOb15nZD"
    "FJULPywMAIhrAZJhvUsO1IlC7UFq4q8iyHEQJFKt9Kxo1gRUl3VDjJ8iENqO21tPqPE5nM1n"
    "mZ1XFv8XYEh7Mvv7jUFHCIYR5RCiEsGljnM1pwyvaKR/Gl7sSPQmY9EzlokiiaJ5Q7v189Bo"
    "2Dzs/96tSgqSYDKRX+ALz7yv7ZW2QPrd9LKwYu5JxTt3JjYOGob9r1TKjjaW/fdTNqqUNY2H"
    "9ycZnZ3k/KVPzsli8cTqCkfbYx97lfADjRuaeLS9haViBa2sgTqH/5kGssVLLMhjmDUeHqxL"
    "4PYEtxXSau3qC5KjznQcPkLYs4A/ECAai6D6Ylzte4eCbVIxdaL1W/jp+gBqsoKar/Jpa+T4"
    "agJfbE/NExtKB++LbhZk2ctrN9/nu3uXmairkM/niKxr5qHILkp6kZHMRTxWEwd8+t8l9s+k"
    "6joy42b3X4WZts7erT1Yjo1lW9g45NW7tK5/nJJe4fp0vzMZ2HPsT8Cuz17oak+80frySfcH"
    "335JRdXRhH4sx2b6txyGbWLaBoZlsFQtsi26m5JRFnqnvnpP2Hjg7KEdiaYPn39pvz/tiEyX"
    "oFoGK9fC08ljmLaFaVtYjs2MeofaYAMjd68xeGtgTrfYJ6TffsTUtxx1nXd1M+9rAM3BrEB5"
    "MYGm6+i2jmbqNNe38Fh8Hz/eucZQdrCgW3QWTpORgkpwdjg72ZivThNKNWDIAi4gGJggIIIx"
    "OsWmuc+5UH0LQfRxZezir6ZAZ+E0WQDJWrfpWd/i7Y7Jm7md1pKrK6TIgAC2jW2b/DI8fju1"
    "dfycWrVevzx2xVOF3fdOMbVS/h/reUzNKSf+zwAAAABJRU5ErkJggg==")
index.append('group_go')
catalog['group_go'] = group_go

#----------------------------------------------------------------------
group_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuJJ"
    "REFUOI2NU1tIFGEYPf8/485eR/OyuWvmukpW5JqsF5QV2oQuJFmk9RDR/WJJPVRPPRa9RORb"
    "+CKZRIEVPlSKSVGBBgtKq9mKZhllZWs67s7u7Mys04NoZWF9z+cczne+8xH8Yy7U2A/uqTQ1"
    "JPMRXpYT1Gd99OajLn1d6+CgDADMUuTTW+yVJ2u5VoshoidEA8vGac4KtVChlH/gm+oAALqU"
    "QIFVruZMKZQkV2GZ8xwI5wQIC08+9s9jlhSIibJCnZdgshQiQZ8Ki20vtNWNmAjy0/8l0CVt"
    "Hvre36kRsxWUs4DydjDCCF4M873zGPZXwjFv7sECR2ZDXAXPUqr2S4FXXQNWdbexJ0FgebBE"
    "xdvxKdzTBQ2usy6T/6pfJPPk/R5nZUludqeizP7mii9yQTSmIapIWKUNIC/bgD6Fw+Xe7maO"
    "hk4uXOFAmaNFz1uzbCszUFq2FjOhKKSIBAjfYNyRDgcZQvmqTNiLjyLl20sw+vT1wwEleWEF"
    "VhM+e3fvgVU3BaPJhEyHHYLBgRetV6D7MopiXo/EvCKIY+0wmJzYPtuPTVnGugW7T0X3Y/mj"
    "74/APhhSYIuGkZRfhXhkGPpUO1gjsHJDAYxJ9GeIbZ89Kd7BEbVmUWAtfgdsGf1wTb0HZYIg"
    "VISODwJSBKEvkjQXYvmdIzvLcq+dOe82dz+/j2hYhhSOwZ3vQs54I3R6IZy9Tmdm6TQItWBW"
    "kRG4MyQNBoRDJHtbY21RbsaNfSe2Gv0axVgYiEWA1RMPURG5C/fGMmhyJ0g8hNftgsjMxMMM"
    "IRgY+Xpqb/OHe8R/0a3Kaw4wt5kaBA3pgKRBjQL1tB6FFaWQg9fBsokIPBHh6/l0eHlopjU1"
    "FfA0TYYAgDXz5oneoVHbeGwMFk86FI7MfZiWAMJ8AsOlwd8hgBEJjt9617S4rWw8KW+XYfq9"
    "d/TNcEl8hqm28BwAgmdcEsikD9MTMfXjuK7N605r+1vdfwDl/Rj9aQM+NgAAAABJRU5ErkJg"
    "gg==")
index.append('group_key')
catalog['group_key'] = group_key

#----------------------------------------------------------------------
group_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxpJ"
    "REFUOI2NkltMEwkYhc/cmLbTmdRuaW29UArsrpstiMELpkYJRmh04+qCsl4WSYxGQ3zRN199"
    "IcZ4eTDRN2/BhIgxUTSkEW9RdCOrWK66LMR0KG2z7cBMnU6nHR8MqC/o/3y+k/P/5yfwjTne"
    "4GnZWcudsQtpQdMY/eE/5OWukOlQx+CgBgDUfPCRek/t4Ua2gzenTQRhgKZzZMlivTJLksLt"
    "v5P3AICcz6DCqW1luR9Iwr4FC3zHQLA+gKAR8KN5VjOvQUbRsqTvBDi+EozJAd69G8bPFxBL"
    "CKnvMgipdSP/v+k2CKsTJMuDFDygpHd4/Fbom9XQXwIHakpbKrxLzuR0CDRJ6m/U4dehsFPf"
    "YXnGSLQAmtDxr5jEjYKEufxoOdd/ql8hZuHmgK92VWlxdzab/yqVUFUOxVKIdDaDtKpiRbAC"
    "4dgY2u9fvcSSM4fnWthX7b1iEpxF7qWLsLr6F0zPfICaVgEpDsvvC0EtzoLyZjGlR1FmLwFT"
    "YF0e7ZfscyvQhjRZs2MnnAVJWDgOS7weSGYvHnecRDSvQzPy0PIGVGTQJ72EJKZxze85NJfA"
    "7N24YP1SeQvrKiF6h+PoGkhDnDbwTjKBKTRAkATUHhOKlV+RGTCQTKawgZc/P9IIf3DTj3x8"
    "/eDwABUnF2HX7j3weDxwOFwYej6B6QkNe7b/hRJfKRx2B4yUga4XE3c+HXHt9f3bqktP166T"
    "reNPu7Br716cO38RiffjcLsXwu/3Y3JyEolEApFIJCcIQndra2uws7NTIos3X2hsXGk927K/"
    "0vrk5Svwgg0AkK47CVnNoqmpCYFAAMFgEPX19ZBl+YMsyw0AYLPZWPrWmovt2rJ9VPtwDNOk"
    "G5HoMwBA7m4bCCOHtrY2cBwHAFAUBRRFsQzD3ASASCSi0lbBGusbGXOLmQnYy6oQ++8BQqGH"
    "2L6xAuY6P6ampjA6OgqWZVFUVASXy8Xoul7V29ubEkUxSudsP/1hTo3XjA29XZWTiK284zf0"
    "PLoGt0OAqYABjLxh1qRbPos29Do80xoOh5lMJsOKohhXFOXPjz/OPOYYI4REAAAAAElFTkSu"
    "QmCC")
index.append('group_link')
catalog['group_link'] = group_link

#----------------------------------------------------------------------
heart = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoBJ"
    "REFUOI2lkz1oVHkUxX/vvYlmZsmYCevC+EmMorjqQAyrmBSKlYWI2gkW2qio2CjauiGF2y6k"
    "20YWYWHZzmQXFFRCDGsGFBUNxkTQjCFOwjAf773/u/8Pi4eiYBM8zTnFPefc4l74TnifhBsd"
    "3WqMOWi17nIir8NMZrRw9GgNoDY8XLAiJ1ySXNNKzVilfisODt7+HKBHRi46ra972ZUF/ADb"
    "bCC1+nMnctJEUcsa83dbV+fOlZt7MI0GrcdPaFXm/2xbXDwbyMjIYU8nN4OtW7J+oQs/lyMo"
    "FsHjp+T9/CEjcizb070jt307fhSSaW8nWyphF6u76h+qLuNELgTr1uCFIVTmwVjQmrbu9QR7"
    "eje4OCFoz8KjMlgLItCRI9+/j+rE/6cyTuufyedhZhZEg7NgDLx4hb8qD4EHU9OAhUSnXF3C"
    "67GYOM5nbJKswBiIFSiVBiSShsxVQOu02VpwBpSANSAJJklsxojUndarPS0QR6BNatY65S+1"
    "1mA0ZHzwfYxSvu+UuqunpmDdGmg1IYogjkFUykmcchSlBY0GbNlE9d4DXBzf8o3Ijeabt2/i"
    "d3NQ2gkrgnSoGaaGMAIVQ9iCNh8G9lBbWGLu9uiSs/ZXD2B+aGgXIn/kCh19P+zejb9Qgcmn"
    "4Hnp6mEIpW247s0s/PsflQfjz6zIub5yeezzJS5dvbqqpdRlmySXCr2ljo61RRh/CPUmDOyl"
    "vlhj9tZfiVVq2Go91FcuV7865U+YPn26z8Xx752bNu798eABMJrq2Djv7t6fcSJneicm7nzz"
    "F77E7JEjnaExg1bkfNf6orfwcvofieMrv0xOzizr0x7v33/8SX//pWWZlouPpaVvBRkdKI0A"
    "AAAASUVORK5CYII=")
index.append('heart')
catalog['heart'] = heart

#----------------------------------------------------------------------
heart_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAspJ"
    "REFUOI2lkl9olXUcxj+/9z3z/IkdPQesHdlCtw6m6U66kTUNhFoQKEuFLgZdKATh6n6xbmIJ"
    "InjpuVIEEYMIrKgzGBPFosT+aGsrxtbOhbUO7Wxtez3n/fP718WLMjC86bl5npvv5/lePPA/"
    "JR4EOza2XWv9ilEqb6X8vZlIjOWOHFkBWCmXc0bKQRtFwyoM500YnimMjn71EKAqlfesUh+K"
    "dDKH42Lue8iVtWkr5Vva9xtG609b8pt2J5/pQnsejbs/01ioXW5ZWnrHlZXKYaGiS+72YtrJ"
    "5XEyGdxCAQRPRn/VXtdSHk13bduV2bkTx2+SSKVIl0qYpXr32mLdJqyU77rtWxDNJizUQBtQ"
    "ipZtHbj79j5tgwg3lYbvfwRjQEpozZDd30f91u3jCavUc2SzMF8FqcAa0Bp+m8XZmAVXwMwc"
    "YCBSsdeXEV0GHQTZhImiDWgNQQhhGAMiGUP+XACl4mZjwGoIJRgNMkJHkUloKdesUpuFkhD4"
    "oHR8rFTs67NSoBUkHHAcdBg6jg3Da2pmBtq3QOM++D4EAcgw9iiI3ffjAs+DYif1GzexQXBF"
    "rJTLndr3r2W2dmxNtT0F07/C4nI8DqMffjGeWmQi67EqG0i/wY6pf/z+aktRANROnepGyguZ"
    "XGvvEz09OH8vwA+/gBCgNV8ma/y0y6FnRy/t+SLXpz/j1tTXVOfqZx2AtpGRyQ2+/+pq9d5H"
    "f1z5xPOWPXj5JXAs+E2upms8/2wJ7WhKhX60kLy4uw+wQ49se+7Eid7ZwcHvFj9439rr49ZO"
    "VOyhkT22MnXertcXk+fsvqGCFY8QgOrAwKam1qNGyqF8R0G8mZzQbwy85ioMw/0XOT1+nJSb"
    "5OOrnwf/CXiguwcPHhNStr9dmt/c0blxpK/7AMW2PczW7vDt5Dfcq66efSxgvV442XYaIU4K"
    "aLXgYW35drk2/C+/T4u2uxWEOgAAAABJRU5ErkJggg==")
index.append('heart_add')
catalog['heart_add'] = heart_add

#----------------------------------------------------------------------
heart_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAspJ"
    "REFUOI2lkktoVGcYhp9ziclMkkkmeOnYTGOSRsFbIAZa7EbrykUrqQtR2kXtooW22IWgUBAl"
    "6EKXQly5EVEobk3oJSCmtKVVjC1pCJpEbDIdnEkcZzJzzn/+WxfHDILFje/mfRff97zf4oPX"
    "lLMa7NjYFq31PqNUh5Vytub7Y+mhoRJAaWQkbaQ8YqPopBJizghxPjM8fLMOUKOjX1ulzjiJ"
    "xjSuh1mpIEvlKSvlJzoIqkbrGw0d7Tsa3+5FVypUJ+9TzeWvNiwtfeHJ0dEPHBVd8bb0Jdx0"
    "B24yiZfJgMP66N/8fi3lR4ne7u3JrVtxgxp+UxOJ/n7MUnFnuVC0vpXyK69zI06tBrk8aANK"
    "0dCdxXtn4C0bRnhNCfjjLhgDUkJrktR7uyn+9vunvlVqG6kUzM2DVGANaA3TD3DbUuA5MPMQ"
    "MBCp2IvLOL0GHYYp30TRGrSGUIAQMSCSMWQxB0rFzcaA1SAkGA0yQkeR8bWUZavUOkdJCANQ"
    "Ol5WKvYXs1KgFfguuC5aCNe1QoyrmRno3AjVFQgCCEOQIvYojD0I4oJKBfp6KN66jQ3Da05p"
    "ZKRHB8F4clN2U9MbG2Dqbygsx89hdP2KhcIkC4V7VJ8+wWtJ4T9rqbWIzGYHIH/27E6kvJxM"
    "tw4279qF+yQHd/4Cx3m+fJ+n6TJ9ew/S2L2N4M8fmLr9o3k2M/1N/ROXT5xoqwpx3ETRsfRA"
    "f2vrmxn45VcorzDxzw0GPztOYvYWLP4Mbe0U/S7ufj8xXwes6uHRo4M2DC+293S9u3bfXtCK"
    "8XMf8v6F73AGhupzpdMZ7kwU7UsAgPkDB9prWg8bKb/syGacqUfXg92HP040P76JCPLUgErZ"
    "Y3qWxf8FrGpyz56DjpSd5c659JqW5m+za7XvuwtUCopHeU9HoTn1SsCLmjiUPVlbyn3uGqfL"
    "uHbRYC/t/8mc+w+87YLt4Z8WzAAAAABJRU5ErkJggg==")
index.append('heart_delete')
catalog['heart_delete'] = heart_delete

#----------------------------------------------------------------------
help = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqNJ"
    "REFUOI2l0ktoVHcUx/HvvZlJhAQTY2ommYJJraSYQq0oimiliyJ24yKliK9YcFVwI267KJRS"
    "SlcVN4L4RESJuNBaCGiLTWlLbbWOj9rG2Kh5ODaTJvcx997/OacLcUDFlb/lgd8HDvzgJeM9"
    "e/jhdrxI8Dab6nYxK6gaKjahKkfMcfz95S3DLwQu3Az7VNnb1Zbr8EwQEQB83ycVuH4vGhfR"
    "XZvWtA88Bwxem+lzxuE3CvnG/4KYm/dCRv8NETUWNNfTW5xLa8schm5VQhXt3/le10ANOPvH"
    "9Gvm7NKSYkPnZCVisFSmoznPhrc7MYxf/65weWSKdT1tFNsaGbz6cEwTXbv7g547PkA1Srd2"
    "v5LvnJ5N+PbKJFGQsGXtQlqb6pnf1MD6pe3Ue8b3NyaZmk1Y1t3cGWbJVgAfIE7ctrxvXB2Z"
    "Jq6mZCpMzaZcvDbBL3+V8YB3etuYDkJ+G3lES1OOIE621YAoTooext3yDE6E1KV8MXAF31Pe"
    "6prHTJQx+jBAnHJ3vELO9wnipAiQA4iqCWbgDFKXYGqYwZolBSpBwlenfqeaOgxwnmKeEUUp"
    "NSCI0gepyOvFljnMzEaoOlSVPfuHAJDMgSmG0VGYT5xkRNXkQe2FIE6PjpVDlnbPI+89Lpgo"
    "n3+0is92rMSpw5nimbCip53b/1QIq9nRGpAk8bEzQ3fGcj5sWP4q+ZyHcxknLt7i5Hd/Ph6T"
    "ZqxfuZh8nc+h86WxOEyPPTWk/i8v9GVODn+88c3GTJQfS/cZnaigTim2N7O6t0guV8enB38K"
    "1aT/0tebBp4CADZ+cq5PTfZ+uG5xR8/CVhrq6wCIq47ScJkD35TGFd31874tz0/5Sd7dc3oR"
    "KptFbLuoFFQNEZsw9IiqHL+8f8fws52Xyv8gtnY01523VQAAAABJRU5ErkJggg==")
index.append('help')
catalog['help'] = help

#----------------------------------------------------------------------
hourglass = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtRJ"
    "REFUOI11k01oXFUcxX/3vjfJzCSTSRoxDalK0kXK+LFQ/KC6tB+0ouBCXNiNi+JC7MJtQVy5"
    "cOHGVUCKiBa7Me4aWhFSihFqsdJOQ2Kc1BDnw0ln3pv33n1f914XaQtac7b/c87//A/8BUDj"
    "3EfFGP802CMWURPWTllBKUsTqdSAKPJMEHoqCrx2pLx6FAWX/na6Cx9/SewCKOtfLk8/+vJQ"
    "dQy3VES6LtZYdJKh4wwdJzJT8Yjy/bn+Tmuu09p4LWv88haEr7gAtlCqcA/WGHSaYVKNTnNy"
    "laDjjFSlZHGKyfNdYqFSgRABsHxzszbibd6q+mskvS3C3l8Efpcw6BOGfZQKSPIMWRyjsn+e"
    "wcTzqOozT545daIu7m/+YS25OF7i2BPjkpFhByEgTA0tL0NllskRB2Ph9pbPZjNYev/k7HGA"
    "BwYAS/XoO2vNG4emCuKRURc/NnhKM+wKmr2EG3/0bK714gcn5968r/mXAcD317yXrLRfT1ed"
    "uemJYXJtWd0O2GwPfs+0PXXmxOzKfzX/i2+udq5cvxPYa42B/fzi5vJePLnXQAjrSrkb0eTm"
    "oaR7nnD+avtwscD5g/vLj8/sK5Fqy/X1u/zWuLuhtX3n7Nu1lT0NvrrSXCy64vXnDlbF9Pgw"
    "UkKSWfqR5taWx083tm2mzeIn7z77cInnlptLByaGjtYeqzBecig4Aikgzi3rnQRXCoyx/Fxv"
    "cruxs/TZey8cf9DBhcs3a0PCHi04koIUFByBI3e9c20pFyTGWLSFyWqJctE99uGnF2oALsBT"
    "f36xYGbm6btPsyHnOTBZZqzssuMnrKx2Wdv2CKIMrTUz+Tqz3R8ZrH67AOz+AsCo6bHP/ooT"
    "1iEURKlmKM05nCS8OJqROjFx4DMIO3STOwzu6VyAkhh7VbU6p1WrfSRJk5pS/pSK/FIY+jIM"
    "+0Shb1TsqzSJ2xbqQnKpXwwXAP4B5hJ7p7vb+DUAAAAASUVORK5CYII=")
index.append('hourglass')
catalog['hourglass'] = hourglass

#----------------------------------------------------------------------
hourglass_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwBJ"
    "REFUOI2Nk01oHHUYxn///8zs7Gc2TUuTELF0K6RdbapIsK71YomWVix4EDz04MWLHz146U0E"
    "D9azBglIENGCCFYEabQ9mH4YpJY2bWNJjFkbmk3a3e7O7M7MzuffQwzkEMTn9L4Pvxee5/CK"
    "pcn3013sN0GNKURZKNWvBJkw8KXntXFdK+k4lud2rDXXs+Zct/PzA60+8cEXdAF0T9nns4M7"
    "n0sVe9AzaaSuoxJF7IfE3ZC468vQ6+Y82y61Gqul+6uLL4dLv78GziEAXRmZAv9KJQlxEJIE"
    "MXEQEXk+cTck8ALCbkASReugUSiAA4CYvlUt56zq7aI9j99cxmmu0LHrOJ0WjtPC8zr4UYhM"
    "91AYGKa9bRSvOPL4yRNH5wAEwIV5/1xvhpd29UpypoYQ4AQJq1aIFyq25zQSBX8s21Rrnam3"
    "j+0+spFabAxTc+53SiXH9/YbYkdex+4mWF6MqQtqTZ8bfzVVFMdn3z1WepVNEpuX769aB5VU"
    "Xw0WtdLgNpMoVty516G61v4zjNWJk0d3z/B/9PXl+xev/d1RV5fa6pNz1en/YuVWphBKl3I9"
    "XhIlYitmywpnLq9V0gZn9gxkHx3qyxDEimsLD5lderhYr392IYjWXvdDr2A7VrvZaXw8dfrm"
    "h9rG8ZcXa2dTGqefKhV7d+3IYBoCKQTFvMnC8o99pBeefn70WfPw6BFCs2HW3bsv5B7TChJg"
    "cro2NdCbOl7Z1yf6iyk0CZoAKaHhRswufMuTew8Qy5gDg2PEIuTg/gqg3pLfnL9VTgn1oqFJ"
    "DCkwNIEm15tFsSJrSB5YNQyR55V97wDw3uEJ9uwcQSDS+hN3P59IhoZp6ftZlMM8sj1LT1an"
    "YfvM3Kkzf8+iabe4vXKFGyuXODU2yUc/vUFaM1Gorg6QT5r0qetozhw4AjeISQURFd/nmXyI"
    "PlRmZvYKlZFD/HBznJTQuXT9F0B8Kja/sx/4Zc+z+z3XzjiOLR2nhevYide1vV8NwkUzlU8k"
    "uoI2So3/Nr566h8M1n0LlpqTNAAAAABJRU5ErkJggg==")
index.append('hourglass_add')
catalog['hourglass_add'] = hourglass_add

#----------------------------------------------------------------------
hourglass_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwJJ"
    "REFUOI2Nj19oW2UYh5/vOydtTtI0aTdtw1Znu4uOTIdDRaneCG7OVhS98MrdDvyDQy+8VW/E"
    "W0F6MZAhogO9cBOEtUaQxkHBbcyxxdKuJnW2TbN0SU5yzpfz9/NibuyiiM/V+748vPx+onL6"
    "w2QP+wToIxpREFqPaIEV+J5UqoPrtuOu01Zut73lqnbZdbs/3TIapz7+kh6AqbRdTOUffKYv"
    "O4hpJZGmiY41kRcQ9QKinicD1Usr255obdcm6rXVl4LKpdfBeRbA1Akrw7/oOCbyA2I/IvJD"
    "QuUR9QJ85RP0fOIwvCMmMhlwABAL16qFdLt6PWsv4zVv4jQ36NoNnG4Lx2mhVBcvDJDJQTKj"
    "k3SGnkRlDx08eXy6DCAAfl72zucsXtiXk6T7DYQAx4+ptQNUoNmVNog1/HHTprrZnXtnZvzY"
    "3dTi7jBXdr/XOn7lwEhC7B4wsXsxbRXRbwo2mx6//9nUYRSdfXdm4jXuQ9y/nLvYflpL/XU+"
    "a0zkh/oJI83SepfqVudGEOnjJ6fHF/k/fHOhXrq81tUXKx39+fnqwn+5cqejENqU8k68OIzF"
    "Ts6OFc5c2JpKJjizfzT10J5hCz/SXF65zdXK7dXHim/PJzd+mwkdNRZL/bdGzx4rxp/ee/BV"
    "afNs0hQvP74/K/K5fqQEL9C03IiV7z5j+MY5Djz3Kv3jB1FX5ymX5qPW0tJ7AuD0wubc3qG+"
    "o4WxDDnLIGEIpIBeqFmpe2x/cIipN97EWv0F1n+FbI6GuY9Lc6WK+W3xWiEQ+mjCkCSkIGEI"
    "DCnQWhNGmlRCsl1fIzk6DtPv36trfpTH0OJh85G/vjgV75mkZT7Kqpxk764UgymTbdtjcanB"
    "8nqbw+nduFd+JP3DW3iqhgt0bIPIYMMEGIibDOsrGE4ZHIHrR/T5IVOex1MDAa3DT3B9scTY"
    "sIVpJOjcCqnWRKR1PGtaYvB5VaufULWtI57vFZSyR5RrW45jS8dp4Tp2rHq2esCXXmOtmewL"
    "sSJDbmgdz75YjD/5ByB3j2+JD2IaAAAAAElFTkSuQmCC")
index.append('hourglass_delete')
catalog['hourglass_delete'] = hourglass_delete

#----------------------------------------------------------------------
hourglass_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAx5J"
    "REFUOI1tk81rXGUUxn/vnTvJzORj0jSYhE6/UiR1aqsgYrFRXJhYUlEs2IVQ3HVjsAv/AFGE"
    "KujGZaFULVrQhXVnaP1oM8H4Ua2Qjpo2Jk1MM0kaM3Nz733vx/vhogZC6W91zuE5Dw8Hjpg5"
    "+2YuwjsBdtAiysLabivIp0nsSLlOGDaMHzRk6DeWQtmohqF/cSVz5/RbHxMBuNJ6lwq9Dxxq"
    "Krbj5nM4ros1Fh2n6ChFR7GTyqhFel5ffbXWt1ybfj6duXoMggEA12bzbfyPNQadpJhEoxOF"
    "kjE6SklkQholGKXuCrNtbRAAIK5MzpZbGrPXi94U8do8wdptfO8OgV8nCOpI6ROrFCfXTltP"
    "P+tbHkcWD+w7eXy4CiAAvpmKv+7I89zODoeW5gxCQJAYao0UmVq2tmQwFv6Y95hd9EdHjuw+"
    "vJFabBSj1fBLa82Le7uzoqvVxYsMDalpdgWLazG//71mldYXXj/Sd5RNiM3NV780DlrHftpb"
    "zPT1bmlGacufCz6zS+s3U22PnxzePcE9iHsHAJ+NL4/tLRUGjLFM/LU6NnJ419OvnXsiSFRS"
    "qLc0F744NiE3tM79DISwruPcdTfKCACpYkpdD+H8Ww9f/qCUv2+C8+NLT+aynN/TU9hxZmwY"
    "axWJTomVYlvngxwoDfDT7Ldc+2fCpFlTvDyy4rsby+fGFi+4jn3hkV1F0dvRjDIJg/teRVuD"
    "NhqD5XZjnv2lQ/iJdK7OXW489i6dLsDZK4ujPR1NQ+XtbXTkM2QciFSCtoZbqzdIjUKZlFSn"
    "ePE6j25/Cj8NnR9nKqvu55cmy6mwQ9mMQ9YRZDOCjCOIVITSiu72HSij0daw2Jijs7WHX+fH"
    "qUxXVhLNkPvw3JnTZls/dXc/004/pa0F2gsuUsV89MP7JCYhUgl7usoc7Bvi51sVKtWLSQTP"
    "1E5RdQFazRqd9hqZoAqBIEw0H5bf2PQLEa9Mv4Nw8vw2VeGlhdzke5/IKoCbF+3PytryCVlb"
    "GoyTuCyl1y1DLx8EnhMEdcLAMzLypL8zLXw39b04utD0dk7IUxvH/w8F1rFQtwE5QQAAAABJ"
    "RU5ErkJggg==")
index.append('hourglass_go')
catalog['hourglass_go'] = hourglass_go

#----------------------------------------------------------------------
hourglass_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxBJ"
    "REFUOI2Nk81rXGUUxn/vnZuZjDPJzCSxk0QlZGYRSY1YpEVstqlJK4gWZIx0q5vQ/AOCiEjJ"
    "VsRFRYqIH4ikFRQS+rFInZpFqwmNsSaNmTbMvZlkdD5y79zv+7qokSyC+Fud8/Ccw3MWR2xe"
    "erfdpvkWyDGJGBZSZqUg7rmOYll7tFqN0DAbVstoVFpWY7XVMq7uRqoX3/sMG0C1ZPPaY31H"
    "TkZTnajxdhRVRYaSwPEIbI/AdhTPshNWs5mr/7md29neeNnbvPM6mKMAqmyLd/APMgwJXI/Q"
    "DQhcH99yCGwP13LxbJfQ9x8Z2zo6wARALKyUhhON0q+p5hpObQuzpmE0q5hGHdOsY1kGju+h"
    "tHfS0TvEXuY4VurZo9PnTq8CCIDra85cOs5LA2mFRCyCEGC6IdsND8uTdCcihBJ+22pS0o35"
    "qTOD4/upxX4xv9q6LGX4ytPZNtGTVGnaIQ0rIKYK9JrD8h816QfBlfNncq9xAHGw+e524wWp"
    "yC/6UpFcXyaGH0julQ1Klb37XiDPTZ8eXOT/8GVx5+bPDwx5e3NPfjRXWvgvr3KYKIRUFeVR"
    "vNAPxWGeQ0/4qlh5UZX215Z+96mdB7/T1ZWhrO8SHDledt3W20L76cN8Pp/TNK2madqF9fX1"
    "jyP7w5/f1K9EpD+jLc+lnOYOk5Nv0N/fTybdyfbGUqdn1CbfLJxN5fM50dPTE3ddd6xUKrUJ"
    "gEsL+vyTmeipva0l7hRvcLZQYP77H7h1q0hvby8jIyPouk61WkXTddmRTM5NTU1NzM7ONpRv"
    "rq0MR4U81RZRuLeyTCKRAOD89DSu51EoFBgdHWViYoLx8XEs2xXdQyffAUin0zH1mYefXgyf"
    "GKKujqC0p9A3HgLw/gcX8D2fmZmZf5eapokIfcyVy9cZO0a5XLZVgGRYo0suER00+OSXCsUb"
    "Vzlx7Cgnnn+OSqXC2toasViMgYEBstksbquZXFxcrGuati0OvrPlWMObeq3v27tmvLM7SzQa"
    "QwKZ+o+O4pl/VbvHHkeJSMdxXU3Tdk3TfPVvu++WlhFH88gAAAAASUVORK5CYII=")
index.append('hourglass_link')
catalog['hourglass_link'] = hourglass_link

#----------------------------------------------------------------------
house = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr1J"
    "REFUOI2VkktPE1EYht9z5sxwa2daKNdpsbQgWgPGhYkLIKIuMCpKDLrzkrBy4V8ghJCQuNeF"
    "hsS4w+gKDYlEwqIJwQ1IIBihhHvbKe3cWmAKUxcG5LrwTb7V9z1P3uQcgjMy2B0ShMSeByiE"
    "5dlJPOqZtU67I2fBBRpdJJQWU0bAMS6p8ds1p0lOCAa7Q0KhwcXFSlkS5QAIx5COryCdXNdS"
    "tlF2XEKOw44MH3dWeCXJV/d3TTkQToAWnYceX9FMWzsiIYdhcUdQHBU+UZLPw4gtwkzFkKME"
    "Ba4qOMvrsbk2B3VjRbfz9NJ9Cd2HXVa+Ilb6Rcl3EUZ8CZl0CnLHG3jvv4aeVJBYmkORJwDB"
    "USEa0XxlsDMkAAAZ7A4JLrtAcZSdE51yPbTYPDLqJopv9aMmEASlFJuJOCbediG/0AWpqhpr"
    "v+cRjazrabpXSt25ojFHhV90ei9Ai0WQUZMoa3uFQLAWlFIAQImnDFe73iG2qmB59hek8lIU"
    "uiXRSuyOkW+919pyhHzJL66mamwj1/h0gDgl9wF8OKauYuBFOySPE9FFxQax73AfRlfnHzd7"
    "J9KG5l90dVS3XL9BbNtGX18fwuHwwTQ1NaHI4cR0wkLsx/gMwe6z/rGFYQoAd3vGhx/0jjdb"
    "u3Y6m80CADiOQzAYRF1dHRhjBy1iSgKr8pWH/WMLwwDADlfMZrPI5XIAAMYYeJ4Hx3Hgef7I"
    "jWX9+0vs5ciTRtPcbjC0redTykTB0JQPdy+3g+M4CIIASikYYyCEYGj5E7SWKEhq6/PtptaP"
    "RjI9yUzT+ioylyxXe6GWqPg+OYLW2ptHGjDGoOs6Ztdn0CBfglashiIrS93rkWiadL6/N2qq"
    "ZlBLGWu8mhcSdySryvbpfr8/QCkFpRSEEITD4Qj8e+K223Tqu+ZPQzcDGX1r+sRT/W/+AMQ9"
    "K+rq3YxEAAAAAElFTkSuQmCC")
index.append('house')
catalog['house'] = house

#----------------------------------------------------------------------
house_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAu1J"
    "REFUOI11k0tIVGEUx//fN9dJ53FHp8nGeagzZtJYFrRI0KhFhQsriopWSREREa2DApOIohbt"
    "ahFEbSUowkIiCsF8EYIVIejkY/IxL2fu07mv77YIo4f9l+ec349zFofgP+ntTjidOSsAuKAH"
    "tNypnq/6enPkf3CFQGcIpX7KETg4x4pQVoqtJ/lH0NudcLokR4avCfv4cBzEwUHJpKCsLAoF"
    "JlX/LSF/wx61LOMNRny+aOPPNnWAOJwQlqchZlKCzIQ/JOR3mNecWU8wyvvCWyGlZyAX0rAp"
    "QUVlCN7NTcgvTKK4lBLZBnHTmoSuwZV6eZavqed90W2QMnNQlQLCxx4icvQBxJUscnOTcAfi"
    "cHqCvLRcnu09mXACAOntTjgrWUXWU13He8NNENLTUIt5+A/cQSzeAEop8rkMxh6dR7mrEr5Q"
    "LRamprH8bVFUqLWJq7LdA+5gLe8NNUFYTkItrqC64x5q62Ig5OeFGwPVGN0JqPp3tH5WEQjV"
    "QCwofCGZGeBQ5uiRC4uvTMLRYnrJbul6TLy+ql/wWjTLQCSwDW+2jmPPqIpMMsdAWA8BgL7u"
    "1g6T4dps1Ym2CxcvEU3TcOP1ETCmQ2cWdNNE2N+Ilkg7xmbfYSI1gu1v3Mfv9397zgFAZ89I"
    "P4D+u3ePS4ZheADAZDoONnfBshksZoHBxqKQwo5IG2R9FYP7Bp7t3g8/9/uahmHAtm0AQMnU"
    "YdkMc/kpGMyEyQwYlgFRk7AruheyodLRmcE8d+XtmRZZLu2QhNWzE9mxir6JKDp3HkHJLMG0"
    "TGzma2EyC5bNsCTMw+8JYjz1AcPJYdVl110n516c/s5zfNjr9qCoFKEkTdw8cRuXX7ajpBvQ"
    "mY6SqaEh0IzW+CF8nB/C0OwHNIfaMf1pXiEnnx5+LxflBqEgLZQVNyR4zaeHWFSsr6+PU0pB"
    "KQUhBE/kq/bu2D4yODVo+8mWL5pkh1Rx9fO637heYtehWLbDpcGKp29hZq3+AznZZLYkRZLD"
    "AAAAAElFTkSuQmCC")
index.append('house_go')
catalog['house_go'] = house_go

#----------------------------------------------------------------------
house_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzRJ"
    "REFUOI1tk29oG3UYx7+/311zSS65y9/mf9pk6pbWrIoIvqiNzikrglLwT2FYFSaIoL7xlW+G"
    "SGHFN3uziSgbRRDpi+6VIihIhBaZOCZiWbu49trLn8td0lxyF5sjufhibHRlX3hePc/nw/Pm"
    "S/CQrJyfcLh0uk0oDVCWgGGZpj5ykHnjsw3r6C15GOzuMHUhlhCFRBaEYWHW92A2K/q+3Rk9"
    "KiFHYU93pO6NJkUx9ejdNWVAGAf0Wgnt+p5u2PoDEnIYFnoO1RNNCWLiMXSUbRj7CoaUwOWL"
    "wxs5jkb5FlrVvbbNtcP3JPQe7LOcqhAbF8RUDp26hK65j8Tcl0i+ehntpgpNugU+lIXDExU6"
    "Nae68vqEAwDIyvkJh892qZ7RMcGbOA5dKaHbaiBw+gIy2WOglKKh1XH963Nwun0Q42mUb5dQ"
    "u1Npm3QQpv4hX/RExwVv8gR05Q66rSZGz3yB7LFHQCkFAARDo3j63DdQZBW7G5sQI2G4/aJg"
    "af0i+fnzZ84MCfnBGUjTllIdnnz7CvGK/vvw4RjtFq588ArEkBe1bdUGsV9mvv1VLr35bPK6"
    "2dHHt31z6ZnnThHbtrG4uIi1tbX7Mz09Dd7jxd+aBeWP3/8h6L9zofjvTwwAfFeUS9//Jl89"
    "9cLpT3K5nGN9fR26riOTyaDb7WIwGGBqagrLy8sIBIOwwuNOzRXZ9Pl8fzGHX5yZmflUkiRH"
    "o9HAwsIC4vE4gsEgZFlGuVzG7OwsMpkMQqEQZ1nWizs7OyPko18WThrGQb6j//eueePg+cdd"
    "T9L5s2/h0sWLUBQFsVgM+Xwe1WoVmqahUq3Ak3IbH5792LO6utplDcP6UWB9iUQ6iZt/boB3"
    "8wCAVCoFSZIwPz8Pv98PwzCgqiouf3UJT712wgMAXtHrZju6ebvaUmx9v1Pul/GE3JM5AESS"
    "JNi2jaWlJfD8XalpmrD7Q9y4uqm/9D5EuSz3H+jC5ORkLpvNrhYKhWg6nbZZlg0oioKtrS1w"
    "HIexsTFEIhH0+/3m7u4uLRaLtaNtZAqFQp7n+WvxeDzMcRwzHA6ppmnvEULKoVDoGoCRXq83"
    "qFQqqmmac/8DgNViSwxtrXYAAAAASUVORK5CYII=")
index.append('house_link')
catalog['house_link'] = house_link

#----------------------------------------------------------------------
html = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAddJ"
    "REFUOI3Fk71qVVEQhb99cu49URMhPwqioCDRTkgVNIiIWImtIFqIYOszWNhaiI36ADaWghCE"
    "vIGVYGEjgkQNIpjcc8/Ze/4s7g0I2kVwmmGYWTPDWjMpVTPsx6p9of9Fg/Tg5Xb8LaHuiDhZ"
    "FRHoNOiykkXpStCK03VKDbC2cuA3aKAemE28WiAaiDsigagj5hR1nm9+mzQA2Bkr5kxBTrFp"
    "sQZFnaxGkSCrU8RZnKvpRjrhwCO4em6eLMa11XlunF/g9voidy4tsX52jmGduHlhmdlh4u7l"
    "o4yyMc6Gd0KVVRF1mjqRxWkGFU/fbJMSPHr1hRNLA84cazi+OOTQsOLUkYa2NzpxvFXqNiu9"
    "Os0gceviEnWVaLMSEYyy4Q5rK3ME0Isz6o1xMbJURGtUoy7IxemK8/j1V4o6494JoO0Ni+Dd"
    "pzEftsZkMSKgK0YvgedC9bMr9MWJYDoZRlPfZsM9eLKxxfddpRfn8MEZnt1bQcSJHKQrD9/H"
    "9dUFPv/IFHGyOln2mJ/ItaeGmCNTeU8uN2y++Ei9s6t0xZifnaEMErOSkCZQTYhWiAdigZmj"
    "DuaTbWN6fun0/bfRd0pI4NmJooQ4kQ2KE+aTWAPc/zzl//6NvwBETmzkmcw1jgAAAABJRU5E"
    "rkJggg==")
index.append('html')
catalog['html'] = html

#----------------------------------------------------------------------
html_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAktJ"
    "REFUOI3Vkj1IlWEUx3/ve9/r1bw30Vt+UEGUFkIILkpWSIhQ9LEVRA3V0CDY4iLU0ODg4hCE"
    "hBAODQ0RBEFGUi0i0VD0YUMN0acfkPlxr+993ud5zmnwBg0Nrp3lP5zz/x34nwP/fQXX7i7o"
    "vxpOBGsF4xzWQuyU2DiMdcSJUrRCHDsigM6Wqr+sihPF+3V1XrFOsSJYq1gnWC8kThh7Or8O"
    "AFhZc3ihbBISXx52SuIE4zyJVYwTEivUZSPigiMEEFV623IY6znWnuP0/lrOHajjfHeeA3uz"
    "VEQBZ7q2UFkRcPFwPQXjWTMeiS2hcQ7rhEwUYKyQSYfcnFwgCGDkwSzb82n2NGXYVldBdUXI"
    "zq0ZiiVPbAUpOqKicZSckEkHnD2UJwoDisahqhSMRwQ6W7IoULJCoeRZSzzGhmjRExVixSRC"
    "nAjXH85z+WgDayVBgWLJ41V5+znmy+wj5mcnuHpriWpbYvFnN2LaiZbjhFJShSrlzVAoa9F4"
    "RJTxyds073hJb3cH2+taeDZzn+fv7pBv+EDQM/ReT7TX8m3RkFjBOMHYP8mvn6tGBjh1/Aik"
    "Qk629jPy5BIpQu7cmyBcWXXEiSdXmSK3KUVNVYrabIp8NsXWbET95jRLhXnSQZaTrf0ADPSM"
    "sbu+jSC0RIux5cbD76hVxAiaONQKajwkgnqhed8vZn5M8/rHFIO94ww/vkBlKoNKmmAj/97R"
    "1zS0Y1fNla62g7Q0tvNx7hXTb6b4+ml5ZEOAdUjjMEHQF0BOYRXV0Rejc4O/AY4yW7fUpTeP"
    "AAAAAElFTkSuQmCC")
index.append('html_add')
catalog['html_add'] = html_add

#----------------------------------------------------------------------
html_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjlJ"
    "REFUOI3Vkk2ITmEUx3/3zp33nWlmYt4ZmolpSFgoxWZCkgw1PjYWJEQWyMLCSinNQnYKKbKy"
    "U+zINCGpmY2dj1goRc2M8Vlm3nvv+zzPec6xmCELC1tn81+c8/+dOucP/30lw3c/298aokoI"
    "ihMhBCjFKJ3gglB6Iw9KWQoZwMDK1j+shqgR45xKNIIYQZUQjCBKiIoX5eaTT3MAgJlCiMq8"
    "SfFxflgML4qTiA+GE8UHpdaeUdaFFEDN2L62Axciu9Z1sG9DJ4c21Ti6pYtNq9upZAkHNnbT"
    "Ukk4tnUxdRcpXETLQOpECKJUswQXlGpzyo1Hn0kSuHT/I0u7mlnVW2VJrUJbJWXZoip5I1IG"
    "RXMhy53QEKXanHBwcxdZmpA7wcyou4gqDKxsx4BGUOqNSOEjLqRYHknrpeG8Unrlysg0XpSi"
    "oRiQNyLRjFcfCl7fvsr6O4O83NvGkbEdrHhzE3We7EfpafhWzJjfDPV5zV1E1Xh26zJD6WO2"
    "HD5OdfkaypcPeT32iBdWkGy78Mb2rOtk4rvDB8WJ4sKvy8+96/D4TnafPE3ru6cwOQ4LFvI1"
    "62d09C3ZzKxQ+khHSxO+OaElJISqIZIQJCWoUcunaOlZDjvP/E5LNtxLD9/IvpeBayOTWDDU"
    "KeYFC4q5CF6xqAxWahTPH9B27xSunKYAZmea+Jp0kfxL3sf29w5X2tvO9XXHLEsnmP0ivJ9u"
    "ir6h5/8JMAfpO1t8mzqRatKvqU0qdn3osV78CRMGbjezW9NRAAAAAElFTkSuQmCC")
index.append('html_delete')
catalog['html_delete'] = html_delete

#----------------------------------------------------------------------
html_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjdJ"
    "REFUOI3VkkuIjmEUx3/vN+/MN6YZ5ZvJdUy5hwilMSbJNZOyJFFkYWlpw0KYpWIjWSorsVGT"
    "cmlSlFxKSqFcxq2ZEjPzvd/zPs85z3ksjLKwsHU2p/7/8//9Nwf++8lOXRtLfzPUDBHDqyIC"
    "ThPOK14UFxKFGM4pOUDvkml/RBNqiRh/bY0J0YSYIZIQNSQaQY3L90Z/AQAmGko0pkJGiFPH"
    "mghqeI0ESXg1ghi19hxXVyoAlhI7VnfgJbJ7bQd7+2ZwsL/G4c2d9C9rpyXP2L+xi9aWjCNb"
    "ZlL3kYaPmBMqXhVRo5pneDGqzRUu3R4jy+Dcza90dzazdE6Vi8O7GJnYw7waFGXEiWGFUim8"
    "UqpRbc44sKmTvJJReCWlRN1HzKB3STteA91dyzl6ZR2N4PASSUUkr7uED4YLxoWhUY4NzKJR"
    "GidubMEQBociQZS5tcUsn93LZFnw3A3QkFuYD+TjLlCGaaTEVDPUvUJLYMfKQ8RkRIsYiS/j"
    "H1nV3U89OJ6O9JHZFfIfDcGFyOnrnwhiHL/6Hi+JpkogJuPDtzeIKWqCRGHCT7Jm/ibq0uDH"
    "9n3kE5OKC5GO1iZCc0arZEg1MRZKNCqzpvegFonJ+Do+Qq19Ns8+PuDR25d8v3+ebNGxp6l0"
    "SpKEeSMFJYnRP3CEMgSCBUoNLOpawYaFO3ky8pA7Lx5TPBok1XvI/vXnV5zJivU9W9uGX9/9"
    "LBnbvpzlFfDvgAUnKWJqavPEhaODvPut/wQWDXWDTmhGqAAAAABJRU5ErkJggg==")
index.append('html_go')
catalog['html_go'] = html_go

#----------------------------------------------------------------------
html_valid = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI2dk8uLznEUxj+/37zvvDMYGjNMk3EpxkbUSKbIwj0LCrFha+sPsLZRLLBBliKFTEqh"
    "WEmSlVJs0LzGNZd5L7/f93vO9xyLd8jO5WyenjrPOU/n6WT8Z22/uOWAqpzP/6b50O29Iwev"
    "7dv4k2+7uHmPSLyyaGi4P/uT+PDEgRUSZVWQcEPEdkooe2JKN4cXDnW9rk82/uggqvaHGK4v"
    "XjCSS4x3o9nEspHFXa/rkw3XfG127O4lBzA3LBnJjJQMSYrERBChrXW89yXz+vpotttMTn0k"
    "DxtQ6aXS/X0H46O9v+101JyUOqjJEXVeTT/mwZuTuGXsWnKG7myIC/c/UPkpm24ryZgRGTE5"
    "ooaoE9VwXc3Y3BPE5Hz62s/8OUbR1M4Ac2f7mj4mnnxjz7p51Ko5ODjO83rJwxcN9q0f5Ooj"
    "2D8+wMlbb+mpZlgh5EEVUaNWyQhi1Ko55+59JMvg1K13jAxUWTlcY9H8bmZ35yxbUKNVJgox"
    "rKVUWkEp1ahVMw5tGqCSZ7SC4u40Q8IMxkfn4EApRrNMtGMiSI63EnmzcEI0imicvv2eqEa7"
    "NBxolYnkzrM3bV5OtQmScIciJkpxLETy70WkjIY7M5uhOYOtkDBzzt6Z4nNDKcWYO6uL80dG"
    "ETE8ONnW489991g/9S+BKEZQI0jn8kGNqPYrDUmGzMS7dLDG/cuvqEw3lCIm+nq6iNWMHsmQ"
    "mqOaIZoj5khyUjLUIFnHrXsn/mz50adeFoqLY8HwqLgYHhJEw5N1uDqY/c3v/Vv9AHUFpJrz"
    "F9vTAAAAAElFTkSuQmCC")
index.append('html_valid')
catalog['html_valid'] = html_valid

#----------------------------------------------------------------------
image = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZ1J"
    "REFUOI2lkb1rVEEUxX/3znu+t6skafYFRUEQO22sFPwL0ln6UUQQFLu0YiXGLnbWIlZaWdr4"
    "V0ggZXBBzIosK4n79u3MXIu3eZvN1woeZmDuzL1nzrkX/hMCcO/Zx43g5X5/6PPd0TFZYTbM"
    "c1jIeftp4+5aAhCMBy8f3+gsF4WIJBhgQJz8YQZm+7ERfMXDF59XgZqgvxuyolPI09fvuXBp"
    "icxFgmWgi6hQbxWcCt+2vrK+9gQfVAASgL0RqCZcvXKZazdv49RhFkASEEFFEFFUldQpMU7t"
    "JPuHCGRZTt46V+s9BdaYPEQwrkrG5RBEMItEC8SoCGBmOAn46g9mUwkNgRn8HHznV2/AOHqi"
    "BX6PdqjCxXpUQJH1Ge4NwPR4gh87bdJuOb2wDmZlk9ynRbc7ay9h4sYM1J1BXXaqf5fmHKRo"
    "tMzp24moFYSIAL3tzbkFve1NsBVCPEBQN8l48+p5E52MO0A1q2ChpYPoy8XzbalHOCGcrEMQ"
    "vK/I0vopATibuw+P1r/cGnq7HuKRiiPIE2invJuf+Q/4C/jZpV3a164lAAAAAElFTkSuQmCC")
index.append('image')
catalog['image'] = image

#----------------------------------------------------------------------
images = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI1tkk1IVFEYhp9zzr1zr1M5Lpoxf9AohwgqSKjIZeCmTQQi/SFJoREUuDEqV6a2qGnn"
    "MiIipCCQVlHkKog2QT9aQQsrrNB0bBp/5nrvOS3unWmk+TaHe84973m+h0+cuPIwE/jiZHbF"
    "d/MFwgooletCtcud8czxPiqUFRhODfW2JmtTKSGEhQHWtEADYAh8j+7BJ6eBygHZfOCkkilx"
    "5sYxmpuaSgf5hTSL80lWdZzcsk609YwtViKzlgogpUVzfTM797QglERakonxWoZ695FKJhHC"
    "EgYSlcgsAA3EnBh2PIYw4QvzOU1yc5K3VwdprG8oY7b5lJ1jb/8l/EAKC8DX8ObXJDMvtuDN"
    "NJLNQ25J0DHwFL3aivoiAYHrwJEdm2i3FFpHeQYwBoQt8X40cq27rYhdUeiF689obwCDAQyW"
    "CTQYWPicxVMh9vlb92hJp0vUSgq+fnzHcN851go++alX1OiukEBE6bcHXnJxZBwpLdLbt7Jr"
    "/wGUVEhlI6XEVjLEFgJXCiJVyOoq+Vv7q9TFPWQk1HFc3KqN2DEXpRRCFJ8xaB3w4c8yGAg0"
    "WBtc9eDs8PODK77ZvVIIqn2NeP3+J3NmOrwUhAa+TX2n6xDgVLEtcx/wwhYe3ezsL/ba1jO2"
    "aAwJqWJI5UQCosV2MWEH1MbX8H0Px8ZY5WNZFDo7PfnfyM5OT4I5TH7ZMx2XH+dcC+I2d9cF"
    "FDsdHRkoff2ro4CHQeQmRjtrSnNV/kskNFEXFyBC08YUfYsSdvmddQHlQiN366qIXb73Fzrt"
    "83P0KRZIAAAAAElFTkSuQmCC")
index.append('images')
catalog['images'] = images

#----------------------------------------------------------------------
image_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiJJ"
    "REFUOI2lks1LVFEYxn/vuXe8V/MjC6cMg0BcBFmQJCbuxIV/Qh+LpKAYVxKBSKvIcJFtwllE"
    "4CJa9LGwhIiwQhCJVpUZLYIiQdSIaXJsPrznvi1mnMkc2/RwDpz38PKc38N74D8lACeH7o/a"
    "QE4l0oGfypbpsptL34dan/GJ0RMDLoBVTl89f7RhTzQqIi4KKBAW3lAF1Y1asUGOvitPzwB5"
    "g0TKetGGqMRu3GHf/p14TohVD0wdRshvIzhG+PpxjuGBCwTWCIALsJYFY1xamg9wqKMLxzio"
    "WhAXRDAiiBiMMUQcQxiW4rgbhxDwPB+/sjrP+w9pMeRfBuu5DOuZNIigGhKqJQwNAqgqjliC"
    "3C9USwhFA1X4llzk+0qS9TAgVMvP7DI525QfFRD1EqTXkqCmvMHSchWRhUzpQhtQzRSbE1Sy"
    "sLA5nkshjSoYpwLjeGVz29QUQeoF9fU/GLp9FxNp9rYQbKds8gm7a2Zpa2unaVcLL+cnSL+f"
    "9tv7G6/nCWyIACtf5ssaRCIP6T7WizWWI409TH14QEdrJ58/Pep3ofCfUcauXS5Wf+rSzWEi"
    "Uk3vwbMAXOy+xeRcHOGx7wLUVppkGGTqGqskP8KCYWGxupZkfnGWt4szDPaMM/KsD9/xUDTj"
    "AuzwnXvnhp8fTwfaasMtAFjt9F+9m/U6D3cxORenQlxm3kwDMraVdxu1x/aOIBITqFFYRTX+"
    "Or40+Bs+5NzaMfvfjQAAAABJRU5ErkJggg==")
index.append('image_add')
catalog['image_add'] = image_add

#----------------------------------------------------------------------
image_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiFJ"
    "REFUOI2lks1LVFEYxn/n3DvdOxoqxEwZDaOFFFSbIEwIilrVPxD2AQWRJbSwNlEtItSdLYJq"
    "WeSqVhEIUQaVQRAEkQQDkUSD4gcyjB/zec95W9xxJnVs08M5cJ7Dy/M+z3kP/CcUwOmbz4dM"
    "oM5k8oG/VKxTZVZT34cmn8cvhrr7XAAjnO3vORDbGo8rpVwEEMBWeoiAyAoXTFDiwt1X54FQ"
    "ILNkvHgsrnrvDbM90YLnWIx4oJvRinBrhaMVv1PjDPRdJjBaAbgAy0XQ2qVjVxv7Dh3G0Q4i"
    "BpQLSqGVQimN1pqIo7G2FsddOVjA83z86ObQ7z8g1ZBrBMqlAuVCHpRCxGLFYK1GASKCowxB"
    "KYdIzUJVQATmslPMz2Yp2wArhoXiDCWzIxwVEPcy5JezILq+wPRMA5F0oXYhMUQK1eIMUdLp"
    "1fFcKmlEQDub0I5XN3dH6imJ8SdEZidI/bhFp+ry3qx1sBE6UsMczIyw59wlvPa95L+9pnFs"
    "1D9y3L0aOjAWBcz++l5XoPPzfXZfuY7/8x186KehuYWdySRfUhJ+pPCRhAeDt6vsb0y+78bf"
    "1g4nr9Wy32nFEdXmAjRFddYGhebWBhWOsCJYWUzHWsl9HaHxZS/F/DQ5YHHBwThMuQCNvvPs"
    "4sDbrnwg+41dZ4Bj/lHf//TRS26J4joRFucCJma0iJiH6/1ugLFTiRu5+akebVXSapm0yKMT"
    "o3bwD46k3lr9N0/HAAAAAElFTkSuQmCC")
index.append('image_delete')
catalog['image_delete'] = image_delete

#----------------------------------------------------------------------
image_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp1J"
    "REFUOI2lk1tIVFEUhr+9zzkz46SOYY4ZmrfEysTsQkb6GElF9FAPlURBVAQRvkZQREYk9hJR"
    "kBHRS/VUkJCEdqESupClokl38Y6X8YIzZ87Zu4fxCr71w4K9Fpt/f5u1FvynBMDBs49qXEcc"
    "GplyfBORRW65C1OfDxJ93H1cc6DSBHA1FZdObEhJDQaFECYa0ICafkNr0Hom17iOzdGLz44A"
    "MYORCdcbTAmKU9fusyIjCa+hcLUXZAApiIUUGFLwt6OFqsqTOK4UACbAZASkNMnLzWJdSSmG"
    "NNDaBWGCEEghEEIipcQyJErNfcecOSjA6/Xhi4uP8S6ihJFG9tp3GH/dRPX6VwFuFBxeYBC1"
    "w0TDUyAEWiuUdlFKIoDk8TryQp+JK6wgkF3M6K982utrr84aaA2DoR6GBkJElYPSLmORfmw3"
    "nWz1gnXpP0jM28bwj3Y8wiYhcTnxySsDCwz6+v1YXeG5gk4h03zDztWdJOXsINL7AI9f8Ke5"
    "g9EJraUzXCSZbpnWIA0P0vDGwvSR6WmmIv8LSbk7CffcRlgjWPEJxKkhbn3fNLnl9ONOOZ9g"
    "voJjz9mf8Z7Aqj2Eu28irSj2WBZdjZ8wSs7TYy9zAWIErkIAA7/b6GprQrbdpHx5K8GCXdh9"
    "tRgeTWQsk+6XH7nQUoxMzsdV89oopifsxuVz9H9+RIpWOKTT23KdpUEP4eEMhj50IMrvcHFf"
    "GmDPkkqAxDgZUk6YNL/NwNda1pYex9v1hs4nb2muH+ZbQzOB7VWkBpNJ9UexpI3XQs8SLPEZ"
    "D49VNWydcnRhWXggYLc9JbuojNDgEN8/ftN1/jOTfdWtLrTGlskEv8W9Ofp52leaNLUxN9Xc"
    "vCYHbUXeRQYHj+6+0vJz0dEE/gF9tg0XG0upSgAAAABJRU5ErkJggg==")
index.append('image_edit')
catalog['image_edit'] = image_edit

#----------------------------------------------------------------------
image_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAppJ"
    "REFUOI2lkk9oXFUUxn/3vjd5k76YTHBm0kwsMQa7MggxYisJwdRoshIRMRqDLdQ/6MaAqyAK"
    "otgUky6zacmiuGkXzcJF6aIEA7pRqmQjIRpiMm8ybWSa2Gdm5r17TxeTP0SCGz84cM7h8J3v"
    "4xz4n1AAb01cmzKxGi3txMkHlSOmzOEymYTGJLNzU2+OuwBGePvL97szLdmsUspFAAHs7g4R"
    "ENmrBRNXOffFzbNAjaD0wHjZTFZ9OH2V3IkUnmMx4oFuQitqoRWOVvz52yJfjX9AbLQCcAHC"
    "Cmjt8mTn4zx1qhdHO4gYUC4ohVYKpTRaaxKOxtoDO+5eYgHPS5Ksb6jp/Q/Ivsl/EUTVMlF5"
    "B5RCxGLFYK1GASKCowxx9R9EDiTsE4jAva2Av+5uEdkYK4btSpGqeax2KiDrldgJt0D00QQb"
    "xWMk1soHDckgUt4fLlHP2tphey67bkRAO3VgwQR3SFf/IJd9lN/X71I+cQaVbMJbnmO4I823"
    "szM0i3iDg4P+IQViDZu/fkf3ceGNs2OEYUjn+jq3f1ggoo7R11/BS7gUCgXqEj8nb63UfV5T"
    "YCwKCBbn6el4hL6BMT7+9AJ/byyTa22lq6uLQiHPpalvCIICzz53mhcH+lldXX1Pw+4/I7zw"
    "zEnSzSkAJj77miiKGRkZobe3l+HhYYaGhojimHfOfwRAKpXyXIDGer1l43LTE20ZfrnzEwDX"
    "L1/AGsPk5CS+7wMQhiHWCldmphl6+SXy+XxZAbz2ybWLkVGnt+9vPO2XfvT7nu9RubY2GuoT"
    "qlgssrS0hOd5tLe309LSQrgTSSFYry58P7+yd+I9OP39/V2+79/I5XIZz/McEdGbm5vvKqXy"
    "6XT6BpCoVComCIJ7YRi++hAfxhYIqYlXBQAAAABJRU5ErkJggg==")
index.append('image_link')
catalog['image_link'] = image_link

#----------------------------------------------------------------------
information = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAptJ"
    "REFUOI2lkk1PlFcUgJ93+NAwwIhgwry0DjgKNTZio9UuaNINK4ofoWkTg7p0xbapi676DzQh"
    "cWWqxiY2VNya1qTSQNNMWdSOBEZFEYaxinzzztxz7z1dEGcBceWzPMl5cnLywHsSbB2cvjqV"
    "ds6c9eLOGyPNVj2KFhR/XXC3Rr/tevJOwanBiT4j5kpbQpPHU7uor64AYDmyjORe8jC/Nq/o"
    "QOaH7qFtgi8HH/ZJJD92H4jHP26pY27BUFiOcF5J1FQQJnaSe73KnV8fr2tl7ELm8smhsqBn"
    "8J99tmhHuvfHw47mOv6aXsJaoTPVAKqMTy8SxAIOJWt5sbjK8L1cXiX4PHPtq6cxABHb31av"
    "4UfJesZybzCRQUqe3mNJej8NESuYkiE7u0RrU4L2/fUhJuoH2BQ4e+5EayPThTVEBPEO5y2/"
    "jM0wNDaDEYOxhrUo4tmrFbqOpAhEzgFUApgN09JQV0lufgnrHOIE9Z7+L/ahwNhEHvUeCCgs"
    "rNAefoC3UUv5gpIxqFesgrElvHN4r2SfL7JRtDhjceKwYrFG0ABwjrIgUDe3sF6kMV5FoDHU"
    "K945VBVQnFi8CF4MifgOXq6sEov5ubJAjbvxIDtLak8cvAernPmslYN7G6jZWcXAmU5EBCtC"
    "W3OCkZHHqOqN8g8ord2cmFi9mE7uCo+37+GP7Cy3f5/kp/uPULHoZo180vEhz5ZWeJqdyhPT"
    "mwAVAPk/by+Gh08/nxyf7WlMJaoPp5qISoaoWAKFpt21HOkImVvf4Lef769D1cXM8Hej21I+"
    "9vW1PtRcSR9KJrtOpGmsrQaU/5aLPBidZObf3DxBMJC5e2l7ym85+s3VNFbOBt6dx5eaUU8Q"
    "CwqoXveB3Pp7+PsnW3fei/8Bts1zS9BpGZEAAAAASUVORK5CYII=")
index.append('information')
catalog['information'] = information

#----------------------------------------------------------------------
ipod = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXJJ"
    "REFUOI2Nk0FqG0EQRZ8dS4EBQdAgBoUh+yxyCa+91DFyh0CukANoqQOEHCCKTuATCO2GUWKw"
    "BoJmuupnMepGssdJCpoqaP6v/3/TV5xqs9l8cfePknB3Yjez1M/mT4vF4jPntV6v75um0b+q"
    "rmutVqsfEXcTBzMD4Ov9Iy4QQgIJHJALB27fiRACzwjcnc6FgLdvbkAgeoLYt79aJNF13TAB"
    "ApcSiNN2xCkTIb2gwMzgDHzR1Svz0zyoIITAq2swwe5n2/tWD4qqIsHxeBy24O7cvX+dNki9"
    "ZLgCYDwe8/Dwe9hC27YJ1LYtVVWx3++RRJ7nzGYzRqNRH/ZLIfbboKoqdrtdUnA4HDAzJpPJ"
    "sxCv43AuO24uy5KyLJFEXdfpftBCCCEpiHm4e3qhOEeLgxlEgul0StM0bLfbZCPP878r6Lou"
    "ERRFgZldhDifz/+PIMsysiyjKAqGSlL6NxcEZvZ9uVx+CCEQj5ml/uR8i7g/Fsym34bH9tQA"
    "AAAASUVORK5CYII=")
index.append('ipod')
catalog['ipod'] = ipod

#----------------------------------------------------------------------
ipod_cast = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmdJ"
    "REFUOI2Nkk1IVGEUhp/v3mszTuJtyDQohCgJkiTpBywqSRQLwQhyIbWSonWLaFFBERQu2rUo"
    "oqWLWrUwgiwyoxZBRfQnWOoko43ONKN35v7M992vhUzomNBZHTjPeXgPHEFZ6Vf3tiPMs0h1"
    "GIq7kBJC+QEdDFPw74rjV0aX8mL58v3zKHWdWLySSBSECVqB60CQg7mEiy5eEif6by0T6E8P"
    "1pBdeES0qpOKCORmwZ0HoSDwIQzAjECsGpwMZBJPqFzoFj0PAwOATK6fyqpOAGbHFW62jRwx"
    "0XFBiK7LAs+JkZ5p4+cnhVIQqe4kJW8ACP3izk6Q74ltMJlPKDx3KwWZpkJeJCweIfBAB8/J"
    "GDeJZtcT+N+pazCZfKdQsslCeX1E4yb5FPhuB9qVWOojlfEtOBmwTBB2C5GJXorOQWTYQWrs"
    "GTX1JtNf+wyUv3i3Mwf5zBs87xwRO0/qxwC56VYyU63MjA4Qq8njFU+RLrwmOy2JVoFX6LTw"
    "3S2goViAz9X+l7a9s0YYTvyOt3ZprXuVUoRhSIWb/hXEO2pbj3b7XGt2wFxH6G+ykAWQPrh5"
    "aBy3nIr2nubd+w6U/wdQNzT0tImekwaN3wQiBKFNi7yTYHp0G67j4sQ1G/09AP2Pp5ZtXzi2"
    "GdNb2M+OlEDLeSbf2kDCEqduNywFR0ZOR0r9ocZaACbSAQCuEY2Jq8MSqC8xVnlOpdTffizl"
    "LZtJKVfctUJQgs60rAUWZVrrFfJSGaslMAyDZDJJMpnEMIxVBf9KkAXW2baNbdvl8uz/CAYH"
    "BwfblVK1pR9QSqGUcsIwfFnO/wGZGzZq50zlIgAAAABJRU5ErkJggg==")
index.append('ipod_cast')
catalog['ipod_cast'] = ipod_cast

#----------------------------------------------------------------------
ipod_cast_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAt1J"
    "REFUOI11kk9oXGUUxX/fe28ykzFknFrTiiKUpmh5NP2rMYo6OEyItNgiGGhxI6WlUNwoSBa2"
    "CxEsAd0ZsIhupIt2k1AoovFPzZAWFzWNSWskJuk4NOMkM51J3sz7933vcxEqJtW7ulzuOffc"
    "wxFsKJ3//CmEeRKpXoZwD1JCJCfQwVWa/nlx5OzMv/fFevAX76DUhyTTrcQTIEzQClwHgjos"
    "F1x0+L54ffCTdQR66mILtdUREm19xOJQXwJ3BYSCwIcoADMOyXZwqlAtfE3r6mHRfykwAKjW"
    "B2lt6wNgaV7h1rLUSYre94Q4dEbgOUkqpSx/TimUgnh7H2X5EYDQP362C+QvJB81WSkoPHc7"
    "TVkhJgeIwlcIPNDB91SNcyRqjxD4f7Blh8mdGwoluyyUd5xE2qRRBt/tRbsSS03Smt6GUwXL"
    "BJHqIb5wjNB5ERn1Up79js1PmizePm6g/LW/nWVoVK/heaeIpxqU5y5QX8xQLWYozVwgubmB"
    "F75JpTlObVGSaAOv2Wfhu9tAQ9iE6Xb/VvaZJSOKFu6lM4e01seUUkRRRMyt/BWkezsyrx72"
    "+WCvA+bDRP7jFrIJ0ge3Afa85cRy/Xv3P/vCxnwAW0ZHv+2i/w0D+zeBiEBo06LhFFic6cR1"
    "XJy0Zqt/AGDwSnEdet/WG4zODWeHewIZNjbp3O08R6EgNp4ZGxvT3d3dDF4p8pLdsTabuITk"
    "J/bvPMATm3bww/Qw16fGmJ9d/tjYSKCU+qefLXvMlj1+n7vInqd3owzF7sdyKBHy3K7nAX36"
    "AQIpJQAneh7iYKfiYKeislIiJtp4befbALybPc/2ji4EImH9nwLDMCgW13xYbdSYvjvOzbt5"
    "BnJfcu6bt0iYcTTa+y8FNYBUKoVt29i2TX/mBNcnx2nB4vKvQ7QIi/zEVUB8+oCJIyMjX0VR"
    "lFNKddzPgFKK/MLlYLJ0zVA6tDSsovXQz0Olgb8BoxVjaeXZVo0AAAAASUVORK5CYII=")
index.append('ipod_cast_add')
catalog['ipod_cast_add'] = ipod_cast_add

#----------------------------------------------------------------------
ipod_cast_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAthJ"
    "REFUOI1tkl+IVGUYxn/f+c40Z8Zlx6F1VyvMQaWLJUmsYJV0cXFZQ9ACFxL3SooICvIiukiR"
    "iJS98E5LCaEbLwyyogmxTayNgi5qUdtc2NVtdmq3GWea2T0z5898f7pYVtzN9+q5eJ4fz/vy"
    "ClaM/fGTpxDyNZTeBa1nUAqMGsPG39OMzosDxyce9Ivl4QtH0foD0tkUSQ+EBKsh8CGuw71C"
    "gG29J14ePr0MYG9deoTawpd4bQMkklAvQzAPQkMcgYlBJiHdDn4VqoUrpBb2i8HPYgeAan2Y"
    "VNsAAOW7mqDWR5206H9HiH3HBKGfpjLXx8wtjdaQbB+gpE4CCHv93NOgfiO9RjJf0ITBRpqq"
    "QkK9i2ntJg7BxteoOqfwao8SR1N0bZb8+atGqy0uOjyCl5U0ShAF/dhA4eobpLI5/Cq4EkSm"
    "h+T0IVr+CyjTT2nyOzrWS2b/OOKgo8W9/XvQqP5MGL5OMtOgdOci9dleqsVe5iYuku5oELYO"
    "U2n+RG1W4bVB2BxwiYIcWGg14ff2aLzvubJjzPS/2d591tpDWmuMMSSCyj9xtr+zd+/+iPe3"
    "+iBXY6LHXVQTVARBA7rvun5iz+DWbc/vWPkfQNfIyLdbGDzo0H1bIAwIK10afoHZiU0EfoCf"
    "tayNngUY/qa4LD1kvsa7dLpvpFJsJX6RZn3ZJ7fGK7ji8JnNDxpHR4eSS3pndycAtSvnqM98"
    "Qc/QmyKZ6ya4cVWOj17VU6O3P3ZW9tRa39eTpZDJUoj84Qybdh3Am7qO+PQV0ncus+HJDqmx"
    "b7srAUopAF7tWQUswm5WZ/DW5uDFo/d97ol1SCs2/A+w1MBxHIrFxTs4HV00x/Ks+uoNomCO"
    "JrAwL9GSvx/WoAaszmQyZDIZAIovvcX4tQs8kU3hygQLZcX0nNDWmrMPA+Tz+fwerXXn0g9o"
    "/RjtXdvjytjnym3YlHGcvwzmo70j5sP/AHbnXjE7/2EdAAAAAElFTkSuQmCC")
index.append('ipod_cast_delete')
catalog['ipod_cast_delete'] = ipod_cast_delete

#----------------------------------------------------------------------
ipod_sound = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI2Fkr9rU1EUxz+vTROaEkpfCa1GqtCCOrioHRwERScRh4L/geBQf0A3cShIwbmUgpND"
    "py4OSnVwK+kklaJOai1NSa2kSUrNS/Ly3r3nOCTvkbaDXziccy+X7/l+zz3O2tragqo+UlVE"
    "hChHYa3FWhvVs1NTUy/oRj6f/+p5nv4P5XJZl5eX8xxDQkQAWPn2FwVU2yGq8VlUuTnWVnaC"
    "wFpL2Lk/PdjXJkA7GVAoVANEhCAIANiennngNFsfzr5e/N1RoIjCQc3n516ddH8y7nxqMIFo"
    "LwDGGAoPZ54P2GCuVvPWgcmEtRZUUVUGB1JcmUgdsaLAQaWtYGz3z6hTb7xthf5cpkeubt+4"
    "N50QEXodsAo7B+ER/9I1D/n8hcs7uxM1r35Xmv7TVErntdF4nDDGoKrcuZAiDMN4ONpRBZBM"
    "pqh+GsDUPJxG4+W5j2+crcnb8/j++baFDoIgoFQqUa1WERFc1yWbzZJMJtEwhIaP1hvtx40m"
    "2mqRMMbE31MqlSgWi/FCeZ6HiJDJZJDiHokwQOr+s62L155k+ns4PPS/90SyRYRKpYKIkMvl"
    "yOVyqCr7+/uoKs6t66y6Q7/U91f61M5r0MJpBgs9xpjYQtQ58m6tjWtVZWP8zJ7T9O+nepXD"
    "YnV9vPJj8YgF13XxPI9CoRATua4bExhjGC9szG4OTewZv/UOaM8gQjabxVpLuVxGVRkeHmZ0"
    "dDQmiOxOHGy+ilc5DENUlXQ6TTqdZmRk5MS+RwTdP9ZNsLq0tHTJGIO1lu4c1V3x/jjBP4TQ"
    "72wmHlPWAAAAAElFTkSuQmCC")
index.append('ipod_sound')
catalog['ipod_sound'] = ipod_sound

#----------------------------------------------------------------------
joystick = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeZJ"
    "REFUOI2dks+LUlEUx7/X/JVuBDezcRAyUIkEiWKWIe1mH/0PLV24S0LaRW3atVEwqZXrwMUM"
    "uhEXIm5EM18FQgMiPn33x7mv2+q9BnsD0YHDvYvP+XDv4csQUM1m81RrfUFEWSKC4zjfbdt+"
    "0mg0ZsdsOEgghHiTyWSyiUQCRITVapWZz+evAZwfs6EgwX6/PxkOhxiPxyAixONx7Ha70yA2"
    "ULDdblGv19l6vQYRQQgBznkQGiyIxWIAAMYYiAhEBCnlvwuklKhWqyaVSkEpBaXUjYLAJdq2"
    "jVKphEgkgslkgnQ6feMXAgVSSiOlxHK5xH3ngLNfGs8fPbgXP3v4Gcx8Ym/fvfdY5l06nU7W"
    "dd2ZMSba7/dRLpfBGMP5t684efoMTAqolYXFh494dTv2ot1uvwSAW96w1npWKBSio9EIi8UC"
    "vV4Pg8EAd6JhRByOzdUVnC9LsJ9b/CjcfWyMMZZlXTAAaLVaslgsRvP5PHa7HaSU4Jz77TiO"
    "fyaTSYRCIdRqNUynUxYGACFE1HVddLtd2LYNIYQ/xDnH4XCA4zh+HiqVir9UTwApJTabjQ95"
    "g9df4nFEBKXUHwHnHFJK5HI5KKV84Pqptf6rfYFlWbi8vPRDc9xeGrXWcF0XxpjATPxX/QaM"
    "lGebIcK65gAAAABJRU5ErkJggg==")
index.append('joystick')
catalog['joystick'] = joystick

#----------------------------------------------------------------------
joystick_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlVJ"
    "REFUOI2N0kFIk2Ecx/HvY3NbUiANwqDJIgNntYGapXQTT1mnIDp2tTrlwVsjJLxIXfQQRSjY"
    "qC6LDoJJoQ0RyWEzA3HoZqAVZdv7ur3v8z57fbvkIHml/vDn+R9+fOB5nr/ApUZGRurL5fKU"
    "UiqklKJUKn3Rdb2rv79/eW/W4waYpvkgGAyGampqUEqRzWaDKysrg0D33myVG7C9vV03NzfH"
    "wsICSin8fj+aptW7ZV2BfD5PLBYTm5ubKKUwTRPDMNyi7oDP5wNACIFSCqUUUsr/B6SU9Pb2"
    "OrW1tViWhWVZ+wKuj6jrOtFolOrqatLpNIFAYN8ruAJSSkdKyerqKpFSkfadMrfOt57xt7dN"
    "IJwX4uHQ492s2B3i8XjItu1lx3G8yWSS5uZmhBB0r69Rd+06QppY2RyZZ8+5f9B3d2xs7F4F"
    "iMfjoXK5vBwOh73j4+OkUilyuRxSSmKR00RazjFf85OUvY6mihRL23xbK7ydfPKhUwCMjo7K"
    "pqYmb2NjI5qmIaXEMIxKz2enyPsytIRbOX7kFO+WEsx+es9a5segB8A0Ta9t2yQSCXRdxzRN"
    "SqVSBfgeSHP18iXsKpvosS4mP7/kwtkO1jKvblb9AZBSsrW1ha7raJqGrusUCgUKhQK/ij+o"
    "Foe4Er4NwJ3OR5w8GkEg/B4AwzCQUtLQ0IBlWSil/jpHF9+wtDHDx40kfV1PGZi4gf+ADwfH"
    "9ADkcjmmp6crS7O3vSd2mE3P0BG5yOvFYbzCQ3JhChBDlW/8V7X11A0gRI+Aww7oOM7w3PDX"
    "vt9apVYoVpTgbAAAAABJRU5ErkJggg==")
index.append('joystick_add')
catalog['joystick_add'] = joystick_add

#----------------------------------------------------------------------
joystick_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk9J"
    "REFUOI2N0s1LVFEYx/HvdV4dqUaMsMXoGEK+hIK9iLRq4aJw1Ub6C4KQoJhFm2iIwV3UptoE"
    "oWBDQSRBCCZSk0QMJMMQxWhNM0U6FZrMnbnnnnvuzG3lRHKlHng4Z/HjA+c5j4ZLTU1Nddi2"
    "/VIpFVVKYRjGV13XRxOJRG5n1usGmKZ5MxKJREOhEEopCoVCZHV19QYwtjPb5AZUKpX2dDpN"
    "JpNBKUUwGKRcLne4ZV2Bra0t4vG4tr6+jlIK0zQRQrhF3YFAIACApmkopVBKIaX8f0BKSSwW"
    "c8LhMJZlYVnWroDrEHVdZ3BwEJ/PRzabpa2tbdcnuAJSSkdKST6fZ8CoMlK3mRg+diQ4cmIe"
    "zXmk3bp9bzurbV+SyWS0VqvlHMfxLy0tMTQ0hKZpjH35TPv4OTRpYhWKfHzwkMnmwLWZmZnr"
    "DSCZTEZt28719vb65+bmWF5eplgsIqUkPtDPwNHjiI0slZVFzF/fMUJ7WDECC7HF0qgGMD09"
    "Lfv6+vw9PT2Uy2WklAghGq3ePKa1lObwqbMEuvoR2XnepZ5Tzn246AUwTdNfq9WYnZ1F13VM"
    "08QwjAZw8v19hieuEvz0AlIJQvvCHIp28jbnXNoGkFKyubnZWBohBNVqFSEEe2WFYHsXnLn8"
    "Z/rxg3gcLeoFEEIgpaS7uxvLslBK/XXKH08wMs9oeXoBKUoYgF72UPOw5gUoFoukUqnG0uzs"
    "sQMttL5OEd3fjNfjQ/9pky9pOE79TuMb/1WvxiNXjI218011rbPe5Hyr49w9vVCf/A0vvlkU"
    "8vPoNgAAAABJRU5ErkJggg==")
index.append('joystick_delete')
catalog['joystick_delete'] = joystick_delete

#----------------------------------------------------------------------
joystick_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmhJ"
    "REFUOI2Vkk9IFGEUwH/jLuu2aCii6eL6J2XVNSwJTMqDYRJFt6CLHvVilyAv0SEVT0EEXTt5"
    "2DwkYUGHDh6MpcOmIQsd1pXaKUqkbbOddeeb+Wbm6xBpyR7swTs8+L0fj/eeRplYWFhocRxn"
    "VUrZJqWkVCp9NgxjdH5+Pn2Y9ZcTCCEeRiKRtlAohJSSbDYbyWQyD4Brh9mKcoJisdiYTCbZ"
    "2NhASkkwGKRQKLSUY8sKdnd3mZmZ0ba3t5FSIoTANM1yaHlBZWUlAJqmIaVESollWUcXWJbF"
    "9PS0qqmpwbZtbNv+P4FhGPT29tLc3EwqleJEVY6ZyYaOrVfjDUedQFmWRTqdpt8uMlCn03fu"
    "Rqhar0iqWzcn/mb3z7i4uNjmum5aKRVIJBJomkYkEmFQfSPUfZnjTf18qF9qze3tPR4bGwvH"
    "4/E5AN+fZsdx0j09PYG1tTW2trZYWVnhU2aN4SE/Tb3nUeYbAnUjFHNJdqpiFz1PKV3XV/0A"
    "Usp0LBYLdHd3Ew6HGR8fxzRLOPoTGk/2g3hHMv6cwck72LV7XGit5elSfhaY8wMIIQKu67K8"
    "vIxhGAghqFJfuHS6kuraEm7hIygPt/iW9uHbFF4+QrniYIlCCCzLIp/PYxgGReMnHcFNalrO"
    "4JVSKM/k7PUuPPsrweAmbX1XGY35DgSmaWJZFp2dnUSjUQbaPTpODROqzqGc76D5WH+2CXh4"
    "YpP6aCsjXX5e34vFNICpqSml6/r+09y9YjE0EcdXkUU5PwD1z+V9x7rYeb9B+sXsklbuDxL3"
    "+3PK8ULKUyjP+51KcVAr8Dzw1Pov8D9GD1oS6+oAAAAASUVORK5CYII=")
index.append('joystick_error')
catalog['joystick_error'] = joystick_error

#----------------------------------------------------------------------
key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2Vkl9IU2EYxn/n7Jz9VRSTuWFFFERBBEJaSFDCEhNToYsuIuiiKPMqSlCIhK4qkKKg"
    "QCQowTTNdtWNYbvIFiZSWFRYZsxIp25uc27unLOvC/9gxLTeq++F7/c87/N+n8QGFfB67gF1"
    "y+39LbUvLmzE/AEHvB6hJ8eEnhwTAa9HLAv+BxwfFovTD4QW7RdCpEXA6xFj3WVtK/ek9cZ2"
    "H7mJHn2JpOYTfNUOwOaaPsYflTI1j+9Avb8sk4BwV7Sih58hjAiS6gR2Me2/Dnqawtoevrd5"
    "mDYsPjlTBJEaRxiRpbM+C3zGVdZI7t6jJH6cZNvpW+RpicNKJgFJLUAyORBGHISB0ILoegih"
    "D6DNR7C4ZtFnFjH95dzcLEfdAacWCRSbcxVSs/1IEoCOER/FSEyRtb2G0ZbbTNjsX1Z3sPre"
    "soRlUxG5u0tITrZgUvORbS604CcMbYGsncf5eqeDgNn2sbxpaM/aCHWFVU8x4oNoMR8LE1dQ"
    "5RwktYSZgT7clWdAtjHaco1fdtu78oahIgBp7U9zlp4jFWpHj3xDyc5DcRxjpKszHEpKoa3a"
    "wg7ZamLKah86dGmweMVVWXLuQY/6SAXvos39xJzjxuSo4EPn49Bk2vK8+uqbU5mWrQhBTI+9"
    "zU4EbmDMh7EW7EQy72ekqyscxNpb3eg/mwkGUCSJbEl1gGrH4sxBqPt439EdCSu2J1UN/vPr"
    "wQByWjOG9UQa1XEQ2XGCkU7vXMxqf1h5eWMYQJmMGr1z3RddWiptFqm0nMqytZbXv276Fxjg"
    "N/KeEBUFVhBGAAAAAElFTkSuQmCC")
index.append('key')
catalog['key'] = key

#----------------------------------------------------------------------
keyboard = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAd1J"
    "REFUOI3Fkk1L1GEUxX8jE0SQSCNIliFqFgkxGUEtQrAgItq0itq16StEOzdto2UfICjaRkGS"
    "4qpFUBKBiDEhDkq+hc7M/+V57kuLebE2kYvobs7Z3HvPuefC/65CmywuLt6PMT4OIeQhhCTL"
    "slqaphtJkswnSbKeZdlOmqZLW1tb01NTU9LuK7ZJkiRP8jwnz/MHExMTT/9WQWdAvV4/kOf5"
    "m1qt9mJfFuYqcQUKxxtLs2RZRs+Za6gaooaoEkWRqARRYlSiCDEqISpRYrUwVxHvK9Y6E90d"
    "dzAHM8fdUXPMHHNQM8wcNZhb2Kar3TjSf5jqeoOTx7pZ/l7j9EA3ldVdxgZ7WKruUB45wsLy"
    "Dy6c6mVssAdRIwShMPs1eF+xTnWjgZkjaqg5Yv6LFe9gebjE+GiJmU9rvPu8QZdIU9LkuaNc"
    "Pd9PEOPGxQHyoNy6PEgWjDtXhsmDce/6KOOjJQBEjShC4fWXhvcfTPm2touII7a3VdWIHTRU"
    "95SdHSoxPb9GMYoiYty8dILnMxVuTw79MbZHz+Z5eLfMq/criBqFlx+2feBQQFtXNzPU2ENv"
    "JWCOueOAWxPfflylmAXZXGh47+/5tnjrB6Iooto8sBqmhjcFbe7n6f5N/QSuUniP3hXjNwAA"
    "AABJRU5ErkJggg==")
index.append('keyboard')
catalog['keyboard'] = keyboard

#----------------------------------------------------------------------
keyboard_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlNJ"
    "REFUOI3FkklIVXEYxX9Xn+QiTVRwSEscKpNKM8OkEDSLiApaRbuIDNxGILQSWkhQ0kYogpZN"
    "GynIqFQss2FjmUPyQhEf7znm8N677977n1o4VNjCVp3Ndzbf+c7hfPC/Ya2SkZGRy0KIFs/z"
    "XM/zbMdxwrFYbMa27c+2bU87jrMYi8X8c3Nzr5qamuTqnm+V2LZ923VdXNdtrK6uvrNRB2sC"
    "kUgkwXXd9nA4/OifInSPigmwcqL+LhzHIWX3cZTSSKWRSiGkQgqFJxVCKISUCKHwhEJIEbC6"
    "R6XJ8IXXFI0xGAPagNYGYwxKG7Q2aANKa7Q2KA3dwz+IW10szE4iMB2laGsy41NhduUmMxpc"
    "oiQvBX9gkdLCVIbH56nYmU5JXgpSaTxPYnV990yGL0JgJorWBqk0ShukNr9FMWuztCCN/TvS"
    "6OwL0dE/Q5yUy5ZqyrI4Wp6NJzUnK3NxPcXZI3k4nuZ8bQHB2Tf4gze496KeS7dO837oAUJK"
    "rOcDUZOdGGMstISUBql/XVVKI5QhNNdBfFIf5cUHyEktomuwjQ8Db3Hnq/AJqZBSc+rQNh52"
    "jnKuJn9dVfUtVzlTcQwVp9iXVcfroSdU7qnicVs7Pk9IZILm47dZtmcm8W5gCqVBa708jWF6"
    "IUSCtZkTxRcBuFJ7l2dfW9HmKT7Hk7PDUZP+Z78rfOUH5sMLDAZ7+RLsobHuPs0vL5AYvwnL"
    "SjDWOr9/wcGGrOu5+VuuVe09TFFmGf7JPnr7e5gYW7y5IYFlkcxmLKvBgiQDYYxp/dQ62fgT"
    "a3x88zF05/UAAAAASUVORK5CYII=")
index.append('keyboard_add')
catalog['keyboard_add'] = keyboard_add

#----------------------------------------------------------------------
keyboard_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkxJ"
    "REFUOI3FUs1LVHEUPW98muJHgzPg56CmliSBfVGbkKyIalUEiYuglRS0aSUE4WzaRpui/8Da"
    "REEFlZo4Bq0ykUzGpqTxc5zEeTO/997v494WOlrYwlbdzTmbe+45nAv877HyZHp6ulcpdU9K"
    "6Usphed5juu6KSHEuBBi2fO8Ndd14+l0+k00GtX5PTtPhBD3fd+H7/t9nZ2dj3bqYFMgm80W"
    "+r7/ynGcx/8UYSShfgBWfS4+DM/zENx/FsYQtCFoY6C0gVYGUhsoZaC0hlIGUhkorZLWSEJz"
    "le1sKjIzmAFigIjBzDDEIGIQA4YIRAxDwMjUTwTyiy215Ugu59BaV4HZJQdtkQok5jNobwwi"
    "nlxDR0slpmZXcXRfGO2NQWhDkFLDGp6RXGVnkUzlQMTQhmCIoYl/i8Kb2NEcwqG9IQx9XMDg"
    "RAoBrdctdR2swenDtZCacOF4BL40uHSiEZ4k9JxqRsWnARx4ehmZm/UYu9oMM/wASmtYLydz"
    "XFvs4ttCBlozNG1dNYagDCM0+QStq4NoO3kRu5ra4U68xufYIEaLzsB6Np7humIPHS2VGBhK"
    "oLtrz7aq3l9rw5Hu6yj5+g6YiwG7g1ixGxCLzcCWSkMXEj58WUFDdTnGJpdgCCCidWRG4fws"
    "iqubgPO3th6ovwbl2TRsT+qVqRyH/+x3g2/8wLGyMMT4C5Q+vwHfXYQA4GQKkCsJkbXN719m"
    "9EpNf1FZ6e1I2Nh2IAknpfF9scBIj+7sSGBdJNIn0vO9AbIaKMBzBH547i3d/QVC43pWiPeW"
    "LQAAAABJRU5ErkJggg==")
index.append('keyboard_delete')
catalog['keyboard_delete'] = keyboard_delete

#----------------------------------------------------------------------
keyboard_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAipJ"
    "REFUOI3FkU9LVFEYxn935s6Q4liLUkczS4rKVdGmIBIkiJD2fYHoK7QK3LaJln2CDFoEQS0i"
    "xUVYLSJCUPFPWJKM42h6Z+6955z3vKfFpNAuVz2rZ/P8eN7nhf+taN8sLi7ed849ttYaa22a"
    "53mSZVk9TdMvaZpu5nm+m2XZUqPReDsxMSH7uXjfpGn6xBiDMebB6Ojo039tcABoNpslY8yb"
    "JEmeH+qEmVX3A6KTraVp8jzn2MgtvFfEK+I9TjziPFY8znmcCM55rPM4cevRzKqE3jg5IIYQ"
    "CAE0gGoghIDXgGpAA3hVVANeYWZ+m8J+8Gx/hfXNFucGulmrJVwY7Obbz112s5TVrR3mNjJW"
    "Go6d3DEy2IF4xVohml62oTdusl5voRoQr3gNiAYKBaHUcZTz/V3EpSKbu5adxFAKGV4i3n2t"
    "UxBpVxq7XOXmlX6sKONXBzHW4wpdDPd2smMiNvY8EhUZ6KlQT9obORFiJx6JA69mvyMSEFWe"
    "Ta0gPpBnlnK5hBhBAxgJHImLSIjxXhDxfwCi3Ll2ismpVe6ODR8M+uJDrb22B9HQHjmCtNWi"
    "q1JGvBJbJ0hJ+biwxVBfhfdzNbyCqlLGk2SeSkcZ4wNxIWJj2xEaixSSBNUh4tzK1nwrHP/7"
    "v23vNbBcyzlT7UYD7LUMUpvn+olNfq3M0rt3MYk4pF4+vH2vr1p91DN86djCp9dp8bCAyZnl"
    "zzdON9ecyccLxWLnb75XgvgTdFBXAAAAAElFTkSuQmCC")
index.append('keyboard_magnify')
catalog['keyboard_magnify'] = keyboard_magnify

#----------------------------------------------------------------------
key_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsdJ"
    "REFUOI2VkltoVHcQxn//s3v2kt20abusCUYIqUgEq7ZovCChMWtRCUnABwtF0AdBk/ZFpUQU"
    "fI1CsAhuJWqhLdhEo12oUmhKGiHJalpSMZHWW6I9tiR7y242m72cy9+HqLRKDJ2nGZjvm/m+"
    "GcECoYUCQWD/s/LLJU0/Ny+E+Q9YCwWkkRuTRm5MaqGAfEb4P8CZYZmPfiX16V4ppSW1UECO"
    "Xao997xPvG7tsi0nMKZ/Qag+Iv3fAlDe2MOjbzYyOUPf+pZw7XwEsmxrB8bU90gzhVD9QBXR"
    "cBsYFoubuhk/FyBqOvuU+STIwiOkmZrLjTjwJ6W1rZSs3Eb28SdU7D7J23r2Q/t8BEJdhLB5"
    "kGYGpInUIxhGAmkMoM+kcJbGMWJ5bK9MPnZMmS7T/HpKW+sosVOI9yIEgIGZuY+ZncRb2cj9"
    "9i944i66+8KDF/dWBM533qdkeTW5iXZsqg/FXYoe+QNTn8W7bAcPTl1Ac7jvfHT4txX/lrB/"
    "cf1lzMwQerqP2SdHUZU3EWo1sYEeRstr6R0dJzUwxKzNZ0WTiU4AmxYKBA98XHkVwO17i3z0"
    "LHo0jN3tw+ZtYvRi99SPSU9u3C7cGz5YR93areQdCRGb/WuzZ6mtWJmb3M2imk/RE2fQk/dQ"
    "3/Bj99Yz2vVdYsJyXPvdEu7VVaswFZNVZVswhc769zYCskWRkrSR/pWsdpxC/G9cvmXYPAFG"
    "urqmJnFdaWi9sSs5E3epwkvD8s8AOFjXwbv+lQiESxGCYqF6QC3C6a9Aqmu4deFSKiacF+s/"
    "D+8FiKUmc3f+GaStZw8AbT/t4WHkNhKZUyzdHDayFqpnE4pnJyOdoWTaVfT19kPhfc/dtSzZ"
    "fuP2IA7s/DASxCHs9N+6DojT4ub5miOufLZZL1gOWbCUrMfdUdMyePjl/6huLm1DiGYBxRLS"
    "SBkcCk60PgUVz0QHmlNb6wAAAABJRU5ErkJggg==")
index.append('key_add')
catalog['key_add'] = key_add

#----------------------------------------------------------------------
key_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsVJ"
    "REFUOI2VkltoVHcQxn//s+fsNdFg0k2CilGoVpSiYG0RCY2sohIvUEWKL75INeqDRSGikD6U"
    "0hak0gctooK1qFFbl4IUEi8pXkK1iBrvxqicRGNidt3d7J7Nnsv0IRq8kIrzNAPzfTPfzKd4"
    "R5jx2E5g7Yty19ilJ+vehXkNbMZj4uQ7xMl3iBmPyQvC9wBnL8tA7z6x06dFxBMzHpOOozV7"
    "Xvap/1u7cu6POOkzKKOMnnMHABizpJmHv87iaT8tn61rrRmOQCrn78ZJHkfcFMqIAh/R2/o9"
    "OB6jlx7jwZ4YvW6gRRtOghQeIm5qMHf6gNtU1NRT8vECrEcrqVr1E6Ns63N9OAJllKN8EcTN"
    "griI3YPjJBDnPHZ/ikBFH86zAXxvTW5o0NKVZtROmZ/4S3QKfadRCsDBzd7DtZ5SNGEJ97bv"
    "oDMUvjN0g6F/a4pA6XRKJs8k370dn1GGFqrA7rmFa+comvgF7T8fxPSHbszb8u/UVyWsHV37"
    "O272InamhVznNgxtJMqYybPzzYiaRNdfp8g+asAN67bkC78B6K86zU40UUgcwEndRy/+AC2y"
    "iLbGw8l+M+uV+gul05ZtIDB+Cta1JuPm2aZvm+V2VhucfIzy6vXYiV+wn9/FGBFFL6rleuOh"
    "RLfnP1G41Z76cM5ygvdbUPu/JNxxnKpxZT4X2aiLkHEyl4ot8wfc/iTB8oko/6e0NTYmewj+"
    "sbi+dXXzHN0LVoyHhV8P6dW/qcQnqkpXimJlRMAIE4iORIwZXD14NJXUQ0dqN7euAfA06cpd"
    "OTEm8mcdA1Y3OSCT9uH6eKx5tnvZsTyMyGy0yAraDsefZ4Lh/Qs3DYIBwqXRvTcu/O08yYdI"
    "+wySCUV7p3JFZKf6Z2/11uCAVWcXPL8UPM2KhHZXr7uw5U1/nF0xtj7X9/grzVPjPE26PGTX"
    "gpPed/8BK2RUNBFRtm0AAAAASUVORK5CYII=")
index.append('key_delete')
catalog['key_delete'] = key_delete

#----------------------------------------------------------------------
key_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArBJ"
    "REFUOI2Vkk1MVGcUhp87M3dwAGEiU5gJoAYTY+NP2kYNsTYpyUhqYqJ7F7pVF40rZYVNN2pj"
    "2oSkTYjRRBI3YGFNLYwGpAWd+BONSIvgLUbAofMDzp3v++49LoqEtqGmZ3XOyXnf8/Mei/eY"
    "05f8HjixHP7QeOTmyfdh/gZ2+pJi3Ekx7qQ4fUlZJvwf4KW0lOaviM4PiIgvTl9SJrtbLr+r"
    "s/5r7MSBi5j8IJYdY26oC4CGwz8xdW0fs4ukmk+NtKxFIIkvOjF/9iJeDsuuBbYxP3IejE/9"
    "kR6eX04y75WlAmutIGoK8XJ/+SYDPCXecpboroMUp4+y+fi3bNDFz0NrEVh2HVawAvGWQDxE"
    "z2HMAmKG0Ys5yuIZzOsSwX91bm8P5BNOrc45e8LRECozgGXBuV/T9I4/IlnjUtl0mIlL3/FH"
    "pHx85QYregcsymo+JvrhXtxXlwjaMQKROGcG71ET3caTmTTnZoM44cjj1ra7O1YTSP2hG3hL"
    "o+hCirZbt0EUyvdQWpPYsJVdDfsZnRrgofOL9J+eDWIhodWfphf6UQtdmNzvGL+SA9uP4YmP"
    "53v4CC9zDjsbPmVRFa3d52+pu1IKh4AT9Yd6MPkUaq4DnZ0hXJ3ANVk88ZnOTKB9g/E12tPk"
    "SwU+avyMRf0mlG0fcgMiFExhjKJzAZWZYV1sK8GKJK5xMZ6hrmoj8apNJKqbsIMRPlhfT9oZ"
    "Zvi3oadugWjIslhv2RVgl1NWW43Yu3lwvTv3psqtujryjShfUTKKLbHtgeamVsamh7g53v8w"
    "nGPv8w5KIV97aVP0P7Er9mPZm3nQ1ZEtrCu/1nvy/per5c1+PTJvBSKx1PjP9ypt9j3pQAGE"
    "XuW9H7Pdp+Na+WFRfkBVRjpbT91p++d/LJWEwWcpXtg08xXmXf4toHRhclV9rWsAAAAASUVO"
    "RK5CYII=")
index.append('key_go')
catalog['key_go'] = key_go

#----------------------------------------------------------------------
layers = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhpJ"
    "REFUOI21kz9rVVEQxOfcc+97Ly8v5g+xkyA2FtZiZamN0cY0NjaCYKOIldj5FQQbi3wIRUSb"
    "gIKIjY2tWCWthuTec3Zmz7F4GiRWIk6xbDX8lp0B/lHhwfvbFwBAnA+SEAFK830gSIEi1BMv"
    "7+98+N2grQgnllJ6+xUAAoBRBHYBICJiDxHAXgNgF4gLuvgHwd2dW5fiaP9dg7WHAFDkkAok"
    "gVYgE2QGM6E/TBsN8MXM8OrezmMAaF2OtL8aZuv1tKw+YVKn4l0loxlbmlpTaZRy2+/3adR2"
    "n8y4dXSCstCPFcY2ChzyZLq8+KzWEKoURA9yBbEE2gKms+lEroGpW7769PJHGtHmJIxi33iz"
    "Cvc6DghnD74dPHL5ilRmxcuKu89omnLIJ0uph2lgRKi7Ml1rlTOqW4gdwaSR6KilnPFSl4qX"
    "JZdPSRvLvDPzqbsqjRFAY/kngYWh6TLDkDhZpOBeThX6VNSE1IjZo8wiEzu6OktCraXIHG3K"
    "Gcrx/NCm9f57Ose1GVLihkwtjVFUtESQCsqEszS0XGtFoQnt8zuv3wDA9e0rN9A2n5mJ4spF"
    "ckmNmYLojYygqVhmZbaKCkmO9tc7LBlo3LRkSD3XLTGQLMoETdWSVcnBrCpTAUDJEY4na2t7"
    "s1rmC5lVZtacVURWJjmNTsllxV2srnKzPW5wRJIJZoFzdNA4TyUdksNVUNz/snr/Qz8A53nu"
    "bSdnNGoAAAAASUVORK5CYII=")
index.append('layers')
catalog['layers'] = layers

#----------------------------------------------------------------------
layout = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXFJ"
    "REFUOI2lkr9LHFEUhb83WVcQEtEiihDCFolYJxCCSZneIrba+A+kSJcikCqtlSD+A+lShFSW"
    "llaBiBKINoGIGGXBndmZd06KdWd2cP2FB1717j3vu+c+uKMCwNLq9rsAjwnhFfAMyxACMkkS"
    "SAJIIhY+aTb4NfvowXNk3r+dCwAsr26v+5b6/OWnARoADrwG2Ng6LtF8BfbK/CQ7BydZaUBk"
    "un/55OFob7YwvHn3bwZAmnabFYE91n917zC7UXiWQkUgNfpoN5WiGCDobWPx4yaphAzfPr3h"
    "95/Toc2tmXGsCEByjgPAUSfnxdwUx52iLL4/1qydcoSiZtDLvJ1GcpuzrDIAyKPJY30vUlEZ"
    "hHOCLMvp5JGY5tdm4KI7kMHA1j3kA4zcu7hTu6gM1OMLAN+39muF7bPucAKp+olR2gdaP9YW"
    "akWtmfHLR5D/lQZEf138sPlU+GWQJ6QCLKyIVYAjlrANyOC2Q7Jzqftt9B+LG+YMNDQOgQAA"
    "AABJRU5ErkJggg==")
index.append('layout')
catalog['layout'] = layout

#----------------------------------------------------------------------
layout_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAetJ"
    "REFUOI2lkktIlFEYhp/z9zeKZJEL0yhCwnIWaVBZeYEgZhstclsErZQWEYGLFkEbg1ZCQxTR"
    "MmgRRYVgWAg6DMFAZtNFgmwzXZmcJGf++f/zfS3mjlMYvXBW57zveb4L/KcMwMnxxDkDOzBm"
    "ANiHioIxiOI4BseAiGADXQq5vN+9feN+RLlwImwAODWeuKn/qCt3XyuAC6CGQYBbs+kymv4F"
    "+0x/C28+LnnlACxtpcvO1oZCbaa++d0XD4BcLh+qEKg2lX5d+OqtqXkqYioEIm4Jba0SK1QR"
    "FKYxdGmKnAii8PhyhA+pTF1zx9ZNqFgAnCIOAN+zPgfDW0hng/Lj5qZQzSmXENgqAin0fDln"
    "8VVZ8SoBAL5VYslHxN9O8PPXD/zAJ69dlQBTJPA8n6xvsTm/JmB67h4L6acc6T/AtpZOniXv"
    "E3/1hN6R9quFEqqmrnUWYDJxh71dPVjH0tMewRqfQ3v6AB1xAMS3ZdvE7GKNeXklz7fMJ9ab"
    "DRwLnwXg/NEb7GztxmAaXQArsgh0zF8/vqrbhZAMyVSMudQMo5HbjE2epnFdA4rmipuoD4Yu"
    "Tu0S9LAR3SwSgAoqFpUA1w4Sfxmjr3uAh/NRQsZl5sU0YK79YWFXq3e4bQxjhg00KyyjGn0e"
    "/Tz6G7PBC7fB+1v+AAAAAElFTkSuQmCC")
index.append('layout_add')
catalog['layout_add'] = layout_add

#----------------------------------------------------------------------
layout_content = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZ1J"
    "REFUOI2lkrFrFEEYxX+zHBE0G9BCRBCVJIqdoI0YK5FUgkXSaor8AynSWQhWtqkEtbHTRiwO"
    "q5QprzHgoSSQFBaKJIGA2b2Z73sWu7e3ASMJPphi2J03v/fmg/9UAHi80lsKcJkQZoBbyAUh"
    "4CLLAlkAd8eS9sY6bFy/NHEbF8tzNwIAT1Z6r3RCvXj/RQAdAAXuAbxZ22nQ9A/sxbvn6G/v"
    "lY0BxoXhx+nzp6ps4e+Hv/4oASiKwdiIQDo9vPXbz/JY5ck9jAjcO0O048rNaRFUrzH/bJXC"
    "HRd0nz/g4etZ8jzH3ZtlZnxY6CK3loFXbr8OIvdvXqTb+w5Ano8zNXmFOiaS83m9X+1TZZBV"
    "BlXn+4URJX6XCQAzJ3C4zWRWp04jglATlGXkIBpWxPonRxIgkJCE1TcrDVoRWq+u1gCkZLis"
    "ieAS5sN9i8CjiXqsP61tNQb5+Bk2NreJMTKIEUtGFjLq3kaTaO5bwNX1l48O5X07946jJNdu"
    "Y4Dp4/zT1WuO7gTXWfcEcuSGPIEMNX24QPsKWf9I95PoDxEAIhVEfbTGAAAAAElFTkSuQmCC")
index.append('layout_content')
catalog['layout_content'] = layout_content

#----------------------------------------------------------------------
layout_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfNJ"
    "REFUOI2lkk1IlFEUhp/7zeeoIxUZqBkyzcJCWgQVhP1QIC1qVdAQbWojBEELA6FFCyEI2s6i"
    "H6xF2yiiYAgGhcCklSAFRWFmDQ1qZVMDM/P5ffecFvOPUxi9cDf33vPe55z7wn/KAJxLzIwY"
    "iGLMIWAvKgrGIIrjGBwDIoINNBt2mdvZt3EfooyeHjAAnE/MjOs/6saDNwrgAqjhMMC96ZUq"
    "mv4Fe/hgJ28/Zb2qAZaeymF/V2upN9O8+N2SB0CxuBquEahGKq++X/bWNTwVMTUCEbeCtl6J"
    "FeoISr8RH5ukKIIoJK8d42PmZ9PiWO8mVCwAThkHgG8Fn/0D3awUgurlDZFww6q2ENg6AinN"
    "PFe0+KrkvZoBgG+VbGqcH6k7FNJzpLu3sbvlKI8qBqZM4Hk+Bd9ii36DQTZ1F3/2IXviw7TG"
    "dlF4laJ9aoLBIfdSqYW6X9cmAVhOJug/coq2D88x988SmX9MLNqJRUdcAPGtUo71s+mFhuJc"
    "fpVg8TNtPTE4cbm6745tJaRmuwtgRRaA2OvbJ9dMGyDd1Ut+NknH04t4hUXyQO5XCBsiU06i"
    "Polfndwh6KAR3SwSgAoqFpWAAx1DhF++ILqlHTfUQu5rwPySo6r25h8Cu1ZTZ/qu5L9nLjhi"
    "ouLoF0FvHZ+Q678BXW4OP3EYoPMAAAAASUVORK5CYII=")
index.append('layout_delete')
catalog['layout_delete'] = layout_delete

#----------------------------------------------------------------------
layout_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl5J"
    "REFUOI2lk19Ik1EYh5+ztlnzz8pIZWGmpmYiFhYh6oVEf6ioIL0LI4jugroIvCgIQqgIL4wo"
    "0OhWukrJCwmL0mVgE01yNjQzU9emc87U79v8zulic3qRQfS7PZznfc77vgf+MwKgttF1XUAW"
    "QlQApSipQAikwmQSmARIKTFWVNBqZqQgM+UgUnGjulAAcLHR1aT+MfeeDykAM4ASVAI8dQbi"
    "auov2pfLU3GPB/U4AIOM1cO8tITo28SfL3/5qQOgaWHrmoFSttWqHp++YeU0vYtKbwsjs8XU"
    "Od6KukdFtVEDKc2rahtlabqN0HAPW4ovYM8+QHCsAHdH8/2YQXQaNbc70aREKmi/c5Sxqfno"
    "c4KvsDNEal45gVE3VhEmOSWDpO277FGAlADMLEc4st9Bu2syXjkx3ItFfcKecxx9ugWrTTDe"
    "P0xoUUBkpsQUBUR7vqAZRJRiSV8BQM07sfx6jT33JNpUE8IyhyUpmUQV4Nn3Mg5ffeExAYiY"
    "ga5HWI4YGFoEr7sN2+I77HvOoE0+xmSJEA7txtc1wI5j9Xg1OwBRg3VTVwqKbf0EfzhJKzpF"
    "2NvMJqtCD2Xh7+5DVDWwOb0QpVbWADJixAkTPS3cOmEQNhxMDz5EorEY2InvgxtR1YBITCfW"
    "NxUHGFJ+Axh8co7zuX3sq7hCwkQ3nlYn/R0BPG8GyDz7gJz8vWQ77DGAmosvEoZqrbnZmS9R"
    "Zft9vm3hzy/JLqlk3j/LqMtDZ/I1/PUfUaoXkArUghImN8R+4/pUV2xdLs1NNx8qzEFZ9Pe6"
    "33/p9N3Brxst2G+vDT2RcV/4pwAAAABJRU5ErkJggg==")
index.append('layout_edit')
catalog['layout_edit'] = layout_edit

#----------------------------------------------------------------------
layout_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAilJ"
    "REFUOI2lkk1IVFEUx3/3zfhJTmP4UVKJCxVdRDJBZQVtWheVmxa2adMqEtwFFa2qReDKEDdB"
    "ECIthGwRfRBZqIyEfeEQOUM1aJlp6sx78947p8XTGQWJogMX7uVy/ud3zv/Af4YB6OyJXzRQ"
    "jzGHgRgqCsYgimUZLAMigu/pQnGYj827IvsQpft0iwHgbE+8T/8xrg+8V4AwgBqOAPSPzOfR"
    "9A/Y5w5t40NqwckL4LN97bOxpiTozWyePDXrAGDbueICgWr5WtXEN+evhqcipkAgEl5D2yxW"
    "vo+xmBqmdk8XoeJIkOIL6wgCNzquPMYWQRQeXDvGdHoRxEY/3SNa105ycgCrroOGuq2o+ABY"
    "qzgAzGVd9rfUMp/18tWLFp4SqYkR2dGGN/MMWZ4OWvA2CAQzX7J9XFUyTiCg2TQrqWEqqqL4"
    "v4aoaT1DLjmIioeIVxAwqwSO45J1fXzbBVXcz0NUNR4He4KxO3fZEs3ifB1lMfUS9XLrCNa5"
    "rqvX5ZkJSmSJisoM4kyDCv7yOA1Hu/jy6jZFJlMQENfPKzwcSRI2Qnq8n+juvUhmEpUssVPN"
    "SC5NaWmCyM4DxMrGNS/giyQB3vSe4G3fSR5dCFFa2Uh5xRzq/QATIn4/AQhiJ6huqqetaFSf"
    "X25tDey79OSWqjQJetCIVp6vvkl7Zy8hK4l6P9m42BahsmZm371maujq4KYL++JG25x6Uq6i"
    "qEhwVCm8FURANP4bKsBLLM3GZeoAAAAASUVORK5CYII=")
index.append('layout_error')
catalog['layout_error'] = layout_error

#----------------------------------------------------------------------
layout_header = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYRJ"
    "REFUOI2lkrFrFEEYxX9znlcENFpFDkSuUVIriKClvYWxCmpraWFnIVjZphL8D9KIRRCL2Fmm"
    "EhIEwRwEGyVGDnJ7O/u9Z7HnbZYkavDBMM2b37z3zcB/KgHcX9l4nOASKd0ErmIZUkKm00l0"
    "EkgiKu/1uny+cvHsNWSe3F1MADxY2XjlE+rF6qYBugBO3AJYXr2HEZYJqb41gggRCiICSbx7"
    "9J6t4d5kBiC4AFDmkoX+uT92/rQ5BKAoyl6TwJ4DyDmzM/yGbWSwAslIQjae7gCWUpNA6gK8"
    "frj2z9NXiAMJ6tdYerZOISHD2vPbfPn688jDg/48VgDQmcYB4Ps4c31xgd1xNTOfmeu11m+5"
    "agHqXqMiyDb7kwYAkMPkcLuCqgaQpgkmk8w4B1Hkv87AVXlgBjR0+7D59Kl0GOCqAajOlwDe"
    "fthuGUf75dEJpOYnhrQNDD6+vNMyDfrzx1eQf8wAhN8sPV2/LHwjyeelCiyswKrAgSVsQ/3F"
    "Rk6drWPpJ9EvOoEbsHONUG8AAAAASUVORK5CYII=")
index.append('layout_header')
catalog['layout_header'] = layout_header

#----------------------------------------------------------------------
layout_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkNJ"
    "REFUOI2lkj1oU1EYhp+TXHNrom3SRhNSJHSw0iGLCgpJLRiiLWhFUFoQ7KLOcXARQcHpUqnQ"
    "VYQOTjrUxUGxFpVAly4OFtOChuavNvQHvfTepPcch6RplSIVXzjT9/d833vgPyUAro/P3hYQ"
    "RYgEcAIlFQiBVLhcApcAKSXOplrzaCwcO9J6Eqm4c6VHADAyPvtE/aOM558VgAagBL0ATzMr"
    "TTT1F+wb8Xbmcmt2swEO4a3g0cN6fTexe/GXJRsAy6p6tgmU8m5NzX6393Q8JaXYJpBS20Lb"
    "q6Qj2UFQd+PqgyksKZEKXj1M8bW4vmtxV6QNJR0AXA0cACobNU71hFjZ2GwmH/R6fnvNFTad"
    "HQSyfvMfloNVs2m35hkbmyMQCLBcqZA8d5E2f4CXL57R0dHO5Ooq+y2NVCrl0wBEg8C2LPKf"
    "pjjf7WVo6BqmaZLP5/kw/Rpdb2Hw0iCa202pVELTZnkz77lfJ2i47lpbIOhfp/fsBSYmJshk"
    "MoTDYWKxGPnFHI9GRymXy8TjcRKJBLlc7pYLQNYcBSB+LnLA5wMgnU5jV6sMDw+TSCQYGBig"
    "v78fu1olnU4D4Pf7dQ3AkfIb0HV35AwzMzMAGIaBkhLDMPA1mpqmiVIKwzBIJpMUCgWrbt+9"
    "d4+Vkt3WejHhKr9tjZ8+TmekE2+Lm6WlJbLZLLquE41GCYVCmBs1VSoVnI/vpxf+/LDuvr6+"
    "mM/nm4xEIod0XXcrpVyVSuWmEKIQDAYngX22bTvFYnHZNM3LvwBkfSVXqaf1cQAAAABJRU5E"
    "rkJggg==")
index.append('layout_link')
catalog['layout_link'] = layout_link

#----------------------------------------------------------------------
layout_sidebar = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXBJ"
    "REFUOI2lkjFrVEEUhb95rhsIaFCJLAGRLTRYayPqT7DT1jSbzsYiXf5A2lQBEXuxSZPO0nIb"
    "C2NESGyEWGhCQPLmzZxjsbvv5ZHEJHhgmGLuPfe79w78pwLAi9XhqwC3CeExcB/LEAIyRREo"
    "AkgiJ+91O3ybv3X1ATJLz+4FABZWh699Qa28+2yADoADTwDefPxVo/kf2INH19n8vlfWBmR6"
    "k8c7N6dGvYWTk7d2SwAOD2O3IbCnJ1W//izPNTxLoSGQOhO080pZHCEYbePlxiJSRjZrT9+y"
    "/WP/xOT+3AxWBqAY4wAQY2S2d4NYVnXwlelu69QtpJbBaOZVTACUZWxVrLKpcnsvUmoMQk1Q"
    "jY0qzpJTPDKD8dZTSuM7t4IvXzq+Uzs1BhrxhZwyn4ZfsFUHHvyJx5IBLDU/MUs7QP/9YL0V"
    "1J+bOb0F+XdtQPb68+UPd4UfBvmalMDCylgJnLGEbUAGHzgUm6e6X0R/AbWv6xQyJC4JAAAA"
    "AElFTkSuQmCC")
index.append('layout_sidebar')
catalog['layout_sidebar'] = layout_sidebar

#----------------------------------------------------------------------
lightbulb = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArxJ"
    "REFUOI2lks1rVGcUh5/3zr25M5lMZuIwNolJrSnSkKrRNrEQqSHiorTQRYgtYgOh0A//ALuQ"
    "KAqFULoolELBhUKppUU0Uk1rIrYilFqxErBJEw0ZmyjNxMmHM3PvzP16XxfBaO3s/G3OWTzn"
    "4Sx+gqeSnz3znlZy9qrA2uyXCinlPhDKsSzp23eFHh1Mvv7ZkSd58Wgp3DldpwXquGZG3wiF"
    "EwgzgdArEUIgSzb+0jTW1BBe/n7aqHnx7WTXwF+rAvXvcLSQn/vVrGlqD1WvByRIC5SLki4g"
    "EUYcIVIURk+Sm/hxUa9/raV290BGBygspQ8bsYZ2Pd6EkjZCi4CxbmUCStood5bA+4PYq72U"
    "MrfXuAvpE8CbGkBgL+8LVT0PygahgwgDcuVQ2qB8RKga0PELF6l+pY/iXLoLQAcISrmUZsaQ"
    "fgaEAbKICgKQPkp5COWiNJvAmUZ5U1TEO/CLrrkqkI417+fnG/REFe789witkuL1W6CHQXkE"
    "uQzRnduRpb8x4ttwFzOIkHAANAChRU7a6SuIUC1Ij9z5HzC3pjA3VVHRYlC54yWWvhlAOgvo"
    "yW4Wr36LUV1/dVWQxOx3slOT1sQwZt0HiHAEUBCyQbdAKbRojMoXDpIfHWV57IJTkWz68PEH"
    "XUd9EUm8W5j4OWtNXsOIbV4pRxBByBSg0NdsJ3djintn+/1Yc+f7jT1f3v5PkQDujxxoy2Wz"
    "5yLFe7U1Gwwqmn1QLnI6wezwb+SMhnxNS1vP+j3HRv7XxEf55btP3xq/NT0YT9UalnWZguUx"
    "v/Qy/4z9qT7u697V1Xv0ctkqP5lDn3w0s7G1s5FAwy5a5O0iv18czJ756VLqaVYvJ3CKpbt1"
    "z61tbN3SyszMDDfHxgkJb7kcW1awu6Pl62Nffd66bAUR3/cIG5T2v9P5xamhK+XwZ8tDrVYu"
    "lLqJ1K0AAAAASUVORK5CYII=")
index.append('lightbulb')
catalog['lightbulb'] = lightbulb

#----------------------------------------------------------------------
lightbulb_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvhJ"
    "REFUOI110ktsVHUUx/Hv/z7mzrMzZRic1sZHicE2CGgLJvWRICwaiF3oylciC4khwY0xEEOI"
    "C0xLDDusCQtNjPhYaFUgsTwsKmmqcTEpVBFqRwNopwzTMjP3zr137v3/WTQ0AvLbnLM457M4"
    "OYLbUrv01cua672gQvuRwK3nlH9dKM+2ZeBcFkZiJPvU/nf+Oy9uNvW/vmzTQvWhZiX69WgG"
    "YWUQRhwhBNJ1COZnsKeP0axdLZqtKweyGwfPLQHq39FEvTY7ZrV2rtdb7gckSBuUj5I+IBFm"
    "GiFy1AuHqZ7/tmK0P96d3zxYMgDq88W9ZqpjvZHuREkHocXAvHexAko6KP8SYfNnUj2v4JYu"
    "LvOvFT8CtmgAobPwkp68D5QDwgARBeTionRABQi9BTAI6idoeexVGrPFjQAGQOhWc5qVQgYl"
    "ECbIBioMQQYo1UQoH6U5hN4MqjlNJN1H0PCtJUB69lxQm+swMkn8uc8RWpzGrxfAiIJqElZL"
    "JJ7egHR/x0w/il8pIXThAWgAQosddoo/IvQ8yCbVo19grcthrU4S6TaJP7GK+Y8Hkd41jOxz"
    "VCY+wWxpn1gCslh7vPL0H/b5Uay21xDRGKBAd8CwQSm0RIr4A29TKxRYmPrOi2Q7t9/yB6VT"
    "u9bK+Ssnk6u2LA8vjhHpSS8iSgGK0ZN/M+7HuO7WsRtVt1wtvzu6/+y+JQDg6vG3eqvl8pFY"
    "40q+9UGTyMMBKJ+jZzIUtAw9Xb10LHuIsamvmTj3E8Xp8oFbAIDvP9239bcLMyPpXN607dPU"
    "7SaTVobnn90KusZA104OnNqOjsZnI9+42u3AMy/uOVZyzFmVWU08/wbJ9tep2GVMkWSgaycA"
    "b246xMoVaxCI6B0AgNdwL7fds4L+/k309qxjoVZh6p9xhk5sA2Do+Db+nJtEoVzj/4DNfd0f"
    "HDr43toFO4wFQROjLRFOTI4bfWue5MjZYSLC4EzhB0C8f8cN7pYNO/JDCLFDQEpBDaWGfxme"
    "3X0DyPBMKj6SCb8AAAAASUVORK5CYII=")
index.append('lightbulb_add')
catalog['lightbulb_add'] = lightbulb_add

#----------------------------------------------------------------------
lightbulb_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv1J"
    "REFUOI110ktoXHUUx/Hv/z7mziszk06nTmLbNFGsxGrUWoWKQkvRWsFFFxVf4MYHioIL8UEp"
    "LsRUdCkWXKiIFQW1EI2YGG0xKpVWCKJ1TGKmJJl2Jskk48zcO/feuff/dxEMNupvc87inM/i"
    "cATr0pj79EHN9e5ToX1t4DZzyv9TKM+2ZeDMCyNxInvbqy/9c1783TTPf9KlheptzUrs16MZ"
    "hJVBGHGEEEjXIViZwZ4ept1YLJqdV9yT3TP4yxqgLo4kmo3ySauzb5ee6gEkSBuUj5I+IBFm"
    "GiFyNCeOUy8MLRvdt/Tn9w1WDIDmSvGI2bF5l5HuQ0kHocXAvHy1Ako6KH+OsP0jHTsfwq1M"
    "bfCrxXeAAxpA6NQe0JNbQTkgDBBRQK4uSgdUgNBTgEHQ/IrUjQ/TKhf3ABgAoVvPaVYHMqiA"
    "MEG2UGEIMkCpNkL5KM0h9GZQ7Wki6d0ELd9aA6RnLwSNhc1GJom/8CFCi9M6OwlGFFSbsF4h"
    "cfvNSPc3zPQN+MsVhC48AA1AaLHjTvFbhJ4H2ab++UdY1+ewdiSJ9JvEb93OynuDSK+KkT3I"
    "8un3MVPdp9eALNZhb2n6d7swgtX1CCIaAxToDhg2KIWW6CC+7UUaExPUfv3Si2T7Hr3kDypf"
    "PzcgV0pjye0HNoZTJ4nsTK8iSgGKuXe/pzpVwblYQlpaVbaD1/ePyaNrAMDi6LM31ZeWPou1"
    "SvnOXpPI1QEon/mPXWqzkqv2HsLqvYbWz6OcGx8Na4XCM5cAAN988PLd5yZnTqRzedO2T9G0"
    "21x5ZpI7njxC7I9TUPoO0hmWjB5+GhkvauuBvfcfHq44ZllldhDPP02y+3GSrkM03wtPDcHR"
    "ZXhhBsMuoCuxzVgPAHgtd77rsk1bBq4bYHZ2loUvMjgTwySGnsBrlXGARl0n1Lnwn8C+3f3H"
    "3nrjtYGaHcaCoM2dqU3hhh/Gta0bY5qhmzQWA86XRaiUfPNfN/i/jN+75XmneuExTYoeqamS"
    "RB27a0y+8hfEz18CPibDsQAAAABJRU5ErkJggg==")
index.append('lightbulb_delete')
catalog['lightbulb_delete'] = lightbulb_delete

#----------------------------------------------------------------------
lightbulb_off = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqtJ"
    "REFUOI2lkstrVGcYh59zP5PRyYy5mGhSMaYUB2MQTCSihEgWUqGlVARRiF1U8H+Q0r2CG0Fw"
    "oSvdRHEhuhDBC15BvEQNKFZjkprJZEYnM3PmzDnf+c7nojXEmJ2/1bt43ocX3p/GkoxNzR0U"
    "Qu4PY9UThFGLH0ZaEEVeKNW0pWuXfuv78e/FvPZlGJ/ItwdwxrGM3UnHwrUMbNNAA4JIUqzW"
    "eT5VoFoX79IN7i+/93e/WBA8nZlJ1qvcaG1M9GWSLnGsiOKYSMbIWKEA1zJIOhaP3s3ydCL/"
    "cX06nf11YMOsCeCV5V+ZFYm+5pUJQiGxLYMGw8Q2DQACISnVAiaLFfq72sjN11bla7WzwM86"
    "QDUUBxoTNqGQaJqGqeso9d9iICSxUiRsE0PXeJ37xEB3O4WKPwRgAgRh3OJaJl4g0HWNKP7/"
    "dKWQsSJWilDGFCo+xWqddc0pgihyFgT1KMpXA9HhmAZP3udxTAMrdxfdsFBK4nsV1Lph5so+"
    "HU0rKfshuq4HADqAbejnXuc+kUrYKKD8YpRSpp+PqS3kklvw1wwxc+8UXiDYtLaJ+29maGyw"
    "HywIGivTR+cq/quX/xbZ1tWGYZkACBkjZAyA7boMb/qBiUKZsfdzQXPKOfxVDy4+fts7X/Gu"
    "93S2NP+Tnydpm6hFhcmVPLJrm7j6bCL6qX3VyMjOjee/EgCMPnyzdb7uX/aDqC3pWOiahlQK"
    "xzQYmyrgmkalqy2999CO7LVvmvglZ2+N7/FuHL9kr++3CqVneL6g5nfy4c4FNXz0/K4/h3pu"
    "Lub1pYI/BrNXZmtWzjVTdGQG6cwMsCbdhHBai0uXF964NIFfn25f3drZu7mXyclJnr8cx9BE"
    "aTl2WcHw9uyp0yeP9ZY8mYgigWtRP7Jv8MToldvL4d+Xz4LoNqyX3hTIAAAAAElFTkSuQmCC")
index.append('lightbulb_off')
catalog['lightbulb_off'] = lightbulb_off

#----------------------------------------------------------------------
lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhNJ"
    "REFUOI2lUsFqE1EUPTOZTCxtQm0CXVRSbU0DVVFcWJBiBRcSRVARhdS66Q+4sT/g0pU/ICIo"
    "6EKxC9e6smKpEQyapLEiRW2bmNRkMsm8d+91kTbGmCLigQv3Pd45h3vPA/4TRvuhsHTynrDM"
    "iAiEGWCBULMX5lbPmj5HE6lhALDaBZhkun9kGsICEEOIfpUm1Aqv4ZZz1W3ybwIbiydu2sGY"
    "CQZU8QlEabBSEE/BH7mIevk93M0sRROpYLup2eY+t6v/MKj2AaIJoprlj5yHV12FW85BWMU7"
    "d2ACwNrC5CW7N2rDsEFOGqIJTBq+vqNg5aBezkLVK2eHz6TzXQXAfNcOxiDagWi9NbOGGYjC"
    "LWXQqK7e2Hcu9axrCl9fTk747fBCcE8CXmEe7CmIUuB6HfbgBRSy9wXEXisBYggxmHkzPpMf"
    "tAzN83Z4DEIKVug0hDREEyCAaMbA3suGaBVopsGobiyhVsrVDPKOA4DFwoHqlxeNVt5bDrtH"
    "rgTqKw9h2EPwDxxDrZiGW8pBe+6d+LX8bNePtI1PTw89Dw2dmrLsMEQrVL4twi1lfpgGj40m"
    "V9ba31rdBIR5ygpE4Ky/hVvMgDznduxq/nrXJXZefHx84E1PaP8RYYJTyHw3occ7XXcUePdo"
    "vK/X8lWEGKQat2LJ5bmdiF1H6DH5lfZovWH6Rg8ml6t/I/+BzIPYxL9yfgKK+0bGbsV1lgAA"
    "AABJRU5ErkJggg==")
index.append('lightning')
catalog['lightning'] = lightning

#----------------------------------------------------------------------
lightning_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApFJ"
    "REFUOI2lkU1olFcUhp87znyT0IzYTGhSjIk1jmksGtESi4gKoUhaKm0RxYgLtymuROm+XQTE"
    "ZbPoqhQU2kWbprTgD7SixEkVO6QJmkzSFP+TTJzEfPOT+e49p4vEmNjZ9cCBcy+c5+W8L/zP"
    "MisfmTsHvlXRE6qKioAo6hZnFVmexbr7DR2pRoDwSoA4Pb5u03FUFJygzr1s68hnblGYTfsv"
    "llcBpm/v+8KLJUIIBDM/ooFFggAtBURqPqU4e5fC3Khr6EjFVoqGVqifrVjXisvfQ61Dg8WO"
    "1HxMyX9IYTaNStD8qgchgMnk3sPeaw0exsPlhlHrEGdZU7UTCXIUZ0cJivMfNn4wPF4WgMg3"
    "XiyB2hxq7dLNllC0gUJ2hAX/4Zm3Pkr9WjaFJzf37o548WSsvoNSpg8pBWgQIMUiXu0nZEYv"
    "KE5Kywk4QZ0gInPNJ8Zrw8ZKnxffgrqA8NqDqLOodaCgVqjeeMSoDaKLaQj+9B3y2XTeuNIe"
    "gLCoRP3H1xaW815SeH3T0Whx4juMt55IdRtX0yMknxmeL0R5ntvgsv7MMXjwpSl31z8/bft9"
    "7fr2/WEvjtqAX4ZSpCvj7Gp5l/rqBL8N95Icus7EWOZ8qBxARfaHozXkpgeZGevl0iPf7Xi7"
    "FRdytL75Ps4EvLdtD6Cf/Qfw9w/v/FkR24z/JIk/mXqmdr5uxs+uiZgqDrWcAuB0+9c0vbEd"
    "g6lYBRj6fmuVIbSjkB0jl7l3LtGZjjd1Tkxm5iaLw4/76b5yEoDuyycZnxpE0eIqQGVIBmyp"
    "NJVXjSU6x86++BfR88nBfjzC/PxXD54JcyN1DTBfrTJx5GJid3NneqCcL21ddd0Y02UgpjCP"
    "as8fPU8//xdo7nzCRXscIAAAAABJRU5ErkJggg==")
index.append('lightning_add')
catalog['lightning_add'] = lightning_add

#----------------------------------------------------------------------
lightning_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn1J"
    "REFUOI2lkduLjWEUxn/fYX97HLYwk0OYg2yKRC4oyXFKQwoZQv4BdxTJlXKj3LtTKIoLhyk0"
    "DjkVI6chwxwRYzYze8yesc/f+67lYhgz2ndWrVpvred53mc98J/ljH4kX649p6L7VBUVAVHU"
    "Ds8qMjKLsZ8r65qrAPzRBGJ17+S5e1FRsIJa+7eNJZt8Ri7Vkf4DHkPQ93z18SAWdxEI+6+g"
    "oUHCEC2GRCq2k0+9JzfYbivrmmOjRd1R6ofLJi/BZltRY9FwuCMVWymmu8mlOlAJF/x7Axfg"
    "e9OqHcGEygAnwGZaUGMRa/AmLkPCDPlUO2H+5+aqTS1dJQkQORPE4qjJoMb89mxwo5XkBtoo"
    "pLsP1WxpvlEyhcSTVSsiQXlTbHYdxWQDUgzRMETyeYLp20i2n1esFEcSsIJaQUQGF+zrmu47"
    "RhqC8vmoDfEnbUStQY0FBTXC1OqdjpowOpyGkO57SXagI+vY4koAX1Si6Z4HhZG8fytMmbsr"
    "mv94ESeYRWTqcnru3aX/RRuF3iGsq/2K1gMnnFK+Pl1bfH/SrA1r/KAcNSHdd25iej3mr6sn"
    "WrOI3JtbvHt0y6ZaWw+4pQhUZI0frSDT94b+zqskHr4ejK+rp6zrPs7Z3Yz/cIXqqgrPogf8"
    "f8EfLi96VRabRzrRRCbZ9sPFLNSsJMpm1MCmgyN7/rGZeOpUjyF4e2nhRAd3aW6gExsWTsb3"
    "dB4GaKz1vmabr8+e0LCfQu4bWeDnkIf16BljYZwrT02x2JtVjf0BA4wvn3a65fEDk8iPY8iL"
    "MPDDobPbsap6asz32y7EV5S6CcCjXXOONNZ6H2+v96Wx1vtys9Y9CvALx619B4JO0ZcAAAAA"
    "SUVORK5CYII=")
index.append('lightning_delete')
catalog['lightning_delete'] = lightning_delete

#----------------------------------------------------------------------
lightning_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnpJ"
    "REFUOI2lks1LlFEUxp8Z50MdR0ytkbAxNROTKNoYYRlIhkVQEW1EWrcKotoYEbhwEUF/QgS1"
    "aGEk1CIMFCyVzCSymhG1THPMEWecr/e9955zWpg25uw68MC593J/5z7nXOA/w5G9iI6ffCQs"
    "nSICYQZYILSeC/Nmzobmgu0TVQDgygYwSUdJTQeEBSCGEP2VIaSj75CJTSU3Lm8BLI+d6Pb4"
    "65xgQK88g2gD1hqiNNzlF2HFviATD1OwfcKfXdSZVf1WfskhUPorxBBEr8tdfh4qOY9MbArC"
    "uv7fHjgBYGmk+ZLHF/TA4QGlJiGGwGSQV3QErFOwYmFoK3G26szkdE4AmB96/HUQk4IY88ez"
    "gdMbRGY1BDs5f7P63MTLnFNYHG5ucnvKRvyV7VDRPrDSEK3BlgVP4AKi4ccCYvUg4fOmjML1"
    "grTtIgYzx+s7pwMuh+E+T9l+CGm4ik9DyEAMAQKIYZTuvewQo732xxeoLG/A3YVx7x0fp92k"
    "jgGAi4W9yZ+D9ua8aV33Y8VeYQXFBsoQdpfWoaGiCQkrhWvzI/nazUvbPtJGfHt+cODeWmHL"
    "qcYrIGEQExiCSHweO3y7MDzTj/dzg8wOu9SVCyDMLZZRIGF8X5mCZgPDGpo01uwEDu85jqRO"
    "O0dnh1a2AWZ6Gz/k+/fBioZhyCBQHIRhAgljMT6H0qIKjP94g6HpoWVFaNti4dPTA0U+V15C"
    "iHEjmkbGVqJYwTIKtTsbHUdr2jA29xb9oVcRRWiN9ODzlhcUOHnUKPplO/Nqe6/OJrPPVruH"
    "Uw5nQeFA+PWCcaA10oPQNu+hJ3VNuXoCANW3kQp25UmgC9XZ+78BUOyI/7ckM6oAAAAASUVO"
    "RK5CYII=")
index.append('lightning_go')
catalog['lightning_go'] = lightning_go

#----------------------------------------------------------------------
link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAaNJ"
    "REFUOI3tkjGLGkEAhZ/OjsOxidnFFWEs5JRlicEuxObAIpqkk0AIWmiXK1LZhjQhTbAQYnN/"
    "ID9ASBkRTkggfTpFzggznoywILPkFCemuQv5A6mSVz148MHjPeC/YjemVqvZvu+/5Jy/4py7"
    "s9lsEYbhcwDfXdf9UigU8lLKUEr5bjqdng2HwwgACAAUi8WE53lvy+Xym3a7fcQ5RzqdvqOU"
    "ephIJB63Wq27+Xze8jzvaLfb1ebzOaWUjpVSxgIAxtiTIAhOq9Vq2Ol0vm42m0fZbJaUSqXj"
    "5XJ53Ov1IIQwyWTyU71evxcEwamU8jOAj9Z1gxPHcdhoNOporT9orVeNRuOW67rQWkMphX6/"
    "/yMejz9TSrUcx3kP4OQ3wBhzIYS4SqVStymlA0II63a7sG0bABBFEQgh7DobCiGujDEXAHAD"
    "OJdSXvq+/7rZbP60LIuuVitMJhMwxpDL5ZDJZOh+v7+/WCweSCkvjTHnf65AKpVKybbtAec8"
    "zRgjh8Mhvl6vX8RiMeF53gAA3W63Rkqpoih6Oh6PvwEwf+8g/5B+ASIAqzVg9YveAAAAAElF"
    "TkSuQmCC")
index.append('link')
catalog['link'] = link

#----------------------------------------------------------------------
link_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjhJ"
    "REFUOI3t0bFPE2EYBvDn7uv1Kx5gD1okX02ANpdaTHWQyELsQIsOBBY1kNgmDDKQkDRx0bgY"
    "F8rQxC4Mrg6OqIMDTaMGMcQNIjEBG5B4H5SvWlquUpoc5wK4mf4BPtObvMkved8H+B/pdIjF"
    "Yqqu61OMsUeMMS2fz2+XSqW7AL5rmrYUCAT8nPMS53xmY2NjLpvNVgGAAEBvb6/T4/E87e/v"
    "f5JIJJoYY/B6veeFEINOp/NmPB4P+f1+h8fjaarX67GtrS1FUZQPQgjLAQCU0lvBYHAyGo2W"
    "ksnkcqVSGfL5fCQcDvfs7Oz0pNNpGIZhtba2LoyOjl4OBoOTnPOPAN44Ti4YcLvdNJfLJU3T"
    "fGGaZmFsbKxZ0zSYpgkhBDKZzKEsy7eFEHG32/0MwMAZYFnWpmEYtfb29hZFUeYJIXR2dhaq"
    "qgIAqtUqCCH0ZJc1DKNmWdYmAJwC7znnu7quPx4fHz92OBxKoVDA+vo6KKXo6upC7dwvZfvg"
    "a2zlaGGo7Csfd0TsS1j92wKJRCJhVVXnGWNeSimxbVsuFov3JUky2nT6tvMqcV4L9eFim453"
    "a6+w/GURm9+K6bMa/5V7M9HDO8PDLhAZI6FppHOTIJDxcv51TW4E2Dd/uhSpGSOhaQDAg8Hn"
    "CHRcgQTJ1RBQLBdqa/wTUtkJAEBqYQL5vVXYsGukEYD1NTcd1MWN7gvdKP7+gXJ1D0sri6js"
    "H2Ua+gEAXJ/qTEGSpiSgxQYOYNtzn+d2H/4B8Z/aXnPTd+4AAAAASUVORK5CYII=")
index.append('link_add')
catalog['link_add'] = link_add

#----------------------------------------------------------------------
link_break = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp9J"
    "REFUOI3FklFIE3Ecx3/t7nbObbLDifNGLZvrajZfWlJDCUpFCHSQIhssImjBXtpLgWkJES0E"
    "IfYQGFEPQpAVUdRLojNKsofhwt1mm8M2uL+buyHcdupst/UkRGg99NDn7ffjx4fvF34A/5t9"
    "vw79kxWsnEk+KmyU70mVSvpEkyLp66M1XSPfWq3N6rmv8c2Jd0PGS3sKAADO+ZbdRxurby0u"
    "iz2YDC5sb5THrS3qUPT75tvX143n/5hgh67bMafJUH0nGCo3N+hKE1iVrO7F1YOn96zQ2dmp"
    "NJlMHpqmB2maphKJRArx+fyTcf8xj8ejoyhqzmg0HkIIrSOEfPF4/MHU1JQIAICbzWa5XC4f"
    "YRjm2sDAAIiiCEaj8UAgEFgBAKAoatLlcukJgoDV1VUqGAyOJpPJOrPZPByJRLZxkiS7GYZx"
    "d3R0rHu93nlBELr0ej1msVjuAwAUCoX2sbEx4DhOqqmped/b29vMMIwbIfQJAN7IAKBNo9GQ"
    "09PTg2q1uk0URZXT6VRYLJaHAAB2u11hs9kUgiCYVSpVSzabvavRaEgAaAMAwCVJWuE4bqu2"
    "tlbN8/xnmUwm+Hw+QqlUAgDs8/v9jCiKIYIgfuRyuQCGYWqO47YkSVrZEcwihNImk2nI4XCU"
    "cRwnMpkMxGIxAABgGCZkMBigvr6eKJVK1lQq1YoQSkuSNAsAgLMsG9NqtY6ZmZlXNE3XkSS5"
    "ValUZDzPXwYASK+JS/l8WB8Oh4lisUgihLKiKDpYlo3t+QfdN6IfNvNStpgWXDqLlo0tCsOR"
    "59anu93Kfl+c8bIvG3TkSX6teLOIKXxLC0LfYbNq9Ih93v1Xge1K6PH+RkXPl4+5dvbZ8WiT"
    "pfriNg6J6IJwVlFFnIL+SWw3yT/xE4+BHceJSQc1AAAAAElFTkSuQmCC")
index.append('link_break')
catalog['link_break'] = link_break

#----------------------------------------------------------------------
link_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjZJ"
    "REFUOI3tkU9rE1EUxc/Mm8kzjLYzJoE60cRMCLENWUoRigOa+G/TTdFsEle20FXale6KC6WF"
    "ggXRD+DeQqGgjYVKK7gRioKUhNgqvFfDpI2mk7amzoybNkvtB/CsLvdwf3DPAf5LOBqy2ayS"
    "SCRGdV1/oOu6Vq1WvzUajdsAvmqa9i4ejxuc8wbn/HGlUnlWKpVaAEAAoK+vzxcMBh/29/dP"
    "FAoFv67rCIVC3ZZlXfX5fNfz+XyvYRhSMBj0t9vt7MbGhizL8lvLshwJACilN5LJ5HAmk2kU"
    "i8X3zWbzWjgcJul0Ora5uRmbnp4GY8zp6upaGBwcTCWTyWHO+QqAOenwgwFVVeni4mLRtu0X"
    "tm3XcrncSU3TYNs2LMvCzMzMniiKQ5Zl5VVVfQJgoANwHGedMbYfCAROybI8Swihk5OTUBQF"
    "ANBqtUAIoYdeiTG27zjOeifEVCrVaxjGS9M0eyKRiCtJ0ularYZyuQxKKaLRKGKNT/Ctzrtu"
    "nYs7knzQbLtP7y7tjx+1QEzTTCuKMqvreohSSjzPE+v1+j1BEJjp356/FLDphStDoLEU9j4u"
    "4PPygvNjbW2sU+Pf9CpDqpfHpgx/dQlgK0C3iroUxYfXy+vSP68BEFeIneiJAbfGOztp4gyI"
    "J5w/FsAVPba7On9WmRvFr73v2AWw0yRwCDg5DmDkYk/3do0PiD4iHpAWfm55+MJFx/ntTR0r"
    "AwBYvnPu/u4WHxFdIeqKHnPhPb/5xn30B0qT3dcfFCXvAAAAAElFTkSuQmCC")
index.append('link_delete')
catalog['link_delete'] = link_delete

#----------------------------------------------------------------------
link_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn9J"
    "REFUOI3tkd1LUwEYxp/t7Oyom7nDpujZJk4b5ti0kYnG0qycZhSClEuSgkGQEX1QUNZVCrJ/"
    "oKDsog/Ci8irghCxrPyqIEmZNuaytjPcprN51s42z9ZVEtM/oef69/x4Xl7gf0QA0NTUJNPr"
    "9d0Mw9xkGIZ2u90/wuHwSQBLNE1/KCsrK2VZNsyybL/L5bo7PDwc3RQYDAapTqfrs1qt1zs6"
    "OhCNRuH1ejE6OupJJpPerq6uGpIkKb/fD9b5ApU5LAi5CdHQW4D3nRGZzebjjY2Nj+12e6q3"
    "t3cyEolY1Wo1YTKZ4Pf7EQqF4PP5hNaa6Gx7fW1Vtmo/8nRmrHkm4Hw9sCwBYFEoFNTIyMhl"
    "juOecBy3bLPZ5DRNg+M4BINBTA33J0+dOFIh37EXq24npKIEcncUQq4szpMIguDx+Xy8UqnM"
    "JUlyiCAIyuFwQCaTAQBK84PoudiSpdA1I+4fhDRHhKUv80jE4it8nNtHqFSqqEQiOapWq1st"
    "FktRXV2dXKvVQhAEVJen0H3aCMXOY+DZ+xBLfwMoAO+aWYnH+MPVl17NiQAQDQ0NJplMNsQw"
    "TD5FUUQ6nRbrqYkHtk7rhQJjG3jfPYjJDSTWdQi8GY/GuchB443P05tvzMzLvsJ2XXXns/L6"
    "Nmli+RFERAL8Lw0CY9MxIcEZKq5Mff/LEpnlh+c1duOBs083wBDC+nNkydKIrWkQHJsMILG+"
    "Z9fVj55/eUmmILekfMBgOYeFwWv49m4cVHEVkoEFVkGgefetT4uZ/JYFlSXZt2s1eWK6SItV"
    "bwg/55wcQRKHLHdmvm537haBMifZs7Q4hw1uJRWnhPdipFpaHbPz25UB4A+w9f0Kpi+5PgAA"
    "AABJRU5ErkJggg==")
index.append('link_edit')
catalog['link_edit'] = link_edit

#----------------------------------------------------------------------
link_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnxJ"
    "REFUOI3tkd9LUwEUx7/bvXdT5+xON3R3WLhxuzlYaFILFHxwM6uHflgyE30qIXtZTxE99AOh"
    "pJd6kei12IOLAsF6MGvZD7KSRBrVxJzL3e3upqM1dbt67+2htIj9CX3hwPlyOB/4ngP8l2aj"
    "8Xq9BpZl+xiGOc8wjGl2djaWTqc7AMybTKaXDofDzvN8muf5qzMzM4Ojo6PLAEAAgNPp1JnN"
    "5itut/tST09PMcMwsFgsW0RRbNHpdPu6u7tr7XY7aTabiyVJ8kajUYqiqGeiKMokAOj1+jaO"
    "43o9Hk/a7/e/zmQyrTabjXC5XDWJRKLmYfA66mqW1aEQnjS3HGI5juvlef4FgGHyd4Immqb1"
    "Y2Nj/mw2eyebzQo+n6/UZDJhObuE8pUgqhztmipjMPx4XgzSNH0DQNMmQJbluXg8nquoqDBS"
    "FPWAIAj9wMAADAYDPLu06Dh2BGXWeiy8D/QxpanBcFjMybI8BwAbgBDP80mWZS90dnYqJElS"
    "giBAjIfRuCMJo5mGnBlGdcNJcnE8cFpIfv8iy3Jo84iiKKatVuvzeDx+OJVKlcViMSWVEpT9"
    "tV8n2D1d1TrNNN7cDcLeuBeZTyGisiR/7Vbw7QgAdfON/+pD4ECbobL+EePiIGee4l1wCrtP"
    "tCIvNyMy0v9RWoG76dyrH9qCy0PHdWur+X56ax2UlWmoyioa2jkoEo+ioggqd/pqgdxZACgI"
    "yC0lT5WzBxtKjN+gri8CGgKT9yMAFCi5CCzbt0GWpDPjF53OghEmbroXXF0BG6GNQl1PA1D/"
    "mmpBFHMQwlP4PHz5HlkIsJaXiiZvH11VFRWqovwqVcUfrwKKAihq1U/LQRhVWZnvXwAAAABJ"
    "RU5ErkJggg==")
index.append('link_error')
catalog['link_error'] = link_error

#----------------------------------------------------------------------
link_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAklJ"
    "REFUOI3tkktrE2EYhU8zN8u06Uw7qeWrqEmMoQkRdGG6KGTRpl42FRfSLtIuCkVcZekNvC2k"
    "SFEQqjsRf0DRnU0LBhPtIgi6UtJrdCYtHxobJ5hM5pu4MUUL9Rf4rF7O4nBezgH+09I84vG4"
    "HAgELhFCrhBC1JWVlUKpVLoAYENV1azf7/cZhlEyDONuPp+fTaVSFQDgACAUComapt2ORqM3"
    "x8fHWwkh8Hg8HZTSQVEUTyUSiT6fz8drmtZqWVZ8fX1dEAQhTSllPABIknQ6GAxODQ0NlZLJ"
    "5FK5XB7u7e3lIpGIt1gsemdmZqDrOnO73fMjIyPhYDA4ZRhGBsAL/vcHA4qiSIuLi0nTNJ+Z"
    "prk1OjrapqoqTNMEpRSpb/dcjC+eoZReVBTlAYCBHQPG2Jqu69Wurq52QRDmOI6TpqenIcsy"
    "AKBSqYCct1q8PX3I1mYfK3rsO2NsDQCaBq8Mw9gMBALXxsbGHJ7nhfTP+3BYGZZjo84YSOcR"
    "9PVE8aNawfujzzvs153pP1vgYrFYRJblOUKIR5IkDv25ffHwBFjDAXMYHDSwuf0FqtyNt6sL"
    "yBXSdu5yTdypcTeTT443zh6bxMbXPOqODdupo87qcLlEdLcfQGb1JZZWMxa/l0HVrsJmNva7"
    "D8J2GFjDQXG7gM62Hrz7nEV2OfOxXsGJPROce+RlVcuC5Vio2Rb8WtjV7xtGrvAGC5/mP4jb"
    "OLn8ELV/jPRvwnda6MTTwcahq8iFbkBs6nsm2M3h66BOg9MKPBNwC3ZT/wUCkvljD8e10AAA"
    "AABJRU5ErkJggg==")
index.append('link_go')
catalog['link_go'] = link_go

#----------------------------------------------------------------------
lock = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAopJ"
    "REFUOI1lks9rk0kYxz/vJH3bxLYbfxaapZtq/IGCiLd6EAQ9LC572N2bJ9mDLORW7B/Qq3+F"
    "0IPk4Nm7YEEqFjRaqzXEoiCRTeyb5E1m5nlmD+/WzdaBh3kemPnw/X5nIg6ser0+PRwO76rq"
    "kogc8d4jIn+r6jpwr1ar9cbPR+PD2traJRF5WC6XF2dnZzHGoKoMh0Pa7TbNZrOpqr+trKxs"
    "fgeo1+vTg8HgebVarVpr2d3dpd/vIyLk83nm5uYAaDQa74rF4sXl5eUUwOwD0jT9a35+vuqc"
    "Y3t7+32SJJVcLhfHcRz3er3K1tbWJ2st5XK52ul0avv38vuNc26pWCyys7ODiPxSq9VaY+5a"
    "q6ur11ut1qtKpYKILH0HEJHjxhiSJKHdbjcPhisizV6vhzEG7/3x/2XQenw7rO+c5fPXAiLC"
    "rxc2yAVHEE/wWTkn3N+8jKoyN9XhZnmDc3eeR5mCEPjj92tEGKJcgYifQSPITwEBxCE+YfVG"
    "H9QB8O7Bk/8sBPFAwH+pk588RhRNg05AoQRBYfAV2XuLTT+ifkBhsUawozGA96ABxNJtPMOY"
    "Q5TOX2H30T2CnmDh6g26Ww1s2mGmcpgQhODsOMBBCARxlM6ewcTHIFJkJLz4UmABS+nUIsP+"
    "JMEPIOg3gAEIzhGCgDg6LzfpNp6C8ehQGaUjCJbum9d0tz9kdlUJzo0pcC6jiqV0ukKueBSM"
    "5eStO5x0HvY+88OpeeK9iUyBhoMAC6qot3QbDXLFGZiahnwM6mGvS9pp4/oJMwuzBDSzPQ4I"
    "QZj88U8KP+WI4snsCc0EqIBNmUkTxI0IKlle3o8B7Ij3D+9mWXhP8O7f8t92RLKPJZL1KgD8"
    "A3KBmp11082qAAAAAElFTkSuQmCC")
index.append('lock')
catalog['lock'] = lock

#----------------------------------------------------------------------
lock_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtRJ"
    "REFUOI1lkVFom1UUx3/35muaxFji2FbWDM00dVWxHSrDFhmKVhBlD7qHgU/DhyGNT8Xic30R"
    "6qP6IIgIfZA8TEEEUUGHowWprLbL6OqyEIrVmWLaJk2+fPeee32IrXE7cLjnwLk/zv9/FHdE"
    "sVhMh2H4tnNuXEQOWWsRkb+dc4vAXKFQaPbOq95mfn7+lIhcymazJwYGBtBa45wjDENqtRqV"
    "SqXinHt1ZmZm+S5AsVhMt1qtq/l8Ph9FERsbG+zt7SEiBEHA4OAgAKVS6WYqlRqdnp5uA+h9"
    "QLvdfnNoaChvjGF9ff1Wo9HIxWKxeDwejzebzdza2tpmFEVks9l8vV4v7P8L9gtjzHgqlaJc"
    "LiMirxQKhWqPuurs7OwL1Wr1ei6XQ0TG7wKIyBGtNY1Gg1qtVrnTXBGpNJtNtNZYa4/8z4Pq"
    "Txf8Yvkkt3eSiAhnH1si5g1eLN520xjhs+UncM4xmKjzcnaJkYtXVXcD7zn32nMoNCqWRPES"
    "OAVBAvAgBrENZif3wBkAbn6+8J8ELxbw2K0iQf9hlEqD64NkBryD1g6y+xtR+3ecbZE8UcBH"
    "nR6AteA8SMR26Re0vofMoxNsfDOHd0e5/8wkXy+VWWj2sdsBc3mOsbbuBRjwHi+GzMmH0fHD"
    "oBzSEVa3kqxcL7OayvDsk09x/NAwP5S+ZPHaH5yeOva+BvDG4L2AGOrXltku/Qza4kJHp93h"
    "i5UbnBoZQ7QwdmwSUYanH58A/NQBAO/wEpEZzpEZGQYd8eDrFzk39SJ/7dToU2nOPvIWANPP"
    "f8xDR0dRqERXgonAOZyN2C6ViKXuhUQagjg4S6OxRWlzgV83r/DO5Ke89+0FErF+PD48AHgv"
    "9B9/g+QDMVS8v3tC3QdOOP/nfXy/8h0To8/w1epHxFXAleXLgPpQAdz45LT31nS9sBZvzb9p"
    "D95LrRg/RgGhVyTwnFEt3v1gV/0DWQ+Ehc6w7h4AAAAASUVORK5CYII=")
index.append('lock_add')
catalog['lock_add'] = lock_add

#----------------------------------------------------------------------
lock_break = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqFJ"
    "REFUOI1lkk1oVFcUx3/vvUySmSbj2PpFItGY+EFLaXGnC1HRSlHc6K7diAsRRrrKqgahLgTT"
    "TaFroZBFScFFoWCFLoqgIIpCO6SJjaKiYKJkzOTNm7n3nnO6eBrH9MLh3gvn/M7//O+NWLWm"
    "pqb6Wq3WmKruEZEPQwh479cCn1Wr1eXV+VHnZXJy8nMRuTo4ODhcLpeJ4xhVZWZmhvn5+VRV"
    "Pz13fWzMInzxOt8AdHV2bjabv4yOjg4755ieniZNU0QEM2N7kl354vfzf1jEBiKOva1bAWRZ"
    "dnZgYGDUe8/s7OzDEMLBQqHwPEkSjl/79mxl+dWEwYNex6boT5b/B/De7ymVSszNzSEix6rV"
    "6mOA1hGOmnI5gis/Hvn+h1Kp9NvFQ69sfHx8/3sAEVkfxzGNRoOFhYVHKyYpz4CvL+298CuN"
    "RrtcLpOm6e33THx845TdmtvJi9dFRITjn9whMY9JwEIe3gs/3d+NqrKxd5Gjg3fYdeZelCsw"
    "4+SJA0TEREmRiC9BI+jqBQzEI6HBd4dTUA/Avz/ffOeBSQCM8HKKrp51RFEfaAGKFTCF5mtk"
    "6QEue4aGJsXhKubaHYAQQA3EUa/dJY4/oPLxXp5em8B0A0P7DlP/p4bLFunfuhYzwbzrBHgw"
    "w8RT2bmDuHsdRIq0hb9eFhnCURkZppX2YKEJpiuAGMC8x0xAPIt/36deuw1xQFtKO2uDOeoz"
    "09Rnn+TjqmLedyjwPqeKo7J9K0npI4gd2746wzYfYOkFa0YG6F4q5ArUVgMcqKLBUa/VSEr9"
    "0NsHXd2gAZbqZIsL+LRB/1AZQ/OxOwFmQs/m0xS3JETdPfkTxgVQAZfRnzUQ38ZUcr9C6AC4"
    "Ng+vjuVehIAF/ybCyo5I/rFE8rMKAP8BjA6X1u+crM8AAAAASUVORK5CYII=")
index.append('lock_break')
catalog['lock_break'] = lock_break

#----------------------------------------------------------------------
lock_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs9J"
    "REFUOI1lkU1oVFcUx3/vvpf5eKZhqkmjGamTMNaiIKVCIYWKYl30gy5UCkUolC6kMl3U0Cy6"
    "kmzdu3MhhFJmYUuhKLXiF2hbLAbbCTF1Mh1DpTJpJ/FN5s28e8+9XcTEqAcO5xw458c5/+Px"
    "jJXL5d5Op/OltXZURDYaYxCR/6y1N4FTpVKptb7fW19MTk6+JiLn8vn8cF9fH0oprLV0Oh0a"
    "jQa1Wq1mrT00Pj4+9RygXC73ttvt28VisZgkCfPz8ywvLyMiBEHA4OAgAJVK5V4YhrvHxsZi"
    "ALUKiOP4s6GhoaLWmtnZ2bkoigq+76dSqVSq1WoVZmZmHiRJQj6fLzabzdLqXLCaaK1HwzCk"
    "Wq0iIu+XSqX6uuvqExMTb9fr9elCoYCIjD4HEJEBpRRRFNFoNGrPiisitVarhVIKY8zAUxrU"
    "r3/iblZ38HApi4jwwa5b+E7jxODMimstnJ16HWstg5km7+Vv8eqx297KBs5x5PB+PBSen8Xj"
    "HbAeBBnAgWjEREwcXAarAbj3zY0nJzgxgMMslAnS/XheL9geyObAWWgvIY/+JIn/xpo22eES"
    "LumuAxgD1oEkLFZ+Q6kN5Ha+yfyFUzj7Ei/vPUjtu6ss3Jmjs7BEMPAL6dxTAA3O4UST2/EK"
    "KtUPnkW6wu8LWdTln0kWA/Z8/BXp4V3Ed35k+vpFLh6IPlcATmucExBN848pFiu/gjLYjqUb"
    "d6ld+IniviNkqlfwzn5EOPcthW2bENwXwSoAZ3GSkNtewA83gUoYOXqMEW249OF5MpuH4d0T"
    "a28NTm7Bd17hMSABa7EmYbFSwQ9fgEwvBCmwBr8vTXvqBzZ8f5xu/A9tIHrkIz4P1gDOCemt"
    "n5Ld5uOl0isvVD1ghZHD/UxfO8/WF7MEfg9Rw/DXQw/n7GkP4O6ZN5wzekULY3BGP3azFpN/"
    "A5buNyEGl3Fkco63vrbe/yofh0wa2D2lAAAAAElFTkSuQmCC")
index.append('lock_delete')
catalog['lock_delete'] = lock_delete

#----------------------------------------------------------------------
lock_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvVJ"
    "REFUOI1l0t9rm3UUx/H38+RJs6RZ2tltlVbapU2NOtEWJqPiLtReKJMhKnihoCIIQm6krH9A"
    "wRu9EUQU2WUHkovBQIShXsisc7BhNs1ao2kstfZH2iRNluTJ8/2e79eLutLVA4dzrl4cPhyH"
    "fZXNZuO+7583xkyKyANaa0SkYoy5BnycyWTucqCce8vc3Ny4iFwaHBxMJhIJXNfFGIPv+5TL"
    "ZUqlUskY88rMzEzuf0A2m423Wq1fUqlUKggCVlZWaDabiAie59Hf3w9APp//MxaLPTE9Pd2+"
    "B3gA7Xb7/YGBgZRSikKhsKS1fi4cDv8TCoWo1+sD1Wr1p5GRkYHxpJ8ac/Ktc5c/pLn1A/ir"
    "b3kASqnJWCxGsVhERF7KZDLL+65cnp2dnXJ2vrtzaqyP6NE36UlOUCulWbhy4SMPQESOua5L"
    "o9GgXC6XDgb1xvjFiUTydRK9p6gUF+hyAg4nHiTeN9TjLF99x14rptnYiSIinDt5g5BVWNFY"
    "rXFsnd7UGXpGXqCz9hXtbYfN31sE7c6237n7tIe1vPbqszi4OKEoDi+CccA7RKt8nU4tR8/o"
    "WfzVL3C7NOH4MJHmLfx2ZOr0B98WPCsasOitLF7kKI4TBxNmfbUEjuH44y/jr36OG9YE9STb"
    "8zfxm5tMTC/mAFyrNRgLElDL36R25wbrywtUKx2OnzxLsH6BUJelUx+mfPVn+p9/G6Nae/m4"
    "ViuwFiuK3vTDbAYulVoUZYdY+/VTDD7NyiBb89c5MurgdSewKtgHKIW1AqKo/pbj1u2/eOyZ"
    "94is/Ejh8jy5KxUWv/keN7SD6xkwBqvU/QDWYCWgd+wEfyxtEOS/JvnkGbq702zcXiR9eogj"
    "o31YHYCx9wGeVQEYg9EBtXyefGGNT778jKceOUHsWITJR9ME63+jmg0ODyWwGKw+AFgrRB56"
    "l+hwiItTEfAOgRsGIxC0kXYDUR2skd28tN4HBB2WLp3HKoXVGqvVf633JiK7jyWyuxvZA/4F"
    "qDGpKMiksH4AAAAASUVORK5CYII=")
index.append('lock_edit')
catalog['lock_edit'] = lock_edit

#----------------------------------------------------------------------
lock_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAttJ"
    "REFUOI1lks9rXFUUxz/vRyeZcRyGmDI1E3UsY2sNllAUG4uIoIJYXPhjKVK6EHEWYkiWCsGF"
    "YHb5CypZyECzdSOomBrBaLNwJKaZjuNApYw6mbw3897ce8+9LtLW2H7hyzmLw5fvOd/jcQj1"
    "ej2fpumCtXZORCaMMYjIP9baDeCzWq0Wcxe8283q6uqsiKyVy+VHC4UCvu9jrSVNU7rdLq1W"
    "q2WtfX1xcXHrHoF6vZ4fDodXq9VqVSlFp9NhMBggIoRhSKlUAqDRaOzmcrnT8/PzyW0BHyBJ"
    "kvempqaqWmt2dnauR1FUCYIgk8lkMnEcV7a3t28opSiXy9Ver1c77CAE0FrP5XI5ms0mInK+"
    "Vqu1D820l5aWXmy3279WKhVEZO4eARE56vs+URTR7XZbdx9KRFpxHOP7PsaYo/+7Qfu7C26j"
    "eZKb/SwiwmszmwRO48TgzAG1Fi5tncFaS2m8x6vlTR5/96p34MA53nzjBTx8vCCLxytgPQjH"
    "AQeiERNhvQV6wx6fnF9m94vv/1vBiQEc5q864dgknpcHewSyRXAWhn1k/xqp2md68hRvX36f"
    "j5Q5JGAMWAei2Gv8hO/fR/GJZ/ngyxWwCuUEpTUPTpzg1LFniNIBHyY/gMPDw4XOaHAOJ5ri"
    "yRP4mUnwLMYqXpp5B3EWsYLFcaPf4cnpc8Qq4alPv1WbbpQJndY4JyCa3i9bBGMFiqfPkRqF"
    "OEv772toazBWo0WzP4qYfeg5Yj0M9z5eT0OnNTiLE0XxsQpB7gHwFalJMWIoFR7GWEGc5c/+"
    "H0zkj/Fz5wpXdte39YAzodMKrMUaxV6jQZC7H8bzJCbl0sYyyo5IjeL45Axnj7/Mj+11mr99"
    "RdBntrXCKHRa4ZwwNn2R7CMBXmYMwnEunz0CVkAlSBLx/Odv4flZur3fWR4EPL1iRwcpqBHX"
    "1xZwWt96HH2L5k5FhDiI+HrvG9YGHr6VOzH+C3Vbr9eDoK5oAAAAAElFTkSuQmCC")
index.append('lock_go')
catalog['lock_go'] = lock_go

#----------------------------------------------------------------------
lock_open = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI1dks9LVFEUxz/3jTpab3KiMaQJs+yH1KK1BQVBizZRq5CEihZGiycu2oh/QNCqTbQT"
    "BSFchIsWLaJNraIoqMlJJSh9SDTga8bxzbz747R4acNcONzvPdz74XvOPYq2NTc3d0lEJhqN"
    "xohSaq/W+pW19nEQBK/b7wKo1sPs7Ow93/efFItF5XkeAFtbW6yurkqlUrk/NTX1tB2Q2REz"
    "MzPDvu8vFIvF7NraGuVymfX1deI4pr+/X9Xr9Yvlcnk5iqKlVoC3I2q12ttCoZALw5CNjY2x"
    "IAhUEAQqDMNbKysr9Pb2+qOjow/bHXgtOmuMIQzDzYmJifmd5PT09BxQqVarqq+vz28HdOw2"
    "Q6mMtRbAtl+anJzsa8/tvgP48eaOvPh0FuMU1lqunnlPRjRiDWLS0IlZtNVoEaVueMgVTwzD"
    "4x9V6kCE8dsjKDxUpgfFFXAKOroBAav5Oj92TSl1DeD49YesPgv+lyDWAIKpLNCRLaCUD64T"
    "evIgDrb/cPz8BZI4xJltcA5Jmi0AY8AJ2ISo9AHP20v+9DnWXj5C3EEGLlwmKpdI4k1yg/sR"
    "sYhOWgEaRBCryZ86iddVAOWwTcvnSg8DJOSHjtKoZxGzDeJ2AR6AaI2IBavZ/PKJqPQOPINr"
    "OJpxEyQh+rZEtPwzLdc5ROsWB1qnVJuQPzFIZs8B8BKO3RznmDZQ/UXv0CG6qp2pAyftgASc"
    "w5mEqFQisycH3T50dIEzUI2IN3+j6zVyA/sQXFp2K0DEkj18l54jGVRXNv1CrxOchSQmF9ew"
    "uok4m/bLmBZA0uT78wdpL4xBjP4XZnfH2nSwrE21Swf2L2AqbPdkPyL+AAAAAElFTkSuQmCC")
index.append('lock_open')
catalog['lock_open'] = lock_open

#----------------------------------------------------------------------
lorry = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAc9J"
    "REFUOI3VkstLlVEUxX/f163IULg9lDSwB1HcHKQgBTmKHgg5DfoDIpCgv6BoVCBE0Kwgp0FE"
    "g7JJhBTYg6BoEOI18CJcJJCQSrp59qvB/byRBA2jPVlncc5erL32gX9d2fT4xbq797gbZoqZ"
    "oCqophaKJFTSk5Grz0+tFSi5e0/n0WEijDAnXHE3wpQwwU0JU949Gj/5JwclVcFdWfmyQJji"
    "KrhJEzXhmtjYsYNb7WOcuGJhaqiauejo1PXTt0uqia7KyF9ntWeTXD47gHlQX1xed/P+22tA"
    "U+DS4zlmFr5hydFkWDJ0xVr8QPdmVJSkwcHeMv27y9y4+3oLQElkhfPbp/iezxeWBSusr/K2"
    "rb2cqw/SsSlj/tMS+3eWkSS0BFwSlhpFo7QaXVMzSBUkCaLOdH2ZRrJfAin9wDSxob2rmbgW"
    "ybsWGzBCBU2CaLCnsw2xQEWb/+DM8UMR4bg7EU4U6BFNHgERzOX9RATh0cQIZt88zPJ7T99n"
    "HxakVt57hO6+Y8wsZo3egWE6dh3m4+f1kxMv57KJV7Vs+sWDjKWZ2lDfNgb3tZN/nZ0EyAAq"
    "lcpQRIxFRCMi7uR5fqE4j1ar1erqKte8++3uP66fa6179WmHBVcAAAAASUVORK5CYII=")
index.append('lorry')
catalog['lorry'] = lorry

#----------------------------------------------------------------------
lorry_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI3Fkl9ozXEYxj+/7cw2205GjE02LZl/Yf6tKRcYrexWuVGS1CgXbtyQK5Za4mJF4Y4S"
    "hXFzkj9t0xIic1JkrU6nsYnZONv3+77f18U5ZknNne/N830u3qfnfd4H/veLkpePpEIIVSEo"
    "qoKqR8Qj4ibRe4d4l2g59XjnnwKxEELVvM3NmCmmAQtCCIqpYOoJKpgKLzov7/ibg5iIJwRh"
    "YiSNqRDEE9RnURxBHIXxBVwoO0PTSTUVRUQ1eGntbt91MSbiqFjeMu2u+ugBJ/bUo8FIDY3l"
    "n7/x/DSQFTh+7wNv06OoC4hT1CkyoZO8rrIE8YITY0V1OWsXl3P2Wu9sgJj3Exyc282PvIGc"
    "ZY/mrP/iM+dUcyC1gXhxxMDgF5YuLMc7z6RA8A51mdygnxwM4rJBisc7j5dAMjVGxulvAefG"
    "UXHMKKvIJi655IPkLqCYeCpn9XHz4W3GMl/oeuaIly7K9mD39jVmFgghYBawHAazLDcjvryC"
    "pTvrWLdsPQtnL+Hhm1v09nXR/364Pe/6/ZdRX9r3l9c2ULlyK2+Hokx1fTPxmk28+1zw4O6T"
    "D1Febcn4mrrVaJ6yekETGnkaVjUCdigGEEXR3p6enjNmljGzS4lE4nDu3wrwdexzUUFUSvOy"
    "/QAc3XaRztcdRNwpigEkk8luoHHK2a9O7cDwyMfxN+knRa/S3RxrukJbYh9F+YUYNp4/bYOA"
    "yvWlxaNuaEtNRQ3DP1KMfP9Ez6suvn2dOBf9iwDAxtb5bURRawRlBqOYdTztGDz2E9OrkCfG"
    "wX5NAAAAAElFTkSuQmCC")
index.append('lorry_add')
catalog['lorry_add'] = lorry_add

#----------------------------------------------------------------------
lorry_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj5J"
    "REFUOI3Fkk1IlFEYhc/9vilN0Ril/I1xalFpi5JEwTapFRO5k8JNtAlBoqhVLQo3GQgRtImC"
    "hFZBBC3KhZOIlUabIkLUCCfMcTDEwp+c5t73p8V8jRBB7rqbc8/ifTj33Bf438dM9F9IikiV"
    "CIOZwOxA5EBkc+qcBTkbb+99cexPQEhEqrY3x6DKUBaoEEQYygRlB2GCMuHd0/6jf0sQInIQ"
    "IWSWUlAmCDkIu6yShZBFXnEF7hb14UgPKxODiFkcdY/ePHEvRGRRVtv+z7fyyDCuddaDRZFc"
    "WPVvP357A0AWcHUgganUCtgKyDLYMijDOb+nshDkCJYUdZEwDkTDuPXwTQkAhJzLoGvbKNa8"
    "mSCyAwfRf/uC0gjOJhtQvMVgZv47dleH4axDDiDOgm06GHS5QSGbLZIcnHVwJJhIriJteR1g"
    "7U8wWWwuKss2TkHzQsEPMJQcDq8Mwl2/gmhqGrakHC2ZRkwBMCfb9quqQESgKtBARTXrVdFU"
    "JIjVVaC2tQN50TqkP8Qx/vI5lj9OnvceDb034yn3ObyrCZX7WjC1YNKR+hiKaxrxaXHT8LPX"
    "CXOQZxN7WzuQPz0C86ATBYkn2FlTCoZeDAGAMeb02NhYn6qmVfV+PB4/F9y7AcAXE80vjwLH"
    "L60vUE8FfDU1ZiP7PtjmzzZ3nqku/DKATHoeawBWln1MTmPO3wigq6F867evqUPeZt9z/g8s"
    "LSoSKY+ZtG9DCQDg1akdl9cWU12emIh4OifQO7Eh6f0FhlqO4Z3FS5wAAAAASUVORK5CYII=")
index.append('lorry_delete')
catalog['lorry_delete'] = lorry_delete

#----------------------------------------------------------------------
lorry_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnhJ"
    "REFUOI3FkUtoFGYUhb95aDqFMR3RmJhi0cZEY8UaCwpB0UJ8gJZWEWlduCoFBbtwo4iimwqC"
    "iOKiSslGtEXsQqUIIsVHFkabEEp9ocwkMcRHxKLGTOb/78PFxFQk0KUXLofLhY9zz4X3XYlb"
    "rT/2mVmtmaIqqEZEIiJhVGMMSAwX1vx0ecW7gLSZ1VY1r8JdcTXcBDPFVXCNmAquQue51uVj"
    "OUiLRMyE0vN+XAWTiGksqwRMAhUTajia3U/LHnUVRUTVomxuO7D6WFokMKVxzf/eqpf+ZPe3"
    "Tag5fQODqcOnO/YBZcCuP/Lc6X+JBkOCokGRko7OXzc+ZPvn7WioY9b0acyfnuPgr9cmAqRj"
    "LPHD5DaGkj0jliM6Yt0k4BaprHFyM1bT//QCPY/W0fBxjhgiAMkYS1gMaCgiI62hiIZhNAwz"
    "rqJI5bQWJtTMJzVwiULhJl35p6OAdAjDqATGZ6eUE5eR5E1wfUUy0U120kfoi7NUz/mOoVvn"
    "eSZ1SJQyoLXtCX71KGaGu+FvFGd9Sw0rN2yF4U6unzjDou93kBxo5/iJLpLd6fIJpy52Jf7p"
    "j4Xcp4uY+tmX3BlIFD9pWsW8L5pobl5MNjeElQrghg7eYMbSbWxc8Ips6f5lgBRAVVVVR29v"
    "7+x8Pn/P3fc+6CnUblrilTMXflWRsk5cnjG1cRJuQ4z/sIJMZg714/4+99uVR+cTY/38r58X"
    "b5nc+M2R6voMOngd90DH77dZsG42iVQlZFZw45edTxJiy8YEtB9a2Dd348naVLIbl38Bf2ub"
    "JJVp4PHNLu6e3Xs6PRYglsIHHcfWFt28HKoZ7s5/s4MZmFe/BlW1lIjERNKoAAAAAElFTkSu"
    "QmCC")
index.append('lorry_error')
catalog['lorry_error'] = lorry_error

#----------------------------------------------------------------------
lorry_flatbed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWNJ"
    "REFUOI3tkj1LXGEQhZ97Y6OQgB/YiE3AFIsG/AILg2BjE7G2Si82+QNpUgQCaUIKEUKwFxG1"
    "sBLESEBMlSCuGDeFksKAsJh7974z846Fq6LVgoVNTnPOzBwOMzDwH/dG0qhx4u2mRzNMDVWz"
    "KDrz9cPL+aZGA0yUN9MDWHSOT88ffVz8/g6YTxsNUFGCOm2trYw978ZE2gAaDpAgPGlO+Hl4"
    "jPllDdC09+X1sqlMiRSEkBNCTq2WURQZRfGPWi0jhJy5IIhGshD5/efvTYCpTLUPjd2sGjIk"
    "q6JZFQ35df/TuiDqPO1sQcxRUQCSV5MvPEYjRiOaYVHrus7RiDFylPbj7nj0S3bnYGclSRdW"
    "t5Ldo7NKc1cf7c9G+HFS5F1947R0D7J/mm6sbP9K1r5Vkr3tpYSz/cpobwfDPY9JqwcbUP+D"
    "Uqk06u7v3T13989pms7W9Uy5XC5fnXHHd2v2cLgAs77lq9cfzooAAAAASUVORK5CYII=")
index.append('lorry_flatbed')
catalog['lorry_flatbed'] = lorry_flatbed

#----------------------------------------------------------------------
lorry_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlBJ"
    "REFUOI3FkstL1GEUhp/RSWFEcUynGlMxkTJblBQF1SIrQ8hFm6CVu4I2/QMVRTcoIiiIatE2"
    "inZRCzGxkGqh1SLES45oJoYY3XR+833nnK/FmAspateBw8s5i4f3XOB/R2zw7okpM6s2U1QF"
    "VY+IR8QtqfcO8a6r4+KzA8sBcTOrTu1sJwQlqBFMMFOCCkE9pkJQ4fWju22/cxAX8ZgJua/T"
    "BBVMPKY+r+IwcRSXreF26WX2n9GgooiompfjfVcP3omLOFZt7PjrrNrbw+kjLagFpmZ/FF5/"
    "OHAJyANOPc4wNP0ddYY4RZ0iOV2qN6RLEC84CTTXJdlSn+TavVcVAHHvcxyr6mOhYGLRskcX"
    "rf+qEyvruFHxlPv983SueEJz7Wq88wAUeJ/DvENdFllMdVnURaiLMB9h4onEsbayiRu9e+h/"
    "/3EJEHcuQsVRVLoqv3HJb/7Wty5CoceZ4L4MUV3RSNPq7XyP5rnSsw3Vk/k/OLxvcwjBMDNC"
    "MMKiVh9Nsr+5Ew2GmmIEZr5OkSxJ8TLTzcDEc6wgKi940P029m7ajycbdpDe1MrQbCxb19JO"
    "JA4NxsTcKONzI4zNDvIlO8fE5zE21+xmfXor37LMFQKkUqmBycnJpkwmMxpCOJvJZNJV26Wm"
    "MdVCoqiMRFEZJcXlLLgFKkvTvPnwgt7hns9ZZVfsT3c/dLPeIudw5ojE0VDVHNuxro3+yRd0"
    "D3fNOGXvzCUG/whYHhvPxea31bYmekeefvQx9k6fZxjgnwH1J5nXUJjIoes+XWD8V/8nXlaN"
    "tvKIa90AAAAASUVORK5CYII=")
index.append('lorry_go')
catalog['lorry_go'] = lorry_go

#----------------------------------------------------------------------
lorry_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqdJ"
    "REFUOI3Fks9rXFUUxz8veclLHTJk2kzGTGuGxsUYQwIVRDCBWUg0QYO40bipLlJKzcK/QNtV"
    "JIoI7uoiWzeSCipiF9LBBEVIYSAMkkUgYea9xA5tOs6bybv33HtdJMYfFLr0bL58F98P33M4"
    "8H+PV119v2atPW+twRjBGI2IRkSdqtYK0er2/HL5lf8CfGvt+aGpOZwzOGNxVrDW4IzgjMYa"
    "wRnh7jerLz+qgS+isVZIHoY4I1jRWKOPVRRWFEF6mJv9HzNzwzgjBhFjrJb31j997QtfRJF7"
    "dv6xu5o7P/Lh289hrKN2r9X9+VebHwHHgA++2+G38A+MsogyGGWQxJz6Z/IpRAtKHOOFDJcu"
    "Zvjsy1/OAvhaJ1zNrtPu2j2prDEn1f/yT5wrcKX2POkzHrv7DyheyKCV5hRgtcKozklQnwat"
    "qONDikYrjRZLtdaio8zfAKWOMKLo7c9hjXDUOaK626Le7mdwaJj9cIcXujt4KubO16sMD53j"
    "17v3ueAnPDUzk/JX13/H/XQTay3WWUxvhpdefZPL775FHMfUak/zw/ffcqlnk9fnFznT10cU"
    "RfQFm9xu9F73AMbGxnampqYuttttstmse2dx0ftkeZlms+ny+bw3MTFBFEU0Gg3CMCSdTrO0"
    "tMTa2trDLgDP8y5vbGz8vLW1tZfJZASgUqmUW61WZ2Fhgenpaebm5pidnaXZbJpKpVIGGBgY"
    "CHyAarW6Drw4OTl5LYqiZWCgWCwmh4eHPSsrK6RSKQDiOMb3fVssFhOAer1+5P3zWcbHx8dG"
    "R0fXSqXSkyMjI9b3/bMHBwdsb28TBAGFQoFcLoeI3N/b2+sql8v7/wIA3aVSaSKVSt3K5/PZ"
    "IAi6nXNdjUbjiud59cHBwVtAT5IkJgzDe3Ecv/EnFaqXBld7GvoAAAAASUVORK5CYII=")
index.append('lorry_link')
catalog['lorry_link'] = lorry_link

#----------------------------------------------------------------------
magifier_zoom_out = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjVJ"
    "REFUOI2lkj9MU1EUxr/3+vpKBS1Q2zQtCf4ZRKLGBf/FpIk4diLB6ODkYkIcHVgk3YyDi2l0"
    "cNEYSSQaBwYZgGCMidaJCFKtASRpq1Re/7y+vt57z70OBCIpoMZvOWf5fvm+kwP8p7SNRSml"
    "T2dZShASkkRUkAQXMscFjc/1dQwlNU3uCFBK6VNZNtXuQ7xjjwZDV4ACXKGwUnTxbbU+szQd"
    "uZBMNkN0AJjKslTAp+LhNg0uJxRtwneb4DCJAyE/wgFvPHh6MbVdAh0ABJeJTr+GaoPgMAUh"
    "FYgUakxhrU6IBf1gjBI7VhifrdLxmKmv2gSSClIBJBX6ntyBx7Ig7RqobIPKFVCpAlGyreCX"
    "2U4AMACAcQGpTAipICVAan16LAvOmR5IJkBMQLoM1OAw7j7q2EiwDmAi53LZZegaHCE3E9R1"
    "E97nM6ByBVqpAirb0OwapOO6Wyo8fp2/H9pnXj8UaYXlEGpMQkrA59XQ7vcg/akAe2HSPWaN"
    "ney/NZFpOuLXycjQYqE6M7dcgtcDhPcaCAcMmLrC+/kC7J8FXIz9aHEZe/Py5rkj2z7SyIjS"
    "W09kUozLBCMRFZwgOOWD7hzrD3w82HX0FHKZND6nJ4q84Z6/+iCT2QLYSc9GBk2zkR8NdfcM"
    "dPeexcrCO8ynJ4rXHi6HNivspkvJMcZ8a1eW5t++WPjwCuGuw2C8sb+pwh+TDPaaVltp1DBb"
    "BpyqdfvGU2v4b72/QeC5dzkY/WfjbvoFjJUuNZxE0wgAAAAASUVORK5CYII=")
index.append('magifier_zoom_out')
catalog['magifier_zoom_out'] = magifier_zoom_out

#----------------------------------------------------------------------
magnifier = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfpJ"
    "REFUOI2l0j1oU1EUB/D/+8h7jbYkNSaWtFDFQe3gpqIIARVcMhUqOjg5FkcHpxAn9xJwcLag"
    "IA4d7NCUgggawaUJjaQ0tZCmNTaFJK/vnftxHKzR0kRF/8u5y/3dc7gH+M8YPw7MbC5WKCcV"
    "0lrJpFQaQuqakGqueGF4OmsYui/AzGa+Qvmoi9TwEQO2yQADvmRsNHx8/rK3VF0cuZbNHkZM"
    "AMhXKBdxOZUYNOALhUZbYaut4JHGyXgYiUgoFbu0luvVgQkAUuj0sbCBVqDgEUNqhlKMDjF2"
    "9hRGY2EQqXRfQEiZtEzAI4bSDKXxHdGMTqDhhCwQiWQvwAYAEhKaHUjN0BpQ/LOyBhQDvpA9"
    "f8EEACJZ84WGbRr7L6NbQ7YBzxeQgdjuDwg5V93yMOSacCwDar8T1zYQDVtYXm3gROdjdOHR"
    "zTM9gdWFkem1emupuL6LkAUkhmwkIjYck/G+VEf7ax03RrcHfKI3rx5cOYB0FymTYfPo+XKO"
    "hE6TkkkpFKRQmzG/SNcjy6fGzl1ErVzAp8J8QwT+1btPyuUDQL88z0w5TrA5Gx8/Ozk+cRkb"
    "K+9QKsw37j1dj3dH+F1uZV8QuTt3qqW3L1c+vEZi7DRIBMcPjfDHTqYmnObg7qztDEx6rebj"
    "+8+aD//27i8IrJnbsZ4L9c/5Bsa3EGXTJCwlAAAAAElFTkSuQmCC")
index.append('magnifier')
catalog['magnifier'] = magnifier

#----------------------------------------------------------------------
magnifier_zoom_in = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj1J"
    "REFUOI2lkk1IVGEUht/7M3ecURsdf5kGRFtYLtqEQT8gGLSalWHUIgjaCFK0cREthtkFQZtB"
    "atHKRYJCtHCRCzU3UU4RVDM4ZThqqaU509zmzr3f32kRmWZa0bs53+Y833MOB/jPaD8eRKRP"
    "zbFBIRFTUkSEVOBCLXMhx9Kdtf0JTVO7AohIn5xjkzV+dNUGNZg6AQS4grC07mJxrTydm2ru"
    "TiR2QjQAmHjr3Q75qa+pSoftSbicIAnw6UC130Dy1VWU3CI8l7lDZ0YDWwE6AAiuYuGABtuT"
    "cBhBKIKUhBIjbJQlbKeA7oZ2uCWv4lcDEwC4EBFDt+AwglQERYBUhJH5AdilPJp8VbA9B3W+"
    "IE7f6iJW9vKPrj8JbxowLqAI339WP+uX4mecqG9FNBhCsfwV+0PV6GxrQdnxarcZMCaWXa6i"
    "pq7BEWrTwOCVGMu8QNgKIBoOIb3wHosf1sDK3N0O4GIs99Hpa2uuhJCEElNQCrh4JImagIEr"
    "Q93YFzCQW/yE5zdfalt3oAPAu4nm/vlVezq9UIDPABqrTTSGTFg6YSazCuWZmJ6Zhd8V6sHA"
    "8fbfHlI8Tnrl4ewg4yrGpIgILiG4XKlz0+xU6HVr9NBRLGdTeJMaX+eee/LCnWx2G2C3jMR7"
    "LctbGW5oOdjT0nEMS7NPkUmNr1+6u9CwOcJeOZsYZcy/cT6XeXx/9tlDNEYPgHGvfscIfzTp"
    "7bDyVYVh06rocez8jcv38tf+tncLBEbyXF3knxv3yjdITycgxqAhSwAAAABJRU5ErkJggg==")
index.append('magnifier_zoom_in')
catalog['magnifier_zoom_in'] = magnifier_zoom_in

#----------------------------------------------------------------------
male = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiFJ"
    "REFUOI210z9oU1EUBvDv3fu0L+lfqE2CRaxUKoIiQgcjiJPgYEChQ0dnB6duQkFB0KGbpZ1c"
    "dSmikaJ28g88BDuIWmlUtK1CW/AlTdo0755z73FISQUDEcQDd7v8uOf7uMA/jtfqwuTTaJuZ"
    "YZnBlkFEYGYYIty8fCzhtwKIGLlTvYEIICJwAESAuw/f1QBAtQKYCYtLRbIisAK4nWOI8VfA"
    "2MX+xPxi6V4UbVongHVAXDNCJl4BgMYKIuJNz0WjzJIjy1lLBGYbkqX9xw8mT3f1dOhSqeI6"
    "ujqVFcAwoQGIiDf1rHjtUNofz3TvUUGbVg6Cra34gNbaa0sEauX7Os+GS4/PDfdfyKR6Ne+s"
    "4APA5Fw0Opjyxwcyga+U9kQAT4D2Tl+LANWtqpsNl19TbK4+evH5PPFHZrK7ABPnMt2B8jzt"
    "ra6Xeb5QssSEk4e7dTqzz9+uxWJMvDw9dnYFQOL3jBQAEFN2b6CVE+BNoWjXKtWhqFgZCt+v"
    "WueAZLJdEVG2Wch1wHCjHiYD1GrYBsBEcAJYSKO2pgAzhZubNecEODHYoxOBLnT5Uhg+mtJO"
    "gHJxw7GhsBlQzyCm/Ncf5ZEjg20qlenzc+k+X1B/EZlYFr6sOUOUbwZoAHj+4M6HgSefRCyd"
    "CXwHXyvPssVG9NO9XViyr+a/3Zi5fWkKuP4HsPuZRLwrEy9HY+acJc6SNWDmkJnyM7dG7teL"
    "/Q/zC+aEQljYbuTNAAAAAElFTkSuQmCC")
index.append('male')
catalog['male'] = male

#----------------------------------------------------------------------
map = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr1J"
    "REFUOI1lk8uPFFUUxn+3bj26Z6q7q+meaZhheBjwFSFGEzeaGMcNAXez1bhl5UII/4J7V8aF"
    "JC5cwNYoiWJMJEYSwxijwhgRBtLA2HSgum89blXdui7mReCsTk7yncf3nU+cXDlxuTfoL0sp"
    "eTIET4fYqQmgMjUPNx7+4PYG/eUvPj2PcARVXT4FsNgtWFoqQGCtg60tFsPZc2eWXSklhgpR"
    "fkXy3SrdyymjcweYbYWsrf3M9eRz7o1iWq02G+MY6XpMkpwPT1o8V+Jsz4vjMfFLPhOlSC/9"
    "hVL3UUoh9Co6m5KlU4pMkWWKKk8QogYE7vZdnc4c2JKZj/bAJ9cIVvrM71ugWd4kq47Silr4"
    "0sH1fFSaI4QGxPYGgjiOUWrK43nDpFuRXfwHTI1Nf6LUinSaUOoUnScUOkUIC4DLzgbzYEui"
    "Tpv49Mt0PxtTvb2PoK85UIzxwiVmAonne0zTApiAAGdbsDzXJColnsRMZw2Pnof8y3+xJscp"
    "viHPFIVOyBNFXSRbqCc4aDYjwnZCp90GwHv/EM2Pr+Cagyz0/iRvZiyGvxP4I4rsNtL5AAG7"
    "DaZxglIaSPh1+IA7pcPgiOGF82sMTyUM5NfoyY9EM8cJro4RvRQBOIjND2tHe6ER8Vtacbvw"
    "iKI5Hrx7kP1ul2y0QBROWFxv0Pz+Bnd8g/X8XRKttVy9e4vV4Q3CsEWe5yiVoLTmlxcdjl24"
    "ibq2zrDrcf+155h4giU/2GwggLRKGJmSwA+ZbXbIdUHYCOn8sc7+eym+B49eOcbdwz5B0GC2"
    "0GB3ZBQI4dCiTSZSAtNkRoQMrv+HP8y49eZx9BHFW1ce8/fSXmTgATWmrDZJrCqDMYbFPa+y"
    "2GNHHnEUeAf6YqvyRs3rskQ2fKQjMbWhMgbx3sqpb+cG/RPSc5+x7LOG3k2qyjDaGF36H5Ym"
    "NqAIJJ/WAAAAAElFTkSuQmCC")
index.append('map')
catalog['map'] = map

#----------------------------------------------------------------------
map_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAt9J"
    "REFUOI1lk81vlFUUxn/3/Zhh2ndmOh90bIuVRKtAYmFjYhqJsY0JgnHTrcSwc4MLMfwLsnZh"
    "lIUkLty40ASCRIJGJQQTI6RYaiNIpbS0nRnxnbn3/b7vdVFaG3yWJ3me85zznCOOzh650mg1"
    "p23bZicET0Js1wSQ6ZzOeuc7p9FqTn/20TmEJcjy9AmCwTymBakEBMZYmNxg0Hxw+tS0Y9s2"
    "mgyRfoG6fIPalYD26XEGyx6Li9dYUGdZbfuUyxXWuz6249JTEe8cNbiOjbXVz/e7+PsL9KQk"
    "uHQbKR8ipUTEN4jDPmHQJwklYSjJIoUQOSBwtuaqVneDSRl4rw4f/kpxtsnwyCil9C5hNkF5"
    "qEzBtnDcAjKIECIGxJYDge/7SNnnn2FNr5YRfnkHdI4JfiKNJUFfkcYBcaRI4gAhDAAO2w6G"
    "waQMVSv47x6g9kmX7NURis2Y8aSL6z3NQNHGLbj0gwTogQBrK7AoilEywO/59Ac1j56H6PM/"
    "MTrCSi4ShZIkVkRKkifqMWvHDkqlIbyKolqpAOC+vZfS+1dx9DOMNuaJSiFj3hzFQpskXMK2"
    "jiPgP4G+r5AyBhS/rKxxP7VoPad54dwiK8cU68ufcuv+MjIMScI+Lx0obgogNi+sMvQUvSzm"
    "ZhCwlLjUa3XWZgQzFzPO/5ETljtMHz7MnvoE389/zY+/fYXKK5spGGP4efkeF+7c5sHfXaIo"
    "QkqFjGOu7zMsrK1yaN9BtKU5OPI6WqS8/OIUnXwJSwBBpmjrlGLBY7BUZVdxEG+Xx95lnz0P"
    "VmirLq7weGv/SQBOzZzl2eFJDPlmCkJYlKngiTJFXWJAeLQWNhhdCbk3NYnf7zK/eo0zl08A"
    "cObbE9zdmMPCwskyjdaasfohxhpsxyMmgNegKQRvrPtcn7vA1OQrnL/1MQXhcPXmD9QZR7w5"
    "e+yb3a3mEdt1/veyO/Ew/51O/hc5GRYODcaxNmqX/gUD0k0LyUCAvAAAAABJRU5ErkJggg==")
index.append('map_add')
catalog['map_add'] = map_add

#----------------------------------------------------------------------
map_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAttJ"
    "REFUOI1lk0tsVVUUhr99HvfVc1+9l96WQoWkBV8hzh0Qy4QUZ3ek0Tg1DhyAwZlx5tyRcSDR"
    "gRMHGqNIxBotaGpChBApaVJoUVtaL7dw7tl7n31e9zgorQ3+w5X8a/1r/f8Sc93T861Oe9a2"
    "bfZD8CTEXk0AaTbkwdaDH51Wpz37yYcXEJYgHSZPEHLyxzSdSECQ5xb5MCcn453z52Yd27bJ"
    "SBHJ56jL12nOa3rnpxipeiwv/8pt9TEbPZ9qtcZW38d2XAbK8MZcjuvYWLvzfL+P/0yBgZTo"
    "S0tIeR8pJSK6ThQGhDogDiVhKEmNQoghIHB296rXD0CeUHl7FD74nWK3zdjEQcrJHcJ0hmqj"
    "SsG2cNwCUhuEiACxq0Dg+z5SBjwayxg0U8IvViAbkusrJJFEB4ok0kRGEUcaIXIAHPYUjEGe"
    "0KjX8N98luZHfdKTExTbEVNxH9c7TKVo4xZcAh0DAxBg7RpmTISSGn/gE4xkPDwG5rO75JnB"
    "ii9iQkkcKYySDGP1mLXvBuVyA6+mqNdqALivHaF89ipO9hQHW7cw5ZBJ7ybFQo84XMO2XkfA"
    "fw0CXyFlBCiurW/yZ2LRmc44fmGZ9TOK1uJ7yJ9/4OHmNsKrMJzbUeEgdhJWa4wzSCNuaM1a"
    "7DLaHGXzlODUxZR7C/cp+VucePVdikefI7z5PUtX55l+5O24kOc5v/21yjcrS/y93ccYg5QK"
    "GUUsPp3jLvzCzMkupTs/IT59hcrdLzky1WR6+9bOCjpV9LKEYsFjpFzHRDFeyaP+xz0ObWjW"
    "E0Np/CjMnd0LuvP+BDUjcUAghEWVGqHQFLMyFeHRuf0PhfWQ1RdPYC1eRt/4lpGv3yIKN9FA"
    "MLCRxQpOmmZkWcbk6AtMttizR8wAL0FbCGRXsXTlKw41yzi2S9BLWevZrDSOI17unvnuQKd9"
    "2nad/73sfjyvVjm8cY2qUchShZX6MRbS8Uv/AqxbTdwwzbuyAAAAAElFTkSuQmCC")
index.append('map_delete')
catalog['map_delete'] = map_delete

#----------------------------------------------------------------------
map_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwRJ"
    "REFUOI1dk91vFGUUxn/vvDOzu+zszG73oy0Vug3W0qqh2MQLwZg0XhDWeNNbonfGKy7Q8C94"
    "jxcaVEyIISbGRBIjGIMGQUKN2gaUgukXKaWU7RZmd3Z2dmdmXy/q+sFzeZLzO3mec444OnPk"
    "Ur6/MC2l5L8SPCnxT00AUdxla3Prez3fX5g+c+pThCaIuuETDQr1d5sfeoBAKQ3VVShi3j35"
    "zrQupSQmQoTnaH43R+6ST/XkXtIZizt3rrHQPM39qksmY7NZc5G6Qb0Z8OZRhaFLtN48163h"
    "jpvUPQ//4i08bwPP8xDtOdqtBi2/Qafl0Wp5REETIbqAQO/5cpwiqJBdx/vgvd9IzBQoDe4m"
    "FS7RikbJZDOYUkM3TDw/QIj2DqDn13VdPK8BpRRBLsL6YhFe6qL8K4Ttw/gNjWLnMgfqF5DW"
    "8zTPX2a/newBwHFKoEKyjo379gS5D2tErwySKLTZ26mRl78zrN8iVTiGM3KQxytjvLB1Br23"
    "sCBo0/R8hFA00jHyGQjOLqPeyJNtnWZ0cBRr6BDbSwuYokPGHqCv8NS/GaRSWSy7iWPbABjH"
    "yqROXEU2JOMDIzgjr9Le+Bxzl+Du/G2iruSzhRCtB2i4TTyvjVtv8sv6A84trXDj4DYp3cbZ"
    "VyG4/xHCeIRhZUj6q5hTFeqhREPsXJidHYBklnk/YrVjUGw8YuLQJM7TrxOsf4BmhHTqZao/"
    "zHJPK6IVhwF2QlRKMbu2wtz6bSwrg3FvkTGrTOnZCp0HHyNNReAO8/DH6/y8b5xqOknFTOwA"
    "BOBHTapxSMK0MJfXmEyNEXVLbNx8n1zJJNjew9a1X7n+3BTKyZHutEEpADQQCKGRwcYSGYzF"
    "VSYOv0Vi7Sp/nv+J+W+3ufHNFezl3Wh6GhMDE4M4jBCAHkUxcRwz1DfJUB6+/OQsnT++ZuTA"
    "y7jVGms3F9l//BRGag9TMkQmTaQmibsxURwjXpupXCj2F45IQwcE9fmvmCwXeXG8TLUrmH2Y"
    "x1eJ/7+4gCiKqW5WL/4FeQQ7/rMrp74AAAAASUVORK5CYII=")
index.append('map_edit')
catalog['map_edit'] = map_edit

#----------------------------------------------------------------------
map_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuZJ"
    "REFUOI1lk09oXFUUxn/3vTczTDJvZpKZJNOkjaC0kIZC0IUFUSGohNpiJbooCMWdKzdKV+5d"
    "FCnUTVDQUkVEF4JUDWiLULWWSiMYolVbjSGpYTrqm7nv3333vutiOrHUb3U48J1zvu+cIw4t"
    "LpxvTDTnXdflTgjuhtjJCUCbnFvbty54jYnm/Fun30Y4Ap1ndxEs9jYtyiQgsNbB5haL4eUT"
    "L817ruti0IjsPcLPVxg5H9E+Mc2wX+HatW/4MXyDrXaA71fZ7gS4XoFumHD8kKXguTiDfkHQ"
    "IZgp0pWSaHkNKW8ipUSkK6RxjzjqoWJJHEt0EiJEDgi8ga5abQxsxtCLo/DqVUqLTcZ3TVLO"
    "rhPrvfh1n6Lr4BWKyChBiBQQgwkEQRAgZY9/xg3dEU384a9gcmx0kSyVRL2QLI1IkxCVRghh"
    "AfDYmWAcbEa9ViV4YT8jSx30o7soNVOmVYdCZQ9DJZdCsUAvUkAXBDiDhSVJSigjgm5Ab9jw"
    "9z5Izt7AmgRHfcq5H47wxY3DhPIvchXeZgmcgQflcp1KtUGt1sKvjFF4bo7yukfZ3MNkY5PU"
    "KHY3Zzh3/SizrTdxnRwB/5nYC0KkTIGQ7zb/ZHntCvYxhfr2Z5TWTI7uY6b1IL0k5JUv3+XU"
    "00f6BRD9C6vWW3R1yvdRxO+qgM4Vj88ex9gckxtyLFvBBgd2P4RUMc+/v8AB8WzfRGstlzd+"
    "Y2XzJyoVnyRJSLTC2Jz1zi9kuUbnGZnJ6KY95vY8jMwiLsbv9CVEOqRtMkrFCsPlGkmqSHSC"
    "NpqJ6jQ6NxibczP4g9FKi6sbX7O6tcb93aN4IBDCwadKLCJKpsyQqBDphDOXTqJyRaIV9zVn"
    "OXjvE1xZ/4rL65d4bfEsHy19gqe1wRjD1OgcUw121nNw71P9SPQzx5YeQDhlVrdWef3YB0zV"
    "p9HmY8ThxSc/G5toLrgF738veycu+GdQ1vJI+AzD+GhtaG+3l/8FUsRmPWMpLAkAAAAASUVO"
    "RK5CYII=")
index.append('map_go')
catalog['map_go'] = map_go

#----------------------------------------------------------------------
map_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArhJ"
    "REFUOI1lk8uLHGUUxX+3vnpMz1R310z3TGeMGSaEBIwgiUvB16zC6G7AleDWlRsl/4J7V+LC"
    "gIgbl1lECBE0IvjASUCSDCQmZiaZZ2tq+quqr56fi7YTTc7ywj333HPuldW1c1d6g/6KUor/"
    "Qnga8rgmQFU3HOwefOv2Bv2Vzz+5gDhC1ZRPNVjsv21pqQHBWgfbWCw1H53/cMVVSlFTIeVX"
    "JJfXmb2Ssn9+iZl2yMbGj9xMPuPhfky73WF3GKNcj8PE8N6qxXMVzmReHA+JX/A51Jr0mxto"
    "vY3WGsnXybMRWTqiyDRZpqlMgkgDCO5kr253HmzJ9Adz8PFvBGt9Fhafo1XeIatO0o7a+MrB"
    "9Xx0ahDJAZkoEOI4RusRjxZqDmcrsq9vQ91g06uUuSYdJZR5Sm4SijxFxALg8ljBAtiSqNsh"
    "fv80s58OqV5fJOjnLBVDvPAY04HC8z1GaQEcgoA7CcyYnESPmUczNeoUZF/8wfdnV8lsg3l4"
    "C991UVVM0OojuP/3oNWKCDsJ3U4HAO/dZa5+6TPTf41XTgzwfJe9uGD3IGb33nco5wwCTwhG"
    "cYLWOZDw64Md7pcO1bF3eGN5nkeFQ2VqrCiWn+9z/8/jSJIigIOML6wTHYGpiGtpxb3CI4rm"
    "MWVDEPhUdUPTWEzRUNaCVQHW85+YaK3lp827rD+4RRi2McagdUKgBJOXlLVQNWPXrYDJDNbv"
    "jQkESKuE/bok8ENmWl1MXhBOhSTxNXb2Fol6PUoUriNs/1XiJpts/XJjokAQcWjTIZOUoG4x"
    "LSGDm3tEO79z+w5Ud1/CUT5pXuLEm7x65G/2r//AVDLCraqauq45OneGo71JqIKcBN6E4zKu"
    "zI0a9pTD1vUhBxs/s3TqZV7cuoi8vfbWpflB/5zy3Gde9tmHHsNPtzk7V2NMzj/mJDzGMPjz"
    "cQAAAABJRU5ErkJggg==")
index.append('map_magnify')
catalog['map_magnify'] = map_magnify

#----------------------------------------------------------------------
medal_bronze_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhRJ"
    "REFUOI11kz1rlEEUhZ/Z7zVpDBYLQiKaQiSNggQlPyCFhZDeRixELOwWiyCp8g8sVAQrS2sj"
    "YhECQbQQJKDYhBQrmMXE3Xffmblzr8W7rht3HRjuDMx55nDmjmNsyP17xqUlZGsLE8FSQmNE"
    "h7W6uoq9ecfs29fuj6YyDhgX2ZhQRYq9CBbiuOQfQBRMBPUeFSlAIqN1ZQqgdAIQIuY9LCyQ"
    "vEe9J3lPynPc4iKaDbAQ/u9AQ9goHe6t16/2aF6rQaU8BDskywnvP5N83PgvoHFj/0BjqSdL"
    "t2Z9bZ6USpjkOMmoDvapu5c9rssBd/9qRmnai+Vlxb2Klx+2fKij2U8k72MxxySAK1NvOJpf"
    "Hndc0Ju1B3u7JzJQkXa6eLvlpUnKjkihEFoMaJ4hRz/Iukf4+bVW6ml7IkSzuBJnzqODX4VQ"
    "AkhEo8ckoHGAHB8ykFO4XFYmM1Dm1MpYzFEJWIqoFOIUhhCfk7yQUmluyjNa0UQSR9ZHMw2r"
    "BCx5TKf0gal1XeyBppPWxRc5RA8oiMdF604AXIrblaM9XKWKpnDCenFzolRt0vDfiYHtCYD2"
    "dbP88Vmn6jJK1QaoYqn4E5hRbs5Qn6lS/rTTceY2J/oAwD+6cIfERriy1sprZ0mimM8gZtT6"
    "+5Q/7HQssX766bcnUwEA/fa5ZTvWthNdSermSGDmupbYlkp988zzr7vj538DpFylIsmNfrMA"
    "AAAASUVORK5CYII=")
index.append('medal_bronze_1')
catalog['medal_bronze_1'] = medal_bronze_1

#----------------------------------------------------------------------
medal_bronze_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiFJ"
    "REFUOI11kr1rVEEUxc+8t5u3L0ljkmLBEMQ0plSQNPsPxEpIKagQrKy0WiyCpMp/YKESSKNl"
    "WiGNEiIpTGETSLAwRFg/srhx9+2buV8Wb41v3ThwuQxzz28OZ8ahtB5u37dbC0vYb+9CTCEq"
    "g1KwMm7ONLCxtYk3j9+6P5pKGcDEUCuGRQWsOuh/KwQuS/4BBIYZQCIlSFGqWpx5GgJE5Q0F"
    "RoJxJFENJIwghCAEEkYSp0htEhSGAUMOgqe19uH71Xv5N0yftZByYTeLIrTGp7H9+R2C57X/"
    "Al7h+0nvy2m3unB3kmbn0JMIxjkcZ5jtH+PO0evuyjxOkpLmPE3bXFxUuC26/qTuQwLNfoLz"
    "HoxyGAfAxUhqDunhs5YLenvs0cHeUAbK3JRrK3XPKSTrQEIhNArQPAN3fiBrd+DnluvS1eZI"
    "iGbUoImr0P6vQsgBYIKSh3GAUh98doo+j8Pl3BjNQDGlFsMoh3KACUG5EEsYQHwO8QyRaOqC"
    "ZzSYCJTp3Pp5yaBzgImH6QX/wNTajrqAyrB19kUO5AEowB6OrD0CcEI7lc4BXKUKlTBkvbhZ"
    "EFVT1PxXUMDOCEB7uh7vv2xVXYaoWgNUYUIwIsAMcTqBZKKK+ONuy5lbH/kHAOCfzj+AYC3c"
    "WK7nY5chrDCfAZRhrHeM+MNuywSrl158en4hAAB6zSuLdqZNx9oQdVMQwMy1TbDDlWR9ZuNo"
    "rzz/G6Lmoe5Y078KAAAAAElFTkSuQmCC")
index.append('medal_bronze_2')
catalog['medal_bronze_2'] = medal_bronze_2

#----------------------------------------------------------------------
medal_bronze_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhxJ"
    "REFUOI19kr9rU1EUx783Ly8vzypiVQyKRVoHwakuBcnuJkIRHFxEOjjqFByK1CWTox1UCqKj"
    "4L8ghJYi7aBoocXBLkaowdS8l3fvPT8cXhpeTPDA4XLhfr7ny/ceg0LdePpB7928jI3vHQgp"
    "mAXMAmEBkaA+dxrP325ja/W2OWLKRQFhhoiC/ACk/GTKm0jBxEVkVGA4zXMOFeCh4D8CpREH"
    "xEhSj/MnInjHI33xZIxeasH8Xwe0cvD14/Ldsxs4F+2hKgkAINUYPzCLtS/zYApWiowpXvTN"
    "9aWEqs/Cq3eO+8oMmEtQymAoRdjfh9t914uRPooefH4xJqCvFxYE5r2ff1yzLoKkv0FZAvUZ"
    "lBxgAkRVg3h3tW2c3Ko83NkcyUCIGnzlfs1SDE67YJeD6h0kS0HdA6SdLuzMYo170hgLUdXX"
    "/dQspP8nB8kB5CHeQslBfB90+At9OgaTUX08RMG0aAD1GYQclD2EcpjdQMRmYEtgLk1P+EaF"
    "MkPID60PmwcnOShbqEzYAxXtGN8DhEetk81z8BaAAGRhvHbGBAz7Vrm7A1MOIexGrOeTGaUw"
    "RtX+hHdojQlIIs1g+1U7NClKYRUQgbKHeg+oIoinEE2FCD6tt42a5sRFsk/mlsBYcdcWa1nl"
    "ApgEalPAp6gk+wi21tvKWD718tv4Ih1V0ri0oIfSMCR1FjMNBlRNRxktKkfNM2t7m8X3fwHh"
    "lqcvDtbvjQAAAABJRU5ErkJggg==")
index.append('medal_bronze_3')
catalog['medal_bronze_3'] = medal_bronze_3

#----------------------------------------------------------------------
medal_bronze_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoZJ"
    "REFUOI11k01olEcYx3/z7m52UzegUdKktBr8AJVY24Om1RwKpeChFMGLJ0E8SchBvCxSejAe"
    "ordeFAq99NSj1xr7Qf3oh1DoRwgIudgoi2ZXd7P77jszz8zTw5vGrJIHhnnm8P/xn//MY1gr"
    "mZlWDk4g8/OoCBoC0Xvi2l46cQK9/RPVH24ZNlTx/2ajSDcIo0h+FkGd59V6CfCCihCtJYrk"
    "IJH1vrgJIFkHOI9aC7t2EawlWkuwlpBlmL17iWkPdW5zB9G5y0lj8YvykQ6DHw5AsbAGNkia"
    "4R4sEKy/vCmg8umj5eiTjkycqdqBnYSQoJJhJKXUe0TZfNvhmCxzvh9gAPSbycmIuenfvzRq"
    "XZmYvkCyLuozVByYAuWKYfDhjbpx8eTAhcXf+jKIIrWw/9yolUFC2iK4XKjeEbMUaa2QNlvY"
    "nadGQyfWXgtR1U/5LbuJvdVcKA7EE71FxRF9D2k36MkbmEymXs8gMhy1gPqMKA4Nnii5OLh8"
    "/8W2ePCkTnv7xI7Ts++0n3ca1767+veVtRA1/0Ti162vr+D4uddgaazIRweO8/bwPn5cuDn0"
    "6z93Zo9Oj23NrxC1aXwHYui3Lhb1ju+7dd7bf5iQBA6PfUIwng8OHQN0OgEwwd8tthYxxRIx"
    "uD7rKo5nnRVKpspnB2YAuPjxV+wZeReDqeSv0I1zhT++rpdMSlKqQIxoyGcCVdrtBgtP7jM3"
    "fxaAuVtnWXr6F4pmBYDZ+ebjz49vaxeX7h1JRt6q6pYRksoQhXKFYnmAYJvcbz5k/M1xVtJl"
    "Wt2n3PvzDu0X9su+0ezWxie1HWtG4lSIZpgAqqapgbvnqrL6b6InDQwprKJ6/ffr9dp/lmS+"
    "YLB2+ekAAAAASUVORK5CYII=")
index.append('medal_bronze_add')
catalog['medal_bronze_add'] = medal_bronze_add

#----------------------------------------------------------------------
medal_bronze_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoBJ"
    "REFUOI11k8FrXFUUxn/3vcnMJI0LSympYpNKBbHdFCmhmo3gIhYXBd240I0rERfppkGKlLaU"
    "0j/ArlzYVXd148IkSsG6KIKIkI5UkkVIQrTNtJPOvHn33nPP6eLFNNOSDy7n3MX38Z3v3uPY"
    "hnz1pfHWcWR+HhPBUkJjRLfr0PQ0tnCb0V/mHLtQ+7/ZTbJdRBWp7iJYiDyPZwJRMBHUe1Sk"
    "EhLZ6Wt7CGQ7AiFi3sP4OMl71HuS96SyxB09ihZ9LIS9HWgIF7PN1jeNk12GT9Whlm8LO6Qo"
    "Cb8vkny8uKdA88OVVY1ZV45/Nurrh0kpw6TEScFQf4WGu9nlHVnli0EBB2A3JicV90M88fWY"
    "Dw20eIyUPSyWmARwOY2mY/j+9Q0X9Ex9pnV3IAMVmU1vfj7mZZhUdEihIloMaFkgnYcU7Q7+"
    "8EdjqauzL4RoFqfivtfR/pOKKAEkotFjEtDYR7Y26csIrpSpFzNQ9qvlWCxRCViKqFTkFKra"
    "WVqk83OL8r+NAz+9n68Y9u30gl7dDtGqTyRxx/rOSYHOcguVLm9/OkPjyDH6f829du/Xucvz"
    "9nevGkGt7WIXNA1aF4/FwIPFu7zx3sc0l27jvv+EkeVbTIwfyBM2UwNwKd6pdVpnQu1VNIUB"
    "6yYB7XZpjh2B02efzX7hELm5ieoVeno1/+O7jSFXkA01QRVL1U5ghhsdofjzR7hwCH/O8eic"
    "Y+vfB6Tc1nOAS/PttfPvvrxVW/rtZHbwlVHbd5Cs+RJ5o0mtUadufVbv3yOr58S8R2fTWF7P"
    "UhK7NrCavdmJSdvSWSc6ldTtJ4GZa1vizj+R9fbDtdOZunHNbE2x6x8s6JWnqnHFcWbsFncA"
    "AAAASUVORK5CYII=")
index.append('medal_bronze_delete')
catalog['medal_bronze_delete'] = medal_bronze_delete

#----------------------------------------------------------------------
medal_gold_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgdJ"
    "REFUOI11kj1oVEEUhb95uysxJiJbyIpIigQFEds06Q2kERs7Ky1ERKzcKkUaA3YWWtjbBcRG"
    "MSJBUphCwc4iCGJCFjEbN+77mTd37rXIJrvJxoHDnSnON2fuXMfAkvv3jMtXkOVlTASLEQ0B"
    "7dXa7Cz2foWxD+/cvqc6CBg02YBRRfbOIlgZBi1HAEEwEdR7VGQPJHKwrx4DSA4ByoB5DxMT"
    "RO9R74neE4sCNzWFZjlWlv9PoGW54Lpf52tzW9Ru/oYTHlUjZgm6/QNdaWM+LPwXUHvwaUNz"
    "13WTD8cYvYSRkGiOCx109xvlyNOuzhUb3Oh7DrpZfjw/TWKv3NSzhlVOo9IG+YvFFIsFOAcx"
    "0P3cbMWS6+dusXa4B1Y23YVHDaueweQPxByLRU8p6n9hmjJy8W6j3KU59ASVMFM5dRWTXUyL"
    "nnxPBaYZGnZIRs8iKTNDvxAt1i2pYpqD+p6KvmIBsQsWCIH6EECjgglo2Y++f3vsJ8I84o+Z"
    "AxVpW+hgFo5EL/oQlFhmSEF7CGDBr8btNZyrHI4fe9UCSXKSfOsnWYfVIYBkLHa/PG5psQ2V"
    "EcwEi70kKK46jhSO9aU3rSJjcWgOADafc0cDC+PTtxu1+iQ4wyQllh3SzXXWX75tZRnzs0u8"
    "OBYA8P0J036HpnhmYqAePPicdp6yqoHFa6/3Bmh//QPHPZ+Qy8eH9QAAAABJRU5ErkJggg==")
index.append('medal_gold_1')
catalog['medal_gold_1'] = medal_gold_1

#----------------------------------------------------------------------
medal_gold_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhdJ"
    "REFUOI11kj1oU1EUx3/vJZKktqVEKVFxqigublKQ7H5Mrg6Kgw7ipIuZOnSx4Oagg4Mg0q1Q"
    "XFQQpFKEDhbUQYciFFsMSl9NzXt5736c45BXkzT1wJ/D5d7zu/977gnoi9tvruul0xdZjd7j"
    "VfDicwlOHGcP13m6+IzXd5eC3ZpiP8BZh2j3sBePE8lzT8a4/pI9AONQBet9H6QrEenuZXYA"
    "EPYvrHGUGKEUlrHeYbzFeIv1jlKhQkVHsWYQMODAZHY2Wl+auVr6QtWuU9YUEaUtBX7JUd5+"
    "FkzmZv8LeD71cSNxn9qVyTujjJxCCQmkw7htMbrzlYnoYfvKuXTjUF/Nv26ad8emCXUxOPGo"
    "poVxxEXg/qA+Rn0KQQDe0v7QaHrD5SPXWBnsgZpGcPxeTYsTqPsNvoP6NFeMZD9RiSmfvFUz"
    "OzSGniDO1gsHz6BuB5U0V5YrRSVB7DbhyCQupj70C159VcMiKh2QLFfak0/Bt0Et1lIdAogX"
    "UAdietZ3b/c9R2iGy/aZA3EuUttC1e6xnvYgCN4kuJRoCKA2W/ZbKwRBYdC+z7NawrBC58d3"
    "khbLQwCXMNdevd+UdAsKZVQd6nMnCEFxDJcGrC28bKYJc0NzALD5mJtimR2bvlE7UJ2CQFEX"
    "402LeHONtflXzSRh5sICT/YFAHx7wHS2TcNl1L2lajPIOkSdmGWxzJ1/0R2g3fgLTqeaZY3V"
    "GmkAAAAASUVORK5CYII=")
index.append('medal_gold_2')
catalog['medal_gold_2'] = medal_gold_2

#----------------------------------------------------------------------
medal_gold_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg1J"
    "REFUOI19kjFoU1EUhr+XRE1bo5KiRKVQaFEn1y4Z3OokIrg4CIIdBCcXM3WogwXBsR0cRbeC"
    "uChuSrF0aBcROpSCSDGITU2a9/Leu/ec45CkSZrigZ/DHf7v/Jx7Avpq9tlne3BrmrUfNdQb"
    "IoqIoqJ4r5Snxll6s8nG8t2g68n1A1QEVcO7jtG3u/i2vDfES79lEHA4zUnb1Gc+BB4BZAYS"
    "eCGMHJcKp3CpDGji7AjNKEHkvwn8wp+dr/P3pj5xvvCNfFBH1QjdGFV3jdffbyB+bKHfE/Q/"
    "/NrkXJiefDk6+fg0o1cxMpi2MFdHG1vsby038xw8Gb/jXg0B0i+XZ8jYu2B6qWTZM6ivgT/A"
    "JMQkhiAAcTQ3KlVJuX3xPuuDO7C0Ekw8LVnuHOb/grQwiTsK0eQ3piH5K49KaYPK0A7Uu3J2"
    "7DrmG5jGHSUdxZhGqNsnM3oBH1Ie+gUxKVomh2kLNOko7klikCaYwzmKQwAVBfOgaS96d7r0"
    "EmEJPjnmDtT7mrk6Zu5I9LgHQZE0wsfUhgDmklXZWycIsoPxpdPNkcmM0Pr1k6jO6hDARyw2"
    "N59XNd6DbB4zj0knCUqQK+DjgO2VD9U4YvHYQ9pdZk4dC4WZh6UTxSkIDPMhktYJd7fZfvux"
    "GkXM31xh+JC6tfOCmWSfik8oi6PoEkha1Fohq+pYnH3fPqBu/QOSYaDbWPWasQAAAABJRU5E"
    "rkJggg==")
index.append('medal_gold_3')
catalog['medal_gold_3'] = medal_gold_3

#----------------------------------------------------------------------
medal_gold_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnhJ"
    "REFUOI11k0trFEEUhb/qSUvMQzSKJqgoGJ9oFPGFRFyIEhBE3LgTXEoIKi6clQsVjHGjLrLw"
    "PwjZKCQRI0YlCgo+Air4gqghTiaZme6Zru6qui561CSSA4d7a3HPPaeoUlRhujqFLVsxg4OI"
    "MYi1uCTBVavf0YE8eETDwwHFDNT8aWYOyYxBZ0x6NgaJE+bin0BiEGNwWuOMSYWM+dvXzCPg"
    "/RWIE0RrWLMGqzVOa6zW2ChCtbbiyhUkjud34OL4sgpeX/KP/sQ/mYMFGucEW/Zwk99wj/KI"
    "Ti7PK+CfHRlzFRWodecbqNuI4OG5Ciop4IrviWtvB+5oNMaJ2QIKIH68ci+e9KnW3mbJLMKZ"
    "PJgSYkPERqAU2ITgZXbcxhxvOcXz2XcgcVatvtgsNYsRMw22gtioyhCnJxAXUrvhTHNcJPtf"
    "BGeS9kx9G2KKiIuq1FVGiCvjkim8uuWYkPb/IoQPGq2/877noh9gy6l1E1QjBIgJGPoaMvwd"
    "CpWQYlgoTQWTPf3X315NHVgHYsDF/6z/2W4jBj4VeWfqOHhgF6ua1jM02tc48m74yp7OlsVe"
    "GsHkJSkgksyxnvLexzw7Nm3HepbtLYexKmHftv2AdHrpK9RP7ORzlMqA0+CilDatE8Ucvmrg"
    "2OYuAC4cusO65W0oVK0HYMp0B6+ujbtoEjK1iBjEVp3gKAU5Rn88o3vwNADdA6f5NPEGQaIM"
    "QM9dvp87QrH8oX93zZJVDZn6FpS/COUtRCRDaTrHyM8vrF2xllx5jEI4wdPXwxSn9a1ZX/Pz"
    "DfbqKbJG024TmhINukK+EvLk5tJlpV++f1xBo0AJkd4XvePZ36xFvdeazk63AAAAAElFTkSu"
    "QmCC")
index.append('medal_gold_add')
catalog['medal_gold_add'] = medal_gold_add

#----------------------------------------------------------------------
medal_gold_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmtJ"
    "REFUOI11k81vjFEUh59735maVuMrIm2QttEgiMRCbLqwECk2IhJs7EXE16JdSSOCsLNg7Q8Q"
    "Fiy0TdP4CguChfiIJmiLMq2OmXfe+773nmMxU21JT/LLOXdxnvM7N/ca6uFPHFc2bcEPDKDe"
    "oyEgWYbUc767Gx0cpnmo3zAncjPF3Cad0yje187eo2nGvzELyDzqPeIc4n0N5P3fOrcAwP4F"
    "pBnqHLS1EZxDnCM4R0gSTGcnElfRNF3YgaTpeVN+dS6/7yv5Qz+hwSGihNgixU/I8CTqsvML"
    "AvInn45K1ZTNutPNNG1AsVipYrJppPSWtHCtLPuSUQ7MBxiA9MHqHVi9Yzqvt2i0BPGT4H+j"
    "oYKGBIyBkFF+3vstpOxvPcqz+Xegaa9Z29OiuWWo/wWhioakrgriJlCpUFh/rCUt0fvfCuKz"
    "rmjxVtSXUEnqcnUlqMRINoVtWoWv0PUfIGhYYW0OlSqIqyuZVUiYePyOiSd3icdyK+/v0s+K"
    "Xu8elMs1B0FAPUg6a31mekiYePKBeCRj2+GzLOrYTPV1/9o3D/svDOjbiq2t4Cc1m0Y1+8d6"
    "TV+GXtC58yCFj8OYm0doGrlNe9vKKKCnc7VX6B6F4rP9dulGdK79UMu+GFNo6YC9Z2Z372sl"
    "UtNuAXzM5fKLS98kKUJUQNWjoe4EIVreSPzyHvS14noMUz2G0vcfhEjHI4Artxg7tZtS/O7+"
    "9tzyNc3R4lZMfgnGNqIa4csVxl6/xzZEZFGF6aIyMm5D8Hpl3tccucoON0Wvd3SFjBWZA1dl"
    "slrhUYNdNZ5MFfdaMW1idUzQG3sG5eIfxNC9CuDWbBAAAAAASUVORK5CYII=")
index.append('medal_gold_delete')
catalog['medal_gold_delete'] = medal_gold_delete

#----------------------------------------------------------------------
medal_silver_1 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAf5J"
    "REFUOI11ki9vG0EQxd85rs6ObeLK6oFIIUFVkUkMAgoKAgtaEl4ZVOUBUYBRpHwD198gBsVN"
    "1VpVSCSrLLAswLJbA//Z3dmZmy1IfbrkkpVWOyPN+83s00TIHfn0MeDlK8jlJYIIQppCmaH/"
    "32eHhwjfRqh//xptNOU8IC8KOaGK3OUiCJ7zkgcAFgQRKBFU5A4kksXlRwClewDPCETA7i5S"
    "IigRUiKkziHa24Mai+D90xOo9z1y7nT+7j1WjTrc1haYGbpcovLnL178+IkGce9JwO+Tk9tg"
    "zOr5zk69AkBVEUIAADjn8KtUWpk3r29xdJRpMjdvbm72mflLkiTJcrmEtRaqClVFqVRCHMeI"
    "4xij0WjCzG+73e71PQ+Y+bjVaiWLxQLGGKRpijRNoapgZqxWKxhj0G63E2vtccFE7/1BCAHW"
    "WohI1l1VM9h6vUatVoNz7qDggfe+qaqZGDkP8jkAEFGzAGDmrDj/PoxDCHDOFfeAiOYbxzd/"
    "34y/iaMogojAez8vAJxzV9ZaxHGcdc3fEAKq1Sqm0ym891cFgDHmbDweTyqVCra3t+95EEUR"
    "arUayuUyhsPhhIjOCnsAAP1+/wMR9TqdTtJoNAAgm2Y2m+Hi4mJCRKeDweDzowAAOD8/32fm"
    "Y+/9ARE1vfdg5rmIXInIWb/fv87X/wOrjrYLU4cXsAAAAABJRU5ErkJggg==")
index.append('medal_silver_1')
catalog['medal_silver_1'] = medal_silver_1

#----------------------------------------------------------------------
medal_silver_2 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgVJ"
    "REFUOI11kr+LE0EUx7+7BjfJXppgYIv7B+wkIJcijaU2Wl9lIynsBCGCXBEQAvkP1oBgmxTX"
    "ChYRgnAQbCQg1hFiAinyY3fnvZk3FknWza0OPGaGee8zbz6Mg8x4+fm5fXL/Mb6tvsJYgRFz"
    "CIEWjYf3mvhw/RGfXn1xjjWFLECzhth9shEDLXKY/waRzpbcApCGtQAbk4HsQ0T2Z4pPAG52"
    "w6ThoQzPLYKNBhkGGQYbDe9OCSV7BqZTwEkHpLjzaza/elR5iru2CIddsDAis8NG1vj5/QdI"
    "6c5/AW8fvJtFFG3Pq+dnAA5tWwBAkiRQv2n7uv5mdonLtCa1OZ1OL5j5OgiCYLPZII5jiAhE"
    "BK7rwvM8eJ6H0Wg0Z+ZnrVbr5sQBM7drtVqwXq8RRRGMMTBmL4+Zsd1uEUUR6vV6EMdxOyeR"
    "iJrWWsRxDK11eruIpLDdbgff95EkSTPngIiqIpIWZx1k9wCglKrmAMycJmfn22trLZIkSSWm"
    "T1BKrY7Gj28/tn9cO44DrTWIaJUDJEkyjuMYnuelt2bDWotSqYTFYgEiGucAURR1J5PJvFgs"
    "olwunzhwHAe+76NQKGA4HM6VUt3cPwCAMAxfKKU6jUYjqFQqAJB2s1wuMRgM5kqpq36///6f"
    "AADo9XoXzNwmoqZSqkpEYOaV1nqste6GYXiTzf8Dm0Oyv0SyhiUAAAAASUVORK5CYII=")
index.append('medal_silver_2')
catalog['medal_silver_2'] = medal_silver_2

#----------------------------------------------------------------------
medal_silver_3 = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgJJ"
    "REFUOI19kr+LU0EQx78vBF9+XBAjwUfgsNDGNs2liJXFdWJjYyFYSP6FVFfEJpDeg5hWm6Tw"
    "L5AIATk4BYv8AQcpYiKBS17e292ZnbWIeb5c1IVhZmG/n5n5sh5S5/TNZ/fq6UN8uVpC2MFa"
    "gbUCsQJmQePBXbx9/w1fz597O002DRBrIeLA9FvI22x5G8wOlm1asg9IupHdilLiBHgDkNmb"
    "gC02EaFa8kHG7sXx7TzCSMPa/07A7enVz7Mnj45weu8WPCEQCSItuNYbfJr8gGVu/xNw/vL+"
    "dKMoPK7eOQIAEYFzDgCglIK5/h4+ruamLz780SRuTiaTEyL6GARBsF6vEccxRAQigkwmA9/3"
    "4fs+RqPRjIieNZvNiz0PiKhVqVSC1WqFKIpgrYW1FiICIkIYhoiiCLVaLYjjuHVgojGm4ZxD"
    "HMdg5qS7iCSwzWaDYrEIpVTjwANjTFlEEnHag/QdALTW5QMAESWP0/lm7ZyDUioxMVlBa73c"
    "Ob7bfTf+rvY8D8wMY8zyAKCUGsdxDN/3k67pcM4hn89jPp/DGDM+AERR1Lm8vJzlcjkUCoU9"
    "DzzPQ7FYRDabxXA4nGmtOwf/AAB6vd5rrXW7Xq8HpVIJAJJpFosFBoPBTGt91u/33/0VAADd"
    "bveEiFrGmIbWumyMAREtmXnMzJ1er3eRfv8LEqq5N7+wPYUAAAAASUVORK5CYII=")
index.append('medal_silver_3')
catalog['medal_silver_3'] = medal_silver_3

#----------------------------------------------------------------------
medal_silver_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnRJ"
    "REFUOI11k89LFVEUxz8zavP0PSEt6ymCQgYVlSGkES6ECnQTLgqiXSsX4qqNC2lRLSxXbVz0"
    "Pwhu0yhRk35IYvYIF0ILLRN/NW+cmftj7m2h7/UsPHA558A9n3PO93IdDkwP9FsuXERPTmK1"
    "xiYJRinMga/o7sa+niLzZsKhxMoLQWmRLSk0Wu/nWmOl4l/7C1AaqzVGCIzW+yCti3H5EQC3"
    "CJAKKwQ0NZEIgRGCRAiSOMZpacGEEVbKoycwUj4Wcfxo+85dguoMcVkZSilMPk9qc4vTb6ep"
    "FurxkYCVoaFVG4bBicbGTAowxmCtBSCOYz67bhDe7Frl/v1DAAcgl8t1KKXGs9lsNp/PE0UR"
    "xhiMMbiui+d5eJ7H1NTUulKqt6+v78MhDZRSg3V1dVnf9wnDkCRJSJIEYwxKKYIgIAxD2tra"
    "slEUDf4nopSy01pLFEVorYvdjTFF2N7eHul0mjiOO//TQEpZa4wpFlOiQSHP/fzI8sIC/rHd"
    "k/eedPk7wdbzV8+WnpYfrFC8XOoL8eLaHJvuN7o622msPcvb3Hj1+68zT9r764+7AEKI7YLi"
    "hd0L4xtj+PT9DVfOtZK4Ca31t0gcxbVL1wHb7x4802wURXieV+xaejb9X1Q4GW6fHwDg4Y2X"
    "nDl1GQcn5QKEYTg8Pz+/nkqlqKqqOqSB4zj4wS65H3MMTz4AYHjiASsbX7DYuAxgbGxsraen"
    "x19eXr7a0NCQqampIZPJkE6nqaysZNffYXFtmubTzWyGq/ze2+Dd4gz+rnhx6GuOjIx0KKUG"
    "pZSdQohaKSVKqW2t9eySncwLN+h1oNpCHmtHP46uD/4B/9jKGadrVf0AAAAASUVORK5CYII=")
index.append('medal_silver_add')
catalog['medal_silver_add'] = medal_silver_add

#----------------------------------------------------------------------
medal_silver_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm9J"
    "REFUOI11k89LVFEUx7/vvak3vww0pVGMUbAW1UoKNy5cSDiuJIrIf2AW0aI2upAIiZDc17pN"
    "O0mCFqnYULaINCQwmoUuYhStxmp+3Pvur3NbOPOcUTybcw7c8znnfA/XQc30vbsWl65ALy7C"
    "ag1rDEgpUM2fGhmBXcohubzgoMEi9aCxyDYUktYHudawUuGoHQKUhtUaJARI6wOQ1mEcOQHg"
    "hgCpYIUA0mkYIUBCwAgBEwRw+vpAjMNKefIEJOW0CIKH+zdvodKSROB5UEqBymVEfxdx7t17"
    "tAg1fSJgc2qqYBmrnO3uTkYBEBGstQCAIAjwxXUrbHiogPHxJoADABsbGwNKqflUKpUql8vg"
    "nIOIQERwXRe+78P3feRyuV2l1Fg2m/3UpIFSarKjoyNVKpXAGIMxBsYYEBGUUqhUKmCMob+/"
    "P8U5nzwmopRy0FoLzjm01mF3Igph1WoViUQCQRAMHtNAStlGRGExGjQI88/z2F2bx9XCVvvb"
    "Ye+HhX02skQzkdoK4eNGH8Zrr3Gm8BEXb2fh914G/7pw/tuHhceL9nvVBQAhxH5d8fru9fGJ"
    "CHzlJS4M3UB0MwfnxR3Et16hJ93uGdj7kdqZVjjnY77vH9z+yCRucQ/RVC8w+uBw90ed8KzT"
    "4wIAY2xmdXV1NxqNIh6PN2ngOA5sWzvY+hvgUSfEhIM/Ew5Ke79gPLvjAcDc3Nx2JpMp5fP5"
    "a11dXcnW1lYkk0kkEgnEYjFIzlBcX4Z32oXyqvhXtNjacY3R9mnT15ydnR1QSk1KKQeFEG1S"
    "Siil9rXWK9f/5nZiP/OjLjlpcu02wT7PLNGT/2SNyz+KrXTZAAAAAElFTkSuQmCC")
index.append('medal_silver_delete')
catalog['medal_silver_delete'] = medal_silver_delete

#----------------------------------------------------------------------
money = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArxJ"
    "REFUOI2N0t1LU3EYB/Dv2TnzZe4sj8ep021uynwJb7pLvLAuAm/yH5CoRUkUIwi7qNClmUV1"
    "YUFBCEVY0QuJQg5S8y3ojW1eaKhzWkqbbvl2No8dz35n686M1PrePnw/PPA8wH/k5nCL6Pzo"
    "1G03U/2rfGOoWUxPS9ckrVOC0/U3sitwffCKmK5N1xj1JvAsD4WSBIfL8QeyI3BtoEnktJzG"
    "pDcjKq/CrDcha48eSTFKcLT/RrYFWgYaRY7lNGa9CZENARKRMDT2DgWGQhgyDCDJklDTXqPb"
    "Frja3yByWk5j1psxOjcGf3Aa8UQcJYU2CPIqiow25HA5oIiyAAD01nJTX8M6z/IaS5YFxXwJ"
    "DlmrEIqEMLv0DZm6TLBqFt7pEfi++8gT+/OUzQ1aP7TaGnvrZZ7NSLVk5WNsbgx5qWY8fP8A"
    "+83loFUMtGotPP4R+APToFU0U+msZACAvvPpVr0QXeng2Qy6IMeKiBzBYnQRoUgIB2wH8fhz"
    "O8qse+GdGsFU0A9HlQPhtTDWlAg98drXT13uvZTgWR4F2VZEYhFIyk8kEgkEwvNgKAalxlJ4"
    "/F6ExTDs5XYQRYFMJNztuQeJkAyGUTGPBFE4Or+ygGwuC55JL0oLimHJyQerZuGe8kBWybCX"
    "H8NSdBlvZlwbP4LLydF1sY7E41aqeeiigchUkBCCvMxc5PK5EDYE6JJ0cPs8CIkhHC6rxtfF"
    "afSPDvYQokwgFrvdfe7tDABQAHDBVddWnF1yYjQwiny9GSa9CW6fG77AFIqMRZiYm5iRFfmk"
    "kojNu870jW+9HAUA5zvPFqelsV8qCivoLm8ndBodxmcnE0lqdQ8hZPjVqa6WnT6WAoDa+7Vq"
    "FRd/QUisOi1Fq5oNzZIUdXK5LEvLHae7Z3YqbwIAcPzpkX0KibdtKLLzmf1l926lrfkFZwko"
    "NnWbNIsAAAAASUVORK5CYII=")
index.append('money')
catalog['money'] = money

#----------------------------------------------------------------------
money_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvlJ"
    "REFUOI2N0jtsGwUcx/Hvne3UcXxuzhc7CUlcO8ElgUCKgCpUQCilkicmtqoSYaOSJxZQaU0L"
    "hAg6FIYOgGAIIBCoA49KENQHVUtpXqJNkeM4lRNsJ2fckjvHydnn8zEg3uHxX//6ffQbfvA/"
    "7tWvR8qJSwnfZj/xv8KvnHux3NzU7GlYF7TEqb8j/wqMnn2h3Oxt9nQGulAkBUswtPip+J+Q"
    "fwRePnO0LHtlT1cgRKm6SijQRXBrgAZT0OJjvyObAiNnjpRlSfaEAl3oFQ2jZnBu9jzd7T20"
    "+9upbTG0fWP7fJsCL50+XJa9sicUCHF1aZZ0foG6Xae3J4pWXWV7Z5Q2uQ2hZq0AOP4YPvrV"
    "4XVFUjzhYJjblF72RmKousrijQwtvhYkl8T0wgypbKr23vCH7t8aHP/mePTI+KGqIvkbw8Ft"
    "zC7N0tEY4p2LbzMYuh+H6MTr8jKVniGdW8AhOpxDiSEngOP1b48d0ko/nVQkv6O7LYJe1SmW"
    "iqi6ysPR3bx7eYz+yO1Mz88wn08Tj8UprBVYs3RH8rPUaeH58YO2Iil0t0bQTR3D2sC2bXKF"
    "ZZyCk77OPqbS09xcyeHegNK6hmFusEoFS/L6HY8+8UikYlZ2APibZCaSU7TICopPoUPuYHJ+"
    "mlJRpaVRZNc9O9lzXwzDWUC9Mcfy9R86RJzms7V6jYyaIVvM8uAdD+ASG5BcEpOpKdS1FbR8"
    "nh29A1iixUD7XizBZPDOXdTNyuPic0MjyxWz8tatwSjp5essqktILh8Tc5PMZVMEm1opagVc"
    "gpfH+uIAPL3nDXqCdyEguEWAWtU8lrmZsWL9MVK5FBOpCb5fTNqiIH6RXEweLGqqcS1/kdHx"
    "4V8m/uUwC4Ur2NiGA6B/94BepjRwdenK9i0ut5DOpWtuV8OgWTU+PvnUp5/ccq+3sVT98aFw"
    "a5jiehatXODCd+fRVyuvCb+O6Mn3999t1epvVqxq4oPhjz7/60J3HmgbRRAOCCDZUMK2T1w+"
    "sfLMz4p8QIEqodeYAAAAAElFTkSuQmCC")
index.append('money_add')
catalog['money_add'] = money_add

#----------------------------------------------------------------------
money_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwFJ"
    "REFUOI2N0ltsUwUcx/HvOactpespOz1rabO1tINy0QX0wQQjZmI0mfHNmBglGvGF8NDwCASh"
    "gDoJ8kB88UGjMVOj0WCCQmIgXCRRYOtmXGO6rp1d03a0bmM9XWcv5+KT93n5v/7z++T38IP/"
    "cW98PdxI3Ex4VvuJ/xU+ff3VRndXt8uxItQSF/+O/Ctw6torjW53t6vPF0KVVQyhWYtfjP8J"
    "+Ufg9asnG4pbcYV8YertJcK+EP51PhwdoRYf+R1ZFRi+eqKhyIor7AuhtWo09SbXUzfoD24k"
    "6A2ir2nW9ozs8awKvHblWENxK66wL8xkIUW2nMO0TLZujFFrL7G5L0ZACSDoxh0A6Y/hk5eP"
    "raiy6or4I2xRt/J4dIiKVmF2IU+PpwfZLjOemyBTzOgf7v3E+VuDs9+ejZ24dLStyt61Ef8G"
    "UoUUvWvDvPfNu+wMP4gk2nDb3SSzE2RLOSRRsg0mBm0A0pu3zhyt1e+eU2Wv1B+IorU15uvz"
    "VLQKj8R288HtEQai9zA+PcF0OUt8KE51ucqyoUnpLzNXhOOXjliqrNK/PorW0WgaP2NZFqXq"
    "HDbBxra+bSSz4/iTt9k+ladTLGD2qNzqVbm5KeKVHnvx0Wir07oPwNulMJpO0qOoqB6VXqWX"
    "selxwqlJHlpYZvuTLxB77gBBrws596Ppn0xJIrbOYd3UyVfyFOeLPHzvLuyiA9kuM5ZJUlm+"
    "Q3hsgtjgUzhz1xDefxbXzOf0R1QxsFR/Wnx5cHiu1Wm9s8kfIzs3w2ylgGz3MDo1xlQxg79r"
    "PbZqFWcgCvHzcGoRDs9ga6SRLCEiAujtzpn8Yt4YGhgiU8owmhnlh9m0JQriV+nZ9BFDtIor"
    "312A40FaBwXuHhTQKj9hSFZZAhjYvUNrUN8xWfh+8xq7U8iWsrrT7tjZaTc/O7f/i/P7Hgis"
    "W6yUd4kOSexIDWoLFjNl0TB067Tw64he+uj5+w3dfLtltBMf7/30wl8XeuOZ0KGVhfI+0RQ2"
    "mKJVMrHeeuKyOfwLP2BBdH0wJE0AAAAASUVORK5CYII=")
index.append('money_delete')
catalog['money_delete'] = money_delete

#----------------------------------------------------------------------
money_dollar = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlBJ"
    "REFUOI19k91LU3EYx7/nnN82d85WZ7m5OTVPpCDBRKELrahjXXhRcOjVikDFrgoLb6I72V+g"
    "3UUFIyI0o9rSIOvCWYJBUIoUQakHe9G5hsu9ubPz0lUgek7fy4cvH57nAw8Fi/SOXZZCFY33"
    "DIB8XH4fvi09GDTrESvAHl4I+90BLw0aRTV0E4ApgDYbXh3tFBna5qYMGqAoEIbs6IleGOgY"
    "koStXWrr4ErsUtfB2raIg7AgNEFJV8DQDLJKDpliBlPy28Ghjid9lieE/PsHWJsLeS2P+bUl"
    "OZVPyT6Xv6nc6eUdxI5qT1C0dNDzrENkHRxP0wyy+XV8/v2h+f7JWFqKSDzj0K47bE4hn1X6"
    "LAEqIJc0Bbqho4ywUFTSf+rhiUlNQfzpxbGwma9tDm6M9040+EKiy8YhU8pgQy2gUNrA0ro8"
    "s7CyGB7rfhXd3Ge2ArzHKmMK1lsoihE0XQVhCHY4dsLr9AUqPcHzaNVn558vfrHcYHOOR9pF"
    "wzCONATru/buqhcoUHgjT8WHzz1uM3UgRSTeyZGBXCE3O9r5cvBF93gcQFy7q0162YqJcs6H"
    "gLuiyVSiFJGEfdV1EzV8jaCqKjxRj7SymojBgBz0BfpZO4ecksNCSo6bAgCkk7lV2e8KCKyd"
    "Q0vVATHvy4pFvQTO7gIMHX+KaaTW0rc2A7Y5aL9ztKuuqq6/lhcET5kHumEgWUhiLvFp5uev"
    "7+Gpa9PR/wL+5ezImclDu1sPg6Iw/ePd3PDpkUaznuU3JpIrj765vzbrhoHlxPJrq95fLR7c"
    "qP5awh4AAAAASUVORK5CYII=")
index.append('money_dollar')
catalog['money_dollar'] = money_dollar

#----------------------------------------------------------------------
money_euro = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiBJ"
    "REFUOI2tks1vEkEYxp/ZXT4Ega32YBXLErVQeuh6qJoqEePNi3AyGo2cTLwV/4HqX2C9NiZw"
    "8ORlNWp60Cj1YKLGFIJRtm0CDanRBstiafjY3RkPDcSWpSffw2QyeZ/f+8wzQ7BPqS+nZcoT"
    "EQbgNIRcMLGo7e0hVsLiqwtx93Dwoe2AXyKMAKBgtI165fOc3dx6EEzktYEAdWE6KR6/nCZE"
    "AO3U0aqvZnnBLdkPBiTC2dDc/JoLxJTT3X7hX/H3hbOS72g0TRjB1o/3GW7bSHVtF5Uzcc+R"
    "iXRzY+3ZwDsXX5yb2SjMssqHGyXLTJ5OypYZlJSLIvW6006vP+bwjInN6pey2W6UwRhAKQAG"
    "09C1E1feJPYCBADoOM1Z3/BEnOe9YEYLdrdfgotKAAMoAxhDbSV738pVL0RVmZJ9gegSITw2"
    "V99eAgAYvQXj1/NZK8CuEMEYAHNnb+wIORNa6GY+ZyXuAVRlSvaNnl/ibV6AAYek6DuAApSh"
    "tpxNAdgfAN2UW1U1a3MPyQ5vWDRaPzW9/jtnGm0tfKswN0jcV+qTyeSvT/fY+uK1mpqO9D1Z"
    "cT48o86f2nXe9xMrrxMl59CY1KmXtMb6coaazeecCckxNHLbNRKJUb2B2rePwfG7atkSoKYj"
    "suvYScXuGZUIZwPTtwGOAyEO6H8qWmOtkArdWckMdNADPQ4lBc/hqzxvFwGKtlbNUd181J38"
    "3+ovx2TdelLMd24AAAAASUVORK5CYII=")
index.append('money_euro')
catalog['money_euro'] = money_euro

#----------------------------------------------------------------------
money_pound = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgVJ"
    "REFUOI2lks9rE0EUx7+7pE3jmmZjGq2tyCpVEA8q/gFtQPAiJCAIgiLxIHox4EXEgwRBKAhB"
    "EHsQjVXxYku8eO56UnuwQTD4o5KNlgg1qdvobrK7M/M8VEMS0xLwe5l5M+995r15D/hPSZ0H"
    "qamcFg4omd3D4QQnoOEwc7H0/VnFttLTV04aGwJSmdzB/WPDc5HBTaq/rw+uxyFLEuqOh+UV"
    "y3xdMGJP0qfyrTFyqzG2cygXCSoq44TStx/mwoey/vFLxWCcMBRS1JHolkxnBk3AhZszicig"
    "osmyhM9L1fz82+Vd188djb37VDxklE3DZRzatvBEPJXVWgG+vxsuxAFZlmDZHgpG9dbj9AkT"
    "AKbTSfP45UfJhcLSOHm0CsDsCvAYVhknEAGMM7XVaXbytA5A70y/rQQhoNcbDP5+Hw7vHb3W"
    "zbmbml24M/OSgsoAAn4fVmp1/LJdCAI4Bxa/VvS7VxOxboBmCYIE7IYHIoIy4AdnQM12wLkA"
    "Yz2mE7/0MHH76Suamp2nY+fv91RG2xxs3xpKBfp9cD0OwUSpF4AEAPFUVtu3Z3RuJBrU1M0B"
    "OC5HzXLw03JABHABEBHyb4wHz++dTf4DAIAb2Re0IxqCIIKgtXbSn0ABgAShWDYxefFI2/g3"
    "P/F9sapzRhNcUNurggsIABBYW9fT+JmsutH9evoN5bb16NwQwA0AAAAASUVORK5CYII=")
index.append('money_pound')
catalog['money_pound'] = money_pound

#----------------------------------------------------------------------
money_yen = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhpJ"
    "REFUOI3FUE9oUnEc//jURDflhXu6kPlnjagGm1LZiEQZRBELtg7Rbu0UdHKXLhG6UwSBEl46"
    "ROzQfaNo1GHuUbGKahOKJlvTt+l8vrfZU5+pUb/XSXiIsaBDn9P3++Hz+fD9fIF/hKY1jD2+"
    "GBtx+cPfm3Xp89Ybz/wUK6mFo4lQ5MyR01G5KUsrG5987DSbBQCqJdD+qM3symLW1mWjKZ05"
    "pjYHY0H3kGswbNJ14+OXVLxlBgBta0jPcw1LwMw5rc6rhywOL05QbGYhkwUA35XhR0ftg97V"
    "XGr12Y2FSXU4pV5eXF+ce8e9nztAGeCw98YAIHjv7LivzzterVewvZWbav+Btp2wBexvu0zG"
    "ay7a7YaP0B6HK9xj7KEXV5LxV7dez+4bwD3nJIPP0Oy3uy8M9A6MOMx9tFAWpZ382gTHFhvt"
    "eqqdAAD25su4VJdg1ltACIHcqErsTErqpNWol8sPJ5KHGU+IEIJugxlWoxV6So+9WgkFKQ9F"
    "UaDT6IX7kwl7y6NTB/ySCbtWWWdBCBiGCdGOg0FOWJfyFT4lFopL5CcBAfnzBWqcv3MuevL4"
    "qQhf5vnNzNcHyQgb3bfCpcRY0sU4QwoIGJMdtImGQhSUarsofONBoECUxOST6aejHSs0yk02"
    "XU6zhBCIzF7I3+8PZsQNuVASPhR3+CVC8PcVArcD0eFjQxGhKmS3N3Ozy3eXO1b4//gNn6/k"
    "EbEvnDwAAAAASUVORK5CYII=")
index.append('money_yen')
catalog['money_yen'] = money_yen

#----------------------------------------------------------------------
monitor = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfRJ"
    "REFUOI2VkztPVEEUgL+5exeVJfJQIiG7dlgaE9BKQ0KjNLb8ADex07+wHUaTTdh6rSy0szLE"
    "BioTUAtLDPHVCVFexl3uzDlzLC6sy0KCnszkzEzOfOcxZxzA2tqaxRiJMaKqqCoi0tHdM4TQ"
    "0XNzcy4FUFXGx8vs7O2BGeQDzDDAzDprzBgeHmJx8RUAHcDO7i4PGm/4F3ly/zre+78AETlw"
    "CeXKZQb6+6iMljh7JmU/GEEiQUENVt5+wKKRZRkACUAIIQ8TcM7R2he+7+zTyhQzEDW8RDLJ"
    "bcw4GkEIgXgYn3M45/jVEqJlDJWKpGmBJBp2AIgWjwMs5gjXBWl7xYdIqb+PQiEhcbkPiycA"
    "6ErBOZdDAHOOVqa4xPJzIPam4L0nKSQAfPv65dRXKKSF44C+Ysqj6jVUjWKxyObGBqWB85gZ"
    "29s/GLs0RrvdPqh8PAaoLy8vTR92mYiMeO+XyuXyPRFhfX39qYjMhBC2DrtQVV92atYr9Xr9"
    "YQjh7s1b0zODg8O8eP6sraq1+fn5x722RwALCwujIrI5MXGFkQsXUXEEEUqlc3z+9JHV1ZXf"
    "jUZjoPtO2r3x3k9VKhVmZ+8gIpgZZkaSJExNXmVr62epWq3ebjabr0+MAKBWq70XkcneX6iq"
    "hBDeNZvNG6c+0//IH9RAUzcZArNFAAAAAElFTkSuQmCC")
index.append('monitor')
catalog['monitor'] = monitor

#----------------------------------------------------------------------
monitor_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlJJ"
    "REFUOI2Nk01IlEEYx3/zvrurtZrZB1i4QWAHL1GZHqQIkkAjBOngOYqCwDp08Sh0kUTBDh66"
    "RKduRUYIQYegIiJQi2BBRdcV3VUpV2Pd952Pp8PWtuVCPczwDMM8v+f/n2EUQDKZFOcczjms"
    "tVhrMcaUcvnUWpdyb2+vigBYazl8uJGNzU0QgeIAEQQQkdIaEerr9zIx8QKAEmAjl+PW/bf8"
    "TwzdaCUMw98AY8zPltCYOELN7hiJg3GqqyIUtKCNQ1uwAu8/TCFOCIIAAA9Aa12UCSilyBcM"
    "mY0C+cAiAsYKoXEEpnhGhD8VaK1xv/QphVKKrbzBScDeeJRIxMdzgvwEOHE7AeKKCFUG2Q4t"
    "oXbEd8fwfQ9PFXuIqwCgzIJSqggBRCnygUV5UtwH3N8WwjDE8z0AUgvz/3wFP+LvBMSiEQav"
    "ncBaIRqNsprNEq/Zg4jw7ds6mWCW6fRbtrZzDI0/QuyuIgygp6dnz9zcbGwxlVpZTC2szM3N"
    "BEtL6SfO6lPr61leJ8cnC7XpQ+0tbXS0dlKIZEltTxFv8mtVJYkjIyO3tdbdZ86eO19XV8+9"
    "8T4uX7oIvkd3cx/Dr67j4/H46bNCpLxwdHT0oDFmtanpGPv2H8BoyGTW+Pp9jaiqoav5KgB3"
    "Oh7w/PMYivHqPwBhGJ5OJBJ0dXVijEFEEBHuPs/xZfkd08tv6L/wkMGXV6j2qxCksMPCwMDA"
    "R2NMS/kPTOlpvKMrtB8/w7GGk8xkJnn36Q3p+dxwxTuoFG03GwZR6qaCWoEtRMY+jGX6fwCU"
    "sGBj9XUbOgAAAABJRU5ErkJggg==")
index.append('monitor_add')
catalog['monitor_add'] = monitor_add

#----------------------------------------------------------------------
monitor_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkRJ"
    "REFUOI2Nk81LlFEUh5/7vu+oOaJOfpA2k0kGQYuCrEUUQkFki7ZD6wJJqKBFRIuaVQTBgG1a"
    "tuofCETK0NKCyAKpjYtKpbTxI9QRxpn3fpwWo9OYA3W4l3O5nPuc37n3HgUwNTUlzjmcc1hr"
    "sdZijCn58qm1LvlkMqkCAGst7e1xVrNZEIHiABEEEJHSGhFisUaGhgYBKAFW19a4/ugt/2MP"
    "+44ThuEfgDFmMyXEE/uoq60i0RKlpjogrwVtHNqCFXj3fhJxQqFQAMAD0FoXZQJKKXJ5Q2Y1"
    "T65gEQFjhdA4CqYYI8J2BVpr3JY+pVBKsZ4zOCnQGI0QBD6eE2QT4MTtBIgrIlQZZCO0hNoR"
    "ra3C9z08VcwhrgKAshKUUkUIIEqRK1iUJ8V9wP1dQhiGeL4HwOzM9D9fwQ/8nYCqSMCDK0ex"
    "VohEIiwuLBCtq0dEWFlZJvZtjNz4U/TPWTL3Wtlbc2AbID06OtKz9cuMMbvDMByJx+OXjTF4"
    "r59MNEfXu09cuqqqOw+z8ekF9WPDbvhscE1VkphOp29orS+eOt1zpqEhxpdbJ+Vc/x216+sr"
    "mHsDDY0sBx18fD4+HZQfHBgYaDHGLHZ1HWR3UzNGQyazRF0+q2r2dMKFm6XYINWGL2r/NkAY"
    "ht2JRILe3vMYYxARRISJ1jZyk4NEn/VT2MiQA9azPtZnfkcJqVTqgzHmWHkHHlr7zBH/Ox1N"
    "msD7wfqSYSbj2zDv7la8g0o2nkzczv2a7/Oc6nCezDnkce9Ld/83V79g8J9A7e4AAAAASUVO"
    "RK5CYII=")
index.append('monitor_delete')
catalog['monitor_delete'] = monitor_delete

#----------------------------------------------------------------------
monitor_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApFJ"
    "REFUOI2NkltIVEEYx39z9mKu1q6aF8pVNClMoaQblNCFqB4iJAohoijs8hT01FMvEXSDwiAq"
    "kCAi6qGHIkKCSLoYZS9bPSSKrktYuoK5puueMzNnetg8bReijxm+GZj/b77vPyMAent7jeu6"
    "uK6L1hqtNUopL+dOKaWXW1tbhR9Aa82CBZVMTE6CMZAdYAwGMMZ4a4yhqChCZ+cjADzARCrF"
    "scvd/E9cOLIKx3F+ApRSP66EymgVhaEg0dIC5uT5yUiDVC5SgzbwuieGcQ22bQNgAUgps2UC"
    "QgjSGcXIRIa0rTEGlDY4ysVW2TPG8GsFUkrc2fqEQAjBt7TCNTaRggB+vw/LNVTTw54Vnfj6"
    "B9kw9xmxKw37PIBxswiRA5lxNI50KQgFWZz/nM0lCfLn7yVc08REfAkfH3ec9wDktCCEyEIA"
    "IwQLrRdsq08yL7yO8YGPBIXD3HkVFJZUhf2Q7cfyWQAkhuK/ON5Q0s/utQ6R2m3YX+4SDAkS"
    "sV6mphWuTC3zAMGAn7Nty9HaEAgESI6OEvH1Ew3PEK7bQWb4GlZQESisJk8luBdfyMlzN/tm"
    "ARe7up6un/1lSqniwumX8S0bqzaF61rIDF/FCiicyRo+d73WD4er+5Jp/23Ps9/j1pmWG03L"
    "a/fXr2+xnNGbCJ9DJlVJ8nnPjHamltYffzPkPVqusL29vdQaf5fctKYCJcooKe6mqCxIJhVl"
    "pPs9dwai6dMXrxfkaqzcjeM4K8tDCZY2Hybv00v6HnQTezxO39MY1TsvUV7TGGpra9uaq/mj"
    "hVOHGt0TB48KLE3syX0Gh+J8yN/IVzkHKeXbjo6O1f8E7GqOzKxYVO5fVV+LCdiv7LGxA9vP"
    "fhj8m1cA3wFlt1E/ubMoMgAAAABJRU5ErkJggg==")
index.append('monitor_edit')
catalog['monitor_edit'] = monitor_edit

#----------------------------------------------------------------------
monitor_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnBJ"
    "REFUOI2NkktIVFEYgL9z79xxGp1KcyjHV2lKiD0mMtyELVLatGmjuyiKFkEtWkSrNi16gKDt"
    "bdUigqBCWlhKURC9kCASiR4QlaJhU01z73n8LcbGsVr0c37+c+Cc73z/4SiAqakpcc7hnMNa"
    "i7UWY0yplqfWulT7+/tVDMBaSybTwEIuByJQHCCCACJSmiNCdfVqbt8eBaAEWPj6lePDD/mf"
    "uHi0iyiKlgDGmMUroaGxiapknMZ0JYmKGAUtaOPQFqzAo8eTiBPCMATAA9BaFzUBpRT5guHz"
    "QoF8aBEBY4XIOEJT3CPCcgOtNe63n1IopfiWNzgJWV0ZEIv5eE6QRYATVwIsGbgiQpVBfkaW"
    "2YWQGl7SV32ZpP+jaOD+AaCsBaVUEQIEvmbLiglaW7toDx4sGvzRQhRFeL4HwPt3b5e9eF/L"
    "FM0t3aysy7Jh8hoNVT34Mf9vQDyIce7wNqwVgiBgdmaGVEVIYuYWqdoubO4m67cf4Gj8Dp7s"
    "/gswODEx3vP7lxljarQOJ3Zm3h9q2rofCs95fOUG3UdOI/MvuDt5/o3Wq0ZKgIGBgZPl2oOD"
    "gyfS8Y8H69ZUkarOY3NvQRz2+xM27D6JHj0bZhMMXwL88oNDQ0Pp3t7eH+1trXtb/Cfr6jp6"
    "8N1zxHwh01GLuDzxZAUEm9O5D08LI3c+3fPKAVEU7aivr6drvaG2IUsyNYeYeVA+z65PAw5X"
    "mCbd3oyNomP3z3R0LDMYGxt73dnZuS/18Wqmbc8pvJiPChrxEpuoz+7CS2xCxVuJVbYRT22s"
    "nH01vlbxj3hwITsnxiXFCeJcMUVYWgs4B06e/QIgiGSqvCqWzQAAAABJRU5ErkJggg==")
index.append('monitor_error')
catalog['monitor_error'] = monitor_error

#----------------------------------------------------------------------
monitor_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkVJ"
    "REFUOI2Nk01I1EEYh5/5766Fmqmkiewqih5UisiiIKiDJNk58NAhqMBbHrt08JAkFEt2quhQ"
    "dOwcUlgWrPRpdCm0KDPJNAn8yHX/8/V2WF3Xj4MvM7xzmHne32/mHQUwOjoq3nu89zjncM5h"
    "rc3l/GmMyeXOzk4VBXDOUV0dZ25hAUQgO0AEAUQkt0aEsrJSBgYeA5ADzM3Pc+nWMNuJ612H"
    "0VqvAay1KyUhnqihuLCAREURO3dEyRjBWI9x4ARev/2IeCEMQwACAGNMViaglCKdsUzPZUiH"
    "DhGwTtDWE9rsHhHWKzDG4Ff1KYVSisW0xUtIaVGMaDRC4AVZAXjxmwHiswiVB1nWDm08RYUF"
    "RCIBgcrWEL8GyFkgz4JSKgsBRCnSoWPWdzFlzqICi99oQWtNEAkAmPgxvuXNV7SE1FY2sdDQ"
    "iw8ebQYUxKL0XTyAc0IsFuP2yHnEG7S3aGupLm+kqeoIi5klLg+202zOrAMkh4aen1jtMmtt"
    "uS3RdSdbzuHE47zDI0zNT7Ivfox/epnh9F1p7WO32kpuMpns/lT28Obp/ReY+PsV4y3WG4wz"
    "BEEBlbvipL4/4c14ykXzD/b391dYa/80NDQyMpPBOsvekhqsdzjx/J7/SXlxFR8mh0l9S81q"
    "R/s6gNb6UCKRoKPjFPfvdfPg1Q2012Sspn5PM0fr23k3kWJw7Om0drRNX+PzJgs9PT3vrbWt"
    "G3/hy8o7HKw9zosvz34ZRdvUVcZyfbOdqLvCkpNIYYirn+kl99b/ASACddRHXfO/AAAAAElF"
    "TkSuQmCC")
index.append('monitor_go')
catalog['monitor_go'] = monitor_go

#----------------------------------------------------------------------
monitor_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo1J"
    "REFUOI2Nk81LlHEQxz+/Z1fL3UpXzXzNQ2rSQYhKQkpBk5IIIgoi6CZ0iS79AXlKKLpsUJft"
    "EB1a9JARJh6kCJIkwYvo1pZCIWm1tr7sPu7ze+uw66ad/DLDzGU+zBdmBDnFYjFrjMEYg9Ya"
    "rTVKqXzdmlLKfPVvArTWVFfXklxdBWshG2AtFrDW5nusJRQqYWRkeDsgubLCrfB7dqL7N07g"
    "ed4/gF/PEkgOcff8Oj7Hh9EGtAGj2PB2M7R0k5Qtw3EcPs/OYI0lk8lkAXbgim9OTREoq+FQ"
    "2X6sVFip0J6L+yfGy59dpE0I4QgQgpwLPM/DAVhs/FkXNJMUFNVjUjMIJ4jRio3kZ17NtzOb"
    "bsMKByEEIgcw1mQBdvpIoZMxvUUlhwEfxl3EqAy/5kcZnmtlOt3xb1AIRM6yNVmAf3Gt9Kgw"
    "6sauvY1Y5YKvCqRESodiZ4m2QBSf8djQQeKcIS0qchtkLfiFNg93l58odxMxjDIUBhrA+Kmq"
    "76YkEUdLj+TCFIPfLjKd+o5nlwDw+X1ZgNFqILUw/m7BPXm7smI/q/HXhGq7UBtJvPRvVtRB"
    "Ms2Paasv4NKBSlzXBcAha2HTEtFo9IGVa53Hi8ItwX0NzvKPL2pu/ch4puJyu1KKeDz+RCnV"
    "KaVc3rxCrfWLPADg62DzWGGgpjP9e37gbeL6VFIGuk+d7ugsLg4Rff7M1Vr39ff339s6kwd8"
    "GWzqsZ55tCaL77xJXHva2NhEaVk5WgmkUgSDRcx9/cTExIdUOBzekz/APEmy4GlzYezX1bq6"
    "uhp6es6hlMJai7UWx3E4fqyF5eVEsLe392wkEhndtsFW9fX1TSqljv3/hVprpJQfI5FI6w7e"
    "ZWf6C6oXiAxQtsS8AAAAAElFTkSuQmCC")
index.append('monitor_lightning')
catalog['monitor_lightning'] = monitor_lightning

#----------------------------------------------------------------------
monitor_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoFJ"
    "REFUOI2N0c1LVFEYx/HvuXfGO3XFruhgXqpZWGGICxcGgiBuQjeBUClYRItoI/0f0iaC/oH+"
    "gHFVRvTmIoiCaNWYFE7mOF6awpcZnftyztNiahorqMM5nMPh8Hl+D0cBLC8vizEGYwxaa7TW"
    "JEnS3FtXHMfNfXp6WqUAtNb4/jG2dnZABBoTRBBARJpnROjs9FhcvA9AE9ja3ubmnRf8z7h1"
    "Y5goin4BSZL8KAnHjp+g/XAbx7MuGSdFPRbixBBr0AIvX71FjBCGIQAWQBzHjZiAUoq9esLm"
    "Vp29UCMCiRaixBAmjTciHEwQxzHmZz6lUEqxu5dgJMRz06RSNpYR5AdgxPwJiGkQqgXZjzRR"
    "bHAPt2HbFpZq1BDzF4CWFpRSDQQQpdgLNcqSxj1gfm8hiiIs2wLgU3H1n79gp+wmoADy+bwM"
    "D59lZ3eX/f06798vs/55jWw2S7m8yclTp8mdyPH06WOOHu2hUvnK+vpnCoVCuw0wNTXV8fHj"
    "h7bi6urmw8UH1qFDmfbZ2Vl838fzPF6/frVbKLyTS5cu2n19faqz06Ner1MsFtOqNdrQ0ND5"
    "8fHxe5evXTty9/btr0EQdPX29jI4OEi5XKZSqVAqlXRHR8ejubm5yXw+v221Ao7jnPM87wjA"
    "5StXu8IwZGZmhtHRUSYnJ5mYmKBare5Xq9ULAJ7nOalWwPM8giAA4PmzJwDMz8/jui4AtVoN"
    "27Yz6XR6AaBUKtUPtDAwMHCmv7//zcjISMb3fTKZDEEQsLKyguM45HI5enp6SJLk29ramrW0"
    "tLR5AADssbGxQdd1F3zfzzqOY4uIValUriulSt3d3QtAOgxDvbGx8aVWq019B2LjVPn3/VHt"
    "AAAAAElFTkSuQmCC")
index.append('monitor_link')
catalog['monitor_link'] = monitor_link

#----------------------------------------------------------------------
mouse = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm5J"
    "REFUOI2lkjFoE2EYht//ktRemvQqjZSzSUlQIsRJnDrUQcVRcBbHbs6Cg5QUEVoDxVHEJaCU"
    "gkVXl4SqpHQIaUlNKm2pFxyu4SzJccnlv/+/z0F6oK2LfeHb3ueB7+MDzpC1tbVb7H/Aer0+"
    "ZJrmI9u2H54qaDQacSHEYyHEHc75D87585mZmc8AUC6Xr/V6vWeO49xwHCd6QmAYhtrtdj9p"
    "mnZ9bGwMjuPAMAxYlvUxHA43HMe5m8vlMoeHh1hfX3/7h6Berw8RUXl0dHR6amoKRATGflea"
    "zSa2trZ6uq5HNzc3f9q2nbcs6zUDACJizWZz1vO8J7FYLJlKpaAoSgB3u11EIhF0Oh2srq6i"
    "0+k84Jyv5PN5rhAR297efjcyMvIyk8kk0+k0LMuCaZoQQqDVaqHdboOIMDExgWw2CyLS8/k8"
    "BwClVqvNxePxe6lUCrFYDAAwPj6Ofr+P3d1dhEIhJJNJhEIhSCmRTqfBOb95vLYyGAxua5oG"
    "IgqGMQZd18EYAxHB930IIcAYQ6/Xg+d5Q4HAdd2sqqpBUUoZlHVdh2VZ8DwPw8PDqFarWF5e"
    "lq7rzh8LwqGjI0gpoSgKpJSByPd9MMaQy+VgGAZKpRIqlcpX3/fvLy0t1QLBOdNsttvtC5OT"
    "k5BSBjARIRqN4uDgAMVisep5XnFxcfHF33+jnN/f30usrMCvVBCJRIIbqKqKfr+PjY0NuK77"
    "dGFh4QQMAOHLqjq71zKuXHT7098TCei6DiLCzs4OGo0GarXafKFQeH8aDAAMAEpzc+GEab7a"
    "17RLti+vflOjA875FyHEh0Kh8AYA/Utw5vwCF+ZcDJKWvS0AAAAASUVORK5CYII=")
index.append('mouse')
catalog['mouse'] = mouse

#----------------------------------------------------------------------
mouse_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtJJ"
    "REFUOI2l099LU2EYB/Dve7ZZRzePpaQHNpmZUot+SGAWGfT7LugP6MILb6yugn5QIasII7sV"
    "+nVZhJBUV6aCQy3FoObacJazsVF5XCc5O51tvnvf83YRDqIuoh547p7vB54HHuA/amxs7BD5"
    "l2A0Gi3TNO2caZqn/wjMzs56GGMXGWNHKaWfKKW32tvbJwAgFAq15HK5G5Zl7bcsq/w3IJVK"
    "ydlsdlxRlF1VVVWwLAupVAq6rg85nc5Zy7KOBwKBhqWlJUxNTT36BYhGo2VCiFBlZeWe+vp6"
    "CCFAyM+ReDyOSCSSU1W1fGZm5ptpmkFd1x8QABBCkHg83lksFq+43W6vz+eDJEmlcDabhcvl"
    "gmEYGBgYgGEYJyml/cFgkEpCCBKLxZ5UVFTcaWho8Pr9fui6Dk3TwBhDOp1GJpOBEAK1tbVo"
    "bm6GEEINBoMUAKRwONzt8XhO+Hw+uN1uAEB1dTXy+Tzm5+fhcDjg9XrhcDjAOYff7wel9ODq"
    "2tLKysphRVEghCg1IQSqqoIQAiEEbNsGYwyEEORyORSLxbJVwFkoFJplWS6FbduGbdslJJlM"
    "wuPxYHJuBCNvnsPMGzArjLZj57ddfnHz3XWnY3kZnHNIkgTO+W9IIBDA4+H7+Jh7jQPtu+Fd"
    "34TR2NPyqej4tdZTapW0RtPimUwGhBBwzsEYA2MMnHPIsoxkMonhyIC9c/MOcIljh3oEnBTR"
    "tm0vAHFKWrewkKjp74c9OQmXy1W6gSzLyOfzmJ6exvJ3XXIRN45vOQMAOHvoLho3bAcBWStt"
    "kuXOL+nUJAuNIpFIwLZtcM4xNzeHwcFBhMPhq18NrRD7/Ao9wx0AgJ6hDiSWIhAQBQIAo93d"
    "zhpNu7egKI2mzbe+l8tXKKUvGWPPent7H7Z2qdd8G5VLe7fvQ1NdCz4svsWryATSH43bf/2N"
    "rV11PSCkiwAeAZgQom+6b/HCD3b3gbKZ0mJrAAAAAElFTkSuQmCC")
index.append('mouse_add')
catalog['mouse_add'] = mouse_add

#----------------------------------------------------------------------
mouse_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtxJ"
    "REFUOI2lk0+IE3cUx7+/mUl0kuxmZUO3U5I1wZJi9CJKwcMWqrbgRdCLeOihBSlKe9BDUYou"
    "KUUU17NIKSi0PSztikJBVsGw659lQcguWTNbdkPMVnE2nZVknJnkN7/fPA9iQPRQ9MG7fb6f"
    "x3vwgPeoqamp3exdgpVKJWpZ1g+O43z3VkG1Wu0TQpwUQnzJOX/MOT8/MjJyBwBKpdI2z/PO"
    "uK77meu6sTcEjUZDb7fb08lkcvvAwABc10Wj0YBt25OaplVd191XKBRyq6urmJmZ+eM1QaVS"
    "iRJRqb+/f+fw8DCICIy9REzTxPz8vGcYRmxubm7NcZyibdu/MgAgImaa5uEgCE4lEol0JpOB"
    "oii9cLvdRiQSQavVwsTEBFqt1lec8/FiscgVImILCwt/xePxS7lcLp3NZmHbNizLghACKysr"
    "aDabICIMDQ0hn8+DiIxiscgBQCmXy6N9fX37M5kMEokEAGBwcBC+72NpaQmqqiKdTkNVVUgp"
    "kc1mwTnf9Wptpdvt7kkmkyCiXjPGYBgGGGMgIoRhCCEEGGPwPA9BEER7gk6nk9d1vQdKKXuw"
    "YRiwbRtBEGDt5mXc+3oz/ju+AyMPLmy9sUc5AQCa+uwZpJRQFAVSyp4oDEMwxlAoFFD97Rzo"
    "4Q18eugI1uW2wJ+f/ODh9OTPN8l0lXWWZTabTTDGetOFEJBSQtd11Ot11P+80M1/fgDrl0tg"
    "Vw4hVruK7MaUKkHHlA212nJqfBzh/fuIRCK9G+i6Dt/3MTs7i1jneXT9hzng++vA2TXgZA2a"
    "a0IlltU+1vXDyyuNTz7q+DsfpVIwDANEhMXFRVSrVZTL5Z++UOgbr/x3On79KLr+U3gAnLYK"
    "qeIJA4Dbo6NayrJ+qSWTm5xQbvlHj3U553eFENfGxsZ+nz5ojEYT8R8zKalpyr9wmgL1p6rk"
    "nfD0//7G6YOZE5795FslZBtDhR6HoIt7b4VnXgDmjocCUZwJ0gAAAABJRU5ErkJggg==")
index.append('mouse_delete')
catalog['mouse_delete'] = mouse_delete

#----------------------------------------------------------------------
mouse_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAs5J"
    "REFUOI2lk81rY2UUxn/vTdKZpEluMk0pAROrDqkToVjHjUIFP3ApjLrQhe5mpRsVBBdSgjCg"
    "/gkiwoCzKFqwG0GUydRCS3TGNCQ0dtqMRJ1y08ZMEm8+3vve93VRjIqz0gPP4sB5focHzoH/"
    "URsbG0+L/2KsVqtTjuO83e/3X78rYHd3N6aUekcp9ayU8lcp5YfLy8ubAMVicWkwGFxyXfcJ"
    "13Uj/wI0m81wr9f71rbt84lEAtd1aTabtNvtr4LB4K7rus/l8/n7Wq0W29vbV/4BqFarU8aY"
    "YjwefyybzWKMQYiTkXq9TqVSGaTT6cjOzs5v/X6/0G63PxYAxhhRr9cvep73bjQavSeTyWBZ"
    "1sTc6/UIhUJ0u13W1tbodruvSClXC4WCDBpjRK1W+zwej19IJpNMT0/TarXQWpNKpTg8PMTr"
    "ljk1/J65xTfJ5XKUSqV0oVCQAFa5XF6JxWIXMpkM0WgUgJmZGYbDIfv7+wSER6h3jciZRTqN"
    "L5ifn0dK+dSfsa3xePyMbdsYYyYSQpBOpxFC4B1dIzLzCPH0Endufc2wcxPP86YmgNFolAuH"
    "wxhj0Frj+z5KKYQQzNqG0S/fEEsl8HvrzJ57mds3LhuUe2kCCHQ6+L6P1hqlFL7vn0A8j35j"
    "ndkHn4fRDUqXPyWaGDI3dcyLZyuJCeCU49SPjo4QQky2K6VwnR9g3CeWHKDHt8Bo/N+/4/4n"
    "3xK+lO9tvv94DMBKNhoHqdVV9NYWoVAIYwwYn07tConsw+hBBaOHnH9hAS1vc/r0HnOLL52D"
    "0RsA1tlw+OLhz80tVbzKwcEBWmvu3PySyJkFIrFjjGqDCHB9bQ/Q6NEes7l78aV8bWMlnxcA"
    "V1dWginH+ahh2w/0tf9QNl2yH331k0DA+gmjOoD5271aBMILOLUyP64XPrvrM21+sHRslI4Y"
    "bTBan8gY/uoNaA3aXP8DEs+G6wC5l3IAAAAASUVORK5CYII=")
index.append('mouse_error')
catalog['mouse_error'] = mouse_error

#----------------------------------------------------------------------
music = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcBJ"
    "REFUOI2tk7+K4lAUxr+4CSOCCGIk6GAvLGJja2EvPkB8goGBqQWRaacRexsrH2AKS1uFAVGI"
    "RKtUkyYOikq899ybTLMJLBu32f3gcA+Hw+/84wL/KCUpOB6PQyklhBCxEVH8Rv7xeISaBPB9"
    "H81mE1LK2IIggBDit9hoNEoGRNVnsxksy4Lv+3Esm82iWq2i0WhACJEM4JxDSon9fo/pdPrH"
    "mKZphvV6HZxzpJIA0ZxhGCYuLpVKxTmJAM55vLwkMcbiRd4FRBX+VuBuBxGdc54ICMMw7uLu"
    "FaKESN1utyWEmDDGHsvlMg6HAxhjXzFgMBi0iGjCGHssFovwPA9hGH4BgGmaL7lcblgqlaDr"
    "OqSUWCwWIKJ3FQD6/f5LJpMZ6rqOfD4PIQSWyyUYY++dTufJMIxhpVLBw8MDhBBwHAfb7RZB"
    "EEzUXq/3VCgUhoZhQNM0EBEcx4FlWbherxMi+qmqKogI6XQatm3Dtm2cz+dn13Xnqud5P263"
    "Gy6XCzRNw263g23buFwuz+v1eg5gXqvVrM1m80ZEihDiQ1GUV9d1P4Ffn6ndbrdOp9Ob7/sK"
    "EX0oivK6Wq0+E0/wv/UNGuZJWe0yFYwAAAAASUVORK5CYII=")
index.append('music')
catalog['music'] = music

#----------------------------------------------------------------------
new = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAUBJ"
    "REFUOI3t0j1rUwEUxvHfTW9rIHfRpd1cVBxc1MHsOhecHRXLLUVwMZ/AIXERQe4iCDppB8Gt"
    "Szct6AeILYKm+BKHXN9SE4K9xyFa7ezaBw6c4TmH/3nhQEl03ESOAhPkwkPkEh/wFW8lCpVj"
    "oKaukqspREcZozLi0YWIjn4M+9N8MowotyI+vox4tRpxO4tYuzqNtm4MuhF3FyIV6tI6i4+5"
    "cyQzl7FwlsmQeyc+mcvmLfU4vcLR81Pu8ZeTZjN2+u9SVKJic5Vmq7E3XP0wV7bmjQa8fsqZ"
    "FX6OmTnEuRaDLnTTvYK1pR3Xyr8Nxp+nBLyRzDRd/8H2OpPvHL/I/VNQ1Pat9EWb2cZ+gksb"
    "TdXuSOzyrcf7Z9RSyk3JDU+SaLv1zxUaErlQSFxGDwPh+W/PA1R/PEnL8v8/woH8Ah0VioYI"
    "i9+mAAAAAElFTkSuQmCC")
index.append('new')
catalog['new'] = new

#----------------------------------------------------------------------
newspaper = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmdJ"
    "REFUOI2N0sFKG0EcBvBvk9W0axIvVtMibDxZiSGpBHX2ENQHKMVLoS8g9AmMFE99hDxGE+gl"
    "eKoVwY0KdRepRtIqxBqQEmxM424y85/pSYlVbOc68/tm+M+n4R+rVCpFhRAfpJRfBgcH383P"
    "z4ve/cB/4IIQwuKcvz0/P3+/vr6u954JPoQ55wUisizLGkgkEqHDw8PpZrNpzM3Nba6trREA"
    "aA9hIYTFGDN2d3ehlMLCwgIKhYIkohIRLS4tLfE7LyiVStFut1skIosxZuzs7MDzPBiGgdHR"
    "USSTSc1xnKdSykgmk/kcvA8LIVgvjkajeDb+Ah+dn7jwCL9OK/1ERKFQqBjoxb7vFznnjDFm"
    "bG9vo91uIxKJgDEG+/gSX+u/sVlp4OWrRY2IpohoMtCLiYhZlmWUy+UbPDMzg/39fbzOjGAk"
    "2o9p8zGcyndwzh9xzvsDAOB5XpGIstls1rBt+9bN5XIZUkq0Lpt4k45CXJzhaK/cVUrN5nK5"
    "TzoASCmlEELnnCOVSuHk5ATpdBq2baOvrw+maeLq6gq10x84O3J9IkrkcrnjmyJxzmcTiYQW"
    "DoehlIJpmtja2oKu64jH42i1WqjVanCdPU9KOX6NbwKklO1WqwXbtjE0NAQpJSYmJhCPx9Hp"
    "dFCv1+G6rgfg+fLycq33565nkK5UKlzXdWxsbGB4eBixWAxSSjQaDbiu21FKTf6NbzUxn8+H"
    "g8HgsWmaT3zfRyqVQrVaheM4frfbTa+urh7d19pbVc7n82HOeXVsbCymaRoODg58pVRyZWXl"
    "2334TsB1SLvdrhLRAICphzAA/AFWQ3HhJyet6wAAAABJRU5ErkJggg==")
index.append('newspaper')
catalog['newspaper'] = newspaper

#----------------------------------------------------------------------
newspaper_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtpJ"
    "REFUOI2N091Pm3UUwPHv89CXWdY2McCYIQHURAnU1qXCnseEAIuJ8WKR3ZjsbheEBPHKGyFe"
    "esGFl4wL/wZLYkwqmYnYQNby4toMNkpkEmdYVteGlfLYlt9zfo83utTMTM/tOZ+ck5NzDP4j"
    "0ul0xHXdr7XWd6LR6Ofj4+Nua978Hzjluq6tlJoplUpfrK6u+lpr2l6ElVIpEbFt224fHBwM"
    "7u3tDVer1dDY2NjaysqKABgvwq7r2pZlhba2tvA8j4mJCVKplBaRtIhcm56eVs9NkE6nI2dn"
    "Z8siYluWFdrc3KRerxMKhejp6SEWixmFQuGi1jqcTCZ/bPs37Lqu1YojkQivvPE23xSecFwX"
    "nv5WDIiIBIPBZbMVNxqNZaWUZVlWaGNjA8dxCIfDWJZF9pcT7j06Za1Y4eqH1wwRuSQiQ2Yr"
    "FhHLtu1QLpd7hkdGRtjZ2eGj5AUuRAIM975EofgApdQ5pVTABKjX68siMjo6OhrKZrP/6JzL"
    "5dBaUzupcj0RwT0+Yj+fO/M87/Lc3NwPPgCttXZd16eUIh6Pc3h4SCKRIJvN4vf76e3tZf3+"
    "LfK/rnPaOOGkUVXHp5UPgDttAJOTkzeHhoaCnZ2dOI5DNBoln8/j9/vp7+9n7f53PGz+xLvJ"
    "Ya688z4qWAmU/3g40f56W9j8awKnVquRzWbp6OhAa83AwAB9fX00m03W91dIvBlHTCF+8T3E"
    "UFyO2YD38d87SBSLReXz+chkMnR1ddHd3Y3WmkqlQrlWwm+c5+rAJwB8euUrXut6CwPjnAkw"
    "NTVVqtfrLx8cHDwJBoNkMhnK5TJHR0dsb283yk9LzXuPbrPw/Q0AFm7d4MHvd/HwGs/uYHZ2"
    "9lREXt3f339smia7u7vk8/mG1jqmPe/L3N3bBPDx7c4SAcPHeiEDGDef+4XFxcXzjuP8LCLt"
    "wKX5+fkDgOGZ7gUMY8aAsAc1PG9pc+nxZ38C1uOTgWFOwdsAAAAASUVORK5CYII=")
index.append('newspaper_add')
catalog['newspaper_add'] = newspaper_add

#----------------------------------------------------------------------
newspaper_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtpJ"
    "REFUOI2N089LFGEYB/DvzOy6OuoKtfgjjFk7FKLiJpLOHEQ9BF0ivER1FqHs0MmUDh0i+gOk"
    "6BJG19YoaBENdRGc9Qe6pOVKqx5qzU3XzbXZWX3f550uFRuF9Vyf58Pz8PA8Ev4RoVDIyzl/"
    "LoRYKCsru9PR0cHz8/J/4CDn3GCMXU8mk/cmJiZc+TXKUZgxFiQiwzCM4rq6Os/Kysq5vb09"
    "tb29fWpkZIQAQDoKc84NXdfVubk5OI6Dzs5OBINBQUQhIurq6elhf0wQCoW8h4eHw0Rk6Lqu"
    "zs7OwrZtqKqK6upqNDQ0SNFotEoIUdrc3Dyp/A1zzvV87PV6ceLMWbyMbiNtE75+jBUQEXk8"
    "nmE5H+dyuWHGmK7rujozMwPLslBaWgpd12GuZ/Bu8xumYilcvNQlEVETEdXL+ZiIdMMw1Egk"
    "8gu3tLRgaWkJl5srUOEtwDmtCNHYGhhjhYyxAhkAbNseJqK2trY21TTN3zpHIhEIIbCf2cPV"
    "gBc8ncDqYuTQcZzW/v7+cRcACCEE59zFGENjYyM2NjYQCARgmibcbjc0TcPu2BAyk89QsfUR"
    "xxWk4NB5AAsuAGCMtdbX10slJSXIZrPQNA3T09Nwu93w+/1IjQ2hYG0crdduwFNTB/vtaNX7"
    "qdF7Y07Mkn9MYO3v78M0Tfh8PgghUFtbC7/fj4ODA6THnuB0excK1yYhPb0Cdf0F/JpPITi3"
    "fu4gEIvFmMvlQjgcRnl5OSorKyGEQCqVgpL+gsLKGuDmK+DBLtC/DpcVg+JIfhkAuru7k7Zt"
    "H4vH49sejwfhcBg7OztIJBKYn5/PcQVb2ehr4G4VDvokpPskZJLbIMXZ/HUHvb2934jo1Orq"
    "6pYsy1heXsbi4mJOCNFQfMz3+N10mH/OFSGjuJHelRD/JJHjOA//+IXBwcESy7I+EFExgKaB"
    "gYE4AExdPnk7m9rskYWkCdlJCDiPLrwR978DpTKejCAZ6dwAAAAASUVORK5CYII=")
index.append('newspaper_delete')
catalog['newspaper_delete'] = newspaper_delete

#----------------------------------------------------------------------
newspaper_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArpJ"
    "REFUOI2N009PE2EQBvBn20V0aUs0gqiVBowxWBpQ0bJrJIDRozFePHrEePZC4w2NHD3sR/Bo"
    "STjY4F8koi2g2IRIqwiNEokbJFrLssvOO+96wtRo1LnO/DKTyYyCf0Qmk4kIIe5KKWfr6+uv"
    "9/X1iep84D9wWghhENFVy7JujI+Pq9U1wb9hIkozs2EYRl08Hq8tFAony+Wy1tvb+2xsbIwB"
    "QPkbFkIYuq5rMzMz8H0f/f39SKfTkpkzzHxxYGCAfpsgk8lEPM8bYWZD13VtenoajuNA0zRE"
    "o1EkEgkln8/vlVKGu7q6ngb/hIUQejWORCLYd/goRvOr+Oowvi0XtzEz19bWjgSqseu6I0Sk"
    "67quTU1NwbZthMNh6LqO7NJ3vFlZx7PiGs5fuKgw8zFmbg9UY2bWDcPQcrncT5xMJjE3N4eF"
    "tQEo6hUcbw4iX1wEEW0nom0BAHAcZ4SZe3p6erRsNvtL51wuByklXOEhursNo4VLKLye9Hzf"
    "7x4cHHyiAoCUUgohVCJCR0cHSqUS7q0O4cn9YXhSwPsisG/nIbQ1JVFxbTx0bqtUI98BgAoA"
    "RNTd3t6uhEIhbGxsIBaLQVgezsYvg30JlgwJHyvlZSSip7DuOYFXHyfKx4exa2sCu1KphLPZ"
    "LJLJJCzLgis8sC/xYW0BJAWEJBATvm9W0HngNNZpIzBVmlzb2kFnsVgkVVUxMTGBxsZGuMKF"
    "YIE9kWY0RWLYW9+KmuAONIT3Y3b5OSYXJ1dtQtfPSzRNMxQMBpdisViD67q4Y12D43nw5CZc"
    "8vyDDXGlu/UcXn58gUdvH3z2GGc+38L8L6dsmmaIiBZaWlqaFEXB/Py86/t+IpVKvT8ypNgn"
    "mvu1p+8efyIFZ1Zu4O0ff8E0zZBt2wvMXAfgWCqVeg8ALddhsx/UNsGt1k2Utup/AKHUo0If"
    "AhscAAAAAElFTkSuQmCC")
index.append('newspaper_go')
catalog['newspaper_go'] = newspaper_go

#----------------------------------------------------------------------
newspaper_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvVJ"
    "REFUOI2F089LI3cYBvBnkq+OO5mMsztuk5WAFEoRNCAiqzOIqCe9lDbUVsSDFysU7yL0uBeL"
    "x/kD/AMa9xZlkbVhoYmKrWLFKO7WiBM7NG13YoaJfn9ML1VYl23f8/PhfQ7vK+E/JpfLaYyx"
    "H4QQP7e2tn43MjLC7mci/4OzjDGLUvqt67rPNjc3yf1c9EOYUprlnFuWZcW6urrko6Ojp57n"
    "KcPDw6/W19f5bVb6EGaMWaZpKjs7OwjDEKOjo8hms4JznuOcZ+bm5uh7DXK5nHZzc7PKObdM"
    "01S2t7cRBAEURUEqlUI6nZb29vaeCCHifX19P+bzeUHuY8aYaZqmsrW1hSAIoGkannzag5Wf"
    "Kvj4IxWMMVUIMaDrugrgbeQWNxqNVUrpHfZ9H/F4HKZpovCmhsNKHa9Kf+KzzzMS57yXc94N"
    "AJFbzDk3LctSisXiHe7v78fBwQG+7ksgoTXjaccD7JVeg1LaQiltBoBIEASrnPOhoaEhpVAo"
    "vLO5WCxCCIGrmoepHg3sbwfHvxRvwjAcWFxcfAkA0YmJiWnG2CepVEoyDANBEIBzjo2NDUiS"
    "hOPjY8RiMVxWHPy6Wwjb29uJ53lfdXZ2Cl3X9wmldKC7u1tSVRW1Wg2lUgmEEMzMzMD3fVxc"
    "XODfZmJ6epoRQpovLy8f7u7ufl8ulx8TIYR/dXUVLxQK4JyjWq1iYmoKtm1jf38fyWQS6XQa"
    "nudFlpeXmx3H4ZqmvZifnx8vl8vfRIIg6CmVSpQQgrW1NaiqCgDIZDJoNBqYnJzE4OAgxsfH"
    "MTY2hnq9HtTr9S8BQNd1mczOzrq2bT86PT19YxjG40qlAgBYWVkB5xxLS0uIxWIAAN/3EY1G"
    "5aampucA4DhO4+6UbdtWXdf97ezsrK23txfJZDKUZVlyXRcnJyeQZRkdHR1IJBJgjP11fn4e"
    "yefzv7/zCwsLC62EkNeHh4cPDcO4bmlpkcIwjFSr1VlJkpy2trbnAJqur695pVL5w/f9L/4B"
    "Yy2f9YyeXIoAAAAASUVORK5CYII=")
index.append('newspaper_link')
catalog['newspaper_link'] = newspaper_link

#----------------------------------------------------------------------
note = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYpJ"
    "REFUOI2lk72KVEEQhb++48+KGogiZoKxoBgY+gBmBoJiYOAr+BJGPoOJIGYKRkYKgpFgYLIa"
    "GCy46rLDjk53366qY3BnxxlnIqeC7qbhfOd0U5VSN2KT6jZSA0cOD/7lpWzyE6lH1pA3ZD2y"
    "irxCK7gVZBla4cztp2kJIDeOXr6z4iBBgtkCCPaf311NUMc7nJBQ5OEigRRAQvwlpO44ankV"
    "IDOi/4ZN3kNUpH7Yo4coKAqKzLFzt4g2XQPwChiKAmoz0aK4oJiCDPVrEtivvSHyknMmoswg"
    "GSIPJvZ7FRBeKNtvsfoZvAcZXg7Yunh+cI6CPINi/R943sMOdjh19R4QRP+VyYdnyKegKfIy"
    "JJDhC4B5IyWJ9v0j+68f4tNt8EaoLYiHFCFfSjAHSHD6+n3a+AfjN49n4jIXKwpSBXxopn+f"
    "gBXSqOPktQfkT6+YvHvB6OwVti7cIBDIAQMCWZ17p8Nh2n1yU9EqsoJaxvIu0NGlhKxAX4ko"
    "Q2ubc+nRKC0B/rc2nsY/cboweYwVQacAAAAASUVORK5CYII=")
index.append('note')
catalog['note'] = note

#----------------------------------------------------------------------
note_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhZJ"
    "REFUOI3Fkk9IlEEYh5/ZbXVLRYOQ9dAfKqGg1IokpVMidIoiiLoU0s3o1CEhgg4e7BB18tCl"
    "Q10iuhRFdglMFqqDqESEiVhoS2qru/XN7PfNzNth3WVlJbr1XmZgeJ/nx/sO/O9SpYuffSk2"
    "v4RIiNgIcRFiQ8QWEFeAyOCsQayGyNB09qEC2FQCiLMkDpyvMoisWUoqgeyTC+X3MqCwMs9m"
    "EcTrcjYRDyikIqyK1SKRrgaItfgwg82/A19AJCyePgRvEG8Qr6nZdgYfBRsAXAGwiDcg0VpT"
    "ZbNBfABikXCDBPbXcjHyOrPGe7MG0eB1UWJ/VwO8M5jpt9jCF3AhiMWZHMmdzUWzN4jTIH7d"
    "DMprXHx6URLNrdR3nAY8PpwjP/6Y2h1bQQLezBhG5zyrWhMGWb7nszdHbk8NxkuA6+fabrlg"
    "HjP7nJrULpR4TGaSRKNi5HOeCb2FriNd9Bw9ia75yVLw9UTd3nhDrHLfDZ2XiFYWWRm9i5cI"
    "xCDO8OJTlo597biYo72lF6cijh3sBuRKGYA1qHiMusOXEdtEPv2MeLKdZKqPH7llEqqeU/uv"
    "AnCt5z57mttQqGTFPzBkX91DrEEiTainYCZN8OERuVzIx4U0EwtjDPQ+YOh1H8l4LYKY8hD/"
    "Vp39LYPbdzfe6G47TmvqENOZcdKTY3ybXb3zT4AiJDWEUv0KGgTyiAy/H84M/AGMFzyJhh4p"
    "VAAAAABJRU5ErkJggg==")
index.append('note_add')
catalog['note_add'] = note_add

#----------------------------------------------------------------------
note_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgFJ"
    "REFUOI3Fkj1IlVEch5/zXtObWgRJ6CAqtBX0MTg0RENDBQ1SkBLUENFcS0IQDhFtjc3hVA5B"
    "kIRdKDSCJsHBxLQvvOInijffc973Pef/b7jXN0OJts5yDhx+z/M7H/C/h9layNdh9ZUVVFPU"
    "Z2jIUJ+iPkFDApkjeId6C5njwKVBA1C3BdDg2XO0d4dBtWbZUimsDfXl+zkgWS+zVxUVm3dT"
    "FcCg28qaqAHN7E6Aeo+kC/jKR5AE1bQ6SwriUHGoWOpbepAs3gUQEsCj4kCzWmh72KESg3o0"
    "3aWB/7larfyH2SLiahALYqsSv7kTIMHhPo/hkxkIKagnuA2KHYeqZnFosKCy+x0Eu4rfKNN8"
    "/CogSPqdyvgzNMSgMYujMyyOThHPPydqNLw+G/WfK8mjHGBUyZYmWCu9Z/+pmxhjEM3y8OZ0"
    "xoneuzR0HcFOjDA5NvLgjU5tRtvfe1/3dbL1ZdZHH9fCDg2OudI4h89cpjj7DvO0j8YvL+js"
    "aCkE9HbeAO8whYimkzewk8NUPrykcPAYxdbTZCtDFFu74MKd32cfaKOgpjP/ykuDF1WyBPUO"
    "zSzeLgIRkTFMv52ju+caTT9ekdgFYqCyUeDTLOUc8LcxdqVtoL656V57S6iri+aoLHu+LRRC"
    "6uT+PwGqkPb+eHX+ViSmQyItC/rkfEke/gLMgkY1wcUB8wAAAABJRU5ErkJggg==")
index.append('note_delete')
catalog['note_delete'] = note_delete

#----------------------------------------------------------------------
note_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm1J"
    "REFUOI2lk0tsTGEUx393nlVTM1QmlXiGhAalEo+IHQlBJCISQmJhZWFBusJKYsGGxMICKxuP"
    "DRshROKZiIm3FC3V6ox2pvMwr/vde7/7HQstOu3O2Zzk5P//nX9yvg/+sywA03dbdGUEERfR"
    "HuJ7iHYR7SC+A57C1wrRNniKxK4r1hggBCC+JrxszwS6yOiGMblA8cbecZoQgFNKM0UEMfaf"
    "XCIGsJC/QbECUcSzJwJEa4w7hK48B+Mg4v7uxgWjEKMQYxOZuRPj1ScB+A6gEaNAvFHTv2aF"
    "mDp2NkU+2kbPrVNSG3kIKn0gBKCr+d+Rx222MUaNQmzcch/Oz2balu8nvqCTUt9iuu9eOhMC"
    "ML5C9TxGO73guyAaX5VpmpdETB23PABNncxIrqbwpZuI5dIyrY1Y69x4CMC38+hymtjKfYDB"
    "uP1UXl1D/DpebRCiHcQXbMb5cZVIs0X/64+4tpNXTnV9AMASwcu+pXi/C7/eA76HEQ+n8h0J"
    "tRNfuA2VuYgVLhKOtdBU6x02teFNaw/f/BwYu3fLmgN4pRylR2cx4lHIZ3DNEuKLdqDSFwiE"
    "PdzyfLIPnqLq9e2dR+69BggAoBVWMMDUVQcRnWDgzmVMYi3Jpdtwhy4RjAhOeR65JynCuee0"
    "H32RangHiuKdc4hWDGQLxFbtQEuSH+/OMz0ZQRXmUHj0mFD+JcZVE//Cv3X99EbZfegyn652"
    "kfn2jOjcFXjZXCYRZPPK46n3jfpg46Bj/pQT62bHA9NnzaEwOML3D93VYDi4ccPJN+8atZMC"
    "Wpu9Y/1fP6CreeNE/ScBzJatp99/nMwM8AvLamgSjrLbyAAAAABJRU5ErkJggg==")
index.append('note_edit')
catalog['note_edit'] = note_edit

#----------------------------------------------------------------------
note_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj9J"
    "REFUOI2lkj1oU1EUx38vabVpG4201Yrix2JIqaIWFARBQRAXsXapFnFwdBLdnMTJSQUHFSdF"
    "QdSlgzg4+QX9RCoiWqUFrdRoTdIk7928d+85Dm1Na7p54HK5cP6/+7uXA/9ZHoBMPFVb/IVq"
    "iNoIdRFqQ9RWUFeByOCsQW0AkSHVc89bANQBqLPUd/bW0FXnb1hoV8g9OrGkpw6gkp8ioYpK"
    "8NdLVQAPrYrixVaiUVALUGuRcBpbHACpoBrO7RKCGFQMKgErWruRyF8G4CqARcWARvOhxWGD"
    "ig9q0XCpQQzAlmbmlDVcFA4QCVAJMOUCuekCLiqitlxrIM5gxl9iK5/BhaAWZ2Zp2LwWsWVK"
    "M0WaNx6jMDVa8wcxABfMYGenaM700dx5msb0IZAIdT7lXIHG9iOsWr+L/Nd3hLFYLcBTJcqO"
    "kXt+AeePg4sQjbCmRCHrk2xN4Wb7aes4hd/UwvCtrvolAFVI7jlNlP9J/sVVRCNQQ356lpb0"
    "STCjDN69T3MqIIg14ZE8ugSANXjxGE27z6A2RfFNPxFb0HiG5BofqUyACq40xNYD53FhePnV"
    "lX3JqoE15J5dwx94iPzOEnx5zczkKKlNOxF/DJWArp40En6noeET63b0ZsCcq47YPzV8c//Z"
    "to7uG+3bErjSIKohI08+0NWTwYuvhsRhhu5czHpWDi4LGLi+99v2vgcb4rFJ1OZgfqAXXh1P"
    "pPnx/i0f+y89rlsOEFXChpHbxwMVRUXmlirVs4IIiLb/AWOzZ4pvTpAaAAAAAElFTkSuQmCC")
index.append('note_error')
catalog['note_error'] = note_error

#----------------------------------------------------------------------
note_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiJJ"
    "REFUOI2lkk9IlEEYxn+frluhacVSBpb9oYNZIB4yirqEnYsuRQcP0TGqa0iSXroZdOgcnaJb"
    "B4nyUqkQiIGBFBrhiqWZrbq633wz78zbYXcrWz31XAZe3uf3PMwM/KcigPBlQCX/A1WLikO9"
    "Q8WikqA+AWfwYlCJwRl2XHoSlQEpAPVCzbHLFXTVUkJ5XSH37Mq6nRRAsjTLNlU0xL97qQYg"
    "Qv8UJaragrq4EqAiBDuH5N9BSFC1xTNYCAYNBg0x6cxFgitsAPAJIGgwoK5k+tts0FAAFdRu"
    "0EBWF4uV1yXHhGBKkBhCXAyRtUpA8AYz+RZJpsBbUMGbFbY27y4mB0Pv2AQ5c5u+je7Ax4vI"
    "yix1bVeBQLDT5N8/RX0BtIB6gxFLU6aFm8lYJSBSxX0fJzc4RP2p60RRRO98FuY+Y4NgRdi7"
    "8wgtjR3kzRqd/Tn36tZ8mghNld97e0cXPwfvsvSmn4azN5Bg6WztwmvAB09A+bo8w/Gm06za"
    "OJW7/9qOapJOASCGqLqK2vZrxBMD5EeeY8TiNTC9OIkLggSH846VJE/bvjOsukJqqWfIlP6B"
    "IffiASoGdTE2/oBpqEW8sKd+PxI8XgPflrPsqmtkbGaY4amhj26N9ohNdOHRQW+sxQZLIpbD"
    "mdaqk4fOM5odYfDTy/H0MiemHpJs5q9Qa1+00PX4nDbfYfRoD+nyfNMG/+pANwtBqzPZlK/h"
    "HlKe/wJanGlieFq9AQAAAABJRU5ErkJggg==")
index.append('note_go')
catalog['note_go'] = note_go

#----------------------------------------------------------------------
overlays = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl5J"
    "REFUOI2lk19Ik1EYh5+ztlnzz8pIZWGmpmYiFhYh6oVEf6ioIL0LI4jugroIvCgIQqgIL4wo"
    "0OhWukrJCwmL0mVgE01yNjQzU9emc87U79v8zulic3qRQfS7PZznfc77vgf+MwKgttF1XUAW"
    "QlQApSipQAikwmQSmARIKTFWVNBqZqQgM+UgUnGjulAAcLHR1aT+MfeeDykAM4ASVAI8dQbi"
    "auov2pfLU3GPB/U4AIOM1cO8tITo28SfL3/5qQOgaWHrmoFSttWqHp++YeU0vYtKbwsjs8XU"
    "Od6KukdFtVEDKc2rahtlabqN0HAPW4ovYM8+QHCsAHdH8/2YQXQaNbc70aREKmi/c5Sxqfno"
    "c4KvsDNEal45gVE3VhEmOSWDpO277FGAlADMLEc4st9Bu2syXjkx3ItFfcKecxx9ugWrTTDe"
    "P0xoUUBkpsQUBUR7vqAZRJRiSV8BQM07sfx6jT33JNpUE8IyhyUpmUQV4Nn3Mg5ffeExAYiY"
    "ga5HWI4YGFoEr7sN2+I77HvOoE0+xmSJEA7txtc1wI5j9Xg1OwBRg3VTVwqKbf0EfzhJKzpF"
    "2NvMJqtCD2Xh7+5DVDWwOb0QpVbWADJixAkTPS3cOmEQNhxMDz5EorEY2InvgxtR1YBITCfW"
    "NxUHGFJ+Axh8co7zuX3sq7hCwkQ3nlYn/R0BPG8GyDz7gJz8vWQ77DGAmosvEoZqrbnZmS9R"
    "Zft9vm3hzy/JLqlk3j/LqMtDZ/I1/PUfUaoXkArUghImN8R+4/pUV2xdLs1NNx8qzEFZ9Pe6"
    "33/p9N3Brxst2G+vDT2RcV/4pwAAAABJRU5ErkJggg==")
index.append('overlays')
catalog['overlays'] = overlays

#----------------------------------------------------------------------
package = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAu5J"
    "REFUOI11k01oXGUYhZ97Z+7MnWmGTKaYlIRGwaZtHLRWV1YK3VhBVKo1EqVQQXRhQReiiISu"
    "zEKRIlgEBXEpLlxIISi2EIpaA1Or0DYlndok03Qmk4lp5+f+f+/rQiyo8SwPh2dzzrH4H136"
    "5qmyjXkPpSCxvFWe+PbCZjnr30b1u2cGkyh5XdUc23rvs0Xjt/hj8UxXjHyaNtaJ8RdP39wU"
    "UKm86hRWGy+pmrcLI4/vGBp/DlsM3XoFJ5uiWZ3lVq2yJKof+m78+b7nf/bvABZmDh0UNVPu"
    "wN79Q7sP4w6MgUYkG1e5PjvN9vsexc7fTdhbY7V6nk5zfk41nn74lcop68rM018gevSusUnL"
    "Ld1P0Glxe20eE3WJe3WyVsi20V0QbJDqG8V2C7TrC6xWz9PbWPoyjdEjOx87acWdFt36LBK1"
    "yXpreO067doKD01+jJPbAr1FtFfFai+wdfgB+kvwy8y1ibSo9BSrP+NmKZRG8dcukx8oUhzI"
    "kcODYBlMBoIV8Gt4jTm6iz/h3nMYMdJLqwgIYGVw+sdwsgWCZgXpNnFSYHnXwFaixmk67Vsk"
    "uSJksmicoCKk1QgKgAENIb0Fd3AvSSaHG6wjje+5HXdI3D5MtoB4ESSKRAlqBBtj/upRDUgM"
    "4oGGpPtGKGzbiedAlHVJwgQTRBgvIPZCJI7RRLDFmJztOJDKgQYgIUgAxgd3mERBQ4N4EUk3"
    "JO4GOP1lbAXEuDaiZ38/+xH+xjJkhyGVBxOBxoCgsWCCiMSLSGVG6d81gZgc1co5VHQudWwy"
    "/5XfatZaV8+MR36nVBjajZ0bBOlA4tFpXkQil77tT2I5JW5cvEDj+uxSEq4fzxv/zTtT/vWT"
    "RwZjK3pDRV8b2XOoOPzgExAHtGvn0ESpX77E+vKPXRX5LEV0Yt/UjZVNzzR3ck9ZY31XRV7Y"
    "ceBly28ucnP+N2K/9rUx1vSB49V/vPI/gL/1wwflg5aYd1RNRo2+v3+qemqz3J+H2Z+jsNHT"
    "3AAAAABJRU5ErkJggg==")
index.append('package')
catalog['package'] = package

#----------------------------------------------------------------------
package_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxZJ"
    "REFUOI11k19sU3UcxT/3trf3drRZt8UxN50mUMZc2Jj6oEMMiQ4T0QVFDBoTNUYeMOoD0SzE"
    "R0nUqDGBLFFDSHzhUYnJAgi6MP44UsQQgTmKbGtGu3aj9P9t7/39vj4YeRA8jycnn5dzjsH/"
    "6NLh5/tM1McIUe3pD/q2H7lwt5zxXyN59IV2v+G/J6LeaVv1YkzVlrg5e6Kslf46qIwve189"
    "fuOugERipxVdzLwhoj6Mdj2zemXvS5haUU4nsOwA2eQEt1KJOS3yec3xDgy9/GvtNmBmfOtm"
    "Leojp2Vw48q123Ba4iAN/PxVrk/s5f6HNmA2PUC9kmMxeZ5S9sqUiLf3kbcTPxrT4yMH0fL6"
    "PfEdhtO6Dre0RCF3BdUo41XS2Eadju4ecPMEIt2YTpRieobF5Hkq+blDQZS8tmZ4v+GVliin"
    "J9CNInY1R7WYppha4OEd+7DCK6Ayi1SSGMUZ2jr7aW6F38avbQ9q0RXBaA45NtHWbmq5yzS1"
    "xIi1hAlTBXceVAjcBailqGamKM+ewXlwG1rpSlC0Bg0YIazmOJYdxc0m0OUsVgCM6jUwhUbm"
    "OKXiLfxwDEI24vmI1gRFaQQABVKH4Aqc9kH8UBjHXUZnfqLglfCdCMqOoqsN8AXd8BGlCaLU"
    "Pz2KAu2BroLUCUa6iHasoXAzgWc6TC7YnF0KU3RdGm6BjfmL9PiaoFYqbFoWEAZ/GXQdtAuq"
    "Dk4nvsDP8yH+tNrY9OSj3Nca55dLP3Dsj0mmC27ERMvJv05+RS0/D3YnBJpANUA8QCOe5ui8"
    "x/q1AyhTMXDvMMrweGzdEKfLnmGaVnZLaX5y5/SRPcm5c9+hCEG0B6wwCKi6R660jGVEGOl9"
    "F4DdT33DqvZ+FJi3p/z72OPtntF4X7Ts6hrYGutc/yx4LsXUWUYO7OO5LU/joxkdPsgnx97E"
    "Cdgc+v6we8eZpvYP9Ikne0TrV1ZvesuoZWf59vQJLsd8hvqfIN4xyNXMBc5cPEXqeuGLOwD/"
    "6tRnfZsNrUZFVEiUfLr7RnkDhrHLgKhACZGxc2OZ0b8Be7COHkNjkrEAAAAASUVORK5CYII=")
index.append('package_add')
catalog['package_add'] = package_add

#----------------------------------------------------------------------
package_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxFJ"
    "REFUOI11k19oW3UcxT/35ia5aRv7D7vaarexdnMGN+fwYYqwB52somzOyiaDCaKCgoLgUBER"
    "cYoiIjgUH0R88lFELOqqlG1Mi9kUxXXUdGaNXdKk6Z/8vbn3/r5fH4Z9cPM8Hg6fl3OOxf/o"
    "jy8fSNmYN1CSEsgLqbFvfrlWzvqvkfl2f1/oh8+qmmd6Nz3UZZqLLGW/r4mRjx1jvbf10YnL"
    "1wSk009GkwuFx1TN0eTgfcPrtj6MLYZaPk00HqGYmWQll74kqu823eCTOx/5qbkGmBnft0fU"
    "vOJ277h73c0HcLtHQH3C5T/5a/IYN91yF3bbelr1EguZs1SL01OqwbGdT6S/si6MP/gpokeu"
    "HzlouT234lUXWS1NY/waQT1P3GrRP7QFvGUiHUPYbpJKfoaFzFnqy5c+dzB6ePO9x62gukgt"
    "P4n4FeKNEo1KnkpuntsPfkA00Q71LFrPYFVm6B3YRmcPnBufHXNEpa5YnTE3TrJniGbpPG3d"
    "XXR1J0jQAG8OTAy8eWjmaBSmqGXP4G44gBipOyoCAlgxop0jRONJvGIaqRWJRsBqzIKt+IUJ"
    "qpUVwkQXxOJoEKIiOGoEBcCAtsBpx+3bQRhL4HplpHCC1aBK6HZg4kmk4UOoiB+iRnAw5kqP"
    "akACkAZoC6djkGT/ZlaX0gS2S3mqRPnnObyFFezrYvTt4gpAjEnY0SiQgLAM0gLxwLTAHSBU"
    "WJoq4xdcdh5+ifjGFM3fvuP86QnCYKXdRvTkxZPv01yeg/gARNrA+KABIGgg5M/MMLJ7DHd2"
    "EuuzQ7Rd/IINQz20ciuhY0eL91fnTh25kD15tGfTPcM3bhslktwCjQx4dUwrwCz7uP0bYfT5"
    "tQk7r92A7Ul8bcq/frirL7D851T06cHt+7oGbhuFwKOS+5Fzr7/FHXv30z73Na1mgQZQrUSY"
    "nmX+qjNNHd+e0kBfVpFDw7sft5rFLLkTPxCpeDrUG1qO/TfVUki2EDG+J69eBfhXp99J7bHE"
    "vKhqYmr0bX5vpRrly0/ZYq0XW+cF/WjvhLz5D8tjmZW7WD5LAAAAAElFTkSuQmCC")
index.append('package_delete')
catalog['package_delete'] = package_delete

#----------------------------------------------------------------------
package_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxtJ"
    "REFUOI11k1to1nUcxj//d+//PWy+bu/ObnOT5dS5zFYXlSZ4kSsIY2aGRWERepGUN52QbqQM"
    "OhCBEnTRgQi6KIgIhmHCcGluvLOEcjrf6Q64w7vp3Hv8n37fbxehF7Wey4eHz83zPBb/o79+"
    "3NkVwryLkhBfXu/ac+L35XLWv430z7vqAy94VdUcrLnrySpTWuDm+Km8GPksbKyPO5/9ZXpZ"
    "QCp1wE7Mzb6gat5IND+6tqHzKUJiyM+ksKNlZNL93JpKTYjqR6WY//mWp8+V7gBG+3p7RM3b"
    "sWT3toYNu4klO0A9gsUrXOs/yuqNWwmVt+EW5plLD5PLjAyq+kfv35/6ybrU98SXiO6r69hr"
    "xao34eQWWJofwXh5/MIMUculsXU9OIuUrWglFEuQnRllLj1MYXHi2zBGn1u347jl5xbIz/Qj"
    "XpZocZ5idobs1HXu23sMO14BhXG0kMbKjlLTdA+V1XC+b2xPWFQKilUZiUVJVLdSmr9IebKK"
    "qmScOEVwJsFEwLkOpSmKs4Pkx88SW7MbMVIIqwgIYEWwKzuwowmcTArJZ7DLwCqOQUh5c+h7"
    "Fl2Xd9Y0QCSK+gEqQkiNoAAYUBfCFcTqu4lUdxJLlCOzJ1ma+AEn8Gmp7eTQ5XGk6CBegBoh"
    "jDH/9KgGxAcpgrq8NvQdqI8nPl4QsCq5js7GB8g5BV68Osg3tQ+jgRAWY+Ih2wbiENwAcUEc"
    "AvHY0bUPo4IRg6BML02xqWUrea/EzoH3+FCaYmFET189/ckjTRseI55sAZ0G7yZO4GFUmLhx"
    "BV8CAvHxjU/WzXHv6m3k/SL7r52JhEJ25vHc5MCBSycOpyeGvsYQgcR6nMAhMAENK1tpXNnG"
    "qsp27LI4dYlmzk+d4cLYb3O97oq6O1P+49OH6n3LO6SiLzdv7q165c+vcDwPTzycwKO9ZiMP"
    "tveQmjxL/+jJkdAt7U4fw/3PmQaPb+5SXw+ryDNrt79klTLjTI9c4GB+wL27bXu0//Kp4Qqb"
    "LReP4C37xtv69YOuHkvMW6omokbff95JfyFaVjsZNjZHCG7n/gZ50qMOfGm6ZwAAAABJRU5E"
    "rkJggg==")
index.append('package_go')
catalog['package_go'] = package_go

#----------------------------------------------------------------------
package_green = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAyBJ"
    "REFUOI11k11oW2UAhp9zcpKcdEmbtms72m4O15b+4OrwysncRJ0ycMz9uYkwQRRU0CuLSBEE"
    "e6HobhyCg+GlIOxCJlVxw4pzrJJ1m1varku1bZqlSdrm/+TknPN9n1cO1Ppevrw8V++j8T+J"
    "f/PckI74EEVEuvKdoWPfX99op/27SPzwfLvneG8pJd5s3XE4KmqrrC9cqkghvzCEdnrgxYv3"
    "NgTEYq/5I5mVl5USI5GuZ3o6Bo6iS0ElHcMf9JFNTFBIxhalUp/UTPfc7uNXa/cBc+OH9ksl"
    "Rs3mXXs6+o9gNveCcvDyd/lzYoytg4+hNzxAvZojk7hGOTszqZQ79sirsQva7PjBL5HqVFvv"
    "Cc1seQi7vEoxN4NwKrjVNKbu0LG1D+w8vvA2dDNCKT1HJnGNan7xKwOhXup7+ozmlleppCeQ"
    "TomglcMqpSklU/Sc+Ax/aBNUF1DVBFppjtbOnTS1wNT4/DFDKllVaE0BM0ikZRu13DQNzVGi"
    "zSFCWGAvgQiAnYJaEmtlksrCFcztR5BCVg0lpOnKOkH8+Jt68Qcj2NkYspLF7wPNmgdd4axc"
    "pFwq4IWiKB8gQQnZYCCkL1H8DkOu0xt+Ft3YhNm+Cy8QwrTXkCs/UnTLeGYYEYwgLZd12yKl"
    "bJDSr0spvMZAO3eLP3Mp/QGp6mVQdYxwF5EtfVh+cIImXt2jbNn8Us/yrVEgrwmkJ5WhhNC7"
    "G/fSEejnp+URfiucp83fwXDoccJmJ56Cuu0xVS5yS1QQGjzR+CSDRcmsFI7v9cPb91bWlh8M"
    "R7rp33KSNt9m4uUJ5u04nsrzRybDeCHDorQZCA9yfPNBGouSpfh1PHv1inb768GAW42eUlKN"
    "tOx4qqd75wF0w+D33FlmK1PcvpOnLdDKC11H8Vl1UtM3Ka3dWETxaYNnnbt/5RufP9ruas7b"
    "Sqo3uoYPRTsfPoDrFMgmY4SFTno6ztrSrxUl5Vkfzundo8upDWWaPDM8pFz1npLyZM++V7Ra"
    "doF7Mzdxa8nzQmhj+95P/MPK/wD+zuWPh/ZrUryrlAgooT7aM5q4sNHuL/c8nVtP1fsiAAAA"
    "AElFTkSuQmCC")
index.append('package_green')
catalog['package_green'] = package_green

#----------------------------------------------------------------------
package_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA0RJ"
    "REFUOI11k11oW2UAhp+T5OQkS0PStFu7lrXFrtO2mzK9mtYWlLkWdXO/FB04BQciDG/0Qrx0"
    "FwVRRBFlyhAvJsw5h1o27LRVJ52kVTfsSpr+LG2TJv1Lk5z8nHO+7/NCEBzzvXx5eW5eHo3/"
    "yV+Xnu50Id5CEZS2fK3z6OXf77bT7iziVw5ucSznlFLilZrWQ2FRWmFt7mpBCvmxR2jvtD87"
    "lLwrIBo9qQfTSyeUEq8HG/dtr2s/gksKCqkouuEmEx8mOx+9LZV6u+SzP3342GjpX0Bs8Jkn"
    "pBJv+qp3P1p332F81W2gLJz1KWaHT7Ot4xFcm5qpmMuk42PkM7euK2Wffuil6Dfa5OD+s0j1"
    "/Oa2fs0X2UU5v8LG8i2EVcA2Uxhahfqme6G8jruqCZcvSC4VIx0fw1y/fc6DUMd37P1As/Mr"
    "FFLDSCuHUVymmEuRm1/kwf730f0BMOdQZhwtF6Om4X5CERgfnD7qkUqaCi3k9RkEI02UlifY"
    "VB0mXO3HTxHKCRBeKC9CaZ7i0nUKc7/iazmMFNL0KClBApoXPdSGbgQpZ6LIQgbdDVpxGlwK"
    "a2mIfC6L4w+D10DZDkpKPEpIFAACVAU8AXxbduN4/fjKq8il79mw8zi+KoQRRBYtcBTSclBC"
    "4kGIf35UAqRNuZjll99i3JguUh3pZSU1yd6dEwQrNl+NP0BtQwer6QRtmSwhS2keKYTfpeuA"
    "H7uc4dzX18g7tTx3/ASmabKw0MqPo24M8hw48gIe3UcqlWJsbIxsIhJwv3yopaewunCPv2oz"
    "ozfSRG8m6d1/gAufv8uZs18wMzPL1sZWkisWQ1d/4Mvz5ylnJul6/CluzmxIl0vPPJlP/Hxy"
    "8vIb8Z+uXCAQqALg1Rf3YFsl+vv76erqoq+vj97eXiqlAt3hawmAYKjG8ew8NmEBZ/74cM+l"
    "tdTUZ6IU3gdoA5+MI4TGwMAAgUAAANM0cSTyoz87Zk89RtPi4mL5PzJ1dna279je8l13d3fj"
    "tsZ6r8sbJJ1OE4vFMAyD5uZm6urqcBxnLZFIuEZGRpbutNHd09OzKxAIXGxs2FpvGLpX01xa"
    "yJ56byob+ba2tvYioFcqFZFMJpdN0zz4N2f6lU+8WE5JAAAAAElFTkSuQmCC")
index.append('package_link')
catalog['package_link'] = package_link

#----------------------------------------------------------------------
page = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiJJ"
    "REFUOI1dk72PTkEUxn/nzL3vfliWJWIrIYsQDRsRhURD2GgUNBqNUiVUCo1S5Q+QKLbRi0bh"
    "IxGJkCgUQkJis2GxhNjde++cR3Hv++7aSSaZOZN5PuY5YwAnbzy+NDQ+dDEZ0xLDZhgABshA"
    "QR3x4de3eLT4cf7a2/sXKrphAGduPXt678r0fjc2Y5YQgyEBiIU/NbMvfzL/afnv53fvJx7e"
    "mVkBKAA82b5e8s1vFyy5GbSkZAVNI5bqzIk9Gzm6t+BFLIxKU4unrzzY8vDOzIp3RGNA6iWn"
    "dCgMkkMyMAPHgGByU4+zRybZNTU8Uo0N3wVoAcysv3EDN/t/JmP+xxI7x2oOTBiXj20lFcX5"
    "gYW+1yKBYciMyAI3igQ9Oe+/iyoaIiqO7x7CSm8GABIIKMwRQoB5G4UClBx64GFEJISDteJb"
    "ACBo/RqGupoCytTPy7FsyEUM0ukAomkL0Y++O3UHwiiSun4AYeSAHGsBQu0l0RnoP0y/WQwT"
    "FN6SDJfQ1FoFyAFZreRYdzvUnqtby6BMTlM1axTUIiRuvq4wRBhIBgEyDVLqg8/uKKmrvApQ"
    "N5mcYXJTyeHt3rIKsnWs/aQEb742KES9vEZBriLqnFVl7PlcJkyo+08hWlUCueFhpETkJlb7"
    "oFrKXzYMpW3XD65sAJw1csdHioGFkbLtjDL576bR3ADAybdPXX1yzt0PBTG6PgWtLhAsK/Sq"
    "dM0C/APyiBZGztqynwAAAABJRU5ErkJggg==")
index.append('page')
catalog['page'] = page

#----------------------------------------------------------------------
page_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoBJ"
    "REFUOI1dk1uIzVEUxn9r730uzLgNqVNK5BK55H6JIo0YXhRevBBKTZ5EHjx4UR68CeVFIYUX"
    "jOQaMu7KZS5FIxQzaTBEczn/s9fy8D/nuKzaD3vt1re+b31rC0D9vrubc8Nym7wwx4y8CAKA"
    "ACZgSqL69scXvdXzvmt3+/mNRcohAKsPNN87uXPOFCcMR8RjVMMMwOj+lXDm2Xe6PvT3fnzT"
    "UXf1cMMAQABwXiZnvRve3i3eiUDalGhKqWT0JZFlE4ewYFLgsXYPNpvQs2rnlRFXDzcMuHKj"
    "WsBnvSPjIAh4B15ABBwCKIWhWdbOKzBuQn5QsTZ/AiAFEJHKxQk4kX+PF7q+9TG2NmFqnbB9"
    "0Uh8CBuqEipagwdBMBE0GjgheMiao+OrUdQSqkWWjs8hGVeqApiBAUEchmGAuNQKUzDvIAtO"
    "BVWP4UBS8ikAoKR6BcHKOVPI+IpfDomCOUOr7pQBtJQmtGJ9+dU5QIXgrbwPYAhRIerfAGpp"
    "kVEWUBlMZVmEltcXae1o4mdvD0kpwQ3MDFWAqBAtpaz/VavBk9ZzdP68wfIl8xhTN5HbbRfo"
    "bb0c5jcWDqUMEkPN2P+8iGCogJmAgolR03aa9WtWEl1kZqGem+3nWTh9Me86LjYGgKQUiREK"
    "QzPMHu1QSxlFSRlcedRFRmpZPWUrALtWHKep5SjCpXwqoaiaxGjFiDz8FFExrPyf1ODbrx+0"
    "dT7gZWcze+tPcPD6FvI+h2H9AaDYFz/X5PyoPdMGagCH/ZnFsEGBU9+3cf/VSRbPWEJTy1Gy"
    "Emh+cReQIwIwd8e1xqTEOufcLEUH/++CYQR3NmTCnQD9GNloOu7602N3Gn4DjqUkm1dALZ4A"
    "AAAASUVORK5CYII=")
index.append('page_add')
catalog['page_add'] = page_add

#----------------------------------------------------------------------
page_attach = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr9J"
    "REFUOI1dk09oVFcUxn/n3jdvRp1otFLJIqQt1n8IojFoEakFq9amomhF2ggBERfVleiqC7sQ"
    "BCmIWhQp1HaRjeDCReqirfinjikhKoJ/atqatiEJUaNEmsm8d8/p4s1MaA/cxT2X7zvfd797"
    "BeD9z6925mflP/VCqxkFEQQAAUzAlET1t5dP9cexJ0OH7l/YWaFaAvDB0RvXvzvQutgJjYh4"
    "jHqZARijrxK6el8wNFD+5+9f++dcPrV5EiACcF4Wxt413h8V70QgG0owJU2NiSSw7u0GVi2I"
    "6NHR6WbzxzYd6J59+dTmSVcdVAR87B05B5GAd+AFRMAhgNI0M6a9rYk35xemVYqFbwAyAhGp"
    "bZyAE/nv8sLQ8wlaiglL5gh733kNH0Uf1y3UvEYeBMFE0GDghMhDbI7+Z0ZFU1QrrH0rj+Rc"
    "WicwAwMicRiGAeKyKEzBvIMYnAqqHsOBZOIzAkDJ/AqCVXumkPO1vBwSBHOG1tOpEmiaNbQW"
    "ffXUOUCFyBuYMDLwiAvnjlEsFmlOkkJHR8dHDkDVMpBNgalJI1M1MvCY65fO07Z6LcdPnKa/"
    "aU85juNvI4CgECyTrP9Dq8Ffvz/kh4tfs3jFGpa9u5V9ezoJsiAaHhuOMwuJoWYcuV1BMFTA"
    "TEBh1rO7NNzpIm1ZTXdjOyd3b2X/J1vouVWK/iyX34gAkjQQAjTNzLHidYdapujFoxL3rpzl"
    "j8I8NmzcRe9nG1n/4Q5+6SlxN7ejfPun9kEHECqqSQhWCVAaDJSGUnqGA4+/P0/feBGePuGL"
    "9c2s3NLJywc3OfnVGU01mnoHlYkwMiPv5x5eOjkDcFQT2d7bx5WrN3k1Ps6tn6/RfekiJ06f"
    "0Wn53Hia2uDUZyJ8ueHgtW3OueWKTq/fY+tRmlsW5fMRbHqvTR40dJbXHbxRNrW+nLMugH8B"
    "RC41tIOVkIoAAAAASUVORK5CYII=")
index.append('page_attach')
catalog['page_attach'] = page_attach

#----------------------------------------------------------------------
page_code = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsFJ"
    "REFUOI1Vk0toXGUUx3/nfPfeuTPJ5DHGlqFosY19xCDaVnxgsRvxgRsFRcimgqIgdddCoeBC"
    "CoK4EHERXAgKQXQvduHC1KBCbEU0C1PRVmOMk3RmTGNm7v3ud7pIMqMHDufAOfz/5ylsy6Pn"
    "vjxZGi5NOeGoGakIAoAAJmCBPIRf2qvhi+Zvy6cXPn0u2wkD8MT5ry5+eOroYRVGEHEYPTED"
    "MBo3cmbmWyxf7fz7x89Xap+/+2Q32klSJwcTpyMLDXEqAlukFBbw3tjMC07cWeX+AxHfhkbF"
    "bLz5+KnPRrXPwyDgEqfECpGAU3ACIqAIEKgPJTx1X507xtNyNph+0AcQkY3MUEAFVOT/6oTl"
    "65vsHcyZqAkvPXgLLoqe7bUQUN6cbdMujNMPjPHO9y0iD1OTVSInJKZcWTOy4Akh4/i+EhKr"
    "V4CJ16/VwtCtSRQr2t1ix0O1DB9datPNjNgppcSRJo40iTEURNG7z//6/D2TpaWJ26vabhW8"
    "eKyGinDyrmEarYJKGd7/rsn84gZxpCTOUYqUsL0dPbSvNL236tLlZs4LRyqMViMMGK0ozxyo"
    "stL21AeEud83ECBSIXJKEaAIoJfn119e/LPbqSWO6Ytt1lo5ZsbaDc8nl5uMRMrVlYyH6xVi"
    "VSIVnAppLPjc0MW3D378zVxzz48L10OaKu9d+IsiwPTsKgOpsrGW89oju3hocggDgoEBsVN8"
    "5vuXePzs3Ob++p50NYPKod10rzX4Zx2Gx8fQRHoXGbbzZx6LOXFmttNfY/C8MbWbt35KOLJL"
    "CftvozAopM9qtqU//O2xYOQdTw+gyELIi8KyAvl6qSCIYdsFBgPBtoBU0CA4Ryh88D2AbLNY"
    "GSi5sTOT3QFA+U+5w+Wo10I5FsBC7HTde1vqzeDYKxdezT1Pq+q9gVDpv+KO6TkYdCzYJTWb"
    "uQn9Qy2v3yDC0AAAAABJRU5ErkJggg==")
index.append('page_code')
catalog['page_code'] = page_code

#----------------------------------------------------------------------
page_copy = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkVJ"
    "REFUOI11kj9IVXEUgL9zfr/73vOp7z2DSoqGoHybDRJEJKJDLdHQEAQNThEVEQ1BTUWQQ0O7"
    "QyQ0OQa1RJAglJBBa4iTGSmZvt5f772/03B1iN476+F88H0cOf/g43x5IDqhSsUkpCCIGe2E"
    "xk4jfmE/dmcX5ibb9Bhf6ncj8w/H+jfqKQIumBEnhvOU5pa2735Z+j46dv31neXZS82uAFUp"
    "/moEt7JhiEKSBmqtmImRPsarFQYimaq9r98HHnUDqJmJF8hHkPMQqVDIKT+3W1SHYPpMhWPD"
    "xWs9FQBEIKdgBnihEBwL3+rHO0mNJAmMjhzm9suvDVKTWjteW1vrvGq21599en6l5QMgKKp7"
    "yGAEJ3TimBuTR9isBwQINlyM04B3nJxb2n68vFQ8nb85f9WbQchsEFKcQOSFNDV+N42VTUPV"
    "iJNArZUwMdLHuWqF/pxefPOuPuPNDAEiByqOYKApGOAECj5zFMvabGy3qA5FnDpU5sNC/paC"
    "koSkayCRDOwFvBMKXlndEhZXO+y0jMgrXoJznfQPMPTPsQGC4PbjiBGCQd4hKjjnMMAncacR"
    "6WB/uRATDJwIIhkhayMIASeQ84qYEYIgIpiBT1Jbn366fHA3trJhLciuSxXP9PhRvIKK7sFB"
    "A5CDPg9mhn87c/ZCN//LTz7HaUj83qv8N8ESCIJ23QJizneSeq81naSOmJPueKDZbG9FOnig"
    "XIgxA91vQybptERq8a70AkzdW1xQpycFGcZo7LeB7C2CpfVSMdf3F6zf+cWV/1n7AAAAAElF"
    "TkSuQmCC")
index.append('page_copy')
catalog['page_copy'] = page_copy

#----------------------------------------------------------------------
page_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo1J"
    "REFUOI1dk0toVVcUhr+1976PPDQPJXiDECPWUCsF46N0IBREqtFJC22RTkqL0FcGKdiRAwd1"
    "LgTEkYIDQewoJcEWEqoWRFCUgqG0USpVo9zYJE3J9Z5z9lodnHuv1QV7sNdm/ev/17+2AOw/"
    "fuWTUlfpYy/sNKMsggAggAmYkqreW17Q6cU/54/NXvowoRECcPDkL9fOj+583QndiHiMVpgB"
    "GNV/Uy7cXGL+wfPVh7/P9V4eH6kDBADnZajoXfdsVbwTgbwp0ZQsM2pp5J3X1vDW1sANrbab"
    "bVk8MDrVc3l8pO4ajToBX/SOgoMg4B14ARFwCKBU1hY5vLvC4JZyW9JZPgeQA4hI8+IEnMjL"
    "xwvzf9cY6EzZ1iscfXsdPoQPWhKaWoMHQTARNBo4IXgommPumZFohmrC3s0lpOCyFoAZGBDE"
    "YRgGiMutMAXzDorgVFD1GA4kJ58DAEquVxCskTOFgm/65ZAomDO05U4DQLM8oU3rG6/OASoE"
    "b419AEOIClH/D6CWFxkNAc3BNJdFiDNnSKZPkz76g7t9/ewpHwgzTYCoEC2nrK9Uq8Hz6TOU"
    "717kzY8+ozT4BrVff6L92nTYty+M5gxSQ804cTtBMFTATEDBxDgycYpDn35B+d7PcPU72ru6"
    "2TwwwK3fbCwApFkkRqisLTDc51DLGUXJGfQsPaC8YRBGvmnxCycqeJNNuYRENY3RkohcfxRR"
    "Mazxn9Sgv6vC6p1JOia+pF57wiqw8o8neh4HgKQWn3aU/Ppvt9c7AIe9mEVXW2DhydfMXjnL"
    "xp42gi+wUs24/9Rjlp0WgF2f//hVmvGec26Hou2vumAY79Ynw3D1e7++viDLhTX1v4pDU2M/"
    "XH//P6O5HySKW8ZvAAAAAElFTkSuQmCC")
index.append('page_delete')
catalog['page_delete'] = page_delete

#----------------------------------------------------------------------
page_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAshJ"
    "REFUOI1Nkz1sU1cUx3/nPj87Ng6OQoVIStNGNOIzCgghhlLEAFRQqVKXLq3UTt2YEF3KAAMD"
    "SLAwhPKxZIiQYKBqkYC2qgC3ZajSFBRAEYYgSJPgJARs4+f33r2nw3McznLvcn7n/M/5HwHY"
    "c/jmN5lC5ktP2KpKmwgCgAAqoI7IudKrWffby4mpQ/cvfRHSDAHYd6x4e+jA1vVG6EDEQ2mF"
    "KoBSrkYM/73A1NPgzfPxR53XTu9vAKQAjCdr057puF8Wz4hAUhSrjjhW6pFlV187e7qKrKwM"
    "5bzd/UFt814IJr9ONQvlAS/tGQRFAWcAB1bAIDSmr9BXuUO2/ysKvVtYeLKWB9fPn0gAIgJg"
    "ABHQ5ghUBCNQqN/A6l06+z5ivvSAtIS0L19FfkVPIfW21pQHgqAiOKtghHy9SE9mhELvJzSm"
    "LpLOCU9HH7JQEzXR7IBZTFYgJQYjggE8I7RVbtGjv1BYs5/gv3OI/xI/307WzfPD3L5o+4Er"
    "4wkgkYsICUCEYOInOms3KHz4GcHkIMaPCF9/wMztf8nuPMqk7XKLsnFx0oVrwmqPr5Kr/MnK"
    "jZ8STp/HSyuN1+8zUxxhbscgsmId1iXSE4BTtKljeuQi2YW/iFw3U/dO4wiozb/LzJ2HVHae"
    "QfJdtPlCHOkSwDqwmuy+fO8CG3Z8S+ZZkfEf/2D0+jxjv45S3X6cONeNAr5niMOYlpFcpDhV"
    "jvwT0l8qE479TO/Ax7wqz1EaLfH7rsvMTryHI0kaXuUThXYJEMUWa6Fruc/YoxecOjvItnW9"
    "1LsHqO4eYnP76mRTCndfxKhTouCtDmzoXGSthhbp+P45j0UpNc3kqiDVGKegRjBO8DycjV3c"
    "AoR1O7Ms473z3abGMsDQ3AhAIZtqGS3rC6DO90wljnVy6ZiwJ/cevPW5MWaLw+WWTnHxaX1Q"
    "CNTpiG90GOB/UyFPOKMILW0AAAAASUVORK5CYII=")
index.append('page_edit')
catalog['page_edit'] = page_edit

#----------------------------------------------------------------------
page_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqxJ"
    "REFUOI1VklFolWUYx3/P+37nfMdtZ51Npx1IlqYbbngxl4SIIUJQIkhFggjRTTAIb4LuBBXx"
    "Qu/Eq66CgUJYRgbOwIJsGrOcQio1zNR0o7a5HHM75/u+93m8OGfH+cBz8T7w/J7/n/8rAG8d"
    "+Omj+KV4nxf6zSiIIAAIYAKmpKp/PZnSH2buTXx2+8yehHoJwDtHh38e3N+/wQklRDxGo8wA"
    "jMm5lNO//c/E/cr8w7E77RdO7qwCRADOS3feu9LtSfFOBGpHCaZkmbGQBravL/JGV8SITjaZ"
    "rZt5e//5tgsnd1Zd/VAL4PPekXMQCXgHXkAEHAIo5dY8uzaXWbOusCxpKXwBUAOIyOLDCTiR"
    "F9sLE48X6GxJ6WkXPt6yHB9FHzQsLHqNPAiCiaDBwAmRh7w57kwbiWaoJmxbGyM5lzUUmIEB"
    "kbjaRcA7IeeFSIRiZZTVj4/R7Ocp5HMYDqQmvgYAlLrfJdLFhLxUaJ76mo5VGyk9GSKOHNpI"
    "pw7QrDbQOszMAMM5yE0N0baqj9ZyH/n/LhJX7xIUgi4FqNWWbHG5/knmH8Kj7yiuKBFmz/Fy"
    "717if74k9oEsteeAoBCsnn2jFX1who6u3VAZ5ergKVpKC9j4ZarjI2RJRiMFTQ0149D1BMFQ"
    "gdfSGwwUZyi2rSTM/g2mhLlfWbP9U+5f+RyXfvgckGaBEKDcmmPTSodpRtfvg5R6d6DzI5gu"
    "0P9+N5qMU2geo7R6C2/e/DEablhIVNMQLAnwy6PA7B/f8kp5PU3FKSybBvFcOzsGKFoZo6Or"
    "k63xsL90sKdHADYNXLw7dGzriqeJNQNu+ps99L53Au/uYdlMPZvFcvhl3fx76wZ/njv8lQC8"
    "PvD9J2nGu865PkWbjr96JM5TFVPDVJe0oaomQc1Zmonp1Wdaaz3vApDIQgAAAABJRU5ErkJg"
    "gg==")
index.append('page_error')
catalog['page_error'] = page_error

#----------------------------------------------------------------------
page_excel = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtBJ"
    "REFUOI11kk9oXFUUxn/33nfnzWSSTJpWSqDRRKfGiChN0G5qKUpD/7mogqj9Q4uibooLyUoR"
    "IbiSBmq6ElHqIiDiqmiD2kj/pFBoQl20StHSlkooCRmjyXuT9+69x8WkExD6bc7ZnO/7zjmf"
    "Atj54bkjcSU+YBSDIhSVQgGgAFEggTyEPxfnw9nardnh69++mrEKBbD7k4sXvj422K8VHShl"
    "EJoQARDmlnLGr/zN7O16cvfGH50TY3tWACIAbVRfweiO63PKaKWgIYqXgHNCmnt2bG5j6+MR"
    "l8Nci0i1tuvYD+smxvas6FWhVsAUjMZqiBQYDUaBUqBRQKCrvcC+Z7vorRZLWWvxKwD12vEX"
    "boawvqejHJQXxUD1JRaW5/nl11MIENtWfHDsHXiDg9vfIbYRST3j4Oi0+2lku41EmHl315He"
    "NJ7l1sLvzEyfxoWEgc3PkHlHkqQEOql2v87lO44QMp5/NEZZ7QD0oi0cOHnmR79eqrSX2+l7"
    "qotItzD/zwJJUicyGzm68zPayxWKBUOxYBE0qMb2euK9iZU0vJJ/M3WK/tKLtBVLVPseoZ7W"
    "cS7iraFRSjbGRpqCMcSRJjS/AxogSc6aSzcmOfH9CM9t2I+PUp7sf5qVvMa12z8TGbBGEWlF"
    "ZDQ+gA+rBAPDXW8vpV/YrU9sQ6xi9PTH7O4+RI15NvU8xpkrY7x5ogclDQKjFUWrcHnDglbw"
    "EQhT1yb57eZV0szz5eTnvNxzmErbOjof7mZL7zYECAICWKNxmQMgmv50dtOODy6m48ODxbkl"
    "C8Di8j2+mxphuV5DKU2l5SGsBqsbCQ8i5JmnmcTcebxfi2+lvJGjQyd5ECQIed2tHdFnIeTe"
    "ywMn/gdjVPAuuKaDLPX3yrHZgMrKgEYg3HdTihqqAiWrAQnW6H+dk7+aBBp/fOj98/u11lsC"
    "oWXN6/3SbBCoS5AZq2Uc4D/1DydNrs+wqQAAAABJRU5ErkJggg==")
index.append('page_excel')
catalog['page_excel'] = page_excel

#----------------------------------------------------------------------
page_find = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv9J"
    "REFUOI1Nk01onGUQgJ953+/b3WySTU3aUESatvnRqhetKKUKigixqMWDXrx4aEtRCl5sL4oU"
    "8SRF0KtQ9ZCWSC1iayNt1aAoFUkhxcWkSbrJ7maz2e1uk3R/st/3vq+HbDYODDMww/wwzwhN"
    "eemD8bejXdG3tLDfOWIiCAACOAFnCaydXSna6+VU7v3kt282NsMAvPzJ7799c2L/PiVsQ0Tj"
    "aIlzAI7C/YCRv++Rm69XM9Mz3WNfHFr3NpOUlocjWm1LFkQrEdhoinGWMHTUAsPzg508M+Rx"
    "wxbizg2Uh0/8+IAG+OjMmW6Tnjh97dp11bd3iLOff8wfP1/h4AvDgMM6MMbR16OpGc3Agx2U"
    "gro/s7Tar44dO9UlLv7hnr2DLNyZZbVcIp/Lsrt/gEujZ7EmRImgtJAr1ejrCHi0Wzh6oAft"
    "eW+oHUO7EsnJiSPFfJ77lTq3bv7FulEEVjF+9TKV1TKeFiJaMXNXuLEQ8uvtKlFfI74K1diF"
    "88dr1WrHnkceo/ehPgqlFRKJTrbv2Ek83s4Po1/jieBrRTSiiUU0sYiPQ4EoVP/AvnfaOxOM"
    "XRyhUszQ3REhn57l0uiX5HNprlw8h68FXwm+p4hoTdRT2OZ1vI5EV9urrx1mbj7NYmqK5148"
    "RDadYviVw+TyBa5evoASwdOuyQM4BGPBWPCMCaOhMUwlJ7lXzLO0mEG0QpTizsy/ZOdTTZ4E"
    "ceApsEDMhzBwqMraKguZReq1Gpl0msraGivlEtNTUxSXl7hbWMI6h7HgAOs2rK8VYSPEyyzM"
    "TX937iuqxhvc1dsj3y+3MXd7nmQqS61axfTs5vTNoEWkbYI3stMnaJgtlA+eGq+dP/l07NN/"
    "IjzZqzbgcWBkq6tzGzq5HPLZAXj2vV/qLZRNw9rAGNcwyJ9ZgxWHa9a3DqRJpFOCsoLWWBPa"
    "sFWgUTP59qjefvLx9XZA8b9xu9q81gptvgDO+lqthaHLtlZ46vhP7wYhryulnrDY+NYrbpqW"
    "g4O6s25COTfyHygscqDbyiMsAAAAAElFTkSuQmCC")
index.append('page_find')
catalog['page_find'] = page_find

#----------------------------------------------------------------------
page_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAttJ"
    "REFUOI1Vk09onFUUxX/3vS8zk2nSaaby5Y+mMjpWGlS0VapSUYKiRjcF7aYu7MIilC66qBuF"
    "6KJk464LUZAGwW6yFGwVu2gqiFCrpqVKkybKNJ2ZZKbJdMrM5PvzrotvEvXA5XEX99xz7uEJ"
    "wCsfXXw3nUsftsI+VTIiCAACqIA6QuduNmruwtpf5ZPXZw4FdCEAr5/68dJXx/ftMcIORCzK"
    "FlQBlNV7IWcvr1P+u9O6dWMhf/70xAaAB2CsPJqyZsf1VbFGBJKlxOqIIqUdxrz0SD/7d3v8"
    "7FazqsW1145/O3D+9MSG6S7qA2zKGnoMeALWgBUQAYMAjuHtKd58ZphCMdMb9GXOACQEIrLZ"
    "GAEj8v+yQvlOmwf7QsbywnvP7cR63ttbFja9ehYEQUVwsYIRPAspNSzUlcBFOBfwwkNppMdE"
    "WwSqoIAnBkVRQEwShTpQa2iVZtEwIFMcRzEgiXiT3BgcXb//kd6ul1hfuIRsNMmkU2SzWaR9"
    "h4s/nOPZ/GrPFoGLEhWuS6aqgNIoz7Nr9AHa5Tl832dkZISoeo1i8WGyzT/s5ORk1gNwTpMh"
    "pWsgQTY/SqfToVarMTs7S29vL2NjY7RaLWoyGn/6yeGWAYgdxNrNvluLv5wj5Zr4vs/8/Dxv"
    "HPmQFw+d4NbybYaGhhh/fMBOTU1poiBUnCof/xogKE7gYKOBtZbBwUF83+fUbyEOGHdCs9mk"
    "VCqxuLiYpBBGMXEMw9t72OsbnEI7eovl8jXylQqFQoFXb35N5ByFXfdTr9e5MNeI+53zPYA4"
    "cC6MYw1i5KflGCeKYjlw+yrk9lCpVNj75BN0Oh2WlpbI5XIMmpKt3L3b8ACCdlzdlrb3ffDY"
    "xjbA0E3k8vpOpqenOXL0GH9evUK1WmX/8wf0i88/k7V44N43MzOxADz9/nfHwoiDxpinHC77"
    "71fcfJSX+7/PrKys8HvmnXV1esWonp07M/HlP53pTZLk0IjNAAAAAElFTkSuQmCC")
index.append('page_gear')
catalog['page_gear'] = page_gear

#----------------------------------------------------------------------
page_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqlJ"
    "REFUOI1Vk01olUcUhp8z8917E02TmAZr0Fb8J62CP4iKCG4MrUjFhW4K6kZx40p0JeimS1dS"
    "ilBQXIjSTUuhuFCJGgniTxcFF1ahqdFoo16vibn3zjdzThffTWIPDMMZmOe875w5ArDj5M2D"
    "la7Kd17YYEabCAKAACZgSq76tPZar1f/Hjv+6Od9gVYIwDffD92+eHRDvxO6EfEYM2EGYIxP"
    "5ly6/46xkcbU6OMnPVfP7mwCZADOy6qyd92PxsU7ESiKkkyJ0ajnie0rPmHTyoy7Oj7HbHn1"
    "66O/z7t6dmfTtQp1AL7sHSUHmYB34AVEwCGA0tdZZtfGPpYsb2sPHW3nAQqAiEwnTsCJ/H95"
    "YextncUdOV/2CIe2fIrPsr0zFqa9Zh4EwUTQZOCEzEPZHE/eGEEjqoFtSytIycUZgBkYkInD"
    "MAwQV7TCFMw7KINTQdVjOJBCvCveGJSW34+kiwklL5Sc8Mv9b7l8ZyuVzKEz3WkBNBYH2oKZ"
    "GWA4VwAzD82Ys6i3nx+urSUpJC0AGYCqFZeMlgE4d2M7WCJoJMRI37xl9C/YxETjA/vPLyHm"
    "V2YBSSFZ4bcFJmpgx1cHSKYkTSjGi9oz1izaymSo82BqoA1DCgW5oWac/iMgGCrQFQPJlJE3"
    "f5FrJGpOnnLeNydY+/k2JvMpqqeGGhlAHhMpQV9nifXzHWpw/UWDmCKfdX5B1EQyZaz2Dz0d"
    "C3j47A7Dj0esWae7sBBU85QsJGT4eULFmIqBC8NnCBpoxMCy3n42Lx3g3sgQo7WXtP/744en"
    "P+2qZwChnl7NrfjeE6ubcwGHga7+E4Cu9uKv7T63EHHtjE9U+fXw3dr6Q4PPZ4eJdGbg2K09"
    "zrl1is6ZHcXpzZic36yMVgel69Vv7zYeGXxYcnYJ4D9DB0iz8O5G8wAAAABJRU5ErkJggg==")
index.append('page_go')
catalog['page_go'] = page_go

#----------------------------------------------------------------------
page_green = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg1J"
    "REFUOI2NkjtoFVEQhr+Zs3vvzUMToyBBQZSoKFhIELEQbAwatBDUxsbGMo1iZ2tplSKlYJEm"
    "lY2kEXw1glimkAgKuYRw1SiKSXb3zFjs40YLdeBw5sH8889DAM7fe36zPdK+EYRJdzoiCAAC"
    "uIAbudn7b5/s6fqH1btLC9czKhGAi/dfvXw0M3lMhVFEAk4j7gBO70fO/JuvrH7c/Lnybnls"
    "cXZ6CyAB0CBHW0FHl3oSVATKokQ3isLZyCPnDu/g9JGE19YbdJ9YvzDzZNfi7PSWVoWGgdAK"
    "SqqQCASFICACigDG+M4Wl06Nc3CiM5ANdx4ClAAiUhsqoCK/vyCsftngwHDO8THh1pndhCS5"
    "1rRQ95oEEAQXwaKDCkmAlivLn53MCswyzh5qI6kWDYA7OJCI4jgOiJarcAMPCi1QE8wCjoKU"
    "5EsAwCj7FQSvfG6QhnpfikTB1bFmOxWAFaXD6tVXUVXAhCR4dQ/gCNEg2nYA8zLJqRqoB1Mf"
    "iyAOiZZFOikUufcBokH0krL9kW1exr3SXSANSpEV2xjkjrkz9+wy/yMnrj4mz2IfIC8isbTZ"
    "v2/vX5NXumu4OfnmNgYxM8tjdEBWumv/ZBCCWCysfwfZRlwbaoc9t6cWhgDF+7MYGShvzR0G"
    "UgXc0iDfi8K7DYASH0zdeXFFVU8aNtiU8vprFBw23fxtqj4P8AvG7vPN7kd50wAAAABJRU5E"
    "rkJggg==")
index.append('page_green')
catalog['page_green'] = page_green

#----------------------------------------------------------------------
page_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsNJ"
    "REFUOI1dk01oXVUQx39zzr33vTaveTFGISQYDG1jVShaRVMpRqF+VBdaqSAudFGFQruQogtR"
    "cONSXXRRBFHooqmo3bWN4kf9gFKQ1lJNS42x1YQQ8syH7Uveu/eeGRf35VUdGIZZzH/+v3MY"
    "Adj+xrcvlqql572wxYyyCAKAACZgSqb621JNv1q4PPPq+CfPprRCAB5/+4fvD+3bsskJXYh4"
    "jHaYARhz1zIO/7jIzJXG8tSlie6xAzuaABGA8zKUeNc1PifeiUCxlGBKnhsrWWBkwzru2xhx"
    "WufWmq1feGzf8RvGDuxoutaiCuAT74gdRALegRcQAYcASm9nwpP39nLr+vKatFL+CKAQEJHV"
    "xgk4kf+mF2bmVxioZNzeLbw0fCM+ina1EVZZIw+CYCJoMHBC5CExx8RfRqo5qinbBktI7PK2"
    "gBkYEInDMAwQV3yFKZh3ECvdE+9TCZOs6AhIP20EA5QW77+siwmxF2InVP44wkD3nww++ALM"
    "f84GfnJtAc0LF9oSMzPAcK4QLE8dpT86SXXoHupXThCv6WPvwDfJib2Dz0UAqlYMGS2A1Ycp"
    "Srx0lur9TxCWf6Hc008jTDEwcgdSnz0YAQSFYAWv/m9aDbKkj2zhMs7XEFcn6axBY5lrM01f"
    "OMgMNeOtsymCoQJmQl/jArv4gGpHhuYNnC6CW4dlKedHJ/n1Uu3lCCDLAyFAb2fM3Tc71KBn"
    "9hi31D9l4/Awln6BhKv8PJaS1Zt0JcJ7U89kHx95fbRASFWzECwNyKnpgIqxe+k4t217iLR2"
    "kCiqcv5k4LN4D4ubH+XdB0THXzl1/RbSlTDbUfI9r93Z7AAcBtE5j/hpfOkmLny9TDy0hze3"
    "PgWYlhN3Nc9t+voxEd55ZP93Tzvn7lJ0LcDOnjjaPnna/z2f8+HvD+cXz1QCo19i0DC1M7Gz"
    "wwD/ABdNNe5K15glAAAAAElFTkSuQmCC")
index.append('page_key')
catalog['page_key'] = page_key

#----------------------------------------------------------------------
page_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuFJ"
    "REFUOI1Nk01onFUUhp97v5/5Jslk0mRqHVBSJTG1+BdqURcFrYq/4E9pBd24EBQkggsF0YUg"
    "uhOUbroTXGTRLMSNWKqLYLUIQaKUEkpi22CcmEkyk8bmm5l77zkukkw8m3vgHp5z3nvfY9iJ"
    "Jz+afr1QLrwWGY6okhmDAcAAakAFJ7KwsSo/Nq7V3rs8daqzew3AM59e+OnriSN3W8MAxkQo"
    "3VAFUOr/OiZnmtSut7b+ujI/+P3pZ9vxbpGNzFga2YHLdRNZY2C7KUEF75XcBR4dLfHQXTG/"
    "Sr1HdaTx9MR3+7qAeyoL/e7PM9Gw82hQJAgaAuIdXnpZHPoMKFLtT3n+aJXz6XLxai37KgbQ"
    "syejqexSXOg9QE+yH3UedZ7Qyckbc9TKp5DCfmrrOcN9EYUk5uAjQ0xfvHYyBlgeXbn94bwR"
    "JcUX8Bsz2GycENZoNa+w2v8q7YHnSL0wvxboiEekw7E7C5jEequXDqe2LW+Uh8aACMmXEd+m"
    "sXieZukEcsvLxMaQRJZCGpGlEVmaoFgwlnh5c3DciH+zUBpFfQ5RFZxDJMZsLZJe/YLE5ThK"
    "bB14EZNWUavIzu/EJsjprHK0kq/NIV5Ie0ZAYgarj5Gv/U5wHW78PYse+oQ424diUAxBIAhY"
    "Cf7szaVfPp+aKfm2HWF1/hy+fRPXatLZWmXD3IE/9gMMv4KJeomtIbKGLDF4p3tGOv7xz/nk"
    "xKFsa/oJsr6DbDZXcMPvoLedQHS7mwBBFDVwf9Xy+IcXWl0fiFPy2XdJCoNcXK/yTe8Z8noZ"
    "/vGo0a4jZad+8tYE1wl0AYf7Zm24cZ1vix8w8MBTHFcICsGAKOgOQBX+WPGoKK7l9wD1zbKY"
    "+77UucV7jS4FxCi7CkXBoNsga7BiiCIkePFdwMJ6tdZXGau839/uBSz/G7dcjLsSiokBVJLI"
    "bnqvS91HfPCtc287z0vW2nFBevZWcffoJii0VPQ3qzr5H1MpbtwSUWmDAAAAAElFTkSuQmCC")
index.append('page_lightning')
catalog['page_lightning'] = page_lightning

#----------------------------------------------------------------------
page_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtlJ"
    "REFUOI1Vkl2IlGUUx3/ned6Zd3dnXWe2lXH1Yin8wGAVUQmXVSsY2JGCEtIFLbsp+mARhS6C"
    "oKsutoQI77xwoSAC7yRKC6llN0PLLvIDGdRamJ13xlWnaMfZed95n+PFO7vkgXPxnMPzO+fP"
    "/whA4aPpN/3V/mEr7FClSwQBQAAVUEfk3J1/77uL9b+DD26ePRjSCQEofjI78+XEji1GyCJi"
    "UVZCFUBZWIz4+vd/COaWHpVLt/vPn9rfAvAAjJXNaWuyNxfEGhFIhhKro91WmlHM8xtX8dwm"
    "j8tuoUd1Q31s4rvc+VP7W6YzqBewaWtIGfAErAErIAIGARyDfWle2jXI0xu6usPerimABCAi"
    "yw8jYESeTCsED5sM9UY82y+8tfsprOe9tiJhWatnQRBUBBcrGMGzkFbD7QdK6No4F7LnGR9J"
    "mfYKQBUU8MSgKAqISaxQB2oNpME4wTmLYkCS5RMA4Ej0CoJ2auogZZf9MkgsqFHcijsdgGsn"
    "BbdsfadrDOAEz2rnHkARYgex+z/AafJJYanV5MYfv1C5e42B/hzVew/Y9eIBulflmDk3RX5N"
    "jkv1Orn/+rxCoZDxIKHFClEY8eO5b/B1kTeOHKbRaFAul7ky+y023c2BV17G8yxBEJC6etX7"
    "4Vb642SDSHGqfHh2hs0Ld3n9yDjHPj3DYulX1g2uZXh4mGD+L06e/I1KUGVkZIR9e/cwNzf3"
    "tgGI2jFxDF71Ov19GQBeOHqCpTBifHyc0dFRisUiY2NjPGpFvPveBADZbNZPJITORXGsZvVa"
    "KQeXAfhpahKNYyYnJ8lkEmij0UCc8sXnn2mhUJD5+fklDyBsxrWMbweOF7dmvjo9bWZ/nubQ"
    "vq2wd5harUapVML3fYaGhsjn84gIM5euxJVKpSoAO9+58H7U5lUjbDdhtXfg4fep9fms+H4K"
    "Aa4tborapke39fyZFpy2WqGrVGr1ZqNeeAxMazoaGHLdRQAAAABJRU5ErkJggg==")
index.append('page_link')
catalog['page_link'] = page_link

#----------------------------------------------------------------------
page_paintbrush = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtFJ"
    "REFUOI1Nk01slFUUhp9z7/d1aAdoIW11MKAdWkpLQzBF3RldqMEYEzcubExYGHeGBQE2LCCE"
    "hASUBW6MrFxUo8Zo3IAJIYg/aBSliZUiiEyrA0zb6bSl7Xw/57iY6Qw3ubk3uefnfe97Xnnh"
    "8KW9mfbMiBeGzVgjggAggAmYEqveqkzrhfI/xQPjn70e8dCSPce/u/zRO8MDTuhAxGPNRzMA"
    "o7QYM/rLHMU7K0tTN25uPHfm5epqTOC89Ld41zFeEu9EoNaU1JQkMZbjlOf61vHMtoCftNRm"
    "1lv++NTu/t6cfLAwU5hwwFrAt3hH6CAQ8A68gAg4BFBy61t45akc23sqrZt3vPr7tmf37THN"
    "vh0gIgCOWoLVv8BEcALOC8XZZR5f63Fxia7uy+S27to4cfEk89OLZ4NVroEHQTARNDVwQuCh"
    "xRw3Z4x45T+2LH1O344hZm99wp2xGx/GvvNAYAYGBOIwDAPE1aQwBfMOdIrHlr8gPzjIXOFT"
    "vj5f0mycOTRyYjxyBmgdvhNpbDEh9EJQnaSr8iX5gQEW737FH9/f5lz0VjxyolAGcJrUKCg1"
    "JGYGGPHSNJXbF8j8fZT8YJ7q7HmufvMrW54/zZxsaogdqFotyagTgMq9CSqTY2gyR3V2njU/"
    "vk+lHOGHjtH9xE6S+OfGrLhUIbW69gqTxQI/jF0n2LCZXbufpr3/Da79uY5ydi/ZvpcIvSOJ"
    "EpoIYkPNOPJbREd0l+6Fv3iks5crk1XOXlogkDZ063s8cJvgWsLooyFxlDYLxElKmkJufYi/"
    "cpF5C5kpzvNgMSJs7Sa/c5Cunh7MYOx+gqkRrzyEII1U4zS1KEVs+E1UDEPIAGowhVEoJpgT"
    "nAreo2mijQpBtJzey2Z858GhahZw1BUBaG8NGqZqDWuTEXq3kCT2b9NMpO++uP/b15xzTyra"
    "1rTi6tG4YLBialdDZ6OrYf8DPvtVbv2/qNgAAAAASUVORK5CYII=")
index.append('page_paintbrush')
catalog['page_paintbrush'] = page_paintbrush

#----------------------------------------------------------------------
page_paste = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmlJ"
    "REFUOI1tkz2I1UcUxX935r9v37rqGhX8wN2AYFxlBTFEG0UwFjZaCFpYmSKEWFgIARFESzsh"
    "TZJGEgKShChYWFmIqKABQRARTPAjAZFdNau85/O9mbnH4v/Wr/U0A8O9Z86594zRxw9fja21"
    "EG7zASQ9//bUwwUf3s/Afto/tsGDHTeznXMXLmHfkWO0n/wFwPDijfx67DCd9gskTgs/e+DU"
    "v2feJagU7eyOr78bXbR8OU8v/IwkSrc98zpb1o0yvP5LXNp57sfvdwHvE4B9umjZCqb/vo6n"
    "l9z//SRIgHiiGwgxdesqC8c3zsNsloUKQLmH50QYm8BLRhK/lYMUOe514fO7bWzzdr6ZeKRn"
    "r5bc+W/ywefXTu7tVABeEp4TnrqU7itAlMo5unucqZZjgEuk4lRxHb9cn15T3ajuDR74Y1VN"
    "kLt4ySDHrHYQQ+D/l+KfKRGCSNl50cls/WyIzasXMNwISy8r3ww1QQ/PPUrq4bnguQAQDZoV"
    "NKLRiEazEZic7rD6E9i/aYSStLJWkLoo9VB2PBWQKE1hBgOxVqRoNKvAvWei9bjLF2ODDFSB"
    "6q2CgqeCZwcXLmEYMYR+YoS7YDBiwYgxojdbSAX1ylv5/cnXh2E40aBRBUzC3TAzpD5BTpmS"
    "Cl5K3wJ4EQZUAYIFXPVMggMNGKrqoNUKehlPBZWCsiMXAMXzjMhZcGVwo0K63Gm1tswdHUcz"
    "FlS76+YW8PF/1M0tTNEqGScunv9znhnr3y2YnNjDQFjJSDMhQTB7k2QDYphPUerNDncf2w5d"
    "uRRiWGXYUkS7bqutmWGu0po/pzH0GodQT3jmxlFNAAAAAElFTkSuQmCC")
index.append('page_paste')
catalog['page_paste'] = page_paste

#----------------------------------------------------------------------
page_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiVJ"
    "REFUOI1dkjtoFVEURdc5d97LVxOjYKxE8UPsJIhYCDaKBhsLbWwEsbQSwcJOLK3sVSzS2Esa"
    "Cz+NICIWKfyAghIkahSDiTNzz7aYee9FLwzcz9x19r77GMDx648vDE0MnU/GrMSwGQaAATJQ"
    "UEW8//k1Hq18WLq6+OBcSTsM4NTNZ0/vX56dcWMSs4ToDwlALK9WzL/4wdLH9d+f3rybWrg9"
    "9wegAPBk+7vJJxeXLbkZNEXJCuparFWZY3s3cXhfwfNYHpX2rJy8/HDLwu25P94WGgdSNzkd"
    "h8IgOSQDM3AMCHZs7nL60A527RkeKceH7wI0ADPrLdzAzf79krH0fY2d4xUHpoxLR7aSiuJs"
    "30LPa5HAMGRGZIEbRYKunHffRBk1ESVHdw9hHa/7AAkEFOYIIcC8iUIBSg5d8DAiEsLBGvEN"
    "AAgav4ahdk8BndTLy7FsyEX002kBUTcb0Yu+PXUHwiiS2n4AYeSAHBsBoeaSaA30HqbXLIYJ"
    "Cm+KDHegrjQA5ICsRnL8dzvUnKudy6CTnLqsNyioREhMX7+IsPbvDCbUIyqwVlHcuUdV5gGg"
    "qjM5Q3f7NGMzM5AzigxhjbVQCwhW375FIar1DQpyGVHlLKrSVl+/QrlVAJggUFNdYC5Sssh1"
    "DPqgXMtfxobStuVrN8YAR4O3mBgp+o020nFA0Un2q671uQ9w8q0TV56ccfeDQYz+n4IGEwTr"
    "Cr3suOYB/gKeqxmixV90FQAAAABJRU5ErkJggg==")
index.append('page_red')
catalog['page_red'] = page_red

#----------------------------------------------------------------------
page_refresh = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAulJ"
    "REFUOI1Vk19o1WUYxz/P+/udc3b23z9oK2ZJp4XihBRJMqqbJCOiSAfhTUhENyO2ckUE5YVe"
    "pV14KWEr0NCEIJCygk0XOZszFNfa2cRBx2mzzeV2jvu9f54uzs5mL7y8F+/D9/l+nj/y/Ee9"
    "b2QaMrsjYbMqVSIIAAKogAZsCGMzt8PP09cn9g6dbEu478iO/X3nvmzfvM4IjYhE6NKnKoAy"
    "OWs5NnCHifF7xb9GRpd/f/jF+UpMbCJ5PB2ZxqFJiYwIlJPiNeCcUrKe5x6r48mWmP4wWa2a"
    "m36h/fSyiogBaoEoHRlSBmKByEAkIAIGAQJN9WlqVn/L2lw6m9RWHa04MIhIRckIGJH/30iY"
    "mCrxcK1ltlTAZT4niuNdiwgV1jgCQVARglduJXkGb3/Hjdk/cGMelzia69Zg3RzZpq/NooAq"
    "KBCLQVEUuDmf57fJb3iwejkbV7xE0IBXT1CPC55isd9sP/Ts6JnO3lysQKDMKwgK5Gf6WZmu"
    "YVV2NYOFAfI3R7CJo3nZGrzzXB2dDz929eYATHBlhEDZiapybfp3Bm9c5NSVk8wVDR1Pn6Dj"
    "mVP8M1XCFQ2++GaytWNrFiAOQdEFDl0Ygj3rD5ZFFXzwHB84wM5NH9KQfoB9r3zMy/sHOP/Z"
    "+RJA7AN4Lfc+LI0QLiQIKY70vc/d0h2Cwuvb9tH11dvMJReqNr6zTl3ixuNglaDKJ5cSBCUI"
    "qAoEQ/L3BzTXzZBJOzq/eAqbOB5tfoTdO9sYGv6TnnO//BBb5/EemupTbFplyrYVTp99jYca"
    "62nNteLVs6Fl/WInRq6N0dPbd9F6ezz2SQjWe0088mvBE0RRhBUtJ7h+tZPiXD/WOYaGh3GJ"
    "w1lPcGu99fa98e5CT5yU/K2aTLSya8N8DWDQpVo0bPmUvd1vUfx3ir4DlwEN2bS527rnTCHf"
    "vaOnvEz4g9vfPfuqMeaJQKi+r44LTxsuOpra1v6TVbinQQdTRo9Vwv4DqpeBRE8vf3wAAAAA"
    "SUVORK5CYII=")
index.append('page_refresh')
catalog['page_refresh'] = page_refresh

#----------------------------------------------------------------------
page_save = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqFJ"
    "REFUOI1tkk2IlWUUx3/nPM+99/XOnenOZOUg2Qc6YhTWiEpBEEVRIUQL27hpI+LCldiqaFO7"
    "hKBVmyIXRbQViSLKPqgBE9pIhoWZOOhNZ7qT9973fZ/nnBYzYzPRgbM6nP/5/8458vSrp19u"
    "3dY6EIRdwCQwQgAXcKM2+/WvP+2LhYvzx8598lLFf0Kee/Pbb04c2bVDhS5IWC24Azi9v2s+"
    "PLPI/O+jweVfLkx9+s7z5VqBqEG2N4N2z/UkqApukN1IyRnWmSe2jbN3JjJnvbb71oVnj5ya"
    "XCuiQAcIzaBEgaAQBERAEcCYnmiyb/c0920tNlSd4v21DhQRWVVSkfUZhPkbQ+7p1DwwJRx8"
    "9HZCjPvXIazyxgCIYNlBhRig6cqF605lCbOKx+9vIQ1N6wTcwYEoiuGICgJ8cPI84y0YVInJ"
    "TpMr14acUti5qVM89O5PvtAf8uXZK3ujA8a/zA64wXAw4sk923lhtsPJHy7z2oEd68534qse"
    "ZjKnlpYRDHB3wFGFQVlzY2nZ7ednrt5qHCXol9BbrBAxopkXvspx6wlAVQgOdTaOH57FzHEg"
    "4LQjlGVJ/2ZFrEsf1ebF6z9WuDjuAgZTDWVU1rzx8UVUIGXDsi0jrgxsN4xYp0zOMD3R4OE7"
    "lOyQBebOO2VOBG0AjpAREdwcdyOlmqpKxFyZ1Tl7lZHv5xOOALA0qGlI5PC+cZJVy5/i4GIU"
    "sclbH13iev8msRrmq2OtsPGVB8sxHLWVNRw77QQaGEPeO3uIje0tCEpv8AcHd7+NUjAoK6KS"
    "jz9z9OsXVfURx6ccH+Ews2W8uHcT3NVZ4qmde+g2N4PC4mgzd44l2k2IIit+/ydmD3323czd"
    "Gx7rtroUcYJkNWKGeMZkwM+XfuNav+YfTCM/egrfO5kAAAAASUVORK5CYII=")
index.append('page_save')
catalog['page_save'] = page_save

#----------------------------------------------------------------------
page_white = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAT5J"
    "REFUOI2Nk8tuwjAQRY9jxJ4N3bRS/6Eq/c4KseCTqv5Fu0BkQxAhJtHYtwsIDaGhjDSSX/f4"
    "jh+OYzwCD4DnduTAF5D6Ey8hhKJpmmhm+isPh4Pm8/k78AxkfcCsaZpYlqX2+/05t9utNpuN"
    "1uu1zEyr1UqLxeIK4oCZmSmEoLquFUJQCEG73U5FUSjPc5mZqqpSWZZaLpctBHfKVzP7iDGe"
    "LaWUkISZUdc1k8nkwvJoNHoDPkfdwSzLcM6d2zFGvPeMx2OKoiClhJkxnU5/QV1AK27b3vuL"
    "fgu8cNI/zT6wFTjncM4h6X5AK+yW1o+r+xyCAHjvybJLyaCDrlVJOOdI6eoB/l9CF9Tf/Sag"
    "PbCh2q8AkuR6q4fEktpalAECUowxdCYGQ1KKMVZAhOMzBnji+J3vupWTOAe+fwCXA9OcPJGc"
    "bQAAAABJRU5ErkJggg==")
index.append('page_white')
catalog['page_white'] = page_white

#----------------------------------------------------------------------
page_white_acrobat = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhtJ"
    "REFUOI19kz1oFFEQx3/vY/c2BHPGJJcoKpYWIhI1FkKwsNBCRCSNKClSpAuCoKKFjaWg4Qza"
    "2FrbWokISgpBVEQUNMQiXkJyd+Q+Nm/f7lgkJpe76B+mejO/+TMzT7Gl/cAgYPi/FoF5IGt/"
    "ON5sNivOudR7LztFHMdSLBangUOAbgeMOOfSWrUq1fu3ZfXVS6nX61KtVqVcLkupVBLvvSws"
    "LMjMzMwmxG4UKwCttTZakSYJurcPrTVaa0QEpRQA+Xye8fHxKWstk5OTDzts6DBH2myQfvkI"
    "gDEGrfUmIAxDoihiYmJiCijYDoDW0NWNykVYa0nTFGMMYRhSqVTIsgzvPYVCYT2/HaCUwpdK"
    "rM2+RSmFMQZjDNZawjAkCAJyudxWw3aAn5/DNxr4Wo3k29cOiLWWIAj+DSg/mSY3epb8jbus"
    "FB+QzP1AKYXWehvor7bNIF1eIp77Se/1W2T1GhKE/Lp6mWBoL2ZgENM/QDR8ku4Ll3Z2sPT4"
    "EeGRozQ/faA++45dY1fY9+w5uVOnkVyEGIuv19pNw5uD+d6n/T33vo9dlLWV5c3LS5JEkiQR"
    "55w456RZ+i1rq6vinBPvvQAj9v3Q7lGcOn9Yy7nBm3cwPfltG2k9Irunr6O5TtPsWur98OfY"
    "veg6NiztCUqpHUNEMtg44Q2diOP4tTEmUkp1bKdVIpKladqIouhMK+AA69/5v8UtSoHFPxKc"
    "+o6IhxSDAAAAAElFTkSuQmCC")
index.append('page_white_acrobat')
catalog['page_white_acrobat'] = page_white_acrobat

#----------------------------------------------------------------------
page_white_actionscript = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl1J"
    "REFUOI19k8FLVFEUh7/z7nUaE3SG0hnIqUFKBRdNk9WyokUy/4SLCDfhslXUrkUEYuYm2mVB"
    "KzeWqwzBJBdOgUJi5CKVSSFGaXTee/Puuy1GHEetH5zF5dzzcTi/c4Sa2oEEoPi/NoGfQHg4"
    "cblcLm/5vm+CILDHheu6dmRkZBhIA85hwFXf902pVLI7Ozv7sb29bYvFot3Y2LBBENhCoWBH"
    "R0f3IXqvWAAcx3GUUjiOQ5j/AtPTaL9CZfAeIgJAS0sL/f39g1prBgYGhuQA4EoQBHPGGJiZ"
    "IXw1RsP5M3ifvmLevsHzPOLxeF3LWutrmkOStXXMi5foswn8hRXo6UEpRSQSYWtrizAMCYKA"
    "tra2KqSu2lrCsdfoCykqgabh+TDEYhhjqnARjDEoVTOqbpL2xwr2+xJe/huqrw+URkRYXl5m"
    "fn4erTX5fJ7V1dXjAebde3R7kmhvD96Dh/jPRgEoFAp0dHSglKKrq4ulpaWjgEednZ3BhynA"
    "sjs1hzV2/5PneSQSCQBaW1txXbc2SICN67lEEJbvR7rTlD8vcGLoKdJ0EpqbmZycJB6PY61F"
    "RAjDkFQqxcTERBVQup2bsV4laULOhX92ULduoi5d3JupJZPJsLi4WGvZcVhbWyOXy1Xf1vUy"
    "YaXS0Zjt1t76byJ379QsFSGZTGKMoVQqISKISN1OOLYSNOFX5NfHucXok8dWTp+q3wsR0uk0"
    "s7OziAjj4+Nks1mstSHsrfCeel3XnVZKRUWkzh3P8yiXy8RiMYrFIo2NjaHWejcajd44CEhR"
    "PecjV/YPGWDzL6MlIJZ/ca9oAAAAAElFTkSuQmCC")
index.append('page_white_actionscript')
catalog['page_white_actionscript'] = page_white_actionscript

#----------------------------------------------------------------------
page_white_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeFJ"
    "REFUOI2Nk8FrE1EQh7+3uw0qHoxIpFBBEEUPtYI0igoK4tWTIHiLCILBk/9ErxIixIt68OLJ"
    "InrQQhFKtRS0VnoRvCgYspdsyGZfNnlvx0PdNNk06sDAzHvMx2/mvVFs2wxwGHD5u/nADyDJ"
    "XpzVWge9Xs8aY2Q373a7UqlUHgJHAScLKPZ6PRuGoXQ6nYG3Wi1pNpvSaDTEGCP1el2q1eoY"
    "RAFFY4xorSWOY9Fai9Za2u22BEEgvu+LMUaiKJIwDKVWq6UQ1B+fN8asWWsHkpIkQUQwxhDH"
    "Mfl8fkSy53nngHVv+NBxHJRSg9hai+u65HI5giAgSRKMMRQKhR3QMCAtTmPXdUfyFDiiJDvN"
    "LDAtUEqhlEJE/h+QFg63lrV/AlLI0qdFlr+8ptVp0jd9LpVO3F558m19ImBY6pu1F2zUl7h8"
    "cZ6Zg8dZ3npJNPXzbrE8HY79qN1Aix+ec+bkHNaxzE1fw6o+52cvAFKeCEh7VkrhB3Wm1H6u"
    "n7oPwIOrjzlWOI1C7RkAJDtedibfjlps/Vpl4V0JgIW3Jb77mwjSdQABEmutFpGxLQO4eeUO"
    "HzdXyeHx6usjcspjZeM9oKrp2xxhe50ntjR761B57wHvhlJqn4hE/UiefX7auPcbQ5sFU0l5"
    "TfwAAAAASUVORK5CYII=")
index.append('page_white_add')
catalog['page_white_add'] = page_white_add

#----------------------------------------------------------------------
page_white_c = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAh1J"
    "REFUOI19k71rU1EYxn/n3nMTS9NCorQWLdQPpCARpNi4iKJInUSRglPBQXB2URz8A7RLKR3q"
    "rLvg2NlBpw6FiojaIoRkaFJzk5N7c855HWqbpKk+8C7vx8P7vB+KLk4D40DI/1EFtgF/ODBj"
    "jKmnaeqstXKUtdttWV5eXgKmgOAwwWyapi6OY2k2mwe2u7srtVpNKpWKWGulXC7LysrKAIkC"
    "Zq21YoyRJEnEGCPGGGk0GlKv16VarYq1VlqtlsRxLKurq0vAlAK49+rrOVPZfjl3o7gAwkQu"
    "5OzJiEtTWUQEay1JkpDP5/ta1lqX1Pzit5nimdxaIafzofc4Jxgn+ER4ev8Ezjmcc1hr6XQ6"
    "eO+x1jI2NobWuhQMHcs8Gx/V+Q9rG+8f3y7w5M5xJoYCdtqO2HjCMCQMQ7TWZDIZoigim80e"
    "dBFMn8rOx21H5efm533nw5sFSpN7SUqpPhKtNVEUdWU460lEkf6uNXr13b3W1auUIggClFID"
    "RxH82ul8D4DM6Pnp3sDiuzKbP0wfCUAYhgRB9wSCzY34TdLxXL4+s/Bly9BoOl6/LbPVdHgv"
    "iHRNKYWI9HWgAEqP1p9fKA6/yI9kR0zqsR3P3PQwD24VAAaKAIIg2FtjD9GVj+u1TyJwtThy"
    "kHhU8b4krXVJ9zpnL+ZEHZrUUYP7S+yhe8sCeOec2Q/8DyLinXMtwPXST7L3zgNf9g84oPoH"
    "DkIpPPMYvBcAAAAASUVORK5CYII=")
index.append('page_white_c')
catalog['page_white_c'] = page_white_c

#----------------------------------------------------------------------
page_white_camera = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjxJ"
    "REFUOI19k71LW1EYxn/3I0QxCbRLllx06SAtEii1RNC1k/9DF6F2c9DFLgWnbiIB/Ts6NdCl"
    "k3TSpSoqjaYqXsk18Sb33I9z83YoJsaPPvBwhnPe530Pz/sYDFACioDF/+ECp0Dv/sVrpVQr"
    "juNUay2PMQxD2djYWAcmAPO+wHQcx2mn05Fut9tnu92W6+truby8FK21XFxcSLVafSBiANNa"
    "a1FKSRRFopQSpZT4vi+tVktc1xWttQRBIJ1OR7a2ttaBCWN1dfULsCwiAIhIn0mSsLa2xsrK"
    "CmEYsrm5OTSybdtvTa318vz8PJOTkziOw87ODp8/vOLTu5/s7e2xtLREPp8nl8uxuLiI53m4"
    "rjsQGRsbY3d3l3K5TKFQYGZmhu+/ztjenmVhoUy326XRaJDNZtnf3yeTyWBZA6PsfD7P1NQU"
    "X0+eUzs1wcwyW3Qov2hSq9WoVCocHBxQKpVQSmHbNrffBTCz2Syjo6N8q5u0GKFtjPCjmcOy"
    "LG5ubgjDEKUUURShtcayLGzbHggEQYDv+/QEQMAUxBZc1yUIgkcFTHOwAmaz2eT4+Ji3z5rk"
    "jJCcEfKSEw4PD4miqF+cJEnfnSEnrq6u8DwPx/nD+0IB3/ep1+v8PjujWCzieR7j4+MEQUCS"
    "JEPdAezz8/NqGIYfj46OjFvv4zgmSRIajcbQXszNzWEYxpCAced8kyTJtnH/xRMQkV4mk6nc"
    "ziNAL01TJSIPUvZYcZqmAZDe7ebwL84PUvYEUsD9C1EMdqoenNumAAAAAElFTkSuQmCC")
index.append('page_white_camera')
catalog['page_white_camera'] = page_white_camera

#----------------------------------------------------------------------
page_white_cd = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl9J"
    "REFUOI19kz1oU1EUx//3vvvey5c2kaYqWpKCWForRfyI0SKCpbhZEMRF6OroVOniooIgSCmZ"
    "XMRBioNTB0cVhQoOarFFsIM1WPNqm0Rfvu7HOw7SpG2ifzjLPZz/+Z3LOQwtHQSwF4CF/8sD"
    "sAIg2Jk4XqvVSlJKo7WmTlGv12lmZmYaQBoA32lwSkppfN+nSqXSjHK5TMVikQqFAmmtaXV1"
    "lXK5XNNkE5fdfPBswkmkL3xYkfiUV8ivKzAQEjELRIQgCBAOh2HbNoaHhzOpVIrPzc0tsVtE"
    "fOCtf0cpM3luIMIahhCPcVR8jdmX33GsL4zs4RikbCCRSGxDFkJk+MC8f0UpPXnpxC7WFRZY"
    "9hQCbmF/MoQb42m8WljHUr4Kx3FQKpWwsbEBz/OaJlxpPTHSH2FvvvyG3wiQ7XMRMgZaE0hw"
    "XBtN4d3nIoQQcBwHtm3Ddd0WhZR6sCoN6tIg6hAePl9APBrC5ZFDWPECuJbAt7UKLMsCYwyM"
    "MRDRFgNtYILWQ9S1EXFtEBGKFYPuMEFJDc45GGNtSyFkQy2GBXqPpnfDcAtXz/eDiLBWBSyL"
    "Q9Wr6I67zc6WZW0j4FLpR7Mv8pSMcqzXGJbLAos/GQq/AvR2Mdx/8h5nh5IgojZ8AOD+x/TT"
    "htT37j5eoHq5jBiXiNsKkaCCqdxrXMwcwOnBZKuAc3DeWsLNodj49emp0bGx219/+FBKY9+e"
    "EM4c6UF2qKdtbgBgjEEIkWFbjE4qpeZZp5/qICIKbNvObrIQgMAYUyOitivrVGyMqQIwW7v1"
    "4u85t13ZP2QAeH8A9UM1ZcPmVKIAAAAASUVORK5CYII=")
index.append('page_white_cd')
catalog['page_white_cd'] = page_white_cd

#----------------------------------------------------------------------
page_white_code = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjdJ"
    "REFUOI19k89LVFEUxz/33TvjrzFTa6y0lAgSyhZKGm7atG1ptAnaREEugjYhLQqMdqGIi6lF"
    "i1r1H4SUtBSiNtWmRSDhMLNw3nN+vDePe99pMeroaH7hLO495344l+85iqaGgAFAc7SKwDqQ"
    "tCYmwjD04zh21lo5LKIokqWlpUVgBPBaAZNxHLtKpSLVanU3giCQUqkkhUJBrLWSz+dleXn5"
    "AEQBk9ZaCcNQ6vW6hGEoYRhKuVwW3/elWCyKtVZqtZpUKhXJ5XKLwIjaA7jqV+O1DiO7LSVJ"
    "gohgraVer9Pb27uvZWPMlNk5dJ0bzzz/7BPYhNc3T/BwxacLYW46Q4fRpNNpfN8nSRKstWSz"
    "2QYEYPTJr76h096C0gpdawB1Ipi0Yn61zNz1DF1pg1IK5xxaN43yrrz4c3t8ov/v2IW+sXLg"
    "eHbjOABPp4/hlx0qBY8/brHyI8IYgzGGVCrVBIyeb8sNd+v2/GbsZq9lGOhp/CrbrZmdyFAM"
    "LKc6FR9+hiTiobXGGNMEfP9avv97ox71tRn96pNPoWQBKASWhS8+PcZjvRgzc7GDlFForfG8"
    "5ggogDN31vqHB1Orly8NjEWB5e2DQe69L9DW7iFly/zMSXo6vV1nth3AGDPlAWy8m9r89ubu"
    "I7YskW3YGMUJElhe3mo+BvA872AHO3NgrV2jRSLSetV4oNT+OdguFqWUai08TCKSQHOWBUic"
    "c+FO4iiJSOKcqwFuL/4sjXU+sGX/kQOK/wDP1icqAyasqwAAAABJRU5ErkJggg==")
index.append('page_white_code')
catalog['page_white_code'] = page_white_code

#----------------------------------------------------------------------
page_white_code_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAihJ"
    "REFUOI19k89LVFEUxz/v3fveWKk0pWVqZEQgxUgU6n8S1kJqEdUmiogkohYRRFFo5mKWQdta"
    "ta+ttGgXRIsipNGXzDybH++H977TYnTGRvMLZ3PPOR++3HOOQ1vDwGFAsbsC4CeQdSbORVEU"
    "pmlqjTGyU8RxLPPz83PACOB2AibSNLW1Wk3q9Xor1tbWpFKpyMrKihhjpFQqycLCwjaIA0wY"
    "YySKIkmSRKIokiiKpFqtShiGEgSBGGOk0WhIrVaTYrE4B4w4WwDj62FlMduzt2UpyzJEBGMM"
    "SZKQz+f/say1nmxZmNiX647v3SG5eAGlFOvTl7G3buA06iil8H2fMAwpl8sEQdCCuABLo4MH"
    "3p4tzIoR6NYbeBAU5uEMbr2K1hrf9/E8j1wu1wYEY4NTPSfPLPWOjhUwf+h68hwA/9lTpFYh"
    "S4X0+hXsx/dordFa43leG5AbPl10TxzvMstL1rs9g9t/pJk4NIA/c5dsdRkZGsS+eY0rFqUU"
    "Wus2oBF8vmq+f43VQL9qzD7Crv5qfuDvEtGLxzh9eWzpB+rSNI72UUrhuu0VcAC+jPcc1Pmh"
    "D33HCgXrJeRfvqN67TyQw/ZCz/05nO79rclsTKA9hVOfquWpxW83Ta+LxHGzMI6azQ9etZoB"
    "XNfd7mBzD4wxi3RIRDqfmg2Og9Z6UncUi+M4TmfhThKRDNq7LEBmrY02E7tJRDJrbQOwW/FH"
    "aZ7ztiv7jywQ/AV5byMoN5vASQAAAABJRU5ErkJggg==")
index.append('page_white_code_red')
catalog['page_white_code_red'] = page_white_code_red

#----------------------------------------------------------------------
page_white_coldfusion = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAg9J"
    "REFUOI19k79rU1EUxz/3/WhCa6t1aATbUlCsCi4VqyLqIDiKg/oP6Kazg5vgXqRWKI7OUiji"
    "P+CiUhehBemkDm1S0iT05b0k7973dYhN0qT2CwcOHM73fs8932PoYhIoAD5HowT8BrL+wuUk"
    "SaqtVstZa3VYNBoNLS4uvgZmAK+fYL7VarkoilSv1ztRq9VUqVRULBZlrdXW1paWlpYGSAww"
    "b61VkiRqNptKkkRJkmhvb0/ValWlUknWWsVxrCiKtLy8/BqYMT0EV6y1X51zHUlZliGJzbpY"
    "KQeUsyEWznXrQRBcDfrn8DwPY0wn34jEm+2A2Bl8xO7uLtZaJiYm2iT9BPvN+/mHHZ/IGi4O"
    "Ox6cbBAGIb7fXVQA8HAtniqvr91fLRuGDNwZF6GB9ciwGRkkOJ2D8ZxPYISkLsGjDc0Ni0+j"
    "czcLq0VwghtjjjCAjzuGpgOXwcq2z0xeXBsTvQhCxwKiUK1HP2+dGpnNezAawE4LftQMLoO5"
    "4yIAJvPC9/2DCnBcssCfb5/fP3t69xVAJYW3vzzqKZwdFi/OuE5Tlh1UYO5917s8PElT1zyR"
    "83MZEKdQt5Dz4OWs4/zIgGvxPK+9RhfzPBpi2he3K832H2SCQk48nhYXjumfTQ7HASOlafrF"
    "9O7xCEjKwjC8vu9lAZlzLpE0qPeQZudcDLje16Zon/PAlf0HDij9BRUMLxMfO8o5AAAAAElF"
    "TkSuQmCC")
index.append('page_white_coldfusion')
catalog['page_white_coldfusion'] = page_white_coldfusion

#----------------------------------------------------------------------
page_white_compressed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmJJ"
    "REFUOI19k09LVFEYxn/nnuN4Z3QMR5tRNBWMQiSMrFy4EWqV0NYWrbMPUNB3KIgSV7UqpF3Q"
    "wlokpRFSEQxuhGoRSP43nHFmnOude87bQhlHix54OXAO5/c+vH8Uh+oEMoDm/9oAlgB3/GGw"
    "XC7nwjC0URTJvyIIApmYmHgE9ADeccDlMAxtsViUUqlUjXw+L9vb27K+vi5RFMnq6qpMTk5W"
    "Ier9k94RnWx+lTPXmla2uqir03gegMMYj729gN7e0/T3D5BKpQjDEOccU1NTj8fHxx+qDy8G"
    "f6XPpTs+fhqgWEwACgTEeSidwDkHRIyN3SSTyRyxbIwZMo1NiVRHTwdj3WvUmSSVaAlV2WNh"
    "FrqHnvL6zTTOVojHfXK5HM45oiginU7vQ5RSEpTzLC/PV8nd7X2IGAD8eIxiPkRrgzEKay1a"
    "HzbKiDgSCZ/OjrMAKLVLzDMg4JwQRQ6HQ2uN53kopRCRQ4BSitLuJivL36qXXW0WVAsiDsQi"
    "zuF53pHMVQDW1sXjzWTaesCV0cbim4YDBw5cBcShlAJAa33UQWk79/zHrNxQCk+8E76zFXZL"
    "AWuFdkrfF4nF6tnZKVaz73elxsGKv3grsdR15+6D3xem32ZnXk6/w0Z7xI3lZzZLY2OMqFJh"
    "eSNPvKGJVMPRAVQ156XV9a3P92diJNli9MwmX7/MsZCdR7ecJ9Z3m5akx73rzQfFVvtzUEuz"
    "XlwKhYJKNChaW09y5eoow8Mj7ASaZ9mIZL2u1kJEXK0DgItBEMxprX2l1F+LUisRcdbaXd/3"
    "R2oBp9hf5/9+rjUMbPwBBCEnpG2JUEEAAAAASUVORK5CYII=")
index.append('page_white_compressed')
catalog['page_white_compressed'] = page_white_compressed

#----------------------------------------------------------------------
page_white_copy = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAUZJ"
    "REFUOI2FkbFuwjAURY8dCzYGBrpVzOyFD0IMLPxKVTGw9Vv4Cfa2EwoSCKhCgh99HYqjkFjp"
    "laJYefbxvTcGeAaeAENTKfAF/ERmpV6KoihERKtPnue6XC7fgCFg2wBjEdHL5aLn81kPh4Om"
    "aaoiolmW6Wq1CpB2QJ7nmmWZnk4n3e12pRPvvQKTuwtTj+rCIkmS8t3tdtlsNmy3W3q9HsDo"
    "vk1j3YyrtwUn6/Var9er/tdN6QDAGFM6sdZircV7j4ggInjv6ff7TKfThXOO+Xz+2mjXGIMx"
    "BmvtAzRJEoz5i9/pdJjNZgtgEP09ARI6sdaW3RyPR/b7fbNEAFV9gNRjBbCIxAHhUGxdjVCd"
    "OSB1zk3qKYCRiLzXY1VBAfABfEYADVV7qUfQyP7yW6ybOqBV9UMAIvIN3KJW7xoCg5b5DUh/"
    "AcrsxXEO/RaWAAAAAElFTkSuQmCC")
index.append('page_white_copy')
catalog['page_white_copy'] = page_white_copy

#----------------------------------------------------------------------
page_white_cplusplus = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkJJ"
    "REFUOI19k09IVFEUxn/3/XH8DzPFmKRgJiGEgUhOu/4RtizCEAKpRdC6TVEUBLWpNiIubB0t"
    "I6hNuGrRIjdJCEqEpBQ2Azmj82buvDf3vtPCHCc1Pzhw+c45H+fj3KPYRhfQAbjsjxywAsQ7"
    "E0Na60IURdYYI3tFpVKRycnJCaAHcHYKDEdRZIMgkFKpVIv19XXJ5/OSzWbFGCOrq6syNTW1"
    "S0QBw8YY0VpLGIaitRattRSLRSkUCpLL5cQYI+VyWYIgkOnp6QmgRwFcevr1qM6uPBw5MzAO"
    "QmerS+8hnxM9CUQEYwxhGJJMJv8Z2fO8jBp9/m1o4EjrTKrVS7pxjLWCtkIcCrcvH8Rai7UW"
    "YwzVapU4jjHGkE6n8Twv4zQ1NtzpaPeSb2fm39y8kOLWxQN0NjmsVSyFwPJ+LsB1XVAuHxYN"
    "vu+TSCRqUzj9hxOjQcWS/b4wu0WOnUuR6U5gY/i8VMZ1XUS5fFkJ8TwP3/e3bVgTE4oi2sgX"
    "6/0tb0TMvvsFwINXP2v8k9e/uX42SV/z3wl+rFWXHKChva+/XiAsxFzNpGj0HR5f6+L+aCeN"
    "vuLRWCc96ToLC/PBi7AaM3h6aHxxWVMsWZ69XGW5ZEGEwd5mRARHUXvXQwFkbszdPTbQci/Z"
    "lmjTUYypxoz0t3DlfApgVxOA4ziba6wTOvlxLv9JBE4NtNUK92oGUErheV7GqyeHj7eKUkrt"
    "LNwLIhLD9l8WILbW6q3EfhCR2FpbBmy9fDeb57zryv4DC+T+AK9uO46JFb+OAAAAAElFTkSu"
    "QmCC")
index.append('page_white_cplusplus')
catalog['page_white_cplusplus'] = page_white_cplusplus

#----------------------------------------------------------------------
page_white_csharp = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn1J"
    "REFUOI19k8trU1EQxn8nuUmbVKPRqsVnbeujFK1amwoiIuLChSCCO/EfEFwJgoK4EnyAaC1Y"
    "QReibkRxIyguCoqirgTxjUVFSZOquWke596bc+64CNZYHx8MB87MfHNmzjeKX1gIzAOi/B95"
    "4BMQTnX0aa3dIAisMUb+Zp7nyeDg4BmgHYhMJcgEQWDL5bJUKpVJKxaLUigUJJfLiTFGstms"
    "DA0N/UGigIwxRrTW4vu+aK1Fay2lUklc15V8Pi/GGKlWq1Iul2V4ePgM0K4Adp542+kVPh/Z"
    "sWXV3ihC67Qo7XNi9CyMISIYYzh5e4LuOXHWdCW5NFJg//bZLG5LDji7T33sW7+s+V5ranYa"
    "EUKB8YrwpeDR257AWsuHnCVChN4lwp1HeWo+zG+NA+DMSqmDbelY+tbI61vXD2d2Atx8XGS0"
    "HJJ3DRdHClT9kBnJKFcfaIpBlNCGnLqaBSDSszixW/tC9v2Lpz8HsmvDDHra4ox9r9Ex06Gl"
    "KUKtYkjFIkxLRlndGqW3M1EnCEOhFob4ZbfU+CXb+1Mk4hFa4grtQ6YrgVhw3YDujgQDq6bX"
    "WxgvmtEFs2IdLemulY0Ep2/k+OqB40AYCndfaaJKEYjiyv0Jzq9N11/w7E31QlATMpvW7X33"
    "xaOkLWdv1pP3bEwx7tZY2xZj2/JmvpUMx/fM5dy+BZOFnNtHu477B16q7hWJQ9ceTuDVQrxA"
    "2Ly0iVejVawVtmZSHLs8xtJmxczpsd/UpxrO/sfPi08E6O9umQwQkamKrScoheM4A07jZd/K"
    "pCil1NTAv0FEQvilZQFCa63+6fgfRCS01lYB20i/iPo6/7Fl/4AF8j8ANVBP2Bp3KbwAAAAA"
    "SUVORK5CYII=")
index.append('page_white_csharp')
catalog['page_white_csharp'] = page_white_csharp

#----------------------------------------------------------------------
page_white_cup = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlBJ"
    "REFUOI2Nk81rE0EYxn+zmS27Wdhkt7SWUEtKEC0kRRAtohREvOlB8Z5jb/4RvUsrpTdPQr1K"
    "rh6EQgUv3lrIJRfBhE1TYjRN0uzMjofa7afiA+9pnvm9z3y8glPNAteADP9WG/gGJBcX7gyH"
    "wx/j8VgrpcxVNRqNzMbGxhugCFgXAffG47Hu9/vm8PAwrV6vZ7rdromiyCilTKvVMpubmylE"
    "Amxtbd1qtVov9/b2LGMMxhiS5Dih1ppcLofneQDkcjmq1eorKSUrKytrolarvQjD8HWhUCie"
    "mIQQnAV1Oh06nQ7lcpnJyck0spRySfq+v1apVOYanz/y6cM7hr0uOh4DYDtZsvmQm4+eUlp6"
    "zO7uLpVKBaUU09PTx5ButztnWRY3Hz7hZ9TkV7tJu1FHCIHj5wlm5wlm58lms4xGI2zbJpM5"
    "fSjped7AcZxskiTcfl5lYmKCo6Oj1BDHMUop4jjGtm2klBhjTgGu6363LOtGFEXU63UWFhbS"
    "8yul6Pf7BEFAr9ejUCic6w5gDQaDSCnF/v4+nuehtUZrTRzHaRLXdWk0GuTzeTKZDJZ1+gXk"
    "9vb2+6mpqbLv+3kA27YxxqQm3/dpNpuEYUgQBOfiA2R2dnbqWuuvUsoHMzMz+TAMkVIipSRJ"
    "EqIo4uDggMXFRVzXRQiR1urq6lvxBySWl5efra+v16IoAiBJEuI4plQqUSwWcRznXGchBFLK"
    "pRQA3I3j+IsQQvAfMsYktm3fP7kNAyRa66Ex5tKUXbVZaz0A9Nlu1zke50tT9hdpoP0bPJws"
    "iql3k2IAAAAASUVORK5CYII=")
index.append('page_white_cup')
catalog['page_white_cup'] = page_white_cup

#----------------------------------------------------------------------
page_white_database = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAglJ"
    "REFUOI19U01rGzEQfRpJuyY2BjtgG9IFH+1CT20acsp/qH+Ef0iPPpQ25Cf41vR3FFzoKZCT"
    "Dz3ErLfYa/DXaiVND8VrJ07yYBBo3rx5SDMCe7wB0AQg8TqmAP4A8E8T7zebTWqMcdZafi62"
    "2y1fX19/BdAGQE8FPhpj3HK55NVqVcRiseD5fM5xHLO1lieTCd/c3BQiYjAYND6cX/z+m8St"
    "Wq1G1lqEYYh6vY6zszOEYQjnHIwxqNfrMMbAe4/hcPit3+9/Ed9vb3+97XajZrPZqFQqICKs"
    "VivEcYzxeIyrqytYa5FlGWq12iPLSqkLyr1R7XZbhWFYJIIgQBRFWCwWICJIKREEAdI0xWw2"
    "w3Q63YtYb4W1liaTCcrlMrz3eHh4QLfbhXMOUu4/RQhxdEclKmmttSQilMtlzGYzlEolVKtV"
    "OOcghICUElJKKKWglILWeu/AOS/TNFXGGABAnudF0lpbdCYiCCGOhkIJIbY78u61d8SdwE6E"
    "mSGlBDPvBQAGESEIAqzXa2itC4tZlhVkZoYQAt4/HkBKkuTH/f09Tk9PUa1W0el0EEURRqMR"
    "Tk5OiuKigAhE+yFUSZJ8Ho/H4u7u7lOj0XiX5zmYGa1WC71er7D/EsTBeZ7n+U/xGvsAzOy1"
    "1pc7LwzAO+c2zHy0Zc8VO+fWANxhtwj/1/loy16AAzD9B2sWFb/E8T1gAAAAAElFTkSuQmCC")
index.append('page_white_database')
catalog['page_white_database'] = page_white_database

#----------------------------------------------------------------------
page_white_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeJJ"
    "REFUOI2Nk7+LE1EQxz9vdz1zZyFBjHegmFM7G0GNpZ2FIJxgY6FX2IgiiI2t/8IRI6YQtBYU"
    "/FGojSgnBBu1UEQUTuTWRDSbZJOXXd/bsTg3JhtzOjAw84b5vO+bxyjWbDuwDXBZ3xrAZyDJ"
    "FvZrrYM4jq0xRv7m/X5fyuXyElAEnCygFMexDcNQut3uwFutljSbTanX62KMEd/3pVKpjEEU"
    "UDLGiNZaoigSrbVoraXT6UgQBNJoNMQYI71eT8IwlGq1mkJQv/2gMaZmrR1ISpIEEcEYQxRF"
    "5PP5Ecme5x0CXnrDh47joJQaxNZaXNdlamqKIAhIkgRjDIVC4Q9oGJA2p7HruiN5ChxRkp1m"
    "Fpg2KKVQSiEi/w9IG4eflrWx/5wE8R9UeX3+AC+ObWb59G6ultTiugqGpa7ev067dpt9J86w"
    "cX4v+s1jcs+enH008+79PxWICCt3lthzeIHcx6eoWyeZ+XSXXcUtjrhycaKCdGBKKWJ/hdzs"
    "PBy9NKh7V+ZwRRUHABERlZlUmnqFOXqvHrLp3jki/ZUe0Gm7WJdVBxAgsdZqERnbMoCdCxd4"
    "W1vG70/TdjfQ/KH48EUlInItvXEHa+s8cSY3jhQWt5rvx6dRs33kW/CTm6ee28u/AJplBbjt"
    "xWEdAAAAAElFTkSuQmCC")
index.append('page_white_delete')
catalog['page_white_delete'] = page_white_delete

#----------------------------------------------------------------------
page_white_dvd = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI19k8FOU1EQhr9z77mXXrAoGkKCVqANiZoaFkYIwQ36Dq55C2JcsPIBTGXv2p2RhAdg"
    "o4kl6EJdEIyEpOkttNS2QO8954wLAgWL/smsJvPPN5MZRU93gDHA5/+KgV3A/Z14dHx8fJgk"
    "iTXGyFVxcnIipVLpNTAJeH8bzCZJYtvttnQ6nfNoNpvSaDSkWq2KMUYqlYqsrq6em5zhqlKp"
    "tDQ6OvqsUqkQxzHNZhOlFFEUISI454iiiCAImJmZmZuYmPDW1ta+KxHxtra2XhljlguFgjLG"
    "EEURSZJQLpcZHx8nl8uRJAkjIyOXkLXWc97m5uZzY8xysVhUURRRq9UQEYaHh1lcXGRnZ4da"
    "rUYYhhweHlKv14nj+NzEc84t5fN5tb29TbfbZWpqCq01zp0ueXZ2lr29PbTWhGFIEAQMDAz0"
    "KIwxD5IkIU1TQi2sr6+TzWZZWFhg/6BBVzRxy+L7PkoplFKISM/AWoN0ygy6GNvaJxoUMpkM"
    "tZZhr56SyXgY6/A8D6VU31FoY+w3PTSdGx66zy9XZ/xhlhvhLULXJfDBOce1KDjv7Pv+JQLP"
    "GPP205cfUpc6R90jOu02u7WfNH5XmRzL8nWrzPTkbUSkDx/A29jYeHdij96UNz9Lmqb4vkZr"
    "TcsdsPbhPcX8GPnJu70Cz8Pzekd4NpR6ufJi5cnT+ZX9ZoxzjuuDN7k3UaSQL/TNDaCUQms9"
    "py4YPU7T9KO6alNXSERcEATzZywCOGvtsYj0fdlVxdbaI8Be7Jbj9J37vuwfskD8B2VDQAwN"
    "5x98AAAAAElFTkSuQmCC")
index.append('page_white_dvd')
catalog['page_white_dvd'] = page_white_dvd

#----------------------------------------------------------------------
page_white_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAh1J"
    "REFUOI19k8tPk0EUxX8zH7ThZSNFEBV5qMFH1BiDLpQVC2NMdKF7N8YV/4ULNy40RTGGaOJK"
    "ExcSDQkuMCZgcaGpaRqggEZ5g9ZSgX5Mv5lxAdQWKCeZ3MW952TO3DmCNRwAagCHnTEP/ATM"
    "5sbZdDqdVEppz/Psdsd1XRsKhR4ADYDcIIr1ek4pFVZKSSFEVtXzPIwxKKUIBoPMjrxmKfIK"
    "p/wky78+gDt1U6yLtHie9ymTySClxBiTFdBao5SiRA2wFB+kpKqVQOMZkt/DDPV2zRXl+pBS"
    "ZqsxBsdxsNZi/vSR0SNUHrlAYnwIn1BU7NpLefBgYIvAhgUpJVprzOIgvkyMQNMlVmde4CsV"
    "/IgM466sLi6vpM7nCeT6F0Kgfg9gku8JHL6KO/UY6fMoLq+nzE7ysDva3tEzFpcUwNzwG5an"
    "362TO5HFGVSqgYX+rwTb7tDRMxYndx155JEeUtNhqk9cQc124fgsq6l6Fvq/sOdaCH/N0exs"
    "0WbyaPgl5m8MT+xjJhpid7UPN1FH8vMwtdcf4VTU5s1vuUH041OOX7yNf6KfePcAkd4E8b4I"
    "1ZfvbiFvKzD6bQEVe0vj6VbKypqZi47TfOMe/qompJTZVRe0EBub5/6TTlqONVJx6BRtt55R"
    "Wrl/u6fKF7DWWiGEeN47WXA4Z3YjTFYCFjBa63ROY0ey1noF0PA/THWsxbngv9gEzVq0J/4B"
    "2vwDCNX+vIkAAAAASUVORK5CYII=")
index.append('page_white_edit')
catalog['page_white_edit'] = page_white_edit

#----------------------------------------------------------------------
page_white_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhlJ"
    "REFUOI2Nk81LVFEYxn/3nlFHTXMyjcC0Fmm5SbGMdv0HfdGi/oyWbaJdS0NmYZsiaJVEGEEU"
    "BLkozLIQIrPAlGqaIZs7zp177r2ce94WNpMflb7wwHPew/vj4bwch9XqAvYAiv9XAVgC7MaL"
    "Ia21F8dxYoyRvykMQxkdHb0O7AfcjYDhOI4T3/elUqnUVCqVpFgsSj6fF2OM5HI5yWazmyAO"
    "MGyMEa21RFEkWmvRWku5XBbP86RQKIgxRoIgEN/3ZWxsrArB+a1jxpipJElqkay1iAjGGKIo"
    "IpPJrIucSqWOA9OptU3XdXEcp+aTJEEpRX19PZ7nYa3FGENnZ+efmbWA6nDVK6VQSpGszBJ8"
    "GkE5IQ0NDeuSbHrNjUBHYsqL92luP0KUe0JdXd32AQDlpUc0tQ/SuneQ8uJTksri9gGx/4Wf"
    "Hx/QsruNZGWCjv6LFOfuItZsDRBrWX4/zq6DpyCc4eXtO+xo05QWnrOy9GJrQCX/BhMUackE"
    "2GgBxJL40xw4eYmvUzfo62lu+idArOH7zE3augewwSxiNUPn+rDxN9LpeXZ2neDy2e4L6wAi"
    "IlW/PPeQxkwvTS0/ELMMjuL1vXnAYsN5Onp76Gp1z09e6T9cXfzRMAyfKaXSjuO4s7fOcOj0"
    "CMr9jJgiIGvyuajGPvLv3vJh4up4FbCP1e/sAkxeG3hMQlqsINauSizUzoJYK47Iq1+isjmh"
    "5HpvTgAAAABJRU5ErkJggg==")
index.append('page_white_error')
catalog['page_white_error'] = page_white_error

#----------------------------------------------------------------------
page_white_excel = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiVJ"
    "REFUOI2Fk09I1EEcxT+/f6tErrrIbtsfyQ7VJYrChaKDRBFE4bEIrykdAi9BdpWoDhEpElHX"
    "FToEhRe7FRQFdRCMEKkOYohr5lq7/n47v5n5dgh3dbV88JjDzLzhO+89hxp2AxnA4/8oADOA"
    "rd84FoZhUSlltNayGaMokuHh4QfAXsCtF8gppUypVJJyuVzl8vKyLC0tyfz8vGitZW5uTkZG"
    "RqoiTv94t6wqWCuIsVgrWCMYbbHGYrTl7tlRUqkUSimsteTz+aG+vr779I93y1boedwlCwsL"
    "G0YCcv7iTImrDy+xI5siUmUa4jZeTY/R0pTCEZfFXz/IZjIkEgmKxSLWWrTWpNNpAPztbQ2c"
    "aD1FS7KZODuDFFppSAT8lp/MFma5ffkRN0Z78X0fx3EwxuB5NaPcuKLp6erl07cJSlNNzMoU"
    "jckE7ybecv3CIAd3HUKFGs/z8H0f3/cJgqAmoCLD1PdJXk6+4PmHPO2Vo6w0lckdPsnT10+I"
    "4pA4inFdF8/zqkJVgbAccfHeadLNGcQXhsYG2Rl1kO1oh2Qjd54NoCKD4zgAeJ6H69Yi4OuK"
    "4dq5AZLbmjFGsy9zgI/Tb/jy9TPK1bixJa5oRATHcbC2LoDnb+W2tLHzyn5RSq1j1UYVac7c"
    "PILR64NjjawL1uoI9XDWrJ1xHL93/nWyDiJigyA4vvobAlhjTCgiG1q22WVjzApg1r62h791"
    "3tCyf8AAhT+tPJZK1IqO0gAAAABJRU5ErkJggg==")
index.append('page_white_excel')
catalog['page_white_excel'] = page_white_excel

#----------------------------------------------------------------------
page_white_find = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmFJ"
    "REFUOI19kztMk1EUx3/fo18fQtEoqAlSCCAYB2KMshnjoAEfbG5OGOLkqgOTA3E1hM1EYdEF"
    "jQZiiQmDcTExPoiiJUql1L6Atp99fKV+97sOSKEV+Scndzjn/s85/3v/CltoBg4CGrsjBUQA"
    "pzZx0rKsbLlcFrZty52iVCrJ0dHRe0AroNYSnC6XyyKfz8tCoVAJ0zRlJpORyWRS2rYt4/G4"
    "HBsbq5BoALdHRvZ3dZ/4HHw5q3d0djJ85y7B4AyX+i8gpURKieM4eL1eXC4XPT09vYFAQJ2a"
    "mvqiDg3davAY+4ZbO7qNSPg7OTNLIvaTw62d3H8wjuM4qKqKoigAGIaBx+NhcHDwJtCkNh5t"
    "8c/Pvbu+mkySK5SYefWWdaGyLlQmn70gmzXRNA3DMMhms6TTaVKpVGVvNTj5+IZVLNa1dR+n"
    "qTlAYtXE76/nQOMhfL49jE9MoGkauq5jGAYulwu3210hUK5eG8qourY3m16D3xbnzp7h6fNp"
    "NMPAKlpYuQwfP7xHCIHjOAghkFLi8/nQdb1Xr/M3eC9fGWBxaZmVSIi+/j4+LSxx/uIA8eQK"
    "r2cmURSlSoft0IWw3bYQhObnyK0liUajSFVFUVXC374SDv/YGFVRkFKiaRpSyi0NCrlfRKIx"
    "SpZFZHmZfC6PmUmzEAqxmkqQSiYqT7lJUjVBNLK48OTRQ8xM2nOsq6Ol3l/PSmyJ2ekYllWg"
    "vb2tuqNa/QGVbecp27bf1O5Y27FyUVE2RKwplkqNUjsJ97fWgS1DSMARQlibid0gpXSEEEVA"
    "bKc/woad/3HZfyCA1B8aXkVeFPKU0wAAAABJRU5ErkJggg==")
index.append('page_white_find')
catalog['page_white_find'] = page_white_find

#----------------------------------------------------------------------
page_white_flash = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAglJ"
    "REFUOI19k01LlUEUx3/zzNzbLcEXiquQlkSJcBe9WS0rWgR+CRcRbsJdrqK+QCBmdxPttKgP"
    "ULsMwSA3FdgiiFxEYlcor3Wv93mZmdNCfXyea/iHwyxm/r9zZs4ZxZ76gV5Ac7DWge+Ab9+4"
    "2Gq16nEcO2ut/C/CMJSZmZlpYBAI2gGX4zh2jUZDms1mGpubm7KxsSG1Wk2stbK2tibVajWF"
    "mB2zAgiCINBaEwQB/sNHWFjAxAnJxB2UUgB0dXUxNjY2YYxhfHx8SmUAl6y1S845WFzEz85R"
    "OH2c6N0n3MvnRFFET09PrmRjzBVDm9SPVdyTp5gTvcTLK1CpoLWmWCxSr9fx3mOtpVwub0Ny"
    "bhH83DPMmQESayg8nobubpxz23ClcM6h9V6jcgD5toJ8/UL0+w+FybugDUqp1KCUQimFiKSe"
    "XCvcq9eY/j5KIxWie/eJH1VTYxAEaK3RWmOM2Q94MDQ0ZN/MA8LW/BLiJMtOu7DbpdwValdH"
    "e61vTRaHB2m9X+bQ1ENUxxHo7EzLFRGUUnifH0DTuDm6KFHS5zwn/d8m+sZ19PmzqSm7Arns"
    "AIGE0TmfJKcOXxg20eovirdv7St79/GykVYgie0gsfx8u/S578VsRR07qrIZsoezEhEPOyO8"
    "o5EwDBe01iWl1L6P0m52zm2VSqVrWcAA29/5QHNGDlj/B13r9mbysZO2AAAAAElFTkSuQmCC")
index.append('page_white_flash')
catalog['page_white_flash'] = page_white_flash

#----------------------------------------------------------------------
page_white_freehand = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkVJ"
    "REFUOI19k7FrU1EUxn/3vdeYNpKSFFopDaYqKLgUbBsHKQ6Ki4Pi7CQiCi4dHEQdFRSEUjr0"
    "b7BDodhFHIRSaVEnxXYytNSYFJqX8JKXvtx7j0NKmqbiB990ub97znfuURxqBBgCXP6vErAF"
    "2O6DS2EY+lEUGa21/MuNRkNmZ2dngCzgdAMmoygyQRBIrVZru1KpSLlclmKxKFprKRQKMjc3"
    "dwyigEmttYRhKPv7+/K9WpX7+bxc39yQQrkspVJJtNZSr9clCAKZn5+fAbKqAzChtV4zxrBQ"
    "rTJd/MNu1CTtKH6MjuJETVKp1JGSPc/Led19bDSbPC78xteaXLyXR+k0va6HxBS+72OtRWvN"
    "4OBgC9INeFUq4jebTCUSLJ89Rw9gjMEohVIKYwyuezioFmB9/SJLS2OLlQrvfR/HWh4MDLAW"
    "BDSspQe4kkigDiAi0gYoAPXty4IS7mAtiHC5L8HUyQSvd3ZAhKTjUBqfQEQwxgAQi8XwPC/n"
    "AKim+UzZ/4q1YAy3+vtJOi5nYjGwlgHXRalW3q7r4jiHX8ABsLncW9n8uYy1xIHb6RRPhofb"
    "gGvJfkTkWPmtDEQcd2XlhljzEGO4N3SK7Ik4L7e3+Li3hwfcPUgcOPI6gKdWVxdFcRPXVRN9"
    "fTzPZHiW/8Wb7S0QYXokQy6Z7B7WIVCJHUOkJrvFD+/OX5C055EPQ1KOx9PMaV5kR9vpd1pE"
    "bHsKBxpvNBqfXNeNK6WOLUqnRMQaY+rxePxqJyBDa53/e7lDBij9BVcmMrQyLWX2AAAAAElF"
    "TkSuQmCC")
index.append('page_white_freehand')
catalog['page_white_freehand'] = page_white_freehand

#----------------------------------------------------------------------
page_white_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI19kz9LI0EYxn/ZXVaUS2FhIpiDVCIWghzRL3Hch/ADWFidn8BK5BALLcTCzu6IYGVh"
    "IRcP7AKCoHLRqGvEDbvZf8zMe4WXXIyXe+CFYYb3xzPPzJvjVSWgCNj8Xx7wCzCDB5/iOPaz"
    "LNNKKflXJUkim5ub34AyYA0CFrIs02EYSqfT6VW73ZaXlxd5fHwUpZTc39/L1tbWO0gOWFBK"
    "SRzHkqapxHEscRxLEATi+754nidKKYmiSMIwlO3t7S6E3J+qKKVqWuueJWMMIoJSijRNGR8f"
    "f2PZcZxF4KfTv2lZFrlcrrfWWmPbNq7r4vs+xhiUUhQKhb89/YBuc3dt2za2beM4Dufn55yd"
    "nTEyMvLGybs0+3V7e8vp6SmdTgfXdRkbGyMIAg4PD9nY2Pj6LoNBwPHxMeVymbu7O4rFIpZl"
    "cXNzQ6lUolqt8vT09MEZbOpXqVQiSRJarRYnJyeMjo4yOztLFEWkaVpdX1+Phl7h6OiIMAwp"
    "FApcXl6yurrK8vIyzWaTyclJKpXK57W1NTMU0G63eX5+Jk3TXurdVwqCgEajwdXV1fAMsiyj"
    "Xq9jjCEMQ66vrzHGMDU1RT6fZ3d397vWeqnnQESkH+C6LvV6HYCHhwfm5uaYmZmh1WphWRb5"
    "fP5LkiS+BQhgtNaxiLyZsomJCfb29pifn+fi4oJarcb09LTs7OzQbDZ/HBwc6O7P+cjrOA/N"
    "ZGVlpeZ5Hvv7+4uA5nW0G78B2ClKz+gytQIAAAAASUVORK5CYII=")
index.append('page_white_gear')
catalog['page_white_gear'] = page_white_gear

#----------------------------------------------------------------------
page_white_get = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcdJ"
    "REFUOI2Nk79uE0EQh7/1WUYIClxgKEhEAbwASqDgBSh5DDqUBkEDNKQCgSwXpuAdkGjTgUQU"
    "hEKDwFEklIT4T+OzfPbe7c3eUJhz7HOM8pNGmt3VfPrNrMYw0TXgChDwf/WAAyArPty21obO"
    "OS8ielrEcaz1ev0tcB0oFQHrzjkfRZGORqNpDAYD7ff72u12VUS03W5ro9FYgBhgXUTUWqtJ"
    "kqi1Vq21OhwONQxD7fV6KiI6Ho81iiJtNps5BPMv1kRk23s/tZRlGaqKiJAkCdVqdc5yuVy+"
    "A+yUZy9LpRLGmGnuvScIAiqVCmEYkmUZIkKtVjsBzQLy4jwPgmDunAPnnBSnWQTmBcYYjDGo"
    "6tkBeeFsa0Ut/OcyCMCbb5u83nl5NgezVlWVzS/PEJ8iacrjj49O4Mx842kA8SkvPj0lwHCj"
    "dhPnU3b3dvm59+vgsNO7tbSF3Hb96yu6/TZxnBCLI5aEc5XzpEl69dKFix+mLaiqmsKkjDFs"
    "3H0CwIN391m5vIrzjtZ+i9+f/zw82jp+XwIUyLz3VlUXtiyXHcVYmbjotDscbR1/z2cAsMJk"
    "nZe2dO/52naSpKRxinMpPxqtVeDwL30oGvlpwdX3AAAAAElFTkSuQmCC")
index.append('page_white_get')
catalog['page_white_get'] = page_white_get

#----------------------------------------------------------------------
page_white_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgdJ"
    "REFUOI19k79rU1EUxz95LxTFIkRLWzQVLTpUEYRqK0gHLTo56F/QWR0FF8FZwUVKwY4duzk4"
    "OCmFqJSiYsGpg7SRhqZKEvOS+959597jUBOT2PTAgXN/nM899577zbBneWAECDnYysAW4HsX"
    "Jo0xVWutExHdz+M41vn5+RfAaSDoBUxZa10URdpoNNpeq9W0Uqnozs6OioiWSiVdWFj4D5IB"
    "pkREjTGaJIkaY9QYo/V6XavVqpbLZRURbTabGkWRLi4utiBk/voVEVl1zrVL8t6jqogISZKQ"
    "y+W6Ss5ms9PAWrZzMggCMplMO3bOEYYhAwMDVKtVvPeICMPDw/9AnYBWcisOw7Br3AJ2Hdr7"
    "mr3AMAwJw5Anr2/z6NUNCLo7eCCgBQmCgMSl5IcmuL88g5V4/yt02sPl66gK1gtWhBO5s0yM"
    "TlOPG9x5eY7BfPZw9EP6A8Rbbl6Yw6nHeYdH2a4VuZi/RmQNlQcrb20sx/sCYrE49Wz+2iD1"
    "gviU1KX8TupcGpshSpvB6vfCzwMAMeKEkaOnEO9w6inVtjg2OMrn4nsKG4WKFWbbAFXVTEcf"
    "jSQsfXyO9ZZYLOND57k6fou1zQLr2+vsvuNe4wNfWvsvx3HcSNO0r5gmnx7RuaVZnXp2Ur8V"
    "vzaASdj7xgBj7Mm5b1vPPGbFER7afePumk8U2ZN28Q8jylaeuHmUQAAAAABJRU5ErkJggg==")
index.append('page_white_go')
catalog['page_white_go'] = page_white_go

#----------------------------------------------------------------------
page_white_h = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgNJ"
    "REFUOI19kz1vE0EQhp/dvbMFQbhBiRSBhGhoEAUII+gQHx0NBTUdTf4CPQVCQkkkolDQ0FFR"
    "WbQQBAVlaNIFESu2wBf7fJfc7c5QOD5iO+GVRrur3XlmZnfH8E/ngQXA8X91gG1Apjeu53me"
    "FEURvPd6nO3v7+vy8vIr4CJgpwHNoihCmqY6HA4r29vb016vp7u7u+q913a7raurqzMQAzS9"
    "95rnuR4cHGie55rnuQ4GA02SRDudjnrvNcsyTdNU19bWxpAR4MHSylJrM9W3XxLdag8rSJZl"
    "2u/3tdvtzpQENKMxwZfCr57HWUNWGpxzWGsJIeCco1arkSQJIoL3nvn5+Sr18Xjjzefet8ga"
    "zsYgoqjAvSunORUrIYTKRIRGo0EURTcnbtJ7xRnYGQS2uiU7g8C7T32cczjniKKIKIqI47jy"
    "iY4CilIpy8DVxZi5ep2PmxneB4wxWGsxxjCtCYD3gijM1SwqShkUKQ9rNAZVxTmHqlY+9vHK"
    "9vMXra40n6zfLbzgA6iO6g9BEZXRWrWCTGRQr7lLFli4fO2+iEFEeP99QAhKPTaIMXzYSHh4"
    "uzGKaCc/YPTnt3/a+jlc/9F6eebZo9d3kMMMAHQ0XzwXH1v/zDOWZfnVnHRySqoqcRzfGuej"
    "gIQQclWd6bLjnEMIGRCORrvAqJ1nuuwEBaDzFzRiZXyu/dYNAAAAAElFTkSuQmCC")
index.append('page_white_h')
catalog['page_white_h'] = page_white_h

#----------------------------------------------------------------------
page_white_horizontal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATJJ"
    "REFUOI2Vk0FuwjAQRd+Mg8SWTbuq1DtUohfhFki9SlWx4Ey9RlmlG5BCRAB7pgsal4QI6Eje"
    "fPs/z/fIQreE2+V9wxPwAIQ7zADfwBdgrfDSNE11PB5TjNFvreVy+QE8A9oCpq15v9/7brfz"
    "uq69rmuvqsrX67WXZemr1cpjjL7dbn2xWGRIASAimSYiebk7IkIIgdFoBICqMpvN3lSV+Xz+"
    "LsA0xvgJYGaY5WgAxBhJKXE4HJhMJh19PB6/Fv0Xam8OIWBmFEWByGk4m83mNAb3DLsAAIQQ"
    "cuvuf1NTVdy9o3UAbfa+FkLIADO7Djjf7EPMLENyV0OH+1309fP9C8C1GoIrgLvboOMKyH5z"
    "KGAppcaHwg8YVRURsZRSBaT2Mz3yzzhAAsrzQPd85bZytz9cVr3eZUgUYgAAAABJRU5ErkJg"
    "gg==")
index.append('page_white_horizontal')
catalog['page_white_horizontal'] = page_white_horizontal

#----------------------------------------------------------------------
page_white_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjNJ"
    "REFUOI19k89rE1EQxz+7bxuD4o9QGwtGEAqiKEiVVqoXUcSDh578A8SD2JsXj948FQQpVeIf"
    "oILVoy1FKoqX4kFFWxpKUWs1NAlm0+xms9v3djzEpjE1HRj48h7zmXkzbywalgEOAIrtrQAs"
    "A3H7xekgCNwoiozWWv7n9XpdxsbG7gOHAbsdMBhFkfE8T3zfb3qlUpFyuSyrq6uitZZ8Pi/j"
    "4+NbIBYwqLWWIAgkDEMJgkCCIJBqtSqu60qhUBCttdRqNfE8T7LZ7AYE668PaK1njTHNkuI4"
    "RkTQWhOGIalU6p+SHcc5A7x3Wg9t28ayrKY2xqCUIpFI4LoucRyjtSadTm+CWgEbwRtaqc2h"
    "WAhrH7NI8JVq5uJm0vZutgOVUiilCHITJJO/6D13jbA4xd2r6aEtPegEqsxPYMovSZ28hL+y"
    "hK7G/F78VF+c/Xzd6RTUamHxA939VzC1OZL7M9TNCpnz/cnYLz/oCBCRplY7D7Je/oatSli2"
    "T2JPCeo1vHyotq0gLM6zNvcIO7FOrOvYsQv2bmQ9Yu5xLvqSq9zoCPCXJqkuPKf71FkkmsYy"
    "VRamQ7rCEGVZPHuXvzM6U3zSBIiIWC1zrC1P0TN4gaj0EMfZS+6tIXlshL6BywjEo7f2vQbE"
    "AQSIjTGBUippWZYNYHc5WOonakcPCzM1dp0YoW9oGBGJjTE1wEBjhACHaKxz8188vX385tEj"
    "vcNeyQ9fvPk+dm8y/6rlhYbGav/4A1UePWPpcJMYAAAAAElFTkSuQmCC")
index.append('page_white_key')
catalog['page_white_key'] = page_white_key

#----------------------------------------------------------------------
page_white_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI19k89LVFEUxz/vvfveG0eH0dEmTc0JFE0IsZoCF2bQxjZRLgpauHDhqty2Kqh1WAyz"
    "bNEu+gciXISbSGghUSAFEYa/JmVmcsb3fHPfvS3K+WHZFw53cc/3cw/3nGNQUw9wHLD4v3LA"
    "KqAOX5zzPK8QBEEopdT/Ct/3dSaTeQqkAPMw4EIQBGGpVNLlcrkaxWJR5/N5vbW1paWUemNj"
    "Q2ez2SpE/DEbmUdD6dKXGVNJiQ4VKlQQKsJKAESxTt0H2onH40xPT98VQjA7OztvALx5cEnE"
    "znovBs+MT1n2MXRFoiuSMPDw8iuIrtvo1nHa2tobShZCXBQAQ5OqF+VM2k19yOJ7zMgoYbiD"
    "X/iM230Lp/MqUkoKhQJKKaSUJJNJAEz9cdgxYSbaPhIFC+VtouQ+xe8LuCdu0HJyCsuyEELg"
    "OA62beO6bq2Kzd3EqKHkrBsbQEsPrC6oVNBKUNldpfDpCSrw0GYL0b5riEgSrXUNYIQqE+lI"
    "d3g7KyipcKL9oATxzst42x8IKwE/15fpSD/EbkqgzcYxMVUoX5bX3j5eXlp8jjNA/utr5H6Z"
    "il8g2NuGphSp6wu0nr6JaUexLAvTrI2AUXemA7+4tPZqArc5hb+bo3X4DrH+KYBq2Uqpgw7U"
    "unCgH+/mEE4C7XTTM/kMw441mIGG1wGqgPm5rrGg+I3EyD2ae65UE7TWGIbBUaoCVteDXHIs"
    "q922wYbso8xaa1X/BwDnfd9ftCwrYhjGX4ty2ByG4V4kEpmoB/Tye53/a65TCOR+ARh3Gy8A"
    "hJ43AAAAAElFTkSuQmCC")
index.append('page_white_lightning')
catalog['page_white_lightning'] = page_white_lightning

#----------------------------------------------------------------------
page_white_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI2Nk0FLG0EUx3+TXUzAS/ZiArZYoeApCNa2IHoU9JCDFCFgv0LzMQoGL0U8ePToxZMe"
    "KniIYCT0JIQePBbNJqkhCdnN7mZn83qwSU0spX/4w5sZ3o/35s0oHvUCSAEG/1YD+AEMJg/e"
    "eJ7X7vf7kdZa/mbf92V/f/8L8AqITQLe9fv9yHEccV135E6nI61WS+r1umitxbZtOTg4eAZR"
    "wDuttXieJ0EQiOd54nmedLtdabfb0mg0RGstvV5PHMeRw8PDIQT122+11uUoikYlDQYDRASt"
    "NUEQYFnWWMmmab4HvplPN2OxGEqpURxFEYZhMDU1RbvdZjAYoLVmZmbmD+gpYJg8jA3DGFsP"
    "gWOVTN7mJHCYoJRCKYWI/D9gmPi0tUk9A/i+z9XVFZVKBcuyaDabbG1tkUwmOTo6wrIsWq0W"
    "29vbHxuNxvcxQBiGHB8f4zgOOzs7uK7L3d0dZ2dnJBIJstkshmFg2zamaX46Pz/3x8Z4eXnJ"
    "xcUFH3I5vp6eUiqVSKfTZDIZbNvm4eGBWq3GysoKa2trnJycdMae5M3NDdPT0wDk83nCMCSX"
    "y7G6usrm5iYbGxuEYUg+nwcgmUzGRy2IiKTTaVUulwHY29sjiiJ2d3dHUNd1EREKhYKsr6+r"
    "+/t73wQEGERR5C0tLSWKxWKsVCyyuLhIJpOhXq9ze3tLPB5nbm6OVCoFwPX1dbdardaGs3nJ"
    "43c25+fnXy8sLBRmZ2eT8XjcUEqpSqXy2fO8n8vLywXADIIgqlarzV6vl/0F2sJFKvxSsVQA"
    "AAAASUVORK5CYII=")
index.append('page_white_link')
catalog['page_white_link'] = page_white_link

#----------------------------------------------------------------------
page_white_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeRJ"
    "REFUOI2Nk8FqFEEQhr/emd1sFmJYghskEaIXDyoiavQgXsxNfAMfQzx69iohhzyAr6BeRRBU"
    "vEmiSA4quMmEZGczs9Mzs9VdHuJks1FXC36o7qY+/qruNhzGIjAPBEyOCPgG+JMH16y1cVmW"
    "TkT0T8rzXFdXV58CS0DtJGC5LEuXpqkOBoMj9ft97fV6urOzoyKi3W5X19bWfoMYYFlE1Fqr"
    "RVGotVattZokicZxrFEUqYholmWapqmur69XEMwv3RCRt865I0vee1QVEaEoCtrt9pjlMAxv"
    "Au/D45u1Wg1jzFHunCMIAhqNBnEc471HROh0OiPQcUBVXOVBEIytK+CYk5PTHAfC2y8Ru0lO"
    "WkwxVQ+ZnfasXGr+H+DNxg+SYZMr5+YI6wFRv6SXFLze2Bu1PQmwndY5P9+iVxi6Bw4xAQud"
    "GXaT0Tv6K0BVSW1Jo1FHnMd7JS89pYDoyPjEFlpTdcqhY+hAvB6CDWSDwb8dGGM4M1sjsY6Z"
    "6ZBWM+RUq053f4jufebJg6v3xhyoqprj9whcXmqztZ2x9T3FKyRZwXB7k9unIw6WLz58Nltu"
    "VgXX8zx/FQRB0xgzcbBfP7zU/Y8vmFu8YD69e55VgLMcfueJxVU8ur9wd+XOrceoa/4EuYQV"
    "tUlDNa8AAAAASUVORK5CYII=")
index.append('page_white_magnify')
catalog['page_white_magnify'] = page_white_magnify

#----------------------------------------------------------------------
page_white_medal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlVJ"
    "REFUOI19k71rFFEUxX/vvdnNZCQZk41JChWxCSp+QAJRsBARBCsbOyFFkKiBgIWKrYWIjWgK"
    "tfIfkNRaGBA0IKSwjphigyIbmd0N2Z3dmffetYiOqwQPnOZezrn3XLiKP9gPjAGG/6MGVAH/"
    "b2MyTdNGlmXOWiu7sdPpyOLi4hPgEKAB1Nk7r+3B0dB0jeCtwzvBWk+kDOvVhOVHF/Hek2UZ"
    "lUqFzc1NlpaWns7Pzz8GqkHY38fk8XHWkjZZZrG5w1vPRKWftS81tNaICEopAOI4ZmZmZiEI"
    "Aubm5h5r55xtNFMOD5TopjndjmViuJ96IwXvMMagtS4MyuUyYRgyOzu7AIxqn9vbyx+/Zkk9"
    "5Ugl4uhIRFJv8fbDOreunEJrjTGGcrlMo9EgSRJqtVpxOCWrh+OVjYlXR4Y2Luwx23gn1NMy"
    "3+QiJ8/fBzOAc+4veu+J45ggCKZV/n7/Q8au3lXDl/C+i9gmPm9iv79BgkNEJx4gIoXQOYeI"
    "EEURQRBMa5e3bqiRy7i8gUuruNYXXLqOHp5ia/X5zppKFVGMMQRBUEQIvLODIiBuG1wbcW0k"
    "b4AydOtbf7IqhYhgjEFEirr21iOSIS7dEfs24lrgOuRdEJGCv016oW2WbUm+BT7/ZZKCOMRu"
    "k+eDAH9P1BqtdY/Bdv4s/fwSpUvovn3ocBxl9vLj0wrRsevF+v+yiJa8IG42uddOuCkZA3kG"
    "1g8Rn77Gwct3CaJ4148SEV8qlc6ontpUp9N5Z4wJlVJ6V1WP2DnXDsPwXK/BAXbe+b/iHjig"
    "9hMR8liZCo21OQAAAABJRU5ErkJggg==")
index.append('page_white_medal')
catalog['page_white_medal'] = page_white_medal

#----------------------------------------------------------------------
page_white_office = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsFJ"
    "REFUOI19k01oXFUYhp/zczN3fpJpM820trZWW6rWgkjV+gd1VxCEKuimYKhVCo0IulG66UIE"
    "F/5QU5FYQXeCi8FsXAgiYhZKkbQL7a6psa11Jk1mJpN779x77vlchPwV6Qtn836ch+/73nMU"
    "a7ob2AoY7qwmMAv42wsH4zhup2maO+fk/06SJDI+Pn4W2A1oAPX70Zf+Mu2r24e3WROOGBXk"
    "c+TFEQqnG+iwhHMO7z1pmlKr1Wi1WjQajU/HxsY+AWZ1dnl6V3Xf4PR3Oni3eOos6vXzFIY8"
    "fqmD1hqtNUoplFIAVKtVRkdH35yYmHgL2KX+OPyADD23/+TOdxoXnXO/5XlO3jiGO/wh5y7E"
    "dFzOzX973DNc4PTRh7BWr85srT1ka3cFLLbn2iumxsOAIjeGfzoprz6zg1DnnPvhKjduzlEp"
    "WZxz1Ov1ZUhYzIhVaXYFoExAdGsLxfJmtlTa7N1aJjCKwkBApRISGIUxa0HZNCxK3c1PLX10"
    "RNIvX8QN3Ifdcy94x1IK703+Sd9rMm8IrMUahYisZSc/nbHXpo7cf+qVPS8nvb/FpZGkcUuc"
    "c9KL5iWKuhLFC9Jqz8hSvChRFEkUReKcE+BxFTc/fo2Z8fOd/oFYBUFR6RJ4Yejhz/nmwtuk"
    "eYLS4HyfK81F3n9hEhHBWou19pAmKpNlFSZ/2f5B7bFvGT74NTYcRFtLP19kx+YHOf70VzxS"
    "P0G/6ze2D1jvA5NlMHPtenPFLAQ3cP0Ozmf08pio3yVyCyTdFK31RsDCfDcJnOL5pwbfuH7p"
    "M0olT7l3BQQ2BU/w6+Ufmb50gjhOISqsPqjV1C42zuzbVvl+SvJsxBjQWjBD+yke+AJtC8x3"
    "5xARnHOUimWqlU3LyxfxQRA8uR73aJIkPxtjQqXUxj5vk4j4PM+jMAyfXQ/YyfJ3vuPldcqB"
    "5n9+pVBplGVs7QAAAABJRU5ErkJggg==")
index.append('page_white_office')
catalog['page_white_office'] = page_white_office

#----------------------------------------------------------------------
page_white_paint = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAl1J"
    "REFUOI19k01IVFEcxX/v3pkJPyd1TPyYsMAPLEHKhAiKNtE2kIgWCW2FdoGroIg2QWG2y2gb"
    "QURYhESELULCikwypTLH/Bwbn844b96d9+5tIX6bB+7qzzn38P+fYwFVQBkg2R1zQAzQWwdH"
    "HcexlVK+53lmp5fJZExXV1cnUA2IjeQAIKWUBUopYVnW2sDzPLTWKKUoKSmhtbX1ihCC9vb2"
    "u6/uRNxI2YGHyb+xkQCAEEJIKRFC4PmarAEpBMYYVkXD4TBtbW1X8mQ8P1qTOhatbWoceHrt"
    "VGD1RyEEcxlN3DF4WlOVJ8gX6wKhUAi1PM3p5vDlfdVHGHl7m6X5VPcmgaWsIe0bjIaZtKGu"
    "UBIKhbBtG5WexZnsoaq+kcTPx4wPjj7IysjVtYVYlkWOhHTWJ+1pDBZSSgKBAGTjZKZfUFl3"
    "CDv2hL5nfR/nUsGO89e/qTUHANoYHNdDG0NlZA9SCtxUjGTsJRU1DaRmnjP8foxHPYlbvYOp"
    "Bbae5Lft4rgeaE3QXWD06xtmPt2kovYgbqKXL68HaDjbSe9g6s/GMwLwy1ZM2Rk8T7PXTPF5"
    "7AdK2QQTS1jefRYXFNUnblAcbdwUojUHSdfDySgW5ycZ+j4O4ShNzS0U1V9keDSf3PJLVB4+"
    "szWE6w72F4Z4Z8dJz89SEKmhf8Kluy9JeU4uHRfuURSp2EbeJFCUEyA2NIhngkxMZVhOKUrD"
    "pZw7WUdxaeWOZAALaMlms/3WxhzvAmOMDgaDx4EPqzvQvu87xphtLduJ7Pt+GvA3OoiyUmfx"
    "P+IW+KxUewLgHxydIjSkg5NZAAAAAElFTkSuQmCC")
index.append('page_white_paint')
catalog['page_white_paint'] = page_white_paint

#----------------------------------------------------------------------
page_white_paintbrush = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAilJ"
    "REFUOI19k01IVFEUx3/vXmcgMwZ1TPwYsMgPLEHKhAiKNtE2cBEtGghaCe4CVy0k2gSJGW0y"
    "2koQFRYxVISLRMICJ0gdEnEstbLx6Tzn485777YYZpoP9Q+Xuzjn/M//nD/HAJqBekCyP34D"
    "UcAtDZxKJpOmUsqxbVvv9lKplB4dHR0BWgBRWFwBSCnlIaWUMAwjH7BtG9d1UUpRW1tLX1/f"
    "gBCC/v7+4Tf3/Gl//ZHH8b/RhQoAIYSQUiKEwHWzCoUQaK3Jkfp8PoLB4MBB+acq0GqdDrR1"
    "d808u3W+ItdRCJH/XddFSllE4PV6UTtrXOjxXT/ccpKFD3fZ3rDGighyyUIIHMdBSonX68U0"
    "TVTiF8mfEzR3dBFbHGc5HHmUkf6beYLC+Q3DQMr/pmQSq6TWXtHUfhwz+pTJ55Of4wnP4I3h"
    "bypPUIocSdqKEo++prG1E2v9JXNTSzyZiN0Jha1NSi0pxJa5QeTre9a/3Kax7SjpWIjZtzN0"
    "XhohFLZ+FNpYhpXlCIvzYZQy8cS2MewHbG0qWs4OURPoKsotU7CwHOXF1Dz4AnT39FLdcZW5"
    "SBWVDddoOnGxrFmRgqXVNT7OfkfWHGN6Jc3YZJyGA5UMXrlPtb9x11GLCB6Ov8PWHjJ6mx1L"
    "Ueer4/K5dmrqmvZaFQbQm8lkpo1CH/eB1tr1eDxngE+Q3YHrOE5Sa112ZbsVO46TAJxCBQGy"
    "57ynpSVwyJ72CsA/lHPveKG0pUAAAAAASUVORK5CYII=")
index.append('page_white_paintbrush')
catalog['page_white_paintbrush'] = page_white_paintbrush

#----------------------------------------------------------------------
page_white_paste = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgNJ"
    "REFUOI19kj9oVEEQh7+593jRxJPwCPEfiYKdIIigXSprDQQrK+VIcUJSS5qktAvYiATSCIKF"
    "sRALC0WwUhBsbJUkICQXIaceetnZGYt37+VyQX+w7LK78838Zlfo6eGdyQtSq31mQO7ebq6u"
    "jw7ul5JHtycvW02WROT6sfwEtxYW6ex8AGBk7CqPF+/xu/MDd544tnZ3deNZPyD1RNauTc9M"
    "DtfrhC+fcHdit1NmZ+riBLVT53G3m6+ev7gBHASAnB2uH2fv5zZqyteny+AOODv+EXMnbG1y"
    "ZOxM5iIZIID3AQCLuCq10ZNYVNyNbzsdvrf/4IBt7SKbynqrC3AF2AY2AEsB3AxTxUIXC11w"
    "p9XaZXrhJUmaVeXOAEuq71dWVh7Mzc0tAxs9gGIx4G4978VI0owQAqqKqhJCIM9zGo3GfJqm"
    "NJvN5VoBiJgGXAMWIxYNtwImIiRJQpIkiAgAWZYxOzs7D4ynJQANeDRcDTPHtAAkSVLNQ0ND"
    "tNttYozkeb7fRLciq6lhGnFzPMYDFZRrEUFV+5+x18QQcTVcI2ZgWr1UBSktlHMFKLIXAOtZ"
    "KCvohwyC9v9BdCxYrwelBWNQZWBpqQC4vwt7e1MjpyeKQDPc4GhoVZfc/RCkArhw/+3rN3UR"
    "LlUBwHqry8w/ggBU9RcQD5/s6xww/p/zCGz/BQksMILgNALhAAAAAElFTkSuQmCC")
index.append('page_white_paste')
catalog['page_white_paste'] = page_white_paste

#----------------------------------------------------------------------
page_white_php = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiBJ"
    "REFUOI19k89LVFEUxz/3zXvooCYk80TNaaR26iL8VRQpWORCadPU39DCbS2EQnfqJhEpNzK7"
    "thGtJNy4kJYV4SrmUZDMwMMR582bed43p8Xk/DS/cLjccw5fvvd8z1XUcA3oBSJcjizwCyg3"
    "F8Z8388FQRBqreWiKBaLsrm5uQEkAKOZYDIIgjCfz4vnedU4OTmR4+NjyWQyorWWo6Mj2dra"
    "aiFRwKTWWnzfl1KpJL7vi+/7cnp6KrlcTrLZrGitpVAoSD6fl+3t7Q0goQCSyWRkb+/rzNt3"
    "7z/v7//EsiKkHReAgYFu7ty+zr27cfr7YyilqpJN05xSc3MbbW3R9kXDUOvnhZXleV69/tQy"
    "veSTUWamh4Aytm1jmuaUGY1Gn2Ow/vLFQzo62nDSLnask5XleZy0S8zurOZ3UgeYkQizszeq"
    "pAaKZQDb7mJ1bZeY3UlYFlbXdhke6WvIjwz38eHjDyzLqj0DJV2g8LwAzwsAKHilhnv9WSye"
    "YZpmTYEIKYChRE9FtuNyeJgBwEm7Dfm04zJ9/yaGUVsBUwlLIFfTjvu4eXA7qQMSQz3VgY6P"
    "x3n29FZDjwJYWHjTm8v9Xnw092Dp2/c/nJ2F1QbLijA62s/EeJyxsUG6r7RXpBtGxcY6ogmt"
    "9Zdm60SkxU4ApVTFxqZmUfWb8q/xIohIGWq7LEA5DEP/vHAZRKQchmEBCOvpB6l855Zf9h+E"
    "QPYvSxEa0surVlQAAAAASUVORK5CYII=")
index.append('page_white_php')
catalog['page_white_php'] = page_white_php

#----------------------------------------------------------------------
page_white_picture = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAh9J"
    "REFUOI19k79PU1EUxz/nvddXpVBiTUpQQRaNYdFoJKKT4T9wMcbNhcHZgdGEOGkMEFadSHR0"
    "czaamLCoYXAFDdii9Afta3vvu/c4ENpKwW/yzR3uOd/v+SbnCD1cAMaAkP+jDGwB/ujHjVar"
    "VTXGuDRN9Ti2221dWVlZAqaA4KjAjDHGNRoNbTabXdZqNa1UKloqlTRNU93Z2dHV1dWuiCws"
    "v3+Rzw09/NPwudxQPNyxjmzUl0I80xMj3L0+TqFQwBiD9561tbXl+fn5lzx79aFUKpd9o9nS"
    "4/hrr66Lrz/p7u7uQCRgJqonks3lRuT7dp2Pm08Yzf8mMZat8llun1vk1pXzCCFxHFOtVvHe"
    "k6YpxWIRgEhE8ymQes/wcJnTmQKeDj7epFRJ8OoxaUoURYgIzjnCsBcxUpW6KqP7iaHSbuO0"
    "ScN22EvaVOiACnEmJAxDRAQRQVV7AgCqsN/2bG5fwmc3aNiEauUil8ey3cIgCBCRgaUIEM17"
    "D9WW4+rYAo9qRea+BMxNPSeKIhQw1nebwzAkCHorEKGKoHz7+RhrLevGYMYzmI37WGt5cGcd"
    "VVBVRATv/13AKMD/UGcmn957x0EypS8i1lpOZXqO/e4AUZJ03i69+TqbKtdyQ/GwMY44DuFQ"
    "RDzTk2eOzQ8gfe9Na+1nOanyCFTVZzKZ2cN5FPDOuZaqDlzZcc3OuQRw/W4THJzzwJWdAAeU"
    "/wK1OFRVz0OZBwAAAABJRU5ErkJggg==")
index.append('page_white_picture')
catalog['page_white_picture'] = page_white_picture

#----------------------------------------------------------------------
page_white_powerpoint = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdtJ"
    "REFUOI2Fk79rVEEQxz+7770LGMXkkCgkGhttLMWApa3Yi6ksxENLi4AWtv4AFXNcIbY5/5a0"
    "aWwUFJuQOyEXuZe7tzu7Y/G8l3jvogPDLOzOZ76zzBiObAU4DyT823rADyBOX1wfjUYD51wQ"
    "EZ3l4/FY2+32e+AyYKcBa865MBwONc/zyg8ODnR/f1/39vZURHR3d1c7nU4FMcO3LQXQGCEo"
    "GgIqf9yXES/Isw80m02cc8QY6Xa7m61W6x3DNw/1f/bz0R3t9/u1loC1VKX8i5gPyT+9Aizh"
    "+1fs6jVO332MPbuAFp5Go8FgMCDGiIiwtLQEgFUvAORbLzh1+wHz6xvE/BC/s82vjy9LeOFJ"
    "05RGo0GWZczNzVUfl04AGsAsnMPOz6Njj0rAf94p7wpPkiQYYzDGoKpHgOhKQPj2hcHGOlEE"
    "nBBF0GgqgLUWY0xtKKwWvjwsXyUWDi080Xl07EkvLJctOKmSkyTBWlsHnLn/hOTSFVQiKpF0"
    "ZZXFp69LBV5Q1Zr8soWJgoUmi883axIngKqi/XsAUy08vXu3yir+aIiQgIZY+az+AcyxeMN7"
    "v21OejmtSjVmWXZzokeBGEIYqWpty2YlhxAOgXC82kXKda5t2QkWgN5vBGBoABFhyyMAAAAA"
    "SUVORK5CYII=")
index.append('page_white_powerpoint')
catalog['page_white_powerpoint'] = page_white_powerpoint

#----------------------------------------------------------------------
page_white_put = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAb1J"
    "REFUOI2Nk71uU0EQhc96LeMgRcgSdppECqIIBVDwY8ooPABKlReIFImGApKHSAeyrMgNDSUN"
    "rwAdoFQgkTopbN/G1/L67t/sHQpnL/ZN5HCkkWZ3NZ9mjnYEZloHsAZAYrkSAOcA8vLDU611"
    "6pwLRMTXhTGGO53OBwCbACplQNs5F5RSPJ1OixiPxzwajXg4HDIRcb/f5263ewUiALSJiLXW"
    "bK1lrTVrrXkymXCappwkCRMRZ1nGSinu9XoRAnEZz4noewihaCnPczAziAjWWjQajYWWq9Xq"
    "CwA/q/OXlUoFQogiDyFASolarYY0TZHnOYgIrVbrH2geEItjLqVcOEfgQidlN8vAWCCEgBAC"
    "zPz/gFg4P1pZNwIi5O23A3hHcM7DG1+8XfkQUcy8ENZ4bG/uYOf+S+jM3gyYBwGA1RaWLDQZ"
    "1EUdW7v3Hi4dIRr2/scx/vR/o7nSgiEHFxyajTU0H989WX1wZ6/ogMv2XkLetI9wG6swxsJ6"
    "A+sNBskASulBdsu9itY+M8Z8lVLWhRDXjvX60z40Z3DOgxXyz4df2gBOI2ADs3Ve6smTd48+"
    "+szTr5OzfcxW++IvVvoQ3RrM2gEAAAAASUVORK5CYII=")
index.append('page_white_put')
catalog['page_white_put'] = page_white_put

#----------------------------------------------------------------------
page_white_ruby = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjZJ"
    "REFUOI2Fk81LlFEUxn/3/ZgZZ5SZCgypwQ/URlACBfsngqIQCvcWRJuIaFGkSwlSkVnYImgV"
    "FC1r26JtmGSh61AHR8IZ5p33877vaRE65gz1wLO55zzPfQ73XEULF4HzgMm/UQV+AsnpwpTn"
    "ebUwDGOttXSi7/uyurq6AgwAxmmD6TAMY8dxpNlsHrNer8vh4aHs7++L1loqlYqUy+U2EwVM"
    "a63F8zwJgkA8zxPP86TRaEitVpNqtSpaa3FdVxzHkbW1tRVgQAHoRw+e1oPweuFSaTLRGtEa"
    "Ik0SRkgYkQQhcRBgT05iz94+jmxZ1hVLHj98JoND82cuFCGVwrRtcF28nV18xyGVjolsHwew"
    "Pnwk5XqE167S29sLgJFAiVod1XRRI6Oo0hgqCIm3toh2dmBvD79SoZHNECQJxpd10ul0K4WR"
    "zs3q3d1fRsO5Z/T3w9QUJAlqexulFHE+j1sqkdv4TqEnjzn/BLHtloFaWEiA+z9mbp4b9YNb"
    "Vj4PfX2Ytk1XNks4Po69/o1C4SyZ5efEqZaYk89w+d375WRwiGjtJZgmdrGINTFB+HWTQiZL"
    "19IidGUwTRPDMNoNNIh5Z454eAT/1WvMsTH8jU26e/J0lZcgl0MphYh0TnAE++4cMjyM++kz"
    "VneezItFyOVaAsP4K0HbIh3RffNWooMDiaKoI7XWAkxbJ11ERJRSCiA1c6PtllO9yckRBEji"
    "OPaOCv8Tx3HsArE6cV7kz3duH7AzYqD6G5cqTrXugETlAAAAAElFTkSuQmCC")
index.append('page_white_ruby')
catalog['page_white_ruby'] = page_white_ruby

#----------------------------------------------------------------------
page_white_stack = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAT9J"
    "REFUOI2Vk71qQkEQRs/+oKVgoV0wbRqrmAcSQRtfJQQbq5QGn0MQUuYJTNJILAQhoNcZsyl0"
    "5aqr4sCwA7P7zdmPXQPcAVXAcBoz4Bv4S/T28ZhlWaaqIaaIhOVyGXq93gtwD7hzhw3QUNV3"
    "EWEymTCdThERSqUSIsJgMBj2+/034OMcTUNVw2q1CqPRKKzX63ALjY+FtXa/pmjq9Xq33W5X"
    "UzSNOGk8HodLNLG3o6kB1udxjDFJGlVFVRERyuUyzWaz672n0+k826SzxuCcO6idc/sBhUKB"
    "VqvVBSpJgTyNcw5rLc45isUii8WC+Xx+aiJACOEqjTEGVU0LxKnnRGI/v88DM+/9E9tH9aCq"
    "rymaOD0vFAU+gS+O/kKKJu/L8RXCLn+u0RwLH3hwC42q/gKbtGvbqAGVC/0NMPsH8sHZ7dTF"
    "f98AAAAASUVORK5CYII=")
index.append('page_white_stack')
catalog['page_white_stack'] = page_white_stack

#----------------------------------------------------------------------
page_white_star = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfNJ"
    "REFUOI19k79rVEEQxz+z+/ISjRIDGgMqxMaoiEEkCVj7F/gHWFrYibWVYKshXJFSGwuxsbYT"
    "hHSWh+kCkrsrzHvcu9t773Z3LI68+5GYL0yzs9/Pzgyzwlg3geuA5Xx1gEMgziYeO+eyqqqC"
    "917PisFgoLu7uzvAGmBmAVtVVYWiKLTX69WR57keHx9ru91W770eHR1po9E4BRFgy3uvzjkt"
    "y1Kdc+qc0263q1mWaafTUe+99vt9LYpC9/b2doA1mQBsDvNf+yEMkcWHAMQYUVW895RlyfLy"
    "8lTJSZJsJ5MHvvUJQo/kTgMAYwwhBKy1pGlKlmXEGPHes7KyMoLo4asLRd7ZPjhoPZdYgO/i"
    "D99jlp5gLm9g7Xz9gIjUwLqKsp9/SOeWXtx/sIpJV9HUEbOfVH8+Y688Ze7eu9ogIogIqloD"
    "zPx692WsWt9GYxiFGou5tMHc3be10RiDtRZrLUky7tyIfAluOHyj/SYaHXhHzJskt1+DjEsV"
    "Gc3bWosx4xVIANIwuIFZwLe/En2JmIvooIUurtcXVRURIcbpBRyhYnmt2fz9cf7RdxY2f2Cv"
    "PkOrv1Pm2mDMVAVTe+C932dGk+ZJicjpPVBVlZNmZ3o/AxzHLYACMYTgThLnSVVjCKEPhEn8"
    "LUbf+dQv+48C0PkHjsEg5EFpO/wAAAAASUVORK5CYII=")
index.append('page_white_star')
catalog['page_white_star'] = page_white_star

#----------------------------------------------------------------------
page_white_swoosh = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgxJ"
    "REFUOI19kz1rVFEQhp8558asJhISgyaQgKiVYCVqkdLC0s5GRLAJNiKKP8DKTggh/8LCzkZI"
    "G0EsUomgiIJho7Am2WTv3nvmvBY32XxofGEYOMM8M2eYMfY1A5wDIv/XOvANyEcDV3u93u+q"
    "qjylpH9ZWZZaXFxcAM4D4SjgelVV3u12tb29PbCNjQ11Oh21222llLS2tqalpaUBpNhNNoAQ"
    "QogxEkIg50ydYTNFymSQIq0aWqNj3L13/1EoCns4P//SDgCupZTe7VTO167xecvo1WKkECPB"
    "adFneuI0pyK0ChgKMDpc3CgO/uH9T/jwq6DO4kSAVoTgEDBCGGK9s8XJ4BRKTJ+dBGAAePz6"
    "05PlH4YQAVEHSBmyoEGARTACrRjpJe0Dnq9UzyrpdpmEaALRRIpGyuAyJoeNoRjpJcgENqum"
    "cPFiVePdnfS0nxQ8igYsosGVCbg0ZlweN3IGSbiLrRrK3c6LzZ10MyXG6wwJcIksuHPRmJva"
    "mzGYGZKIMTIWxJmiiRV1sgv9nK1yUBYpi1uzgbmpJmFPkjAzcj68gEVP2SpXqLPkagY3M3J4"
    "ww6CQji8gKFfQ9+hdKzx4s33PGh7zx+1AaB2OlWSlS56LsokVtqZhVU/Nnl3HhkgbOFvSxdV"
    "wkoXpUPfxasvzoPlmo8dcVSSsrvvAG4H3mdpzvmvKztGDqz/AV0fPqnIn7O3AAAAAElFTkSu"
    "QmCC")
index.append('page_white_swoosh')
catalog['page_white_swoosh'] = page_white_swoosh

#----------------------------------------------------------------------
page_white_text = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAXBJ"
    "REFUOI19kz2OGkEQRl/PcgaceIUjyAiwWCcknIJzWYiAEyGLjJCMdYAgYRADDT1VXQ7YGTPD"
    "7pT0Sf1X76tudTnu8R34BrzQHHvgHYj1jZ/e+zSEoCJin+l6vdp0Ov0N/ACSOuAthKBZltn5"
    "fC51PB7tcDjYbrczEbHtdmuz2ewJ4oA3ETHvvd1uN/Pem/feTqeTpWlq+/3eRMQul4tlWWbz"
    "+byA4D40FJE/qspisSCEQAiBPM9LTSaTSsmtVusXsGw9LiZJwmg0AsDMUFVUFREhTVNijIgI"
    "7Xb7P+gR4JxjuVyS5zkiQggBESlBMUbG43G1kvprDofDyryoJMaIqmJmzYDVaoWIVJyLxBhj"
    "ecUvAf1+v75UJhfjRsB6vS4fLsZYlg4QY2QwGDQDut1uxanuWI8nwGazKZ0LPUJ6vd7nADMz"
    "55zrdDqNjh9ni2ayBDAgqqp/2GhMVtULoHD/xgCv3Nv5qcu+COXe2n//AdgJRGOle6PNAAAA"
    "AElFTkSuQmCC")
index.append('page_white_text')
catalog['page_white_text'] = page_white_text

#----------------------------------------------------------------------
page_white_text_width = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAT5J"
    "REFUOI3FkT1uAjEQRt/+oFSpkEiTggoJ2kgJ9+AAnIAcI22EKDhTLoBEm3KrLSzM2mNPCvBm"
    "ISgkaTLSyJ6R55unz/DfkV2pL4WeD9wDd0Dxw6UV8A7E1Hiw1tbOuSAi+l3u93tdrVZLYAjk"
    "ACVQFEVx673PQwioKr1eD9UDqYgQY8Q5R7/fZzabPQMsFovXIwmPSd1aq9ZabZqmvRtjtK5r"
    "rapKRUR3u50aY3S9Xi+BYXYUeAshsN1u8d6T5/nBLVVUlRACzjmm0+mJGWVZPpWpyPOcyWRy"
    "avdxOGVd18QYEREGgwHJg8N3ZBmbzeaL5Ukkxtieo9Hok6L7+JygK5IEktEXBS4RpIgxtkLj"
    "8fh3BImim38iSELdRVcJutsu1dl8Pn8xxtyICCJCCAERwXvf1s659kx9EQFoPgCV7SPjUQwT"
    "DgAAAABJRU5ErkJggg==")
index.append('page_white_text_width')
catalog['page_white_text_width'] = page_white_text_width

#----------------------------------------------------------------------
page_white_tux = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmFJ"
    "REFUOI19U01IVFEYPffemedrQgUHRxcZhiFOEKnJVLqpkJrCjds2EdYqCWYx2NaFuyBkmMRd"
    "y0BaFIYtc1GCEFgiE4bMKMFjBmze6HRn3uu++7WYfDP+4IFv9XEOh/Odj6GOcwA6AAicjgKA"
    "HQD66OJqpVKxXdf1lFJ00lSrVUqlUrMAugHwowIxx3G8xcVFisfjNDMzQ8VikUqlEhWLRcrn"
    "86SUIsuyKJ1OHxNhAGK7u7+pf+AaXb9xi/oHBml1dZX29/fJtm0qFAqklCIpJZXLZZqfn58F"
    "0H3IBpHGk4dXMP38PKI9ndBaQwgBzjkYYwAAwzBgmiYmJiaeAYgEGgU4FMZHNhEIaLwTZRAx"
    "cM4hhIBhGLBtG1prKKUQiUT+cxqwvrGJ9yv3sctfYvDOJJaWPvgCgUAAhmEgGAyiqanJ5/gO"
    "hoaGere3c3j8NAnBAbOlDWNjYwgGg5iamqoFxRgYYyCiw/EnEokzsVjseyaToQMopSiZTFIo"
    "FKJsNkuu65LjOCSlJCklKaUIQIwDwNZW7nY0eulyX1+fry6EwOjoKDjnsCzLD/Eg1HpuANpb"
    "vVA2m8VfpaB1vWBr39ahPI1IpANEdKJ9bi1PXph+oB4J9we+rHyFELUm76wvYOHNa7S3tSAc"
    "bq0TOD/soLSz9oKXcvfGh5vxczMDWXEg/5SQ+zyHu715pCfDoF+v/AAPxr9CWfR8ZNIeHrlo"
    "nn278ak5PbcHt7KHbs9BfLgLnW0G8hZDS7ROqpWONFCrsH/JarW6LIQwGWPHHuUo2fM8aZrm"
    "zUaBLtTe+VRyAzwAhX/9sDRYdchmQwAAAABJRU5ErkJggg==")
index.append('page_white_tux')
catalog['page_white_tux'] = page_white_tux

#----------------------------------------------------------------------
page_white_vector = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAktJ"
    "REFUOI19k79rU1EYhp/v3JvUJrZpjCZEW0gHUQcFEVsVoZMgCEUxk/9CwQ72bxB00VKXbMWl"
    "iKOdLO3QQVHBQXSrIEWhhFb7I96b3HvO/Rza0DRWX3inw3k45/2+V9jXIFACPP6vOrAKJN0H"
    "l8Iw3IyiyFlr9TA3m02dmZmZBiqAAfA7AJ7neX1RFBkRAWB9fZ2VlRUKhQLlcplCoUC1Wr1v"
    "jGFiYuLJ3ksAEGDEWqthGGqr1dIgCHRubk53dnZ0eXlZ6/W6Wms1CAJtNBpaq9WmgYp0AC5b"
    "a98551BVFhcX2fi1RfHEcQZPnaRUKpHP5w/82ff9UZ8uiQhLS0ts/Y44f/02/b1CrifBOcvG"
    "z02EBGstxWKR7gxQVSYnJ3GZMlfvTPHxh+B7StpAMetRyQu5Hkfa7A+qEyALCwtcGLtLeuga"
    "5QFD7ohQKRiSRGk0HVstwSZCvlfRLoAAo41Gg/7hW2xHwrmSodhnSHmgKuQz4Jwhto7YgXV7"
    "gNnZ2Wocx0+DIEjGx8d5/kHxUPIZIeW1c4GUJ3iipHyPJFE8A/i+GBF5JCI3s9ms8X0fp2AM"
    "ZNKCqh6wiIAqRnahAMYY8zidTr9YW1ubBzjaA9ut9nT3w23LGIMxBgGwVlFVqdVqOd/3r1hr"
    "9fP3SB++DjVo7a5vHMeH2lqrwIgvIgpsA4mq6umiEffF8nbFMXbGo73W3VLVBPYKASiQOOdC"
    "I5oM9wlvVv8q24HLzrkAcJ34IXbrbI6dvTFw8d6zB9/ev3r5dX7q0z84Dqj/AfTXQPexMuzX"
    "AAAAAElFTkSuQmCC")
index.append('page_white_vector')
catalog['page_white_vector'] = page_white_vector

#----------------------------------------------------------------------
page_white_visualstudio = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmdJ"
    "REFUOI19k0FIVFEUhv/7fDNOipNlKJJGYRESRFBO6aqyAgumyEWtkoICW0QRgVELqWWbYtAc"
    "UkhoFVIQTi6ChAjCwiIKA0kIS2Umc+bpm3fn3Tn3nRamI+PkD2dxOIfvcO/5j0BONQCqABRh"
    "bSUATALw8gt7pZQppZQmIi4UmUyGI5HIAwBbARj5gJBSStu2zel0ejksy+JkMsnxeJyJiGdm"
    "Zrirq2sVRAAIERFLKdl1XZZSspSSFxYWOJVKcSKRYCJix3HYtm2ORqNLkEXAo75tnd7UYdbT"
    "Z1nJ7+y6Ljuzs5y6c5OnWk9w/4tPq54EIGQCwPnh9mZ/6cR14Y5AMEOs+wnt9iB9twf69TMQ"
    "TMTe/kA2UIbwniCICJWVlQAA88abtmYl5IADlDI0hD8L/H4P+/4ZqKEUDC2hzXLMZ/3ofpVE"
    "WYmDI/Wblz/OgJHtZ1VsDA54V6iiDzy3CfP3qpEZnAOrDMRGP6qe9qHj3E4Ey2z0j/fC5/Pl"
    "AEqWl/wZP+WzZo8HReAkZGQ75FAGyErATwhedRGo+4VQfRV2ND2Bu+ElTNPMAazpfbelVRuo"
    "qGvq/Hi5A5nYKKAdoCiN8g4F/yELRvwinn9uxGhyGMdqWmEYOQsYj9sudLvkXNMe+dwvHwDt"
    "gMnE+uhDFLc0APMASMEnv+JgdRjtu24VtKc4cKm3+11LmJONuzkdizERcVZOsjdxlL1vW3hs"
    "7DRLN81KKVZKLa9RrDBSAxGN5JOZufBEIWCa5n4zr5mFECK/sZCY2Vtc478cgKe1lkuFtcTM"
    "ntbaAaBX4muxeM6rruw/0gASfwGXtYBD6vbi/wAAAABJRU5ErkJggg==")
index.append('page_white_visualstudio')
catalog['page_white_visualstudio'] = page_white_visualstudio

#----------------------------------------------------------------------
page_white_width = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATpJ"
    "REFUOI3FkTFuAjEQRZ/Xu5sqEhISaVJwh0jJQTgAJyDHSBshCs6Ua6Sk2sLCrD32pAAvhKBA"
    "qow0smek//39P/x3mSvzpdJzwCPwANgbH90An0AuiyfvfRdCSCKiv/Vut9PVarUEpkAFUAPW"
    "WnsfY6xSSqgqTdOgulcqIuScCSEwHo+ZzWavAIvF4v2ghOfC7r1X7732fT/cnXPadZ1uNhsV"
    "Ed1ut+qc0/V6vQSm5kDwkVLCWkuMkaqq9m6pknMmpUTf94xGo29m1HX9UpehgJqmOdp9+Iaq"
    "0rYtXdeRc0ZEmEwmFA/2cZifCRpjsPYYTtu2FKWDimuZFRJjzNBF2U0EheRczZ8ICgmAtfab"
    "gupWglPQqV9XFRTgJZMBzHw+f3PO3YkIIkJKCREhxjjMIYThLHsRAei/AEff4NPqjcwZAAAA"
    "AElFTkSuQmCC")
index.append('page_white_width')
catalog['page_white_width'] = page_white_width

#----------------------------------------------------------------------
page_white_word = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhpJ"
    "REFUOI19k79rVEEQxz9v972XHBq8XPCCYMSYRiSdGqOFiKCdhSBYamUaG7EVbEULMSG9Tf6X"
    "2ChpFAkI/iDH5WLuDnJ57+3bnbEI3p2XxC982YGd+c53lp2IAc4C04Dl/9gGfgAyenE5y7KO"
    "cy547/Uo5nmuKysr74DzgBkVWHDOhb29Pe31en12u11tt9vabDbVe6+NRkNXV1f7ItHD5Y1f"
    "RV52vMvGZ+uTcxIUAkgA8YIvleADr5/MUKvVcM4hIqytrS0vLS295f6bT1+ywmvp5Ug2f+f6"
    "6OVHbbVah0YCFuJQBp9Yw4v3X+nmgUv1CptbGROJpXrSsvFtn1AqaZrS6XQQEbz31Ot1AIx6"
    "RYG8UFKNmJmu0O4Jp6sxeRFQB1GpxHFMmqYkScLY2Fj/4Yy6g2AckEJZ3+hQOmGrWfD9p2Nx"
    "/gTGK9Za4jgmjmOSJBkIeBcAKAulsR/Y2S2pRhGbWwETKXdvTCNBMcZgre0LDTlQUOhlgimU"
    "O9dq1E7FVCqGm1cmmaqmSFCiKALAWosxZtgBGAvBCbNTCfdunUGBCfXcXqxjTYSoonogoqr/"
    "fJ7YBCo7uwWvnl0EhSz3PH88109o7RZ4Nyga7g4QixMePP3wuSzy8blztQsioCKogooiEmGi"
    "wQijiIbOq2VZrkfHZY5AVSVJkut//SggIYRMVQ9t2VHFIYR9IAx3m+FgnQ9t2TEIwPYf+A5j"
    "pgV6TOoAAAAASUVORK5CYII=")
index.append('page_white_word')
catalog['page_white_word'] = page_white_word

#----------------------------------------------------------------------
page_white_world = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApRJ"
    "REFUOI19k8tPE1EUxn935g4zLUJbAlMQcAj1hUZrFEWNiUYToy5cqIlx4c4Vceuav8EQNkb3"
    "rlwY4sqN8RHFt1GMxChUoJRXebR0OszMdUGEAoYvOZtz833nnHu+I1hDC5AEdLbGJJABwo0P"
    "R0ql0pzneYHv++p/4bqu6u3tvQu0AdpGgWOe5wWFQkEVi8XVmJ+fV/l8XuVyOeX7vspms6qv"
    "r29V5F+74vTNo5dirdHLjz885PHHh3zKvGW2OEWVNIlFEoRhSCQSwTAM0ul0l+M4Wn9//3cB"
    "0H3/+k0VaD0n9x9PNdl7KWvNTObH+TMxgPQLnNp1jo7kIRKJxLqWpZRdsvvBjVNS1+9cO38l"
    "VRN3yC+YzJZMxtw2ovEktvmG50NPiUfqEEIQhiG+72Pb9oqIJrh6INVxIBerwfV8huerGZ5a"
    "ZsYfIbr9J0bEZTlTZHDiC20NuwiCAF1fW5SGEBet+hgjS+Po4TY+/S4QWHkKziu+yncMjA7i"
    "2C38GP+KlBIpJYZhrI0hlNjty2VmFgq8nCmSX9CpspZJmGm8SYfS9GuiKZOpxYl1lVcFQhEO"
    "aUvhnqhsZngiJDQSDI9VUXwPUaueZF2WmYVp7NpGAHRdRylVMYLiyXR2ivLcC0wzg/A8qqxa"
    "rJiPGR+gPVbme2aEjuaDCCHWkQE0pXj0a2zky46wmp0NBnakTJ3usr1mnM7GP5SKsyQTLRxs"
    "PbJC0DQ0bc2Eqz7wymFPo+2kYtHDaKIBQw4yNPqGprjD2f0X6Gw/ua6yEAIpZZeocOKt2923"
    "730b/cz0Yo6G2kb2taRJ7+ik3d696fOUUqFhGCdERa7Tdd1nuq5bQohNh7KRHATBkmVZZyoF"
    "Wlk55y3JFQiAyb+gMiH4yAFHogAAAABJRU5ErkJggg==")
index.append('page_white_world')
catalog['page_white_world'] = page_white_world

#----------------------------------------------------------------------
page_white_wrench = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjhJ"
    "REFUOI19k01PE1EUhp9770xpGyghjUX5sBI/S40JQWOCJCC/gZ0SliwgJC6Ma0lcuSCGjWsT"
    "4x+oSxe4k9hIcWGkxoYx6aIkdUoLHce5c13w1WLDm5zVPec5b845V3CqIaAfUJyvCuAA4dmH"
    "8Waz6fq+r4MgMJ3C8zyztrb2CrgCSACrBaCUUj2+70shBKVSiUKhgOd5jIyMkM1mSSaTzM7O"
    "LkspWVxcXAWcY4AAkFJKpRSe57G1tcXk5CS1Wg3HcRBCANDb28v8/PyyZVksLCysihbAvSAI"
    "Pmmt2dnZoVgsMjY2Ri6XI5VKYYwhkUgwNTV1YtmyrPvy7CCklAgh0Frjui6RSATHcejr6yOf"
    "z1OtVqlUKqeQTmMuFAqk02mCICCTyRCLxWg0Gti2jW3bKKU6Aza2G2x8q5JUF4nH45TLZXZ3"
    "d/F9H9d1mZiYwLIsjDH/A568fP/441eXW5d7+Lx9ib3NEv1dNUZHR7Esi8HBQeLxOFrrNrcW"
    "wIt3pWdam6VsugfbhpvD3axvDvB6efok0RhDGIYopdocyJW3P5/u/+H5nasJISXUD0K+/9rn"
    "we0+jDFtIYRoKwaQe81wZfxad0QKaDQ1+WKd6wMx5mYutHVv3ZKUp8uz6s3Q+934G411Kb78"
    "qJMZjvHo4WHxccfjI+okuVf3l3Ib1dqbD+XmjaEYczOptgQhRMcwxoRwdMJHuut53rpSKiqE"
    "+O/AWmWMCbXWB9FodLoVMMzhdz63uEUaqPwD92H9V/Io7goAAAAASUVORK5CYII=")
index.append('page_white_wrench')
catalog['page_white_wrench'] = page_white_wrench

#----------------------------------------------------------------------
page_white_zip = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeVJ"
    "REFUOI19kj9L5EAYxn/vTMwa8DbXuEfwOFJEkDQWV9nfR9jKxmJ78a7YL3Cf4Fi28DOkt7Sy"
    "tLIRNyjhQPAElxXjZYlJ5gov0ax/Bl4YmPf5zfM+M8Lj+gx8AjTvr2vgN1AtHnzNsmyW53l5"
    "cnJioigyURSZoiiams/nZjQa/QJ8QNXCeqO11h/yPFdxHLO1tYWIcH9/z93dHTc3N1iWRb/f"
    "3x2Px9+BL7VWAQKglFJaa4IgII5jRASlFCKCiADgui47Ozu7+/v7NeTJyn8I5+fnbGxsoJRC"
    "a91AAGzbZnl5mcFgsAv0AKxFwPr6OpPJBKVUA7Ftm9lsRlVVFEVBr9d70jwHiAgXFxeEYdiI"
    "tdZYloVt2ywtLdHpdFrptxwABEHA2dlZY11r3cBFBGNMq18tApIkaTKohYtu3gU8PDxwdHTU"
    "uqkOsQ71zREODw85Pj7G8zyyLGNtbY0wDDHGICJU1YsP2HZweXmJ7/tcXV2xurrK6elpy0n9"
    "Mm8CHMdhOp2yt7fH7e0taZo24T2vVwHGGNPtdtnc3OTg4ADf97Es61WAMaaZxQIMUJVlma2s"
    "rDiO44jrupRlSZqmL2Y2xlRlWf4Fyuch/vE879twOPyZJMnHurmqqvn29vaPF5RH8TXAPwaQ"
    "uKHqFpCCAAAAAElFTkSuQmCC")
index.append('page_white_zip')
catalog['page_white_zip'] = page_white_zip

#----------------------------------------------------------------------
page_word = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqpJ"
    "REFUOI19k82PVFUQxX9V971+3TPNdA/Dx/QGPxgGxLgAQiYQFoYgHxM3mGgIbCSYmJgQY4wu"
    "jFvdEUn4A0hc4IKVG2WhCYMkBGNwAxNwRgMMTke6YRwh/fHeu7dcvKZ1xdlUbe45p26dEoA3"
    "Pp97N6klJ5ywy4yyCAKAACZggSyE31fb4ceVu81P5i++kzKAABz54upPX5/e9YoKdUQcxhBm"
    "AEbracaFX/6mea/XefDb4tpL52b7ABGAOtlaclqfb4lTEShE8RbIc6ObeV7fsoaZ6YjroTVi"
    "NrVy+PR345fOzfZ1IFQFXMkpsUIk4BScgAgoAgQaYyXe3N3gpalyJa2WzwNE2z+cP1ufHKt8"
    "cLHFjvEKsYNrzS4zGyukWeCHW03Gq3W2TKzlhaojiSNe3DPB3LW7bwPHNetxY0M1omxwaHeN"
    "K0sdeqmxf2eN5VaKGLw/u57FR8L1+zmXFzoksUNizQFULP95tRN469VRIlGetleYTiKcCjeb"
    "bQ5sbTCSOJKSo1xylEsxhoIU00chyFTi4NfFLl99v8S2zetpP/Z8+s0yBDi0b5zMG4giXjA1"
    "wnA7EGmfUQzaoqiHek+QWoRbanFsZhMqQuRskAcwBB/Ah4JAfZ/EvDC/8JAvT26nEgtpFnjS"
    "CezdOTYIiyAmRCo4FcqxkGeFhci8NZxAnBuVknJnuc+q/4fD05MEM4IVagaEgZHYKXmaFwTk"
    "Uru98JCzp14mt0AtVu6veI4cmCAM5nQKDoi1SHgwI0t9QfDHt6991tg291F9TVR+3IX3jk0C"
    "kzwPFoysVzhQAJ+GkHlvz331PzgnwechH95C2vV/jSZuHZKOAorB4JOpVaJC1aASK2Ahdvok"
    "z+3PIYHizxz8+MpRVd0RCCP/eX1Whg0GPQt2I1a7APAvfGscJI5vUoIAAAAASUVORK5CYII=")
index.append('page_word')
catalog['page_word'] = page_word

#----------------------------------------------------------------------
page_world = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAx9J"
    "REFUOI1Fk0to3FUUxn/33v9rJpnMJJkmGRMTrLEPqLFpkwpKSRHrq1YJhW5E6FKR4ELciAs3"
    "LrpwowuXiotQqIWupKIFH60koY1pCVNs85i0nbwm40w6ecz8H/e6SDJ+m3PgHM75OOf7BLs4"
    "/fnvF9yk+54SHDcGTwgEAAIwAowm0Hp2fU1fL+WWPs1ePu/vlQF488sbf/4wcvywFKQQQmGo"
    "wxgAQ2EjYPRWmaWF6tbj+zMt1755q2btNUklDjpKprIFoaQQsLOUyGjC0LAdRJx6LsGLByzG"
    "dSFuTG/pjZGfmusDBPNN34/dVCX/X6pRiDI2TfbT9HWdocFrRyIATabJ4e3BDL84y7H5Je87"
    "BfDu169fOHXUOzd04CUOdg6STp2gJXEIP6owOXeFlNdDPNaCbQLaGgyZRkVfxuXq+Mphdebi"
    "KyeHjh27/Fr/aWViKcrbDiu+w2zBBpp5vsvh+p1LPJU8wlaY5GE5Yr7osz9t8+PEki/bM62f"
    "DD7T7/wjIwp+yMy6xb18wKPaLPnWP8gn8hzqaGM8ewXXUXiOwnNsDBKERHa3Zk6WLJ+FrUWU"
    "bmRqfoPIK7HR8xfT1i0mHmfpbO2gWJ7DtiSOUriWRO9+x7ItJ1aulihGNjeLm5SeKBwvoNl9"
    "AX+1h+21MUyvJoh8bCXAgEEQaYg0WJXNSjGB1xUPO8gta7TdTC7vsHkb4l6a9pYltrYrSOMi"
    "jMCSoAHPhjAwyGxu5qq/XqVWvoHrPkT4Po7XhJcMcVMT7E/WuP3gPt37jmIAbcAAtpKEfoi1"
    "srLx1bWx3955dfBEd2GfTa5Ww9cWJrHIs+lH1MowmU+S7jvP9FSA3tXNaIdN4EdY4xfHc/6H"
    "R86urtlTQwNK9DZ6hJFDIh1yZ67IYrGNc2e/wI0lMWbncHdXQ4w2BNUQC+Dvb6fvDox8Vn1S"
    "eBD7deESWodYdgwaXqaz732my3FEOdyhLwVSC5RCR6EO61LWQdvyx8PD6U3fNAASQ51uMqbr"
    "porZAjDaVrIShiZfd+PABz9/FIQMSyn7NTr+vxX3Qj3BQNVoMymNGf0P+0Rn4KLL+3gAAAAA"
    "SUVORK5CYII=")
index.append('page_world')
catalog['page_world'] = page_world

#----------------------------------------------------------------------
paintbrush = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiFJ"
    "REFUOI2lkU9oknEYx7+v7+9VI805nf8iEnq1eVh0GN2KDhFrFbRFpwrGsm4Ro+gSzFPQLVqs"
    "FUhdgphR7FBrO5gKs6JNxbaobdSWTpBlTnx9X1/ft9e3Qw2itX/1XJ/n8+XD8wX+c6h/gcaC"
    "FhfqWwZrfDW86YCxoMVlY7tTVner7e3gxZJmM3Cs37zD7ulOO3a32WrfRqFIlJFsFI4HG3ba"
    "2HNJh7etUak8Q3L4uSKK1LENGfyE/UlHc3sjQ8XwJZ1ATaSvnryeH1kXjg4YPTPRy0Uu/1IV"
    "873qu6cH1SfXnA+W92saxO9Zmp2+8+NO31Ezgyg+jb/CbGL6deGr68LyzYoWQqEQ3cTzDJF7"
    "d9m8p+LbfcdNRI0gM5nAVDSVqRbJ3tMDmaUVBqqqUkNDQaOeWuopG8SUUqfeWFxuE1EjWPz8"
    "EVPRZLXKUYd+hwGABoBAIKDJFrNNekV6CDB+AHaZdmsXJ25TDEMj834ehVztyJm+hYk/jQkA"
    "mFjWPl8h/SZF136glUWLWwuB8yI2Wp5Lhx87hApz6WxfJvy3P5FAKKSt8lJnXVA6GE8LhpM5"
    "3BmRYdWLqJXZD3sEw/6uW7O51R5N1IL8SGa2dmqtdnC8BhWlAYLGgMm5dMmhk3q6bq4OAwAp"
    "FoUOQSyjKi5AFBVI0ncQ3bYXZq0YDN64MrMWDPyqMRIJkFKW26dR5cN0XbmrIbQg1Xj1hP8+"
    "t17AD/JG5y0Pd51dAAAAAElFTkSuQmCC")
index.append('paintbrush')
catalog['paintbrush'] = paintbrush

#----------------------------------------------------------------------
paintcan = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApNJ"
    "REFUOI2Vk89Lk3Ecx997njlduu3Z1lYZZLqDNQ8WeTAQckREtKSCSccgoUN48CBEYvaYhyCI"
    "TtJ/0MndEqyki84x2soWkxlqrrR0Pm5PbY/fH8/zrEMYGUr4Pn0+H97v1+XD24JdFH40M8B1"
    "dp8R/cWaqNzIyN1sNx8ACP8eIkMfbZxz+Wyz21ZbhWs1itixV3hXQMH+zV4xdJEzA4wwMI3a"
    "9wVAAaBbFD9VAq1McPFEzdV9Afov1d4lGoWqEpAyw8njnp6xsbG+vQCWv5d4PD5c53AN3n6W"
    "gVok4ExHdOQ80nMZWKrrKNErsyo135RAHt+7fkEBAHE7HIvFhiVJGjzk92E9r+JOuAGiAJxr"
    "9aO56RiSH+as0pGGo9UHHB3KhnbmVPjmu+CVni1xO+x2uwd9Ph82NzfBuIHkpwJaA140HHaA"
    "MQaBa3ibel8pV2ywS/6mL/kfi5RqKcvU1NSQ1+t9UF9fj3w+D8MwIIoiXC4XCCGglIJzjlwu"
    "B9M08SoxV6lr6bSsbRTWV0rlFoFzbtN1HYQQCIIAq9UKSZIAAJqmgRACxhgMw0A2mwXUr/G8"
    "UkSV86BfKVlvCaFQaGBpaelpLpeDx+OB2+2GaZpQFAWUUui6jkKhgMXFRSwvL884HI7OMjOx"
    "/n3NKOmVcQEAurq6+rLZ7JN0Og1KKVRVBaUUhmEAAObn57GwsBBzOp2dsiwzjZtYKfHX6ZHL"
    "6T9fiEajL9va2iRd19v9fj8457Db7chkMkilUjGXyxWSZfl3J053f049DPfveCMAjI+PTwSD"
    "Qck0zfZAIIBkMonp6emdYQD5qeez2/MOAABMTk5ONDY2SsVisT2RSMRWV1dDo6Oje7ZxT/X2"
    "9nZHIhHb/3y/ADKbTnIVgak6AAAAAElFTkSuQmCC")
index.append('paintcan')
catalog['paintcan'] = paintcan

#----------------------------------------------------------------------
palette = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv1J"
    "REFUOI2dk11MW2UAhp/T05bTrbXlp7SDAkXGNlgZGhBNRDOa6NVcsmVcTC8kS9w00Wg0Ri8W"
    "47KYeOmiIdmFmokXi84YiYs/Uwnhxi4wIIMx1qLgENiA/rG27Jzv+45XJkuQG5/r932u3ldj"
    "G6b6++II+7BQMq6UkNKWV7HEpcfe/fbKgzltS/H8yXos8yMjEDpiBGsxykMgJcXMCtm/k2RX"
    "FlLKNt86+N4vgwD6g+WZ/hNv21J8429qb6tqfZyA70e87ou49Vs4/Yfw1+zGEwhWWPc3jx99"
    "xLfzy5GFKxrA1Fe9bm3Ve95b09wXdk7jzk0i3EH0liyavxs2hriTOoYtJUakDSUEicFzUgnV"
    "6QDQ7uw8463d01exrxPXvZsQ6cFprpJf60KsXSN/t52f9Ot8vGOIL+5+huZwED3Qo5vKfFWf"
    "6X+xQ0j1ecTV6HB8+j2m24vDOUehrIWiVUcx04BZeIjfjFvUljexbK7Qse7F5QtyOzlqOExL"
    "vFLZ0qVrEyns1n2InzNkg72oxqN4IgfwRNrRDR89Gw0U1xbpztUiCxu4XAaWZYadQsq44a+m"
    "1JGHkSnE4VbKyuv4a3KIlT8nqaprIRp7movTAX5Nh9lLlk+cCRyahpDS41DCDOtON/reGHbv"
    "QVS0CltKlv+Y4Nmzw9rS3DVsJfldVtJZH2IWP3KzgAYoZXn0E/E94XvppS6zmAPNiaeyHtAw"
    "S3mea9Xfr67fT0WwgeDqNFdz8Lya4dHow6TTyyykxmY1gOGzz8SFEHGhZIcSojsae8pbXb8f"
    "lAJbUVqcwcosYSuFEWrC4Q8xkfiOhfnxF7Ys8fI7T7QJeX/8yUOv6cW5UWQpD0qi6WXs2N1F"
    "qZAjeWOEVDJx7uUL629sEQBcej32dXN7/FhNQ4zNxZuU7WoGWzGfHGV89LJEytOnBtY/BHD+"
    "l0ChPpga++FIILBLtwwfS7MJbs9Pkl5fHARx+tRA5vq2Z/qXgZONbwolziglUspWwyg58NKF"
    "tbHt8v+bfwAlWleld2xSiAAAAABJRU5ErkJggg==")
index.append('palette')
catalog['palette'] = palette

#----------------------------------------------------------------------
paste_plain = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgFJ"
    "REFUOI2Nkj1oU1EYhp9zEktsTSla8I/Wwa0gSCKSDp2cHFQQQXBScImdC+ISwUW6OIpLl4Lg"
    "YB2cHBRB6CANOOggEUWdLBWpJTW59/txyL0xTTv4Lvdw7n2f9/0+biDTwxvTMyHGDwzJ3Tfr"
    "S18nhu9zhUfXpysWw90QwoUDBw9z7U6D9sZbAMYmz7LcuM2f9m/ceezYyq2lb08HAUUvhJVz"
    "ly5Pj5bLpJ/f4e5ot52nM3dqinj0JO525cWz5xeBnQAIJ0bL4yRb64gJX548AHfA2fAmjtNZ"
    "/05p8vgIIYwMj1AEwBQXIU4cwVRwt51zdrZJNrf33EERwM0wESztYmk3a/B/ygCCadpPNg+8"
    "/zlORwvgvV14GOHHvhnq9fOLZoaZISIfM4BikoIKpkoikcL+Sa7evEeSJMOhC+5OjDGdn59f"
    "7AOQFFfDxTB1TI1ut8vq6io+MFJ+rtVqiAj/GqhhYpgopgFVBaBSqeww5md3HwQYliouhoti"
    "GrHM0Gw2++ZBSK1WQ1V7gF56D2D5CCjuvmeDXP0GqGOpZTtQXAMWBIC1tbVdRndndnY2A7i/"
    "SZNkbuzYFG6Om1FMofCrjLtTrVZ3mfOnmVH0wP3XL1+VQ+B0/pFSZGviDKVSiRDCrgYAMUZE"
    "hD3fNhqN2Gq1FszskKoiIvmPg5n101X101/aGGo/AJPwfAAAAABJRU5ErkJggg==")
index.append('paste_plain')
catalog['paste_plain'] = paste_plain

#----------------------------------------------------------------------
paste_word = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2Nkk2IjVEYx3/nfe9MM8bluj7GRzM+ZiNRSEiRfO1QsrIaS6xQktRYWhEb2UgpZYGF"
    "lQUpKSnFgmhEqBGmywx37vu+55znb3HvDDNR/nXq9Jz6/Z/n/xxHS5cO9q5wSfKCKZI0cujK"
    "+8rU+rjc5f7etZa4M8653dOr3Rw4NUB9+AkAXXPWc23gJI36KBLXhd06fOXDzT8BJaXu1va9"
    "+3qnlcv4t8+QRMzr4+5sXtVDsqAPyfbfvX1nDzAZAG7xtPIMih9fCBZ4d+M8SIAY1lOEyL58"
    "pGPOonaca586QgkAiygEksp8LAYkmzxnNkYxMvbXDEoAMsNCwHyO+bzVwf+pBQhY9JOcz/08"
    "Rup/khWBcnUJlgnWHOXQBWTBCF7EEMcBEQseYsBiBEESGpw/soNSmvzVuTZScOLiy98AgkfR"
    "UDAkocLTliacvvqakSyyYl4ng0MNym0plekpz9+OEb1IJjqIRgxGDBELEYtCQJaLdjl6ujv5"
    "VjfmVkpkeUQFuN8Aw3xErWPeUNEMsgOwXDx+/h1fGEOfc95/LNi4sosktAAWrekaIhaa91g0"
    "A/W5+DQWGa55Ks4xOBRJnNi1qRuLLQBRmDcsGAoRhYgVAkG9YSS52LmhSnVmic7OhC3rZjG7"
    "0o5FUUJ66Itic9fCHmRCZiCg1kaSQiyMpbPb2L11Ac9ejVJWYNvGeaSJwyRKcpx9cO9+2TlW"
    "/7mm0XQPw7Wcs0eXg6CRBY739028f63lhEK4f/2w7QcfvSkaPvd51tHXW11m1gxbApkwcyDj"
    "F9XteNW2ODz6AAAAAElFTkSuQmCC")
index.append('paste_word')
catalog['paste_word'] = paste_word

#----------------------------------------------------------------------
pencil = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAY9J"
    "REFUOI2t0rFLW1EUx/Hvve+ZpyF5BNQQU2nFwRS1ZgitVaSIS6CULkJxy5+gLq1LwVUnBcW9"
    "i3SoUEGkrdChNC4aqdUh2mqUJGoIJq2giZpct7cE9YGe+X4O557fgTuWsPtwP/q8ppj07h0f"
    "iVpVUtLpSiRMo6pbt9vgbN93qkp+Ol5HEFKyPv+uKZc+nrY1QfJrUHn8I+juhwhpAFAu/OPX"
    "wmRZ2sF1oSl0U5BaneUiG+ciGwdAk/r5jRNY2MhTTC1QPjX4G8vgNv1k03/oHPwsNFv48BPq"
    "MoHR+BSRy1BI/CY49E3ANSlU4PMkDt9LstE1TrZ3CAz/tFzFDr5PBGzjigZfxlpU6M2MbWx9"
    "YSbyqKm51dh93DfOwc4iT0JFWxhAB7g01W7XwAeqHTVszK8Sy5doaOvhJLpE4SBD1/uVa9Oy"
    "LtGQGv9/TBB64GIrtkls+SNOr5dX4xs3Rq0BeFzaaJszR317mHLjMzL5I5Qo3YqtHQz01iqH"
    "lLwIePC5DarqzLnw22j/bfhe6gpUqroRWOTJnAAAAABJRU5ErkJggg==")
index.append('pencil')
catalog['pencil'] = pencil

#----------------------------------------------------------------------
pencil_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjBJ"
    "REFUOI2l009I03EYx/H39/eb/XRtQ9L8MyUXRmqZC0xzUh2UKCSkYwQhXY3+0SEvgYcO6kmh"
    "LKJTl+iQWOBBM4REkcjJmpF/ms4xRdfmpj+dm3P7dUqIUfyg5/y8Hj48Dw/8Zwm9jb7xuqy4"
    "P29pfU3kaElNMpq8XouSUW/QO2DHVxDVklaqmlsQksTX9w9t4ZX1p7oS+IfsWra1DYP5CEJS"
    "AEjFNnAN9KQkPTi3+gkGi2B58jWJ4CyJ4CwAsmTY/WeCfaxEiC8PkIoqeJwBzBYrwZUfnL37"
    "Tsi68OpbtD0vSnENIhwg5nVjv/dBwF+ukIZ3/RwoaCI4PoU6v0DZ/bF9l7aDke4y3TgtwWDn"
    "cc1x4zlGy3YaHvGEmJAsajyxY97c3lDDW6GuwU73YxngWUuJ7c71/HB5QxeLrn5yLO4/8ND8"
    "GotFhZyvcSiNNZdJKCElGPU1HDwmmyWAPYu26Lj2isLio4SmJ3F+dLG6XsG3vmGWpr4zHEvF"
    "TpfbSUpJ7IUXSYoEdafqAe3W/g4USWZztJvqIhOa04/z5RuW53w4Hn0Rka1QZoYw0VxxG4AH"
    "jS8ozatCIDJlgGyT3H7SGOZw5SVSxbUEImtoIsmVrmkBcMguteVaFcOnhX7OlV6lY+gm6k4I"
    "98xMTAaoLDG2T0x7UJcmiMyNoRnpa2qfPPE7nfWMKUvd/XnBlm8jGPWzsR1gzDXKZiTeo/sb"
    "a1sLOhCiVYBZAxVN6/3cu9r2C6KkCso2gDcfAAAAAElFTkSuQmCC")
index.append('pencil_add')
catalog['pencil_add'] = pencil_add

#----------------------------------------------------------------------
pencil_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAihJ"
    "REFUOI2l0ztMU1Ecx/HvfdgLFygkGlIQbGEQAz6GhiiGmIiLEOJmdDGMJC5aFxkZjNFOaFTc"
    "TFyMgyaSEMMj8UGoLC2IhRSUUkhbHhYoVFoKvfc42aXR3MQz/z/n/M7/fw7855KsFi77zhVn"
    "o5VLm2vSYWEIWS+NROzaofOq1Q0yy460MKo5faULSZaZHrjr2opvPrWUIDp8RlRU96CWHUOS"
    "NQDMvW2+Dj4yZSv4iPsJql0i5n/FQWKOg8QcAIqs7v8zQR5rSbKxQcy0xkJgnTJ7NYn4D87e"
    "eicplvDqG0QuglbTjLS1zl7kG2duj0jwlykU4P0oNkcHCd8kqe9hGjzjeVfQgw99DZZxQYKh"
    "h8dFy43n6PbdArz2aYpkKLKc283UmrKICsSzy6PmAwmgv8vpqm/UFk+0eVkJv+eUO1uAJaNk"
    "v+HSVZtW10RmepjZsWEjGQp5VICcXSy2XH9Jka2Y4ICfQNKgqqmVlG+UvZV1tidnwxc83vqi"
    "hY/w+R56eQUup1Pxh4Qn/xI1WWFnrA/30VLmAzMEvrxGr6yk0xuURtpUs8hRBx138tdVe6tQ"
    "hORSAXwzv7g49Jg6dzsZFETqBfrPKJ3eoARgyiKWnhqsKRm4STazShpI7SgYCnEF4KRT750I"
    "LpBamiA5P47QedvR62/8c1p3s6N8cy3eKtsU+UDZZXtDEI7LhpETXsu/cexabU96I94tm5LT"
    "lEXMRPS3j5r3fwOfHhQSlR9/5wAAAABJRU5ErkJggg==")
index.append('pencil_delete')
catalog['pencil_delete'] = pencil_delete

#----------------------------------------------------------------------
pencil_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkNJ"
    "REFUOI2lkt1LU3EYxz/n7GzL5dbImVOXiWBWpgbrTXshhBC66KYbb8I/IaOoLqKybsorhaKu"
    "u4kuChS8UKkUnYTpQA1RMtzmlObb5kvb2dk559dVkpgx6Hv58P08fPk+D/ynpGyNkaGzOeno"
    "gfBqTMoThpAduaGQy26tU7JdkIp4k8IoovpqE5IsM955tzS+sPoiqwTRnhrhLrqH4ixBku0A"
    "mOoaY13tppwN7PE/R3FJzI++IbM8TWZ5GgCLrGj/TLAF2xOk57swk3a+BxdxuopYXpjhzI0O"
    "yZIV/OMdQg9h951Cii+ihiaoae6VYJcr7IC1KI8nNOLJDW4nHFTcDGxxOzr41FaxA7Z5r5BS"
    "k/g8R3mQs7LNvy1B97PDovb6Kxyun9zqaAWhoZkGWkancH851b7zDIc+Mhb9rPc2x2xICAXg"
    "ZdOh0rJj9tkj9a1MDrylyp9GNzUuVzZhCBPDNDARLKzNUeU7x6aWUuJP+7URkbYpALpLzNY2"
    "vmaPLYevnaMEEwaqDQxhEl75RsbU0c0MGSPDenqDEwcvsJlJKomHg+pWB3bZwvpAG/7iXEQw"
    "iqqr6IZOgasEr+sQhfvKsFpyyHcWE5wLEJgZnFI3cFsA3LmWR5WOOPnHGzB9p1lMxBhUYnwJ"
    "D5gjc/1iONwn1lNxqbygmpFIgJ6p7nHrGv5QO6oE0HgpT9hkmYsVbrxOO1aP633DnaFrfxZc"
    "+URaOllS7+mb/jC610rdZAvarn/wN5XeZ8kUFk9EMay0oP+e/wIvJQ5kCU/z/wAAAABJRU5E"
    "rkJggg==")
index.append('pencil_go')
catalog['pencil_go'] = pencil_go

#----------------------------------------------------------------------
phone = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYBJ"
    "REFUOI2NkzGLU1EQhb+59/ryBOWxaLOQwPMPbLnYaZduW1t/gJWF5dYB2cIipLIQrBaScksb"
    "u5RiFQgJaYKBNGYhwZs7Y7Fs2GxCXqab4fKdM+cycGS1221rtVr2eO6OBagq/X5/Zx4eNp1O"
    "58rM3orIKfBSRJ6ICKpKvV4nhHAYEGP82Gw2qdVqm8cpJVJKqCre+8MAVaUoCs67JzwNylIF"
    "MJ5nkW+v/1Q7CCGQUkK88emNEJwhwNWvwN9/Wg1wzhFjRJyRecAMB4g3MI5zoKqIh8ufYAIi"
    "gIBZqgZ471FVrs9+o6qb8FJKFL7YC3D7AN3Fd27WXQaDAarKiy9fMbPqX7gHXOTv7pRf3TmY"
    "fXjPCfsz2HJwn8FwOERVGY1GmBmTyWQjULmCmVGWJQBlWaKqNBqNjcBBgHMOVWU6nZJlGbPZ"
    "jDzPmc/nmBnO7Z7OFlJEbpfL5bOHDkSEsiyJMbJYLHaucQswHo8/93q9i9VqtaUmIqzXa/I8"
    "//EY8B9+frUGIyWYHwAAAABJRU5ErkJggg==")
index.append('phone')
catalog['phone'] = phone

#----------------------------------------------------------------------
phone_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgZJ"
    "REFUOI2N0stLVHEUwPHv+d3rvSMmlx4EmsVtrOhB2iYZgughYStd+A/kpk20KYhW0qLFFEzQ"
    "YhSCFkGrwFWralMUUoNIaC0iBsFF2qSFjjlDl3tOq8QxUM/uHH58OI8fbDOKxaLl83nbWHfb"
    "BVSVUqn0X91fn4yOjhbM7LyItAF7RKRJRFBVOjo68H1/cyBJkht9fX2EYbj2OE1T0jRFVfE8"
    "b3NAVYmiiJ6xnTT7Sk0FMFqDhCe571t34Ps+aZoinnHrnOA7Q4DClM/yH90acM6RJAnijMAD"
    "zHCAeAbG9jpQVcSD4bdgAiKAgFm6NeB5HqrKs65PqOra8tI0JfKi7QNj1aeEYcjBr8fJZrPs"
    "fviYiSs55PACVx8M2PLvpeqvlcX7L+5N3224y+Dg4J329nYOJJ1k7QhRFGFmfNhfZ96mOduT"
    "o/f0ZZJwMVxYnb3YcshrbfiJ/3ZQLpdRVWZmZjAzJmZfc+poN6lL6W67RCoJuZNnALvmNo5g"
    "ZsRxDEAcx6gqi9UKTbKD/mPXAbjZ+4jOvV0IkmkAnHOoKnNzcwRBQKVSIZPJsFT9yedv4+Rf"
    "DQGQfzlEuTKFYfUGQERWarUacRzjnCOOY4Ig4MKJAd5PjRPg83x6hEB83n18A0hR1gOFQmF4"
    "cnKyv16v45xbD7PQ8mXfavOPXSYWGFQxGymNzN/+C5Xa3XOxifScAAAAAElFTkSuQmCC")
index.append('phone_add')
catalog['phone_add'] = phone_add

#----------------------------------------------------------------------
phone_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfdJ"
    "REFUOI2NkjFI1GEUwH/v+/7eaaVnZKBo1/+kloLGcAg6grAchKZoaGtqy6AxGiIOwqFBb2oQ"
    "agk0CFrMQZKGnEIqgjq9xLoaLDjTu/rzvdcgmWbofcvjezx+7/fe90GDZ2RkxAqFgv2bd40C"
    "VJXZ2dlt+WjzpVgsDptZXkS6gA4RaRIRVJWenh6iKNoZkCTJUH9/P+l0eqM4hEAIAVXFe78z"
    "QFXJZDKcHN9PS6TUVACjNZUw1vd1d4MoigghIN64cVqInCHA8FxE9ZfuDnDOkSQJ4oyUB8xw"
    "gHgDozEDVUU83JwBExABBMzC7gDvParKoxOvUdWN5YUQyPhM44DxlQek02ly74/R29vLgXv3"
    "WTubZWBpnMEzkaqzJcNGz01p4b+AweaL651z6wbLpw7SPj9N/sp10rnjUpubPPR2ZvL2M3u3"
    "uuUn/tlBqVRCVVlYWMDMWH3+kKP5CzSXppGxS+yZf0x8uMMH7No2AzMjjuONGEIgVV2muTMH"
    "A0N/m93qwpvE255RValUKmSzWRYXF+nu7qba1s7aq6fsfXKVn7UvrAErVU/wfN4ygoj8qNVq"
    "xHGMc444jkmlUmTyl3nz8gWVegtV38T3b8KHJQlmNrrFoFwu352YmBis1+s45zaD6bPWziMf"
    "y/taEmtT5z4pWjw/pXd+AxqQ6SH5TNNNAAAAAElFTkSuQmCC")
index.append('phone_delete')
catalog['phone_delete'] = phone_delete

#----------------------------------------------------------------------
phone_sound = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlBJ"
    "REFUOI2FkztoFFEUhr8zc7NZMWGJSkBIzFjZiJUvbAxEDYjaiJ2FhaLgI5BCEEELBQNiIbJG"
    "BAVLBQMKaiFYaGVIZ5oshGyCuLiYoNlsdnZm7zkWISNBore5xbn3+//zgv+cYrFoIyMjtl48"
    "+B9AVRkfH1837gBGR0fvmVm/iGwFtohIm4igqvT09OCc+zcgTdPhwcFB2tvbs8fee7z3qCph"
    "GGYfyheGz0rSfNv3tPgtA6gqhUKBvS+72OCUhgpgdOZSnu3/nkFnzw9d3yjp7aWleALYk9XA"
    "OYf3HgmNqweFWwPG7QFwBcdiohyqpZTPDp2TevNV8muZzjbdXT588mIGCIKANE2RwMiFRoAR"
    "YkhoYLCvnpBbWHhszcaxZLE+RNxEluPLWQrOOVQVCeHGJzABEUDAzPMq6uZ05Seo3YnePpfZ"
    "A0fvEzd3ZIAwDFFVXuyaRFWz4nnvKYQFAhGcC2j9rK9UcjmGZvPPHKwC3iyM8aHxjlKphKqy"
    "+f4TzIwjcz9wPoV641p5V/+Vjo0hLMdTfzk40nl8RXn7ioPqpTN0AaVNHXSVvl6UJPnYhn4h"
    "MSxOHqzpgqoyPT2NqjIzM4OZMTc3B8BEbzfbJt4/tHp8qt1BbfbHRPT9S3GNAzMjiqLs9t7T"
    "29vLqgBA3/Tnm7PdOyviW69XBytro6pSqVTI5XJUq1Xy+Tzz8/OYGUHwZ2X6qpOP+uanvq0Z"
    "ZRFZajQaHVEUARBFESJCFEWkaUqtVlt3Gx1AuVy+OzY2diKO4zVqIkKr1SKfz39YD/AbC5En"
    "GJC419IAAAAASUVORK5CYII=")
index.append('phone_sound')
catalog['phone_sound'] = phone_sound

#----------------------------------------------------------------------
photo = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeJJ"
    "REFUOI2lk79r01EUxT/fbwJGbJpWY38kUBB06NCkghTEVbeCi5N/gM6KruLg6qiDKA5KQVwE"
    "hw6lHVxEtwYdWlBBi2CRNsakTZp3z3V4X2wGFaEP7vIu99zDOecmSZrjIC9ZujPnf2tKjuSY"
    "nGDCTAQTIYhg8S8PUJ2dRmbgjruDpzjgBu6OSygImSE5CJyU1berEUAWaG58Y3e79V+bi6Vh"
    "xisT+wzcnN3tFkvn3+BO3O4DBdyqXGPo8BQgHt9+wPGxMcxECqBMheWd+yzv3KOXrGGCkFXf"
    "4PVWHe02cO0RTHimQRo5R9qnRz7RS56z0rlKX02CQT9ACNDoXWBx8yyt9gfMhAQmzxhkAMEC"
    "Z4p1zIxX3Yv0WY8gBmvtKi+aV7j+8eFvBpKTlxwFi4Kpz/tWg/lqma+dLp3cPFs/ZxnVJb5s"
    "nqPdnUAhR00eXRkECCbq5e/MHJukUjhJrSTkNT4X1xELnKo+RUSbteJYMADyJkfBMRPjh04g"
    "F8H3kAtHTBamYhYQQrg7P9TALSqfDyZkTuHIEN27L3GLYNHz/QxYlg3JKY+M4JlzeTOBJ5RG"
    "ywwPH0WKjenLN+hsLAKiUJ7j3ZNHuAlJ4JAk0cDk2c0ZH8z2vzb/8ZgOeo3pgaaBX8Zvm8vi"
    "QPw/AAAAAElFTkSuQmCC")
index.append('photo')
catalog['photo'] = photo

#----------------------------------------------------------------------
photos = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkNJ"
    "REFUOI2tkstLVGEYh58zc87gbUxLIYQgJIzMCrxAm6hVBEG0bNkyUCKI/oJa1CIIIlpFBC66"
    "t7CgRUQkVBKYBFJ0gS4mQ+ak6OSc+d5Li5NIlKt64YVv9fB7vt8L/zjR9WObJ92I1B1zw80Q"
    "BXNDzTAxxJ2hK1+6/waIzTzq7+/B5gKBCsFTRMDMWUjzFJubefJsfNUEsZiFUJ5NzvTcJYrA"
    "HSQo8+WUUmmRCwwSTFcHqHkuieoINSEfRSjOvod7u0wzhfdWob21ictHGmfMDFMQNdSdoStT"
    "7bGKIurMlVPycYSJo6r0bt+CzAcKzFINFaJcHhVjoRbT1Fzk6VimFQd1RISvpQr5OELVCZLz"
    "Wnk2OrJzisZoCRHDGwrUxwXW1bdy/L4RxH4pqNoS5E982b/FzTF3zJxX774z9MazJsxR/dGm"
    "VuH1qa5vBZtCVH99olgyOjFJR/saBvp60PlA8B+Ip1mdaiykWewnY+NAB7Waofo2Axwdnu4G"
    "GB4spqE8WzjcfZuNyVoaBD4FuDhwlv62jzw//w5Ro7FRSJJFRDOF3HIdapZLonrybYe4471U"
    "BdqAB9N7WAwbSKyMqHLw5iuq1aW/ANQQM1pqDewozlFq7UJyt7gx2Ufx6glC6EDEuDfygnuj"
    "L1H1TGEZIOKEoPRsXcO2pkHqmGFi6TRpeo3Olk3E57LYJ0fm2387pOVHMLEqcOBSiSj5Rufu"
    "9exiGx8ef4b4KWmqqNmfl7ii4IXRiUnUDFXn0UNDbaXG5f3v8xN2EHfLSCkXdQAAAABJRU5E"
    "rkJggg==")
index.append('photos')
catalog['photos'] = photos

#----------------------------------------------------------------------
photo_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlNJ"
    "REFUOI2lk0tI1FEUh7//zIRm6qSZOlqGkYELXyBSZqtyEShBtGonQYG7HgshiBYu3LjMhQTu"
    "WiSE6ELQLCixclNaig9SSBGT0HF8zOjcc06L/1RuAqELZ3MvfOfjd86F/zzecHud/etR1VA1"
    "RA0niojiRHFOceLfhQCKq8tRETDDzMACGGACZoapok5REVQNFIwAE+MTPkDFEV3+QXwjdqjO"
    "WeFsCooK/xqYGPGNGMNXP2KG390OFPC46B6ZR0sApedJNyfz8xFRAgCaSmFkt4uR3afsebOI"
    "gktVUuD9ehUan8R0HyeKpTII+M6+ds3xRfa8Xl7v3CWpUZxA0oFzMLnXyODaRWLb3xBRVEHU"
    "UgYpgBNHbVYVIsLbxHWSzPkQgdntYvqid7i/8OyPgaoRUjXUiR+YJpmKTdJUnMfKToKdYBPr"
    "W9Xk6E2W1i6xnShEXZBKNX8qBwFOlKq8n1SciFCUfo7KsKJWyfesOZTnlOy9IBENEd9N8Pn8"
    "GRLxTUJASNRQZ4goBWmlqCnO9lFTDCWSXsLK9CYZ2wEuN9RyKreMN1N9fPj6jlCGEnKiqBjp"
    "xzJJdA5g4sP8mfs7sFBWyo3mZiQgVEUaeTXdy4WKenrn+wmJKJhHOCeP7OxcVP2Rlt96yM7y"
    "IKAMvRzmiJfJtfLbADy40s3Aly7E6/cNFmZm/uz2784TbS2+gRrRsGNqZYyJlVHaGnvoGGoh"
    "PZhG0MA7zI+ra420nz4bflRf2UBZYQ3zq58YmxxlaXGz81AAH1LYgee1epBlsIVZ13jXatsv"
    "kFWoFxwnHhAAAAAASUVORK5CYII=")
index.append('photo_add')
catalog['photo_add'] = photo_add

#----------------------------------------------------------------------
photo_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk1J"
    "REFUOI2lk01IlFEUhp/55rOm/OvHzFHMjCgk0oIIom0FRdAmKNq1KWgRFBFCEC6iXbWqIIJ2"
    "bdpEEUH23yJqlUKRkhplYr/KqDOjc897WnyTuQmELpzNvfCch/OeC/95Ut3ntvq/HiVHckxO"
    "MGEmgokQRLDkLgZo2tSGzMAddwePcMAN3B2XUBAyQ3IQOBE9r3sSgCwwPvyVwlhuXp2ra2tY"
    "2djw18DNKYzl6N7xCneS7j6ngLONJ6hatAoQN7qusaK+HjMRAag8hUf5KzzKX2Y61YcJQrlK"
    "Bi9/daBCL64ZggkvzyBKnBPtzUuGmE7d4vHUUUoaJxiUAoQAvdM7uf9tG7nJAcyEBCYvG5QB"
    "wQJbqjswM54X91GiP4EY9E02cXv8CCcHr88aSE4sOQqWDEwl3uZ62dtUx8hUkan0Xn5NbGKp"
    "9vP523Ymiw0opGmXJ6nMBQQTHXU/2Lg8S2NmLe21Qt7Op+p+xE12DV4k+2yQeGSMYhxhQxkA"
    "YpOj4JiJlQtbkYvgM8iFI7KZVSx/0s+a/oj1BztZ2LqBQu8D3r3opr7wnTiYkDmZyiqKF+7i"
    "lsCSzJMdqBj5wrrj58kMPIXn51hcu4TVLS2MfugjNhN4itqlddTULENKIm07dIqp4fuAGDh9"
    "iUxDK+w5ObvmcVeWRSUlBoPv38/u9p/OPZ2HEwM5bXGK/Jt7VN45xnRhlDwwkUtTrEiTms+P"
    "e3Eg27WgqvJMc53FcTTMxPfAx9G0zRR1dl6ABNLcmf85cjRSqkWRfxF+dfdDnf8N94Opaa2K"
    "uRMAAAAASUVORK5CYII=")
index.append('photo_delete')
catalog['photo_delete'] = photo_delete

#----------------------------------------------------------------------
photo_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqVJ"
    "REFUOI2lk09olGcQh59vd3WVjYlrNtl0A7uQQNSGGAsiiJEFqZBAQIS2podiUdRzaw96UIQW"
    "2kBpT/UggkcP/utNSkwh9SAqHgyVJguaNmt2XQ1JTPJl87nvzHj4Fo2HQqEDc5kXnnn4DS/8"
    "z/JGvttt//aoaqgaooYTRURxojinOAlnMYD2ndtRETDDzMAiGGACZoapok5REVQNFIwIj+4/"
    "CgEqjoVnFarzi/9p86amRtKZtncGJkZ1fpGRj+9hRrjd1jRwLvMVDRuzgHL5/EVaWlsRUSIA"
    "Wk9hdOUCoyu/EHiTiIKrd03g7lwvWh3H9DVOFKtnEAmdQ+2PNk8ReFf53T9JTRdwAjUHzsF4"
    "cIBbL/awuPwEEUUVRK1uUAc4ceza1IuI8MfqQWoUQojA5HI7vy6c4Ounl94aqBoxVUOdhIFp"
    "jceL4wy2pyj5q/jRQeaWdpLUTyi+2MvyahvqouxQC6+yFuBE6U3N8mFDG9G/sjRPJUk3f8ZU"
    "ZRLbe43OrVfgty46WrdR7jrCxKtJxDxiooY6Q0RJRXP8ebtCliyHvziM7/t0PuvkzoNRdH3A"
    "p4eOsD4Wp1zu4uHDZoqFKWJOFBVjQ6KBx2dvEW3dz74v9/PtN0f5Z97jg0yGnp4eyqUyP/34"
    "M+XSDLktET4/eZri30+IiCiYR1MyxZKXpLEpCcCZ709Rq1UZGhqir6+PgYEB+vv7Cao+A7kA"
    "gMbNydDg6cQETozXS1CaKQJw/tQPOKcMDw+TSCQA8H0fMY/rE8qxfijPFPHWfp7u7u7tHR0d"
    "N/L5fFs2m9VYLLalUqlQKBSIx+PkcjnS6TTOubnp6enI2NjY8/cAQDSfz/ckEombmUymJR6P"
    "R80sMjs7e9zzvJlUKnUTWBcEgZRKpZe+7x96A1eLqBickWWRAAAAAElFTkSuQmCC")
index.append('photo_link')
catalog['photo_link'] = photo_link

#----------------------------------------------------------------------
picture = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAfJJ"
    "REFUOI2lks1qk0EUhp+Z778JJNDEkkqUtiC4KKJurN6AC1eCq3bhxu4LbrwIr8GfnQvduBGh"
    "6hUoCC6KWhHUpi39SdO0mXwzc1zEpkkjKvgyi5k5c55zzsvAf0oBPHz+9r445tu5pN38N69k"
    "+BhGkIU8uHPz8lII4IWFG9fq1SzLlFLBHyt2PDib82z5422gBzgwkqRpph6/2aHDFi21wtTE"
    "BlnUxIpney/jw6cSY3KekHHu3prCilYAIUCeg9YBWkFXN5iqbJDEX2maFtZZwiRhul7jy2qB"
    "clzB+4FxjjYe0FphZJM42mH3sIlxHbrWYqVNkiS0TcZ4phGkb8wwQCnEeozL6VjDYW7oeovz"
    "gMoR7wi1QuTYVd03WnqAlCqtdgEhwniHsQ6lYtqtIsV4kiDQIGp0BJHeCMXgNN8b65TSNcYK"
    "mkRZ9rfHWG/UqJWmCfVxch8gg4DoFJPZRb69e025+APlHFGnypmZBYppDef90LcY6mBlaxHn"
    "Pc57zplN5upn8cDq2jov9u/h9zzee+DliQ5EUMD1S0v9QDC7y0F7i3TtPZWri8wH0XFZ6RXs"
    "A9TR7YBcVsZlZUxlhlGdMDGJVROfly5MXAGlfqHkaI0kW9sl0r1QCBCHPHn66vOc8czKaMaI"
    "wgCiQB79/eU/6Cf91tSW+ziqFAAAAABJRU5ErkJggg==")
index.append('picture')
catalog['picture'] = picture

#----------------------------------------------------------------------
pictures = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2lkjtoVFEQhr85N7vXfcYXxGhhpWgRH2Dho7ATFhHLIDaipVUgghHExlIkCVHsxM6o"
    "INpp4QPsLIyiECyEFRWMYfdmc/c+95yxUJP4QAR/GBiY4eOf/xz4TwnA2OSDkVql1AgiLYoY"
    "xFBVS7i8ZcmT+P7l0cblXwF9ALVaqXHq8LY15UpNVsyqP5puknPlzosjwJ8BC10plis1uf1o"
    "dvBL6+PqhdQZBdSu8oqmav2CR5aJOzv1ZDZJ4unx0caFnwAiWrHA4mK25vih7X2lcg1Fsc7h"
    "UfWKBY8k7XlWtH719sww8DNAVbrOUW1HVvxShbtP33nzrY4JYkFEUOdjRPBENqQ9GTg79TRI"
    "kuj6+GhjpO8HSRWsc17mPIKONScP76Jcrv0pdAnTvH/q1swJYGTpBFVQNdZIyQtCpVyuMfup"
    "w7PmGfrr80RZzvu5dezfeJG92zZhjJGlE0ARlMzOY3sh1ik9oOcc1eocpcJaHCmu2ORzO8Kp"
    "Q9D6coiqn7WXbSj76z2/UMcYgyosRhntJMFqlzBPaUUJbVJQQaGzBIji+OH49MyO3MlQluZY"
    "F38DJI7mpy04/zVhHhG0N7N1wP/9H0ycaUwCjF15stMvuE3gDzoHQWzZOTDG7uYIb96+Jzh4"
    "iV7eQwFB6isy+KYoiu+N33y5BzVHBeXVh9Pkec7zLCMbLJC9HibPc44deI7qrw+0QuemHjfn"
    "W4EuhIkGYaJBGGt7cbnmWh09f+1Z+zcHy07S6YmbL/c5zJDxQJB+RRdw3xeMEnajG3/x8O/6"
    "CpzoNySLFUW+AAAAAElFTkSuQmCC")
index.append('pictures')
catalog['pictures'] = pictures

#----------------------------------------------------------------------
picture_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAn5J"
    "REFUOI2N0ktsTFEcx/HvuffO3HvbYRpt6ZSSViq6GEWlqbITQWJDYsWCiC7aVUOCsJCwYGHb"
    "hU0bOwsibJB4LKQREuLRRYM2gnb6YsaYdm7vPedv0WpNWfjlbM7ifPJ/HNV39+VV0RwuhOLN"
    "hvwdKb06MfAdek8cbOkGcIxwZP+Oumrf95VS9j+ExRQN6Cjk1sP3R4E5YDoQ1/N8df3Jd4pM"
    "kVeD1K8ax4/liMTw7YfPwIckZdKEQyWnDtUTiaUWKgpDsCwbS8GslaG+ahw3/olckCfSEY7r"
    "0lCXYnionIp4FcYsaQnAAJalCGSCeOw72ZkcgS4yG0VEUsB1XQqBT6VvIUjJYBYBpZDIEOiQ"
    "YhQwEwbMmghtABUiRuNYCpHSqVoAInOARzX5QjlCjMBogkijVJxCPkEiXottWyCqBHAWAEuR"
    "sFfzNTNG0hulrNzCVRE/v5UxlkmRSjbgWKWPARz5E4itpNbfwpdXj6lIjKC0JlasZu36IyS8"
    "FNqYpd9isYLBqQ60MWhj2BBMsL1uHQYYGh3j3s+z2NlybJPgQl+R6Zni8j2n0+fvX3l7yRER"
    "FLB3a/eCaqezTBem8EbfUNXewaYPL5mcHqSlaRtrVjTyeOC2evZu5GJrV6pivqvSwrRfQVC1"
    "nlz6AGLHeDHwhM0bm9GWpjm1G61C2tLtgHQ5blzlMGGyeVUbKDVPye8DwGRujJhKsK/pOAAn"
    "d13j7tseFHc8J+5w4+ajj9sDQ1qWTmg+2Xw2OTDSz+uRp5zZ3cvlB8fwbBdBin/v5R9p7Uxd"
    "qmtInmvftJPGmi28z7yi/81TPg/nrv4XMIfUXEapTgXLBPKI9DzvyZz5BYdFEGtMczAFAAAA"
    "AElFTkSuQmCC")
index.append('picture_add')
catalog['picture_add'] = picture_add

#----------------------------------------------------------------------
picture_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnpJ"
    "REFUOI2Nkj1oU1EYhp9z7k3uvU00gaTWKLFNCxUpRbSL1dWhipMgDlZ0sYJbxcEfEAcRF2dH"
    "xUkHHRShxKpFESd/EJUWW3+gtmlL7U9Mmpt7zzkO0dbUDr58yzech/d9zyduPnh9zSiOlALj"
    "VgP+lalf7Qh4NjdOHOzqB7C1offAnmyj53lCCGsNwooqGlQYcO/xp+NADVD2jeO6nrg1NEeF"
    "WYpihFzTNF5kgdBofix6fBhN0GC2YZPizKEcoZFi2VEQgJQWUkBVFsilp3Gi31jwi4QqxHYc"
    "WrMZvnyOkYym0XpVJAANSCnwzQzRyBzzSwv4qkI1DAlNCcdxKPkeKU9iMHXFrACEwIQaXwVU"
    "Qp+lwKeqQ5QGRIDRClsKjKlvVQIYUwO4NFIsxTBE8LXCDxVCRCkV48Sjm7AsCUbUAexlgBTE"
    "rc18L0yRcCdpiEkcEfLzRwNThQyZRCu2rH8MYJu/AZENbPJ2MP7mKcn4BEIpIpVGtrT1Encz"
    "KK1Xn8WKg5HZPpTWKK1p92fozjajgc+TUwz8PEfH+zm2jo7z8foirfHUuoG98mzPoL5qG2MQ"
    "QM/O/mWq1TlPuTSLO/mO9O4+el/kWR+8pP3YeZxcB0vv8vLj8/zlR2a4ZNdS1RtTXhLlJfHT"
    "bbULzN+m62g/7tgQPLtMQyJJS3Oz9WrY9NtOVCygg8T2pl0gxG+U+TMAvJqZwt2Yg/2nV7Jf"
    "ymAZ0WJHbe7cfTLW7Ws6zeqGfqstllpXfvtQxu6fwl8qUAaKixbKYuLff1lDzw9nLkXjsQvZ"
    "tLJtOU5xJuRrwVLVir74X4AaJHu2PDtxUmrRrKX5rjHX9w3qK78AHboTpoxuNtgAAAAASUVO"
    "RK5CYII=")
index.append('picture_delete')
catalog['picture_delete'] = picture_delete

#----------------------------------------------------------------------
picture_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsxJ"
    "REFUOI1tk0toVGcUx3/ffc4dx9zgjEmaEMNEsVgJIRYfabsqUgbbCm3RjYLFtoLdRcSFGxdd"
    "WeiqBbtQfKzsokWQLkpfQrVgKe2UGkxiTZhiTNRknMnMde53H9/XhZo0mv/uwDm/8+B/xLnL"
    "f3ymU/YFsc5EMc9LLw8tGzyLsx+9+/IIgKU0+996tXet53lCCHMFwpJCBWkS882Pt94HHgMe"
    "Se1mMp64cOUhIfM0xDjFzvt4dp1EK6oLHqP/+GT1JizyHN1TJNGGWJwojsEwTAwBkTFLsXAf"
    "16lQlw2SNMFyXfp7X2BqchXtTgGlnlkJQAGGIZD6AY79kFqrjkxDoiQh0QGu6xJIj7xnoNHL"
    "DrMEEAKdKGQaEyaSViyJVEKqABGjVUq/8xu1b09Qyg345TNvaMLpAxaA1o8BGdbSCGbQpo1U"
    "AVGSYpseQSPH9jVzlDqqeIX9+MUhalMvcvO7058uAQxBzuxhevYefmaG7CoDVyQ0q1nyjSZ7"
    "txVo87dQvX0TR0Ssbusil1/nW/r/ALuDbm+IO3/+THvuLiJNKbou77y+lfb+nciZizhZQaU8"
    "RtSS86FsvrI4wfj8IVKlSJVio3zAcG8fwq7TPTiEv34X4fSXGE6CnetDtKa0CuTO7SPfT1ha"
    "awRQ2jKyeFlzoEZt8gobutfjb9hNOH0Kw06IForMXStzPXswOHDovTLAE0cs96ucmyCfcejY"
    "/CbR7GlMRyMX+rh39Xfc0hfU3WL6NNdwHVFHxQx27mCwa5jV/96hs1UnVj3M/P05ipCg2sPc"
    "9THWvH0Kty2PbSx1tByLr77+6fawVAxoDV1T5/w9h88wfvEoE7/8irtukLB6V1V6jzxqXqul"
    "llnDNvX5pwDBM/rkw5fiYx98bGGklH+4RGXyVrOt4L9WOjn610oP9tz75bPx8crkKElzXkk3"
    "vWqgSrtO3hhbqRjgP0S/OQvINsGhAAAAAElFTkSuQmCC")
index.append('picture_edit')
catalog['picture_edit'] = picture_edit

#----------------------------------------------------------------------
picture_empty = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAWRJ"
    "REFUOI2lkj1uFUEQhL/q3We/jSAhROICRA4s5CuQYJGZgIQDwD04g0GOCHBCDJIvwAUQZ0AO"
    "QLJ3t4tgZn/8bAQSrRlt92xXdVfPwH+aAN59+vrWIyc/e2+v+zuyfDNsN9C1nL46PnjdAqR5"
    "8fTo4YOu6yQ1uGKy1rDBnmIzDj3nn7+9BArBryvvb7edzi5+MI5myCzfMRlGM9Z4TJNp3jx/"
    "xOAQQAD0PUQ0CFGWFo2Tq+JLkLmSMzm55M1ASQgTEhZYEAGeRe4QzCAZSYRMhpAhVPpNg71M"
    "dSawF/BSUTSahIJcNtafCApJRKni0HKDAifEaj4zgSvBUtnECqxaPaVCvEuw7qBoXd0CVZpN"
    "2Nh3dWDPiRF1opNuCaWRWcD1Yc0EqqchSNYkIu3Smdft7wxxf0+XZH/v2eF90KTd09oxMQzX"
    "bKL8agH2Wj58/PL9yVXy2LcRt6xtYNP4/d8z/8F+Az0BqUJGOLNpAAAAAElFTkSuQmCC")
index.append('picture_empty')
catalog['picture_empty'] = picture_empty

#----------------------------------------------------------------------
picture_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAodJ"
    "REFUOI11kU1sTGEUhp/vuzNz53ZUf1Q7tKVTUdpk/JVQNtUNCzZEIqmFTVlXbMTKksTCFgmR"
    "sBA/UWsiIhGkUpJGSikNUq2atmNm7p1773csSmta3uQszlk8Oe/7qqv3X56XkO6cL/Giz2JJ"
    "6RqJghPhSs+B9l6AiBGO7NvVuNxxHKWU9Q/CvFwDYeBz58G7o8AsIO+JHY876tqjDC6TZNUQ"
    "qbpxnOg0gRh+zDgMDldQJq1EWMbJQykC0WruI98HrS20gqIeI1Uzjh37xLSXJQgDIrZNc+MK"
    "Rj4kqIzVYMwCSwAG0FrhyQSxaIapwjRe6FIMAgLJYds2Oc9hmaMRpCSYeYBSSGDwQh838Cj4"
    "HkUTEBpA+YgJiWiFSGmqGkBkFhBnOdlcAiGKZ0K8IESpGLWuxfG1oySiBRD1H4BWLLHq+TJW"
    "hzu5hDKpplxVozLVpCXL+pZO2uzHi5rR8jcgWstKZzOZgQzBqxEY+Eh66jupNV0sXbGZBnlK"
    "MPN+cYgiMDR5jNAYQmNo8SboaFyNWKDLipTXVBLO9NGwoZuJ4Zso9s8DRAQF7N3SO3e00lPk"
    "c99JfH5IMn0Y3Jc8v36PHT2n+DT6lGo7FZ2zMBtJabKhU4mJWiSqmimvymO8ERBD+PMFqc4T"
    "1M/0xZ+c3VkOoO2Ymsb4bKzbwcZkBxuSHaRrt1Ix+ozKVZsw+deIKdB+cB2m+JV4/C1NbV0a"
    "3F4Adelu/zkxqsMzpP9UvNJ9HNvWZJxki0P48zkiRfpvv6H9YCvKqgBnDy8unx5XgdldWupv"
    "Pbuw/XO6+0a9pT8iQWaBRY3lrOPb4ABDfWduRf4F8L1ivP/igYIYQYyZHRHmdwFjwEjyFyXO"
    "K8TQjiLkAAAAAElFTkSuQmCC")
index.append('picture_error')
catalog['picture_error'] = picture_error

#----------------------------------------------------------------------
picture_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnxJ"
    "REFUOI2NkUtsjFEYhp/zzz+Xv52qTFt1a5NWIilp3OIWEQkhFlbCioQNsbCRsLNDiMTOigWx"
    "x0JiJ0hKIkHaBVFUtVXKZNR0Ou1//nP5LIoat3h331k8ec77qqu3nl4Qx76qkVxi+D1Se4Zp"
    "iEKuHNq95hhA6IX9uza1tURRpJRK/YEwm9iDs4Ybd14dBGYAU1qyuVykrt0bJ6ZERfXT0fqJ"
    "KF3GiufzRMSz143USRchTRzf24GVQP0wMgaCIEWgIAnG6Gj+RDYzRFlXsM4SZrN0ti1g8E09"
    "czPNeP/LlwA8EAQKLUUy6XG+TJfRLiaxFitVstksVR3RFAUIUlPMLEApxHq0M8RWM200ibc4"
    "DyiDeEcYKERqWw0ARGYAOVqoVOsR0mjv0NahVIZqJU8+s5BUKgBRfwEEinxqEaNjrcSlPHVS"
    "oEEVsJ+bGBtZQNBwiaF4L8bpWoD8DEjPY2G0ivHecWzfIPS+Jf2iSHvTOrQzLG7u4sT1jTiJ"
    "Z1f4btBfOozzHuc9S3WRZ0tyiE9I/AB6+giLCkvpmr+eSlzl9rvdc7ZcbMnfP1qcDEUEBexc"
    "feyHVqr7C32959i+/ABOPM47PML78gjdizcxmUzzZPh+ec05CuGMS22zLppLbBOceIZKrzDe"
    "Yr3BOMOErrCybTOTZip4NNhTCrMZVcabxhWtG0CpbyghtjHWWVrntGO9w4nnQ3mYQn4+T0ce"
    "0DPQU0wcO9Tlm0/Oi1cbtaf754nvlvY0xklC4hNim7CkeRkbOnfwePghPQMPpyb05Nqxszyv"
    "HfUfWXZKVde2b6279/LOqFFse3+afoD/BnScpOokVadxnR/PMPj9/StnVEQ6CNH4CwAAAABJ"
    "RU5ErkJggg==")
index.append('picture_go')
catalog['picture_go'] = picture_go

#----------------------------------------------------------------------
picture_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAqxJ"
    "REFUOI1908trVFccwPHvuffcO3PTiTOYV2M7xKm0pYVQtS7MZFHUCqG0m4KrKrZgs3IjlEL/"
    "AXdddOWm0FZQtDCCuLAtGt2qqCCKjo8x1kdiXpNxvJP7OufXhW3Umva3O/Djw+911M8nLn0v"
    "hi/CVPJJyqshLz+1B4Hmp68//3AfgLbCzk9Hy31BECil3BWE5xFZMFnKsdO3vgSeAZ1Ycvl8"
    "oA6ebRIxT1vVqQzMEHgtMrEsPAm4drtIl7yHpodvdlTIxFHLFaUpOI6LoyBxpqn0zpDz79GK"
    "22QmQ+dyvFUe5G7jNUp+L9b+qyUACziOIpZZfK/J4lKL2EQkWUYmIblcjjAO6AkcBHlpMM8B"
    "pZDMEpuUKItZSmMSm2EsoFLEGrSjEJFXKxB5BuTpox1OIa5HbEOSzOC5AWG7QLc/yIb0MOn5"
    "GcpLFf8fwFkGHEXBfYOH0wNE8wW6ZDXdajXZQg/T9wepeg2q7zcZrO5mff/V/MX968YAtLwI"
    "eP2sCTbw4PIZSoVHKGPwoj62lIf4uNKg+O52wnsnKRSHVFZu1U7ulT3LLdTnxzHWYqzlnXiW"
    "kfIQFmhMPSaQE5SG92I618j3vklkHrDmo/Vd2dOFA1pEUMDYxn3Lg3GHF+mE8+SnrtBbHacw"
    "eYq0OYnjzqGcEH/VHEQdnk7FrlYr3KsJSpighPU9Xr91CC8QbDaNYxfB6UbShBtH6tH1m61x"
    "nfNVC5sWPxjYDEr9TQlR4zeiydP0bxpFkj9Qps2N32N0HJEkRup3F3fuOvJnTfuao7WJOyOx"
    "ZfjFFW9Rxwtvj25zk7kDaF3k6kQiF8JPIj1UTX3SQ199t7X2vx/nfm3sXPx4v4T1z+TCDyPt"
    "H3ev27VSnv4v4NHk7KknrYm1YbOzdPvmzLd7frnz60p5fwHrfz+i6Py9YQAAAABJRU5ErkJg"
    "gg==")
index.append('picture_key')
catalog['picture_key'] = picture_key

#----------------------------------------------------------------------
picture_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtJJ"
    "REFUOI1tkj1sW1UUx3/3+j4/v9jBVmPj2lBHcaYSLBRY+Ijwmkjp0EqQqAQJCbVDFlSpSJW6"
    "dUtFGLtSsTHQDkgIBj4ihMTQUhYITQqVQ/wVpylO+lI/v/vuZYjU1KFnO8P56f9xxPWvfl22"
    "Ee/5oU30Q/4/dnBVDniKz86dee0CgDKWhdm3TuQ8zxNCxJ5BOJyegUiH3Phu/QPgALAfWDeR"
    "8MTnPz6kxwP2xF3G8lt4ThdtDTu7Hr/fSzNkT6IY4eI7Y2grxRNFYQhSxpAC+rLFWHYLN16j"
    "G+yhI41yXconCtz/O0kmnsWYI5YADCClILAd4s5D/n3cJYh69LVGWx/XdfEDjxFPYrEDwRwC"
    "hMBqQxCF9HTA4zCgbzSRAUSINRFKCqwdTFUCWHsASJBjz09icQhMRKAjhIjj76VIxYvEYhKs"
    "GACoJwApSMVeoN5qk040GUpKXKF5tDNEu1WgkC6j5OAxgLJPA5znKXqTbN75gUyqgYginF6O"
    "0vgCqUSByJijb3Go4O6D80TGEPYjjnUVynmbbP5FNu+v0ti6glEBI51JvtmdYLfVeW5xcfHj"
    "9fX1a8paiwCmX71ApCN++vpnhksZ5ubm8H2fzfFxfrmVJSYls2dP4SiHZrMpbt9OXK3Vajl1"
    "4OpA2Opvf7Lf2Wf27Bk+vbbMH3dWKRwvUKlUaDabLH+yTKvVojj2kn7/3VOqVqudl25cdDEh"
    "r+Rf59E/AcPDaQAufnSZsK+Zn59namqKmZkZpqen6ff7vPzmaR8gk8m4Kq744svv/3ojMFTu"
    "bYVxtd9MAOLS5Staa62WlpZIJpMA+L5PFBlufXu9O/nhQrper/cGepmYmDhZLpdvVKvV46VS"
    "ySiljrXbbdbW1nBdl9HRUfL5PFrrnY2NDbmystI6WmysWq1WksnkzWKxmHNdN2atldvb2+eE"
    "EPVsNnsTcIIgiBqNRsf3/dP/AfNHPiyjImtpAAAAAElFTkSuQmCC")
index.append('picture_link')
catalog['picture_link'] = picture_link

#----------------------------------------------------------------------
picture_save = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAolJ"
    "REFUOI1tk72PVWUQh595z3vOueeyeG/CwoqbNa4FhoIQlwh+dNpYkBhNqLAwJiuhJCF0VNgp"
    "xr9ADY0hRhuoICqNBqNubIgSFBU/dtnrsrv35n6857xnxuIaLusy3RTzzMzvNyMfXVo6bzXH"
    "+5U1yortYVtTn0Lh+XDxtUOnALwarx99YW53URQikjyEMImRQh0rPvv81hvAGDAIljcahVy4"
    "ts6INXpyk/mZVYp0k2jKvW7BjZ9bNG0/nl2cPjZPNCf3J6oqcC7BCZRuhfnpVfLsdzZDj1hH"
    "fJ7z5Nxefr29g3Y2jer/VgJQwDkhWIcsXWdjuEmoR5QxEq1Pnuf0Q8GuwmHYFmEmABEsKqGu"
    "GMXAsAqUGqkVkArTGu8EM9s+gdkY0GA3vf4ylqQs/3iGnTkMyoifymjqkJV/erz3yS3Uktab"
    "71y3L5f+PjIBOGEqmeWvlbu0GssMByNePPwUryxMcfn6n5w9vn9L5wvXOqjKN84eBKR7eKx4"
    "mvUf1hmEinu9CMDV7+5OrIzQDdDZKBHRyQo3196iVqVWZV/osJwJiUFVK+dPLqA6li/BaHoI"
    "IdDtl3gzQ4CXF07d75Ic2ODbK45RqHj74m84gVgrWuvYAzMwaKaKH1/EVmXrok1UI9SRxKWA"
    "IdSICKaGmRJjRVlGfJ7JJlq1Ds48CyL/oYze4HtS8Zw8upOoJeDAwERp+Ix3P77DWrePzzwX"
    "P/3il+eCcuBBi2u1VkKKMuSDpRNMNx9HcHQGf7D4zPs4GgxCiV989dCZbV8DHDv3tT3xKMxM"
    "9Xjp4GHa2Sw42BjNsmdHpJmBF0EeVgywcOLKV/vmiufbeZuGf4SoFaKKWI3KgJ/u3Ga1W/Ev"
    "ihM9QElJFpQAAAAASUVORK5CYII=")
index.append('picture_save')
catalog['picture_save'] = picture_save

#----------------------------------------------------------------------
pilcrow = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAQVJ"
    "REFUOI1jYBhowIguoFz70FhDhWumqiSbMcO/fwwM/xFyF2792nMgX9wVWT0TugGGOtyrrJTZ"
    "jZX4mRgkuZkZLt79tWeCpyDjhVu/9iAbBgMs6AIy/MxKvCyMDAz/GRj+/2dg+P8XIv7vPwMD"
    "A8NfDAMwXHDx3q89b7/9Y/gPsw1G//3L8P8PpgswDLj76EfYjjNfVj9494fh28//DP/+Qmz9"
    "/x+rAzC98KhD/v0jBoaw55kPBbV02XfDXfIH2Tl4XAA3aLr8+6/f/r1ngDv7Pzw8iDIA3db/"
    "f2EBScALKODvf7ij/xEbBmj6kTgM2IKAgAv+IWn6i1U/EQZAwX8cCWngAQBtXmpqweJ9mAAA"
    "AABJRU5ErkJggg==")
index.append('pilcrow')
catalog['pilcrow'] = pilcrow

#----------------------------------------------------------------------
pill = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnBJ"
    "REFUOI2lk8tLG1EUxr9rZiYTH5m0iQ+opeBjZzctmE0FW7svWLoIgrjrpvuitZvaB7jon1AX"
    "unChCKW4KkYQRSlRcSHTShHM1KFoo8lM7p3M3Hunm5pqSR/QuzlcON/vfOece4H/PORvCfl8"
    "vltK+UAI0SmlfNfZ2fmWECL+CWCa5lMjkXimR6MAAEopHMexi8Xi9XQ6/e2PlT9sbb34Ytuh"
    "7/uh53mh4zghpTQsFArh5ubmSTab1QGgrpZ4aXX1ZSqVGmtOJuH7Phhj8DwPjuNAVVU0GUZC"
    "0bRHNQHZbPZ5e1vb6JXWVlQqFfi+D845hBDgnKNUKiFhGOCcjwKAcl68Nz090SDEk1Q8Ds/z"
    "EAQBpJQXAEII6LqOCueXLziwx8Ym2qLR8WZFgZiagszlIIRAEATgnFdjPB6H47pwXfdT1cHH"
    "TOah3tExrieT4Ovr4JYFYprAwAB4X1+1sqZpkFLCNE2UKL0LAJHFrq5oS0/PenNvL4KNDXDL"
    "giyXISlFuL0N4brwu7uhaRrqYzFYOzs42t/PDI2MrAGAEgpxrU7TEJZK4Pk8JGMQjEFSCsEY"
    "IvPzaJAS6vAw7OVl+Llc5v7k5OxZ60qJUp/ZNmShAOG6PwE/IEokAm1hAScHByicnmZuz8zM"
    "nh98ZK5cLq4JMdiSSLTohkF8y4KgFLJchkoIVClxQgiOdncHby0tzf269joChF8t687eyopF"
    "Dw+D+mQSEQBNjY1QggCHjGHPtgfTprlQ69FV/8Irw7h0VVXf3Ghv748TEvcohU2pPGDs3tDx"
    "8WIt8QXA2f11LHYzRkg/D8PPlLH3jwHnd2IA+A6tB2AzrCYJagAAAABJRU5ErkJggg==")
index.append('pill')
catalog['pill'] = pill

#----------------------------------------------------------------------
pill_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsBJ"
    "REFUOI2lk01oXFUYhp8zufOTNjOTOmlnghZKJ4VqaCuUGilUpFFwY3aCdSNdCdWuXNTGdtMf"
    "yUpwU8RNha66leJCi4PEpMXSpIlIpqmRtpnOmJhMZu69c+6dc88514USrRQV/ODl23zP+76b"
    "D/7niH87WF5e3mOtfcMYU7bWXiuXy18IIcx/MqhWq2fz/f3nMuk0AFJKPM9rtNvtfSMjI+v/"
    "mHxrdvbio0YjVkrFYRjGnufFUsq42WzGMzMzG5VKJQOQeBL8zdTURwMDA+PbCwWUUgRBQBiG"
    "eJ5HMpkkm8/3O6nUe080qFQqF54plU4/XSzS7XZRSqG1xhiD1hrXdenP59FanwZw/grfu3Ll"
    "/FZjPhzI5QjDkCiKsNY+ZmCMIZPJ0NX6qccaNMbHz5fS6TPbHQdz+TL29m2MMURRhNZ6c+dy"
    "OTzfx/f9xc0Gd48deyeze/eZTKGAvnkTXashqlUYHUUfObKZnEqlsNZSrVZxpXwFwPlyaCjt"
    "bNv2ad/OnUQ3bqDrdayU2CBAXL2KaDTQY2PMPviOW0vf4soWfscN1v21t4ELPW/l8+Udw8Mn"
    "s8Ui6s4drJQYKbGdDkZKxPw8006NxfRPHD54iNFDr6HS68k1+fDo1qGebMKVUgWNBrbZxPj+"
    "n+p0sL6PA1wPF3h+7wFMwnBg8FWMiHhx32Egfjfx5srKg8W5uR/chYU4OTiI6XR+1x9wUmtW"
    "5TpJ0cfYsycBeH/0M8o79iMQmYSAeKVWO3pvcrIm6/VoS6FAD5Dt68OJIupBwEZrJfqxPs3E"
    "18cBmPjqOEur88TEYQ/ANaXkHik/X7t//7kt3W7JUSrV3tiIf263zd1W6/Xp4cRDT/360q7i"
    "LtZkjXZnlam5SdxW95O/P5P4uLf3YK8QL+s4XpJBcP0UeAAvnChNIMQJAdkYPOL40veXfvng"
    "N7Xcjy62u4hgAAAAAElFTkSuQmCC")
index.append('pill_add')
catalog['pill_add'] = pill_add

#----------------------------------------------------------------------
pill_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArRJ"
    "REFUOI2lk0toE1EUhv87M5lMa5tUk9JELbWvjY+NLrpRFHWjoODCR3EtbtzoploVii/EhVvd"
    "VemqiIiiLqoYofgAtbUWZGppUZJOSDVpk5neO5m5D3fxQVHBA4ezOf//f3A4wH8W+dtCNpvt"
    "llIeFEJ0SikfdnZ2PiCEiH8ysG37fLyp6YIVjQIAKKVwXTdfLpc39fT0FP+Y/GZ8/PJcPq+C"
    "IFC+7yvXdRWlVJVKJTU2NraQyWQsANCWEz978eJKMpnsb04kEAQBGGPwfR+u6yISiaAxHm8y"
    "TPPEsgaZTObS2lTqzJqWFlSrVQRBAM45hBDgnKNSqaApHgfn/AwAGD+Lp4eGLq4Q4mwyFoPv"
    "+wjDEFLKXwyEELAsC1XOV/1CkO/vv5iKRs81GwbE4CDku3cQQiAMQ3DOazMWi8H1PHie96lG"
    "MNXbe9zq6DhnJRLgr1+D53Igtg3s2gW+bVst2TRNSClh2zYqlO4GAONxV1fUWLnyZkNrK8JX"
    "r8AdB5JSSMZAhodB8nnw/ftRfXkH85khsOwMVFQvrg6DowCuGkqINs00oSoV8GwWkjEIxiAp"
    "hWAM+t274M5bKCOHzYeOIdq+AezDSOLj6MilJ8pe0iqUBiyfhyyVIDzvRy8tQXoeDADzEw/Q"
    "tf0ArJnnILd7UT97D+vakrqAOmkcKRS+3J+YmEym0xvr02lCJydrBBFNQ4RzcBXASrUDe0/V"
    "LmYMpKErsk4jgCrkcjunR0dz1HHC+kQCOoDGhgYYYQiHMXANRfr+ETCQRrWPYKGPoFL4CqEr"
    "RweAh0FAuym99e3z5/X11WrKCAKzvLCgZstlMbW4uK95Q+NcqeBs1UxdC/UllIsKs44mBFfX"
    "fn8mcr2ubksdITu4UjOUsad9gAsAo4dbT9Oic1yTpE1qak5C3djzVF75Dt+WlIxV1ggdAAAA"
    "AElFTkSuQmCC")
index.append('pill_delete')
catalog['pill_delete'] = pill_delete

#----------------------------------------------------------------------
pill_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAr5J"
    "REFUOI2lk8tvVHUYhp9T5lrKTC/TdCpTiDM0DQiJEU1NjAkRcGtcmFhZuDHRhRtXhlpjQqm4"
    "MBp3upFF/wFjDAtBR5JWMNohBKUX0hBmoEMjHTLnnPmdM78rKxqJRE1819/zfO/mhf8Z798O"
    "Go3GuLX2NWNMxVr7XaVS+dbzPPOfBCsrKx/m+/tPZdJpAIQQBEHQbLfbhyYnJ7f+8fOvV67M"
    "3Wk2nZTSxXHsgiBwQgjXarVcrVa7X61WMwA9j4N/XFz8uFAoTA8PDSGlJIoi4jgmCAKSySS7"
    "8vn+RCr17mMF1Wr1dKlYPLl7ZIRut4uUEq01xhi01vi+T38+j9b6JEDir/CN+fnZncZ8UMjl"
    "iOMYpRTW2kcExhgymQxdrQcfadCcnp4tptMzw4kE5uxZ7NISxhiUUmit+fTiG8xVXyW7M00Q"
    "hoRhuLYtWJ2aejtTLs9khobQly+j63W8+Xk4fx6tNUopYi0pFfbz3jfH+H35Gr4QxwAS5/bt"
    "SycGBr7sGxtDXbqE3tjACsFHx9dx5g9k9XOk1jwxOM7+4iRB3OGL6285mTL3ARLOmL09qRTO"
    "99GNBjaKMFGEtpLjB9/EOIuxBotjo93gUOkFQhl5S/WL7cOfMJjwhZBRs4lttTBhuC2ItcQ4"
    "y62tGyir0VahjMLvBjw99iKhEj2/3FzY6nl9c/PW2tWr1/zlZZccHcV0OphOh1jHaKMZye2h"
    "mNvLaL5MckeW4V27qTUWWVhf+LOjeNYD+Kqvr3BwYqI2PjFR7IWkuH2bd6YaxFIirSRS0lWG"
    "n/KeL7/Mb/WfubD6/V1pOHr3DNe3t3Amnx8YSya/fqZUOpLzvFwsBE0hbD2KXjlx7965A7Ne"
    "57k9L/X+tPbDHeVxdOM0q/D3MXmfZbOHs553RDu3LqLowvsQADw5Q8e4Hb1dTHlzjpsPgQci"
    "x43qOw9HCAAAAABJRU5ErkJggg==")
index.append('pill_go')
catalog['pill_go'] = pill_go

#----------------------------------------------------------------------
plugin = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAeZJ"
    "REFUOI2lkb9LlXEUxj+vP3Lwx0v+QBKzIG7mvWJrNLa0CEH/QFMFEUVbTSENjdHS1tDS2BQO"
    "ZYZjZaJxJ4sraKjULVSy1Pc85zS8JtbNGjzLFw7nfL7P8xzYZyV/a45M3SxHqCTzMNno3dP3"
    "h/cC1P3ZuF2+0Z4Epf6WfgppITH5qX8pqAGMDN77upVtrmeRsb61jix7918Ld6ZvhbuQHLmQ"
    "eQy0n0jMjZmlmVXLJLnqzIyH5x4f3A1oAJCL480FPByPIPBE7kRAsauUKkSE87rytkZBDpBQ"
    "OB7O4rd5VjZWsDA8grqkHvfgWFrAzPYAmChXy7Q1pnQ39/D5exWFcjuxiVwYoqOlg/OPhsPM"
    "MBOjl58nv53x+otLUewqUv4yjdzxEBaOQrQ1pvS29uEeBM745ATPrrxMGnYDzIRCmPJX28ty"
    "YfVCnocc27M7Fq6NXQwzkTalyJ0ssjwTF+Z5Nr2tfczOv2d+eWHL5QekXQAzUeoeQARzaxWK"
    "7UM7F/FwKqsfkDsLyx8ZuzrRVBNiZoYhpj9NMdh5ksryHIvVJSTRmXZytOdIbmOvK1hmyJ1S"
    "xxAmZ7G6xJMLTxOAsw/ORN+hw2QybFt2LcCMN7OTmPJfLNPGr4HMzMdfTSD5D0lrNYT91k+9"
    "LGHVm8vdaQAAAABJRU5ErkJggg==")
index.append('plugin')
catalog['plugin'] = plugin

#----------------------------------------------------------------------
plugin_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAk5J"
    "REFUOI2lk99rzXEYx1+fszM/2uabc46M5EbH7JzZVgotbkhSK+UfkISaIrmZK8kFF0ounAsl"
    "uXEpIRd+JpKYtc0RuZiSzhYHww6b7/PDxbGMbVx4bp566nk9z/v99MB/RpiueKS3u+iueRVz"
    "Ubl2rONU50yAxJ+Fw8UDqeDkm+qbyEbZIGpr/7bBFMCRlpMfvsfjldhjKt8rqMQD/5RwtO+Q"
    "mymqhpqiYt6cWhHEhP6h/k8Sq6ppQkQ4u/XC/MmAJICasrwui7lh7jgW1Ax3yC3IR+qKu/Fo"
    "8MmUDaoAVdQNc6M0+pqRsRHEBXMnEWowc5ZFWURkBoAoxXKRebURC+sW8+5rGXWtyvFx1BRB"
    "Sden2Xa+00UEEeXanhvhtzPuv7XbcwtyFN/3oWaYK+KGujKvNmJJw1LMHMe43XOX6113QnIy"
    "QERRV0SrWX82qyn2cZw3L57z7VuFyvgobpVfEvbd3OUiSjQ7Qs2IPa56YoqYMavsZObWsGr9"
    "Gpakstx5domHxXus3rvoRGJicn5hM41RI68+D5JLtZJPtZJPt7My044MVWhf0YYmlLZFm9AQ"
    "s3ZlB+B7kwCxCILS97aXlkwbg8OvKJWHUFUyUYaPn8vUhnq2NO8E4ODGM1x5WiBweU4SQGJB"
    "zcinWxE1SuUhLm6/GgA2Fzb46Oh7npUe0F+6T/emcxy/voM5NbNxfKwKEOHxyx5EFRFBYh2b"
    "MDYWMRrqwsOBB6GjdR1XnhaYFZLc77sLhNPTfuN0sbqr8TghdAVocPiCe+FRYbj7B+j6ZCOY"
    "8ddgAAAAAElFTkSuQmCC")
index.append('plugin_add')
catalog['plugin_add'] = plugin_add

#----------------------------------------------------------------------
plugin_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkxJ"
    "REFUOI2lkztsjQEUx3/fvbfx6OPTl9Kg9bhavU0ZDNINgxCJxCImMdBEgtTE4hHCKBYmg8Vo"
    "ECpp69lFVKu4g0iUSNzb6EWVtuo7D8NtKW0ZnOUkJzm/8/+fkwP/GcFMxVO9R9PumlIxF5W2"
    "c80Xts8GiP1ZOJFuLQucVF1RHckwGYjahr8pmAY41Xj+4/dofCTyiJHvI6hEz/5p4XTfMTdT"
    "VA01RcV8TVl9ICY8zT79LJGqmsZEhMs7rpZOBSQA1JTVhUnMDXPHsUDNcIeGylSorrgbj/p7"
    "pinIA1RRN8yNzNe3DH0bQlwwd2JBHDNnZZhERGYBiJLOpSkpCKkqrGZwNIe65u34OGqKoJQX"
    "lbPzynYXEUSUtpaO4LczHr693xsqG0h/6EPNMFfEDXWlpCBkSfEyzBzHuPP4Pu0H7gaJqQAR"
    "RV0RzWedaFZTVj9/xaont4hnBxgrLWa4upT2SQuHOve5iBLOCVEzIo/yOzFFzFj3PEtzLkb9"
    "7lbmLE8x9qydhV0dbNycOJiYnJyqWoPivB7up6Gs6edFzI2V3Xeo23ucua/uwYMzzA8XsKKm"
    "hp4X3poAiEQQlL73vTRWrKV/4DWZXBZVpSKsYP2nEeYuWg7bjvza/snFxD2ozSuIBDUjVd6E"
    "qJHJZbm250YAsOXiJh9bUMRo300Krx9gfGyAUeDLcByNk5mwIHS/fIyoIiJIpN8mJ0Ui1ltb"
    "HVQ8fBDUlM0jES/gy6DwZiBQd7s44zfOFF27lh4d/ZBpiVlQYzF/Z/ilrZ129gc/GGu7vdAB"
    "ewAAAABJRU5ErkJggg==")
index.append('plugin_delete')
catalog['plugin_delete'] = plugin_delete

#----------------------------------------------------------------------
plugin_disabled = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAZZJ"
    "REFUOI2lkkGKIkEQRX8VMgomjGWhVZ6hLzBHEO0TuBcXghfyDrprBPESw+hWXKiIVFI2iINW"
    "/JhFU9nVYzuz6A+5CTJe/h+RwBflfVacz+e/VPVJRJTkS7fbfX4E8P8uzGazOoCner2OMAw9"
    "Vf3xLwd3gHa7bW+325kkrtcrROTnfyMsFgslifyIiDabTY8kdrvdSd7kk0Sv1wuKgBIAkEQQ"
    "BFBVqCoAeCShqoii6LuqgiQ2m82dgxIAiIhrPp1OuFwuyAG+70NVEYYhRORzAEkcDgeUy2UY"
    "Y3A+n12cLMsczBiD8XisIgIRwXA49EoA0Ol0PACYTqdarVado7yRJJIkQRiGCIK3EaxWq3cH"
    "uUQExWHmsYo1ku6uA0wmExURVCqVDw1FF7VaDfv9Htbaq4h8y0FuiHEcQ1VhrUUURe51VUWS"
    "JCAJay1Go1H54Ra22y1arRaOxyPSNAVJGGPQaDTy/3G3Bb+YPY5jkESapuj3+95gMPCstS7K"
    "wzWKCNbrtbuUZdnvwmC5XC5B8iIir3eEr+oPEYZlHzhAeKUAAAAASUVORK5CYII=")
index.append('plugin_disabled')
catalog['plugin_disabled'] = plugin_disabled

#----------------------------------------------------------------------
plugin_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnpJ"
    "REFUOI2lk01MVAcUhb8HjMQAzlSD0+JfRxwRxtbU1qIG49ZE0266cNe4kF3buKsrY1xoTIwx"
    "mrioTVdturRJ04REF/hvVEQZoyVVGkdAgUEgDLx57/50gVEQtQvP8ib3yz0558J7KnjT8GDX"
    "j3l3zamYi8pfh7ee2PU2QMXrgwP5fYsDJ9dU20Q2mQ1EbfO7LpgHOLj++GgUl0uxx5SiEirx"
    "3f+1cKh7v5spqoaaomLevHhdICbcGbwzLrGqmlaICD9//dsHswFVAGrK2pos5oa541igZrhD"
    "S30uqa64G5N9nTz4dbdX1n5CaaQTwv5vZwCqqBvmxsDkY8bCMcQFc6ciqMTM2V4Nran1LFyz"
    "jWTmM8b6mrjfceboDECU/EieRYkk6ZoGhqdGUNcZO15mrQzRVt9K3fIvGH14nwVBRN2iD6ld"
    "sjI5J8Yfzrd7S30L+WI3aoa58rE9Z2/DRlKrd1Ae/J3pYsDQ31OMhyFBWGqak4KIoq6IKmLC"
    "yrhI+0cbSDXuJBz4iSDxnERtHUQFTk09ofW7s71VAN+f2+siSrI6iZoRe0xD8Rl7Gr8kueYr"
    "wv7TVCSEaCJDofMqx+KIgtmrFESUXLoZxembeERrVMOW1EaW5nYSPT1D5QInHF/FwIVrVEal"
    "zC/7rv87p0ixCIJye+gmmf5JtgZp1Fcw2HMSI6Q0uozHl29xIA5pnrX8EiCxoGbklnxKujBA"
    "S1s71YVL9P5xme6OUW51XKQjk+Wp2rwmvrAg3Oi9iagy9fAZ0b0/yWzYxvhwkX+67nE2u8wG"
    "e7qmVXXijVWerW/aUtOfN6arNjWvxhPlK+Xh4T27jvQ8mv8FM/oP0stc969CNkUAAAAASUVO"
    "RK5CYII=")
index.append('plugin_edit')
catalog['plugin_edit'] = plugin_edit

#----------------------------------------------------------------------
plugin_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlRJ"
    "REFUOI2lkztI1QEUxn//ewvt4b1pD+1hoqLmvSZGBmYRDUFEQVAQUTg0SFAQSEtNIlFRS0Vz"
    "Q0QtRZCDS03RZGkpRuSg0sPqdi0VX/f+z6NBSMkeQwfOcL7hx3fOx4H/rOB3Ylv3uT53TaqY"
    "i0rH5cYbB/4EiPwqtPa1FAROsmp5FRXxikDUGv7mYAGgrebat2yYmQw9ZDI7iUrY+88VLrw6"
    "72aKqqGmqJhXF2wKxISeTz1jEqqqaUREuHXwXv58wCIANaVyWQXmhrnjWKBmuENidTKurrgb"
    "nQNdCxzMAlRRN8yN4Yl3jM6MIi6YO5EgSrkJ24MoPaZ/AIjSl+4jtjhO4bJ1fJ1Ko66oKVHP"
    "UK9CSekh9ky2M3L7gIsIIkrHycdBBODS9uvBlZ03g9RECjUltJBQBTGhTkJKi/cTW7uF6nCa"
    "veVJGjc3ICoLUxBR1BVRRUyIqVA3nSFv1Qp0vJ0NNScoS7/DVBHRuRXOPGl2ESWeE0fNCD3E"
    "3KifylCcaIKZbjrvPqKh+Twrv6VIffiIyjwHIkqysJqieBGD4wMkCmrZlVPMtlgNeflTWGYQ"
    "3NCJ55TtPssxlzcXQ2I/AaEIgvIy9YL1yzcw9HmANQO9rNhYh0314jbN1sNVWHaY3Nx+CmuP"
    "VsNMy5yDUFAzkitrETWKvrwnWb6PpXlpXEYgiNL1sB8wbKaf1ZUlaDZ7+mlrIhEANN0/MhuN"
    "KiLCqbHvvuP4nSAaGcLlO+DzTh0huqSKL69f8ba97cFvv/HZ1S1pF1vq5rjZbLszNzuYgXnX"
    "D0XfcRIVRjM3AAAAAElFTkSuQmCC")
index.append('plugin_error')
catalog['plugin_error'] = plugin_error

#----------------------------------------------------------------------
plugin_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkpJ"
    "REFUOI2lkklvjWEYhq/vtEgRJ45KS5AY2moPJRFR40KjK4mfYCUSC2GHSESEEgvTUiRW/oCk"
    "C0OQ1KyNNtWkRI8OOlFR7dFzvvcZLKqImhL38l5c7329eeA/E/2qPN58qM1d0yrmotJQv+nC"
    "zt8BEj8Xx9oOpiInXTG7grJkWSRqNX9aMAVwfNW5D3HIZ4MHsnEWldD6V4UTzw+7maJqqCkq"
    "5pWplZGY0NLfMiJBVU0TIsKVXdfm/ggoBFBTymeVYW6YO45FaoY7VM1PJ9UVd+NJZ9OUBRMA"
    "VdQNc6NvrJuPuY+IC+ZOIirAzFmeLENEfq1w5OEBV1XmTEtSMquE9uFW1HVCxye0pg+9IR+P"
    "M5xYiIgiojTsvRklAE5tPB+d2XIpGhobQk0JFggqiAnBhODCeMizqLiSaeOvqUmvR1S+K0xG"
    "RFFXRJXpg28wi3ETVIQFqXIqSzcwmsty5+FltGDFd8D+W3tcREnOSKJmBA8kLGZHevc3BcPp"
    "G+lh9aLNjMXjNHXfY91pkoWTL6dLKlGczKdOqlLVvOjtQN3oGn5FMEEsEDTwKT/K2sVbGQuf"
    "eZxpHC4ECCIIyvOhZlYVr6FzIENOcogKJXOWIF8/s3+km9TsUpp77tP4uvFdrNRNLAiCmpGe"
    "V42o0fe+Hw85v/rgLLHHUU5ilhenqVlWx9OuRm513BiIldqBetq/KghPXz5DVBERJGju+r5M"
    "EcD2i9u0EKW591EiShRx9+XttxJRO1BPx7c7+JcsPUpWvWBmHl02eJLMZP8F6VyE/27oGIkA"
    "AAAASUVORK5CYII=")
index.append('plugin_go')
catalog['plugin_go'] = plugin_go

#----------------------------------------------------------------------
plugin_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApZJ"
    "REFUOI2lk8FrHHUUxz8zO5OhTLKbTRO23TZGE9e2SdOLF4lIUMhBLIhFbDxIT61QgtKbHkoo"
    "PUgOEvYP6MGLlx5yEHrYWiWnQrCSyIKYgiVLJ2PYtaZkp+lm3/s9D0GordWD7/g9fN7ny+PB"
    "/xzvn8IrP35WN9MJFWeicuOLqerp5wH8p4P5+qUBz5g41nuMSqHiibrX/s3gGcCVk4sP9rqd"
    "rGtdsr0Mle5P/1nh6urn5pyi6lCnqDg7MXDcEyespWsPpauqTn0R4dq7XxefBAQA6pRX4grO"
    "HM4Mw3nqHGYwPjRRUFPMHCu/3nnGYB+giprDmWOz3WD78TZigjPD93I4Z4wVKojIcwCi1Ft1"
    "8mGBUlym+aiFmu7XsQ7qFEE52HuQM1+dNhFBRLnx8U3vb2f89NYFGx8ap/77KuoczhQxh5qS"
    "Dwsc7XsB5wzD8d0Py9Qufu8FTwJElE5nD/k5R3lnlCNDR7mb/EL68gaSd+zc3uPFQy+RNlPy"
    "u0VmZmbiAOCTb8+biNIX9HH31j2OHzjF2XNnybKMsftj3Lxdw+/xmD3zIVEYkaYpvXd6qfXU"
    "5oO/Nk+UTnBv9T492wd44523mK9eJqmnHD50mMnJSdI0ZfHLRZIk0Xw+X5ubm3t7Y2PjQgDQ"
    "FUFQ6mt1pganAWhWUtorO8zOXqJYLNJut2k2m1Sr1V3f998Hsv7+/mjfoCuocwwfGSZtpADY"
    "N2HNc/6bCwsLYRzHAGRZRi6Xi8IwXAJIkuSxB/DR9Q9MRMi2dmElYOrV1210ePSPIAgGtra2"
    "WF9fJ4oiRkZGKJVKiMiDRqPhLy8v//b0N+amp6cn4zheKpfLQ1EU5czMb7Va5z3PSwYHB5eA"
    "sNPp6ObmZjPLsvf+BGH3XbKWFZEWAAAAAElFTkSuQmCC")
index.append('plugin_link')
catalog['plugin_link'] = plugin_link

#----------------------------------------------------------------------
printer = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI11k09IlEEYxn/vzOw/Wozoy8NeQkEks4I0UKhTqJQgIniKQIguVnjqFqRRhwghCOsi"
    "FARBoFepbhEUQaeQLumqYRa7n9Wnu+q335/pIG4q2wMz8D7zPj/eYRhhl7puvR1KHUxd0tjz"
    "iAjCFlaIwiD1a5XH7x+cvc4+ye7iwr13lec32hNKCdZue9ZCsVThxac/rCxsbn6fmz/06tFF"
    "fyejdgOUVmFCKxZ+Gxb/aL6uCl8K0HDkAP3tORqaMplKNv10T2bvPCI7phKprh+/NjmaDbja"
    "eRhtzGBNwPj4eMYSK2vBaDBa0EowWphbFT5+C0klNCSIBwcHM3sAo6OjV0qlUkEhSQsYUSgg"
    "oQUjQiqpSSc1FoUWlTTGFAYGBq4AqLGxsa5cLjfZ29ubVUoRAyLbVxArJLSQMIqk1sSAUprh"
    "4eFsY2PjZHd3d5ex1o53dHRQX1/PqbUJHt6f2f9SVb0B2oCmpmv09/eztLT0xIhIc0tLCwB9"
    "fX00Nzf/FwAwOzuL4zg4jsPU1FSjiaIoGUURAIuLiziOg+u6NcOO4zA/P09bWxsAnueJCcOQ"
    "fD4PgOu6+L5PqVSqCchmsxSLxWp/Pp/HBEHA8vIyABsbG4RhSKVSqQkIw5ByuVztLxaL24Cd"
    "QDqdZnp6GoCtrS3K5TLr6+t4nofneVhraW1trfYHQYDxfT9eW1tTdXV1uK7LseMnOezU15yg"
    "WPjJ3Tu36enpYWVlhTiOMb7vT87MzHQGQXAic26Em72n2aiABWJriSJLEEVEcUxnxxleF3KM"
    "jFzGWvsZeLnnNw5NfIgSWivsP8/u2kWEIIziZ9c79c75X1weDC74Rf6dAAAAAElFTkSuQmCC")
index.append('printer')
catalog['printer'] = printer

#----------------------------------------------------------------------
printer_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAspJ"
    "REFUOI11k09onGUQxn/zvu+3u6FLxObLxqwF20CIiZgULBJLEbFsoIaGEAgecqkEL6kexEsP"
    "HpKDoJSAIE1BC4UWekqoqFTpRUtjJVUJpWkhtE2Tso1p+m1MNrub3e/Pvh76x2zVB2ZgHnie"
    "mWEYYRsyn1w6En8uPqSxBxERhDJWiMIgvpZj4srxAx/wDGR7cejTy/7ZD/c5SgnWPuKshYcF"
    "n3O/r7N8d2vr/u07z//45TuVJxq13UBpFTpacfcvw+K65lZOuLkKexp30L8vzZ7Wujo/mThd"
    "o6mdR+QJqUSexp9rW7yUDHj/jQa0MYP/aTA+Pl5nqSprwWgwWtBKMFq4nRNm7oXEHQ0O1cHB"
    "wboag9HR0eFCobCqkJgFjCgU4GjBiBCPaRIxjUWhRcWMMasDAwPDAGpsbCyTTqdP9fb2JpVS"
    "VAGRRyuIFRwtOEYR05oqoJRmZGQk2dLScqqnpydjrLXj3d3dpFIpuvIn+OLzC89e6ikuAq8B"
    "ra1H6e/vZ2lp6aQRkbaOjg4A+vr6aGtr+18DgLm5OVzXxXVdJicnW0wURbEoigBYXFzEdV08"
    "z/uX8Pr9GW6u/Ea+tM7X0z5v7z3MxsaGmDAMWVhYAMDzPCqVCoVCobbrygxrZp63DrzOrp2t"
    "/HTjG76fO0m2FKGCICCbzZLNZimVSoRhiO/7NfHHvZ/Z+3IXkYroas4QSUD3q/sJd65jgiDA"
    "930AEokEU1NTAJTLZYrFIpubm3jpBziS5FD7MAAfH/yK765PgPoWU6lUqvl8XtXX1+N5Hu2v"
    "dNLgpmpWGD0/xI3lK1xbnuZY5jSfXXyPhI5jq6A7OztfnJ+fj83OzjYV24f46N03aUilaWpO"
    "0/hCMw2NzZT9MjO3LrC7aTdeKctGcZVfrl3GuxNM13zjkRO/Ro7WCvsPZx/nlQdnyOV+oFrd"
    "wsIm1k5cnVg59je0DB4LdkOhyAAAAABJRU5ErkJggg==")
index.append('printer_add')
catalog['printer_add'] = printer_add

#----------------------------------------------------------------------
printer_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArxJ"
    "REFUOI11k01olFcUhp9z7/1mJhqiMl8mZqTaBGIw0gjVRQrFTUlAAyEEgotsFNFF1IVZu0hA"
    "hVICBVE3QheWFkqCoNgWcdEf0VoKEUkDoTFOwmg0fonJ/P9839wu0qQZW184F+4L73PO5XCF"
    "Teq88PPx8LbwgMZ+hoggFLBC4JfDy0tce/jFp2d5R7L5cuTSr6Wb5w45SgnWrnnWwptMiW/+"
    "WOHl83z+xcyzHT9eOVpcz6jNAKWV72jF87eGxIrmryVhahGa6rfSeyhOU0tNTak28lVVpnoe"
    "kXVTiWzUwnKePbVlTn0SRRvT/7+A0dHRGktFWQtGg9GCVoLRwsyS8HjeJ+xocKj09/fXVAGG"
    "h4dPZjKZRYWELGBEoQBHC0aEcEgTCWksCi0qZIxZ7OvrOwmgRkZGOuPx+I3u7u5apRQVQGTt"
    "CWIFRwuOUYS0pgIopRkcHKxtbm6+0dXV1WmstaMdHR3EYjEOpK7y5effv7upDd0DDgItLWfo"
    "7e1lbm7uuhGR1ra2NgB6enpobW19LwBgcnIS13VxXZexsbFmEwRBKAgCABKJBK7r4nnef4LB"
    "77fwH49TSM7yoCHOru7TrK6uivF9n9nZWQA8z6NYLJLJZKrCauIu2xcesffYacJN+8k/vcfU"
    "g++IJvKYcrlMMpkEIJfL4fs+pVKpuv3Db2k5MUTk2U/wy0W2bNvOh7v38PGf02uA9UAkEmF8"
    "fByAQqFANpslnU4zsPyayM4mODq0wTTDjdSLjykWi5VUKqXq6urwPI99+9uJurGqAfwrP5B7"
    "cpettwcp5l+RA9IpzbLV6Pb29l3T09OhiYmJhuy+Ac4fO0w0FqehMU79zkai9Y1o4OVvd1CO"
    "UNZZVpcsMwvKPk1F7lf9xuNXHwWO1gr7r2f/OT+av8UHU19Tl35NoCrJCvb6kfuVy38DHtEG"
    "lWyKINkAAAAASUVORK5CYII=")
index.append('printer_delete')
catalog['printer_delete'] = printer_delete

#----------------------------------------------------------------------
printer_empty = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAbhJ"
    "REFUOI3FkbuqGlEUhr8dJUxARHCjiF0aUUyjEAw2aRI78RlMp00eQR9ASCMhYB4geAHbNKZO"
    "I4iVoCiIhU7h6Iw6zjg7RVA4iRxOlfzNgsW/vnWD/y3xZ6LVaikApRTXqJTC8zyUUlQqFXEX"
    "0Gg0Xpim+Toej//I5/Pouv4ALKVkMBgwHA7fbrfbn+12+3gD1Gq1D0KIT9FoNODz+e52vubW"
    "6zWTycS0bftjr9f7Kur1+rtYLPY9k8kQDoeftPdyuaTf7zMajd77lVKNXC5HJBKh2Ww+CVCt"
    "VimVSiwWi89+IUQilUoBUCwWSSQSjxaPx2OklEgp6XQ6L/2Xy+X55XIBYD6fI6X864BXSSmZ"
    "Tqdks1kADMMQftd1mc1mAOi6jm3bmKZ5FxAIBNhsNjf/bDbD7zgOy+USgMPhgOu6nM/nuwDX"
    "dbEs6+bfbDa/AdcCTdPodrsAnE4nLMtiv99jGAaGYaCUIp1O3/yO4+C3bdvb7XbPgsEguq6j"
    "adoNFgqFHkxwPB7pdDoUCgVWqxWe5yHK5fIXx3HeOI7zKplM3u283++xLIvT6QSAEAKl1Aj4"
    "9tjH/o1+AT4I/p9ln6obAAAAAElFTkSuQmCC")
index.append('printer_empty')
catalog['printer_empty'] = printer_empty

#----------------------------------------------------------------------
printer_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvFJ"
    "REFUOI1tk11om2UUx3/P87xvPtZkdpp0W4uEZsT0A6Jju6hfYzJbmB2lVIq4IQyGN1VB2e0u"
    "2gvBIQVBpggDQdGrVoeieCHoVHTTrb0ZYmtN0tFNSN7MNnuX5P18vMg2GvHAH8458P9xzoEj"
    "2BajZy6ejD4QPaHQRxBCIGihBYHvRW/VeO/nt596lf+E2F4cffNH9+PXDppSCrRu97SGqu3y"
    "6ZVNbpaazRtrf+365t3nnHseuR0glfRNJSn9Y1DeVPxZE/xegf50F5MHe+nPxeNuIvZhh6dz"
    "HiHuNaUQ9/X3rSaZhMfLjz+EMozp/wXMz8/HNaHUGgwFhhIoKTCUYK0muHzdJ2oqMAmnp6fj"
    "HYDZ2dlTtm1XJCKiAUNIJGAqgSEE0YgiFlFoJErIiGEYlampqVMAcm5ubrS3t/f8+Ph4QkpJ"
    "CAjRXkFogakESWeJvspbBF4dKRUzMzOJbDZ7fmxsbNTQWs+PjIzQ09PDo/VzvHP2646zmCrk"
    "2GMbpIeP8dPiGQ600uRyrzA5Ocn6+vr7hhAiPzQ0BMDExAT5fL4DcOf6lxhqkJ179zOw+wJ7"
    "cqOkUilSqRQLCwtZIwiCSBAEAJTLZVKpFJZltQ/kW8QrX5F94jhB/QvSQ8exLn2O7x1FSMXW"
    "1paQvu9TLBYpFotYloXjONi2jW3fhup39AxMQWuJXz/6hER3kx1OibUrF+57DM/z2NjYAKDR"
    "aOD7Pq7rEvXKPNhlktzVIKiXQIcE9m/0Hz7NH99+gJ3ZSbVabQNc1wUgFouxuLiIFJon00t0"
    "P/sSYeMyOmxy4Pk8oXuTWNcqe/NHWCt9j+d5SMdxwnq9DoBlWQwOF3imkGTf8GF2JC20XwOh"
    "uPrZKhAStlZJP5JB3viBPUmNKhQKfSsrK5Hl5eXddwZP8MYLh9i8dJbModeRhkKYDyNjA/Tt"
    "fxoZG0BE9mF05YgmMnTXLl7r+MaT534JTKXki7dPo4IWOtR3Fd5VOxeB0yQMIdRX/wWFizbq"
    "aFYNDQAAAABJRU5ErkJggg==")
index.append('printer_error')
catalog['printer_error'] = printer_error

#----------------------------------------------------------------------
rainbow = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnNJ"
    "REFUOI2Nkz9oE2EYxn/fd99dcynttZfDlCQtNFIcBKtkUQdBxLWFFKSCKIKgi4hOxb0uOnRz"
    "6uDsrKBopVPBDq04CMnYkhRtL2lSS8+Yex0u/isV/Ob3+fM+z/sp/vNVbW4J3FBwAvAEDKDU"
    "fwCfCpSBwLt+RevAR/U5KK0J5xcw/wJWbK4hPOornRp1L5zDGnQxww7UV7DcDs7py6QfcDRB"
    "1bAocNW7OevaxTy69RHHNLDQqHwyo2yFNkcQVA3PUUz7c3dtJ+uit9/gFGzQGhl0iYMBxEsj"
    "uRG+eaW/CaqGRRTT/sN7tlNIYbeW0FkbGUoT53wk0w/GSoaNBVr/JqjYXBO46s/dtZ1CCmf/"
    "HSqtiUczxAUfUjY73zu8bzRZ+9omlxljfn31DwfCI+/mrOtkXezWUgI+niUu+IhWvAy3ebUb"
    "UutEdEW4ONTlIO5l0KuqYI/n0DtL6GPWL+U9iXlWr7HcbtIRIWhdwts/Q949ydlKLwOB8vD9"
    "28rJOjgHVrJzT/lZvcbbVgM3GmcsnOF8cRKFohtLEkXvwgJr0EV/eQueJs4lO78Mt1luN3Gj"
    "cSajO0wU82x8blPdaLIV7kUi6oMRuOFdv6LNsINFUpVk+tn53uHVbkhHhLFwholintVPW1Q3"
    "G5ESpl48Kb8GMApO6MCH+goqD3EwAMbifaNJrRMRtC5xvjiZKG82ohePy6k/qzeAp/ocLLeT"
    "lOGlAVj72qYrgrd/BoWiutFECVOHD88IGKU1zunLKFshuREwFrnMGBeHuuTdk3RjYSvci37a"
    "PuxAhfMLpB+ANvDNK4HWzK+vchDD2UopcSbqw1H/5gfe6eb284OcNAAAAABJRU5ErkJggg==")
index.append('rainbow')
catalog['rainbow'] = rainbow

#----------------------------------------------------------------------
report = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiZJ"
    "REFUOI2Nk7FrU1EUxn/vvoca24rE5NWhIYuDIDpk6VgQERXsJIhD0Q469T9wKYKTq6BLieBQ"
    "HFwetUVBWxdxMEIrtg8HX4m0pJVSlMSmyX3nOLzmpaEdeuAO53LOd777fec6AJVK5Vrjw7M5"
    "u7WG3Yi4Wg6HOVpsOpVK5ZKIfFK72+cS8/v5A65MfT9St+d5w14QBGGpVJo4sTxb7j8DKLTb"
    "7Z5CEUFVe/JMJpOAjI6OnheRp+qP4WL5+3H+wCRjDCKS5o7jpIApg2NLs+UBX0GSAoBHrzcQ"
    "AYWkQUCAyVu57jNSBvkxXMfy5/1CCiACFwqZPYDkLK42AIjjuJeBt/imfCqnqGoXQJVvq/8Q"
    "QEVRiRFNNHAcRwC6LrR3+1zHsvbkPtdfLaOqPe9WVay16b2INLLZ7EiXwdeZ8kA+4dkpejhd"
    "QyQmjpVY95xot5m87WOM6QPcfRrcxcWy/W4+VfrxnbPoHqDneSmbZrNJFEV4nmdMEATh+vr6"
    "xMbsC+pfXiIxqUUduzqCdZpXVlYYHBzEWitdBjfuYbBszc3vc0HS4zgOOzs7hGFIoVAgl8v1"
    "umA+B+V+X6A7LN3AOI5pNpuEYcjQ0BD5fP6QPbg5njCYWcB1XUQk3UBVpVqtUiwW8X2/Z0u9"
    "IAjCer1+sRS+/Xkym0EVoijCWou1NgUwxlCr1ahWqxhjaLVaiU4dpPFzp0cKA8cvrzVav6Z+"
    "bC8d+BCHx+Z/wS9vq4IrUroAAAAASUVORK5CYII=")
index.append('report')
catalog['report'] = report

#----------------------------------------------------------------------
report_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAopJ"
    "REFUOI2Nk01IVFEUx3/3vZc1OVZMZim5qsAoLYaiD4KgLypoaFFEgZSL2lSrFgUtiiAI2kZF"
    "EFOboq/Ny5SEUiEiiYlGKYaCRhCn7AObcpSc+85pMfoma9OFu7iXc373f/7nXAOQSqW2F55e"
    "abffBrFDWbYlM2v4v/XZpFKpJhF5rvZXpUvAl6tH2HL9zX9le563xvN9PxOPx4/NeNuWjM4F"
    "FIrF4pRAEUFVp5wjkUgJkkgkGkTkktY042L50d35z0uO4yAi4dkYEwJDBRW9bcmqGgUpBQCc"
    "ezCECCiUEgQEOLunulxGqGBeM66x5J90hQARWFYfmQCUdrq/AEAQBFMVeOlHyVnViqqWAar0"
    "9Y8igIqiEiBa8sAYIwDlLhR/VbrGMnjxMDvuvEVVp9Stqlhrw3sRKcRisY1lBa9ak1XzSjon"
    "g07f/oRIQBAogU50oljk7L4aHMepBNw/PDiIi2W4ozN0+vz+BegEsKu3jc50K/niMCdvjNO0"
    "cB2e5zlubW3tcDQaHRjtvrvb5NOMvu9nyb6jIUREaH95n9cfO1gXX83m1dsZc4d4kW3HxIKI"
    "k0gkGurq6i7N33mIylXNqJRMnOy1iPCo5zYrG1YQOAErarcSmCJrG9cTme3udXzfz+RyuWND"
    "D5P87LkJwb8T+Dn/iWkmSmLpcQBObL7GopomMKai7MGuFhws31q7cF0XEQkn8Gchz5vcc9K5"
    "Z5zamuRCRwsz3OmgOu75vp8ZGRlpjGcef5gZi6AK2WwWay3WWkSETct386K3jfVNG3jYd5kK"
    "4/HsdTdj+eCemZTbsnjOxvqq6ZsGC+MD198N9/79HxoPVB+NzPH2GGNmquro2Hd7v+/W1zO/"
    "AS1efFm0I9riAAAAAElFTkSuQmCC")
index.append('report_add')
catalog['report_add'] = report_add

#----------------------------------------------------------------------
report_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnFJ"
    "REFUOI2Nk0tIlFEUx3/fo3SasdR0chYSQUIkFbjQVQgRUlJSEViCiEEFGgRt20jRprZBEsks"
    "o9BF46uCfFCIRRNpKENSyojmM/Exkzb3O7fF6DdNbrpwF/dyzu/+z/+cawCEw+FTsZ5H3Wpx"
    "CjU7TkUwUsb/rTkjHA4fFZEBrTa8Fg7zzdc42TLyX9m2bZfZoVAoUlJSciNztCvo2wtoSCQS"
    "aYEigtY67ezxeJKQqqqqQyLyUPtrsVCs9Pdue8k0TUTEPRuG4QJdBTuHu4JZfg2SDAC40zaL"
    "CGhIJggI0HQxL1WGqyC/FstQLL/pcwEiUFzo2QQk99BEDADHcdIV2EOdwd15Gq11CqA1Xybi"
    "CKBFo8VBdNIDwzAEINWFxIbXMhRTD65y+tkoWuu0urXWKKXcexGJ5ebmlqcUfOoIZuUndW4F"
    "3X46g4iD42gcvdmJRIKmaj+maXoB6y8P6rBQLL3udZ2+d7kAvQmcf/mE6fZmYtExRgYCZJRe"
    "wLZt0woEAks+n28y3v/8nLE8RHxsgqLqRhciIvzoeMzqh1aKK2soqrnJvpwMfg71cFjNLad5"
    "YKKI3r3CmRcRd2CUUny8fozSmgY83/pg6h3syWbB3s9g99tp1wNzMBT0+QWc7ROoZqJkFhyA"
    "ylup/jcFyDSMQMqDs/WYKBY7+rAsCxFxJ9DKKyD+uRNvqIGNXzPEgdUVi3VYsEOhUGRtbe1I"
    "SeTV9125HrSG8fFxlFIopRARvMcvMfK+ncIcD7a1g9V5xcScRTSeaDW2JNUfzC4vzMo4MRX7"
    "PdnydWn43//QUuGvy1eL5z0YBevo+Whc2hoH9f0/dUZ/g0ic6yMAAAAASUVORK5CYII=")
index.append('report_delete')
catalog['report_delete'] = report_delete

#----------------------------------------------------------------------
report_disk = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAodJ"
    "REFUOI2NkU1oU0EUhb9576UmMZWibbSIIiioiC0EbJeCiohoFXQn/nThH3brUhBxqeBCUBAb"
    "FEEEdRHF4m8rggoawYIaFE1tbaGNNTVtYl7evDsuXk1T3HRgFhfuOfPNOQognU5vKz671KPH"
    "h9GjWbYmM+3M7YypdDrdIiIvjXbn2/jkLh9hy9UPc1I7jtPupFKpTCKR6Ap/fJCMLQIMeJ43"
    "a1FEMMbMmiORSGDS0dGxRkQumvh+bDSF573/vWRZFiJSnZVSVcMqQV3/g2R93IAECwBn7owi"
    "AgYCgYAAp/c2znyjStC0H1tpfj/tqxqIwLplkWmD4L4fKALg+z4AdnNzcz4Wiw2VX93ebRX6"
    "KWcHWLXnBCe7vxBWFQZHf+OWXT59HWd4rEDYrtDbn+fOix98/+m/qiE4gK00+ScBwZ9SmU1t"
    "q9mViHH/9Q9O7Vs7K5frfTlEjnVbqVQqMzIy0pV7eI1i+gYYgzGGkuvxa1ID8PjtaFVY1lBw"
    "ITdRQSmpzeAgNpr8o97p5BW2Ac8Xzh9PIGIwgI0h6oDruhSKlZkWrDf3kgviBvGDxMMhi7Lr"
    "cfbWAJYC7Qviy0wjBqKhWoLth7DQjPf0opRCi8H1NbYVAgwKP+hfDMYIWntUKrqG4HUqGYsL"
    "BO0wWfIIKYfjO+rRUgEsMGCUEHbqOHdzkPFCsYZgZ2dAcL8P27bxxWATQvhD97ujNEaXo7DI"
    "lYY4vOECFmFK7nQGU1NT6xOZh9+iCyMYA9lsFsexWbEEFscm2dzaRkPdUrBgoryU+HxNtA4c"
    "pVD/6ulc1bBxWf28TcPFytDVz/n+1s67V9aubGppmNdA2FmAFg8lgjI+okpkBr8xVvD4C2WI"
    "bwozCYmtAAAAAElFTkSuQmCC")
index.append('report_disk')
catalog['report_disk'] = report_disk

#----------------------------------------------------------------------
report_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAsVJ"
    "REFUOI2Nk1tIk2EYx3/ft6XNTc1yS6205ajooLQbLyyKqCgpETrQTWU3QXS6qJuIIOqqm24K"
    "MjBGdNE5aB2sSO1ghsXCVjMVM9G25pzO6Rbbt8/362L1aUTQe/fA8/ze/3P4SwAej2djvOli"
    "gzrsRx38ygZXZwX/90KSx+MpE0K0amrSbGCCobp9rLvs+69qo9FYYXS73Z1Op/Pg9I5HLsss"
    "QINUKvVHohACTdP+iE0mUxpSXV29WAhxQbPtwoDK2Ivmv36SZRkhhB5LkqQDdQUZ3keubJsG"
    "Ip0AcPrOIEKABukCAQI4tS1/sg1dgXUXBkkl2vhcBwgBS+eZfgFgltKCI3yT743LiYdfcOlQ"
    "SZWhsLAwYrFYBhJvbtfIY14SX/twbD2AJEk0fhonFEkRHE2Rl2hgTY6XPPsWipybmJ41GzHY"
    "XzZFwW4Mkkrk2XO9x9M7CgBIhp4wEfNjzq5k5MtnMiSF7JwCcqzFlkkFLbdqpKiXRG8fjm0H"
    "EEJw4lqQnq5GluW1M8O+nlT0Hpo6RsDXwVCfj7NXm3ZOUbAHAyqRp836pE+u60aMtpNbWk3C"
    "X4ecoTLNUkKWGCBSuo8bL+u/6VuQ39135dg0xER64qGuBxiTb7EtqyHhv4g8TUUZsxNubSdS"
    "WstchxNVVcWkgqpaZFSGG5oZ6n5MLNjGwpWbUYL1GDI0EtESwq/fM7rkCEWOMvLz06uU3W53"
    "ZyAQODh438V42xWSZkF0oA1loojvH88jSBAfmUO47TOjSw5T5CjDarVOHpXuhVTSLKPS++oM"
    "2/dfpuv6MQJ9rWQWl0NckFt5FKu9HJvNNvUi016IxWLLnZ1PerNmmujO/IHie4C9fBXRoWEG"
    "PvRg33kOzVxIMBikv78fWZZRFCUN+U3b65ixel525toOi3J8xYLZcsWi+YyLuLf+ru/Mw/cj"
    "/n8YMvQT1+Fr/yFDRDAAAAAASUVORK5CYII=")
index.append('report_edit')
catalog['report_edit'] = report_edit

#----------------------------------------------------------------------
report_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoZJ"
    "REFUOI2Nk0tIlFEUx3/fPNLxRUymERkURpkY4SKDMCnSHgtLqKXoLGoR7gskkIgIglZBD5BZ"
    "RbiwwMpKsRIqghrBicweqCmaD0y0GZ35vnvPbfHlTFObLtzFvZzzv79z/vdYAJFI5Ej82Y3H"
    "an4SNTNKXXi4iv9bs1YkEtklIq+NSuZ60czdPMOh9g//le3z+ap8XV1dw5WVlS3ZQ93hvHWA"
    "AcdxMgJFBGNMxjkQCLgi9fX1O0TkuilqxItiqf/5Py95PB5EJHW2LCslmCJYE+0O5xcZEDcA"
    "4GLnDCJgwE0QEKDtZGG6jBTB+ka8lmKx70VKQATKSwK/Bdw9OBYHQGudSeAbfBQuKDQYY9IC"
    "xvB+bBkBjBiMaMS4PbAsSwDSLjjJXK+lmLx6mqMdQxhjMuo+f+8w8eQSV0704LX8iEg8GAzW"
    "pAkGHobz17ucq8mtd6cR0WhtiPuTbC4s42xHNdeO95LlD+QC3j960IQXxUKP68K5zlqMX2GL"
    "wrYUG9eWUrahip+JOKGOPVzafx+fz+dJEXjePggXFBlEux1XYlNb3oQ2ghaNYJhanKBi0z5i"
    "9gotPQfI2qhy0gTHmvGgmH/8HMuySCgbbYRv819wRKHEwdEOS8mf7C6pJuYss9D8sjdN8KYr"
    "nFck4LpDQiVQWlFcsBklGm2E74vjBPM2MDDxio/fPzHdT1OGCx4UYxdCNPR85dTtbSRsG1ts"
    "Espma+FO9m6t4934a6JTUe4097G9uNydhVgsVlE5/HQkJxjAGBgdHeXygW6UUqk5CD3ai+UJ"
    "EB2P0lZ9ix8jS+63XvU5VLq2piQ/6+Bk3J5o/7wQ/XsetrTSr/Fmzz3RDSsRpn5fz/4CSoiM"
    "s/BB2HkAAAAASUVORK5CYII=")
index.append('report_go')
catalog['report_go'] = report_go

#----------------------------------------------------------------------
report_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAApdJ"
    "REFUOI2Nk1+IzFEUxz/3d2fXDrNjrTHZIi9is/EwZB8k8i/EkqQ8EJESz14o8iAvvFBImlKi"
    "LA/rz6LFbiHRiNHsjhUzzE7s2jXWzqyZ+f3mXA/Db1o8uHUebp3zvZ/zPecqgEgksjr34Ey7"
    "M5TG6U+wKhxv5v/OgIpEIvNE5IlxChM0Jb6c3cOKC7H/qvZ4PM2etra2eCgU2l/TfTvsmwwY"
    "sG17TKKIYIwZc/d6vWWRlpaWRhE5bYLb0Dh873r410uWZSEi7l0p5Qq6BNXR2+HaoAEpJwAc"
    "vdaPCBgoFwgIcGRzoNKGSzBlG1o5DN/vdAVEoGm695dAOV4lcwCUSqWxBJ5Xt8L+gMEYUxEw"
    "htfJUeSX2kLnIlv9aXK9S/HN3ih/EGxHK4dMR6fb49EtU13U4egltMkwcc5uhp6fI9PrLwIl"
    "3dDQkPH5fKn8o6sb1XCU/PskMzfvQ0Q4ePkzHdFh0i9aaax7zKSmxeRSz0BqGX37wBOwh1KV"
    "PbALEzQOfcd3saa1B2OMG18fHyYQmo/Jx8CaRr6/j+pJFsmb97OuB9bzG2F/0CAl3BEppRAR"
    "VE0DdiaJpQdRVo5q/yDkR8l9LuiKB2t3YOEw1P7QNTE/EGMkdh6r2kacApZ8A6sWYxd505rg"
    "StfHYxWCp21hX1CgPB2y79rJxq8RmL8IU7yHKo3QfecHVYUfVGlN/cojnDi07l6FYP3OMsHN"
    "TrTW5FN3CTYvpzh4Bo9nIj1dNjJjB3NWbEEp0DW+yh5ks9m5ofjd9+PrvRgDiUSCqpKD0mn0"
    "uCl0d2QZCWyifsYCXsbiWJZFsVgs+/R7zjtn1i2ZXjtuWTpXTF3ozUSvHGja2zhr6obsYK5w"
    "vevDqZPtnzr+8SEHfgKiA3BXN2U2fAAAAABJRU5ErkJggg==")
index.append('report_key')
catalog['report_key'] = report_key

#----------------------------------------------------------------------
report_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArlJ"
    "REFUOI2NkT1om1cUhp+rT1R1PlmRnEi2ZIIwpHFJkAdjk8WQQSFKFpEhkHoIoT+ul1C6dwkd"
    "OrSLh0K7FBktdQL2oPwPkWOQ68F8JT9WcGxQbWpZViI3jWrZCH3fuR2USBVdcuEO53LOe5/z"
    "vgrAsqzztexP9+zdInb5D86lVk/zfuelsixrSER+03bdNHB49fOXnP0l/17Tbrf7tDuTyawO"
    "Dw9f+/D53ZT3CKCh0Wh0NIoIWuuOuqurqymSTCY/FpEfdegKBjbVhfn//eRyuRCRVq2Uagm2"
    "CD54ejfVHdIgzQaAb2fLiICG5oCAANcvHW2v0SIIXsFQNm8ePmoJiMCpY11vBZr3yUYNAMdx"
    "OgncT+6kfEc1Wuu2gNY829hHAC0aLQ6imx4opQSgnUKjbhrKpvjDBBduPEdr3bG31hrbtlvv"
    "IlLr6ek50yb4/XaqO9jkfNf0za87iDg4jsbRb5NoNLh+OYTL5TIB4z8eXMXA5uWDR2SzWfL5"
    "PKcCASq7FZLJJMFgkOnpaQKBAOn0X4RCIUzTNI1wOPza6/X+ub9w86K8fkyusE/9cJjx8XEi"
    "kQg+n49cLsf6+jqJRIKBgQH8fj+FQoFqtWp0ePDs6WNevFjjk88muH/rFktLS/T19RGLxSiV"
    "SlQqFUqlEqOjo8Tjcebm5vbaBNkbF5fzFofDxzlx8iQXEglmZmaYnJxkcHCQaDRKJBJheXmZ"
    "qakpdnZ22N7e7kxhYWGejcIGn3/1NZnZWRYXF1FKYZomALVaDa01Y2NjxONx0un0P+5MJrO6"
    "t7cXG159UPAd8vBm/wi5+XlisRhDQ0OUy2XW1tbweDxEo1F6e3sRESzLYmtra1e9y/nT4/4z"
    "kW5PfF28uhr+aKK/v9/v8XgMpZRaWVn57uDg4NXIyMj3gLterzvFYvHvzc3NL/4F9/KFsMtM"
    "o1IAAAAASUVORK5CYII=")
index.append('report_link')
catalog['report_link'] = report_link

#----------------------------------------------------------------------
report_magnify = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmhJ"
    "REFUOI2Nk8trU1EQh7/7SNI0TS2aJoIU8YEIvqCCbkRBfCFSEMSdr40rly4rSP8GQTeSveIm"
    "aouiti4UrUSoolaptrSN2kqNNUnjzT13xsXVG6suOnAWAzO/883LAigWi4dqDy4PmLkSZmac"
    "A/nRnSzNZq1isbhVRB6r8VIOAV+unGXf1VdLynZdd6dbKBRGu7u7z7W87s+3rQAUfN9fFCgi"
    "qOoiP5lMhiI9PT0bReSSZk/gYPj+cPCfn2zbRkQi37KsSDAiiL/oz6ezChIGAPTdmEEEFMIE"
    "AQEuHss0y4gIOk/gWIb5+0ORgAhs6kr+EgjfyEQNgCAIFhO4I7fz7RlFVZsCqrycWEAAFUUl"
    "QDTsgWVZ8hfBSRzLUL43FNXYdzzH03ezfKl6VL0EiVicZUkh8OsYE6sDQZPg+a18ujPkVFVE"
    "hGuPplne0c62NRncmMPsfINyxWP4fYXta9tTgPMHwSkcDOW7g1GnW5Ip1uZaKXsWph6glsOq"
    "bJpXYzVKpRKu69oRgf3sZr49q0hANKJqvUE8HsN4BlHwjNLiOhh1yeVyGGOkSXD4NDaGuYHB"
    "qImtiRgNP8APwEgoqhYs1GpkMusWT8F+Usi3ZQWC5gKtTFtU6gHpZBwvUFzb4tNXH517y6eR"
    "D2Gp0S34XsrGMHHhDEfvjiEifKs2GPtcY7ocllCpefgzb9jV+ZEfk8NcL9zpdQuFwmi1Wt3S"
    "PXrnQ+vyJKowPj6OMQZjDCkRNqQ0XOc24VtlkoWpETpXb2b3jsle6zfumfUde7rSib2lWmPq"
    "6rvyi/+e3y87f6Rr/8HdOy4oQeInBYRwZXkQuaIAAAAASUVORK5CYII=")
index.append('report_magnify')
catalog['report_magnify'] = report_magnify

#----------------------------------------------------------------------
report_picture = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI2Nk71PU1EYxn/n3tuWlvIRPkrUEAeVsKiRBaMDxhhiHEh0MQx+sLDo4uDgoInE0ZFE"
    "B0j/AgdQIRIVB2M0pCYQIEiUjypQiliEUrn3nHuOQ6UFYwzvdpLnPPmd9zyPAEgkEuc3Xz8a"
    "VKsLqOVZWuNTzext0iKRSBzTWr8zyi218Vl53Mm53ok93XYcp9np7++fampqulkyORCPVgMG"
    "pJS7hFprjDG7zuFwGIC/CBTp7k7O9Iwy9GGGuYUN0usSx7FxpU/IsYuuQuOvTnYVCIJjA/Gy"
    "mAENQgjmljZobz1EJBL9J37WlfT0iXtOW1tbo9a629RewRaKn6/eIIQgk9VEIlGmFtd5O3+b"
    "ivLv5DxJMl3Nqf0PONl4AIFNgcAZfR4vrzEYYxBC4EkfBSitiUbThANVaFx0cJ7lTA5tNJ5S"
    "7CC4ii0UmZd5gmDAxhjYyHlktrbwzSZZ6fIjt0UGF0xeUyT4+CxeVmvAmMLGjYGNLc384hF0"
    "aJyszLGWOUhDXaj4lUWCa9goMkPDALjSR2tY++VzvO4OJ+ZvMTGdZK3lIUoqDOBJXSSwRp7G"
    "y2MG7ZMnMAaBYezbDaSUjHge3r4A3vhlpJS0nx7BmJ0EF65joVgdHEYIQWU0gPE97l/q48+D"
    "2JElpJSUBKwdBO/749GYBj8vaKiv4MnwF5a+53CCDp7nEwzasG0iNGrlU1cxidIttVDM3e3g"
    "4tBntNb4vo9SCtd1SaVS1NTUEIvFimEUIt+FbDZ7tGnqxUykKowxMDs7i1IKpVShB5ZlkUql"
    "SCaTWJaF53l5k223jsOVLfVlobMLm97X3unM2P97WJj0b8jlfhbuyFekAAAAAElFTkSuQmCC")
index.append('report_picture')
catalog['report_picture'] = report_picture

#----------------------------------------------------------------------
report_user = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAt1J"
    "REFUOI2Nk19oW1Ucxz/n5to0N7ezbmli69+OVTpMqwuyig8TRxGZGObLBo6qBdmDBmEg+iAD"
    "UdA9SBGczJcZQRQqOlxwmxs1rliEUW5dNiZhdk2XbDFraetiku7enpzjQzShbz1vB87vw+f3"
    "5XwFgOM4z1XTx87IpZvIWzmeTWaH2NhZEI7jDCqlftPSDfqos/j5QYaPX9nQtGmaQ2YqlcrG"
    "YrFE+x+nk/YWQMPa2tq6h0optNbr7oFAoAGJx+P9SqmjOjyCD0l58pd1w7Vaja8/eQ93Zpw7"
    "SlDdHGX08Gf0bt0KgJFKpbLFYjGxNPEVq5e+AQVCCIQQfHBigSNHPqV28Ttqug6mQTU/zbEP"
    "32mt0TToGsEnJLd/Po8Q4j9VENcmEJE+Hrqnk0wmgx2JsHjjMlI21mxmYGZOJTeFNFrrFkBr"
    "fJF+Xnv9BQKmwfMLeczQg6R/GEdrFIARj8f7e3p6jnYNv4y14wCqThPw/r57CffHyE6dQder"
    "2OH7WJ7L4Czdjeu6q0C9ZTDzY7KjS4NuWCilSHx0gr9+n2Bl507SX/yEfRfMrm7B8zRfJpNB"
    "wPSNjY09atv291ZvtM3fHaX860n69iWYmpqiUryC9Fa5cX2O6NAwvY/vIn3uNO3+Nsr/VPCZ"
    "bdLX3d29Ytt2oTb57V5xO0Ptz3n69r+B79RBOnt6WdRdWH6TzIyDM32Bjg4bYVo8s+N+3uzL"
    "xZoZRPa8SvCJEbRqhBjctotb2Qtcmy8QDkeIDgxgWRaDg48hNWSnJxH+TfMtg/T4Xv6+yJ2r"
    "13nkpQTtDz9JZPtTzM4VKBULLC8v43ke5XIZf8Di0Nvv8spbH+9vdWHNDRpI5g+P8uK5WZRS"
    "1Ot1pJS4rkupVCIUChEOh5ufSAjR6EKlUhmIZc/OWZsDaA25XA4pJVLKZg8Mw6BUKpHP5zEM"
    "A8/zGpD/aaPbOp9+oMO/+2bVKxy/unJpQ3WEhX8BK65hjrR8IxAAAAAASUVORK5CYII=")
index.append('report_user')
catalog['report_user'] = report_user

#----------------------------------------------------------------------
report_word = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm5J"
    "REFUOI2Nk81LVGEUxn/vvaN5U2NIHWnhImohUS2GwIiokJIIEvoDLN20clOtgloXrYVaFPb9"
    "B8xCKSqrRbhwCI1i+kDDaBq1ZlJmnLlz3/ecFqOWEtHZHTjn8OM5z2MA0un08dKz66P2x1fs"
    "3Aw9w5ku/q/mTTqd3isir9SGjT6OhRtnOXrr7X9tx2Kxrlgqlcokk8nBhncjw00tgEIUResG"
    "RQRVXdcHQQDABgLL/NBZjtyc5NzDaepUKVfKBPUB4hQciAOxgo2UpenizzWC+qmR4eaEgoAx"
    "hhhwra+TmO/9FT+/WGXw4gSx3t7eThEZ0rY+fGNZfPocYww4pc73uHT7PYsVx65EwMdsmeY6"
    "n3iTz+T0MgBeKpXKZLPZwYUnd1l+/QBVxRiDiqJAJVTq1dDRHlAoCW3xGJXQodUVIX8TnMY3"
    "lsKTGoGu6NgAlEJlfPInUVXIzoXkC479uxt5+aL4B8GjO5TS90EVVcVVBYAoVL4tO77nI+LG"
    "8DHr8IzSc6B9I8EZfCyFx2MAaKSgUCoLXqgcO9jCZGaJJScc2reFlnj9eg3mRm5TnLiHOGoE"
    "EXg+uKqwvaWOk0e2oUCzWrr3J/A9s4HgRD8elh+jYxhjiCrC93zI1XOdoFCuWC7071h740I+"
    "rB1Y9YE3nhpuSgi4FbdFwvkrbygXywQNASKgIqiCiiJiMOucGIWNHpbPlwc49fgTIoJzDmst"
    "YRiSy+VobW0lkUisURhjalkoFot7kplH05u3BqjCzMwM1lqstWs58DyPXC7H7OwsnudRrdaM"
    "YFavDeyMH+5o3tT9tVT9cutDYepfKfyj5n8BSDyAkuHFahQAAAAASUVORK5CYII=")
index.append('report_word')
catalog['report_word'] = report_word

#----------------------------------------------------------------------
resultset_first = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAadJ"
    "REFUOI3NkjtoVFEQhv8bN3t3SVAkEgJLbCIKYiVaCCIEJEFSKlgEfICttem0CAQFbe3SKBaK"
    "EEGxE9EuWogxytYikpCoe3fvnjNnHsdKvSeytU43/8x882CAf21Z1bnxaDMCgJnBi768Nd+a"
    "rsbP3m4vKePqysKh0V/aUMozHJtq4MBEHYEliczd/LTkOF4rJY5U9QTg2CBqYDWU4Y9+ZnH9"
    "zv59jYWZI3uyngvVEtSqDgUBawSxwTkFAMwuflyeHG9ePjjRgGpEl3QwoOSIIAZiQ0mM6etr"
    "9yfH8vnDrRzfeoy8NoTC2WCAcwYSQzPP0CE5cXRqd97aO4yNglGUgrHRGsRxAkhu0KeAwIa+"
    "VzgvvSAKzwYfDI4Nng22Y4IE0KUI4oiNDqPw9mHlzfbjF2vf0axnyBARJCJSGAzouQBiRZ8U"
    "hbP4+e7xc+vtzsPX735gpLELQQzR62BAlxTEBh/0965fH5w8336/dW/17TZI/l4hOWLhDF4M"
    "FDTptPn89AU79cyY5GLc8WAJQBxj+ekXRDKYpIlbr+YuWfmEUR++gv/KfgIuv/8gWElNBgAA"
    "AABJRU5ErkJggg==")
index.append('resultset_first')
catalog['resultset_first'] = resultset_first

#----------------------------------------------------------------------
resultset_last = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAahJ"
    "REFUOI3Fkj1rVEEUhp+7evdukARRwcUihQgiWln5URh/gJ2FIAQU8gNSiB+NYCM2NoKFqKCS"
    "JkF/gRptLNUiV6KIkBRusNnN3pudO3NmzlhI5G5gt83pzgPz8M7Lgd2epL7cXdooY+DRvSvt"
    "23U+92RtWURnrChWPG9uHP//rrHDti9ovDn/cv1+nRsTODnd4uKpSQobhxIMCYwop4+2ksNT"
    "zVvXH/96uM23rGAl4EQpjRstsM6jwPTBJu392fylB6vPAUoXMS5iRSlsGBLsrS9bEnFe6ZvA"
    "sXZK12TXzt752iwHlsq1qNKEvtHRAmMU65XewNNI4MSRCVK4+jbv2qmJBlYC3showcA6nCiV"
    "C+xJoJFEKq+UVSyLKmQNQMclKGzESoQIWZbwId/ky8/+ayKH/nTdhQOTKdGOKbE0DiuBLE14"
    "t9Ln8/fu4u9nZy6rCdHagPNKrMaUWNiAFeVj3iP/UbzqLJyfBdBK8O5fPzu/MJSgb5TlvEe+"
    "uvmis3BudpvHKiCiSFCi+NEJvBG+rRRPN5Zm5uo8VoFP7ztEr8Q4fIm7P38B1/L29mMUPyUA"
    "AAAASUVORK5CYII=")
index.append('resultset_last')
catalog['resultset_last'] = resultset_last

#----------------------------------------------------------------------
resultset_next = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAS1J"
    "REFUOI1jYBh0oH71iy91K160E6ueCV2AkYGJ+x/D//LiRY+IMgTDgJ9//jAYKnAwivCxVcRP"
    "vdNHsgFff/5h+P3/P4OMECuDGD97oXvLtXkkGfDl+3+Gn7/+Mbz/+ptBRZyNQUqYPVG78OwS"
    "og34+P0Xw49f/xjeff7N8OLDLwZNKXYGBXHOaMmko4+wGcCCLvDh22+G77/+Mnz5+ZeBmRFi"
    "x4/vfxkYvjFeJMqAT5//MHz/9Zfh37//DBwcTAz7zr9juHHzw9qXb/5HEGXAu++/Gb7//MvA"
    "zsrIcPDce4abN96serXRJRybZqwGfP/yh+H7738Mxy9+YLh19e3iV9td4nBpxmrAv++/GY6d"
    "e8tw8/KbhW/2eCTg04wViPkd+C/suG02yRoHDAAASER91U0dN2wAAAAASUVORK5CYII=")
index.append('resultset_next')
catalog['resultset_next'] = resultset_next

#----------------------------------------------------------------------
resultset_previous = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAS9J"
    "REFUOI1jYBgSIHvWg/bUGQ++YJNjIaQ5Zea99u9/GMq///rLiE2eCZ/m+Kl3+sR42Sss1LkY"
    "P37/g1UNThdE9d+eJ8bPnigvysLw+88/hg9ffxNvQFDvzSXigqzRKuJsDG+//GFgZ2Zk+PCN"
    "SAMCOm48khRgl1WR4GB48eEXw8dvfxgEeVgYPn7+hdUAjDD4+OPvxS8//jB8+/2X4dvPvwxf"
    "f/5l+P7zH8O/73+JM+Df/1eBx298WLv30kcGVlZGhv///jN8//2X4d837C7A8MLBRsc/DAwM"
    "IZ9jjqz8+ulXmKEGL8OPX/8Y/n0l0gUw8HyJTfjNS28WnzzzhuHnr38M/3+SGI0MDAwMr7a7"
    "xP213PLv15ff8f9//sOnFD8Q0N8wW8h4y3/yTaAlAADYf4P5BP7YMAAAAABJRU5ErkJggg==")
index.append('resultset_previous')
catalog['resultset_previous'] = resultset_previous

#----------------------------------------------------------------------
rosette = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi5J"
    "REFUOI19kU1PU0EUhp+5H730VkmBNCC6sNiwEE1IWYFxYaIhujHRxAVbEn+B/ghd+APcunTh"
    "jp1ujInGjwRNpYbQBaRoC1iFUnrvnZnjoiDFCieZzHkz8z4z5xw4JuIwfBD7fpRMTe0lcPO4"
    "e163EEjrsbEtKpW0c2MW+rOQ8pBafUGfGcGUStWg1Tp3LEDDI2eymOb2XWjuQroPPB9mb6FO"
    "ZVDanN3+WrrfH0VPDzzqIEkymcfq/IWHauIy4qeIKhXiJEZZwfdcUmN5VBiiXzyPTaMxk4GP"
    "RwHj49q5c89lq0F7cRGsxRcBsYi1WKXwL00g39fZqa5uDi4t5QCcv/UvLzcpf0M26iQ6wbcG"
    "xxwuSWJUu40ZHqZdrUYHvkNAsQhjedRAFtdalLFgDRgD1qCMRfb2oLKCbbXe9wBYWzuN1qDA"
    "VQ5iDWLM/m47DRsdwRYKeIXCTA9Aw0LrzWvET+HnhjCANgZtDEaBV5xkt/aDrXdv2S6Xn/RM"
    "AeB3LvcquHL1mhekUQNZqNcRbWBoEJRi89MHml8+Xy8Y8/K/gE242HbdUjA9QxhmSOXzxMsr"
    "RI7QqtdI4ljny2Wfk0LC0Ox6nlQdR1anp2XJ82QjCKThOBKBOdkcBPPiumJAIpAmyL96G+a7"
    "PUdKEIgMpAydpxJYDwELo6bTaCzEWQh6piAwZyFlu8gePLPwrEvjQWoH5np+oOEn4Am0FAxb"
    "iH3I7p/9ogOvAaGA7oNBgD9A9Q6gr5WvHwAAAABJRU5ErkJggg==")
index.append('rosette')
catalog['rosette'] = rosette

#----------------------------------------------------------------------
rss = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAadJ"
    "REFUOI3Fk8+LjVEYxz/nvO+bq5CFNElZmSRxlaT5B8RqGguaRMmShRUW1CxnpywoZWFjYdSd"
    "Dc1Ckx1lotgp5UcWVjR03fv8sjjvvWXYjXLqdJ7z4/nU8/0+J6VcsZ6R15X9LwApHnTj71cO"
    "4qAC6iBDUCtnBgwDBlADsHt2Ta7/Ps3BrMRibazw9H4LAFj9DO6EtQ9UCVMQJVTKXoRQBRWa"
    "7XugHyNAQAQcukpqNhOvbhNm5APnQfvY40vkYzdITQddnic+vgSRFqBaaguHZgvxbI505DrJ"
    "BviLW2BOPnwB5AeyeJFq/yn0/coYkBEpAA/INWzaBa7Et0/kqSvkg+fwt0ukbZPUJ+7gH56D"
    "lxIZBJn+z1Kfe7Fl31ni3RIMV7GHswRB3juD3D2Ov+lRH50rYqq1gIEWmju44Cs3SZPT8P0L"
    "1cw9Umcr9nqB5kyPqnsSfXStBSgIpJjfEXRPE3wtqqsSUpQOadUfuaAKZoQZGzbuhN4TavoB"
    "IiTrkEYWmhXvoxU3O1QGKaD24ti4Ey9PBBLjzsIChmtWpXSf/9m06b//xl+3YBRtpjmYigAA"
    "AABJRU5ErkJggg==")
index.append('rss')
catalog['rss'] = rss

#----------------------------------------------------------------------
rss_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhZJ"
    "REFUOI3Vkk1IVVEQx3/n3PvqlR+VhFgWQWFkxEvBJCRoERJRGNimJIgkCiQX1cYIAqGFLoQg"
    "sLBF0KIWkaQgUlASiVQkWuQmgyjDpAiSV9x33/mYFvclGC3cNnCYOefM/OD/Z+C/DyX3auTf"
    "Xx6MB2vAejB5sC55c0BeIIYQgKqWv2b94uM8OJfUxhVqC0/vFgAA2VnwHnGFBmsRZ8FYxJrk"
    "bgxiLVhDqnwbRPIHICACdRdRqRJk8gbiHHrnKbARbvgc+sBVVCqNHelGZibAmALA2kSbeEiV"
    "Is87Ubsvo1yMf3UdnEfXnwXzCzPQTpA5iv04vgDQGJMAvIAOoXgTeIvMf0Y3dKBrW/HTD1Fr"
    "txIeuYn/9AJ8IpFYCIlyiT7vUYDacQJ5PwTFlbj7Lej9PejtzQz3NTPii5iPfmIiTWP8hWOx"
    "EBLbhOY9eIMfv4bedR55N0TQfBucYXCwk8myNeytrmNDWRUjUw8YePuMb6UBSrrXCzXHEX4k"
    "rluLmMRpMYn7Z+ZyHD54CAJNU3U7PY9PE6Dp7x9EEwkYg8ql0bkV6HglgSkisKWEsppQyvia"
    "/U5KFdNU3Q7AhX19bCnPkFcQEgk8ubOwWTiB/OKcrUwzNTvG69lROhpv0fXoJOlgOcsE1FL2"
    "vb5t3ZWNm1ddasjsoaqilum5CcbejDLzYb5nSYAEUtGFUm0KSgSyiPS+7J3r+A23vyFchU4N"
    "ywAAAABJRU5ErkJggg==")
index.append('rss_add')
catalog['rss_add'] = rss_add

#----------------------------------------------------------------------
rss_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgNJ"
    "REFUOI3Vks1LlUEUxn/z3rmlaB8LiSxMXCRRUQYm0T8QtrRFIUEQRdAX5EoJRDeBiyBoYdGu"
    "RS0iqEAikTIyKkiSNkJflOlFsCA1vfd9Z+acFnMVjBZuGxjmzNcPnuc58N8Po/ea9N9XAk7A"
    "O/ACLgMf4lkAMoUULADb2//6KytnEAgh1i6Uaw/P75YBAPMFEEFD+YH3aPDgPOpd3DuHeg/e"
    "kd+0A4q6BFBQheYuTH4dOnYDDYFk7ynwRcLjSySt1zD5CvyzPvT7O3CuDPA+alOB/Hr0dS/m"
    "QDcmpMjbfghC0nIe3ALu4QVye47hv40uAxKciwBRSCxU14N4dHaS5GAnyb6TyMcnmJpG7JFb"
    "yMQbkCiRVLEUS1GfCAYwu0+gnwageivhfjvJoaskO9uY6G6h8GWGhekCtsqyrfE3DaliSX2k"
    "iYA4ZPQ6yf4O9MMAubbbEBwTN88xm1bS1H6RtQ27KL4fZHxkCFvKMNq3RWk6jvIruu496qLT"
    "6qL7rx4M03y6l8rPwzA1Ahs28sPWMz74EktRwTlMqMAsRRhCzF6judlciYrNDXC4Yzl121NL"
    "JloGPL2z3FkEhWzlmreGxbEBqh6dJS1OswjMz+WwuQSzmn5/cbS2Z0111eW6mmBtMsn8jOfr"
    "dC5kJeleFSBC6joXfxbOJGLqJdEpQftbh+TKH6KTMSLR3i+fAAAAAElFTkSuQmCC")
index.append('rss_delete')
catalog['rss_delete'] = rss_delete

#----------------------------------------------------------------------
rss_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgRJ"
    "REFUOI3Vks9rz3Ecxx+fz76rWdtEi8VMVpOZHyNjWQ6Ict5tlyFHqdkBJSVzcJFQ/ANy4DAH"
    "pCYUWm0zrbSYWvthcnCYfef7+Xzerx8O3+8UOezqVa96/XzUs9cL/nuL/EGr/7tlEAwkgBiE"
    "DESLNQUyhxRyADR1/bVrf7oaqBbjoKVY4NX9EgBgYQ7McC0NiOAqEASXUMxDwEVAAuVrtkDB"
    "lwAO7rDnAlF5Nf7+Lq5KvPMUSAF92kN87AZReQXy4ho+MwohlAAiRW1uUF6DD14mar9EpCk2"
    "fAfUiPeepvdJF/k0z80dvcRTI78BMSEUAeYQ56BqI5jg87PE+88T7zqJTTwjUaG+tpnjQ31k"
    "JiACqZOjkBT1mREB0bZu/PNjekZv45aRuZKJsG5VE811+1hIFumcHaQ/rGdF6uRISzQzsICN"
    "3CJuO4uMXOdISzfqhppiOHPzM2yv7yCfFTg43c+AVZKj4JAGwLCBMyCCPjpBIhnqxtT3CYIJ"
    "YoGggR/pAq0bDpAPP2nb/boECIFIK4iWTqhKIgmiwtqaBsQUdePr/DSrq+p4N/OG8ckhHo6t"
    "JPJzdU7w35+FOmTQ2VFFkmVklpFIRmNtC+2NRxmefsvYhwHujVezOSkjWu7Pb70SLbY1HKp8"
    "+en5lxBxeK6Pj8DyAZsusqheVpmijd+uMrlU/wVIBEUx1B4tkAAAAABJRU5ErkJggg==")
index.append('rss_go')
catalog['rss_go'] = rss_go

#----------------------------------------------------------------------
rss_valid = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAilJ"
    "REFUOI2tkU2IjWEUx3/ve+/NJRcjZnxcX8UkxJCGWBGNjxIjH42JkiULKyyI5eyUBTJZSNkY"
    "zZRGMyXZiDJRbKQ0zNCwmmnM3Hnf53xYvHcUG5J/nU6nzvk9z/mfiH/Uzvbth0TCzfhvmo91"
    "Hygfvt+8dbLe0b5tXwjpvYV182uiPw23dh1aHtKwOgnJgxCsKSQTxVS1c35tXa5/cGD0jz9I"
    "RWqSNOlYNLcchzTtTc26lpYX5foHB0Zd4g3Rw959DmDumBpqhqkipmgqaAj0S8yb4mxmlkp8"
    "Hx9n6MtndskYJTHye0c+wYqWX581+zXUeDb8lcsf35Iz5+6yRsr5Ajy9R/7n0OgXMMNVQRVE"
    "cBUIgktgkwjt02aAKHVD76B2JVR8EuDgDhsvEBVK+OsbuCrxulMgFfTRWeLdV1lcKCJP2vCB"
    "VxBCFSACouAGhRn48ytEmy8RaYK9vA5qxI2nIYwRus6QW3sU+dj3ExATQgYwhzgP05eACT4y"
    "SLzlPPH6k9j7HqI59eQP3sI+vQDLViRxYioT2b5mAERrTuAfeiAdRTtacJx4VTPh9h7sbSf5"
    "piuZsaJVQCIZzQwsYH3XiOr3w/dv5JrvEBVnoW/uUzjeSa7hCNJ9sQoQCBB52wKnoRVnOHNd"
    "BA8CEvAQsloms4AqrsqUqWXofEyeikMIRFokmjyhKqiBV82NDXIKkUPesotVFfm5eU5wSB0S"
    "QB3S37IASmb0/9YPixtZ9HWy7QkAAAAASUVORK5CYII=")
index.append('rss_valid')
catalog['rss_valid'] = rss_valid

#----------------------------------------------------------------------
ruby = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAehJ"
    "REFUOI3V0k1LVGEYh/HrOefMjDo6OVa0EdsUgRKCYQQuJJ3Idq4icdGiL1AJ0keoVZBBi8BV"
    "Kwl0ZUaUUCBmNIwoZum8pVNqLzZN48w5z1sLIXqxD+AP7s29/V+w7wkAe+P6oMG5A9YFsMqA"
    "1lilsUphA7l7UmGDAHypdBBcbXgy9UDY4aGLxhGjztlElIYYRKNQVwdSYrY22S58wNEazxi0"
    "H/CjsgNft2mcflG2vhz0jCOGneMnogQSCgVobYVyGdJpmJ2lUirhKkWNtWjfZ6tYJNrVRbWj"
    "PXr4+cxdz7H6illeui8+f+oUzUehvh5aWqBYhGwWt1LBtRYX+FatUtfbS3g1Q/xVaoNADTni"
    "1u15x62eN+vrj8zKO0ilYGMDYjFEJELYWsJCYIzBJhLUrGZpmnudQfoXGt8kxxwAcfPetot7"
    "Sb1fm9QzM5DLQSgEtbV4UhJSCtXTg7uS4cBcMmP8oD++NJ8CcH7NMTLyPez7A0EmNynHJ3af"
    "8TieUniJBJW1ArGXyS2U7G96u7Dwx4y/s319sR3ch96pjnOhk23ofJ7Sx03E42dVAjUQTy9O"
    "/NPB38rd3c1a2unImdPHjDFUpp5WrdSXD6YXx/YMaS9f2jvbhNajNpBHrC+vHcovj/+/x33t"
    "J5W09M31esPXAAAAAElFTkSuQmCC")
index.append('ruby')
catalog['ruby'] = ruby

#----------------------------------------------------------------------
ruby_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAm5J"
    "REFUOI3VkstLVHEAhb/fvXd0dHRSoydiRkiZlGH2oCAolcxFtIpACqqdEUSC+Ae0sCCiCIOC"
    "QgiCaCEtzAoSswYZTRxKszJHTc1X2cx45859/lpELRKhbR+c7Vmc88F/jwCQjRdrPZQbIFUA"
    "6XjgukjHRToO0rJ/xXaQlgWm7biWdSH7eft9IRvqj3uKuKscrAyQHYRAADIzwbbxZmdYmJxC"
    "cV00z8M1LRaNJHxfIKejS5emXat5imhQijYHsGyYnIStW0HX4fNn6O7GSCRQHQe/lLimyWws"
    "RmD/flJlpYFVL0M3NUW6Z72hwTtifm6XyN8AWVlQUACxGESjqIaBKiUq8COVIrOigrThEXJ7"
    "+qexnHpFXL4WUdTUYW9i4on36SP098P0NASDiPR00qQkTQg8z0NWVuIfjpIXfjOCbR7Jed/3"
    "UAEQTbcWVNQTzviXNjcUgtFR8PkgIwPNtvE5Ds6hQ6ifRlgR7hvxTOtY7mCk/88Lv5G1tUHD"
    "ch5oGwtrfKdOIltaSPb2otXU8Fj/QDgYl3FMEddjiYXFb1eeXn57SfAXsro6mER9pO0sq/Jt"
    "K8EdG6PVGGKwBHYWl5OfV0THQCvd77qIDs9fVZaI0d4ex1g8Y3Z0DtvhXpyvMzzRxtmxpRRX"
    "cSldV4UrbPZu2wfIc0sKAAKdnRO2bhzTn70IJ9uej80a3/GJLI4WnwegvuI2m1ZvRyD82nKK"
    "roz0DAB7APbG1hsDUyF/ZOoVjVX3aHp2Gr+ajkSm1H/QnfXlWRkJa+5A4ZpC5pMTxPRZXke6"
    "iP8wry8ZcTl2161tQog6AdkSEkjZHG6ebvwJPGYuElE4ldcAAAAASUVORK5CYII=")
index.append('ruby_add')
catalog['ruby_add'] = ruby_add

#----------------------------------------------------------------------
ruby_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlpJ"
    "REFUOI3VkktIVGEAhb/73+uMOj6DyIUPhCzQRDCswEDSiXTXpoe4CVq4rSRx1yai2gQZuAha"
    "tYqwNpqPwNAQU5TRhVrqjK8xNUcdbZy5r/9vIYj0ALd9cDZncThwDvz3aACq5V6DRDwHpQMo"
    "R4LrohwX5Tgoy96X7aAsC0zbcS3rTnpv12tNNTddl0J7JS75faRngM8Hqalg28j1NbbCKwjX"
    "xZAS17T4Gd+DzS2y+gZiyrQbDCm0ZlF02odlQzgMxcUQi8HcHAwNEd/dRXcckpXCNU3Wo1F8"
    "lZUkyst8x/sHXxhCubfl9ORLbeNHhZZbAGlpkJ8P0SiEQujxOLpS6MB2IkFqTQ2e2SDZI4FV"
    "LKdJaE+ejQs9cUUuL3+QM98gEIDVVcjIQPN68SiFR9OQUqL8fpJnQxwbHg1im3VZU2NvBID2"
    "uG1LR7/pLC51uoODMD8PSUmQkoJh2yQ5Dk51NfpMkMzhsaA0ravZk+MBAHEwR2vrjsc0663g"
    "fKf97v2+mZ2N4TgYfj9rX/sIf293R09MFI7kTXZ0+UXLwYyHUbW1GXvob42z5ZeTSktwFxYI"
    "zfSTSI9Q5L+Gt7CE+EQPkwM97vb09N0/AgBiVVW5rq36vBfOnZRSMhRoU+fvP9RS5j5B+DNk"
    "ZrFhFDDaPRD658MiZRUlm2fKv0ROlc73VhtSjrarw2w9yFG91Yb8a4Pf6fbrS5X1t3J9ix2Y"
    "8VX2gN0dnak5wvpRAhorcjI311YuCo8ubD1GNKIIrgjXddTTIzUAGLiR17IXWWkUUiuQQoUl"
    "qq3uo3z0C3SsNh9uq7scAAAAAElFTkSuQmCC")
index.append('ruby_delete')
catalog['ruby_delete'] = ruby_delete

#----------------------------------------------------------------------
ruby_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoxJ"
    "REFUOI3Vkk1oFHcYxn/z3yXUmWwSCdmNsGqIKcVACe2iQnMqFARBsJekasBqWi9+UCKEXnMK"
    "PRUaL9IPQWrbOIKSpjWwQqEVMSglKcGEbHezIdllN24aZj9md2b+M/8eJIVE8N4fvJcX3oeH"
    "53nhf48GoD4fORsgvgIVAlAyAN9HSR8lJcr1Xo4nUa4Ljid91/0skpz5XlOj1wYCoX0n3v/A"
    "INIChgG6Dp5HsFFkK5dH+D7hIMB3XKp1G/7Zou23P2rK8c6GA6GNijffMnA9yOWgtxdqNUin"
    "4ckT6pUKISl5Qyl8x2HDsjD6+2m822d0/P74elgofzhYev61VnpxRIsfhOZmOHAALAtWVgjV"
    "64SU4tmlS7hKcWh+nqa/M+x9OlfAldeE9sWX8yLUOB6srz8IUsswNweFArS0sHbsGIuXL+PG"
    "YjQZBrqu421ZzB09Ih9e/PhR2+Kfd7TtNNWVKy1urfZjqKPjROjUKYhESObzdHV1kcvliMVi"
    "CCHIZrPE43Gmp6ep1+uG+K+OiYlyk+OcdjPZX7179wHYn07TaDQolUqYpsnU1BRSSmzbRtf1"
    "m2NjY7bY0ent2+U9Feu099dC8pdslkoiQTQaJZVKcfWne41Pb9z6cHV11e7s7KSnp+f8+Pi4"
    "2iEAoM3MlKlXL1iWxebmJo7jEI1GCVx5bm964b5SyqtUKqytrZHJZNB2C2yzODj4XrEzfnfP"
    "mYF91WqV5eVlW0rpdXd3t0YiEUzT/Na27dFXHGxzeHLycfadt/cBFAoFEomE3tfX11oqlRBC"
    "AAyXy2Ur/Lo/z+fz38zOzn7S3t5+0vf9n4vFIktLSx8lk8kffN9/aJqm/7r7HYyMjKihoSG1"
    "e/8v1uBEP8EJfOMAAAAASUVORK5CYII=")
index.append('ruby_gear')
catalog['ruby_gear'] = ruby_gear

#----------------------------------------------------------------------
ruby_get = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAktJ"
    "REFUOI3VkU1LVGEAhZ9773zojJoKtbJxkRJYEilF5ULSkWwRuIrCpX8gEqI2LVpVBEJGLYIg"
    "aBWhEWVRkGlgYiQjhpWj46ijztjHNNn1frzvvW8LQQpcuO2BszmLhwMH/ns0AHXxfKePfhOU"
    "AaCkD56Hkh5KSpQrNiIkynXBEdJz3XOlr1480NSF7tO+rt3Tj8ejlJZBNAqRCAiBv5ojv7SM"
    "7nkEfB/PcfltrcOPPOWDb03liM6Ar2sX9Nq9UVwBS0tQVwemCbOzMDqKtbaGISVFSuE5DquF"
    "AtGmJuyGA9GdwyO3ArryuvzPU3e1b18PaVXVUFICsRgUCjA3h2FZGEphAD9tm0hrK6GZFBXv"
    "E1lc2a1r13omdMM+4Wcyz/3kNCQSkM1CWRlaOExIKUKahu/7qHicopk5Ksc+pBDOyfJP4w91"
    "AO3qnbyBcUYuLA54IyOQTkMwCMXFBIQgKCWypQUjmWLH2HjKd9yOiqmJBIC+eUdv76+Q45x1"
    "U+kB0f94o6yoICAlgXgca3GJ+8fy4tLlPYXKL5OT/9z4N6q9vWwd41GgsaEtWL8Pb36etZUc"
    "PXULStVUa1IIpjOzib6uZwe3FACYzc1VnlCD4SOHawQ+V/bPq2AsptXsqsX1BIlkgmR6ZnrZ"
    "/F6vbyWIDg1lhGl1mC9fj/XsTtorRb60bQdbutjSIRwqxlq3YhEn9GTLBVtx6nabam1sxfVc"
    "3rwbJpvLHR2/Pjka2K7AMm0s6SA8QXYly/iNj6MA2xbYpk3f036ELXBdsdn/AThoNNoF6L+Z"
    "AAAAAElFTkSuQmCC")
index.append('ruby_get')
catalog['ruby_get'] = ruby_get

#----------------------------------------------------------------------
ruby_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAltJ"
    "REFUOI3V0ktIVHEUx/HvvXdGc0bHlOxplkZEChWREFhI2XvXogcMEdS2RRRJi6JFhbUKImoR"
    "tAqCaF3S27LJnkwbe/pIxxjfjTrOvf9ni7BFVvs+cDZnceDw+8F/zwGwx4/EDe5FsB6AVQa0"
    "xiqNVQor5M+RCisEBFJpIQ4X3Wu+7tjGo7uN61xzN2yKUhSDaBQiEZASM9DPaN83XK0JGYMO"
    "BBO5SRgZZeajp1kbyHjIuE6ju3RZFCGhrw+qqyGbhY4OaGsjNz6OpxQzrEUHAQOZDNG6OvzV"
    "K6NlTxKXQq7VB82H9qvO0GCtU74ICguhogIyGejqwsvl8KzFA777PpGGBvK+dFLyKplGqKOu"
    "c/7CO9fzt5pU6o75/AmSSUinIRbDyc8nz1ryHIdTu0Zo2jeK19lB6cs3nchg+8z3b2+6AM65"
    "K6Me3l7V03tbJxLQ3Q3hMBQUEJKSsFL4VlE+azknaxP0FAZ7StrfJX+lMMXG47GcUDdClYt3"
    "HFuZwBqB0AqhNfNLl7KifB0vux+STLUZGTbFLYcGJxx+Y7dti03i3WqMD23eXLMfbQ3aaAyW"
    "dCZFSXQ2zzvv86anxRgnKA1NK0Zz81i2vv6Ar0Svtoavw5+RRqGMRGrJWDDOqoXrmZCT7ouu"
    "1mH3T+2KtrSkfOWjtGJOrIK5sUXMK64i7BVQVrSAt73PaO1oHcxK1kx7YcrOy5XGFwJhBL4S"
    "LCmrcdZWbeF1T4L7H++mhaYh3UT7Xw/8rvq0k62t2Bh5/OlBn3Ro+HaGj9NS+JfKE2S19SIB"
    "uqr/LF1T+x/roThGhqNPmAAAAABJRU5ErkJggg==")
index.append('ruby_go')
catalog['ruby_go'] = ruby_go

#----------------------------------------------------------------------
ruby_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAndJ"
    "REFUOI3V0ctLVGEcxvHv+57jbUZNy1LMsiIrkrB7koQIRQUtWpXpJioICiIKrFUkrVoFFbQI"
    "AskgrCgISrpTUdJFCryVd1PTaRqdy5lxzjnveVsELUr/gH7wbH48fDYP/PcnAPTpE7Ue8iJo"
    "A0C7HiiFdhXaddG28zuOi7ZtSDqusu3jWY+bG4WuO7nHk+KarNrqJysb/H7w+cBx8ALjTIyM"
    "IpXC9DxU0iaWiENogpznryyddGpNT4o6WbLcj+3AyAisXAmWBb290NJCIhrFcF3StUYlkwTC"
    "YfwVFUytLfPPffnmsim1Ouh1dVwVwR8bRFExZGbCwoUQDkN/P0YigaE1hoDQsglmby9Etb1l"
    "zovvY9juSSnOX/gsjant3vDwQ6/7K3z6BGNjkJ2NSEsjVWtShSC2YJKc6o0U7a7DvznFGy+P"
    "nMvpbG0yAOpff5iq31R+3wkGywiFSmRBAWRkwMePOKEQdrGFUbOEnNItWN/eIVLyhJ2pqnbO"
    "t/vlnzkuXYqkJpP77L6BB87de7+fubmYrou7Lp9Zq3ah4t2k5xVi+qCwcrVvcWnRFfH3rnrH"
    "juw4xm1z3dptKatKUYODjKkWcveWI41BhMxAqyA4cToah2L/AABWZWWRcvRzKlcsjZWMo9OU"
    "zlo/W5hyEiGz8Bybrptfpjq6wgemBQD6zq45JTLTz+Tv2e/T9iOEitL+MGwZERUzhKCtZ/xo"
    "bcPQHXMmwCidV51fUeOzg1cwzVl0PrXire8Dx/KjkVt5eVDb8DMKMCMgpbCFMYKRNpf25mDs"
    "c2vgyOEb/df/7s0IjA78eBIJP1tkTcQTPV8DdYcaepum6/0Ck8wjSNVpF28AAAAASUVORK5C"
    "YII=")
index.append('ruby_key')
catalog['ruby_key'] = ruby_key

#----------------------------------------------------------------------
ruby_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArlJ"
    "REFUOI3V0c9rHGUAxvHvvO9sJskkm92yIXEIu7BgxcYgWgSh6mIaqfVURSSyF0EUKTlIC8Wb"
    "NzVgkYioIHjyVMGABxU9SKqEtpKSHmwk2ySbpDNms0uTtZnuzo/3fT2I0vwJPvBcP4fngf99"
    "LADzzrmqRnwMRgKYVINSmFRh0hQTJ/80STFxDFGSqjh+e/CnH76yzIXzr2hhfSmenXIZzILr"
    "Qn8/JAl6t8GeHyCUwtYaFcUcdO7BnT1yP/8Smiip2lpYF8SDD7nECfg+HDsGYQhra3DlCp27"
    "d5FpSq8xqChit93GPXGC7uOPusOXFz+xhVGv6z9ufmG1mk9YYyUYGIBiEdpt2NhAdjpIY5DA"
    "frdL/8mT9NxaJ//b8g5xel5Ysx/dELJ7St++/b2urcLyMuzsQDaL5Tj0GEOPZaG1xkxN0Xtr"
    "gyPXltZJotO5leuXBID1wWd7Ejmdbm1/pxYXoV6HTAb6+rCThEyakk5OImvrDF27vq6j+Ez+"
    "5o3l/174N6Zazbai+NLS2Nip370HyBcKtFZWODM0hGo0+TZjq+FHxmUQBHtBELxfq9U+lfcD"
    "Xytlrg4OPjZw/PiTr1areJ5HdnSUy2trbLf/0i/MnNXlclkWCoW+OI6fq9frGft+wHGc50tH"
    "j7729OQkn7919t5SEvWPeh4TExNsx7H48OJF4fu+ymazP87MzJze3Nx88xAAPJXL5RyAl/7c"
    "febXHnF1+ty0zOfzHBwc0Gw2mZub6wghXgbCXC7nHAKUUhu+73eB3ne94ffU/r6enZ2VrusC"
    "EIYhUkonk8nMA/i+3z004vj4+MPlcvmbSqUyWiwWtW3bRxqNBqurqziOQ6lUYmRkhDRN72xt"
    "bYmFhYWdQwAgK5XKhOu6857nDTuOI40xotVqvWFZll8oFOaBTBRFKgiCZhiGL/4N/BtBEDH6"
    "65MAAAAASUVORK5CYII=")
index.append('ruby_link')
catalog['ruby_link'] = ruby_link

#----------------------------------------------------------------------
ruby_put = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAldJ"
    "REFUOI3VkctLVHEcxT/33plRZ3TSonf0ICsw8FFIgURoA5mLaFMYUov8Byoj+hOKiCCKFkEQ"
    "FFGLljUQIVaIqclMpIVOKuXkZA8bdbz397j31yKSHgRt+8B3c+AcvocD/z0WgDlzsi3AvgTG"
    "ATA6AN/HaB+jNUaq76c0RkoQSvtSHi97mLxpmdMdhwLbum43JmKUxSEWg2gUlCKY+sB09j22"
    "7xMKAnwhmXPn4cs05Z1PCkaotlBgW6ftTVtiSAXZLFRVQaEAb95ATw/u7CyO1hQbgy8EU/k8"
    "sYYGvG01saWPuy+HbOO3B6+HrlmfPtZba9ZBaSmsXQv5PIyN4bgujjE4wFfPI7pnD5HMKBV9"
    "qRxSd9jWuYtp2/H2BhMTD4KRYUilIJeDeByrqIiIMUQsiyAIMIkExZkxFvc+H0WJfeWvBu7a"
    "ANbZq9MOTqt+++6+390N4+MQDkNJCSGlCGuNbmrCGRllUe/AaCDkgYqhdGphhR+Ytra4K/Xt"
    "0Ib1LeGjRzA3bjDf30+opYVTdYMoqZFSoTzFzdZ7FoD9y6a3bs2UzOYPqxcvH8rbd2D7doqa"
    "m5nPTiI8xe71jTRubMKdFwueXwIArGRyBnfumOjsyqjefvTkB0g+8oQrEFrgao9iq5jEhYad"
    "f1T4mc819Vst379+pX119fDykLMsvjJcuWoz0peMZcfpS/V6wtNdob8FLEn3DQI7Dq7eGPHn"
    "CoNeRFQK5SF9SW4qh1sQb72ov/+vH/xO4vyu9IolK6qlVGRGMqmBCy/r/tW7QP2Z2me1J6qe"
    "/qx9A7BjLmT4K0wxAAAAAElFTkSuQmCC")
index.append('ruby_put')
catalog['ruby_put'] = ruby_put

#----------------------------------------------------------------------
script = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAp9J"
    "REFUOI1V0z+IXFUUx/Hvuff9mTeTzJtsXDfIkiVWFkHRIrqCRPBPI9hZiCCWlmIK0TZ1IE0q"
    "S00TrSUkdkHQQBqbDRJMTHTZzc7sZP7Pu/fdeyxmdlwP3OoePvecH1xhWZ/eeHxBjF59sVNs"
    "T31k6iM+RqZ1HIjqSIWuIAGlD/Qw8bu8272VHAEa69dffv7E9qWL6xyviYvl1MWyPw+bzsOo"
    "Cjzqjvnpwfi9WXvtixUQ6nqjnQkAT54FUhESAZtAnhrO5gZrDKmFVzcLXihba9/+9s8VswKc"
    "b7cSqCOMnDDw8KyCwXxxejN4Og4AfH39MdvnWpxfz9ZXE0Tv105mhkkFk3nAGCEBrAVjwSJY"
    "gQhIGPLrn33u/TXYXQG1rzbKwjKY1UwrxRjFGjBBsAYsirWAWvaHFVdvPxii8tl/GVR+a6Od"
    "MpgrNYCCDYJRICyARA1RIaSBpIrnfrj05qE5NsHWmTJn4hQxYEUwgAFk2SMKqlBXFX0/CSzv"
    "+ejKjUJCneWpwQUwKBBRIgEloihgDPgQGE8m9c9fvTtcAf2njfVcwCxDQhevGgTRZRNCkUJv"
    "XFFXbh8RXQHeu2ZCJDFgjYAYUFlgAjEKKDQTw0F/RnBu92h1c/HL68/V9fzyhZfOsjdUHu0H"
    "DkeBiYOgioiSZVA0oN2E3nCKd9X+EZDMZ9U7RvWDezsP6c8SxpXig1J5wdWROkSiKmtlyefv"
    "n2GvNyVU/mAFRO9e+/DtV4pvPnnjf38gKPiguHqRybWbuzRTGI2nhNr1jgH+4V53wPe3d+ic"
    "KOi0G3RaOWUr52QzI88MeWL4+K0N8gQODkcE5/9eAbjqxzt372/eubuzJSKngdOgpxQ5hWpZ"
    "5FnaaKS0WwWddpPf7z/5Axt/OQL+BQBSS+DT6kQRAAAAAElFTkSuQmCC")
index.append('script')
catalog['script'] = script

#----------------------------------------------------------------------
script_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuJJ"
    "REFUOI1Vk01oXGUUhp/zfffOj6kzTdoYI6FpRaGCNf5gbIpQpYYiSncuRBDFZTfFLJrqsi5c"
    "WKgIXejChWRTXYgRwVoo+EcUu6gaq1BrjRrTYdLJ/N2Ze7/7fcdFxlhfOHDgPTy8vHCEgZ4/"
    "uzItRk/fub08k7hA4gIuBJI8NEW1rUJdEI/SANYx4b1ivX4u+hegIX/kvtu2zcwdHOVmdbNQ"
    "TbJQbfT9ROagnXqu1Tt8cqUz26uMHNsC+DwfqxQEgD82PLEIkYCNoBgbdhUN1hhiCw9MlLmj"
    "OjTyzjd/nTJbgMxVhiLIA7QzoelgI4Vmf3PWe1DreABOLKwws2eIe0cLo1sJgnMjtxYM3RS6"
    "fY8xQgRYC8aCRbACARDfYulqg4u/N1e3ALlLx6plS7OXk6SKMYo1YLxgDVgUawG1XG+lnP7s"
    "SguVF/7rIHWTY5WYZl/JARSsF4wCfhMQqSEo+NgTpWHP+3MHbpibEkzeXi3SzRQxYEUwgAFk"
    "cCMKqpCnKQ3X9Qx8njl1tiw+LxRjQ+bBoEBACXiUgKKAMeC8p9Pt5uePP9ECiAAatdJopQpm"
    "UBIKImAQdLBf/nWRX65+TDtpMCyJPTx//NVP4bUIwLnsloiYyIA1gg8CqpuNC3z/8wesJ+d5"
    "/NGHmRi5mwvLH8rSj2snp4+ObzcHX17Ymef9k9N7d7HWUq5d99xoe7oZeFVElO+WF7h/7xTe"
    "eKbGZ/Hi2L/vAKBHo34vPWRUn7p4+TcavYhOqjivpE7I8kDuA+3m38SyjSfveQmAuUNvs/jD"
    "GYSPSlFw2YNHHpsqv/Lc/v/9gFdwXslyOHKiyfLq11xa/ZL52Xd5/dyLlGwRRft2fN/hu4ar"
    "Q0+vtx0rtS61Vp9W4nC5Yo2hEAvep3z+0yK7x3ZTT/6k2a3x1aUvaG2kb8pDz76x00t0DHRS"
    "RHYAO0CHFRlGtVouFuJSKUYKF+j5JYL2AUlUw1vfnlmb/weDE2uIg356XgAAAABJRU5ErkJg"
    "gg==")
index.append('script_add')
catalog['script_add'] = script_add

#----------------------------------------------------------------------
script_code = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwFJ"
    "REFUOI1V00toXGUYxvH/951z5swlc2YyaYzU0NJs6iXU2mLrLErFWl0UXFukta6qC0F0Ibpx"
    "IS4L3Qhq3WlAiuBOxShog2BqiyDUCTaYmrFjJplk7pfzne/iQjPUB57tjxdeHsF/OX91/ZiQ"
    "7vJcMVMeJJZBYkmsZaBtWzjXdYKGQBgcTWAbaT8JG41v/F3AWX380H0T5TdOTnNv+soWBsoW"
    "miMzqxLoxoY7jR5frvZOD6PSa2PAaD0TpQQA1ZYhEAJfgOdDGEj2hRJPSgIPHpvNsLeQK11Z"
    "vntJjgGVRD4ObaGrBO0EWjG0R/92ewibPQPAWwvrlA/kmJ9OTY8vUErPXKsaljbqvHK0xEe3"
    "OgSJ48LhiIm0xEPgCbCAMB1++qPJzT/bNQnw8DvrpVgWni3lfUQMg9hhlSOfFVxZbrPZMfRj"
    "Sz+x4KDeibm8uNoxKrkgD7239vzh+fDuwQeyhZ0dzfkjERo4M5djY8eQz8HHN1r8cKvHSAus"
    "AxMY/Fgf+OLVxxflg3Phh/vzXvrvVsLFY3nClIeQUMr6nN6Xo97W7M0JlmsDjHY4BzqOaSZ9"
    "AyB/udG9eLsWj0qBxwfXWtRbGomj1U/4qtKm6Evu1BVH96RJBYLEGHr9vv72zac7APL2pYOf"
    "VX+rHF+pNEiFgoXvG+Dg6s8toqykvaV4qTxFeT4iE8B2L0bHqo4QDsAHSNuWmpQaOnmMcyAk"
    "Rhs6m4Zzp6bJpDxwkPUlW80hRqna7vf8k68v7NF69G75kYc4+9Qs31UUO13DiydmSAeOwAff"
    "g5QHURZWqwMSFdfHwGgYn5LOnblZWaM59OnFjsQ44kSgtEUbi3WOUqHAy8/cz8b2ABMnW2PA"
    "JurIc08+mnn7hSf+twHjIDEOpQEH739dIxtAtzfAaLV9D5CsbTTafLpYoTiRoRilKeZCCrmQ"
    "fDZFmJKEvuTsiRlCH7Z2uhiV/DUGUPHnS9dXZpeuV/YLIaaAKXCTDjGJc4VMmArS6YAol6EY"
    "Zfl1pfo7nv1xF/gH4At8dsrYI3UAAAAASUVORK5CYII=")
index.append('script_code')
catalog['script_code'] = script_code

#----------------------------------------------------------------------
script_code_red = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAw9J"
    "REFUOI1V001oXFUYxvH/OXPv3MxMnJlOk6atQR0XdmGtVNCYRYyg1YXgVkuL1HShC4VQW4La"
    "nR+LFqEoSoIbwRaKFEQkRYwupBG1kAoumqih1U4bms6Mkzsf9+vcc46LmqE+8Gx/vPDyCP7L"
    "S19ce0xIe+r+cm48UIZAGZQxBKnxhbUdK2gIhMbSAppI87nXaHzrbALWpGN7tg2OvzE5zJ3p"
    "JaYUJKbUivRooqATa/5qdDm/2t0XFivTfUCn6UgxKwCobWhcIXAEZBzwXMk9niQjJW4G9o7m"
    "2FkqVD795cYHsg8kqlg2EamBTiLwFbTbEX4EfgTNEG51NQBvnrnGeLXA7uHscB8YDDdGnvhq"
    "jvTlQ/QiTfXEDEOffUTg9+jEhm5kCRMwgNBtfr7SYulvf00C2MOHKzNLZ58tOCFKOASxReHg"
    "0mH73EmiVodebOgpAxbW2zGnFlbbOlGHZHzw4Ithu3Njxza3ZGpNakffJQUu7Z8mue6TFT0e"
    "ODqFt/gDUSowFrSrceK0+uXrjy5IHUZzydjuAXNpBY7N0B6sICToYoU/X3gNfv0dNfYgd8+e"
    "QCqFtZDGMS3V0wCSKHxFnl+MTHUn4vjb2Ft1JJas36A6+x7pfTsQ84vUpqYRWRelNd1eL/1u"
    "5uk2gMzPz5+dHZ0cu7K6gRr0qB6ZAgu73j9GpugQtAyXZ8/hT+wj50KzG5PGyTpC2NsXAPND"
    "u5IPJw7gxJCp10FIZKNO4MPV4ydRhRJYyDuSeitEJ8na5vecySNnhtI0euehPXvpTp/m++WE"
    "Qkfz0ydfM+BaXAeymdst5mG1FqCSeL0PRGH8lLT2uaXlq7RCh25sUdoSK0GSGlJtMNZSKZV4"
    "9Znt3GwG6FjV+4BRySPPP/lw7q0Dj/9vA9qC0pYkBSx8/M0aeRc63QCdJs07AHX1ZsPn9MIy"
    "5cEc5eIA5YJHqeBxVz6Ll5V4jmT/xAieA/V/OuhEXe8DJPG5CxdXRi9cXL5XCLEV2Ap2i0Vs"
    "wdpSzsu6AwMuxUKOcjHPbyu1P8iYHzeBfwEwiol55ANRRAAAAABJRU5ErkJggg==")
index.append('script_code_red')
catalog['script_code_red'] = script_code_red

#----------------------------------------------------------------------
script_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAtpJ"
    "REFUOI1Vk01oXGUUhp/zfffOZDp2xqSJaUtpGlEp+FNUqMZNCxrEKuJGoQgqFFy4qu2iKAiC"
    "4kIstEt1JdJNuxBFRdIsKl3YChVxoV3UtE0xNiHT6fzcmbn3+zkuMo71hbM6L885vJwjDPXa"
    "6eW9YvTEvXdX5nou0nMRFyM9H1ui2lFhXZCA0gQamPhleX19IfkXoNE/8cg9d80d3TfFncqK"
    "WO8Vsd4chB2Fg04euLbe5fsr3fl+beLwCBC8n66VBIAbtwOpCImATaCcGnaWDdYYUguP7qiw"
    "vV6d+PziX8fNCFC4WjUBH6FTCC0Ht3NoDTaq0Ye1bgDgnVPLzM1WeWiqNDXaIDo3sblkyHLI"
    "BgFjhASwFowFi2AFIiChzYWlJpeut1ZGAO/y6XrF0up7erlijGINmCBYAxbFWkAtq+2cE2ev"
    "tFF5478McjczXUtpDRQPoGCDYBQIG4BEDVEhpIEkj7Nnjj51y9yxwczWepmsUMSAFcEABpCh"
    "RxRUwec5TZcFhn1ePn66IsGXyqmhCGBQIKJEAkpEUcAYcCHQzTK/eOyZ9gjQXBubKguYYUjo"
    "xlSDIDo0/fgp/ff28NOBCm9eeF1+mLfHABIA54pNCSmJAWuEEAVUNxIX4Nxn1C6f4YFXDlGe"
    "fZD+bwv29/MLH57Vy5nZd+TUpPeDD/bu3snNtnJtNXCrE8gKCKqIKPniSe7f/xJjf55DvjjI"
    "pqWv2DUzaQP6djLo508b1ecv/XGVZj+hmysuKLkTCh/xIXJo9TpjW2fhwJHRiSfvb8Oq7Eqi"
    "Kx57cf+eyruvPvm/HwgKLiiFh18ubqf363dUv3mLvH+THtBpW4JlxW57+Nn7xuvVFxodx/Ja"
    "xlp7QLvncF6xxlBKhZJErp7/GpMKzma0GsrSignB68fy+MFPJoMkh0FnRGQLsAV0XJFxVOuV"
    "cikdG0uZDz+z++9v2Zw1yBNZs9GffG4xfvQPC9hhQ8GmkvkAAAAASUVORK5CYII=")
index.append('script_delete')
catalog['script_delete'] = script_delete

#----------------------------------------------------------------------
script_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxVJ"
    "REFUOI1NkE9sk3Uch5/f733flq5dO7t1mwt2FlDJdJrNZGSKIRGVxBlOcvBPOHowMUE8GDkq"
    "R0lMSPQAiQecMVyUCEQc0ZhtiaiEIcpm1Q3WDja6tuv/99/v/XmAVT7J9/h98uQR3NvB08tj"
    "QupPtnVFxpteQNML8IKAph9UhNY1LVgXCIWmDBSRwanw+vr35iZAB/6uJ3tj4+/tSXH/Gm6Q"
    "aLpBomyrra4HNUdxY73O+X/qL7biyUNtgPL9vnhIAJDbUFhCYAowTAhbknRYYkiJZcDI1ggD"
    "iWjyxKWVY7INcL141AQ/gJorqHiw4UDFvnvFFtypKwA+mFxmPBPliVQo1TYIPC/ZGZI0HGjY"
    "CikFJmAYIA0wEBgCAkCoKj8vlrl8s3KrDfA9py8RMai0fJqORkqNIUEqgSHBQLOl+iN/T33O"
    "2z3DNGZ+4lW/f/L/Bo432Be3qNgaH0CDoQRSAwritW9Jln4hMvwmicwIG0uP0bxw8uD9BoP9"
    "iTDzawohQXL3WQIdte9IW38Qe+RZSv/OExIunfF+Yt3phAlw4NjpSNP2Q2FL4iqFRAMaDYQb"
    "s2TMX0lk9uHc/opQh+Dm3AJuyynaTv0ZCVC+syUVFiDvRUKDACK1aXaIiyS2v4x96wTCKmPF"
    "OnHrK0HQWHth1zvfZCWA57kdJgGmBEMKEBK1fI60ukhix37slc+QlodbfZi16ascz7+0MPLu"
    "1ByA3HN4ssf37Y/GdqZZrWpurCkq2XP0e5fofXwCd/UkRkjjVAcpzFwhN/wh8/XU4mY70245"
    "e6XWE5fnlyi3TKz8eQ4MF/CDAW5fO84DvSHs0kPkZq8j935KPmejHK+wCZCB546+snso8uWR"
    "CY6+/ihDnGVo91uEczNkz8wyd6HEXz9cZTr5PpGuAWr1Jsp3i22DwPOWVtcrfDE1T1csQnax"
    "gPvnWTJPPUelUGTl2iLPHznDg6HthE0olGoo18tvAsTTr33co4R5CPSgEKJ7W+7ovtFMSozt"
    "zIglJ6q/zo8K2+omHo3QFe/g94VcFiN448qpw78B/AdkdWZdteLv9QAAAABJRU5ErkJggg==")
index.append('script_edit')
catalog['script_edit'] = script_edit

#----------------------------------------------------------------------
script_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv5J"
    "REFUOI1N0kto3FUUx/Hvufc/r0xmJp1mnLTWhvRhY2uMMViNUFJQ6abqQlwUQdyLUCsiuhHR"
    "jWihC3eCCyUIxVBQVLBBsFR8NRWkUpRQ0/RhMpnJZN7/173Xhe3YA2f74fc7HOHWvHB65aAo"
    "d2rXUGamG1m6kSWylm5sG+JcywlVQQyOOlBD2U9T1eq33m3A2fiRB+4anHl1tsSd0wltoRva"
    "Qt03O8IIWoFhudrm66X2k7188XgfMHFczicFgGubhoQInoD2IJVQ7EwptFIkNEztyLC9kC1+"
    "9PONk6oPhFE+60FsoRUKjQg2A2j4/22tB5W2AeCNuRVmxrLcX0qW+glsFBVzSUUngI5vUErw"
    "AK1BadAIWsACYpr8dKXO4tXGzT4QR0G5kNE0ejHdwKGUQytQRtAKNA6tAadZawacOrvUxMmL"
    "/1cIotFyPkHDd8RA6CA0QmhAGhfIrrxLGLSwDkzC4AXx2JmXHz6r7kgwOlJI0QkdokCLoABt"
    "e+Rr85TKE2TWv8Q5iIOAetQxAArguZOnM2LiZCqhCA0oHGBxWDL1byiWp8hvm0KvLdCp/Um7"
    "04kXXn+i2QfqlXQpJaBuHQkHAiSDm6RXvyI3PIRpfsHIgWOs/T6HC/wKIq4PRFE44GHxFGgl"
    "IAocpFbnKe97BvyL/PLJHINDPXrXfmQyfal7u7qaPTE3HMf+OwfHd7LadCyvGTZaBlP7jaJs"
    "ktvSxQZ/g7OY9q+MHT7B44PnR86/91gOQI88ePQpTPxaL4wSS+vC1dVNrtyosXf9Q3ZPHkLb"
    "i7h4g+37h3G2S3IgRSa1L9m8fsH/eOGf7z0bhQ89fXgy8+bzj/b/f/2PM/Q2JhjIVTHtGohm"
    "cf4y08/eh/X/onTvEZbPhS+de2v/53rbxJE9WwrZo7VWxEqlQ6Xp0/7hbcZmX0F5Gkncg0qP"
    "c/fUIVR6HEnuxsvuJZnbk61c/q4s08c+GDbiHQc3KiJbga3vH/hsWrlY4Zw463DWgrNgwZjY"
    "aWdCrLFYt/gvZEhrVo+emp8AAAAASUVORK5CYII=")
index.append('script_error')
catalog['script_error'] = script_error

#----------------------------------------------------------------------
script_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwpJ"
    "REFUOI1Vkz1sW1UAhb9773PsZ7d+rpvYFjVNjDJAQEQtVSEsRaAyUIkJBhQJUXXoBFSNVKWs"
    "DFlaqStCiEDbpWGMGEgGFBYIqViCWpHIdpO6so2N67/nZ7/37mWghHKks376dKQjeJIP7+yd"
    "FtLceC5lz7m+xvU1vta4gW4LY7pG0BCIEEMLaCL1zWij8YP1L8Do4NWXM4fmFs5M8HT6I+24"
    "I+20vDA/8qE7DCk3eny/2zs7SKYvHQDCIMgmxwQA+49DIkJgCVAWRCOS41GJkpKIghN5m2ec"
    "RPrLXyrX5QFg5CcTFgQauiNB24fHQ2h7/7Q5gHovBODq7T3mCglemhibODDQvp8+PCbpD6Hv"
    "hUgpsAClQCpQCJQADYiww8/FFncftB8dAAJ/mHVsRXsQ4A4NUhqUBBkKlASFQSnAKGqdITfW"
    "djsY8dF/Gwz9yWwyQtszBAAGVCiQBghhsPsjgT/ixdw5wkiINdSFlYXX/5JPGUzmnCj9kUFI"
    "UEIgug8ZlX7CeB1i0THi8Th/1uu8ndrjnfHiNQAB8P71O7brOe53V86y+cBHYwDwixtMTU1R"
    "qVTIZrNIKSmXy+TzeVZXVxkMBgkLoFWPTSQdkE9GwoAQIA4fw/M8Go0GGxsb2LbNzMwMrusS"
    "j8e/XlxcdCWA74/iFhpLgpIChKR3fx1H9clkMuzs7PDm/FXeO7/Aw0qFXC7H9PT0+aWlJWOd"
    "uXx7PAi8z08//wLVjqFcC0nEwGu3UUqRzWbJZDLYMUjGwRhBt9tlf3+fYrGI5Q2Gb0ljzt29"
    "V6I1sOgNDX5o0MEsuV6FdLpKoVBgc/UbtoTh+LPHaDabbG9vf6W1vmJpf3Ty3Tdm7c/mX/vf"
    "B0IDt77dAlJUq1VOnZzF8zxKpRKO4wBc6HQ6Fy3t+6Vqo82ttXukDtmkkjFSiShOIkoqPc7y"
    "8jIff/IpW79uUqvVaJgs6+tfmCAI1lZWVkLxygfXxkNhXQIzKYQ4ChwFc8QgjmCMY0fHIrFY"
    "hBP2fer1Or/rU3+g9PxvNy9vAfwNFnVoEQ5qDTEAAAAASUVORK5CYII=")
index.append('script_gear')
catalog['script_gear'] = script_gear

#----------------------------------------------------------------------
script_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAvVJ"
    "REFUOI1Vk0toXGUYhp//P+fMJZPOJNOJCWVsaOjCaNWqmDaKpKDJRnBTXAlWRHArdlHstosq"
    "WIgLwSIiot1EQVcurFRrI7aRCCI0XtrmZmvaTjo5cz3nv7pIGusL3+qDh4f34xNs5eWZlTEh"
    "/fRIX368ox0d7dDO0TEuFt43vaAmEBZPHVhHuk+ztdo34V2Ad+bAI/f1jh+dGODetJUrdZQr"
    "1RNbVRqaqWWp1uLrK63JbrH8xjbAGjNYzAgAVjcskRCEAoIQspFkd1YSSEkUwGPVPLtKhfKH"
    "l66fktsApYuFEIyDphLEGjZSiJPNWe/CrZYF4K0zK4zvKbBvIDOwbeC0Lu/ISNoptBOLlIIQ"
    "CAKQAQQIAgEOELbBxWt15pfjG9sAo9PBUj4g7ho6qUdKTyBBWkEgIcATBIAPuNlImT57pYEX"
    "r/zXQaqHB4sRceIxAB4CK5AesJuA0EucBxtZwtTt+fzoU3fkPQbDQ6UsbeUREgIhkIAEBDBz"
    "cYqPzo2hTIpJU+q6bdna8+KpmbywJpONJMqCxAMOj8PicXhSo6hWRnn14/20Ohvm22PPNQBC"
    "gPqt3ECxBHKrJDx8NTeJdwblDMoadvXvZXToAM2kzZ3u6+HE+68VzkMrBNBa9YREhBICKbBO"
    "YJxi8qEjWO+wzuLw3IhXebj6NC3VZX7lfPzE25TDiTfPVIxJTow9MMpaw7N001LIQWIU1juW"
    "1/9CO4NxGm01jbTJ/vufoaU78tLi7HqYdNNnpffPzy8sUu+GtFKPtp6EBGMNg8XdGGex3vFP"
    "vEK5d4hfVn9k9ursbWWZCp1Wj79w6NH88ZcO/u8HDn+Q8slP76KcIjGKkcqDHByZ4uflWc79"
    "8UM7sRxaO8nl0Gm9uFaL+ezsAn29efqKOfoKWaYP/8aOngzZjCQbSp58pxch88xd+5We20fe"
    "Wzp9+vLmFVT6xYW536sX5haGhRA7gZ3g+z2iH+9L+WwmyuUi4ormuz+/p/j3scXIVb68a/ov"
    "UXB+NWjA4+IAAAAASUVORK5CYII=")
index.append('script_go')
catalog['script_go'] = script_go

#----------------------------------------------------------------------
script_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAv9J"
    "REFUOI1Vk01sVFUYhp9zzp2/DswdC2NJWzu2aaJGo9VFsbioRDExJCw0rkyNK2KiCwNudOua"
    "hMRFF7jxh0iKaOJCFLSaoMZiiIkKLaROpwWEkoH5v3PvPfec46K04pt82+d98ySf4G5em1ub"
    "FNIdHSvmpgJtCbRFW0uQ2KZwru0ENYEwOOrAbaT9JFOrnfE2Ac4mux+/f9vU4ekS96YbWz+I"
    "rV8PzXCsoR0ZqrUOXy939vUK/W9vAUySDBTSAoCrDUNKCDwByoNMSjKSkSgpSSl4cjjHoJ/v"
    "P7Zw/YjcAsS6kPcgsdCOBU0NjQia4cbd7sGtjgHg3eNrTI3meayULm0tsFr3b09LuhF0Q4OU"
    "Ag9QCqQChUAJsIAwLX6t1Lmw2vxnC5DoaMDPKZq9hCBySOlQEqQRKAkKh1KAU6y3Io6eXW7h"
    "xOv/OYh0eaCQohk6EgAHygikAwwoZyhUZllfrDCRLvNb+MzoycN77sh7FpR3+Rm6sUNIUEIg"
    "AQkIIFf9jEF/ldLuGV4e+5ODvXf2AngArxyZywVhks6kJLExSBzg2CgX9F37kgdSP+I/tI/u"
    "6mn84oOMllsfn35rLO0B1G9lSwUf5F1JOBACJALnIN/+HX/PfkxwkezOYUJzjcHpib6kc2fW"
    "A9A67vNI4UlQUmCsAOc2jAuIvCF0vYpUNYTski7UIAzo3IiUN33o+M4kCd+ffPgRbrYc1XVD"
    "PgvZtKTQu8Su9Q9JZzU2CZG2AXI7TscsnbgcLl5pHvTCXvScdG7/hcUV6j2PTuTQxjGe/MRk"
    "6nuGXtiLi88gTJtL30a4ToCNwt7ySmNm5sTaKc/q+KkDzz6Re+/Vp//3Aze++4D+R18krs3i"
    "eT5//ZAQjrzBxXCEk98sHJv/6NApAM9qvXKz1uTTs4sUt+UoFrIU8xmKKIS6jsqUWJoPMONv"
    "Mj55gPkvfqGRpCqbRR5x9Pm580vD584vloUQO4Ad4O57abAx9Hyl0teqx8xVJ6j9HVBc+Io/"
    "lq5eQdmfNwH/ApjHYrODX5+hAAAAAElFTkSuQmCC")
index.append('script_key')
catalog['script_key'] = script_key

#----------------------------------------------------------------------
script_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxxJ"
    "REFUOI1N0strXGUAhvHnO9fMTOaSmVxMTBssto1W1AqmVpGIly4sihRUqiKCioIo0gri2pVQ"
    "ISBu7EaQbGIXrtRaBTWINWKRttikhF5yY5LMZDKZmTNzzndzoQl9/oDf5n0F//fq1MKYcOzE"
    "nkLqcCQNkTRIY4iUqQtrG1ZQEQiNpQZUccxXYaXyg7cNWKMO3dvfffjkeB+31kpMPkpMvtbR"
    "w4mERqy5UWny7XzzqXau+P4OoJUayAUCgMVNjS8EngDXg9B32B06uI6D78LB4RRD+Uzx9B/L"
    "n+4Ah7K/HDgS/szGJYuXGIw2xNpgtQQyiP2nIOjn9rzLR5MLfPLyCL9fC/o8ADv1vPtT998H"
    "Sj2DuH4fXVJhpUInbdq1WeqlF7C2FzcBAwi9xflrNf66WV9xAMp713btT1/Z46dGMK1/EE4G"
    "oxWdzausdr9EPfs0rRha0oCF1a2YiXPzWzqRr3n28t3BWtO8kSve44KLaZfBi6ndPEel9A7N"
    "/HMgwcXiWQdjQfsaLzZ3fH3y4Q2v3CgeFEa9FWb3YlUb3EGQEm1cvPYC+aUJUB2MyKIGj2Ht"
    "blQcU5eJBnCENp91lR7sbVdniSpziPBOwKM09DgD8hJ90XnCG18inV5EWEBqTbPVUj9++OQW"
    "gGO0mlq+fvH0NxfS2GAfa/NnUXEL2dkkiSqs6RGqY2dJdr1IKpWm2oxRcbKKEBbAGxqfOTV+"
    "4szoQG/mzVeOP0J9bpJo7TL12ipbQ+/SGTqGNQLXQtpzWK+10Umysj2/N35islepzsdjo3ex"
    "NP0eQVhkuT1IZfQLglQWX1j8QBC4kEvD/GKETOLVHaDTjp9wrD3aWPiOzf55fo1fZ049RLxc"
    "JVHrKG0w1lLM53n7yG2UqxE6lus7gJHJA88+dl/qg6M9WJ7h/sK+/65tQWpLogALn3+/QtqH"
    "RjNCq6R6CyCvlyt1pv7MU+hOUciVKWRC8pmQbDogDBxCz+H4owOEHqxvNNCJXNoBSOIz0zOz"
    "w9MzV0aEECWgBLbHInqwNp8KA7+ryyeXSVHIpbk4u3gV1/y2DfwLYhCJbIhbPSoAAAAASUVO"
    "RK5CYII=")
index.append('script_lightning')
catalog['script_lightning'] = script_lightning

#----------------------------------------------------------------------
script_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAxNJ"
    "REFUOI1Nk89r22Ucx1/P8/0maZotv0yaVoth8+DBpWMKage6gfYkUwsKkTLdbQcvYxNE/4OK"
    "g52c4kXQHuygF2XoNnAocxmSgz9wWIdZuzZp0rRp2nyT76/neTy01r3hc3q/efHmA2/Bnt6e"
    "X35WSHPpcDo+2Q80/UATaE0/1F1hzI4RtAVCYegAG0j9Zazdvmb/BzA6fG5i5MDkhRN5Hpbj"
    "61Tf16mOq8b9AHY8xf12j6v3elODZPbcPkCFYSEZFQA82FJEhMAWYNkQi0gej0ksKYlYcGw8"
    "zqOpRPbzO6sX5T7AD5IJG0INO76gG8CWB1139zYG0OopAD6YW2byUIIj+Wh+v4EOguzBqMTx"
    "wHEVUgpswLJAWmAhsARoQKhtKv90qC516/uAMPAKqbhFdxDS9wxSGiwJUgksCRYGywKMRXPb"
    "49L1e9sYceb/H3hBsZCM0HUNIYABSwmkAdQuwDYSbUBFFLanD125cHxTPtSgOJqK4fgGIcES"
    "AglIQOxlhAFjIPQ8OoGj2PN58+J8XKgwGotIfAUSA2gMGoVBYzCAlBAoRc9xwhvvv7wNYAN0"
    "WkP5ZAqkANdzqf32M92VP8k/kqHe3OCpF1/nwMEst777gt9zGY7Llnzi3W/f+3tq6hMbIAj8"
    "YZsIRgXcuXaFlHR45/QMjuOwsrJCpXIVKzLE9GunsG2LRqMhq9XqR0tLS3lx4vxcLgzN5emT"
    "x944PNSi8uMNyjNl5r7+hr9+vc3Y6CilUolGo0G73aaxtkY0Pd46f3ZmZGFhoWu7A+8lacwr"
    "1bs1bi//wsT4MACdwil6/ZuUy2UymQy9Xo/19XUuf/oZm/Gj3wOn0+l0zNaB//SrJ4/GP5x5"
    "nvl5h0qlAkBxc4EH0jA7O0sikdjdheNgtCa7eesFOMLq6qpr6yCorbW7fHX9Lr49Rqfb46cf"
    "blKamKBUKtFsNllcXCQWi1EsFikUCgw8f6RSqWzV6/U18cxbH+eUsM+BKYLJWX5nPOf+8eRj"
    "o3k7Fo0KIaA2yDM0nGSMGsZo47sDt9FoNB3Hmf4Xnpl4Bo+No7IAAAAASUVORK5CYII=")
index.append('script_link')
catalog['script_link'] = script_link

#----------------------------------------------------------------------
script_palette = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAzxJ"
    "REFUOI1N0clrnHUAxvHv7533zayZLclkaUzS2JRUi6V10hjRNrS0thSsF5daEb15EcTiQkH6"
    "FwhF8KIXsRahtiAIKsaDpUhtaypkwCRtkmZplklmycw727v9fh5sQp/LA8/hc3kEj/L2lcWD"
    "QlMX++PBkZojqTkSR0pqriwJpUwlyAmEh6II5NHkJX8u95u+BSjpDj+TioycO9zG46naMlaz"
    "ZazY8LptB0zLYz5X4eeZyrF6NPnBNuC5bnugusr1az9SXLwPQhHs2E1/+ijtT/TR49fwaRqG"
    "D/Z3B+mKhZNf31r+3LcFjO7tOr87f72/I2QzMOCjK5VEVIrM3x1jtWQRSg1QcyEa0Pjo0iLv"
    "HmpjNmuG9QsX0FLlV77dk7h3ZG+PQbJ/BV/LNNIOENHfomfnLuamb/Lv3ThP7htFAsIr89dc"
    "kfGF0oqeLJz6aiSdPvt0xybC+gdnUYNQhKoj+ca6TNANcnrHCVaX71B96hAoH9myxcWxmTJK"
    "vKN3xSJnBjNLuDfLiBMxVKCF8sMRljcz+KIZsOsYrknYK9BwBVKBZ3joltz5w7nnC3ogEA4p"
    "B2STTrX5JaZnJmj2T0FqkKsLw4Q9m9fj02heA6FAKXAti5JjewC6Eorc8WEihsTcLDBXcImo"
    "TRKJXdSJoqkKCAnKQ9PA8Twq1ar7+2cny3wK+kJ27fvNsZ9GopFw34FnhzjYF8PwJQiYs3yS"
    "v0VvZzemEWTdnyRlQL5i4Vp2FiEUgPb+F7+8eaU09Nq12gtkMuN0tO0gZObQSusc62ml1Wjw"
    "93qd5j2vEtI1Nop1PNte2bpfP/zh5daiqz4eTe9H1h2Ws/OkWnup2lUWixvM+nppG3qD1lQn"
    "0RDMLNVwbCu7DTTq1lFNqVPjkw/ItadZKy2Q1BeYMDuZV0ewI4PIP8okY4L3jnewlq/hWc7G"
    "NiAd+8DLo/uC588+92j6v08rcDyF7QIKvvx1hZABZqWG59r5xwDnwVquxHdjk8QjQeLRAPGw"
    "n1jYT3OoCX+Thl/XOPNiO34dNgomnu083Aawras3bk9137g92SuEaAFaQCUUIoFSsaC/yQgE"
    "DKLhIPFoiImppXv45J9bwH+TgXl1DBZKwAAAAABJRU5ErkJggg==")
index.append('script_palette')
catalog['script_palette'] = script_palette

#----------------------------------------------------------------------
script_save = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAspJ"
    "REFUOI1VkU1onFUUhp9z7/3mPzPTNGmqLU0sSC0UixGjWVUsrhQFwYUUxI1Id0VXCkLBLhvI"
    "XnChFrFLERdmoQsXLdhuI1jamGpokomTmcl8f/fPhXVsX3iX5+HlOcLDvHt9c0lUXD3ZrS+n"
    "NpDagA2B1IWBxDiKQk8QT6QP7KHCV9Ve70fzHyAG9+KzR1rLH52b5dGMy9BJy9Dp5/54aWFU"
    "eDZ6B/xw5+DVrD19aQLwzs21KwLA/X1PIoIR0AaqieJEVaGVItHw3PE6T3aa05/f/GtFTQCl"
    "bTcNuACjUhhY2C9gkP/bvQx2DjwAH1/bZPmpJmdmK7OTBcHa6amKYlzAOPcoJRhAa1AaNIIW"
    "CID4ITfu9rn1x2BrAnC2mOvUNYPMkRYRpSJagfKCVqCJaA1EzfawYHXtzpAo7/3voLDzc+2E"
    "QR5xwHdrvzNVhbR0HGpV2NrJEAWthuaJRoX+MGv/dHtr8OiC+aOdKuvbHlGQpTmvLJ3izcUW"
    "39/4k08vnH7sO1/+vEsIclMBvL1yvS7eVaqJovSgiKSF5e+RA2Dt1+3JYe5gWMDufolIQAH0"
    "d2qzVQH1UBIRlBJ0BOsDKxcXCSHiQ0QTaJhAURQMxyUGwNqyYUgwCrQSfBBqiSIvLFe+3UAJ"
    "OB8IPhCBGCNEaCQBc+7DazPO5Z8tPXOaB8PIxranWQMXIoV3aJUAEcEjIsQQiTHgnKUsHSbP"
    "ivMqxtdurd+jnxkOioj1kVFqScRw8fUpXCgBBRGiBGqmwtVvNtkbjjHBlotvvHy2/smFlx6z"
    "/NblX9AkBDK+uP0BM40TCIrd9D7vv7CKokZalJhg7b0HvQFfr63TbdXptmt0m1WM0SwchbnW"
    "iPNnl+hWjoGC/fwYR5qORgWMCPL8O1dnvJhLEOdF5DBwGOIhVT+58PTCdNKtdqmZNi5YJAQk"
    "eoKk/LZ5l52h5R+2ulpJz2KIXwAAAABJRU5ErkJggg==")
index.append('script_save')
catalog['script_save'] = script_save

#----------------------------------------------------------------------
server = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAbRJ"
    "REFUOI2lkz+LU1EQxc+a5UUNIa5m/RMloFa6LIgWfgIXZQsbAwrW6f0E0V6Cvcua0m+wbJ1O"
    "88BFCFqtjZWNxMjm3blzjsVLQlZfLPTCbS4zZ37nXAb4z7NS9Jim6ZsY41MzW40xwsxgZggh"
    "wMzetlqtJ7Pa1cXGwWBQA7BTq9UelcunkZkBJAQAEtbWzmB/f+8xgD8F0jS9T3KnXq9frlQq"
    "OPzyFTFGkAJFgIKTyLLsGO1cgORes9kEABwdTWAx4uNBCpLze2/rAUIIxQJmhiRJMBqN8snu"
    "uLlxCxSh6XRJywlCCHB3SIIEkMLBh/cgHSTh7ri0/fDvBHlWgruDFDY2b0PTDERBBRmcWCSY"
    "CUiC00HPvX+rHmL3+ytwoa7Qwrx52jibvvv5NX7+iBC1XCDLMkjKf0QEp8iU8Ozcc/AsIHFu"
    "tZAgSRKUSqV8shNSLpCT5OH+TjDPYDKZvOv3+xiPx6hWqzh5qgxhBXTCldNIWk7Qbrfvdrvd"
    "7eFw+KLRaNy5eu06zq9fgZnNrV28sI4Y4zGBwmXqdDpbIYSXZrY5W6YYI2KMcPdPvV7vRlHf"
    "P51fgatf/8BvOGcAAAAASUVORK5CYII=")
index.append('server')
catalog['server'] = server

#----------------------------------------------------------------------
server_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkhJ"
    "REFUOI2lk0tIlFEUx3+fozPa9DUZU2qBIBY9xEfBhIgQJIoRZEJCQZs2LYxWbdrZooVFRSsX"
    "JbptGbkQW2q0UId8LSaKlCRSzMwZzZnvfvecFjoijbbpwIXL5Zz/63LgP8v5+yEej/f7vn/T"
    "GJPv+z7GGIwxeJ6HMeZVR0fHjZ39+dnL+Ph4BOiNRCLXQqF9ZIwBERRAleLigwwNDV4HcgHi"
    "8XiriPRGo9Fj4XCY2blv+L6PiCIqIIoVIZPJ5FjIBxCRwfLycgA2NtIY32d6Mo6IbJ/mlkt4"
    "nrc7gDGGYDBIMpncZLaWM1V1iAq6xa6qeyvwPA9rLaqKKogokxNjiFhEBGstZZfb/q1gMyvF"
    "WouIUlV9Dt3KQEXRPTLIyyrIAqgqVixiN70vubP0/XqO7Ojb1cL28NZglr3v40vWUz4Tc8Os"
    "Hv7M7WdtmlxfTa2sLT8eejT9MADQ3t7+oKKiAs/z8IxhNbmOiiCq1BddoMS6LDlTNMbqaYq1"
    "YkLLoR+/v14MHw+42xaCwSCBQGCT2cqOL1Rmvg9Td6oWm2epLWvGOob66gZA7+QBpNPp0ZGR"
    "EdbW1nBdl8KiEIqDWMGq8iO1SIGznyun7wJwr+kFlUdqcHAKAwADAwO9sVhsPJFInFxZ+Xk0"
    "Gj1EaUkprhsmcsDlzVg/xWX5DH95TWPlVbrf3iK1scx0IpHOWaaurq4Wz/OeGGOqs8s0LzMU"
    "VC7SUNPIidKzfFr4wPupd8zPrj7NAdirzneWduM4nQ64CilUe0Z7Fu7/AS+UeqJIlhZIAAAA"
    "AElFTkSuQmCC")
index.append('server_add')
catalog['server_add'] = server_add

#----------------------------------------------------------------------
server_chart = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjdJ"
    "REFUOI2lk71Pk1EUxn/v2/K25cNKJCEKqQ66SEjQhcFZ/Ex0sEYTFhdMHDvqQNxdjCuJg4v/"
    "QEMYFSalKlFZOkCixrioKaX3fe/HOQ5FREAWT3Jzc4b7O8/z3Bz4z4p2No1G46n3fto5l/fe"
    "45zDOYe1Fufc82q1ens3IA+wvLxcBubK5fKNQqGXzDkQQQFUGRw8zMLC/C1gL6DRaFwUkbmh"
    "oaGRvr4+1ta/4L1HRBEVECWIkGXZvhbyIjJfqVQAMCbFec/7lQYisn3OT13CWrs/wDlHkiS0"
    "Wq3u5BA4PTaBqKBb01X13wqstYQQUFVUQURZefcakYCIEELg6JVrByvoZqWEEBBRxsbPolsZ"
    "qCh6QAbxb3JXgRIkIGHLf2xp6XcKX9e437+OPL6rrna5tQew/Tj8CS5I4EnzDPPmAg8+TUJP"
    "CY6MguZ67n2o9t/5WJ0GiLMsQ1UBEJXu90n3Hh4ucbIckRQTcB6sh07ARPGPXJQ8u/n2+rfY"
    "WkuSJORyua7vnSqs4C34jiLGo1mATU/qXb5MmSzLDsVpmr5aXFyk3W4zMDBAsVRAiZAguI7i"
    "MyVsKqQOjAPjSdMM6x3GZMV4ZmZmstlsXq3X642lpZcUkogTx0epVEYIHfBGCZuA8ZB61HlM"
    "mrJh2zjrurtQq9XqQH12dnZqdXX1kXNu3HtPOPYQ3weSCmoC9HrwgjEprXgDk5m/t3F3TdTW"
    "NVJQhXM/X2gpH0WfO7nszamQ15zJBVv0vwBPraeTe+8LXwAAAABJRU5ErkJggg==")
index.append('server_chart')
catalog['server_chart'] = server_chart

#----------------------------------------------------------------------
server_compressed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmlJ"
    "REFUOI2lk81rlFcUxn/3nTczGcfpVEz8iDKg7hpCq8GW7roxtIi4MVChf0P/AVvS4sJNyaIb"
    "DYhuuxe0WYSCIVloBowSocWPiKStiYTmJX3fee+595wuMn7E6soDZ3EW93ee81weeM9yrw+d"
    "TudqCOEbEUlDCIgIIoL3HhH5ZXx8/OybgBRgYWGhBVxutVpnarUdlCKgigGYsWvXh0xP3/ga"
    "+D+g0+l8qaqXBwYGDjQaDR4vrxBCQNVQU1AjqlKW5VtPSFX1RrvdBqAoukgI3FvsoKov+8TY"
    "V3jv3w4QEarVKlmWbW2OkY+GP0FNsd52M3u3Au89MUbMDDNQNRbv3EY1kpKDczx82KRWT7g4"
    "9bM655yZ2frzv/aeO3dhLRURtrwyYoyoGsMjx0iyGZrV66QNAYuUxSDPNr5wK1nrVOLctRh1"
    "H7CWvrhtS4ERNWJq7K7NcWD0IFHXwAU0y6k9+M1W1k9vkDqKojCAxHv/6nF8ZVylD5K0Trn6"
    "GcWfo9R31reMllS2eVCWJWYGgJqiapgqlkAlyekfXMS5nMT1AQmllq4aePkrifeearVKpVLB"
    "1NCeCucUiZ71R4e4O9cmxoyeBDQGRHqAbrd7a3Z2ls3NTZrNJv31GoZDg0GZ0Np/h4+PL0E3"
    "AcC52KfBWwi5QS8Lk5OTJ0Xkx6GhodFDh4/Qau2mWLtJpTtD1BQv/yJlwfzSwNMP9hw9WOYb"
    "4f6j1ZErly79vi1MExMTY977n0Rk5EWYQgg0Pv2OrAjU/zgfgQpAPPy9ZXm0bYB31fgP8/Gf"
    "v5dp26+fu5gdyaVvZ77326mNZ0/sP7Adj+jjshbKAAAAAElFTkSuQmCC")
index.append('server_compressed')
catalog['server_compressed'] = server_compressed

#----------------------------------------------------------------------
server_connect = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAodJ"
    "REFUOI2lk89rXHUUxT/T92amM6l2Jplo00pchJbQUJqqEaG4USstLtz4Y+M/0a0rV4I794aK"
    "C0tJoejGEEESFLtJBgwtRYM2xkmsOHHyY+bNe+97v997XWS0ipYueuHuLuecew4HHnEKDzto"
    "Npsfe+/fEZHYe4+IICI45xCRaw8EWFlZOQrM1mq1N8rlKrkIqGIAZtTrNRYW5okfwHpRVWcb"
    "jcaJoaEh1n/ewnuPqqGmoEZQJc/z/wdQ1fnx8XEA0jRDvOfWahNV/XsvvHoJ59x/AT75pjPe"
    "ai3R6XSYnJw8YA6B01PTqCk2YDezfyuYu/lLpZcevpq31y89UakQRRHLy8tMT59D1Vj9bhnV"
    "gKoSQmDstdfvK1hctPjH5N7q4aKeLNaPcfvub0zU93HO4b0nBGXqzDPYwANTwwYeHAJY878e"
    "z/JwslqCqKDEI6e4uVFmbOIcS0uLzH/xGcF7VJX2Y+tc2f0QBZxzBwB7XXcid440c7TaCcVI"
    "KdWOM/t5ExFhZuY5rs99ig+eKz98xEb7HqZ2/4UkyUajCJLM6PUzft8RjlZjxp6e4NtbX3O2"
    "d5f68AhmcHnkPXQYzBQRGSjopaec5PQzYb+f000y1jY77HZzKk89y/xK4Pz5lwYRGqqK2eCF"
    "N+dul3Z66fvlYoHtvYQj5UM8Xo2pVUsUCsrmxjYvzpwmiiM0KMEODDQzRIQ4/mmnVxmKisF7"
    "kjSntbVHdych7WVkvZzhcs4rb5+l0RhFRDAzAI49OYr3nng36X8VUbp4Z7vLZqsjrp++G5ys"
    "0XftPIStC8//MfXlwuYHInLmrzJ57wfxhu8LL1yeq0S9wo2Q5i/v56Ujd66/5R7W0H/Ony8C"
    "qwi0F1TOAAAAAElFTkSuQmCC")
index.append('server_connect')
catalog['server_connect'] = server_connect

#----------------------------------------------------------------------
server_database = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkNJ"
    "REFUOI2lkz1P01EUhx/+lNuWUirKJLZlk2gMxkU2Jo0mxkkSTRgNu58AP4DfQKOrYScNDiYI"
    "k9JE6qREdCGENGFAXnpfzjkOpeALTp7k5uYm9/7O+T3nHvjP6Pv10Gw2X6WUZmOMuZQSMUZi"
    "jIQQiDG+npmZefSnQA5gbW2tAryoVCoP8vlBfIygigGYMTJyjqWlxkPgb4Fms3lHVV+Mjo6O"
    "lUolvn3fIqWEqqGmoIao4r0/00JOVRu1Wg2Ao6MOMSU+rTdR1ZN16/ZdQghnC8QYcc6xt7fX"
    "zSzClavXUVPsOLuZ/buCEAIigplhBqrG+scPqAqqCsBweZpqtUqj0WiLSEFEvqrqGxF5nosx"
    "0mVliAiqxtVrN7AeA4uUhwaZnp5maGhoNMsyDg4OJnd2diZbrdb9rOetW4EhKqh0vbfL3+jI"
    "AePj4+Tz+ZOynXNUq1VE5HIWQjh9LKfgRIWXn58TUiClxNbWFu12m+3tbVqtFjFGRITMe4+Z"
    "AaCm3fZpd39y4SnFvkGcc2RZRqlUYnd3l0KhwPDwMCLSheico7+/v+tbFDNFzTA1MAE4aWOP"
    "GUBKiazT6bxfWVlhf3+fcrlMoZjH6ENFkWOwvcsi0vvWpwJzc3M3NzY27i0uLjZXV9+Rd32M"
    "1y9Rq41Rr14EjCzLcM5xeHjIwMAAxWIRAO/978M0Pz9/O4TwLMZ4rTdMExMTTE1NUa/XT1iE"
    "ENjc3GR5efnLbwJnxcLCgvPeP04pzarq+ZRSznv/w3v/1nv/7CeZlqCsKYlswwAAAABJRU5E"
    "rkJggg==")
index.append('server_database')
catalog['server_database'] = server_database

#----------------------------------------------------------------------
server_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjZJ"
    "REFUOI2lk0tIlFEUx38z8zVjDsMkziINH1O0SYQwCGpTBJmTiwiSEtq1aG1tWqVBSIuQVrVI"
    "jHa2ahXiIwiGNulA9m5hSqhJYo8xZ+b77nfPaTGPpNE2HbhwuZzzf5zLH/6zAn8/ZDKZB77v"
    "XzTGOL7vY4zBGIPneRhjRnt6eno39zvly8zMTBwYjsfj5yKRWlxjQAQFUKWubhfj42MXgGqA"
    "TCbTJSLDiURiTzQaZX5hCd/3EVFEBUSxIriuW2XBARCRsebmZgDy+QLG93k9m0FEKudkZwrP"
    "87YGMMYQDofJZrNFZms50HYQUUFL7Kq6vQLP87DWoqqogogy+3IaEYuIYK2lofvMvxUUd6VY"
    "axFR2to70NIOVBTdZgfBsoIygKpixSK26H01Ns/IjzvIpr4tLVSGS4Nl9pGP99lY93Gfj3L0"
    "zTCTJxyRoC4qerdrSm45AK7roqoAiApSkiyq9NUPEPkyRmTtKccuXSWSbAvkX000vUtP3JzU"
    "DxsVC+FwmFAoVGS2sukLFZl+xP7jZ6mZe0bgYS+1nx7T2pIIWbTPASgUCi/S6fThZDJJLBaj"
    "ZudPcrkCYi0CON+/UrM7Caev/PE+0EBIA62VLAwNDXUbY240NjYeSu7dRzxejzEGVeXb4CmO"
    "pFJEPz/Bza+QA9azId7PsVQVpv7+/k7P824bY9rLYTrw6y0dO5ZpqTc4wUXWV30WVkLWK8j1"
    "KoDtKn2+6VpubflyUAItEtQlQe+lpmTwN3mMg/zQCue9AAAAAElFTkSuQmCC")
index.append('server_delete')
catalog['server_delete'] = server_delete

#----------------------------------------------------------------------
server_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo5J"
    "REFUOI2lk0tolFcUx3+ZxxfzciZmUEtgNI2tJCGlqUhEU3ChYmkKXRiIECgtNItCF3Xjwp0r"
    "6daFiwaaTcGV6CKESBaGaNrEDI4EMU3ajKXEJOShmWQ633fvd89xkWQsndJND1w4HO75/c/j"
    "XvifVvHPQCaT+TEMwz5rbSwMQ6y1WGsxxmCtvd3T03P57/dje8709HQCGEgkEpcqK6sJrAUR"
    "FECV+vokIyPDvUA5IJPJXBSRgVQq1VhTU0PuxSJhGCKiiAqI4kQIgqCshRiAiAyn02kAikUf"
    "G4bMPM0gIqVz/sInGGP+HWCtxfM88vn8jrJztLZ9iKigu+qqyoHoHLM/9Wq0tp3C2hj4i1/E"
    "AIwxOOdQVVRBRHmafYyIQ0RwzpE+u5+Pm+NUpfpINHXwOnec5yMD35cq2JmV4pxDRGlr/wjd"
    "nUGdmyJVs0ztO2fY+P05XoWhbv9hahvSiVIFewBVxYlDZdevGuV4vZJsukiwdBuvuoI/srOY"
    "YrDuB9unI3uAUrJ7O7h9NsupZEiy+VP8lz9QEX9FvLaOfYXfVqSwcq7z27tzMYAgCFBVAEQF"
    "EUXXJ3j/vU0Sxz7HX7xFJB5i8k2sPvh5y5q/ujuujGVLWzDG4Hke0Wh0p++1Xzja8IqDbZ9h"
    "lgeIeoq/eYSlsUmwhQ9arjx+sbfGCIDv+1Pj4+Nsb2+zlRvjaH2eUBtZmrmJ4FPYaGRl4hmD"
    "v6Zp+W6ylFwC9Pf3d87Pz3cPDQ1lFmfv0NrVT+WfD5m794jsyAbP7k9T1XWN9WKk7CGVfabr"
    "X7eGV7/6JkrEkR29y0IuxxOvi/WgEufc7ODgYMt/Ai51JYsnmg/FTra8i8aDiWB19cvuGzML"
    "ZdK79gZo53xaPfAJQgAAAABJRU5ErkJggg==")
index.append('server_edit')
catalog['server_edit'] = server_edit

#----------------------------------------------------------------------
server_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj1J"
    "REFUOI2lk89LVFEUxz/jjOP44/VmYKi0lBIqTAptcOPOICuSNiYYVNCfEC0jRFrVwn0gCEHQ"
    "IgkkEFcKuknnhWYRtdFNgRYJw+DMe/fec1pM/qjRVRcO3HO593O+33M58J8r9u9BEAQT1to7"
    "xpiEtRZjDMYYoijCGPNqaGjo9v77iZ1NPp/3gXHf92/V1TUQGgMiKIAqmUyamZnpYaAaEATB"
    "NREZz2azJxobG1lb/4a1FhFFVEAUJ0IYhlUWEgAiMt3W1gZAqVTGWMvqSoCI7MaV/utEUXQw"
    "wBhDMpmkUChUKjvH+c4uRAX9U11VD1cQRRHOOVQVVRBRVpaXEHGICM3+L07XWmKSPlxBpVeK"
    "cw4RpfPCJVQUtMxJfUOmuY/29FwVoGZHwQ5AVXHiEFfxnkjMkW3t5UhzN63eBquTAz0HAnYf"
    "u73Gxd0PvK2PeNk0rjBFa/d9NHSP889ztX8BwjBEVQEQlcr3icMrveNU510ov2fxxUua0iVs"
    "KRqI4d2sUpBMJonH46go4oS6aI2jfhIvs42Ea6CCKy7R3vcw5qLoycLTXm8XUC6XF+fn5ykW"
    "i3ieRyqVoKkwS7qtC9n+gEqJ3OA5JPpOKvWVYxeHO6D8APbNwtjY2A1jzGhLS0vuTHqTZj/G"
    "8bP1uOIiqhHB5Gdygx3E4j7UX2Vp/NFmzEpf1TCNjIz0X/Zn3/bcm6iN16yjdgsqE7HrOl5/"
    "jo1Py3yZGn1dBQBYeNb9U600qCgqUglV9nIFERANfgPzIWhOAAxL1wAAAABJRU5ErkJggg==")
index.append('server_error')
catalog['server_error'] = server_error

#----------------------------------------------------------------------
server_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI2lk81L1HEQxj/t2prJtiUrlZrSBoGJIBUURHWIpPDQpY0CoUvH/gRBgqIOJR26JXWN"
    "uhdFQaFFL25YQWARlpG9SOHL6v5+3/l+ZzqsK5HapYGBYZh55nkGHvjPWPF3o1AoXPfed4tI"
    "lfceEUFEcM4hIjfy+fyJP+erKsXQ0FAG6M9kMkerq1cTi4AqBmDGunVruXv3znFgMUChUDik"
    "qv3ZbLaxtraW0Y9f8N6jaqgpqBFUieN4kYQqAFW909zcDECpFCHe8+ZVAVVdyIOdh3HOLQ0g"
    "IqRSKaanp8uXQ2BbWwdqis1fN7PlGTjnCCFgZpiBqvFq+AWqAVUlhMDGriP/ZlD+lRFCQNVo"
    "a9+Ozf/A1Lg6fIq5bJH8zd01t449LVUAEhUGFQAzI2hAQ1n7RHqUa5OXibzQlG0l8WtyLn+p"
    "qWaRhIXl+cXbP3owFeKvQq331NdtpXXDLmaiWYZLT4v7r9RnHp2eKFYBxHGMmQGgpqgaXh0H"
    "204STMuMMManPtPetIeiKyUKY4+mdlygboFBKpUimUyWdQcl8o5gyqef7xH1eBUkCNPxDB2b"
    "9lKUucSz0cGfCYAoip4PDAxQLBZJp9Osqqkm8hE+eNavaWbDmhY2ZnKsTNZQn27k5efHDH4Y"
    "nJgVdi54oa+vr0tEzjQ0NOzYnNtC3+tuIudw6oi8I5fdxu5cJ0NjT7g/cu+bCxz4dp63i8zU"
    "29vb6Zy7KCLtFTN573nSeI3tLft4+O7BF1nBgfGzjMASblwuNvcwGyy5Oibkvp9jtNL/DZZM"
    "jgMmGarkAAAAAElFTkSuQmCC")
index.append('server_go')
catalog['server_go'] = server_go

#----------------------------------------------------------------------
server_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoBJ"
    "REFUOI2lk0tsTHEUxn8zc93Sml7lbgzKIISmIuq1EGwUaWIhmiDsxIZIbCxsyoKF0C3i1Vg1"
    "TSzEYtSKNILqJFTE1CMtST2HvrSde//3f45FdTxaKyf5Jycn3/873/clB/6zYn8PstnstSiK"
    "9hljnCiKMMZgjCEMQ4wxzfX19Xt+xzvjTUdHhwdc9jxvV0lJKYExIIICqFJRMYPW1sxuYCJB"
    "NpvdJiKXfd+fU1ZWRndPL1EUIaKICohiRQiCYIIFB0BEMpWVlQCMjhYwUcSzp1lEpPi21G4n"
    "DMPJCYwxuK7L4ODg2GZrWV61ElFBf25X1X8rCMMQay2qiiqIKE+fPEbEIiJYa5ldt4PF8XZ6"
    "Wmofh196Lyw59PzKHwrGslKstYgoVdWr0J8ZqCixt7dYt9bHW35kdf5B45ns6UJvzfE3t4sK"
    "xglUFSsWlbH+S3k377uus2rBXLylWxh+m2FKculMb15wI3NYD8THCYqf7a/grFiudl1iflTA"
    "q67Djrxiqp/CKYXUppWl6aq55x2AIAhQVQBEBRFFRRBVjs46gT/QiunrIZ7IE4sP45bnoTDC"
    "9w9BomjBdV0SicSYbyuoCm7wjnlyl5KZINFn4tIP8SRqQnLNXYUXLwcOOgCFQqG9ra1tbTqd"
    "JplMMnXaAE7+PrNGHzJ/81Y0vEPMDtF5awj3+/tPiViMXHf/of3N724Ub6GxsbHOGHMylUrV"
    "pBcuIvXtCqmajYT58ziOR+6eoaV9Guu/Piz3fdhw9esQTHJMDQ0NtWEYnt25LFe9Yusaov4H"
    "dGb6uNk5g4/i55qampb9jp9AMF6PztWcml5RcWC4b2T09ctPx/ZefNMyGe4HHtmCWuOXo0gA"
    "AAAASUVORK5CYII=")
index.append('server_key')
catalog['server_key'] = server_key

#----------------------------------------------------------------------
server_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnlJ"
    "REFUOI2lk81vzWkUxz/3/n51X+TqrXFxS40xmJQQIiQSCyJEg8gMsysrGfFXNJYSaSaxHKkF"
    "C6kFK8JSQoQ2qZAq8R41V18yt3pfn/M851jcNmIx6cLZnM35fs/nnJwDPxiJhQqGh4cve+97"
    "RST23iMiiAjOOUTk2v8aDA0NtQOX8vn8iVQqS1MEVDEAMzo68ty5c5t4XjD5ZO9+E7toqpGG"
    "eLE0zq2IEsmYT4Gma2MqfRYhj5qCGkGVZrPZMrDBP6NJ//l4Zumu7qitgInHxBNcnfp/Y8xE"
    "+xh5+pqghqqiqhw42INzrmVQ2jDRlXTW25b5GT8zRDK9nRCmaZRfUlt8iNnaNro3g5pic93N"
    "rEVgzzYtmqjo6XTH1hxEaL0EcZPyh7to4STafgCtTPBk5DGqAVUlhEDx8LEWQWl26faE+jOp"
    "3AbM1yEqggimEVobx2YHWFIus7srQyWzB4k7MDVsbgfJRNCL6Z92LqtPj1GbekEitR6IyRf3"
    "k22+JVt/TmbqFi7k8IkMk7m3DJT/RqFFoMEPVscf3As+iIm2mb9/Kr/2j4JvlHG1KSq2lk/F"
    "8/h4OWrKwIt/qM56TA3n3PeH9PLW+iVRNf43096drc2UsGIvjfxePo5PYqqo2VyGNV1Frl65"
    "/O0OAKJqfGNRdlX2fSnwW88gX6qB+pcKGhSzeQNrZWuNkJwXv7q+sUedX1edfvf708aRR/cf"
    "jlCpVMjlcqQzKYwEGpQwR2FmiMg3goQw7oIe3XTqzTP462Z/f//h0dHRc52dnTt+Wfcrywur"
    "ERHMDICVKwp47xd+pr6+voPOuQsismX+mbz3eO8JIYwtpF8wvgKtSZIE47fYfgAAAABJRU5E"
    "rkJggg==")
index.append('server_lightning')
catalog['server_lightning'] = server_lightning

#----------------------------------------------------------------------
server_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoBJ"
    "REFUOI2lk8FLXHcQxz/urvukb6NuWRUV1sOemmWh9NCejJe0VHIohQgmFpJLPfl/FBOi9ZJT"
    "sNfePAabEBDbEFofZC0kZD3Y1ezbykoMW5/ue7/fbyYHY0hj0ksHBoZh5jvf7xcG/md0vdsI"
    "guAna+13xpiMtRZjDMYYkiTBGPPz1NTUlbfnM6fFxsZGH3Cnr6/vsud9RGwMiKAAquTz/ayu"
    "3p0GzgIEQfC1iNwpFAqjvu+z/VcDay0iiqiAKE6EOI7PSMgAiMjdYrEIwPFxB2Mtf1YDRORN"
    "fvnVJEmSvB/AGEM2m6Xdbp9cdo7z5U8RFfT1dVX9MIMkSXDOoaqogohSffwHIg4RwTnH8KVv"
    "/pvBiVeKcw4RpVz5DH3tgYqiH/AgdcrgFEBVceIQd6K9dW6b5Zc/Im/NvVfC6fLR0TG1Z0/4"
    "p/2SwcEBnu48Yd9vc1SMcM6xvLysYRgehGH4w9bW1u0MQBzHqCrWWu7fv4fnZbl+/RpRFFF6"
    "XuLjhwM8evQrMzMzeJ5Hs9nMB0Fwo16vD7xhkM1mqVarHBy8YOrqVW7cvEXt2VOGh4epVCo0"
    "m00WFxdpNBqut7f3l7m5ucl6vT6bAeh0Or+vr69/vrm5SS6XA2D8wkU2q4+Znp4mn89zeHhI"
    "q9ViaWnpOJVKXQai/v5+LwMwOzv7xcLCwqXd3d3buVyuCPDwtweAMj8/j+/7AERRRDqd9rq7"
    "u1cAGo1G51/PVC6XPymVSqvj4+Mjo6Oj6Z6eHvb29qjVaniex9jYGENDQ1hrX+zs7KTW1tb+"
    "fvcb0xMTExXf91dGRkYGPM9Lq2pqf3//+66urkahUFgBuuM4dmEYtqIo+vYVliR7ixVwB5YA"
    "AAAASUVORK5CYII=")
index.append('server_link')
catalog['server_link'] = server_link

#----------------------------------------------------------------------
server_uncompressed = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlFJ"
    "REFUOI2lk89LVFEUxz9vfr0pZxqVAaVgQBOCRIxAJHAnSS3aJRT0H/QPCC78B8JVm0Bo296F"
    "uBZc1Iw15EJwUQtDnKGnzRtn3nv33nNajDNk6aoDd3EP936/53zuPfCf4f25qdVq7621r4wx"
    "GWstxhiMMSRJgjHmw/Ly8su/BTIA1Wq1BGyUSqXnvn+T2BgQQQFUGRkZZnt76wXwr0CtVnsi"
    "IhvlcvnO0NAQ377/wFqLiCIqIIoTIY7jK1vIiMhWpVIBoNuNMNbytV5DRAbr8dJTkiS5WsAY"
    "Qy6Xo9Vq9Zyd4/70A0QFvXBX1esrSJIE5xyqiiqIKPUvnxBxOOc4Ojoin88DsLKyIhfgtVgs"
    "jq2urjZTxhh6rBTnHCLK9MxDbt0a5fDwkE6nQxAEhGHI5OSkV6lUngFet9sdH1TQF1BVnDhU"
    "lHp9j/n5ec7Pzwcs9vf3dWpq6lePV1cHAoPLrndQRUmlPHzfp1AoYIwhDMO+kbnEII5jVBUA"
    "UUFE0Qtw1lparRZ90ABxHHvOOfqtZ5IkIZfLkU6nUVHECaoCgDEG3/cJwxCRXs5ai3Nu8Kyp"
    "KIo+7uzs0G63KRaL5G/4KN6gqrOzM1KpFJ7X+/We52Wdc9rpdBQgvbm5uTE3N1c9ODi4d3oa"
    "3C6XRxkfG2d4eIS9z3u0222CIKDZbNBsNhsTExOvG42Gy2azb6vV6s9Lw7S2traUJMkbY8xM"
    "f5istSwuLhJFEbu7uw5IAywsLGgcx3pJ4LpYX193x8fHBEHwKIqiu6pamJ2dfXdycqK/AV3t"
    "nK1lkpzvAAAAAElFTkSuQmCC")
index.append('server_uncompressed')
catalog['server_uncompressed'] = server_uncompressed

#----------------------------------------------------------------------
shading = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAK9J"
    "REFUOI3tkjHOAWEQQN+6hsI5HIErKHQkvlEp+BMa2WwcwF/M/PdwhJlep0S0/xHQrGiE7FLq"
    "3hQvMy8ZAMbmPVHfAYhFIRqnp6wxS+ZLymFUSbYoRP1Quh2Sxb6afGPPk/mGevKd35LFPKe+"
    "/KEr3kyI4pvwiYRkMa37zkn9p5HB/++g3RLznAv99bDdFIviJWssyLIzAKO/6IqFP9qW1I8l"
    "z8ViCyAaE1FfAVwBvumlx+9IHEYAAAAASUVORK5CYII=")
index.append('shading')
catalog['shading'] = shading

#----------------------------------------------------------------------
shape_align_bottom = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAASRJ"
    "REFUOI2tk0FKBDEQRV+P4kpciDvBi3gLN17FO3gLdS14CvUA7kVxoeBGcHoyqfrfRXpGBqcZ"
    "QQMhJJV69aiQrpts8ZexvenC+c2zlxtDypydHHW/BgAc7u8gGwme3mYrsclvAItkpanpldjS"
    "4Pr+wwaUYMCG0+O9LtJkgGQyRS0jgBQc7E4QYMHrhwCIEJFCaUKi1FgPsCHdVhmi5VOriGjV"
    "Mz1uEAnSNyCznc+rlxaZpkSuB2gwkFYN5jWpIXKwqHWDQQMYZSPUkkRt1UOm1hGDUGuk7GYw"
    "3CvV1KG6BDH2jJki1X33wIsmZkvOBpY0YmB4eU9yeBEPgJibh8fPH4mL0f3LZ7q6vHAphb7v"
    "mc1mTKfTH7Pv+2W8lMLt3X33LwZfdNoagjeuI6oAAAAASUVORK5CYII=")
index.append('shape_align_bottom')
catalog['shape_align_bottom'] = shape_align_bottom

#----------------------------------------------------------------------
shape_align_center = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAASBJ"
    "REFUOI2lk81NxDAUhMfJigsLBzjSA1VQQKqgBJpAAkqgAiTKoAGuIO1hbwgBK5H4vRkOdpaE"
    "/OxKPCmyI2e+N2PHIRQl/lPF3OLd7Y12AULXwcPTx1bgBCjAHTAClsfLi+PQBSz+Ek+XBdiK"
    "CXgeSWH15gMHPYAAkL9CMnUlld6H+j6gtUslywmmHmwWYA6s37nNS09zV4KO6IFQlJNPVVWa"
    "Ww9FmU7h+nE1OC4zwYyIRtTREWuijkRsiMYc91fnoRfh7OQgbaRy7g4gWgmLQjTCjHh+3Yzv"
    "ASXQAfMsjglgkYgmuBPmgpNDAJW7unI3h0WiyU7MBFKg+mkXbd6X9fdkXmsEc2Lsvw5zl+lo"
    "eajPr02Y/GAXYJ+avY371A9WAPaSrkR/nQAAAABJRU5ErkJggg==")
index.append('shape_align_center')
catalog['shape_align_center'] = shape_align_center

#----------------------------------------------------------------------
shape_align_left = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAS9J"
    "REFUOI2lkTFOA0EMRd9uIhoCBZScgEPQcQoOQMlFkICOWyBxDE5AQQdCdAiRbBJm7G+K2WwS"
    "bYSAuBl7pP/8bVdVPWCbqAFurq/iv4AhwHw+B+Du4bMDuUAB7mACa9/z0/2qB5hOp93H4ahG"
    "C7HA21cKXt59s4OmaQAIQFoKpdJVilL39QUwmUyK7damolgusFiD/Qgwh7cPdfPKS+5RoBv0"
    "64Czk/UF/SaGAOPxGIDL+5feOd0DM5E9yClI2clZpCxuL46rNQDA0cEOAIpAvgIwYS7MaiyL"
    "x+dm6WBxBYCIdnEeuAuzIJvwHOS2dhfzL/V3sOhmHpi1uYnc5m7q4NIKYDabAZCSeHqdkZKT"
    "rcyZU7GfU+CxFC6iquoBe6PdGE+aP1+gA2wT9VZq4BubLxCQddwfWAAAAABJRU5ErkJggg==")
index.append('shape_align_left')
catalog['shape_align_left'] = shape_align_left

#----------------------------------------------------------------------
shape_align_middle = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATpJ"
    "REFUOI2lkzFKXkEUhb/5FSsRCXYBW80aXIDapcsSNLgB95AFGDchWEWXkBUYS5EUgdgIFs7c"
    "e06KeX9UfA+F/8IwDHPm49xzmVJmSyxSy28Jvp3f+vk5bY4/b5Z3AwA+fljBBtvc/K3jDs5+"
    "3tuAEgzY8GVnrQDIRgLLZNM4IAUbqzMEWPDnvgszjRIkkzI1JgA2pPsuw1wXITJNSmRCe8xx"
    "QCTd5gDIQdfSHSKT+drBDODr4YE1OAg9rf29XbdqWogWIkLUJj5tb/kF4OT7aZk76MsoxY+L"
    "y1JrEimyiRamVXH16/r1GEM9SNk9g6GFGiKa/7fQpkLMFKnylMFgsj12+1LXtOpxQBh+3yU5"
    "TMR+5iCN5T5KTwCOdtcLI9VakmHkOWSihamKMFc3D8gavS+L/sbZQq+Bf8dLDSqJzEhqAAAA"
    "AElFTkSuQmCC")
index.append('shape_align_middle')
catalog['shape_align_middle'] = shape_align_middle

#----------------------------------------------------------------------
shape_align_right = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAS1J"
    "REFUOI2lkzFOAzEQRd8GRENIASUn4BB0nIIDUHIRJKDjFkgcgxNQ0IEQHUJskg32zB8K7yZs"
    "sjThNx7L/s/jb7mqRjv8R6Ntjbc31wGwu75w//gVXe0CBbiDCawdL84m1WKxYBAAcDQeoc4s"
    "8HaUgtcPB2A+nw8DApBWRqmcKkWZFz+z2WwY0LWrKC0XWPRgANPpdBhgDu+fWt5XXmqPAm39"
    "fwPOTyfVUC7r6gGuHl5jfYN7YCayBzkFKTs5i5TF3eVJVdd1v4Pjwz0AFIH8F8CEuTAbYVk8"
    "vZTwNgARbVgeuAuzIJvwHOR27i4W3yWF3it0p5kHZm1tIre1m5ZwSZsZpCSe3xpScrKVe+ZU"
    "2s8p8FgZOzVNA0C17Wc6GO9HPZ1VWwM6bf0bO/0ACSsQkFMOhc0AAAAASUVORK5CYII=")
index.append('shape_align_right')
catalog['shape_align_right'] = shape_align_right

#----------------------------------------------------------------------
shape_align_top = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATBJ"
    "REFUOI2tk0FK5VAQRU9UeiQi4kzojfQCnDtxEW7APbgLdSy4CnUBzpsWBwpOBH/+s17d6+Dl"
    "56P/p3tgF4RA6t1TJxXSdRubfKe2AC4vzl1Koe975vM5s9ls5er7fuyXUri5vesAuv9iAHB1"
    "92oDSjBgw/Gvne7s+sHjaUPKnB797FYAKdjf3kCABU+vGnMHez+QjQR/nufrDWxIt7sMdZkf"
    "w0oT6fWAmiAtAZmL5yYrSCZTRJkAaDCQPhvUKmoKpakSJerfDRrAKBshQtTapmd62qCqLVJ2"
    "Mxhe4T08WmSasmh8BWSKVLfcgReAJKrIwSJiysDw+JIkbZEezkVJarTpVSZiwuDkcLdjTZUw"
    "MUyX2ldZC5iqiGzhbLuR9Kn/T0B9N/e/31aCi/r2z/QBy7obR52UF9MAAAAASUVORK5CYII=")
index.append('shape_align_top')
catalog['shape_align_top'] = shape_align_top

#----------------------------------------------------------------------
shape_flip_horizontal = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAASVJ"
    "REFUOI3l0L1KA1EQhuE32cTk+JMoQgrBIpC7CcTKzhuwFFnYwjuQwGIn2JhGyB1YBiS1YCVp"
    "gmgp2OjuZs/MWJgExART65TD8MzMB3+z+kNz13fpCODs5nl00n9yy2aLi5qJZqEYLQAza1Vz"
    "wpWB3iBp5qKRFwNAVREv0Wlv3FwJyLB4bztwM8Crsb9bdpL7+FfgapC2667YqVUKzAARxQWw"
    "s1HqHF8+tpcC3aG53Eu8VSmQefD61feivKdCNQCZaHzY/R7oHKh+JGGjFrTKAXgxRKcveCWZ"
    "KN4LjXq5tV58C38AF7dJU0SjzbUC+XS7TC8QEdKJkGQKaoi36Oj8fh5oCcCQWKzgHl5yxEAV"
    "1Gz+wvg1RUURNdTMiVgMHCwK9T/WJ3MRo14i65E1AAAAAElFTkSuQmCC")
index.append('shape_flip_horizontal')
catalog['shape_flip_horizontal'] = shape_flip_horizontal

#----------------------------------------------------------------------
shape_flip_vertical = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAVtJ"
    "REFUOI29kL9LQlEUx7/Xpz0elg4VSlDw4EEFYfR3CG419A9E0FQILuHQ0NDyhiD6MQk1uDk4"
    "Nbk4hrRFg4lTidGiz3e959yGKNQ0i8DPds4938+59wKT5KLk2ae37UJvL/ibYL6srWbHS0vJ"
    "GcWw/iS4KnWSrx3PjUUCTsQMoFKXfecjBbmSZ/vQbsRCasY0EDKArtIg7p/7JsiXtdViP+0r"
    "zsSjhjU9JSBJQ3YB0gCx/lnQIv+eWDukBWpNgiINRR+biTUG8v9H9BaHN/WkFsIVAg6zBjGD"
    "SEMRgYihiNFVjMu91a9coFdwtL1YbBmcYOIsEXn2bAgbSybWFkysxE048yZo4Bf7btDLQe7J"
    "JqXcuXAwZYUEmBgdyXh8biG3nxBjBZ/snj8klWQ3Fg05YI1qo43r9PrwJwzjbGe5+CbDiVqj"
    "na2+tD1iHhcZzeZJxd46viuMn5wk7w8Yp+2Ujp5hAAAAAElFTkSuQmCC")
index.append('shape_flip_vertical')
catalog['shape_flip_vertical'] = shape_flip_vertical

#----------------------------------------------------------------------
shape_group = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAbZJ"
    "REFUOI2NkbFuE0EQhv+zjChOsRSuoEBpqADRQKjNFUgu3PgJkK7xQ7iiNJXfAslV3NpCokph"
    "QlJAkSIUyEikDI111t38/1DsnXHCCXmk1eyuZj59OxuNx+MVgCNJl6PR6Bn2iOFw+MnMUpKX"
    "rSiKjvr9Pkg+2acZADabTZplGfI8f9omeTGbzV7cP3gYnZyt3QGIQJ0FQA6QwNvXcQQAeZ5/"
    "nEwmb8zsNKqpJ2drP4xbgIcmV2h0D/n6t5ClcXTXpl1vqFBcN9TLHZAAU/NztoC60Ctl6Q6E"
    "zYSt0vR07Q8OWnAHvq5ugpU7SMApmACZYAYYiffZ4+iWgTnAnSc8OrwXLOSgHGLIpOP7r7Jh"
    "BtzRpldnhyRQACmQAVCUagA4cH0jUArFcogCierur0lZ+r+A3S96N105TVtlSpB5mAMFswbA"
    "bpg5bEd5O4Nqb8b/A8qCMGtvG41eDVMQcdtgMBh8KYrimOT5fD5/BQClCVc/1ygF0AQjYEaI"
    "4Ws/fxgiSRI3syv0ej1fLBbe7Xa9yaYpkiTx6XTqcRx7lKbpeVmWL83sYrlcHu8D6HQ638zs"
    "uZn9+ANfUHo27JrAOgAAAABJRU5ErkJggg==")
index.append('shape_group')
catalog['shape_group'] = shape_group

#----------------------------------------------------------------------
shape_handles = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAaVJ"
    "REFUOI2lkbGKE2EUhb+RUdBCXARB2DQ2IYEU8QlMJeQxolUeYRrbiEK2SBlIa5loJRY2ytpo"
    "6SRNJLOswtYmOOS/91hkMptgcAVv9cN/z8c558J/TgTQ6/UyoOLuaZIk9b8Jut3u+xDCo/V6"
    "nY5Go3oMEEVRpd1uM5lMai/ffJdLCDADBHLHBeaQvX1Gp9NhMBjUAGIAM/syHo8fxrfucv/o"
    "OnIQIBcu0A7k4s4x/X6fEMLHMgLA89fnOj66sRE4SEICl0qQu3AX8x+/ePHkQVQ6oLBrDki4"
    "F8Lt2/cha/OykxIg882iwN2RUwi8FG6BIRwABAc34cXSZnn79ksnAg/6E+DBMVeZUzuZVUTa"
    "OgmHACGAmZf59yGXjiQIfiiCGWZx0XohVHHKnQIlYXbQweajtOvgRfbdc6roajsRQKvVykII"
    "lZu37/G4c7LX+K51Sbw6ecq39BNmluZ5Xr8GkOd5JUkSLs7nzM6WzM5WTLMls8VPptmS6WJF"
    "uliSZivmX08ZDoeEEGqljWaz+bnRaHi1Wj3lionj+F0URQI+XLX7T/MbfsKOkD5N39gAAAAA"
    "SUVORK5CYII=")
index.append('shape_handles')
catalog['shape_handles'] = shape_handles

#----------------------------------------------------------------------
shape_move_back = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAShJ"
    "REFUOI2NkjtOw0AQhr+1HSRKRBOEUlIAEi9xDCpuwCVoaWg4CA2XcRMkFxAkEFIuQJF4/xma"
    "xNjOJmSk1exoNN889IfpdOpmRvtJWvFn5xeBhBWSGA6HqRzuDsB4PE7mAQozA2Dp+8VZliFp"
    "PaCfXBa2/314coJ1xQCSeHieeDSIUTzdHTX3aCYIIRBC8k5I4mBvBzPn7TuurlBVVefq/b+Z"
    "EaMhObO6u3JxfHLatH18+fTD/QFmjsmROZIjsyaua+8C2kE0Q9GQgWSoBfoDaD2gro06Gia4"
    "vc4W4/viLda6HHB/8+rLuAuYixiLZvRtBNYBzOZG9fWDRbCrXeB/gYWQ5ckuH5N3H41GDaCv"
    "kTzPKcuSLFnd67xJYJ0V2ratwDYCthHYLwUaQQvlMyUqAAAAAElFTkSuQmCC")
index.append('shape_move_back')
catalog['shape_move_back'] = shape_move_back

#----------------------------------------------------------------------
shape_move_backwards = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPlJ"
    "REFUOI3FkjFOw1AQRJ8jC2pEF6i4gJUjcRJoOQniNlFKJApA5gY08c4sxY+tn9gRZUay9C1r"
    "3u78MVxaDUDf92mb8ZGEpNl5s9k0p4AWwDbr9frslMxku90ufmsBJDGClsyr1YqI+B9waqwl"
    "iee3r5QSCyLEy+NDMwOcGsd329zdXGEnUvLxE/MNavPSBhEuACfDoGPAmPWcShvFbCUReQzY"
    "7XaLFdbVRhi5xNnXgK7rpn6fXj/z/vZ6yjqu7PpsUB2hVgRHWa2cptpgF1Ac7n0G2A9Cahen"
    "WgdIJqGSYQYYwrx//xIGyUgc7qD0r0zSJmlmv/Vl9AdwNibDLwHECwAAAABJRU5ErkJggg==")
index.append('shape_move_backwards')
catalog['shape_move_backwards'] = shape_move_backwards

#----------------------------------------------------------------------
shape_move_forwards = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAARVJ"
    "REFUOI3FkztOA0EQRN+OLXJSUosIOBW3gdNwDV/AGMkREjcg8G5XFcF6vWDsiICWShqN1K/6"
    "M9N1bcFfov0pG1gCPL+8Z7pQQgQKWEYOUrCgSjw93na/AAA311ckwYE42CAbG3yA7D7qfAVK"
    "sMdkO98EkkeAwzDoAkDMCSeuU7IVqnIBUKZ03tUKMtimr7B93cQ2trm7f+iWAFWe3U5cj2eD"
    "BrFa3ZKEzWYzV1A1Qs65Tu3YoQSSaK1hewb0g5CWZ12tAyRBnocoaQYMZd7eP6lD/+NQfdy/"
    "EmITIBkHOVVA1xa/tNvtIil93x+13++Pqqqs1+t0bTE/pO8hiSS0dvml/2jhNGyz3W6Z1nVJ"
    "AN2//8Yv4wFtllmhytIAAAAASUVORK5CYII=")
index.append('shape_move_forwards')
catalog['shape_move_forwards'] = shape_move_forwards

#----------------------------------------------------------------------
shape_move_front = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAVVJ"
    "REFUOI19kz1u20AQhT9S9AHiSjAgqJGLxEDsK/kublLmGjmBb6FGtlk4CpDAgADXLmzue5Ni"
    "SYJ/yQCL2eVw3sybfVucTqewzXBJmvmv1zcFC1ZJYr1eL8WICAAOh8NiHKCyDUDnp8llWSLp"
    "3wDTYJc43E/Bh1Ycj8fYbrfY5vv9ax9QBBKEjA2SSYaUxLfby34efQdFkb9dfDojAmywAzmy"
    "V/bPL2lOoa7rPO04R4Zw5Ko2ElhGLch7M6Zcff5y1bdz9+N3dJWs6JNkY4EcNE2MAYaHZKNk"
    "1HLWAKjzzbSD4aFpTJPaamGcguSOQr6NlIKnx4foBDYG+BApVaOKPaV2JQW73Q7IAhsBvH+Y"
    "+s8bTi0d5WvLHQVhCLLcO4EVRbmaqwP4dfwZm82mF9FUYKvViv1+T7mYzVh9S+oE5jMY2lBg"
    "nciW/vkvQC+w9llP97b5C+9Wcbm7S7QeAAAAAElFTkSuQmCC")
index.append('shape_move_front')
catalog['shape_move_front'] = shape_move_front

#----------------------------------------------------------------------
shape_rotate_anticlockwise = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI21kktoE3EQxr/dbJJdU/MybVKqSNqAxZMg9GJ7ErUQyEXqoeDFFhFsaYoEcxILChYR"
    "QitC1ZugEPWwUMVaiooPCurFoESRmofakkhBSDb7+D882IelTfTiwMAww/w+5gH8b+tL99ni"
    "z08m69XFvwHaQu4pYhj99epCo+bhJwOpVqV1hFgEn0sLZaIbb2s6mWG6dV89/bgIALZ6zUNz"
    "Jy6E5FCi3dMBr+xFyB1yNTndETDeu1heat/ZHcznn37/uiXg7K1cVLPPdig25YBH9mC5tgwI"
    "IqhA4HPvgCRKnfliMeDrCrzcBBhNFxRuUHXy2ECs7XBzoKJpXbIkI79UgENygIHDqcjQqlpn"
    "ebFUkDbJV0mCUBYBgNv96nB08mBTJpvZb+rWnKGbR3u6e3ZJTgkenxemYR7ZADhzPRc2iZVk"
    "jK/ltgX9gz8/5JIvzr++uC++Fw8fPIpbJgExCSihvRu3fuOTOn4vx09dy3IAuPvGVNPztXCD"
    "Q63/wdDUx6jfJcXsAkAoAwAIQAw28f2def1c+hVX6gJGrxQUwnjKKQJVna4BGAf2tIhKi1sc"
    "q1Lj3c1nenRLgCZrieB2e8SyGHSTga4AKONgHPA4Bez2CxG3gumrs5o6MbM+ljQ4kQ0TRpMC"
    "l1AzGQjlfwAAk3AQCthEAc0uASIQ+/LDOjQ+Xbkkaa7LEuc0RRlXFkraiiLH6hUI5ch8YyDs"
    "d7zqjAkKZXzMdFSON1rwP9kv7lAQ7RHLIS4AAAAASUVORK5CYII=")
index.append('shape_rotate_anticlockwise')
catalog['shape_rotate_anticlockwise'] = shape_rotate_anticlockwise

#----------------------------------------------------------------------
shape_rotate_clockwise = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjVJ"
    "REFUOI21kU1oU0EUhU/ykjbPpClNtQ2BFoNBXbhzo2sXFQrtogRRFARFyEJsKbHZKFjoSoRI"
    "C1LRTQXBQNGKkFaxEtSCi9IfiGjaRWoV7SIi1vfezLy5My7SIJWGuvGshrn3fPfMXOB/6cLT"
    "05lkLmns1uetV+AWPwPbGd8N4KkdUtPnO1zX7RPc7ZKcH20Px/YJIbBSXr39fLDQXw9gAMCl"
    "/LnjritGYsHYlc6WzkS87UAwEoqgKRTGpvXrWOBIo//L66+zOz4hNX2qw2V86GDkUO/+1jh8"
    "fj+kktiwNsBdDsYYhMUarj1c794RYFu6L7on1tsa3AsmOTjjKK2tQDgS80sLKH1YGVvMvr+q"
    "PZ7sQO6T+TfA59isK9QaApMMP+1NzBRm1jkXk4KLE4K788XR0mUA0FonAi7SAIa3JeA2P/lm"
    "6S0ev3yC/Ks8HIdPvhtZGGCOeFT8VrpYa1RKgSRlBifK8V0W80d3C0587IU9BQDpibIeffZZ"
    "999fndqWYCdjbk6bd2bt60KoolS6BwCIFEwDaAn6elLjH7vrAu4VWPd35iy3h703Dkf9piQN"
    "AJCkYDFCwABIqGzyVvVDfTXjRMGJc+hs2ERPU6MBvwG4UoNUtS6lgiMUSCm0NfsTvPIjDWDY"
    "l5vTpqV4mkuViTYbZqjBA0EawgVIA6SqCYgITHhRS0RSZ87eXHzgs4gvk9IJ0h6sVQiSNCRV"
    "J5PS2PJDkkK5wqBIbd1rk0hn/3kj9fQb5EszJ0f4WWUAAAAASUVORK5CYII=")
index.append('shape_rotate_clockwise')
catalog['shape_rotate_clockwise'] = shape_rotate_clockwise

#----------------------------------------------------------------------
shape_square = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPRJ"
    "REFUOI3FkzFSwzAURJ9Dhp6WkntxHCpOw3FoaFJxgTTR7lL4y5Yn6lLg6s/4787blbQspyce"
    "+U4PqYFzHz6/LumzEwJIQCA2DsjrLMPH+9tyMAB4fXkmhBgCxMGBDCY2/Pxe7wmUkJTAkISk"
    "aMrIDnbQbRJBWhFJsEvYZx9NbvK9QeR1MWCbmBJ4E3bD1iYGzWAF19K63GfvJAG33Bu4GTlb"
    "zgyZU5E6SZsZtAaSt/xHk50ogeZZBAnpXK2XMHWUQ4FJkKYE648N1+DKPh5nqqsJQaqDY+Mj"
    "er8ng34kMN+X65bZNlEwYO3XOzaDnuXfX+Mf1G1fvcW0Vf0AAAAASUVORK5CYII=")
index.append('shape_square')
catalog['shape_square'] = shape_square

#----------------------------------------------------------------------
shape_square_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAa1J"
    "REFUOI3Fk79LlWEYhq/PrM5QWA3hiSIohBrUgjiEtMWhrX+gqVURgoaE3HJwqNWhpX9BaAgk"
    "aBGRlihyCKGgg3ICMfPAITjvc98N349zRIm23ukenvv6rud9+eB/n6wMz19vu8yyMRABGCwh"
    "QyjPIVh4cDkDGB6kXTh7AmMsMGAZGTwAkeDrj27VqQBhYxcFgW3swqYASUYy0eMIQOSK2EhF"
    "scw6COmFDgMcygcNkrAoCqqKJTClIwBJoDAqhvLhMqtvYlDyYYCSCLna0wM7u1ipNEkDgKHK"
    "IEGEiDAhkyIHhkyS+bn/lu/teTZbs3S6j7j3ZHz+4AoRRAwXt1583flT7uy9oTayTvNWg4vn"
    "xni3scz6561njZn6mQEDE2GUyC0iN0phtnaWuXFtkhgKJutNIutxe3wK8EwfEH3dPIuI3GS3"
    "0+Z4dor712cBeHz3JVfPT5CR1forJPGl1a1uXhIOI2B3f4+N7TU+bq8y13zF4spDasdOYvy7"
    "+hf+dhrT9YVLV0aeTk3cYWz0JpvtD6x9WqX17deLfwLkkNFFsmw6g9OGDvbS+6X23B8J7G9T"
    "5jzkHgAAAABJRU5ErkJggg==")
index.append('shape_square_add')
catalog['shape_square_add'] = shape_square_add

#----------------------------------------------------------------------
shape_square_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAaNJ"
    "REFUOI3Fk79rk2EUhZ98CbUkXYQqRihpQbDiXyE4qJsuIuKq4KZTQZAORRzcHZyK7oKiQ+0g"
    "dBcRsToYBGuoikMtpmrfe47D9yMJDeLmO53hnodz7uWF//1qpbjzuOdSy8ZABGCwhAyhXIdg"
    "6WKnBtAYph3eP4ExFhiwjAwegkjQ/dyvPBUgbOzCILCNXaQpQJKRTOwyBhB5RGykwlhqjUJ2"
    "Q3sBDuWDBklYFAZVxhKY0hhAEiiMiqF8uNQaJDEoeS9ASYRc9fRQZxeVyiRpHCAliFDVfxQC"
    "7fX7TL9eJvvS5UjrIOdOZgunVnV7AIggolFsvTA6P2V7/QHHtp4yf+ky++aOs/NqhTdrK0vP"
    "/PZHNkhgIowSRDi/SogUZurFPY6eOMvk++fUli/Q7D5ktjNdD3xtKIGLHYxu3DbNrQ0mD83B"
    "meuD7ott6q7NDu1AvPvYrzpLwmEEzDcP0H/5hNajq/za2aQPbH+vE3V61V/421s7316cmGrd"
    "mJmORiPbYPtr4sNmPX7/1M1/AuSQmYX+t96VTLWOMn8Svnt6Vbf+AP4kb/4CH0GtAAAAAElF"
    "TkSuQmCC")
index.append('shape_square_delete')
catalog['shape_square_delete'] = shape_square_delete

#----------------------------------------------------------------------
shape_square_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAiFJ"
    "REFUOI3Fk81LlFEUxn/zqiONH1M4iik4mkGgRLiSSojCSiL8BwxaFATthGrRJqI2RrsWtdBd"
    "CzdCFBRmQmRFEcVE2ThGU4ONX6DoMDpf7z2nxfvO6yjuO6uHy31+5zncc+F/l68o7j+b16IW"
    "VRQwBlBQEUTBiKONwN2BsA+gvJTWtM+PoqiAAiqKKGgJRATiS5uexwMYVVRdg4CqouqmcUEi"
    "iohiCuwCME5EVBFxjUUtDqTevKMzNUZv6DADI2eUbPKiB1AjzkUFEUEFt6sTvUlf0l0VZU/4"
    "AsG2LtZ+HyI6PnzPA9gCYhRxuzrdHb2fSXpa/1ATPM7qryh+X56a2kaq61qCHkBswYh6c6o7"
    "cz0fOdE2y94DZ8ktjOIP+EhEZshncivZXPrYVgIbjBFvfhElJB843f6ZYHs/2eQjLL9NRXUY"
    "s5FAMpne7sGJWcsDGIMxihFBjFK1OsHJ5k8ED/aTTT7EqiiQT7Uy/zrC49QVugYnIttewbYV"
    "Y5wdqFqfpLsxSkPnefKLw5T5lex6mMWpL7wI3Ca5FvCesSSBYkSx/j7laEMMo00sfHuAkGVj"
    "tZm5Nz94HrhFygphvJ3dlkCIzW1yKjNGR88IsdFrzE69p7LlCKnlJcbLr7O8Vo1KmhL/1l8o"
    "1p3LHYUbl66WYxkir56QiP9M14aCPX1D01933gUo23lQFyjcTMSnsdMrkqs0by2k79zQ95nd"
    "zAD/ADtfV0Dj5MLmAAAAAElFTkSuQmCC")
index.append('shape_square_edit')
catalog['shape_square_edit'] = shape_square_edit

#----------------------------------------------------------------------
shape_square_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAdNJ"
    "REFUOI3Fk81qU1EURld6q6TSSFos2FiTWMVixJ8iVXCir6AO8wiO9AVEcCI4ERw5LOhE6aCK"
    "gqCIdKISkYBCMtBCpVpQhKJJmnv2tx3cm7TWzN1w4DuDb7EOnA3/ezK9cOvRqvey3HHADHBw"
    "CTmYkmyCG9VSBmB4K60wthPHcYEDLkcOvgUiwae1Vr/TB5g77mlB4O64pzYpSHIkx2IGACxR"
    "xB0pLfay/obEpj5gqBfclNAFJiHzBGpiIlPn9I47RL6OyQlhACCItKTUJskZ63CQJ5TKs5T9"
    "BTJHwf8FKCgt9SBJ3u8vKRTn2D05y2RYYtSWCYMAIbBZlBNMjOgrU+E5uT15bH2RqeNVpsNj"
    "pHgAwCwtJ+93E8XuUwqVC9B5x5v5e4zm24y3a5Si+iCDRFkBzJx8/JFD4x1yYy208Rlc2K+3"
    "HDh/lblogaWbZ3PbDFJ1ObKYcusB+eJJ1KrjanPq0gzqrpLNNjly4hzQubLNQDRWWjRWfhN9"
    "e0Z5+ii7ct/x8AMyEbWFJiDUaTJxuIR1u5dfXatU+ruwdV7fPvPlWPX+vmhoGQ8/ST725quj"
    "kRnWPrynsXj94fAgQLzRzdbuXmy7HJeSk37p5J4uhXzvH8w7aW67Jx+vAAAAAElFTkSuQmCC")
index.append('shape_square_error')
catalog['shape_square_error'] = shape_square_error

#----------------------------------------------------------------------
shape_square_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAcdJ"
    "REFUOI3Fk8FqU0EUhr/UIlhKwVCxaK1YEWyLIIgoiAiKFfQFRBc+gD6COyu6cNnHcOdasBIF"
    "RQtuhDZoMcVoiVnEJO3t3Dn/cZF7byIGuvRs5mc4/8c/Z2bgf1cpF89e1D3XcscBM8DBJeRg"
    "6mkTLN09XgIYHaQdObgfx3GBAy5HDj4AkeDr1nbhKQDmjntmELg77lmaDCQ5kmMpQwDWi4g7"
    "UmbMtf6GpKZ/AW7qNTpIwkVmUGHMgTEOAUSBzFHW1GvOtVhr3SFJ25yeeI5iMW9GislHYXLM"
    "HDNla6YjJDEwPTnH+8Yt0pgMSRDBTMX5q63bSClBkRAjR8unmJu6QDvp8mnnBleWD42vPGh0"
    "+gAzzEazqUNU4PrCPcyFyRBOvbXJmelLdMIOH2srrXNPKQ8k6EX2LEESA+biW7NKqkhUSmop"
    "v3fbnD12mU66PfJuo9IcSOCY+teWxIRokcMTM0QZ5uJHq0Z5fIrVzTdUvlQawVgsnvL95XU3"
    "9SffPHCTJASCAkkMnJyc5+LsIh9qb3ldXaWT/lr4+YTPBWCvmn9U6p6fuTr2av3l97TEtfoS"
    "azDwmfaqEw/pmu8b28Vmtx6zke//ASWofK2eQSy5AAAAAElFTkSuQmCC")
index.append('shape_square_go')
catalog['shape_square_go'] = shape_square_go

#----------------------------------------------------------------------
shape_square_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAedJ"
    "REFUOI3Fkb1rU2EUh598UKVoWkGrlFiVFgtKoaCgXSwImoK4uGpxsDg5+xdIJxenLg4Wl1qI"
    "i2BQ/AA3v6ZSNEVrbUulNpjGJtck955zOtw3yS0GV9/px+X8nvd5z4X/fWKNcPfJmjWymmGA"
    "CGBgqqiBaJhF4c7VIzGAZJTWu68DwzAFA0wNNbAIRBUW171mpwkQM8xcQcHMMHM2DqRqqBri"
    "0wYgoSJmqLpiI+tOiC/6N8BEw0EDVcUUV1BnpQyUHnBo1zKJYLgJiDdCoKBiiKizaWUVJV18"
    "zKmBDU5kbpA59o6Pk/1jOww0UMS9sWUS5nQ5x9m+D3QNXqDyPUequw89PJTN3bKJJiAIQESb"
    "749Cepine+gS4s2ze3+aqqzSOzrcGZR/TbUAIogk3dbd7Rb+ylLQg19cIp4oEItX6EgVoOpR"
    "/lFLRAwMEVd220/5eU4nZuk8IGjgE9dNiO/F/DqfZ/LVTwulmxEDczsIb0/XXnM8eMbg+VGs"
    "/pyYbDH3tIpVPExh8dvmtfGZ5WzEQMmveG5xcO7gG05ezFAvTJFMdjH30ufR6hUKe0Yw4OH0"
    "mSz/OivZsbe19Umr5C/b+3sjW/ev94+3m0u2+wiwtrTx4nfp1dFK0fvzZeHn7Ynpr7Pt5rYB"
    "L+Fue5kKDXMAAAAASUVORK5CYII=")
index.append('shape_square_key')
catalog['shape_square_key'] = shape_square_key

#----------------------------------------------------------------------
shape_square_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAhNJ"
    "REFUOI3Fkr9rU2EUhp+bpr1KqCba2jZDgtGCpcTRSQiOTlUQbaiii5OT+A84uFRcRUpxddJ0"
    "6OoSUTqU+ANEsK1KSm9uQ9IWaW9pkvud45B7k5R295ue4bwP7wsf/O9nhfBisaIhiyoKGAMo"
    "qAiiYKTNRuDZTNoCiPbakokBFEUFFFBRREF7JCLwu7rfyXQERhXVICCgqqgGbQKRiCKimBbH"
    "CEy7IqqIBMGQ5bCkZeSoQI20DxVEBBWCgHSCodD3jxH4AmIUCY7axyFLt4mC+HpUIL5gRDs7"
    "tWezBpPCJn6PoC+Eq1OPnw6ejNBsNNj6s0zL+UDCqlBZXULtsygWuz/fkjxRxdr5wsSl8f14"
    "PP6tO8EYWk1YXV7k4jnlzoN7eJ7HhY0Nip8+csAA+ds3GOiP4roupZL9vFwuD3c+0pP5X2rt"
    "fMXaKpG/m2fu9TuctRJjY6Nks1lc16Ver+O6mwyOXebR/esUCoW/PQ2U7fIPxkdjAJy/MsPq"
    "9yWmp6dJJBLs7e1Rq9V4+WqOU6lbgEc8Hre7Al/YNadx3DUAPr+fBzHMzs4Si7WlnuehIjTX"
    "3sC1KRzHOehMAJicnJzIZDKFXC43mkqlJBqNnqlWq6ysrGDbNul0mpGREXzf315fX48Ui8XN"
    "QwKgL5fLZWOx2EIymRy2bbtPVSP1ev2hZVnO0NDQAtDfaDRMpVKpeZ538x/K/GiUBySJYQAA"
    "AABJRU5ErkJggg==")
index.append('shape_square_link')
catalog['shape_square_link'] = shape_square_link

#----------------------------------------------------------------------
shape_ungroup = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjpJ"
    "REFUOI2lkjFI1HEUxz//6zTtVNRCUrgEh0BHr6kh5GiTpsAEx6ghCCQS5JYmwSUcjBvEFgcj"
    "knBoa2jJvEhvkPTMKPM0tbDLobu/5+/3e6/hvKs7XaIHP3g/3vt93vu974P/NA9gdHQ0DYRF"
    "JBWLxboqk4aHh18ZY3pEJDU2NlYWDwB4nhfu7e1FRDqfv8vqTCKrzxJZfTqX1SdzWfV9v6ev"
    "r49cLtdZCQ8COOeSs7Oz3bUNLTSfCSCACoiCKjScu8DExATGmLkTvwAw8zarZ+sCqBYeFo8q"
    "iMD2vnArGvIqAcGiU0x88yJO5vsWwZp6Ll+7S1VNXSHmBIBoNLpgjIkYYxYTicSlQBEgrlBx"
    "bzdNf38/P75tsby5x9JGhqX1PXZ/7vNgekMPDg4isVgM3/cjZR1YBadQVdtIPB7nVHWIlvog"
    "p2urcKKIU5wooaY2hoaGODw8TJZmMDg4uGCMiYQaz3Pl+n3eb2Roa6pGRBERnIBzgnOKc8ra"
    "1xyP7lz0SjL6vh8ZGBhgJ73GdsYWkkVxTrAWrBWsVewRwBgt3wPf95Pj4+P4vp+8fbXeM05x"
    "VrBOsU6wTgp3qyVYmQpTU1ORv6UpVPvTcmkGR7617vgeFK27uzttjAnXN7dx495jxBVaF1Gc"
    "CNMPb/J5JYFzLpXP57sClYB8Ph8eGRlhJ/2RD5s5VtNZVtM5Vr78IrWe49PyPJOTk1hrj601"
    "AB0dHYvt7e3S2to6f1I8GAy+9DxPgdcnAv7VfgNKTWV7QDoMfwAAAABJRU5ErkJggg==")
index.append('shape_ungroup')
catalog['shape_ungroup'] = shape_ungroup

#----------------------------------------------------------------------
shield = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAlZJ"
    "REFUOI21krtrk2EUh5/3+76kV+ONopaCohKhVh29IFgcFIWiICIUEf8BEbGIIA4OLuLgXhBF"
    "HBx08IK26CBiEG9QbbBGDbWU1sa0sYmx3yXvOQ4h1Wpx8wdn+52Hh8OB/5mJ/m3pib6t+q+O"
    "BzD1pFNVFEU2i+hqU9HdCkfrW7tQVcbvWlWrd8TKfVWbEqsplMaVhwaMAZh8vEPrWruoFNI4"
    "dS14izZRv3wnuM2AoFEBfyKFn3tNOPWehrZOvr25wqrut8YDEDdK+GP9xcVbLoMKaktE08/w"
    "ElsxxiPM3SDW2EF83WFQS/75BWxFdwE4AC3bUyWJyqBClL9JlL+H+J9BBVAk+EIwdp0fH86C"
    "CsFUFs81L2dvAKCiVV0bgkRgBJlJYdwItX51KgGoxYkl8MuFFUDhF8AKqIKEqI0wjgVmwEQY"
    "DUB9kKBqZC1SceRvA60aqEagLuADAUqA2gi1AaoCYlAqsdkb1AxEApyGNSAhqAUnBKdqoRqC"
    "AirYoITrO4U5ABG5VHx3FW/hFkxsCcYzGC/CeCFOXMFENK2/yPSHfvzi18Hk8Y+jcwBt+1+d"
    "KA/3UczcIL7sAE5DE048wnhl3GaPpuR5/Fya6cxDbBAerO3NAgDc0G35nn3A92wfsaXdGG8t"
    "xikTW3oaP5+hMPQAPzdycGPP+FBtx/z528PX2tuJLUwnkntItO/FraunmHnE5MBdSiPpfZt6"
    "xm7/3v8LAPCpt2OZVf+YE2s+syDZSf7FrayE0ZENp8af/tmdF1DLYG/bEi2ZcyXVU9tOjs7M"
    "1/kJtIFGFRTTFAoAAAAASUVORK5CYII=")
index.append('shield')
catalog['shield'] = shield

#----------------------------------------------------------------------
shield_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAolJ"
    "REFUOI21k0uIjXEYh5//933nzMWYBg2GkQmFXMaCzAwhctmMlIVyKRY2pEjJRrKTFRuJkgWL"
    "WcgCMWNDOAlDM4xCxiUOcxxnzv183/nO/30tTghl51fv7tfT01s/+J8Z6esaGunt1H91PIDU"
    "3VWqoiiyVERnmIquV9hZO6UbVeXzNatq9apYuaFqY2I1hlI/fcuAMQDf7qzUmindVEaHcGqa"
    "8ZraqZ28GtwGQNBwFH8khp94Qjn1krrWVaQHL9C29ZnxAMQNG/14X3Zcx3lQQW2OMPMAr7ET"
    "YzzKiR4i9fOJzt4Oakk+PIGt6DoAB6B5eSwnYQFUCJOXCZPXEf89qACKBF8I4pcovj4CKgSp"
    "YTzXPP75AwAVreraMkgIRpBSDOOGqPWrVwlALU6kEb8w2gKM/gJYAVWQMmpDjGOBEpgQowGo"
    "DxJUjaxFKo78baBVA9UQ1AV8IEAJUBuiNkBVQAxKJfI7wAoiAU7dTGx+EEwUnDI4VYvb8Rru"
    "fR5H5tEJyiWhWKzfARxyfwAObGlpkiDXUd/ajfhvMW6I21CH8XxuPI0zEIync3EXa5ZsoBRN"
    "8Sn/YdmYWe5Y5wegdVP/gcK7XrKveohO2oxTNwYnGmK8AlefZ1k0px3rWNpb1mJNSMeCLkD3"
    "/gQAuGW3OT98k/xwL5EJWzHeLIxTIJFJEjENbJy7D4CDa84yc+JCDKb2N8DUbf1JKWXmpYd6"
    "SA9exJangdlNLp9iKB7j+K1dABzv28WbxCCK+i5/5OSVr1/3rW86U4j3B5kXN1dUiilG3j9L"
    "P80matsmtZEsfiRTSHB/4C7ZdHDK/Gtpz8+1jtecOZZTPbT/TeUoxuwxMFYhh+rph6e/HP4O"
    "7Ydl+eYElaQAAAAASUVORK5CYII=")
index.append('shield_add')
catalog['shield_add'] = shield_add

#----------------------------------------------------------------------
shield_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAoFJ"
    "REFUOI21kktIFWEYhp9/Zk5eOo1aWBqGlaRkQS2KMoKkRTcQaqNgEe1qE1GLIKLbpkXroEUQ"
    "QbQIaVViRQsjOYSU0EUiQkvxrnmy42XmzPzf1+JQKkW7Xnh3Hw8PHy/8z4w+29U9+rRO/3Xj"
    "AUy+rFcVRZEdIrrexLpf4UT+6gZUleHHVtXqI7HSpmpTYjWFUljZ9NYYgG8v9mje6gbidDdO"
    "Xile8Rbyy/aCmwQEjdIEoymCsS6yk58oqKjn+7u7rG1+bzwAcSM/GHr2o2TnHVBBbYZo6hWe"
    "X4cxHtmxByQKN7Ok5hioZaLzBjbWfQAOQOnuVEaiGVAhmnhINNGKBH2gAigSjhAO3Wf28yVQ"
    "IZzsxXPN698/AFDRnK7NgkRgBJlLYdwItUGucQhqcRI+wUy6HEjPA6yAKkgWtRHGscAcmAij"
    "IWgAEuaMrEViR/400JyBagTqAgEQooSojVAboiogBiVOLAZYQSTEKajCTr8DswScLDg5i7HO"
    "McZfDTA7Uo9JeqjEzcAF9xfgbFN5sYSZnYUVDUjwBeNGuMkCjBcw3NbFTI/LpoZTbGg+Q9nK"
    "5WSmpuoa/cm0Wbiq/patmqw6gl/TiJ1+SKIkD5w0Hcdvsu3oFQp62mGwA4qKmfAqefP05Rdv"
    "IcDNuqXTvU/GnUQR/sZmjPMWaCc7Okd+2To4dG5+wlfLcdWsXWQA8PVebS2Jom6/+iB+7SHc"
    "vHzaG/ew/cBhlva3Es6NMAtkfrh87GHwDwBAz+3Nq6wGp51E8uKy6nr6WlrSOl3or1kRu54z"
    "QGY85uuIa7OBXP4r4Fc+3K5YrhlzLaN63naaM7Pfhk46YirF0UFBbx18Ltd/AvShVNG7c3/2"
    "AAAAAElFTkSuQmCC")
index.append('shield_delete')
catalog['shield_delete'] = shield_delete

#----------------------------------------------------------------------
shield_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAohJ"
    "REFUOI21kl1ojnEYxn/P+7Ev887X2uhlmtCGyAE2ZClzpBwhKXbkSI0DJUkrR3KglJOVSA7Q"
    "nCAsivAmRhnDGot3a4zZu+3dx/M8////vh2svfKRM1ddZ1e/ruvuhv+p/tbajv47NfqvTAxg"
    "8GGdqiiKrBXRSs/qVoV9BfO2oap8vuFUnV4XJ7dUXUqcplCKKna+9DyA7w82af68bdhMB5H8"
    "UmIzVlJQvhmixYCgJoPfn8L/+oJwsJPCZB1D7edZuPuVFwOQqEn4fa0jM9edAxXUZTHDT4gl"
    "avC8GOHXy8SLlpO3dA+oY+DpSZzVeoAIQOmGVFbMGKhgBlowAzcR/xOoAIoEXwj6LjHedQxU"
    "CAa7iUW9ttwNAFR0sq4LQQx4gkyk8KIGdf6kbQDqiMQT+GOZuUDmJ8AJqIKEqDN4EQdMgGfw"
    "NOBEZx+ZIODsEkWcQ2xEchNyDXSygeqkwQfGUQJ8a0jOqWLPlQYQD8XGf53gBJGASOEi3Gg7"
    "R54+A71HKJbQWubOXExV+Vqy/hj7e59wKq946BeAiJweeXuhsaSqAQl6sRKyZdlenApOHILS"
    "N9zDiuR6RsMJGtIPulHycoDk9ucH01ddoxctIrF0B75twanw6XsXRixWDMYZRoIsq+ZvZNSM"
    "x4aOP/JzAIBoGC0d7b79LRIvwbc+1lnKEguw4nAqfB5OM6u4nBc9j3n8/tE7M8Zq7/ff/nix"
    "upp4ScehTD++CQklxLchlbOrWVdZT1s6xd3O1va8Yda8P0PwBwDgQ/PyMqf+gUi8+Oj0JXUM"
    "PLvWvWukZ/bqis0l9zvvPZ8Wp/ZNEyHAXwFTet2cnKVZrymrenh3pjctGp2Tjrk4TdipzA/2"
    "w3yW8vkCOgAAAABJRU5ErkJggg==")
index.append('shield_go')
catalog['shield_go'] = shield_go

#----------------------------------------------------------------------
sitemap = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAPhJ"
    "REFUOI2dkrFqhDAch78UUecONzj5FPYxuhfcxLVwD3LQVZz7GM69p/DG4+QgIMQgkXQ5RIm1"
    "aX+QIV/Cx5/kJ9hOChwW+xtw+eGuEwFkxhhrjLFaawtkD6mTpz2TlJIgCDDGnB8TiT8J4jim"
    "7/vdcYO9wyiKCMPw/wIhBEI4U3slBbKiKO5lWd7ZecRZ3zTNqW3bNykl4zgyTRNJkrx3Xccw"
    "DB9KKQCUUmitP+u6Pq5EVVVdWb+yWKwVy/P8ugQpbmnwZBdwS/MCvHqwDEjnHixK8wU8W2t/"
    "Y2fgMAu2SuPD5h5slcaHzYKt0viwrV8ACIHRg92+AXh4kls+SBmJAAAAAElFTkSuQmCC")
index.append('sitemap')
catalog['sitemap'] = sitemap

#----------------------------------------------------------------------
sitemap_color = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATxJ"
    "REFUOI2dkjFLw0AYhp+TXNLZwaFTfkX8Ge5CB6F0Ffwhgmvp3H+gQoeInSwIbl06pA7a0lqJ"
    "BC8huRiXGnqkhugH33DPHQ8f732C/eUCRzvnFTD/5W2lBOBprQutdZEkSQF4W2mlDupMYRhi"
    "WRZa68l2IvEnQavVIoqi2nGtukvHcbBt+/8CIQRCVKZuVC7gdbvdTa/X21ATYqn3ff8yCILT"
    "MAxJ05Q8z2m32+fr9Zo4jq+UUgAopUiSZDgYDC4MUb/fX2KmLHbaYJ1OZ7kLXKpLQ0M2h+rS"
    "HAMnDZgHuOUejGcfLD4FWusH4LAoCtTTNdb73GA3m1teWZTLVQqklDy/KSNhS0rixcxgUkqm"
    "0bQ8l4LJyxejoDAF0xHO49BgfnbHfT42WJnBTwNnWZY1Yd6+XwCwgbQBW30DgrjTYaOKs0sA"
    "AAAASUVORK5CYII=")
index.append('sitemap_color')
catalog['sitemap_color'] = sitemap_color

#----------------------------------------------------------------------
sound = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAf5J"
    "REFUOI3NUj1oU1EYPfflpbG2xpqHkdLSZBBdRAjUpVlcurg4SAZ1EX3SgtSgTqWLaFAKWYpU"
    "QYroIhinOnTQTXALWCgIEQ3vNbEo6JT37rv3vvu+66AoaSuuPeP3nfP9nQ/Ys1hcvHe+Vrv7"
    "5X88e3ug0WikPK99W2t9yxga3E3kzd50mZJrhSfLW3a9Xp/qS3rtZ47jHM3lclhff79D7M9U"
    "F4ZYXAsC0QRwymbMvEunB2AMwRjAcQ5jYGAfer0AUsj+zm71KgvlqqK4diBNk970uWs2UYJS"
    "qQQpFYgI3W4XnvcR2WwWSv0t4F2Zc4eZfhzKaF5FsprJWEuMizlb6wSdTge+vwkighACYRjC"
    "shhiHQMAvp698EkIOZNQDITifnHtBfOnzixByOO21hphGKDdbkMphSAIwDlHsTgBwAAAGHAI"
    "QQgwA3DxayQuAClhCRH93j2HkZGDIErAOQfnHEQJAODI6nOHReqYncRAGM17J09fHx5KAVy0"
    "bCklWq0P0FqDiDA2NgoAsCwLRPTnBoXXLx9tTk4zptTbNGgDysAI9cAiqcucq7JSqixEVBYi"
    "+jw+Pop83oExps+FieabhyYUlYwN9PzvzeK3jWW23edKpZLKZvffAdgNxjC4svJ0B8fPn5hF"
    "Er8q/Ght7fZoAADXvXzRdS/9m7Bn8BOxaQYGwKVnIQAAAABJRU5ErkJggg==")
index.append('sound')
catalog['sound'] = sound

#----------------------------------------------------------------------
sound_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAndJ"
    "REFUOI3Nkk9sTFEUxn/3eW2nVBMzlNIwC0IXQpMS6ST+BAsSEZFGsBKVCpEGC4SF0FBJ/WlE"
    "FxISG4l2409igcQCXYhUkYoKk6kO6l/Sdt677943b+61IEERW9/ynPN953w5H/y3OHHi2Mbm"
    "5qNv/zXnji50dHSMyWTSh6Mo2mutKf0TKbN9T4MI9c0ZF8+9c1tbW+t+aWbSlxKJxMx4PE5P"
    "z+PfyP2NTQfHiXyz56lHwAJXCPugqKgYaw3WQiIxieLiGLmch1b6180NTduEr6+FJt88vsjU"
    "Zlau3+kaU6CmpgatQ4wxZLNZMpmXlJeXE4Y/BDJbdzWUiei8r4MDYaCbSkqcNiHVLjeKCgwM"
    "DNDf/wZjDEopfN/HcQT5KA/A4NpNr5TSjQWTB18dT968IvrrVreh9Gw3iiJ83yOdThOGIZ7n"
    "IaUkmZwOWAAETMDzQViQ6ttJUoHWuEoF373HCYKAkZFhpJRIKYnFigGYfO1y4syhDdezEwUj"
    "BjYvW6LuvFCs6NJ9rtaavr7nRFGEMYZp0yoBcBwHYwwAjafXHR6uGrtmaXUtVfFZ3O29WnKr"
    "/B73o6GsY3SUkjJMhWGYUipIKRW8rqqqpKIigbXfLPgqt2/+nHkUnALzKldSEHkWza2jtyKf"
    "ck+dPdv186vq6+tnW2uPSBnsFoJSgCHvS6xIlLGqeisAe5ef58azdgTXY87ooHR2dhYuXLh0"
    "UAhnG/Ae4PPwB9X7rouW21sAaLm1hdcfn2KxasyfogrQ3f34WXd3z0mAqbVlpbnw0+Lk5CSf"
    "ZZZh/yMPntxjZEi3ib8JjMbCHVNaEGKHgPEWcljb/rB9cP9Xu908cNSELwoAAAAASUVORK5C"
    "YII=")
index.append('sound_add')
catalog['sound_add'] = sound_add

#----------------------------------------------------------------------
sound_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmRJ"
    "REFUOI3Nkk9IVFEUxn/3zXMc/2TlFCVajhS4CALJNrWsFrUJColatKgpowipFhZCSA1GJEFE"
    "BC2CWgTppoJaWItIalUkLQSjpmeOIoRG+t597765c28LA0uFWvYtzznfd77D+eC/xdWrPQdz"
    "ucvjf5tzFxb6+voSnpfv1lqfs9ZULEXyTpzNilg9a7x7a8Lt7e3d9kfTy99Lp9Mba2trGRp6"
    "v4g82t7RVSWKOd+P3gJbXSHs67KyJNYarIV0ejXJZIrZWR8VqT83ZzuOiUA9jk0xt6zMtHq7"
    "9p9yjSnR0tKCUjHGGAqFAp73kZqaGuJ4XsA7ejpbLfSdQIUX4lB1lJc7N4SMTrtalxgbG2N0"
    "9CvGGKIoIggCHEdQ1EUAJvce+hRFqr1kihBEVzLPHorRbXtuEKlmV2tNEPjk83niOMb3faSU"
    "ZDLrAQuAgJX4AQgLMpqzJCNQCjeKwl+31xKGITMzP5BSIqUklUoCsObxg/TbfZsfqeIk0pm2"
    "AzuT331doPrLshFXKcXIyDBaa4wx1NfXAeA4DsYYAAYPrO906yt3b9rRSXnTJhF+GFgx/Oo5"
    "M773wTVKbw+1BjRaF7GW+w0NdRsqKyuYmpoGIJgaP77lcEcy9fklvMpRuXwFmUwj70aGW93r"
    "N2+++f1VbW1tzdbaS1KGZ4SgAiBhRFNqbRPsOTufwO46ElZkFiWxv7+/BHRls0eGwVwDMI4d"
    "l0NPG6qenESFk0hgdiZBKcGEWCqqCzF4oK47WV3VtW5VyXWdArPfNN5kohRH5uI/CcyJrDsv"
    "pybaHSMajWPHDfb27hem5yevZTLG3MTlaQAAAABJRU5ErkJggg==")
index.append('sound_delete')
catalog['sound_delete'] = sound_delete

#----------------------------------------------------------------------
sound_low = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAb5J"
    "REFUOI3NkT9oE2EYxn/fpQkm1FpzFKktbUERTHAIddLBSXBzyuCfQeqJk4gUd9FSLWZWkCLq"
    "4JC6OCk6i0vBTpUGCdcGiw41Qu4u3919930Oypm0Q8VBfMaH9/m9z8sL/60WFubPzc3d+bzb"
    "3MB2o16vZ1y3eUspNWuMzu8KqNVqJ3oN120+tW37cLFYZGXlw47Ax5mbe48+vt9JAUKYd9ls"
    "DmM0xoBtj5DL7aHT8Qhl2Bd2netXMt32KyAFWFonVCoVyuVjlEpl4jih0WjQbn8nin4D3MvX"
    "nEGhHukovrh5pjqSNlAqodVqsb6+gdYaKSW+72NZgljFAHw5e/6TlOHVRMfgy7sHXy/d6wEo"
    "fN+j2WwSRRGe5xEEAVNTE4ABQMB+PB+EgUD2nWVJ2f11e5Hh4X1onRAEAUEQoHUCwIGXz23R"
    "jY4MJDH4cvZr6dRg2iAMQ9bWVlFKobVmbGz0J9my0FqnmybfLD3cOH5axJH3YnL1vZcCdKhO"
    "dpUCFErFGMOz8fHRQ4VCnq2tb311J5bfPliens72emL7n6vVamZoqHAbxA0hyC8uPtkx80dy"
    "nJkLjnNp86/C/1Q/AIcGzXIH6B0gAAAAAElFTkSuQmCC")
index.append('sound_low')
catalog['sound_low'] = sound_low

#----------------------------------------------------------------------
sound_mute = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAYpJ"
    "REFUOI3VkDlIA2EUhGc3m8ubLIkHwUqwSWEsLCwEQbAKW6UQG5WQys7SRlACgdhZWIgSRIvY"
    "iYWNYKMitoKFuOZS1NzRZLNx9/22krsSnO4Nbz6GAf6NgsHAwtbW5kutL7QLRiIRQzQqb2ia"
    "tsYYWbMezyoYO7WdncUbAkKh0PTvOxqVw6IojtlsNpjPzwHAz1utx00bcBy7MhpNYIzAGCCK"
    "dphMFgzf3sH5kQY47n7g5CTbFECkw+12Q1WrICIkk0nYry8xmkohKwgwCoK/5QaapiORSCAW"
    "i4OIMBGLwZVKoWix4EDsx/bO7lcbgIZS6QuyLGO2WIRLUfDGGA77e1HVqfYdfK1RqShgDPAQ"
    "YaZaRZoD1j8/kVcUEOl1gLoGqqrCcXONyXwBOYOAo5FBdPE8eJ4HUQcNlp/je9OZXN6g00Ok"
    "r3uuqFaenM5hOBwiGGOtATlJmhj6/pYE4JE3m6c298MXhUJpvFwuB9LprFKXbqSMJM2/e709"
    "tb7Pt7Lo8y29dgT5U/0AEButCwo9mOMAAAAASUVORK5CYII=")
index.append('sound_mute')
catalog['sound_mute'] = sound_mute

#----------------------------------------------------------------------
sound_none = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAATFJ"
    "REFUOI3Nz79Kw1AUBvDvpn+wHWJJcCgtUtAXyKrPkUFcRPICxRcQLUKhj9BBHfseznYS6hBS"
    "E93q0uQ2Nz0510EHqcMtDuI3fpzz4xzg32Y4vDkZDK5fTXPVzWIymVSiKLwkogutuWEERqPR"
    "0fciisI713UPHcfBdPpovLQqhH6o1erQmqE14Lp7qNd3sFymULkyA8wlPM+DUgWYGUmSIIqe"
    "Yds2imILgKhEHMeYz1/AzMjzHFmWwbIE1rTeBiBkWYowDFEUBdI0hZQSvd4+AG0ErDxfff3u"
    "oNXaBXMJKSWklGAuzRcopTCbPYGIwMzodNqfsmWBmc0AKzpeEQEgEK2hNe673fZBs9nAYvFu"
    "BMRm4ft+xbabV4DoC4HGeHz7Y2arBMH5aRCcvf1q+U/zAft7lJrTB8IUAAAAAElFTkSuQmCC")
index.append('sound_none')
catalog['sound_none'] = sound_none

#----------------------------------------------------------------------
spellcheck = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjRJ"
    "REFUOI3FkV1IU3EYxp99MM9xDofLmiXpCMsJOsPS3FyR4kaZFxF1URezIL2pi0JS0BGEUdAH"
    "RBHsKsKb7rIGIZYsVI4f05KiRTkbQ2MjdR3X5s48579/V6lLA+um5/Z9fs/z8r7A/5YMAGrv"
    "1LjUGWy5+8LLKustiyOLYdoW+eggZDBwnV5b2UVjK5GkKiEhRUCA6e5AS1pA44P6UZGIi3FB"
    "aE9RlBKRmEec3hbL9Urfwly0Ts2q+iduvCvZcIO6uxaHRKk5RegUJakiKSlxykxVWzIqzC7x"
    "8cByQuJSEjVPP15tBYACxyMmmFFK5EqF8gylyCFiqojNZI6IAkEsxA96u97axCWSQxLkm1qj"
    "sabVOiYqggbzJKKKe0pCafZAK2cDgIr2MpcYF3NVGpV1V5PBpWJUO4WkOBmLRJ/tObu7j6Sk"
    "7ab8g/lDuuys+RjhSWj5mmzT5z45qodR67EXq4uH/PF4vHfOBK5metXQ+akJVz7XbwifGD+2"
    "7bZfOv5kliqcHyM4wO34NZKvmBKyMX0p60aHrxuXOBYAcJXKcXr8fnXDVnd1HqN4OvEjTHrD"
    "JRgxf135QlrT+fcdjUe3dL2YioXI6GIzClmn3aSpZOVy9IxFZvBqoRK+w+G1SHrAIY8S1jzv"
    "qb3a8pnvAky5DMK8iJ5hPoCBefPv8PoAALAPF+qsOn/zPq3iQyiB51zEjz7eiuB6+M/a//py"
    "7cMAxbk3X1Dg0W8eXCtj/81/h/9CPwECq/Qb3JwGugAAAABJRU5ErkJggg==")
index.append('spellcheck')
catalog['spellcheck'] = spellcheck

#----------------------------------------------------------------------
sport_8ball = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAuFJ"
    "REFUOI1lk89LK2cUhp87CYkmikZvCChCyCKaYGJcWbKMoBsXCuLWZa7QndvuKoVCF0IvlC6F"
    "7vwL7gUFFQIRzF1J4GJFEhAyan7MTGbyzffNpBsNtn3hwOHwnnPezfOB/+jg4GDD9/1NKWXR"
    "dd2MEALbtuuWZVUsy/pyc3Pz9b3/w1tTLpeTmqb96Pt+eXl5eWJycpLx8XGEEOi6TqPR4Pz8"
    "3DIM489er/e51+s9AAQA9vf3k5qm/ZzL5T7t7u6G1tbWmJubQ0pJIBCg1WqRSCRYXFwMeZ5X"
    "rNfrHz3P+wZ0AwC5XO6nlZWVT6VSiWw2S7fb5fj4mEajQTgcJhaLUavVUEq9Hc43m00P+Kpt"
    "b29v2LZdTiaTzMzMUK1WOTk5AeDw8JBqtUoqlUJKydPTE7qus7S0BFAGNjTbtjfz+fyEUop4"
    "PM7p6Sl7e3sUCgWOjo5YWFggm83i+z6e59FutwHIZDITwGbQNM3i1NQUrVaLRqNBoVDg7OyM"
    "SCTC+vo6W1tb3N7e4vv+qJ6fn4lGowBFzTTNzNjYGJ1Oh1qtxs7ODul0mtnZWUqlEkoprq+v"
    "Rwl838c0TYLBIEAmaJomjuPgOA6VSgWlFKurq6RSKe7u7qhWq1xcXKCUwvM8pJS4rott2wAE"
    "DcOoPzw8/BCNRhkMBlxdXXF5eTn6qJRCSolSCqUUruvi+z4vLy8Ada3b7Vbq9TqhUAjHcRgM"
    "BgghEELgui6u6yKlREqJEIJ+v4/runQ6HYBKAOD+/n4nnU6HfN/HcRw8zxvFfUsghMCyLBzH"
    "4fHxkU6nYwG/BIC/gVnXdYvT09NIKbFte7QshMBxHAzDwLZtdF2n3W7jed7vwB+BVxS+67r+"
    "0bKsvKZpBINBLMvCMAxM08S2bfr9Ps1mE9M0EUL8BfwKdN+DlQR+A8xYLDZMJBLD+fn5YTwe"
    "H0YikWE4HB4C5qsn+T8a32kD2ASKQOZ1VgcqwBfgXzj/AxjYvcEFVbiAAAAAAElFTkSuQmCC")
index.append('sport_8ball')
catalog['sport_8ball'] = sport_8ball

#----------------------------------------------------------------------
sport_basketball = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAA2FJ"
    "REFUOI1tk1tsU3UAh7//6el9a7t2l9Jd2LKtGW4hjl3QLegI4iKYaCLBR41R3jQk+qC+GGKC"
    "Eo2+Gd9UEmL0waFBCbIAGwkzQ2VsDRtbdyHr2q3r7fRGT3t6jq9A/L39ki/f2yd4Yko83p3P"
    "xI4XlNlntdxiY0UplnH1L7h8fRc6nh698yQvHj2JSPiN5OLnn3kCXXskk4OSZqNSKFEpKmxH"
    "1yNW/6tfeVt7vgkGg+pjgkQi4SpEwxfk6vmXq3dM1I2PU1VTiEqKXCKKSQQo5ZIkVv8mllOW"
    "OwfferH3yNsPAIRhGPLG/Pe3ZLE55GscIjl1g5peJ2pqgcxcFGdnHbWePcjufUhmL9GVf1kK"
    "bd4bOfXliNfbqYj41vLp6Ll3vg5+/AHVQhhl/SqZmztgETQfGcHQdIRRQUKnogrMjQfZnp8i"
    "Vqj7NnB4/LTp1ImWS+7hQUf6yhS1bRby8QhKKM3eY/2YTQKqVSRNR9fKGOUypUwRu38/K9cm"
    "DthL2pysq/d8rtaTJFM/sBtaJ7eUInhygK2/QpSUKsIiY6t3IFssOB0yVrNCtbYNuaFPuvjL"
    "5LicCEVo6arQ8tJhls//RlUHs62e9udGQSsjDMjG4+iqRiaepaKUMcdmaXDWUtjZ6JeL07MU"
    "n48iGzpmjwVfdz3//HiVA6+NYUJgCBPuhiYMTcXltiE0FWw+MhkY6XDmpMCJMbJraZYuXoMa"
    "Oy2dvbQOdjDz6wyp3RxCMjAQGEICE6BrSDYvaj7NdlrflDVNKlq7/Y6aRC/F3RXy6V0aW/zY"
    "3D7mby4hhIl9w+14akDSNYTNiZCdJB9skFfFdXH3p3Nn04X1jwK+vdjVedKxOMGnAiAEuiyj"
    "pEos3t4ETcfqkPAPHGNhcpqff78+EU473pT8vcNnM9HU/NytGXzdYzykjVKxAg/zSNkMHmuZ"
    "Zw41Mnq0h55Dx8nevU348uVs937fe7OpVFZq6jucdzf3v3J/bTU8N/kn9c2t5OxDFMzt6HIT"
    "wtqGqX4EbB2Y1iZRwpfWc62uo2cmtiKPxXTli/edG7Hwh95M6F1XXafb2xUkZdhxGllcxRil"
    "yJS6usV3S1vaJ2dmCvH/rRHg09cHxtx68gVLMnPQY8W567AkZsP6/Y3t9I3pneofAoxH+f8A"
    "LWaG7sbRkSgAAAAASUVORK5CYII=")
index.append('sport_basketball')
catalog['sport_basketball'] = sport_basketball

#----------------------------------------------------------------------
sport_football = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAx9J"
    "REFUOI1901tsU3UcB/Dv/5zS1tPL1rXbWYUWBgmZsEwbMHELS8BLJBCMPqhvvpj4xosPvE55"
    "IjFqEB9MTNC4eEm8JIhAdBAZWWAqdKTbMKyj3fW0p/b0tp6d09Pz//19MBo3id/3z/fp+2X4"
    "n8yOjnp5rGPAG8LRcP/ACASp1dwcLVyZul8r6r/Wde1b9jCY/2TUb9rRlxjRmy7xlDeiyL6u"
    "ECL9KYC7KGam8ONb74h1w8jIW/H82bPdLaG8DaIziaPP7fBHFckbUmCVV9As5OHt7IES7YW6"
    "N85mxieCmwrmPnz3GEniS38scKJzX5/ErSZCu/ahmp1GYyWL9ZUcSrO/QFETCMaTIP22+Kcg"
    "896Z44JJHwQTkb2xJ4dgGzrCewaxcv0bJI+8jFLmJqq5OdSWsmjks4g+dgDeYAgyAEy/P9oJ"
    "zk4Hk5HhR9QeWMVlRAcPYfHKZyjdvYGNkoZw334sT14G5wLWeh2WUQaTGXnmT570NU06zVnr"
    "hVhqCI3cDCL7h7A2eRHx4eNomSby175G22mDcwFOBCIJNV3Dza+uOZ6q4jkGa+NE12BCaq4t"
    "IPbEYTy4+DH09HUUbk8g/tTzmzB3BQK929Gy2ig4ruVp2+ZwcLe6S8DFtlAE2q1L2D7yIhzL"
    "xvLEBej37mzCJADuEiZ+niOXifseLjkHmUSwKyUs/fQFzD80FNM3oB58Fq773WZMAgE1CafN"
    "4QqySeBzlr08VmwV8qqp59Far8KqGLCqZbgu/w/mJKCoCVwdzxAR7gQ66iMSGPN3H3gajm2h"
    "WVjFRqX0cMwJgd4kKuUmuBBmW+CjcwtoScbv0wQiJA6/Anh8f8EtWDAZgfhOlPQ6fks/WHUF"
    "e32sXD8PAPLj97Kv7TiU6vZ39aBzzwCM+Rk4tgUm++EJhOHriAG+APRCDXczi5pL4o2xcuPC"
    "3wOUnwn5X7WNpZ2Rvt1Quh9FrD+FurYGy3LRqDtYXasgnc5ZRb3+gyukU2PlxtV/z18+EvYu"
    "6quV6Oyl8Y5tpMkQJCThtG59P5Vb1KqTRs38lJh86nypfi6zYS9tPd+fP2nZzcl5CxkAAAAA"
    "SUVORK5CYII=")
index.append('sport_football')
catalog['sport_football'] = sport_football

#----------------------------------------------------------------------
sport_golf = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwpJ"
    "REFUOI1Vk81LK2cUxn/vO/lyEkIGBTUhEsRK4S4sNCBCl9Iv6KJu7F0LpXRR1wX/gNuNq9vN"
    "3QhioYtKuyhc0CKEaiyCRERRxBQkGoOaGBMzk8nMvG8XJQEPHDgHznMezvNwBC9D7O7ufgF8"
    "6vv+nOu6HyqlcBzn4vn5+SCRSPy5sLDw/gWgXxwcHEyGw+Hv2+32d6lUKj46OsrQ0BCPj480"
    "m01isRhHR0edSqXyi2VZPy0tLf07WHB2dpar1Wpv0un04vj4OFprHMdBKYVpmgghuL29xXEc"
    "HMfh+Pj4V9d1V5aXl8shQLRarR8mJiYWE4kEvu8DEA6H0VoTBAFBEJBIJACYnJzEcZxvtra2"
    "2sC3olgsft5qtX6bnZ2NCyHwfR8hBFJKADzPo9frEYvFMAyDy8tLPM+jWCx2Op3OotRafzY2"
    "NhZXSqGUQkqJEP9Lo7XGMAwikQhaa2zbJpVKEY/HmZubiz89PX0lG43GJ5lMBtu28TwPIQRC"
    "CLTWaK2RUhIOh7Ftm2q1imma5HI56vU6Usp8SCk1bRjGC2CfvZ9KKSKRyEBQ27bJZrMopT6Q"
    "AOVyGdM0MQwDx3HwPA8p5aCv1+sIIUin09zd3VEqlcjlcti2LaTruhdSSoIgQCmF67r4vj9g"
    "7/V6uK4LQBAERCIRUqkU19fXaK0vZKPROIzH49zc3FCpVLAsi1gsRq1Wo1arkUwmyWQyPDw8"
    "UCqVsCyLV69eUSgU8H3/H5lMJv/Y29vrhEIhhBD03Wi327RaLQCklIOzgiDAtm0ODw87juNs"
    "G5ubm5f5fD5nWdbHMzMznJycUK/XmZ6eZnh4mHK5zNXVFVNTU2SzWc7Pz9nf3+fu7u7t2tra"
    "zyGAkZGRN6enp4lut/s6m83i+z5BEAzciEajAy2q1Srb29u/d7vdd0AweKbV1dXJSqXyo2VZ"
    "r+fn5+PNZpNQKEQ+n+fh4YGdnR0KhYJtmuY7z/Perq+vl198Yz9WVla+vL+//9o0zY+A6Xa7"
    "LTzPu4xGo3/btv3XxsbGe8Dvz/8HevGm8V+GQz4AAAAASUVORK5CYII=")
index.append('sport_golf')
catalog['sport_golf'] = sport_golf

#----------------------------------------------------------------------
sport_raquet = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnFJ"
    "REFUOI2Vkl1IU2EYx9/znm1nOl2WQ1i0LEtBWo2okGQ3IUJEQQTZfVEgMULwIpAY0kAWycak"
    "IPCiq66CUExikE1w6ioQawRnJDZROcXaXPPsvN+nizAoD2a/24f/7/ngkcA/yGaz+3Rdv0Yp"
    "7SaEpMkv7Aihpz09PUVpp3Amk2kUQqQYYw8xxnbGWAVj7CSEdGGMOznnF+QdOtchhD4DAG7K"
    "sny2paWlyePxdPl8vo+apn2oVCrQMIy9lgLTNOHS0tIDxljKZrP5fT7fHtM0mx0Oxyxj7LLX"
    "611dXl7O6Lp+FVoJZmZmDlBKA4VCgTY0NKwJIQ5DCLOEkKAkSYumaV5sbW2tIoSaLAVfK8T/"
    "bNE8xjlXFUXpVBRlXAhxRpKkFcZYmyzLc7W1tR0IoQ1LQRXTmrUSryeEHLHb7TmE0HkI4XvO"
    "+VFZlj9hjE8mk8lNQsispeB7ha1WEZUYY3OqqiqSJK1QSv2KokxSSgO5XO5euVy+wxgbtVkJ"
    "5vOwQAmFlNIRVVXvFovFbrfb/VzX9YCmaY/y+XwKY3wlHo+vb/uD29HR/Qta0/jp9uZTC9lc"
    "QXBGGeWCUKF77D+kgPvLG875i1gs9goAAP6YIDocjxio1O8A9Ua5YgAHQOGDrlKjLPChKuaa"
    "TkSaELKSSCSyW5nfgqHocOR4e9uAy+UCGy9fO97l9JH0k+uPt+rhcNgJACCDgwmxbef7Q9HI"
    "xMSEWSqVzLGxMbM31D/f19dXY3Wfv4GRSMTrtMGBYDAIpqenwWQylXHa+LlYLGbsRiBPTU1t"
    "tp3oaP+2nven0m8zdU646/Af3LjVeykUCin/m/sJPBthMVp6NpcAAAAASUVORK5CYII=")
index.append('sport_raquet')
catalog['sport_raquet'] = sport_raquet

#----------------------------------------------------------------------
sport_shuttlecock = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAo1J"
    "REFUOI2Nkk9IFHEUx99vZnbGmbZd17Sy2oouyWK2BxG7FGWHsotEdQqCCPp3KFKCoHMidOgU"
    "njsZiHTwFnbIjSIVTDNiZxu3RVjU2Fp2Z9nf/ua91yFXRKz8wDu8w/u+73t8ATbAzBozCwCA"
    "fD6/G7aBtqkXQgguFApRZh5cWloay+VyXdsSWNtMAABKqYfMXEXEj4j4xvO8d+l0+tJWAoKZ"
    "6yICADibzZqmaaZDodBApVI5QUQWAHhSyttE9JaZb7a3t9c2OuC1IgBgwzCuEFGzlPIOIvaE"
    "w+GXSqnziPgMEXcppaZmZmY61gWEEFwvANCI6K6u6xNKqW4iMgqFQj8RzcZisVlmbiKiCiI+"
    "3/KJuVzuNAC0MLMNAF8QsQkRe5h5bnV19SkAjEYikUEi6kilUg/qd6/jed4YM59CREvX9c+I"
    "GNU0zS2VSr3MPAoA01LKq4j4AhH7iej4uoNsNpsgog4hRAERhZTyqOM4k77vd9m2PaGU6lNK"
    "DTQ2Nt4XQpSJKGDmC+sOXNcdDoLgGgBIZi4FQeAgouU4Tsr3/WOWZbnlcrktCALHsqxPjuMM"
    "JRKJcQEAkE6nDzBzChFjQRCETdOcrVar+xAxysw10zQzlUplfygUmrZt+0kikXhfX2zwyEi3"
    "zLhDP4liPw4d1mzbnisWi0lN00oA8EsptQMAMg0NDZeTyeTi5iAZge/fMg3jZHPmG2hf3eX8"
    "2TNHAKCmlNINwxgnosednZ0rW6UQAMBAb7FPPxgH3TIh8mFqT5EoqPWeex2NRu/F43H3b4N1"
    "9EfhSJtWLic1KQGz3wHmFyZ33rh+sbW1Nf+/4T8nLK8M+/MLUPNLfaTUKyH04b0tLSVmFmvp"
    "/Ce/AeXVeytgOFHeAAAAAElFTkSuQmCC")
index.append('sport_shuttlecock')
catalog['sport_shuttlecock'] = sport_shuttlecock

#----------------------------------------------------------------------
sport_soccer = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAx1J"
    "REFUOI1dk81LK2cYxc98JHWSQBlkiEwSJQqWdtGllLrSS7spXWsX1sUt5NKNuLBQ/DOEesWW"
    "KsV/oEhCF0FoS8FqkVjREI0KFhe2M4nz9U7e5513umlC2wMHnsWPs3nOUfA/XVxcvMM5/yRJ"
    "khee580GQfAGY6wfhuHPnuftra+v//BvXhkeR0dHummam1LK9WKx+GY+n4fv+6jX6zAMA+Vy"
    "Gd1uV3ie972u66/W1tb+HAWcnp5mMpnMN6ZprliWBVVVEccxwjDE4+MjWq0Wut0upqenUalU"
    "cH19/Wsmk/moVqv9pQOArutfmqa5MjExASEEiAhSSuRyOczMzMC2bTiOA845crkcCoXC3Pn5"
    "+Vdpmi4prVbrLSL6rVgs5pvNJhRFwdzcHKrVKhhjiKIIjDEMBgNwzuH7PvL5PO7v73F3d/ex"
    "SkQrlmXlt7e3cXh4iG63i9vbW0gpkSTJyHEcI4oiEBGenp5g2zaI6HNVCPGBlBKdTge5XA5B"
    "EODy8hL9fh+cc8RxjDiOkaYpHh4e0Gw24fs+NE0DEb2nE9GM7/twXRdRFOH5+RlpmiIMQ6iq"
    "CsYYhBBot9vY29uD53lwHAfLy8vgnGsqEamWZaFSqcBxHJimidXVVWSzWURRBM45rq6usLu7"
    "C9d1h12B67ogIuhE9Ec2mzU3NzfRaDSwsLAAy7IQBAGklACAfr+PKIqgqir++RrGxsaQJAlU"
    "Ivqx1+uhWCxiaWkJ4+PjGAwGEEJACIE4jlEul1EoFKAoCtI0RbVahWEYIKJzVQjx3dnZmQQA"
    "xhiIaNQFIgLnHIqiwLZtGIYB27axuLiIm5sbENFrBQAODg6+np2dfTk5OQnHcaBpGhhj8H0f"
    "YRgiCIJReKlUAuccjUbjlzAMX+gAEEXRF8fHx2+7rvt+p9NBr9fD1NQUSqUS0jSFpmkwTROm"
    "aaLX66Fer98nSfJyf38/Ho1pY2PD5px/Wy6XPxyChmFgfn4emqYhCAK0222cnJz8JKV8tbOz"
    "c/mfNQ5Vq9U+ZYx9JoR4V0qp27YtpJRSCPG7EGI/k8kcbG1tDYb83w7A3IKgPHOhAAAAAElF"
    "TkSuQmCC")
index.append('sport_soccer')
catalog['sport_soccer'] = sport_soccer

#----------------------------------------------------------------------
sport_tennis = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwJJ"
    "REFUOI1dk09MXGUUxX/fe/MeMA4zUFuwZYNWE2mMK+sCEw2NQnVhYtXUJiRdwgITk26aNEZT"
    "Fy4FGRtxUxd0qavGCAubKEHThahEaI1NIbRV6AAD82bevO/fddG0Ac/qLs49yTknR/E/mMXT"
    "gyBDXqQfZ/q8bihffLWiotY/9drlSx0DC9/v5auHhywM9drcgTFx9ZGw+3TBh+CVQbxBBYch"
    "WSX7ezLxXk+Jr5c7X19feSQgC0O9Nsh/EnS/O+xji6tfw+tbiNnCywFanrhI/e4kcfE1Qp2R"
    "LF6YNk3z4eEz2UoABFrC94Oud4atuoHdmsCnc+DuASmYCkgOs7lEbW2Sul6lre/jYUw2BhBU"
    "fnnvFORHfVzH715F/A4gD/wFClSC3v6R4rGvcGlAc2MGGxWwhpHVLxgM2o+cHM09+UFeRU8h"
    "HEK83xdqEEXY6pdk69/ReWwcvbNJo/ITpRc/LZiEoUDWJgo+u4mtzRF3f4ToEET2xKxQcY5s"
    "82vEG3KPDdDcvoHEJWxGfyBeP+vDALN5BZeuoaIXEOceNCMgXgCFyoWk//5M1P48praNI8Qa"
    "+gJvU/AOLwq78wdB/jje+UfP3oN34KxgTYZ3IA681dgGBN6my6IdojoxyRJB23O4psUZj7Pg"
    "NNiGxSRtFI+eIflnHtXagdINsgbLgRg7T9ZAxU+ja78SPf4yPhgg20rROxlZtUFz9yDFvnGS"
    "u9fR1evEhWewyQbNOvOq+i2DzvNN6/FyoXbnEqIP0n70HCpswTbuE7Z0IcRUb89QvTVNVGqn"
    "1HuWvybOJ806b+c6TjG7cYUp2d04FxVP0Kz8wP3fR1GqB5EObFbF6nVwjqhUorXzJezGTepb"
    "TL1xldkAwGnK1bmL07FtJ98zQlvXCWhROL+KCneISkfI97xCqfcsYWr5bfzytAop7xvT7c/o"
    "lZQx5xk5dPJ8Qdq68GELYh2SJZjqPRY/LyfZLlMupvzWDCv7BB5i6QKDWY0hMfTrJn06hazB"
    "ctZk3htm3rzG7F7+f6qOqPqwcmBcAAAAAElFTkSuQmCC")
index.append('sport_tennis')
catalog['sport_tennis'] = sport_tennis

#----------------------------------------------------------------------
star = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAi9J"
    "REFUOI2dk7trVFEQxr9z7p69N7ub3WyiiSRI0MTE1YCFhUR8YOMfIEhArYS0YmGloOktLbSx"
    "sNM0lrZaqBAQBJcUYmJhkmWz2ez77n2cmbFI1ASSoA4cZuCb7zcH5hzggKh8unC2vHDp2kE9"
    "+iCRLF4K2ef/BSh9PD9jTGbcJLN9pXfn5v4ZoESeGi+LZE8eTHK/OH8q+deA0vvpOeP15bXj"
    "AgCM22tyWe/FnoPKxcsZ+LgOsVdBOCMsoyaVS7npfnC0AQ5aUIkRdOtlBJ1aVyxWhekLSN6S"
    "jV6r9YWLRZPuO+24aTg6CUBDsYCCMmxnFRJbCDLQZgQSW1AUwoYB4tBH6Dc2FACUPkwvuZmB"
    "415uCNxZBocNsLWQ2IK3j8QEIQUnNYmgXYPf2qxHfjCmAaCabRSCWmWlWy1BmaMQZggxhGgr"
    "263ayRQQtOvoNqsdR9HJqdmVTQ0AU1OLkcOtgr+5vk5RDOUMQuy2mRjCBMBAiNBpbgSIUBi7"
    "8b28awtDVxbbEtOToFEBdP7PLSwBxFDmMGK/DY7ozYnbSz9++RI7VyJMk1obSNQEVArazUMl"
    "E6DWGjioQzmD4DA+ttOzG0A8rnUC0C60GUXYrIPiFpLeMJwEg8IINoiP7A+wMqyUg3Z5Fd1a"
    "JSKWeRBXOVyZTfb0prx0DhxEuX0BzDRQXV7ssOVnEze/3dsh3f38+NCdpl17aEPbv9eLBAB8"
    "fTVxa19xOxYeeDPFR/j9L34Cf98zkPlcMmoAAAAASUVORK5CYII=")
index.append('star')
catalog['star'] = star

#----------------------------------------------------------------------
status_away = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAArpJ"
    "REFUOI2Fkd9LU2EYx7/nnHm2nR23ZvPHNOc0FZyIWUpEF0rQjUoXEQVeBbsIwroWQoq60Iug"
    "PyCCbiqCoECE0Cy8UTNaHTLKqbOhLpdu/tiPc3bec963C3PUFHquHl4+z5eXz5fDIdN9V7ka"
    "8LmCXrfUmiMUX6Nx5c3swqP480uPC1nhsONzbZXDve3uQKDKbm2otFmba474CJPOfMoENll0"
    "9PPfPF8Y0ORzBbsCjnKXJEAlFFmdwikJuHjWW97WVBss5A8ElDptrbYiAbtZCmICxGDYSpuQ"
    "bRx8/mOthbyl8EHTAdNkIAYDoQyGCRgmwPOAqhkHfB34gRKOKcksgVXkkCMMGmGQrBziOwYm"
    "p+aU/wZMzMyPP3wd1XZVClWnUHUT6RzF8BPFUD+8DxXy/7TQ1j995UJXw42uerFiK6UiEieI"
    "JzVkU0l0+EU+VXa8IRqptyH9dnL/httfmq9NtHae9D3t6/QGjsoWZHQGRvdcJMJjcGQ+wu6S"
    "oWVVLIamw5Evsf6hkbnxvER3sdTf21EWcEsCNnZNSFYeAIetxQnUeTawW3sdOdMKQih81X2N"
    "vHjzVTDJevIOGipLOl0OHr+2CcAYKGOglIHFJ5CQutHk92Dq2QOcb/egpbEG8ulByXOUv5MP"
    "kGVbtcjxWI2roAwwTcCgDLxFRJqIcMlFeVelxRbk7NXw+uUT+YAcMTjCAJ7nYFIGgzLohCGz"
    "s4FUzgD7ww0NDILnBexkVJCcwfIOlld31pZizjqnfc+rSSl0k2ElqqG8Poy17VIMDN8DB+BH"
    "woCQmEFE2Qrla4yQnoWxRZJ2CKy9qUaGtYiHIDDoQgU2393COi3BtzUDynwM88oooi/uby+n"
    "+GC+xv2pujy2XlHmNjxO0aEakGPJLEhM0U5tv7S01CWLLExLrSxlZn/q4u2R0PeZ37zsQhF4"
    "VZscAAAAAElFTkSuQmCC")
index.append('status_away')
catalog['status_away'] = status_away

#----------------------------------------------------------------------
status_busy = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAphJ"
    "REFUOI2Fkd1LU3EYx7/nnHl2drY2pzmd5tRylvNiWXrRCyheRJRESRR0FXhRF3bdRRAlBP4J"
    "QQTdGBUIEfSCZSBCLzasQQpqLka6mov5NnfOzu+c39PF2sgp9Fw9PM/3+fDw/QrYoU4NRi+H"
    "Ap5+v1cN5xjHdDwZfTM5fz/5+PyDUq2003FPe+1Qb4c3FKpz2IO1ir2toTzASD3yeTP0m+LP"
    "v/yrF0sBrQFPf3fIWe1RJWiMI2twuFUJfcf81e2tTf2l+m2AKrcSVsokrGc5mAUwk7CSseBS"
    "BAQa94RL9bbSgW4AlkVgJoFxgmkBpgWIIqDp5ja/tn0QnUtE01kGuywgxwg6I6h2Ack1E+Pv"
    "vkb/Cxj7MPv63qu4vq5xaAaHZljI5DiGhqOm9unjVKl+SwrtA+8vnukOXutulmtWNjTEkgzJ"
    "tI7sRhqdjbK44dsXjMeaFWTejhduhELTdmUs3HUo8PBSlz9U6bJh0yAQz3shjAyj6tYAiBkA"
    "ABOCLoD6DgAviyZ6d6kDvZ2+kFeVkFq3oNpFAALszx7Bd/cm5OMHYfN6ACLkfqYUfeHHi5lU"
    "+kQREKyt6PI4RSyvMkiSCE4E4oD3xlXIR8OQFAVGZBZEBLljPzhxaKn0kyLA5VLqZUFELJlB"
    "vd8Jy0IewgzYKstRMTK6xbzU2R5YgKcIyDFTYASIogCLE0xOME3KL4lgRCIAURFQaIuA74tr"
    "SwsJ9163I++rxTkMi8AdTuQSy+B3riMXmQMAlB1ugb6UhACsFmOMsdPzo99YxilRR2uDC/Yy"
    "EZJEyLSE4Xg6DNgk2FvqIforoS8msTY1QwScLMZYqLoLo79qfF5zt1t2aiZciXQWTdMT+uDk"
    "bdVpZcW/z6cJOBcGJv4ABxEnLygfJvsAAAAASUVORK5CYII=")
index.append('status_busy')
catalog['status_busy'] = status_busy

#----------------------------------------------------------------------
status_offline = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAj9J"
    "REFUOI2FUj1r21AUPdaXJVkK8kewFdQSAjXYxjUp1dCpgf6IroWs7ZjNc+iaLplK+h8ydgpk"
    "jajwYiiysYOpsZuoyHKw/J6eOkUkViAX7vI457x7z7k5PFGnp6efTNM8NAyjQynFeDx2Xdf9"
    "fnJy8mMTyz9FbjabX1utVrNWq+W3t7fzlmW95DjunSRJf3u93q+HeG5TwDTNw729vaosyyCE"
    "gBACWZaxv79frdfrh5t4YfNB1/WOKIqIogiMMcRxjPV6DUmSsLOz03lWII5jJEmCOI7BGEs7"
    "l8uBEJLxK7PCcDh0l8slBEEApRSUUkiShDAM4TiO+6yA4zg/Ly8vV1EUgRCC9XqNKIpwfn5O"
    "r6+vnU38oxSOj48/2rb9ZXd3txaGIW5vbxEEAYIggGVZnKqqrwqFgtzv9y8yAt1ut9NoNL7Z"
    "tt2oVqvQdR2VSgWlUgmapqFYLMKyLGU6nb5WFMUdDAbeoxW2trY+t9vtpqIoWC6X6VT3ht7c"
    "3EAURRwcHJRLpVI344Fpmu9lWcZisQAAMMaQJEmaAgDMZjMYhgFN01oZAVVVX/A8D9/3kSRJ"
    "Sr6PM0kSrFYrCIKAfD6v3/PSOyCE5Bhj4Dgu/TWOY1BK09t4uFZmgtlsNpnP55AkCQBSMiEE"
    "jDHwPA/DMDCZTHB3d7fIpGBZ1m/P80JRFN+apglBEMBxXOoHIQRXV1dwHCcYjUYfPM/7AwA5"
    "bNTR0dG0XC5TXdcLlFLN930EQRCGYegTQv6dnZ29eYj/D0mLKIadWHVKAAAAAElFTkSuQmCC")
index.append('status_offline')
catalog['status_offline'] = status_offline

#----------------------------------------------------------------------
status_online = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnVJ"
    "REFUOI2Fks9PE0EUx7+7a9vt9hcVaWnBApEaW6IVAwejUaI3RQ/ESLyZkOgF/wNPnjh7NSZe"
    "jDHxamJQjHhQVCLWaKIikCpWq9BCW3a7OzNvPFQNtCS+ZJLJ5PO+b+b7HQXb1Klr2YvpRGgs"
    "FjYyNiO8zxWyj17O3yzcPXerkdW2az7RH58YHgin0x1eTzKue/q6WhJMGofnNtIrMnf/zWZe"
    "bRRIJUJjQ2lfNGRosBjBdAhBQ8PIkVi0P9Uz1sg3CbQF9Yzu0lA2CUwAjEuUqgJ+XUGiuzPT"
    "yO9oPKg5gBASjEswkuAC4AJQVcCq8Sa/mm6Q/ZTPFk0Gj1uBzSRqTMLwKCisc0w/e5f9r8DU"
    "zMeHNx7kamWLYDkEyxGo2oSJ21luvXrxupHfkkL/+PPRs0PJK0O97vZSxcJigaFQrMGsFDHY"
    "7VYrkT3J3GKvjurj6SaBvstTmaMHY9cvHIulejtDaAn50BP1oiviRTDgQ3s0iP09Ld7ZVRwo"
    "vQ1kgdmFLU8IB4zx4cFIOmxo+FUWgAQABSQBh0ss5G14XBounUm2Yt/eq00eJOM7j4d8Kn6u"
    "MUBKkJQgkuBU30upYP6LiXirDlc01tck4Pfru92KiuWCBZKAEACnepycA0RAucLh1jS4dW/g"
    "b9+/f2AzrjAJqKoC8Wcy5xI2IzAiEJT6UlQQbRPj0vL6t4W8Cb9XAQAIIjiCYDMCF4BLAxJt"
    "LswtbcAqrlWaUlhkp+cnP7OqT5MDqS4/PC4VmiahABAkYTmEe1N53Hm6UqbpJyeBme91mxuq"
    "4/zkj/ZImO8Kun0Whz9fNJFfdarm13IJVXMNH0YPbeZ/A/ACJMrOgl8GAAAAAElFTkSuQmCC")
index.append('status_online')
catalog['status_online'] = status_online

#----------------------------------------------------------------------
stop = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkhJ"
    "REFUOI2lk1tLVFEUx3/OGRXJW2kqjk3ekkDF6E0i7CnI/B69FD0UvttDgdBNwpL6CD1V9Al6"
    "kkytmDEmm1ScZEzHuZzL3vvsfXo402hKL7VgsRab9b+w2Av+M6oOP2RfzF2tqoneI2LF0b7A"
    "BJjAr8WT67rkTO3a3uuhqSn5ez56EJx5+mS8prVprr6vM2ZZASgfjIHAoKUZzifXXjYUv98C"
    "HhxxkJmduVLb1jLbdPZ0t7Wbhp0t8A34CoSExhb8k33kFpNf7fTGzZ6HM28BrFD50XhdW+vz"
    "xjNdcWvnG2Q3QekQKCRIBTvbRLwStT39J6RtX7re27vyeGExFQGIRqqnG3raY1Y2BZk18BS4"
    "bpiOB44bEqVTRL+8p7WvK0Z1ZLqyA2N03MKHzTXQAfh+qKrKKf1yFbCaJNreTZUx8QpBIISH"
    "KxrwRGj9D6As9yrshQDXw3iut+9AyAApwXbL6geAFbJyCgFSoj0R7DuQXh1aQaEAAQcUDxEo"
    "CY4DRoMSdQARgKBU3NCuD82tUNgD2w4HHQfscnUdKOSh4xRKavxCcaNCIHO5yexiMuPHh+B4"
    "B+zlQxK7DHRcTD6P6YzjjlxgY34xo37uTFb+wczCcupaW0tKFEujdYPDzVYxBz82QQkCV+A7"
    "DqarF3H+Ilvv5leLnz7eGFlaeXPkFhKXxyYaB/qftQ0OxKqNQiuFMQYdgDKw/eEzxeWl2+cS"
    "6ft/PabE2OiEVX/sLpYVD7QSRmuqAlOrHW9d7+XuWLrm1VAiIQ/j/jl+AS8ObQPjMCNvAAAA"
    "AElFTkSuQmCC")
index.append('stop')
catalog['stop'] = stop

#----------------------------------------------------------------------
style = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAshJ"
    "REFUOI2lkltIU3Ecx3//nbOz7bg5tzmdznJ5wQsqmBpdDM3UtJcu4IMRXaiHeqiIVhEkkhTW"
    "Q9CDPUS9lJSUWBAJveQlUpESZ0xzqOH9Mm3TTc92Lju/3sRSK+j79oHf9/Pw5QfwnyFrIb3O"
    "qc03hzdZjEyehVXoBQklT0DmJuaDwy3OxYqxe9mjfzUm3h8sq+pccHVOcdgxwWHho+FX8Zd6"
    "0gCQbHSv+IUQiZaC8iQdbbG/nqxv6Fv8GvSKQdEjuQEIbiSg10L8rf5TNZVbz994Pv5wyR18"
    "WZikrdepiRH1bGpqjeu0PoxOlkQUIIRAATJ+rzi1Kki42Z98dJfJPusTfb65QANZQS6GVUZo"
    "KEpLZF4trGAgMk653WZitLII8LHb+8YzKzhWBREqsBds0aTM+0LLVyrj36oBlGkWlbF7UKHF"
    "cd+QNjc6TokYNjC08t0Wq0pYmA70mwTmAQ3VrbR1LqzyclnMscet7vbPbe4nKEgCIlqrLqZW"
    "qwmo0MQezEoKOzw6HnS6vvnt0QbmPY3ADjRmCLR1Mjz9UHnUVe+yFPjS4rbPNO3pBQAwHfiQ"
    "0jPsP8MQhT4r11DrXuDdLqfvHITkaCLJoGFIDACA4kJFbHeGWZW5uCKy5cXmOwAAkaUtOQXF"
    "sc9K0g1ZyzyJtxqYCEeXp27+RXYHysjLkgwMRcLXPdLviTrRe7xkX2S9miLACyFY8oWAVQLo"
    "WAo627zNE37+JL1ZObqyd0eSjb3u+cEH+nv8TzmOd8kySGYtU5RfaDxCK1DHcJJ5U4HRQF1L"
    "tmkympunb9M8XbvwbicHAADln2bGRjVFIAFKIVlYJ4is6MlBxMKtVk3xzCzPhXh0zM+ACACg"
    "L2nfFpIwkyAqwyOoRHlW3rtug9K7Iz4VAzqQEVACmB5Z7nIvcvsnG3cH8s46+swWVSYAIYAA"
    "kigLf9rwn/ITdDg+KiZyvO4AAAAASUVORK5CYII=")
index.append('style')
catalog['style'] = style

#----------------------------------------------------------------------
style_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwZJ"
    "REFUOI2NkV1MW3UYxp9/T3tOW05pS8toKRuE0QwIYzI+4tgiGOgEbzQmxECMGeFmkqgxVDPj"
    "FiJxEU1IdsFIpkYTiS5qcGbeLBphmq2EDcLHYK6BbAgMSqmllNKP09Pz7sKMoAP1d/ck7/O7"
    "eF6GHRT3TosnMtMHbBl8pU2vMkoyycGYEl1ci88NToea/viobB7/xcGeew3nPAGv52GUbi5G"
    "qfbS3Le5b44VAcR2u1f9LRExkUNjgUFtc3+/1H95MjQVX0/Gk0HZDzDaTaDeGXLfnznV1Xzg"
    "tXe/Wri44Y9/U1sg9hu0LIOM+sLCLm+rMU3tlJMkIUXgQPzmevLhtiD/7IzzpWMWty+cDIdX"
    "Y5fZFkXteo1Jx3EiUxJaaYti1hzN0TwLLypJ4LeR9StBnzSxLTAJcNfs1x1aC6ciHc25V7WA"
    "psgmZIzcU4m0EJ4VK7JyNERpd2e37udlC/mB5diMReIvqNE5pHaspjW/1WBv+XTI/+vt6/7P"
    "SJIlInKce6OwU8sgkEX/fGlB2ovzC/Fp7++b7iwzf01N0N/9rkRSO5bSi19o3Pf2ekSOjQ76"
    "3SsDx8cBwPLcL4fG5jbbeKYyllaYP/QHEn7vdPg0UkoWkxXoeGYHANXrTdkjJZnC4dBWUt9Y"
    "n3keAKwnB8tr6rO/dBWbSyMJlusw86aJ4WDv2tdlN0mhhCIr4DmWDgC7/vYx+14df8X1rLVf"
    "yzGooj9DkK9DkkKIxBJYWCn2Ti69fJzbq5zVPF7lPKj/WFEUQ3Tp88mi/DvZz1RWoq6yARK/"
    "irA8ZGXxHzJVewkyzNw7zjxdyehwoMckekqeKjyClCqFI3YXUiyJpw9Xg+OCLep/Fq1NY+VE"
    "VHvAoatf8SWiqQRNhCJ/ajVMRGNRGwCgo+4T/HinD4xdFZ4QHC03DQk8DFAIJAN5dl1HYGM1"
    "PrPs0U4u38AZ1xfo/qkVWk4AA//vIz6mqt3+wf5843vVpSfgtJVh1jcOz9QNLD7Y6Plfgr8k"
    "tm4w1s4AAwGbIOq71ec78wjT9EFd5EwuWgAAAABJRU5ErkJggg==")
index.append('style_add')
catalog['style_add'] = style_add

#----------------------------------------------------------------------
style_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwZJ"
    "REFUOI2Nkl1oU3cYxp//OacnJydJ23w0H01ram1oDbVQ6yZjgnXUzXijjpWRTYpjF5tjU9Qo"
    "G87pZB9MEIQ5ZGwgtWyiooIg7GK23UYtRbt20mozO+1qW2Ma25q0+Tg5+b+7EJ1zdfN398D7"
    "/C7e92V4hMDhAfOKksLTbpv8jFsVijSd9Kk0T92azAy3D8w0//lF/Qj+j0UHh9bsuRiPXBxP"
    "UdetFDV+PXzSt7V3MUBsvnnhH4mImUUEqyySO3xmrO34bzNXMtO5TG5KjwGM5hNIjwbfx4Ob"
    "9ocWbP7gu9Gv7sUyJxqrzG0WhdmoSK2p2R95o8gk+fUcacgTRJCcnM6NPxRUfjjof/k5ezia"
    "yCUSd9LH2RylPGpBsVEUzYxnFW2O0o6ygqUVdtnMc8DPPdNnp6Ja/0NBsQHhleXG6slEfnZH"
    "yHdOAQoWuw22niHBTKOJ6+ZlrrICItPV63M3KkoNlfGJ9KBdkw9J2Nshee+YQtvWeF77piP2"
    "06XO2Lek6RoRefdsqdmrMBjIrq6tqzKtHxnNDESuJcMuq/yDRFCvnqrVJO9YYWBd0LlzelZP"
    "X26PhW+ffr4PAOwvXajuHU6+KTOhqG6Z9fNYPBuLDCTeRp67mM5hlJkHAIT3mkt7aksMS2bm"
    "cmqwqeRTAHC82N6wsqn02OqAtW42y3xeq1zc3z11ePL7+i7ilOU6hyyyQgCY97YPcLb0bVy9"
    "ytGmiAyB31vhj7RCvXsTSYsLl7Bq6Ev27grxSWVXqO9Z/yL1AOfcEuj85Neg2uVZvqFF8L++"
    "FT6nAttMt71+4oQuPElgs4q7/BXG2svd8YPL40ed1S+8Iip/dIK1hqDeOItKn415MNoiPV50"
    "NPc2EFHjAq+x6XY0m8pnqV8itltxLwTWbv/7A/d5IBMv+5dgaUNxh0GGBZxAOlDhMe7Ij2Ai"
    "1X/eazr3DrLpKFIAkgkR9xTnfy/xAb+86tknm027yx15SRLGkJzUMRIV81qGf/RUgvuS8vdT"
    "dyfeEjjzcYHGOehI8Ef+2V/6r0CKd7Q5OwAAAABJRU5ErkJggg==")
index.append('style_delete')
catalog['style_delete'] = style_delete

#----------------------------------------------------------------------
style_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAwxJ"
    "REFUOI19kltIUwEcxv/nsrOj29zmzG22zUteptPKSyRlYRfS7KJgVoiVYRQVFFoUaVSGPRQF"
    "QXSliErNoIcKIqILal4qu8zMSiUvqenO1LTtbOecnbPTS4ap+D19D9/v4//BH4G/Cr7ZRSZJ"
    "kFPLIuRbtSQufdvr7KlrcVxoPBJ9DWYQOm56tocyP2nBLkpQgmJ45n0H3dRL/bozEwwAgIwb"
    "c9mX5MxE1dUnjSO3TbPJ+RwtwLcfnpuBRp9UCYDUywEwtIdvLjOXTLlAe8AqW27xOxmilgah"
    "jNCTMIs0aXxQNefyaEgc2xYb6ntIr8R3DQ2wxLQTwhSSHUaFJKGlZfSDRUvkGZS4hRC8oo/o"
    "1SoIRNXeQTc4HbydHWUrp0wI2/9h9ZY0fcVH66+ql09txwRWkK7L0l1Uz5LFt40K4hjFPxwa"
    "cNdHRsjP56rOXlnsP1aKyeOAHqoBYPq3ofkrtXsDZCil9sNpZ2r1iDaYtAT6y9UEgRvlOKYi"
    "QKzV6wjTkoDn/hkWVakuLg/Cl+dD8IKd4HIZz+Bmd1DmxnWIAKKIAFIqdudYXjx6rzTGxymS"
    "edpDYSAeXhVSH7knxSZVqhbDyPevQCAcKPx0INeYlMjkTdqN1ti4ebIHtkG3ta+TOXE3u3hu"
    "UlJyuTo8HWEHqsA9jADV5gLOzQ4zrHMR/o88LqL6duv6AA26z1eKzhkeZC81FeQY/SNyK5Th"
    "a4DpvwIowYNEHgwk/cnGuIn0hYXP2v8V5EArbjfLNvmSqFbkvR0bDPeWyIybzynD1wPTfxlQ"
    "CQ/c71CwVzc6PJxrbXxRjfW/R5qox2W67NCk3MqopVkEZ7sFCMYBM2YAqvatW+CcMdGFb7rH"
    "s9hk+MZuQ0Fsan45D0GY4LgPpEwE96gB7LWvKeAcieaipq6JeXxygSIk6npMyk5oqzoI7a8a"
    "QGqaBx6q7acKg7T5Je86J+enXDA3xOdoskGJqvVGGOkbgt7Wr05Mgq1IOdncMt3cKQUaX09x"
    "T2cr8M5hLysV6lDwpmec/vxtOhgA4A+g3THKMJ68SgAAAABJRU5ErkJggg==")
index.append('style_edit')
catalog['style_edit'] = style_edit

#----------------------------------------------------------------------
style_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAulJ"
    "REFUOI2FkV1MU2cYx/+n5/QU2vJVirS0WgIYKSLxa4kGDahA1BuNGRdsMejlskxjrBdbNESX"
    "xe3CxIt5YfRGjSFK2KLRqDf1I4GMCUYWYCDMQAuKraPQz9P3vOd9vNKoQPzd/Z88+SXP85fw"
    "ETW/D9m3leR3uxzqVy6rqYBx4nMZkQ5HtYng0Hzr1G8bJvElKs+N7j7V+3asdyZNPeE0NV6c"
    "uOk7OuAHSFpq3/RJIpLsMvZU5SmuwB/T1zoH5//RYrqmz/EIINFSAuXj4Ds9fOhM26rvfrwe"
    "urAQ0W40Vtmv5eVIDiqwVlefGTtcYFNWc50YDIIMUhMxfeaDoOLk8OoDW4sDs3E9Hn+T6ZRS"
    "lHZbzYW5smyXRDaHpSjj9Jo3lherdqEDT/pif87NsucfBIUWBBpW5q6Jxo3k8Tbf7RzA7HdZ"
    "HH2jJjuF4uP2zaVeM5FtZDz1srzMUvH2VWa4mKnnFXQ8VDxvbG3Hdru/ufQw8vjpo8hlYpwR"
    "kefUkeqOHAkWKrburauy7Z8MaUNj/yYCpUXqfYVgHemqZSbPdH7Nvib3iViSZ/qDkcDrrvrO"
    "2VsN3TxrPBiYSEzLhLy6zUVnbeKg8Lu/rgUzbBIXyFUlNwCYfmgt66stsaybT+nWPU0lvwCA"
    "syW4qaGp7GpzTVFdMiv5PEVqocZSmtfpx84d33YLLqDKUj4ALNktABy9vp2EwQxGJDPO4XFU"
    "os67DX9PBjE4/RQzz+7cDSf0dmU5ARcMzbXtskEChjAgQHi1EMY6bz2SLIN5f/1ec/DeimUF"
    "GmcwSGDq/3HogoMLHbqhI55NYP3K7UjqaSlWv2NwkcDZOrCJiBo1fhDc4CjNXwUuDBgk8Hoh"
    "BIfdhWfhHvz1IsSj/d3fL/pBy6//xS0q8pTcZmhMBxNZaDwrKp1rTVsqWtAf6kXPiylUiC4Y"
    "usKWu2ARa3+Wou1XdpHvJ/TXdEB9P1+2hc8pP4moINkZUgwzToO/n78DBLdd65xGcs0AAAAA"
    "SUVORK5CYII=")
index.append('style_go')
catalog['style_go'] = style_go

#----------------------------------------------------------------------
sum = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAV1J"
    "REFUOI3VUrtqAlEQnWwCthZ2FtoEQowgRLBI4eYLFMHa5B/sxQ9IEYJVkOAXSDoLwQ1Css2i"
    "gihkmy1NEbBRd+6ci2kUNouPMuTAFHPmzGFm7iX6a5wEk1qtZhqG0dNaEwBHa80AIgCuRCTC"
    "zO/NZvMm2GMEk3q9bgEYmqZJIkIi8qGUspj52ff9B6XUZ3iCszChtb53HGcQj8evXdetNhoN"
    "a1srl8u9sP40TPT7/VkqlaJEImF6nmem0+nWaDTyiYgmk0nrqAERkW3bb7FYrJjL5S5c1/0a"
    "j8f2Lh1R6AZBMPNjt9udK6Uu92mIQq+wRaVSiS6XywEAtNvt80MGOydYLBYvzPy9Wq1eg3w2"
    "m10fNSiVSnfMnGTmdafTqRIR5fP5KBGRUmp+cIVCoZAB0AOgmfkJAIlIVESKAJIiYk2n09tg"
    "z69/ICIZERmKCDGzCYA24W1iuP8a/xY/06XOh7WO7+4AAAAASUVORK5CYII=")
index.append('sum')
catalog['sum'] = sum

#----------------------------------------------------------------------
tab = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAANtJ"
    "REFUOI3tkUFqAkEQRV9V9T6gAy4kINmJoEsP4FXmAjmEJwjZztwh13Ah8QBDo6sgOYHMVBaN"
    "PRlDwAP4N78L+r8qquAhAajreuPuW2B9Z67puu61LMuPAODub6vVfD6ZFIkqmY1I7+ktnM/f"
    "L7vd5zuQAEAxGj1xPH5xubQAqGoOiUiuQwhMp2PcvQAIeSgEM6NtPX/+DekBhqrlVAaoKmaB"
    "EBgEbt1MEdG/ABHFTHEP/3ZPTYYAqarKZ7NnlstFXl6/sGs9dID9/kDTxDRBjCdiPN15wYdu"
    "9QN94TRuVAbP1wAAAABJRU5ErkJggg==")
index.append('tab')
catalog['tab'] = tab

#----------------------------------------------------------------------
table = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAc5J"
    "REFUOI2lk79rVEEQxz/vRxJjTKHcJWDEJqAY4y+Q40QLBQsrxR8IWtiIpb2VpDH/hwiKQgKH"
    "dqYQNXhEBAOCHBEtDtTcHdE7lITszKzFO997JykSHFiGmWU/853ZXfhPCwAevFy5az64Zd72"
    "mBlqIGaoGmoeUcstRcWjam+nb+wrxQDq/e0rpeHCVipPPV46DBADmPkCQOXzfcQEUcGZ4NRl"
    "XiXdu3PiHs7ZQApQ8wBcn7i5qeq/1wQnSgZQA+DR68amAOeP72I9D5AuAODaqRGezC9z9eRo"
    "mpupLnO5nMWtzlqvAqeGeU8cwcybBlEUMlttEIQQdg9VFhrgPX0xHBjbzrr7pwUPxFHAxVKR"
    "ykKTC6WRHgX5+NPXDiLWq8AbxCE8e9ckihIPSe4vJA7AgInd2/DkAWJ47+mL4NyxInOLLc4e"
    "yZ7F8/dNyvt3MjwYA1CrtxkaiHNDtIQWhQFziy2A1IcBOINXH3+kwPFif3pzCUAkmUEIZw4V"
    "ePGhxenJTMFstcmlcjGNa/U2Ube1bAbeM7l3B99WVhkfHeTL91/pXzg41k+t3iZvaons5BbE"
    "5qceLh11ZkNOFCeKiuHUEBU2sp+d1acbbmzV/gDX7wklmbL0IwAAAABJRU5ErkJggg==")
index.append('table')
catalog['table'] = table

#----------------------------------------------------------------------
table_add = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAixJ"
    "REFUOI2lk0FIlEEUx3/zfZ9ppRdZNUm6SJFRuxbxYWaXVKiLEUVQhyCii+Kpi6fwUngIgiAP"
    "HYoQiiJLq1OsRbHWYkSt5SWjDoHp+iG1Jup+M286rOyuHcLowfDnvWF+782bN/CfpgAGXs5d"
    "EKvOiZU6EcEIaBGMEYxYtJGiZTDaYoy8uXR6m+8BGGu7j/sVkX/J3Ht3MgrgAYjYCMDwl1to"
    "0WijCUUTmrCgRuf3evZdJAylNA8wYgE4tePsmrIvLGlCbSgAjABwJ5FeE6BjbyXZYoBeAQCc"
    "bKnm3ugMJ/bX5GODyRmONRX8ILO0uoLQCGItnguDr9O4rsODZBrlgLNyaHgsDdZS4kHD5g1k"
    "wz+uYAHPVRz1qxgem+WIX72qgmL/81QGrWV1BVbAc+DJ21lcN6eQiwFceTjAt5kRFhZ/sBxm"
    "yS7vKQJowVpLiQuHdlcRTwW0xQpjcXXoBvMmQesBn7rKrTyfGCL58RF+V+1lB3JTB+A6ingq"
    "ACCeCoinAp6NB7z7dJ/G7TGMY4jVtmNUSNOuZsB25QBa53rgQFssgufmtC0W4WA0QpCZpkSV"
    "09HQDcD51uvUV0dRqLJCD6xl55Zyvs8tUl+znq/Tv/J/IbPwk4mpV6SmEvS036Tv6RnK3FIs"
    "din3ClpGe29PNoYiG0NtCLXBaCE0gjaadaWHSY6P0Bxt4fGHftYpj8T7F4C6pv4+cwXzOzf1"
    "oVSnggoL81jbP9Y/3fMbyWYvT8Y6XUwAAAAASUVORK5CYII=")
index.append('table_add')
catalog['table_add'] = table_add

#----------------------------------------------------------------------
table_delete = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAihJ"
    "REFUOI2lk0tIlUEUx3/fQ3wliV5f9LhJD6gsC+KW1KKoRQ8opDByUYuQoHBRK1fholxEy8h2"
    "EUFRYWAYVFzpokkXQ8hoEZi2kEyvVxdaas7MmRaffFeLwOjAcDhnmN/5z5kz8J/mANzvmrwq"
    "1mkQK6tFBCOgRTBGMGLRRhYtg9EWY+Rdy9lNMR/AWNt4KlYQ+ZfKzY8GtgP4ACI2AtA+dA8t"
    "Gm00SjTKqIw3OtxrqrmOUpIdAoxYAOq3nF9W9R9zGqUNGYARAB6+SS0LcHxXEfOLAXoBAHBm"
    "XymPe8ao21sW5tqSY5zck4nTU3NLFSgjiLX4HrS9TeF5Lk+TKRwX3IVD7b0psJYsHzavymNe"
    "/XYFC/ieQ22shPbecU7ESpcoWBx/HplCa1mqwAr4LnT0jeN5gYcgB/Di1g2yk3eR0UGcSAXV"
    "hcd4EgK0YK0ly4PDO0uI96c5VJ0Zi8SdmxQPd7CxvoHsyq3MfnhFQXcnuw/6jUETJZDjuQ7x"
    "/jRA6F0H1OtWNpy7RM5gArqukbeykMpolL5P9nIA0DrogQsHtkVIfEyzvyqjoHNimJzySjh6"
    "Jcz5zRV41lmX6YG1VK1dwbfJWdaX5fJl9Hv4FyguZ+b9c/KfXeTn7CgzwPSUh/EYCV5BS0/z"
    "g4EdSiRfaYPSBqMFZQRtNDVlteQnXxItysX3spge1wyNudZac9v5Y8z+Yt2n1zTNTIxccMWJ"
    "imu/Crb1SFxafgE3iSsdZ+L6uQAAAABJRU5ErkJggg==")
index.append('table_delete')
catalog['table_delete'] = table_delete

#----------------------------------------------------------------------
table_edit = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnlJ"
    "REFUOI2lk0tIlGEUhp//MmOXMW0qC7PU7G52wTQiW0slRRBBEUJE7tpHi2pRIW0jWuimgq4Y"
    "WS4SpOtMlqFpQ2kNGjGUl9FJp4vj/3+XFr+NbYqiAx8Hzsf3nvc95/3gP8MAuPw4cVxp47DS"
    "Kk8phVQglEJKhVQaIdUvRyKFRkr14kz18nIbQGp9ZE955tx/6XzyenQtgA2glJ4L0Nh3EaEE"
    "QgpcJXClO5WlSN8d3Xwa11UZaQCpNAD7Vx/6q+7fUgJXSKYApALgamjojw+DToiCgZtYgRJq"
    "/I+oOV9cbQOISQCAfRU53AgPsnfL/HSt4dkg2/Kfk+xpY3rJAbIKNzD6fgXdzfVnbQBXKpTW"
    "2BY0tA5hWSa3ng1hmGACQec+qc9Rgsu2kOjtxm84ZM5aQGDO4qy0BA3YlsHu8nk0tsXZVZ4D"
    "QGr4Md8Hu8kurGSi/xr+GQYfOntIfjfBia8zfzLQCmwTmtrjWJaXH4YbGR+4R3bRdlKf6jB8"
    "n/EFMsmQI1xKVLLpyO13HoBQaK3xWVBVOo9ptsHGGa2szGgla+lOUh8vYPpcnGQBw6FXOOuP"
    "8dWfB3gSEcobomUatHQNo/pbSMTC5BTvwBmox/JrJpL5DD7pIFpcC8Hl6c15WxDCm4EJC7+0"
    "IHQEoXLpj5xjdo6fVGIRo+09FOyrY1nWQt7GxrBMphi40pOwZnGArlA9qytqyIiFeNcYprM5"
    "wZuWlzhlJ+hLBngbG8Mzn0fb24JQ4ZNXoutdpWbm9sZxXjdRuG4rY/ERejuiPMg7xcidL0Ak"
    "7Y3R5PhdmPyNv8aeiuzx0qL5dtmqJWjfxNOJePxgVW2k73fu/AH4lkPwKTXiiAAAAABJRU5E"
    "rkJggg==")
index.append('table_edit')
catalog['table_edit'] = table_edit

#----------------------------------------------------------------------
table_error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAkNJ"
    "REFUOI2l0ktIlFEUwPH/9ygndURtnKEMe5GvwkeKKLYoaClhDwIT2kTLNq6iRY9FLdq3jF6E"
    "FCYo0aLMyLSHZpSgkEG1qjQ1EJsZ/e49p8WUM0ULowuHw70Xfufecy/853AAbgzMnRZ1jovK"
    "BhHBChgRrBWsKMZKRlisUayVkQtHSxt8AKt64lBDOPIvlc/eelcF4AOIaASg5/01jBiMNQRi"
    "CGyQztYs751sOk8QSNYyYEUBOFJ5bEXVvycNgbGkASsAdA5OrwjYV1/IUiZgfgIAbbui3B6a"
    "4nBzbHmtf+gB5VlDxKo68FbnMTOf/P0EgRVEFd+DO8+m8TyX7ufTOC74mmRr8h6hWDMvhzqZ"
    "zWulojibpSAFuL+uoIDvORxsiuK7cKAxyv6GKM1rh4kW15O3rpbC+CB7tsynntZIGgisoAK+"
    "C3dHv+J5qXz/xRhfJnoIR/Kx871EKtoYG7iCNQYlEzCCqrLKg5a6IkK+Q8vOCNudPmLlrZB8"
    "xfD1m+TmJ8iaG8FOD5OT5acBIynNcx363swA8OTpI4KFOcIFcWTxA6hgF0bYvLuDxMRVPJvI"
    "AIxJ9cCFvdURfNcQm+0iv6QGiY+hkqDuYBmy9IlQaJKiTc1UO/1/9ECVHSW5fJ5LsD7+mFDB"
    "NrLDM6iZBcdjtHsSECQ5SVHpRsoXHzJwprLSAei4PD4YBFITiOQExtKup2hsv4TnfkTNN0Az"
    "vpGLt6aMqfHXvO091+X87acNXqydUSPZKoqKpEKV9FxBBERHfwAjJkXpNa22tAAAAABJRU5E"
    "rkJggg==")
index.append('table_error')
catalog['table_error'] = table_error

#----------------------------------------------------------------------
table_gear = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmRJ"
    "REFUOI2lkk1IlFEUhp/vp2ymMsjxOqn9WBImYUUhCa6idhFUbgwZCInatBEEV9qmXLZ2ERVB"
    "EW4qIoJcSS3MrEQXwoBlMvqZn8ZozQx+957bYsqsTUYHDu/5gfec83LgP825N7jYLda5JFaq"
    "RQQjoEUwRjBi0UbWuMFoizEyfCO1vxHAN9ZebWncmviXqdcepht+xr6ITQA8nryLFo02mkg0"
    "kYl+odGrva6m60SRlKwSGLEAXKhvX9f0bwVNpM1q7hsjADx4+XldBGeObWdlDYGrfxAAtDYr"
    "PMfS2qxWfaNfzBP5UUqzw+RXft/Aufk0Y9tPlPP8/RdcAMfBweK4EItCvHxAPr6XbdEUIkLZ"
    "jr2MvBnGt/m+VCp1xTVGsIDvOZxvUvgunDuuONuo8HIZ9uzeSenKR5RSVFZWMjs1QeORA8zM"
    "zFzu6emJ+5ERrIDvwtOReTyviABeSYJCoUAYhgwODhKLxaivryeXyxGPx293dXXl3EgL1lo2"
    "eHD6aDmbfIfTR8txgtckYhqlFOl0mu7ubjo7O8lkZkgmk9TW1l7s7e21vpaiiJ7rMDAaAjAw"
    "GpLNZvE8j4qKCpRSPHs7/0M1WF5eZnp6msnJSVytdVEDF04eSuB7RWxpaUEpRRAE1NTUMPvu"
    "CZmRR1RXVbGwsMD4+PgtESlzI1M84eCuLcwu5tlXEeND8JVP8wXGxsYACIKAhoYG6urqCMMQ"
    "13UB2peWlrK+0fLq2v304Uhkc6QNkTYYLURGqLaWoaE7fEuewpgJ5ubmGFlMsmGgz2qtX/T3"
    "9/96iL9ZR0eHbWtrs3/WvwPvJEpbKbVHAgAAAABJRU5ErkJggg==")
index.append('table_gear')
catalog['table_gear'] = table_gear

#----------------------------------------------------------------------
table_go = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAjxJ"
    "REFUOI2lk81LlUEUh5/7vtfiVirJ9WqlRoaBH6WRmGIfm7I2FmUEFdQiWkYuCyLcGC1atOkP"
    "EFEp0IpaugovWqJltBMUUwpNBb/y9Z0zZ1pcP3dGBw7DnGGe85sfZ+A/IwLQ+nH2ibrIPXWa"
    "p6pYBVHFWsWqQ6xuSosVh7Xa//T2kaoogHXu/rWq9Pi/dG56NXwMIAqg6uIA70ZaEBXECkYF"
    "Y83GamX97GFNM8boznWAVQfAzZK72+q+FAhGLBsAqwB09ExtC3CpMotwM0BWAQA3TiV4nZzk"
    "em3Oeq2zb5KG6o399HywVYGxijpH1IfO3il836Orb4qIB97qpQdtZ1k2C9SXvqUsfy+hSQG8"
    "tSc4IOpHaKhJEPXganWCK1UJLlclADDOkBcvpm3wAoEJENGtCpxC1IMPA7/xfWhsP4NTQ6hC"
    "KML+rCKKc0+yECzR2FVOOq2bAKI450jz4eLxbLqHphENOV96B+sUqxbF8XNunKN5tSyGywz8"
    "qOfEMzJTJmpKju9F6B6aBiCQEOuUsZlhjAqiBmMN8ysLVOSfZtH84dNoz4wHICIpDzw4Vx4n"
    "6kMgAWKFnIwCcjMOsi+zkDQ/Rnb6AQbHk3we+c6SoXLDA+coK9jDr9llDufEWJYVWnqfE2pI"
    "ICGF8RKqC+voH+thcGKI0thLffPo1tfUIIkmm9qHK4zqbiMWI5aYdBC1ilghA/gyUUfEi5Ec"
    "/kbRjhfMLWa/h9XfuJ049Jgl6/xdK9jCyWZG1+p/AcoCRvg7fAlOAAAAAElFTkSuQmCC")
index.append('table_go')
catalog['table_go'] = table_go

#----------------------------------------------------------------------
table_key = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAntJ"
    "REFUOI2VkltI1FEQh7//JctKK7O1GxEJBaFlEFuSdKOLECVaBEU36AJBvUZP4Uv2HAS9BCHR"
    "FTYwMMosRIoyCVISMy0vSbXrYtZe3N3/OXN60FaFCjswzJk5P74zM4x1o3HwghjrpBhZLCJo"
    "ASWC1oIWg9IyzjRaGbSW5qojy/0Arjbm7D5/Vi7/cSrvdq76fXdFTC5AzadqlCiUVnii8LQ3"
    "5rVKv50vvojnydQ0QIsB4ODK45P6PZZQeEqnY1drAeD289CkAHvW5pAaD1CjAIADJT7uvQiy"
    "f0NeOhd4FWTv+rE4/DMxsQJPC2IMrgOBlyEcx+b+qxCWDfaoqOZ1CIywIHidvIzPFLAsDbC1"
    "FgzgOhZ7i324NlSs91Hu91Hm9wFQ5vexcWod+fODLCo5RsWKd7ypyi8FsC7d7zWndyygsX0I"
    "y5rYr2tDLCnkhB9SkN3AnNXbifV/REWEoa7WeGdT6wnXU4IxhikOlK6ZR31LmG2rx9biydsB"
    "lmd2MKtwFzrexrTcxSR0Pws3FU1X0cGrrpKRITq2RX1LGCDtbQs8gf74XGZ/78F2wlh2jIzs"
    "MCTiRL8mHVcpNTIDG7YU5tLwLszmgpEKEqE2ul9eIWeOQdQwtgyBnYXxUry/05Fo//DjlOvp"
    "kRYKlszk6+Aw+XmZdH+LovseYfU9YOm6EkyqDktHaH+cxEkkGE5qPnUPHTp8py/gaiUvKm91"
    "FnkiMzyl8ZRGK+HMwlrWbN1GKnwV151F69MUN3t3EspeSzQSq62tLg/8c+M+B0qbksEqE+vY"
    "bZovF0euHc0//Ced+zfAl56B+p8/ni2NfY8Pd30InTtR/fHen3S/AHXxV9/UPuBjAAAAAElF"
    "TkSuQmCC")
index.append('table_key')
catalog['table_key'] = table_key

#----------------------------------------------------------------------
table_lightning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAnBJ"
    "REFUOI2lk0tsjFEYhp+Z+aczHZ2IMaNouxCduIsmLpXYYIW4s7CyQGyIYMFCRIillTUbGyqI"
    "hU1XbqGCuNMOQl3bMZ3OTMs/nfOd71hI/5LYiDc5yflykuf9cvK+8J8KjV7O3SweVRfapU6b"
    "VRWrIKpYq1h1iNXfjsWKw1q9740CrHN7tyxOpv/F/diF1/MDQCr8NF19e5bhahG1ioqiVnBi"
    "GbFhbtQvoeyiiApihcNLT2KMxjwA17E1cj9yl1iikcT4uTgjOCPYmo8/2E1DdgfzmlZDKBy4"
    "f68KRiweQF8239I8cp1o/Vqk/IBwvA1rB6iWcrww6+l/vxjeF/5Yf93CFDWxeO757Lr8sO6M"
    "T8gCEdTvA2+EYm8nqRn7WDFtGwCXuvrZ3N4YAAqV6q8N+oZSbSGV3bFkFic+RKaAMYhEeJnr"
    "RnMnCMsIGTeOa7fXINFGoh7MakpQMxYvZPV0PL0o7Q90o6LUJVpBPTLNK2kYyGFNjUr/Yz5N"
    "OsSqJa2EowkA3nypIKJ4aqXj++c7N5/5Gw4uaIkxmLtKumU5Ui1R+1Hgq8ykMusI5dBUrjwc"
    "wgsNocDsqXEcOvYpxzveueJg0b251Oa+dG50r84vdaWei25UnY/yrvLDBHP3h5LbfqrLBTkQ"
    "VYYf7ScWT5GvZhjInuKTn4QnBcIhMAq3Xg0GhtMzdVirBIDJeg9T6SU/cQ/tyzZz/XmBFXPH"
    "gnm56xub2jPB3POxTCTMGKAsE0guPE2yoZWvRZ/pjfW86xsOujCnqY6ej+U/smBVNSjTgTMv"
    "bhujC4zqOCMWIxYrirGKWPlrF0oV/+pfH/5FPwEIK2nIBiYClQAAAABJRU5ErkJggg==")
index.append('table_lightning')
catalog['table_lightning'] = table_lightning

#----------------------------------------------------------------------
table_link = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAmlJ"
    "REFUOI2lkktIlFEUx3/ffKNDfpki4yOncFWQMGFU9hJsoahBD0l8lEgQumvTIlqZUAliq9oF"
    "BVEgFSpuayGJofighQk2aTE24zjjKKV94fjdR4sRXyujA5fDuZf7+//P4cB/hgHwcmCpVWmj"
    "WWl1QCmFVCCUQkqFVBoh1ZYjkUIjpRptbzpc7AaQWt+qKU73/oty2+uvRwHcAEppL0DftxcI"
    "JRBS4CiBI53NLMXG290zD3Ec5dkASKUBuFZ4c1fq9qrAEZJNgFQAdA3GdgW4dCKLta0AsQ4A"
    "aCjJ4c3HKLXncjfuuoejXD29WceXV7c7cKRCaY3bhO6hGKbpomc4huEC1/qnvpEYaE2KG474"
    "0lhzdrSgAbdpUF2cTd/IApeLc7Y52FpPzy0jhNruQCtwu6B3KEToyxgdH2bI8WYRnl/A5y+j"
    "q/83M8M9+PK8LC4usWclg/LycisJEAqtNS4t+Dn1Hr2ywo2mRmzbJhQKMTQyQEa6RV3NFUzT"
    "JBKJkDo+zrvU1HvJIaqknenJMSKBaequN/Do8VOmJkbZn5eH3+9nNvidzs5RIvPzHDt+ioqy"
    "8wSDwRYXgBACDcxOT5Kxby8AD1rvIByH+vp6SkpKqKqqorKyEuE41Da2AJCZmenZnIHWFB46"
    "yMSnMQDa7rcjhKCjowPLspILZNsopXj1/AkXL1QQDodXDYDbzyYHHUcV/Yr/sJY/v+XsySLy"
    "fT7SUl1Eo1ECgQAej4eCggJyc3P5k1CEQ7PO4ED/jLFjyczS0lK/ZVm9+fn52R6Px9Rau+Lx"
    "eLNhGGGv19sLpCQSCTk3N7dg23b1X5NJR+brKXThAAAAAElFTkSuQmCC")
index.append('table_link')
catalog['table_link'] = table_link

#----------------------------------------------------------------------
table_multiple = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAgtJ"
    "REFUOI2lkktLlGEYhq9v5htnPGSiqJgty2iEaGFl0LpFRGEtoiAXST9BaCOMi2rpX0jI1IUL"
    "KfoBUSRJYBBJjbUUtOgwOiff59BizNQUFz3Ll5frvp4D/GdFAI9f/LhrzoC4dbgZpYpQDYKY"
    "I6oEMUwdNf3w4PaJwe2AGEDNblw719xyUFpuaunY7rcYQNxbAGbfv+m0SneraCqlZpSqQjUo"
    "YkZdIkNTfYqRifyyqC88HOy5tAUwdQAavLftYl9DvFe6OxQrSmN9ktHpz9ldLSgAv9ZDXA3O"
    "848LCSsfTZhlIttuooaodTXV1zEyseSqNh8DBKkZqDnpVEQq9CQvn2k6aCTkpvOnagBT3B01"
    "oxqcUrVmNPtlHDGhUFmjFMoEFcQEUeHe+fuEYOmtGTggaqRTEWo1o1vZoX3TixUhiLLZguEK"
    "Yk4lGKoGwOTL1X0BV/pa2fgD+L5eQl2JgGQiQjYBADcvdDAzt8L1/s4dgG+Fyl8DEX+Xm8z3"
    "dLY1UyorQQ1zJ07CzOtViGBmboU4EYE7qRhOdjewETYBY0O1ZocfLS5n6hKoWpcDcTJi4Gz7"
    "ngZLywVEjB1HI+bzo1OfervaD+MGcQKevf0K1AwA4ggMyB7J4OwCjN3JXgUYHl90NaP/+CFE"
    "nWI5bG1me2VibM+zVbFXuSf508GsMYiyVqwiKv/8+1koP/0N1yhARSwy8TkAAAAASUVORK5C"
    "YII=")
index.append('table_multiple')
catalog['table_multiple'] = table_multipl