#!/bin/bash
#
# Read configuration:
source 'config.sh'

# Create qdiscs:
echo Creates qdiscs
WRR_ADDR_FIELD=sour
DEV=$DEV_OUT
BW=$BW_OUT
ADDR=$ADDR_OUT
if [ "$MASQGRADING" = "y" ]; then
  CLASSIFY=masq
else
  CLASSIFY=ip
fi    
if [ "$USE_HTB" = "y" ]; then
  source qdisc/create-qdisc-htb.sh
else
  source qdisc/create-qdisc-cbq.sh
fi

DEV=$DEV_IN
BW=$BW_IN
ADDR=$ADDR_IN
CLASSIFY=ip
WRR_ADDR_FIELD=dest
if [ "$USE_HTB" = "y" ]; then
  source qdisc/create-qdisc-htb.sh
else
  source qdisc/create-qdisc-cbq.sh
fi

# Setup penalty for qdiscs:
echo Sets up penalty
WEIGHT1_DECR=$WEIGHT1_DECR_IN
WEIGHT1_INCR=$WEIGHT1_INCR_IN
WEIGHT1_MIN=$WEIGHT1_MIN_IN
WEIGHT1_MAX=$WEIGHT1_MAX_IN
WEIGHT1_VAL=$WEIGHT1_VAL_IN
WEIGHT1_MODE=$WEIGHT1_MODE_IN
WEIGHT2_DECR=$WEIGHT2_DECR_IN
WEIGHT2_INCR=$WEIGHT2_INCR_IN
WEIGHT2_MIN=$WEIGHT2_MIN_IN
WEIGHT2_MAX=$WEIGHT2_MAX_IN
WEIGHT2_VAL=$WEIGHT2_VAL_IN
WEIGHT2_MODE=$WEIGHT2_MODE_IN
DEV=$DEV_IN
source qdisc/penalty.sh 

WEIGHT1_DECR=$WEIGHT1_DECR_OUT
WEIGHT1_INCR=$WEIGHT1_INCR_OUT
WEIGHT1_MIN=$WEIGHT1_MIN_OUT
WEIGHT1_MAX=$WEIGHT1_MAX_OUT
WEIGHT1_VAL=$WEIGHT1_VAL_OUT
WEIGHT1_MODE=$WEIGHT1_MODE_OUT
WEIGHT2_DECR=$WEIGHT2_DECR_OUT
WEIGHT2_INCR=$WEIGHT2_INCR_OUT
WEIGHT2_MIN=$WEIGHT2_MIN_OUT
WEIGHT2_MAX=$WEIGHT2_MAX_OUT
WEIGHT2_VAL=$WEIGHT2_VAL_OUT
WEIGHT2_MODE=$WEIGHT2_MODE_OUT
DEV=$DEV_OUT
source qdisc/penalty.sh 

# Kill any wipld and wiplc processes running:
echo Kills all instances of wipld and wiplc
killall -q wipld
killall -q wiplc
sleep 1

# Create wipl configuration file and start wipld:
echo Starts wipld and wiplc for lan side
source 'wipl/create-daemon-lan.sh' > $WIPLD_CONF_LAN
$PRG_WIPLD -c $WIPLD_CONF_LAN
sleep 1
source 'wipl/create-clients-lan.sh'

# Run user configuration
echo Runs user configuration
source 'userconf.sh'

# And start loop:
echo Enters main loop
loop/wrr-loop.sh
