%define name writerperfect
%define version 0.8.1

Name: %{name}
Version: %{version}
Release: 0
Summary: Tools for converting WordPerfect(tm) documents into OpenDocument Text and Word Perfect Graphics into OpenDocument Drawing formats
Source: ftp://ftp.sourceforge.net/pub/sourceforge/libwpd/%{name}-%{version}.tar.gz
Group: Applications
URL: http://libwpd.sf.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
License: LGPL
BuildRequires: gcc-c++ pkgconfig
BuildRequires: libwpd-devel >= 0.9
BuildRequires: libwpg-devel >= 0.2
BuildRequires: libwpd-devel >= 0.2
BuildRequires: libvisio-devel >= 0.0
BuildRequires: glib2-devel >= 2.0.0
BuildRequires: libgsf-devel >= 1.6.0

%description
Tools for converting WordPerfect(tm) documents into OpenDocument Text and Word Perfect Graphics into OpenDocument Drawing formats.

%package -n wpd2odt
Summary: Tool for converting WordPerfect(tm) documents into OpenDocument Text format.
Group: Applications

%description -n wpd2odt
Tool for converting Word Perfect documents into OpenDocument Text format.

%package -n wps2odt
Summary: Tool for converting MS Works documents into OpenDocument Text format
Group: Applications
 
%description -n wps2odt
Tool for converting MS Works documents into OpenDocument Text format.

%package -n wpg2odg
Summary: Tool for converting Word Perfect Graphics into OpenDocument Graphics format
Group: Applications
 
%description -n wpg2odg
Tool for converting Word Perfect Graphics into OpenDocument Graphics format.

%package -n vsd2odg
Summary: Tool for converting Microsoft Visio documents into OpenDocument Graphics format
Group: Applications
 
%description -n vsd2odg
Tool for converting Microsoft Visio documents into OpenDocument Graphics format.

%prep
%__rm -rf $RPM_BUILD_ROOT

%setup -q

%build
./configure --prefix=%{_prefix} --exec-prefix=%{_prefix} \
	%{?_with_debug:--enable-debug}  \

%__make

%install
umask 022

%__make DESTDIR=$RPM_BUILD_ROOT install

%clean
%__rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -n wpd2odt
%defattr(755,root,root,755)
%{_bindir}/wpd2odt

%files -n wps2odt
%defattr(755,root,root,755)
%{_bindir}/wps2odt

%files -n wpg2odg
%defattr(755,root,root,755)
%{_bindir}/wpg2odg

%files -n vsd2odg
%defattr(755,root,root,755)
%{_bindir}/vsd2odg

%changelog
* Wed Nov 17 2004 Fridrich Strba <fridrich.strba@bluewin.ch>
- Remove execution of autogen.sh
- Source tarball is writerperfect-X.Y.Z.tar.gz

* Tue Sep  9 2003 Fridrich Strba <fridrich.strba@bluewin.ch>
- Add execution of autogen.sh before ./configure

* Mon May 26 2003 Rui M. Seabra <rms@1407.org>
- Change spec to spec.in
- Remove Prefix: since we're using whatever the distribution uses by default

* Thu May  8 2003 Fridrich Strba <fridrich.strba@bluewin.ch>
- Create rpm spec using libwpd .spec of Rui M. Seabra
