/** Suport for parallel task processing on multiple CPUs.
 * (c) 2013 - 1019 Jaroslav Fojtik.
 * This code could be distributed under LGPL licency. */
#ifndef __JOBS_H__
#define __JOBS_H__

extern int JobsStatus;


/*
typedef struct
{
  (void)(*Caller)(void *JobData);
  void *JobData;
} JobStruct;
*/


class JobBase
{
public:
  static volatile long JobCount;

  virtual void Run(void)  {};  
  JobBase();
  virtual ~JobBase();
};


int InitJobs(int ThrCount);
int RunJob(JobBase *js);
void FinishJobs(int WaitMs = 5000);
void EndJobs(void);

#endif	// __JOBS_H__
