/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This file is based on the qbrowser example from Qt.
    The license of the modified files are the same as the
    example.
*/

/****************************************************************************
** $Id: helpwindow.h,v 1.3.2.1 1999/07/13 19:17:56 reggie Exp $
**
** Copyright (C) 1992-1999 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <qtextbrowser.h>
#include <qmainwindow.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>
#include <qmime.h>

#ifdef HAVE_KDELIBS3
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#endif

class QComboBox;
class QPopupMenu;
class QConfig;

#ifdef DEFAULT_GRAPHIC
class HWMimeSourceFactory : public QMimeSourceFactory
{

public:
	HWMimeSourceFactory();

	virtual const QMimeSource* data(const QString & abs_name) const;
};
#endif


class MyTextBrowser : public QTextBrowser
{
	Q_OBJECT
public:
	MyTextBrowser ( QWidget * parent=0, const char * name=0 );
	virtual void setSource ( const QString & name );

protected slots:
	void copyText();

protected:
	void viewportMousePressEvent( QMouseEvent *e );
	QPopupMenu *menu;
};


class HelpWindow : public QMainWindow
{
    Q_OBJECT
public:
    HelpWindow( const QString& inicio,  const QString& path, QWidget* parent = 0, const char *name=0 );
    ~HelpWindow();

	void goTo(const QString & direccion);

	static HelpWindow *defaultHelpWindow();

protected slots:
    void setBackwardAvailable( bool );
    void setForwardAvailable( bool );

    void textChanged();
    void about();
    //void aboutQt();
    void openFile();
    void newWindow();

    void pathSelected( const QString & );
    void histChosen( int );
    void bookmChosen( int );
    void addBookmark();
	void clearHistory();

	void imprimir();

protected:
	virtual void closeEvent(QCloseEvent *);
    
protected:
#ifdef AUTO_COMPLETE
    bool eventFilter( QObject * o, QEvent * e );
    QStringList fileList;
    QDir path;
#endif
	void fixStyleSheet();
	void leeConfig();
	void guardaConfig();

	QString quitaTipo(const QString & url );
	QConfig *conf;
    
    QTextBrowser* browser;
    QComboBox *pathCombo;
    int backwardId, forwardId;
    QString selectedURL;
    QMap<int, QString> mHistory, mBookmarks;
    QPopupMenu *hist, *bookm;

private:
	static HelpWindow *help_window;
};

#endif

