

#include <SimpleConfig.h>

#include <stdlib.h>
#include <fstream.h>
#include <cstring> //Soluciona el bug #113819 de Debian

#include "../salidas.h" //Aade dependencia a un fichero externo!

using std::strcpy;
using std::strcmp;

SimpleConfig::SimpleConfig() : FileConfig() {
	strcpy(filename,"");
}

SimpleConfig::SimpleConfig(const char *fileName) : FileConfig() {

	setFileName(fileName);

	/*
	ifstream inpStream;

  	inpStream.open( filename, ios::in | ios::nocreate);
    if ( inpStream ) {
		readStream(&inpStream);
	}
	inpStream.close();
    inpStream.clear();
	*/

}

void SimpleConfig::setFileName(const char *fileName) {
	strcpy(filename,fileName);
	readFile(filename);
}

SimpleConfig::~SimpleConfig() {
}

/*
Bool SimpleConfig::writeEntry(const char *key, const char *sValor) {
	return FileConfig::writeEntry(key, sValor);
}

Bool SimpleConfig::writeEntry(const char *key, long int Value) {
	return FileConfig::writeEntry(key,Value);
}

Bool SimpleConfig::writeEntry(const char *key, double Value) {
	return FileConfig::writeEntry(key,Value);
}
*/

bool SimpleConfig::writeBoolEntry(const char *key, bool bValue) {
	if (bValue)
		return writeEntry(key, "true");
	else
		return writeEntry(key, "false");
}

bool SimpleConfig::writeNumEntry(const char *key, int iValue) {
	return writeEntry(key, (long int) iValue);
}

bool SimpleConfig::readBoolEntry(const char *key, bool bDefault) const {
	const char *valor;

	if (bDefault)
		valor=readEntry(key, "true");
	else
		valor=readEntry(key, "false");

 	if ( (strcmp(valor,"true")==0) || (strcmp(valor,"TRUE")==0) )
		return TRUE;
	else
		return FALSE;
}

int SimpleConfig::readNumEntry(const char *key, int iDefault) const {
	return (int) readEntry(key, (long int) iDefault);
}

bool SimpleConfig::save(const char *fileName) {
	if ( Salidas::getShowDebugMessages() )
		cout << "Saving '" << fileName << "'" << endl;

	ofstream o(fileName);
	return flush(&o);
}

bool SimpleConfig::sync() {
	//ofstream o(filename);
	//return flush(&o);
	return save(filename);
}

