/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2005 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _MINIWINDOW_H_
#define _MINIWINDOW_H_

#include <qwidget.h>
#include "QSimpleTextBrowser.h" //KDE3 ???

class QString;
//class QSimpleTextBrowser;
class QConfig;

class MiniWindow : public QWidget
{
	Q_OBJECT

public:
	MiniWindow();

	~MiniWindow();

	QSimpleTextBrowser *browser() { return _browser; };

	QString text();

	void save(QConfig *conf);
	void load(QConfig *conf);

	void save();
	void load();

	static MiniWindow *defaultWindow();
	static void setConf( QConfig * _conf );

public slots:
	void setText( const QString & texto );
	virtual void show();

protected:
	void mousePressEvent( QMouseEvent*) { hide(); };
	bool eventFilter( QObject *, QEvent *e );
	void keyPressEvent (QKeyEvent *e);

private:
	QSimpleTextBrowser * _browser;
	static MiniWindow *miniwindow;
	static QConfig * conf;
};


#endif
