/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "aprender.h"

#include "aprenderData.cpp"
#include "aprenderData.moc.cpp"

Aprender::Aprender
(
	QWidget* parent,
	const char* name
)
	:
	AprenderData( parent, name, TRUE )
{
	//setCaption( _("Learning") );
	//learn_button->setDefault(true); //QtArch no me hace caso :-(
	ingles->setFocus();
}


Aprender::~Aprender()
{
	debug("Destruyendo Aprender");
}

/*
void Aprender::aprender() {
	done(1);
}

void Aprender::cancelar() {
	done(2);
}
*/

void Aprender::setIngles(const QString & s_ingles) {
	ingles->setText(s_ingles);
}

void Aprender::setCastellano(const QString & s_castellano) {
	cast->setText(s_castellano);
}

QString Aprender::getIngles() {
	return ingles->text();
}

QString Aprender::getCastellano() {
	return cast->text();
}

void Aprender::setTitle1(const QString & titulo) {
	box_idioma1->setTitle( titulo );
}

void Aprender::setTitle2(const QString & titulo) {
	box_idioma2->setTitle( titulo );
}


#include "aprender.moc.cpp"

