<?
/************************************************************************/
/* WordTrans-Web: A web Interface for WordTrans                         */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Aliet Santiesteban Sifontes                    */
/* Email: aliet@tesla.cujae.edu.cu                                      */
/*                                                                      */
/* ========================                                             */
/* Based on WordTrans-Web                                               */
/* Copyright (c) 2001 by Copyright (C) 2001, 2002 Ricardo Villalba      */
/* http://wordtrans.sourceforge.net                                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

include_once("functions/conv_charset.php");

switch ($lang_case) {
	case "es":
		$p_palabra="Palabra "; 
		$p_dict="Diccionario ";
		$p_buscar="Buscar";
		$p_borrar="Borrar";
		$p_completas="Palabras Completas ";
		$p_mayusculas= to_utf8("Diferenciar Maysculas ");
		$p_invertir="Invertir Idioma ";
		$p_acentos="Ignorar acentos ";
		$p_busc_avanzada= to_utf8("Bsqueda Avanzada");
		$p_busc_normal= to_utf8("Bsqueda Simple");
		break;
	case "fr":
		$p_palabra="Mot "; 
		$p_dict="Dictionnaire ";
		$p_buscar="Chercher";
		$p_borrar="Effacer";
		$p_completas="Mots complets ";
		$p_mayusculas= to_utf8("Sensibilit  la casse ");
		$p_invertir="Inverser les langues ";
		$p_acentos= to_utf8("Ignorer les voyelles accentues ");
		$p_busc_avanzada= to_utf8("recherche avance");
		$p_busc_normal="recherche simple";
		break;
	case "el":
		$_char = "ISO-8859-7";
		$p_palabra= to_utf8(" ",$_char); 
		$p_dict= to_utf8(" ",$_char);
		$p_buscar= to_utf8("",$_char);
		$p_borrar= to_utf8("",$_char);
		$p_completas= to_utf8("  ",$_char);
		$p_mayusculas= to_utf8("  -  ",$_char);
		$p_invertir= to_utf8("  ",$_char);
		$p_acentos= to_utf8("  ",$_char);
		$p_busc_avanzada= to_utf8(" ",$_char);
		$p_busc_normal= to_utf8(" ",$_char);
		break;
	default:
		$p_palabra="Word "; 
		$p_dict="Dictionary ";
		$p_buscar="Search";
		$p_borrar="Clear";
		$p_completas="Full words ";
		$p_mayusculas="Case sensitive ";
		$p_invertir="Invert language ";
		$p_acentos="Ignore accented vowels ";
		$p_busc_avanzada="advanced search";
		$p_busc_normal="simple search";

}

function introduccion($lang) {
	switch ($lang) {
		case "es": 

echo to_utf8(		
"<h3>Bienvenido a la interface web de Wordtrans.</h3>
<p class=\"parrafo2\">El funcionamiento es muy 
  simple, sencillamente teclea la palabra que deseas buscar. Si seleccionas el 
  enlace <i>bsqueda avanzada</i> tendrs acceso a ms opciones, aunque solo 
  tendr efecto con los diccionarios <i>i2e</i> y <i>de-en</i>.</p>
<p class=\"parrafo2\">Es muy aconsejable que actives 
  las cookies en tu navegador, ya que de este modo las consultas sern 
  memorizadas.</p>
<p class=\"parrafo2\">Esta pgina todava 
  es muy simple, as que no esperes grandes cosas.</p>
<p class=\"parrafo2\">Esta interfaz web, como 
  el resto del wordtrans, est bajo licencia GPL.</p>
		<hr>
<p align=\"center\"><span class=\"littletext\">
  &copy; 2001-2002 Ricardo Villalba <br>
  &copy;2002 GDISEC Group</span></p>"
);
		break;

		case "fr": 

echo to_utf8(		
"<h3>Bienvenue  l'interface web de Wordtrans.</h3>
<p class=\"parrafo2\">L'utilisation de l'interface est trs 
  simple: il suffit de taper le mot que vous cherchez.

</p>
<p class=\"parrafo2\">
Si vous cliquez sur le lien <i>recherche avance</i>, vous aurez accs  
plus d'options mais elles ne seront effectives que 
pour les dictionnaires <i>i2e</i> et <i>de-en</i>.</p>
<p class=\"parrafo2\">Il est fortement conseill d'activer les
  cookies dans le navigateur afin d'accler les rponses.</p>
<p class=\"parrafo2\">Cette interface est trs simple. N'en attendez pas
  des merveilles.</p>
<p class=\"parrafo2\">Cette interface, ainsi que le reste de 
wordtrans, est sous license GPL.</p>
		<hr>
<p align=\"center\"><span class=\"littletext\">
  &copy; 2001-2002 Ricardo Villalba <br>
  &copy;2002 GDISEC Group</span></p>"
);
		break;

		case "el" :

echo to_utf8(
"<h3>   web  Wordtrans.</h3>
<p class=\"parrafo2\">    , 
          .   
  <i> </i>      ,     
      <i>i2e</i> y <i>de-en</i>.</p>
<p class=\"parrafo2\">    
  cookies  browser ,      
  .</p>
<p class=\"parrafo2\">        , 
      ..</p>
<p class=\"parrafo2\">   web,   
    wordtrans,      GPL.</p>
                <hr>
<p align=\"center\"><span class=\"littletext\">
  &copy; 2001-2002 Ricardo Villalba <br>
  &copy;2002 GDISEC Group</span></p>", "ISO-8859-7"
);
		break;
 

		default:
		?>
		
<h3>Welcome to the Wordtrans Web Interface.</h3>
		<p class="parrafo2">The use of this interface is very easy, just type 
		the word you want to look for. 

		If you click on the link <i>advenced search</i> 
		you'll have access to some more options, but they will only work 
		with the <i>i2e</i> and <i>de-en</i> dictionaries.</p>

		<p class="parrafo2">It's strongly advisable to have the cookies of your browser activated, 
		so the queries will be faster.</p>

		<p class="parrafo2">This interface is still a lot simple, so don't expect great things.</p>

		<p class="parrafo2">
		This web interface, as the rest of wordtrans, is under the 
		GPL.</p>
		<hr>
<p align="center"><span class="littletext">
 &copy; 2001-2002 Ricardo Villalba <br>
 &copy;2002 GDISEC Group</span></p>
		<?
	}
}

?>
