NUMUINT [0-9]+
NUMF    [0-9]+(\.[0-9]+)?
SPACE   [ \t\n]+

%option noyywrap
%option yylineno

%{
struct FloatExpr;
#include "wiplcexpr-yacc.h"
%}

%%

{ 

"<<"      { return SHL;   }
">>"      { return SHR;   }

{NUMUINT} { yylval.nuintconst=atoi(yytext);	   
	    return UINTCONST;
	 }

{NUMF}   { yylval.nfloatconst=0;
	   sscanf(yytext,"%f",&yylval.nfloatconst);
           return FLOATCONST;
         }
	 
{SPACE}

.        { return yytext[0]; }
}
