/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Google Inc.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Seth Spitzer <sspitzer@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function run_test() {
  do_test_pending();

  let exceptionCaught = false;
  try {
    PlacesUtils.favicons.setAndLoadFaviconForPage(
      null, uri("http://www.mozilla.com/favicon.ico"), false
    );
  } catch (ex) {
    exceptionCaught = true;
  }
  do_check_true(exceptionCaught, "should throw because page param is null");

  exceptionCaught = false;
  try {
    PlacesUtils.favicons.setAndLoadFaviconForPage(
      uri("http://www.mozilla.com"), null, false
    );
    do_throw("should throw because favicon param is null");
  } catch (ex) {
    exceptionCaught = true;
  }
  do_check_true(exceptionCaught, "should throw because page param is null");

  PlacesUtils.favicons.setAndLoadFaviconForPage(
    uri("http://www.google.com"), uri("http://www.google.com/favicon.ico"),
    false, continue_test
  );
}

function continue_test(aFaviconData) {
  do_test_finished();
}
