/* Definition for OSS drivers : wine multimedia system
 *
 * Copyright 1999 Eric Pouech
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WINE_CONFIG_H
# error You must include config.h to use this header
#endif

#if defined(HAVE_SYS_SOUNDCARD_H)
# include <sys/soundcard.h>
#elif defined(HAVE_MACHINE_SOUNDCARD_H)
# include <machine/soundcard.h>
#elif defined(HAVE_SOUNDCARD_H)
# include <soundcard.h>
#endif

#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

/* check for one of the Open Sound System specific SNDCTL_ defines */
#ifdef SNDCTL_DSP_STEREO
# define HAVE_OSS
#endif

LRESULT OSS_WaveInit(void);
LRESULT OSS_WaveExit(void);

LRESULT OSS_MidiInit(void);
LRESULT OSS_MidiExit(void);

LRESULT OSS_MixerInit(void);
LRESULT OSS_MixerExit(void);

LRESULT OSS_AuxInit(void);
LRESULT OSS_AuxExit(void);
