/*
 * Copyright 1999 Sylvain St-Germain
 * Copyright 2002 Andriy Palamarchuk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "resource.h"

#define KEY_MAX_LEN             1024

#define REG_FORMAT_5 1
#define REG_FORMAT_4 2

#define NOT_ENOUGH_MEMORY          1

#define CHECK_ENOUGH_MEMORY(p) \
if (!(p)) \
{ \
    output_message(STRING_OUT_OF_MEMORY, __FILE__, __LINE__); \
    exit(NOT_ENOUGH_MEMORY); \
}

void __cdecl output_message(unsigned int id, ...);
void __cdecl error_exit(unsigned int id, ...);

BOOL export_registry_key(WCHAR *file_name, WCHAR *reg_key_name, DWORD format);
BOOL import_registry_file(FILE *in);
void delete_registry_key(WCHAR *reg_key_name);
CHAR* GetMultiByteString(const WCHAR* strW);
