/*
 * DIB driver tests.
 *
 * Copyright 2011 Huw Davies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdarg.h>
#include <stdio.h>
#include <math.h>

#include "windef.h"
#include "winbase.h"
#include "wingdi.h"
#include "winuser.h"
#include "wincrypt.h"
#include "mmsystem.h" /* DIBINDEX */

#include "wine/test.h"

static HCRYPTPROV crypt_prov;
static BOOL (WINAPI *pGdiAlphaBlend)(HDC,int,int,int,int,HDC,int,int,int,int,BLENDFUNCTION);
static BOOL (WINAPI *pGdiGradientFill)(HDC,TRIVERTEX*,ULONG,void*,ULONG,ULONG);
static DWORD (WINAPI *pSetLayout)(HDC hdc, DWORD layout);

static const DWORD rop3[256] =
{
    0x000042, 0x010289, 0x020C89, 0x0300AA, 0x040C88, 0x0500A9, 0x060865, 0x0702C5,
    0x080F08, 0x090245, 0x0A0329, 0x0B0B2A, 0x0C0324, 0x0D0B25, 0x0E08A5, 0x0F0001,
    0x100C85, 0x1100A6, 0x120868, 0x1302C8, 0x140869, 0x1502C9, 0x165CCA, 0x171D54,
    0x180D59, 0x191CC8, 0x1A06C5, 0x1B0768, 0x1C06CA, 0x1D0766, 0x1E01A5, 0x1F0385,
    0x200F09, 0x210248, 0x220326, 0x230B24, 0x240D55, 0x251CC5, 0x2606C8, 0x271868,
    0x280369, 0x2916CA, 0x2A0CC9, 0x2B1D58, 0x2C0784, 0x2D060A, 0x2E064A, 0x2F0E2A,
    0x30032A, 0x310B28, 0x320688, 0x330008, 0x3406C4, 0x351864, 0x3601A8, 0x370388,
    0x38078A, 0x390604, 0x3A0644, 0x3B0E24, 0x3C004A, 0x3D18A4, 0x3E1B24, 0x3F00EA,
    0x400F0A, 0x410249, 0x420D5D, 0x431CC4, 0x440328, 0x450B29, 0x4606C6, 0x47076A,
    0x480368, 0x4916C5, 0x4A0789, 0x4B0605, 0x4C0CC8, 0x4D1954, 0x4E0645, 0x4F0E25,
    0x500325, 0x510B26, 0x5206C9, 0x530764, 0x5408A9, 0x550009, 0x5601A9, 0x570389,
    0x580785, 0x590609, 0x5A0049, 0x5B18A9, 0x5C0649, 0x5D0E29, 0x5E1B29, 0x5F00E9,
    0x600365, 0x6116C6, 0x620786, 0x630608, 0x640788, 0x650606, 0x660046, 0x6718A8,
    0x6858A6, 0x690145, 0x6A01E9, 0x6B178A, 0x6C01E8, 0x6D1785, 0x6E1E28, 0x6F0C65,
    0x700CC5, 0x711D5C, 0x720648, 0x730E28, 0x740646, 0x750E26, 0x761B28, 0x7700E6,
    0x7801E5, 0x791786, 0x7A1E29, 0x7B0C68, 0x7C1E24, 0x7D0C69, 0x7E0955, 0x7F03C9,
    0x8003E9, 0x810975, 0x820C49, 0x831E04, 0x840C48, 0x851E05, 0x8617A6, 0x8701C5,
    0x8800C6, 0x891B08, 0x8A0E06, 0x8B0666, 0x8C0E08, 0x8D0668, 0x8E1D7C, 0x8F0CE5,
    0x900C45, 0x911E08, 0x9217A9, 0x9301C4, 0x9417AA, 0x9501C9, 0x960169, 0x97588A,
    0x981888, 0x990066, 0x9A0709, 0x9B07A8, 0x9C0704, 0x9D07A6, 0x9E16E6, 0x9F0345,
    0xA000C9, 0xA11B05, 0xA20E09, 0xA30669, 0xA41885, 0xA50065, 0xA60706, 0xA707A5,
    0xA803A9, 0xA90189, 0xAA0029, 0xAB0889, 0xAC0744, 0xAD06E9, 0xAE0B06, 0xAF0229,
    0xB00E05, 0xB10665, 0xB21974, 0xB30CE8, 0xB4070A, 0xB507A9, 0xB616E9, 0xB70348,
    0xB8074A, 0xB906E6, 0xBA0B09, 0xBB0226, 0xBC1CE4, 0xBD0D7D, 0xBE0269, 0xBF08C9,
    0xC000CA, 0xC11B04, 0xC21884, 0xC3006A, 0xC40E04, 0xC50664, 0xC60708, 0xC707AA,
    0xC803A8, 0xC90184, 0xCA0749, 0xCB06E4, 0xCC0020, 0xCD0888, 0xCE0B08, 0xCF0224,
    0xD00E0A, 0xD1066A, 0xD20705, 0xD307A4, 0xD41D78, 0xD50CE9, 0xD616EA, 0xD70349,
    0xD80745, 0xD906E8, 0xDA1CE9, 0xDB0D75, 0xDC0B04, 0xDD0228, 0xDE0268, 0xDF08C8,
    0xE003A5, 0xE10185, 0xE20746, 0xE306EA, 0xE40748, 0xE506E5, 0xE61CE8, 0xE70D79,
    0xE81D74, 0xE95CE6, 0xEA02E9, 0xEB0849, 0xEC02E8, 0xED0848, 0xEE0086, 0xEF0A08,
    0xF00021, 0xF10885, 0xF20B05, 0xF3022A, 0xF40B0A, 0xF50225, 0xF60265, 0xF708C5,
    0xF802E5, 0xF90845, 0xFA0089, 0xFB0A09, 0xFC008A, 0xFD0A0A, 0xFE02A9, 0xFF0062
};

static inline BOOL rop_uses_src(DWORD rop)
{
    return (((rop & 0xcc0000) >> 2) != (rop & 0x330000));
}

static const char *sha1_graphics_a8r8g8b8[] =
{
    "a3cadd34d95d3d5cc23344f69aab1c2e55935fcf",
    "2426172d9e8fec27d9228088f382ef3c93717da9",
    "9e8f27ca952cdba01dbf25d07c34e86a7820c012",
    "664fac17803859a4015c6ae29e5538e314d5c827",
    "17b2c177bdce5e94433574a928bda5c94a8cdfa5",
    "fe6cc678fb13a3ead67839481bf22348adc69f52",
    "d51bd330cec510cdccf5394328bd8e5411901e9e",
    "df4aebf98d91f11be560dd232123b3ae327303d7",
    "f2af53dd073a09b1031d0032d28da35c82adc566",
    "eb5a963a6f7b25533ddfb8915e70865d037bd156",
    "c387917268455017aa0b28bed73aa6554044bbb3",
    "dcae44fee010dbf7a107797a503923fd8b1abe2e",
    "6c530622a025d872a642e8f950867884d7b136cb",
    "7c07d91b8f68fb31821701b3dcb96de018bf0c66",
    "b2261353decda2712b83538ab434a49ce21f3172",
    "35f731c0f6356b8f30651bb3cbe0d922c49deba5",
    "9b9874c1c1d92afa554137e191d34ea33acc322f",
    "c311dd74325e8cebfc8529a6d24a6fa4ecb7137e",
    "d7398de15b2837a58a62a701ca1b3384625afec4",
    "a78b28472bb7ff480ddedd06b9cf2daa775fa7ae",
    "5246ef357e7317b9d141a3294d300c195da76cb7",
    "87f6b6a19f021ca5912d285e14ce2ff9474d79f3",
    "3d8244b665ecdb104087bad171b0b0f83545133c",
    "e2a8eef4aeda3a0f6c950075acba38f1f9e0814d",
    "8b66f14d51ecdeea12bc993302bb9b7d3ec085a1",
    "7da9dd3d40d44d92deb9883fb7110443c2d5769a",
    "e358efb1c11172e40855de620bdb8a8e545cd790",
    "9e0c2596c6ecb4f1bc97b18ec3ca493d37626608",
    "58806549380c964e7a53ad54821d2eb86fa5b9ce",
    "7fc30d3058c235ce39088de0a598b8c7fe7ca61f",
    "52a6c769c227f2bb1949097c4c87fed5ee0cbcb1",
    "8a010d4c5af51fcc34d51be3197878782bdf63e7",
    "c84c2c33e22eb7e5c4a2faad3b3b99a359d77528",
    "41bcc1f57c60bdec3c4d1e749084a12867f91224",
    "94645300d6eb51020a7ef8261dee2941cd51b5df",
    "c56f5bdc9cac4f0bc81c33295d9aed8eaf4cb1f2",
    "21cdfde38ac7edbb241ec83d82f31286e90c4629",
    "1fd2f4dcb62f8522171872e43fd4a35041d68100",
    "68c18db6abfda626cab12d198298d4c39264bfbc",
    "6b59ae6c20749020ad43175e05110dc33b6a59b5",
    "39c31de73aafcfcadf0bf414da4495be9de54417",
    "132949f59bfeb88dc2047e6eaecb8512aea3d9ab",
    "f6a6d765bf23726329f96020ba8c5e3c0897aafa",
    "a7aa311cdc6137f15b9ef9cb1a92ac54ec02f058",
    "e71d6bb9bd38eea5719f8ba57177997910e2d841",
    "3d2ccbe51408232a04769546b1bdd74f84558a41",
    "a1fe9aa885584a0f713d7c6f76c89830fbf28563",
    "d7085333becdec7759a5229e5fe9ba1e11db0c22",
    "aaf62842bb98d8a2945c4f643baf50afaeea9307",
    "287b2f2f2fb5a1d7ee4a29b43342103d78a7a8ab",
    "d7dd4700f49808541bba99244b7eb5840e0a2439",
    "af99228aa4cfbd1f61bd824db046144a3c6c2ed7",
    "568f87f0194ca19b69a5b2bcdef795d89c5721ce",
    "a37810f46dee8741fe5adbb3f1f2e87012ffc929",
    "50a09678c49c208f71d40452daca5411279aa674",
    "e462052a03dbe4ec3814db7700e166d00d4d686f",
    "a27917d4db49ce77989fae246015aeb2a28520ee",
    "657514a4ca1f2b6ca7a125ad58dfed82099a37d1",
    "5e0549fdcf0fc7c50054dccc51d37fc734ab8134",
    "eca1998a4d79fb81b2a4103f79e3b846a864eaaf",
    "e4acfcf2d001fbc431d9af59ab3d3ca7c2d965e5",
    "2b3198bd5c0a87db5dab13df8bbe14363d02acec",
    "f115ef8392ba82d8cd6e7a039320edcd812c1d28",
    "aebb1b3baa4fd5213bf80a5ad7a50d54de8fdba4",
    "f451a05f699ac3bbe155d059e7871a2636887b5f",
    "5dca709c60e0cd50fa85274a2836aec9eb6168e3",
    "dccaef62738ff90da4554a85d8cb846d6436799e",
    "cc4e1372ddf6e303a7fd159090c9d3a1f8ec2a89",
    NULL
};

static const char *sha1_graphics_a8r8g8b8_bitfields[] =
{
    "a3cadd34d95d3d5cc23344f69aab1c2e55935fcf",
    "2426172d9e8fec27d9228088f382ef3c93717da9",
    "9e8f27ca952cdba01dbf25d07c34e86a7820c012",
    "664fac17803859a4015c6ae29e5538e314d5c827",
    "17b2c177bdce5e94433574a928bda5c94a8cdfa5",
    "fe6cc678fb13a3ead67839481bf22348adc69f52",
    "d51bd330cec510cdccf5394328bd8e5411901e9e",
    "df4aebf98d91f11be560dd232123b3ae327303d7",
    "f2af53dd073a09b1031d0032d28da35c82adc566",
    "eb5a963a6f7b25533ddfb8915e70865d037bd156",
    "c387917268455017aa0b28bed73aa6554044bbb3",
    "dcae44fee010dbf7a107797a503923fd8b1abe2e",
    "6c530622a025d872a642e8f950867884d7b136cb",
    "7c07d91b8f68fb31821701b3dcb96de018bf0c66",
    "b2261353decda2712b83538ab434a49ce21f3172",
    "35f731c0f6356b8f30651bb3cbe0d922c49deba5",
    "9b9874c1c1d92afa554137e191d34ea33acc322f",
    "c311dd74325e8cebfc8529a6d24a6fa4ecb7137e",
    "d7398de15b2837a58a62a701ca1b3384625afec4",
    "a78b28472bb7ff480ddedd06b9cf2daa775fa7ae",
    "5246ef357e7317b9d141a3294d300c195da76cb7",
    "87f6b6a19f021ca5912d285e14ce2ff9474d79f3",
    "3d8244b665ecdb104087bad171b0b0f83545133c",
    "e2a8eef4aeda3a0f6c950075acba38f1f9e0814d",
    "8b66f14d51ecdeea12bc993302bb9b7d3ec085a1",
    "7da9dd3d40d44d92deb9883fb7110443c2d5769a",
    "e358efb1c11172e40855de620bdb8a8e545cd790",
    "9e0c2596c6ecb4f1bc97b18ec3ca493d37626608",
    "58806549380c964e7a53ad54821d2eb86fa5b9ce",
    "7fc30d3058c235ce39088de0a598b8c7fe7ca61f",
    "52a6c769c227f2bb1949097c4c87fed5ee0cbcb1",
    "8a010d4c5af51fcc34d51be3197878782bdf63e7",
    "c84c2c33e22eb7e5c4a2faad3b3b99a359d77528",
    "41bcc1f57c60bdec3c4d1e749084a12867f91224",
    "94645300d6eb51020a7ef8261dee2941cd51b5df",
    "c56f5bdc9cac4f0bc81c33295d9aed8eaf4cb1f2",
    "21cdfde38ac7edbb241ec83d82f31286e90c4629",
    "1fd2f4dcb62f8522171872e43fd4a35041d68100",
    "68c18db6abfda626cab12d198298d4c39264bfbc",
    "6b59ae6c20749020ad43175e05110dc33b6a59b5",
    "39c31de73aafcfcadf0bf414da4495be9de54417",
    "132949f59bfeb88dc2047e6eaecb8512aea3d9ab",
    "f6a6d765bf23726329f96020ba8c5e3c0897aafa",
    "a7aa311cdc6137f15b9ef9cb1a92ac54ec02f058",
    "e71d6bb9bd38eea5719f8ba57177997910e2d841",
    "3d2ccbe51408232a04769546b1bdd74f84558a41",
    "a1fe9aa885584a0f713d7c6f76c89830fbf28563",
    "d7085333becdec7759a5229e5fe9ba1e11db0c22",
    "aaf62842bb98d8a2945c4f643baf50afaeea9307",
    "287b2f2f2fb5a1d7ee4a29b43342103d78a7a8ab",
    "d7dd4700f49808541bba99244b7eb5840e0a2439",
    "af99228aa4cfbd1f61bd824db046144a3c6c2ed7",
    "568f87f0194ca19b69a5b2bcdef795d89c5721ce",
    "a37810f46dee8741fe5adbb3f1f2e87012ffc929",
    "50a09678c49c208f71d40452daca5411279aa674",
    "0cda6b3297003b3ccd6d5baa17e1ca9bb7c56f08",
    "b2c8e1ebb9435031fe068442f479d1304096e79f",
    "657514a4ca1f2b6ca7a125ad58dfed82099a37d1",
    "5e0549fdcf0fc7c50054dccc51d37fc734ab8134",
    "eca1998a4d79fb81b2a4103f79e3b846a864eaaf",
    "e4acfcf2d001fbc431d9af59ab3d3ca7c2d965e5",
    "e4f110504dd3e4e34f960a39ba91a91c67bf26af",
    "f115ef8392ba82d8cd6e7a039320edcd812c1d28",
    "aebb1b3baa4fd5213bf80a5ad7a50d54de8fdba4",
    "f451a05f699ac3bbe155d059e7871a2636887b5f",
    "5dca709c60e0cd50fa85274a2836aec9eb6168e3",
    "dccaef62738ff90da4554a85d8cb846d6436799e",
    "cc4e1372ddf6e303a7fd159090c9d3a1f8ec2a89",
    NULL
};

static const char *sha1_graphics_a8b8g8r8[] =
{
    "a3cadd34d95d3d5cc23344f69aab1c2e55935fcf",
    "e0bc877697093ed440e125154e247ca9d65e933c",
    "c6d7faf5a502299f99d59eef3f7650bd63dbe108",
    "9d8c05c3ebd786e7d052418e905a80a64bf7853d",
    "3da12af0a810fd993fa3dbe23328a4fcd2b6c92a",
    "b91c8f21cc4d7994abc551feff5b6927d267a9db",
    "d49dd2c6a37e975b6dc3d201ccc217a788b30284",
    "ca6753f9eb44529cf8c67cd6abcd4ed1ef758904",
    "18c3ae944e0afb6c43c21cde093ddb22a27611e4",
    "b753ebb39d90210cc717f57b53dd439f7de6b077",
    "38c017dd1fff26b492a57e09f3ce2c4370faf225",
    "94368cea5033b435454daa56d55546310675131e",
    "bf57a6a37fb107d29ed3d45695919887abcb7902",
    "3db0f8bcca3d94920aa57be6321202b8c3c08822",
    "1f1fc165a4dae7ba118ddccb58a279bfe3876b0a",
    "8e09abb108e137c99527ab4c9bd07d95b9254bbb",
    "b0178632775d29bec2b16de7b9b8287115c40d0f",
    "ca7e859647b9498b53fdd92543ad8aea98ff46f3",
    "3369889a67d6c79a24ee15f7d14374f9995215e4",
    "473a1fd07df800c87a5d3286b642ace10c61c6af",
    "10cd25a0ed5cd8f978d7d68236f81d949b938e84",
    "b8951d2b20518fd129e5113a5f429626893913bf",
    "e81fc45962f861d53f420e29cb5d33faf5adbec8",
    "4851c5b7d5bc18590e787c0c218a592ef504e738",
    "9aa506e3df33e0d5298755aa4144e10eb4b5adcf",
    "abdf003699364fe45fab7dc61e67c606d0063b40",
    "89abaadff4e68c738cf9251c51e3609564843381",
    "f6aa3f907f620b9f3493f03cb3b4b292df3a9545",
    "77d0ad32938147aa4038c1eced232b7b5a5f88f3",
    "43d36e57b702ce56eb250bf53f1ecc4680990cfe",
    "fd6e0ebb52710ebcdd8dd69931165c83c4930b41",
    "71b9756fdfeedce1e6db201176d21a981b881662",
    "5319528d9af750c172ae62ee85ddb2eaef73b193",
    "b7ce8aa3c328eedaed7306234ed9bae67708e627",
    "19b32a0daa91201725b5e13820c343d0a84ff698",
    "abca6a80a99b05722d2d87ce2a8b94ef1ae549e1",
    "2ba70994d0b4ce87fdf6fbc33ada11252178061e",
    "7b4e1d47a03e2cec236d8fb6e2ae89d8ed078f79",
    "075c4cb50e2cf96ab5d132c9f7bb1c1deb4735bd",
    "8566c1110ab5cb8f754787b47923c8bff38f790c",
    "89e90d6159d59886bbbf0c40a7cd01293c3cfda3",
    "3a598f1eb35c1412b0c131e9d9e36a4aef9534d2",
    "d01071c44259adc94b89978b7d51a058b6dad665",
    "e6d33b106bcda374e662d338c57a457dbcaa108a",
    "27ef47377e88f5ac5ad33b19eae27d56c456ac65",
    "339908a568f384e1f384a3e1b0dd415779203b02",
    "88fd743d00bd37d2ed722092146795b044d08a6e",
    "c0537ec24147e74939219213d864ee113cad9967",
    "118bf4c5bddc206ba737f7aa8b239940cd1aadc2",
    "7cb51f6c5f1dae926601986c934533df5f8baa9f",
    "86c84cc8306975edecc6d4a89a8aff29f59b55a7",
    "af99228aa4cfbd1f61bd824db046144a3c6c2ed7",
    "25675c30adfe24d6cae60793b156dfdaa36ac3ba",
    "849d4abf4b690128a5f70e9b8ac78f20c437de06",
    "e768fc9f3167ef3144a4cfb1e20126a577f7dd5b",
    "87f57a31253a38dbf3dc3070473328fa04b68a48",
    "db64cc4d830fc35ed170b53943e722b2342954d4",
    "9988ceca44dafbee247aece1f027c06c27c01652",
    "d80d45a97bc877b50ba2c3f720d5197f2f1c5fc5",
    "b76e0724496e471b01ef8b34f8beba69f5bde261",
    "34201d3d3583f89ce3267d3d0c4e01c64463de4b",
    "693f5c5fbaeaadb5928d34b035499626fecb8394",
    "8a9aa84c42dedc3e681191a1229846887ed262ec",
    "66041875232f64dbfd2d18353aa28e43e8ccb6b5",
    "707bc44fc9fed68ff1f537f0473e0cd825dd660f",
    "f19f5d8e2c96328f06f3985d02ff474fa37b1ea8",
    "175a7bcb73c74eceecc000657a0100bccf158ff4",
    "d26eeb6b2d345b587d4305a1234ec0842a96d4b6",
    NULL
};

static const char *sha1_graphics_r10g10b10[] =
{
    "a3cadd34d95d3d5cc23344f69aab1c2e55935fcf",
    "b340b5d4750dd3dcd95d73c41b2c3a17f799210b",
    "b1db68f35022c5fd43519ec8e98047e16bc4fff8",
    "6e1902eb24865e74066fa9f2a7a49e6f9154f62f",
    "35df9f4b0965fedf7bca36aa4f17b0fa20e2cd03",
    "5652e1feb7d4f22c8a2721fd141157e0b9ef965e",
    "22d89d5933f8b9bd60e9b22e42e7f5659269b63d",
    "0ad27de0c916c073d0d18484fff899bbdb258db7",
    "7c05ee5a01dad1e187537701a95382f0a3ec28dc",
    "b00f0b4448be722d1a19ffe33aaaac4df848d397",
    "7e5ce5c05a54e83890f022ba4e9853e4b254bf0c",
    "2986b431a0022153e5f875da77cc792e3825ebd5",
    "ca4b25a5459885ce1e0a36844612087893d425b1",
    "181bd4616796d89174cedc0332fb320b65aeb0e2",
    "6c417b1798ee319eeb404efe4aa136ed7ed37966",
    "9a9f83e2035aa591d18101c919d1fd5b3456b46c",
    "74ce9f5658cd8aeae4601fe72fcef07d9f75ec26",
    "536eaaa901d652805a8977ecb2dc73f651094c5b",
    "b8b1ac11bcc7174c5b23c18cc7919d09a04255c2",
    "92cddcabf5365eef1e037f488af52b31669d987f",
    "2c9c4f27bade080a2cd6f9160422762e267c2f5f",
    "c7ce29d189dc06ba57e64f0cc32202f5a25ba48d",
    "717778cc9ab30bcfc026a4344ea1bdef870bd247",
    "7ac4cb547c8f4ce5079c95afad9d0e2b0cd76a0e",
    "d578210815e27fe210eb678a71e6d22ba4b4c196",
    "c7a027c7079dfcc831ca8bc134a509958273073c",
    "19cf978596195b848df8709aaf637f83f92b8336",
    "798a835fe50156eeb478c0a6085b088f53409d52",
    "86ddf268d854f37e5b478c48792b551b57635db6",
    "8259d388e02542207b6a08d65d553871ce1c4a09",
    "faea73ff9436223f8c4ee76ac9861a6609ac4ae4",
    "66f8d78d4971934794478afee28b3a50e97f1b82",
    "b8f16334bdced439e1c6fc69704bc95f7b46b147",
    "63798fb175afef78fa8fe8133d9de97a0cc80651",
    "5f629ab51719dd0ca5a67d880eb2631f5b598a7b",
    "1ceb85697f649a62b1753438daa14944af7f450c",
    "98ce4dbc04eb48fa0f96ef813db5b4dfa1b2dd39",
    "3addb9ccd8f56fc0825f61b1b5af67d3297f4ded",
    "f00bac7e18827cfb264fae2e8a0da17b9db18d52",
    "63c1c6c63e82f3b8bd977a1381b248e05321394d",
    "ada202d2f526f6995f83412479891c1764b66e5a",
    "68348e8f54883f4fe295354b024e291c85f1038f",
    "07f55f85a5bb70de5841ea4f62a9af3d29d3d94b",
    "e9167564031ead3459eee6a3ebb2f58f100d931f",
    "d39315a1399639f6d4305a342c9ccf02a463b0dd",
    "46196f50297260df2863e2fa76d2dfcf72006c23",
    "0790585dfaef94f912b1ee81477d4ac448708708",
    "589fb8a85d924ad19ed78409ae89475ba479c30a",
    "43d67bc61ef54014b022891e5c024fc24b1fe797",
    "e8783644428b637adbe80bcd084a33428cb69983",
    "fc0c32afb719295f28bcfef22803bef94f798e20",
    "36f6db4fbe2a1630a7597d3a446f2902755c96ef",
    "d3f08946300e1700865042aed121870e292d1095",
    "4782df8e24127e66a434b4e839adebf2dbb223fb",
    "739707cc85ca63e0580c79618dc0bb8a4a338d95",
    "8ea5d7e4bebc40a1d91b04b12e1c11a42c188095",
    "317521e576801acaea62c76fe16813cdfe20f4ad",
    "ce0fc29bb0281d6c955d64e239254ef9e6dbc06d",
    "5ab49e7b61eddd3bab4182f362a38e1ab6a5a3b7",
    "555b6f04ba8dec9e2a60693dcaac594227052727",
    "c199b96a71c3aab2d49ccb5b6294bf14eb0dd1eb",
    "4238fe9d296b5c72b0a8745cc761f308605b2094",
    "943dc6033ab335a6a63e666f70a6bb3a0677e157",
    "88b6427cf71a6b9a26bfd6026103d50f721651a9",
    "88cfa7b7c1487f8eda05fce92b622942c9fb7ca4",
    "64cf929548bc5324fb14b053077bf5bc4be3e15c",
    "ad91dde8566dceaadc3523cdc8149cd7415a1b70",
    "1936661eee8073068506131c9e89265b2f8403e8",
    NULL
};

static const char *sha1_graphics_r6g6b6[] =
{
    "a3cadd34d95d3d5cc23344f69aab1c2e55935fcf",
    "a1adb32e70188a00f82fe58156b4da74f3ef7a0a",
    "5b9dab3d8411afb25fbbeba0313db526815ac189",
    "6415f551e28e1b38b2d721f0a9e003b7d215f6b2",
    "2028d1b0d1acef35dc07027135023f35fb9746b9",
    "378713720dcb5aadb730435ad0989a68ab189114",
    "084152773feb01a85df6006f2f4f288a1442d37a",
    "97b824953f60fc9a91028045baacbe7b7dc82b14",
    "f33b1931f392bd09b3494efc23cf7d0ed3071014",
    "287d755448e72e29e4812193e2b6f8098a214d82",
    "4059d295aa05ace77853d7ee3d74305cdcbec9f5",
    "2557ebd4fdacc0e5bcce3dae88a46dd247654ea1",
    "e51bcf80211cd06e7d10225534b7a79b5454be27",
    "9bf91a547f47b29bf370e9b60eae7cd6ce987617",
    "0b94e0a5b739ab0020130646522e53da35a149ad",
    "eab6e532845dfd5dc2701ef90669a5f7b63e9539",
    "90deb2e2502186b3c62a58ec9b1c9d2b7b4089c1",
    "a4e451f76a77bbc3e224a41e9b4fa78cb841a8af",
    "084607a5c99a84140d93db57d1b0f3a0f51afdac",
    "2128157e601ef0d6b3636b7387d3b28e876de728",
    "8bdcdcd463f0052279d070ac763757f4db975483",
    "9ea0ad22d7b61598fe36e9c942242e8e07e32edb",
    "8b6452ebd1f6d189d10ee6647e7704821559cfcb",
    "c39a25a61c4eade48dea62a97c9fb8714c06a8af",
    "66b130f83381957cfc4763558c5f5cddf2e3b564",
    "d548135ce2320499277ce12b80bc35004f8a9787",
    "85a4f3f1b4b0a170198f1bb5d225fcf77887665e",
    "1906ddfd829e735af49245171f8eb7673295d399",
    "971a0b786d5bccb1bfb9cbb054740e4eb36f9b7a",
    "e2896035f178b3d20e4f4d1accb1b3d1b4028865",
    "defd95a10d44cad6e736542920b74efd53e9e7eb",
    "eaccd012c0fc46e79cae1997ef101979e5654d8d",
    "3f11a735e52030aa3d0f024d83803698293d10e5",
    "82f45c5a34fbb9e36d947a876834d33a1f69719c",
    "3d27002f4fe3c943468b7e3ef6985962c41ac8dc",
    "3231c4d87faefb7ec5bd377613969c05b70343fc",
    "00394e438e9edde978e88602c9ad2a572e965bf6",
    "e760be69cb37c7be35d5968d7a294e1fd49d4f66",
    "996fb708ddc4b94eb8d1585bd83a5c8a1e2633ba",
    "caa39eb482e8fc2e00f1c6737735c023ac9363ef",
    "c1250ff2b67e6d2a8baccc5c93f8f5ad933c5c4f",
    "3d6cf3753390a05504b1f50302f767df443f0f40",
    "b7cf1bafe002673ae58ff50feea61ee32a1ae10a",
    "da9e896a3a98b330980152b2e4a43cb6e686c730",
    "0a613357e1e8ec8ff1ad956e46e527a05cab8500",
    "bdd8ed3ca3ad107b43731ec253ecaa34750a10de",
    "47499ad13b719de18c59c2bc9b38ed578db50b95",
    "643e82ac67ab2b0c034a3fcfa498b072a5f2be5c",
    "cd01f2c0a63b2229d4467d2f874d58edca32b3d4",
    "94b54f1da5212b3f3a1195eda5ea927e160bc89d",
    "49341c297a887186bd47d7465d827ab3147f05e3",
    "325279e76367200d3fd7194d81c09fd139988ece",
    "c3def160a1e847605ff0fc7edd30397fa90635a0",
    "2b3e87e0b705b03c7c08f403409ab82cce095ba1",
    "45c08e11fffc78b2a3574263419e0cb7f8cd9b45",
    "aecb242c31f31a90f071b6455ea7d808d4ea22e3",
    "77ea86e51a94b11a8081b29696cb4115687843e3",
    "d67b897cad72d31e75359094007b1346fd8806ea",
    "442bcf4d94a649c9406c3b0bf2f00cb7c6a4d1d4",
    "3d0853f4f7580d7cd5148c21c34d878ecf39a5f3",
    "1e5a4ef7f8634847a251d1fcce298c409fd13d87",
    "481337fbedf181d4324bf7f8299b0327197ff468",
    "9ab957870fa4e17aec6a79bc1a4fdb42a5ffcc30",
    "b4b9f0bf127ef11f510f25684ae21d692609c85e",
    "8e32ea3614c3b20899d748db48258761c7158d2b",
    "5da35bad12e3e9b26a0444d30820099481281e45",
    "94f004e98ae8035af948611770a4a2dd6643f510",
    "045ddaf752e7ffc7ded792f36af3c7c0cfeeae42",
    NULL
};

static const char *sha1_graphics_24[] =
{
    "e993b15c9bd14fb45a15310450b7083c44e42665",
    "edbd7bab3d957fbc85e89612197cf918f5f5af20",
    "6a7efb3b6e0b49336df1bd2937ca09a11d976531",
    "236eb5ca9da70ec7cc719cd2fd291bab14000257",
    "f98023c7cd8c068f2d7a77ce3600004b90ea12d6",
    "5c4cb9cea2226fc671bb4a11f8253343ee94bb4b",
    "fd4be592483623dbc800fe28210a1f0daa71999b",
    "788b8de98c47974fa9f232a6042ae4ca546ddb7d",
    "a8772e6c44ba633fb384a7c4b50b435f1406107e",
    "883bc8f305c602edca785e21cd00f488583fb13f",
    "3bac4e80993f49dc3926e30524115fca9d7a8026",
    "91369e35be29059a0665782541db4c8b324c6bb2",
    "0fa8cf332a56bb6d7e14e85861fdd60f51d70501",
    "593d694cdcc8349b3bfc8257041dbcb27e61da45",
    "1036b91d93e31cd1d4740d0c8642e115e5a38188",
    "1898073cdb35ca4d2b21bba933ac16a0b4297317",
    "5068bff794553cf5a3145ae407c9a2984357844c",
    "413a7989969c229dee4ab1798362f32f96cf0a10",
    "0bb222e540b82720d4971e4a2fc626899af03e03",
    "adc20832d8c43f1cf372d8392535492013cd2306",
    "45649794dcbcabda487f66f7a80fc1bec79047a1",
    "367c2dc1e91ff9ea0e984d6fb3000cfb4e0ae7e9",
    "9c6afd47dd748a33c585e6655fd4ec1c28976a47",
    "b4df692ac70a5f9f303270df4641ab014c6cbf46",
    "8bc3128ba47891366fd7b02fde7ca19100e64b9f",
    "e649e00efe7fea1eb8b17f7867fe089e5270c44b",
    "a0bffbbfb0adf6f188479c88da04e25d76ab4822",
    "92a1ab214dd8027c407814420449119466c92840",
    "b58f19c1800344a2b8e017eb784705bdb2bd8450",
    "5747a6d5c6ce79731c55e8cf33f7da3025cd35fd",
    "955390669afed2369b15b32fa519f2f921cdf1a0",
    "201906f7d763b930a98c97f8eeab417f2b65e723",
    "5313357d50c40c05a3b3a83d0d2013a138c955a1",
    "701c5af1d0c28294ce7d804b5697643c430d22a0",
    "b0a959745b2db1d9f449e68e4479a4f36301879c",
    "63f764b9bd2f4876ab1ee0f3c0eb55b5a7de5212",
    "e171f6ec77bca91d6b8559911bce296c0bac469e",
    "9725669042ef68acb408404d196496d10340bb5a",
    "26e7e1c300ba0c5aaaef03eeb71d529f6def9289",
    "b1f602d2a74095cc0115ae2ae07b642498e6c0fc",
    "03d5eb8e3a6662e6dc183f88ee2f285065fc9c51",
    "f4c312f9a37ddc54a27f6b1421dab1ce0cec0c27",
    "0f79500eda467cd3cbc220abdd37b5dba695d654",
    "8d4e3e9d81cc30aaad555ed9e27aed7c615de630",
    "84c43a3cbd7d8c1ac9a0e9b6f07620158079b278",
    "7d479beeb6758c164566638b5c873c188d6a91e7",
    "80086808fca03e757d812e31d1ae576bf90dac9d",
    "9560096f1b85ae6d939d736165c44df00a47c424",
    "1015e0217ea13eaa62c7666b8b81aafd75f8f610",
    "93e1aec608e037af3bfb7bd32dde446abe4eea11",
    "b25ba91487ec945410deb2b51bc1156890c032a8",
    "d347ca5c6c4b6a61389247c3b6f61564033e8c25",
    "ee315634ed92da3a32c2675ecd1b369471c60936",
    "099c688a920f606655b485e8f0a433dc811bc976",
    "9c044a733335bca43766bda2b317249309155079",
    "354b92008a8409c62d0fa1dff1532c5943aa37a2",
    "8dc9cb7deae5c24d1eae004d53893fa6caf4723c",
    "cf311a96d41bd98fdbdfb5dfaac4ba1ba9b7d6da",
    "bf5ec23456efe00e1e0931c17de9040ab2092858",
    "0bbdf0a0489428f96e3c1d3e5305f9a893820852",
    "9d86b1b2bbce90efd3c0b9fe20d23ffa3eeecd20",
    "8f7a0af421101952e674f37154c1e8c4646ea2d2",
    "e96b79bf88988b5694a04dfc3bd0029361b39801",
    "d12284f58daabbd173dfae6c7e55fd5d822d89b4",
    "09cb4ab070083144bed4271c0a2a34ccb6ed13c0",
    "cc5ed4c9e925f0a457a7437fbb8054528cdd9469",
    "c95afd0a020e68a76982fe8663b5d64113987233",
    "48658ff76c137185c56a53f3ccf0e958d0296742",
    NULL
};

static const char *sha1_graphics_r5g5b5[] =
{
    "2a2ab8b3c019e70b788ade028b0e9e53ffc529ae",
    "847005cf7371f511bcc837251cde07b1796f6113",
    "a8f75743a930843ec14d516cd048b6e0468e5d89",
    "d094f51ce9b9daa9c1d9594ea88be2a2db651459",
    "cf3928e240c9149788e1635b115a4e5baea0dd8f",
    "a9034a905daa91757b4f63345c0e40638cd53ca8",
    "15ee915d989e49bb9bab5b834d8f355bd067cd8f",
    "99474fecf11df7b7035c35be6b8b697be9889418",
    "cbc2898717f97ebb07c0c7cc04abde936dc5b584",
    "29c896b591fdf4ddd23e5c0da1818c37e4686d94",
    "4b5b275d33c1ebfe5bdc61df2ad125e865b800fa",
    "92df731fa1f89550d9d4f7ea36c13f2e57c4b02a",
    "420e39ff3bdd04c4b6cc2c98e99cb7993c7a0de5",
    "1fabf0fdd046857b1974e31c1c1764fa9d1a762f",
    "449092689226a1172b6086ba1181d6b6d6499f26",
    "1a92a60f190d33ef06d9decb56fd3fdd33f3af03",
    "e61f5978c2e28c0c6d8f5eefe0f840c975586efc",
    "897d16f4d6a6ddad685d23ed7828d4f676539b75",
    "9d21bcfdeaf1ca5d47eb823bdefc24d7a95f4f56",
    "6daaf945a955928c5c124c880522ca4634fb2343",
    "12a288390d16e1efa99d4185301de48a4d433b14",
    "ea92af2538b76f41a3a03eaa11ac395c9b6197c4",
    "1d3af561605fd61433035600d8962cb8d266fdd0",
    "3a50ce21b3563a604b4fc9f247a30f5a981f1ba6",
    "d7d97e28ed316f6596c737eb83baa5948d86b673",
    "ecc2991277d7314f55b00e0f284ae3703aeef81e",
    "656bf3b7121bcd620a0a3ad488f0d66604824577",
    "d7d8493b5fa7a3a8323d6ac84245093a79f052c1",
    "df5dafe96e528c2cc7fd11e4934e298f53cec34b",
    "a49530722328ae88fd765792ac0c657efbcce75d",
    "aa46aa2226e3121eaefa9d0836418e0b69262d69",
    "333f3f2cf3ff15736d59f92a33c45323d3987d6d",
    "a6fd83542c3826132e88d3f5e304d604c0056fad",
    "a8d6a5285a927ba3a3be34b06a06c70a20d4c1b3",
    "e428d213ad02651287894f093413949dcb369208",
    "7df915bedcc5951a1b6f828490f7dbb93212e835",
    "645dc251d205139282b17eb7bece1055fff3bcd0",
    "76215275593631f5900aad3616d725733dc39493",
    "81655a550703849a616d4a16504bb9c6f999285f",
    "573d65665d20f00d36d9782ae2b89772140524ab",
    "619414c1b33ac60cb0c0de61df86245d472259b0",
    "c3d4a1425e17de9e05e3f6dfc6a24c26bfd5ee12",
    "2a66dae03890ff791eabb982949435adb19af02b",
    "24ac219478ba406f30794550690486b14cbac5e8",
    "2b28d20690dc92374ebecb5508f8fdc6c7581790",
    "db8c34882ddd46716d14bbf569d530f80db65ed4",
    "6c652ecce55e71fee16bc1c9b2c5ae4161bdd2ea",
    "9b02173f424c098ea0f4cc5db9eb65f69263d127",
    "a92942269911a88793b3460b6f2a2cd56e48eec1",
    "059db9f0426b371e464ef3d30f1a4f4aa599e101",
    "a52d6ceee5c2a04b4e059c0d49337a997cc17e40",
    "aa4a0a4b7f2697aaf270c89874631974bd9d7183",
    "585061e403d9cac1603a38af420efe87338f381a",
    "8f447a3820c83662086dfa836da2205b0130fd5f",
    "3772003c7fb420003512d0c437b3659d96d89ce4",
    "dab47c9dc149e570045d699598b14a613bf319b3",
    "2daca4d26a086ed34894693be0b0374402232809",
    "904f1d82159bcf5485f323bd12b859dc5e83f8eb",
    "5bd29f94844351e9a5bd01f25d85608b9b0701b2",
    "295ec16530126046790fb734e99f86f5b3b74ed8",
    "d98b0561010606b55a1b9b85fbc93640f681d256",
    "1c1499051860b7caa25173b328ca9c862f01dd1a",
    "a655512753bc90e6d4eb3848f69e96db1ad348e5",
    "2230f36f12d4becb242e2962fa1b3694db2496ca",
    "d81e41a765d7a2d68073f5fde3f74f09df84001d",
    "0de013c2c6aba9f99cbcf5f8cfd3212ded7ae72a",
    "5950f7d00cd8692872377df0e869a7d5ea5e4420",
    "fedc67d1b0797be5f40cd45280844f2b61d29b0a",
    "7de23c68ca224818fdf127c5e96729dcd0de2b8b",
    "a848b1b0293b05b3f9358a3ffcb21a2e5fdecf05",
    "1a0fd0df17fa4c455a4a91cad30b5242f77fd233",
    "af45bf81d119be5cf6845ad41191ba52637e65e9",
    NULL
};

static const char *sha1_graphics_r4g4b4[] =
{
    "2a2ab8b3c019e70b788ade028b0e9e53ffc529ae",
    "cfa0ab83ee93283ad914c3748f0532da1697af1d",
    "8bd18697d1ef27492805667a0bc956343ac08667",
    "e8501c830321584474654f90e40eaf27dc21e6a8",
    "d95ab10fcfb8447b41742e89f1ae8cd297a32fc4",
    "821177710961d2cb5f7e7dfc0e06e767b6042753",
    "667124365ffadeea1d8791bedda77a0c7b898de8",
    "c9f23e684b600dea17575b4b17175fbd9106c3a9",
    "7678876e50eae35d1eaa096aae25afaa0b864bf3",
    "fb52b0c373a5f2a60b981604b120962942d2447a",
    "5ab8dd07436681d762fa04ad7c6d71291c488924",
    "0167981d9e1490a2ebd396ff7582f0943aa8e1b8",
    "115a6bd382410a4a1d3c1fa71d8bf02536863e38",
    "65c6d1228e3b6d63d42647f14217bc1658b70d9a",
    "25fcb75aa687aac35b8f72640889fe92413e00c5",
    "3bddf9d53e89560b083302b146cd33791b13d941",
    "a81504498c7a7bb46340ce74476a42f70f2730b1",
    "e61a4f2657a444d8c49f84fb944f9f847667bf2b",
    "32b6e0aa79b7e96cd0ab2da167f6463c011023a8",
    "1d283aa4d2b2114f7809fe59357d590c7c779aa7",
    "29640e2ddd2d3016da14507c3ce9b2ce32f39bb4",
    "57ebf8becac1524543da120e88e9cc57ecfdec49",
    "e68ef3ffd7401244cdea79781eab12d7a5e8ca18",
    "d591232bbc2592462c819a9486750f64180518fd",
    "0e183a4c30b3da345129cffe33fe0fc593d8666b",
    "f14d9a4bd8a365b7c8f068a0dad481b6eb2b178b",
    "8933450132bf949ba4bc28626968425b5ed2867d",
    "9928a8f28a66c00069a124f7171b248817005763",
    "e4a9dcc3e565cd3a6b7087dd1433f3898bb9cdb2",
    "eca4f9b16b3bddfd0735fdd792e0ccaadfb9ba49",
    "233e588cf660e2c9b552cf02065cf63fa6655864",
    "0740ff74dcd259d9a644ba51ad77ff0d40348951",
    "a3345acaf272f2e288626906e3056cd0ced70499",
    "957a86fbe8a96dd068db65e4e624a52bcc84af46",
    "13b0f240054dc57ba0e2dfde74048496304a2c7f",
    "51ef267eb9c15487c9430f505e8a6c929eb2170c",
    "1b593d8e031d3b37fecf6f1df5a8f96c8e8bfef8",
    "9dd123938b0a02601d8d458ecbd6535ddefea724",
    "815a1e4fc7f3a00c2990c150e87eba0b13f66811",
    "75ae8c80af4356a1a5eebde6608fbc31e8a95372",
    "b89ae8de2d975b8adb263ace66fd953d29165a8b",
    "e901ab4b20bc87370609d7ba1f21aa08abd9eced",
    "e9105c6ed8355519e0cf2d2217ed7af43cec8ba0",
    "3cbf5fffdd73f9639f3eb34ec1ab3055bc8618fb",
    "8e2e70ade90711c4ac01352aa0373fce36ff5dc0",
    "8c40d6d8e0c696c31f04c896e492a2a38703d870",
    "e13c821c236ea0b67cca64c9da7be15e88fc712f",
    "9af4907a8144458a73dbb7471784f8c3d9aeffcf",
    "e4731b63d41f6b51e30752ea52d85c4a2938731b",
    "f0acb3cfcda62e95bee5f7bc8830ffeb3dd7e5a7",
    "07b10c3f191d0a93e5e5694aae37dcad407e10f5",
    "f7900e60347029876ba55e8f0c4c02e89deb36b6",
    "f373a5f37b82e7523c64c08eb509b6191e49b173",
    "9f0760a05190c9edf9ce2e8be6aaa5557601fe91",
    "7587a9c87cab1eca827807f351bb67ca184d1ac5",
    "b53ef0b5c674822e784903a9dbdd3b386d9f2350",
    "5505d2ed20dc61ffe48832ecf5329162a5ceb734",
    "9f72be4467219a345b1164205d1fbfda2d64271e",
    "13d1634e03bc49cfe14a32278d9b1f5ddbb9be10",
    "a79e4cc419b9e1735e275e2823da52875536943a",
    "b0182002cb1f4fba9df3c21a4d046ab41ce7e9be",
    "3830cd728c1e72837310940bcdac4e294d6c9843",
    "f571c7c4aac92491017963032194690c0fa06b42",
    "6fd751b7328c02954bce98bed94b3ce3c73db118",
    "91d50b5a604d6c38aa0d08b9af995490f8ec246b",
    "8585783d0373e9696b508776b6e6b18a80b09888",
    "b53cde47b0e28063770d3b1328c3cc2f774a6300",
    NULL
};

static const char *sha1_graphics_8_color[] =
{
    "41728d7ff2bb425b5fc06521adeabf6cc73136f3",
    "e313bb57f699587b0bae2f17f5da5d977e6f2a61",
    "49024d6cbdf1614327dfda9eda17675e76805f7e",
    "63ba8ab7e7996857d52d4c2b995cfcd304daf25f",
    "92295ae66712df050cfd6cc9fd2fd4101784c5fc",
    "84d85009d35ae10abbc435f3913422544105cea2",
    "eae349c2a481d6e8bfdf9a7f4f49384a14716a5f",
    "6c51068ca1db36d948eaa34aed4a44d2cd1e8b32",
    "f3aa8d89430748178952de56643069d80b40aad6",
    "bd5fed74e2f1b097ef4c20bd30edfc6ee11eeccd",
    "0546b87bf5fbe1b8168eed5d4a20649be92734a1",
    "52b1363e821bf604d9df260bfa97e26d428c33fd",
    "108732d9909ee5f3542a9b90b3ad96ec82446ab9",
    "06c76c53dcf3ba5e213d483e27d841404c9aa90a",
    "ae8fcdbdd44ba58e9bd46a4c56eb54f37483913c",
    "89711289be6d5c55734878410e4923d5cca9aca9",
    "8355caf57d51ad4e14275943088392e37dc75d33",
    "5992b2e331a0e0f752598cc8d083cbecb5f4dde6",
    "6f0570da9dea7f043f678088f8362ee458cd79fa",
    "940db409d4c3e5640275724f9e5f7c1a0d2e21b2",
    "242ce86967ea62fa69c1e6f597ccbcf2f0b1602c",
    "5092b22af85a08f10a2899888bb9d552f25f828e",
    "f5dafef807237fe72c74c0bbd47c382ace45bfde",
    "e91973be2651eeef568700463652838d8cbba976",
    "1df851515ecf46df5c2d3279535c1763f72353dd",
    "b68922915ebc2797d58deecf983f7d0cf9a5efbd",
    "359bd76088a965bb0cee7c44800bc46b2638807e",
    "e14e5734b33057b890368f3e9d482d9e5a0358c5",
    "64205ccaa277e64eeea0c20e99900ac79858ca2c",
    "2cdee35d43d62da09b4ddfddbd0948ddbb9fc48e",
    "91f988f575338505ba8a40727865a8d3f2298624",
    "d2b4557492ebb2e0f640a0a2f6fc3bdc8d8f36f9",
    "421e8b608378e4f17774dd32ea6446fa0fa16f91",
    "3b7488731da48635d86be551ab7c8c0f91c78219",
    "4fd49cb49853ef950fd0b7e2e35718a71c8374c7",
    "e15a355fc09bfd22267917898e2266168ff410e3",
    "b9688566bddf18586787c00e68724e51e97dfb72",
    "5e38e03310f1c66f2052af2a745d8c60515707c5",
    "f994fb5019bf4c1a96eccf89af599eae0aa6b412",
    "3a71ad6fef147067641e49a5f69b2454e3a5010d",
    "ea10eac72830dcae19bcb16a076c2b21d844b5b6",
    "6376234f542467e5887adfece62f753e998dc19d",
    "add949d009217ef2b847e34772ba363e4be7b1b8",
    "28fcf9f7d098c05de632ae38b2fe33b9635ad445",
    "0b58666deb3615e912896a764e5c6475989e95e4",
    "bf460cc44c0edee851d72587c8425c3f06a62c55",
    "ea74c00c45569007383b632d7f1d2adc82645717",
    "5ac22e1a33b0204fdc7a68d54ee94648e96079a0",
    "284abed096637c80bb50844e393da9dd4b3f19ac",
    "9dc776c5ab8256b1301c7d1da60544a9410e6715",
    "a433c41c05b6db008a4cb2c52a321d027c6be1fe",
    "46f772c2832b3aad584674db666bd63e48b4f338",
    "a9f9ca0049235db51ab7359a5fc3d21be42d2aac",
    "f3dc739da41fb299637c8660e8c46917ddcf87a8",
    "eae47bf865d932f22a6e59b6fe8d041f220e1fbc",
    "9ae38bb94c7b4c0c6dfebbee23d1de4db9b77488",
    "678979a45126a76eb629992cd64734862f53a555",
    "2f7ba8803604c032cb1a1228bc021f0f1c03e245",
    "52e7c2f8b01592898c13f1e7633881e350244209",
    "d9d5556b77301952b4caf113337720966bc8e1f5",
    "e58d9c0acf0219d0839e1dbd162e08a765ed7f0f",
    "34ca0f9660e1889f9f2c0deb80535d3c4f349fa4",
    "2c07272462c68cf5944b03e2aa049475b99143c5",
    "07ca369fb875d37b9cf855045f528af1827edec4",
    "5e9e3e71b06c5efe20f93b3838e745b40b878471",
    "153ae5c9fc2a31b38c4878b25d9026b9f51f132d",
    "488341e88810d737de0b26de4e4d4fa0e78eb482",
    "bd1e7f40e3971e2ff6c5561286901193a1557527",
    "5a42b7eeff8198e7b005e4afa4282e6ffb939906",
    "d7ffa3893c6fa937569791cf49986518a4a4d96e",
    "26bc25a011e2b60961ee9d6c6141d928ae24389b",
    "8771d5ff7b93b9dd9d077e672b342235dfb28472",
    "6a1f6e1d494bf6b0ece7af5fa164ebaadb3a19bd",
    NULL
};

static const char *sha1_graphics_8_grayscale[] =
{
    "41728d7ff2bb425b5fc06521adeabf6cc73136f3",
    "df35491dd5038187c05bac06921402ba6d7773a8",
    "c8cd6d34e011d5f9ca4b1190eec3b416e5e68e53",
    "66a686ac22cd0ec326f2c97ef473781cabe9690b",
    "9bddef7b97b8b03569f07011e66ddd67fe82d787",
    "2a4cea20974bcfb92cf40b05746fc7eb465c4b0f",
    "0a87689ca33f888f05dbfa21ddec11c069990d8b",
    "8d0a92e6333e1b99591962e2def9bc9121111cf5",
    "409c9f29f6fa2e312c8e0b4b3c59acb4d84d8717",
    "1fbc234c28a8140965ad0fe30b4b799f6681e864",
    "1fc709d5d3e55d5f96c451c209cd73c59dbfe733",
    "96b6a32e057d5faeae57086cbb62a8e7b3e6e86f",
    "aa66ea7c9b7214339858b9fc9bd4720d05e8c843",
    "114bb377b4e78a1978e1ac09388c48861b5223a3",
    "8d0a92e6333e1b99591962e2def9bc9121111cf5",
    "9dc511d6947fe816185cdff93bf0cfe0349b72b4",
    "eb4c14ee66b012187f5fe6a2ec28b6be956567c8",
    "216388ddf6b563dd2058a9df65b40b6f72df1715",
    "ad11e4b6979cf055e3bf1868112a7bef207385a4",
    "47f72be971bd2d3399dabd018201f4f5075e96fe",
    "de09d41c9ae4338fbfcfe9f8ed71d343537a6f3d",
    "f39ab890a2b99d0c31e6e047f2315244972f5ffd",
    "6e7baf7d328bc2c55366e32967a0db4d2f43ab82",
    "15b991814d84d6aa252696dd0c6150ef88a8db3f",
    "1cb52f2a4d17b9b0d8375d016aa8cf0677fcd29a",
    "9a6cfd68523e40ea1d52847d7747da912cfe2ca9",
    "b6785a410048bb85e7ea3f0492459972103c935e",
    "82e641ebe47d9f8cc229b82b8315e69e52f812b1",
    "15db343049e3a9b31addc5d2ffebc3fe91b39c51",
    "a895daf1f20371d4d1c3f93c070124cc13e341c3",
    "3ddc872384ed8f9eaef472aa14a1d79a2c3f3b04",
    "0000000000000000000000000000000000000000",
    "bd7d8c1cb4b2adc31cf8c7d39a4fa1e3ac7f2545",
    "33fc8618ce62f5cdd9e06ad61e296f718a99899e",
    "dcaa7fe030ae4d3029e38ca584047eeb2d17fe10",
    "6d41e6168662e75baacf74d911d7419d54c8d73c",
    "2404952157ba1519094a2da6bfbf2b0f1356432d",
    "24caede65b40815a60b83c4edfa06bdc542388cd",
    "650a51bedd1af92469d2950eb95220db35f95c6e",
    "3f43aa11e6fccb747cc13224583fb2f951fee08c",
    "04cea9753b575ecce8e55357eddfcec10ddfbbea",
    "6b6f4b97f05e015eb37a5f6aff637235feacd030",
    "1bd06e4e11929e5e91c3c9f20def639b20e731e8",
    "d63a6086547e90d2ba84aaebfeae24f3ba0c04f1",
    "85425940daf119125deb52421b2057acebe6d1cf",
    "a3db92382cf0a4c7cafe52c27b1f41520aaa677d",
    "9869b6f088822fb423996f9968e5a931301fc2c3",
    "cdf63ab4ab32c2e8e27527a9588d0fb525f1c945",
    "a7f81cf3326fa3608acc13cfce2f573912e9d745",
    "f2ea92f523f8918b1d514a2d9555dcb4750273b4",
    "e9c16e43a8f589ae85289c5c3ffea6b22fba1806",
    "84a4bc0c2c5d36d016da4df95a5d8d6c8ce3ba6f",
    "f543efc84e638afbaa456e629100f0274de1a35b",
    "1bd2587399006eed0d46beff397d32081f6bc58e",
    "f8a571de89ed82ffb9cbc041ce1eacb064be2853",
    "640a49455acabca6954a7fbb6af4e872af342d11",
    "589e7911e09332ee090371deae17b0120ff990b5",
    "a1a941fa270cda48c648553ed4b427e16e96f8e0",
    "f30a8d9f73ca043c5bfc18d9595e299fc0a39eec",
    "fb63bbb2f944fb63ed2d7399f07b168740c1034b",
    "3685c9ae95118a83db3569832c29753276fa1264",
    "09640bad951c33e7d70a1fced83b1869f65b3fc5",
    "5eb00252664ec39e61359adb1dade4906a87a248",
    "ee7b9b292ea9fb559ef5ebf6a2a5586d38c7f854",
    "dcad1a146c1d0ec2c4cc7f64bd4f45c57a604bfe",
    "0ca8775d9a61ccc251d1e6f2e3cfd26a24ae24a2",
    "17ae603c199a5d6695d198a7f36e6d7263990951",
    "1918a33f59d3500204ffc573318a39e9ff754221",
    "5449d1aef0d2d6af9ac3fd7adb32c23ddc9be1e2",
    "55d302ece31a9b7fc4be4a07a53767ba210273e7",
    "a6a29836291f9dbca85e25cee60f62ef5faca6d7",
    "3494a23633405e46af96cb57715617fef1ac252e",
    "5a3ae1da30d83cc157e6a4a5617c85598309f4ac",
    "edc1ad2704452354aa6f79fac244a55b6f509c2e",
    "87eab8f81fb2a036080e099760f628037f9306e7",
    "a3eac75d30f681b3898ee469d368960529634d7d",
    "cd5caeabdb71241766d24f038cfc5f1e91e11256",
    "e2b393dc3f5833f7868668ea31369e90348768cd",
    NULL
};

static const char *sha1_graphics_8[] =
{
    "41728d7ff2bb425b5fc06521adeabf6cc73136f3",
    "512246d4886ab889a090b167ba194577cb95272e",
    "921e852d4564cb9e5ac15ff68b5207bebea871d1",
    "9636b0ebefc443ea11949ccd28f6ca454277dd41",
    "aa9050da55e6b6957c60b7d603fce539cb5c0048",
    "e2b93aca15fb1233ac09a713dced1f4cd950b1e4",
    "3e3a603fc26cc305aa27f88da7d2a3b0073877d8",
    "390b2bf70daba36310683f46af9cd50b9a061396",
    "82d21737e9a7247397a6c983a9b6d9a0452dd74d",
    "2a8460af91675e01cbe9384eb6cd3eb2cb420960",
    "1af53b1218ee9844fcda891b836d42f6b2f66bd5",
    "da1cc34a9d9b779fc7849e03e214096026506464",
    "5ba8f99ca034666effa556748c49a0f5a015125f",
    "b67ba2f55659c75ac72c1112494461bb3086e1a4",
    "73e2859ce849f756f954718ce3c90f02e31712b6",
    "b1dff0f5dd233b44ee568878c5d3f8ae1d80c6d9",
    "1f27dc1a1316fb7a4a78fe40fcd4bdae3aaad218",
    "6e375e1485a1e45ac6ab10af49645d5fb2e76dff",
    "cfc67c325c7cdf96d90af9b3cceb8d0504cbb3b0",
    "7262364067e03c7fa498af1d59d228d6c63b460e",
    "5241241a355a667ef0834049adf4218e8b3f16b8",
    "db22d666690948eb966f75b796c72c7150a5c4b9",
    "af21fb2645b568b049549de375584c4aa3055143",
    "1f13ea0034db4b0ffa4ddcff9664fd892058f9cd",
    "3caf512cfddfd463d0750cfe3cadb58548eb2ae8",
    "4e5e7d5fd64818b2b3d3e793c88f603b699d2f0f",
    "c4efce8f7ed2d380ea5dc6fe1ef8448a27827532",
    "bdc0a354635b879871077c5b712570e469863c99",
    "d599bf210423fe3adbb4f1de87d9360de97827d0",
    "bae7c8b789e4e9b336c03c4daee3bce63fe039d9",
    "cc01f17928f7780cefd423ea653b072eea723a1b",
    "c005662a47f14c2f1b7c7fb3b0ef0fc390c6ea6a",
    "675cde16a6ad2bcd8d7e72780b07a0ccd8d0393a",
    "ea39ac62ca2f815a1d029340c6465994b6f03cb0",
    "9a603513cd81acf70cf8b27b0d544e7f672e9d40",
    "f4a334e69535de74ee5ed54be93a75120a66e54a",
    "559fd1d15447745527c61fe43a94c6708bff3e39",
    "995f77f2f53398399f09d1365cb4dfd105764e5c",
    "61907a6685bba93077da40cfb28cf2ab74552fd2",
    "122015e5e17c1c317c6e51c0e207826b606a4077",
    "c21851589a5f8a45ea5f9bb3e72f4f88d0a6697d",
    "8c609921d4a3ed89a994a75482b27496bf103cf5",
    "eb2ce16a6ae251f4965135ee776776b5fc02c42c",
    "66493ee117719e172f327a426af601996025f28c",
    "acead2745fec0b6c817fa601353bdf2d197b64f7",
    "a6b858b2d125c159529d3f3ec45b31925a79acff",
    "1f1379089d7c6e8d733aaa4eaffbe02db6255b61",
    "d83adc669c0dea0dc4812b93f998514b6f02d805",
    "9e8ceb7c3cd68e043b6d875c8c84a1e394962412",
    "9e996fc74eeef53f0a6c31aabb2edce6e103f189",
    "6b8abd1785304d6531c1e4cc65c1ffcdcb2196a5",
    "7d1bfff706b0713e53209407889f83a0da26a81d",
    "31e667c2dbb81dcf81d01cb88f794e88ddb90ff2",
    "31e667c2dbb81dcf81d01cb88f794e88ddb90ff2",
    "465d9cd0a77ab4fcf035aa67544b2a26269e0b09",
    "600d6b2713d5e4c0d90c02660245ed26c7ae3033",
    "0025a440866a404523a8a20e79a8891e45a2ff56",
    "c04d335933895f836f0a28c1e3f7f444352c3b8e",
    "bd28d77cd85b20a2384d6b25082cfd884bba683e",
    "7e591ec8ae9bb61c3a443c93f071cab2b8978394",
    "f81c70b6ee2d4690f9f7c797c66582b176f8dcef",
    "d3f359cac7318ce09e0531d51c8c2b316cf3a23b",
    "293c41a7ed923a4617560481ae8815cebf83701a",
    "ec06b56f3abe277be42650ebd49dabeaae9e756d",
    "750c923785ba2afb9ce597516c072f90f014bf95",
    "80089132f8a11d86e8038f2f8e12dfba46624ee5",
    "bde5a62a065c027561226fbec5155e938ba7f6b3",
    "a6311d74fc058079a327abb536e69353be719925",
    "fbaa8848a1d3896469c37fd43ab44233f5b875a3",
    "0000000000000000000000000000000000000000",
    "c2ac98ef716fd8a5ac8f08ce66293d9a96344337",
    NULL
};

static const char *sha1_graphics_4[] =
{
    "fa867e2976a549ecd3b1fa67df54963232fcef8c",
    "256d742b4da96b373b4fa5663d0ad3b5faab5c8e",
    "d96d8f4232b930bccd53b903b5efaf8c0bdb16f4",
    "9401799e6116c35e5f0e5bdca07ea25316757a72",
    "482ae2b0ef1d64752b5ef11cc7f35a33eb55d07c",
    "dcfb3e01100b41c0f75a1c5f84b6de6b90138281",
    "2505598845fa026ea7187582461efbf06cb6904f",
    "3981a19363beca8f28d32a5928ac296fd22a5296",
    "01404024ebb2c266d17d734059524d874491650f",
    "c87bbff3f83b8ec11bb03cfa9bc9ee5166c4c7ef",
    "f35c5d62853be78c5d39fb2f45200dc262aa8e18",
    "46e94a55f5f58a6b915078d8ffdc725f53aab516",
    "665bbbc749a5ffeedc0d62aef0661a5ce845b017",
    "1f26a01730f67d40ea711a50d9d801bac15a642e",
    "3b53d24178cfacba53103a44dfd5d072b15a6781",
    "c52cfd57f26037723d37192722fc3a217f280c9e",
    "e34da6500cf2e424d980714d92737cf6c31a7bda",
    "d17f4358ae529f920960ed89e535902ee13b0033",
    "0f44e12ecd1ea7e39433890443626d4fc35204a4",
    "eb38683e812fd13dca971ba8f4cfd2b6820d3524",
    "73bbc83f88f1aaa6df0158b63e70bb3165163163",
    "0dc2690a5c58a2907a8ab06693ebfab6698172eb",
    "df5f0d6574bdf1781754b5b9f98232a77e439e33",
    "39c16648cf6c261be71a33cec41867f28e119b94",
    "26ad5116562e7b58c76a26eaf521e2e40899e944",
    "1bcc54eaf8e3c2b7c59ecccb23c240181d7ba8b8",
    "4f827ca6927f15191588456f985bf29d2a3b3c24",
    "e7de769c3d12ea9dd223bef4881c578823bec67e",
    "6fb102d020e5554116feefc8482104f3ae2036d2",
    "ae546ffd30b837afc7dfcb5c9ce4f01d15b35ddc",
    "20c9eb3276c08fdce35755e349bec94b04929812",
    "628d837163a25c6520f19c0602383176dbad528e",
    "b5a12cff7100290ad43f5ed17a321b42de048893",
    "b672afbeeafb44194a821f0def81a8892872937e",
    "db0124045882b598feea192186cf7eb7a0387866",
    "602d91471378fe24a2d0248bd8a92b624f099fea",
    "e772873b87a0f55ea51a3da323f64bf8814c6703",
    "21aa1ff238a2d78efed1aa658ac8fe21b1e64daa",
    "1a579cd280422131c35e907a023ee0e80749b5a4",
    "bbf027f506cbb80d359bf4892fcb75f816f2e446",
    "ed44bded6b17df7fe92b191fd810d1aafbd55f52",
    "a49bcb1ace42d548254d9e96d22088b1fe2e75b4",
    "e2a21a965dfd0bd09f9270917f681610efc18ce7",
    "3e411b004a5be84451860c6da6a4a1a482b77862",
    "3b3d2f18fdc75e938ca43cc2d0b41fa67c1c5d36",
    "7811c536a6527112b438a6413f3927f2c79086a7",
    "525ef3615040225752a2fe646ab99ee64e360630",
    "46760975993f9881b7bbe94123173e6a683d3f25",
    "df5feb905a31c288008cf5e82d73ac818a160d82",
    "df5feb905a31c288008cf5e82d73ac818a160d82",
    "d8af3868c66c7d6dac35ec8ee0317b38a6910bb1",
    "ec8e2aebfb4a1c28ebcd0e053b9e4d8638b50951",
    "ccf8d11b1e81895e9781f17c227c821228d8714b",
    "f751e26578193afe6a727ee2a52318c404c56555",
    "28a6b9f7927e99e53cf46f0333d29168cb10e920",
    "029552113292cc110fd6b7888e766628950aaeef",
    "297f6ad15200bffbf15198324ee8f27a61a6f2d4",
    "70cfa427a1a0d6f2232b1fd544905d48af69cb98",
    "287ea7db721e641439888cb9f4bac3a5f16124eb",
    "dd9eaa5325cdf250e89162ac84207978ebb6458e",
    "42466aab11852741d937c1ff6f3bb711e58415a6",
    "0663cf6330591fcf744aba96664e05d90243d07a",
    "3024fa38333f83a639b0f0e6ac6d4b9868231157",
    "6fe7d0d17b892032cfd171c3d7c365f030b5be38",
    "7ae780dcc7cf04dda50648bfc07cc6a7a2f2189e",
    "0000000000000000000000000000000000000000",
    "9ab46e0c42f82dc73df8a55cbf881abd72397cec",
    NULL
};

static const char *sha1_graphics_4_grayscale[] =
{
    "fa867e2976a549ecd3b1fa67df54963232fcef8c",
    "6611ea6cb24bcf34c5f3688d57e2874aecb39c24",
    "5ab1d3f8f5938c5d20a2fa3237e319077b21e716",
    "1c201d149c0bd886ff8a427ad513f15a70991174",
    "44646e67842a4d055bea1fad0434e6e4a0eb5465",
    "315189097a02024d2eae61d524c4de07a396aee7",
    "73ac786015dea36ac466a6524dba757d5d238ece",
    "6e328cc4d53627f034b23706d8bf26afe18512ae",
    "3c5b90cfeafdc1c99c8c62317d07276fdf66803e",
    "95e6f509bb1cf9981efc47a0878ab0bd983eb349",
    "2e1bc3b00e4ecc62b03785533dc0faeeda38d53f",
    "6448226859cab61a61c95d3ed5ed5f216b1bb120",
    "7f1cb06597b14edbea03b860aec3cebc4ebc3d62",
    "ec3879342b5a44f6de6efe946243ae5ade00980d",
    "6e328cc4d53627f034b23706d8bf26afe18512ae",
    "51b50968a3a0570d5ed690fe44ba1a78a4d62ce2",
    "d5bab61f78ac3355aa2e0776b2d5d9d71d61e77b",
    "fa47c5195405f6a0eefba3e3a60ad463c7ee94c7",
    "b2bda683edef912957845a33edc055902a801fed",
    "b067f0421cb2c83b218b8ab6edbede2ff5723b57",
    "c8de76f9c0900e5f86c7584fe94d5749376b7b49",
    "43ee3e187dda14b86aef12371041ae70313b5a65",
    "7fab79b7f1a5cb2ec31ed8eeaf213b3d8dcde4d8",
    "d4930552a7845111ffd9db57260be1ab97967c06",
    "afdf41fca7951c6dd6193320de1295f2c68fe52a",
    "f2f1f331fe6b1b31d7c9ddd37793b375fc01d3d4",
    "f0af0f1edcb837bdf1535c1f5e9988c21ae9bfd1",
    "0000000000000000000000000000000000000000",
    "71c4577baaf35f12f6707b1e2f78a1e8c0d41d0b",
    "9b7d6b12385bb9e1cd881758aff342bd5427432b",
    "6fdd5aa022da2a8af6f1d02b6072ebc068b4b600",
    "643fab30f1a59dc37f1e0f1a6006076fbf90a5fe",
    "6edbc0b95e9ae3348ce7d12c44f9c8082b5f2aa9",
    "9c0da52c4ceaa8fdfcff7351328dd520bb57e985",
    "f8224430462f6a93f85ef33b8aa7299525990708",
    "1cf93cecc942b41ab8fae21ea18418a6d64873e5",
    "d58b8760ef01c12e691651c932d683c66fde3654",
    "94438c82b8812fe81a69d5d1429c5967cdbfed7a",
    "764ea26f10fe11f7bdb538a26fc33d44b3a95d6d",
    "94ad53c578f6034dfc5c666e363203cdfb00f2cc",
    "8cd7b0ba8426db344b4cb8820890603020ed65e9",
    "ad96132f25ca14e1aeb17c86f8d187febf6401c9",
    "027b05bc82ce4f897c4bf812610a641547368939",
    "3f131e855ba1611d8fb0f16a6979f8f56aacc7f3",
    "ae64d1dc52dcfa8c644f953c4601fa2fbefec37b",
    "2f3fb1bd8f416198d70e06f6d519571cd5eb4ef4",
    "cc96ccaf6b99f60a49b03017515f83cba22b4c40",
    "5eeb56afea8040a8fb18c11f29931b836474126d",
    "a3405c085fc2f2184bcd0d1edcdcc66927e33659",
    "f8681c09f1abfc38d31e47622cb8798cd896a00e",
    "b5ee51cfc73acb59a2f6124509ea236f8fc7f9f7",
    "d374d4d92c940ae42a9b42c14d744341b68a8c14",
    "06a6a224be0f5cdc51ac4704f9f57fc1f3813d6f",
    "c47c2dc806b6b8ff28f300949695d013a46c0083",
    "ada3b7c34946e584dcdf4203e07cfa3dad02bc63",
    "c2f61571b067a44b30f56b4658c9606f0edfc0f3",
    "58f400c9bb78e49a879276fb049edfc9c981740a",
    "cb3794f676d6e9502f27172ac7d79a12ca2ba32c",
    "aa89612798fbc4e11a73b6233c0ac4832e6af2f9",
    "c96a998be5c1d588ef1243cfd2610d056d16947e",
    "68bee638d59a373f33f308751471b3ef41849582",
    "be0501175cc3cbb61217fca76356f761117fb40f",
    "8fa37e26cdae406c2d1c81b1175dcf0311cf60c9",
    "3efe128a5bf250f2c460664e8f543f5ec54d5dc2",
    "2d5123e757cf00e423a89160d7dc4997c3688829",
    "0000000000000000000000000000000000000000",
    "36dfdad9f3f5cfde6add3cef23368c343d30469a",
    NULL
};

static const char *sha1_graphics_1[] =
{
    "23366004515f3bc46796ea505d748f8d0f97fbe1",
    "61ade9054d4477fb89cf830539a5e8b4e45f0688",
    "ac530c5dbaf837e15b2337347e974184fad73643",
    "95fdcda26262d5948a9ade77d83fd698e0031050",
    "1dd5cee06af78d026e5da8bfe3f45e1cf51faa13",
    "f6b61ecf03ad11752775faca1d4404c6bb5065f5",
    "d7ad44d6f377598268e9968333ae2cf23a0715ca",
    "5871339cd7e6cee12d4dc45934a89071c73efe6b",
    "69e9b85b34caf736069ba91e57a5c3fa7c891653",
    "21d5d9e47bb07de2cf7bc99b7725390d03a6cde6",
    "f69ee65ea25676429a28eea79b5b9cb9206b8d01",
    "39ff81f77ef4ee772367ed1a63785987c060126e",
    "4c686508a994ca4c7a0a73b8c0fe52423c180d9c",
    "b0cc1f5e244ae0c0835a9866a46abdfcd56d1cb1",
    "7ddf19df5bbdf4475b6ec1bc042425e382502864",
    "144c9a846e5e37ac6efd5ed3a97ec231479e8fca",
    "c5ffc59048bf786b5646ad6226cd8633965de9ef",
    "40fadc2d24c713b04ff96f7dc26e70e85f26c55e",
    "400a21caa01e015096ee1afcf1b54e7f8ec515bd",
    "0ff4b49797e30e3555aab45219adf449a9a560ff",
    "280327328ca940c212ce24fe72e0b00014072767",
    "144c9a846e5e37ac6efd5ed3a97ec231479e8fca",
    "b85463875f755b85f1464b1b6275912bcbad6c9f",
    "816f200969feecc788b61dfeecf05b1790984401",
    "a4964d8bbf80fe785f906bc0f7c5b113242a58fc",
    "a5d204cc7342d40b765ca042f8668e22601c4ff9",
    "adb2818f6d3845dd140bc0f9abdbaa89d2a8c3de",
    "0a76e0121facb103857130bc6e12185ad77fc3fa",
    "02aede714773d654d0fc2f640afaa133ec718ad5",
    "13cc63972aee4f6ae27091a8af18de01f1d3a5da",
    "3bb745ccb08402ce6fac6ee26fb8d7aad2dba27e",
    "b26699f62661e16a1dc452d24c88ce363a1f2998",
    "4d95c3d1e170f004c80aa8c52feafb8e0e90760e",
    "c14832e69ec3585c15987b3d69d5007236fa9814",
    "e44ea620b0c47125a34193537ab9d219a52ad028",
    "ef2db9fb75a672f69bab88e5d08fe64f50ec2bc4",
    "df81db2a9b3942a82e0dc5e57247b642f9b42702",
    "8819bf7a43295161fe045a42936000b3a51fe200",
    "e08dbc26469c229f75ccbf1a38a133401f270b84",
    "d1e6091caa4482d3142df3b958606c41ebf4698e",
    "07c1116d8286fb665a1005de220eadc3d5999aaf",
    "4afb0649488f6e6f7d3a2b8bf438d82f2c88f4d1",
    "f2fe295317e795a88edd0b2c52618b8cb0e7f2ce",
    "ffc78c075d4be66806f6c59180772d5eed963dc0",
    "c86eeaeed09871dee4b43722ba512d2d3af7f4d0",
    "24b1a6241c81dbb950cfbe5da6798fd59eb36266",
    "1007d3b531b4bc3553d4547bc88443fc1f497cf6",
    "b71ca46be287598f716bb04fac0a52ad139c70db",
    "6589e48498e30ab036fbfe94d73427b2b1238a69",
    "4dce919117d2e41df9f5d4d0de14f97ae650046d",
    "22c2e078f69d73b7a5cb3f7dcbb8fbaa007ef3ac",
    "be36cda370650e6d5fb0570aeb8ced491d0c2b1c",
    "4c34cb8e47f9ff4b4348aa2d40cce7cb54d65cb0",
    "18f4497e43903e8df5b27da4ceebf62b15550a87",
    "3fa3570a2ebd38042b90f24bd3496233bca5a23d",
    "2fcd25c2d19a01fa631fd19135d9f28b26b86259",
    "655cfadeb157233c804d42b58195569c8846e3c1",
    "65c8811c609203fd424f5ed5f92ca2268a1dca54",
    "a45b297d709e297584eb0f2985294ec0ab53d8ad",
    "0d180c37bc26d83a1a11f66168757f3de2493243",
    "b362ba4790def178c236c0ae7b0093dbba47cf24",
    "d1d2ecf71a37d9eda58fa09454aa871971428ace",
    "6672da4e016b6e9de0ca218f8307cce7d48d62c4",
    "ee22f43ea867228c6ff937d39e1826e285a107e8",
    "832c3c3afd056e5d1cdfb2f466f27225c4adcc6c",
    "a2a928de9007d765da496abec8c21b23601f8c45",
    "28ded40e72d4327b9413571476b167fb28a1f420",
    "23366004515f3bc46796ea505d748f8d0f97fbe1",
    "88763f8e8fcf4f78fa864325791a9dd35a0bd279",
    "013cee26bac8f815eadad4bfc012d9b5d01c3b7f",
    "44a28536466dc895feb824b23dfd4a47c6948af8",
    "17468a3789f0a6d65c302bda735a01dc2c1a74d9",
    "781d8c5cbc28591fd48fce06f984c502fdc6b363",
    "df510792a7790cc699532b1420d43c6d4da2ae2f",
    "55c26d22f11d80b73383fa57d0fac552d705b092",
    "14443b33a9879bf829ed3b06e1aef0d7dcf662cc",
    "53ab1fcccd09fa5cbff77497f36a70a3b3cb8b81",
    "4842a30dd7fdf38ddc3ddec85c08efe13a0e2e0b",
    "cc76db6da5ba1776f20240a5ad97a26a9cdf96b0",
    "014f477664a7f4ce4a948d6359a2707119afc8e2",
    "74d01690e344bc22e7a0478e7a09ccd92354c486",
    "9ab50a663b74577b656e9849484a909d7ac52eeb",
    "128eefd2ee043d59dc37918065f687e378e5ca95",
    "d7e2daab98ce1f698c4bfedfc01c0d79fcb76b8e",
    "8d34215487088b5d4ef63062270ce25c2862643d",
    "826562eb11a0d0bba77fa21245f7406a194e9225",
    "bbae6f0659e095a42b420082079663f937065813",
    "bbabe686a6955402c90530e7c67f1428868369b3",
    NULL
};

static const RECT graphics_bounds[] =
{
    { 0, 0, 0, 0 },
    { 10, 3, 219, 101 },
    { 100, 100, 301, 301 },
    { 0, 0, 201, 201 },
    { 10, 10, 110, 320 },
    { 10, 99, 300, 200 },
    { 99, 12, 201, 200 },
    { 90, 110, 300, 200 },
    { 90, 90, 210, 200 },
    { 10, 99, 300, 200 },
    { 10, 99, 300, 200 },
    { 99, 12, 201, 200 },
    { 99, 11, 201, 200 },
    { 90, 110, 300, 200 },
    { 90, 110, 300, 200 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 365, 405 },
    { 10, 10, 350, 251 },
    { 10, 10, 300, 200 },
    { 300, 10, 9, 260 },
    { 10, 10, 435, 405 },
    { 10, 10, 120, 120 },
    { 10, 10, 110, 110 },
    { 10, 10, 120, 110 },
    { 10, 10, 110, 120 },
    { 10, 10, 120, 120 },
    { 10, 10, 110, 110 },
    { 10, 10, 120, 110 },
    { 10, 10, 110, 120 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 50, 50, 306, 306 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 100, 100, 356, 356 },
    { 10, 10, 416, 26 },
    { 10, 8, 60, 104 },
    { 0, 10, 511, 306 },
    { 0, 10, 512, 306 },
    { 1, 1, 300, 512 },
    { 0, 0, 500, 512 },
    { 5, 5, 206, 206 },
    { 45, 45, 256, 256 },
    { 86, 86, 215, 215 },
    { 45, 45, 256, 256 },
    { 8, 0, 392, 231 },
    { 8, 0, 392, 231 },
    { 0, 0, 60, 20 },
    { 0, 0, 512, 512 },
    { -1, -1, -1, -1 }  /* the end */
};

static const char **current_sha1;
static const RECT *current_bounds;
static const char *dst_format;

static inline DWORD get_stride(const BITMAPINFO *bmi)
{
    return ((bmi->bmiHeader.biBitCount * bmi->bmiHeader.biWidth + 31) >> 3) & ~3;
}

static inline DWORD get_dib_size(const BITMAPINFO *bmi)
{
    return get_stride(bmi) * abs(bmi->bmiHeader.biHeight);
}

static char *hash_dib(const BITMAPINFO *bmi, const void *bits)
{
    DWORD dib_size = get_dib_size(bmi);
    HCRYPTHASH hash;
    char *buf;
    BYTE hash_buf[20];
    DWORD hash_size = sizeof(hash_buf);
    int i;
    static const char *hex = "0123456789abcdef";

    if(!crypt_prov) return NULL;

    if(!CryptCreateHash(crypt_prov, CALG_SHA1, 0, 0, &hash)) return NULL;

    CryptHashData(hash, bits, dib_size, 0);

    CryptGetHashParam(hash, HP_HASHVAL, NULL, &hash_size, 0);
    if(hash_size != sizeof(hash_buf)) return NULL;

    CryptGetHashParam(hash, HP_HASHVAL, hash_buf, &hash_size, 0);
    CryptDestroyHash(hash);

    buf = HeapAlloc(GetProcessHeap(), 0, hash_size * 2 + 1);

    for(i = 0; i < hash_size; i++)
    {
        buf[i * 2] = hex[hash_buf[i] >> 4];
        buf[i * 2 + 1] = hex[hash_buf[i] & 0xf];
    }
    buf[i * 2] = '\0';

    return buf;
}

static void reset_bounds( HDC hdc )
{
    current_bounds = graphics_bounds;
    SetBoundsRect( hdc, NULL, DCB_RESET | DCB_ENABLE );
}

static void compare_bounds( HDC hdc, const char *info )
{
    RECT rect;

    GetBoundsRect( hdc, &rect, DCB_RESET );

    if (current_bounds->left == -1 &&
        current_bounds->top == -1 &&
        current_bounds->right == -1 &&
        current_bounds->bottom == -1)
    {
        ok( 0, "missing bounds, got { %d, %d, %d, %d },\n", rect.left, rect.top, rect.right, rect.bottom );
        return;
    }

    ok( !memcmp( current_bounds, &rect, sizeof(RECT) ),
        "%s: %s: expected bounds %d,%d,%d,%d got %d,%d,%d,%d\n", dst_format, info,
        current_bounds->left, current_bounds->top, current_bounds->right, current_bounds->bottom,
        rect.left, rect.top, rect.right, rect.bottom );
    current_bounds++;
}

static void skip_compare( int count )
{
    current_sha1 += count;
    current_bounds++;
}

static void compare_hash_broken_todo(HDC hdc, const BITMAPINFO *bmi, BYTE *bits, const char *info, int num_broken, BOOL todo)
{
    char *hash = hash_dib(bmi, bits);
    BOOL ok_cond;
    int i;

    /* reset the bits for the next test */
    memset( bits, 0xcc, get_dib_size(bmi) );

    if(!hash)
    {
        skip("SHA1 hashing unavailable on this platform\n");
        return;
    }

    for(i = 0; i <= num_broken; i++)
    {
        if(current_sha1[i] == NULL)
        {
            ok(current_sha1[i] != NULL, "missing hash, got \"%s\",\n", hash);
            HeapFree(GetProcessHeap(), 0, hash);
            return;
        }
    }

    ok_cond = !strcmp(hash, *current_sha1);

    for(i = 1; i <= num_broken; i++)
        ok_cond = ok_cond || broken( !strcmp(hash, current_sha1[i]) );

    if(todo)
        todo_wine ok( ok_cond, "%s: %s: expected hash %s got %s\n",
                      dst_format, info, *current_sha1, hash );
    else
        ok( ok_cond, "%s: %s: expected hash %s got %s\n",
            dst_format, info, *current_sha1, hash );

    current_sha1 += num_broken + 1;

    HeapFree(GetProcessHeap(), 0, hash);

    compare_bounds( hdc, info );
}

static void compare_hash(HDC hdc, const BITMAPINFO *bmi, BYTE *bits, const char *info)
{
    compare_hash_broken_todo(hdc, bmi, bits, info, 0, FALSE);
}

static const RECT bias_check[] =
{
    {100, 100, 200, 150},
    {100, 100, 150, 200},
    {100, 100,  50, 200},
    {100, 100,   0, 150},
    {100, 100,   0,  50},
    {100, 100,  50,   0},
    {100, 100, 150,   0},
    {100, 100, 200,  50}
};

static const RECT hline_clips[] =
{
    {120, 120, 140, 120}, /* unclipped */
    {100, 122, 140, 122}, /* l edgecase */
    { 99, 124, 140, 124}, /* l edgecase clipped */
    {120, 126, 200, 126}, /* r edgecase */
    {120, 128, 201, 128}, /* r edgecase clipped */
    { 99, 130, 201, 130}, /* l and r clipped */
    {120, 100, 140, 100}, /* t edgecase */
    {120,  99, 140,  99}, /* t edgecase clipped */
    {120, 199, 140, 199}, /* b edgecase */
    {120, 200, 140, 200}, /* b edgecase clipped */
    {120, 132, 310, 132}, /* inside two clip rects */
    { 10, 134, 101, 134}, /* r end on l edgecase */
    { 10, 136, 100, 136}, /* r end on l edgecase clipped */
    {199, 138, 220, 138}, /* l end on r edgecase */
    {200, 140, 220, 140}  /* l end on r edgecase clipped */
};

static const RECT vline_clips[] =
{
    {120, 120, 120, 140}, /* unclipped */
    {100, 120, 100, 140}, /* l edgecase */
    { 99, 120,  99, 140}, /* l edgecase clipped */
    {199, 120, 199, 140}, /* r edgecase */
    {200, 120, 200, 140}, /* r edgecase clipped */
    {122,  99, 122, 201}, /* t and b clipped */
    {124, 100, 124, 140}, /* t edgecase */
    {126,  99, 126, 140}, /* t edgecase clipped */
    {128, 120, 128, 200}, /* b edgecase */
    {130, 120, 130, 201}, /* b edgecase clipped */
    {132,  12, 132, 140}, /* inside two clip rects */
    {134,  90, 134, 101}, /* b end on t edgecase */
    {136,  90, 136, 100}, /* b end on t edgecase clipped */
    {138, 199, 138, 220}, /* t end on b edgecase */
    {140, 200, 140, 220}  /* t end on b edgecase clipped */
};

static const RECT line_clips[] =
{
    { 90, 110, 310, 120},
    { 90, 120, 295, 130},
    { 90, 190, 110, 240}, /* totally clipped, moving outcodes */
    { 90, 130, 100, 135}, /* totally clipped, end pt on l edge */
    { 90, 132, 101, 137}, /* end pt just inside l edge */
    {200, 140, 210, 141}, /* totally clipped, start pt on r edge */
    {199, 142, 210, 143}  /* start pt just inside r edge */
};

static const RECT wide_lines[] =
{
    {100,  10, 200,  10},
    {100,  21, 200,  21},
    {200,  40, 100,  40},
    {200,  61, 100,  61},
    { 10, 100,  10, 200},
    { 21, 100,  21, 200},
    { 40, 200,  40, 100},
    { 61, 200,  61, 100},
};

static const POINT poly_lines[] =
{
    {100, 100}, {200, 100}, {200, 200}, {100, 200}
};

static const POINT polypoly_lines[] =
{
    {100, 100}, {200, 100}, {200, 100}, {200, 200}
};

static const DWORD polypoly_counts[] =
{
    sizeof(polypoly_lines)/sizeof(polypoly_lines[0])
};

static const RECT patblt_clips[] =
{
    {120, 120, 140, 126}, /* unclipped */
    {100, 130, 140, 136}, /* l edgecase */
    { 99, 140, 140, 146}, /* l edgecase clipped */
    {180, 130, 200, 136}, /* r edgecase */
    {180, 140, 201, 146}, /* r edgecase clipped */
    {120, 100, 130, 110}, /* t edgecase */
    {140,  99, 150, 110}, /* t edgecase clipped */
    {120, 180, 130, 200}, /* b edgecase */
    {140, 180, 150, 201}, /* b edgecase */
    {199, 150, 210, 156}, /* l edge on r edgecase */
    {200, 160, 210, 166}, /* l edge on r edgecase clipped */
    { 90, 150, 101, 156}, /* r edge on l edgecase */
    { 90, 160, 100, 166}, /* r edge on l edgecase clipped */
    {160,  90, 166, 101}, /* b edge on t edgecase */
    {170,  90, 176, 101}, /* b edge on t edgecase clipped */
    {160, 199, 166, 210}, /* t edge on b edgecase */
    {170, 200, 176, 210}, /* t edge on b edgecase clipped */
};

static const RECT rectangles[] =
{
    {10,   11, 100, 101},
    {250, 100, 350,  10},
    {120,  10, 120,  20}, /* zero width */
    {120,  10, 130,  10}, /* zero height */
    {120,  40, 121,  41}, /* 1 x 1 */
    {130,  50, 132,  52}, /* 2 x 2 */
    {140,  60, 143,  63}, /* 3 x 3 */
    {150,  70, 154,  74}, /* 4 x 4 */
    {120,  20, 121,  30}, /* width == 1 */
    {130,  20, 132,  30}, /* width == 2 */
    {140,  20, 143,  30}, /* width == 3 */
    {200,  20, 210,  21}, /* height == 1 */
    {200,  30, 210,  32}, /* height == 2 */
    {200,  40, 210,  43}  /* height == 3 */
};

static const BITMAPINFOHEADER dib_brush_header_8888 = {sizeof(BITMAPINFOHEADER), 16, -16, 1, 32, BI_RGB, 0, 0, 0, 0, 0};
static const BITMAPINFOHEADER dib_brush_header_24   = {sizeof(BITMAPINFOHEADER), 16, -16, 1, 24, BI_RGB, 0, 0, 0, 0, 0};
static const BITMAPINFOHEADER dib_brush_header_555  = {sizeof(BITMAPINFOHEADER), 16, -16, 1, 16, BI_RGB, 0, 0, 0, 0, 0};
static const BITMAPINFOHEADER dib_brush_header_8    = {sizeof(BITMAPINFOHEADER), 16, -16, 1,  8, BI_RGB, 0, 0, 0, 0, 0};
static const BITMAPINFOHEADER dib_brush_header_4    = {sizeof(BITMAPINFOHEADER), 16, -16, 1,  4, BI_RGB, 0, 0, 0, 0, 0};
static const BITMAPINFOHEADER dib_brush_header_1    = {sizeof(BITMAPINFOHEADER), 16, -16, 1,  1, BI_RGB, 0, 0, 0, 0, 0};

static const BYTE rle8_data[20] = { 0x03, 0x02, 0x04, 0xf0, 0x00, 0x00,     /* 2, 2, 2, f0, f0, f0, f0, <eol> */
                                    0x00, 0x03, 0x04, 0x05, 0x06, 0x00,     /* 4, 5, 6, <pad> */
                                    0x00, 0x02, 0x01, 0x02, 0x05, 0x80,     /* dx=1, dy=2, 80, 80, 80, 80, (80) */
                                    0x00, 0x01 };                           /* <eod> */

static const DWORD four_by_four_data[16] = { 0x000000, 0xff0000, 0x00ff00, 0x0000ff,
                                             0xffffff, 0x00ffff, 0xff00ff, 0xffff00,
                                             0x000000, 0xff0000, 0x00ff00, 0x0000ff,
                                             0xffffff, 0x00ffff, 0xff00ff, 0xffff00 };

static const DWORD ddb_brush_bits[8] = { 0x11112222, 0x33334444, 0x55556666, 0x77778888,
                                         0xaaaaaaaa, 0x00000000, 0x98765432, 0xabcdef00 };

static const RGBQUAD default_palette_1[2] =
{
    { 0x00, 0x00, 0x00 }, { 0xff, 0xff, 0xff }
};

static const RGBQUAD default_palette_4[16] =
{
    { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x80 }, { 0x00, 0x80, 0x00 }, { 0x00, 0x80, 0x80 },
    { 0x80, 0x00, 0x00 }, { 0x80, 0x00, 0x80 }, { 0x80, 0x80, 0x00 }, { 0x80, 0x80, 0x80 },
    { 0xc0, 0xc0, 0xc0 }, { 0x00, 0x00, 0xff }, { 0x00, 0xff, 0x00 }, { 0x00, 0xff, 0xff },
    { 0xff, 0x00, 0x00 }, { 0xff, 0x00, 0xff }, { 0xff, 0xff, 0x00 }, { 0xff, 0xff, 0xff },
};

static const RGBQUAD default_palette_8[256] =
{
    { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x80 }, { 0x00, 0x80, 0x00 }, { 0x00, 0x80, 0x80 },
    { 0x80, 0x00, 0x00 }, { 0x80, 0x00, 0x80 }, { 0x80, 0x80, 0x00 }, { 0xc0, 0xc0, 0xc0 },
    { 0xc0, 0xdc, 0xc0 }, { 0xf0, 0xca, 0xa6 }, { 0x00, 0x20, 0x40 }, { 0x00, 0x20, 0x60 },
    { 0x00, 0x20, 0x80 }, { 0x00, 0x20, 0xa0 }, { 0x00, 0x20, 0xc0 }, { 0x00, 0x20, 0xe0 },
    { 0x00, 0x40, 0x00 }, { 0x00, 0x40, 0x20 }, { 0x00, 0x40, 0x40 }, { 0x00, 0x40, 0x60 },
    { 0x00, 0x40, 0x80 }, { 0x00, 0x40, 0xa0 }, { 0x00, 0x40, 0xc0 }, { 0x00, 0x40, 0xe0 },
    { 0x00, 0x60, 0x00 }, { 0x00, 0x60, 0x20 }, { 0x00, 0x60, 0x40 }, { 0x00, 0x60, 0x60 },
    { 0x00, 0x60, 0x80 }, { 0x00, 0x60, 0xa0 }, { 0x00, 0x60, 0xc0 }, { 0x00, 0x60, 0xe0 },
    { 0x00, 0x80, 0x00 }, { 0x00, 0x80, 0x20 }, { 0x00, 0x80, 0x40 }, { 0x00, 0x80, 0x60 },
    { 0x00, 0x80, 0x80 }, { 0x00, 0x80, 0xa0 }, { 0x00, 0x80, 0xc0 }, { 0x00, 0x80, 0xe0 },
    { 0x00, 0xa0, 0x00 }, { 0x00, 0xa0, 0x20 }, { 0x00, 0xa0, 0x40 }, { 0x00, 0xa0, 0x60 },
    { 0x00, 0xa0, 0x80 }, { 0x00, 0xa0, 0xa0 }, { 0x00, 0xa0, 0xc0 }, { 0x00, 0xa0, 0xe0 },
    { 0x00, 0xc0, 0x00 }, { 0x00, 0xc0, 0x20 }, { 0x00, 0xc0, 0x40 }, { 0x00, 0xc0, 0x60 },
    { 0x00, 0xc0, 0x80 }, { 0x00, 0xc0, 0xa0 }, { 0x00, 0xc0, 0xc0 }, { 0x00, 0xc0, 0xe0 },
    { 0x00, 0xe0, 0x00 }, { 0x00, 0xe0, 0x20 }, { 0x00, 0xe0, 0x40 }, { 0x00, 0xe0, 0x60 },
    { 0x00, 0xe0, 0x80 }, { 0x00, 0xe0, 0xa0 }, { 0x00, 0xe0, 0xc0 }, { 0x00, 0xe0, 0xe0 },
    { 0x40, 0x00, 0x00 }, { 0x40, 0x00, 0x20 }, { 0x40, 0x00, 0x40 }, { 0x40, 0x00, 0x60 },
    { 0x40, 0x00, 0x80 }, { 0x40, 0x00, 0xa0 }, { 0x40, 0x00, 0xc0 }, { 0x40, 0x00, 0xe0 },
    { 0x40, 0x20, 0x00 }, { 0x40, 0x20, 0x20 }, { 0x40, 0x20, 0x40 }, { 0x40, 0x20, 0x60 },
    { 0x40, 0x20, 0x80 }, { 0x40, 0x20, 0xa0 }, { 0x40, 0x20, 0xc0 }, { 0x40, 0x20, 0xe0 },
    { 0x40, 0x40, 0x00 }, { 0x40, 0x40, 0x20 }, { 0x40, 0x40, 0x40 }, { 0x40, 0x40, 0x60 },
    { 0x40, 0x40, 0x80 }, { 0x40, 0x40, 0xa0 }, { 0x40, 0x40, 0xc0 }, { 0x40, 0x40, 0xe0 },
    { 0x40, 0x60, 0x00 }, { 0x40, 0x60, 0x20 }, { 0x40, 0x60, 0x40 }, { 0x40, 0x60, 0x60 },
    { 0x40, 0x60, 0x80 }, { 0x40, 0x60, 0xa0 }, { 0x40, 0x60, 0xc0 }, { 0x40, 0x60, 0xe0 },
    { 0x40, 0x80, 0x00 }, { 0x40, 0x80, 0x20 }, { 0x40, 0x80, 0x40 }, { 0x40, 0x80, 0x60 },
    { 0x40, 0x80, 0x80 }, { 0x40, 0x80, 0xa0 }, { 0x40, 0x80, 0xc0 }, { 0x40, 0x80, 0xe0 },
    { 0x40, 0xa0, 0x00 }, { 0x40, 0xa0, 0x20 }, { 0x40, 0xa0, 0x40 }, { 0x40, 0xa0, 0x60 },
    { 0x40, 0xa0, 0x80 }, { 0x40, 0xa0, 0xa0 }, { 0x40, 0xa0, 0xc0 }, { 0x40, 0xa0, 0xe0 },
    { 0x40, 0xc0, 0x00 }, { 0x40, 0xc0, 0x20 }, { 0x40, 0xc0, 0x40 }, { 0x40, 0xc0, 0x60 },
    { 0x40, 0xc0, 0x80 }, { 0x40, 0xc0, 0xa0 }, { 0x40, 0xc0, 0xc0 }, { 0x40, 0xc0, 0xe0 },
    { 0x40, 0xe0, 0x00 }, { 0x40, 0xe0, 0x20 }, { 0x40, 0xe0, 0x40 }, { 0x40, 0xe0, 0x60 },
    { 0x40, 0xe0, 0x80 }, { 0x40, 0xe0, 0xa0 }, { 0x40, 0xe0, 0xc0 }, { 0x40, 0xe0, 0xe0 },
    { 0x80, 0x00, 0x00 }, { 0x80, 0x00, 0x20 }, { 0x80, 0x00, 0x40 }, { 0x80, 0x00, 0x60 },
    { 0x80, 0x00, 0x80 }, { 0x80, 0x00, 0xa0 }, { 0x80, 0x00, 0xc0 }, { 0x80, 0x00, 0xe0 },
    { 0x80, 0x20, 0x00 }, { 0x80, 0x20, 0x20 }, { 0x80, 0x20, 0x40 }, { 0x80, 0x20, 0x60 },
    { 0x80, 0x20, 0x80 }, { 0x80, 0x20, 0xa0 }, { 0x80, 0x20, 0xc0 }, { 0x80, 0x20, 0xe0 },
    { 0x80, 0x40, 0x00 }, { 0x80, 0x40, 0x20 }, { 0x80, 0x40, 0x40 }, { 0x80, 0x40, 0x60 },
    { 0x80, 0x40, 0x80 }, { 0x80, 0x40, 0xa0 }, { 0x80, 0x40, 0xc0 }, { 0x80, 0x40, 0xe0 },
    { 0x80, 0x60, 0x00 }, { 0x80, 0x60, 0x20 }, { 0x80, 0x60, 0x40 }, { 0x80, 0x60, 0x60 },
    { 0x80, 0x60, 0x80 }, { 0x80, 0x60, 0xa0 }, { 0x80, 0x60, 0xc0 }, { 0x80, 0x60, 0xe0 },
    { 0x80, 0x80, 0x00 }, { 0x80, 0x80, 0x20 }, { 0x80, 0x80, 0x40 }, { 0x80, 0x80, 0x60 },
    { 0x80, 0x80, 0x80 }, { 0x80, 0x80, 0xa0 }, { 0x80, 0x80, 0xc0 }, { 0x80, 0x80, 0xe0 },
    { 0x80, 0xa0, 0x00 }, { 0x80, 0xa0, 0x20 }, { 0x80, 0xa0, 0x40 }, { 0x80, 0xa0, 0x60 },
    { 0x80, 0xa0, 0x80 }, { 0x80, 0xa0, 0xa0 }, { 0x80, 0xa0, 0xc0 }, { 0x80, 0xa0, 0xe0 },
    { 0x80, 0xc0, 0x00 }, { 0x80, 0xc0, 0x20 }, { 0x80, 0xc0, 0x40 }, { 0x80, 0xc0, 0x60 },
    { 0x80, 0xc0, 0x80 }, { 0x80, 0xc0, 0xa0 }, { 0x80, 0xc0, 0xc0 }, { 0x80, 0xc0, 0xe0 },
    { 0x80, 0xe0, 0x00 }, { 0x80, 0xe0, 0x20 }, { 0x80, 0xe0, 0x40 }, { 0x80, 0xe0, 0x60 },
    { 0x80, 0xe0, 0x80 }, { 0x80, 0xe0, 0xa0 }, { 0x80, 0xe0, 0xc0 }, { 0x80, 0xe0, 0xe0 },
    { 0xc0, 0x00, 0x00 }, { 0xc0, 0x00, 0x20 }, { 0xc0, 0x00, 0x40 }, { 0xc0, 0x00, 0x60 },
    { 0xc0, 0x00, 0x80 }, { 0xc0, 0x00, 0xa0 }, { 0xc0, 0x00, 0xc0 }, { 0xc0, 0x00, 0xe0 },
    { 0xc0, 0x20, 0x00 }, { 0xc0, 0x20, 0x20 }, { 0xc0, 0x20, 0x40 }, { 0xc0, 0x20, 0x60 },
    { 0xc0, 0x20, 0x80 }, { 0xc0, 0x20, 0xa0 }, { 0xc0, 0x20, 0xc0 }, { 0xc0, 0x20, 0xe0 },
    { 0xc0, 0x40, 0x00 }, { 0xc0, 0x40, 0x20 }, { 0xc0, 0x40, 0x40 }, { 0xc0, 0x40, 0x60 },
    { 0xc0, 0x40, 0x80 }, { 0xc0, 0x40, 0xa0 }, { 0xc0, 0x40, 0xc0 }, { 0xc0, 0x40, 0xe0 },
    { 0xc0, 0x60, 0x00 }, { 0xc0, 0x60, 0x20 }, { 0xc0, 0x60, 0x40 }, { 0xc0, 0x60, 0x60 },
    { 0xc0, 0x60, 0x80 }, { 0xc0, 0x60, 0xa0 }, { 0xc0, 0x60, 0xc0 }, { 0xc0, 0x60, 0xe0 },
    { 0xc0, 0x80, 0x00 }, { 0xc0, 0x80, 0x20 }, { 0xc0, 0x80, 0x40 }, { 0xc0, 0x80, 0x60 },
    { 0xc0, 0x80, 0x80 }, { 0xc0, 0x80, 0xa0 }, { 0xc0, 0x80, 0xc0 }, { 0xc0, 0x80, 0xe0 },
    { 0xc0, 0xa0, 0x00 }, { 0xc0, 0xa0, 0x20 }, { 0xc0, 0xa0, 0x40 }, { 0xc0, 0xa0, 0x60 },
    { 0xc0, 0xa0, 0x80 }, { 0xc0, 0xa0, 0xa0 }, { 0xc0, 0xa0, 0xc0 }, { 0xc0, 0xa0, 0xe0 },
    { 0xc0, 0xc0, 0x00 }, { 0xc0, 0xc0, 0x20 }, { 0xc0, 0xc0, 0x40 }, { 0xc0, 0xc0, 0x60 },
    { 0xc0, 0xc0, 0x80 }, { 0xc0, 0xc0, 0xa0 }, { 0xf0, 0xfb, 0xff }, { 0xa4, 0xa0, 0xa0 },
    { 0x80, 0x80, 0x80 }, { 0x00, 0x00, 0xff }, { 0x00, 0xff, 0x00 }, { 0x00, 0xff, 0xff },
    { 0xff, 0x00, 0x00 }, { 0xff, 0x00, 0xff }, { 0xff, 0xff, 0x00 }, { 0xff, 0xff, 0xff }
};

static HPALETTE create_default_palette( int bpp )
{
    char pal_buffer[sizeof(LOGPALETTE) + 255 * sizeof(PALETTEENTRY)];
    LOGPALETTE *pal = (LOGPALETTE *)pal_buffer;
    PALETTEENTRY *entries = pal->palPalEntry;
    int i;

    pal->palVersion = 0x300;
    pal->palNumEntries = 1 << bpp;
    switch (bpp)
    {
    case 1:
        for (i = 0; i < 2; i++)
        {
            entries[i].peRed   = default_palette_1[i].rgbRed;
            entries[i].peGreen = default_palette_1[i].rgbGreen;
            entries[i].peBlue  = default_palette_1[i].rgbBlue;
            entries[i].peFlags = 0;
        }
        break;
    case 4:
        for (i = 0; i < 16; i++)
        {
            entries[i].peRed   = default_palette_4[i].rgbRed;
            entries[i].peGreen = default_palette_4[i].rgbGreen;
            entries[i].peBlue  = default_palette_4[i].rgbBlue;
            entries[i].peFlags = 0;
        }
        break;
    case 8:
        for (i = 0; i < 256; i++)
        {
            entries[i].peRed   = default_palette_8[i].rgbRed;
            entries[i].peGreen = default_palette_8[i].rgbGreen;
            entries[i].peBlue  = default_palette_8[i].rgbBlue;
            entries[i].peFlags = 0;
        }
        break;
    }
    return CreatePalette( pal );
}

static inline void solid_patblt( HDC hdc, int x, int y, int width, int height, COLORREF color )
{
    HBRUSH brush = CreateSolidBrush( color );
    brush = SelectObject( hdc, brush );
    PatBlt( hdc, x, y, width, height, PATCOPY );
    DeleteObject( SelectObject( hdc, brush ) );
}

static void draw_graphics(HDC hdc, const BITMAPINFO *bmi, BYTE *bits)
{
    char pal_buffer[sizeof(LOGPALETTE) + 255 * sizeof(PALETTEENTRY)];
    LOGPALETTE *pal = (LOGPALETTE *)pal_buffer;
    PALETTEENTRY *entries = pal->palPalEntry;
    HPEN solid_pen, dashed_pen, wide_pen, orig_pen;
    LOGBRUSH log_brush;
    HBRUSH solid_brush, dib_brush, hatch_brush, orig_brush;
    HBITMAP bmp;
    INT i, j, x, y, hatch_style;
    HDC src_dc;
    HRGN hrgn, hrgn2;
    BYTE dib_src_buf[sizeof(BITMAPINFO) + 256 * sizeof(RGBQUAD)];
    BYTE dib_brush_buf[sizeof(BITMAPINFO) + 256 * sizeof(RGBQUAD) + 16 * 16 * sizeof(DWORD)]; /* Enough for 16 x 16 at 32 bpp */
    BITMAPINFO *src_bi = (BITMAPINFO*)dib_src_buf;
    BITMAPINFO *brush_bi = (BITMAPINFO*)dib_brush_buf;
    RGBQUAD *brush_colors = brush_bi->bmiColors;
    BYTE *brush_bits, *src_bits;
    BOOL ret, dib_is_1bpp = (bmi->bmiHeader.biBitCount == 1);
    BOOL dib_is_8bpp_gray = (bmi->bmiHeader.biBitCount == 8 && bmi->bmiColors[1].rgbRed == 1);
    BLENDFUNCTION blend;
    COLORREF old_text, old_bkgnd;
    HPALETTE hpal, old_hpal;

    blend.BlendOp = AC_SRC_OVER;
    blend.BlendFlags = 0;

    reset_bounds( hdc );

    memset(bits, 0xcc, get_dib_size(bmi));
    compare_hash(hdc, bmi, bits, "empty");

    src_dc = CreateCompatibleDC( 0 );
    solid_pen = CreatePen(PS_SOLID, 1, RGB(0, 0, 0xff));
    orig_pen = SelectObject(hdc, solid_pen);
    SetBrushOrgEx(hdc, 0, 0, NULL);

    /* horizontal and vertical lines */
    for(i = 1; i <= 16; i++)
    {
        SetROP2(hdc, i);
        MoveToEx(hdc, 10, i * 3, NULL);
        LineTo(hdc, 100, i * 3); /* l -> r */
        MoveToEx(hdc, 100, 50 + i * 3, NULL);
        LineTo(hdc, 10, 50 + i * 3); /* r -> l */
        MoveToEx(hdc, 120 + i * 3, 10, NULL);
        LineTo(hdc, 120 + i * 3, 100); /* t -> b */
        MoveToEx(hdc, 170 + i * 3, 100, NULL);
        LineTo(hdc, 170 + i * 3, 10); /* b -> t */
    }
    compare_hash(hdc, bmi, bits, "h and v solid lines");

    /* diagonal lines */
    SetROP2(hdc, R2_COPYPEN);
    for(i = 0; i < 16; i++)
    {
        double s = sin(M_PI * i / 8.0);
        double c = cos(M_PI * i / 8.0);

        MoveToEx(hdc, 200.5 + 10 * c, 200.5 + 10 * s, NULL);
        LineTo(hdc, 200.5 + 100 * c, 200.5 + 100 * s);
    }
    compare_hash(hdc, bmi, bits, "diagonal solid lines");

    for(i = 0; i < sizeof(bias_check) / sizeof(bias_check[0]); i++)
    {
        MoveToEx(hdc, bias_check[i].left, bias_check[i].top, NULL);
        LineTo(hdc, bias_check[i].right, bias_check[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "more diagonal solid lines");

    /* solid brush PatBlt */
    solid_brush = CreateSolidBrush(RGB(0x33, 0xaa, 0xff));
    orig_brush = SelectObject(hdc, solid_brush);

    for(i = 0, y = 10; i < 256; i++)
    {
        ret = PatBlt(hdc, 10, y, 100, 10, rop3[i]);

        if(rop_uses_src(rop3[i]))
            ok(ret == FALSE, "got TRUE for %x\n", rop3[i]);
        else
        {
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 20;
        }

    }
    compare_hash(hdc, bmi, bits, "solid patblt");

    /* clipped lines */
    hrgn = CreateRectRgn(10, 10, 200, 20);
    hrgn2 = CreateRectRgn(100, 100, 200, 200);
    CombineRgn(hrgn, hrgn, hrgn2, RGN_OR);
    SetRectRgn(hrgn2, 290, 100, 300, 200);
    CombineRgn(hrgn, hrgn, hrgn2, RGN_OR);
    ExtSelectClipRgn(hdc, hrgn, RGN_COPY);
    DeleteObject(hrgn2);

    for(i = 0; i < sizeof(hline_clips)/sizeof(hline_clips[0]); i++)
    {
        MoveToEx(hdc, hline_clips[i].left, hline_clips[i].top, NULL);
        LineTo(hdc, hline_clips[i].right, hline_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped solid hlines");

    for(i = 0; i < sizeof(vline_clips)/sizeof(vline_clips[0]); i++)
    {
        MoveToEx(hdc, vline_clips[i].left, vline_clips[i].top, NULL);
        LineTo(hdc, vline_clips[i].right, vline_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped solid vlines");

    for(i = 0; i < sizeof(line_clips)/sizeof(line_clips[0]); i++)
    {
        MoveToEx(hdc, line_clips[i].left, line_clips[i].top, NULL);
        LineTo(hdc, line_clips[i].right, line_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped solid diagonal lines");

    /* clipped PatBlt */
    for(i = 0; i < sizeof(patblt_clips) / sizeof(patblt_clips[0]); i++)
    {
        PatBlt(hdc, patblt_clips[i].left, patblt_clips[i].top,
               patblt_clips[i].right - patblt_clips[i].left,
               patblt_clips[i].bottom - patblt_clips[i].top, PATCOPY);
    }
    compare_hash(hdc, bmi, bits, "clipped patblt");

    /* clipped dashed lines */
    dashed_pen = CreatePen(PS_DASH, 1, RGB(0xff, 0, 0));
    SelectObject(hdc, dashed_pen);
    SetBkMode(hdc, TRANSPARENT);
    SetBkColor(hdc, RGB(0, 0xff, 0));

    for(i = 0; i < sizeof(hline_clips)/sizeof(hline_clips[0]); i++)
    {
        MoveToEx(hdc, hline_clips[i].left, hline_clips[i].top, NULL);
        LineTo(hdc, hline_clips[i].right, hline_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped dashed hlines");

    for(i = 0; i < sizeof(hline_clips)/sizeof(hline_clips[0]); i++)
    {
        MoveToEx(hdc, hline_clips[i].right - 1, hline_clips[i].bottom, NULL);
        LineTo(hdc, hline_clips[i].left - 1, hline_clips[i].top);
    }
    compare_hash(hdc, bmi, bits, "clipped dashed hlines r -> l");

    for(i = 0; i < sizeof(vline_clips)/sizeof(vline_clips[0]); i++)
    {
        MoveToEx(hdc, vline_clips[i].left, vline_clips[i].top, NULL);
        LineTo(hdc, vline_clips[i].right, vline_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped dashed vlines");

    for(i = 0; i < sizeof(vline_clips)/sizeof(vline_clips[0]); i++)
    {
        MoveToEx(hdc, vline_clips[i].right, vline_clips[i].bottom - 1, NULL);
        LineTo(hdc, vline_clips[i].left, vline_clips[i].top - 1);
    }
    compare_hash(hdc, bmi, bits, "clipped dashed vlines b -> t");

    for(i = 0; i < sizeof(line_clips)/sizeof(line_clips[0]); i++)
    {
        MoveToEx(hdc, line_clips[i].left, line_clips[i].top, NULL);
        LineTo(hdc, line_clips[i].right, line_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped dashed diagonal lines");

    SetBkMode(hdc, OPAQUE);

    for(i = 0; i < sizeof(line_clips)/sizeof(line_clips[0]); i++)
    {
        MoveToEx(hdc, line_clips[i].left, line_clips[i].top, NULL);
        LineTo(hdc, line_clips[i].right, line_clips[i].bottom);
    }
    compare_hash(hdc, bmi, bits, "clipped opaque dashed diagonal lines");

    ExtSelectClipRgn(hdc, NULL, RGN_COPY);

    /* 8888 DIB pattern brush */

    brush_bi->bmiHeader = dib_brush_header_8888;
    brush_bits = (BYTE*)brush_bi + sizeof(BITMAPINFOHEADER);
    memset(brush_bits, 0, 16 * 16 * sizeof(DWORD));
    brush_bits[2] = 0xff;
    brush_bits[6] = 0xff;
    brush_bits[14] = 0xff;
    brush_bits[65] = 0xff;
    brush_bits[69] = 0xff;
    brush_bits[72] = 0xff;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);
    SetBrushOrgEx(hdc, 1, 1, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed == 256)  /* 8-bpp grayscale broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 8888 dib brush patblt", 1, FALSE);
    else
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 8888 dib brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 8888 bottom-up DIB pattern brush */

    brush_bi->bmiHeader.biHeight = -brush_bi->bmiHeader.biHeight;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);

    /* This used to set the x origin to 100 as well, but
       there's a Windows bug for 24 bpp where the brush's x offset
       is incorrectly calculated for rops that involve both D and P */
    SetBrushOrgEx(hdc, 4, 100, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed == 256)  /* 8-bpp grayscale broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "bottom-up 8888 dib brush patblt", 1, FALSE);
    else
        compare_hash_broken_todo(hdc, bmi, bits, "bottom-up 8888 dib brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 24 bpp dib pattern brush */

    brush_bi->bmiHeader = dib_brush_header_24;
    brush_bits = (BYTE*)brush_bi + sizeof(BITMAPINFOHEADER);
    memset(brush_bits, 0, 16 * 16 * 3);
    brush_bits[0] = brush_bits[3] = brush_bits[6] = brush_bits[8] = 0xff;
    brush_bits[49] = brush_bits[52] = 0xff;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);
    SetBrushOrgEx(hdc, 1, 1, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed == 256)  /* 8-bpp grayscale broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 24 bpp brush patblt", 1, FALSE);
    else
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 24 bpp brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 555 dib pattern brush */

    brush_bi->bmiHeader = dib_brush_header_555;
    brush_bits = (BYTE*)brush_bi + sizeof(BITMAPINFOHEADER);
    memset(brush_bits, 0, 16 * 16 * sizeof(WORD));
    brush_bits[0] = brush_bits[1] = 0xff;
    brush_bits[32] = brush_bits[34] = 0x7c;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);
    SetBrushOrgEx(hdc, 1, 1, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed == 256)  /* 8-bpp grayscale broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 555 dib brush patblt", 1, FALSE);
    else
        compare_hash_broken_todo(hdc, bmi, bits, "top-down 555 dib brush patblt", dib_is_1bpp ? 1 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    SetBrushOrgEx(hdc, 0, 0, NULL);

    /* 8 bpp dib pattern brush */

    brush_bi->bmiHeader = dib_brush_header_8;
    brush_bi->bmiHeader.biClrUsed = 3;
    memset(brush_colors, 0, brush_bi->bmiHeader.biClrUsed * sizeof(RGBQUAD));
    brush_colors[0].rgbRed = 0xff;
    brush_colors[1].rgbRed = 0xff;
    brush_colors[1].rgbGreen = 0xff;
    brush_colors[1].rgbBlue = 0xff;

    brush_bits = (BYTE*)brush_bi + sizeof(BITMAPINFOHEADER) + brush_bi->bmiHeader.biClrUsed * sizeof(RGBQUAD);
    memset(brush_bits, 0, 16 * 16 * sizeof(BYTE));
    brush_bits[0] = brush_bits[1] = 1;
    brush_bits[16] = brush_bits[17] = 2;
    brush_bits[32] = brush_bits[33] = 6;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);
    SetBrushOrgEx(hdc, 1, 1, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    compare_hash_broken_todo(hdc, bmi, bits, "top-down 8 bpp dib brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 4 bpp dib pattern brush */

    brush_bi->bmiHeader = dib_brush_header_4;
    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);

    SelectObject(hdc, dib_brush);
    SetBrushOrgEx(hdc, 1, 1, NULL);

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }
    compare_hash_broken_todo(hdc, bmi, bits, "top-down 4 bpp dib brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 1 bpp dib pattern brush */

    brush_bi->bmiHeader = dib_brush_header_1;
    brush_bi->bmiHeader.biClrUsed = 2;
    memset(brush_bits, 0, 16 * 4);
    brush_bits[0] = 0xf0;
    brush_bits[4] = 0xf0;
    brush_bits[8] = 0xf0;

    dib_brush = CreateDIBPatternBrushPt(brush_bi, DIB_RGB_COLORS);
    SelectObject(hdc, dib_brush);
    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }

    compare_hash_broken_todo(hdc, bmi, bits, "top-down 1 bpp dib brush patblt", dib_is_1bpp ? 2 : 0, dib_is_1bpp);

    SelectObject(hdc, orig_brush);
    DeleteObject(dib_brush);

    /* 1 bpp ddb pattern brush */

    old_text = GetTextColor( hdc );
    old_bkgnd = GetBkColor( hdc );
    bmp = CreateBitmap( 16, 16, 1, 1, ddb_brush_bits );
    dib_brush = CreatePatternBrush( bmp );
    SelectObject(hdc, dib_brush);
    for(i = 0, y = 10; i < 256; i++)
    {
        SetTextColor(hdc, RGB( i, 2*i, 255 - i ) );
        SetBkColor(hdc, RGB( 255 - i, i / 3, i ) );
        if(!rop_uses_src(rop3[i]))
        {
            ret = PatBlt(hdc, 10 + i, y, 100, 20, rop3[i]);
            ok(ret, "got FALSE for %x\n", rop3[i]);
            y += 25;
        }
    }

    compare_hash_broken_todo(hdc, bmi, bits, "1 bpp ddb brush patblt", dib_is_1bpp ? 3 : 0, dib_is_1bpp);

    DeleteObject(bmp);
    SelectObject(hdc, orig_brush);
    DeleteObject( dib_brush );
    SetBrushOrgEx(hdc, 0, 0, NULL);
    SetTextColor(hdc, old_text);
    SetBkColor(hdc, old_bkgnd);

    /* Rectangle */

    SelectObject(hdc, solid_pen);
    SelectObject(hdc, solid_brush);

    for(i = 0; i < sizeof(rectangles)/sizeof(rectangles[0]); i++)
    {
        Rectangle(hdc, rectangles[i].left, rectangles[i].top, rectangles[i].right, rectangles[i].bottom);
    }

    SelectObject(hdc, dashed_pen);
    for(i = 0; i < sizeof(rectangles)/sizeof(rectangles[0]); i++)
    {
        Rectangle(hdc, rectangles[i].left, rectangles[i].top + 150, rectangles[i].right, rectangles[i].bottom + 150);
    }

    compare_hash(hdc, bmi, bits, "rectangles");
    SelectObject(hdc, solid_pen);

    /* PaintRgn */

    PaintRgn(hdc, hrgn);
    compare_hash(hdc, bmi, bits, "PaintRgn");

    /* RTL rectangles */

    if( !pSetLayout )
    {
        win_skip("Don't have SetLayout\n");
        skip_compare(1);
    }
    else
    {
        pSetLayout(hdc, LAYOUT_RTL);
        PaintRgn(hdc, hrgn);
        PatBlt(hdc, 10, 250, 10, 10, PATCOPY);
        Rectangle(hdc, 100, 250, 110, 260);
        compare_hash(hdc, bmi, bits, "rtl");

        pSetLayout(hdc, LAYOUT_LTR);
    }
    DeleteObject( hrgn );

    for(i = 0, y = 10; i < 256; i++)
    {
        if(!rop_uses_src(rop3[i]))
        {
            for(hatch_style = HS_HORIZONTAL; hatch_style <= HS_DIAGCROSS; hatch_style++)
            {
                hatch_brush = CreateHatchBrush(hatch_style, RGB(0xff, 0, 0));
                SelectObject(hdc, hatch_brush);
                ret = PatBlt(hdc, 10 + i + 30 * hatch_style, y, 20, 20, rop3[i]);
                ok(ret, "got FALSE for %x\n", rop3[i]);
                SelectObject(hdc, orig_brush);
                DeleteObject(hatch_brush);
            }
            y += 25;
        }
    }

    compare_hash_broken_todo(hdc, bmi, bits, "hatch brushes", 1, FALSE); /* nt4 is different */

    /* overlapping blits */

    orig_brush = SelectObject(hdc, solid_brush);

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 20, 20, 100, 100, hdc, 10, 10, SRCCOPY );
    compare_hash(hdc, bmi, bits, "overlapping BitBlt SRCCOPY +x, +y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 10, 10, 100, 100, hdc, 20, 20, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 1)  /* Windows gets this one wrong */
        compare_hash_broken_todo(hdc, bmi, bits, "overlapping BitBlt SRCCOPY -x, -y",1, FALSE);
    else
        compare_hash(hdc, bmi, bits, "overlapping BitBlt SRCCOPY -x, -y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 20, 10, 100, 100, hdc, 10, 20, SRCCOPY );
    compare_hash(hdc, bmi, bits, "overlapping BitBlt SRCCOPY +x, -y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 10, 20, 100, 100, hdc, 20, 10, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 1)  /* Windows gets this one wrong */
        compare_hash_broken_todo(hdc, bmi, bits, "overlapping BitBlt SRCCOPY -x, +y", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "overlapping BitBlt SRCCOPY -x, +y" );

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 20, 20, 100, 100, hdc, 10, 10, PATPAINT );
    compare_hash(hdc, bmi, bits, "overlapping BitBlt PATPAINT +x, +y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 10, 10, 100, 100, hdc, 20, 20, PATPAINT );
    compare_hash(hdc, bmi, bits, "overlapping BitBlt PATPAINT -x, -y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 20, 10, 100, 100, hdc, 10, 20, PATPAINT );
    if (bmi->bmiHeader.biBitCount >= 24)  /* Windows gets this one wrong */
        compare_hash_broken_todo(hdc, bmi, bits, "overlapping BitBlt PATPAINT +x, -y", 1, FALSE);
    else
        compare_hash(hdc, bmi, bits, "overlapping BitBlt PATPAINT +x, -y");

    Rectangle(hdc, 10, 10, 100, 100);
    Rectangle(hdc, 20, 15, 30, 40);
    Rectangle(hdc, 15, 15, 20, 20);
    Rectangle(hdc, 15, 20, 50, 45);
    BitBlt( hdc, 10, 20, 100, 100, hdc, 20, 10, PATPAINT );
    compare_hash(hdc, bmi, bits, "overlapping BitBlt PATPAINT -x, +y" );

    /* blitting with 32-bpp BI_RGB source */

    memset( dib_src_buf, 0, sizeof(dib_src_buf) );
    src_bi->bmiHeader.biSize = sizeof(bmi->bmiHeader);
    src_bi->bmiHeader.biHeight = 256;
    src_bi->bmiHeader.biWidth = 256;
    src_bi->bmiHeader.biBitCount = 32;
    src_bi->bmiHeader.biPlanes = 1;
    src_bi->bmiHeader.biCompression = BI_RGB;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    SelectObject( src_dc, bmp );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
        {
            BYTE a = (x + y) * 2;
            BYTE r = (BYTE)(y + 2 * x) * a / 255;
            BYTE g = (BYTE)(x + y / 3) * a / 255;
            BYTE b = (BYTE)(x / 3 + 2 * y) * a / 255;
            ((DWORD *)src_bits)[y * 256 + x] = (a << 24) | RGB( r, g, b );
        }

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 32-bpp SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 32-bpp SRCCOPY" );

    blend.SourceConstantAlpha = 0xd0;
    blend.AlphaFormat = 0;
    if (pGdiAlphaBlend) pGdiAlphaBlend( hdc, 100, 100, 256, 256, src_dc, 0, 0, 256, 256, blend );
    if (bmi->bmiHeader.biBitCount == 16 && bmi->bmiHeader.biCompression == BI_RGB) /* 555 broken on w2k */
    {
        if (!pGdiAlphaBlend) skip_compare(2);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 32-bpp no alpha", 1, FALSE );
    }
    else
    {
        if (!pGdiAlphaBlend) skip_compare(1);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 32-bpp no alpha", 0, dib_is_1bpp );
    }

    blend.SourceConstantAlpha = 0xb0;
    blend.AlphaFormat = AC_SRC_ALPHA;
    if (pGdiAlphaBlend) pGdiAlphaBlend( hdc, 50, 50, 256, 256, src_dc, 0, 0, 256, 256, blend );
    if (bmi->bmiHeader.biBitCount == 16 && bmi->bmiHeader.biCompression == BI_RGB) /* 555 broken on w2k */
    {
        if (!pGdiAlphaBlend) skip_compare(2);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 32-bpp alpha", 1, FALSE );
    }
    else
    {
        if (!pGdiAlphaBlend) skip_compare(1);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 32-bpp alpha", 0, dib_is_1bpp );
    }

    /* blitting with 32-bpp r10g10b10 source */

    src_bi->bmiHeader.biBitCount = 32;
    src_bi->bmiHeader.biCompression = BI_BITFIELDS;
    ((DWORD *)src_bi->bmiColors)[0] = 0x3ff00000;
    ((DWORD *)src_bi->bmiColors)[1] = 0x000ffc00;
    ((DWORD *)src_bi->bmiColors)[2] = 0x000003ff;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    SelectObject( src_dc, bmp );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
        {
            WORD r = (7 * x + 3 * y) % 1024;
            WORD g = (11 * x + y / 3) % 1024;
            WORD b = (x / 3 + 9 * y) % 1024;
            ((DWORD *)src_bits)[y * 256 + x] = r << 20 | g << 10 | b;
        }

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 32-bpp r10g10b10 SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 32-bpp r10g10b10 SRCCOPY" );

    /* blitting with 32-bpp b6g6r6 source */

    src_bi->bmiHeader.biBitCount = 32;
    src_bi->bmiHeader.biCompression = BI_BITFIELDS;
    ((DWORD *)src_bi->bmiColors)[0] = 0x00003f;
    ((DWORD *)src_bi->bmiColors)[1] = 0x000fc0;
    ((DWORD *)src_bi->bmiColors)[2] = 0x03f000;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    SelectObject( src_dc, bmp );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
        {
            BYTE r = (y + 2 * x) % 64;
            BYTE g = (x + y / 3) % 64;
            BYTE b = (x / 3 + 2 * y) % 64;
            ((DWORD *)src_bits)[y * 256 + x] = r | g << 6 | b << 12;
        }

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 32-bpp b6g6r6 SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 32-bpp b6g6r6 SRCCOPY" );

    /* blitting with 24-bpp source */

    src_bi->bmiHeader.biBitCount = 24;
    src_bi->bmiHeader.biCompression = BI_RGB;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
        {
            src_bits[(y * 256 + x) * 3 + 0] = x + 3 * y;
            src_bits[(y * 256 + x) * 3 + 1] = 2 * x + 7 * y;
            src_bits[(y * 256 + x) * 3 + 2] = 5 * x + 12 * y;
        }

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 24-bpp SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 24-bpp SRCCOPY" );

    blend.SourceConstantAlpha = 0xe0;
    blend.AlphaFormat = 0;
    if (pGdiAlphaBlend) pGdiAlphaBlend( hdc, 100, 100, 256, 256, src_dc, 0, 0, 256, 256, blend );
    if (bmi->bmiHeader.biBitCount == 16 && bmi->bmiHeader.biCompression == BI_RGB) /* 555 broken on w2k */
    {
        if (!pGdiAlphaBlend) skip_compare(2);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 24-bpp", 1, FALSE );
    }
    else
    {
        if (!pGdiAlphaBlend) skip_compare(1);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 24-bpp", 0, dib_is_1bpp );
    }

    /* blitting with 16-bpp BI_RGB source */

    src_bi->bmiHeader.biBitCount = 16;
    src_bi->bmiHeader.biCompression = BI_RGB;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
            ((WORD *)src_bits)[y * 256 + x] = x | x << 4 | x << 8 | y << 3 | y << 7;

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed > 5)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 16-bpp SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 16-bpp SRCCOPY" );

    /* blitting with 16-bpp b4g4r4 source */

    src_bi->bmiHeader.biBitCount = 16;
    src_bi->bmiHeader.biCompression = BI_BITFIELDS;
    ((DWORD *)src_bi->bmiColors)[0] = 0x00000f;
    ((DWORD *)src_bi->bmiColors)[1] = 0x0000f0;
    ((DWORD *)src_bi->bmiColors)[2] = 0x000f00;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
            ((WORD *)src_bits)[y * 256 + x] = x | x << 4 | x << 8 | y << 3 | y << 7;

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    if (bmi->bmiHeader.biBitCount == 8 && bmi->bmiHeader.biClrUsed > 5)  /* broken on NT4 */
        compare_hash_broken_todo(hdc, bmi, bits, "BitBlt src 16-bpp b4g4r4 SRCCOPY", 1, FALSE );
    else
        compare_hash(hdc, bmi, bits, "BitBlt src 16-bpp b4g4r4 SRCCOPY" );

    /* blitting with 8-bpp source */

    src_bi->bmiHeader.biBitCount = 8;
    src_bi->bmiHeader.biCompression = BI_RGB;
    src_bi->bmiHeader.biClrUsed = 160;
    for (i = 0; i < 256; i++) ((DWORD *)src_bi->bmiColors)[i] = i | (i * 3) << 8 | (i / 2) << 16;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x++)
            src_bits[y * 256 + x] = 3 * x + 5 * y;

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    compare_hash(hdc, bmi, bits, "BitBlt src 8-bpp SRCCOPY" );

    blend.SourceConstantAlpha = 0xd0;
    blend.AlphaFormat = 0;
    if (pGdiAlphaBlend) pGdiAlphaBlend( hdc, 100, 100, 256, 256, src_dc, 0, 0, 256, 256, blend );
    if (bmi->bmiHeader.biBitCount == 16 && bmi->bmiHeader.biCompression == BI_RGB) /* 555 broken on w2k */
    {
        if (!pGdiAlphaBlend) skip_compare(2);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 8-bpp", 1, FALSE );
    }
    else
    {
        if (!pGdiAlphaBlend) skip_compare(1);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 8-bpp", 0, dib_is_1bpp );
    }

    /* blitting with 4-bpp source */

    src_bi->bmiHeader.biBitCount = 4;
    src_bi->bmiHeader.biClrUsed = 12;
    for (i = 0; i < 16; i++) ((DWORD *)src_bi->bmiColors)[i] = i | (i * 5) << 8 | (i * 19) << 16;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x += 2)
            src_bits[(y * 256 + x) / 2] = 7 * x + 3 * y;

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    compare_hash(hdc, bmi, bits, "BitBlt src 4-bpp SRCCOPY" );

    /* blitting with 1-bpp source */

    src_bi->bmiHeader.biBitCount = 1;
    src_bi->bmiHeader.biClrUsed = 0;
    for (i = 0; i < 2; i++) ((DWORD *)src_bi->bmiColors)[i] = (i + 37) | (i * 91) << 8 | (i * 53) << 16;
    bmp = CreateDIBSection(0, src_bi, DIB_RGB_COLORS, (void**)&src_bits, NULL, 0);
    DeleteObject( SelectObject( src_dc, bmp ) );
    for (y = 0; y < 256; y++)
        for (x = 0; x < 256; x += 8)
            src_bits[(y * 256 + x) / 8] = 7 * x + 3 * y;

    BitBlt( hdc, 100, 100, 256, 256, src_dc, 0, 0, SRCCOPY );
    compare_hash(hdc, bmi, bits, "BitBlt src 1-bpp SRCCOPY" );

    blend.SourceConstantAlpha = 0x90;
    blend.AlphaFormat = 0;
    if (pGdiAlphaBlend) pGdiAlphaBlend( hdc, 100, 100, 256, 256, src_dc, 0, 0, 256, 256, blend );
    if (bmi->bmiHeader.biBitCount == 16 && bmi->bmiHeader.biCompression == BI_RGB) /* 555 broken on w2k */
    {
        if (!pGdiAlphaBlend) skip_compare(2);
        else compare_hash_broken_todo(hdc, bmi, bits, "AlphaBlend src 1-bpp", 1, FALSE );
    }
    else
    {
        if (!pGdiAlphaBlend) skip_compare(1);
        else compare_hash(hdc, bmi, bits, "AlphaBlend src 1-bpp" );
    }

    DeleteDC( src_dc );
    DeleteObject( bmp );

    /* RLE StretchDIBits */
    src_bi->bmiHeader.biSize        = sizeof(src_bi->bmiHeader);
    src_bi->bmiHeader.biWidth       = 8;
    src_bi->bmiHeader.biHeight      = 8;
    src_bi->bmiHeader.biPlanes      = 1;
    src_bi->bmiHeader.biBitCount    = 8;
    src_bi->bmiHeader.biCompression = BI_RLE8;
    src_bi->bmiHeader.biClrUsed     = 0;
    src_bi->bmiHeader.biSizeImage   = sizeof(rle8_data);

    for (i = 0; i < 256; i++)
    {
        src_bi->bmiColors[i].rgbRed      = i;
        src_bi->bmiColors[i].rgbGreen    = i;
        src_bi->bmiColors[i].rgbBlue     = i;
        src_bi->bmiColors[i].rgbReserved = 0;
    }

    StretchDIBits( hdc,  10, 10, 7, 7, 0, 0, 7, 7, rle8_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    StretchDIBits( hdc, 100, 10, 7, 7, 0, 0, 7, 7, rle8_data, src_bi, DIB_RGB_COLORS, SRCAND );
    StretchDIBits( hdc, 200, 10, 7, 7, 0, 1, 7, 7, rle8_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    StretchDIBits( hdc, 300, 10, 7, 7, 1, 0, 7, 7, rle8_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    StretchDIBits( hdc, 400, 10, 16, 16, 0, 0, 8, 8, rle8_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    compare_hash_broken_todo(hdc,  bmi, bits, "rle stretchdibits", 0, dib_is_1bpp );

    /* 32 bpp StretchDIBits */

    src_bi->bmiHeader.biWidth       = 4;
    src_bi->bmiHeader.biHeight      = 4;
    src_bi->bmiHeader.biPlanes      = 1;
    src_bi->bmiHeader.biBitCount    = 32;
    src_bi->bmiHeader.biCompression = BI_RGB;
    src_bi->bmiHeader.biClrUsed     = 0;
    src_bi->bmiHeader.biSizeImage   = 0;

    ret = StretchDIBits( hdc,  10, 10, 4, 4, 0, 0, 4, 4, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  20, 10, 4, 4, 0, 0, 4, 4, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  30, 10, 3, 3, 1, 1, 3, 3, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  40, 10, 3, 3, 1, 1, 3, 3, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  50, 10, -2, -2, 2, 3, -2, -2, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  60, 10, -2, -2, 2, 3, -2, -2, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == 4, "got %d\n", ret);

    src_bi->bmiHeader.biHeight = -4;

    ret = StretchDIBits( hdc,  10, 100, 4, 4, 0, 0, 4, 4, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  20, 100, 4, 4, 0, 0, 4, 4, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == -4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  30, 100, 3, 3, 1, 1, 3, 3, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  40, 100, 3, 3, 1, 1, 3, 3, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == -4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  50, 100, -2, -2, 2, 3, -2, -2, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCCOPY );
    ok(ret == 4, "got %d\n", ret);
    ret = StretchDIBits( hdc,  60, 100, -2, -2, 2, 3, -2, -2, four_by_four_data, src_bi, DIB_RGB_COLORS, SRCAND );
    ok(ret == -4, "got %d\n", ret);

    compare_hash_broken_todo(hdc,  bmi, bits, "stretchdibits", dib_is_8bpp_gray ? 1 : 0, dib_is_8bpp_gray );

    /* Solid colors */
    for (i = 0; i < 256; i++)
    {
        solid_patblt( hdc, i * 2, 10, 1, 1, DIBINDEX(i) );
        solid_patblt( hdc, i * 2, 20, 1, 1, PALETTEINDEX(i) );
        solid_patblt( hdc, i * 2, 30, 1, 1, RGB( (i & 0x07) << 5, (i & 0x38) << 2, i & 0xc0 ) );
        solid_patblt( hdc, i * 2, 40, 1, 1, PALETTERGB( (i & 0x07) << 5, (i & 0x38) << 2, i & 0xc0 ) );
        for (j = 0; j < 256; j++) solid_patblt( hdc, i * 2, 50 + j, 1, 1, (j << 24) | i );
    }

    /* A few extra colors that are interesting in the 1bpp case */

    /* bk color */
    solid_patblt( hdc, 0, 50, 1, 1, RGB( 0, 0xff, 0 ) );
    solid_patblt( hdc, 2, 50, 1, 1, PALETTERGB( 0, 0xff, 0 ) );

    /* color 0 */
    solid_patblt( hdc, 4, 50, 1, 1, RGB( 0, 0x1, 0xff ) );
    solid_patblt( hdc, 6, 50, 1, 1, PALETTERGB( 0, 0x1, 0xff ) );

    /* color 1 */
    solid_patblt( hdc,  8, 50, 1, 1, RGB( 0xff, 0, 0 ) );
    solid_patblt( hdc, 10, 50, 1, 1, PALETTERGB( 0xff, 0, 0 ) );

    compare_hash(hdc, bmi, bits, "Colors");

    for (i = 0; i < 256; i++)
    {
        COLORREF s, g;
        s = SetPixel( hdc, i * 2, 10, DIBINDEX(i) );
        g = GetPixel( hdc, i * 2, 10 );
        ok( s == g, "got %08x and %08x\n", s, g );

        s = SetPixel( hdc, i * 2, 20, PALETTEINDEX(i) );
        g = GetPixel( hdc, i * 2, 20 );
        ok( s == g, "got %08x and %08x\n", s, g );

        s = SetPixel( hdc, i * 2, 30, RGB( (i & 0x07) << 5, (i & 0x38) << 2, i & 0xc0 ) );
        g = GetPixel( hdc, i * 2, 30 );
        ok( s == g, "got %08x and %08x\n", s, g );

        s = SetPixel( hdc, i * 2, 40, PALETTERGB( (i & 0x07) << 5, (i & 0x38) << 2, i & 0xc0 ) );
        g = GetPixel( hdc, i * 2, 40 );
        ok( s == g, "got %08x and %08x\n", s, g );

        for (j = 0; j < 256; j++)
        {
            s = SetPixel( hdc, i * 2, 50+j, (j << 24) | RGB( (i & 0x07) << 5, (i & 0x38) << 2, i & 0xc0 ));
            g = GetPixel( hdc, i * 2, 50+j );
            ok( s == g, "got %08x and %08x\n", s, g );

            s = SetPixel( hdc, i * 2 + 1, 50+j, (j << 24) | i );
            g = GetPixel( hdc, i * 2 + 1, 50+j );
            ok( s == g, "got %08x and %08x\n", s, g );
        }
    }

    compare_hash(hdc, bmi, bits, "SetPixel");

    /* gradients */

    if (pGdiGradientFill)
    {
        TRIVERTEX vrect[] =
        {
            {   1,   1, 0xff00, 0x8000, 0x0000, 0x8000 },
            { 200, 200, 0x0000, 0x0000, 0xff00, 0xff00 },
            { 180, 180, 0x1234, 0x5678, 0x9abc, 0xdef0 },
            { 300, 300, 0xff00, 0xff00, 0xff00, 0x0000 }
        };
        GRADIENT_RECT rect[] = { { 0, 1 }, { 2, 3 }, { 2, 1 } };

        TRIVERTEX vtri[] =
        {
            { 250,   0, 0xff00, 0x0000, 0xff00, 0xff00 },
            { 500, 500, 0x0000, 0xff00, 0x0000, 0xff00 },
            {   0, 500, 0x0000, 0x0000, 0xff00, 0xff00 },

            {  10,   0, 0x8000, 0x0000, 0x8000, 0x8000 },
            {   0,  20, 0xff00, 0xff00, 0xff00, 0x0000 },
            {   5,  30, 0x4000, 0xc000, 0x7000, 0x9000 },

            {  30,   0, 0x9000, 0x8800, 0xcc00, 0xff00 },
            {   5,  12, 0x9900, 0xaa00, 0xbb00, 0xcc00 },
            {   0,  30, 0x5000, 0xd000, 0x9000, 0xbb00 },

            {  35,   3, 0xaa00, 0x6500, 0x4300, 0x2100 },
            {  50,   6, 0x9800, 0x9800, 0x9800, 0x2000 },
            {  60,  10, 0x0100, 0x0200, 0x0300, 0x3000 },

            {  60,   2, 0x0700, 0x0800, 0x0900, 0xff00 },
            {  73,  10, 0x9900, 0x8800, 0x7700, 0xff00 },
            {  66,  23, 0x1100, 0x2200, 0x3300, 0xff00 },

            {  80,   1, 0xa000, 0x6000, 0x4000, 0x2000 },
            {  76,   9, 0x7000, 0x5000, 0x3000, 0x1000 },
            {  85,  23, 0x3300, 0x3300, 0x3300, 0x3300 },

            {  90,   4, 0x4400, 0x5500, 0x6600, 0x9900 },
            {  95,  12, 0x4500, 0x5600, 0x6700, 0x9900 },
            {  85,  14, 0x4600, 0x5700, 0x6800, 0x9900 },
        };
        GRADIENT_TRIANGLE tri[] =
        {
            { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 9, 10, 11 }, { 12, 13, 14 }, { 15, 16, 17 }, { 18, 19, 20 },
            { 2, 1, 0 }, { 3, 5, 4 }, { 7, 6, 8 }, { 10, 11, 9 }, { 14, 13, 12 }, { 17, 15, 16 }, { 19, 20, 18 }
        };

        pGdiGradientFill( hdc, vrect, 4, rect, 2, GRADIENT_FILL_RECT_H );
        for (i = 0; i < 4; i++) vrect[i].y += 250;
        pGdiGradientFill( hdc, vrect, 4, rect, 2, GRADIENT_FILL_RECT_V );

        if (bmi->bmiHeader.biBitCount <= 8) /* Wine's 8-bit dithering isn't identical to Windows */
            compare_hash_broken_todo(hdc,  bmi, bits, "GdiGradientFill", 0, 1 );
        else
            compare_hash(hdc, bmi, bits, "GdiGradientFill" );

        pGdiGradientFill( hdc, vtri, 7*3, tri, 7, GRADIENT_FILL_TRIANGLE );
        for (i = 0; i < 7*3; i++) vtri[i].y += 100;
        pGdiGradientFill( hdc, vtri, 7*3, tri + 7, 7, GRADIENT_FILL_TRIANGLE );
        if (bmi->bmiHeader.biBitCount <= 8) /* Wine's 8-bit dithering isn't identical to Windows */
            compare_hash_broken_todo(hdc,  bmi, bits, "GdiGradientFill", 0, 1 );
        else
            compare_hash(hdc, bmi, bits, "GdiGradientFill" );
    }
    else
    {
        win_skip( "GdiGradientFill not supported\n" );
        skip_compare(1);
        skip_compare(1);
    }

    /* wide pen */

    wide_pen = CreatePen( PS_SOLID, 7, RGB( 0xff, 0, 0 ) );
    SelectObject( hdc, wide_pen );

    for (i = 0; i < sizeof( wide_lines ) / sizeof( wide_lines[0] ); i++)
    {
        MoveToEx( hdc, wide_lines[i].left, wide_lines[i].top, NULL );
        LineTo( hdc, wide_lines[i].right, wide_lines[i].bottom );
    }

    compare_hash(hdc, bmi, bits, "wide pen" );

    SelectObject( hdc, orig_pen );
    DeleteObject( wide_pen );

    log_brush.lbStyle = BS_SOLID;
    log_brush.lbColor = RGB(0xff, 0, 0);
    log_brush.lbHatch = 0;

    wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_FLAT | PS_JOIN_MITER | PS_SOLID,
                             9, &log_brush, 0, NULL );
    SelectObject( hdc, wide_pen );

    Polyline( hdc, poly_lines, sizeof(poly_lines) / sizeof(poly_lines[0]) );
    compare_hash(hdc, bmi, bits, "wide pen - flat caps, mitred" );

    SelectObject( hdc, orig_pen );
    DeleteObject( wide_pen );

    wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_SQUARE | PS_JOIN_BEVEL | PS_SOLID,
                             16, &log_brush, 0, NULL );
    SelectObject( hdc, wide_pen );

    Polyline( hdc, poly_lines, sizeof(poly_lines) / sizeof(poly_lines[0]) );
    compare_hash(hdc, bmi, bits, "wide pen - square caps, bevelled" );

    SelectObject( hdc, orig_pen );
    DeleteObject( wide_pen );

    wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_FLAT | PS_JOIN_MITER | PS_SOLID,
                             9, &log_brush, 0, NULL );
    SelectObject( hdc, wide_pen );

    PolyPolyline( hdc, polypoly_lines, polypoly_counts, sizeof(polypoly_counts)/sizeof(polypoly_counts[0]) );
    compare_hash(hdc, bmi, bits, "wide pen - empty segments" );

    SelectObject( hdc, orig_pen );
    DeleteObject( wide_pen );

    /* brushed wide pen */

    old_text = GetTextColor( hdc );
    old_bkgnd = GetBkColor( hdc );
    bmp = CreateBitmap( 16, 16, 1, 1, ddb_brush_bits );
    log_brush.lbStyle = BS_PATTERN;
    log_brush.lbColor = 0;
    log_brush.lbHatch = (ULONG_PTR)bmp;
    wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_FLAT | PS_JOIN_BEVEL | PS_SOLID,
                             12, &log_brush, 0, NULL );
    ok( wide_pen != 0, "failed to create pen\n" );
    SelectObject( hdc, wide_pen );
    Polyline( hdc, poly_lines, sizeof(poly_lines) / sizeof(poly_lines[0]) );

    for (i = 1; i < 20; i++)
    {
        wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_FLAT | PS_JOIN_BEVEL | PS_SOLID,
                                 i, &log_brush, 0, NULL );
        ok( wide_pen != 0, "failed to create pen\n" );
        DeleteObject( SelectObject( hdc, wide_pen ));
        SetTextColor(hdc, RGB( 2*i, i, 255 - i ) );
        SetBkColor(hdc, RGB( 255 - i, i, i / 3 ) );
        MoveToEx( hdc, 10 * i, 10, NULL );
        LineTo( hdc, 10 * i, 200 + i );
        LineTo( hdc, 20 * i, 200 + i );
    }
    /* NT4 broken for all cases, W2K for 1 bpp only */
    compare_hash_broken_todo(hdc,  bmi, bits, "wide brushed pen", 1 + dib_is_1bpp, dib_is_1bpp );

    for (i = 1; i < 20; i++)
    {
        wide_pen = ExtCreatePen( PS_GEOMETRIC | PS_ENDCAP_FLAT | PS_JOIN_BEVEL | (i % 5),
                                 i, &log_brush, 0, NULL );
        DeleteObject( SelectObject( hdc, wide_pen ));
        SetTextColor(hdc, RGB( 2*i, i, 255 - i ) );
        SetBkColor(hdc, RGB( i, 255 - i, i / 3 ) );
        MoveToEx( hdc, 10 * i, 10, NULL );
        LineTo( hdc, 10 * i, 200 + i );
        LineTo( hdc, 20 * i, 200 + i );
    }
    /* NT4 broken for all cases, W2K for 1 bpp only */
    compare_hash_broken_todo(hdc,  bmi, bits, "dashed wide brushed pen", 1 + dib_is_1bpp, dib_is_1bpp );

    DeleteObject(bmp);
    SetTextColor(hdc, old_text);
    SetBkColor(hdc, old_bkgnd);
    SelectObject( hdc, orig_pen );

    /* PALETTEINDEX */

    solid_brush = CreateSolidBrush( PALETTEINDEX(3) );
    solid_pen = CreatePen( PS_DASH, 1, PALETTEINDEX(5) );
    SetTextColor( hdc, PALETTEINDEX(38) );
    SetBkColor( hdc, PALETTEINDEX(9) );
    SelectObject( hdc, solid_brush );
    SelectObject( hdc, solid_pen );

    pal->palVersion = 0x300;
    pal->palNumEntries = 40;
    for (i = 0; i < 80; i++)
    {
        entries[i].peRed   = i * 3;
        entries[i].peGreen = i * 7;
        entries[i].peBlue  = 128 - i;
        entries[i].peFlags = 0;
    }
    hpal = CreatePalette( pal );
    old_hpal = SelectPalette( hdc, hpal, FALSE );

    solid_patblt( hdc, 20, 10, 10, 10, PALETTEINDEX(15) );
    Rectangle( hdc, 0, 0, 10, 10 );
    SetPaletteEntries( hpal, 0, 40, entries + 40 );
    Rectangle( hdc, 10, 0, 10, 10 );
    SelectObject( hdc, orig_brush );
    DeleteObject( solid_brush );

    solid_brush = CreateHatchBrush( HS_CROSS, PALETTEINDEX(7) );
    DeleteObject( SelectObject( hdc, solid_brush ));
    PatBlt( hdc, 20, 0, 10, 10, PATCOPY );
    SetPaletteEntries( hpal, 0, 40, entries );
    PatBlt( hdc, 30, 0, 10, 10, PATCOPY );
    SelectObject( hdc, orig_brush );
    DeleteObject( solid_brush );

    bmp = CreateBitmap( 16, 16, 1, 1, ddb_brush_bits );
    dib_brush = CreatePatternBrush( bmp );
    SelectObject( hdc, dib_brush );
    PatBlt( hdc, 40, 0, 10, 10, PATCOPY );
    SetPaletteEntries( hpal, 0, 40, entries + 40 );
    PatBlt( hdc, 50, 0, 10, 10, PATCOPY );
    DeleteObject( bmp );
    SelectObject( hdc, orig_brush );
    DeleteObject( dib_brush );

    SelectPalette( hdc, old_hpal, FALSE );
    DeleteObject( hpal );

    /* NT4 broken for all cases, W2K for 1 bpp only */
    compare_hash_broken_todo(hdc, bmi, bits, "PALETTEINDEX", 1 + dib_is_1bpp, dib_is_1bpp );

    /* ExtFloodFill */

    solid_patblt( hdc,   0,   0, 512, 512, RGB( 0, 0, 0xff ) );
    solid_patblt( hdc,  10,  10, 200, 200, RGB( 0, 0xff, 0 ) );
    solid_patblt( hdc,  10,  50,  50,  50, RGB( 0, 0, 0xff ) );
    solid_patblt( hdc, 100, 160,  50,  50, RGB( 0, 0, 0xff ) );
    solid_patblt( hdc,  90, 160,  70,  10, RGB( 0, 0, 0xff ) );

    /* add a vertical 'bar' to show that the clip rgn stops the flooding */
    hrgn = CreateRectRgn( 180, 10, 190, 210 );
    ExtSelectClipRgn( hdc, hrgn, RGN_DIFF );
    DeleteObject( hrgn );

    solid_brush = CreateSolidBrush( RGB( 0xff, 0, 0 ) );
    SelectObject( hdc, solid_brush );

    ret = ExtFloodFill( hdc, 100, 100, RGB( 0, 0xff, 0 ), FLOODFILLSURFACE );
    ok (ret, "got ret %d\n", ret);
    compare_hash(hdc, bmi, bits, "flood fill" );

    ExtSelectClipRgn( hdc, NULL, RGN_COPY );

    SelectObject(hdc, orig_brush);
    SelectObject(hdc, orig_pen);
    DeleteObject(solid_brush);
    DeleteObject(wide_pen);
    DeleteObject(dashed_pen);
    DeleteObject(solid_pen);
}

static const BYTE ramp[17] =
{
    0,    0x4d, 0x68, 0x7c,
    0x8c, 0x9a, 0xa7, 0xb2,
    0xbd, 0xc7, 0xd0, 0xd9,
    0xe1, 0xe9, 0xf0, 0xf8,
    0xff
};

static inline void get_range(BYTE alpha, DWORD text_comp, BYTE *min_comp, BYTE *max_comp)
{
    *min_comp = (ramp[alpha] * text_comp) / 0xff;
    *max_comp = ramp[16 - alpha] + ((0xff - ramp[16 - alpha]) * text_comp) / 0xff;
}

static inline BYTE aa_comp(BYTE dst, BYTE text, BYTE alpha)
{
    BYTE min_comp, max_comp;

    if (alpha == 16)  return text;
    if (alpha <= 1)   return dst;
    if (text == dst)  return dst;

    get_range( alpha, text, &min_comp, &max_comp );

    if (dst > text)
    {
        DWORD diff = dst - text;
        DWORD range = max_comp - text;
        dst = text + (diff * range ) / (0xff - text);
        return dst;
    }
    else
    {
        DWORD diff = text - dst;
        DWORD range = text - min_comp ;
        dst = text - (diff * range) / text;
        return dst;
    }
}

static inline COLORREF aa_colorref( COLORREF dst, COLORREF text, BYTE glyph )
{
    COLORREF ret;

    ret = RGB( aa_comp( GetRValue(dst), GetRValue(text), glyph ),
               aa_comp( GetGValue(dst), GetGValue(text), glyph ),
               aa_comp( GetBValue(dst), GetBValue(text), glyph ) );
    return ret;
}

static const BYTE masks[8] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

static void draw_text_2( HDC hdc, const BITMAPINFO *bmi, BYTE *bits, BOOL aa )
{
    DWORD dib_size = get_dib_size(bmi), ret;
    LOGFONTA lf;
    HFONT font;
    GLYPHMETRICS gm;
    BYTE g_buf[10000];
    int i, stride, x, y;
    static const MAT2 identity = { {0,1}, {0,0}, {0,0}, {0,1} };
    char *eto_hash = NULL, *diy_hash = NULL;
    static const char str[] = "Hello Wine";
    POINT origin, g_org;
    static const BYTE vals[4] = { 0x00, 0x00, 0x00, 0x00 };
    TEXTMETRICA tm;
    COLORREF text_color;

    for(i = 0; i < dib_size; i++)
        bits[i] = vals[i % 4];

    memset( &lf, 0, sizeof(lf) );
    strcpy( lf.lfFaceName, "Tahoma" );
    lf.lfHeight = 24;
    lf.lfQuality = aa ? ANTIALIASED_QUALITY : NONANTIALIASED_QUALITY;

    font = CreateFontIndirectA( &lf );
    font = SelectObject( hdc, font );

    GetTextMetricsA( hdc, &tm );
    if (!(tm.tmPitchAndFamily & TMPF_VECTOR))
    {
        skip( "skipping as a bitmap font has been selected for Tahoma.\n" );
        DeleteObject( SelectObject( hdc, font ) );
        return;
    }

    SetTextColor( hdc, RGB(0xff, 0x00, 0x00) );
    SetTextAlign( hdc, TA_BASELINE );
    SetBkMode( hdc, TRANSPARENT );
    origin.x = 10;
    origin.y = 100;

    ExtTextOutA( hdc, origin.x, origin.y, 0, NULL, str, strlen(str), NULL );
    eto_hash = hash_dib( bmi, bits );

    for(i = 0; i < dib_size; i++)
        bits[i] = vals[i % 4];

    if (bmi->bmiHeader.biBitCount <= 8) aa = FALSE;

    text_color = GetTextColor( hdc );
    for (i = 0; i < strlen(str); i++)
    {
        DWORD ggo_flags = aa ? GGO_GRAY4_BITMAP : GGO_BITMAP;

        ret = GetGlyphOutlineA( hdc, str[i], ggo_flags, &gm, 0, NULL, &identity );

        if (ret == GDI_ERROR) continue;

        if (ret) GetGlyphOutlineA( hdc, str[i], ggo_flags, &gm, sizeof(g_buf), g_buf, &identity );

        g_org.x = origin.x + gm.gmptGlyphOrigin.x;
        g_org.y = origin.y - gm.gmptGlyphOrigin.y;

        origin.x += gm.gmCellIncX;
        origin.y += gm.gmCellIncY;

        if (!ret) continue;

        if (aa)
        {
            stride = (gm.gmBlackBoxX + 3) & ~3;

            for (y = 0; y < gm.gmBlackBoxY; y++)
            {
                BYTE *g_ptr = g_buf + y * stride;
                COLORREF val;

                for (x = 0; x < gm.gmBlackBoxX; x++)
                {
                    if (g_ptr[x] <= 1) continue;
                    if (g_ptr[x] >= 16) val = text_color;
                    else
                    {
                        val = GetPixel( hdc, g_org.x + x, g_org.y + y );
                        val = aa_colorref( val, text_color, g_ptr[x] );
                    }
                    SetPixel( hdc, g_org.x + x, g_org.y + y, val );
                }
            }
        }
        else
        {
            stride = ((gm.gmBlackBoxX + 31) >> 3) & ~3;

            for (y = 0; y < gm.gmBlackBoxY; y++)
            {
                BYTE *g_ptr = g_buf + y * stride;
                for (x = 0; x < gm.gmBlackBoxX; x++)
                {
                    if (g_ptr[x / 8] & masks[x % 8])
                        SetPixel( hdc, g_org.x + x, g_org.y + y, text_color );
                }
            }
        }
    }

    diy_hash = hash_dib( bmi, bits );
    ok( !strcmp( eto_hash, diy_hash ), "hash mismatch - aa %d\n", aa );

    HeapFree( GetProcessHeap(), 0, diy_hash );
    HeapFree( GetProcessHeap(), 0, eto_hash );

    font = SelectObject( hdc, font );
    DeleteObject( font );
}

static void draw_text( HDC hdc, const BITMAPINFO *bmi, BYTE *bits )
{
    draw_text_2( hdc, bmi, bits, FALSE );

    /* Rounding errors make these cases hard to test */
    if ((bmi->bmiHeader.biCompression == BI_BITFIELDS && ((DWORD*)bmi->bmiColors)[0] == 0x3f000) ||
        (bmi->bmiHeader.biBitCount == 16))
        return;

    draw_text_2( hdc, bmi, bits, TRUE );
}

static void test_simple_graphics(void)
{
    char bmibuf[sizeof(BITMAPINFO) + 256 * sizeof(RGBQUAD)];
    BITMAPINFO *bmi = (BITMAPINFO *)bmibuf;
    RGBQUAD *colors = bmi->bmiColors;
    DWORD *bit_fields = (DWORD*)(bmibuf + sizeof(BITMAPINFOHEADER));
    HDC mem_dc;
    BYTE *bits;
    HBITMAP dib, orig_bm;
    DIBSECTION ds;
    HPALETTE default_palette, old_hpal;
    int i;

    mem_dc = CreateCompatibleDC(NULL);

    /* a8r8g8b8 */
    trace("8888\n");
    memset(bmi, 0, sizeof(bmibuf));
    bmi->bmiHeader.biSize = sizeof(bmi->bmiHeader);
    bmi->bmiHeader.biHeight = 512;
    bmi->bmiHeader.biWidth = 512;
    bmi->bmiHeader.biBitCount = 32;
    bmi->bmiHeader.biPlanes = 1;
    bmi->bmiHeader.biCompression = BI_RGB;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_RGB ||
       broken(ds.dsBmih.biCompression == BI_BITFIELDS), /* nt4 sp1 and 2 */
       "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    default_palette = create_default_palette( 8 );
    old_hpal = SelectPalette( mem_dc, default_palette, FALSE );

    dst_format = "8888";
    current_sha1 = sha1_graphics_a8r8g8b8;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* a8r8g8b8 - bitfields.  Should be the same as the regular 32 bit case.*/
    trace("8888 - bitfields\n");
    bmi->bmiHeader.biBitCount = 32;
    bmi->bmiHeader.biCompression = BI_BITFIELDS;
    bit_fields[0] = 0xff0000;
    bit_fields[1] = 0x00ff00;
    bit_fields[2] = 0x0000ff;

    dib = CreateDIBSection(mem_dc, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0xff0000, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x00ff00, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0x0000ff, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);
    SelectPalette( mem_dc, default_palette, FALSE );

    dst_format = "8888 - bitfields";
    current_sha1 = sha1_graphics_a8r8g8b8_bitfields;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* a8b8g8r8. */
    trace("a8b8g8r8\n");
    bmi->bmiHeader.biBitCount = 32;
    bmi->bmiHeader.biCompression = BI_BITFIELDS;
    bit_fields[0] = 0x0000ff;
    bit_fields[1] = 0x00ff00;
    bit_fields[2] = 0xff0000;

    dib = CreateDIBSection(mem_dc, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0x0000ff, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x00ff00, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0xff0000, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "a8b8g8r8";
    current_sha1 = sha1_graphics_a8b8g8r8;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* r10g10b10. */
    trace("r10g10b10\n");
    bmi->bmiHeader.biBitCount = 32;
    bmi->bmiHeader.biCompression = BI_BITFIELDS;
    bit_fields[0] = 0x3ff00000;
    bit_fields[1] = 0x000ffc00;
    bit_fields[2] = 0x000003ff;

    dib = CreateDIBSection(mem_dc, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0x3ff00000, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x000ffc00, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0x000003ff, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "r10g10b10";
    current_sha1 = sha1_graphics_r10g10b10;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* r6g6b6. */
    trace("r6g6b6\n");
    bmi->bmiHeader.biBitCount = 32;
    bmi->bmiHeader.biCompression = BI_BITFIELDS;
    bit_fields[0] = 0x0003f000;
    bit_fields[1] = 0x00000fc0;
    bit_fields[2] = 0x0000003f;

    dib = CreateDIBSection(mem_dc, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0x0003f000, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x00000fc0, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0x0000003f, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "r6g6b6";
    current_sha1 = sha1_graphics_r6g6b6;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 24 */
    trace("24\n");
    bmi->bmiHeader.biBitCount = 24;
    bmi->bmiHeader.biCompression = BI_RGB;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "24";
    current_sha1 = sha1_graphics_24;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* r5g5b5 */
    trace("555\n");
    bmi->bmiHeader.biBitCount = 16;
    bmi->bmiHeader.biCompression = BI_RGB;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0x7c00, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x03e0, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0x001f, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "r5g5b5";
    current_sha1 = sha1_graphics_r5g5b5;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* r4g4b4 */
    trace("444\n");
    bmi->bmiHeader.biBitCount = 16;
    bmi->bmiHeader.biCompression = BI_BITFIELDS;
    bit_fields[0] = 0x0f00;
    bit_fields[1] = 0x00f0;
    bit_fields[2] = 0x000f;
    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");
    ok(GetObjectW( dib, sizeof(ds), &ds ), "GetObject failed\n");
    ok(ds.dsBitfields[0] == 0x0f00, "got %08x\n", ds.dsBitfields[0]);
    ok(ds.dsBitfields[1] == 0x00f0, "got %08x\n", ds.dsBitfields[1]);
    ok(ds.dsBitfields[2] == 0x000f, "got %08x\n", ds.dsBitfields[2]);
    ok(ds.dsBmih.biCompression == BI_BITFIELDS, "got %x\n", ds.dsBmih.biCompression);

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "r4g4b4";
    current_sha1 = sha1_graphics_r4g4b4;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 8 color */
    trace("8 color\n");
    bmi->bmiHeader.biBitCount = 8;
    bmi->bmiHeader.biCompression = BI_RGB;
    bmi->bmiHeader.biClrUsed = 236;
    for (i = 0; i < 236; i++)
    {
        colors[i].rgbRed   = (i & 0x07) << 5;
        colors[i].rgbGreen = (i & 0x38) << 2;
        colors[i].rgbBlue  =  i & 0xc0;
    }
    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "8 color";
    current_sha1 = sha1_graphics_8_color;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 8 grayscale */
    trace("8 grayscale\n");
    bmi->bmiHeader.biBitCount = 8;
    bmi->bmiHeader.biCompression = BI_RGB;
    bmi->bmiHeader.biClrUsed = 256;
    for (i = 0; i < 256; i++) colors[i].rgbRed = colors[i].rgbGreen = colors[i].rgbBlue = i;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "8 grayscale";
    current_sha1 = sha1_graphics_8_grayscale;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 8 */
    trace("8\n");
    bmi->bmiHeader.biBitCount = 8;
    bmi->bmiHeader.biCompression = BI_RGB;
    bmi->bmiHeader.biClrUsed = 5;
    colors[0].rgbRed = 0xff;
    colors[0].rgbGreen = 0xff;
    colors[0].rgbBlue = 0xff;
    colors[1].rgbRed = 0;
    colors[1].rgbGreen = 0;
    colors[1].rgbBlue = 0;
    colors[2].rgbRed = 0xff;
    colors[2].rgbGreen = 0;
    colors[2].rgbBlue = 0;
    colors[3].rgbRed = 0;
    colors[3].rgbGreen = 0xff;
    colors[3].rgbBlue = 0;
    colors[4].rgbRed = 0;
    colors[4].rgbGreen = 0;
    colors[4].rgbBlue = 0xff;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "8";
    current_sha1 = sha1_graphics_8;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 4 */
    trace("4\n");
    bmi->bmiHeader.biBitCount = 4;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);
    DeleteObject( SelectPalette( mem_dc, create_default_palette(4), FALSE ));

    dst_format = "4";
    current_sha1 = sha1_graphics_4;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 4 grayscale */
    trace("4 grayscale\n");
    bmi->bmiHeader.biClrUsed = 16;
    for (i = 0; i < 16; i++) colors[i].rgbRed = colors[i].rgbGreen = colors[i].rgbBlue = i * 17;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);

    dst_format = "4 grayscale";
    current_sha1 = sha1_graphics_4_grayscale;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    /* 1 */
    trace("1\n");
    bmi->bmiHeader.biBitCount = 1;
    bmi->bmiHeader.biClrUsed = 2;

    colors[0].rgbRed = 0x00;
    colors[0].rgbGreen = 0x01;
    colors[0].rgbBlue = 0xff;
    colors[1].rgbRed = 0xff;
    colors[1].rgbGreen = 0x00;
    colors[1].rgbBlue = 0x00;

    dib = CreateDIBSection(0, bmi, DIB_RGB_COLORS, (void**)&bits, NULL, 0);
    ok(dib != NULL, "ret NULL\n");

    orig_bm = SelectObject(mem_dc, dib);
    DeleteObject( SelectPalette( mem_dc, create_default_palette(1), FALSE ));

    dst_format = "1";
    current_sha1 = sha1_graphics_1;
    draw_graphics(mem_dc, bmi, bits);
    draw_text(mem_dc, bmi, bits);

    DeleteObject( SelectPalette( mem_dc, old_hpal, FALSE ));
    SelectObject(mem_dc, orig_bm);
    DeleteObject(dib);

    DeleteDC(mem_dc);
}

START_TEST(dib)
{
    HMODULE mod = GetModuleHandleA("gdi32.dll");
    pSetLayout = (void *)GetProcAddress( mod, "SetLayout" );
    pGdiAlphaBlend = (void *)GetProcAddress( mod, "GdiAlphaBlend" );
    pGdiGradientFill = (void *)GetProcAddress( mod, "GdiGradientFill" );

    CryptAcquireContextW(&crypt_prov, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT);

    test_simple_graphics();

    CryptReleaseContext(crypt_prov, 0);
}
