/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class Lexer {
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    static final int UMIN = 6;
    static final int POWER = 7;
    static final int FACT = 8;
    static final int NUMBER = 9;
    static final int CONST = 10;
    static final int CALL = 11;
    static final int COMMA = 12;
    static final int LPAREN = 13;
    static final int RPAREN = 14;
    static final int END = 15;
    static final int SQRT = 16;
    static final Token TOK_ADD = new Token(1, 3, 2, 3);
    static final Token TOK_SUB = new Token(2, 3, 2, 4);
    static final Token TOK_MUL = new Token(3, 4, 2, 5);
    static final Token TOK_DIV = new Token(4, 4, 2, 6);
    static final Token TOK_MOD = new Token(5, 4, 2, 7);
    static final Token TOK_UMIN = new Token(6, 5, 1, 9);
    static final Token TOK_POWER = new Token(7, 6, 3, 10);
    static final Token TOK_FACT = new Token(8, 7, 4, 11);
    static final Token TOK_SQRT = new Token(16, 8, 1, 12);
    static final Token TOK_LPAREN = new Token(13, 1, 1, 0);
    static final Token TOK_RPAREN = new Token(14, 2, 0, 0);
    static final Token TOK_COMMA = new Token(12, 1, 0, 0);
    static final Token TOK_END = new Token(15, 0, 0, 0);
    static final Token TOK_NUMBER = new Token(9, 20, 0, 0);
    static final Token TOK_CONST = new Token(10, 20, 0, 0);
    private static final String WHITESPACE = " \n\r\t";
    private static final char END_MARKER = '$';
    private char[] input = new char[32];
    private int pos;
    private SyntaxException exception;

    Lexer(SyntaxException syntaxException) {
        this.exception = syntaxException;
        this.init("");
    }

    void scan(String string, TokenConsumer tokenConsumer) throws SyntaxException {
        Token token;
        this.init(string);
        tokenConsumer.start();
        do {
            int n = this.pos;
            token = this.nextToken();
            token.position = n;
            tokenConsumer.push(token);
        } while (token != TOK_END);
    }

    void init(String string) {
        this.exception.expression = string;
        int n = string.length();
        if (this.input.length < n + 1) {
            this.input = new char[n + 1];
        }
        string.getChars(0, n, this.input, 0);
        this.input[n] = 36;
        this.pos = 0;
    }

    Token nextToken() throws SyntaxException {
        while (WHITESPACE.indexOf(this.input[this.pos]) != -1) {
            ++this.pos;
        }
        char c = this.input[this.pos];
        int n = this.pos++;
        switch (c) {
            case '!': {
                return TOK_FACT;
            }
            case '$': {
                return TOK_END;
            }
            case '%': {
                return TOK_MOD;
            }
            case '(': {
                return TOK_LPAREN;
            }
            case ')': {
                return TOK_RPAREN;
            }
            case '*': {
                return TOK_MUL;
            }
            case '+': {
                return TOK_ADD;
            }
            case ',': {
                return TOK_COMMA;
            }
            case '-': {
                return TOK_SUB;
            }
            case '/': {
                return TOK_DIV;
            }
        }
        if (c == '^') {
            return TOK_POWER;
        }
        int n2 = this.pos;
        if ('0' <= c && c <= '9' || c == '.') {
            while ('0' <= c && c <= '9' || c == '.' || c == 'E' || c == 'e') {
                if (c != 'E' && c != 'e' || this.input[n2] == '-') {
                    // empty if block
                }
                int n3 = ++n2;
                ++n2;
                c = this.input[n3];
            }
            this.pos = n2 - 1;
            String string = String.valueOf(this.input, n, n2 - 1 - n);
            try {
                if (string.equals(".")) {
                    return TOK_NUMBER.setValue(0.0);
                }
                double d = Double.parseDouble(string);
                return TOK_NUMBER.setValue(d);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.exception.set("invalid number '" + string + "'", n);
            }
        }
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            while ('a' <= (c = this.input[n2++]) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
            }
            String string = String.valueOf(this.input, n, n2 - 1 - n);
            while (WHITESPACE.indexOf(c) != -1) {
                c = this.input[n2++];
            }
            if (c == '(') {
                this.pos = n2;
                return new Token(11, 0, 1, 0).setAlpha(string);
            }
            this.pos = n2 - 1;
            return TOK_CONST.setAlpha(string);
        }
        if (c >= '\u0391' && c <= '\u03a9' || c >= '\u03b1' && c <= '\u03c9') {
            return TOK_CONST.setAlpha("" + c);
        }
        switch (c) {
            case '^': {
                return TOK_POWER;
            }
            case '\u00d7': {
                return TOK_MUL;
            }
            case '\u00f7': {
                return TOK_DIV;
            }
            case '\u2212': {
                return TOK_SUB;
            }
            case '\u221a': {
                return TOK_SQRT;
            }
        }
        throw this.exception.set("invalid character '" + c + "'", n);
    }
}

