/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class TrivialDOM {
    public static final int TYPE_NODE = 1;
    public static final int TYPE_TEXT = 2;
    Node doc = null;

    public Node CreateNode(String Name) {
        return new Node(Name);
    }

    public Text CreateText(String Text2, boolean Preserve) {
        return new Text(Text2, Preserve);
    }

    public TrivialDOM() {
    }

    public TrivialDOM(String DocName) {
        this.doc = new Node(DocName);
    }

    public TrivialDOM(Node DocNode) {
        this.doc = DocNode;
    }

    public Node Document() {
        return this.doc;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            TrivialDOM.WriteXML(out, this);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return out.toString();
    }

    public static TrivialDOM ReadXML(BufferedReader in) throws IOException {
        String str;
        ArrayList<String> chunks;
        block33: {
            String EOF = "ReadXML: unexpected end of file during parsing";
            chunks = new ArrayList<String>();
            str = "";
            while (true) {
                int ich;
                if (str.length() == 0) {
                    ich = in.read();
                    if (ich < 0) break block33;
                    str = String.valueOf((char)ich);
                }
                if (str.charAt(0) == '<') {
                    for (int n = 0; n < 2; ++n) {
                        ich = in.read();
                        if (ich < 0) {
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        }
                        str = str + (char)ich;
                    }
                    if (str.startsWith("<![")) {
                        do {
                            if ((ich = in.read()) >= 0) continue;
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        } while (!(str = str + (char)ich).endsWith("]]>"));
                        chunks.add(str);
                        str = "";
                        continue;
                    }
                    if (str.startsWith("<!-")) {
                        do {
                            if ((ich = in.read()) >= 0) continue;
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        } while (!(str = str + (char)ich).endsWith("-->"));
                        chunks.add(str);
                        str = "";
                        continue;
                    }
                    boolean inquot = false;
                    while (true) {
                        if ((ich = in.read()) < 0) {
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        }
                        str = str + (char)ich;
                        if ((char)ich == '\"') {
                            inquot = !inquot;
                            continue;
                        }
                        if ((char)ich == '>') break;
                    }
                    chunks.add(str);
                    str = "";
                    continue;
                }
                boolean eof = false;
                while (true) {
                    if ((ich = in.read()) < 0) {
                        eof = true;
                        break;
                    }
                    if ((char)ich == '<') {
                        chunks.add(str);
                        str = String.valueOf((char)ich);
                        break;
                    }
                    str = str + (char)ich;
                }
                if (eof) break;
            }
            if (str.trim().length() != 0) {
                throw new IOException("ReadXML: unexpected end of file during parsing");
            }
        }
        TrivialDOM xml = new TrivialDOM("unknown");
        Node node = null;
        for (int n = 0; n < chunks.size(); ++n) {
            str = (String)chunks.get(n);
            if (str.trim().length() == 0) continue;
            if (str.charAt(0) == '<' && str.length() >= 2 && (str.charAt(1) >= 'A' && str.charAt(1) <= 'Z' || str.charAt(1) >= 'a' && str.charAt(1) <= 'z') && str.endsWith(">")) {
                boolean isclosed = (str = str.substring(1, str.length() - 1)).endsWith("/");
                if (isclosed) {
                    str = str.substring(0, str.length() - 1);
                }
                String[] bits = str.split(" ");
                Node newNode = null;
                if (node == null) {
                    newNode = xml.Document();
                    newNode.SetNodeName(bits[0]);
                } else {
                    newNode = node.AppendNode(bits[0]);
                }
                for (int i = 1; i < bits.length; ++i) {
                    int spc = bits[i].indexOf("=");
                    if (spc <= 0) {
                        throw new IOException("Malformatted attribute: [" + TrivialDOM.snip(bits[i]) + "].");
                    }
                    String key = bits[i].substring(0, spc);
                    String val = bits[i].substring(spc + 1);
                    if (!val.startsWith("\"") || !val.endsWith("\"")) {
                        throw new IOException("Malformed attribute value: [" + TrivialDOM.snip(bits[i]) + "].");
                    }
                    val = val.substring(1, val.length() - 1);
                    newNode.SetAttribute(key, val);
                }
                if (isclosed) continue;
                node = newNode;
                continue;
            }
            if (str.startsWith("</")) {
                if (node == null) {
                    throw new IOException("Unexpected end tag: [" + TrivialDOM.snip(str) + "].");
                }
                if ((str = str.substring(2, str.length() - 1)).compareTo(node.NodeName()) != 0) {
                    throw new IOException("Closing tag does not match opening tag: [" + TrivialDOM.snip(str) + "].");
                }
                node = node.Parent();
                continue;
            }
            if (str.startsWith("<![CDATA[")) {
                if (node == null) {
                    throw new IOException("Unexpected CDATA node: [" + TrivialDOM.snip(str) + "].");
                }
                if (!str.endsWith("]]>")) {
                    throw new IOException("CDATA node not ended: [" + TrivialDOM.snip(str) + "].");
                }
                str = str.substring(9, str.length() - 3);
                node.AppendText(str, true);
                continue;
            }
            if (str.startsWith("<!--")) {
                if (str.endsWith("-->")) continue;
                throw new IOException("Unterminated comment: [" + TrivialDOM.snip(str) + "].");
            }
            if (str.startsWith("<?")) continue;
            if (str.startsWith("<")) {
                throw new IOException("Unexpected angle bracket, near: [" + TrivialDOM.snip(str) + "].");
            }
            if (node == null) {
                throw new IOException("Misplaced text-like block: [" + TrivialDOM.snip(str) + "].");
            }
            node.AppendText(str.trim(), false);
        }
        return xml;
    }

    private static String snip(String str) {
        if (str.length() < 60) {
            return str;
        }
        return str.substring(0, 60) + "...";
    }

    public static void WriteXML(Writer out, TrivialDOM dom) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        TrivialDOM.RecursiveWriteNode(out, dom.Document(), 0);
        out.flush();
    }

    private static void RecursiveWriteNode(Writer out, Node nod, int Level2) throws IOException {
        int n;
        for (int n2 = 0; n2 < Level2; ++n2) {
            out.write(" ");
        }
        out.write("<" + nod.NodeName());
        String[] attr = nod.GetAttributeNames();
        for (int n3 = 0; n3 < attr.length; ++n3) {
            out.write(" " + attr[n3] + "=\"" + TrivialDOM.EscapeAttr(nod.Attribute(attr[n3])) + "\"");
        }
        if (nod.NumChildren() == 0) {
            out.write("/>\n");
            return;
        }
        out.write(">");
        boolean doIndent = true;
        if (nod.NumChildren() == 1 && nod.ChildType(0) == 2) {
            doIndent = false;
        } else if (nod.NumChildren() > 0 && nod.ChildType(0) == 2 && nod.GetChildText(0).Preserve()) {
            doIndent = false;
        }
        if (doIndent) {
            out.write("\n");
        }
        for (n = 0; n < nod.NumChildren(); ++n) {
            if (nod.ChildType(n) == 2) {
                Text txt = nod.GetChildText(n);
                if (doIndent) {
                    for (int i = 0; i < Level2 + 1; ++i) {
                        out.write(" ");
                    }
                }
                if (txt.Preserve()) {
                    out.write("<![CDATA[");
                }
                out.write(TrivialDOM.EscapeText(txt.Get()));
                if (txt.Preserve()) {
                    out.write("]]>");
                }
                if (!doIndent) continue;
                out.write("\n");
                continue;
            }
            TrivialDOM.RecursiveWriteNode(out, nod.GetChildNode(n), Level2 + 1);
        }
        if (doIndent) {
            for (n = 0; n < Level2; ++n) {
                out.write(" ");
            }
        }
        out.write("</" + nod.NodeName() + ">\n");
    }

    public static String EscapeAttr(String S) {
        int i;
        while ((i = S.indexOf(34)) >= 0) {
            S = S.substring(0, i) + "&quot;" + S.substring(i + 1);
        }
        while ((i = S.indexOf(39)) >= 0) {
            S = S.substring(0, i) + "&apos;" + S.substring(i + 1);
        }
        return S;
    }

    public static String EscapeText(String S) {
        int i;
        String str = "";
        while ((i = S.indexOf(38)) >= 0) {
            str = str + S.substring(0, i) + "&amp;";
            S = S.substring(i + 1);
        }
        S = str + S;
        while ((i = S.indexOf(60)) >= 0) {
            S = S.substring(0, i) + "&lt;" + S.substring(i + 1);
        }
        while ((i = S.indexOf(62)) >= 0) {
            S = S.substring(0, i) + "&gt;" + S.substring(i + 1);
        }
        return S;
    }

    class Text {
        private Node parentNode = null;
        private String text;
        private boolean preserve;

        public Text(String Text2, boolean Preserve) {
            this.text = Text2;
            this.preserve = Preserve;
        }

        public Node Parent() {
            return this.parentNode;
        }

        public void SetParent(Node Parent) {
            this.parentNode = Parent;
        }

        public String Get() {
            return this.text;
        }

        public void Set(String Txt) {
            this.text = Txt;
        }

        public boolean Preserve() {
            return this.preserve;
        }
    }

    class Node {
        private Node parentNode = null;
        private String nodeName;
        private Hashtable<String, String> nodeAttr;
        private ArrayList<Object> children;

        public Node(String NodeName) {
            this.nodeName = NodeName;
            this.nodeAttr = new Hashtable();
            this.children = new ArrayList();
        }

        public Node Parent() {
            return this.parentNode;
        }

        public void SetParent(Node Parent) {
            this.parentNode = Parent;
        }

        public String NodeName() {
            return this.nodeName;
        }

        public void SetNodeName(String Name) {
            this.nodeName = Name;
        }

        public String Attribute(String Attr) {
            return this.nodeAttr.containsKey(Attr) ? this.nodeAttr.get(Attr) : null;
        }

        public void SetAttribute(String Attr, String Value) {
            this.nodeAttr.put(Attr, Value);
        }

        public String[] GetAttributeNames() {
            Set<String> attr = this.nodeAttr.keySet();
            String[] names = new String[attr.size()];
            return attr.toArray(names);
        }

        public int NumChildren() {
            return this.children.size();
        }

        public int ChildType(int N) {
            Object child = this.children.get(N);
            if (child instanceof Node) {
                return 1;
            }
            if (child instanceof Text) {
                return 2;
            }
            return 0;
        }

        public Node GetChildNode(int N) {
            return (Node)this.children.get(N);
        }

        public Text GetChildText(int N) {
            return (Text)this.children.get(N);
        }

        public void Clear() {
            this.children.clear();
        }

        public void DeleteChild(int N) {
            this.children.remove(N);
        }

        public void SetText(String Txt, boolean Preserve) {
            this.Clear();
            Text txt = new Text(Txt, Preserve);
            txt.SetParent(this);
            this.children.add(txt);
        }

        public String GetText() {
            String txt = "";
            for (int n = 0; n < this.NumChildren(); ++n) {
                txt = this.ChildType(n) == 2 ? txt + this.GetChildText(n).Get() : txt + this.GetChildNode(n).GetText();
            }
            return txt;
        }

        public void AppendChild(Node Nod) {
            Nod.SetParent(this);
            this.children.add(Nod);
        }

        public void AppendChild(Text Txt) {
            Txt.SetParent(this);
            this.children.add(Txt);
        }

        public void InsertChild(int N, Node Nod) {
            Nod.SetParent(this);
            this.children.add(N, Nod);
        }

        public void InsertChild(int N, Text Txt) {
            Txt.SetParent(this);
            this.children.add(N, Txt);
        }

        public Node AppendNode(String Name) {
            Node nod = new Node(Name);
            nod.SetParent(this);
            this.children.add(nod);
            return nod;
        }

        public Text AppendText(String Txt, boolean Preserve) {
            Text txt = new Text(Txt, Preserve);
            txt.SetParent(this);
            this.children.add(txt);
            return txt;
        }
    }
}

