/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.FileExtFilter;
import WIMSchem.MainPanel;
import WIMSchem.Molecule;
import WIMSchem.Utils;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetCache;
import WIMSchem.ds.DataSheetStream;
import WIMSchem.ds.DataTableModel;
import WIMSchem.ds.DialogEditColumns;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;

public class DataWindow
extends JFrame
implements ActionListener,
WindowListener,
KeyListener {
    public static final boolean ALLOW = true;
    String filename = null;
    JSplitPane splitter = null;
    DataSheet ds = null;
    DataSheetCache cache = null;
    DataTableModel model = null;
    JTable sheet = null;
    MainPanel editor = null;
    int molEdRow = -1;
    int molEdCol = -1;
    ImageIcon mainIcon = null;
    ImageIcon mainLogo = null;
    int unitRowHeight;
    int curRowMag;

    public DataWindow(String LoadFN) {
        super("WIMSchem DataSheet");
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setDefaultCloseOperation(0);
        this.mainIcon = new ImageIcon(this.getClass().getResource("/images/MainIcon.png"));
        this.mainLogo = new ImageIcon(this.getClass().getResource("/images/MainLogo.png"));
        this.setIconImage(this.mainIcon.getImage());
        this.filename = LoadFN;
        if (this.filename == null) {
            this.ds = new DataSheet();
            this.cache = new DataSheetCache();
            this.ds.AppendColumn("Molecule", 1, "Molecular structure");
        } else {
            this.LoadDataSheet(this.filename);
        }
        this.setLayout(new BorderLayout());
        JMenuBar menubar = this.CreateMenuBar();
        this.model = new DataTableModel(this.ds, this.cache);
        this.sheet = new JTable(this.model);
        this.sheet.setPreferredScrollableViewportSize(new Dimension(720, 530));
        this.sheet.setDefaultRenderer(Molecule.class, this.model.NewMoleculeRenderer());
        this.sheet.setDefaultEditor(Molecule.class, this.model.NewMoleculeEditor(this));
        this.sheet.setRowSelectionAllowed(true);
        this.sheet.setSelectionMode(2);
        this.sheet.addKeyListener(this);
        this.unitRowHeight = this.sheet.getRowHeight();
        this.UpdateRowHeight(2);
        this.editor = null;
        this.splitter = new JSplitPane(1, new JScrollPane(this.sheet), this.editor);
        this.splitter.setOneTouchExpandable(true);
        this.add((Component)menubar, "North");
        this.add((Component)this.splitter, "Center");
        this.pack();
        this.addWindowListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void LoadDataSheet(String FN) {
        DataSheet newDS = null;
        FileInputStream istr = null;
        try {
            istr = new FileInputStream(FN);
            if (DataSheetStream.ExamineIsXMLDS(istr)) {
                newDS = DataSheetStream.ReadXML(istr);
                this.SetFilename(FN);
            } else if (DataSheetStream.ExamineIsMDLSDF(istr)) {
                newDS = DataSheetStream.ReadSDF(istr);
                this.SetFilename(null);
            } else {
                String msg = "[" + FN + "]\n" + "The file does not appear to be of the XML\n" + "WIMSchem DataSheet format, an MDL SD file.";
                JOptionPane.showMessageDialog(null, msg, "Open Failed", 0);
            }
            this.cache = new DataSheetCache();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Open Failed", 0);
        }
        finally {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (IOException e) {}
        }
        if (newDS == null) {
            this.ds = new DataSheet();
            return;
        }
        this.ds = newDS;
        if (this.model != null) {
            this.model.SetDataSheet(this.ds, this.cache);
            this.model.fireTableStructureChanged();
        }
    }

    private JMenuBar CreateMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menufile = new JMenu("File");
        menufile.setMnemonic(70);
        menufile.add(this.MenuItem("New", 78, null, KeyStroke.getKeyStroke(78, 2)));
        menufile.add(this.MenuItem("Open", 79, null, KeyStroke.getKeyStroke(79, 2)));
        menufile.add(this.MenuItem("Save", 83, null, KeyStroke.getKeyStroke(83, 2)));
        menufile.add(this.MenuItem("Save As", 65));
        JMenu menuexport = new JMenu("Export");
        menuexport.setMnemonic(88);
        menuexport.add(this.MenuItem("as MDL SDF", 83, null, KeyStroke.getKeyStroke(83, 3)));
        menufile.add(menuexport);
        menufile.addSeparator();
        menufile.add(this.MenuItem("Quit", 81, null, KeyStroke.getKeyStroke(81, 2)));
        JMenu menumol = new JMenu("Molecule");
        menumol.setMnemonic(77);
        menumol.add(this.MenuItem("Edit Molecule", 69, null, KeyStroke.getKeyStroke(32, 0)));
        menumol.add(this.MenuItem("Keep Edit", 75, null, KeyStroke.getKeyStroke(10, 2)));
        menumol.add(this.MenuItem("Abandon Edit", 65));
        JMenu menuedit = new JMenu("Edit");
        menuedit.setMnemonic(69);
        menuedit.add(this.MenuItem("Undo", 85, null, KeyStroke.getKeyStroke(90, 2)));
        menuedit.add(this.MenuItem("Redo", 82, null, KeyStroke.getKeyStroke(90, 3)));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem("Add Row", 65, null, KeyStroke.getKeyStroke(155, 0)));
        menuedit.add(this.MenuItem("Delete Rows", 68));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem("Copy Rows", 67, null, KeyStroke.getKeyStroke(67, 3)));
        menuedit.add(this.MenuItem("Cut Rows", 84, null, KeyStroke.getKeyStroke(88, 3)));
        menuedit.add(this.MenuItem("Paste Rows", 80, null, KeyStroke.getKeyStroke(86, 3)));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem("Edit Columns", 67));
        JMenu menuview = new JMenu("View");
        menuview.setMnemonic(86);
        menuview.add(this.MenuItem("Single Line", 76, null, KeyStroke.getKeyStroke(49, 2)));
        menuview.add(this.MenuItem("Small Height", 83, null, KeyStroke.getKeyStroke(50, 2)));
        menuview.add(this.MenuItem("Medium Height", 77, null, KeyStroke.getKeyStroke(51, 2)));
        menuview.add(this.MenuItem("Large Height", 76, null, KeyStroke.getKeyStroke(52, 2)));
        JMenu menuhelp = new JMenu("Help");
        menuhelp.setMnemonic(72);
        menuhelp.add(this.MenuItem("About", 65));
        menubar.add(menufile);
        menubar.add(menumol);
        menubar.add(menuedit);
        menubar.add(menuview);
        menubar.add(Box.createHorizontalGlue());
        menubar.add(menuhelp);
        return menubar;
    }

    private JMenuItem MenuItem(String txt, int key) {
        return this.MenuItem(txt, key, null, null);
    }

    private JMenuItem MenuItem(String txt, int key, Icon icon) {
        return this.MenuItem(txt, key, icon, null);
    }

    private JMenuItem MenuItem(String txt, int key, Icon icon, KeyStroke accel) {
        JMenuItem mi = new JMenuItem(txt, key);
        mi.addActionListener(this);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (accel != null) {
            mi.setAccelerator(accel);
        }
        return mi;
    }

    private JRadioButtonMenuItem RadioMenuItem(String txt, int key, boolean sel, ButtonGroup bg) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(txt, sel);
        mi.addActionListener(this);
        mi.setMnemonic(key);
        bg.add(mi);
        return mi;
    }

    private void UpdateRowHeight(int Mag) {
        this.curRowMag = Mag;
        this.sheet.setRowHeight(this.unitRowHeight * (this.curRowMag == 2 ? 3 : (this.curRowMag == 3 ? 6 : (this.curRowMag == 4 ? 12 : 1))));
    }

    private void SetFilename(String FN) {
        this.filename = FN;
        String title = "WIMSchem DataSheet";
        if (this.filename != null) {
            title = title + " - " + new File(this.filename).getName();
        }
        this.setTitle(title);
    }

    private void SaveCurrent() {
        if (this.filename == null) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(this.filename);
            DataSheetStream.WriteXML(ostr, this.ds);
            ostr.close();
            this.ds.ClearDirty();
        }
        catch (IOException e) {
            Utils.errmsg("Save Failed", e.toString());
        }
    }

    boolean SameColumns(DataSheet DS1, DataSheet DS2) {
        if (DS1.NumCols() != DS2.NumCols()) {
            return false;
        }
        for (int n = 0; n < DS1.NumCols(); ++n) {
            if (DS1.ColName(n).compareTo(DS2.ColName(n)) != 0) {
                return false;
            }
            if (DS1.ColType(n) != DS2.ColType(n)) {
                return false;
            }
            if (DS1.ColDescr(n).compareTo(DS2.ColDescr(n)) == 0) continue;
            return false;
        }
        return true;
    }

    private void FileQuit() {
        Object[] opt;
        if (this.ds.IsDirty() && JOptionPane.showOptionDialog(null, "Current datasheet has been modified. Exit without saving?", "Quit", 0, 0, null, opt = new String[]{"Yes", "No"}, opt[0]) != 0) {
            return;
        }
        this.dispose();
    }

    private void FileNew() {
        new DataWindow(null).setVisible(true);
    }

    private void FileOpen() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("DataSheet Formats", ".xml;.sdf"));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String newfn = chooser.getSelectedFile().getPath();
        if (this.ds.NumRows() == 0 && !this.ds.IsDirty()) {
            this.LoadDataSheet(newfn);
        } else {
            new DataWindow(newfn).setVisible(true);
        }
    }

    private void FileSave() {
        if (this.filename == null) {
            this.FileSaveAs();
            return;
        }
        this.SaveCurrent();
    }

    private void FileSaveAs() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("WIMSchem DataSheets", ".xml"));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".xml";
        }
        if ((newf = new File(fn)).exists()) {
            Object[] opt = new String[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Save As", 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        this.SetFilename(fn);
        this.SaveCurrent();
    }

    private void FileExportSDF() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("MDL SD files", ".sdf"));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".sdf";
        }
        if ((newf = new File(fn)).exists()) {
            Object[] opt = new String[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Save As", 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            DataSheetStream.WriteSDF(ostr, this.ds);
            ostr.close();
        }
        catch (IOException e) {
            Utils.errmsg("Export Failed", e.toString());
        }
    }

    private void MoleculeEditMol() {
        if (this.editor != null) {
            return;
        }
        int row = this.sheet.getSelectedRow();
        int col = this.sheet.getSelectedColumn();
        if (row < 0 || col < 0 || col >= this.ds.NumCols()) {
            return;
        }
        if (this.ds.ColType(col) != 1) {
            return;
        }
        this.model.SetTemporaryEdit(col);
        this.sheet.editCellAt(row, col);
        this.model.ClearTemporaryEdit();
    }

    private void MoleculeKeepEdit() {
        if (this.editor == null) {
            return;
        }
        Molecule mol = this.editor.MolData();
        if (mol.NumAtoms() == 0) {
            mol = null;
        }
        this.cache.CacheUndo(this.ds);
        this.ds.SetMolecule(this.molEdRow, this.molEdCol, mol);
        this.ds.SetDirty();
        this.model.fireTableCellUpdated(this.molEdRow, this.molEdCol);
        this.editor = null;
        this.splitter.setRightComponent(this.editor);
        this.sheet.requestFocusInWindow();
    }

    private void MoleculeAbandonEdit() {
        if (this.editor == null) {
            return;
        }
        if (this.sheet.getCellEditor() != null) {
            this.sheet.getCellEditor().stopCellEditing();
        }
        this.editor = null;
        this.splitter.setRightComponent(this.editor);
        this.sheet.requestFocusInWindow();
    }

    private void EditUndo() {
        if (!this.cache.CanUndo()) {
            return;
        }
        DataSheet newds = this.cache.PerformUndo(this.ds);
        boolean colmod = !this.SameColumns(this.ds, newds);
        this.ds = newds;
        this.ds.SetDirty();
        this.model.SetDataSheet(this.ds, this.cache);
        if (colmod) {
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    private void EditRedo() {
        if (!this.cache.CanRedo()) {
            return;
        }
        DataSheet newds = this.cache.PerformRedo(this.ds);
        boolean colmod = !this.SameColumns(this.ds, newds);
        this.ds = newds;
        this.ds.SetDirty();
        this.model.SetDataSheet(this.ds, this.cache);
        if (colmod) {
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    private void EditColumns() {
        DialogEditColumns edcols = new DialogEditColumns((Frame)this, this.ds);
        if (!edcols.Execute()) {
            return;
        }
        this.ModifyColumns(edcols.ResultOldPos(), edcols.ResultNewPos(), edcols.ResultName(), edcols.ResultType(), edcols.ResultDescr());
        this.ds.SetDirty();
        this.model.fireTableStructureChanged();
    }

    private void AddRow() {
        this.cache.CacheUndo(this.ds);
        this.ds.AppendRow();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.sheet.setRowSelectionInterval(this.ds.NumRows() - 1, this.ds.NumRows() - 1);
    }

    private void DeleteRows() {
        if (this.sheet.getSelectedRowCount() == 0) {
            return;
        }
        this.cache.CacheUndo(this.ds);
        int[] todel = this.sheet.getSelectedRows();
        for (int i = 0; i < todel.length; ++i) {
            this.ds.DeleteRow(i);
            for (int j = i + 1; j < todel.length; ++j) {
                if (todel[j] <= todel[i]) continue;
                int n = j;
                todel[n] = todel[n] - 1;
            }
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void CopyRows() {
        if (this.sheet.getSelectedRowCount() == 0) {
            return;
        }
        int[] rn = this.sheet.getSelectedRows();
        DataSheet copy = new DataSheet();
        for (int n = 0; n < this.ds.NumCols(); ++n) {
            copy.AppendColumn(this.ds.ColName(n), this.ds.ColType(n), this.ds.ColDescr(n));
        }
        for (int i = 0; i < rn.length; ++i) {
            copy.AppendRow();
            for (int j = 0; j < this.ds.NumCols(); ++j) {
                copy.SetObject(i, j, this.ds.GetObject(rn[i], j));
            }
        }
        StringWriter sw = new StringWriter();
        try {
            DataSheetStream.WriteXML(new BufferedWriter(sw), copy);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(sw.toString()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Copy Failed", 0);
        }
    }

    private void CutRows() {
        this.CopyRows();
        this.DeleteRows();
    }

    private void PasteRows() {
        int i;
        String cliptext = "";
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clip.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                cliptext = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Clipboard Read Failed", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Paste Failed", 0);
        }
        DataSheet paste = null;
        try {
            if (DataSheetStream.ExamineIsXMLDS(new BufferedReader(new StringReader(cliptext)))) {
                paste = DataSheetStream.ReadXML(new BufferedReader(new StringReader(cliptext)));
            } else if (DataSheetStream.ExamineIsMDLSDF(new BufferedReader(new StringReader(cliptext)))) {
                paste = DataSheetStream.ReadSDF(new BufferedReader(new StringReader(cliptext)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (paste == null) {
            JOptionPane.showMessageDialog(null, "Unknown format: must be DataSheet XML or MDL SDF", "Paste Failed", 0);
            return;
        }
        this.cache.CacheUndo(this.ds);
        int[] newcolpos = new int[paste.NumCols()];
        for (i = 0; i < paste.NumCols(); ++i) {
            newcolpos[i] = -1;
            for (int j = 0; j < this.ds.NumCols(); ++j) {
                if (this.ds.ColName(j).compareTo(paste.ColName(i)) != 0) continue;
                newcolpos[i] = j;
                break;
            }
            if (newcolpos[i] >= 0) continue;
            newcolpos[i] = this.ds.AppendColumn(paste.ColName(i), paste.ColType(i), paste.ColDescr(i));
        }
        for (i = 0; i < paste.NumRows(); ++i) {
            int rn = this.ds.AppendRow();
            for (int j = 0; j < paste.NumCols(); ++j) {
                int cn = newcolpos[j];
                int ptype = paste.ColType(j);
                int dtype = this.ds.ColType(j);
                String strval = "";
                if (ptype == 1 && dtype == 1) {
                    this.ds.SetMolecule(rn, cn, paste.GetMolecule(i, j));
                    continue;
                }
                if (ptype == 1 || dtype == 1) continue;
                String val = "";
                if (ptype == 2) {
                    val = paste.GetString(i, j);
                } else if (ptype == 3) {
                    val = String.valueOf(paste.GetInteger(i, j));
                } else if (ptype == 4) {
                    val = String.valueOf(paste.GetReal(i, j));
                } else if (ptype == 5) {
                    val = paste.GetBoolean(i, j) ? "true" : "false";
                }
                try {
                    if (dtype == 2) {
                        this.ds.SetString(rn, cn, val);
                        continue;
                    }
                    if (dtype == 3) {
                        this.ds.SetInteger(rn, cn, new Integer(val));
                        continue;
                    }
                    if (dtype == 4) {
                        this.ds.SetReal(rn, cn, new Double(val));
                        continue;
                    }
                    if (dtype != 5) continue;
                    this.ds.SetBoolean(rn, cn, val.toLowerCase().compareTo("true") == 0);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void HelpAbout() {
        String msg = "WIMSchem v" + MainPanel.VERSION + "\n" + "Molecule drawing tool\n" + "\u00a9 2005-2008 Dr. Alex M. Clark\n" + "Released under the Gnu Public\n" + "License (GPL), see www.gnu.org\n" + "Home page and documentation:\n" + "http://sketchel.sf.net\n";
        JOptionPane.showMessageDialog(null, msg, "About WIMSchem", 1, this.mainLogo);
    }

    private void EditMolecule(int RN, int CN) {
        if (this.editor != null) {
            // empty if block
        }
        this.editor = new MainPanel(null, false, true, null, null, null, null, null, null, true, true);
        this.molEdRow = RN;
        this.molEdCol = CN;
        Molecule mol = this.ds.GetMolecule(RN, CN);
        if (mol != null) {
            this.editor.SetMolecule(mol.Clone());
        }
        this.splitter.setRightComponent(this.editor);
        int pos = this.splitter.getWidth() - 560;
        this.splitter.setDividerLocation(pos < 0 ? 50 : pos);
        this.editor.requestFocusInWindow();
    }

    private void ModifyColumns(int[] OldPos, int[] NewPos, String[] Name, int[] Type2, String[] Descr) {
        int n;
        int sz = OldPos.length;
        for (n = 0; n < sz; ++n) {
            int i;
            if (NewPos[n] >= 0) continue;
            this.ds.DeleteColumn(OldPos[n]);
            for (i = 0; i < sz; ++i) {
                if (OldPos[i] <= OldPos[n]) continue;
                int n2 = i;
                OldPos[n2] = OldPos[n2] - 1;
            }
            for (i = n; i < sz - 1; ++i) {
                OldPos[i] = OldPos[i + 1];
                NewPos[i] = NewPos[i + 1];
                Name[i] = Name[i + 1];
                Type2[i] = Type2[i + 1];
                Descr[i] = Descr[i + 1];
            }
            --n;
            --sz;
        }
        for (n = 0; n < sz; ++n) {
            if (OldPos[n] >= 0) continue;
            OldPos[n] = this.ds.AppendColumn(Name[n], Type2[n], Descr[n]);
        }
        for (n = 0; n < sz; ++n) {
            this.ds.ChangeColumnName(OldPos[n], Name[n], Descr[n]);
            this.ds.ChangeColumnType(OldPos[n], Type2[n], true);
        }
        int[] reord = new int[sz];
        for (int n3 = 0; n3 < sz; ++n3) {
            reord[NewPos[n3]] = OldPos[n3];
        }
        this.cache.CacheUndo(this.ds);
        this.ds.ReorderColumns(reord);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (e.getSource() == this.sheet) {
            String[] rc = cmd.split(",");
            this.EditMolecule(Integer.parseInt(rc[0]), Integer.parseInt(rc[1]));
        } else if (cmd == "Quit") {
            this.FileQuit();
        } else if (cmd == "New") {
            this.FileNew();
        } else if (cmd == "Open") {
            this.FileOpen();
        } else if (cmd == "Save") {
            this.FileSave();
        } else if (cmd == "Save As") {
            this.FileSaveAs();
        } else if (cmd == "as MDL SDF") {
            this.FileExportSDF();
        } else if (cmd == "Edit Molecule") {
            this.MoleculeEditMol();
        } else if (cmd == "Keep Edit") {
            this.MoleculeKeepEdit();
        } else if (cmd == "Abandon Edit") {
            this.MoleculeAbandonEdit();
        } else if (cmd == "Undo") {
            this.EditUndo();
        } else if (cmd == "Redo") {
            this.EditRedo();
        } else if (cmd == "Add Row") {
            this.AddRow();
        } else if (cmd == "Delete Rows") {
            this.DeleteRows();
        } else if (cmd == "Copy Rows") {
            this.CopyRows();
        } else if (cmd == "Cut Rows") {
            this.CutRows();
        } else if (cmd == "Paste Rows") {
            this.PasteRows();
        } else if (cmd == "Edit Columns") {
            this.EditColumns();
        } else if (cmd == "Single Line") {
            this.UpdateRowHeight(1);
        } else if (cmd == "Small Height") {
            this.UpdateRowHeight(2);
        } else if (cmd == "Medium Height") {
            this.UpdateRowHeight(3);
        } else if (cmd == "Large Height") {
            this.UpdateRowHeight(4);
        } else if (cmd == "About") {
            this.HelpAbout();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.FileQuit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.sheet) {
            if (this.sheet.isEditing()) {
                return;
            }
            boolean shouldEdit = false;
            if (e.getKeyChar() >= ' ' && e.getKeyChar() <= '~') {
                shouldEdit = true;
            }
            if (e.getKeyChar() == '\b') {
                shouldEdit = true;
            }
            if (e.getModifiers() != 0) {
                shouldEdit = false;
            }
            int row = this.sheet.getSelectedRow();
            int col = this.sheet.getSelectedColumn();
            if (row < 0 || col < 0) {
                shouldEdit = false;
            } else if (this.ds.ColType(col) == 1) {
                shouldEdit = false;
            }
            if (shouldEdit) {
                this.model.SetTemporaryEdit(col);
                this.sheet.editCellAt(row, col);
                this.model.ClearTemporaryEdit();
            }
        }
    }
}

