/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import rene.gui.CloseFrame;
import rene.gui.Global;
import rene.gui.Panel3D;
import rene.util.MyVector;
import rene.viewer.TextDisplay;
import rene.viewer.TextPosition;
import rene.viewer.Viewer;
import rene.viewer.Wheel;
import rene.viewer.WheelListener;

public class ExtendedViewer
extends Viewer
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
WheelListener {
    TextDisplay TD = new TextDisplay(this);
    Scrollbar Vertical;
    TextPosition Start;
    TextPosition End;
    PopupMenu PM;
    int X;
    int Y;
    Panel P3D;
    MyVector V;
    StringBuffer B;
    boolean Changed = false;
    boolean Dragging = false;

    public ExtendedViewer() {
        this.setLayout(new BorderLayout());
        this.P3D = new Panel3D(this.TD);
        this.add("Center", this.P3D);
        this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
        this.add("East", this.Vertical);
        this.Vertical.addAdjustmentListener(this);
        this.TD.addMouseListener(this);
        this.TD.addMouseMotionListener(this);
        this.End = null;
        this.Start = null;
        this.PM = new PopupMenu();
        MenuItem menuItem = new MenuItem(Global.name("block.copy", "Copy"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        this.PM.addSeparator();
        menuItem = new MenuItem(Global.name("block.begin", "Begin Block"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        menuItem = new MenuItem(Global.name("block.end", "End Block"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        this.add(this.PM);
        Wheel wheel = new Wheel(this);
        this.addMouseWheelListener(wheel);
        this.V = new MyVector();
        this.B = new StringBuffer();
    }

    public void setFont(Font font) {
        this.TD.init(font);
    }

    public void appendLine(String string) {
        this.B.append(string);
        this.V.addElement(this.B.toString());
        this.B.setLength(0);
        this.Changed = true;
    }

    public void newLine() {
        this.V.addElement(this.B.toString());
        this.B.setLength(0);
        this.Changed = true;
    }

    public void appendLine(String string, Color color) {
        this.appendLine(string);
    }

    public void append(String string) {
        this.B.append(string);
    }

    public void append(String string, Color color) {
        this.append(string);
    }

    public void doUpdate(boolean bl) {
    }

    public void update() {
        this.resized();
        this.showFirst();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.Vertical) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.TD.verticalUp();
                    break;
                }
                case 2: {
                    this.TD.verticalDown();
                    break;
                }
                case 4: {
                    this.TD.verticalPageUp();
                    break;
                }
                case 3: {
                    this.TD.verticalPageDown();
                    break;
                }
                default: {
                    int n = this.Vertical.getValue();
                    this.Vertical.setValue(n);
                    this.TD.setVertical(n);
                    return;
                }
            }
            this.setVerticalScrollbar();
        }
    }

    public void setVerticalScrollbar() {
        if (this.Vertical == null) {
            return;
        }
        int n = this.TD.computeVerticalSize();
        this.Vertical.setValues(this.TD.computeVertical(), n, 0, 1000 + n);
    }

    public void setText(String string) {
        this.TD.unmark();
        this.End = null;
        this.Start = null;
        this.TD.setText(string);
        this.V.removeAllElements();
        this.B.setLength(0);
        this.setVerticalScrollbar();
    }

    public void save(PrintWriter printWriter) {
        this.TD.save(printWriter);
    }

    public void appendLine0(String string) {
        this.appendLine(string);
    }

    public void appendLine0(String string, Color color) {
        this.appendLine(string);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            this.PM.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            this.X = mouseEvent.getX();
            this.Y = mouseEvent.getY();
        } else {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(mouseEvent.getX(), mouseEvent.getY());
            this.Start.oneleft();
            this.End = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 200);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.Dragging = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.TD.unmark(this.Start, this.End);
        TextPosition textPosition = this.TD.getposition(mouseEvent.getX(), mouseEvent.getY());
        if (textPosition != null) {
            this.End = textPosition;
        }
        this.TD.mark(this.Start, this.End);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(Global.name("block.copy", "Copy"))) {
            this.TD.copy(this.Start, this.End);
        } else if (string.equals(Global.name("block.begin", "Begin Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(this.X, this.Y);
            this.Start.oneleft();
            if (this.End == null && this.TD.L.last() != null) {
                this.End = this.TD.lastpos();
            }
            this.TD.mark(this.Start, this.End);
        } else if (string.equals(Global.name("block.end", "End Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.End = this.TD.getposition(this.X, this.Y);
            if (this.Start == null && this.TD.L.first() != null) {
                this.Start = new TextPosition(this.TD.L.first(), 0, 0);
            }
            this.TD.mark(this.Start, this.End);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67 && this.Start != null && this.End != null) {
            this.TD.copy(this.Start, this.End);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setTabWidth(int n) {
        this.TD.setTabWidth(n);
    }

    public void showFirst() {
        this.TD.showFirst();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public void showLast() {
        this.TD.showlast();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public boolean hasFocus() {
        return false;
    }

    public void setBackground(Color color) {
        this.TD.setBackground(color);
        this.P3D.setBackground(color);
        super.setBackground(color);
    }

    public void up(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalUp();
        }
        this.setVerticalScrollbar();
    }

    public void down(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalDown();
        }
        this.setVerticalScrollbar();
    }

    public void pageUp() {
        this.TD.verticalPageUp();
        this.setVerticalScrollbar();
    }

    public void pageDown() {
        this.TD.verticalPageDown();
        this.setVerticalScrollbar();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void doAppend(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int[] nArray = this.TD.getwidth(cArray);
        int n2 = 0;
        int n3 = this.TD.getSize().width;
        for (n = 0; n < cArray.length && cArray[n] == ' '; ++n) {
        }
        if (n >= cArray.length) {
            this.TD.appendLine("");
            return;
        }
        int n4 = 0;
        String string2 = "";
        int n5 = 0;
        if (n > 0) {
            n4 = n;
            string2 = new String(cArray, 0, n4);
            n5 = n4 + nArray[0];
        }
        while (n < cArray.length) {
            int n6 = this.TD.Offset + n5;
            int n7 = n;
            for (n2 = n; n2 < cArray.length && n6 < n3; ++n2) {
                n6 += nArray[n2];
                if (cArray[n2] != ' ') continue;
                n7 = n2;
            }
            if (n6 < n3) {
                n7 = n2;
            }
            if (n7 == n) {
                n7 = n2;
            }
            if (n4 > 0) {
                this.TD.appendLine(string2 + new String(cArray, n, n7 - n));
            } else {
                this.TD.appendLine(new String(cArray, n, n7 - n));
            }
            for (n = n7; n < cArray.length && cArray[n] == ' '; ++n) {
            }
        }
    }

    public synchronized void resized() {
        if (this.TD.getSize().width <= 0) {
            return;
        }
        this.TD.setText("");
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doAppend(string);
        }
        this.TD.repaint();
    }

    public static void main(String[] stringArray) {
        CloseFrame closeFrame = new CloseFrame();
        closeFrame.setLayout(new BorderLayout());
        ExtendedViewer extendedViewer = new ExtendedViewer();
        closeFrame.add("Center", extendedViewer);
        closeFrame.setSize(300, 300);
        closeFrame.setVisible(true);
        extendedViewer.append("test1 test test test test test test ");
        extendedViewer.append("Donaudampfschifffahrtsgesellschaftskapit\u00e4n ");
        extendedViewer.append("test2 test test test test test test ");
        extendedViewer.append("test3 test test test test test test ");
        extendedViewer.append("test4 test test test test test test ");
        extendedViewer.append("test5 test test test test test test ");
        extendedViewer.append("test6 test test test test test test ");
        extendedViewer.append("test7 test test test test test test ");
        extendedViewer.append("test8 test test test test test test ");
        extendedViewer.appendLine("");
        extendedViewer.appendLine("");
        extendedViewer.appendLine("  affe affe affe affe affe affe affe test test test test test last");
        extendedViewer.appendLine("");
        extendedViewer.appendLine("test affe affe affe test test test test test last ");
        extendedViewer.appendLine("  ");
        extendedViewer.appendLine("test test test test affe affe affe test test last");
        extendedViewer.repaint();
        extendedViewer.resized();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }
}

