/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Formula;
import SharpTools.Function;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.util.LinkedList;

class FunctionMin
extends Function {
    FunctionMin() {
    }

    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        float min = Float.MAX_VALUE;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            float value = table.getNumericValueAt(i, j).floatValue();
                            if (!(value < min)) continue;
                            min = value;
                        }
                    }
                    continue;
                }
                float value = Formula.evaluate(table, exp.getExp(), row, col).floatValue();
                if (!(value < min)) continue;
                min = value;
            }
        }
        return new Float(min);
    }

    public String getUsage() {
        return "MIN(value1,value2,...)";
    }

    public String getDescription() {
        return SharpTools.translation.getProperty("min_desc");
    }
}

